; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -mtriple=riscv32 -mattr=+f,+d -target-abi=ilp32 -verify-machineinstrs < %s \
; RUN:     | FileCheck %s

define fastcc float @callee(<32 x float> %A) nounwind {
; CHECK-LABEL: callee:
; CHECK:       # %bb.0:
; CHECK-NEXT:    fmv.x.w a0, fa0
; CHECK-NEXT:    ret
	%B = extractelement <32 x float> %A, i32 0
	ret float %B
}

; With the fastcc, arguments will be passed by fa0-fa7 and ft0-ft11.
; The rest will be pushed on the stack.
define float @caller(<32 x float> %A) nounwind {
; CHECK-LABEL: caller:
; CHECK:       # %bb.0:
; CHECK-NEXT:    addi sp, sp, -64
; CHECK-NEXT:    sw ra, 60(sp) # 4-byte Folded Spill
; CHECK-NEXT:    fmv.w.x fa0, a0
; CHECK-NEXT:    fmv.w.x fa1, a1
; CHECK-NEXT:    fmv.w.x fa2, a2
; CHECK-NEXT:    fmv.w.x fa3, a3
; CHECK-NEXT:    fmv.w.x fa4, a4
; CHECK-NEXT:    flw ft0, 64(sp)
; CHECK-NEXT:    flw ft1, 68(sp)
; CHECK-NEXT:    flw ft2, 72(sp)
; CHECK-NEXT:    flw ft3, 76(sp)
; CHECK-NEXT:    flw ft4, 80(sp)
; CHECK-NEXT:    flw ft5, 84(sp)
; CHECK-NEXT:    flw ft6, 88(sp)
; CHECK-NEXT:    flw ft7, 92(sp)
; CHECK-NEXT:    flw ft8, 96(sp)
; CHECK-NEXT:    flw ft9, 100(sp)
; CHECK-NEXT:    flw ft10, 104(sp)
; CHECK-NEXT:    flw ft11, 108(sp)
; CHECK-NEXT:    flw fs0, 112(sp)
; CHECK-NEXT:    flw fs1, 116(sp)
; CHECK-NEXT:    flw fs2, 120(sp)
; CHECK-NEXT:    flw fs3, 124(sp)
; CHECK-NEXT:    flw fs4, 128(sp)
; CHECK-NEXT:    flw fs5, 132(sp)
; CHECK-NEXT:    flw fs6, 136(sp)
; CHECK-NEXT:    flw fs7, 140(sp)
; CHECK-NEXT:    flw fs8, 144(sp)
; CHECK-NEXT:    flw fs9, 148(sp)
; CHECK-NEXT:    flw fs10, 152(sp)
; CHECK-NEXT:    flw fs11, 156(sp)
; CHECK-NEXT:    fmv.w.x fa5, a5
; CHECK-NEXT:    fmv.w.x fa6, a6
; CHECK-NEXT:    fmv.w.x fa7, a7
; CHECK-NEXT:    fsw fs8, 32(sp)
; CHECK-NEXT:    fsw fs9, 36(sp)
; CHECK-NEXT:    fsw fs10, 40(sp)
; CHECK-NEXT:    fsw fs11, 44(sp)
; CHECK-NEXT:    fsw fs4, 16(sp)
; CHECK-NEXT:    fsw fs5, 20(sp)
; CHECK-NEXT:    fsw fs6, 24(sp)
; CHECK-NEXT:    fsw fs7, 28(sp)
; CHECK-NEXT:    fsw fs0, 0(sp)
; CHECK-NEXT:    fsw fs1, 4(sp)
; CHECK-NEXT:    fsw fs2, 8(sp)
; CHECK-NEXT:    fsw fs3, 12(sp)
; CHECK-NEXT:    call callee
; CHECK-NEXT:    lw ra, 60(sp) # 4-byte Folded Reload
; CHECK-NEXT:    addi sp, sp, 64
; CHECK-NEXT:    ret
	%C = call fastcc float @callee(<32 x float> %A)
	ret float %C
}
