; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py UTC_ARGS: --version 5
; RUN: llc -mtriple=sparc64 -mattr=+vis3 < %s | FileCheck %s

define float @fnadds(float %a, float %b) nounwind {
; CHECK-LABEL: fnadds:
; CHECK:       ! %bb.0: ! %entry
; CHECK-NEXT:    retl
; CHECK-NEXT:    fnadds %f1, %f3, %f0
entry:
  %add = fadd float %a, %b
  %fneg = fneg float %add
  ret float %fneg
}

define double @fnaddd(double %a, double %b) nounwind {
; CHECK-LABEL: fnaddd:
; CHECK:       ! %bb.0: ! %entry
; CHECK-NEXT:    retl
; CHECK-NEXT:    fnaddd %f0, %f2, %f0
entry:
  %add = fadd double %a, %b
  %fneg = fneg double %add
  ret double %fneg
}

define float @fnmuls(float %a, float %b) nounwind {
; CHECK-LABEL: fnmuls:
; CHECK:       ! %bb.0: ! %entry
; CHECK-NEXT:    retl
; CHECK-NEXT:    fnmuls %f1, %f3, %f0
entry:
  %mul = fmul float %a, %b
  %fneg = fneg float %mul
  ret float %fneg
}

define double @fnmuld(double %a, double %b) nounwind {
; CHECK-LABEL: fnmuld:
; CHECK:       ! %bb.0: ! %entry
; CHECK-NEXT:    retl
; CHECK-NEXT:    fnmuld %f0, %f2, %f0
entry:
  %mul = fmul double %a, %b
  %fneg = fneg double %mul
  ret double %fneg
}

define double @fnsmuld(float %a, float %b) nounwind {
; CHECK-LABEL: fnsmuld:
; CHECK:       ! %bb.0: ! %entry
; CHECK-NEXT:    retl
; CHECK-NEXT:    fnsmuld %f1, %f3, %f0
entry:
  %da = fpext float %a to double
  %db = fpext float %b to double
  %mul = fmul double %da, %db
  %fneg = fneg double %mul
  ret double %fneg
}


define float @fhadds(float %a, float %b) nounwind {
; CHECK-LABEL: fhadds:
; CHECK:       ! %bb.0: ! %entry
; CHECK-NEXT:    retl
; CHECK-NEXT:    fhadds %f1, %f3, %f0
entry:
  %add = fadd float %a, %b
  %div = fmul float %add, 5.000000e-01
  ret float %div
}

define double @fhaddd(double %a, double %b) nounwind {
; CHECK-LABEL: fhaddd:
; CHECK:       ! %bb.0: ! %entry
; CHECK-NEXT:    retl
; CHECK-NEXT:    fhaddd %f0, %f2, %f0
entry:
  %add = fadd double %a, %b
  %div = fmul double %add, 5.000000e-01
  ret double %div
}

define float @fhsubs(float %a, float %b) nounwind {
; CHECK-LABEL: fhsubs:
; CHECK:       ! %bb.0: ! %entry
; CHECK-NEXT:    retl
; CHECK-NEXT:    fhsubs %f1, %f3, %f0
entry:
  %sub = fsub float %a, %b
  %div = fmul float %sub, 5.000000e-01
  ret float %div
}

define double @fhsubd(double %a, double %b) nounwind {
; CHECK-LABEL: fhsubd:
; CHECK:       ! %bb.0: ! %entry
; CHECK-NEXT:    retl
; CHECK-NEXT:    fhsubd %f0, %f2, %f0
entry:
  %sub = fsub double %a, %b
  %div = fmul double %sub, 5.000000e-01
  ret double %div
}

define float @fnhadds(float %a, float %b) nounwind {
; CHECK-LABEL: fnhadds:
; CHECK:       ! %bb.0: ! %entry
; CHECK-NEXT:    retl
; CHECK-NEXT:    fnhadds %f1, %f3, %f0
entry:
  %add.i = fadd float %a, %b
  %fneg = fmul float %add.i, -5.000000e-01
  ret float %fneg
}

define double @fnhaddd(double %a, double %b) nounwind {
; CHECK-LABEL: fnhaddd:
; CHECK:       ! %bb.0: ! %entry
; CHECK-NEXT:    retl
; CHECK-NEXT:    fnhaddd %f0, %f2, %f0
entry:
  %add.i = fadd double %a, %b
  %fneg = fmul double %add.i, -5.000000e-01
  ret double %fneg
}

define <4 x float> @vec_fnadds(<4 x float> %a, <4 x float> %b) nounwind {
; CHECK-LABEL: vec_fnadds:
; CHECK:       ! %bb.0: ! %entry
; CHECK-NEXT:    fnadds %f1, %f9, %f0
; CHECK-NEXT:    fnadds %f3, %f11, %f1
; CHECK-NEXT:    fnadds %f5, %f13, %f2
; CHECK-NEXT:    retl
; CHECK-NEXT:    fnadds %f7, %f15, %f3
entry:
  %add = fadd <4 x float> %a, %b
  %fneg = fneg <4 x float> %add
  ret <4 x float> %fneg
}

define <4 x double> @vec_fnaddd(<4 x double> %a, <4 x double> %b) nounwind {
; CHECK-LABEL: vec_fnaddd:
; CHECK:       ! %bb.0: ! %entry
; CHECK-NEXT:    fnaddd %f0, %f8, %f0
; CHECK-NEXT:    fnaddd %f2, %f10, %f2
; CHECK-NEXT:    fnaddd %f4, %f12, %f4
; CHECK-NEXT:    retl
; CHECK-NEXT:    fnaddd %f6, %f14, %f6
entry:
  %add = fadd <4 x double> %a, %b
  %fneg = fneg <4 x double> %add
  ret <4 x double> %fneg
}

define <4 x float> @vec_fnmuls(<4 x float> %a, <4 x float> %b) nounwind {
; CHECK-LABEL: vec_fnmuls:
; CHECK:       ! %bb.0: ! %entry
; CHECK-NEXT:    fnmuls %f1, %f9, %f0
; CHECK-NEXT:    fnmuls %f3, %f11, %f1
; CHECK-NEXT:    fnmuls %f5, %f13, %f2
; CHECK-NEXT:    retl
; CHECK-NEXT:    fnmuls %f7, %f15, %f3
entry:
  %mul = fmul <4 x float> %a, %b
  %fneg = fneg <4 x float> %mul
  ret <4 x float> %fneg
}

define <4 x double> @vec_fnmuld(<4 x double> %a, <4 x double> %b) nounwind {
; CHECK-LABEL: vec_fnmuld:
; CHECK:       ! %bb.0: ! %entry
; CHECK-NEXT:    fnmuld %f0, %f8, %f0
; CHECK-NEXT:    fnmuld %f2, %f10, %f2
; CHECK-NEXT:    fnmuld %f4, %f12, %f4
; CHECK-NEXT:    retl
; CHECK-NEXT:    fnmuld %f6, %f14, %f6
entry:
  %mul = fmul <4 x double> %a, %b
  %fneg = fneg <4 x double> %mul
  ret <4 x double> %fneg
}

define <4 x double> @vec_fnsmuld(<4 x float> %a, <4 x float> %b) nounwind {
; CHECK-LABEL: vec_fnsmuld:
; CHECK:       ! %bb.0: ! %entry
; CHECK-NEXT:    fnsmuld %f1, %f9, %f0
; CHECK-NEXT:    fnsmuld %f3, %f11, %f2
; CHECK-NEXT:    fnsmuld %f5, %f13, %f4
; CHECK-NEXT:    retl
; CHECK-NEXT:    fnsmuld %f7, %f15, %f6
entry:
  %da = fpext <4 x float> %a to <4 x double>
  %db = fpext <4 x float> %b to <4 x double>
  %mul = fmul <4 x double> %da, %db
  %fneg = fneg <4 x double> %mul
  ret <4 x double> %fneg
}

define <4 x float> @vec_fhadds(<4 x float> %a, <4 x float> %b) nounwind {
; CHECK-LABEL: vec_fhadds:
; CHECK:       ! %bb.0: ! %entry
; CHECK-NEXT:    fhadds %f1, %f9, %f0
; CHECK-NEXT:    fhadds %f3, %f11, %f1
; CHECK-NEXT:    fhadds %f5, %f13, %f2
; CHECK-NEXT:    retl
; CHECK-NEXT:    fhadds %f7, %f15, %f3
entry:
  %add = fadd <4 x float> %a, %b
  %div = fmul <4 x float> %add, <float 5.000000e-01, float 5.000000e-01, float 5.000000e-01, float 5.000000e-01>
  ret <4 x float> %div
}

define <4 x double> @vec_fhaddd(<4 x double> %a, <4 x double> %b) nounwind {
; CHECK-LABEL: vec_fhaddd:
; CHECK:       ! %bb.0: ! %entry
; CHECK-NEXT:    fhaddd %f0, %f8, %f0
; CHECK-NEXT:    fhaddd %f2, %f10, %f2
; CHECK-NEXT:    fhaddd %f4, %f12, %f4
; CHECK-NEXT:    retl
; CHECK-NEXT:    fhaddd %f6, %f14, %f6
entry:
  %add = fadd <4 x double> %a, %b
  %div = fmul <4 x double> %add, <double 5.000000e-01, double 5.000000e-01, double 5.000000e-01, double 5.000000e-01>
  ret <4 x double> %div
}

define <4 x float> @vec_fhsubs(<4 x float> %a, <4 x float> %b) nounwind {
; CHECK-LABEL: vec_fhsubs:
; CHECK:       ! %bb.0: ! %entry
; CHECK-NEXT:    fhsubs %f1, %f9, %f0
; CHECK-NEXT:    fhsubs %f3, %f11, %f1
; CHECK-NEXT:    fhsubs %f5, %f13, %f2
; CHECK-NEXT:    retl
; CHECK-NEXT:    fhsubs %f7, %f15, %f3
entry:
  %sub = fsub <4 x float> %a, %b
  %div = fmul <4 x float> %sub, <float 5.000000e-01, float 5.000000e-01, float 5.000000e-01, float 5.000000e-01>
  ret <4 x float> %div
}

define <4 x double> @vec_fhsubd(<4 x double> %a, <4 x double> %b) nounwind {
; CHECK-LABEL: vec_fhsubd:
; CHECK:       ! %bb.0: ! %entry
; CHECK-NEXT:    fhsubd %f0, %f8, %f0
; CHECK-NEXT:    fhsubd %f2, %f10, %f2
; CHECK-NEXT:    fhsubd %f4, %f12, %f4
; CHECK-NEXT:    retl
; CHECK-NEXT:    fhsubd %f6, %f14, %f6
entry:
  %sub = fsub <4 x double> %a, %b
  %div = fmul <4 x double> %sub, <double 5.000000e-01, double 5.000000e-01, double 5.000000e-01, double 5.000000e-01>
  ret <4 x double> %div
}

define <4 x float> @vec_fnhadds(<4 x float> %a, <4 x float> %b) nounwind {
; CHECK-LABEL: vec_fnhadds:
; CHECK:       ! %bb.0: ! %entry
; CHECK-NEXT:    fnhadds %f1, %f9, %f0
; CHECK-NEXT:    fnhadds %f3, %f11, %f1
; CHECK-NEXT:    fnhadds %f5, %f13, %f2
; CHECK-NEXT:    retl
; CHECK-NEXT:    fnhadds %f7, %f15, %f3
entry:
  %add.i = fadd <4 x float> %a, %b
  %fneg = fmul <4 x float> %add.i, <float -5.000000e-01, float -5.000000e-01, float -5.000000e-01, float -5.000000e-01>
  ret <4 x float> %fneg
}

define <4 x double> @vec_fnhaddd(<4 x double> %a, <4 x double> %b) nounwind {
; CHECK-LABEL: vec_fnhaddd:
; CHECK:       ! %bb.0: ! %entry
; CHECK-NEXT:    fnhaddd %f0, %f8, %f0
; CHECK-NEXT:    fnhaddd %f2, %f10, %f2
; CHECK-NEXT:    fnhaddd %f4, %f12, %f4
; CHECK-NEXT:    retl
; CHECK-NEXT:    fnhaddd %f6, %f14, %f6
entry:
  %add.i = fadd <4 x double> %a, %b
  %fneg = fmul <4 x double> %add.i, <double -5.000000e-01, double -5.000000e-01, double -5.000000e-01, double -5.000000e-01>
  ret <4 x double> %fneg
}
