; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc < %s -mtriple=aarch64-linux-gnu | FileCheck %s --check-prefixes=CHECK,CHECK-SLOW
; RUN: llc < %s -mtriple=aarch64-linux-gnu -mattr=+alu-lsl-fast | FileCheck %s --check-prefixes=CHECK,CHECK-FAST

define i32 @testmul3(i32 noundef %x, i32 noundef %y, i32 noundef %z) {
; CHECK-SLOW-LABEL: testmul3:
; CHECK-SLOW:       // %bb.0: // %entry
; CHECK-SLOW-NEXT:    lsl w8, w0, #3
; CHECK-SLOW-NEXT:    add w9, w8, w1
; CHECK-SLOW-NEXT:    add w8, w8, w2
; CHECK-SLOW-NEXT:    mul w0, w8, w9
; CHECK-SLOW-NEXT:    ret
;
; CHECK-FAST-LABEL: testmul3:
; CHECK-FAST:       // %bb.0: // %entry
; CHECK-FAST-NEXT:    add w8, w1, w0, lsl #3
; CHECK-FAST-NEXT:    add w9, w2, w0, lsl #3
; CHECK-FAST-NEXT:    mul w0, w9, w8
; CHECK-FAST-NEXT:    ret
entry:
  %shl = shl i32 %x, 3
  %add = add nsw i32 %shl, %y
  %add2 = add nsw i32 %shl, %z
  %mul = mul nsw i32 %add2, %add
  ret i32 %mul
}

define i32 @testvar(i32 noundef %x, i32 noundef %y, i32 noundef %z, i32 %zz) {
; CHECK-LABEL: testvar:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    lsl w8, w0, w3
; CHECK-NEXT:    add w9, w8, w1
; CHECK-NEXT:    add w8, w8, w2
; CHECK-NEXT:    mul w0, w8, w9
; CHECK-NEXT:    ret
entry:
  %shl = shl i32 %x, %zz
  %add = add nsw i32 %shl, %y
  %add2 = add nsw i32 %shl, %z
  %mul = mul nsw i32 %add2, %add
  ret i32 %mul
}

define i32 @testmul5(i32 noundef %x, i32 noundef %y, i32 noundef %z) {
; CHECK-LABEL: testmul5:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    lsl w8, w0, #5
; CHECK-NEXT:    add w9, w8, w1
; CHECK-NEXT:    add w8, w8, w2
; CHECK-NEXT:    mul w0, w8, w9
; CHECK-NEXT:    ret
entry:
  %shl = shl i32 %x, 5
  %add = add nsw i32 %shl, %y
  %add2 = add nsw i32 %shl, %z
  %mul = mul nsw i32 %add2, %add
  ret i32 %mul
}

define i64 @testsext3(i32 noundef %x, i64 noundef %y, i64 noundef %z) {
; CHECK-LABEL: testsext3:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    // kill: def $w0 killed $w0 def $x0
; CHECK-NEXT:    sbfiz x8, x0, #3, #32
; CHECK-NEXT:    add x9, x8, x1
; CHECK-NEXT:    add x8, x8, x2
; CHECK-NEXT:    mul x0, x9, x8
; CHECK-NEXT:    ret
entry:
  %conv = sext i32 %x to i64
  %shl = shl nsw i64 %conv, 3
  %add = add nsw i64 %shl, %y
  %add3 = add nsw i64 %shl, %z
  %mul = mul nsw i64 %add, %add3
  ret i64 %mul
}

define i64 @testzext3(i32 noundef %x, i64 noundef %y, i64 noundef %z) {
; CHECK-LABEL: testzext3:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    // kill: def $w0 killed $w0 def $x0
; CHECK-NEXT:    ubfiz x8, x0, #3, #32
; CHECK-NEXT:    add x9, x8, x1
; CHECK-NEXT:    add x8, x8, x2
; CHECK-NEXT:    mul x0, x9, x8
; CHECK-NEXT:    ret
entry:
  %conv = zext i32 %x to i64
  %shl = shl nsw i64 %conv, 3
  %add = add nsw i64 %shl, %y
  %add3 = add nsw i64 %shl, %z
  %mul = mul nsw i64 %add, %add3
  ret i64 %mul
}

define i64 @test3sext(i32 noundef %x, i64 noundef %y, i64 noundef %z) {
; CHECK-LABEL: test3sext:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    lsl w8, w0, #3
; CHECK-NEXT:    sxtw x8, w8
; CHECK-NEXT:    add x9, x8, x1
; CHECK-NEXT:    add x8, x8, x2
; CHECK-NEXT:    mul x0, x9, x8
; CHECK-NEXT:    ret
entry:
  %shl = shl i32 %x, 3
  %conv = sext i32 %shl to i64
  %add = add nsw i64 %conv, %y
  %add3 = add nsw i64 %conv, %z
  %mul = mul nsw i64 %add, %add3
  ret i64 %mul
}

define i64 @test3zext(i32 noundef %x, i64 noundef %y, i64 noundef %z) {
; CHECK-LABEL: test3zext:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    lsl w8, w0, #3
; CHECK-NEXT:    add x9, x8, x1
; CHECK-NEXT:    add x8, x8, x2
; CHECK-NEXT:    mul x0, x9, x8
; CHECK-NEXT:    ret
entry:
  %shl = shl i32 %x, 3
  %conv = zext i32 %shl to i64
  %add = add nsw i64 %conv, %y
  %add3 = add nsw i64 %conv, %z
  %mul = mul nsw i64 %add, %add3
  ret i64 %mul
}
