; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py UTC_ARGS: --version 4
; RUN: llc -verify-machineinstrs -mtriple=riscv32 -mattr=+m,+v,+f,+d,+zvfh,+zvfbfmin < %s | FileCheck %s
; RUN: llc -verify-machineinstrs -mtriple=riscv64 -mattr=+m,+v,+f,+d,+zvfh,+zvfbfmin < %s | FileCheck %s
; RUN: llc -verify-machineinstrs -mtriple=riscv32 -mattr=+m,+v,+f,+d,+zvfhmin,+zvfbfmin < %s | FileCheck %s
; RUN: llc -verify-machineinstrs -mtriple=riscv64 -mattr=+m,+v,+f,+d,+zvfhmin,+zvfbfmin < %s | FileCheck %s

; Vector compress for i8 type

define <vscale x 1 x i8> @vector_compress_nxv1i8(<vscale x 1 x i8> %data, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: vector_compress_nxv1i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e8, mf8, ta, ma
; CHECK-NEXT:    vcompress.vm v9, v8, v0
; CHECK-NEXT:    vmv1r.v v8, v9
; CHECK-NEXT:    ret
  %ret = call <vscale x 1 x i8> @llvm.experimental.vector.compress.nxv1i8(<vscale x 1 x i8> %data, <vscale x 1 x i1> %mask, <vscale x 1 x i8> undef)
  ret <vscale x 1 x i8> %ret
}

define <vscale x 1 x i8> @vector_compress_nxv1i8_passthru(<vscale x 1 x i8> %passthru, <vscale x 1 x i8> %data, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: vector_compress_nxv1i8_passthru:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e8, mf8, tu, ma
; CHECK-NEXT:    vcompress.vm v8, v9, v0
; CHECK-NEXT:    ret
  %ret = call <vscale x 1 x i8> @llvm.experimental.vector.compress.nxv1i8(<vscale x 1 x i8> %data, <vscale x 1 x i1> %mask, <vscale x 1 x i8> %passthru)
  ret <vscale x 1 x i8> %ret
}

define <vscale x 2 x i8> @vector_compress_nxv2i8(<vscale x 2 x i8> %data, <vscale x 2 x i1> %mask) {
; CHECK-LABEL: vector_compress_nxv2i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e8, mf4, ta, ma
; CHECK-NEXT:    vcompress.vm v9, v8, v0
; CHECK-NEXT:    vmv1r.v v8, v9
; CHECK-NEXT:    ret
  %ret = call <vscale x 2 x i8> @llvm.experimental.vector.compress.nxv2i8(<vscale x 2 x i8> %data, <vscale x 2 x i1> %mask, <vscale x 2 x i8> undef)
  ret <vscale x 2 x i8> %ret
}

define <vscale x 2 x i8> @vector_compress_nxv2i8_passthru(<vscale x 2 x i8> %passthru, <vscale x 2 x i8> %data, <vscale x 2 x i1> %mask) {
; CHECK-LABEL: vector_compress_nxv2i8_passthru:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e8, mf4, tu, ma
; CHECK-NEXT:    vcompress.vm v8, v9, v0
; CHECK-NEXT:    ret
  %ret = call <vscale x 2 x i8> @llvm.experimental.vector.compress.nxv2i8(<vscale x 2 x i8> %data, <vscale x 2 x i1> %mask, <vscale x 2 x i8> %passthru)
  ret <vscale x 2 x i8> %ret
}

define <vscale x 4 x i8> @vector_compress_nxv4i8(<vscale x 4 x i8> %data, <vscale x 4 x i1> %mask) {
; CHECK-LABEL: vector_compress_nxv4i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e8, mf2, ta, ma
; CHECK-NEXT:    vcompress.vm v9, v8, v0
; CHECK-NEXT:    vmv1r.v v8, v9
; CHECK-NEXT:    ret
  %ret = call <vscale x 4 x i8> @llvm.experimental.vector.compress.nxv4i8(<vscale x 4 x i8> %data, <vscale x 4 x i1> %mask, <vscale x 4 x i8> undef)
  ret <vscale x 4 x i8> %ret
}

define <vscale x 4 x i8> @vector_compress_nxv4i8_passthru(<vscale x 4 x i8> %passthru, <vscale x 4 x i8> %data, <vscale x 4 x i1> %mask) {
; CHECK-LABEL: vector_compress_nxv4i8_passthru:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e8, mf2, tu, ma
; CHECK-NEXT:    vcompress.vm v8, v9, v0
; CHECK-NEXT:    ret
  %ret = call <vscale x 4 x i8> @llvm.experimental.vector.compress.nxv4i8(<vscale x 4 x i8> %data, <vscale x 4 x i1> %mask, <vscale x 4 x i8> %passthru)
  ret <vscale x 4 x i8> %ret
}

define <vscale x 8 x i8> @vector_compress_nxv8i8(<vscale x 8 x i8> %data, <vscale x 8 x i1> %mask) {
; CHECK-LABEL: vector_compress_nxv8i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e8, m1, ta, ma
; CHECK-NEXT:    vcompress.vm v9, v8, v0
; CHECK-NEXT:    vmv.v.v v8, v9
; CHECK-NEXT:    ret
  %ret = call <vscale x 8 x i8> @llvm.experimental.vector.compress.nxv8i8(<vscale x 8 x i8> %data, <vscale x 8 x i1> %mask, <vscale x 8 x i8> undef)
  ret <vscale x 8 x i8> %ret
}

define <vscale x 8 x i8> @vector_compress_nxv8i8_passthru(<vscale x 8 x i8> %passthru, <vscale x 8 x i8> %data, <vscale x 8 x i1> %mask) {
; CHECK-LABEL: vector_compress_nxv8i8_passthru:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e8, m1, tu, ma
; CHECK-NEXT:    vcompress.vm v8, v9, v0
; CHECK-NEXT:    ret
  %ret = call <vscale x 8 x i8> @llvm.experimental.vector.compress.nxv8i8(<vscale x 8 x i8> %data, <vscale x 8 x i1> %mask, <vscale x 8 x i8> %passthru)
  ret <vscale x 8 x i8> %ret
}

define <vscale x 16 x i8> @vector_compress_nxv16i8(<vscale x 16 x i8> %data, <vscale x 16 x i1> %mask) {
; CHECK-LABEL: vector_compress_nxv16i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e8, m2, ta, ma
; CHECK-NEXT:    vcompress.vm v10, v8, v0
; CHECK-NEXT:    vmv.v.v v8, v10
; CHECK-NEXT:    ret
  %ret = call <vscale x 16 x i8> @llvm.experimental.vector.compress.nxv16i8(<vscale x 16 x i8> %data, <vscale x 16 x i1> %mask, <vscale x 16 x i8> undef)
  ret <vscale x 16 x i8> %ret
}

define <vscale x 16 x i8> @vector_compress_nxv16i8_passthru(<vscale x 16 x i8> %passthru, <vscale x 16 x i8> %data, <vscale x 16 x i1> %mask) {
; CHECK-LABEL: vector_compress_nxv16i8_passthru:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e8, m2, tu, ma
; CHECK-NEXT:    vcompress.vm v8, v10, v0
; CHECK-NEXT:    ret
  %ret = call <vscale x 16 x i8> @llvm.experimental.vector.compress.nxv16i8(<vscale x 16 x i8> %data, <vscale x 16 x i1> %mask, <vscale x 16 x i8> %passthru)
  ret <vscale x 16 x i8> %ret
}

define <vscale x 32 x i8> @vector_compress_nxv32i8(<vscale x 32 x i8> %data, <vscale x 32 x i1> %mask) {
; CHECK-LABEL: vector_compress_nxv32i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e8, m4, ta, ma
; CHECK-NEXT:    vcompress.vm v12, v8, v0
; CHECK-NEXT:    vmv.v.v v8, v12
; CHECK-NEXT:    ret
  %ret = call <vscale x 32 x i8> @llvm.experimental.vector.compress.nxv32i8(<vscale x 32 x i8> %data, <vscale x 32 x i1> %mask, <vscale x 32 x i8> undef)
  ret <vscale x 32 x i8> %ret
}

define <vscale x 32 x i8> @vector_compress_nxv32i8_passthru(<vscale x 32 x i8> %passthru, <vscale x 32 x i8> %data, <vscale x 32 x i1> %mask) {
; CHECK-LABEL: vector_compress_nxv32i8_passthru:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e8, m4, tu, ma
; CHECK-NEXT:    vcompress.vm v8, v12, v0
; CHECK-NEXT:    ret
  %ret = call <vscale x 32 x i8> @llvm.experimental.vector.compress.nxv32i8(<vscale x 32 x i8> %data, <vscale x 32 x i1> %mask, <vscale x 32 x i8> %passthru)
  ret <vscale x 32 x i8> %ret
}

define <vscale x 64 x i8> @vector_compress_nxv64i8(<vscale x 64 x i8> %data, <vscale x 64 x i1> %mask) {
; CHECK-LABEL: vector_compress_nxv64i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e8, m8, ta, ma
; CHECK-NEXT:    vcompress.vm v16, v8, v0
; CHECK-NEXT:    vmv.v.v v8, v16
; CHECK-NEXT:    ret
  %ret = call <vscale x 64 x i8> @llvm.experimental.vector.compress.nxv64i8(<vscale x 64 x i8> %data, <vscale x 64 x i1> %mask, <vscale x 64 x i8> undef)
  ret <vscale x 64 x i8> %ret
}

define <vscale x 64 x i8> @vector_compress_nxv64i8_passthru(<vscale x 64 x i8> %passthru, <vscale x 64 x i8> %data, <vscale x 64 x i1> %mask) {
; CHECK-LABEL: vector_compress_nxv64i8_passthru:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e8, m8, tu, ma
; CHECK-NEXT:    vcompress.vm v8, v16, v0
; CHECK-NEXT:    ret
  %ret = call <vscale x 64 x i8> @llvm.experimental.vector.compress.nxv64i8(<vscale x 64 x i8> %data, <vscale x 64 x i1> %mask, <vscale x 64 x i8> %passthru)
  ret <vscale x 64 x i8> %ret
}

; Vector compress for i16 type

define <vscale x 1 x i16> @vector_compress_nxv1i16(<vscale x 1 x i16> %data, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: vector_compress_nxv1i16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, mf4, ta, ma
; CHECK-NEXT:    vcompress.vm v9, v8, v0
; CHECK-NEXT:    vmv1r.v v8, v9
; CHECK-NEXT:    ret
  %ret = call <vscale x 1 x i16> @llvm.experimental.vector.compress.nxv1i16(<vscale x 1 x i16> %data, <vscale x 1 x i1> %mask, <vscale x 1 x i16> undef)
  ret <vscale x 1 x i16> %ret
}

define <vscale x 1 x i16> @vector_compress_nxv1i16_passthru(<vscale x 1 x i16> %passthru, <vscale x 1 x i16> %data, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: vector_compress_nxv1i16_passthru:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, mf4, tu, ma
; CHECK-NEXT:    vcompress.vm v8, v9, v0
; CHECK-NEXT:    ret
  %ret = call <vscale x 1 x i16> @llvm.experimental.vector.compress.nxv1i16(<vscale x 1 x i16> %data, <vscale x 1 x i1> %mask, <vscale x 1 x i16> %passthru)
  ret <vscale x 1 x i16> %ret
}

define <vscale x 2 x i16> @vector_compress_nxv2i16(<vscale x 2 x i16> %data, <vscale x 2 x i1> %mask) {
; CHECK-LABEL: vector_compress_nxv2i16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, mf2, ta, ma
; CHECK-NEXT:    vcompress.vm v9, v8, v0
; CHECK-NEXT:    vmv1r.v v8, v9
; CHECK-NEXT:    ret
  %ret = call <vscale x 2 x i16> @llvm.experimental.vector.compress.nxv2i16(<vscale x 2 x i16> %data, <vscale x 2 x i1> %mask, <vscale x 2 x i16> undef)
  ret <vscale x 2 x i16> %ret
}

define <vscale x 2 x i16> @vector_compress_nxv2i16_passthru(<vscale x 2 x i16> %passthru, <vscale x 2 x i16> %data, <vscale x 2 x i1> %mask) {
; CHECK-LABEL: vector_compress_nxv2i16_passthru:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, mf2, tu, ma
; CHECK-NEXT:    vcompress.vm v8, v9, v0
; CHECK-NEXT:    ret
  %ret = call <vscale x 2 x i16> @llvm.experimental.vector.compress.nxv2i16(<vscale x 2 x i16> %data, <vscale x 2 x i1> %mask, <vscale x 2 x i16> %passthru)
  ret <vscale x 2 x i16> %ret
}

define <vscale x 4 x i16> @vector_compress_nxv4i16(<vscale x 4 x i16> %data, <vscale x 4 x i1> %mask) {
; CHECK-LABEL: vector_compress_nxv4i16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, m1, ta, ma
; CHECK-NEXT:    vcompress.vm v9, v8, v0
; CHECK-NEXT:    vmv.v.v v8, v9
; CHECK-NEXT:    ret
  %ret = call <vscale x 4 x i16> @llvm.experimental.vector.compress.nxv4i16(<vscale x 4 x i16> %data, <vscale x 4 x i1> %mask, <vscale x 4 x i16> undef)
  ret <vscale x 4 x i16> %ret
}

define <vscale x 4 x i16> @vector_compress_nxv4i16_passthru(<vscale x 4 x i16> %passthru, <vscale x 4 x i16> %data, <vscale x 4 x i1> %mask) {
; CHECK-LABEL: vector_compress_nxv4i16_passthru:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, m1, tu, ma
; CHECK-NEXT:    vcompress.vm v8, v9, v0
; CHECK-NEXT:    ret
  %ret = call <vscale x 4 x i16> @llvm.experimental.vector.compress.nxv4i16(<vscale x 4 x i16> %data, <vscale x 4 x i1> %mask, <vscale x 4 x i16> %passthru)
  ret <vscale x 4 x i16> %ret
}

define <vscale x 8 x i16> @vector_compress_nxv8i16(<vscale x 8 x i16> %data, <vscale x 8 x i1> %mask) {
; CHECK-LABEL: vector_compress_nxv8i16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, m2, ta, ma
; CHECK-NEXT:    vcompress.vm v10, v8, v0
; CHECK-NEXT:    vmv.v.v v8, v10
; CHECK-NEXT:    ret
  %ret = call <vscale x 8 x i16> @llvm.experimental.vector.compress.nxv8i16(<vscale x 8 x i16> %data, <vscale x 8 x i1> %mask, <vscale x 8 x i16> undef)
  ret <vscale x 8 x i16> %ret
}

define <vscale x 8 x i16> @vector_compress_nxv8i16_passthru(<vscale x 8 x i16> %passthru, <vscale x 8 x i16> %data, <vscale x 8 x i1> %mask) {
; CHECK-LABEL: vector_compress_nxv8i16_passthru:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, m2, tu, ma
; CHECK-NEXT:    vcompress.vm v8, v10, v0
; CHECK-NEXT:    ret
  %ret = call <vscale x 8 x i16> @llvm.experimental.vector.compress.nxv8i16(<vscale x 8 x i16> %data, <vscale x 8 x i1> %mask, <vscale x 8 x i16> %passthru)
  ret <vscale x 8 x i16> %ret
}

define <vscale x 16 x i16> @vector_compress_nxv16i16(<vscale x 16 x i16> %data, <vscale x 16 x i1> %mask) {
; CHECK-LABEL: vector_compress_nxv16i16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, m4, ta, ma
; CHECK-NEXT:    vcompress.vm v12, v8, v0
; CHECK-NEXT:    vmv.v.v v8, v12
; CHECK-NEXT:    ret
  %ret = call <vscale x 16 x i16> @llvm.experimental.vector.compress.nxv16i16(<vscale x 16 x i16> %data, <vscale x 16 x i1> %mask, <vscale x 16 x i16> undef)
  ret <vscale x 16 x i16> %ret
}

define <vscale x 16 x i16> @vector_compress_nxv16i16_passthru(<vscale x 16 x i16> %passthru, <vscale x 16 x i16> %data, <vscale x 16 x i1> %mask) {
; CHECK-LABEL: vector_compress_nxv16i16_passthru:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, m4, tu, ma
; CHECK-NEXT:    vcompress.vm v8, v12, v0
; CHECK-NEXT:    ret
  %ret = call <vscale x 16 x i16> @llvm.experimental.vector.compress.nxv16i16(<vscale x 16 x i16> %data, <vscale x 16 x i1> %mask, <vscale x 16 x i16> %passthru)
  ret <vscale x 16 x i16> %ret
}

define <vscale x 32 x i16> @vector_compress_nxv32i16(<vscale x 32 x i16> %data, <vscale x 32 x i1> %mask) {
; CHECK-LABEL: vector_compress_nxv32i16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, m8, ta, ma
; CHECK-NEXT:    vcompress.vm v16, v8, v0
; CHECK-NEXT:    vmv.v.v v8, v16
; CHECK-NEXT:    ret
  %ret = call <vscale x 32 x i16> @llvm.experimental.vector.compress.nxv32i16(<vscale x 32 x i16> %data, <vscale x 32 x i1> %mask, <vscale x 32 x i16> undef)
  ret <vscale x 32 x i16> %ret
}

define <vscale x 32 x i16> @vector_compress_nxv32i16_passthru(<vscale x 32 x i16> %passthru, <vscale x 32 x i16> %data, <vscale x 32 x i1> %mask) {
; CHECK-LABEL: vector_compress_nxv32i16_passthru:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, m8, tu, ma
; CHECK-NEXT:    vcompress.vm v8, v16, v0
; CHECK-NEXT:    ret
  %ret = call <vscale x 32 x i16> @llvm.experimental.vector.compress.nxv32i16(<vscale x 32 x i16> %data, <vscale x 32 x i1> %mask, <vscale x 32 x i16> %passthru)
  ret <vscale x 32 x i16> %ret
}

; Vector compress for i32 type

define <vscale x 1 x i32> @vector_compress_nxv1i32(<vscale x 1 x i32> %data, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: vector_compress_nxv1i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, mf2, ta, ma
; CHECK-NEXT:    vcompress.vm v9, v8, v0
; CHECK-NEXT:    vmv1r.v v8, v9
; CHECK-NEXT:    ret
  %ret = call <vscale x 1 x i32> @llvm.experimental.vector.compress.nxv1i32(<vscale x 1 x i32> %data, <vscale x 1 x i1> %mask, <vscale x 1 x i32> undef)
  ret <vscale x 1 x i32> %ret
}

define <vscale x 1 x i32> @vector_compress_nxv1i32_passthru(<vscale x 1 x i32> %passthru, <vscale x 1 x i32> %data, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: vector_compress_nxv1i32_passthru:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, mf2, tu, ma
; CHECK-NEXT:    vcompress.vm v8, v9, v0
; CHECK-NEXT:    ret
  %ret = call <vscale x 1 x i32> @llvm.experimental.vector.compress.nxv1i32(<vscale x 1 x i32> %data, <vscale x 1 x i1> %mask, <vscale x 1 x i32> %passthru)
  ret <vscale x 1 x i32> %ret
}

define <vscale x 2 x i32> @vector_compress_nxv2i32(<vscale x 2 x i32> %data, <vscale x 2 x i1> %mask) {
; CHECK-LABEL: vector_compress_nxv2i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m1, ta, ma
; CHECK-NEXT:    vcompress.vm v9, v8, v0
; CHECK-NEXT:    vmv.v.v v8, v9
; CHECK-NEXT:    ret
  %ret = call <vscale x 2 x i32> @llvm.experimental.vector.compress.nxv2i32(<vscale x 2 x i32> %data, <vscale x 2 x i1> %mask, <vscale x 2 x i32> undef)
  ret <vscale x 2 x i32> %ret
}

define <vscale x 2 x i32> @vector_compress_nxv2i32_passthru(<vscale x 2 x i32> %passthru, <vscale x 2 x i32> %data, <vscale x 2 x i1> %mask) {
; CHECK-LABEL: vector_compress_nxv2i32_passthru:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m1, tu, ma
; CHECK-NEXT:    vcompress.vm v8, v9, v0
; CHECK-NEXT:    ret
  %ret = call <vscale x 2 x i32> @llvm.experimental.vector.compress.nxv2i32(<vscale x 2 x i32> %data, <vscale x 2 x i1> %mask, <vscale x 2 x i32> %passthru)
  ret <vscale x 2 x i32> %ret
}

define <vscale x 4 x i32> @vector_compress_nxv4i32(<vscale x 4 x i32> %data, <vscale x 4 x i1> %mask) {
; CHECK-LABEL: vector_compress_nxv4i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m2, ta, ma
; CHECK-NEXT:    vcompress.vm v10, v8, v0
; CHECK-NEXT:    vmv.v.v v8, v10
; CHECK-NEXT:    ret
  %ret = call <vscale x 4 x i32> @llvm.experimental.vector.compress.nxv4i32(<vscale x 4 x i32> %data, <vscale x 4 x i1> %mask, <vscale x 4 x i32> undef)
  ret <vscale x 4 x i32> %ret
}

define <vscale x 4 x i32> @vector_compress_nxv4i32_passthru(<vscale x 4 x i32> %passthru, <vscale x 4 x i32> %data, <vscale x 4 x i1> %mask) {
; CHECK-LABEL: vector_compress_nxv4i32_passthru:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m2, tu, ma
; CHECK-NEXT:    vcompress.vm v8, v10, v0
; CHECK-NEXT:    ret
  %ret = call <vscale x 4 x i32> @llvm.experimental.vector.compress.nxv4i32(<vscale x 4 x i32> %data, <vscale x 4 x i1> %mask, <vscale x 4 x i32> %passthru)
  ret <vscale x 4 x i32> %ret
}

define <vscale x 8 x i32> @vector_compress_nxv8i32(<vscale x 8 x i32> %data, <vscale x 8 x i1> %mask) {
; CHECK-LABEL: vector_compress_nxv8i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m4, ta, ma
; CHECK-NEXT:    vcompress.vm v12, v8, v0
; CHECK-NEXT:    vmv.v.v v8, v12
; CHECK-NEXT:    ret
  %ret = call <vscale x 8 x i32> @llvm.experimental.vector.compress.nxv8i32(<vscale x 8 x i32> %data, <vscale x 8 x i1> %mask, <vscale x 8 x i32> undef)
  ret <vscale x 8 x i32> %ret
}

define <vscale x 8 x i32> @vector_compress_nxv8i32_passthru(<vscale x 8 x i32> %passthru, <vscale x 8 x i32> %data, <vscale x 8 x i1> %mask) {
; CHECK-LABEL: vector_compress_nxv8i32_passthru:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m4, tu, ma
; CHECK-NEXT:    vcompress.vm v8, v12, v0
; CHECK-NEXT:    ret
  %ret = call <vscale x 8 x i32> @llvm.experimental.vector.compress.nxv8i32(<vscale x 8 x i32> %data, <vscale x 8 x i1> %mask, <vscale x 8 x i32> %passthru)
  ret <vscale x 8 x i32> %ret
}

define <vscale x 16 x i32> @vector_compress_nxv16i32(<vscale x 16 x i32> %data, <vscale x 16 x i1> %mask) {
; CHECK-LABEL: vector_compress_nxv16i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m8, ta, ma
; CHECK-NEXT:    vcompress.vm v16, v8, v0
; CHECK-NEXT:    vmv.v.v v8, v16
; CHECK-NEXT:    ret
  %ret = call <vscale x 16 x i32> @llvm.experimental.vector.compress.nxv16i32(<vscale x 16 x i32> %data, <vscale x 16 x i1> %mask, <vscale x 16 x i32> undef)
  ret <vscale x 16 x i32> %ret
}

define <vscale x 16 x i32> @vector_compress_nxv16i32_passthru(<vscale x 16 x i32> %passthru, <vscale x 16 x i32> %data, <vscale x 16 x i1> %mask) {
; CHECK-LABEL: vector_compress_nxv16i32_passthru:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m8, tu, ma
; CHECK-NEXT:    vcompress.vm v8, v16, v0
; CHECK-NEXT:    ret
  %ret = call <vscale x 16 x i32> @llvm.experimental.vector.compress.nxv16i32(<vscale x 16 x i32> %data, <vscale x 16 x i1> %mask, <vscale x 16 x i32> %passthru)
  ret <vscale x 16 x i32> %ret
}

; Vector compress for i64 type

define <vscale x 1 x i64> @vector_compress_nxv1i64(<vscale x 1 x i64> %data, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: vector_compress_nxv1i64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e64, m1, ta, ma
; CHECK-NEXT:    vcompress.vm v9, v8, v0
; CHECK-NEXT:    vmv.v.v v8, v9
; CHECK-NEXT:    ret
  %ret = call <vscale x 1 x i64> @llvm.experimental.vector.compress.nxv1i64(<vscale x 1 x i64> %data, <vscale x 1 x i1> %mask, <vscale x 1 x i64> undef)
  ret <vscale x 1 x i64> %ret
}

define <vscale x 1 x i64> @vector_compress_nxv1i64_passthru(<vscale x 1 x i64> %passthru, <vscale x 1 x i64> %data, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: vector_compress_nxv1i64_passthru:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e64, m1, tu, ma
; CHECK-NEXT:    vcompress.vm v8, v9, v0
; CHECK-NEXT:    ret
  %ret = call <vscale x 1 x i64> @llvm.experimental.vector.compress.nxv1i64(<vscale x 1 x i64> %data, <vscale x 1 x i1> %mask, <vscale x 1 x i64> %passthru)
  ret <vscale x 1 x i64> %ret
}

define <vscale x 2 x i64> @vector_compress_nxv2i64(<vscale x 2 x i64> %data, <vscale x 2 x i1> %mask) {
; CHECK-LABEL: vector_compress_nxv2i64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e64, m2, ta, ma
; CHECK-NEXT:    vcompress.vm v10, v8, v0
; CHECK-NEXT:    vmv.v.v v8, v10
; CHECK-NEXT:    ret
  %ret = call <vscale x 2 x i64> @llvm.experimental.vector.compress.nxv2i64(<vscale x 2 x i64> %data, <vscale x 2 x i1> %mask, <vscale x 2 x i64> undef)
  ret <vscale x 2 x i64> %ret
}

define <vscale x 2 x i64> @vector_compress_nxv2i64_passthru(<vscale x 2 x i64> %passthru, <vscale x 2 x i64> %data, <vscale x 2 x i1> %mask) {
; CHECK-LABEL: vector_compress_nxv2i64_passthru:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e64, m2, tu, ma
; CHECK-NEXT:    vcompress.vm v8, v10, v0
; CHECK-NEXT:    ret
  %ret = call <vscale x 2 x i64> @llvm.experimental.vector.compress.nxv2i64(<vscale x 2 x i64> %data, <vscale x 2 x i1> %mask, <vscale x 2 x i64> %passthru)
  ret <vscale x 2 x i64> %ret
}

define <vscale x 4 x i64> @vector_compress_nxv4i64(<vscale x 4 x i64> %data, <vscale x 4 x i1> %mask) {
; CHECK-LABEL: vector_compress_nxv4i64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e64, m4, ta, ma
; CHECK-NEXT:    vcompress.vm v12, v8, v0
; CHECK-NEXT:    vmv.v.v v8, v12
; CHECK-NEXT:    ret
  %ret = call <vscale x 4 x i64> @llvm.experimental.vector.compress.nxv4i64(<vscale x 4 x i64> %data, <vscale x 4 x i1> %mask, <vscale x 4 x i64> undef)
  ret <vscale x 4 x i64> %ret
}

define <vscale x 4 x i64> @vector_compress_nxv4i64_passthru(<vscale x 4 x i64> %passthru, <vscale x 4 x i64> %data, <vscale x 4 x i1> %mask) {
; CHECK-LABEL: vector_compress_nxv4i64_passthru:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e64, m4, tu, ma
; CHECK-NEXT:    vcompress.vm v8, v12, v0
; CHECK-NEXT:    ret
  %ret = call <vscale x 4 x i64> @llvm.experimental.vector.compress.nxv4i64(<vscale x 4 x i64> %data, <vscale x 4 x i1> %mask, <vscale x 4 x i64> %passthru)
  ret <vscale x 4 x i64> %ret
}

define <vscale x 8 x i64> @vector_compress_nxv8i64(<vscale x 8 x i64> %data, <vscale x 8 x i1> %mask) {
; CHECK-LABEL: vector_compress_nxv8i64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e64, m8, ta, ma
; CHECK-NEXT:    vcompress.vm v16, v8, v0
; CHECK-NEXT:    vmv.v.v v8, v16
; CHECK-NEXT:    ret
  %ret = call <vscale x 8 x i64> @llvm.experimental.vector.compress.nxv8i64(<vscale x 8 x i64> %data, <vscale x 8 x i1> %mask, <vscale x 8 x i64> undef)
  ret <vscale x 8 x i64> %ret
}

define <vscale x 8 x i64> @vector_compress_nxv8i64_passthru(<vscale x 8 x i64> %passthru, <vscale x 8 x i64> %data, <vscale x 8 x i1> %mask) {
; CHECK-LABEL: vector_compress_nxv8i64_passthru:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e64, m8, tu, ma
; CHECK-NEXT:    vcompress.vm v8, v16, v0
; CHECK-NEXT:    ret
  %ret = call <vscale x 8 x i64> @llvm.experimental.vector.compress.nxv8i64(<vscale x 8 x i64> %data, <vscale x 8 x i1> %mask, <vscale x 8 x i64> %passthru)
  ret <vscale x 8 x i64> %ret
}

; Vector compress for bf16 type

define <vscale x 1 x bfloat> @vector_compress_nxv1bf16(<vscale x 1 x bfloat> %data, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: vector_compress_nxv1bf16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, mf4, ta, ma
; CHECK-NEXT:    vcompress.vm v9, v8, v0
; CHECK-NEXT:    vmv1r.v v8, v9
; CHECK-NEXT:    ret
  %ret = call <vscale x 1 x bfloat> @llvm.experimental.vector.compress.nxv1bf16(<vscale x 1 x bfloat> %data, <vscale x 1 x i1> %mask, <vscale x 1 x bfloat> undef)
  ret <vscale x 1 x bfloat> %ret
}

define <vscale x 1 x bfloat> @vector_compress_nxv1bf16_passthru(<vscale x 1 x bfloat> %passthru, <vscale x 1 x bfloat> %data, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: vector_compress_nxv1bf16_passthru:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, mf4, tu, ma
; CHECK-NEXT:    vcompress.vm v8, v9, v0
; CHECK-NEXT:    ret
  %ret = call <vscale x 1 x bfloat> @llvm.experimental.vector.compress.nxv1bf16(<vscale x 1 x bfloat> %data, <vscale x 1 x i1> %mask, <vscale x 1 x bfloat> %passthru)
  ret <vscale x 1 x bfloat> %ret
}

define <vscale x 2 x bfloat> @vector_compress_nxv2bf16(<vscale x 2 x bfloat> %data, <vscale x 2 x i1> %mask) {
; CHECK-LABEL: vector_compress_nxv2bf16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, mf2, ta, ma
; CHECK-NEXT:    vcompress.vm v9, v8, v0
; CHECK-NEXT:    vmv1r.v v8, v9
; CHECK-NEXT:    ret
  %ret = call <vscale x 2 x bfloat> @llvm.experimental.vector.compress.nxv2bf16(<vscale x 2 x bfloat> %data, <vscale x 2 x i1> %mask, <vscale x 2 x bfloat> undef)
  ret <vscale x 2 x bfloat> %ret
}

define <vscale x 2 x bfloat> @vector_compress_nxv2bf16_passthru(<vscale x 2 x bfloat> %passthru, <vscale x 2 x bfloat> %data, <vscale x 2 x i1> %mask) {
; CHECK-LABEL: vector_compress_nxv2bf16_passthru:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, mf2, tu, ma
; CHECK-NEXT:    vcompress.vm v8, v9, v0
; CHECK-NEXT:    ret
  %ret = call <vscale x 2 x bfloat> @llvm.experimental.vector.compress.nxv2bf16(<vscale x 2 x bfloat> %data, <vscale x 2 x i1> %mask, <vscale x 2 x bfloat> %passthru)
  ret <vscale x 2 x bfloat> %ret
}

define <vscale x 4 x bfloat> @vector_compress_nxv4bf16(<vscale x 4 x bfloat> %data, <vscale x 4 x i1> %mask) {
; CHECK-LABEL: vector_compress_nxv4bf16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, m1, ta, ma
; CHECK-NEXT:    vcompress.vm v9, v8, v0
; CHECK-NEXT:    vmv.v.v v8, v9
; CHECK-NEXT:    ret
  %ret = call <vscale x 4 x bfloat> @llvm.experimental.vector.compress.nxv4bf16(<vscale x 4 x bfloat> %data, <vscale x 4 x i1> %mask, <vscale x 4 x bfloat> undef)
  ret <vscale x 4 x bfloat> %ret
}

define <vscale x 4 x bfloat> @vector_compress_nxv4bf16_passthru(<vscale x 4 x bfloat> %passthru, <vscale x 4 x bfloat> %data, <vscale x 4 x i1> %mask) {
; CHECK-LABEL: vector_compress_nxv4bf16_passthru:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, m1, tu, ma
; CHECK-NEXT:    vcompress.vm v8, v9, v0
; CHECK-NEXT:    ret
  %ret = call <vscale x 4 x bfloat> @llvm.experimental.vector.compress.nxv4bf16(<vscale x 4 x bfloat> %data, <vscale x 4 x i1> %mask, <vscale x 4 x bfloat> %passthru)
  ret <vscale x 4 x bfloat> %ret
}

define <vscale x 8 x bfloat> @vector_compress_nxv8bf16(<vscale x 8 x bfloat> %data, <vscale x 8 x i1> %mask) {
; CHECK-LABEL: vector_compress_nxv8bf16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, m2, ta, ma
; CHECK-NEXT:    vcompress.vm v10, v8, v0
; CHECK-NEXT:    vmv.v.v v8, v10
; CHECK-NEXT:    ret
  %ret = call <vscale x 8 x bfloat> @llvm.experimental.vector.compress.nxv8bf16(<vscale x 8 x bfloat> %data, <vscale x 8 x i1> %mask, <vscale x 8 x bfloat> undef)
  ret <vscale x 8 x bfloat> %ret
}

define <vscale x 8 x bfloat> @vector_compress_nxv8bf16_passthru(<vscale x 8 x bfloat> %passthru, <vscale x 8 x bfloat> %data, <vscale x 8 x i1> %mask) {
; CHECK-LABEL: vector_compress_nxv8bf16_passthru:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, m2, tu, ma
; CHECK-NEXT:    vcompress.vm v8, v10, v0
; CHECK-NEXT:    ret
  %ret = call <vscale x 8 x bfloat> @llvm.experimental.vector.compress.nxv8bf16(<vscale x 8 x bfloat> %data, <vscale x 8 x i1> %mask, <vscale x 8 x bfloat> %passthru)
  ret <vscale x 8 x bfloat> %ret
}

define <vscale x 16 x bfloat> @vector_compress_nxv16bf16(<vscale x 16 x bfloat> %data, <vscale x 16 x i1> %mask) {
; CHECK-LABEL: vector_compress_nxv16bf16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, m4, ta, ma
; CHECK-NEXT:    vcompress.vm v12, v8, v0
; CHECK-NEXT:    vmv.v.v v8, v12
; CHECK-NEXT:    ret
  %ret = call <vscale x 16 x bfloat> @llvm.experimental.vector.compress.nxv16bf16(<vscale x 16 x bfloat> %data, <vscale x 16 x i1> %mask, <vscale x 16 x bfloat> undef)
  ret <vscale x 16 x bfloat> %ret
}

define <vscale x 16 x bfloat> @vector_compress_nxv16bf16_passthru(<vscale x 16 x bfloat> %passthru, <vscale x 16 x bfloat> %data, <vscale x 16 x i1> %mask) {
; CHECK-LABEL: vector_compress_nxv16bf16_passthru:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, m4, tu, ma
; CHECK-NEXT:    vcompress.vm v8, v12, v0
; CHECK-NEXT:    ret
  %ret = call <vscale x 16 x bfloat> @llvm.experimental.vector.compress.nxv16bf16(<vscale x 16 x bfloat> %data, <vscale x 16 x i1> %mask, <vscale x 16 x bfloat> %passthru)
  ret <vscale x 16 x bfloat> %ret
}

define <vscale x 32 x bfloat> @vector_compress_nxv32bf16(<vscale x 32 x bfloat> %data, <vscale x 32 x i1> %mask) {
; CHECK-LABEL: vector_compress_nxv32bf16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, m8, ta, ma
; CHECK-NEXT:    vcompress.vm v16, v8, v0
; CHECK-NEXT:    vmv.v.v v8, v16
; CHECK-NEXT:    ret
  %ret = call <vscale x 32 x bfloat> @llvm.experimental.vector.compress.nxv32bf16(<vscale x 32 x bfloat> %data, <vscale x 32 x i1> %mask, <vscale x 32 x bfloat> undef)
  ret <vscale x 32 x bfloat> %ret
}

define <vscale x 32 x bfloat> @vector_compress_nxv32bf16_passthru(<vscale x 32 x bfloat> %passthru, <vscale x 32 x bfloat> %data, <vscale x 32 x i1> %mask) {
; CHECK-LABEL: vector_compress_nxv32bf16_passthru:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, m8, tu, ma
; CHECK-NEXT:    vcompress.vm v8, v16, v0
; CHECK-NEXT:    ret
  %ret = call <vscale x 32 x bfloat> @llvm.experimental.vector.compress.nxv32bf16(<vscale x 32 x bfloat> %data, <vscale x 32 x i1> %mask, <vscale x 32 x bfloat> %passthru)
  ret <vscale x 32 x bfloat> %ret
}

; Vector compress for f16 type

define <vscale x 1 x half> @vector_compress_nxv1f16(<vscale x 1 x half> %data, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: vector_compress_nxv1f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, mf4, ta, ma
; CHECK-NEXT:    vcompress.vm v9, v8, v0
; CHECK-NEXT:    vmv1r.v v8, v9
; CHECK-NEXT:    ret
  %ret = call <vscale x 1 x half> @llvm.experimental.vector.compress.nxv1f16(<vscale x 1 x half> %data, <vscale x 1 x i1> %mask, <vscale x 1 x half> undef)
  ret <vscale x 1 x half> %ret
}

define <vscale x 1 x half> @vector_compress_nxv1f16_passthru(<vscale x 1 x half> %passthru, <vscale x 1 x half> %data, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: vector_compress_nxv1f16_passthru:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, mf4, tu, ma
; CHECK-NEXT:    vcompress.vm v8, v9, v0
; CHECK-NEXT:    ret
  %ret = call <vscale x 1 x half> @llvm.experimental.vector.compress.nxv1f16(<vscale x 1 x half> %data, <vscale x 1 x i1> %mask, <vscale x 1 x half> %passthru)
  ret <vscale x 1 x half> %ret
}

define <vscale x 2 x half> @vector_compress_nxv2f16(<vscale x 2 x half> %data, <vscale x 2 x i1> %mask) {
; CHECK-LABEL: vector_compress_nxv2f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, mf2, ta, ma
; CHECK-NEXT:    vcompress.vm v9, v8, v0
; CHECK-NEXT:    vmv1r.v v8, v9
; CHECK-NEXT:    ret
  %ret = call <vscale x 2 x half> @llvm.experimental.vector.compress.nxv2f16(<vscale x 2 x half> %data, <vscale x 2 x i1> %mask, <vscale x 2 x half> undef)
  ret <vscale x 2 x half> %ret
}

define <vscale x 2 x half> @vector_compress_nxv2f16_passthru(<vscale x 2 x half> %passthru, <vscale x 2 x half> %data, <vscale x 2 x i1> %mask) {
; CHECK-LABEL: vector_compress_nxv2f16_passthru:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, mf2, tu, ma
; CHECK-NEXT:    vcompress.vm v8, v9, v0
; CHECK-NEXT:    ret
  %ret = call <vscale x 2 x half> @llvm.experimental.vector.compress.nxv2f16(<vscale x 2 x half> %data, <vscale x 2 x i1> %mask, <vscale x 2 x half> %passthru)
  ret <vscale x 2 x half> %ret
}

define <vscale x 4 x half> @vector_compress_nxv4f16(<vscale x 4 x half> %data, <vscale x 4 x i1> %mask) {
; CHECK-LABEL: vector_compress_nxv4f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, m1, ta, ma
; CHECK-NEXT:    vcompress.vm v9, v8, v0
; CHECK-NEXT:    vmv.v.v v8, v9
; CHECK-NEXT:    ret
  %ret = call <vscale x 4 x half> @llvm.experimental.vector.compress.nxv4f16(<vscale x 4 x half> %data, <vscale x 4 x i1> %mask, <vscale x 4 x half> undef)
  ret <vscale x 4 x half> %ret
}

define <vscale x 4 x half> @vector_compress_nxv4f16_passthru(<vscale x 4 x half> %passthru, <vscale x 4 x half> %data, <vscale x 4 x i1> %mask) {
; CHECK-LABEL: vector_compress_nxv4f16_passthru:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, m1, tu, ma
; CHECK-NEXT:    vcompress.vm v8, v9, v0
; CHECK-NEXT:    ret
  %ret = call <vscale x 4 x half> @llvm.experimental.vector.compress.nxv4f16(<vscale x 4 x half> %data, <vscale x 4 x i1> %mask, <vscale x 4 x half> %passthru)
  ret <vscale x 4 x half> %ret
}

define <vscale x 8 x half> @vector_compress_nxv8f16(<vscale x 8 x half> %data, <vscale x 8 x i1> %mask) {
; CHECK-LABEL: vector_compress_nxv8f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, m2, ta, ma
; CHECK-NEXT:    vcompress.vm v10, v8, v0
; CHECK-NEXT:    vmv.v.v v8, v10
; CHECK-NEXT:    ret
  %ret = call <vscale x 8 x half> @llvm.experimental.vector.compress.nxv8f16(<vscale x 8 x half> %data, <vscale x 8 x i1> %mask, <vscale x 8 x half> undef)
  ret <vscale x 8 x half> %ret
}

define <vscale x 8 x half> @vector_compress_nxv8f16_passthru(<vscale x 8 x half> %passthru, <vscale x 8 x half> %data, <vscale x 8 x i1> %mask) {
; CHECK-LABEL: vector_compress_nxv8f16_passthru:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, m2, tu, ma
; CHECK-NEXT:    vcompress.vm v8, v10, v0
; CHECK-NEXT:    ret
  %ret = call <vscale x 8 x half> @llvm.experimental.vector.compress.nxv8f16(<vscale x 8 x half> %data, <vscale x 8 x i1> %mask, <vscale x 8 x half> %passthru)
  ret <vscale x 8 x half> %ret
}

define <vscale x 16 x half> @vector_compress_nxv16f16(<vscale x 16 x half> %data, <vscale x 16 x i1> %mask) {
; CHECK-LABEL: vector_compress_nxv16f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, m4, ta, ma
; CHECK-NEXT:    vcompress.vm v12, v8, v0
; CHECK-NEXT:    vmv.v.v v8, v12
; CHECK-NEXT:    ret
  %ret = call <vscale x 16 x half> @llvm.experimental.vector.compress.nxv16f16(<vscale x 16 x half> %data, <vscale x 16 x i1> %mask, <vscale x 16 x half> undef)
  ret <vscale x 16 x half> %ret
}

define <vscale x 16 x half> @vector_compress_nxv16f16_passthru(<vscale x 16 x half> %passthru, <vscale x 16 x half> %data, <vscale x 16 x i1> %mask) {
; CHECK-LABEL: vector_compress_nxv16f16_passthru:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, m4, tu, ma
; CHECK-NEXT:    vcompress.vm v8, v12, v0
; CHECK-NEXT:    ret
  %ret = call <vscale x 16 x half> @llvm.experimental.vector.compress.nxv16f16(<vscale x 16 x half> %data, <vscale x 16 x i1> %mask, <vscale x 16 x half> %passthru)
  ret <vscale x 16 x half> %ret
}

define <vscale x 32 x half> @vector_compress_nxv32f16(<vscale x 32 x half> %data, <vscale x 32 x i1> %mask) {
; CHECK-LABEL: vector_compress_nxv32f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, m8, ta, ma
; CHECK-NEXT:    vcompress.vm v16, v8, v0
; CHECK-NEXT:    vmv.v.v v8, v16
; CHECK-NEXT:    ret
  %ret = call <vscale x 32 x half> @llvm.experimental.vector.compress.nxv32f16(<vscale x 32 x half> %data, <vscale x 32 x i1> %mask, <vscale x 32 x half> undef)
  ret <vscale x 32 x half> %ret
}

define <vscale x 32 x half> @vector_compress_nxv32f16_passthru(<vscale x 32 x half> %passthru, <vscale x 32 x half> %data, <vscale x 32 x i1> %mask) {
; CHECK-LABEL: vector_compress_nxv32f16_passthru:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, m8, tu, ma
; CHECK-NEXT:    vcompress.vm v8, v16, v0
; CHECK-NEXT:    ret
  %ret = call <vscale x 32 x half> @llvm.experimental.vector.compress.nxv32f16(<vscale x 32 x half> %data, <vscale x 32 x i1> %mask, <vscale x 32 x half> %passthru)
  ret <vscale x 32 x half> %ret
}

; Vector compress for f32 type

define <vscale x 1 x float> @vector_compress_nxv1f32(<vscale x 1 x float> %data, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: vector_compress_nxv1f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, mf2, ta, ma
; CHECK-NEXT:    vcompress.vm v9, v8, v0
; CHECK-NEXT:    vmv1r.v v8, v9
; CHECK-NEXT:    ret
  %ret = call <vscale x 1 x float> @llvm.experimental.vector.compress.nxv1f32(<vscale x 1 x float> %data, <vscale x 1 x i1> %mask, <vscale x 1 x float> undef)
  ret <vscale x 1 x float> %ret
}

define <vscale x 1 x float> @vector_compress_nxv1f32_passthru(<vscale x 1 x float> %passthru, <vscale x 1 x float> %data, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: vector_compress_nxv1f32_passthru:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, mf2, tu, ma
; CHECK-NEXT:    vcompress.vm v8, v9, v0
; CHECK-NEXT:    ret
  %ret = call <vscale x 1 x float> @llvm.experimental.vector.compress.nxv1f32(<vscale x 1 x float> %data, <vscale x 1 x i1> %mask, <vscale x 1 x float> %passthru)
  ret <vscale x 1 x float> %ret
}

define <vscale x 2 x float> @vector_compress_nxv2f32(<vscale x 2 x float> %data, <vscale x 2 x i1> %mask) {
; CHECK-LABEL: vector_compress_nxv2f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m1, ta, ma
; CHECK-NEXT:    vcompress.vm v9, v8, v0
; CHECK-NEXT:    vmv.v.v v8, v9
; CHECK-NEXT:    ret
  %ret = call <vscale x 2 x float> @llvm.experimental.vector.compress.nxv2f32(<vscale x 2 x float> %data, <vscale x 2 x i1> %mask, <vscale x 2 x float> undef)
  ret <vscale x 2 x float> %ret
}

define <vscale x 2 x float> @vector_compress_nxv2f32_passthru(<vscale x 2 x float> %passthru, <vscale x 2 x float> %data, <vscale x 2 x i1> %mask) {
; CHECK-LABEL: vector_compress_nxv2f32_passthru:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m1, tu, ma
; CHECK-NEXT:    vcompress.vm v8, v9, v0
; CHECK-NEXT:    ret
  %ret = call <vscale x 2 x float> @llvm.experimental.vector.compress.nxv2f32(<vscale x 2 x float> %data, <vscale x 2 x i1> %mask, <vscale x 2 x float> %passthru)
  ret <vscale x 2 x float> %ret
}

define <vscale x 4 x float> @vector_compress_nxv4f32(<vscale x 4 x float> %data, <vscale x 4 x i1> %mask) {
; CHECK-LABEL: vector_compress_nxv4f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m2, ta, ma
; CHECK-NEXT:    vcompress.vm v10, v8, v0
; CHECK-NEXT:    vmv.v.v v8, v10
; CHECK-NEXT:    ret
  %ret = call <vscale x 4 x float> @llvm.experimental.vector.compress.nxv4f32(<vscale x 4 x float> %data, <vscale x 4 x i1> %mask, <vscale x 4 x float> undef)
  ret <vscale x 4 x float> %ret
}

define <vscale x 4 x float> @vector_compress_nxv4f32_passthru(<vscale x 4 x float> %passthru, <vscale x 4 x float> %data, <vscale x 4 x i1> %mask) {
; CHECK-LABEL: vector_compress_nxv4f32_passthru:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m2, tu, ma
; CHECK-NEXT:    vcompress.vm v8, v10, v0
; CHECK-NEXT:    ret
  %ret = call <vscale x 4 x float> @llvm.experimental.vector.compress.nxv4f32(<vscale x 4 x float> %data, <vscale x 4 x i1> %mask, <vscale x 4 x float> %passthru)
  ret <vscale x 4 x float> %ret
}

define <vscale x 8 x float> @vector_compress_nxv8f32(<vscale x 8 x float> %data, <vscale x 8 x i1> %mask) {
; CHECK-LABEL: vector_compress_nxv8f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m4, ta, ma
; CHECK-NEXT:    vcompress.vm v12, v8, v0
; CHECK-NEXT:    vmv.v.v v8, v12
; CHECK-NEXT:    ret
  %ret = call <vscale x 8 x float> @llvm.experimental.vector.compress.nxv8f32(<vscale x 8 x float> %data, <vscale x 8 x i1> %mask, <vscale x 8 x float> undef)
  ret <vscale x 8 x float> %ret
}

define <vscale x 8 x float> @vector_compress_nxv8f32_passthru(<vscale x 8 x float> %passthru, <vscale x 8 x float> %data, <vscale x 8 x i1> %mask) {
; CHECK-LABEL: vector_compress_nxv8f32_passthru:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m4, tu, ma
; CHECK-NEXT:    vcompress.vm v8, v12, v0
; CHECK-NEXT:    ret
  %ret = call <vscale x 8 x float> @llvm.experimental.vector.compress.nxv8f32(<vscale x 8 x float> %data, <vscale x 8 x i1> %mask, <vscale x 8 x float> %passthru)
  ret <vscale x 8 x float> %ret
}

define <vscale x 16 x float> @vector_compress_nxv16f32(<vscale x 16 x float> %data, <vscale x 16 x i1> %mask) {
; CHECK-LABEL: vector_compress_nxv16f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m8, ta, ma
; CHECK-NEXT:    vcompress.vm v16, v8, v0
; CHECK-NEXT:    vmv.v.v v8, v16
; CHECK-NEXT:    ret
  %ret = call <vscale x 16 x float> @llvm.experimental.vector.compress.nxv16f32(<vscale x 16 x float> %data, <vscale x 16 x i1> %mask, <vscale x 16 x float> undef)
  ret <vscale x 16 x float> %ret
}

define <vscale x 16 x float> @vector_compress_nxv16f32_passthru(<vscale x 16 x float> %passthru, <vscale x 16 x float> %data, <vscale x 16 x i1> %mask) {
; CHECK-LABEL: vector_compress_nxv16f32_passthru:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m8, tu, ma
; CHECK-NEXT:    vcompress.vm v8, v16, v0
; CHECK-NEXT:    ret
  %ret = call <vscale x 16 x float> @llvm.experimental.vector.compress.nxv16f32(<vscale x 16 x float> %data, <vscale x 16 x i1> %mask, <vscale x 16 x float> %passthru)
  ret <vscale x 16 x float> %ret
}

; Vector compress for f64 type

define <vscale x 1 x double> @vector_compress_nxv1f64(<vscale x 1 x double> %data, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: vector_compress_nxv1f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e64, m1, ta, ma
; CHECK-NEXT:    vcompress.vm v9, v8, v0
; CHECK-NEXT:    vmv.v.v v8, v9
; CHECK-NEXT:    ret
  %ret = call <vscale x 1 x double> @llvm.experimental.vector.compress.nxv1f64(<vscale x 1 x double> %data, <vscale x 1 x i1> %mask, <vscale x 1 x double> undef)
  ret <vscale x 1 x double> %ret
}

define <vscale x 1 x double> @vector_compress_nxv1f64_passthru(<vscale x 1 x double> %passthru, <vscale x 1 x double> %data, <vscale x 1 x i1> %mask) {
; CHECK-LABEL: vector_compress_nxv1f64_passthru:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e64, m1, tu, ma
; CHECK-NEXT:    vcompress.vm v8, v9, v0
; CHECK-NEXT:    ret
  %ret = call <vscale x 1 x double> @llvm.experimental.vector.compress.nxv1f64(<vscale x 1 x double> %data, <vscale x 1 x i1> %mask, <vscale x 1 x double> %passthru)
  ret <vscale x 1 x double> %ret
}

define <vscale x 2 x double> @vector_compress_nxv2f64(<vscale x 2 x double> %data, <vscale x 2 x i1> %mask) {
; CHECK-LABEL: vector_compress_nxv2f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e64, m2, ta, ma
; CHECK-NEXT:    vcompress.vm v10, v8, v0
; CHECK-NEXT:    vmv.v.v v8, v10
; CHECK-NEXT:    ret
  %ret = call <vscale x 2 x double> @llvm.experimental.vector.compress.nxv2f64(<vscale x 2 x double> %data, <vscale x 2 x i1> %mask, <vscale x 2 x double> undef)
  ret <vscale x 2 x double> %ret
}

define <vscale x 2 x double> @vector_compress_nxv2f64_passthru(<vscale x 2 x double> %passthru, <vscale x 2 x double> %data, <vscale x 2 x i1> %mask) {
; CHECK-LABEL: vector_compress_nxv2f64_passthru:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e64, m2, tu, ma
; CHECK-NEXT:    vcompress.vm v8, v10, v0
; CHECK-NEXT:    ret
  %ret = call <vscale x 2 x double> @llvm.experimental.vector.compress.nxv2f64(<vscale x 2 x double> %data, <vscale x 2 x i1> %mask, <vscale x 2 x double> %passthru)
  ret <vscale x 2 x double> %ret
}

define <vscale x 4 x double> @vector_compress_nxv4f64(<vscale x 4 x double> %data, <vscale x 4 x i1> %mask) {
; CHECK-LABEL: vector_compress_nxv4f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e64, m4, ta, ma
; CHECK-NEXT:    vcompress.vm v12, v8, v0
; CHECK-NEXT:    vmv.v.v v8, v12
; CHECK-NEXT:    ret
  %ret = call <vscale x 4 x double> @llvm.experimental.vector.compress.nxv4f64(<vscale x 4 x double> %data, <vscale x 4 x i1> %mask, <vscale x 4 x double> undef)
  ret <vscale x 4 x double> %ret
}

define <vscale x 4 x double> @vector_compress_nxv4f64_passthru(<vscale x 4 x double> %passthru, <vscale x 4 x double> %data, <vscale x 4 x i1> %mask) {
; CHECK-LABEL: vector_compress_nxv4f64_passthru:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e64, m4, tu, ma
; CHECK-NEXT:    vcompress.vm v8, v12, v0
; CHECK-NEXT:    ret
  %ret = call <vscale x 4 x double> @llvm.experimental.vector.compress.nxv4f64(<vscale x 4 x double> %data, <vscale x 4 x i1> %mask, <vscale x 4 x double> %passthru)
  ret <vscale x 4 x double> %ret
}

define <vscale x 8 x double> @vector_compress_nxv8f64(<vscale x 8 x double> %data, <vscale x 8 x i1> %mask) {
; CHECK-LABEL: vector_compress_nxv8f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e64, m8, ta, ma
; CHECK-NEXT:    vcompress.vm v16, v8, v0
; CHECK-NEXT:    vmv.v.v v8, v16
; CHECK-NEXT:    ret
  %ret = call <vscale x 8 x double> @llvm.experimental.vector.compress.nxv8f64(<vscale x 8 x double> %data, <vscale x 8 x i1> %mask, <vscale x 8 x double> undef)
  ret <vscale x 8 x double> %ret
}

define <vscale x 8 x double> @vector_compress_nxv8f64_passthru(<vscale x 8 x double> %passthru, <vscale x 8 x double> %data, <vscale x 8 x i1> %mask) {
; CHECK-LABEL: vector_compress_nxv8f64_passthru:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e64, m8, tu, ma
; CHECK-NEXT:    vcompress.vm v8, v16, v0
; CHECK-NEXT:    ret
  %ret = call <vscale x 8 x double> @llvm.experimental.vector.compress.nxv8f64(<vscale x 8 x double> %data, <vscale x 8 x i1> %mask, <vscale x 8 x double> %passthru)
  ret <vscale x 8 x double> %ret
}
