; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py UTC_ARGS: --version 2
; Verify that we handle single-element vector types correctly.

; RUN: llc < %s -mtriple=s390x-linux-gnu -mcpu=z13 | FileCheck %s

define void @f1(<1 x i128> %a, ptr %ptr) {
; CHECK-LABEL: f1:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vst %v24, 0(%r2), 3
; CHECK-NEXT:    br %r14
  store <1 x i128> %a, ptr %ptr
  ret void
}

define <1 x i128> @f2() {
; CHECK-LABEL: f2:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vgbm %v24, 0
; CHECK-NEXT:    br %r14
  ret <1 x i128><i128 0>
}

declare void @bar3(<1 x i128>)

define void @f3() {
; CHECK-LABEL: f3:
; CHECK:       # %bb.0:
; CHECK-NEXT:    stmg %r14, %r15, 112(%r15)
; CHECK-NEXT:    .cfi_offset %r14, -48
; CHECK-NEXT:    .cfi_offset %r15, -40
; CHECK-NEXT:    aghi %r15, -160
; CHECK-NEXT:    .cfi_def_cfa_offset 320
; CHECK-NEXT:    vgbm %v24, 0
; CHECK-NEXT:    brasl %r14, bar3@PLT
; CHECK-NEXT:    lmg %r14, %r15, 272(%r15)
; CHECK-NEXT:    br %r14
  call void @bar3 (<1 x i128> <i128 0>)
  ret void
}

declare <1 x i128> @bar4()

define void @f4(ptr %ptr) {
; CHECK-LABEL: f4:
; CHECK:       # %bb.0:
; CHECK-NEXT:    stmg %r13, %r15, 104(%r15)
; CHECK-NEXT:    .cfi_offset %r13, -56
; CHECK-NEXT:    .cfi_offset %r14, -48
; CHECK-NEXT:    .cfi_offset %r15, -40
; CHECK-NEXT:    aghi %r15, -160
; CHECK-NEXT:    .cfi_def_cfa_offset 320
; CHECK-NEXT:    lgr %r13, %r2
; CHECK-NEXT:    brasl %r14, bar4@PLT
; CHECK-NEXT:    vst %v24, 0(%r13), 3
; CHECK-NEXT:    lmg %r13, %r15, 264(%r15)
; CHECK-NEXT:    br %r14
  %res = call <1 x i128> @bar4 ()
  store <1 x i128> %res, ptr %ptr
  ret void
}

define void @f5(<1 x fp128> %a, ptr %ptr) {
; CHECK-LABEL: f5:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vst %v24, 0(%r2), 3
; CHECK-NEXT:    br %r14
  store <1 x fp128> %a, ptr %ptr
  ret void
}

define <1 x fp128> @f6() {
; CHECK-LABEL: f6:
; CHECK:       # %bb.0:
; CHECK-NEXT:    lzxr %f0
; CHECK-NEXT:    vmrhg %v24, %v0, %v2
; CHECK-NEXT:    br %r14
  ret <1 x fp128><fp128 0xL00000000000000000000000000000000>
}

declare void @bar7(<1 x fp128>)

define void @f7() {
; CHECK-LABEL: f7:
; CHECK:       # %bb.0:
; CHECK-NEXT:    stmg %r14, %r15, 112(%r15)
; CHECK-NEXT:    .cfi_offset %r14, -48
; CHECK-NEXT:    .cfi_offset %r15, -40
; CHECK-NEXT:    aghi %r15, -160
; CHECK-NEXT:    .cfi_def_cfa_offset 320
; CHECK-NEXT:    lzxr %f0
; CHECK-NEXT:    vmrhg %v24, %v0, %v2
; CHECK-NEXT:    brasl %r14, bar7@PLT
; CHECK-NEXT:    lmg %r14, %r15, 272(%r15)
; CHECK-NEXT:    br %r14
  call void @bar7 (<1 x fp128> <fp128 0xL00000000000000000000000000000000>)
  ret void
}

declare <1 x fp128> @bar8()

define void @f8(ptr %ptr) {
; CHECK-LABEL: f8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    stmg %r13, %r15, 104(%r15)
; CHECK-NEXT:    .cfi_offset %r13, -56
; CHECK-NEXT:    .cfi_offset %r14, -48
; CHECK-NEXT:    .cfi_offset %r15, -40
; CHECK-NEXT:    aghi %r15, -160
; CHECK-NEXT:    .cfi_def_cfa_offset 320
; CHECK-NEXT:    lgr %r13, %r2
; CHECK-NEXT:    brasl %r14, bar8@PLT
; CHECK-NEXT:    vst %v24, 0(%r13), 3
; CHECK-NEXT:    lmg %r13, %r15, 264(%r15)
; CHECK-NEXT:    br %r14
  %res = call <1 x fp128> @bar8 ()
  store <1 x fp128> %res, ptr %ptr
  ret void
}

