; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc < %s -O2 -mtriple=x86_64-linux-android \
; RUN:     -enable-legalize-types-checking | FileCheck %s --check-prefix=ANDROID
; RUN: llc < %s -O2 -mtriple=x86_64-linux-gnu \
; RUN:     -enable-legalize-types-checking | FileCheck %s --check-prefix=GNU
; RUN: llc < %s -O2 -mtriple=i686-linux-gnu -mattr=sse2 \
; RUN:     -enable-legalize-types-checking | FileCheck %s --check-prefix=X86
; RUN: llc < %s -O2 -mtriple=x86_64-pc-windows-msvc \
; RUN:     -enable-legalize-types-checking | FileCheck %s --check-prefix=WIN
; RUN: llc < %s -O2 -mtriple=i686-pc-windows-msvc \
; RUN:     -enable-legalize-types-checking | FileCheck %s --check-prefix=WIN-X86

; Check all soft floating point library function calls.

@vf64 = common dso_local global double 0.000000e+00, align 8
@vf128 = common dso_local global fp128 0xL00000000000000000000000000000000, align 16

define dso_local void @Test128Add(fp128 %d1, fp128 %d2) nounwind {
; CHECK-LABEL: Test128Add:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    pushq %rax
; CHECK-NEXT:    callq __addtf3@PLT
; CHECK-NEXT:    movaps %xmm0, vf128(%rip)
; CHECK-NEXT:    popq %rax
; CHECK-NEXT:    retq
;
; ANDROID-LABEL: Test128Add:
; ANDROID:       # %bb.0: # %entry
; ANDROID-NEXT:    pushq %rax
; ANDROID-NEXT:    callq __addtf3@PLT
; ANDROID-NEXT:    movaps %xmm0, vf128(%rip)
; ANDROID-NEXT:    popq %rax
; ANDROID-NEXT:    retq
;
; GNU-LABEL: Test128Add:
; GNU:       # %bb.0: # %entry
; GNU-NEXT:    pushq %rax
; GNU-NEXT:    callq __addtf3@PLT
; GNU-NEXT:    movaps %xmm0, vf128(%rip)
; GNU-NEXT:    popq %rax
; GNU-NEXT:    retq
;
; X86-LABEL: Test128Add:
; X86:       # %bb.0: # %entry
; X86-NEXT:    pushl %ebp
; X86-NEXT:    pushl %ebx
; X86-NEXT:    pushl %edi
; X86-NEXT:    pushl %esi
; X86-NEXT:    subl $76, %esp
; X86-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; X86-NEXT:    movl {{[0-9]+}}(%esp), %edx
; X86-NEXT:    movl {{[0-9]+}}(%esp), %esi
; X86-NEXT:    movl {{[0-9]+}}(%esp), %edi
; X86-NEXT:    movl {{[0-9]+}}(%esp), %ebx
; X86-NEXT:    movl {{[0-9]+}}(%esp), %ebp
; X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    movl %eax, {{[0-9]+}}(%esp)
; X86-NEXT:    movl %ebp, {{[0-9]+}}(%esp)
; X86-NEXT:    movl %ebx, {{[0-9]+}}(%esp)
; X86-NEXT:    movl %edi, {{[0-9]+}}(%esp)
; X86-NEXT:    movl %esi, {{[0-9]+}}(%esp)
; X86-NEXT:    movl %edx, {{[0-9]+}}(%esp)
; X86-NEXT:    movl %ecx, {{[0-9]+}}(%esp)
; X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    movl %eax, {{[0-9]+}}(%esp)
; X86-NEXT:    leal {{[0-9]+}}(%esp), %eax
; X86-NEXT:    movl %eax, (%esp)
; X86-NEXT:    calll __addtf3
; X86-NEXT:    subl $4, %esp
; X86-NEXT:    movaps {{[0-9]+}}(%esp), %xmm0
; X86-NEXT:    movaps %xmm0, vf128
; X86-NEXT:    addl $76, %esp
; X86-NEXT:    popl %esi
; X86-NEXT:    popl %edi
; X86-NEXT:    popl %ebx
; X86-NEXT:    popl %ebp
; X86-NEXT:    retl
;
; WIN-LABEL: Test128Add:
; WIN:       # %bb.0: # %entry
; WIN-NEXT:    subq $72, %rsp
; WIN-NEXT:    movaps (%rcx), %xmm0
; WIN-NEXT:    movaps (%rdx), %xmm1
; WIN-NEXT:    movaps %xmm1, {{[0-9]+}}(%rsp)
; WIN-NEXT:    movaps %xmm0, {{[0-9]+}}(%rsp)
; WIN-NEXT:    leaq {{[0-9]+}}(%rsp), %rcx
; WIN-NEXT:    leaq {{[0-9]+}}(%rsp), %rdx
; WIN-NEXT:    callq __addtf3
; WIN-NEXT:    movaps %xmm0, vf128(%rip)
; WIN-NEXT:    addq $72, %rsp
; WIN-NEXT:    retq
;
; WIN-X86-LABEL: Test128Add:
; WIN-X86:       # %bb.0: # %entry
; WIN-X86-NEXT:    pushl %ebp
; WIN-X86-NEXT:    movl %esp, %ebp
; WIN-X86-NEXT:    pushl %ebx
; WIN-X86-NEXT:    pushl %edi
; WIN-X86-NEXT:    pushl %esi
; WIN-X86-NEXT:    andl $-16, %esp
; WIN-X86-NEXT:    subl $80, %esp
; WIN-X86-NEXT:    movl 16(%ebp), %edx
; WIN-X86-NEXT:    movl 20(%ebp), %esi
; WIN-X86-NEXT:    movl 24(%ebp), %edi
; WIN-X86-NEXT:    movl 28(%ebp), %ebx
; WIN-X86-NEXT:    movl 32(%ebp), %ecx
; WIN-X86-NEXT:    movl 36(%ebp), %eax
; WIN-X86-NEXT:    movl %eax, {{[0-9]+}}(%esp)
; WIN-X86-NEXT:    movl %ecx, {{[0-9]+}}(%esp)
; WIN-X86-NEXT:    movl %ebx, {{[0-9]+}}(%esp)
; WIN-X86-NEXT:    movl %edi, {{[0-9]+}}(%esp)
; WIN-X86-NEXT:    movl %esi, {{[0-9]+}}(%esp)
; WIN-X86-NEXT:    movl %edx, {{[0-9]+}}(%esp)
; WIN-X86-NEXT:    movl 12(%ebp), %eax
; WIN-X86-NEXT:    movl %eax, {{[0-9]+}}(%esp)
; WIN-X86-NEXT:    movl 8(%ebp), %eax
; WIN-X86-NEXT:    movl %eax, {{[0-9]+}}(%esp)
; WIN-X86-NEXT:    leal {{[0-9]+}}(%esp), %eax
; WIN-X86-NEXT:    movl %eax, (%esp)
; WIN-X86-NEXT:    calll ___addtf3
; WIN-X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; WIN-X86-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; WIN-X86-NEXT:    movl {{[0-9]+}}(%esp), %edx
; WIN-X86-NEXT:    movl {{[0-9]+}}(%esp), %esi
; WIN-X86-NEXT:    movl %esi, _vf128+12
; WIN-X86-NEXT:    movl %edx, _vf128+8
; WIN-X86-NEXT:    movl %ecx, _vf128+4
; WIN-X86-NEXT:    movl %eax, _vf128
; WIN-X86-NEXT:    leal -12(%ebp), %esp
; WIN-X86-NEXT:    popl %esi
; WIN-X86-NEXT:    popl %edi
; WIN-X86-NEXT:    popl %ebx
; WIN-X86-NEXT:    popl %ebp
; WIN-X86-NEXT:    retl
entry:
  %add = fadd fp128 %d1, %d2
  store fp128 %add, ptr @vf128, align 16
  ret void
}

define dso_local void @Test128_1Add(fp128 %d1) nounwind {
; CHECK-LABEL: Test128_1Add:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    pushq %rax
; CHECK-NEXT:    movaps %xmm0, %xmm1
; CHECK-NEXT:    movaps vf128(%rip), %xmm0
; CHECK-NEXT:    callq __addtf3@PLT
; CHECK-NEXT:    movaps %xmm0, vf128(%rip)
; CHECK-NEXT:    popq %rax
; CHECK-NEXT:    retq
;
; ANDROID-LABEL: Test128_1Add:
; ANDROID:       # %bb.0: # %entry
; ANDROID-NEXT:    pushq %rax
; ANDROID-NEXT:    movaps %xmm0, %xmm1
; ANDROID-NEXT:    movaps vf128(%rip), %xmm0
; ANDROID-NEXT:    callq __addtf3@PLT
; ANDROID-NEXT:    movaps %xmm0, vf128(%rip)
; ANDROID-NEXT:    popq %rax
; ANDROID-NEXT:    retq
;
; GNU-LABEL: Test128_1Add:
; GNU:       # %bb.0: # %entry
; GNU-NEXT:    pushq %rax
; GNU-NEXT:    movaps %xmm0, %xmm1
; GNU-NEXT:    movaps vf128(%rip), %xmm0
; GNU-NEXT:    callq __addtf3@PLT
; GNU-NEXT:    movaps %xmm0, vf128(%rip)
; GNU-NEXT:    popq %rax
; GNU-NEXT:    retq
;
; X86-LABEL: Test128_1Add:
; X86:       # %bb.0: # %entry
; X86-NEXT:    pushl %ebp
; X86-NEXT:    pushl %ebx
; X86-NEXT:    pushl %edi
; X86-NEXT:    pushl %esi
; X86-NEXT:    subl $76, %esp
; X86-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; X86-NEXT:    movl {{[0-9]+}}(%esp), %edx
; X86-NEXT:    movl {{[0-9]+}}(%esp), %esi
; X86-NEXT:    movl vf128, %edi
; X86-NEXT:    movl vf128+4, %ebx
; X86-NEXT:    movl vf128+8, %ebp
; X86-NEXT:    movl vf128+12, %eax
; X86-NEXT:    movl %esi, {{[0-9]+}}(%esp)
; X86-NEXT:    movl %edx, {{[0-9]+}}(%esp)
; X86-NEXT:    movl %ecx, {{[0-9]+}}(%esp)
; X86-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; X86-NEXT:    movl %ecx, {{[0-9]+}}(%esp)
; X86-NEXT:    movl %eax, {{[0-9]+}}(%esp)
; X86-NEXT:    movl %ebp, {{[0-9]+}}(%esp)
; X86-NEXT:    movl %ebx, {{[0-9]+}}(%esp)
; X86-NEXT:    movl %edi, {{[0-9]+}}(%esp)
; X86-NEXT:    leal {{[0-9]+}}(%esp), %eax
; X86-NEXT:    movl %eax, (%esp)
; X86-NEXT:    calll __addtf3
; X86-NEXT:    subl $4, %esp
; X86-NEXT:    movaps {{[0-9]+}}(%esp), %xmm0
; X86-NEXT:    movaps %xmm0, vf128
; X86-NEXT:    addl $76, %esp
; X86-NEXT:    popl %esi
; X86-NEXT:    popl %edi
; X86-NEXT:    popl %ebx
; X86-NEXT:    popl %ebp
; X86-NEXT:    retl
;
; WIN-LABEL: Test128_1Add:
; WIN:       # %bb.0: # %entry
; WIN-NEXT:    subq $72, %rsp
; WIN-NEXT:    movaps (%rcx), %xmm0
; WIN-NEXT:    movaps vf128(%rip), %xmm1
; WIN-NEXT:    movaps %xmm1, {{[0-9]+}}(%rsp)
; WIN-NEXT:    movaps %xmm0, {{[0-9]+}}(%rsp)
; WIN-NEXT:    leaq {{[0-9]+}}(%rsp), %rcx
; WIN-NEXT:    leaq {{[0-9]+}}(%rsp), %rdx
; WIN-NEXT:    callq __addtf3
; WIN-NEXT:    movaps %xmm0, vf128(%rip)
; WIN-NEXT:    addq $72, %rsp
; WIN-NEXT:    retq
;
; WIN-X86-LABEL: Test128_1Add:
; WIN-X86:       # %bb.0: # %entry
; WIN-X86-NEXT:    pushl %ebp
; WIN-X86-NEXT:    movl %esp, %ebp
; WIN-X86-NEXT:    pushl %ebx
; WIN-X86-NEXT:    pushl %edi
; WIN-X86-NEXT:    pushl %esi
; WIN-X86-NEXT:    andl $-16, %esp
; WIN-X86-NEXT:    subl $80, %esp
; WIN-X86-NEXT:    movl 16(%ebp), %esi
; WIN-X86-NEXT:    movl 20(%ebp), %edi
; WIN-X86-NEXT:    movl _vf128, %edx
; WIN-X86-NEXT:    movl _vf128+4, %ebx
; WIN-X86-NEXT:    movl _vf128+8, %ecx
; WIN-X86-NEXT:    movl _vf128+12, %eax
; WIN-X86-NEXT:    movl %edi, {{[0-9]+}}(%esp)
; WIN-X86-NEXT:    movl %esi, {{[0-9]+}}(%esp)
; WIN-X86-NEXT:    movl 12(%ebp), %esi
; WIN-X86-NEXT:    movl %esi, {{[0-9]+}}(%esp)
; WIN-X86-NEXT:    movl 8(%ebp), %esi
; WIN-X86-NEXT:    movl %esi, {{[0-9]+}}(%esp)
; WIN-X86-NEXT:    movl %eax, {{[0-9]+}}(%esp)
; WIN-X86-NEXT:    movl %ecx, {{[0-9]+}}(%esp)
; WIN-X86-NEXT:    movl %ebx, {{[0-9]+}}(%esp)
; WIN-X86-NEXT:    movl %edx, {{[0-9]+}}(%esp)
; WIN-X86-NEXT:    leal {{[0-9]+}}(%esp), %eax
; WIN-X86-NEXT:    movl %eax, (%esp)
; WIN-X86-NEXT:    calll ___addtf3
; WIN-X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; WIN-X86-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; WIN-X86-NEXT:    movl {{[0-9]+}}(%esp), %edx
; WIN-X86-NEXT:    movl {{[0-9]+}}(%esp), %esi
; WIN-X86-NEXT:    movl %esi, _vf128+8
; WIN-X86-NEXT:    movl %edx, _vf128+12
; WIN-X86-NEXT:    movl %eax, _vf128
; WIN-X86-NEXT:    movl %ecx, _vf128+4
; WIN-X86-NEXT:    leal -12(%ebp), %esp
; WIN-X86-NEXT:    popl %esi
; WIN-X86-NEXT:    popl %edi
; WIN-X86-NEXT:    popl %ebx
; WIN-X86-NEXT:    popl %ebp
; WIN-X86-NEXT:    retl
entry:
  %0 = load fp128, ptr @vf128, align 16
  %add = fadd fp128 %0, %d1
  store fp128 %add, ptr @vf128, align 16
  ret void
}

define dso_local void @Test128Sub(fp128 %d1, fp128 %d2) nounwind {
; CHECK-LABEL: Test128Sub:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    pushq %rax
; CHECK-NEXT:    callq __subtf3@PLT
; CHECK-NEXT:    movaps %xmm0, vf128(%rip)
; CHECK-NEXT:    popq %rax
; CHECK-NEXT:    retq
;
; ANDROID-LABEL: Test128Sub:
; ANDROID:       # %bb.0: # %entry
; ANDROID-NEXT:    pushq %rax
; ANDROID-NEXT:    callq __subtf3@PLT
; ANDROID-NEXT:    movaps %xmm0, vf128(%rip)
; ANDROID-NEXT:    popq %rax
; ANDROID-NEXT:    retq
;
; GNU-LABEL: Test128Sub:
; GNU:       # %bb.0: # %entry
; GNU-NEXT:    pushq %rax
; GNU-NEXT:    callq __subtf3@PLT
; GNU-NEXT:    movaps %xmm0, vf128(%rip)
; GNU-NEXT:    popq %rax
; GNU-NEXT:    retq
;
; X86-LABEL: Test128Sub:
; X86:       # %bb.0: # %entry
; X86-NEXT:    pushl %ebp
; X86-NEXT:    pushl %ebx
; X86-NEXT:    pushl %edi
; X86-NEXT:    pushl %esi
; X86-NEXT:    subl $76, %esp
; X86-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; X86-NEXT:    movl {{[0-9]+}}(%esp), %edx
; X86-NEXT:    movl {{[0-9]+}}(%esp), %esi
; X86-NEXT:    movl {{[0-9]+}}(%esp), %edi
; X86-NEXT:    movl {{[0-9]+}}(%esp), %ebx
; X86-NEXT:    movl {{[0-9]+}}(%esp), %ebp
; X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    movl %eax, {{[0-9]+}}(%esp)
; X86-NEXT:    movl %ebp, {{[0-9]+}}(%esp)
; X86-NEXT:    movl %ebx, {{[0-9]+}}(%esp)
; X86-NEXT:    movl %edi, {{[0-9]+}}(%esp)
; X86-NEXT:    movl %esi, {{[0-9]+}}(%esp)
; X86-NEXT:    movl %edx, {{[0-9]+}}(%esp)
; X86-NEXT:    movl %ecx, {{[0-9]+}}(%esp)
; X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    movl %eax, {{[0-9]+}}(%esp)
; X86-NEXT:    leal {{[0-9]+}}(%esp), %eax
; X86-NEXT:    movl %eax, (%esp)
; X86-NEXT:    calll __subtf3
; X86-NEXT:    subl $4, %esp
; X86-NEXT:    movaps {{[0-9]+}}(%esp), %xmm0
; X86-NEXT:    movaps %xmm0, vf128
; X86-NEXT:    addl $76, %esp
; X86-NEXT:    popl %esi
; X86-NEXT:    popl %edi
; X86-NEXT:    popl %ebx
; X86-NEXT:    popl %ebp
; X86-NEXT:    retl
;
; WIN-LABEL: Test128Sub:
; WIN:       # %bb.0: # %entry
; WIN-NEXT:    subq $72, %rsp
; WIN-NEXT:    movaps (%rcx), %xmm0
; WIN-NEXT:    movaps (%rdx), %xmm1
; WIN-NEXT:    movaps %xmm1, {{[0-9]+}}(%rsp)
; WIN-NEXT:    movaps %xmm0, {{[0-9]+}}(%rsp)
; WIN-NEXT:    leaq {{[0-9]+}}(%rsp), %rcx
; WIN-NEXT:    leaq {{[0-9]+}}(%rsp), %rdx
; WIN-NEXT:    callq __subtf3
; WIN-NEXT:    movaps %xmm0, vf128(%rip)
; WIN-NEXT:    addq $72, %rsp
; WIN-NEXT:    retq
;
; WIN-X86-LABEL: Test128Sub:
; WIN-X86:       # %bb.0: # %entry
; WIN-X86-NEXT:    pushl %ebp
; WIN-X86-NEXT:    movl %esp, %ebp
; WIN-X86-NEXT:    pushl %ebx
; WIN-X86-NEXT:    pushl %edi
; WIN-X86-NEXT:    pushl %esi
; WIN-X86-NEXT:    andl $-16, %esp
; WIN-X86-NEXT:    subl $80, %esp
; WIN-X86-NEXT:    movl 16(%ebp), %edx
; WIN-X86-NEXT:    movl 20(%ebp), %esi
; WIN-X86-NEXT:    movl 24(%ebp), %edi
; WIN-X86-NEXT:    movl 28(%ebp), %ebx
; WIN-X86-NEXT:    movl 32(%ebp), %ecx
; WIN-X86-NEXT:    movl 36(%ebp), %eax
; WIN-X86-NEXT:    movl %eax, {{[0-9]+}}(%esp)
; WIN-X86-NEXT:    movl %ecx, {{[0-9]+}}(%esp)
; WIN-X86-NEXT:    movl %ebx, {{[0-9]+}}(%esp)
; WIN-X86-NEXT:    movl %edi, {{[0-9]+}}(%esp)
; WIN-X86-NEXT:    movl %esi, {{[0-9]+}}(%esp)
; WIN-X86-NEXT:    movl %edx, {{[0-9]+}}(%esp)
; WIN-X86-NEXT:    movl 12(%ebp), %eax
; WIN-X86-NEXT:    movl %eax, {{[0-9]+}}(%esp)
; WIN-X86-NEXT:    movl 8(%ebp), %eax
; WIN-X86-NEXT:    movl %eax, {{[0-9]+}}(%esp)
; WIN-X86-NEXT:    leal {{[0-9]+}}(%esp), %eax
; WIN-X86-NEXT:    movl %eax, (%esp)
; WIN-X86-NEXT:    calll ___subtf3
; WIN-X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; WIN-X86-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; WIN-X86-NEXT:    movl {{[0-9]+}}(%esp), %edx
; WIN-X86-NEXT:    movl {{[0-9]+}}(%esp), %esi
; WIN-X86-NEXT:    movl %esi, _vf128+12
; WIN-X86-NEXT:    movl %edx, _vf128+8
; WIN-X86-NEXT:    movl %ecx, _vf128+4
; WIN-X86-NEXT:    movl %eax, _vf128
; WIN-X86-NEXT:    leal -12(%ebp), %esp
; WIN-X86-NEXT:    popl %esi
; WIN-X86-NEXT:    popl %edi
; WIN-X86-NEXT:    popl %ebx
; WIN-X86-NEXT:    popl %ebp
; WIN-X86-NEXT:    retl
entry:
  %sub = fsub fp128 %d1, %d2
  store fp128 %sub, ptr @vf128, align 16
  ret void
}

define dso_local void @Test128_1Sub(fp128 %d1) nounwind {
; CHECK-LABEL: Test128_1Sub:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    pushq %rax
; CHECK-NEXT:    movaps %xmm0, %xmm1
; CHECK-NEXT:    movaps vf128(%rip), %xmm0
; CHECK-NEXT:    callq __subtf3@PLT
; CHECK-NEXT:    movaps %xmm0, vf128(%rip)
; CHECK-NEXT:    popq %rax
; CHECK-NEXT:    retq
;
; ANDROID-LABEL: Test128_1Sub:
; ANDROID:       # %bb.0: # %entry
; ANDROID-NEXT:    pushq %rax
; ANDROID-NEXT:    movaps %xmm0, %xmm1
; ANDROID-NEXT:    movaps vf128(%rip), %xmm0
; ANDROID-NEXT:    callq __subtf3@PLT
; ANDROID-NEXT:    movaps %xmm0, vf128(%rip)
; ANDROID-NEXT:    popq %rax
; ANDROID-NEXT:    retq
;
; GNU-LABEL: Test128_1Sub:
; GNU:       # %bb.0: # %entry
; GNU-NEXT:    pushq %rax
; GNU-NEXT:    movaps %xmm0, %xmm1
; GNU-NEXT:    movaps vf128(%rip), %xmm0
; GNU-NEXT:    callq __subtf3@PLT
; GNU-NEXT:    movaps %xmm0, vf128(%rip)
; GNU-NEXT:    popq %rax
; GNU-NEXT:    retq
;
; X86-LABEL: Test128_1Sub:
; X86:       # %bb.0: # %entry
; X86-NEXT:    pushl %ebp
; X86-NEXT:    pushl %ebx
; X86-NEXT:    pushl %edi
; X86-NEXT:    pushl %esi
; X86-NEXT:    subl $76, %esp
; X86-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; X86-NEXT:    movl {{[0-9]+}}(%esp), %edx
; X86-NEXT:    movl {{[0-9]+}}(%esp), %esi
; X86-NEXT:    movl vf128, %edi
; X86-NEXT:    movl vf128+4, %ebx
; X86-NEXT:    movl vf128+8, %ebp
; X86-NEXT:    movl vf128+12, %eax
; X86-NEXT:    movl %esi, {{[0-9]+}}(%esp)
; X86-NEXT:    movl %edx, {{[0-9]+}}(%esp)
; X86-NEXT:    movl %ecx, {{[0-9]+}}(%esp)
; X86-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; X86-NEXT:    movl %ecx, {{[0-9]+}}(%esp)
; X86-NEXT:    movl %eax, {{[0-9]+}}(%esp)
; X86-NEXT:    movl %ebp, {{[0-9]+}}(%esp)
; X86-NEXT:    movl %ebx, {{[0-9]+}}(%esp)
; X86-NEXT:    movl %edi, {{[0-9]+}}(%esp)
; X86-NEXT:    leal {{[0-9]+}}(%esp), %eax
; X86-NEXT:    movl %eax, (%esp)
; X86-NEXT:    calll __subtf3
; X86-NEXT:    subl $4, %esp
; X86-NEXT:    movaps {{[0-9]+}}(%esp), %xmm0
; X86-NEXT:    movaps %xmm0, vf128
; X86-NEXT:    addl $76, %esp
; X86-NEXT:    popl %esi
; X86-NEXT:    popl %edi
; X86-NEXT:    popl %ebx
; X86-NEXT:    popl %ebp
; X86-NEXT:    retl
;
; WIN-LABEL: Test128_1Sub:
; WIN:       # %bb.0: # %entry
; WIN-NEXT:    subq $72, %rsp
; WIN-NEXT:    movaps (%rcx), %xmm0
; WIN-NEXT:    movaps vf128(%rip), %xmm1
; WIN-NEXT:    movaps %xmm1, {{[0-9]+}}(%rsp)
; WIN-NEXT:    movaps %xmm0, {{[0-9]+}}(%rsp)
; WIN-NEXT:    leaq {{[0-9]+}}(%rsp), %rcx
; WIN-NEXT:    leaq {{[0-9]+}}(%rsp), %rdx
; WIN-NEXT:    callq __subtf3
; WIN-NEXT:    movaps %xmm0, vf128(%rip)
; WIN-NEXT:    addq $72, %rsp
; WIN-NEXT:    retq
;
; WIN-X86-LABEL: Test128_1Sub:
; WIN-X86:       # %bb.0: # %entry
; WIN-X86-NEXT:    pushl %ebp
; WIN-X86-NEXT:    movl %esp, %ebp
; WIN-X86-NEXT:    pushl %ebx
; WIN-X86-NEXT:    pushl %edi
; WIN-X86-NEXT:    pushl %esi
; WIN-X86-NEXT:    andl $-16, %esp
; WIN-X86-NEXT:    subl $80, %esp
; WIN-X86-NEXT:    movl 16(%ebp), %esi
; WIN-X86-NEXT:    movl 20(%ebp), %edi
; WIN-X86-NEXT:    movl _vf128, %edx
; WIN-X86-NEXT:    movl _vf128+4, %ebx
; WIN-X86-NEXT:    movl _vf128+8, %ecx
; WIN-X86-NEXT:    movl _vf128+12, %eax
; WIN-X86-NEXT:    movl %edi, {{[0-9]+}}(%esp)
; WIN-X86-NEXT:    movl %esi, {{[0-9]+}}(%esp)
; WIN-X86-NEXT:    movl 12(%ebp), %esi
; WIN-X86-NEXT:    movl %esi, {{[0-9]+}}(%esp)
; WIN-X86-NEXT:    movl 8(%ebp), %esi
; WIN-X86-NEXT:    movl %esi, {{[0-9]+}}(%esp)
; WIN-X86-NEXT:    movl %eax, {{[0-9]+}}(%esp)
; WIN-X86-NEXT:    movl %ecx, {{[0-9]+}}(%esp)
; WIN-X86-NEXT:    movl %ebx, {{[0-9]+}}(%esp)
; WIN-X86-NEXT:    movl %edx, {{[0-9]+}}(%esp)
; WIN-X86-NEXT:    leal {{[0-9]+}}(%esp), %eax
; WIN-X86-NEXT:    movl %eax, (%esp)
; WIN-X86-NEXT:    calll ___subtf3
; WIN-X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; WIN-X86-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; WIN-X86-NEXT:    movl {{[0-9]+}}(%esp), %edx
; WIN-X86-NEXT:    movl {{[0-9]+}}(%esp), %esi
; WIN-X86-NEXT:    movl %esi, _vf128+8
; WIN-X86-NEXT:    movl %edx, _vf128+12
; WIN-X86-NEXT:    movl %eax, _vf128
; WIN-X86-NEXT:    movl %ecx, _vf128+4
; WIN-X86-NEXT:    leal -12(%ebp), %esp
; WIN-X86-NEXT:    popl %esi
; WIN-X86-NEXT:    popl %edi
; WIN-X86-NEXT:    popl %ebx
; WIN-X86-NEXT:    popl %ebp
; WIN-X86-NEXT:    retl
entry:
  %0 = load fp128, ptr @vf128, align 16
  %sub = fsub fp128 %0, %d1
  store fp128 %sub, ptr @vf128, align 16
  ret void
}

define dso_local void @Test128Mul(fp128 %d1, fp128 %d2) nounwind {
; CHECK-LABEL: Test128Mul:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    pushq %rax
; CHECK-NEXT:    callq __multf3@PLT
; CHECK-NEXT:    movaps %xmm0, vf128(%rip)
; CHECK-NEXT:    popq %rax
; CHECK-NEXT:    retq
;
; ANDROID-LABEL: Test128Mul:
; ANDROID:       # %bb.0: # %entry
; ANDROID-NEXT:    pushq %rax
; ANDROID-NEXT:    callq __multf3@PLT
; ANDROID-NEXT:    movaps %xmm0, vf128(%rip)
; ANDROID-NEXT:    popq %rax
; ANDROID-NEXT:    retq
;
; GNU-LABEL: Test128Mul:
; GNU:       # %bb.0: # %entry
; GNU-NEXT:    pushq %rax
; GNU-NEXT:    callq __multf3@PLT
; GNU-NEXT:    movaps %xmm0, vf128(%rip)
; GNU-NEXT:    popq %rax
; GNU-NEXT:    retq
;
; X86-LABEL: Test128Mul:
; X86:       # %bb.0: # %entry
; X86-NEXT:    pushl %ebp
; X86-NEXT:    pushl %ebx
; X86-NEXT:    pushl %edi
; X86-NEXT:    pushl %esi
; X86-NEXT:    subl $76, %esp
; X86-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; X86-NEXT:    movl {{[0-9]+}}(%esp), %edx
; X86-NEXT:    movl {{[0-9]+}}(%esp), %esi
; X86-NEXT:    movl {{[0-9]+}}(%esp), %edi
; X86-NEXT:    movl {{[0-9]+}}(%esp), %ebx
; X86-NEXT:    movl {{[0-9]+}}(%esp), %ebp
; X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    movl %eax, {{[0-9]+}}(%esp)
; X86-NEXT:    movl %ebp, {{[0-9]+}}(%esp)
; X86-NEXT:    movl %ebx, {{[0-9]+}}(%esp)
; X86-NEXT:    movl %edi, {{[0-9]+}}(%esp)
; X86-NEXT:    movl %esi, {{[0-9]+}}(%esp)
; X86-NEXT:    movl %edx, {{[0-9]+}}(%esp)
; X86-NEXT:    movl %ecx, {{[0-9]+}}(%esp)
; X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    movl %eax, {{[0-9]+}}(%esp)
; X86-NEXT:    leal {{[0-9]+}}(%esp), %eax
; X86-NEXT:    movl %eax, (%esp)
; X86-NEXT:    calll __multf3
; X86-NEXT:    subl $4, %esp
; X86-NEXT:    movaps {{[0-9]+}}(%esp), %xmm0
; X86-NEXT:    movaps %xmm0, vf128
; X86-NEXT:    addl $76, %esp
; X86-NEXT:    popl %esi
; X86-NEXT:    popl %edi
; X86-NEXT:    popl %ebx
; X86-NEXT:    popl %ebp
; X86-NEXT:    retl
;
; WIN-LABEL: Test128Mul:
; WIN:       # %bb.0: # %entry
; WIN-NEXT:    subq $72, %rsp
; WIN-NEXT:    movaps (%rcx), %xmm0
; WIN-NEXT:    movaps (%rdx), %xmm1
; WIN-NEXT:    movaps %xmm1, {{[0-9]+}}(%rsp)
; WIN-NEXT:    movaps %xmm0, {{[0-9]+}}(%rsp)
; WIN-NEXT:    leaq {{[0-9]+}}(%rsp), %rcx
; WIN-NEXT:    leaq {{[0-9]+}}(%rsp), %rdx
; WIN-NEXT:    callq __multf3
; WIN-NEXT:    movaps %xmm0, vf128(%rip)
; WIN-NEXT:    addq $72, %rsp
; WIN-NEXT:    retq
;
; WIN-X86-LABEL: Test128Mul:
; WIN-X86:       # %bb.0: # %entry
; WIN-X86-NEXT:    pushl %ebp
; WIN-X86-NEXT:    movl %esp, %ebp
; WIN-X86-NEXT:    pushl %ebx
; WIN-X86-NEXT:    pushl %edi
; WIN-X86-NEXT:    pushl %esi
; WIN-X86-NEXT:    andl $-16, %esp
; WIN-X86-NEXT:    subl $80, %esp
; WIN-X86-NEXT:    movl 16(%ebp), %edx
; WIN-X86-NEXT:    movl 20(%ebp), %esi
; WIN-X86-NEXT:    movl 24(%ebp), %edi
; WIN-X86-NEXT:    movl 28(%ebp), %ebx
; WIN-X86-NEXT:    movl 32(%ebp), %ecx
; WIN-X86-NEXT:    movl 36(%ebp), %eax
; WIN-X86-NEXT:    movl %eax, {{[0-9]+}}(%esp)
; WIN-X86-NEXT:    movl %ecx, {{[0-9]+}}(%esp)
; WIN-X86-NEXT:    movl %ebx, {{[0-9]+}}(%esp)
; WIN-X86-NEXT:    movl %edi, {{[0-9]+}}(%esp)
; WIN-X86-NEXT:    movl %esi, {{[0-9]+}}(%esp)
; WIN-X86-NEXT:    movl %edx, {{[0-9]+}}(%esp)
; WIN-X86-NEXT:    movl 12(%ebp), %eax
; WIN-X86-NEXT:    movl %eax, {{[0-9]+}}(%esp)
; WIN-X86-NEXT:    movl 8(%ebp), %eax
; WIN-X86-NEXT:    movl %eax, {{[0-9]+}}(%esp)
; WIN-X86-NEXT:    leal {{[0-9]+}}(%esp), %eax
; WIN-X86-NEXT:    movl %eax, (%esp)
; WIN-X86-NEXT:    calll ___multf3
; WIN-X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; WIN-X86-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; WIN-X86-NEXT:    movl {{[0-9]+}}(%esp), %edx
; WIN-X86-NEXT:    movl {{[0-9]+}}(%esp), %esi
; WIN-X86-NEXT:    movl %esi, _vf128+12
; WIN-X86-NEXT:    movl %edx, _vf128+8
; WIN-X86-NEXT:    movl %ecx, _vf128+4
; WIN-X86-NEXT:    movl %eax, _vf128
; WIN-X86-NEXT:    leal -12(%ebp), %esp
; WIN-X86-NEXT:    popl %esi
; WIN-X86-NEXT:    popl %edi
; WIN-X86-NEXT:    popl %ebx
; WIN-X86-NEXT:    popl %ebp
; WIN-X86-NEXT:    retl
entry:
  %mul = fmul fp128 %d1, %d2
  store fp128 %mul, ptr @vf128, align 16
  ret void
}

define dso_local void @Test128_1Mul(fp128 %d1) nounwind {
; CHECK-LABEL: Test128_1Mul:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    pushq %rax
; CHECK-NEXT:    movaps %xmm0, %xmm1
; CHECK-NEXT:    movaps vf128(%rip), %xmm0
; CHECK-NEXT:    callq __multf3@PLT
; CHECK-NEXT:    movaps %xmm0, vf128(%rip)
; CHECK-NEXT:    popq %rax
; CHECK-NEXT:    retq
;
; ANDROID-LABEL: Test128_1Mul:
; ANDROID:       # %bb.0: # %entry
; ANDROID-NEXT:    pushq %rax
; ANDROID-NEXT:    movaps %xmm0, %xmm1
; ANDROID-NEXT:    movaps vf128(%rip), %xmm0
; ANDROID-NEXT:    callq __multf3@PLT
; ANDROID-NEXT:    movaps %xmm0, vf128(%rip)
; ANDROID-NEXT:    popq %rax
; ANDROID-NEXT:    retq
;
; GNU-LABEL: Test128_1Mul:
; GNU:       # %bb.0: # %entry
; GNU-NEXT:    pushq %rax
; GNU-NEXT:    movaps %xmm0, %xmm1
; GNU-NEXT:    movaps vf128(%rip), %xmm0
; GNU-NEXT:    callq __multf3@PLT
; GNU-NEXT:    movaps %xmm0, vf128(%rip)
; GNU-NEXT:    popq %rax
; GNU-NEXT:    retq
;
; X86-LABEL: Test128_1Mul:
; X86:       # %bb.0: # %entry
; X86-NEXT:    pushl %ebp
; X86-NEXT:    pushl %ebx
; X86-NEXT:    pushl %edi
; X86-NEXT:    pushl %esi
; X86-NEXT:    subl $76, %esp
; X86-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; X86-NEXT:    movl {{[0-9]+}}(%esp), %edx
; X86-NEXT:    movl {{[0-9]+}}(%esp), %esi
; X86-NEXT:    movl vf128, %edi
; X86-NEXT:    movl vf128+4, %ebx
; X86-NEXT:    movl vf128+8, %ebp
; X86-NEXT:    movl vf128+12, %eax
; X86-NEXT:    movl %esi, {{[0-9]+}}(%esp)
; X86-NEXT:    movl %edx, {{[0-9]+}}(%esp)
; X86-NEXT:    movl %ecx, {{[0-9]+}}(%esp)
; X86-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; X86-NEXT:    movl %ecx, {{[0-9]+}}(%esp)
; X86-NEXT:    movl %eax, {{[0-9]+}}(%esp)
; X86-NEXT:    movl %ebp, {{[0-9]+}}(%esp)
; X86-NEXT:    movl %ebx, {{[0-9]+}}(%esp)
; X86-NEXT:    movl %edi, {{[0-9]+}}(%esp)
; X86-NEXT:    leal {{[0-9]+}}(%esp), %eax
; X86-NEXT:    movl %eax, (%esp)
; X86-NEXT:    calll __multf3
; X86-NEXT:    subl $4, %esp
; X86-NEXT:    movaps {{[0-9]+}}(%esp), %xmm0
; X86-NEXT:    movaps %xmm0, vf128
; X86-NEXT:    addl $76, %esp
; X86-NEXT:    popl %esi
; X86-NEXT:    popl %edi
; X86-NEXT:    popl %ebx
; X86-NEXT:    popl %ebp
; X86-NEXT:    retl
;
; WIN-LABEL: Test128_1Mul:
; WIN:       # %bb.0: # %entry
; WIN-NEXT:    subq $72, %rsp
; WIN-NEXT:    movaps (%rcx), %xmm0
; WIN-NEXT:    movaps vf128(%rip), %xmm1
; WIN-NEXT:    movaps %xmm1, {{[0-9]+}}(%rsp)
; WIN-NEXT:    movaps %xmm0, {{[0-9]+}}(%rsp)
; WIN-NEXT:    leaq {{[0-9]+}}(%rsp), %rcx
; WIN-NEXT:    leaq {{[0-9]+}}(%rsp), %rdx
; WIN-NEXT:    callq __multf3
; WIN-NEXT:    movaps %xmm0, vf128(%rip)
; WIN-NEXT:    addq $72, %rsp
; WIN-NEXT:    retq
;
; WIN-X86-LABEL: Test128_1Mul:
; WIN-X86:       # %bb.0: # %entry
; WIN-X86-NEXT:    pushl %ebp
; WIN-X86-NEXT:    movl %esp, %ebp
; WIN-X86-NEXT:    pushl %ebx
; WIN-X86-NEXT:    pushl %edi
; WIN-X86-NEXT:    pushl %esi
; WIN-X86-NEXT:    andl $-16, %esp
; WIN-X86-NEXT:    subl $80, %esp
; WIN-X86-NEXT:    movl 16(%ebp), %esi
; WIN-X86-NEXT:    movl 20(%ebp), %edi
; WIN-X86-NEXT:    movl _vf128, %edx
; WIN-X86-NEXT:    movl _vf128+4, %ebx
; WIN-X86-NEXT:    movl _vf128+8, %ecx
; WIN-X86-NEXT:    movl _vf128+12, %eax
; WIN-X86-NEXT:    movl %edi, {{[0-9]+}}(%esp)
; WIN-X86-NEXT:    movl %esi, {{[0-9]+}}(%esp)
; WIN-X86-NEXT:    movl 12(%ebp), %esi
; WIN-X86-NEXT:    movl %esi, {{[0-9]+}}(%esp)
; WIN-X86-NEXT:    movl 8(%ebp), %esi
; WIN-X86-NEXT:    movl %esi, {{[0-9]+}}(%esp)
; WIN-X86-NEXT:    movl %eax, {{[0-9]+}}(%esp)
; WIN-X86-NEXT:    movl %ecx, {{[0-9]+}}(%esp)
; WIN-X86-NEXT:    movl %ebx, {{[0-9]+}}(%esp)
; WIN-X86-NEXT:    movl %edx, {{[0-9]+}}(%esp)
; WIN-X86-NEXT:    leal {{[0-9]+}}(%esp), %eax
; WIN-X86-NEXT:    movl %eax, (%esp)
; WIN-X86-NEXT:    calll ___multf3
; WIN-X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; WIN-X86-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; WIN-X86-NEXT:    movl {{[0-9]+}}(%esp), %edx
; WIN-X86-NEXT:    movl {{[0-9]+}}(%esp), %esi
; WIN-X86-NEXT:    movl %esi, _vf128+8
; WIN-X86-NEXT:    movl %edx, _vf128+12
; WIN-X86-NEXT:    movl %eax, _vf128
; WIN-X86-NEXT:    movl %ecx, _vf128+4
; WIN-X86-NEXT:    leal -12(%ebp), %esp
; WIN-X86-NEXT:    popl %esi
; WIN-X86-NEXT:    popl %edi
; WIN-X86-NEXT:    popl %ebx
; WIN-X86-NEXT:    popl %ebp
; WIN-X86-NEXT:    retl
entry:
  %0 = load fp128, ptr @vf128, align 16
  %mul = fmul fp128 %0, %d1
  store fp128 %mul, ptr @vf128, align 16
  ret void
}

define dso_local void @Test128Div(fp128 %d1, fp128 %d2) nounwind {
; CHECK-LABEL: Test128Div:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    pushq %rax
; CHECK-NEXT:    callq __divtf3@PLT
; CHECK-NEXT:    movaps %xmm0, vf128(%rip)
; CHECK-NEXT:    popq %rax
; CHECK-NEXT:    retq
;
; ANDROID-LABEL: Test128Div:
; ANDROID:       # %bb.0: # %entry
; ANDROID-NEXT:    pushq %rax
; ANDROID-NEXT:    callq __divtf3@PLT
; ANDROID-NEXT:    movaps %xmm0, vf128(%rip)
; ANDROID-NEXT:    popq %rax
; ANDROID-NEXT:    retq
;
; GNU-LABEL: Test128Div:
; GNU:       # %bb.0: # %entry
; GNU-NEXT:    pushq %rax
; GNU-NEXT:    callq __divtf3@PLT
; GNU-NEXT:    movaps %xmm0, vf128(%rip)
; GNU-NEXT:    popq %rax
; GNU-NEXT:    retq
;
; X86-LABEL: Test128Div:
; X86:       # %bb.0: # %entry
; X86-NEXT:    pushl %ebp
; X86-NEXT:    pushl %ebx
; X86-NEXT:    pushl %edi
; X86-NEXT:    pushl %esi
; X86-NEXT:    subl $76, %esp
; X86-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; X86-NEXT:    movl {{[0-9]+}}(%esp), %edx
; X86-NEXT:    movl {{[0-9]+}}(%esp), %esi
; X86-NEXT:    movl {{[0-9]+}}(%esp), %edi
; X86-NEXT:    movl {{[0-9]+}}(%esp), %ebx
; X86-NEXT:    movl {{[0-9]+}}(%esp), %ebp
; X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    movl %eax, {{[0-9]+}}(%esp)
; X86-NEXT:    movl %ebp, {{[0-9]+}}(%esp)
; X86-NEXT:    movl %ebx, {{[0-9]+}}(%esp)
; X86-NEXT:    movl %edi, {{[0-9]+}}(%esp)
; X86-NEXT:    movl %esi, {{[0-9]+}}(%esp)
; X86-NEXT:    movl %edx, {{[0-9]+}}(%esp)
; X86-NEXT:    movl %ecx, {{[0-9]+}}(%esp)
; X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    movl %eax, {{[0-9]+}}(%esp)
; X86-NEXT:    leal {{[0-9]+}}(%esp), %eax
; X86-NEXT:    movl %eax, (%esp)
; X86-NEXT:    calll __divtf3
; X86-NEXT:    subl $4, %esp
; X86-NEXT:    movaps {{[0-9]+}}(%esp), %xmm0
; X86-NEXT:    movaps %xmm0, vf128
; X86-NEXT:    addl $76, %esp
; X86-NEXT:    popl %esi
; X86-NEXT:    popl %edi
; X86-NEXT:    popl %ebx
; X86-NEXT:    popl %ebp
; X86-NEXT:    retl
;
; WIN-LABEL: Test128Div:
; WIN:       # %bb.0: # %entry
; WIN-NEXT:    subq $72, %rsp
; WIN-NEXT:    movaps (%rcx), %xmm0
; WIN-NEXT:    movaps (%rdx), %xmm1
; WIN-NEXT:    movaps %xmm1, {{[0-9]+}}(%rsp)
; WIN-NEXT:    movaps %xmm0, {{[0-9]+}}(%rsp)
; WIN-NEXT:    leaq {{[0-9]+}}(%rsp), %rcx
; WIN-NEXT:    leaq {{[0-9]+}}(%rsp), %rdx
; WIN-NEXT:    callq __divtf3
; WIN-NEXT:    movaps %xmm0, vf128(%rip)
; WIN-NEXT:    addq $72, %rsp
; WIN-NEXT:    retq
;
; WIN-X86-LABEL: Test128Div:
; WIN-X86:       # %bb.0: # %entry
; WIN-X86-NEXT:    pushl %ebp
; WIN-X86-NEXT:    movl %esp, %ebp
; WIN-X86-NEXT:    pushl %ebx
; WIN-X86-NEXT:    pushl %edi
; WIN-X86-NEXT:    pushl %esi
; WIN-X86-NEXT:    andl $-16, %esp
; WIN-X86-NEXT:    subl $80, %esp
; WIN-X86-NEXT:    movl 16(%ebp), %edx
; WIN-X86-NEXT:    movl 20(%ebp), %esi
; WIN-X86-NEXT:    movl 24(%ebp), %edi
; WIN-X86-NEXT:    movl 28(%ebp), %ebx
; WIN-X86-NEXT:    movl 32(%ebp), %ecx
; WIN-X86-NEXT:    movl 36(%ebp), %eax
; WIN-X86-NEXT:    movl %eax, {{[0-9]+}}(%esp)
; WIN-X86-NEXT:    movl %ecx, {{[0-9]+}}(%esp)
; WIN-X86-NEXT:    movl %ebx, {{[0-9]+}}(%esp)
; WIN-X86-NEXT:    movl %edi, {{[0-9]+}}(%esp)
; WIN-X86-NEXT:    movl %esi, {{[0-9]+}}(%esp)
; WIN-X86-NEXT:    movl %edx, {{[0-9]+}}(%esp)
; WIN-X86-NEXT:    movl 12(%ebp), %eax
; WIN-X86-NEXT:    movl %eax, {{[0-9]+}}(%esp)
; WIN-X86-NEXT:    movl 8(%ebp), %eax
; WIN-X86-NEXT:    movl %eax, {{[0-9]+}}(%esp)
; WIN-X86-NEXT:    leal {{[0-9]+}}(%esp), %eax
; WIN-X86-NEXT:    movl %eax, (%esp)
; WIN-X86-NEXT:    calll ___divtf3
; WIN-X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; WIN-X86-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; WIN-X86-NEXT:    movl {{[0-9]+}}(%esp), %edx
; WIN-X86-NEXT:    movl {{[0-9]+}}(%esp), %esi
; WIN-X86-NEXT:    movl %esi, _vf128+12
; WIN-X86-NEXT:    movl %edx, _vf128+8
; WIN-X86-NEXT:    movl %ecx, _vf128+4
; WIN-X86-NEXT:    movl %eax, _vf128
; WIN-X86-NEXT:    leal -12(%ebp), %esp
; WIN-X86-NEXT:    popl %esi
; WIN-X86-NEXT:    popl %edi
; WIN-X86-NEXT:    popl %ebx
; WIN-X86-NEXT:    popl %ebp
; WIN-X86-NEXT:    retl
entry:
  %div = fdiv fp128 %d1, %d2
  store fp128 %div, ptr @vf128, align 16
  ret void
}

define dso_local void @Test128_1Div(fp128 %d1) nounwind {
; CHECK-LABEL: Test128_1Div:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    pushq %rax
; CHECK-NEXT:    movaps %xmm0, %xmm1
; CHECK-NEXT:    movaps vf128(%rip), %xmm0
; CHECK-NEXT:    callq __divtf3@PLT
; CHECK-NEXT:    movaps %xmm0, vf128(%rip)
; CHECK-NEXT:    popq %rax
; CHECK-NEXT:    retq
;
; ANDROID-LABEL: Test128_1Div:
; ANDROID:       # %bb.0: # %entry
; ANDROID-NEXT:    pushq %rax
; ANDROID-NEXT:    movaps %xmm0, %xmm1
; ANDROID-NEXT:    movaps vf128(%rip), %xmm0
; ANDROID-NEXT:    callq __divtf3@PLT
; ANDROID-NEXT:    movaps %xmm0, vf128(%rip)
; ANDROID-NEXT:    popq %rax
; ANDROID-NEXT:    retq
;
; GNU-LABEL: Test128_1Div:
; GNU:       # %bb.0: # %entry
; GNU-NEXT:    pushq %rax
; GNU-NEXT:    movaps %xmm0, %xmm1
; GNU-NEXT:    movaps vf128(%rip), %xmm0
; GNU-NEXT:    callq __divtf3@PLT
; GNU-NEXT:    movaps %xmm0, vf128(%rip)
; GNU-NEXT:    popq %rax
; GNU-NEXT:    retq
;
; X86-LABEL: Test128_1Div:
; X86:       # %bb.0: # %entry
; X86-NEXT:    pushl %ebp
; X86-NEXT:    pushl %ebx
; X86-NEXT:    pushl %edi
; X86-NEXT:    pushl %esi
; X86-NEXT:    subl $76, %esp
; X86-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; X86-NEXT:    movl {{[0-9]+}}(%esp), %edx
; X86-NEXT:    movl {{[0-9]+}}(%esp), %esi
; X86-NEXT:    movl vf128, %edi
; X86-NEXT:    movl vf128+4, %ebx
; X86-NEXT:    movl vf128+8, %ebp
; X86-NEXT:    movl vf128+12, %eax
; X86-NEXT:    movl %esi, {{[0-9]+}}(%esp)
; X86-NEXT:    movl %edx, {{[0-9]+}}(%esp)
; X86-NEXT:    movl %ecx, {{[0-9]+}}(%esp)
; X86-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; X86-NEXT:    movl %ecx, {{[0-9]+}}(%esp)
; X86-NEXT:    movl %eax, {{[0-9]+}}(%esp)
; X86-NEXT:    movl %ebp, {{[0-9]+}}(%esp)
; X86-NEXT:    movl %ebx, {{[0-9]+}}(%esp)
; X86-NEXT:    movl %edi, {{[0-9]+}}(%esp)
; X86-NEXT:    leal {{[0-9]+}}(%esp), %eax
; X86-NEXT:    movl %eax, (%esp)
; X86-NEXT:    calll __divtf3
; X86-NEXT:    subl $4, %esp
; X86-NEXT:    movaps {{[0-9]+}}(%esp), %xmm0
; X86-NEXT:    movaps %xmm0, vf128
; X86-NEXT:    addl $76, %esp
; X86-NEXT:    popl %esi
; X86-NEXT:    popl %edi
; X86-NEXT:    popl %ebx
; X86-NEXT:    popl %ebp
; X86-NEXT:    retl
;
; WIN-LABEL: Test128_1Div:
; WIN:       # %bb.0: # %entry
; WIN-NEXT:    subq $72, %rsp
; WIN-NEXT:    movaps (%rcx), %xmm0
; WIN-NEXT:    movaps vf128(%rip), %xmm1
; WIN-NEXT:    movaps %xmm1, {{[0-9]+}}(%rsp)
; WIN-NEXT:    movaps %xmm0, {{[0-9]+}}(%rsp)
; WIN-NEXT:    leaq {{[0-9]+}}(%rsp), %rcx
; WIN-NEXT:    leaq {{[0-9]+}}(%rsp), %rdx
; WIN-NEXT:    callq __divtf3
; WIN-NEXT:    movaps %xmm0, vf128(%rip)
; WIN-NEXT:    addq $72, %rsp
; WIN-NEXT:    retq
;
; WIN-X86-LABEL: Test128_1Div:
; WIN-X86:       # %bb.0: # %entry
; WIN-X86-NEXT:    pushl %ebp
; WIN-X86-NEXT:    movl %esp, %ebp
; WIN-X86-NEXT:    pushl %ebx
; WIN-X86-NEXT:    pushl %edi
; WIN-X86-NEXT:    pushl %esi
; WIN-X86-NEXT:    andl $-16, %esp
; WIN-X86-NEXT:    subl $80, %esp
; WIN-X86-NEXT:    movl 16(%ebp), %esi
; WIN-X86-NEXT:    movl 20(%ebp), %edi
; WIN-X86-NEXT:    movl _vf128, %edx
; WIN-X86-NEXT:    movl _vf128+4, %ebx
; WIN-X86-NEXT:    movl _vf128+8, %ecx
; WIN-X86-NEXT:    movl _vf128+12, %eax
; WIN-X86-NEXT:    movl %edi, {{[0-9]+}}(%esp)
; WIN-X86-NEXT:    movl %esi, {{[0-9]+}}(%esp)
; WIN-X86-NEXT:    movl 12(%ebp), %esi
; WIN-X86-NEXT:    movl %esi, {{[0-9]+}}(%esp)
; WIN-X86-NEXT:    movl 8(%ebp), %esi
; WIN-X86-NEXT:    movl %esi, {{[0-9]+}}(%esp)
; WIN-X86-NEXT:    movl %eax, {{[0-9]+}}(%esp)
; WIN-X86-NEXT:    movl %ecx, {{[0-9]+}}(%esp)
; WIN-X86-NEXT:    movl %ebx, {{[0-9]+}}(%esp)
; WIN-X86-NEXT:    movl %edx, {{[0-9]+}}(%esp)
; WIN-X86-NEXT:    leal {{[0-9]+}}(%esp), %eax
; WIN-X86-NEXT:    movl %eax, (%esp)
; WIN-X86-NEXT:    calll ___divtf3
; WIN-X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; WIN-X86-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; WIN-X86-NEXT:    movl {{[0-9]+}}(%esp), %edx
; WIN-X86-NEXT:    movl {{[0-9]+}}(%esp), %esi
; WIN-X86-NEXT:    movl %esi, _vf128+8
; WIN-X86-NEXT:    movl %edx, _vf128+12
; WIN-X86-NEXT:    movl %eax, _vf128
; WIN-X86-NEXT:    movl %ecx, _vf128+4
; WIN-X86-NEXT:    leal -12(%ebp), %esp
; WIN-X86-NEXT:    popl %esi
; WIN-X86-NEXT:    popl %edi
; WIN-X86-NEXT:    popl %ebx
; WIN-X86-NEXT:    popl %ebp
; WIN-X86-NEXT:    retl
entry:
  %0 = load fp128, ptr @vf128, align 16
  %div = fdiv fp128 %0, %d1
  store fp128 %div, ptr @vf128, align 16
  ret void
}

define dso_local void @Test128Rem(fp128 %d1, fp128 %d2) nounwind {
; ANDROID-LABEL: Test128Rem:
; ANDROID:       # %bb.0: # %entry
; ANDROID-NEXT:    pushq %rax
; ANDROID-NEXT:    callq fmodl@PLT
; ANDROID-NEXT:    movaps %xmm0, vf128(%rip)
; ANDROID-NEXT:    popq %rax
; ANDROID-NEXT:    retq
;
; GNU-LABEL: Test128Rem:
; GNU:       # %bb.0: # %entry
; GNU-NEXT:    pushq %rax
; GNU-NEXT:    callq fmodf128@PLT
; GNU-NEXT:    movaps %xmm0, vf128(%rip)
; GNU-NEXT:    popq %rax
; GNU-NEXT:    retq
;
; X86-LABEL: Test128Rem:
; X86:       # %bb.0: # %entry
; X86-NEXT:    pushl %ebp
; X86-NEXT:    pushl %ebx
; X86-NEXT:    pushl %edi
; X86-NEXT:    pushl %esi
; X86-NEXT:    subl $76, %esp
; X86-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; X86-NEXT:    movl {{[0-9]+}}(%esp), %edx
; X86-NEXT:    movl {{[0-9]+}}(%esp), %esi
; X86-NEXT:    movl {{[0-9]+}}(%esp), %edi
; X86-NEXT:    movl {{[0-9]+}}(%esp), %ebx
; X86-NEXT:    movl {{[0-9]+}}(%esp), %ebp
; X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    movl %eax, {{[0-9]+}}(%esp)
; X86-NEXT:    movl %ebp, {{[0-9]+}}(%esp)
; X86-NEXT:    movl %ebx, {{[0-9]+}}(%esp)
; X86-NEXT:    movl %edi, {{[0-9]+}}(%esp)
; X86-NEXT:    movl %esi, {{[0-9]+}}(%esp)
; X86-NEXT:    movl %edx, {{[0-9]+}}(%esp)
; X86-NEXT:    movl %ecx, {{[0-9]+}}(%esp)
; X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    movl %eax, {{[0-9]+}}(%esp)
; X86-NEXT:    leal {{[0-9]+}}(%esp), %eax
; X86-NEXT:    movl %eax, (%esp)
; X86-NEXT:    calll fmodf128
; X86-NEXT:    subl $4, %esp
; X86-NEXT:    movaps {{[0-9]+}}(%esp), %xmm0
; X86-NEXT:    movaps %xmm0, vf128
; X86-NEXT:    addl $76, %esp
; X86-NEXT:    popl %esi
; X86-NEXT:    popl %edi
; X86-NEXT:    popl %ebx
; X86-NEXT:    popl %ebp
; X86-NEXT:    retl
;
; WIN-LABEL: Test128Rem:
; WIN:       # %bb.0: # %entry
; WIN-NEXT:    subq $72, %rsp
; WIN-NEXT:    movaps (%rcx), %xmm0
; WIN-NEXT:    movaps (%rdx), %xmm1
; WIN-NEXT:    movaps %xmm1, {{[0-9]+}}(%rsp)
; WIN-NEXT:    movaps %xmm0, {{[0-9]+}}(%rsp)
; WIN-NEXT:    leaq {{[0-9]+}}(%rsp), %rcx
; WIN-NEXT:    leaq {{[0-9]+}}(%rsp), %rdx
; WIN-NEXT:    callq fmodl
; WIN-NEXT:    movaps %xmm0, vf128(%rip)
; WIN-NEXT:    addq $72, %rsp
; WIN-NEXT:    retq
;
; WIN-X86-LABEL: Test128Rem:
; WIN-X86:       # %bb.0: # %entry
; WIN-X86-NEXT:    pushl %ebp
; WIN-X86-NEXT:    movl %esp, %ebp
; WIN-X86-NEXT:    pushl %ebx
; WIN-X86-NEXT:    pushl %edi
; WIN-X86-NEXT:    pushl %esi
; WIN-X86-NEXT:    andl $-16, %esp
; WIN-X86-NEXT:    subl $80, %esp
; WIN-X86-NEXT:    movl 16(%ebp), %edx
; WIN-X86-NEXT:    movl 20(%ebp), %esi
; WIN-X86-NEXT:    movl 24(%ebp), %edi
; WIN-X86-NEXT:    movl 28(%ebp), %ebx
; WIN-X86-NEXT:    movl 32(%ebp), %ecx
; WIN-X86-NEXT:    movl 36(%ebp), %eax
; WIN-X86-NEXT:    movl %eax, {{[0-9]+}}(%esp)
; WIN-X86-NEXT:    movl %ecx, {{[0-9]+}}(%esp)
; WIN-X86-NEXT:    movl %ebx, {{[0-9]+}}(%esp)
; WIN-X86-NEXT:    movl %edi, {{[0-9]+}}(%esp)
; WIN-X86-NEXT:    movl %esi, {{[0-9]+}}(%esp)
; WIN-X86-NEXT:    movl %edx, {{[0-9]+}}(%esp)
; WIN-X86-NEXT:    movl 12(%ebp), %eax
; WIN-X86-NEXT:    movl %eax, {{[0-9]+}}(%esp)
; WIN-X86-NEXT:    movl 8(%ebp), %eax
; WIN-X86-NEXT:    movl %eax, {{[0-9]+}}(%esp)
; WIN-X86-NEXT:    leal {{[0-9]+}}(%esp), %eax
; WIN-X86-NEXT:    movl %eax, (%esp)
; WIN-X86-NEXT:    calll _fmodl
; WIN-X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; WIN-X86-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; WIN-X86-NEXT:    movl {{[0-9]+}}(%esp), %edx
; WIN-X86-NEXT:    movl {{[0-9]+}}(%esp), %esi
; WIN-X86-NEXT:    movl %esi, _vf128+12
; WIN-X86-NEXT:    movl %edx, _vf128+8
; WIN-X86-NEXT:    movl %ecx, _vf128+4
; WIN-X86-NEXT:    movl %eax, _vf128
; WIN-X86-NEXT:    leal -12(%ebp), %esp
; WIN-X86-NEXT:    popl %esi
; WIN-X86-NEXT:    popl %edi
; WIN-X86-NEXT:    popl %ebx
; WIN-X86-NEXT:    popl %ebp
; WIN-X86-NEXT:    retl
entry:
  %div = frem fp128 %d1, %d2
  store fp128 %div, ptr @vf128, align 16
  ret void
}

define dso_local void @Test128_1Rem(fp128 %d1) nounwind {
; ANDROID-LABEL: Test128_1Rem:
; ANDROID:       # %bb.0: # %entry
; ANDROID-NEXT:    pushq %rax
; ANDROID-NEXT:    movaps %xmm0, %xmm1
; ANDROID-NEXT:    movaps vf128(%rip), %xmm0
; ANDROID-NEXT:    callq fmodl@PLT
; ANDROID-NEXT:    movaps %xmm0, vf128(%rip)
; ANDROID-NEXT:    popq %rax
; ANDROID-NEXT:    retq
;
; GNU-LABEL: Test128_1Rem:
; GNU:       # %bb.0: # %entry
; GNU-NEXT:    pushq %rax
; GNU-NEXT:    movaps %xmm0, %xmm1
; GNU-NEXT:    movaps vf128(%rip), %xmm0
; GNU-NEXT:    callq fmodf128@PLT
; GNU-NEXT:    movaps %xmm0, vf128(%rip)
; GNU-NEXT:    popq %rax
; GNU-NEXT:    retq
;
; X86-LABEL: Test128_1Rem:
; X86:       # %bb.0: # %entry
; X86-NEXT:    pushl %ebp
; X86-NEXT:    pushl %ebx
; X86-NEXT:    pushl %edi
; X86-NEXT:    pushl %esi
; X86-NEXT:    subl $76, %esp
; X86-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; X86-NEXT:    movl {{[0-9]+}}(%esp), %edx
; X86-NEXT:    movl {{[0-9]+}}(%esp), %esi
; X86-NEXT:    movl vf128, %edi
; X86-NEXT:    movl vf128+4, %ebx
; X86-NEXT:    movl vf128+8, %ebp
; X86-NEXT:    movl vf128+12, %eax
; X86-NEXT:    movl %esi, {{[0-9]+}}(%esp)
; X86-NEXT:    movl %edx, {{[0-9]+}}(%esp)
; X86-NEXT:    movl %ecx, {{[0-9]+}}(%esp)
; X86-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; X86-NEXT:    movl %ecx, {{[0-9]+}}(%esp)
; X86-NEXT:    movl %eax, {{[0-9]+}}(%esp)
; X86-NEXT:    movl %ebp, {{[0-9]+}}(%esp)
; X86-NEXT:    movl %ebx, {{[0-9]+}}(%esp)
; X86-NEXT:    movl %edi, {{[0-9]+}}(%esp)
; X86-NEXT:    leal {{[0-9]+}}(%esp), %eax
; X86-NEXT:    movl %eax, (%esp)
; X86-NEXT:    calll fmodf128
; X86-NEXT:    subl $4, %esp
; X86-NEXT:    movaps {{[0-9]+}}(%esp), %xmm0
; X86-NEXT:    movaps %xmm0, vf128
; X86-NEXT:    addl $76, %esp
; X86-NEXT:    popl %esi
; X86-NEXT:    popl %edi
; X86-NEXT:    popl %ebx
; X86-NEXT:    popl %ebp
; X86-NEXT:    retl
;
; WIN-LABEL: Test128_1Rem:
; WIN:       # %bb.0: # %entry
; WIN-NEXT:    subq $72, %rsp
; WIN-NEXT:    movaps (%rcx), %xmm0
; WIN-NEXT:    movaps vf128(%rip), %xmm1
; WIN-NEXT:    movaps %xmm1, {{[0-9]+}}(%rsp)
; WIN-NEXT:    movaps %xmm0, {{[0-9]+}}(%rsp)
; WIN-NEXT:    leaq {{[0-9]+}}(%rsp), %rcx
; WIN-NEXT:    leaq {{[0-9]+}}(%rsp), %rdx
; WIN-NEXT:    callq fmodl
; WIN-NEXT:    movaps %xmm0, vf128(%rip)
; WIN-NEXT:    addq $72, %rsp
; WIN-NEXT:    retq
;
; WIN-X86-LABEL: Test128_1Rem:
; WIN-X86:       # %bb.0: # %entry
; WIN-X86-NEXT:    pushl %ebp
; WIN-X86-NEXT:    movl %esp, %ebp
; WIN-X86-NEXT:    pushl %ebx
; WIN-X86-NEXT:    pushl %edi
; WIN-X86-NEXT:    pushl %esi
; WIN-X86-NEXT:    andl $-16, %esp
; WIN-X86-NEXT:    subl $80, %esp
; WIN-X86-NEXT:    movl 16(%ebp), %esi
; WIN-X86-NEXT:    movl 20(%ebp), %edi
; WIN-X86-NEXT:    movl _vf128, %edx
; WIN-X86-NEXT:    movl _vf128+4, %ebx
; WIN-X86-NEXT:    movl _vf128+8, %ecx
; WIN-X86-NEXT:    movl _vf128+12, %eax
; WIN-X86-NEXT:    movl %edi, {{[0-9]+}}(%esp)
; WIN-X86-NEXT:    movl %esi, {{[0-9]+}}(%esp)
; WIN-X86-NEXT:    movl 12(%ebp), %esi
; WIN-X86-NEXT:    movl %esi, {{[0-9]+}}(%esp)
; WIN-X86-NEXT:    movl 8(%ebp), %esi
; WIN-X86-NEXT:    movl %esi, {{[0-9]+}}(%esp)
; WIN-X86-NEXT:    movl %eax, {{[0-9]+}}(%esp)
; WIN-X86-NEXT:    movl %ecx, {{[0-9]+}}(%esp)
; WIN-X86-NEXT:    movl %ebx, {{[0-9]+}}(%esp)
; WIN-X86-NEXT:    movl %edx, {{[0-9]+}}(%esp)
; WIN-X86-NEXT:    leal {{[0-9]+}}(%esp), %eax
; WIN-X86-NEXT:    movl %eax, (%esp)
; WIN-X86-NEXT:    calll _fmodl
; WIN-X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; WIN-X86-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; WIN-X86-NEXT:    movl {{[0-9]+}}(%esp), %edx
; WIN-X86-NEXT:    movl {{[0-9]+}}(%esp), %esi
; WIN-X86-NEXT:    movl %esi, _vf128+8
; WIN-X86-NEXT:    movl %edx, _vf128+12
; WIN-X86-NEXT:    movl %eax, _vf128
; WIN-X86-NEXT:    movl %ecx, _vf128+4
; WIN-X86-NEXT:    leal -12(%ebp), %esp
; WIN-X86-NEXT:    popl %esi
; WIN-X86-NEXT:    popl %edi
; WIN-X86-NEXT:    popl %ebx
; WIN-X86-NEXT:    popl %ebp
; WIN-X86-NEXT:    retl
entry:
  %0 = load fp128, ptr @vf128, align 16
  %div = frem fp128 %0, %d1
  store fp128 %div, ptr @vf128, align 16
  ret void
}

define dso_local void @Test128Sqrt(fp128 %d1) nounwind {
; ANDROID-LABEL: Test128Sqrt:
; ANDROID:       # %bb.0: # %entry
; ANDROID-NEXT:    pushq %rax
; ANDROID-NEXT:    callq sqrtl@PLT
; ANDROID-NEXT:    movaps %xmm0, vf128(%rip)
; ANDROID-NEXT:    popq %rax
; ANDROID-NEXT:    retq
;
; GNU-LABEL: Test128Sqrt:
; GNU:       # %bb.0: # %entry
; GNU-NEXT:    pushq %rax
; GNU-NEXT:    callq sqrtf128@PLT
; GNU-NEXT:    movaps %xmm0, vf128(%rip)
; GNU-NEXT:    popq %rax
; GNU-NEXT:    retq
;
; X86-LABEL: Test128Sqrt:
; X86:       # %bb.0: # %entry
; X86-NEXT:    pushl %esi
; X86-NEXT:    subl $56, %esp
; X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; X86-NEXT:    movl {{[0-9]+}}(%esp), %edx
; X86-NEXT:    movl {{[0-9]+}}(%esp), %esi
; X86-NEXT:    movl %esi, {{[0-9]+}}(%esp)
; X86-NEXT:    movl %edx, {{[0-9]+}}(%esp)
; X86-NEXT:    movl %ecx, {{[0-9]+}}(%esp)
; X86-NEXT:    movl %eax, {{[0-9]+}}(%esp)
; X86-NEXT:    leal {{[0-9]+}}(%esp), %eax
; X86-NEXT:    movl %eax, (%esp)
; X86-NEXT:    calll sqrtf128
; X86-NEXT:    subl $4, %esp
; X86-NEXT:    movaps {{[0-9]+}}(%esp), %xmm0
; X86-NEXT:    movaps %xmm0, vf128
; X86-NEXT:    addl $56, %esp
; X86-NEXT:    popl %esi
; X86-NEXT:    retl
;
; WIN-LABEL: Test128Sqrt:
; WIN:       # %bb.0: # %entry
; WIN-NEXT:    subq $56, %rsp
; WIN-NEXT:    movaps (%rcx), %xmm0
; WIN-NEXT:    movaps %xmm0, {{[0-9]+}}(%rsp)
; WIN-NEXT:    leaq {{[0-9]+}}(%rsp), %rcx
; WIN-NEXT:    callq sqrtl
; WIN-NEXT:    movaps %xmm0, vf128(%rip)
; WIN-NEXT:    addq $56, %rsp
; WIN-NEXT:    retq
;
; WIN-X86-LABEL: Test128Sqrt:
; WIN-X86:       # %bb.0: # %entry
; WIN-X86-NEXT:    pushl %ebp
; WIN-X86-NEXT:    movl %esp, %ebp
; WIN-X86-NEXT:    pushl %esi
; WIN-X86-NEXT:    andl $-16, %esp
; WIN-X86-NEXT:    subl $64, %esp
; WIN-X86-NEXT:    movl 8(%ebp), %eax
; WIN-X86-NEXT:    movl 12(%ebp), %ecx
; WIN-X86-NEXT:    movl 16(%ebp), %edx
; WIN-X86-NEXT:    movl 20(%ebp), %esi
; WIN-X86-NEXT:    movl %esi, {{[0-9]+}}(%esp)
; WIN-X86-NEXT:    movl %edx, {{[0-9]+}}(%esp)
; WIN-X86-NEXT:    movl %ecx, {{[0-9]+}}(%esp)
; WIN-X86-NEXT:    movl %eax, {{[0-9]+}}(%esp)
; WIN-X86-NEXT:    leal {{[0-9]+}}(%esp), %eax
; WIN-X86-NEXT:    movl %eax, (%esp)
; WIN-X86-NEXT:    calll _sqrtl
; WIN-X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; WIN-X86-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; WIN-X86-NEXT:    movl {{[0-9]+}}(%esp), %edx
; WIN-X86-NEXT:    movl {{[0-9]+}}(%esp), %esi
; WIN-X86-NEXT:    movl %esi, _vf128+12
; WIN-X86-NEXT:    movl %edx, _vf128+8
; WIN-X86-NEXT:    movl %ecx, _vf128+4
; WIN-X86-NEXT:    movl %eax, _vf128
; WIN-X86-NEXT:    leal -4(%ebp), %esp
; WIN-X86-NEXT:    popl %esi
; WIN-X86-NEXT:    popl %ebp
; WIN-X86-NEXT:    retl
entry:
  %sqrt = call fp128 @llvm.sqrt.f128(fp128 %d1)
  store fp128 %sqrt, ptr @vf128, align 16
  ret void
}
declare fp128 @llvm.sqrt.f128(fp128)

define dso_local void @Test128Sin(fp128 %d1) nounwind {
; ANDROID-LABEL: Test128Sin:
; ANDROID:       # %bb.0: # %entry
; ANDROID-NEXT:    pushq %rax
; ANDROID-NEXT:    callq sinl@PLT
; ANDROID-NEXT:    movaps %xmm0, vf128(%rip)
; ANDROID-NEXT:    popq %rax
; ANDROID-NEXT:    retq
;
; GNU-LABEL: Test128Sin:
; GNU:       # %bb.0: # %entry
; GNU-NEXT:    pushq %rax
; GNU-NEXT:    callq sinf128@PLT
; GNU-NEXT:    movaps %xmm0, vf128(%rip)
; GNU-NEXT:    popq %rax
; GNU-NEXT:    retq
;
; X86-LABEL: Test128Sin:
; X86:       # %bb.0: # %entry
; X86-NEXT:    pushl %esi
; X86-NEXT:    subl $56, %esp
; X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; X86-NEXT:    movl {{[0-9]+}}(%esp), %edx
; X86-NEXT:    movl {{[0-9]+}}(%esp), %esi
; X86-NEXT:    movl %esi, {{[0-9]+}}(%esp)
; X86-NEXT:    movl %edx, {{[0-9]+}}(%esp)
; X86-NEXT:    movl %ecx, {{[0-9]+}}(%esp)
; X86-NEXT:    movl %eax, {{[0-9]+}}(%esp)
; X86-NEXT:    leal {{[0-9]+}}(%esp), %eax
; X86-NEXT:    movl %eax, (%esp)
; X86-NEXT:    calll sinf128
; X86-NEXT:    subl $4, %esp
; X86-NEXT:    movaps {{[0-9]+}}(%esp), %xmm0
; X86-NEXT:    movaps %xmm0, vf128
; X86-NEXT:    addl $56, %esp
; X86-NEXT:    popl %esi
; X86-NEXT:    retl
;
; WIN-LABEL: Test128Sin:
; WIN:       # %bb.0: # %entry
; WIN-NEXT:    subq $56, %rsp
; WIN-NEXT:    movaps (%rcx), %xmm0
; WIN-NEXT:    movaps %xmm0, {{[0-9]+}}(%rsp)
; WIN-NEXT:    leaq {{[0-9]+}}(%rsp), %rcx
; WIN-NEXT:    callq sinl
; WIN-NEXT:    movaps %xmm0, vf128(%rip)
; WIN-NEXT:    addq $56, %rsp
; WIN-NEXT:    retq
;
; WIN-X86-LABEL: Test128Sin:
; WIN-X86:       # %bb.0: # %entry
; WIN-X86-NEXT:    pushl %ebp
; WIN-X86-NEXT:    movl %esp, %ebp
; WIN-X86-NEXT:    pushl %esi
; WIN-X86-NEXT:    andl $-16, %esp
; WIN-X86-NEXT:    subl $64, %esp
; WIN-X86-NEXT:    movl 8(%ebp), %eax
; WIN-X86-NEXT:    movl 12(%ebp), %ecx
; WIN-X86-NEXT:    movl 16(%ebp), %edx
; WIN-X86-NEXT:    movl 20(%ebp), %esi
; WIN-X86-NEXT:    movl %esi, {{[0-9]+}}(%esp)
; WIN-X86-NEXT:    movl %edx, {{[0-9]+}}(%esp)
; WIN-X86-NEXT:    movl %ecx, {{[0-9]+}}(%esp)
; WIN-X86-NEXT:    movl %eax, {{[0-9]+}}(%esp)
; WIN-X86-NEXT:    leal {{[0-9]+}}(%esp), %eax
; WIN-X86-NEXT:    movl %eax, (%esp)
; WIN-X86-NEXT:    calll _sinl
; WIN-X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; WIN-X86-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; WIN-X86-NEXT:    movl {{[0-9]+}}(%esp), %edx
; WIN-X86-NEXT:    movl {{[0-9]+}}(%esp), %esi
; WIN-X86-NEXT:    movl %esi, _vf128+12
; WIN-X86-NEXT:    movl %edx, _vf128+8
; WIN-X86-NEXT:    movl %ecx, _vf128+4
; WIN-X86-NEXT:    movl %eax, _vf128
; WIN-X86-NEXT:    leal -4(%ebp), %esp
; WIN-X86-NEXT:    popl %esi
; WIN-X86-NEXT:    popl %ebp
; WIN-X86-NEXT:    retl
entry:
  %sqrt = call fp128 @llvm.sin.f128(fp128 %d1)
  store fp128 %sqrt, ptr @vf128, align 16
  ret void
}
declare fp128 @llvm.sin.f128(fp128)

define dso_local void @Test128Cos(fp128 %d1) nounwind {
; ANDROID-LABEL: Test128Cos:
; ANDROID:       # %bb.0: # %entry
; ANDROID-NEXT:    pushq %rax
; ANDROID-NEXT:    callq cosl@PLT
; ANDROID-NEXT:    movaps %xmm0, vf128(%rip)
; ANDROID-NEXT:    popq %rax
; ANDROID-NEXT:    retq
;
; GNU-LABEL: Test128Cos:
; GNU:       # %bb.0: # %entry
; GNU-NEXT:    pushq %rax
; GNU-NEXT:    callq cosf128@PLT
; GNU-NEXT:    movaps %xmm0, vf128(%rip)
; GNU-NEXT:    popq %rax
; GNU-NEXT:    retq
;
; X86-LABEL: Test128Cos:
; X86:       # %bb.0: # %entry
; X86-NEXT:    pushl %esi
; X86-NEXT:    subl $56, %esp
; X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; X86-NEXT:    movl {{[0-9]+}}(%esp), %edx
; X86-NEXT:    movl {{[0-9]+}}(%esp), %esi
; X86-NEXT:    movl %esi, {{[0-9]+}}(%esp)
; X86-NEXT:    movl %edx, {{[0-9]+}}(%esp)
; X86-NEXT:    movl %ecx, {{[0-9]+}}(%esp)
; X86-NEXT:    movl %eax, {{[0-9]+}}(%esp)
; X86-NEXT:    leal {{[0-9]+}}(%esp), %eax
; X86-NEXT:    movl %eax, (%esp)
; X86-NEXT:    calll cosf128
; X86-NEXT:    subl $4, %esp
; X86-NEXT:    movaps {{[0-9]+}}(%esp), %xmm0
; X86-NEXT:    movaps %xmm0, vf128
; X86-NEXT:    addl $56, %esp
; X86-NEXT:    popl %esi
; X86-NEXT:    retl
;
; WIN-LABEL: Test128Cos:
; WIN:       # %bb.0: # %entry
; WIN-NEXT:    subq $56, %rsp
; WIN-NEXT:    movaps (%rcx), %xmm0
; WIN-NEXT:    movaps %xmm0, {{[0-9]+}}(%rsp)
; WIN-NEXT:    leaq {{[0-9]+}}(%rsp), %rcx
; WIN-NEXT:    callq cosl
; WIN-NEXT:    movaps %xmm0, vf128(%rip)
; WIN-NEXT:    addq $56, %rsp
; WIN-NEXT:    retq
;
; WIN-X86-LABEL: Test128Cos:
; WIN-X86:       # %bb.0: # %entry
; WIN-X86-NEXT:    pushl %ebp
; WIN-X86-NEXT:    movl %esp, %ebp
; WIN-X86-NEXT:    pushl %esi
; WIN-X86-NEXT:    andl $-16, %esp
; WIN-X86-NEXT:    subl $64, %esp
; WIN-X86-NEXT:    movl 8(%ebp), %eax
; WIN-X86-NEXT:    movl 12(%ebp), %ecx
; WIN-X86-NEXT:    movl 16(%ebp), %edx
; WIN-X86-NEXT:    movl 20(%ebp), %esi
; WIN-X86-NEXT:    movl %esi, {{[0-9]+}}(%esp)
; WIN-X86-NEXT:    movl %edx, {{[0-9]+}}(%esp)
; WIN-X86-NEXT:    movl %ecx, {{[0-9]+}}(%esp)
; WIN-X86-NEXT:    movl %eax, {{[0-9]+}}(%esp)
; WIN-X86-NEXT:    leal {{[0-9]+}}(%esp), %eax
; WIN-X86-NEXT:    movl %eax, (%esp)
; WIN-X86-NEXT:    calll _cosl
; WIN-X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; WIN-X86-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; WIN-X86-NEXT:    movl {{[0-9]+}}(%esp), %edx
; WIN-X86-NEXT:    movl {{[0-9]+}}(%esp), %esi
; WIN-X86-NEXT:    movl %esi, _vf128+12
; WIN-X86-NEXT:    movl %edx, _vf128+8
; WIN-X86-NEXT:    movl %ecx, _vf128+4
; WIN-X86-NEXT:    movl %eax, _vf128
; WIN-X86-NEXT:    leal -4(%ebp), %esp
; WIN-X86-NEXT:    popl %esi
; WIN-X86-NEXT:    popl %ebp
; WIN-X86-NEXT:    retl
entry:
  %sqrt = call fp128 @llvm.cos.f128(fp128 %d1)
  store fp128 %sqrt, ptr @vf128, align 16
  ret void
}
declare fp128 @llvm.cos.f128(fp128)

define dso_local void @Test128Ceil(fp128 %d1) nounwind {
; ANDROID-LABEL: Test128Ceil:
; ANDROID:       # %bb.0: # %entry
; ANDROID-NEXT:    pushq %rax
; ANDROID-NEXT:    callq ceill@PLT
; ANDROID-NEXT:    movaps %xmm0, vf128(%rip)
; ANDROID-NEXT:    popq %rax
; ANDROID-NEXT:    retq
;
; GNU-LABEL: Test128Ceil:
; GNU:       # %bb.0: # %entry
; GNU-NEXT:    pushq %rax
; GNU-NEXT:    callq ceilf128@PLT
; GNU-NEXT:    movaps %xmm0, vf128(%rip)
; GNU-NEXT:    popq %rax
; GNU-NEXT:    retq
;
; X86-LABEL: Test128Ceil:
; X86:       # %bb.0: # %entry
; X86-NEXT:    pushl %esi
; X86-NEXT:    subl $56, %esp
; X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; X86-NEXT:    movl {{[0-9]+}}(%esp), %edx
; X86-NEXT:    movl {{[0-9]+}}(%esp), %esi
; X86-NEXT:    movl %esi, {{[0-9]+}}(%esp)
; X86-NEXT:    movl %edx, {{[0-9]+}}(%esp)
; X86-NEXT:    movl %ecx, {{[0-9]+}}(%esp)
; X86-NEXT:    movl %eax, {{[0-9]+}}(%esp)
; X86-NEXT:    leal {{[0-9]+}}(%esp), %eax
; X86-NEXT:    movl %eax, (%esp)
; X86-NEXT:    calll ceilf128
; X86-NEXT:    subl $4, %esp
; X86-NEXT:    movaps {{[0-9]+}}(%esp), %xmm0
; X86-NEXT:    movaps %xmm0, vf128
; X86-NEXT:    addl $56, %esp
; X86-NEXT:    popl %esi
; X86-NEXT:    retl
;
; WIN-LABEL: Test128Ceil:
; WIN:       # %bb.0: # %entry
; WIN-NEXT:    subq $56, %rsp
; WIN-NEXT:    movaps (%rcx), %xmm0
; WIN-NEXT:    movaps %xmm0, {{[0-9]+}}(%rsp)
; WIN-NEXT:    leaq {{[0-9]+}}(%rsp), %rcx
; WIN-NEXT:    callq ceill
; WIN-NEXT:    movaps %xmm0, vf128(%rip)
; WIN-NEXT:    addq $56, %rsp
; WIN-NEXT:    retq
;
; WIN-X86-LABEL: Test128Ceil:
; WIN-X86:       # %bb.0: # %entry
; WIN-X86-NEXT:    pushl %ebp
; WIN-X86-NEXT:    movl %esp, %ebp
; WIN-X86-NEXT:    pushl %esi
; WIN-X86-NEXT:    andl $-16, %esp
; WIN-X86-NEXT:    subl $64, %esp
; WIN-X86-NEXT:    movl 8(%ebp), %eax
; WIN-X86-NEXT:    movl 12(%ebp), %ecx
; WIN-X86-NEXT:    movl 16(%ebp), %edx
; WIN-X86-NEXT:    movl 20(%ebp), %esi
; WIN-X86-NEXT:    movl %esi, {{[0-9]+}}(%esp)
; WIN-X86-NEXT:    movl %edx, {{[0-9]+}}(%esp)
; WIN-X86-NEXT:    movl %ecx, {{[0-9]+}}(%esp)
; WIN-X86-NEXT:    movl %eax, {{[0-9]+}}(%esp)
; WIN-X86-NEXT:    leal {{[0-9]+}}(%esp), %eax
; WIN-X86-NEXT:    movl %eax, (%esp)
; WIN-X86-NEXT:    calll _ceill
; WIN-X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; WIN-X86-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; WIN-X86-NEXT:    movl {{[0-9]+}}(%esp), %edx
; WIN-X86-NEXT:    movl {{[0-9]+}}(%esp), %esi
; WIN-X86-NEXT:    movl %esi, _vf128+12
; WIN-X86-NEXT:    movl %edx, _vf128+8
; WIN-X86-NEXT:    movl %ecx, _vf128+4
; WIN-X86-NEXT:    movl %eax, _vf128
; WIN-X86-NEXT:    leal -4(%ebp), %esp
; WIN-X86-NEXT:    popl %esi
; WIN-X86-NEXT:    popl %ebp
; WIN-X86-NEXT:    retl
entry:
  %sqrt = call fp128 @llvm.ceil.f128(fp128 %d1)
  store fp128 %sqrt, ptr @vf128, align 16
  ret void
}
declare fp128 @llvm.ceil.f128(fp128)

define dso_local void @Test128Floor(fp128 %d1) nounwind {
; ANDROID-LABEL: Test128Floor:
; ANDROID:       # %bb.0: # %entry
; ANDROID-NEXT:    pushq %rax
; ANDROID-NEXT:    callq floorl@PLT
; ANDROID-NEXT:    movaps %xmm0, vf128(%rip)
; ANDROID-NEXT:    popq %rax
; ANDROID-NEXT:    retq
;
; GNU-LABEL: Test128Floor:
; GNU:       # %bb.0: # %entry
; GNU-NEXT:    pushq %rax
; GNU-NEXT:    callq floorf128@PLT
; GNU-NEXT:    movaps %xmm0, vf128(%rip)
; GNU-NEXT:    popq %rax
; GNU-NEXT:    retq
;
; X86-LABEL: Test128Floor:
; X86:       # %bb.0: # %entry
; X86-NEXT:    pushl %esi
; X86-NEXT:    subl $56, %esp
; X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; X86-NEXT:    movl {{[0-9]+}}(%esp), %edx
; X86-NEXT:    movl {{[0-9]+}}(%esp), %esi
; X86-NEXT:    movl %esi, {{[0-9]+}}(%esp)
; X86-NEXT:    movl %edx, {{[0-9]+}}(%esp)
; X86-NEXT:    movl %ecx, {{[0-9]+}}(%esp)
; X86-NEXT:    movl %eax, {{[0-9]+}}(%esp)
; X86-NEXT:    leal {{[0-9]+}}(%esp), %eax
; X86-NEXT:    movl %eax, (%esp)
; X86-NEXT:    calll floorf128
; X86-NEXT:    subl $4, %esp
; X86-NEXT:    movaps {{[0-9]+}}(%esp), %xmm0
; X86-NEXT:    movaps %xmm0, vf128
; X86-NEXT:    addl $56, %esp
; X86-NEXT:    popl %esi
; X86-NEXT:    retl
;
; WIN-LABEL: Test128Floor:
; WIN:       # %bb.0: # %entry
; WIN-NEXT:    subq $56, %rsp
; WIN-NEXT:    movaps (%rcx), %xmm0
; WIN-NEXT:    movaps %xmm0, {{[0-9]+}}(%rsp)
; WIN-NEXT:    leaq {{[0-9]+}}(%rsp), %rcx
; WIN-NEXT:    callq floorl
; WIN-NEXT:    movaps %xmm0, vf128(%rip)
; WIN-NEXT:    addq $56, %rsp
; WIN-NEXT:    retq
;
; WIN-X86-LABEL: Test128Floor:
; WIN-X86:       # %bb.0: # %entry
; WIN-X86-NEXT:    pushl %ebp
; WIN-X86-NEXT:    movl %esp, %ebp
; WIN-X86-NEXT:    pushl %esi
; WIN-X86-NEXT:    andl $-16, %esp
; WIN-X86-NEXT:    subl $64, %esp
; WIN-X86-NEXT:    movl 8(%ebp), %eax
; WIN-X86-NEXT:    movl 12(%ebp), %ecx
; WIN-X86-NEXT:    movl 16(%ebp), %edx
; WIN-X86-NEXT:    movl 20(%ebp), %esi
; WIN-X86-NEXT:    movl %esi, {{[0-9]+}}(%esp)
; WIN-X86-NEXT:    movl %edx, {{[0-9]+}}(%esp)
; WIN-X86-NEXT:    movl %ecx, {{[0-9]+}}(%esp)
; WIN-X86-NEXT:    movl %eax, {{[0-9]+}}(%esp)
; WIN-X86-NEXT:    leal {{[0-9]+}}(%esp), %eax
; WIN-X86-NEXT:    movl %eax, (%esp)
; WIN-X86-NEXT:    calll _floorl
; WIN-X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; WIN-X86-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; WIN-X86-NEXT:    movl {{[0-9]+}}(%esp), %edx
; WIN-X86-NEXT:    movl {{[0-9]+}}(%esp), %esi
; WIN-X86-NEXT:    movl %esi, _vf128+12
; WIN-X86-NEXT:    movl %edx, _vf128+8
; WIN-X86-NEXT:    movl %ecx, _vf128+4
; WIN-X86-NEXT:    movl %eax, _vf128
; WIN-X86-NEXT:    leal -4(%ebp), %esp
; WIN-X86-NEXT:    popl %esi
; WIN-X86-NEXT:    popl %ebp
; WIN-X86-NEXT:    retl
entry:
  %sqrt = call fp128 @llvm.floor.f128(fp128 %d1)
  store fp128 %sqrt, ptr @vf128, align 16
  ret void
}
declare fp128 @llvm.floor.f128(fp128)

define dso_local void @Test128Trunc(fp128 %d1) nounwind {
; ANDROID-LABEL: Test128Trunc:
; ANDROID:       # %bb.0: # %entry
; ANDROID-NEXT:    pushq %rax
; ANDROID-NEXT:    callq truncl@PLT
; ANDROID-NEXT:    movaps %xmm0, vf128(%rip)
; ANDROID-NEXT:    popq %rax
; ANDROID-NEXT:    retq
;
; GNU-LABEL: Test128Trunc:
; GNU:       # %bb.0: # %entry
; GNU-NEXT:    pushq %rax
; GNU-NEXT:    callq truncf128@PLT
; GNU-NEXT:    movaps %xmm0, vf128(%rip)
; GNU-NEXT:    popq %rax
; GNU-NEXT:    retq
;
; X86-LABEL: Test128Trunc:
; X86:       # %bb.0: # %entry
; X86-NEXT:    pushl %esi
; X86-NEXT:    subl $56, %esp
; X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; X86-NEXT:    movl {{[0-9]+}}(%esp), %edx
; X86-NEXT:    movl {{[0-9]+}}(%esp), %esi
; X86-NEXT:    movl %esi, {{[0-9]+}}(%esp)
; X86-NEXT:    movl %edx, {{[0-9]+}}(%esp)
; X86-NEXT:    movl %ecx, {{[0-9]+}}(%esp)
; X86-NEXT:    movl %eax, {{[0-9]+}}(%esp)
; X86-NEXT:    leal {{[0-9]+}}(%esp), %eax
; X86-NEXT:    movl %eax, (%esp)
; X86-NEXT:    calll truncf128
; X86-NEXT:    subl $4, %esp
; X86-NEXT:    movaps {{[0-9]+}}(%esp), %xmm0
; X86-NEXT:    movaps %xmm0, vf128
; X86-NEXT:    addl $56, %esp
; X86-NEXT:    popl %esi
; X86-NEXT:    retl
;
; WIN-LABEL: Test128Trunc:
; WIN:       # %bb.0: # %entry
; WIN-NEXT:    subq $56, %rsp
; WIN-NEXT:    movaps (%rcx), %xmm0
; WIN-NEXT:    movaps %xmm0, {{[0-9]+}}(%rsp)
; WIN-NEXT:    leaq {{[0-9]+}}(%rsp), %rcx
; WIN-NEXT:    callq truncl
; WIN-NEXT:    movaps %xmm0, vf128(%rip)
; WIN-NEXT:    addq $56, %rsp
; WIN-NEXT:    retq
;
; WIN-X86-LABEL: Test128Trunc:
; WIN-X86:       # %bb.0: # %entry
; WIN-X86-NEXT:    pushl %ebp
; WIN-X86-NEXT:    movl %esp, %ebp
; WIN-X86-NEXT:    pushl %esi
; WIN-X86-NEXT:    andl $-16, %esp
; WIN-X86-NEXT:    subl $64, %esp
; WIN-X86-NEXT:    movl 8(%ebp), %eax
; WIN-X86-NEXT:    movl 12(%ebp), %ecx
; WIN-X86-NEXT:    movl 16(%ebp), %edx
; WIN-X86-NEXT:    movl 20(%ebp), %esi
; WIN-X86-NEXT:    movl %esi, {{[0-9]+}}(%esp)
; WIN-X86-NEXT:    movl %edx, {{[0-9]+}}(%esp)
; WIN-X86-NEXT:    movl %ecx, {{[0-9]+}}(%esp)
; WIN-X86-NEXT:    movl %eax, {{[0-9]+}}(%esp)
; WIN-X86-NEXT:    leal {{[0-9]+}}(%esp), %eax
; WIN-X86-NEXT:    movl %eax, (%esp)
; WIN-X86-NEXT:    calll _truncl
; WIN-X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; WIN-X86-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; WIN-X86-NEXT:    movl {{[0-9]+}}(%esp), %edx
; WIN-X86-NEXT:    movl {{[0-9]+}}(%esp), %esi
; WIN-X86-NEXT:    movl %esi, _vf128+12
; WIN-X86-NEXT:    movl %edx, _vf128+8
; WIN-X86-NEXT:    movl %ecx, _vf128+4
; WIN-X86-NEXT:    movl %eax, _vf128
; WIN-X86-NEXT:    leal -4(%ebp), %esp
; WIN-X86-NEXT:    popl %esi
; WIN-X86-NEXT:    popl %ebp
; WIN-X86-NEXT:    retl
entry:
  %sqrt = call fp128 @llvm.trunc.f128(fp128 %d1)
  store fp128 %sqrt, ptr @vf128, align 16
  ret void
}
declare fp128 @llvm.trunc.f128(fp128)

define dso_local void @Test128Nearbyint(fp128 %d1) nounwind {
; ANDROID-LABEL: Test128Nearbyint:
; ANDROID:       # %bb.0: # %entry
; ANDROID-NEXT:    pushq %rax
; ANDROID-NEXT:    callq nearbyintl@PLT
; ANDROID-NEXT:    movaps %xmm0, vf128(%rip)
; ANDROID-NEXT:    popq %rax
; ANDROID-NEXT:    retq
;
; GNU-LABEL: Test128Nearbyint:
; GNU:       # %bb.0: # %entry
; GNU-NEXT:    pushq %rax
; GNU-NEXT:    callq nearbyintf128@PLT
; GNU-NEXT:    movaps %xmm0, vf128(%rip)
; GNU-NEXT:    popq %rax
; GNU-NEXT:    retq
;
; X86-LABEL: Test128Nearbyint:
; X86:       # %bb.0: # %entry
; X86-NEXT:    pushl %esi
; X86-NEXT:    subl $56, %esp
; X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; X86-NEXT:    movl {{[0-9]+}}(%esp), %edx
; X86-NEXT:    movl {{[0-9]+}}(%esp), %esi
; X86-NEXT:    movl %esi, {{[0-9]+}}(%esp)
; X86-NEXT:    movl %edx, {{[0-9]+}}(%esp)
; X86-NEXT:    movl %ecx, {{[0-9]+}}(%esp)
; X86-NEXT:    movl %eax, {{[0-9]+}}(%esp)
; X86-NEXT:    leal {{[0-9]+}}(%esp), %eax
; X86-NEXT:    movl %eax, (%esp)
; X86-NEXT:    calll nearbyintf128
; X86-NEXT:    subl $4, %esp
; X86-NEXT:    movaps {{[0-9]+}}(%esp), %xmm0
; X86-NEXT:    movaps %xmm0, vf128
; X86-NEXT:    addl $56, %esp
; X86-NEXT:    popl %esi
; X86-NEXT:    retl
;
; WIN-LABEL: Test128Nearbyint:
; WIN:       # %bb.0: # %entry
; WIN-NEXT:    subq $56, %rsp
; WIN-NEXT:    movaps (%rcx), %xmm0
; WIN-NEXT:    movaps %xmm0, {{[0-9]+}}(%rsp)
; WIN-NEXT:    leaq {{[0-9]+}}(%rsp), %rcx
; WIN-NEXT:    callq nearbyintl
; WIN-NEXT:    movaps %xmm0, vf128(%rip)
; WIN-NEXT:    addq $56, %rsp
; WIN-NEXT:    retq
;
; WIN-X86-LABEL: Test128Nearbyint:
; WIN-X86:       # %bb.0: # %entry
; WIN-X86-NEXT:    pushl %ebp
; WIN-X86-NEXT:    movl %esp, %ebp
; WIN-X86-NEXT:    pushl %esi
; WIN-X86-NEXT:    andl $-16, %esp
; WIN-X86-NEXT:    subl $64, %esp
; WIN-X86-NEXT:    movl 8(%ebp), %eax
; WIN-X86-NEXT:    movl 12(%ebp), %ecx
; WIN-X86-NEXT:    movl 16(%ebp), %edx
; WIN-X86-NEXT:    movl 20(%ebp), %esi
; WIN-X86-NEXT:    movl %esi, {{[0-9]+}}(%esp)
; WIN-X86-NEXT:    movl %edx, {{[0-9]+}}(%esp)
; WIN-X86-NEXT:    movl %ecx, {{[0-9]+}}(%esp)
; WIN-X86-NEXT:    movl %eax, {{[0-9]+}}(%esp)
; WIN-X86-NEXT:    leal {{[0-9]+}}(%esp), %eax
; WIN-X86-NEXT:    movl %eax, (%esp)
; WIN-X86-NEXT:    calll _nearbyintl
; WIN-X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; WIN-X86-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; WIN-X86-NEXT:    movl {{[0-9]+}}(%esp), %edx
; WIN-X86-NEXT:    movl {{[0-9]+}}(%esp), %esi
; WIN-X86-NEXT:    movl %esi, _vf128+12
; WIN-X86-NEXT:    movl %edx, _vf128+8
; WIN-X86-NEXT:    movl %ecx, _vf128+4
; WIN-X86-NEXT:    movl %eax, _vf128
; WIN-X86-NEXT:    leal -4(%ebp), %esp
; WIN-X86-NEXT:    popl %esi
; WIN-X86-NEXT:    popl %ebp
; WIN-X86-NEXT:    retl
entry:
  %sqrt = call fp128 @llvm.nearbyint.f128(fp128 %d1)
  store fp128 %sqrt, ptr @vf128, align 16
  ret void
}
declare fp128 @llvm.nearbyint.f128(fp128)

define dso_local void @Test128Rint(fp128 %d1) nounwind {
; ANDROID-LABEL: Test128Rint:
; ANDROID:       # %bb.0: # %entry
; ANDROID-NEXT:    pushq %rax
; ANDROID-NEXT:    callq rintl@PLT
; ANDROID-NEXT:    movaps %xmm0, vf128(%rip)
; ANDROID-NEXT:    popq %rax
; ANDROID-NEXT:    retq
;
; GNU-LABEL: Test128Rint:
; GNU:       # %bb.0: # %entry
; GNU-NEXT:    pushq %rax
; GNU-NEXT:    callq rintf128@PLT
; GNU-NEXT:    movaps %xmm0, vf128(%rip)
; GNU-NEXT:    popq %rax
; GNU-NEXT:    retq
;
; X86-LABEL: Test128Rint:
; X86:       # %bb.0: # %entry
; X86-NEXT:    pushl %esi
; X86-NEXT:    subl $56, %esp
; X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; X86-NEXT:    movl {{[0-9]+}}(%esp), %edx
; X86-NEXT:    movl {{[0-9]+}}(%esp), %esi
; X86-NEXT:    movl %esi, {{[0-9]+}}(%esp)
; X86-NEXT:    movl %edx, {{[0-9]+}}(%esp)
; X86-NEXT:    movl %ecx, {{[0-9]+}}(%esp)
; X86-NEXT:    movl %eax, {{[0-9]+}}(%esp)
; X86-NEXT:    leal {{[0-9]+}}(%esp), %eax
; X86-NEXT:    movl %eax, (%esp)
; X86-NEXT:    calll rintf128
; X86-NEXT:    subl $4, %esp
; X86-NEXT:    movaps {{[0-9]+}}(%esp), %xmm0
; X86-NEXT:    movaps %xmm0, vf128
; X86-NEXT:    addl $56, %esp
; X86-NEXT:    popl %esi
; X86-NEXT:    retl
;
; WIN-LABEL: Test128Rint:
; WIN:       # %bb.0: # %entry
; WIN-NEXT:    subq $56, %rsp
; WIN-NEXT:    movaps (%rcx), %xmm0
; WIN-NEXT:    movaps %xmm0, {{[0-9]+}}(%rsp)
; WIN-NEXT:    leaq {{[0-9]+}}(%rsp), %rcx
; WIN-NEXT:    callq rintl
; WIN-NEXT:    movaps %xmm0, vf128(%rip)
; WIN-NEXT:    addq $56, %rsp
; WIN-NEXT:    retq
;
; WIN-X86-LABEL: Test128Rint:
; WIN-X86:       # %bb.0: # %entry
; WIN-X86-NEXT:    pushl %ebp
; WIN-X86-NEXT:    movl %esp, %ebp
; WIN-X86-NEXT:    pushl %esi
; WIN-X86-NEXT:    andl $-16, %esp
; WIN-X86-NEXT:    subl $64, %esp
; WIN-X86-NEXT:    movl 8(%ebp), %eax
; WIN-X86-NEXT:    movl 12(%ebp), %ecx
; WIN-X86-NEXT:    movl 16(%ebp), %edx
; WIN-X86-NEXT:    movl 20(%ebp), %esi
; WIN-X86-NEXT:    movl %esi, {{[0-9]+}}(%esp)
; WIN-X86-NEXT:    movl %edx, {{[0-9]+}}(%esp)
; WIN-X86-NEXT:    movl %ecx, {{[0-9]+}}(%esp)
; WIN-X86-NEXT:    movl %eax, {{[0-9]+}}(%esp)
; WIN-X86-NEXT:    leal {{[0-9]+}}(%esp), %eax
; WIN-X86-NEXT:    movl %eax, (%esp)
; WIN-X86-NEXT:    calll _rintl
; WIN-X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; WIN-X86-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; WIN-X86-NEXT:    movl {{[0-9]+}}(%esp), %edx
; WIN-X86-NEXT:    movl {{[0-9]+}}(%esp), %esi
; WIN-X86-NEXT:    movl %esi, _vf128+12
; WIN-X86-NEXT:    movl %edx, _vf128+8
; WIN-X86-NEXT:    movl %ecx, _vf128+4
; WIN-X86-NEXT:    movl %eax, _vf128
; WIN-X86-NEXT:    leal -4(%ebp), %esp
; WIN-X86-NEXT:    popl %esi
; WIN-X86-NEXT:    popl %ebp
; WIN-X86-NEXT:    retl
entry:
  %sqrt = call fp128 @llvm.rint.f128(fp128 %d1)
  store fp128 %sqrt, ptr @vf128, align 16
  ret void
}
declare fp128 @llvm.rint.f128(fp128)

define dso_local void @Test128Round(fp128 %d1) nounwind {
; ANDROID-LABEL: Test128Round:
; ANDROID:       # %bb.0: # %entry
; ANDROID-NEXT:    pushq %rax
; ANDROID-NEXT:    callq roundl@PLT
; ANDROID-NEXT:    movaps %xmm0, vf128(%rip)
; ANDROID-NEXT:    popq %rax
; ANDROID-NEXT:    retq
;
; GNU-LABEL: Test128Round:
; GNU:       # %bb.0: # %entry
; GNU-NEXT:    pushq %rax
; GNU-NEXT:    callq roundf128@PLT
; GNU-NEXT:    movaps %xmm0, vf128(%rip)
; GNU-NEXT:    popq %rax
; GNU-NEXT:    retq
;
; X86-LABEL: Test128Round:
; X86:       # %bb.0: # %entry
; X86-NEXT:    pushl %esi
; X86-NEXT:    subl $56, %esp
; X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; X86-NEXT:    movl {{[0-9]+}}(%esp), %edx
; X86-NEXT:    movl {{[0-9]+}}(%esp), %esi
; X86-NEXT:    movl %esi, {{[0-9]+}}(%esp)
; X86-NEXT:    movl %edx, {{[0-9]+}}(%esp)
; X86-NEXT:    movl %ecx, {{[0-9]+}}(%esp)
; X86-NEXT:    movl %eax, {{[0-9]+}}(%esp)
; X86-NEXT:    leal {{[0-9]+}}(%esp), %eax
; X86-NEXT:    movl %eax, (%esp)
; X86-NEXT:    calll roundf128
; X86-NEXT:    subl $4, %esp
; X86-NEXT:    movaps {{[0-9]+}}(%esp), %xmm0
; X86-NEXT:    movaps %xmm0, vf128
; X86-NEXT:    addl $56, %esp
; X86-NEXT:    popl %esi
; X86-NEXT:    retl
;
; WIN-LABEL: Test128Round:
; WIN:       # %bb.0: # %entry
; WIN-NEXT:    subq $56, %rsp
; WIN-NEXT:    movaps (%rcx), %xmm0
; WIN-NEXT:    movaps %xmm0, {{[0-9]+}}(%rsp)
; WIN-NEXT:    leaq {{[0-9]+}}(%rsp), %rcx
; WIN-NEXT:    callq roundl
; WIN-NEXT:    movaps %xmm0, vf128(%rip)
; WIN-NEXT:    addq $56, %rsp
; WIN-NEXT:    retq
;
; WIN-X86-LABEL: Test128Round:
; WIN-X86:       # %bb.0: # %entry
; WIN-X86-NEXT:    pushl %ebp
; WIN-X86-NEXT:    movl %esp, %ebp
; WIN-X86-NEXT:    pushl %esi
; WIN-X86-NEXT:    andl $-16, %esp
; WIN-X86-NEXT:    subl $64, %esp
; WIN-X86-NEXT:    movl 8(%ebp), %eax
; WIN-X86-NEXT:    movl 12(%ebp), %ecx
; WIN-X86-NEXT:    movl 16(%ebp), %edx
; WIN-X86-NEXT:    movl 20(%ebp), %esi
; WIN-X86-NEXT:    movl %esi, {{[0-9]+}}(%esp)
; WIN-X86-NEXT:    movl %edx, {{[0-9]+}}(%esp)
; WIN-X86-NEXT:    movl %ecx, {{[0-9]+}}(%esp)
; WIN-X86-NEXT:    movl %eax, {{[0-9]+}}(%esp)
; WIN-X86-NEXT:    leal {{[0-9]+}}(%esp), %eax
; WIN-X86-NEXT:    movl %eax, (%esp)
; WIN-X86-NEXT:    calll _roundl
; WIN-X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; WIN-X86-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; WIN-X86-NEXT:    movl {{[0-9]+}}(%esp), %edx
; WIN-X86-NEXT:    movl {{[0-9]+}}(%esp), %esi
; WIN-X86-NEXT:    movl %esi, _vf128+12
; WIN-X86-NEXT:    movl %edx, _vf128+8
; WIN-X86-NEXT:    movl %ecx, _vf128+4
; WIN-X86-NEXT:    movl %eax, _vf128
; WIN-X86-NEXT:    leal -4(%ebp), %esp
; WIN-X86-NEXT:    popl %esi
; WIN-X86-NEXT:    popl %ebp
; WIN-X86-NEXT:    retl
entry:
  %sqrt = call fp128 @llvm.round.f128(fp128 %d1)
  store fp128 %sqrt, ptr @vf128, align 16
  ret void
}
declare fp128 @llvm.round.f128(fp128)

define fp128 @Test128FMA(fp128 %a, fp128 %b, fp128 %c) nounwind {
; ANDROID-LABEL: Test128FMA:
; ANDROID:       # %bb.0: # %entry
; ANDROID-NEXT:    jmp fmal@PLT # TAILCALL
;
; GNU-LABEL: Test128FMA:
; GNU:       # %bb.0: # %entry
; GNU-NEXT:    jmp fmaf128@PLT # TAILCALL
;
; X86-LABEL: Test128FMA:
; X86:       # %bb.0: # %entry
; X86-NEXT:    pushl %ebp
; X86-NEXT:    pushl %ebx
; X86-NEXT:    pushl %edi
; X86-NEXT:    pushl %esi
; X86-NEXT:    subl $92, %esp
; X86-NEXT:    movl {{[0-9]+}}(%esp), %ebp
; X86-NEXT:    movl {{[0-9]+}}(%esp), %ebx
; X86-NEXT:    movl {{[0-9]+}}(%esp), %edi
; X86-NEXT:    movl {{[0-9]+}}(%esp), %esi
; X86-NEXT:    movl {{[0-9]+}}(%esp), %edx
; X86-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    movl %eax, {{[0-9]+}}(%esp)
; X86-NEXT:    movl %ecx, {{[0-9]+}}(%esp)
; X86-NEXT:    movl %edx, {{[0-9]+}}(%esp)
; X86-NEXT:    movl %esi, {{[0-9]+}}(%esp)
; X86-NEXT:    movl %edi, {{[0-9]+}}(%esp)
; X86-NEXT:    movl %ebx, {{[0-9]+}}(%esp)
; X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    movl %eax, {{[0-9]+}}(%esp)
; X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    movl %eax, {{[0-9]+}}(%esp)
; X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    movl %eax, {{[0-9]+}}(%esp)
; X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    movl %eax, {{[0-9]+}}(%esp)
; X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    movl %eax, {{[0-9]+}}(%esp)
; X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    movl %eax, {{[0-9]+}}(%esp)
; X86-NEXT:    leal {{[0-9]+}}(%esp), %eax
; X86-NEXT:    movl %eax, (%esp)
; X86-NEXT:    calll fmaf128
; X86-NEXT:    subl $4, %esp
; X86-NEXT:    movaps {{[0-9]+}}(%esp), %xmm0
; X86-NEXT:    movaps %xmm0, (%ebp)
; X86-NEXT:    movl %ebp, %eax
; X86-NEXT:    addl $92, %esp
; X86-NEXT:    popl %esi
; X86-NEXT:    popl %edi
; X86-NEXT:    popl %ebx
; X86-NEXT:    popl %ebp
; X86-NEXT:    retl $4
;
; WIN-LABEL: Test128FMA:
; WIN:       # %bb.0: # %entry
; WIN-NEXT:    subq $88, %rsp
; WIN-NEXT:    movaps (%r8), %xmm0
; WIN-NEXT:    movaps (%rcx), %xmm1
; WIN-NEXT:    movaps (%rdx), %xmm2
; WIN-NEXT:    movaps %xmm2, {{[0-9]+}}(%rsp)
; WIN-NEXT:    movaps %xmm1, {{[0-9]+}}(%rsp)
; WIN-NEXT:    movaps %xmm0, {{[0-9]+}}(%rsp)
; WIN-NEXT:    leaq {{[0-9]+}}(%rsp), %rcx
; WIN-NEXT:    leaq {{[0-9]+}}(%rsp), %rdx
; WIN-NEXT:    leaq {{[0-9]+}}(%rsp), %r8
; WIN-NEXT:    callq fmal
; WIN-NEXT:    addq $88, %rsp
; WIN-NEXT:    retq
;
; WIN-X86-LABEL: Test128FMA:
; WIN-X86:       # %bb.0: # %entry
; WIN-X86-NEXT:    pushl %ebp
; WIN-X86-NEXT:    movl %esp, %ebp
; WIN-X86-NEXT:    pushl %ebx
; WIN-X86-NEXT:    pushl %edi
; WIN-X86-NEXT:    pushl %esi
; WIN-X86-NEXT:    andl $-16, %esp
; WIN-X86-NEXT:    subl $96, %esp
; WIN-X86-NEXT:    movl 8(%ebp), %esi
; WIN-X86-NEXT:    movl 52(%ebp), %ebx
; WIN-X86-NEXT:    movl 56(%ebp), %edi
; WIN-X86-NEXT:    movl 60(%ebp), %edx
; WIN-X86-NEXT:    movl 64(%ebp), %ecx
; WIN-X86-NEXT:    movl 68(%ebp), %eax
; WIN-X86-NEXT:    movl %eax, {{[0-9]+}}(%esp)
; WIN-X86-NEXT:    movl %ecx, {{[0-9]+}}(%esp)
; WIN-X86-NEXT:    movl %edx, {{[0-9]+}}(%esp)
; WIN-X86-NEXT:    movl %edi, {{[0-9]+}}(%esp)
; WIN-X86-NEXT:    movl %ebx, {{[0-9]+}}(%esp)
; WIN-X86-NEXT:    movl 48(%ebp), %eax
; WIN-X86-NEXT:    movl %eax, {{[0-9]+}}(%esp)
; WIN-X86-NEXT:    movl 44(%ebp), %eax
; WIN-X86-NEXT:    movl %eax, {{[0-9]+}}(%esp)
; WIN-X86-NEXT:    movl 40(%ebp), %eax
; WIN-X86-NEXT:    movl %eax, {{[0-9]+}}(%esp)
; WIN-X86-NEXT:    movl 36(%ebp), %eax
; WIN-X86-NEXT:    movl %eax, {{[0-9]+}}(%esp)
; WIN-X86-NEXT:    movl 32(%ebp), %eax
; WIN-X86-NEXT:    movl %eax, {{[0-9]+}}(%esp)
; WIN-X86-NEXT:    movl 28(%ebp), %eax
; WIN-X86-NEXT:    movl %eax, {{[0-9]+}}(%esp)
; WIN-X86-NEXT:    movl 24(%ebp), %eax
; WIN-X86-NEXT:    movl %eax, {{[0-9]+}}(%esp)
; WIN-X86-NEXT:    leal {{[0-9]+}}(%esp), %eax
; WIN-X86-NEXT:    movl %eax, (%esp)
; WIN-X86-NEXT:    calll _fmal
; WIN-X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; WIN-X86-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; WIN-X86-NEXT:    movl {{[0-9]+}}(%esp), %edx
; WIN-X86-NEXT:    movl {{[0-9]+}}(%esp), %edi
; WIN-X86-NEXT:    movl %edi, 12(%esi)
; WIN-X86-NEXT:    movl %edx, 8(%esi)
; WIN-X86-NEXT:    movl %ecx, 4(%esi)
; WIN-X86-NEXT:    movl %eax, (%esi)
; WIN-X86-NEXT:    movl %esi, %eax
; WIN-X86-NEXT:    leal -12(%ebp), %esp
; WIN-X86-NEXT:    popl %esi
; WIN-X86-NEXT:    popl %edi
; WIN-X86-NEXT:    popl %ebx
; WIN-X86-NEXT:    popl %ebp
; WIN-X86-NEXT:    retl
entry:
  %call = call fp128 @llvm.fma.f128(fp128 %a, fp128 %b, fp128 %c)
  ret fp128 %call
}
declare fp128 @llvm.fma.f128(fp128, fp128, fp128)

define fp128 @Test128Acos(fp128 %a) nounwind {
; ANDROID-LABEL: Test128Acos:
; ANDROID:       # %bb.0:
; ANDROID-NEXT:    jmp acosl@PLT # TAILCALL
;
; GNU-LABEL: Test128Acos:
; GNU:       # %bb.0:
; GNU-NEXT:    jmp acosf128@PLT # TAILCALL
;
; X86-LABEL: Test128Acos:
; X86:       # %bb.0:
; X86-NEXT:    pushl %edi
; X86-NEXT:    pushl %esi
; X86-NEXT:    subl $52, %esp
; X86-NEXT:    movl {{[0-9]+}}(%esp), %esi
; X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; X86-NEXT:    movl {{[0-9]+}}(%esp), %edx
; X86-NEXT:    movl {{[0-9]+}}(%esp), %edi
; X86-NEXT:    movl %edi, {{[0-9]+}}(%esp)
; X86-NEXT:    movl %edx, {{[0-9]+}}(%esp)
; X86-NEXT:    movl %ecx, {{[0-9]+}}(%esp)
; X86-NEXT:    movl %eax, {{[0-9]+}}(%esp)
; X86-NEXT:    leal {{[0-9]+}}(%esp), %eax
; X86-NEXT:    movl %eax, (%esp)
; X86-NEXT:    calll acosf128
; X86-NEXT:    subl $4, %esp
; X86-NEXT:    movaps {{[0-9]+}}(%esp), %xmm0
; X86-NEXT:    movaps %xmm0, (%esi)
; X86-NEXT:    movl %esi, %eax
; X86-NEXT:    addl $52, %esp
; X86-NEXT:    popl %esi
; X86-NEXT:    popl %edi
; X86-NEXT:    retl $4
;
; WIN-LABEL: Test128Acos:
; WIN:       # %bb.0:
; WIN-NEXT:    subq $56, %rsp
; WIN-NEXT:    movaps (%rcx), %xmm0
; WIN-NEXT:    movaps %xmm0, {{[0-9]+}}(%rsp)
; WIN-NEXT:    leaq {{[0-9]+}}(%rsp), %rcx
; WIN-NEXT:    callq acosl
; WIN-NEXT:    addq $56, %rsp
; WIN-NEXT:    retq
;
; WIN-X86-LABEL: Test128Acos:
; WIN-X86:       # %bb.0:
; WIN-X86-NEXT:    pushl %ebp
; WIN-X86-NEXT:    movl %esp, %ebp
; WIN-X86-NEXT:    pushl %edi
; WIN-X86-NEXT:    pushl %esi
; WIN-X86-NEXT:    andl $-16, %esp
; WIN-X86-NEXT:    subl $48, %esp
; WIN-X86-NEXT:    movl 8(%ebp), %esi
; WIN-X86-NEXT:    movl 24(%ebp), %eax
; WIN-X86-NEXT:    movl 28(%ebp), %ecx
; WIN-X86-NEXT:    movl 32(%ebp), %edx
; WIN-X86-NEXT:    movl 36(%ebp), %edi
; WIN-X86-NEXT:    movl %edi, {{[0-9]+}}(%esp)
; WIN-X86-NEXT:    movl %edx, {{[0-9]+}}(%esp)
; WIN-X86-NEXT:    movl %ecx, {{[0-9]+}}(%esp)
; WIN-X86-NEXT:    movl %eax, {{[0-9]+}}(%esp)
; WIN-X86-NEXT:    leal {{[0-9]+}}(%esp), %eax
; WIN-X86-NEXT:    movl %eax, (%esp)
; WIN-X86-NEXT:    calll _acosl
; WIN-X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; WIN-X86-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; WIN-X86-NEXT:    movl {{[0-9]+}}(%esp), %edx
; WIN-X86-NEXT:    movl {{[0-9]+}}(%esp), %edi
; WIN-X86-NEXT:    movl %edi, 12(%esi)
; WIN-X86-NEXT:    movl %edx, 8(%esi)
; WIN-X86-NEXT:    movl %ecx, 4(%esi)
; WIN-X86-NEXT:    movl %eax, (%esi)
; WIN-X86-NEXT:    movl %esi, %eax
; WIN-X86-NEXT:    leal -8(%ebp), %esp
; WIN-X86-NEXT:    popl %esi
; WIN-X86-NEXT:    popl %edi
; WIN-X86-NEXT:    popl %ebp
; WIN-X86-NEXT:    retl
  %x = call fp128 @llvm.acos.f128(fp128 %a)
  ret fp128 %x
}

define fp128 @Test128Asin(fp128 %a) nounwind {
; ANDROID-LABEL: Test128Asin:
; ANDROID:       # %bb.0:
; ANDROID-NEXT:    jmp asinl@PLT # TAILCALL
;
; GNU-LABEL: Test128Asin:
; GNU:       # %bb.0:
; GNU-NEXT:    jmp asinf128@PLT # TAILCALL
;
; X86-LABEL: Test128Asin:
; X86:       # %bb.0:
; X86-NEXT:    pushl %edi
; X86-NEXT:    pushl %esi
; X86-NEXT:    subl $52, %esp
; X86-NEXT:    movl {{[0-9]+}}(%esp), %esi
; X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; X86-NEXT:    movl {{[0-9]+}}(%esp), %edx
; X86-NEXT:    movl {{[0-9]+}}(%esp), %edi
; X86-NEXT:    movl %edi, {{[0-9]+}}(%esp)
; X86-NEXT:    movl %edx, {{[0-9]+}}(%esp)
; X86-NEXT:    movl %ecx, {{[0-9]+}}(%esp)
; X86-NEXT:    movl %eax, {{[0-9]+}}(%esp)
; X86-NEXT:    leal {{[0-9]+}}(%esp), %eax
; X86-NEXT:    movl %eax, (%esp)
; X86-NEXT:    calll asinf128
; X86-NEXT:    subl $4, %esp
; X86-NEXT:    movaps {{[0-9]+}}(%esp), %xmm0
; X86-NEXT:    movaps %xmm0, (%esi)
; X86-NEXT:    movl %esi, %eax
; X86-NEXT:    addl $52, %esp
; X86-NEXT:    popl %esi
; X86-NEXT:    popl %edi
; X86-NEXT:    retl $4
;
; WIN-LABEL: Test128Asin:
; WIN:       # %bb.0:
; WIN-NEXT:    subq $56, %rsp
; WIN-NEXT:    movaps (%rcx), %xmm0
; WIN-NEXT:    movaps %xmm0, {{[0-9]+}}(%rsp)
; WIN-NEXT:    leaq {{[0-9]+}}(%rsp), %rcx
; WIN-NEXT:    callq asinl
; WIN-NEXT:    addq $56, %rsp
; WIN-NEXT:    retq
;
; WIN-X86-LABEL: Test128Asin:
; WIN-X86:       # %bb.0:
; WIN-X86-NEXT:    pushl %ebp
; WIN-X86-NEXT:    movl %esp, %ebp
; WIN-X86-NEXT:    pushl %edi
; WIN-X86-NEXT:    pushl %esi
; WIN-X86-NEXT:    andl $-16, %esp
; WIN-X86-NEXT:    subl $48, %esp
; WIN-X86-NEXT:    movl 8(%ebp), %esi
; WIN-X86-NEXT:    movl 24(%ebp), %eax
; WIN-X86-NEXT:    movl 28(%ebp), %ecx
; WIN-X86-NEXT:    movl 32(%ebp), %edx
; WIN-X86-NEXT:    movl 36(%ebp), %edi
; WIN-X86-NEXT:    movl %edi, {{[0-9]+}}(%esp)
; WIN-X86-NEXT:    movl %edx, {{[0-9]+}}(%esp)
; WIN-X86-NEXT:    movl %ecx, {{[0-9]+}}(%esp)
; WIN-X86-NEXT:    movl %eax, {{[0-9]+}}(%esp)
; WIN-X86-NEXT:    leal {{[0-9]+}}(%esp), %eax
; WIN-X86-NEXT:    movl %eax, (%esp)
; WIN-X86-NEXT:    calll _asinl
; WIN-X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; WIN-X86-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; WIN-X86-NEXT:    movl {{[0-9]+}}(%esp), %edx
; WIN-X86-NEXT:    movl {{[0-9]+}}(%esp), %edi
; WIN-X86-NEXT:    movl %edi, 12(%esi)
; WIN-X86-NEXT:    movl %edx, 8(%esi)
; WIN-X86-NEXT:    movl %ecx, 4(%esi)
; WIN-X86-NEXT:    movl %eax, (%esi)
; WIN-X86-NEXT:    movl %esi, %eax
; WIN-X86-NEXT:    leal -8(%ebp), %esp
; WIN-X86-NEXT:    popl %esi
; WIN-X86-NEXT:    popl %edi
; WIN-X86-NEXT:    popl %ebp
; WIN-X86-NEXT:    retl
  %x = call fp128 @llvm.asin.f128(fp128 %a)
  ret fp128 %x
}

define fp128 @Test128Atan(fp128 %a) nounwind {
; ANDROID-LABEL: Test128Atan:
; ANDROID:       # %bb.0:
; ANDROID-NEXT:    jmp atanl@PLT # TAILCALL
;
; GNU-LABEL: Test128Atan:
; GNU:       # %bb.0:
; GNU-NEXT:    jmp atanf128@PLT # TAILCALL
;
; X86-LABEL: Test128Atan:
; X86:       # %bb.0:
; X86-NEXT:    pushl %edi
; X86-NEXT:    pushl %esi
; X86-NEXT:    subl $52, %esp
; X86-NEXT:    movl {{[0-9]+}}(%esp), %esi
; X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; X86-NEXT:    movl {{[0-9]+}}(%esp), %edx
; X86-NEXT:    movl {{[0-9]+}}(%esp), %edi
; X86-NEXT:    movl %edi, {{[0-9]+}}(%esp)
; X86-NEXT:    movl %edx, {{[0-9]+}}(%esp)
; X86-NEXT:    movl %ecx, {{[0-9]+}}(%esp)
; X86-NEXT:    movl %eax, {{[0-9]+}}(%esp)
; X86-NEXT:    leal {{[0-9]+}}(%esp), %eax
; X86-NEXT:    movl %eax, (%esp)
; X86-NEXT:    calll atanf128
; X86-NEXT:    subl $4, %esp
; X86-NEXT:    movaps {{[0-9]+}}(%esp), %xmm0
; X86-NEXT:    movaps %xmm0, (%esi)
; X86-NEXT:    movl %esi, %eax
; X86-NEXT:    addl $52, %esp
; X86-NEXT:    popl %esi
; X86-NEXT:    popl %edi
; X86-NEXT:    retl $4
;
; WIN-LABEL: Test128Atan:
; WIN:       # %bb.0:
; WIN-NEXT:    subq $56, %rsp
; WIN-NEXT:    movaps (%rcx), %xmm0
; WIN-NEXT:    movaps %xmm0, {{[0-9]+}}(%rsp)
; WIN-NEXT:    leaq {{[0-9]+}}(%rsp), %rcx
; WIN-NEXT:    callq atanl
; WIN-NEXT:    addq $56, %rsp
; WIN-NEXT:    retq
;
; WIN-X86-LABEL: Test128Atan:
; WIN-X86:       # %bb.0:
; WIN-X86-NEXT:    pushl %ebp
; WIN-X86-NEXT:    movl %esp, %ebp
; WIN-X86-NEXT:    pushl %edi
; WIN-X86-NEXT:    pushl %esi
; WIN-X86-NEXT:    andl $-16, %esp
; WIN-X86-NEXT:    subl $48, %esp
; WIN-X86-NEXT:    movl 8(%ebp), %esi
; WIN-X86-NEXT:    movl 24(%ebp), %eax
; WIN-X86-NEXT:    movl 28(%ebp), %ecx
; WIN-X86-NEXT:    movl 32(%ebp), %edx
; WIN-X86-NEXT:    movl 36(%ebp), %edi
; WIN-X86-NEXT:    movl %edi, {{[0-9]+}}(%esp)
; WIN-X86-NEXT:    movl %edx, {{[0-9]+}}(%esp)
; WIN-X86-NEXT:    movl %ecx, {{[0-9]+}}(%esp)
; WIN-X86-NEXT:    movl %eax, {{[0-9]+}}(%esp)
; WIN-X86-NEXT:    leal {{[0-9]+}}(%esp), %eax
; WIN-X86-NEXT:    movl %eax, (%esp)
; WIN-X86-NEXT:    calll _atanl
; WIN-X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; WIN-X86-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; WIN-X86-NEXT:    movl {{[0-9]+}}(%esp), %edx
; WIN-X86-NEXT:    movl {{[0-9]+}}(%esp), %edi
; WIN-X86-NEXT:    movl %edi, 12(%esi)
; WIN-X86-NEXT:    movl %edx, 8(%esi)
; WIN-X86-NEXT:    movl %ecx, 4(%esi)
; WIN-X86-NEXT:    movl %eax, (%esi)
; WIN-X86-NEXT:    movl %esi, %eax
; WIN-X86-NEXT:    leal -8(%ebp), %esp
; WIN-X86-NEXT:    popl %esi
; WIN-X86-NEXT:    popl %edi
; WIN-X86-NEXT:    popl %ebp
; WIN-X86-NEXT:    retl
  %x = call fp128 @llvm.atan.f128(fp128 %a)
  ret fp128 %x
}

define fp128 @Test128Atan2(fp128 %a, fp128 %b) nounwind {
; ANDROID-LABEL: Test128Atan2:
; ANDROID:       # %bb.0:
; ANDROID-NEXT:    jmp atan2l@PLT # TAILCALL
;
; GNU-LABEL: Test128Atan2:
; GNU:       # %bb.0:
; GNU-NEXT:    jmp atan2f128@PLT # TAILCALL
;
; X86-LABEL: Test128Atan2:
; X86:       # %bb.0:
; X86-NEXT:    pushl %ebp
; X86-NEXT:    pushl %ebx
; X86-NEXT:    pushl %edi
; X86-NEXT:    pushl %esi
; X86-NEXT:    subl $76, %esp
; X86-NEXT:    movl {{[0-9]+}}(%esp), %esi
; X86-NEXT:    movl {{[0-9]+}}(%esp), %edx
; X86-NEXT:    movl {{[0-9]+}}(%esp), %edi
; X86-NEXT:    movl {{[0-9]+}}(%esp), %ebx
; X86-NEXT:    movl {{[0-9]+}}(%esp), %ebp
; X86-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    movl %eax, {{[0-9]+}}(%esp)
; X86-NEXT:    movl %ecx, {{[0-9]+}}(%esp)
; X86-NEXT:    movl %ebp, {{[0-9]+}}(%esp)
; X86-NEXT:    movl %ebx, {{[0-9]+}}(%esp)
; X86-NEXT:    movl %edi, {{[0-9]+}}(%esp)
; X86-NEXT:    movl %edx, {{[0-9]+}}(%esp)
; X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    movl %eax, {{[0-9]+}}(%esp)
; X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    movl %eax, {{[0-9]+}}(%esp)
; X86-NEXT:    leal {{[0-9]+}}(%esp), %eax
; X86-NEXT:    movl %eax, (%esp)
; X86-NEXT:    calll atan2f128
; X86-NEXT:    subl $4, %esp
; X86-NEXT:    movaps {{[0-9]+}}(%esp), %xmm0
; X86-NEXT:    movaps %xmm0, (%esi)
; X86-NEXT:    movl %esi, %eax
; X86-NEXT:    addl $76, %esp
; X86-NEXT:    popl %esi
; X86-NEXT:    popl %edi
; X86-NEXT:    popl %ebx
; X86-NEXT:    popl %ebp
; X86-NEXT:    retl $4
;
; WIN-LABEL: Test128Atan2:
; WIN:       # %bb.0:
; WIN-NEXT:    subq $72, %rsp
; WIN-NEXT:    movaps (%rcx), %xmm0
; WIN-NEXT:    movaps (%rdx), %xmm1
; WIN-NEXT:    movaps %xmm1, {{[0-9]+}}(%rsp)
; WIN-NEXT:    movaps %xmm0, {{[0-9]+}}(%rsp)
; WIN-NEXT:    leaq {{[0-9]+}}(%rsp), %rcx
; WIN-NEXT:    leaq {{[0-9]+}}(%rsp), %rdx
; WIN-NEXT:    callq atan2l
; WIN-NEXT:    addq $72, %rsp
; WIN-NEXT:    retq
;
; WIN-X86-LABEL: Test128Atan2:
; WIN-X86:       # %bb.0:
; WIN-X86-NEXT:    pushl %ebp
; WIN-X86-NEXT:    movl %esp, %ebp
; WIN-X86-NEXT:    pushl %ebx
; WIN-X86-NEXT:    pushl %edi
; WIN-X86-NEXT:    pushl %esi
; WIN-X86-NEXT:    andl $-16, %esp
; WIN-X86-NEXT:    subl $80, %esp
; WIN-X86-NEXT:    movl 8(%ebp), %esi
; WIN-X86-NEXT:    movl 36(%ebp), %edi
; WIN-X86-NEXT:    movl 40(%ebp), %ebx
; WIN-X86-NEXT:    movl 44(%ebp), %edx
; WIN-X86-NEXT:    movl 48(%ebp), %ecx
; WIN-X86-NEXT:    movl 52(%ebp), %eax
; WIN-X86-NEXT:    movl %eax, {{[0-9]+}}(%esp)
; WIN-X86-NEXT:    movl %ecx, {{[0-9]+}}(%esp)
; WIN-X86-NEXT:    movl %edx, {{[0-9]+}}(%esp)
; WIN-X86-NEXT:    movl %ebx, {{[0-9]+}}(%esp)
; WIN-X86-NEXT:    movl %edi, {{[0-9]+}}(%esp)
; WIN-X86-NEXT:    movl 32(%ebp), %eax
; WIN-X86-NEXT:    movl %eax, {{[0-9]+}}(%esp)
; WIN-X86-NEXT:    movl 28(%ebp), %eax
; WIN-X86-NEXT:    movl %eax, {{[0-9]+}}(%esp)
; WIN-X86-NEXT:    movl 24(%ebp), %eax
; WIN-X86-NEXT:    movl %eax, {{[0-9]+}}(%esp)
; WIN-X86-NEXT:    leal {{[0-9]+}}(%esp), %eax
; WIN-X86-NEXT:    movl %eax, (%esp)
; WIN-X86-NEXT:    calll _atan2l
; WIN-X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; WIN-X86-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; WIN-X86-NEXT:    movl {{[0-9]+}}(%esp), %edx
; WIN-X86-NEXT:    movl {{[0-9]+}}(%esp), %edi
; WIN-X86-NEXT:    movl %edi, 12(%esi)
; WIN-X86-NEXT:    movl %edx, 8(%esi)
; WIN-X86-NEXT:    movl %ecx, 4(%esi)
; WIN-X86-NEXT:    movl %eax, (%esi)
; WIN-X86-NEXT:    movl %esi, %eax
; WIN-X86-NEXT:    leal -12(%ebp), %esp
; WIN-X86-NEXT:    popl %esi
; WIN-X86-NEXT:    popl %edi
; WIN-X86-NEXT:    popl %ebx
; WIN-X86-NEXT:    popl %ebp
; WIN-X86-NEXT:    retl
  %x = call fp128 @llvm.atan2.f128(fp128 %a, fp128 %b)
  ret fp128 %x
}

define fp128 @Test128Cosh(fp128 %a) nounwind {
; ANDROID-LABEL: Test128Cosh:
; ANDROID:       # %bb.0:
; ANDROID-NEXT:    jmp coshl@PLT # TAILCALL
;
; GNU-LABEL: Test128Cosh:
; GNU:       # %bb.0:
; GNU-NEXT:    jmp coshf128@PLT # TAILCALL
;
; X86-LABEL: Test128Cosh:
; X86:       # %bb.0:
; X86-NEXT:    pushl %edi
; X86-NEXT:    pushl %esi
; X86-NEXT:    subl $52, %esp
; X86-NEXT:    movl {{[0-9]+}}(%esp), %esi
; X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; X86-NEXT:    movl {{[0-9]+}}(%esp), %edx
; X86-NEXT:    movl {{[0-9]+}}(%esp), %edi
; X86-NEXT:    movl %edi, {{[0-9]+}}(%esp)
; X86-NEXT:    movl %edx, {{[0-9]+}}(%esp)
; X86-NEXT:    movl %ecx, {{[0-9]+}}(%esp)
; X86-NEXT:    movl %eax, {{[0-9]+}}(%esp)
; X86-NEXT:    leal {{[0-9]+}}(%esp), %eax
; X86-NEXT:    movl %eax, (%esp)
; X86-NEXT:    calll coshf128
; X86-NEXT:    subl $4, %esp
; X86-NEXT:    movaps {{[0-9]+}}(%esp), %xmm0
; X86-NEXT:    movaps %xmm0, (%esi)
; X86-NEXT:    movl %esi, %eax
; X86-NEXT:    addl $52, %esp
; X86-NEXT:    popl %esi
; X86-NEXT:    popl %edi
; X86-NEXT:    retl $4
;
; WIN-LABEL: Test128Cosh:
; WIN:       # %bb.0:
; WIN-NEXT:    subq $56, %rsp
; WIN-NEXT:    movaps (%rcx), %xmm0
; WIN-NEXT:    movaps %xmm0, {{[0-9]+}}(%rsp)
; WIN-NEXT:    leaq {{[0-9]+}}(%rsp), %rcx
; WIN-NEXT:    callq coshl
; WIN-NEXT:    addq $56, %rsp
; WIN-NEXT:    retq
;
; WIN-X86-LABEL: Test128Cosh:
; WIN-X86:       # %bb.0:
; WIN-X86-NEXT:    pushl %ebp
; WIN-X86-NEXT:    movl %esp, %ebp
; WIN-X86-NEXT:    pushl %edi
; WIN-X86-NEXT:    pushl %esi
; WIN-X86-NEXT:    andl $-16, %esp
; WIN-X86-NEXT:    subl $48, %esp
; WIN-X86-NEXT:    movl 8(%ebp), %esi
; WIN-X86-NEXT:    movl 24(%ebp), %eax
; WIN-X86-NEXT:    movl 28(%ebp), %ecx
; WIN-X86-NEXT:    movl 32(%ebp), %edx
; WIN-X86-NEXT:    movl 36(%ebp), %edi
; WIN-X86-NEXT:    movl %edi, {{[0-9]+}}(%esp)
; WIN-X86-NEXT:    movl %edx, {{[0-9]+}}(%esp)
; WIN-X86-NEXT:    movl %ecx, {{[0-9]+}}(%esp)
; WIN-X86-NEXT:    movl %eax, {{[0-9]+}}(%esp)
; WIN-X86-NEXT:    leal {{[0-9]+}}(%esp), %eax
; WIN-X86-NEXT:    movl %eax, (%esp)
; WIN-X86-NEXT:    calll _coshl
; WIN-X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; WIN-X86-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; WIN-X86-NEXT:    movl {{[0-9]+}}(%esp), %edx
; WIN-X86-NEXT:    movl {{[0-9]+}}(%esp), %edi
; WIN-X86-NEXT:    movl %edi, 12(%esi)
; WIN-X86-NEXT:    movl %edx, 8(%esi)
; WIN-X86-NEXT:    movl %ecx, 4(%esi)
; WIN-X86-NEXT:    movl %eax, (%esi)
; WIN-X86-NEXT:    movl %esi, %eax
; WIN-X86-NEXT:    leal -8(%ebp), %esp
; WIN-X86-NEXT:    popl %esi
; WIN-X86-NEXT:    popl %edi
; WIN-X86-NEXT:    popl %ebp
; WIN-X86-NEXT:    retl
  %x = call fp128 @llvm.cosh.f128(fp128 %a)
  ret fp128 %x
}

define fp128 @Test128Sinh(fp128 %a) nounwind {
; ANDROID-LABEL: Test128Sinh:
; ANDROID:       # %bb.0:
; ANDROID-NEXT:    jmp sinhl@PLT # TAILCALL
;
; GNU-LABEL: Test128Sinh:
; GNU:       # %bb.0:
; GNU-NEXT:    jmp sinhf128@PLT # TAILCALL
;
; X86-LABEL: Test128Sinh:
; X86:       # %bb.0:
; X86-NEXT:    pushl %edi
; X86-NEXT:    pushl %esi
; X86-NEXT:    subl $52, %esp
; X86-NEXT:    movl {{[0-9]+}}(%esp), %esi
; X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; X86-NEXT:    movl {{[0-9]+}}(%esp), %edx
; X86-NEXT:    movl {{[0-9]+}}(%esp), %edi
; X86-NEXT:    movl %edi, {{[0-9]+}}(%esp)
; X86-NEXT:    movl %edx, {{[0-9]+}}(%esp)
; X86-NEXT:    movl %ecx, {{[0-9]+}}(%esp)
; X86-NEXT:    movl %eax, {{[0-9]+}}(%esp)
; X86-NEXT:    leal {{[0-9]+}}(%esp), %eax
; X86-NEXT:    movl %eax, (%esp)
; X86-NEXT:    calll sinhf128
; X86-NEXT:    subl $4, %esp
; X86-NEXT:    movaps {{[0-9]+}}(%esp), %xmm0
; X86-NEXT:    movaps %xmm0, (%esi)
; X86-NEXT:    movl %esi, %eax
; X86-NEXT:    addl $52, %esp
; X86-NEXT:    popl %esi
; X86-NEXT:    popl %edi
; X86-NEXT:    retl $4
;
; WIN-LABEL: Test128Sinh:
; WIN:       # %bb.0:
; WIN-NEXT:    subq $56, %rsp
; WIN-NEXT:    movaps (%rcx), %xmm0
; WIN-NEXT:    movaps %xmm0, {{[0-9]+}}(%rsp)
; WIN-NEXT:    leaq {{[0-9]+}}(%rsp), %rcx
; WIN-NEXT:    callq sinhl
; WIN-NEXT:    addq $56, %rsp
; WIN-NEXT:    retq
;
; WIN-X86-LABEL: Test128Sinh:
; WIN-X86:       # %bb.0:
; WIN-X86-NEXT:    pushl %ebp
; WIN-X86-NEXT:    movl %esp, %ebp
; WIN-X86-NEXT:    pushl %edi
; WIN-X86-NEXT:    pushl %esi
; WIN-X86-NEXT:    andl $-16, %esp
; WIN-X86-NEXT:    subl $48, %esp
; WIN-X86-NEXT:    movl 8(%ebp), %esi
; WIN-X86-NEXT:    movl 24(%ebp), %eax
; WIN-X86-NEXT:    movl 28(%ebp), %ecx
; WIN-X86-NEXT:    movl 32(%ebp), %edx
; WIN-X86-NEXT:    movl 36(%ebp), %edi
; WIN-X86-NEXT:    movl %edi, {{[0-9]+}}(%esp)
; WIN-X86-NEXT:    movl %edx, {{[0-9]+}}(%esp)
; WIN-X86-NEXT:    movl %ecx, {{[0-9]+}}(%esp)
; WIN-X86-NEXT:    movl %eax, {{[0-9]+}}(%esp)
; WIN-X86-NEXT:    leal {{[0-9]+}}(%esp), %eax
; WIN-X86-NEXT:    movl %eax, (%esp)
; WIN-X86-NEXT:    calll _sinhl
; WIN-X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; WIN-X86-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; WIN-X86-NEXT:    movl {{[0-9]+}}(%esp), %edx
; WIN-X86-NEXT:    movl {{[0-9]+}}(%esp), %edi
; WIN-X86-NEXT:    movl %edi, 12(%esi)
; WIN-X86-NEXT:    movl %edx, 8(%esi)
; WIN-X86-NEXT:    movl %ecx, 4(%esi)
; WIN-X86-NEXT:    movl %eax, (%esi)
; WIN-X86-NEXT:    movl %esi, %eax
; WIN-X86-NEXT:    leal -8(%ebp), %esp
; WIN-X86-NEXT:    popl %esi
; WIN-X86-NEXT:    popl %edi
; WIN-X86-NEXT:    popl %ebp
; WIN-X86-NEXT:    retl
  %x = call fp128 @llvm.sinh.f128(fp128 %a)
  ret fp128 %x
}

define fp128 @Test128Tan(fp128 %a) nounwind {
; ANDROID-LABEL: Test128Tan:
; ANDROID:       # %bb.0:
; ANDROID-NEXT:    jmp tanl@PLT # TAILCALL
;
; GNU-LABEL: Test128Tan:
; GNU:       # %bb.0:
; GNU-NEXT:    jmp tanf128@PLT # TAILCALL
;
; X86-LABEL: Test128Tan:
; X86:       # %bb.0:
; X86-NEXT:    pushl %edi
; X86-NEXT:    pushl %esi
; X86-NEXT:    subl $52, %esp
; X86-NEXT:    movl {{[0-9]+}}(%esp), %esi
; X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; X86-NEXT:    movl {{[0-9]+}}(%esp), %edx
; X86-NEXT:    movl {{[0-9]+}}(%esp), %edi
; X86-NEXT:    movl %edi, {{[0-9]+}}(%esp)
; X86-NEXT:    movl %edx, {{[0-9]+}}(%esp)
; X86-NEXT:    movl %ecx, {{[0-9]+}}(%esp)
; X86-NEXT:    movl %eax, {{[0-9]+}}(%esp)
; X86-NEXT:    leal {{[0-9]+}}(%esp), %eax
; X86-NEXT:    movl %eax, (%esp)
; X86-NEXT:    calll tanf128
; X86-NEXT:    subl $4, %esp
; X86-NEXT:    movaps {{[0-9]+}}(%esp), %xmm0
; X86-NEXT:    movaps %xmm0, (%esi)
; X86-NEXT:    movl %esi, %eax
; X86-NEXT:    addl $52, %esp
; X86-NEXT:    popl %esi
; X86-NEXT:    popl %edi
; X86-NEXT:    retl $4
;
; WIN-LABEL: Test128Tan:
; WIN:       # %bb.0:
; WIN-NEXT:    subq $56, %rsp
; WIN-NEXT:    movaps (%rcx), %xmm0
; WIN-NEXT:    movaps %xmm0, {{[0-9]+}}(%rsp)
; WIN-NEXT:    leaq {{[0-9]+}}(%rsp), %rcx
; WIN-NEXT:    callq tanl
; WIN-NEXT:    addq $56, %rsp
; WIN-NEXT:    retq
;
; WIN-X86-LABEL: Test128Tan:
; WIN-X86:       # %bb.0:
; WIN-X86-NEXT:    pushl %ebp
; WIN-X86-NEXT:    movl %esp, %ebp
; WIN-X86-NEXT:    pushl %edi
; WIN-X86-NEXT:    pushl %esi
; WIN-X86-NEXT:    andl $-16, %esp
; WIN-X86-NEXT:    subl $48, %esp
; WIN-X86-NEXT:    movl 8(%ebp), %esi
; WIN-X86-NEXT:    movl 24(%ebp), %eax
; WIN-X86-NEXT:    movl 28(%ebp), %ecx
; WIN-X86-NEXT:    movl 32(%ebp), %edx
; WIN-X86-NEXT:    movl 36(%ebp), %edi
; WIN-X86-NEXT:    movl %edi, {{[0-9]+}}(%esp)
; WIN-X86-NEXT:    movl %edx, {{[0-9]+}}(%esp)
; WIN-X86-NEXT:    movl %ecx, {{[0-9]+}}(%esp)
; WIN-X86-NEXT:    movl %eax, {{[0-9]+}}(%esp)
; WIN-X86-NEXT:    leal {{[0-9]+}}(%esp), %eax
; WIN-X86-NEXT:    movl %eax, (%esp)
; WIN-X86-NEXT:    calll _tanl
; WIN-X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; WIN-X86-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; WIN-X86-NEXT:    movl {{[0-9]+}}(%esp), %edx
; WIN-X86-NEXT:    movl {{[0-9]+}}(%esp), %edi
; WIN-X86-NEXT:    movl %edi, 12(%esi)
; WIN-X86-NEXT:    movl %edx, 8(%esi)
; WIN-X86-NEXT:    movl %ecx, 4(%esi)
; WIN-X86-NEXT:    movl %eax, (%esi)
; WIN-X86-NEXT:    movl %esi, %eax
; WIN-X86-NEXT:    leal -8(%ebp), %esp
; WIN-X86-NEXT:    popl %esi
; WIN-X86-NEXT:    popl %edi
; WIN-X86-NEXT:    popl %ebp
; WIN-X86-NEXT:    retl
  %x = call fp128 @llvm.tan.f128(fp128 %a)
  ret fp128 %x
}

define fp128 @Test128Tanh(fp128 %a) nounwind {
; ANDROID-LABEL: Test128Tanh:
; ANDROID:       # %bb.0:
; ANDROID-NEXT:    jmp tanhl@PLT # TAILCALL
;
; GNU-LABEL: Test128Tanh:
; GNU:       # %bb.0:
; GNU-NEXT:    jmp tanhf128@PLT # TAILCALL
;
; X86-LABEL: Test128Tanh:
; X86:       # %bb.0:
; X86-NEXT:    pushl %edi
; X86-NEXT:    pushl %esi
; X86-NEXT:    subl $52, %esp
; X86-NEXT:    movl {{[0-9]+}}(%esp), %esi
; X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; X86-NEXT:    movl {{[0-9]+}}(%esp), %edx
; X86-NEXT:    movl {{[0-9]+}}(%esp), %edi
; X86-NEXT:    movl %edi, {{[0-9]+}}(%esp)
; X86-NEXT:    movl %edx, {{[0-9]+}}(%esp)
; X86-NEXT:    movl %ecx, {{[0-9]+}}(%esp)
; X86-NEXT:    movl %eax, {{[0-9]+}}(%esp)
; X86-NEXT:    leal {{[0-9]+}}(%esp), %eax
; X86-NEXT:    movl %eax, (%esp)
; X86-NEXT:    calll tanhf128
; X86-NEXT:    subl $4, %esp
; X86-NEXT:    movaps {{[0-9]+}}(%esp), %xmm0
; X86-NEXT:    movaps %xmm0, (%esi)
; X86-NEXT:    movl %esi, %eax
; X86-NEXT:    addl $52, %esp
; X86-NEXT:    popl %esi
; X86-NEXT:    popl %edi
; X86-NEXT:    retl $4
;
; WIN-LABEL: Test128Tanh:
; WIN:       # %bb.0:
; WIN-NEXT:    subq $56, %rsp
; WIN-NEXT:    movaps (%rcx), %xmm0
; WIN-NEXT:    movaps %xmm0, {{[0-9]+}}(%rsp)
; WIN-NEXT:    leaq {{[0-9]+}}(%rsp), %rcx
; WIN-NEXT:    callq tanhl
; WIN-NEXT:    addq $56, %rsp
; WIN-NEXT:    retq
;
; WIN-X86-LABEL: Test128Tanh:
; WIN-X86:       # %bb.0:
; WIN-X86-NEXT:    pushl %ebp
; WIN-X86-NEXT:    movl %esp, %ebp
; WIN-X86-NEXT:    pushl %edi
; WIN-X86-NEXT:    pushl %esi
; WIN-X86-NEXT:    andl $-16, %esp
; WIN-X86-NEXT:    subl $48, %esp
; WIN-X86-NEXT:    movl 8(%ebp), %esi
; WIN-X86-NEXT:    movl 24(%ebp), %eax
; WIN-X86-NEXT:    movl 28(%ebp), %ecx
; WIN-X86-NEXT:    movl 32(%ebp), %edx
; WIN-X86-NEXT:    movl 36(%ebp), %edi
; WIN-X86-NEXT:    movl %edi, {{[0-9]+}}(%esp)
; WIN-X86-NEXT:    movl %edx, {{[0-9]+}}(%esp)
; WIN-X86-NEXT:    movl %ecx, {{[0-9]+}}(%esp)
; WIN-X86-NEXT:    movl %eax, {{[0-9]+}}(%esp)
; WIN-X86-NEXT:    leal {{[0-9]+}}(%esp), %eax
; WIN-X86-NEXT:    movl %eax, (%esp)
; WIN-X86-NEXT:    calll _tanhl
; WIN-X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; WIN-X86-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; WIN-X86-NEXT:    movl {{[0-9]+}}(%esp), %edx
; WIN-X86-NEXT:    movl {{[0-9]+}}(%esp), %edi
; WIN-X86-NEXT:    movl %edi, 12(%esi)
; WIN-X86-NEXT:    movl %edx, 8(%esi)
; WIN-X86-NEXT:    movl %ecx, 4(%esi)
; WIN-X86-NEXT:    movl %eax, (%esi)
; WIN-X86-NEXT:    movl %esi, %eax
; WIN-X86-NEXT:    leal -8(%ebp), %esp
; WIN-X86-NEXT:    popl %esi
; WIN-X86-NEXT:    popl %edi
; WIN-X86-NEXT:    popl %ebp
; WIN-X86-NEXT:    retl
  %x = call fp128 @llvm.tanh.f128(fp128 %a)
  ret fp128 %x
}

define { fp128, fp128 } @Test128Modf(fp128 %a) nounwind {
; ANDROID-LABEL: Test128Modf:
; ANDROID:       # %bb.0:
; ANDROID-NEXT:    subq $24, %rsp
; ANDROID-NEXT:    movq %rsp, %rdi
; ANDROID-NEXT:    callq modfl@PLT
; ANDROID-NEXT:    movaps (%rsp), %xmm1
; ANDROID-NEXT:    addq $24, %rsp
; ANDROID-NEXT:    retq
;
; GNU-LABEL: Test128Modf:
; GNU:       # %bb.0:
; GNU-NEXT:    subq $24, %rsp
; GNU-NEXT:    movq %rsp, %rdi
; GNU-NEXT:    callq modff128@PLT
; GNU-NEXT:    movaps (%rsp), %xmm1
; GNU-NEXT:    addq $24, %rsp
; GNU-NEXT:    retq
;
; X86-LABEL: Test128Modf:
; X86:       # %bb.0:
; X86-NEXT:    pushl %ebx
; X86-NEXT:    pushl %edi
; X86-NEXT:    pushl %esi
; X86-NEXT:    subl $80, %esp
; X86-NEXT:    movl {{[0-9]+}}(%esp), %esi
; X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; X86-NEXT:    movl {{[0-9]+}}(%esp), %edx
; X86-NEXT:    movl {{[0-9]+}}(%esp), %edi
; X86-NEXT:    leal {{[0-9]+}}(%esp), %ebx
; X86-NEXT:    movl %ebx, {{[0-9]+}}(%esp)
; X86-NEXT:    movl %edi, {{[0-9]+}}(%esp)
; X86-NEXT:    movl %edx, {{[0-9]+}}(%esp)
; X86-NEXT:    movl %ecx, {{[0-9]+}}(%esp)
; X86-NEXT:    movl %eax, {{[0-9]+}}(%esp)
; X86-NEXT:    leal {{[0-9]+}}(%esp), %eax
; X86-NEXT:    movl %eax, (%esp)
; X86-NEXT:    calll modff128
; X86-NEXT:    subl $4, %esp
; X86-NEXT:    movaps {{[0-9]+}}(%esp), %xmm0
; X86-NEXT:    movaps {{[0-9]+}}(%esp), %xmm1
; X86-NEXT:    movaps %xmm1, 16(%esi)
; X86-NEXT:    movaps %xmm0, (%esi)
; X86-NEXT:    movl %esi, %eax
; X86-NEXT:    addl $80, %esp
; X86-NEXT:    popl %esi
; X86-NEXT:    popl %edi
; X86-NEXT:    popl %ebx
; X86-NEXT:    retl $4
;
; WIN-LABEL: Test128Modf:
; WIN:       # %bb.0:
; WIN-NEXT:    subq $72, %rsp
; WIN-NEXT:    movaps (%rcx), %xmm0
; WIN-NEXT:    movaps %xmm0, {{[0-9]+}}(%rsp)
; WIN-NEXT:    leaq {{[0-9]+}}(%rsp), %rcx
; WIN-NEXT:    leaq {{[0-9]+}}(%rsp), %rdx
; WIN-NEXT:    callq modfl
; WIN-NEXT:    movaps {{[0-9]+}}(%rsp), %xmm1
; WIN-NEXT:    addq $72, %rsp
; WIN-NEXT:    retq
;
; WIN-X86-LABEL: Test128Modf:
; WIN-X86:       # %bb.0:
; WIN-X86-NEXT:    pushl %ebp
; WIN-X86-NEXT:    movl %esp, %ebp
; WIN-X86-NEXT:    pushl %ebx
; WIN-X86-NEXT:    pushl %edi
; WIN-X86-NEXT:    pushl %esi
; WIN-X86-NEXT:    andl $-16, %esp
; WIN-X86-NEXT:    subl $112, %esp
; WIN-X86-NEXT:    movl 8(%ebp), %esi
; WIN-X86-NEXT:    movl 24(%ebp), %eax
; WIN-X86-NEXT:    movl 28(%ebp), %ecx
; WIN-X86-NEXT:    movl 32(%ebp), %edx
; WIN-X86-NEXT:    movl 36(%ebp), %edi
; WIN-X86-NEXT:    leal {{[0-9]+}}(%esp), %ebx
; WIN-X86-NEXT:    movl %ebx, {{[0-9]+}}(%esp)
; WIN-X86-NEXT:    movl %edi, {{[0-9]+}}(%esp)
; WIN-X86-NEXT:    movl %edx, {{[0-9]+}}(%esp)
; WIN-X86-NEXT:    movl %ecx, {{[0-9]+}}(%esp)
; WIN-X86-NEXT:    movl %eax, {{[0-9]+}}(%esp)
; WIN-X86-NEXT:    leal {{[0-9]+}}(%esp), %eax
; WIN-X86-NEXT:    movl %eax, (%esp)
; WIN-X86-NEXT:    calll _modfl
; WIN-X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; WIN-X86-NEXT:    movl %eax, {{[-0-9]+}}(%e{{[sb]}}p) # 4-byte Spill
; WIN-X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; WIN-X86-NEXT:    movl %eax, {{[-0-9]+}}(%e{{[sb]}}p) # 4-byte Spill
; WIN-X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; WIN-X86-NEXT:    movl %eax, {{[-0-9]+}}(%e{{[sb]}}p) # 4-byte Spill
; WIN-X86-NEXT:    movl {{[0-9]+}}(%esp), %edi
; WIN-X86-NEXT:    movl {{[0-9]+}}(%esp), %ebx
; WIN-X86-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; WIN-X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; WIN-X86-NEXT:    movl {{[0-9]+}}(%esp), %edx
; WIN-X86-NEXT:    movl %edx, 28(%esi)
; WIN-X86-NEXT:    movl %eax, 24(%esi)
; WIN-X86-NEXT:    movl %ecx, 20(%esi)
; WIN-X86-NEXT:    movl %ebx, 16(%esi)
; WIN-X86-NEXT:    movl %edi, 12(%esi)
; WIN-X86-NEXT:    movl {{[-0-9]+}}(%e{{[sb]}}p), %eax # 4-byte Reload
; WIN-X86-NEXT:    movl %eax, 8(%esi)
; WIN-X86-NEXT:    movl {{[-0-9]+}}(%e{{[sb]}}p), %eax # 4-byte Reload
; WIN-X86-NEXT:    movl %eax, 4(%esi)
; WIN-X86-NEXT:    movl {{[-0-9]+}}(%e{{[sb]}}p), %eax # 4-byte Reload
; WIN-X86-NEXT:    movl %eax, (%esi)
; WIN-X86-NEXT:    movl %esi, %eax
; WIN-X86-NEXT:    leal -12(%ebp), %esp
; WIN-X86-NEXT:    popl %esi
; WIN-X86-NEXT:    popl %edi
; WIN-X86-NEXT:    popl %ebx
; WIN-X86-NEXT:    popl %ebp
; WIN-X86-NEXT:    retl
  %x = call { fp128, fp128 } @llvm.modf.f128(fp128 %a)
  ret { fp128, fp128 } %x
}
