; NOTE: Assertions have been autogenerated by utils/update_test_checks.py
; RUN: opt -passes=slp-vectorizer -S -slp-revec -slp-max-reg-size=1024 -slp-threshold=-1000 %s | FileCheck %s

; The 4 stores can be re-vectorised, make sure the poison sources
; are safely handled when trying to vectorise [ %0, poison, poison, %1 ]
define void @test_missing_lanes_1_2(ptr %ptr, i32 %val0, i32 %val1) {
; CHECK-LABEL: @test_missing_lanes_1_2(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[TMP0:%.*]] = insertelement <4 x i32> <i32 poison, i32 0, i32 0, i32 0>, i32 [[VAL0:%.*]], i32 0
; CHECK-NEXT:    [[TMP1:%.*]] = insertelement <4 x i32> <i32 poison, i32 0, i32 0, i32 0>, i32 [[VAL1:%.*]], i32 0
; CHECK-NEXT:    [[GETELEMENTPTR0:%.*]] = getelementptr i32, ptr [[PTR:%.*]], i64 0
; CHECK-NEXT:    store <4 x i32> [[TMP0]], ptr [[GETELEMENTPTR0]], align 4
; CHECK-NEXT:    [[GETELEMENTPTR1:%.*]] = getelementptr i32, ptr [[PTR]], i64 4
; CHECK-NEXT:    store <8 x i32> poison, ptr [[GETELEMENTPTR1]], align 4
; CHECK-NEXT:    [[GETELEMENTPTR3:%.*]] = getelementptr i32, ptr [[PTR]], i64 12
; CHECK-NEXT:    store <4 x i32> [[TMP1]], ptr [[GETELEMENTPTR3]], align 4
; CHECK-NEXT:    ret void
;
entry:
  %0 = insertelement <4 x i32> <i32 poison, i32 0, i32 0, i32 0>, i32 %val0, i32 0
  %1 = insertelement <4 x i32> <i32 poison, i32 0, i32 0, i32 0>, i32 %val1, i32 0

  %getelementptr0 = getelementptr i32, ptr %ptr, i64 0
  store <4 x i32> %0, ptr %getelementptr0, align 4
  %getelementptr1 = getelementptr i32, ptr %ptr, i64 4
  store <4 x i32> poison, ptr %getelementptr1, align 4
  %getelementptr2 = getelementptr i32, ptr %ptr, i64 8
  store <4 x i32> poison, ptr %getelementptr2, align 4
  %getelementptr3 = getelementptr i32, ptr %ptr, i64 12
  store <4 x i32> %1, ptr %getelementptr3, align 4

  ret void
}

; The 4 stores can be re-vectorised, make sure the poison sources
; are safely handled when trying to vectorise [ %0, poison, %1, poison ]
define void @test_missing_lanes_1_3(ptr %ptr, i32 %val0, i32 %val1) {
; CHECK-LABEL: @test_missing_lanes_1_3(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[TMP0:%.*]] = insertelement <4 x i32> <i32 poison, i32 0, i32 0, i32 0>, i32 [[VAL0:%.*]], i32 0
; CHECK-NEXT:    [[TMP1:%.*]] = insertelement <4 x i32> <i32 poison, i32 0, i32 0, i32 0>, i32 [[VAL1:%.*]], i32 0
; CHECK-NEXT:    [[GETELEMENTPTR0:%.*]] = getelementptr i32, ptr [[PTR:%.*]], i64 0
; CHECK-NEXT:    store <4 x i32> [[TMP0]], ptr [[GETELEMENTPTR0]], align 4
; CHECK-NEXT:    [[GETELEMENTPTR1:%.*]] = getelementptr i32, ptr [[PTR]], i64 4
; CHECK-NEXT:    [[TMP2:%.*]] = shufflevector <4 x i32> [[TMP1]], <4 x i32> poison, <8 x i32> <i32 poison, i32 poison, i32 poison, i32 poison, i32 0, i32 1, i32 2, i32 3>
; CHECK-NEXT:    store <8 x i32> [[TMP2]], ptr [[GETELEMENTPTR1]], align 4
; CHECK-NEXT:    [[GETELEMENTPTR3:%.*]] = getelementptr i32, ptr [[PTR]], i64 12
; CHECK-NEXT:    store <4 x i32> poison, ptr [[GETELEMENTPTR3]], align 4
; CHECK-NEXT:    ret void
;
entry:
  %0 = insertelement <4 x i32> <i32 poison, i32 0, i32 0, i32 0>, i32 %val0, i32 0
  %1 = insertelement <4 x i32> <i32 poison, i32 0, i32 0, i32 0>, i32 %val1, i32 0

  %getelementptr0 = getelementptr i32, ptr %ptr, i64 0
  store <4 x i32> %0, ptr %getelementptr0, align 4
  %getelementptr1 = getelementptr i32, ptr %ptr, i64 4
  store <4 x i32> poison, ptr %getelementptr1, align 4
  %getelementptr2 = getelementptr i32, ptr %ptr, i64 8
  store <4 x i32> %1, ptr %getelementptr2, align 4
  %getelementptr3 = getelementptr i32, ptr %ptr, i64 12
  store <4 x i32> poison, ptr %getelementptr3, align 4

  ret void
}

; This could be re-vectorised to use a store <8 x i32> instruction.
define void @test_valid_value_operands(ptr %ptr, i32 %val0, i32 %val1) {
; CHECK-LABEL: @test_valid_value_operands(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[TMP0:%.*]] = insertelement <4 x i32> <i32 poison, i32 0, i32 0, i32 0>, i32 [[VAL0:%.*]], i32 0
; CHECK-NEXT:    [[TMP1:%.*]] = insertelement <4 x i32> <i32 poison, i32 0, i32 0, i32 0>, i32 [[VAL1:%.*]], i32 0
; CHECK-NEXT:    [[GETELEMENTPTR0:%.*]] = getelementptr i32, ptr [[PTR:%.*]], i64 0
; CHECK-NEXT:    store <4 x i32> [[TMP0]], ptr [[GETELEMENTPTR0]], align 4
; CHECK-NEXT:    [[GETELEMENTPTR1:%.*]] = getelementptr i32, ptr [[PTR]], i64 4
; CHECK-NEXT:    store <4 x i32> [[TMP1]], ptr [[GETELEMENTPTR1]], align 4
; CHECK-NEXT:    ret void
;
entry:
  %0 = insertelement <4 x i32> <i32 poison, i32 0, i32 0, i32 0>, i32 %val0, i32 0
  %1 = insertelement <4 x i32> <i32 poison, i32 0, i32 0, i32 0>, i32 %val1, i32 0

  %getelementptr0 = getelementptr i32, ptr %ptr, i64 0
  store <4 x i32> %0, ptr %getelementptr0, align 4
  %getelementptr1 = getelementptr i32, ptr %ptr, i64 4
  store <4 x i32> %1, ptr %getelementptr1, align 4
  ret void
}
