; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc < %s -mtriple=aarch64 | FileCheck %s --check-prefixes=CHECK,CHECK-SD
; RUN: llc < %s -mtriple=aarch64 -global-isel | FileCheck %s --check-prefixes=CHECK,CHECK-GI

; Select of constants: control flow / conditional moves can always be replaced by logic+math (but may not be worth it?).
; Test the zeroext/signext variants of each pattern to see if that makes a difference.

; select Cond, 0, 1 --> zext (!Cond)

define i32 @select_0_or_1(i1 %cond) {
; CHECK-SD-LABEL: select_0_or_1:
; CHECK-SD:       // %bb.0:
; CHECK-SD-NEXT:    mov w8, #1 // =0x1
; CHECK-SD-NEXT:    bic w0, w8, w0
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: select_0_or_1:
; CHECK-GI:       // %bb.0:
; CHECK-GI-NEXT:    eor w8, w0, #0x1
; CHECK-GI-NEXT:    and w0, w8, #0x1
; CHECK-GI-NEXT:    ret
  %sel = select i1 %cond, i32 0, i32 1
  ret i32 %sel
}

define i32 @select_0_or_1_zeroext(i1 zeroext %cond) {
; CHECK-LABEL: select_0_or_1_zeroext:
; CHECK:       // %bb.0:
; CHECK-NEXT:    eor w0, w0, #0x1
; CHECK-NEXT:    ret
  %sel = select i1 %cond, i32 0, i32 1
  ret i32 %sel
}

define i32 @select_0_or_1_signext(i1 signext %cond) {
; CHECK-SD-LABEL: select_0_or_1_signext:
; CHECK-SD:       // %bb.0:
; CHECK-SD-NEXT:    mov w8, #1 // =0x1
; CHECK-SD-NEXT:    bic w0, w8, w0
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: select_0_or_1_signext:
; CHECK-GI:       // %bb.0:
; CHECK-GI-NEXT:    eor w8, w0, #0x1
; CHECK-GI-NEXT:    and w0, w8, #0x1
; CHECK-GI-NEXT:    ret
  %sel = select i1 %cond, i32 0, i32 1
  ret i32 %sel
}

; select Cond, 1, 0 --> zext (Cond)

define i32 @select_1_or_0(i1 %cond) {
; CHECK-LABEL: select_1_or_0:
; CHECK:       // %bb.0:
; CHECK-NEXT:    and w0, w0, #0x1
; CHECK-NEXT:    ret
  %sel = select i1 %cond, i32 1, i32 0
  ret i32 %sel
}

define i32 @select_1_or_0_zeroext(i1 zeroext %cond) {
; CHECK-LABEL: select_1_or_0_zeroext:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ret
  %sel = select i1 %cond, i32 1, i32 0
  ret i32 %sel
}

define i32 @select_1_or_0_signext(i1 signext %cond) {
; CHECK-LABEL: select_1_or_0_signext:
; CHECK:       // %bb.0:
; CHECK-NEXT:    and w0, w0, #0x1
; CHECK-NEXT:    ret
  %sel = select i1 %cond, i32 1, i32 0
  ret i32 %sel
}

; select Cond, 0, -1 --> sext (!Cond)

define i32 @select_0_or_neg1(i1 %cond) {
; CHECK-SD-LABEL: select_0_or_neg1:
; CHECK-SD:       // %bb.0:
; CHECK-SD-NEXT:    and w8, w0, #0x1
; CHECK-SD-NEXT:    sub w0, w8, #1
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: select_0_or_neg1:
; CHECK-GI:       // %bb.0:
; CHECK-GI-NEXT:    eor w8, w0, #0x1
; CHECK-GI-NEXT:    sbfx w0, w8, #0, #1
; CHECK-GI-NEXT:    ret
  %sel = select i1 %cond, i32 0, i32 -1
  ret i32 %sel
}

define i32 @select_0_or_neg1_zeroext(i1 zeroext %cond) {
; CHECK-SD-LABEL: select_0_or_neg1_zeroext:
; CHECK-SD:       // %bb.0:
; CHECK-SD-NEXT:    sub w0, w0, #1
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: select_0_or_neg1_zeroext:
; CHECK-GI:       // %bb.0:
; CHECK-GI-NEXT:    eor w8, w0, #0x1
; CHECK-GI-NEXT:    sbfx w0, w8, #0, #1
; CHECK-GI-NEXT:    ret
  %sel = select i1 %cond, i32 0, i32 -1
  ret i32 %sel
}

define i32 @select_0_or_neg1_signext(i1 signext %cond) {
; CHECK-SD-LABEL: select_0_or_neg1_signext:
; CHECK-SD:       // %bb.0:
; CHECK-SD-NEXT:    mvn w0, w0
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: select_0_or_neg1_signext:
; CHECK-GI:       // %bb.0:
; CHECK-GI-NEXT:    eor w8, w0, #0x1
; CHECK-GI-NEXT:    sbfx w0, w8, #0, #1
; CHECK-GI-NEXT:    ret
  %sel = select i1 %cond, i32 0, i32 -1
  ret i32 %sel
}

; select Cond, -1, 0 --> sext (Cond)

define i32 @select_neg1_or_0(i1 %cond) {
; CHECK-LABEL: select_neg1_or_0:
; CHECK:       // %bb.0:
; CHECK-NEXT:    sbfx w0, w0, #0, #1
; CHECK-NEXT:    ret
  %sel = select i1 %cond, i32 -1, i32 0
  ret i32 %sel
}

define i32 @select_neg1_or_0_zeroext(i1 zeroext %cond) {
; CHECK-LABEL: select_neg1_or_0_zeroext:
; CHECK:       // %bb.0:
; CHECK-NEXT:    sbfx w0, w0, #0, #1
; CHECK-NEXT:    ret
  %sel = select i1 %cond, i32 -1, i32 0
  ret i32 %sel
}

define i32 @select_neg1_or_0_signext(i1 signext %cond) {
; CHECK-LABEL: select_neg1_or_0_signext:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ret
  %sel = select i1 %cond, i32 -1, i32 0
  ret i32 %sel
}

; select Cond, C+1, C --> add (zext Cond), C

define i32 @select_Cplus1_C(i1 %cond) {
; CHECK-SD-LABEL: select_Cplus1_C:
; CHECK-SD:       // %bb.0:
; CHECK-SD-NEXT:    mov w8, #41 // =0x29
; CHECK-SD-NEXT:    tst w0, #0x1
; CHECK-SD-NEXT:    cinc w0, w8, ne
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: select_Cplus1_C:
; CHECK-GI:       // %bb.0:
; CHECK-GI-NEXT:    and w8, w0, #0x1
; CHECK-GI-NEXT:    add w0, w8, #41
; CHECK-GI-NEXT:    ret
  %sel = select i1 %cond, i32 42, i32 41
  ret i32 %sel
}

define i32 @select_Cplus1_C_zeroext(i1 zeroext %cond) {
; CHECK-SD-LABEL: select_Cplus1_C_zeroext:
; CHECK-SD:       // %bb.0:
; CHECK-SD-NEXT:    mov w8, #41 // =0x29
; CHECK-SD-NEXT:    cmp w0, #0
; CHECK-SD-NEXT:    cinc w0, w8, ne
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: select_Cplus1_C_zeroext:
; CHECK-GI:       // %bb.0:
; CHECK-GI-NEXT:    add w0, w0, #41
; CHECK-GI-NEXT:    ret
  %sel = select i1 %cond, i32 42, i32 41
  ret i32 %sel
}

define i32 @select_Cplus1_C_signext(i1 signext %cond) {
; CHECK-SD-LABEL: select_Cplus1_C_signext:
; CHECK-SD:       // %bb.0:
; CHECK-SD-NEXT:    mov w8, #41 // =0x29
; CHECK-SD-NEXT:    tst w0, #0x1
; CHECK-SD-NEXT:    cinc w0, w8, ne
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: select_Cplus1_C_signext:
; CHECK-GI:       // %bb.0:
; CHECK-GI-NEXT:    and w8, w0, #0x1
; CHECK-GI-NEXT:    add w0, w8, #41
; CHECK-GI-NEXT:    ret
  %sel = select i1 %cond, i32 42, i32 41
  ret i32 %sel
}

; select Cond, C, C+1 --> add (sext Cond), C

define i32 @select_C_Cplus1(i1 %cond) {
; CHECK-SD-LABEL: select_C_Cplus1:
; CHECK-SD:       // %bb.0:
; CHECK-SD-NEXT:    mov w8, #41 // =0x29
; CHECK-SD-NEXT:    tst w0, #0x1
; CHECK-SD-NEXT:    cinc w0, w8, eq
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: select_C_Cplus1:
; CHECK-GI:       // %bb.0:
; CHECK-GI-NEXT:    sbfx w8, w0, #0, #1
; CHECK-GI-NEXT:    add w0, w8, #42
; CHECK-GI-NEXT:    ret
  %sel = select i1 %cond, i32 41, i32 42
  ret i32 %sel
}

define i32 @select_C_Cplus1_zeroext(i1 zeroext %cond) {
; CHECK-SD-LABEL: select_C_Cplus1_zeroext:
; CHECK-SD:       // %bb.0:
; CHECK-SD-NEXT:    mov w8, #41 // =0x29
; CHECK-SD-NEXT:    cmp w0, #0
; CHECK-SD-NEXT:    cinc w0, w8, eq
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: select_C_Cplus1_zeroext:
; CHECK-GI:       // %bb.0:
; CHECK-GI-NEXT:    sbfx w8, w0, #0, #1
; CHECK-GI-NEXT:    add w0, w8, #42
; CHECK-GI-NEXT:    ret
  %sel = select i1 %cond, i32 41, i32 42
  ret i32 %sel
}

define i32 @select_C_Cplus1_signext(i1 signext %cond) {
; CHECK-SD-LABEL: select_C_Cplus1_signext:
; CHECK-SD:       // %bb.0:
; CHECK-SD-NEXT:    mov w8, #41 // =0x29
; CHECK-SD-NEXT:    tst w0, #0x1
; CHECK-SD-NEXT:    cinc w0, w8, eq
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: select_C_Cplus1_signext:
; CHECK-GI:       // %bb.0:
; CHECK-GI-NEXT:    add w0, w0, #42
; CHECK-GI-NEXT:    ret
  %sel = select i1 %cond, i32 41, i32 42
  ret i32 %sel
}

; In general, select of 2 constants could be:
; select Cond, C1, C2 --> add (mul (zext Cond), C1-C2), C2 --> add (and (sext Cond), C1-C2), C2

define i32 @select_C1_C2(i1 %cond) {
; CHECK-SD-LABEL: select_C1_C2:
; CHECK-SD:       // %bb.0:
; CHECK-SD-NEXT:    mov w8, #42 // =0x2a
; CHECK-SD-NEXT:    tst w0, #0x1
; CHECK-SD-NEXT:    mov w9, #421 // =0x1a5
; CHECK-SD-NEXT:    csel w0, w9, w8, ne
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: select_C1_C2:
; CHECK-GI:       // %bb.0:
; CHECK-GI-NEXT:    and w8, w0, #0x1
; CHECK-GI-NEXT:    mov w9, #42 // =0x2a
; CHECK-GI-NEXT:    mov w10, #421 // =0x1a5
; CHECK-GI-NEXT:    tst w8, #0x1
; CHECK-GI-NEXT:    csel w0, w10, w9, ne
; CHECK-GI-NEXT:    ret
  %sel = select i1 %cond, i32 421, i32 42
  ret i32 %sel
}

define i32 @select_C1_C2_zeroext(i1 zeroext %cond) {
; CHECK-SD-LABEL: select_C1_C2_zeroext:
; CHECK-SD:       // %bb.0:
; CHECK-SD-NEXT:    mov w8, #42 // =0x2a
; CHECK-SD-NEXT:    cmp w0, #0
; CHECK-SD-NEXT:    mov w9, #421 // =0x1a5
; CHECK-SD-NEXT:    csel w0, w9, w8, ne
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: select_C1_C2_zeroext:
; CHECK-GI:       // %bb.0:
; CHECK-GI-NEXT:    mov w8, #42 // =0x2a
; CHECK-GI-NEXT:    mov w9, #421 // =0x1a5
; CHECK-GI-NEXT:    tst w0, #0x1
; CHECK-GI-NEXT:    csel w0, w9, w8, ne
; CHECK-GI-NEXT:    ret
  %sel = select i1 %cond, i32 421, i32 42
  ret i32 %sel
}

define i32 @select_C1_C2_signext(i1 signext %cond) {
; CHECK-SD-LABEL: select_C1_C2_signext:
; CHECK-SD:       // %bb.0:
; CHECK-SD-NEXT:    mov w8, #42 // =0x2a
; CHECK-SD-NEXT:    tst w0, #0x1
; CHECK-SD-NEXT:    mov w9, #421 // =0x1a5
; CHECK-SD-NEXT:    csel w0, w9, w8, ne
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: select_C1_C2_signext:
; CHECK-GI:       // %bb.0:
; CHECK-GI-NEXT:    and w8, w0, #0x1
; CHECK-GI-NEXT:    mov w9, #42 // =0x2a
; CHECK-GI-NEXT:    mov w10, #421 // =0x1a5
; CHECK-GI-NEXT:    tst w8, #0x1
; CHECK-GI-NEXT:    csel w0, w10, w9, ne
; CHECK-GI-NEXT:    ret
  %sel = select i1 %cond, i32 421, i32 42
  ret i32 %sel
}

; A binary operator with constant after the select should always get folded into the select.

define i8 @sel_constants_add_constant(i1 %cond) {
; CHECK-SD-LABEL: sel_constants_add_constant:
; CHECK-SD:       // %bb.0:
; CHECK-SD-NEXT:    mov w8, #28 // =0x1c
; CHECK-SD-NEXT:    tst w0, #0x1
; CHECK-SD-NEXT:    csinc w0, w8, wzr, eq
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: sel_constants_add_constant:
; CHECK-GI:       // %bb.0:
; CHECK-GI-NEXT:    and w9, w0, #0x1
; CHECK-GI-NEXT:    mov w8, #28 // =0x1c
; CHECK-GI-NEXT:    tst w9, #0x1
; CHECK-GI-NEXT:    csinc w0, w8, wzr, eq
; CHECK-GI-NEXT:    ret
  %sel = select i1 %cond, i8 -4, i8 23
  %bo = add i8 %sel, 5
  ret i8 %bo
}

define i8 @sel_constants_sub_constant(i1 %cond) {
; CHECK-SD-LABEL: sel_constants_sub_constant:
; CHECK-SD:       // %bb.0:
; CHECK-SD-NEXT:    mov w8, #18 // =0x12
; CHECK-SD-NEXT:    tst w0, #0x1
; CHECK-SD-NEXT:    mov w9, #-9 // =0xfffffff7
; CHECK-SD-NEXT:    csel w0, w9, w8, ne
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: sel_constants_sub_constant:
; CHECK-GI:       // %bb.0:
; CHECK-GI-NEXT:    and w8, w0, #0x1
; CHECK-GI-NEXT:    mov w9, #-9 // =0xfffffff7
; CHECK-GI-NEXT:    mov w10, #18 // =0x12
; CHECK-GI-NEXT:    tst w8, #0x1
; CHECK-GI-NEXT:    csel w0, w9, w10, ne
; CHECK-GI-NEXT:    ret
  %sel = select i1 %cond, i8 -4, i8 23
  %bo = sub i8 %sel, 5
  ret i8 %bo
}

define i8 @sel_constants_sub_constant_sel_constants(i1 %cond) {
; CHECK-SD-LABEL: sel_constants_sub_constant_sel_constants:
; CHECK-SD:       // %bb.0:
; CHECK-SD-NEXT:    mov w8, #2 // =0x2
; CHECK-SD-NEXT:    tst w0, #0x1
; CHECK-SD-NEXT:    mov w9, #9 // =0x9
; CHECK-SD-NEXT:    csel w0, w9, w8, ne
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: sel_constants_sub_constant_sel_constants:
; CHECK-GI:       // %bb.0:
; CHECK-GI-NEXT:    and w8, w0, #0x1
; CHECK-GI-NEXT:    mov w9, #9 // =0x9
; CHECK-GI-NEXT:    mov w10, #2 // =0x2
; CHECK-GI-NEXT:    tst w8, #0x1
; CHECK-GI-NEXT:    csel w0, w9, w10, ne
; CHECK-GI-NEXT:    ret
  %sel = select i1 %cond, i8 -4, i8 3
  %bo = sub i8 5, %sel
  ret i8 %bo
}

define i8 @sel_constants_mul_constant(i1 %cond) {
; CHECK-SD-LABEL: sel_constants_mul_constant:
; CHECK-SD:       // %bb.0:
; CHECK-SD-NEXT:    mov w8, #115 // =0x73
; CHECK-SD-NEXT:    tst w0, #0x1
; CHECK-SD-NEXT:    mov w9, #-20 // =0xffffffec
; CHECK-SD-NEXT:    csel w0, w9, w8, ne
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: sel_constants_mul_constant:
; CHECK-GI:       // %bb.0:
; CHECK-GI-NEXT:    and w8, w0, #0x1
; CHECK-GI-NEXT:    mov w9, #-4 // =0xfffffffc
; CHECK-GI-NEXT:    mov w10, #23 // =0x17
; CHECK-GI-NEXT:    tst w8, #0x1
; CHECK-GI-NEXT:    csel w8, w9, w10, ne
; CHECK-GI-NEXT:    add w0, w8, w8, lsl #2
; CHECK-GI-NEXT:    ret
  %sel = select i1 %cond, i8 -4, i8 23
  %bo = mul i8 %sel, 5
  ret i8 %bo
}

define i8 @sel_constants_sdiv_constant(i1 %cond) {
; CHECK-SD-LABEL: sel_constants_sdiv_constant:
; CHECK-SD:       // %bb.0:
; CHECK-SD-NEXT:    mov w8, #4 // =0x4
; CHECK-SD-NEXT:    tst w0, #0x1
; CHECK-SD-NEXT:    csel w0, wzr, w8, ne
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: sel_constants_sdiv_constant:
; CHECK-GI:       // %bb.0:
; CHECK-GI-NEXT:    eor w8, w0, #0x1
; CHECK-GI-NEXT:    and w8, w8, #0x1
; CHECK-GI-NEXT:    lsl w0, w8, #2
; CHECK-GI-NEXT:    ret
  %sel = select i1 %cond, i8 -4, i8 23
  %bo = sdiv i8 %sel, 5
  ret i8 %bo
}

define i8 @sdiv_constant_sel_constants(i1 %cond) {
; CHECK-SD-LABEL: sdiv_constant_sel_constants:
; CHECK-SD:       // %bb.0:
; CHECK-SD-NEXT:    mov w8, #5 // =0x5
; CHECK-SD-NEXT:    tst w0, #0x1
; CHECK-SD-NEXT:    csel w0, wzr, w8, ne
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: sdiv_constant_sel_constants:
; CHECK-GI:       // %bb.0:
; CHECK-GI-NEXT:    and w9, w0, #0x1
; CHECK-GI-NEXT:    mov w8, #5 // =0x5
; CHECK-GI-NEXT:    tst w9, #0x1
; CHECK-GI-NEXT:    csel w0, wzr, w8, ne
; CHECK-GI-NEXT:    ret
  %sel = select i1 %cond, i8 121, i8 23
  %bo = sdiv i8 120, %sel
  ret i8 %bo
}

define i8 @sel_constants_udiv_constant(i1 %cond) {
; CHECK-SD-LABEL: sel_constants_udiv_constant:
; CHECK-SD:       // %bb.0:
; CHECK-SD-NEXT:    mov w8, #4 // =0x4
; CHECK-SD-NEXT:    tst w0, #0x1
; CHECK-SD-NEXT:    mov w9, #50 // =0x32
; CHECK-SD-NEXT:    csel w0, w9, w8, ne
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: sel_constants_udiv_constant:
; CHECK-GI:       // %bb.0:
; CHECK-GI-NEXT:    and w8, w0, #0x1
; CHECK-GI-NEXT:    mov w9, #50 // =0x32
; CHECK-GI-NEXT:    mov w10, #4 // =0x4
; CHECK-GI-NEXT:    tst w8, #0x1
; CHECK-GI-NEXT:    csel w0, w9, w10, ne
; CHECK-GI-NEXT:    ret
  %sel = select i1 %cond, i8 -4, i8 23
  %bo = udiv i8 %sel, 5
  ret i8 %bo
}

define i8 @udiv_constant_sel_constants(i1 %cond) {
; CHECK-SD-LABEL: udiv_constant_sel_constants:
; CHECK-SD:       // %bb.0:
; CHECK-SD-NEXT:    mov w8, #5 // =0x5
; CHECK-SD-NEXT:    tst w0, #0x1
; CHECK-SD-NEXT:    csel w0, wzr, w8, ne
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: udiv_constant_sel_constants:
; CHECK-GI:       // %bb.0:
; CHECK-GI-NEXT:    and w9, w0, #0x1
; CHECK-GI-NEXT:    mov w8, #5 // =0x5
; CHECK-GI-NEXT:    tst w9, #0x1
; CHECK-GI-NEXT:    csel w0, wzr, w8, ne
; CHECK-GI-NEXT:    ret
  %sel = select i1 %cond, i8 -4, i8 23
  %bo = udiv i8 120, %sel
  ret i8 %bo
}

define i8 @sel_constants_srem_constant(i1 %cond) {
; CHECK-SD-LABEL: sel_constants_srem_constant:
; CHECK-SD:       // %bb.0:
; CHECK-SD-NEXT:    mov w8, #-4 // =0xfffffffc
; CHECK-SD-NEXT:    tst w0, #0x1
; CHECK-SD-NEXT:    cinv w0, w8, eq
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: sel_constants_srem_constant:
; CHECK-GI:       // %bb.0:
; CHECK-GI-NEXT:    and w8, w0, #0x1
; CHECK-GI-NEXT:    mov w9, #-4 // =0xfffffffc
; CHECK-GI-NEXT:    mov w10, #3 // =0x3
; CHECK-GI-NEXT:    tst w8, #0x1
; CHECK-GI-NEXT:    csel w0, w9, w10, ne
; CHECK-GI-NEXT:    ret
  %sel = select i1 %cond, i8 -4, i8 23
  %bo = srem i8 %sel, 5
  ret i8 %bo
}

define i8 @srem_constant_sel_constants(i1 %cond) {
; CHECK-SD-LABEL: srem_constant_sel_constants:
; CHECK-SD:       // %bb.0:
; CHECK-SD-NEXT:    mov w8, #5 // =0x5
; CHECK-SD-NEXT:    tst w0, #0x1
; CHECK-SD-NEXT:    mov w9, #120 // =0x78
; CHECK-SD-NEXT:    csel w0, w9, w8, ne
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: srem_constant_sel_constants:
; CHECK-GI:       // %bb.0:
; CHECK-GI-NEXT:    and w8, w0, #0x1
; CHECK-GI-NEXT:    mov w9, #120 // =0x78
; CHECK-GI-NEXT:    mov w10, #5 // =0x5
; CHECK-GI-NEXT:    tst w8, #0x1
; CHECK-GI-NEXT:    csel w0, w9, w10, ne
; CHECK-GI-NEXT:    ret
  %sel = select i1 %cond, i8 121, i8 23
  %bo = srem i8 120, %sel
  ret i8 %bo
}

define i8 @sel_constants_urem_constant(i1 %cond) {
; CHECK-SD-LABEL: sel_constants_urem_constant:
; CHECK-SD:       // %bb.0:
; CHECK-SD-NEXT:    mov w8, #2 // =0x2
; CHECK-SD-NEXT:    tst w0, #0x1
; CHECK-SD-NEXT:    cinc w0, w8, eq
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: sel_constants_urem_constant:
; CHECK-GI:       // %bb.0:
; CHECK-GI-NEXT:    sbfx w8, w0, #0, #1
; CHECK-GI-NEXT:    add w0, w8, #3
; CHECK-GI-NEXT:    ret
  %sel = select i1 %cond, i8 -4, i8 23
  %bo = urem i8 %sel, 5
  ret i8 %bo
}

define i8 @urem_constant_sel_constants(i1 %cond) {
; CHECK-SD-LABEL: urem_constant_sel_constants:
; CHECK-SD:       // %bb.0:
; CHECK-SD-NEXT:    mov w8, #5 // =0x5
; CHECK-SD-NEXT:    tst w0, #0x1
; CHECK-SD-NEXT:    mov w9, #120 // =0x78
; CHECK-SD-NEXT:    csel w0, w9, w8, ne
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: urem_constant_sel_constants:
; CHECK-GI:       // %bb.0:
; CHECK-GI-NEXT:    and w8, w0, #0x1
; CHECK-GI-NEXT:    mov w9, #120 // =0x78
; CHECK-GI-NEXT:    mov w10, #5 // =0x5
; CHECK-GI-NEXT:    tst w8, #0x1
; CHECK-GI-NEXT:    csel w0, w9, w10, ne
; CHECK-GI-NEXT:    ret
  %sel = select i1 %cond, i8 -4, i8 23
  %bo = urem i8 120, %sel
  ret i8 %bo
}

define i8 @sel_constants_and_constant(i1 %cond) {
; CHECK-SD-LABEL: sel_constants_and_constant:
; CHECK-SD:       // %bb.0:
; CHECK-SD-NEXT:    mov w8, #4 // =0x4
; CHECK-SD-NEXT:    tst w0, #0x1
; CHECK-SD-NEXT:    cinc w0, w8, eq
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: sel_constants_and_constant:
; CHECK-GI:       // %bb.0:
; CHECK-GI-NEXT:    sbfx w8, w0, #0, #1
; CHECK-GI-NEXT:    add w0, w8, #5
; CHECK-GI-NEXT:    ret
  %sel = select i1 %cond, i8 -4, i8 23
  %bo = and i8 %sel, 5
  ret i8 %bo
}

define i8 @sel_constants_or_constant(i1 %cond) {
; CHECK-SD-LABEL: sel_constants_or_constant:
; CHECK-SD:       // %bb.0:
; CHECK-SD-NEXT:    mov w8, #23 // =0x17
; CHECK-SD-NEXT:    tst w0, #0x1
; CHECK-SD-NEXT:    mov w9, #-3 // =0xfffffffd
; CHECK-SD-NEXT:    csel w0, w9, w8, ne
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: sel_constants_or_constant:
; CHECK-GI:       // %bb.0:
; CHECK-GI-NEXT:    and w8, w0, #0x1
; CHECK-GI-NEXT:    mov w9, #-3 // =0xfffffffd
; CHECK-GI-NEXT:    mov w10, #23 // =0x17
; CHECK-GI-NEXT:    tst w8, #0x1
; CHECK-GI-NEXT:    csel w0, w9, w10, ne
; CHECK-GI-NEXT:    ret
  %sel = select i1 %cond, i8 -4, i8 23
  %bo = or i8 %sel, 5
  ret i8 %bo
}

define i8 @sel_constants_xor_constant(i1 %cond) {
; CHECK-SD-LABEL: sel_constants_xor_constant:
; CHECK-SD:       // %bb.0:
; CHECK-SD-NEXT:    mov w8, #18 // =0x12
; CHECK-SD-NEXT:    tst w0, #0x1
; CHECK-SD-NEXT:    mov w9, #-7 // =0xfffffff9
; CHECK-SD-NEXT:    csel w0, w9, w8, ne
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: sel_constants_xor_constant:
; CHECK-GI:       // %bb.0:
; CHECK-GI-NEXT:    and w8, w0, #0x1
; CHECK-GI-NEXT:    mov w9, #-7 // =0xfffffff9
; CHECK-GI-NEXT:    mov w10, #18 // =0x12
; CHECK-GI-NEXT:    tst w8, #0x1
; CHECK-GI-NEXT:    csel w0, w9, w10, ne
; CHECK-GI-NEXT:    ret
  %sel = select i1 %cond, i8 -4, i8 23
  %bo = xor i8 %sel, 5
  ret i8 %bo
}

define i8 @sel_constants_shl_constant(i1 %cond) {
; CHECK-SD-LABEL: sel_constants_shl_constant:
; CHECK-SD:       // %bb.0:
; CHECK-SD-NEXT:    mov w8, #-32 // =0xffffffe0
; CHECK-SD-NEXT:    tst w0, #0x1
; CHECK-SD-NEXT:    mov w9, #-128 // =0xffffff80
; CHECK-SD-NEXT:    csel w0, w9, w8, ne
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: sel_constants_shl_constant:
; CHECK-GI:       // %bb.0:
; CHECK-GI-NEXT:    and w8, w0, #0x1
; CHECK-GI-NEXT:    mov w9, #-128 // =0xffffff80
; CHECK-GI-NEXT:    mov w10, #-32 // =0xffffffe0
; CHECK-GI-NEXT:    tst w8, #0x1
; CHECK-GI-NEXT:    csel w0, w9, w10, ne
; CHECK-GI-NEXT:    ret
  %sel = select i1 %cond, i8 -4, i8 23
  %bo = shl i8 %sel, 5
  ret i8 %bo
}

define i8 @shl_constant_sel_constants(i1 %cond) {
; CHECK-SD-LABEL: shl_constant_sel_constants:
; CHECK-SD:       // %bb.0:
; CHECK-SD-NEXT:    mov w8, #8 // =0x8
; CHECK-SD-NEXT:    tst w0, #0x1
; CHECK-SD-NEXT:    mov w9, #4 // =0x4
; CHECK-SD-NEXT:    csel w0, w9, w8, ne
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: shl_constant_sel_constants:
; CHECK-GI:       // %bb.0:
; CHECK-GI-NEXT:    sbfx w9, w0, #0, #1
; CHECK-GI-NEXT:    mov w8, #1 // =0x1
; CHECK-GI-NEXT:    add w9, w9, #3
; CHECK-GI-NEXT:    and w9, w9, #0xff
; CHECK-GI-NEXT:    lsl w0, w8, w9
; CHECK-GI-NEXT:    ret
  %sel = select i1 %cond, i8 2, i8 3
  %bo = shl i8 1, %sel
  ret i8 %bo
}

define i8 @sel_constants_lshr_constant(i1 %cond) {
; CHECK-SD-LABEL: sel_constants_lshr_constant:
; CHECK-SD:       // %bb.0:
; CHECK-SD-NEXT:    mov w8, #7 // =0x7
; CHECK-SD-NEXT:    tst w0, #0x1
; CHECK-SD-NEXT:    csel w0, w8, wzr, ne
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: sel_constants_lshr_constant:
; CHECK-GI:       // %bb.0:
; CHECK-GI-NEXT:    and w9, w0, #0x1
; CHECK-GI-NEXT:    mov w8, #7 // =0x7
; CHECK-GI-NEXT:    tst w9, #0x1
; CHECK-GI-NEXT:    csel w0, w8, wzr, ne
; CHECK-GI-NEXT:    ret
  %sel = select i1 %cond, i8 -4, i8 23
  %bo = lshr i8 %sel, 5
  ret i8 %bo
}

define i8 @lshr_constant_sel_constants(i1 %cond) {
; CHECK-SD-LABEL: lshr_constant_sel_constants:
; CHECK-SD:       // %bb.0:
; CHECK-SD-NEXT:    mov w8, #8 // =0x8
; CHECK-SD-NEXT:    tst w0, #0x1
; CHECK-SD-NEXT:    mov w9, #16 // =0x10
; CHECK-SD-NEXT:    csel w0, w9, w8, ne
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: lshr_constant_sel_constants:
; CHECK-GI:       // %bb.0:
; CHECK-GI-NEXT:    sbfx w9, w0, #0, #1
; CHECK-GI-NEXT:    mov w8, #64 // =0x40
; CHECK-GI-NEXT:    add w9, w9, #3
; CHECK-GI-NEXT:    and w9, w9, #0xff
; CHECK-GI-NEXT:    lsr w0, w8, w9
; CHECK-GI-NEXT:    ret
  %sel = select i1 %cond, i8 2, i8 3
  %bo = lshr i8 64, %sel
  ret i8 %bo
}


define i8 @sel_constants_ashr_constant(i1 %cond) {
; CHECK-LABEL: sel_constants_ashr_constant:
; CHECK:       // %bb.0:
; CHECK-NEXT:    sbfx w0, w0, #0, #1
; CHECK-NEXT:    ret
  %sel = select i1 %cond, i8 -4, i8 23
  %bo = ashr i8 %sel, 5
  ret i8 %bo
}

define i8 @ashr_constant_sel_constants(i1 %cond) {
; CHECK-SD-LABEL: ashr_constant_sel_constants:
; CHECK-SD:       // %bb.0:
; CHECK-SD-NEXT:    mov w8, #-16 // =0xfffffff0
; CHECK-SD-NEXT:    tst w0, #0x1
; CHECK-SD-NEXT:    mov w9, #-32 // =0xffffffe0
; CHECK-SD-NEXT:    csel w0, w9, w8, ne
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: ashr_constant_sel_constants:
; CHECK-GI:       // %bb.0:
; CHECK-GI-NEXT:    sbfx w9, w0, #0, #1
; CHECK-GI-NEXT:    mov w8, #-128 // =0xffffff80
; CHECK-GI-NEXT:    add w9, w9, #3
; CHECK-GI-NEXT:    and w9, w9, #0xff
; CHECK-GI-NEXT:    asr w0, w8, w9
; CHECK-GI-NEXT:    ret
  %sel = select i1 %cond, i8 2, i8 3
  %bo = ashr i8 128, %sel
  ret i8 %bo
}

define double @sel_constants_fadd_constant(i1 %cond) {
; CHECK-SD-LABEL: sel_constants_fadd_constant:
; CHECK-SD:       // %bb.0:
; CHECK-SD-NEXT:    mov x9, #7378697629483820646 // =0x6666666666666666
; CHECK-SD-NEXT:    adrp x8, .LCPI42_0
; CHECK-SD-NEXT:    tst w0, #0x1
; CHECK-SD-NEXT:    movk x9, #16444, lsl #48
; CHECK-SD-NEXT:    ldr d0, [x8, :lo12:.LCPI42_0]
; CHECK-SD-NEXT:    fmov d1, x9
; CHECK-SD-NEXT:    fcsel d0, d0, d1, ne
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: sel_constants_fadd_constant:
; CHECK-GI:       // %bb.0:
; CHECK-GI-NEXT:    mov x9, #7378697629483820646 // =0x6666666666666666
; CHECK-GI-NEXT:    adrp x8, .LCPI42_0
; CHECK-GI-NEXT:    movk x9, #16444, lsl #48
; CHECK-GI-NEXT:    ldr d0, [x8, :lo12:.LCPI42_0]
; CHECK-GI-NEXT:    and w8, w0, #0x1
; CHECK-GI-NEXT:    fmov d1, x9
; CHECK-GI-NEXT:    tst w8, #0x1
; CHECK-GI-NEXT:    fcsel d0, d0, d1, ne
; CHECK-GI-NEXT:    ret
  %sel = select i1 %cond, double -4.0, double 23.3
  %bo = fadd double %sel, 5.1
  ret double %bo
}

define double @sel_constants_fsub_constant(i1 %cond) {
; CHECK-SD-LABEL: sel_constants_fsub_constant:
; CHECK-SD:       // %bb.0:
; CHECK-SD-NEXT:    adrp x8, .LCPI43_0
; CHECK-SD-NEXT:    tst w0, #0x1
; CHECK-SD-NEXT:    ldr d0, [x8, :lo12:.LCPI43_0]
; CHECK-SD-NEXT:    mov x8, #3689348814741910323 // =0x3333333333333333
; CHECK-SD-NEXT:    movk x8, #49186, lsl #48
; CHECK-SD-NEXT:    fmov d1, x8
; CHECK-SD-NEXT:    fcsel d0, d1, d0, ne
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: sel_constants_fsub_constant:
; CHECK-GI:       // %bb.0:
; CHECK-GI-NEXT:    adrp x8, .LCPI43_0
; CHECK-GI-NEXT:    and w9, w0, #0x1
; CHECK-GI-NEXT:    ldr d0, [x8, :lo12:.LCPI43_0]
; CHECK-GI-NEXT:    mov x8, #3689348814741910323 // =0x3333333333333333
; CHECK-GI-NEXT:    tst w9, #0x1
; CHECK-GI-NEXT:    movk x8, #49186, lsl #48
; CHECK-GI-NEXT:    fmov d1, x8
; CHECK-GI-NEXT:    fcsel d0, d1, d0, ne
; CHECK-GI-NEXT:    ret
  %sel = select i1 %cond, double -4.0, double 23.3
  %bo = fsub double %sel, 5.1
  ret double %bo
}

define double @fsub_constant_sel_constants(i1 %cond) {
; CHECK-SD-LABEL: fsub_constant_sel_constants:
; CHECK-SD:       // %bb.0:
; CHECK-SD-NEXT:    adrp x8, .LCPI44_0
; CHECK-SD-NEXT:    tst w0, #0x1
; CHECK-SD-NEXT:    ldr d0, [x8, :lo12:.LCPI44_0]
; CHECK-SD-NEXT:    mov x8, #3689348814741910323 // =0x3333333333333333
; CHECK-SD-NEXT:    movk x8, #16418, lsl #48
; CHECK-SD-NEXT:    fmov d1, x8
; CHECK-SD-NEXT:    fcsel d0, d1, d0, ne
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: fsub_constant_sel_constants:
; CHECK-GI:       // %bb.0:
; CHECK-GI-NEXT:    adrp x8, .LCPI44_0
; CHECK-GI-NEXT:    and w9, w0, #0x1
; CHECK-GI-NEXT:    ldr d0, [x8, :lo12:.LCPI44_0]
; CHECK-GI-NEXT:    mov x8, #3689348814741910323 // =0x3333333333333333
; CHECK-GI-NEXT:    tst w9, #0x1
; CHECK-GI-NEXT:    movk x8, #16418, lsl #48
; CHECK-GI-NEXT:    fmov d1, x8
; CHECK-GI-NEXT:    fcsel d0, d1, d0, ne
; CHECK-GI-NEXT:    ret
  %sel = select i1 %cond, double -4.0, double 23.3
  %bo = fsub double 5.1, %sel
  ret double %bo
}

define double @sel_constants_fmul_constant(i1 %cond) {
; CHECK-SD-LABEL: sel_constants_fmul_constant:
; CHECK-SD:       // %bb.0:
; CHECK-SD-NEXT:    adrp x8, .LCPI45_0
; CHECK-SD-NEXT:    tst w0, #0x1
; CHECK-SD-NEXT:    ldr d0, [x8, :lo12:.LCPI45_0]
; CHECK-SD-NEXT:    mov x8, #7378697629483820646 // =0x6666666666666666
; CHECK-SD-NEXT:    movk x8, #49204, lsl #48
; CHECK-SD-NEXT:    fmov d1, x8
; CHECK-SD-NEXT:    fcsel d0, d1, d0, ne
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: sel_constants_fmul_constant:
; CHECK-GI:       // %bb.0:
; CHECK-GI-NEXT:    adrp x8, .LCPI45_0
; CHECK-GI-NEXT:    and w9, w0, #0x1
; CHECK-GI-NEXT:    ldr d0, [x8, :lo12:.LCPI45_0]
; CHECK-GI-NEXT:    mov x8, #7378697629483820646 // =0x6666666666666666
; CHECK-GI-NEXT:    tst w9, #0x1
; CHECK-GI-NEXT:    movk x8, #49204, lsl #48
; CHECK-GI-NEXT:    fmov d1, x8
; CHECK-GI-NEXT:    fcsel d0, d1, d0, ne
; CHECK-GI-NEXT:    ret
  %sel = select i1 %cond, double -4.0, double 23.3
  %bo = fmul double %sel, 5.1
  ret double %bo
}

define double @sel_constants_fdiv_constant(i1 %cond) {
; CHECK-SD-LABEL: sel_constants_fdiv_constant:
; CHECK-SD:       // %bb.0:
; CHECK-SD-NEXT:    adrp x8, .LCPI46_0
; CHECK-SD-NEXT:    adrp x9, .LCPI46_1
; CHECK-SD-NEXT:    tst w0, #0x1
; CHECK-SD-NEXT:    ldr d0, [x8, :lo12:.LCPI46_0]
; CHECK-SD-NEXT:    ldr d1, [x9, :lo12:.LCPI46_1]
; CHECK-SD-NEXT:    fcsel d0, d1, d0, ne
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: sel_constants_fdiv_constant:
; CHECK-GI:       // %bb.0:
; CHECK-GI-NEXT:    adrp x8, .LCPI46_1
; CHECK-GI-NEXT:    adrp x9, .LCPI46_0
; CHECK-GI-NEXT:    ldr d0, [x8, :lo12:.LCPI46_1]
; CHECK-GI-NEXT:    ldr d1, [x9, :lo12:.LCPI46_0]
; CHECK-GI-NEXT:    and w8, w0, #0x1
; CHECK-GI-NEXT:    tst w8, #0x1
; CHECK-GI-NEXT:    fcsel d0, d1, d0, ne
; CHECK-GI-NEXT:    ret
  %sel = select i1 %cond, double -4.0, double 23.3
  %bo = fdiv double %sel, 5.1
  ret double %bo
}

define double @fdiv_constant_sel_constants(i1 %cond) {
; CHECK-SD-LABEL: fdiv_constant_sel_constants:
; CHECK-SD:       // %bb.0:
; CHECK-SD-NEXT:    adrp x8, .LCPI47_0
; CHECK-SD-NEXT:    tst w0, #0x1
; CHECK-SD-NEXT:    ldr d0, [x8, :lo12:.LCPI47_0]
; CHECK-SD-NEXT:    mov x8, #7378697629483820646 // =0x6666666666666666
; CHECK-SD-NEXT:    movk x8, #49140, lsl #48
; CHECK-SD-NEXT:    fmov d1, x8
; CHECK-SD-NEXT:    fcsel d0, d1, d0, ne
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: fdiv_constant_sel_constants:
; CHECK-GI:       // %bb.0:
; CHECK-GI-NEXT:    adrp x8, .LCPI47_0
; CHECK-GI-NEXT:    and w9, w0, #0x1
; CHECK-GI-NEXT:    ldr d0, [x8, :lo12:.LCPI47_0]
; CHECK-GI-NEXT:    mov x8, #7378697629483820646 // =0x6666666666666666
; CHECK-GI-NEXT:    tst w9, #0x1
; CHECK-GI-NEXT:    movk x8, #49140, lsl #48
; CHECK-GI-NEXT:    fmov d1, x8
; CHECK-GI-NEXT:    fcsel d0, d1, d0, ne
; CHECK-GI-NEXT:    ret
  %sel = select i1 %cond, double -4.0, double 23.3
  %bo = fdiv double 5.1, %sel
  ret double %bo
}

define double @sel_constants_frem_constant(i1 %cond) {
; CHECK-SD-LABEL: sel_constants_frem_constant:
; CHECK-SD:       // %bb.0:
; CHECK-SD-NEXT:    adrp x8, .LCPI48_0
; CHECK-SD-NEXT:    fmov d0, #-4.00000000
; CHECK-SD-NEXT:    tst w0, #0x1
; CHECK-SD-NEXT:    ldr d1, [x8, :lo12:.LCPI48_0]
; CHECK-SD-NEXT:    fcsel d0, d0, d1, ne
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: sel_constants_frem_constant:
; CHECK-GI:       // %bb.0:
; CHECK-GI-NEXT:    adrp x8, .LCPI48_0
; CHECK-GI-NEXT:    fmov d0, #-4.00000000
; CHECK-GI-NEXT:    ldr d1, [x8, :lo12:.LCPI48_0]
; CHECK-GI-NEXT:    and w8, w0, #0x1
; CHECK-GI-NEXT:    tst w8, #0x1
; CHECK-GI-NEXT:    fcsel d0, d0, d1, ne
; CHECK-GI-NEXT:    ret
  %sel = select i1 %cond, double -4.0, double 23.3
  %bo = frem double %sel, 5.1
  ret double %bo
}

define double @frem_constant_sel_constants(i1 %cond) {
; CHECK-SD-LABEL: frem_constant_sel_constants:
; CHECK-SD:       // %bb.0:
; CHECK-SD-NEXT:    mov x9, #7378697629483820646 // =0x6666666666666666
; CHECK-SD-NEXT:    adrp x8, .LCPI49_0
; CHECK-SD-NEXT:    tst w0, #0x1
; CHECK-SD-NEXT:    movk x9, #16404, lsl #48
; CHECK-SD-NEXT:    ldr d0, [x8, :lo12:.LCPI49_0]
; CHECK-SD-NEXT:    fmov d1, x9
; CHECK-SD-NEXT:    fcsel d0, d0, d1, ne
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: frem_constant_sel_constants:
; CHECK-GI:       // %bb.0:
; CHECK-GI-NEXT:    adrp x8, .LCPI49_0
; CHECK-GI-NEXT:    and w9, w0, #0x1
; CHECK-GI-NEXT:    ldr d0, [x8, :lo12:.LCPI49_0]
; CHECK-GI-NEXT:    mov x8, #7378697629483820646 // =0x6666666666666666
; CHECK-GI-NEXT:    tst w9, #0x1
; CHECK-GI-NEXT:    movk x8, #16404, lsl #48
; CHECK-GI-NEXT:    fmov d1, x8
; CHECK-GI-NEXT:    fcsel d0, d0, d1, ne
; CHECK-GI-NEXT:    ret
  %sel = select i1 %cond, double -4.0, double 23.3
  %bo = frem double 5.1, %sel
  ret double %bo
}
