; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py UTC_ARGS: --version 5
; RUN: llc --mtriple=loongarch64 --mattr=+lsx < %s | FileCheck %s

;; TODO For these special shuffle mask, we can lower it to vbsll + vbsrl + vor.

define <16 x i8> @byte_rotate_v16i8_1(<16 x i8> %a, <16 x i8> %b) nounwind {
; CHECK-LABEL: byte_rotate_v16i8_1:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vbsrl.v $vr0, $vr0, 5
; CHECK-NEXT:    vbsll.v $vr1, $vr1, 11
; CHECK-NEXT:    vor.v $vr0, $vr1, $vr0
; CHECK-NEXT:    ret
  %shuffle = shufflevector <16 x i8> %a, <16 x i8> %b, <16 x i32> <i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 16, i32 17, i32 18, i32 19, i32 20>
  ret <16 x i8> %shuffle
}

define <16 x i8> @byte_rotate_v16i8_2(<16 x i8> %a, <16 x i8> %b) nounwind {
; CHECK-LABEL: byte_rotate_v16i8_2:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vbsrl.v $vr1, $vr0, 11
; CHECK-NEXT:    vbsll.v $vr0, $vr0, 5
; CHECK-NEXT:    vor.v $vr0, $vr0, $vr1
; CHECK-NEXT:    ret
  %shuffle = shufflevector <16 x i8> %a, <16 x i8> %b, <16 x i32> <i32 11, i32 12, i32 13, i32 14, i32 15, i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10>
  ret <16 x i8> %shuffle
}

define <16 x i8> @byte_rotate_v16i8_3(<16 x i8> %a) nounwind {
; CHECK-LABEL: byte_rotate_v16i8_3:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vbsrl.v $vr1, $vr0, 11
; CHECK-NEXT:    vbsll.v $vr0, $vr0, 5
; CHECK-NEXT:    vor.v $vr0, $vr0, $vr1
; CHECK-NEXT:    ret
  %shuffle = shufflevector <16 x i8> %a, <16 x i8> poison, <16 x i32> <i32 11, i32 12, i32 13, i32 14, i32 15, i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10>
  ret <16 x i8> %shuffle
}

define <8 x i16> @byte_rotate_v8i16_1(<8 x i16> %a, <8 x i16> %b) nounwind {
; CHECK-LABEL: byte_rotate_v8i16_1:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vbsrl.v $vr1, $vr1, 10
; CHECK-NEXT:    vbsll.v $vr0, $vr0, 6
; CHECK-NEXT:    vor.v $vr0, $vr0, $vr1
; CHECK-NEXT:    ret
  %shuffle = shufflevector <8 x i16> %a, <8 x i16> %b, <8 x i32> <i32 13, i32 14, i32 15, i32 0, i32 1, i32 2, i32 3, i32 4>
  ret <8 x i16> %shuffle
}

define <8 x i16> @byte_rotate_v8i16_2(<8 x i16> %a, <8 x i16> %b) nounwind {
; CHECK-LABEL: byte_rotate_v8i16_2:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vbsrl.v $vr0, $vr0, 6
; CHECK-NEXT:    vbsll.v $vr1, $vr1, 10
; CHECK-NEXT:    vor.v $vr0, $vr1, $vr0
; CHECK-NEXT:    ret
  %shuffle = shufflevector <8 x i16> %a, <8 x i16> %b, <8 x i32> <i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10>
  ret <8 x i16> %shuffle
}

define <8 x i16> @byte_rotate_v8i16_3(<8 x i16> %a) nounwind {
; CHECK-LABEL: byte_rotate_v8i16_3:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vbsrl.v $vr1, $vr0, 10
; CHECK-NEXT:    vbsll.v $vr0, $vr0, 6
; CHECK-NEXT:    vor.v $vr0, $vr0, $vr1
; CHECK-NEXT:    ret
  %shuffle = shufflevector <8 x i16> %a, <8 x i16> poison, <8 x i32> <i32 5, i32 6, i32 7, i32 0, i32 1, i32 2, i32 3, i32 4>
  ret <8 x i16> %shuffle
}

define <4 x i32> @byte_rotate_v4i32_1(<4 x i32> %a, <4 x i32> %b) nounwind {
; CHECK-LABEL: byte_rotate_v4i32_1:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vbsrl.v $vr1, $vr1, 12
; CHECK-NEXT:    vbsll.v $vr0, $vr0, 4
; CHECK-NEXT:    vor.v $vr0, $vr0, $vr1
; CHECK-NEXT:    ret
    %shuffle = shufflevector <4 x i32> %a, <4 x i32> %b, <4 x i32> <i32 7, i32 0, i32 1, i32 2>
    ret <4 x i32> %shuffle
}

define <4 x i32> @byte_rotate_v4i32_2(<4 x i32> %a, <4 x i32> %b) nounwind {
; CHECK-LABEL: byte_rotate_v4i32_2:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vbsrl.v $vr0, $vr0, 4
; CHECK-NEXT:    vbsll.v $vr1, $vr1, 12
; CHECK-NEXT:    vor.v $vr0, $vr1, $vr0
; CHECK-NEXT:    ret
    %shuffle = shufflevector <4 x i32> %a, <4 x i32> %b, <4 x i32> <i32 1, i32 2, i32 3, i32 4>
    ret <4 x i32> %shuffle
}

define <4 x i32> @byte_rotate_v4i32_3(<4 x i32> %a) nounwind {
; CHECK-LABEL: byte_rotate_v4i32_3:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vshuf4i.w $vr0, $vr0, 147
; CHECK-NEXT:    ret
    %shuffle = shufflevector <4 x i32> %a, <4 x i32> poison, <4 x i32> <i32 3, i32 0, i32 1, i32 2>
    ret <4 x i32> %shuffle
}

define <2 x i64> @byte_rotate_v2i64_1(<2 x i64> %a, <2 x i64> %b) nounwind {
; CHECK-LABEL: byte_rotate_v2i64_1:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vshuf4i.d $vr0, $vr1, 3
; CHECK-NEXT:    ret
    %shuffle = shufflevector <2 x i64> %a, <2 x i64> %b, <2 x i32> <i32 3, i32 0>
    ret <2 x i64> %shuffle
}

define <2 x i64> @byte_rotate_v2i64_2(<2 x i64> %a, <2 x i64> %b) nounwind {
; CHECK-LABEL: byte_rotate_v2i64_2:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vshuf4i.d $vr0, $vr1, 9
; CHECK-NEXT:    ret
    %shuffle = shufflevector <2 x i64> %a, <2 x i64> %b, <2 x i32> <i32 1, i32 2>
    ret <2 x i64> %shuffle
}

define <2 x i64> @byte_rotate_v2i64_3(<2 x i64> %a) nounwind {
; CHECK-LABEL: byte_rotate_v2i64_3:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vshuf4i.d $vr0, $vr0, 1
; CHECK-NEXT:    ret
    %shuffle = shufflevector <2 x i64> %a, <2 x i64> poison, <2 x i32> <i32 1, i32 0>
    ret <2 x i64> %shuffle
}
