; NOTE: Assertions have been autogenerated by utils/update_test_checks.py UTC_ARGS: --version 5
; RUN: opt -p lower-matrix-intrinsics -S %s | FileCheck %s

define void @redundant_transpose_of_shuffle(<4 x float> %m, ptr %dst) {
; CHECK-LABEL: define void @redundant_transpose_of_shuffle(
; CHECK-SAME: <4 x float> [[M:%.*]], ptr [[DST:%.*]]) {
; CHECK-NEXT:  [[ENTRY:.*:]]
; CHECK-NEXT:    [[SHUFFLE:%.*]] = shufflevector <4 x float> [[M]], <4 x float> zeroinitializer, <4 x i32> zeroinitializer
; CHECK-NEXT:    [[SPLIT:%.*]] = shufflevector <4 x float> [[SHUFFLE]], <4 x float> poison, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
; CHECK-NEXT:    store <4 x float> [[SPLIT]], ptr [[DST]], align 4
; CHECK-NEXT:    ret void
;
entry:
  %shuffle = shufflevector <4 x float> %m, <4 x float> zeroinitializer, <4 x i32> zeroinitializer
  %t = tail call <4 x float> @llvm.matrix.transpose.v3f32(<4 x float> %shuffle, i32 1, i32 4)
  store <4 x float> %t, ptr %dst, align 4
  ret void
}

define void @redundant_transpose_of_shuffle_2(<4 x float> %m, ptr %dst) {
; CHECK-LABEL: define void @redundant_transpose_of_shuffle_2(
; CHECK-SAME: <4 x float> [[M:%.*]], ptr [[DST:%.*]]) {
; CHECK-NEXT:  [[ENTRY:.*:]]
; CHECK-NEXT:    [[SHUFFLE:%.*]] = shufflevector <4 x float> [[M]], <4 x float> zeroinitializer, <4 x i32> zeroinitializer
; CHECK-NEXT:    [[SPLIT:%.*]] = shufflevector <4 x float> [[SHUFFLE]], <4 x float> poison, <1 x i32> zeroinitializer
; CHECK-NEXT:    [[SPLIT1:%.*]] = shufflevector <4 x float> [[SHUFFLE]], <4 x float> poison, <1 x i32> <i32 1>
; CHECK-NEXT:    [[SPLIT2:%.*]] = shufflevector <4 x float> [[SHUFFLE]], <4 x float> poison, <1 x i32> <i32 2>
; CHECK-NEXT:    [[SPLIT3:%.*]] = shufflevector <4 x float> [[SHUFFLE]], <4 x float> poison, <1 x i32> <i32 3>
; CHECK-NEXT:    store <1 x float> [[SPLIT]], ptr [[DST]], align 4
; CHECK-NEXT:    [[VEC_GEP:%.*]] = getelementptr float, ptr [[DST]], i64 1
; CHECK-NEXT:    store <1 x float> [[SPLIT1]], ptr [[VEC_GEP]], align 4
; CHECK-NEXT:    [[VEC_GEP4:%.*]] = getelementptr float, ptr [[DST]], i64 2
; CHECK-NEXT:    store <1 x float> [[SPLIT2]], ptr [[VEC_GEP4]], align 4
; CHECK-NEXT:    [[VEC_GEP5:%.*]] = getelementptr float, ptr [[DST]], i64 3
; CHECK-NEXT:    store <1 x float> [[SPLIT3]], ptr [[VEC_GEP5]], align 4
; CHECK-NEXT:    ret void
;
entry:
  %shuffle = shufflevector <4 x float> %m, <4 x float> zeroinitializer, <4 x i32> zeroinitializer
  %t = tail call <4 x float> @llvm.matrix.transpose.v3f32(<4 x float> %shuffle, i32 4, i32 1)
  store <4 x float> %t, ptr %dst, align 4
  ret void
}

declare <4 x float> @llvm.matrix.transpose.v3f32(<4 x float>, i32, i32)
