; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -mtriple=aarch64-unknown-linux-gnu < %s | FileCheck %s --check-prefixes=CHECK,CHECK-SD
; RUN: llc -mtriple=aarch64-unknown-linux-gnu -global-isel -global-isel-abort=2 2>&1 < %s | FileCheck %s --check-prefixes=CHECK,CHECK-GI

; CHECK-GI:       warning: Instruction selection used fallback path for freeze_v2i8

%struct.T = type { i32, i32 }

define i32 @freeze_int() {
; CHECK-LABEL: freeze_int:
; CHECK:       // %bb.0:
; CHECK-NEXT:    mul w0, w8, w8
; CHECK-NEXT:    ret
  %y1 = freeze i32 undef
  %t1 = mul i32 %y1, %y1
  ret i32 %t1
}

define i5 @freeze_int2() {
; CHECK-LABEL: freeze_int2:
; CHECK:       // %bb.0:
; CHECK-NEXT:    mul w0, w8, w8
; CHECK-NEXT:    ret
  %y1 = freeze i5 undef
  %t1 = mul i5 %y1, %y1
  ret i5 %t1
}

define float @freeze_float() {
; CHECK-LABEL: freeze_float:
; CHECK:       // %bb.0:
; CHECK-NEXT:    fadd s0, s0, s0
; CHECK-NEXT:    ret
  %y1 = freeze float undef
  %t1 = fadd float %y1, %y1
  ret float %t1
}

define <2 x i8> @freeze_v2i8() {
; CHECK-LABEL: freeze_v2i8:
; CHECK:       // %bb.0:
; CHECK-NEXT:    add v0.2s, v0.2s, v0.2s
; CHECK-NEXT:    ret
  %y1 = freeze <2 x i8> undef
  %t1 = add <2 x i8> %y1, %y1
  ret <2 x i8> %t1
}

define <3 x i8> @freeze_v3i8() {
; CHECK-SD-LABEL: freeze_v3i8:
; CHECK-SD:       // %bb.0:
; CHECK-SD-NEXT:    add v0.4h, v0.4h, v0.4h
; CHECK-SD-NEXT:    umov w0, v0.h[0]
; CHECK-SD-NEXT:    umov w1, v0.h[1]
; CHECK-SD-NEXT:    umov w2, v0.h[2]
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: freeze_v3i8:
; CHECK-GI:       // %bb.0:
; CHECK-GI-NEXT:    mov b0, v0.b[1]
; CHECK-GI-NEXT:    mov b1, v0.b[2]
; CHECK-GI-NEXT:    fmov w8, s0
; CHECK-GI-NEXT:    mov v0.h[1], w8
; CHECK-GI-NEXT:    fmov w8, s1
; CHECK-GI-NEXT:    mov v0.h[2], w8
; CHECK-GI-NEXT:    add v0.4h, v0.4h, v0.4h
; CHECK-GI-NEXT:    umov w0, v0.h[0]
; CHECK-GI-NEXT:    umov w1, v0.h[1]
; CHECK-GI-NEXT:    umov w2, v0.h[2]
; CHECK-GI-NEXT:    ret
  %y1 = freeze <3 x i8> undef
  %t1 = add <3 x i8> %y1, %y1
  ret <3 x i8> %t1
}

define <4 x i8> @freeze_v4i8() {
; CHECK-SD-LABEL: freeze_v4i8:
; CHECK-SD:       // %bb.0:
; CHECK-SD-NEXT:    add v0.4h, v0.4h, v0.4h
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: freeze_v4i8:
; CHECK-GI:       // %bb.0:
; CHECK-GI-NEXT:    mov b0, v0.b[1]
; CHECK-GI-NEXT:    fmov w8, s0
; CHECK-GI-NEXT:    mov b1, v0.b[2]
; CHECK-GI-NEXT:    mov v0.h[1], w8
; CHECK-GI-NEXT:    fmov w8, s1
; CHECK-GI-NEXT:    mov b2, v0.b[3]
; CHECK-GI-NEXT:    mov v0.h[2], w8
; CHECK-GI-NEXT:    fmov w8, s2
; CHECK-GI-NEXT:    mov v0.h[3], w8
; CHECK-GI-NEXT:    add v0.4h, v0.4h, v0.4h
; CHECK-GI-NEXT:    ret
  %y1 = freeze <4 x i8> undef
  %t1 = add <4 x i8> %y1, %y1
  ret <4 x i8> %t1
}

define <8 x i8> @freeze_v8i8() {
; CHECK-LABEL: freeze_v8i8:
; CHECK:       // %bb.0:
; CHECK-NEXT:    add v0.8b, v0.8b, v0.8b
; CHECK-NEXT:    ret
  %y1 = freeze <8 x i8> undef
  %t1 = add <8 x i8> %y1, %y1
  ret <8 x i8> %t1
}

define <16 x i8> @freeze_v16i8() {
; CHECK-LABEL: freeze_v16i8:
; CHECK:       // %bb.0:
; CHECK-NEXT:    add v0.16b, v0.16b, v0.16b
; CHECK-NEXT:    ret
  %y1 = freeze <16 x i8> undef
  %t1 = add <16 x i8> %y1, %y1
  ret <16 x i8> %t1
}

define <32 x i8> @freeze_v32i8() {
; CHECK-LABEL: freeze_v32i8:
; CHECK:       // %bb.0:
; CHECK-NEXT:    add v0.16b, v0.16b, v0.16b
; CHECK-NEXT:    mov v1.16b, v0.16b
; CHECK-NEXT:    ret
  %y1 = freeze <32 x i8> undef
  %t1 = add <32 x i8> %y1, %y1
  ret <32 x i8> %t1
}

define <2 x i16> @freeze_v2i16() {
; CHECK-SD-LABEL: freeze_v2i16:
; CHECK-SD:       // %bb.0:
; CHECK-SD-NEXT:    add v0.2s, v0.2s, v0.2s
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: freeze_v2i16:
; CHECK-GI:       // %bb.0:
; CHECK-GI-NEXT:    mov h0, v0.h[1]
; CHECK-GI-NEXT:    fmov w8, s0
; CHECK-GI-NEXT:    mov v0.s[1], w8
; CHECK-GI-NEXT:    add v0.2s, v0.2s, v0.2s
; CHECK-GI-NEXT:    ret
  %y1 = freeze <2 x i16> undef
  %t1 = add <2 x i16> %y1, %y1
  ret <2 x i16> %t1
}

define <3 x i16> @freeze_v3i16() {
; CHECK-LABEL: freeze_v3i16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    add v0.4h, v0.4h, v0.4h
; CHECK-NEXT:    ret
  %y1 = freeze <3 x i16> undef
  %t1 = add <3 x i16> %y1, %y1
  ret <3 x i16> %t1
}

define <4 x i16> @freeze_v4i16() {
; CHECK-LABEL: freeze_v4i16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    add v0.4h, v0.4h, v0.4h
; CHECK-NEXT:    ret
  %y1 = freeze <4 x i16> undef
  %t1 = add <4 x i16> %y1, %y1
  ret <4 x i16> %t1
}

define <8 x i16> @freeze_v8i16() {
; CHECK-LABEL: freeze_v8i16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    add v0.8h, v0.8h, v0.8h
; CHECK-NEXT:    ret
  %y1 = freeze <8 x i16> undef
  %t1 = add <8 x i16> %y1, %y1
  ret <8 x i16> %t1
}

define <16 x i16> @freeze_v16i16() {
; CHECK-LABEL: freeze_v16i16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    add v0.8h, v0.8h, v0.8h
; CHECK-NEXT:    mov v1.16b, v0.16b
; CHECK-NEXT:    ret
  %y1 = freeze <16 x i16> undef
  %t1 = add <16 x i16> %y1, %y1
  ret <16 x i16> %t1
}

define <2 x i32> @freeze_v2i32() {
; CHECK-LABEL: freeze_v2i32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    add v0.2s, v0.2s, v0.2s
; CHECK-NEXT:    ret
  %y1 = freeze <2 x i32> undef
  %t1 = add <2 x i32> %y1, %y1
  ret <2 x i32> %t1
}

define <3 x i32> @freeze_v3i32() {
; CHECK-LABEL: freeze_v3i32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    add v0.4s, v0.4s, v0.4s
; CHECK-NEXT:    ret
  %y1 = freeze <3 x i32> undef
  %t1 = add <3 x i32> %y1, %y1
  ret <3 x i32> %t1
}

define <4 x i32> @freeze_v4i32() {
; CHECK-LABEL: freeze_v4i32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    add v0.4s, v0.4s, v0.4s
; CHECK-NEXT:    ret
  %y1 = freeze <4 x i32> undef
  %t1 = add <4 x i32> %y1, %y1
  ret <4 x i32> %t1
}

define <8 x i32> @freeze_v8i32() {
; CHECK-LABEL: freeze_v8i32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    add v0.4s, v0.4s, v0.4s
; CHECK-NEXT:    mov v1.16b, v0.16b
; CHECK-NEXT:    ret
  %y1 = freeze <8 x i32> undef
  %t1 = add <8 x i32> %y1, %y1
  ret <8 x i32> %t1
}

define <2 x i64> @freeze_v2i64() {
; CHECK-LABEL: freeze_v2i64:
; CHECK:       // %bb.0:
; CHECK-NEXT:    add v0.2d, v0.2d, v0.2d
; CHECK-NEXT:    ret
  %y1 = freeze <2 x i64> undef
  %t1 = add <2 x i64> %y1, %y1
  ret <2 x i64> %t1
}

define <3 x i64> @freeze_v3i64() {
; CHECK-SD-LABEL: freeze_v3i64:
; CHECK-SD:       // %bb.0:
; CHECK-SD-NEXT:    add v0.2d, v0.2d, v0.2d
; CHECK-SD-NEXT:    fmov d2, d0
; CHECK-SD-NEXT:    ext v1.16b, v0.16b, v0.16b, #8
; CHECK-SD-NEXT:    // kill: def $d1 killed $d1 killed $q1
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: freeze_v3i64:
; CHECK-GI:       // %bb.0:
; CHECK-GI-NEXT:    add v0.2d, v0.2d, v0.2d
; CHECK-GI-NEXT:    add x8, x8, x8
; CHECK-GI-NEXT:    fmov d2, x8
; CHECK-GI-NEXT:    mov d1, v0.d[1]
; CHECK-GI-NEXT:    // kill: def $d0 killed $d0 killed $q0
; CHECK-GI-NEXT:    ret
  %y1 = freeze <3 x i64> undef
  %t1 = add <3 x i64> %y1, %y1
  ret <3 x i64> %t1
}

define <4 x i64> @freeze_v4i64() {
; CHECK-LABEL: freeze_v4i64:
; CHECK:       // %bb.0:
; CHECK-NEXT:    add v0.2d, v0.2d, v0.2d
; CHECK-NEXT:    mov v1.16b, v0.16b
; CHECK-NEXT:    ret
  %y1 = freeze <4 x i64> undef
  %t1 = add <4 x i64> %y1, %y1
  ret <4 x i64> %t1
}

define <2 x ptr> @freeze_v2p0() {
; CHECK-SD-LABEL: freeze_v2p0:
; CHECK-SD:       // %bb.0:
; CHECK-SD-NEXT:    mov w8, #4 // =0x4
; CHECK-SD-NEXT:    dup v0.2d, x8
; CHECK-SD-NEXT:    add v0.2d, v0.2d, v0.2d
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: freeze_v2p0:
; CHECK-GI:       // %bb.0:
; CHECK-GI-NEXT:    adrp x8, .LCPI21_0
; CHECK-GI-NEXT:    ldr q0, [x8, :lo12:.LCPI21_0]
; CHECK-GI-NEXT:    add v0.2d, v0.2d, v0.2d
; CHECK-GI-NEXT:    ret
  %y1 = freeze <2 x ptr> undef
  %t1 = getelementptr i32, <2 x ptr> %y1, i32 1
  ret <2 x ptr> %t1
}

define <3 x ptr> @freeze_v3p0() {
; CHECK-SD-LABEL: freeze_v3p0:
; CHECK-SD:       // %bb.0:
; CHECK-SD-NEXT:    mov w8, #4 // =0x4
; CHECK-SD-NEXT:    dup v2.2d, x8
; CHECK-SD-NEXT:    add v0.2d, v0.2d, v2.2d
; CHECK-SD-NEXT:    add d2, d0, d2
; CHECK-SD-NEXT:    ext v1.16b, v0.16b, v0.16b, #8
; CHECK-SD-NEXT:    // kill: def $d0 killed $d0 killed $q0
; CHECK-SD-NEXT:    // kill: def $d1 killed $d1 killed $q1
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: freeze_v3p0:
; CHECK-GI:       // %bb.0:
; CHECK-GI-NEXT:    adrp x8, .LCPI22_0
; CHECK-GI-NEXT:    ldr q0, [x8, :lo12:.LCPI22_0]
; CHECK-GI-NEXT:    add x8, x8, #4
; CHECK-GI-NEXT:    fmov d2, x8
; CHECK-GI-NEXT:    add v0.2d, v0.2d, v0.2d
; CHECK-GI-NEXT:    mov d1, v0.d[1]
; CHECK-GI-NEXT:    ret
  %y1 = freeze <3 x ptr> undef
  %t1 = getelementptr i32, <3 x ptr> %y1, i32 1
  ret <3 x ptr> %t1
}

define <4 x ptr> @freeze_v4p0() {
; CHECK-SD-LABEL: freeze_v4p0:
; CHECK-SD:       // %bb.0:
; CHECK-SD-NEXT:    mov w8, #4 // =0x4
; CHECK-SD-NEXT:    dup v0.2d, x8
; CHECK-SD-NEXT:    add v0.2d, v0.2d, v0.2d
; CHECK-SD-NEXT:    mov v1.16b, v0.16b
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: freeze_v4p0:
; CHECK-GI:       // %bb.0:
; CHECK-GI-NEXT:    adrp x8, .LCPI23_0
; CHECK-GI-NEXT:    ldr q0, [x8, :lo12:.LCPI23_0]
; CHECK-GI-NEXT:    add v0.2d, v0.2d, v0.2d
; CHECK-GI-NEXT:    mov v1.16b, v0.16b
; CHECK-GI-NEXT:    ret
  %y1 = freeze <4 x ptr> undef
  %t1 = getelementptr i32, <4 x ptr> %y1, i32 1
  ret <4 x ptr> %t1
}

define ptr @freeze_ptr() {
; CHECK-LABEL: freeze_ptr:
; CHECK:       // %bb.0:
; CHECK-NEXT:    add x0, x8, #4
; CHECK-NEXT:    ret
  %y1 = freeze ptr undef
  %t1 = getelementptr i8, ptr %y1, i64 4
  ret ptr %t1
}

define i32 @freeze_struct() {
; CHECK-LABEL: freeze_struct:
; CHECK:       // %bb.0:
; CHECK-NEXT:    add w0, w8, w8
; CHECK-NEXT:    ret
  %y1 = freeze %struct.T undef
  %v1 = extractvalue %struct.T %y1, 0
  %v2 = extractvalue %struct.T %y1, 1
  %t1 = add i32 %v1, %v2
  ret i32 %t1
}

define i32 @freeze_anonstruct() {
; CHECK-LABEL: freeze_anonstruct:
; CHECK:       // %bb.0:
; CHECK-NEXT:    add w0, w8, w8
; CHECK-NEXT:    ret
  %y1 = freeze {i32, i32} undef
  %v1 = extractvalue {i32, i32} %y1, 0
  %v2 = extractvalue {i32, i32} %y1, 1
  %t1 = add i32 %v1, %v2
  ret i32 %t1
}

define i32 @freeze_anonstruct2() {
; CHECK-LABEL: freeze_anonstruct2:
; CHECK:       // %bb.0:
; CHECK-NEXT:    add w0, w8, w8, uxth
; CHECK-NEXT:    ret
  %y1 = freeze {i32, i16} undef
  %v1 = extractvalue {i32, i16} %y1, 0
  %v2 = extractvalue {i32, i16} %y1, 1
  %z2 = zext i16 %v2 to i32
  %t1 = add i32 %v1, %z2
  ret i32 %t1
}

define i64 @freeze_array() {
; CHECK-LABEL: freeze_array:
; CHECK:       // %bb.0:
; CHECK-NEXT:    add x0, x8, x8
; CHECK-NEXT:    ret
  %y1 = freeze [2 x i64] undef
  %v1 = extractvalue [2 x i64] %y1, 0
  %v2 = extractvalue [2 x i64] %y1, 1
  %t1 = add i64 %v1, %v2
  ret i64 %t1
}
