// RUN: llvm-mc -triple=amdgcn -mcpu=bonaire -show-encoding %s | FileCheck %s

ds_add_u32 v1, v2 offset:65535
// CHECK: [0xff,0xff,0x00,0xd8,0x01,0x02,0x00,0x00]

ds_add_u32 v255, v2 offset:65535
// CHECK: [0xff,0xff,0x00,0xd8,0xff,0x02,0x00,0x00]

ds_add_u32 v1, v255 offset:65535
// CHECK: [0xff,0xff,0x00,0xd8,0x01,0xff,0x00,0x00]

ds_add_u32 v1, v2
// CHECK: [0x00,0x00,0x00,0xd8,0x01,0x02,0x00,0x00]

ds_add_u32 v1, v2 offset:0
// CHECK: [0x00,0x00,0x00,0xd8,0x01,0x02,0x00,0x00]

ds_add_u32 v1, v2 offset:4
// CHECK: [0x04,0x00,0x00,0xd8,0x01,0x02,0x00,0x00]

ds_add_u32 v1, v2 offset:65535 gds
// CHECK: [0xff,0xff,0x02,0xd8,0x01,0x02,0x00,0x00]

ds_sub_u32 v1, v2 offset:65535
// CHECK: [0xff,0xff,0x04,0xd8,0x01,0x02,0x00,0x00]

ds_sub_u32 v255, v2 offset:65535
// CHECK: [0xff,0xff,0x04,0xd8,0xff,0x02,0x00,0x00]

ds_sub_u32 v1, v255 offset:65535
// CHECK: [0xff,0xff,0x04,0xd8,0x01,0xff,0x00,0x00]

ds_sub_u32 v1, v2
// CHECK: [0x00,0x00,0x04,0xd8,0x01,0x02,0x00,0x00]

ds_sub_u32 v1, v2 offset:0
// CHECK: [0x00,0x00,0x04,0xd8,0x01,0x02,0x00,0x00]

ds_sub_u32 v1, v2 offset:4
// CHECK: [0x04,0x00,0x04,0xd8,0x01,0x02,0x00,0x00]

ds_sub_u32 v1, v2 offset:65535 gds
// CHECK: [0xff,0xff,0x06,0xd8,0x01,0x02,0x00,0x00]

ds_rsub_u32 v1, v2 offset:65535
// CHECK: [0xff,0xff,0x08,0xd8,0x01,0x02,0x00,0x00]

ds_rsub_u32 v255, v2 offset:65535
// CHECK: [0xff,0xff,0x08,0xd8,0xff,0x02,0x00,0x00]

ds_rsub_u32 v1, v255 offset:65535
// CHECK: [0xff,0xff,0x08,0xd8,0x01,0xff,0x00,0x00]

ds_rsub_u32 v1, v2
// CHECK: [0x00,0x00,0x08,0xd8,0x01,0x02,0x00,0x00]

ds_rsub_u32 v1, v2 offset:0
// CHECK: [0x00,0x00,0x08,0xd8,0x01,0x02,0x00,0x00]

ds_rsub_u32 v1, v2 offset:4
// CHECK: [0x04,0x00,0x08,0xd8,0x01,0x02,0x00,0x00]

ds_rsub_u32 v1, v2 offset:65535 gds
// CHECK: [0xff,0xff,0x0a,0xd8,0x01,0x02,0x00,0x00]

ds_inc_u32 v1, v2 offset:65535
// CHECK: [0xff,0xff,0x0c,0xd8,0x01,0x02,0x00,0x00]

ds_inc_u32 v255, v2 offset:65535
// CHECK: [0xff,0xff,0x0c,0xd8,0xff,0x02,0x00,0x00]

ds_inc_u32 v1, v255 offset:65535
// CHECK: [0xff,0xff,0x0c,0xd8,0x01,0xff,0x00,0x00]

ds_inc_u32 v1, v2
// CHECK: [0x00,0x00,0x0c,0xd8,0x01,0x02,0x00,0x00]

ds_inc_u32 v1, v2 offset:0
// CHECK: [0x00,0x00,0x0c,0xd8,0x01,0x02,0x00,0x00]

ds_inc_u32 v1, v2 offset:4
// CHECK: [0x04,0x00,0x0c,0xd8,0x01,0x02,0x00,0x00]

ds_inc_u32 v1, v2 offset:65535 gds
// CHECK: [0xff,0xff,0x0e,0xd8,0x01,0x02,0x00,0x00]

ds_dec_u32 v1, v2 offset:65535
// CHECK: [0xff,0xff,0x10,0xd8,0x01,0x02,0x00,0x00]

ds_dec_u32 v255, v2 offset:65535
// CHECK: [0xff,0xff,0x10,0xd8,0xff,0x02,0x00,0x00]

ds_dec_u32 v1, v255 offset:65535
// CHECK: [0xff,0xff,0x10,0xd8,0x01,0xff,0x00,0x00]

ds_dec_u32 v1, v2
// CHECK: [0x00,0x00,0x10,0xd8,0x01,0x02,0x00,0x00]

ds_dec_u32 v1, v2 offset:0
// CHECK: [0x00,0x00,0x10,0xd8,0x01,0x02,0x00,0x00]

ds_dec_u32 v1, v2 offset:4
// CHECK: [0x04,0x00,0x10,0xd8,0x01,0x02,0x00,0x00]

ds_dec_u32 v1, v2 offset:65535 gds
// CHECK: [0xff,0xff,0x12,0xd8,0x01,0x02,0x00,0x00]

ds_min_i32 v1, v2 offset:65535
// CHECK: [0xff,0xff,0x14,0xd8,0x01,0x02,0x00,0x00]

ds_min_i32 v255, v2 offset:65535
// CHECK: [0xff,0xff,0x14,0xd8,0xff,0x02,0x00,0x00]

ds_min_i32 v1, v255 offset:65535
// CHECK: [0xff,0xff,0x14,0xd8,0x01,0xff,0x00,0x00]

ds_min_i32 v1, v2
// CHECK: [0x00,0x00,0x14,0xd8,0x01,0x02,0x00,0x00]

ds_min_i32 v1, v2 offset:0
// CHECK: [0x00,0x00,0x14,0xd8,0x01,0x02,0x00,0x00]

ds_min_i32 v1, v2 offset:4
// CHECK: [0x04,0x00,0x14,0xd8,0x01,0x02,0x00,0x00]

ds_min_i32 v1, v2 offset:65535 gds
// CHECK: [0xff,0xff,0x16,0xd8,0x01,0x02,0x00,0x00]

ds_max_i32 v1, v2 offset:65535
// CHECK: [0xff,0xff,0x18,0xd8,0x01,0x02,0x00,0x00]

ds_max_i32 v255, v2 offset:65535
// CHECK: [0xff,0xff,0x18,0xd8,0xff,0x02,0x00,0x00]

ds_max_i32 v1, v255 offset:65535
// CHECK: [0xff,0xff,0x18,0xd8,0x01,0xff,0x00,0x00]

ds_max_i32 v1, v2
// CHECK: [0x00,0x00,0x18,0xd8,0x01,0x02,0x00,0x00]

ds_max_i32 v1, v2 offset:0
// CHECK: [0x00,0x00,0x18,0xd8,0x01,0x02,0x00,0x00]

ds_max_i32 v1, v2 offset:4
// CHECK: [0x04,0x00,0x18,0xd8,0x01,0x02,0x00,0x00]

ds_max_i32 v1, v2 offset:65535 gds
// CHECK: [0xff,0xff,0x1a,0xd8,0x01,0x02,0x00,0x00]

ds_min_u32 v1, v2 offset:65535
// CHECK: [0xff,0xff,0x1c,0xd8,0x01,0x02,0x00,0x00]

ds_min_u32 v255, v2 offset:65535
// CHECK: [0xff,0xff,0x1c,0xd8,0xff,0x02,0x00,0x00]

ds_min_u32 v1, v255 offset:65535
// CHECK: [0xff,0xff,0x1c,0xd8,0x01,0xff,0x00,0x00]

ds_min_u32 v1, v2
// CHECK: [0x00,0x00,0x1c,0xd8,0x01,0x02,0x00,0x00]

ds_min_u32 v1, v2 offset:0
// CHECK: [0x00,0x00,0x1c,0xd8,0x01,0x02,0x00,0x00]

ds_min_u32 v1, v2 offset:4
// CHECK: [0x04,0x00,0x1c,0xd8,0x01,0x02,0x00,0x00]

ds_min_u32 v1, v2 offset:65535 gds
// CHECK: [0xff,0xff,0x1e,0xd8,0x01,0x02,0x00,0x00]

ds_max_u32 v1, v2 offset:65535
// CHECK: [0xff,0xff,0x20,0xd8,0x01,0x02,0x00,0x00]

ds_max_u32 v255, v2 offset:65535
// CHECK: [0xff,0xff,0x20,0xd8,0xff,0x02,0x00,0x00]

ds_max_u32 v1, v255 offset:65535
// CHECK: [0xff,0xff,0x20,0xd8,0x01,0xff,0x00,0x00]

ds_max_u32 v1, v2
// CHECK: [0x00,0x00,0x20,0xd8,0x01,0x02,0x00,0x00]

ds_max_u32 v1, v2 offset:0
// CHECK: [0x00,0x00,0x20,0xd8,0x01,0x02,0x00,0x00]

ds_max_u32 v1, v2 offset:4
// CHECK: [0x04,0x00,0x20,0xd8,0x01,0x02,0x00,0x00]

ds_max_u32 v1, v2 offset:65535 gds
// CHECK: [0xff,0xff,0x22,0xd8,0x01,0x02,0x00,0x00]

ds_and_b32 v1, v2 offset:65535
// CHECK: [0xff,0xff,0x24,0xd8,0x01,0x02,0x00,0x00]

ds_and_b32 v255, v2 offset:65535
// CHECK: [0xff,0xff,0x24,0xd8,0xff,0x02,0x00,0x00]

ds_and_b32 v1, v255 offset:65535
// CHECK: [0xff,0xff,0x24,0xd8,0x01,0xff,0x00,0x00]

ds_and_b32 v1, v2
// CHECK: [0x00,0x00,0x24,0xd8,0x01,0x02,0x00,0x00]

ds_and_b32 v1, v2 offset:0
// CHECK: [0x00,0x00,0x24,0xd8,0x01,0x02,0x00,0x00]

ds_and_b32 v1, v2 offset:4
// CHECK: [0x04,0x00,0x24,0xd8,0x01,0x02,0x00,0x00]

ds_and_b32 v1, v2 offset:65535 gds
// CHECK: [0xff,0xff,0x26,0xd8,0x01,0x02,0x00,0x00]

ds_or_b32 v1, v2 offset:65535
// CHECK: [0xff,0xff,0x28,0xd8,0x01,0x02,0x00,0x00]

ds_or_b32 v255, v2 offset:65535
// CHECK: [0xff,0xff,0x28,0xd8,0xff,0x02,0x00,0x00]

ds_or_b32 v1, v255 offset:65535
// CHECK: [0xff,0xff,0x28,0xd8,0x01,0xff,0x00,0x00]

ds_or_b32 v1, v2
// CHECK: [0x00,0x00,0x28,0xd8,0x01,0x02,0x00,0x00]

ds_or_b32 v1, v2 offset:0
// CHECK: [0x00,0x00,0x28,0xd8,0x01,0x02,0x00,0x00]

ds_or_b32 v1, v2 offset:4
// CHECK: [0x04,0x00,0x28,0xd8,0x01,0x02,0x00,0x00]

ds_or_b32 v1, v2 offset:65535 gds
// CHECK: [0xff,0xff,0x2a,0xd8,0x01,0x02,0x00,0x00]

ds_xor_b32 v1, v2 offset:65535
// CHECK: [0xff,0xff,0x2c,0xd8,0x01,0x02,0x00,0x00]

ds_xor_b32 v255, v2 offset:65535
// CHECK: [0xff,0xff,0x2c,0xd8,0xff,0x02,0x00,0x00]

ds_xor_b32 v1, v255 offset:65535
// CHECK: [0xff,0xff,0x2c,0xd8,0x01,0xff,0x00,0x00]

ds_xor_b32 v1, v2
// CHECK: [0x00,0x00,0x2c,0xd8,0x01,0x02,0x00,0x00]

ds_xor_b32 v1, v2 offset:0
// CHECK: [0x00,0x00,0x2c,0xd8,0x01,0x02,0x00,0x00]

ds_xor_b32 v1, v2 offset:4
// CHECK: [0x04,0x00,0x2c,0xd8,0x01,0x02,0x00,0x00]

ds_xor_b32 v1, v2 offset:65535 gds
// CHECK: [0xff,0xff,0x2e,0xd8,0x01,0x02,0x00,0x00]

ds_mskor_b32 v1, v2, v3 offset:65535
// CHECK: [0xff,0xff,0x30,0xd8,0x01,0x02,0x03,0x00]

ds_mskor_b32 v255, v2, v3 offset:65535
// CHECK: [0xff,0xff,0x30,0xd8,0xff,0x02,0x03,0x00]

ds_mskor_b32 v1, v255, v3 offset:65535
// CHECK: [0xff,0xff,0x30,0xd8,0x01,0xff,0x03,0x00]

ds_mskor_b32 v1, v2, v255 offset:65535
// CHECK: [0xff,0xff,0x30,0xd8,0x01,0x02,0xff,0x00]

ds_mskor_b32 v1, v2, v3
// CHECK: [0x00,0x00,0x30,0xd8,0x01,0x02,0x03,0x00]

ds_mskor_b32 v1, v2, v3 offset:0
// CHECK: [0x00,0x00,0x30,0xd8,0x01,0x02,0x03,0x00]

ds_mskor_b32 v1, v2, v3 offset:4
// CHECK: [0x04,0x00,0x30,0xd8,0x01,0x02,0x03,0x00]

ds_mskor_b32 v1, v2, v3 offset:65535 gds
// CHECK: [0xff,0xff,0x32,0xd8,0x01,0x02,0x03,0x00]

ds_write_b32 v1, v2 offset:65535
// CHECK: [0xff,0xff,0x34,0xd8,0x01,0x02,0x00,0x00]

ds_write_b32 v255, v2 offset:65535
// CHECK: [0xff,0xff,0x34,0xd8,0xff,0x02,0x00,0x00]

ds_write_b32 v1, v255 offset:65535
// CHECK: [0xff,0xff,0x34,0xd8,0x01,0xff,0x00,0x00]

ds_write_b32 v1, v2
// CHECK: [0x00,0x00,0x34,0xd8,0x01,0x02,0x00,0x00]

ds_write_b32 v1, v2 offset:0
// CHECK: [0x00,0x00,0x34,0xd8,0x01,0x02,0x00,0x00]

ds_write_b32 v1, v2 offset:4
// CHECK: [0x04,0x00,0x34,0xd8,0x01,0x02,0x00,0x00]

ds_write_b32 v1, v2 offset:65535 gds
// CHECK: [0xff,0xff,0x36,0xd8,0x01,0x02,0x00,0x00]

ds_write2_b32 v1, v2, v3 offset0:127 offset1:255
// CHECK: [0x7f,0xff,0x38,0xd8,0x01,0x02,0x03,0x00]

ds_write2_b32 v255, v2, v3 offset0:127 offset1:255
// CHECK: [0x7f,0xff,0x38,0xd8,0xff,0x02,0x03,0x00]

ds_write2_b32 v1, v255, v3 offset0:127 offset1:255
// CHECK: [0x7f,0xff,0x38,0xd8,0x01,0xff,0x03,0x00]

ds_write2_b32 v1, v2, v255 offset0:127 offset1:255
// CHECK: [0x7f,0xff,0x38,0xd8,0x01,0x02,0xff,0x00]

ds_write2_b32 v1, v2, v3 offset1:255
// CHECK: [0x00,0xff,0x38,0xd8,0x01,0x02,0x03,0x00]

ds_write2_b32 v1, v2, v3 offset0:0 offset1:255
// CHECK: [0x00,0xff,0x38,0xd8,0x01,0x02,0x03,0x00]

ds_write2_b32 v1, v2, v3 offset0:16 offset1:255
// CHECK: [0x10,0xff,0x38,0xd8,0x01,0x02,0x03,0x00]

ds_write2_b32 v1, v2, v3 offset0:127
// CHECK: [0x7f,0x00,0x38,0xd8,0x01,0x02,0x03,0x00]

ds_write2_b32 v1, v2, v3 offset0:127 offset1:0
// CHECK: [0x7f,0x00,0x38,0xd8,0x01,0x02,0x03,0x00]

ds_write2_b32 v1, v2, v3 offset0:127 offset1:1
// CHECK: [0x7f,0x01,0x38,0xd8,0x01,0x02,0x03,0x00]

ds_write2_b32 v1, v2, v3 offset0:127 offset1:255 gds
// CHECK: [0x7f,0xff,0x3a,0xd8,0x01,0x02,0x03,0x00]

ds_write2st64_b32 v1, v2, v3 offset0:127 offset1:255
// CHECK: [0x7f,0xff,0x3c,0xd8,0x01,0x02,0x03,0x00]

ds_write2st64_b32 v255, v2, v3 offset0:127 offset1:255
// CHECK: [0x7f,0xff,0x3c,0xd8,0xff,0x02,0x03,0x00]

ds_write2st64_b32 v1, v255, v3 offset0:127 offset1:255
// CHECK: [0x7f,0xff,0x3c,0xd8,0x01,0xff,0x03,0x00]

ds_write2st64_b32 v1, v2, v255 offset0:127 offset1:255
// CHECK: [0x7f,0xff,0x3c,0xd8,0x01,0x02,0xff,0x00]

ds_write2st64_b32 v1, v2, v3 offset1:255
// CHECK: [0x00,0xff,0x3c,0xd8,0x01,0x02,0x03,0x00]

ds_write2st64_b32 v1, v2, v3 offset0:0 offset1:255
// CHECK: [0x00,0xff,0x3c,0xd8,0x01,0x02,0x03,0x00]

ds_write2st64_b32 v1, v2, v3 offset0:16 offset1:255
// CHECK: [0x10,0xff,0x3c,0xd8,0x01,0x02,0x03,0x00]

ds_write2st64_b32 v1, v2, v3 offset0:127
// CHECK: [0x7f,0x00,0x3c,0xd8,0x01,0x02,0x03,0x00]

ds_write2st64_b32 v1, v2, v3 offset0:127 offset1:0
// CHECK: [0x7f,0x00,0x3c,0xd8,0x01,0x02,0x03,0x00]

ds_write2st64_b32 v1, v2, v3 offset0:127 offset1:1
// CHECK: [0x7f,0x01,0x3c,0xd8,0x01,0x02,0x03,0x00]

ds_write2st64_b32 v1, v2, v3 offset0:127 offset1:255 gds
// CHECK: [0x7f,0xff,0x3e,0xd8,0x01,0x02,0x03,0x00]

ds_cmpst_b32 v1, v2, v3 offset:65535
// CHECK: [0xff,0xff,0x40,0xd8,0x01,0x02,0x03,0x00]

ds_cmpst_b32 v255, v2, v3 offset:65535
// CHECK: [0xff,0xff,0x40,0xd8,0xff,0x02,0x03,0x00]

ds_cmpst_b32 v1, v255, v3 offset:65535
// CHECK: [0xff,0xff,0x40,0xd8,0x01,0xff,0x03,0x00]

ds_cmpst_b32 v1, v2, v255 offset:65535
// CHECK: [0xff,0xff,0x40,0xd8,0x01,0x02,0xff,0x00]

ds_cmpst_b32 v1, v2, v3
// CHECK: [0x00,0x00,0x40,0xd8,0x01,0x02,0x03,0x00]

ds_cmpst_b32 v1, v2, v3 offset:0
// CHECK: [0x00,0x00,0x40,0xd8,0x01,0x02,0x03,0x00]

ds_cmpst_b32 v1, v2, v3 offset:4
// CHECK: [0x04,0x00,0x40,0xd8,0x01,0x02,0x03,0x00]

ds_cmpst_b32 v1, v2, v3 offset:65535 gds
// CHECK: [0xff,0xff,0x42,0xd8,0x01,0x02,0x03,0x00]

ds_cmpst_f32 v1, v2, v3 offset:65535
// CHECK: [0xff,0xff,0x44,0xd8,0x01,0x02,0x03,0x00]

ds_cmpst_f32 v255, v2, v3 offset:65535
// CHECK: [0xff,0xff,0x44,0xd8,0xff,0x02,0x03,0x00]

ds_cmpst_f32 v1, v255, v3 offset:65535
// CHECK: [0xff,0xff,0x44,0xd8,0x01,0xff,0x03,0x00]

ds_cmpst_f32 v1, v2, v255 offset:65535
// CHECK: [0xff,0xff,0x44,0xd8,0x01,0x02,0xff,0x00]

ds_cmpst_f32 v1, v2, v3
// CHECK: [0x00,0x00,0x44,0xd8,0x01,0x02,0x03,0x00]

ds_cmpst_f32 v1, v2, v3 offset:0
// CHECK: [0x00,0x00,0x44,0xd8,0x01,0x02,0x03,0x00]

ds_cmpst_f32 v1, v2, v3 offset:4
// CHECK: [0x04,0x00,0x44,0xd8,0x01,0x02,0x03,0x00]

ds_cmpst_f32 v1, v2, v3 offset:65535 gds
// CHECK: [0xff,0xff,0x46,0xd8,0x01,0x02,0x03,0x00]

ds_min_f32 v1, v2 offset:65535
// CHECK: [0xff,0xff,0x48,0xd8,0x01,0x02,0x00,0x00]

ds_min_f32 v255, v2 offset:65535
// CHECK: [0xff,0xff,0x48,0xd8,0xff,0x02,0x00,0x00]

ds_min_f32 v1, v255 offset:65535
// CHECK: [0xff,0xff,0x48,0xd8,0x01,0xff,0x00,0x00]

ds_min_f32 v1, v2
// CHECK: [0x00,0x00,0x48,0xd8,0x01,0x02,0x00,0x00]

ds_min_f32 v1, v2 offset:0
// CHECK: [0x00,0x00,0x48,0xd8,0x01,0x02,0x00,0x00]

ds_min_f32 v1, v2 offset:4
// CHECK: [0x04,0x00,0x48,0xd8,0x01,0x02,0x00,0x00]

ds_min_f32 v1, v2 offset:65535 gds
// CHECK: [0xff,0xff,0x4a,0xd8,0x01,0x02,0x00,0x00]

ds_max_f32 v1, v2 offset:65535
// CHECK: [0xff,0xff,0x4c,0xd8,0x01,0x02,0x00,0x00]

ds_max_f32 v255, v2 offset:65535
// CHECK: [0xff,0xff,0x4c,0xd8,0xff,0x02,0x00,0x00]

ds_max_f32 v1, v255 offset:65535
// CHECK: [0xff,0xff,0x4c,0xd8,0x01,0xff,0x00,0x00]

ds_max_f32 v1, v2
// CHECK: [0x00,0x00,0x4c,0xd8,0x01,0x02,0x00,0x00]

ds_max_f32 v1, v2 offset:0
// CHECK: [0x00,0x00,0x4c,0xd8,0x01,0x02,0x00,0x00]

ds_max_f32 v1, v2 offset:4
// CHECK: [0x04,0x00,0x4c,0xd8,0x01,0x02,0x00,0x00]

ds_max_f32 v1, v2 offset:65535 gds
// CHECK: [0xff,0xff,0x4e,0xd8,0x01,0x02,0x00,0x00]

ds_nop
// CHECK: [0x00,0x00,0x50,0xd8,0x00,0x00,0x00,0x00]

ds_gws_sema_release_all offset:65535 gds
// CHECK: [0xff,0xff,0x62,0xd8,0x00,0x00,0x00,0x00]

ds_gws_sema_release_all gds
// CHECK: [0x00,0x00,0x62,0xd8,0x00,0x00,0x00,0x00]

ds_gws_sema_release_all offset:0 gds
// CHECK: [0x00,0x00,0x62,0xd8,0x00,0x00,0x00,0x00]

ds_gws_sema_release_all offset:4 gds
// CHECK: [0x04,0x00,0x62,0xd8,0x00,0x00,0x00,0x00]

ds_gws_init v1 offset:65535 gds
// CHECK: [0xff,0xff,0x66,0xd8,0x01,0x00,0x00,0x00]

ds_gws_init v255 offset:65535 gds
// CHECK: [0xff,0xff,0x66,0xd8,0xff,0x00,0x00,0x00]

ds_gws_init v1 gds
// CHECK: [0x00,0x00,0x66,0xd8,0x01,0x00,0x00,0x00]

ds_gws_init v1 offset:0 gds
// CHECK: [0x00,0x00,0x66,0xd8,0x01,0x00,0x00,0x00]

ds_gws_init v1 offset:4 gds
// CHECK: [0x04,0x00,0x66,0xd8,0x01,0x00,0x00,0x00]

ds_gws_sema_v offset:65535 gds
// CHECK: [0xff,0xff,0x6a,0xd8,0x00,0x00,0x00,0x00]

ds_gws_sema_v gds
// CHECK: [0x00,0x00,0x6a,0xd8,0x00,0x00,0x00,0x00]

ds_gws_sema_v offset:0 gds
// CHECK: [0x00,0x00,0x6a,0xd8,0x00,0x00,0x00,0x00]

ds_gws_sema_v offset:4 gds
// CHECK: [0x04,0x00,0x6a,0xd8,0x00,0x00,0x00,0x00]

ds_gws_sema_br v1 offset:65535 gds
// CHECK: [0xff,0xff,0x6e,0xd8,0x01,0x00,0x00,0x00]

ds_gws_sema_br v255 offset:65535 gds
// CHECK: [0xff,0xff,0x6e,0xd8,0xff,0x00,0x00,0x00]

ds_gws_sema_br v1 gds
// CHECK: [0x00,0x00,0x6e,0xd8,0x01,0x00,0x00,0x00]

ds_gws_sema_br v1 offset:0 gds
// CHECK: [0x00,0x00,0x6e,0xd8,0x01,0x00,0x00,0x00]

ds_gws_sema_br v1 offset:4 gds
// CHECK: [0x04,0x00,0x6e,0xd8,0x01,0x00,0x00,0x00]

ds_gws_sema_p offset:65535 gds
// CHECK: [0xff,0xff,0x72,0xd8,0x00,0x00,0x00,0x00]

ds_gws_sema_p gds
// CHECK: [0x00,0x00,0x72,0xd8,0x00,0x00,0x00,0x00]

ds_gws_sema_p offset:0 gds
// CHECK: [0x00,0x00,0x72,0xd8,0x00,0x00,0x00,0x00]

ds_gws_sema_p offset:4 gds
// CHECK: [0x04,0x00,0x72,0xd8,0x00,0x00,0x00,0x00]

ds_gws_barrier v1 offset:65535 gds
// CHECK: [0xff,0xff,0x76,0xd8,0x01,0x00,0x00,0x00]

ds_gws_barrier v255 offset:65535 gds
// CHECK: [0xff,0xff,0x76,0xd8,0xff,0x00,0x00,0x00]

ds_gws_barrier v1 gds
// CHECK: [0x00,0x00,0x76,0xd8,0x01,0x00,0x00,0x00]

ds_gws_barrier v1 offset:0 gds
// CHECK: [0x00,0x00,0x76,0xd8,0x01,0x00,0x00,0x00]

ds_gws_barrier v1 offset:4 gds
// CHECK: [0x04,0x00,0x76,0xd8,0x01,0x00,0x00,0x00]

ds_write_b8 v1, v2 offset:65535
// CHECK: [0xff,0xff,0x78,0xd8,0x01,0x02,0x00,0x00]

ds_write_b8 v255, v2 offset:65535
// CHECK: [0xff,0xff,0x78,0xd8,0xff,0x02,0x00,0x00]

ds_write_b8 v1, v255 offset:65535
// CHECK: [0xff,0xff,0x78,0xd8,0x01,0xff,0x00,0x00]

ds_write_b8 v1, v2
// CHECK: [0x00,0x00,0x78,0xd8,0x01,0x02,0x00,0x00]

ds_write_b8 v1, v2 offset:0
// CHECK: [0x00,0x00,0x78,0xd8,0x01,0x02,0x00,0x00]

ds_write_b8 v1, v2 offset:4
// CHECK: [0x04,0x00,0x78,0xd8,0x01,0x02,0x00,0x00]

ds_write_b8 v1, v2 offset:65535 gds
// CHECK: [0xff,0xff,0x7a,0xd8,0x01,0x02,0x00,0x00]

ds_write_b16 v1, v2 offset:65535
// CHECK: [0xff,0xff,0x7c,0xd8,0x01,0x02,0x00,0x00]

ds_write_b16 v255, v2 offset:65535
// CHECK: [0xff,0xff,0x7c,0xd8,0xff,0x02,0x00,0x00]

ds_write_b16 v1, v255 offset:65535
// CHECK: [0xff,0xff,0x7c,0xd8,0x01,0xff,0x00,0x00]

ds_write_b16 v1, v2
// CHECK: [0x00,0x00,0x7c,0xd8,0x01,0x02,0x00,0x00]

ds_write_b16 v1, v2 offset:0
// CHECK: [0x00,0x00,0x7c,0xd8,0x01,0x02,0x00,0x00]

ds_write_b16 v1, v2 offset:4
// CHECK: [0x04,0x00,0x7c,0xd8,0x01,0x02,0x00,0x00]

ds_write_b16 v1, v2 offset:65535 gds
// CHECK: [0xff,0xff,0x7e,0xd8,0x01,0x02,0x00,0x00]

ds_add_rtn_u32 v5, v1, v2 offset:65535
// CHECK: [0xff,0xff,0x80,0xd8,0x01,0x02,0x00,0x05]

ds_add_rtn_u32 v255, v1, v2 offset:65535
// CHECK: [0xff,0xff,0x80,0xd8,0x01,0x02,0x00,0xff]

ds_add_rtn_u32 v5, v255, v2 offset:65535
// CHECK: [0xff,0xff,0x80,0xd8,0xff,0x02,0x00,0x05]

ds_add_rtn_u32 v5, v1, v255 offset:65535
// CHECK: [0xff,0xff,0x80,0xd8,0x01,0xff,0x00,0x05]

ds_add_rtn_u32 v5, v1, v2
// CHECK: [0x00,0x00,0x80,0xd8,0x01,0x02,0x00,0x05]

ds_add_rtn_u32 v5, v1, v2 offset:0
// CHECK: [0x00,0x00,0x80,0xd8,0x01,0x02,0x00,0x05]

ds_add_rtn_u32 v5, v1, v2 offset:4
// CHECK: [0x04,0x00,0x80,0xd8,0x01,0x02,0x00,0x05]

ds_add_rtn_u32 v5, v1, v2 offset:65535 gds
// CHECK: [0xff,0xff,0x82,0xd8,0x01,0x02,0x00,0x05]

ds_sub_rtn_u32 v5, v1, v2 offset:65535
// CHECK: [0xff,0xff,0x84,0xd8,0x01,0x02,0x00,0x05]

ds_sub_rtn_u32 v255, v1, v2 offset:65535
// CHECK: [0xff,0xff,0x84,0xd8,0x01,0x02,0x00,0xff]

ds_sub_rtn_u32 v5, v255, v2 offset:65535
// CHECK: [0xff,0xff,0x84,0xd8,0xff,0x02,0x00,0x05]

ds_sub_rtn_u32 v5, v1, v255 offset:65535
// CHECK: [0xff,0xff,0x84,0xd8,0x01,0xff,0x00,0x05]

ds_sub_rtn_u32 v5, v1, v2
// CHECK: [0x00,0x00,0x84,0xd8,0x01,0x02,0x00,0x05]

ds_sub_rtn_u32 v5, v1, v2 offset:0
// CHECK: [0x00,0x00,0x84,0xd8,0x01,0x02,0x00,0x05]

ds_sub_rtn_u32 v5, v1, v2 offset:4
// CHECK: [0x04,0x00,0x84,0xd8,0x01,0x02,0x00,0x05]

ds_sub_rtn_u32 v5, v1, v2 offset:65535 gds
// CHECK: [0xff,0xff,0x86,0xd8,0x01,0x02,0x00,0x05]

ds_rsub_rtn_u32 v5, v1, v2 offset:65535
// CHECK: [0xff,0xff,0x88,0xd8,0x01,0x02,0x00,0x05]

ds_rsub_rtn_u32 v255, v1, v2 offset:65535
// CHECK: [0xff,0xff,0x88,0xd8,0x01,0x02,0x00,0xff]

ds_rsub_rtn_u32 v5, v255, v2 offset:65535
// CHECK: [0xff,0xff,0x88,0xd8,0xff,0x02,0x00,0x05]

ds_rsub_rtn_u32 v5, v1, v255 offset:65535
// CHECK: [0xff,0xff,0x88,0xd8,0x01,0xff,0x00,0x05]

ds_rsub_rtn_u32 v5, v1, v2
// CHECK: [0x00,0x00,0x88,0xd8,0x01,0x02,0x00,0x05]

ds_rsub_rtn_u32 v5, v1, v2 offset:0
// CHECK: [0x00,0x00,0x88,0xd8,0x01,0x02,0x00,0x05]

ds_rsub_rtn_u32 v5, v1, v2 offset:4
// CHECK: [0x04,0x00,0x88,0xd8,0x01,0x02,0x00,0x05]

ds_rsub_rtn_u32 v5, v1, v2 offset:65535 gds
// CHECK: [0xff,0xff,0x8a,0xd8,0x01,0x02,0x00,0x05]

ds_inc_rtn_u32 v5, v1, v2 offset:65535
// CHECK: [0xff,0xff,0x8c,0xd8,0x01,0x02,0x00,0x05]

ds_inc_rtn_u32 v255, v1, v2 offset:65535
// CHECK: [0xff,0xff,0x8c,0xd8,0x01,0x02,0x00,0xff]

ds_inc_rtn_u32 v5, v255, v2 offset:65535
// CHECK: [0xff,0xff,0x8c,0xd8,0xff,0x02,0x00,0x05]

ds_inc_rtn_u32 v5, v1, v255 offset:65535
// CHECK: [0xff,0xff,0x8c,0xd8,0x01,0xff,0x00,0x05]

ds_inc_rtn_u32 v5, v1, v2
// CHECK: [0x00,0x00,0x8c,0xd8,0x01,0x02,0x00,0x05]

ds_inc_rtn_u32 v5, v1, v2 offset:0
// CHECK: [0x00,0x00,0x8c,0xd8,0x01,0x02,0x00,0x05]

ds_inc_rtn_u32 v5, v1, v2 offset:4
// CHECK: [0x04,0x00,0x8c,0xd8,0x01,0x02,0x00,0x05]

ds_inc_rtn_u32 v5, v1, v2 offset:65535 gds
// CHECK: [0xff,0xff,0x8e,0xd8,0x01,0x02,0x00,0x05]

ds_dec_rtn_u32 v5, v1, v2 offset:65535
// CHECK: [0xff,0xff,0x90,0xd8,0x01,0x02,0x00,0x05]

ds_dec_rtn_u32 v255, v1, v2 offset:65535
// CHECK: [0xff,0xff,0x90,0xd8,0x01,0x02,0x00,0xff]

ds_dec_rtn_u32 v5, v255, v2 offset:65535
// CHECK: [0xff,0xff,0x90,0xd8,0xff,0x02,0x00,0x05]

ds_dec_rtn_u32 v5, v1, v255 offset:65535
// CHECK: [0xff,0xff,0x90,0xd8,0x01,0xff,0x00,0x05]

ds_dec_rtn_u32 v5, v1, v2
// CHECK: [0x00,0x00,0x90,0xd8,0x01,0x02,0x00,0x05]

ds_dec_rtn_u32 v5, v1, v2 offset:0
// CHECK: [0x00,0x00,0x90,0xd8,0x01,0x02,0x00,0x05]

ds_dec_rtn_u32 v5, v1, v2 offset:4
// CHECK: [0x04,0x00,0x90,0xd8,0x01,0x02,0x00,0x05]

ds_dec_rtn_u32 v5, v1, v2 offset:65535 gds
// CHECK: [0xff,0xff,0x92,0xd8,0x01,0x02,0x00,0x05]

ds_min_rtn_i32 v5, v1, v2 offset:65535
// CHECK: [0xff,0xff,0x94,0xd8,0x01,0x02,0x00,0x05]

ds_min_rtn_i32 v255, v1, v2 offset:65535
// CHECK: [0xff,0xff,0x94,0xd8,0x01,0x02,0x00,0xff]

ds_min_rtn_i32 v5, v255, v2 offset:65535
// CHECK: [0xff,0xff,0x94,0xd8,0xff,0x02,0x00,0x05]

ds_min_rtn_i32 v5, v1, v255 offset:65535
// CHECK: [0xff,0xff,0x94,0xd8,0x01,0xff,0x00,0x05]

ds_min_rtn_i32 v5, v1, v2
// CHECK: [0x00,0x00,0x94,0xd8,0x01,0x02,0x00,0x05]

ds_min_rtn_i32 v5, v1, v2 offset:0
// CHECK: [0x00,0x00,0x94,0xd8,0x01,0x02,0x00,0x05]

ds_min_rtn_i32 v5, v1, v2 offset:4
// CHECK: [0x04,0x00,0x94,0xd8,0x01,0x02,0x00,0x05]

ds_min_rtn_i32 v5, v1, v2 offset:65535 gds
// CHECK: [0xff,0xff,0x96,0xd8,0x01,0x02,0x00,0x05]

ds_max_rtn_i32 v5, v1, v2 offset:65535
// CHECK: [0xff,0xff,0x98,0xd8,0x01,0x02,0x00,0x05]

ds_max_rtn_i32 v255, v1, v2 offset:65535
// CHECK: [0xff,0xff,0x98,0xd8,0x01,0x02,0x00,0xff]

ds_max_rtn_i32 v5, v255, v2 offset:65535
// CHECK: [0xff,0xff,0x98,0xd8,0xff,0x02,0x00,0x05]

ds_max_rtn_i32 v5, v1, v255 offset:65535
// CHECK: [0xff,0xff,0x98,0xd8,0x01,0xff,0x00,0x05]

ds_max_rtn_i32 v5, v1, v2
// CHECK: [0x00,0x00,0x98,0xd8,0x01,0x02,0x00,0x05]

ds_max_rtn_i32 v5, v1, v2 offset:0
// CHECK: [0x00,0x00,0x98,0xd8,0x01,0x02,0x00,0x05]

ds_max_rtn_i32 v5, v1, v2 offset:4
// CHECK: [0x04,0x00,0x98,0xd8,0x01,0x02,0x00,0x05]

ds_max_rtn_i32 v5, v1, v2 offset:65535 gds
// CHECK: [0xff,0xff,0x9a,0xd8,0x01,0x02,0x00,0x05]

ds_min_rtn_u32 v5, v1, v2 offset:65535
// CHECK: [0xff,0xff,0x9c,0xd8,0x01,0x02,0x00,0x05]

ds_min_rtn_u32 v255, v1, v2 offset:65535
// CHECK: [0xff,0xff,0x9c,0xd8,0x01,0x02,0x00,0xff]

ds_min_rtn_u32 v5, v255, v2 offset:65535
// CHECK: [0xff,0xff,0x9c,0xd8,0xff,0x02,0x00,0x05]

ds_min_rtn_u32 v5, v1, v255 offset:65535
// CHECK: [0xff,0xff,0x9c,0xd8,0x01,0xff,0x00,0x05]

ds_min_rtn_u32 v5, v1, v2
// CHECK: [0x00,0x00,0x9c,0xd8,0x01,0x02,0x00,0x05]

ds_min_rtn_u32 v5, v1, v2 offset:0
// CHECK: [0x00,0x00,0x9c,0xd8,0x01,0x02,0x00,0x05]

ds_min_rtn_u32 v5, v1, v2 offset:4
// CHECK: [0x04,0x00,0x9c,0xd8,0x01,0x02,0x00,0x05]

ds_min_rtn_u32 v5, v1, v2 offset:65535 gds
// CHECK: [0xff,0xff,0x9e,0xd8,0x01,0x02,0x00,0x05]

ds_max_rtn_u32 v5, v1, v2 offset:65535
// CHECK: [0xff,0xff,0xa0,0xd8,0x01,0x02,0x00,0x05]

ds_max_rtn_u32 v255, v1, v2 offset:65535
// CHECK: [0xff,0xff,0xa0,0xd8,0x01,0x02,0x00,0xff]

ds_max_rtn_u32 v5, v255, v2 offset:65535
// CHECK: [0xff,0xff,0xa0,0xd8,0xff,0x02,0x00,0x05]

ds_max_rtn_u32 v5, v1, v255 offset:65535
// CHECK: [0xff,0xff,0xa0,0xd8,0x01,0xff,0x00,0x05]

ds_max_rtn_u32 v5, v1, v2
// CHECK: [0x00,0x00,0xa0,0xd8,0x01,0x02,0x00,0x05]

ds_max_rtn_u32 v5, v1, v2 offset:0
// CHECK: [0x00,0x00,0xa0,0xd8,0x01,0x02,0x00,0x05]

ds_max_rtn_u32 v5, v1, v2 offset:4
// CHECK: [0x04,0x00,0xa0,0xd8,0x01,0x02,0x00,0x05]

ds_max_rtn_u32 v5, v1, v2 offset:65535 gds
// CHECK: [0xff,0xff,0xa2,0xd8,0x01,0x02,0x00,0x05]

ds_and_rtn_b32 v5, v1, v2 offset:65535
// CHECK: [0xff,0xff,0xa4,0xd8,0x01,0x02,0x00,0x05]

ds_and_rtn_b32 v255, v1, v2 offset:65535
// CHECK: [0xff,0xff,0xa4,0xd8,0x01,0x02,0x00,0xff]

ds_and_rtn_b32 v5, v255, v2 offset:65535
// CHECK: [0xff,0xff,0xa4,0xd8,0xff,0x02,0x00,0x05]

ds_and_rtn_b32 v5, v1, v255 offset:65535
// CHECK: [0xff,0xff,0xa4,0xd8,0x01,0xff,0x00,0x05]

ds_and_rtn_b32 v5, v1, v2
// CHECK: [0x00,0x00,0xa4,0xd8,0x01,0x02,0x00,0x05]

ds_and_rtn_b32 v5, v1, v2 offset:0
// CHECK: [0x00,0x00,0xa4,0xd8,0x01,0x02,0x00,0x05]

ds_and_rtn_b32 v5, v1, v2 offset:4
// CHECK: [0x04,0x00,0xa4,0xd8,0x01,0x02,0x00,0x05]

ds_and_rtn_b32 v5, v1, v2 offset:65535 gds
// CHECK: [0xff,0xff,0xa6,0xd8,0x01,0x02,0x00,0x05]

ds_or_rtn_b32 v5, v1, v2 offset:65535
// CHECK: [0xff,0xff,0xa8,0xd8,0x01,0x02,0x00,0x05]

ds_or_rtn_b32 v255, v1, v2 offset:65535
// CHECK: [0xff,0xff,0xa8,0xd8,0x01,0x02,0x00,0xff]

ds_or_rtn_b32 v5, v255, v2 offset:65535
// CHECK: [0xff,0xff,0xa8,0xd8,0xff,0x02,0x00,0x05]

ds_or_rtn_b32 v5, v1, v255 offset:65535
// CHECK: [0xff,0xff,0xa8,0xd8,0x01,0xff,0x00,0x05]

ds_or_rtn_b32 v5, v1, v2
// CHECK: [0x00,0x00,0xa8,0xd8,0x01,0x02,0x00,0x05]

ds_or_rtn_b32 v5, v1, v2 offset:0
// CHECK: [0x00,0x00,0xa8,0xd8,0x01,0x02,0x00,0x05]

ds_or_rtn_b32 v5, v1, v2 offset:4
// CHECK: [0x04,0x00,0xa8,0xd8,0x01,0x02,0x00,0x05]

ds_or_rtn_b32 v5, v1, v2 offset:65535 gds
// CHECK: [0xff,0xff,0xaa,0xd8,0x01,0x02,0x00,0x05]

ds_xor_rtn_b32 v5, v1, v2 offset:65535
// CHECK: [0xff,0xff,0xac,0xd8,0x01,0x02,0x00,0x05]

ds_xor_rtn_b32 v255, v1, v2 offset:65535
// CHECK: [0xff,0xff,0xac,0xd8,0x01,0x02,0x00,0xff]

ds_xor_rtn_b32 v5, v255, v2 offset:65535
// CHECK: [0xff,0xff,0xac,0xd8,0xff,0x02,0x00,0x05]

ds_xor_rtn_b32 v5, v1, v255 offset:65535
// CHECK: [0xff,0xff,0xac,0xd8,0x01,0xff,0x00,0x05]

ds_xor_rtn_b32 v5, v1, v2
// CHECK: [0x00,0x00,0xac,0xd8,0x01,0x02,0x00,0x05]

ds_xor_rtn_b32 v5, v1, v2 offset:0
// CHECK: [0x00,0x00,0xac,0xd8,0x01,0x02,0x00,0x05]

ds_xor_rtn_b32 v5, v1, v2 offset:4
// CHECK: [0x04,0x00,0xac,0xd8,0x01,0x02,0x00,0x05]

ds_xor_rtn_b32 v5, v1, v2 offset:65535 gds
// CHECK: [0xff,0xff,0xae,0xd8,0x01,0x02,0x00,0x05]

ds_mskor_rtn_b32 v5, v1, v2, v3 offset:65535
// CHECK: [0xff,0xff,0xb0,0xd8,0x01,0x02,0x03,0x05]

ds_mskor_rtn_b32 v255, v1, v2, v3 offset:65535
// CHECK: [0xff,0xff,0xb0,0xd8,0x01,0x02,0x03,0xff]

ds_mskor_rtn_b32 v5, v255, v2, v3 offset:65535
// CHECK: [0xff,0xff,0xb0,0xd8,0xff,0x02,0x03,0x05]

ds_mskor_rtn_b32 v5, v1, v255, v3 offset:65535
// CHECK: [0xff,0xff,0xb0,0xd8,0x01,0xff,0x03,0x05]

ds_mskor_rtn_b32 v5, v1, v2, v255 offset:65535
// CHECK: [0xff,0xff,0xb0,0xd8,0x01,0x02,0xff,0x05]

ds_mskor_rtn_b32 v5, v1, v2, v3
// CHECK: [0x00,0x00,0xb0,0xd8,0x01,0x02,0x03,0x05]

ds_mskor_rtn_b32 v5, v1, v2, v3 offset:0
// CHECK: [0x00,0x00,0xb0,0xd8,0x01,0x02,0x03,0x05]

ds_mskor_rtn_b32 v5, v1, v2, v3 offset:4
// CHECK: [0x04,0x00,0xb0,0xd8,0x01,0x02,0x03,0x05]

ds_mskor_rtn_b32 v5, v1, v2, v3 offset:65535 gds
// CHECK: [0xff,0xff,0xb2,0xd8,0x01,0x02,0x03,0x05]

ds_wrxchg_rtn_b32 v5, v1, v2 offset:65535
// CHECK: [0xff,0xff,0xb4,0xd8,0x01,0x02,0x00,0x05]

ds_wrxchg_rtn_b32 v255, v1, v2 offset:65535
// CHECK: [0xff,0xff,0xb4,0xd8,0x01,0x02,0x00,0xff]

ds_wrxchg_rtn_b32 v5, v255, v2 offset:65535
// CHECK: [0xff,0xff,0xb4,0xd8,0xff,0x02,0x00,0x05]

ds_wrxchg_rtn_b32 v5, v1, v255 offset:65535
// CHECK: [0xff,0xff,0xb4,0xd8,0x01,0xff,0x00,0x05]

ds_wrxchg_rtn_b32 v5, v1, v2
// CHECK: [0x00,0x00,0xb4,0xd8,0x01,0x02,0x00,0x05]

ds_wrxchg_rtn_b32 v5, v1, v2 offset:0
// CHECK: [0x00,0x00,0xb4,0xd8,0x01,0x02,0x00,0x05]

ds_wrxchg_rtn_b32 v5, v1, v2 offset:4
// CHECK: [0x04,0x00,0xb4,0xd8,0x01,0x02,0x00,0x05]

ds_wrxchg_rtn_b32 v5, v1, v2 offset:65535 gds
// CHECK: [0xff,0xff,0xb6,0xd8,0x01,0x02,0x00,0x05]

ds_wrxchg2_rtn_b32 v[5:6], v1, v2, v3 offset0:127 offset1:255
// CHECK: [0x7f,0xff,0xb8,0xd8,0x01,0x02,0x03,0x05]

ds_wrxchg2_rtn_b32 v[254:255], v1, v2, v3 offset0:127 offset1:255
// CHECK: [0x7f,0xff,0xb8,0xd8,0x01,0x02,0x03,0xfe]

ds_wrxchg2_rtn_b32 v[5:6], v255, v2, v3 offset0:127 offset1:255
// CHECK: [0x7f,0xff,0xb8,0xd8,0xff,0x02,0x03,0x05]

ds_wrxchg2_rtn_b32 v[5:6], v1, v255, v3 offset0:127 offset1:255
// CHECK: [0x7f,0xff,0xb8,0xd8,0x01,0xff,0x03,0x05]

ds_wrxchg2_rtn_b32 v[5:6], v1, v2, v255 offset0:127 offset1:255
// CHECK: [0x7f,0xff,0xb8,0xd8,0x01,0x02,0xff,0x05]

ds_wrxchg2_rtn_b32 v[5:6], v1, v2, v3 offset1:255
// CHECK: [0x00,0xff,0xb8,0xd8,0x01,0x02,0x03,0x05]

ds_wrxchg2_rtn_b32 v[5:6], v1, v2, v3 offset0:0 offset1:255
// CHECK: [0x00,0xff,0xb8,0xd8,0x01,0x02,0x03,0x05]

ds_wrxchg2_rtn_b32 v[5:6], v1, v2, v3 offset0:16 offset1:255
// CHECK: [0x10,0xff,0xb8,0xd8,0x01,0x02,0x03,0x05]

ds_wrxchg2_rtn_b32 v[5:6], v1, v2, v3 offset0:127
// CHECK: [0x7f,0x00,0xb8,0xd8,0x01,0x02,0x03,0x05]

ds_wrxchg2_rtn_b32 v[5:6], v1, v2, v3 offset0:127 offset1:0
// CHECK: [0x7f,0x00,0xb8,0xd8,0x01,0x02,0x03,0x05]

ds_wrxchg2_rtn_b32 v[5:6], v1, v2, v3 offset0:127 offset1:1
// CHECK: [0x7f,0x01,0xb8,0xd8,0x01,0x02,0x03,0x05]

ds_wrxchg2_rtn_b32 v[5:6], v1, v2, v3 offset0:127 offset1:255 gds
// CHECK: [0x7f,0xff,0xba,0xd8,0x01,0x02,0x03,0x05]

ds_wrxchg2st64_rtn_b32 v[5:6], v1, v2, v3 offset0:127 offset1:255
// CHECK: [0x7f,0xff,0xbc,0xd8,0x01,0x02,0x03,0x05]

ds_wrxchg2st64_rtn_b32 v[254:255], v1, v2, v3 offset0:127 offset1:255
// CHECK: [0x7f,0xff,0xbc,0xd8,0x01,0x02,0x03,0xfe]

ds_wrxchg2st64_rtn_b32 v[5:6], v255, v2, v3 offset0:127 offset1:255
// CHECK: [0x7f,0xff,0xbc,0xd8,0xff,0x02,0x03,0x05]

ds_wrxchg2st64_rtn_b32 v[5:6], v1, v255, v3 offset0:127 offset1:255
// CHECK: [0x7f,0xff,0xbc,0xd8,0x01,0xff,0x03,0x05]

ds_wrxchg2st64_rtn_b32 v[5:6], v1, v2, v255 offset0:127 offset1:255
// CHECK: [0x7f,0xff,0xbc,0xd8,0x01,0x02,0xff,0x05]

ds_wrxchg2st64_rtn_b32 v[5:6], v1, v2, v3 offset1:255
// CHECK: [0x00,0xff,0xbc,0xd8,0x01,0x02,0x03,0x05]

ds_wrxchg2st64_rtn_b32 v[5:6], v1, v2, v3 offset0:0 offset1:255
// CHECK: [0x00,0xff,0xbc,0xd8,0x01,0x02,0x03,0x05]

ds_wrxchg2st64_rtn_b32 v[5:6], v1, v2, v3 offset0:16 offset1:255
// CHECK: [0x10,0xff,0xbc,0xd8,0x01,0x02,0x03,0x05]

ds_wrxchg2st64_rtn_b32 v[5:6], v1, v2, v3 offset0:127
// CHECK: [0x7f,0x00,0xbc,0xd8,0x01,0x02,0x03,0x05]

ds_wrxchg2st64_rtn_b32 v[5:6], v1, v2, v3 offset0:127 offset1:0
// CHECK: [0x7f,0x00,0xbc,0xd8,0x01,0x02,0x03,0x05]

ds_wrxchg2st64_rtn_b32 v[5:6], v1, v2, v3 offset0:127 offset1:1
// CHECK: [0x7f,0x01,0xbc,0xd8,0x01,0x02,0x03,0x05]

ds_wrxchg2st64_rtn_b32 v[5:6], v1, v2, v3 offset0:127 offset1:255 gds
// CHECK: [0x7f,0xff,0xbe,0xd8,0x01,0x02,0x03,0x05]

ds_cmpst_rtn_b32 v5, v1, v2, v3 offset:65535
// CHECK: [0xff,0xff,0xc0,0xd8,0x01,0x02,0x03,0x05]

ds_cmpst_rtn_b32 v255, v1, v2, v3 offset:65535
// CHECK: [0xff,0xff,0xc0,0xd8,0x01,0x02,0x03,0xff]

ds_cmpst_rtn_b32 v5, v255, v2, v3 offset:65535
// CHECK: [0xff,0xff,0xc0,0xd8,0xff,0x02,0x03,0x05]

ds_cmpst_rtn_b32 v5, v1, v255, v3 offset:65535
// CHECK: [0xff,0xff,0xc0,0xd8,0x01,0xff,0x03,0x05]

ds_cmpst_rtn_b32 v5, v1, v2, v255 offset:65535
// CHECK: [0xff,0xff,0xc0,0xd8,0x01,0x02,0xff,0x05]

ds_cmpst_rtn_b32 v5, v1, v2, v3
// CHECK: [0x00,0x00,0xc0,0xd8,0x01,0x02,0x03,0x05]

ds_cmpst_rtn_b32 v5, v1, v2, v3 offset:0
// CHECK: [0x00,0x00,0xc0,0xd8,0x01,0x02,0x03,0x05]

ds_cmpst_rtn_b32 v5, v1, v2, v3 offset:4
// CHECK: [0x04,0x00,0xc0,0xd8,0x01,0x02,0x03,0x05]

ds_cmpst_rtn_b32 v5, v1, v2, v3 offset:65535 gds
// CHECK: [0xff,0xff,0xc2,0xd8,0x01,0x02,0x03,0x05]

ds_cmpst_rtn_f32 v5, v1, v2, v3 offset:65535
// CHECK: [0xff,0xff,0xc4,0xd8,0x01,0x02,0x03,0x05]

ds_cmpst_rtn_f32 v255, v1, v2, v3 offset:65535
// CHECK: [0xff,0xff,0xc4,0xd8,0x01,0x02,0x03,0xff]

ds_cmpst_rtn_f32 v5, v255, v2, v3 offset:65535
// CHECK: [0xff,0xff,0xc4,0xd8,0xff,0x02,0x03,0x05]

ds_cmpst_rtn_f32 v5, v1, v255, v3 offset:65535
// CHECK: [0xff,0xff,0xc4,0xd8,0x01,0xff,0x03,0x05]

ds_cmpst_rtn_f32 v5, v1, v2, v255 offset:65535
// CHECK: [0xff,0xff,0xc4,0xd8,0x01,0x02,0xff,0x05]

ds_cmpst_rtn_f32 v5, v1, v2, v3
// CHECK: [0x00,0x00,0xc4,0xd8,0x01,0x02,0x03,0x05]

ds_cmpst_rtn_f32 v5, v1, v2, v3 offset:0
// CHECK: [0x00,0x00,0xc4,0xd8,0x01,0x02,0x03,0x05]

ds_cmpst_rtn_f32 v5, v1, v2, v3 offset:4
// CHECK: [0x04,0x00,0xc4,0xd8,0x01,0x02,0x03,0x05]

ds_cmpst_rtn_f32 v5, v1, v2, v3 offset:65535 gds
// CHECK: [0xff,0xff,0xc6,0xd8,0x01,0x02,0x03,0x05]

ds_min_rtn_f32 v5, v1, v2 offset:65535
// CHECK: [0xff,0xff,0xc8,0xd8,0x01,0x02,0x00,0x05]

ds_min_rtn_f32 v255, v1, v2 offset:65535
// CHECK: [0xff,0xff,0xc8,0xd8,0x01,0x02,0x00,0xff]

ds_min_rtn_f32 v5, v255, v2 offset:65535
// CHECK: [0xff,0xff,0xc8,0xd8,0xff,0x02,0x00,0x05]

ds_min_rtn_f32 v5, v1, v255 offset:65535
// CHECK: [0xff,0xff,0xc8,0xd8,0x01,0xff,0x00,0x05]

ds_min_rtn_f32 v5, v1, v2
// CHECK: [0x00,0x00,0xc8,0xd8,0x01,0x02,0x00,0x05]

ds_min_rtn_f32 v5, v1, v2 offset:0
// CHECK: [0x00,0x00,0xc8,0xd8,0x01,0x02,0x00,0x05]

ds_min_rtn_f32 v5, v1, v2 offset:4
// CHECK: [0x04,0x00,0xc8,0xd8,0x01,0x02,0x00,0x05]

ds_min_rtn_f32 v5, v1, v2 offset:65535 gds
// CHECK: [0xff,0xff,0xca,0xd8,0x01,0x02,0x00,0x05]

ds_max_rtn_f32 v5, v1, v2 offset:65535
// CHECK: [0xff,0xff,0xcc,0xd8,0x01,0x02,0x00,0x05]

ds_max_rtn_f32 v255, v1, v2 offset:65535
// CHECK: [0xff,0xff,0xcc,0xd8,0x01,0x02,0x00,0xff]

ds_max_rtn_f32 v5, v255, v2 offset:65535
// CHECK: [0xff,0xff,0xcc,0xd8,0xff,0x02,0x00,0x05]

ds_max_rtn_f32 v5, v1, v255 offset:65535
// CHECK: [0xff,0xff,0xcc,0xd8,0x01,0xff,0x00,0x05]

ds_max_rtn_f32 v5, v1, v2
// CHECK: [0x00,0x00,0xcc,0xd8,0x01,0x02,0x00,0x05]

ds_max_rtn_f32 v5, v1, v2 offset:0
// CHECK: [0x00,0x00,0xcc,0xd8,0x01,0x02,0x00,0x05]

ds_max_rtn_f32 v5, v1, v2 offset:4
// CHECK: [0x04,0x00,0xcc,0xd8,0x01,0x02,0x00,0x05]

ds_max_rtn_f32 v5, v1, v2 offset:65535 gds
// CHECK: [0xff,0xff,0xce,0xd8,0x01,0x02,0x00,0x05]

ds_wrap_rtn_b32 v5, v1, v2, v3 offset:65535
// CHECK: [0xff,0xff,0xd0,0xd8,0x01,0x02,0x03,0x05]

ds_wrap_rtn_b32 v255, v1, v2, v3 offset:65535
// CHECK: [0xff,0xff,0xd0,0xd8,0x01,0x02,0x03,0xff]

ds_wrap_rtn_b32 v5, v255, v2, v3 offset:65535
// CHECK: [0xff,0xff,0xd0,0xd8,0xff,0x02,0x03,0x05]

ds_wrap_rtn_b32 v5, v1, v255, v3 offset:65535
// CHECK: [0xff,0xff,0xd0,0xd8,0x01,0xff,0x03,0x05]

ds_wrap_rtn_b32 v5, v1, v2, v255 offset:65535
// CHECK: [0xff,0xff,0xd0,0xd8,0x01,0x02,0xff,0x05]

ds_wrap_rtn_b32 v5, v1, v2, v3
// CHECK: [0x00,0x00,0xd0,0xd8,0x01,0x02,0x03,0x05]

ds_wrap_rtn_b32 v5, v1, v2, v3 offset:0
// CHECK: [0x00,0x00,0xd0,0xd8,0x01,0x02,0x03,0x05]

ds_wrap_rtn_b32 v5, v1, v2, v3 offset:4
// CHECK: [0x04,0x00,0xd0,0xd8,0x01,0x02,0x03,0x05]

ds_wrap_rtn_b32 v5, v1, v2, v3 offset:65535 gds
// CHECK: [0xff,0xff,0xd2,0xd8,0x01,0x02,0x03,0x05]

ds_swizzle_b32 v5, v1 offset:65535
// CHECK: [0xff,0xff,0xd4,0xd8,0x01,0x00,0x00,0x05]

ds_swizzle_b32 v255, v1 offset:65535
// CHECK: [0xff,0xff,0xd4,0xd8,0x01,0x00,0x00,0xff]

ds_swizzle_b32 v5, v255 offset:65535
// CHECK: [0xff,0xff,0xd4,0xd8,0xff,0x00,0x00,0x05]

ds_swizzle_b32 v5, v1
// CHECK: [0x00,0x00,0xd4,0xd8,0x01,0x00,0x00,0x05]

ds_swizzle_b32 v5, v1 offset:0
// CHECK: [0x00,0x00,0xd4,0xd8,0x01,0x00,0x00,0x05]

ds_swizzle_b32 v5, v1 offset:4
// CHECK: [0x04,0x00,0xd4,0xd8,0x01,0x00,0x00,0x05]

ds_swizzle_b32 v5, v1 offset:65535 gds
// CHECK: [0xff,0xff,0xd6,0xd8,0x01,0x00,0x00,0x05]

ds_read_b32 v5, v1 offset:65535
// CHECK: [0xff,0xff,0xd8,0xd8,0x01,0x00,0x00,0x05]

ds_read_b32 v255, v1 offset:65535
// CHECK: [0xff,0xff,0xd8,0xd8,0x01,0x00,0x00,0xff]

ds_read_b32 v5, v255 offset:65535
// CHECK: [0xff,0xff,0xd8,0xd8,0xff,0x00,0x00,0x05]

ds_read_b32 v5, v1
// CHECK: [0x00,0x00,0xd8,0xd8,0x01,0x00,0x00,0x05]

ds_read_b32 v5, v1 offset:0
// CHECK: [0x00,0x00,0xd8,0xd8,0x01,0x00,0x00,0x05]

ds_read_b32 v5, v1 offset:4
// CHECK: [0x04,0x00,0xd8,0xd8,0x01,0x00,0x00,0x05]

ds_read_b32 v5, v1 offset:65535 gds
// CHECK: [0xff,0xff,0xda,0xd8,0x01,0x00,0x00,0x05]

ds_read2_b32 v[5:6], v1 offset0:127 offset1:255
// CHECK: [0x7f,0xff,0xdc,0xd8,0x01,0x00,0x00,0x05]

ds_read2_b32 v[254:255], v1 offset0:127 offset1:255
// CHECK: [0x7f,0xff,0xdc,0xd8,0x01,0x00,0x00,0xfe]

ds_read2_b32 v[5:6], v255 offset0:127 offset1:255
// CHECK: [0x7f,0xff,0xdc,0xd8,0xff,0x00,0x00,0x05]

ds_read2_b32 v[5:6], v1 offset1:255
// CHECK: [0x00,0xff,0xdc,0xd8,0x01,0x00,0x00,0x05]

ds_read2_b32 v[5:6], v1 offset0:0 offset1:255
// CHECK: [0x00,0xff,0xdc,0xd8,0x01,0x00,0x00,0x05]

ds_read2_b32 v[5:6], v1 offset0:16 offset1:255
// CHECK: [0x10,0xff,0xdc,0xd8,0x01,0x00,0x00,0x05]

ds_read2_b32 v[5:6], v1 offset0:127
// CHECK: [0x7f,0x00,0xdc,0xd8,0x01,0x00,0x00,0x05]

ds_read2_b32 v[5:6], v1 offset0:127 offset1:0
// CHECK: [0x7f,0x00,0xdc,0xd8,0x01,0x00,0x00,0x05]

ds_read2_b32 v[5:6], v1 offset0:127 offset1:1
// CHECK: [0x7f,0x01,0xdc,0xd8,0x01,0x00,0x00,0x05]

ds_read2_b32 v[5:6], v1 offset0:127 offset1:255 gds
// CHECK: [0x7f,0xff,0xde,0xd8,0x01,0x00,0x00,0x05]

ds_read2st64_b32 v[5:6], v1 offset0:127 offset1:255
// CHECK: [0x7f,0xff,0xe0,0xd8,0x01,0x00,0x00,0x05]

ds_read2st64_b32 v[254:255], v1 offset0:127 offset1:255
// CHECK: [0x7f,0xff,0xe0,0xd8,0x01,0x00,0x00,0xfe]

ds_read2st64_b32 v[5:6], v255 offset0:127 offset1:255
// CHECK: [0x7f,0xff,0xe0,0xd8,0xff,0x00,0x00,0x05]

ds_read2st64_b32 v[5:6], v1 offset1:255
// CHECK: [0x00,0xff,0xe0,0xd8,0x01,0x00,0x00,0x05]

ds_read2st64_b32 v[5:6], v1 offset0:0 offset1:255
// CHECK: [0x00,0xff,0xe0,0xd8,0x01,0x00,0x00,0x05]

ds_read2st64_b32 v[5:6], v1 offset0:16 offset1:255
// CHECK: [0x10,0xff,0xe0,0xd8,0x01,0x00,0x00,0x05]

ds_read2st64_b32 v[5:6], v1 offset0:127
// CHECK: [0x7f,0x00,0xe0,0xd8,0x01,0x00,0x00,0x05]

ds_read2st64_b32 v[5:6], v1 offset0:127 offset1:0
// CHECK: [0x7f,0x00,0xe0,0xd8,0x01,0x00,0x00,0x05]

ds_read2st64_b32 v[5:6], v1 offset0:127 offset1:1
// CHECK: [0x7f,0x01,0xe0,0xd8,0x01,0x00,0x00,0x05]

ds_read2st64_b32 v[5:6], v1 offset0:127 offset1:255 gds
// CHECK: [0x7f,0xff,0xe2,0xd8,0x01,0x00,0x00,0x05]

ds_read_i8 v5, v1 offset:65535
// CHECK: [0xff,0xff,0xe4,0xd8,0x01,0x00,0x00,0x05]

ds_read_i8 v255, v1 offset:65535
// CHECK: [0xff,0xff,0xe4,0xd8,0x01,0x00,0x00,0xff]

ds_read_i8 v5, v255 offset:65535
// CHECK: [0xff,0xff,0xe4,0xd8,0xff,0x00,0x00,0x05]

ds_read_i8 v5, v1
// CHECK: [0x00,0x00,0xe4,0xd8,0x01,0x00,0x00,0x05]

ds_read_i8 v5, v1 offset:0
// CHECK: [0x00,0x00,0xe4,0xd8,0x01,0x00,0x00,0x05]

ds_read_i8 v5, v1 offset:4
// CHECK: [0x04,0x00,0xe4,0xd8,0x01,0x00,0x00,0x05]

ds_read_i8 v5, v1 offset:65535 gds
// CHECK: [0xff,0xff,0xe6,0xd8,0x01,0x00,0x00,0x05]

ds_read_u8 v5, v1 offset:65535
// CHECK: [0xff,0xff,0xe8,0xd8,0x01,0x00,0x00,0x05]

ds_read_u8 v255, v1 offset:65535
// CHECK: [0xff,0xff,0xe8,0xd8,0x01,0x00,0x00,0xff]

ds_read_u8 v5, v255 offset:65535
// CHECK: [0xff,0xff,0xe8,0xd8,0xff,0x00,0x00,0x05]

ds_read_u8 v5, v1
// CHECK: [0x00,0x00,0xe8,0xd8,0x01,0x00,0x00,0x05]

ds_read_u8 v5, v1 offset:0
// CHECK: [0x00,0x00,0xe8,0xd8,0x01,0x00,0x00,0x05]

ds_read_u8 v5, v1 offset:4
// CHECK: [0x04,0x00,0xe8,0xd8,0x01,0x00,0x00,0x05]

ds_read_u8 v5, v1 offset:65535 gds
// CHECK: [0xff,0xff,0xea,0xd8,0x01,0x00,0x00,0x05]

ds_read_i16 v5, v1 offset:65535
// CHECK: [0xff,0xff,0xec,0xd8,0x01,0x00,0x00,0x05]

ds_read_i16 v255, v1 offset:65535
// CHECK: [0xff,0xff,0xec,0xd8,0x01,0x00,0x00,0xff]

ds_read_i16 v5, v255 offset:65535
// CHECK: [0xff,0xff,0xec,0xd8,0xff,0x00,0x00,0x05]

ds_read_i16 v5, v1
// CHECK: [0x00,0x00,0xec,0xd8,0x01,0x00,0x00,0x05]

ds_read_i16 v5, v1 offset:0
// CHECK: [0x00,0x00,0xec,0xd8,0x01,0x00,0x00,0x05]

ds_read_i16 v5, v1 offset:4
// CHECK: [0x04,0x00,0xec,0xd8,0x01,0x00,0x00,0x05]

ds_read_i16 v5, v1 offset:65535 gds
// CHECK: [0xff,0xff,0xee,0xd8,0x01,0x00,0x00,0x05]

ds_read_u16 v5, v1 offset:65535
// CHECK: [0xff,0xff,0xf0,0xd8,0x01,0x00,0x00,0x05]

ds_read_u16 v255, v1 offset:65535
// CHECK: [0xff,0xff,0xf0,0xd8,0x01,0x00,0x00,0xff]

ds_read_u16 v5, v255 offset:65535
// CHECK: [0xff,0xff,0xf0,0xd8,0xff,0x00,0x00,0x05]

ds_read_u16 v5, v1
// CHECK: [0x00,0x00,0xf0,0xd8,0x01,0x00,0x00,0x05]

ds_read_u16 v5, v1 offset:0
// CHECK: [0x00,0x00,0xf0,0xd8,0x01,0x00,0x00,0x05]

ds_read_u16 v5, v1 offset:4
// CHECK: [0x04,0x00,0xf0,0xd8,0x01,0x00,0x00,0x05]

ds_read_u16 v5, v1 offset:65535 gds
// CHECK: [0xff,0xff,0xf2,0xd8,0x01,0x00,0x00,0x05]

ds_consume v5 offset:65535
// CHECK: [0xff,0xff,0xf4,0xd8,0x00,0x00,0x00,0x05]

ds_consume v255 offset:65535
// CHECK: [0xff,0xff,0xf4,0xd8,0x00,0x00,0x00,0xff]

ds_consume v5
// CHECK: [0x00,0x00,0xf4,0xd8,0x00,0x00,0x00,0x05]

ds_consume v5 offset:0
// CHECK: [0x00,0x00,0xf4,0xd8,0x00,0x00,0x00,0x05]

ds_consume v5 offset:4
// CHECK: [0x04,0x00,0xf4,0xd8,0x00,0x00,0x00,0x05]

ds_consume v5 offset:65535 gds
// CHECK: [0xff,0xff,0xf6,0xd8,0x00,0x00,0x00,0x05]

ds_append v5 offset:65535
// CHECK: [0xff,0xff,0xf8,0xd8,0x00,0x00,0x00,0x05]

ds_append v255 offset:65535
// CHECK: [0xff,0xff,0xf8,0xd8,0x00,0x00,0x00,0xff]

ds_append v5
// CHECK: [0x00,0x00,0xf8,0xd8,0x00,0x00,0x00,0x05]

ds_append v5 offset:0
// CHECK: [0x00,0x00,0xf8,0xd8,0x00,0x00,0x00,0x05]

ds_append v5 offset:4
// CHECK: [0x04,0x00,0xf8,0xd8,0x00,0x00,0x00,0x05]

ds_append v5 offset:65535 gds
// CHECK: [0xff,0xff,0xfa,0xd8,0x00,0x00,0x00,0x05]

ds_ordered_count v5, v1 offset:65535 gds
// CHECK: [0xff,0xff,0xfe,0xd8,0x01,0x00,0x00,0x05]

ds_ordered_count v255, v1 offset:65535 gds
// CHECK: [0xff,0xff,0xfe,0xd8,0x01,0x00,0x00,0xff]

ds_ordered_count v5, v255 offset:65535 gds
// CHECK: [0xff,0xff,0xfe,0xd8,0xff,0x00,0x00,0x05]

ds_ordered_count v5, v1 gds
// CHECK: [0x00,0x00,0xfe,0xd8,0x01,0x00,0x00,0x05]

ds_ordered_count v5, v1 offset:0 gds
// CHECK: [0x00,0x00,0xfe,0xd8,0x01,0x00,0x00,0x05]

ds_ordered_count v5, v1 offset:4 gds
// CHECK: [0x04,0x00,0xfe,0xd8,0x01,0x00,0x00,0x05]

ds_add_u64 v1, v[2:3] offset:65535
// CHECK: [0xff,0xff,0x00,0xd9,0x01,0x02,0x00,0x00]

ds_add_u64 v255, v[2:3] offset:65535
// CHECK: [0xff,0xff,0x00,0xd9,0xff,0x02,0x00,0x00]

ds_add_u64 v1, v[254:255] offset:65535
// CHECK: [0xff,0xff,0x00,0xd9,0x01,0xfe,0x00,0x00]

ds_add_u64 v1, v[2:3]
// CHECK: [0x00,0x00,0x00,0xd9,0x01,0x02,0x00,0x00]

ds_add_u64 v1, v[2:3] offset:0
// CHECK: [0x00,0x00,0x00,0xd9,0x01,0x02,0x00,0x00]

ds_add_u64 v1, v[2:3] offset:4
// CHECK: [0x04,0x00,0x00,0xd9,0x01,0x02,0x00,0x00]

ds_add_u64 v1, v[2:3] offset:65535 gds
// CHECK: [0xff,0xff,0x02,0xd9,0x01,0x02,0x00,0x00]

ds_sub_u64 v1, v[2:3] offset:65535
// CHECK: [0xff,0xff,0x04,0xd9,0x01,0x02,0x00,0x00]

ds_sub_u64 v255, v[2:3] offset:65535
// CHECK: [0xff,0xff,0x04,0xd9,0xff,0x02,0x00,0x00]

ds_sub_u64 v1, v[254:255] offset:65535
// CHECK: [0xff,0xff,0x04,0xd9,0x01,0xfe,0x00,0x00]

ds_sub_u64 v1, v[2:3]
// CHECK: [0x00,0x00,0x04,0xd9,0x01,0x02,0x00,0x00]

ds_sub_u64 v1, v[2:3] offset:0
// CHECK: [0x00,0x00,0x04,0xd9,0x01,0x02,0x00,0x00]

ds_sub_u64 v1, v[2:3] offset:4
// CHECK: [0x04,0x00,0x04,0xd9,0x01,0x02,0x00,0x00]

ds_sub_u64 v1, v[2:3] offset:65535 gds
// CHECK: [0xff,0xff,0x06,0xd9,0x01,0x02,0x00,0x00]

ds_rsub_u64 v1, v[2:3] offset:65535
// CHECK: [0xff,0xff,0x08,0xd9,0x01,0x02,0x00,0x00]

ds_rsub_u64 v255, v[2:3] offset:65535
// CHECK: [0xff,0xff,0x08,0xd9,0xff,0x02,0x00,0x00]

ds_rsub_u64 v1, v[254:255] offset:65535
// CHECK: [0xff,0xff,0x08,0xd9,0x01,0xfe,0x00,0x00]

ds_rsub_u64 v1, v[2:3]
// CHECK: [0x00,0x00,0x08,0xd9,0x01,0x02,0x00,0x00]

ds_rsub_u64 v1, v[2:3] offset:0
// CHECK: [0x00,0x00,0x08,0xd9,0x01,0x02,0x00,0x00]

ds_rsub_u64 v1, v[2:3] offset:4
// CHECK: [0x04,0x00,0x08,0xd9,0x01,0x02,0x00,0x00]

ds_rsub_u64 v1, v[2:3] offset:65535 gds
// CHECK: [0xff,0xff,0x0a,0xd9,0x01,0x02,0x00,0x00]

ds_inc_u64 v1, v[2:3] offset:65535
// CHECK: [0xff,0xff,0x0c,0xd9,0x01,0x02,0x00,0x00]

ds_inc_u64 v255, v[2:3] offset:65535
// CHECK: [0xff,0xff,0x0c,0xd9,0xff,0x02,0x00,0x00]

ds_inc_u64 v1, v[254:255] offset:65535
// CHECK: [0xff,0xff,0x0c,0xd9,0x01,0xfe,0x00,0x00]

ds_inc_u64 v1, v[2:3]
// CHECK: [0x00,0x00,0x0c,0xd9,0x01,0x02,0x00,0x00]

ds_inc_u64 v1, v[2:3] offset:0
// CHECK: [0x00,0x00,0x0c,0xd9,0x01,0x02,0x00,0x00]

ds_inc_u64 v1, v[2:3] offset:4
// CHECK: [0x04,0x00,0x0c,0xd9,0x01,0x02,0x00,0x00]

ds_inc_u64 v1, v[2:3] offset:65535 gds
// CHECK: [0xff,0xff,0x0e,0xd9,0x01,0x02,0x00,0x00]

ds_dec_u64 v1, v[2:3] offset:65535
// CHECK: [0xff,0xff,0x10,0xd9,0x01,0x02,0x00,0x00]

ds_dec_u64 v255, v[2:3] offset:65535
// CHECK: [0xff,0xff,0x10,0xd9,0xff,0x02,0x00,0x00]

ds_dec_u64 v1, v[254:255] offset:65535
// CHECK: [0xff,0xff,0x10,0xd9,0x01,0xfe,0x00,0x00]

ds_dec_u64 v1, v[2:3]
// CHECK: [0x00,0x00,0x10,0xd9,0x01,0x02,0x00,0x00]

ds_dec_u64 v1, v[2:3] offset:0
// CHECK: [0x00,0x00,0x10,0xd9,0x01,0x02,0x00,0x00]

ds_dec_u64 v1, v[2:3] offset:4
// CHECK: [0x04,0x00,0x10,0xd9,0x01,0x02,0x00,0x00]

ds_dec_u64 v1, v[2:3] offset:65535 gds
// CHECK: [0xff,0xff,0x12,0xd9,0x01,0x02,0x00,0x00]

ds_min_i64 v1, v[2:3] offset:65535
// CHECK: [0xff,0xff,0x14,0xd9,0x01,0x02,0x00,0x00]

ds_min_i64 v255, v[2:3] offset:65535
// CHECK: [0xff,0xff,0x14,0xd9,0xff,0x02,0x00,0x00]

ds_min_i64 v1, v[254:255] offset:65535
// CHECK: [0xff,0xff,0x14,0xd9,0x01,0xfe,0x00,0x00]

ds_min_i64 v1, v[2:3]
// CHECK: [0x00,0x00,0x14,0xd9,0x01,0x02,0x00,0x00]

ds_min_i64 v1, v[2:3] offset:0
// CHECK: [0x00,0x00,0x14,0xd9,0x01,0x02,0x00,0x00]

ds_min_i64 v1, v[2:3] offset:4
// CHECK: [0x04,0x00,0x14,0xd9,0x01,0x02,0x00,0x00]

ds_min_i64 v1, v[2:3] offset:65535 gds
// CHECK: [0xff,0xff,0x16,0xd9,0x01,0x02,0x00,0x00]

ds_max_i64 v1, v[2:3] offset:65535
// CHECK: [0xff,0xff,0x18,0xd9,0x01,0x02,0x00,0x00]

ds_max_i64 v255, v[2:3] offset:65535
// CHECK: [0xff,0xff,0x18,0xd9,0xff,0x02,0x00,0x00]

ds_max_i64 v1, v[254:255] offset:65535
// CHECK: [0xff,0xff,0x18,0xd9,0x01,0xfe,0x00,0x00]

ds_max_i64 v1, v[2:3]
// CHECK: [0x00,0x00,0x18,0xd9,0x01,0x02,0x00,0x00]

ds_max_i64 v1, v[2:3] offset:0
// CHECK: [0x00,0x00,0x18,0xd9,0x01,0x02,0x00,0x00]

ds_max_i64 v1, v[2:3] offset:4
// CHECK: [0x04,0x00,0x18,0xd9,0x01,0x02,0x00,0x00]

ds_max_i64 v1, v[2:3] offset:65535 gds
// CHECK: [0xff,0xff,0x1a,0xd9,0x01,0x02,0x00,0x00]

ds_min_u64 v1, v[2:3] offset:65535
// CHECK: [0xff,0xff,0x1c,0xd9,0x01,0x02,0x00,0x00]

ds_min_u64 v255, v[2:3] offset:65535
// CHECK: [0xff,0xff,0x1c,0xd9,0xff,0x02,0x00,0x00]

ds_min_u64 v1, v[254:255] offset:65535
// CHECK: [0xff,0xff,0x1c,0xd9,0x01,0xfe,0x00,0x00]

ds_min_u64 v1, v[2:3]
// CHECK: [0x00,0x00,0x1c,0xd9,0x01,0x02,0x00,0x00]

ds_min_u64 v1, v[2:3] offset:0
// CHECK: [0x00,0x00,0x1c,0xd9,0x01,0x02,0x00,0x00]

ds_min_u64 v1, v[2:3] offset:4
// CHECK: [0x04,0x00,0x1c,0xd9,0x01,0x02,0x00,0x00]

ds_min_u64 v1, v[2:3] offset:65535 gds
// CHECK: [0xff,0xff,0x1e,0xd9,0x01,0x02,0x00,0x00]

ds_max_u64 v1, v[2:3] offset:65535
// CHECK: [0xff,0xff,0x20,0xd9,0x01,0x02,0x00,0x00]

ds_max_u64 v255, v[2:3] offset:65535
// CHECK: [0xff,0xff,0x20,0xd9,0xff,0x02,0x00,0x00]

ds_max_u64 v1, v[254:255] offset:65535
// CHECK: [0xff,0xff,0x20,0xd9,0x01,0xfe,0x00,0x00]

ds_max_u64 v1, v[2:3]
// CHECK: [0x00,0x00,0x20,0xd9,0x01,0x02,0x00,0x00]

ds_max_u64 v1, v[2:3] offset:0
// CHECK: [0x00,0x00,0x20,0xd9,0x01,0x02,0x00,0x00]

ds_max_u64 v1, v[2:3] offset:4
// CHECK: [0x04,0x00,0x20,0xd9,0x01,0x02,0x00,0x00]

ds_max_u64 v1, v[2:3] offset:65535 gds
// CHECK: [0xff,0xff,0x22,0xd9,0x01,0x02,0x00,0x00]

ds_and_b64 v1, v[2:3] offset:65535
// CHECK: [0xff,0xff,0x24,0xd9,0x01,0x02,0x00,0x00]

ds_and_b64 v255, v[2:3] offset:65535
// CHECK: [0xff,0xff,0x24,0xd9,0xff,0x02,0x00,0x00]

ds_and_b64 v1, v[254:255] offset:65535
// CHECK: [0xff,0xff,0x24,0xd9,0x01,0xfe,0x00,0x00]

ds_and_b64 v1, v[2:3]
// CHECK: [0x00,0x00,0x24,0xd9,0x01,0x02,0x00,0x00]

ds_and_b64 v1, v[2:3] offset:0
// CHECK: [0x00,0x00,0x24,0xd9,0x01,0x02,0x00,0x00]

ds_and_b64 v1, v[2:3] offset:4
// CHECK: [0x04,0x00,0x24,0xd9,0x01,0x02,0x00,0x00]

ds_and_b64 v1, v[2:3] offset:65535 gds
// CHECK: [0xff,0xff,0x26,0xd9,0x01,0x02,0x00,0x00]

ds_or_b64 v1, v[2:3] offset:65535
// CHECK: [0xff,0xff,0x28,0xd9,0x01,0x02,0x00,0x00]

ds_or_b64 v255, v[2:3] offset:65535
// CHECK: [0xff,0xff,0x28,0xd9,0xff,0x02,0x00,0x00]

ds_or_b64 v1, v[254:255] offset:65535
// CHECK: [0xff,0xff,0x28,0xd9,0x01,0xfe,0x00,0x00]

ds_or_b64 v1, v[2:3]
// CHECK: [0x00,0x00,0x28,0xd9,0x01,0x02,0x00,0x00]

ds_or_b64 v1, v[2:3] offset:0
// CHECK: [0x00,0x00,0x28,0xd9,0x01,0x02,0x00,0x00]

ds_or_b64 v1, v[2:3] offset:4
// CHECK: [0x04,0x00,0x28,0xd9,0x01,0x02,0x00,0x00]

ds_or_b64 v1, v[2:3] offset:65535 gds
// CHECK: [0xff,0xff,0x2a,0xd9,0x01,0x02,0x00,0x00]

ds_xor_b64 v1, v[2:3] offset:65535
// CHECK: [0xff,0xff,0x2c,0xd9,0x01,0x02,0x00,0x00]

ds_xor_b64 v255, v[2:3] offset:65535
// CHECK: [0xff,0xff,0x2c,0xd9,0xff,0x02,0x00,0x00]

ds_xor_b64 v1, v[254:255] offset:65535
// CHECK: [0xff,0xff,0x2c,0xd9,0x01,0xfe,0x00,0x00]

ds_xor_b64 v1, v[2:3]
// CHECK: [0x00,0x00,0x2c,0xd9,0x01,0x02,0x00,0x00]

ds_xor_b64 v1, v[2:3] offset:0
// CHECK: [0x00,0x00,0x2c,0xd9,0x01,0x02,0x00,0x00]

ds_xor_b64 v1, v[2:3] offset:4
// CHECK: [0x04,0x00,0x2c,0xd9,0x01,0x02,0x00,0x00]

ds_xor_b64 v1, v[2:3] offset:65535 gds
// CHECK: [0xff,0xff,0x2e,0xd9,0x01,0x02,0x00,0x00]

ds_mskor_b64 v1, v[2:3], v[3:4] offset:65535
// CHECK: [0xff,0xff,0x30,0xd9,0x01,0x02,0x03,0x00]

ds_mskor_b64 v255, v[2:3], v[3:4] offset:65535
// CHECK: [0xff,0xff,0x30,0xd9,0xff,0x02,0x03,0x00]

ds_mskor_b64 v1, v[254:255], v[3:4] offset:65535
// CHECK: [0xff,0xff,0x30,0xd9,0x01,0xfe,0x03,0x00]

ds_mskor_b64 v1, v[2:3], v[254:255] offset:65535
// CHECK: [0xff,0xff,0x30,0xd9,0x01,0x02,0xfe,0x00]

ds_mskor_b64 v1, v[2:3], v[3:4]
// CHECK: [0x00,0x00,0x30,0xd9,0x01,0x02,0x03,0x00]

ds_mskor_b64 v1, v[2:3], v[3:4] offset:0
// CHECK: [0x00,0x00,0x30,0xd9,0x01,0x02,0x03,0x00]

ds_mskor_b64 v1, v[2:3], v[3:4] offset:4
// CHECK: [0x04,0x00,0x30,0xd9,0x01,0x02,0x03,0x00]

ds_mskor_b64 v1, v[2:3], v[3:4] offset:65535 gds
// CHECK: [0xff,0xff,0x32,0xd9,0x01,0x02,0x03,0x00]

ds_write_b64 v1, v[2:3] offset:65535
// CHECK: [0xff,0xff,0x34,0xd9,0x01,0x02,0x00,0x00]

ds_write_b64 v255, v[2:3] offset:65535
// CHECK: [0xff,0xff,0x34,0xd9,0xff,0x02,0x00,0x00]

ds_write_b64 v1, v[254:255] offset:65535
// CHECK: [0xff,0xff,0x34,0xd9,0x01,0xfe,0x00,0x00]

ds_write_b64 v1, v[2:3]
// CHECK: [0x00,0x00,0x34,0xd9,0x01,0x02,0x00,0x00]

ds_write_b64 v1, v[2:3] offset:0
// CHECK: [0x00,0x00,0x34,0xd9,0x01,0x02,0x00,0x00]

ds_write_b64 v1, v[2:3] offset:4
// CHECK: [0x04,0x00,0x34,0xd9,0x01,0x02,0x00,0x00]

ds_write_b64 v1, v[2:3] offset:65535 gds
// CHECK: [0xff,0xff,0x36,0xd9,0x01,0x02,0x00,0x00]

ds_write2_b64 v1, v[2:3], v[3:4] offset0:127 offset1:255
// CHECK: [0x7f,0xff,0x38,0xd9,0x01,0x02,0x03,0x00]

ds_write2_b64 v255, v[2:3], v[3:4] offset0:127 offset1:255
// CHECK: [0x7f,0xff,0x38,0xd9,0xff,0x02,0x03,0x00]

ds_write2_b64 v1, v[254:255], v[3:4] offset0:127 offset1:255
// CHECK: [0x7f,0xff,0x38,0xd9,0x01,0xfe,0x03,0x00]

ds_write2_b64 v1, v[2:3], v[254:255] offset0:127 offset1:255
// CHECK: [0x7f,0xff,0x38,0xd9,0x01,0x02,0xfe,0x00]

ds_write2_b64 v1, v[2:3], v[3:4] offset1:255
// CHECK: [0x00,0xff,0x38,0xd9,0x01,0x02,0x03,0x00]

ds_write2_b64 v1, v[2:3], v[3:4] offset0:0 offset1:255
// CHECK: [0x00,0xff,0x38,0xd9,0x01,0x02,0x03,0x00]

ds_write2_b64 v1, v[2:3], v[3:4] offset0:16 offset1:255
// CHECK: [0x10,0xff,0x38,0xd9,0x01,0x02,0x03,0x00]

ds_write2_b64 v1, v[2:3], v[3:4] offset0:127
// CHECK: [0x7f,0x00,0x38,0xd9,0x01,0x02,0x03,0x00]

ds_write2_b64 v1, v[2:3], v[3:4] offset0:127 offset1:0
// CHECK: [0x7f,0x00,0x38,0xd9,0x01,0x02,0x03,0x00]

ds_write2_b64 v1, v[2:3], v[3:4] offset0:127 offset1:1
// CHECK: [0x7f,0x01,0x38,0xd9,0x01,0x02,0x03,0x00]

ds_write2_b64 v1, v[2:3], v[3:4] offset0:127 offset1:255 gds
// CHECK: [0x7f,0xff,0x3a,0xd9,0x01,0x02,0x03,0x00]

ds_write2st64_b64 v1, v[2:3], v[3:4] offset0:127 offset1:255
// CHECK: [0x7f,0xff,0x3c,0xd9,0x01,0x02,0x03,0x00]

ds_write2st64_b64 v255, v[2:3], v[3:4] offset0:127 offset1:255
// CHECK: [0x7f,0xff,0x3c,0xd9,0xff,0x02,0x03,0x00]

ds_write2st64_b64 v1, v[254:255], v[3:4] offset0:127 offset1:255
// CHECK: [0x7f,0xff,0x3c,0xd9,0x01,0xfe,0x03,0x00]

ds_write2st64_b64 v1, v[2:3], v[254:255] offset0:127 offset1:255
// CHECK: [0x7f,0xff,0x3c,0xd9,0x01,0x02,0xfe,0x00]

ds_write2st64_b64 v1, v[2:3], v[3:4] offset1:255
// CHECK: [0x00,0xff,0x3c,0xd9,0x01,0x02,0x03,0x00]

ds_write2st64_b64 v1, v[2:3], v[3:4] offset0:0 offset1:255
// CHECK: [0x00,0xff,0x3c,0xd9,0x01,0x02,0x03,0x00]

ds_write2st64_b64 v1, v[2:3], v[3:4] offset0:16 offset1:255
// CHECK: [0x10,0xff,0x3c,0xd9,0x01,0x02,0x03,0x00]

ds_write2st64_b64 v1, v[2:3], v[3:4] offset0:127
// CHECK: [0x7f,0x00,0x3c,0xd9,0x01,0x02,0x03,0x00]

ds_write2st64_b64 v1, v[2:3], v[3:4] offset0:127 offset1:0
// CHECK: [0x7f,0x00,0x3c,0xd9,0x01,0x02,0x03,0x00]

ds_write2st64_b64 v1, v[2:3], v[3:4] offset0:127 offset1:1
// CHECK: [0x7f,0x01,0x3c,0xd9,0x01,0x02,0x03,0x00]

ds_write2st64_b64 v1, v[2:3], v[3:4] offset0:127 offset1:255 gds
// CHECK: [0x7f,0xff,0x3e,0xd9,0x01,0x02,0x03,0x00]

ds_cmpst_b64 v1, v[2:3], v[3:4] offset:65535
// CHECK: [0xff,0xff,0x40,0xd9,0x01,0x02,0x03,0x00]

ds_cmpst_b64 v255, v[2:3], v[3:4] offset:65535
// CHECK: [0xff,0xff,0x40,0xd9,0xff,0x02,0x03,0x00]

ds_cmpst_b64 v1, v[254:255], v[3:4] offset:65535
// CHECK: [0xff,0xff,0x40,0xd9,0x01,0xfe,0x03,0x00]

ds_cmpst_b64 v1, v[2:3], v[254:255] offset:65535
// CHECK: [0xff,0xff,0x40,0xd9,0x01,0x02,0xfe,0x00]

ds_cmpst_b64 v1, v[2:3], v[3:4]
// CHECK: [0x00,0x00,0x40,0xd9,0x01,0x02,0x03,0x00]

ds_cmpst_b64 v1, v[2:3], v[3:4] offset:0
// CHECK: [0x00,0x00,0x40,0xd9,0x01,0x02,0x03,0x00]

ds_cmpst_b64 v1, v[2:3], v[3:4] offset:4
// CHECK: [0x04,0x00,0x40,0xd9,0x01,0x02,0x03,0x00]

ds_cmpst_b64 v1, v[2:3], v[3:4] offset:65535 gds
// CHECK: [0xff,0xff,0x42,0xd9,0x01,0x02,0x03,0x00]

ds_cmpst_f64 v1, v[2:3], v[3:4] offset:65535
// CHECK: [0xff,0xff,0x44,0xd9,0x01,0x02,0x03,0x00]

ds_cmpst_f64 v255, v[2:3], v[3:4] offset:65535
// CHECK: [0xff,0xff,0x44,0xd9,0xff,0x02,0x03,0x00]

ds_cmpst_f64 v1, v[254:255], v[3:4] offset:65535
// CHECK: [0xff,0xff,0x44,0xd9,0x01,0xfe,0x03,0x00]

ds_cmpst_f64 v1, v[2:3], v[254:255] offset:65535
// CHECK: [0xff,0xff,0x44,0xd9,0x01,0x02,0xfe,0x00]

ds_cmpst_f64 v1, v[2:3], v[3:4]
// CHECK: [0x00,0x00,0x44,0xd9,0x01,0x02,0x03,0x00]

ds_cmpst_f64 v1, v[2:3], v[3:4] offset:0
// CHECK: [0x00,0x00,0x44,0xd9,0x01,0x02,0x03,0x00]

ds_cmpst_f64 v1, v[2:3], v[3:4] offset:4
// CHECK: [0x04,0x00,0x44,0xd9,0x01,0x02,0x03,0x00]

ds_cmpst_f64 v1, v[2:3], v[3:4] offset:65535 gds
// CHECK: [0xff,0xff,0x46,0xd9,0x01,0x02,0x03,0x00]

ds_min_f64 v1, v[2:3] offset:65535
// CHECK: [0xff,0xff,0x48,0xd9,0x01,0x02,0x00,0x00]

ds_min_f64 v255, v[2:3] offset:65535
// CHECK: [0xff,0xff,0x48,0xd9,0xff,0x02,0x00,0x00]

ds_min_f64 v1, v[254:255] offset:65535
// CHECK: [0xff,0xff,0x48,0xd9,0x01,0xfe,0x00,0x00]

ds_min_f64 v1, v[2:3]
// CHECK: [0x00,0x00,0x48,0xd9,0x01,0x02,0x00,0x00]

ds_min_f64 v1, v[2:3] offset:0
// CHECK: [0x00,0x00,0x48,0xd9,0x01,0x02,0x00,0x00]

ds_min_f64 v1, v[2:3] offset:4
// CHECK: [0x04,0x00,0x48,0xd9,0x01,0x02,0x00,0x00]

ds_min_f64 v1, v[2:3] offset:65535 gds
// CHECK: [0xff,0xff,0x4a,0xd9,0x01,0x02,0x00,0x00]

ds_max_f64 v1, v[2:3] offset:65535
// CHECK: [0xff,0xff,0x4c,0xd9,0x01,0x02,0x00,0x00]

ds_max_f64 v255, v[2:3] offset:65535
// CHECK: [0xff,0xff,0x4c,0xd9,0xff,0x02,0x00,0x00]

ds_max_f64 v1, v[254:255] offset:65535
// CHECK: [0xff,0xff,0x4c,0xd9,0x01,0xfe,0x00,0x00]

ds_max_f64 v1, v[2:3]
// CHECK: [0x00,0x00,0x4c,0xd9,0x01,0x02,0x00,0x00]

ds_max_f64 v1, v[2:3] offset:0
// CHECK: [0x00,0x00,0x4c,0xd9,0x01,0x02,0x00,0x00]

ds_max_f64 v1, v[2:3] offset:4
// CHECK: [0x04,0x00,0x4c,0xd9,0x01,0x02,0x00,0x00]

ds_max_f64 v1, v[2:3] offset:65535 gds
// CHECK: [0xff,0xff,0x4e,0xd9,0x01,0x02,0x00,0x00]

ds_add_rtn_u64 v[5:6], v1, v[2:3] offset:65535
// CHECK: [0xff,0xff,0x80,0xd9,0x01,0x02,0x00,0x05]

ds_add_rtn_u64 v[254:255], v1, v[2:3] offset:65535
// CHECK: [0xff,0xff,0x80,0xd9,0x01,0x02,0x00,0xfe]

ds_add_rtn_u64 v[5:6], v255, v[2:3] offset:65535
// CHECK: [0xff,0xff,0x80,0xd9,0xff,0x02,0x00,0x05]

ds_add_rtn_u64 v[5:6], v1, v[254:255] offset:65535
// CHECK: [0xff,0xff,0x80,0xd9,0x01,0xfe,0x00,0x05]

ds_add_rtn_u64 v[5:6], v1, v[2:3]
// CHECK: [0x00,0x00,0x80,0xd9,0x01,0x02,0x00,0x05]

ds_add_rtn_u64 v[5:6], v1, v[2:3] offset:0
// CHECK: [0x00,0x00,0x80,0xd9,0x01,0x02,0x00,0x05]

ds_add_rtn_u64 v[5:6], v1, v[2:3] offset:4
// CHECK: [0x04,0x00,0x80,0xd9,0x01,0x02,0x00,0x05]

ds_add_rtn_u64 v[5:6], v1, v[2:3] offset:65535 gds
// CHECK: [0xff,0xff,0x82,0xd9,0x01,0x02,0x00,0x05]

ds_sub_rtn_u64 v[5:6], v1, v[2:3] offset:65535
// CHECK: [0xff,0xff,0x84,0xd9,0x01,0x02,0x00,0x05]

ds_sub_rtn_u64 v[254:255], v1, v[2:3] offset:65535
// CHECK: [0xff,0xff,0x84,0xd9,0x01,0x02,0x00,0xfe]

ds_sub_rtn_u64 v[5:6], v255, v[2:3] offset:65535
// CHECK: [0xff,0xff,0x84,0xd9,0xff,0x02,0x00,0x05]

ds_sub_rtn_u64 v[5:6], v1, v[254:255] offset:65535
// CHECK: [0xff,0xff,0x84,0xd9,0x01,0xfe,0x00,0x05]

ds_sub_rtn_u64 v[5:6], v1, v[2:3]
// CHECK: [0x00,0x00,0x84,0xd9,0x01,0x02,0x00,0x05]

ds_sub_rtn_u64 v[5:6], v1, v[2:3] offset:0
// CHECK: [0x00,0x00,0x84,0xd9,0x01,0x02,0x00,0x05]

ds_sub_rtn_u64 v[5:6], v1, v[2:3] offset:4
// CHECK: [0x04,0x00,0x84,0xd9,0x01,0x02,0x00,0x05]

ds_sub_rtn_u64 v[5:6], v1, v[2:3] offset:65535 gds
// CHECK: [0xff,0xff,0x86,0xd9,0x01,0x02,0x00,0x05]

ds_rsub_rtn_u64 v[5:6], v1, v[2:3] offset:65535
// CHECK: [0xff,0xff,0x88,0xd9,0x01,0x02,0x00,0x05]

ds_rsub_rtn_u64 v[254:255], v1, v[2:3] offset:65535
// CHECK: [0xff,0xff,0x88,0xd9,0x01,0x02,0x00,0xfe]

ds_rsub_rtn_u64 v[5:6], v255, v[2:3] offset:65535
// CHECK: [0xff,0xff,0x88,0xd9,0xff,0x02,0x00,0x05]

ds_rsub_rtn_u64 v[5:6], v1, v[254:255] offset:65535
// CHECK: [0xff,0xff,0x88,0xd9,0x01,0xfe,0x00,0x05]

ds_rsub_rtn_u64 v[5:6], v1, v[2:3]
// CHECK: [0x00,0x00,0x88,0xd9,0x01,0x02,0x00,0x05]

ds_rsub_rtn_u64 v[5:6], v1, v[2:3] offset:0
// CHECK: [0x00,0x00,0x88,0xd9,0x01,0x02,0x00,0x05]

ds_rsub_rtn_u64 v[5:6], v1, v[2:3] offset:4
// CHECK: [0x04,0x00,0x88,0xd9,0x01,0x02,0x00,0x05]

ds_rsub_rtn_u64 v[5:6], v1, v[2:3] offset:65535 gds
// CHECK: [0xff,0xff,0x8a,0xd9,0x01,0x02,0x00,0x05]

ds_inc_rtn_u64 v[5:6], v1, v[2:3] offset:65535
// CHECK: [0xff,0xff,0x8c,0xd9,0x01,0x02,0x00,0x05]

ds_inc_rtn_u64 v[254:255], v1, v[2:3] offset:65535
// CHECK: [0xff,0xff,0x8c,0xd9,0x01,0x02,0x00,0xfe]

ds_inc_rtn_u64 v[5:6], v255, v[2:3] offset:65535
// CHECK: [0xff,0xff,0x8c,0xd9,0xff,0x02,0x00,0x05]

ds_inc_rtn_u64 v[5:6], v1, v[254:255] offset:65535
// CHECK: [0xff,0xff,0x8c,0xd9,0x01,0xfe,0x00,0x05]

ds_inc_rtn_u64 v[5:6], v1, v[2:3]
// CHECK: [0x00,0x00,0x8c,0xd9,0x01,0x02,0x00,0x05]

ds_inc_rtn_u64 v[5:6], v1, v[2:3] offset:0
// CHECK: [0x00,0x00,0x8c,0xd9,0x01,0x02,0x00,0x05]

ds_inc_rtn_u64 v[5:6], v1, v[2:3] offset:4
// CHECK: [0x04,0x00,0x8c,0xd9,0x01,0x02,0x00,0x05]

ds_inc_rtn_u64 v[5:6], v1, v[2:3] offset:65535 gds
// CHECK: [0xff,0xff,0x8e,0xd9,0x01,0x02,0x00,0x05]

ds_dec_rtn_u64 v[5:6], v1, v[2:3] offset:65535
// CHECK: [0xff,0xff,0x90,0xd9,0x01,0x02,0x00,0x05]

ds_dec_rtn_u64 v[254:255], v1, v[2:3] offset:65535
// CHECK: [0xff,0xff,0x90,0xd9,0x01,0x02,0x00,0xfe]

ds_dec_rtn_u64 v[5:6], v255, v[2:3] offset:65535
// CHECK: [0xff,0xff,0x90,0xd9,0xff,0x02,0x00,0x05]

ds_dec_rtn_u64 v[5:6], v1, v[254:255] offset:65535
// CHECK: [0xff,0xff,0x90,0xd9,0x01,0xfe,0x00,0x05]

ds_dec_rtn_u64 v[5:6], v1, v[2:3]
// CHECK: [0x00,0x00,0x90,0xd9,0x01,0x02,0x00,0x05]

ds_dec_rtn_u64 v[5:6], v1, v[2:3] offset:0
// CHECK: [0x00,0x00,0x90,0xd9,0x01,0x02,0x00,0x05]

ds_dec_rtn_u64 v[5:6], v1, v[2:3] offset:4
// CHECK: [0x04,0x00,0x90,0xd9,0x01,0x02,0x00,0x05]

ds_dec_rtn_u64 v[5:6], v1, v[2:3] offset:65535 gds
// CHECK: [0xff,0xff,0x92,0xd9,0x01,0x02,0x00,0x05]

ds_min_rtn_i64 v[5:6], v1, v[2:3] offset:65535
// CHECK: [0xff,0xff,0x94,0xd9,0x01,0x02,0x00,0x05]

ds_min_rtn_i64 v[254:255], v1, v[2:3] offset:65535
// CHECK: [0xff,0xff,0x94,0xd9,0x01,0x02,0x00,0xfe]

ds_min_rtn_i64 v[5:6], v255, v[2:3] offset:65535
// CHECK: [0xff,0xff,0x94,0xd9,0xff,0x02,0x00,0x05]

ds_min_rtn_i64 v[5:6], v1, v[254:255] offset:65535
// CHECK: [0xff,0xff,0x94,0xd9,0x01,0xfe,0x00,0x05]

ds_min_rtn_i64 v[5:6], v1, v[2:3]
// CHECK: [0x00,0x00,0x94,0xd9,0x01,0x02,0x00,0x05]

ds_min_rtn_i64 v[5:6], v1, v[2:3] offset:0
// CHECK: [0x00,0x00,0x94,0xd9,0x01,0x02,0x00,0x05]

ds_min_rtn_i64 v[5:6], v1, v[2:3] offset:4
// CHECK: [0x04,0x00,0x94,0xd9,0x01,0x02,0x00,0x05]

ds_min_rtn_i64 v[5:6], v1, v[2:3] offset:65535 gds
// CHECK: [0xff,0xff,0x96,0xd9,0x01,0x02,0x00,0x05]

ds_max_rtn_i64 v[5:6], v1, v[2:3] offset:65535
// CHECK: [0xff,0xff,0x98,0xd9,0x01,0x02,0x00,0x05]

ds_max_rtn_i64 v[254:255], v1, v[2:3] offset:65535
// CHECK: [0xff,0xff,0x98,0xd9,0x01,0x02,0x00,0xfe]

ds_max_rtn_i64 v[5:6], v255, v[2:3] offset:65535
// CHECK: [0xff,0xff,0x98,0xd9,0xff,0x02,0x00,0x05]

ds_max_rtn_i64 v[5:6], v1, v[254:255] offset:65535
// CHECK: [0xff,0xff,0x98,0xd9,0x01,0xfe,0x00,0x05]

ds_max_rtn_i64 v[5:6], v1, v[2:3]
// CHECK: [0x00,0x00,0x98,0xd9,0x01,0x02,0x00,0x05]

ds_max_rtn_i64 v[5:6], v1, v[2:3] offset:0
// CHECK: [0x00,0x00,0x98,0xd9,0x01,0x02,0x00,0x05]

ds_max_rtn_i64 v[5:6], v1, v[2:3] offset:4
// CHECK: [0x04,0x00,0x98,0xd9,0x01,0x02,0x00,0x05]

ds_max_rtn_i64 v[5:6], v1, v[2:3] offset:65535 gds
// CHECK: [0xff,0xff,0x9a,0xd9,0x01,0x02,0x00,0x05]

ds_min_rtn_u64 v[5:6], v1, v[2:3] offset:65535
// CHECK: [0xff,0xff,0x9c,0xd9,0x01,0x02,0x00,0x05]

ds_min_rtn_u64 v[254:255], v1, v[2:3] offset:65535
// CHECK: [0xff,0xff,0x9c,0xd9,0x01,0x02,0x00,0xfe]

ds_min_rtn_u64 v[5:6], v255, v[2:3] offset:65535
// CHECK: [0xff,0xff,0x9c,0xd9,0xff,0x02,0x00,0x05]

ds_min_rtn_u64 v[5:6], v1, v[254:255] offset:65535
// CHECK: [0xff,0xff,0x9c,0xd9,0x01,0xfe,0x00,0x05]

ds_min_rtn_u64 v[5:6], v1, v[2:3]
// CHECK: [0x00,0x00,0x9c,0xd9,0x01,0x02,0x00,0x05]

ds_min_rtn_u64 v[5:6], v1, v[2:3] offset:0
// CHECK: [0x00,0x00,0x9c,0xd9,0x01,0x02,0x00,0x05]

ds_min_rtn_u64 v[5:6], v1, v[2:3] offset:4
// CHECK: [0x04,0x00,0x9c,0xd9,0x01,0x02,0x00,0x05]

ds_min_rtn_u64 v[5:6], v1, v[2:3] offset:65535 gds
// CHECK: [0xff,0xff,0x9e,0xd9,0x01,0x02,0x00,0x05]

ds_max_rtn_u64 v[5:6], v1, v[2:3] offset:65535
// CHECK: [0xff,0xff,0xa0,0xd9,0x01,0x02,0x00,0x05]

ds_max_rtn_u64 v[254:255], v1, v[2:3] offset:65535
// CHECK: [0xff,0xff,0xa0,0xd9,0x01,0x02,0x00,0xfe]

ds_max_rtn_u64 v[5:6], v255, v[2:3] offset:65535
// CHECK: [0xff,0xff,0xa0,0xd9,0xff,0x02,0x00,0x05]

ds_max_rtn_u64 v[5:6], v1, v[254:255] offset:65535
// CHECK: [0xff,0xff,0xa0,0xd9,0x01,0xfe,0x00,0x05]

ds_max_rtn_u64 v[5:6], v1, v[2:3]
// CHECK: [0x00,0x00,0xa0,0xd9,0x01,0x02,0x00,0x05]

ds_max_rtn_u64 v[5:6], v1, v[2:3] offset:0
// CHECK: [0x00,0x00,0xa0,0xd9,0x01,0x02,0x00,0x05]

ds_max_rtn_u64 v[5:6], v1, v[2:3] offset:4
// CHECK: [0x04,0x00,0xa0,0xd9,0x01,0x02,0x00,0x05]

ds_max_rtn_u64 v[5:6], v1, v[2:3] offset:65535 gds
// CHECK: [0xff,0xff,0xa2,0xd9,0x01,0x02,0x00,0x05]

ds_and_rtn_b64 v[5:6], v1, v[2:3] offset:65535
// CHECK: [0xff,0xff,0xa4,0xd9,0x01,0x02,0x00,0x05]

ds_and_rtn_b64 v[254:255], v1, v[2:3] offset:65535
// CHECK: [0xff,0xff,0xa4,0xd9,0x01,0x02,0x00,0xfe]

ds_and_rtn_b64 v[5:6], v255, v[2:3] offset:65535
// CHECK: [0xff,0xff,0xa4,0xd9,0xff,0x02,0x00,0x05]

ds_and_rtn_b64 v[5:6], v1, v[254:255] offset:65535
// CHECK: [0xff,0xff,0xa4,0xd9,0x01,0xfe,0x00,0x05]

ds_and_rtn_b64 v[5:6], v1, v[2:3]
// CHECK: [0x00,0x00,0xa4,0xd9,0x01,0x02,0x00,0x05]

ds_and_rtn_b64 v[5:6], v1, v[2:3] offset:0
// CHECK: [0x00,0x00,0xa4,0xd9,0x01,0x02,0x00,0x05]

ds_and_rtn_b64 v[5:6], v1, v[2:3] offset:4
// CHECK: [0x04,0x00,0xa4,0xd9,0x01,0x02,0x00,0x05]

ds_and_rtn_b64 v[5:6], v1, v[2:3] offset:65535 gds
// CHECK: [0xff,0xff,0xa6,0xd9,0x01,0x02,0x00,0x05]

ds_or_rtn_b64 v[5:6], v1, v[2:3] offset:65535
// CHECK: [0xff,0xff,0xa8,0xd9,0x01,0x02,0x00,0x05]

ds_or_rtn_b64 v[254:255], v1, v[2:3] offset:65535
// CHECK: [0xff,0xff,0xa8,0xd9,0x01,0x02,0x00,0xfe]

ds_or_rtn_b64 v[5:6], v255, v[2:3] offset:65535
// CHECK: [0xff,0xff,0xa8,0xd9,0xff,0x02,0x00,0x05]

ds_or_rtn_b64 v[5:6], v1, v[254:255] offset:65535
// CHECK: [0xff,0xff,0xa8,0xd9,0x01,0xfe,0x00,0x05]

ds_or_rtn_b64 v[5:6], v1, v[2:3]
// CHECK: [0x00,0x00,0xa8,0xd9,0x01,0x02,0x00,0x05]

ds_or_rtn_b64 v[5:6], v1, v[2:3] offset:0
// CHECK: [0x00,0x00,0xa8,0xd9,0x01,0x02,0x00,0x05]

ds_or_rtn_b64 v[5:6], v1, v[2:3] offset:4
// CHECK: [0x04,0x00,0xa8,0xd9,0x01,0x02,0x00,0x05]

ds_or_rtn_b64 v[5:6], v1, v[2:3] offset:65535 gds
// CHECK: [0xff,0xff,0xaa,0xd9,0x01,0x02,0x00,0x05]

ds_xor_rtn_b64 v[5:6], v1, v[2:3] offset:65535
// CHECK: [0xff,0xff,0xac,0xd9,0x01,0x02,0x00,0x05]

ds_xor_rtn_b64 v[254:255], v1, v[2:3] offset:65535
// CHECK: [0xff,0xff,0xac,0xd9,0x01,0x02,0x00,0xfe]

ds_xor_rtn_b64 v[5:6], v255, v[2:3] offset:65535
// CHECK: [0xff,0xff,0xac,0xd9,0xff,0x02,0x00,0x05]

ds_xor_rtn_b64 v[5:6], v1, v[254:255] offset:65535
// CHECK: [0xff,0xff,0xac,0xd9,0x01,0xfe,0x00,0x05]

ds_xor_rtn_b64 v[5:6], v1, v[2:3]
// CHECK: [0x00,0x00,0xac,0xd9,0x01,0x02,0x00,0x05]

ds_xor_rtn_b64 v[5:6], v1, v[2:3] offset:0
// CHECK: [0x00,0x00,0xac,0xd9,0x01,0x02,0x00,0x05]

ds_xor_rtn_b64 v[5:6], v1, v[2:3] offset:4
// CHECK: [0x04,0x00,0xac,0xd9,0x01,0x02,0x00,0x05]

ds_xor_rtn_b64 v[5:6], v1, v[2:3] offset:65535 gds
// CHECK: [0xff,0xff,0xae,0xd9,0x01,0x02,0x00,0x05]

ds_mskor_rtn_b64 v[5:6], v1, v[2:3], v[3:4] offset:65535
// CHECK: [0xff,0xff,0xb0,0xd9,0x01,0x02,0x03,0x05]

ds_mskor_rtn_b64 v[254:255], v1, v[2:3], v[3:4] offset:65535
// CHECK: [0xff,0xff,0xb0,0xd9,0x01,0x02,0x03,0xfe]

ds_mskor_rtn_b64 v[5:6], v255, v[2:3], v[3:4] offset:65535
// CHECK: [0xff,0xff,0xb0,0xd9,0xff,0x02,0x03,0x05]

ds_mskor_rtn_b64 v[5:6], v1, v[254:255], v[3:4] offset:65535
// CHECK: [0xff,0xff,0xb0,0xd9,0x01,0xfe,0x03,0x05]

ds_mskor_rtn_b64 v[5:6], v1, v[2:3], v[254:255] offset:65535
// CHECK: [0xff,0xff,0xb0,0xd9,0x01,0x02,0xfe,0x05]

ds_mskor_rtn_b64 v[5:6], v1, v[2:3], v[3:4]
// CHECK: [0x00,0x00,0xb0,0xd9,0x01,0x02,0x03,0x05]

ds_mskor_rtn_b64 v[5:6], v1, v[2:3], v[3:4] offset:0
// CHECK: [0x00,0x00,0xb0,0xd9,0x01,0x02,0x03,0x05]

ds_mskor_rtn_b64 v[5:6], v1, v[2:3], v[3:4] offset:4
// CHECK: [0x04,0x00,0xb0,0xd9,0x01,0x02,0x03,0x05]

ds_mskor_rtn_b64 v[5:6], v1, v[2:3], v[3:4] offset:65535 gds
// CHECK: [0xff,0xff,0xb2,0xd9,0x01,0x02,0x03,0x05]

ds_wrxchg_rtn_b64 v[5:6], v1, v[2:3] offset:65535
// CHECK: [0xff,0xff,0xb4,0xd9,0x01,0x02,0x00,0x05]

ds_wrxchg_rtn_b64 v[254:255], v1, v[2:3] offset:65535
// CHECK: [0xff,0xff,0xb4,0xd9,0x01,0x02,0x00,0xfe]

ds_wrxchg_rtn_b64 v[5:6], v255, v[2:3] offset:65535
// CHECK: [0xff,0xff,0xb4,0xd9,0xff,0x02,0x00,0x05]

ds_wrxchg_rtn_b64 v[5:6], v1, v[254:255] offset:65535
// CHECK: [0xff,0xff,0xb4,0xd9,0x01,0xfe,0x00,0x05]

ds_wrxchg_rtn_b64 v[5:6], v1, v[2:3]
// CHECK: [0x00,0x00,0xb4,0xd9,0x01,0x02,0x00,0x05]

ds_wrxchg_rtn_b64 v[5:6], v1, v[2:3] offset:0
// CHECK: [0x00,0x00,0xb4,0xd9,0x01,0x02,0x00,0x05]

ds_wrxchg_rtn_b64 v[5:6], v1, v[2:3] offset:4
// CHECK: [0x04,0x00,0xb4,0xd9,0x01,0x02,0x00,0x05]

ds_wrxchg_rtn_b64 v[5:6], v1, v[2:3] offset:65535 gds
// CHECK: [0xff,0xff,0xb6,0xd9,0x01,0x02,0x00,0x05]

ds_wrxchg2_rtn_b64 v[5:8], v1, v[2:3], v[3:4] offset0:127 offset1:255
// CHECK: [0x7f,0xff,0xb8,0xd9,0x01,0x02,0x03,0x05]

ds_wrxchg2_rtn_b64 v[252:255], v1, v[2:3], v[3:4] offset0:127 offset1:255
// CHECK: [0x7f,0xff,0xb8,0xd9,0x01,0x02,0x03,0xfc]

ds_wrxchg2_rtn_b64 v[5:8], v255, v[2:3], v[3:4] offset0:127 offset1:255
// CHECK: [0x7f,0xff,0xb8,0xd9,0xff,0x02,0x03,0x05]

ds_wrxchg2_rtn_b64 v[5:8], v1, v[254:255], v[3:4] offset0:127 offset1:255
// CHECK: [0x7f,0xff,0xb8,0xd9,0x01,0xfe,0x03,0x05]

ds_wrxchg2_rtn_b64 v[5:8], v1, v[2:3], v[254:255] offset0:127 offset1:255
// CHECK: [0x7f,0xff,0xb8,0xd9,0x01,0x02,0xfe,0x05]

ds_wrxchg2_rtn_b64 v[5:8], v1, v[2:3], v[3:4] offset1:255
// CHECK: [0x00,0xff,0xb8,0xd9,0x01,0x02,0x03,0x05]

ds_wrxchg2_rtn_b64 v[5:8], v1, v[2:3], v[3:4] offset0:0 offset1:255
// CHECK: [0x00,0xff,0xb8,0xd9,0x01,0x02,0x03,0x05]

ds_wrxchg2_rtn_b64 v[5:8], v1, v[2:3], v[3:4] offset0:16 offset1:255
// CHECK: [0x10,0xff,0xb8,0xd9,0x01,0x02,0x03,0x05]

ds_wrxchg2_rtn_b64 v[5:8], v1, v[2:3], v[3:4] offset0:127
// CHECK: [0x7f,0x00,0xb8,0xd9,0x01,0x02,0x03,0x05]

ds_wrxchg2_rtn_b64 v[5:8], v1, v[2:3], v[3:4] offset0:127 offset1:0
// CHECK: [0x7f,0x00,0xb8,0xd9,0x01,0x02,0x03,0x05]

ds_wrxchg2_rtn_b64 v[5:8], v1, v[2:3], v[3:4] offset0:127 offset1:1
// CHECK: [0x7f,0x01,0xb8,0xd9,0x01,0x02,0x03,0x05]

ds_wrxchg2_rtn_b64 v[5:8], v1, v[2:3], v[3:4] offset0:127 offset1:255 gds
// CHECK: [0x7f,0xff,0xba,0xd9,0x01,0x02,0x03,0x05]

ds_wrxchg2st64_rtn_b64 v[5:8], v1, v[2:3], v[3:4] offset0:127 offset1:255
// CHECK: [0x7f,0xff,0xbc,0xd9,0x01,0x02,0x03,0x05]

ds_wrxchg2st64_rtn_b64 v[252:255], v1, v[2:3], v[3:4] offset0:127 offset1:255
// CHECK: [0x7f,0xff,0xbc,0xd9,0x01,0x02,0x03,0xfc]

ds_wrxchg2st64_rtn_b64 v[5:8], v255, v[2:3], v[3:4] offset0:127 offset1:255
// CHECK: [0x7f,0xff,0xbc,0xd9,0xff,0x02,0x03,0x05]

ds_wrxchg2st64_rtn_b64 v[5:8], v1, v[254:255], v[3:4] offset0:127 offset1:255
// CHECK: [0x7f,0xff,0xbc,0xd9,0x01,0xfe,0x03,0x05]

ds_wrxchg2st64_rtn_b64 v[5:8], v1, v[2:3], v[254:255] offset0:127 offset1:255
// CHECK: [0x7f,0xff,0xbc,0xd9,0x01,0x02,0xfe,0x05]

ds_wrxchg2st64_rtn_b64 v[5:8], v1, v[2:3], v[3:4] offset1:255
// CHECK: [0x00,0xff,0xbc,0xd9,0x01,0x02,0x03,0x05]

ds_wrxchg2st64_rtn_b64 v[5:8], v1, v[2:3], v[3:4] offset0:0 offset1:255
// CHECK: [0x00,0xff,0xbc,0xd9,0x01,0x02,0x03,0x05]

ds_wrxchg2st64_rtn_b64 v[5:8], v1, v[2:3], v[3:4] offset0:16 offset1:255
// CHECK: [0x10,0xff,0xbc,0xd9,0x01,0x02,0x03,0x05]

ds_wrxchg2st64_rtn_b64 v[5:8], v1, v[2:3], v[3:4] offset0:127
// CHECK: [0x7f,0x00,0xbc,0xd9,0x01,0x02,0x03,0x05]

ds_wrxchg2st64_rtn_b64 v[5:8], v1, v[2:3], v[3:4] offset0:127 offset1:0
// CHECK: [0x7f,0x00,0xbc,0xd9,0x01,0x02,0x03,0x05]

ds_wrxchg2st64_rtn_b64 v[5:8], v1, v[2:3], v[3:4] offset0:127 offset1:1
// CHECK: [0x7f,0x01,0xbc,0xd9,0x01,0x02,0x03,0x05]

ds_wrxchg2st64_rtn_b64 v[5:8], v1, v[2:3], v[3:4] offset0:127 offset1:255 gds
// CHECK: [0x7f,0xff,0xbe,0xd9,0x01,0x02,0x03,0x05]

ds_cmpst_rtn_b64 v[5:6], v1, v[2:3], v[3:4] offset:65535
// CHECK: [0xff,0xff,0xc0,0xd9,0x01,0x02,0x03,0x05]

ds_cmpst_rtn_b64 v[254:255], v1, v[2:3], v[3:4] offset:65535
// CHECK: [0xff,0xff,0xc0,0xd9,0x01,0x02,0x03,0xfe]

ds_cmpst_rtn_b64 v[5:6], v255, v[2:3], v[3:4] offset:65535
// CHECK: [0xff,0xff,0xc0,0xd9,0xff,0x02,0x03,0x05]

ds_cmpst_rtn_b64 v[5:6], v1, v[254:255], v[3:4] offset:65535
// CHECK: [0xff,0xff,0xc0,0xd9,0x01,0xfe,0x03,0x05]

ds_cmpst_rtn_b64 v[5:6], v1, v[2:3], v[254:255] offset:65535
// CHECK: [0xff,0xff,0xc0,0xd9,0x01,0x02,0xfe,0x05]

ds_cmpst_rtn_b64 v[5:6], v1, v[2:3], v[3:4]
// CHECK: [0x00,0x00,0xc0,0xd9,0x01,0x02,0x03,0x05]

ds_cmpst_rtn_b64 v[5:6], v1, v[2:3], v[3:4] offset:0
// CHECK: [0x00,0x00,0xc0,0xd9,0x01,0x02,0x03,0x05]

ds_cmpst_rtn_b64 v[5:6], v1, v[2:3], v[3:4] offset:4
// CHECK: [0x04,0x00,0xc0,0xd9,0x01,0x02,0x03,0x05]

ds_cmpst_rtn_b64 v[5:6], v1, v[2:3], v[3:4] offset:65535 gds
// CHECK: [0xff,0xff,0xc2,0xd9,0x01,0x02,0x03,0x05]

ds_cmpst_rtn_f64 v[5:6], v1, v[2:3], v[3:4] offset:65535
// CHECK: [0xff,0xff,0xc4,0xd9,0x01,0x02,0x03,0x05]

ds_cmpst_rtn_f64 v[254:255], v1, v[2:3], v[3:4] offset:65535
// CHECK: [0xff,0xff,0xc4,0xd9,0x01,0x02,0x03,0xfe]

ds_cmpst_rtn_f64 v[5:6], v255, v[2:3], v[3:4] offset:65535
// CHECK: [0xff,0xff,0xc4,0xd9,0xff,0x02,0x03,0x05]

ds_cmpst_rtn_f64 v[5:6], v1, v[254:255], v[3:4] offset:65535
// CHECK: [0xff,0xff,0xc4,0xd9,0x01,0xfe,0x03,0x05]

ds_cmpst_rtn_f64 v[5:6], v1, v[2:3], v[254:255] offset:65535
// CHECK: [0xff,0xff,0xc4,0xd9,0x01,0x02,0xfe,0x05]

ds_cmpst_rtn_f64 v[5:6], v1, v[2:3], v[3:4]
// CHECK: [0x00,0x00,0xc4,0xd9,0x01,0x02,0x03,0x05]

ds_cmpst_rtn_f64 v[5:6], v1, v[2:3], v[3:4] offset:0
// CHECK: [0x00,0x00,0xc4,0xd9,0x01,0x02,0x03,0x05]

ds_cmpst_rtn_f64 v[5:6], v1, v[2:3], v[3:4] offset:4
// CHECK: [0x04,0x00,0xc4,0xd9,0x01,0x02,0x03,0x05]

ds_cmpst_rtn_f64 v[5:6], v1, v[2:3], v[3:4] offset:65535 gds
// CHECK: [0xff,0xff,0xc6,0xd9,0x01,0x02,0x03,0x05]

ds_min_rtn_f64 v[5:6], v1, v[2:3] offset:65535
// CHECK: [0xff,0xff,0xc8,0xd9,0x01,0x02,0x00,0x05]

ds_min_rtn_f64 v[254:255], v1, v[2:3] offset:65535
// CHECK: [0xff,0xff,0xc8,0xd9,0x01,0x02,0x00,0xfe]

ds_min_rtn_f64 v[5:6], v255, v[2:3] offset:65535
// CHECK: [0xff,0xff,0xc8,0xd9,0xff,0x02,0x00,0x05]

ds_min_rtn_f64 v[5:6], v1, v[254:255] offset:65535
// CHECK: [0xff,0xff,0xc8,0xd9,0x01,0xfe,0x00,0x05]

ds_min_rtn_f64 v[5:6], v1, v[2:3]
// CHECK: [0x00,0x00,0xc8,0xd9,0x01,0x02,0x00,0x05]

ds_min_rtn_f64 v[5:6], v1, v[2:3] offset:0
// CHECK: [0x00,0x00,0xc8,0xd9,0x01,0x02,0x00,0x05]

ds_min_rtn_f64 v[5:6], v1, v[2:3] offset:4
// CHECK: [0x04,0x00,0xc8,0xd9,0x01,0x02,0x00,0x05]

ds_min_rtn_f64 v[5:6], v1, v[2:3] offset:65535 gds
// CHECK: [0xff,0xff,0xca,0xd9,0x01,0x02,0x00,0x05]

ds_max_rtn_f64 v[5:6], v1, v[2:3] offset:65535
// CHECK: [0xff,0xff,0xcc,0xd9,0x01,0x02,0x00,0x05]

ds_max_rtn_f64 v[254:255], v1, v[2:3] offset:65535
// CHECK: [0xff,0xff,0xcc,0xd9,0x01,0x02,0x00,0xfe]

ds_max_rtn_f64 v[5:6], v255, v[2:3] offset:65535
// CHECK: [0xff,0xff,0xcc,0xd9,0xff,0x02,0x00,0x05]

ds_max_rtn_f64 v[5:6], v1, v[254:255] offset:65535
// CHECK: [0xff,0xff,0xcc,0xd9,0x01,0xfe,0x00,0x05]

ds_max_rtn_f64 v[5:6], v1, v[2:3]
// CHECK: [0x00,0x00,0xcc,0xd9,0x01,0x02,0x00,0x05]

ds_max_rtn_f64 v[5:6], v1, v[2:3] offset:0
// CHECK: [0x00,0x00,0xcc,0xd9,0x01,0x02,0x00,0x05]

ds_max_rtn_f64 v[5:6], v1, v[2:3] offset:4
// CHECK: [0x04,0x00,0xcc,0xd9,0x01,0x02,0x00,0x05]

ds_max_rtn_f64 v[5:6], v1, v[2:3] offset:65535 gds
// CHECK: [0xff,0xff,0xce,0xd9,0x01,0x02,0x00,0x05]

ds_read_b64 v[5:6], v1 offset:65535
// CHECK: [0xff,0xff,0xd8,0xd9,0x01,0x00,0x00,0x05]

ds_read_b64 v[254:255], v1 offset:65535
// CHECK: [0xff,0xff,0xd8,0xd9,0x01,0x00,0x00,0xfe]

ds_read_b64 v[5:6], v255 offset:65535
// CHECK: [0xff,0xff,0xd8,0xd9,0xff,0x00,0x00,0x05]

ds_read_b64 v[5:6], v1
// CHECK: [0x00,0x00,0xd8,0xd9,0x01,0x00,0x00,0x05]

ds_read_b64 v[5:6], v1 offset:0
// CHECK: [0x00,0x00,0xd8,0xd9,0x01,0x00,0x00,0x05]

ds_read_b64 v[5:6], v1 offset:4
// CHECK: [0x04,0x00,0xd8,0xd9,0x01,0x00,0x00,0x05]

ds_read_b64 v[5:6], v1 offset:65535 gds
// CHECK: [0xff,0xff,0xda,0xd9,0x01,0x00,0x00,0x05]

ds_read2_b64 v[5:8], v1 offset0:127 offset1:255
// CHECK: [0x7f,0xff,0xdc,0xd9,0x01,0x00,0x00,0x05]

ds_read2_b64 v[252:255], v1 offset0:127 offset1:255
// CHECK: [0x7f,0xff,0xdc,0xd9,0x01,0x00,0x00,0xfc]

ds_read2_b64 v[5:8], v255 offset0:127 offset1:255
// CHECK: [0x7f,0xff,0xdc,0xd9,0xff,0x00,0x00,0x05]

ds_read2_b64 v[5:8], v1 offset1:255
// CHECK: [0x00,0xff,0xdc,0xd9,0x01,0x00,0x00,0x05]

ds_read2_b64 v[5:8], v1 offset0:0 offset1:255
// CHECK: [0x00,0xff,0xdc,0xd9,0x01,0x00,0x00,0x05]

ds_read2_b64 v[5:8], v1 offset0:16 offset1:255
// CHECK: [0x10,0xff,0xdc,0xd9,0x01,0x00,0x00,0x05]

ds_read2_b64 v[5:8], v1 offset0:127
// CHECK: [0x7f,0x00,0xdc,0xd9,0x01,0x00,0x00,0x05]

ds_read2_b64 v[5:8], v1 offset0:127 offset1:0
// CHECK: [0x7f,0x00,0xdc,0xd9,0x01,0x00,0x00,0x05]

ds_read2_b64 v[5:8], v1 offset0:127 offset1:1
// CHECK: [0x7f,0x01,0xdc,0xd9,0x01,0x00,0x00,0x05]

ds_read2_b64 v[5:8], v1 offset0:127 offset1:255 gds
// CHECK: [0x7f,0xff,0xde,0xd9,0x01,0x00,0x00,0x05]

ds_read2st64_b64 v[5:8], v1 offset0:127 offset1:255
// CHECK: [0x7f,0xff,0xe0,0xd9,0x01,0x00,0x00,0x05]

ds_read2st64_b64 v[252:255], v1 offset0:127 offset1:255
// CHECK: [0x7f,0xff,0xe0,0xd9,0x01,0x00,0x00,0xfc]

ds_read2st64_b64 v[5:8], v255 offset0:127 offset1:255
// CHECK: [0x7f,0xff,0xe0,0xd9,0xff,0x00,0x00,0x05]

ds_read2st64_b64 v[5:8], v1 offset1:255
// CHECK: [0x00,0xff,0xe0,0xd9,0x01,0x00,0x00,0x05]

ds_read2st64_b64 v[5:8], v1 offset0:0 offset1:255
// CHECK: [0x00,0xff,0xe0,0xd9,0x01,0x00,0x00,0x05]

ds_read2st64_b64 v[5:8], v1 offset0:16 offset1:255
// CHECK: [0x10,0xff,0xe0,0xd9,0x01,0x00,0x00,0x05]

ds_read2st64_b64 v[5:8], v1 offset0:127
// CHECK: [0x7f,0x00,0xe0,0xd9,0x01,0x00,0x00,0x05]

ds_read2st64_b64 v[5:8], v1 offset0:127 offset1:0
// CHECK: [0x7f,0x00,0xe0,0xd9,0x01,0x00,0x00,0x05]

ds_read2st64_b64 v[5:8], v1 offset0:127 offset1:1
// CHECK: [0x7f,0x01,0xe0,0xd9,0x01,0x00,0x00,0x05]

ds_read2st64_b64 v[5:8], v1 offset0:127 offset1:255 gds
// CHECK: [0x7f,0xff,0xe2,0xd9,0x01,0x00,0x00,0x05]

ds_condxchg32_rtn_b64 v[5:6], v1, v[2:3] offset:65535
// CHECK: [0xff,0xff,0xf8,0xd9,0x01,0x02,0x00,0x05]

ds_condxchg32_rtn_b64 v[254:255], v1, v[2:3] offset:65535
// CHECK: [0xff,0xff,0xf8,0xd9,0x01,0x02,0x00,0xfe]

ds_condxchg32_rtn_b64 v[5:6], v255, v[2:3] offset:65535
// CHECK: [0xff,0xff,0xf8,0xd9,0xff,0x02,0x00,0x05]

ds_condxchg32_rtn_b64 v[5:6], v1, v[254:255] offset:65535
// CHECK: [0xff,0xff,0xf8,0xd9,0x01,0xfe,0x00,0x05]

ds_condxchg32_rtn_b64 v[5:6], v1, v[2:3]
// CHECK: [0x00,0x00,0xf8,0xd9,0x01,0x02,0x00,0x05]

ds_condxchg32_rtn_b64 v[5:6], v1, v[2:3] offset:0
// CHECK: [0x00,0x00,0xf8,0xd9,0x01,0x02,0x00,0x05]

ds_condxchg32_rtn_b64 v[5:6], v1, v[2:3] offset:4
// CHECK: [0x04,0x00,0xf8,0xd9,0x01,0x02,0x00,0x05]

ds_condxchg32_rtn_b64 v[5:6], v1, v[2:3] offset:65535 gds
// CHECK: [0xff,0xff,0xfa,0xd9,0x01,0x02,0x00,0x05]

ds_add_src2_u32 v1 offset:65535
// CHECK: [0xff,0xff,0x00,0xda,0x01,0x00,0x00,0x00]

ds_add_src2_u32 v255 offset:65535
// CHECK: [0xff,0xff,0x00,0xda,0xff,0x00,0x00,0x00]

ds_add_src2_u32 v1
// CHECK: [0x00,0x00,0x00,0xda,0x01,0x00,0x00,0x00]

ds_add_src2_u32 v1 offset:0
// CHECK: [0x00,0x00,0x00,0xda,0x01,0x00,0x00,0x00]

ds_add_src2_u32 v1 offset:4
// CHECK: [0x04,0x00,0x00,0xda,0x01,0x00,0x00,0x00]

ds_add_src2_u32 v1 offset:65535 gds
// CHECK: [0xff,0xff,0x02,0xda,0x01,0x00,0x00,0x00]

ds_sub_src2_u32 v1 offset:65535
// CHECK: [0xff,0xff,0x04,0xda,0x01,0x00,0x00,0x00]

ds_sub_src2_u32 v255 offset:65535
// CHECK: [0xff,0xff,0x04,0xda,0xff,0x00,0x00,0x00]

ds_sub_src2_u32 v1
// CHECK: [0x00,0x00,0x04,0xda,0x01,0x00,0x00,0x00]

ds_sub_src2_u32 v1 offset:0
// CHECK: [0x00,0x00,0x04,0xda,0x01,0x00,0x00,0x00]

ds_sub_src2_u32 v1 offset:4
// CHECK: [0x04,0x00,0x04,0xda,0x01,0x00,0x00,0x00]

ds_sub_src2_u32 v1 offset:65535 gds
// CHECK: [0xff,0xff,0x06,0xda,0x01,0x00,0x00,0x00]

ds_rsub_src2_u32 v1 offset:65535
// CHECK: [0xff,0xff,0x08,0xda,0x01,0x00,0x00,0x00]

ds_rsub_src2_u32 v255 offset:65535
// CHECK: [0xff,0xff,0x08,0xda,0xff,0x00,0x00,0x00]

ds_rsub_src2_u32 v1
// CHECK: [0x00,0x00,0x08,0xda,0x01,0x00,0x00,0x00]

ds_rsub_src2_u32 v1 offset:0
// CHECK: [0x00,0x00,0x08,0xda,0x01,0x00,0x00,0x00]

ds_rsub_src2_u32 v1 offset:4
// CHECK: [0x04,0x00,0x08,0xda,0x01,0x00,0x00,0x00]

ds_rsub_src2_u32 v1 offset:65535 gds
// CHECK: [0xff,0xff,0x0a,0xda,0x01,0x00,0x00,0x00]

ds_inc_src2_u32 v1 offset:65535
// CHECK: [0xff,0xff,0x0c,0xda,0x01,0x00,0x00,0x00]

ds_inc_src2_u32 v255 offset:65535
// CHECK: [0xff,0xff,0x0c,0xda,0xff,0x00,0x00,0x00]

ds_inc_src2_u32 v1
// CHECK: [0x00,0x00,0x0c,0xda,0x01,0x00,0x00,0x00]

ds_inc_src2_u32 v1 offset:0
// CHECK: [0x00,0x00,0x0c,0xda,0x01,0x00,0x00,0x00]

ds_inc_src2_u32 v1 offset:4
// CHECK: [0x04,0x00,0x0c,0xda,0x01,0x00,0x00,0x00]

ds_inc_src2_u32 v1 offset:65535 gds
// CHECK: [0xff,0xff,0x0e,0xda,0x01,0x00,0x00,0x00]

ds_dec_src2_u32 v1 offset:65535
// CHECK: [0xff,0xff,0x10,0xda,0x01,0x00,0x00,0x00]

ds_dec_src2_u32 v255 offset:65535
// CHECK: [0xff,0xff,0x10,0xda,0xff,0x00,0x00,0x00]

ds_dec_src2_u32 v1
// CHECK: [0x00,0x00,0x10,0xda,0x01,0x00,0x00,0x00]

ds_dec_src2_u32 v1 offset:0
// CHECK: [0x00,0x00,0x10,0xda,0x01,0x00,0x00,0x00]

ds_dec_src2_u32 v1 offset:4
// CHECK: [0x04,0x00,0x10,0xda,0x01,0x00,0x00,0x00]

ds_dec_src2_u32 v1 offset:65535 gds
// CHECK: [0xff,0xff,0x12,0xda,0x01,0x00,0x00,0x00]

ds_min_src2_i32 v1 offset:65535
// CHECK: [0xff,0xff,0x14,0xda,0x01,0x00,0x00,0x00]

ds_min_src2_i32 v255 offset:65535
// CHECK: [0xff,0xff,0x14,0xda,0xff,0x00,0x00,0x00]

ds_min_src2_i32 v1
// CHECK: [0x00,0x00,0x14,0xda,0x01,0x00,0x00,0x00]

ds_min_src2_i32 v1 offset:0
// CHECK: [0x00,0x00,0x14,0xda,0x01,0x00,0x00,0x00]

ds_min_src2_i32 v1 offset:4
// CHECK: [0x04,0x00,0x14,0xda,0x01,0x00,0x00,0x00]

ds_min_src2_i32 v1 offset:65535 gds
// CHECK: [0xff,0xff,0x16,0xda,0x01,0x00,0x00,0x00]

ds_max_src2_i32 v1 offset:65535
// CHECK: [0xff,0xff,0x18,0xda,0x01,0x00,0x00,0x00]

ds_max_src2_i32 v255 offset:65535
// CHECK: [0xff,0xff,0x18,0xda,0xff,0x00,0x00,0x00]

ds_max_src2_i32 v1
// CHECK: [0x00,0x00,0x18,0xda,0x01,0x00,0x00,0x00]

ds_max_src2_i32 v1 offset:0
// CHECK: [0x00,0x00,0x18,0xda,0x01,0x00,0x00,0x00]

ds_max_src2_i32 v1 offset:4
// CHECK: [0x04,0x00,0x18,0xda,0x01,0x00,0x00,0x00]

ds_max_src2_i32 v1 offset:65535 gds
// CHECK: [0xff,0xff,0x1a,0xda,0x01,0x00,0x00,0x00]

ds_min_src2_u32 v1 offset:65535
// CHECK: [0xff,0xff,0x1c,0xda,0x01,0x00,0x00,0x00]

ds_min_src2_u32 v255 offset:65535
// CHECK: [0xff,0xff,0x1c,0xda,0xff,0x00,0x00,0x00]

ds_min_src2_u32 v1
// CHECK: [0x00,0x00,0x1c,0xda,0x01,0x00,0x00,0x00]

ds_min_src2_u32 v1 offset:0
// CHECK: [0x00,0x00,0x1c,0xda,0x01,0x00,0x00,0x00]

ds_min_src2_u32 v1 offset:4
// CHECK: [0x04,0x00,0x1c,0xda,0x01,0x00,0x00,0x00]

ds_min_src2_u32 v1 offset:65535 gds
// CHECK: [0xff,0xff,0x1e,0xda,0x01,0x00,0x00,0x00]

ds_max_src2_u32 v1 offset:65535
// CHECK: [0xff,0xff,0x20,0xda,0x01,0x00,0x00,0x00]

ds_max_src2_u32 v255 offset:65535
// CHECK: [0xff,0xff,0x20,0xda,0xff,0x00,0x00,0x00]

ds_max_src2_u32 v1
// CHECK: [0x00,0x00,0x20,0xda,0x01,0x00,0x00,0x00]

ds_max_src2_u32 v1 offset:0
// CHECK: [0x00,0x00,0x20,0xda,0x01,0x00,0x00,0x00]

ds_max_src2_u32 v1 offset:4
// CHECK: [0x04,0x00,0x20,0xda,0x01,0x00,0x00,0x00]

ds_max_src2_u32 v1 offset:65535 gds
// CHECK: [0xff,0xff,0x22,0xda,0x01,0x00,0x00,0x00]

ds_and_src2_b32 v1 offset:65535
// CHECK: [0xff,0xff,0x24,0xda,0x01,0x00,0x00,0x00]

ds_and_src2_b32 v255 offset:65535
// CHECK: [0xff,0xff,0x24,0xda,0xff,0x00,0x00,0x00]

ds_and_src2_b32 v1
// CHECK: [0x00,0x00,0x24,0xda,0x01,0x00,0x00,0x00]

ds_and_src2_b32 v1 offset:0
// CHECK: [0x00,0x00,0x24,0xda,0x01,0x00,0x00,0x00]

ds_and_src2_b32 v1 offset:4
// CHECK: [0x04,0x00,0x24,0xda,0x01,0x00,0x00,0x00]

ds_and_src2_b32 v1 offset:65535 gds
// CHECK: [0xff,0xff,0x26,0xda,0x01,0x00,0x00,0x00]

ds_or_src2_b32 v1 offset:65535
// CHECK: [0xff,0xff,0x28,0xda,0x01,0x00,0x00,0x00]

ds_or_src2_b32 v255 offset:65535
// CHECK: [0xff,0xff,0x28,0xda,0xff,0x00,0x00,0x00]

ds_or_src2_b32 v1
// CHECK: [0x00,0x00,0x28,0xda,0x01,0x00,0x00,0x00]

ds_or_src2_b32 v1 offset:0
// CHECK: [0x00,0x00,0x28,0xda,0x01,0x00,0x00,0x00]

ds_or_src2_b32 v1 offset:4
// CHECK: [0x04,0x00,0x28,0xda,0x01,0x00,0x00,0x00]

ds_or_src2_b32 v1 offset:65535 gds
// CHECK: [0xff,0xff,0x2a,0xda,0x01,0x00,0x00,0x00]

ds_xor_src2_b32 v1 offset:65535
// CHECK: [0xff,0xff,0x2c,0xda,0x01,0x00,0x00,0x00]

ds_xor_src2_b32 v255 offset:65535
// CHECK: [0xff,0xff,0x2c,0xda,0xff,0x00,0x00,0x00]

ds_xor_src2_b32 v1
// CHECK: [0x00,0x00,0x2c,0xda,0x01,0x00,0x00,0x00]

ds_xor_src2_b32 v1 offset:0
// CHECK: [0x00,0x00,0x2c,0xda,0x01,0x00,0x00,0x00]

ds_xor_src2_b32 v1 offset:4
// CHECK: [0x04,0x00,0x2c,0xda,0x01,0x00,0x00,0x00]

ds_xor_src2_b32 v1 offset:65535 gds
// CHECK: [0xff,0xff,0x2e,0xda,0x01,0x00,0x00,0x00]

ds_write_src2_b32 v1 offset:65535
// CHECK: [0xff,0xff,0x34,0xda,0x01,0x00,0x00,0x00]

ds_write_src2_b32 v255 offset:65535
// CHECK: [0xff,0xff,0x34,0xda,0xff,0x00,0x00,0x00]

ds_write_src2_b32 v1
// CHECK: [0x00,0x00,0x34,0xda,0x01,0x00,0x00,0x00]

ds_write_src2_b32 v1 offset:0
// CHECK: [0x00,0x00,0x34,0xda,0x01,0x00,0x00,0x00]

ds_write_src2_b32 v1 offset:4
// CHECK: [0x04,0x00,0x34,0xda,0x01,0x00,0x00,0x00]

ds_write_src2_b32 v1 offset:65535 gds
// CHECK: [0xff,0xff,0x36,0xda,0x01,0x00,0x00,0x00]

ds_min_src2_f32 v1 offset:65535
// CHECK: [0xff,0xff,0x48,0xda,0x01,0x00,0x00,0x00]

ds_min_src2_f32 v255 offset:65535
// CHECK: [0xff,0xff,0x48,0xda,0xff,0x00,0x00,0x00]

ds_min_src2_f32 v1
// CHECK: [0x00,0x00,0x48,0xda,0x01,0x00,0x00,0x00]

ds_min_src2_f32 v1 offset:0
// CHECK: [0x00,0x00,0x48,0xda,0x01,0x00,0x00,0x00]

ds_min_src2_f32 v1 offset:4
// CHECK: [0x04,0x00,0x48,0xda,0x01,0x00,0x00,0x00]

ds_min_src2_f32 v1 offset:65535 gds
// CHECK: [0xff,0xff,0x4a,0xda,0x01,0x00,0x00,0x00]

ds_max_src2_f32 v1 offset:65535
// CHECK: [0xff,0xff,0x4c,0xda,0x01,0x00,0x00,0x00]

ds_max_src2_f32 v255 offset:65535
// CHECK: [0xff,0xff,0x4c,0xda,0xff,0x00,0x00,0x00]

ds_max_src2_f32 v1
// CHECK: [0x00,0x00,0x4c,0xda,0x01,0x00,0x00,0x00]

ds_max_src2_f32 v1 offset:0
// CHECK: [0x00,0x00,0x4c,0xda,0x01,0x00,0x00,0x00]

ds_max_src2_f32 v1 offset:4
// CHECK: [0x04,0x00,0x4c,0xda,0x01,0x00,0x00,0x00]

ds_max_src2_f32 v1 offset:65535 gds
// CHECK: [0xff,0xff,0x4e,0xda,0x01,0x00,0x00,0x00]

ds_add_src2_u64 v1 offset:65535
// CHECK: [0xff,0xff,0x00,0xdb,0x01,0x00,0x00,0x00]

ds_add_src2_u64 v255 offset:65535
// CHECK: [0xff,0xff,0x00,0xdb,0xff,0x00,0x00,0x00]

ds_add_src2_u64 v1
// CHECK: [0x00,0x00,0x00,0xdb,0x01,0x00,0x00,0x00]

ds_add_src2_u64 v1 offset:0
// CHECK: [0x00,0x00,0x00,0xdb,0x01,0x00,0x00,0x00]

ds_add_src2_u64 v1 offset:4
// CHECK: [0x04,0x00,0x00,0xdb,0x01,0x00,0x00,0x00]

ds_add_src2_u64 v1 offset:65535 gds
// CHECK: [0xff,0xff,0x02,0xdb,0x01,0x00,0x00,0x00]

ds_sub_src2_u64 v1 offset:65535
// CHECK: [0xff,0xff,0x04,0xdb,0x01,0x00,0x00,0x00]

ds_sub_src2_u64 v255 offset:65535
// CHECK: [0xff,0xff,0x04,0xdb,0xff,0x00,0x00,0x00]

ds_sub_src2_u64 v1
// CHECK: [0x00,0x00,0x04,0xdb,0x01,0x00,0x00,0x00]

ds_sub_src2_u64 v1 offset:0
// CHECK: [0x00,0x00,0x04,0xdb,0x01,0x00,0x00,0x00]

ds_sub_src2_u64 v1 offset:4
// CHECK: [0x04,0x00,0x04,0xdb,0x01,0x00,0x00,0x00]

ds_sub_src2_u64 v1 offset:65535 gds
// CHECK: [0xff,0xff,0x06,0xdb,0x01,0x00,0x00,0x00]

ds_rsub_src2_u64 v1 offset:65535
// CHECK: [0xff,0xff,0x08,0xdb,0x01,0x00,0x00,0x00]

ds_rsub_src2_u64 v255 offset:65535
// CHECK: [0xff,0xff,0x08,0xdb,0xff,0x00,0x00,0x00]

ds_rsub_src2_u64 v1
// CHECK: [0x00,0x00,0x08,0xdb,0x01,0x00,0x00,0x00]

ds_rsub_src2_u64 v1 offset:0
// CHECK: [0x00,0x00,0x08,0xdb,0x01,0x00,0x00,0x00]

ds_rsub_src2_u64 v1 offset:4
// CHECK: [0x04,0x00,0x08,0xdb,0x01,0x00,0x00,0x00]

ds_rsub_src2_u64 v1 offset:65535 gds
// CHECK: [0xff,0xff,0x0a,0xdb,0x01,0x00,0x00,0x00]

ds_inc_src2_u64 v1 offset:65535
// CHECK: [0xff,0xff,0x0c,0xdb,0x01,0x00,0x00,0x00]

ds_inc_src2_u64 v255 offset:65535
// CHECK: [0xff,0xff,0x0c,0xdb,0xff,0x00,0x00,0x00]

ds_inc_src2_u64 v1
// CHECK: [0x00,0x00,0x0c,0xdb,0x01,0x00,0x00,0x00]

ds_inc_src2_u64 v1 offset:0
// CHECK: [0x00,0x00,0x0c,0xdb,0x01,0x00,0x00,0x00]

ds_inc_src2_u64 v1 offset:4
// CHECK: [0x04,0x00,0x0c,0xdb,0x01,0x00,0x00,0x00]

ds_inc_src2_u64 v1 offset:65535 gds
// CHECK: [0xff,0xff,0x0e,0xdb,0x01,0x00,0x00,0x00]

ds_dec_src2_u64 v1 offset:65535
// CHECK: [0xff,0xff,0x10,0xdb,0x01,0x00,0x00,0x00]

ds_dec_src2_u64 v255 offset:65535
// CHECK: [0xff,0xff,0x10,0xdb,0xff,0x00,0x00,0x00]

ds_dec_src2_u64 v1
// CHECK: [0x00,0x00,0x10,0xdb,0x01,0x00,0x00,0x00]

ds_dec_src2_u64 v1 offset:0
// CHECK: [0x00,0x00,0x10,0xdb,0x01,0x00,0x00,0x00]

ds_dec_src2_u64 v1 offset:4
// CHECK: [0x04,0x00,0x10,0xdb,0x01,0x00,0x00,0x00]

ds_dec_src2_u64 v1 offset:65535 gds
// CHECK: [0xff,0xff,0x12,0xdb,0x01,0x00,0x00,0x00]

ds_min_src2_i64 v1 offset:65535
// CHECK: [0xff,0xff,0x14,0xdb,0x01,0x00,0x00,0x00]

ds_min_src2_i64 v255 offset:65535
// CHECK: [0xff,0xff,0x14,0xdb,0xff,0x00,0x00,0x00]

ds_min_src2_i64 v1
// CHECK: [0x00,0x00,0x14,0xdb,0x01,0x00,0x00,0x00]

ds_min_src2_i64 v1 offset:0
// CHECK: [0x00,0x00,0x14,0xdb,0x01,0x00,0x00,0x00]

ds_min_src2_i64 v1 offset:4
// CHECK: [0x04,0x00,0x14,0xdb,0x01,0x00,0x00,0x00]

ds_min_src2_i64 v1 offset:65535 gds
// CHECK: [0xff,0xff,0x16,0xdb,0x01,0x00,0x00,0x00]

ds_max_src2_i64 v1 offset:65535
// CHECK: [0xff,0xff,0x18,0xdb,0x01,0x00,0x00,0x00]

ds_max_src2_i64 v255 offset:65535
// CHECK: [0xff,0xff,0x18,0xdb,0xff,0x00,0x00,0x00]

ds_max_src2_i64 v1
// CHECK: [0x00,0x00,0x18,0xdb,0x01,0x00,0x00,0x00]

ds_max_src2_i64 v1 offset:0
// CHECK: [0x00,0x00,0x18,0xdb,0x01,0x00,0x00,0x00]

ds_max_src2_i64 v1 offset:4
// CHECK: [0x04,0x00,0x18,0xdb,0x01,0x00,0x00,0x00]

ds_max_src2_i64 v1 offset:65535 gds
// CHECK: [0xff,0xff,0x1a,0xdb,0x01,0x00,0x00,0x00]

ds_min_src2_u64 v1 offset:65535
// CHECK: [0xff,0xff,0x1c,0xdb,0x01,0x00,0x00,0x00]

ds_min_src2_u64 v255 offset:65535
// CHECK: [0xff,0xff,0x1c,0xdb,0xff,0x00,0x00,0x00]

ds_min_src2_u64 v1
// CHECK: [0x00,0x00,0x1c,0xdb,0x01,0x00,0x00,0x00]

ds_min_src2_u64 v1 offset:0
// CHECK: [0x00,0x00,0x1c,0xdb,0x01,0x00,0x00,0x00]

ds_min_src2_u64 v1 offset:4
// CHECK: [0x04,0x00,0x1c,0xdb,0x01,0x00,0x00,0x00]

ds_min_src2_u64 v1 offset:65535 gds
// CHECK: [0xff,0xff,0x1e,0xdb,0x01,0x00,0x00,0x00]

ds_max_src2_u64 v1 offset:65535
// CHECK: [0xff,0xff,0x20,0xdb,0x01,0x00,0x00,0x00]

ds_max_src2_u64 v255 offset:65535
// CHECK: [0xff,0xff,0x20,0xdb,0xff,0x00,0x00,0x00]

ds_max_src2_u64 v1
// CHECK: [0x00,0x00,0x20,0xdb,0x01,0x00,0x00,0x00]

ds_max_src2_u64 v1 offset:0
// CHECK: [0x00,0x00,0x20,0xdb,0x01,0x00,0x00,0x00]

ds_max_src2_u64 v1 offset:4
// CHECK: [0x04,0x00,0x20,0xdb,0x01,0x00,0x00,0x00]

ds_max_src2_u64 v1 offset:65535 gds
// CHECK: [0xff,0xff,0x22,0xdb,0x01,0x00,0x00,0x00]

ds_and_src2_b64 v1 offset:65535
// CHECK: [0xff,0xff,0x24,0xdb,0x01,0x00,0x00,0x00]

ds_and_src2_b64 v255 offset:65535
// CHECK: [0xff,0xff,0x24,0xdb,0xff,0x00,0x00,0x00]

ds_and_src2_b64 v1
// CHECK: [0x00,0x00,0x24,0xdb,0x01,0x00,0x00,0x00]

ds_and_src2_b64 v1 offset:0
// CHECK: [0x00,0x00,0x24,0xdb,0x01,0x00,0x00,0x00]

ds_and_src2_b64 v1 offset:4
// CHECK: [0x04,0x00,0x24,0xdb,0x01,0x00,0x00,0x00]

ds_and_src2_b64 v1 offset:65535 gds
// CHECK: [0xff,0xff,0x26,0xdb,0x01,0x00,0x00,0x00]

ds_or_src2_b64 v1 offset:65535
// CHECK: [0xff,0xff,0x28,0xdb,0x01,0x00,0x00,0x00]

ds_or_src2_b64 v255 offset:65535
// CHECK: [0xff,0xff,0x28,0xdb,0xff,0x00,0x00,0x00]

ds_or_src2_b64 v1
// CHECK: [0x00,0x00,0x28,0xdb,0x01,0x00,0x00,0x00]

ds_or_src2_b64 v1 offset:0
// CHECK: [0x00,0x00,0x28,0xdb,0x01,0x00,0x00,0x00]

ds_or_src2_b64 v1 offset:4
// CHECK: [0x04,0x00,0x28,0xdb,0x01,0x00,0x00,0x00]

ds_or_src2_b64 v1 offset:65535 gds
// CHECK: [0xff,0xff,0x2a,0xdb,0x01,0x00,0x00,0x00]

ds_xor_src2_b64 v1 offset:65535
// CHECK: [0xff,0xff,0x2c,0xdb,0x01,0x00,0x00,0x00]

ds_xor_src2_b64 v255 offset:65535
// CHECK: [0xff,0xff,0x2c,0xdb,0xff,0x00,0x00,0x00]

ds_xor_src2_b64 v1
// CHECK: [0x00,0x00,0x2c,0xdb,0x01,0x00,0x00,0x00]

ds_xor_src2_b64 v1 offset:0
// CHECK: [0x00,0x00,0x2c,0xdb,0x01,0x00,0x00,0x00]

ds_xor_src2_b64 v1 offset:4
// CHECK: [0x04,0x00,0x2c,0xdb,0x01,0x00,0x00,0x00]

ds_xor_src2_b64 v1 offset:65535 gds
// CHECK: [0xff,0xff,0x2e,0xdb,0x01,0x00,0x00,0x00]

ds_write_src2_b64 v1 offset:65535
// CHECK: [0xff,0xff,0x34,0xdb,0x01,0x00,0x00,0x00]

ds_write_src2_b64 v255 offset:65535
// CHECK: [0xff,0xff,0x34,0xdb,0xff,0x00,0x00,0x00]

ds_write_src2_b64 v1
// CHECK: [0x00,0x00,0x34,0xdb,0x01,0x00,0x00,0x00]

ds_write_src2_b64 v1 offset:0
// CHECK: [0x00,0x00,0x34,0xdb,0x01,0x00,0x00,0x00]

ds_write_src2_b64 v1 offset:4
// CHECK: [0x04,0x00,0x34,0xdb,0x01,0x00,0x00,0x00]

ds_write_src2_b64 v1 offset:65535 gds
// CHECK: [0xff,0xff,0x36,0xdb,0x01,0x00,0x00,0x00]

ds_min_src2_f64 v1 offset:65535
// CHECK: [0xff,0xff,0x48,0xdb,0x01,0x00,0x00,0x00]

ds_min_src2_f64 v255 offset:65535
// CHECK: [0xff,0xff,0x48,0xdb,0xff,0x00,0x00,0x00]

ds_min_src2_f64 v1
// CHECK: [0x00,0x00,0x48,0xdb,0x01,0x00,0x00,0x00]

ds_min_src2_f64 v1 offset:0
// CHECK: [0x00,0x00,0x48,0xdb,0x01,0x00,0x00,0x00]

ds_min_src2_f64 v1 offset:4
// CHECK: [0x04,0x00,0x48,0xdb,0x01,0x00,0x00,0x00]

ds_min_src2_f64 v1 offset:65535 gds
// CHECK: [0xff,0xff,0x4a,0xdb,0x01,0x00,0x00,0x00]

ds_max_src2_f64 v1 offset:65535
// CHECK: [0xff,0xff,0x4c,0xdb,0x01,0x00,0x00,0x00]

ds_max_src2_f64 v255 offset:65535
// CHECK: [0xff,0xff,0x4c,0xdb,0xff,0x00,0x00,0x00]

ds_max_src2_f64 v1
// CHECK: [0x00,0x00,0x4c,0xdb,0x01,0x00,0x00,0x00]

ds_max_src2_f64 v1 offset:0
// CHECK: [0x00,0x00,0x4c,0xdb,0x01,0x00,0x00,0x00]

ds_max_src2_f64 v1 offset:4
// CHECK: [0x04,0x00,0x4c,0xdb,0x01,0x00,0x00,0x00]

ds_max_src2_f64 v1 offset:65535 gds
// CHECK: [0xff,0xff,0x4e,0xdb,0x01,0x00,0x00,0x00]

ds_write_b96 v1, v[2:4] offset:65535
// CHECK: [0xff,0xff,0x78,0xdb,0x01,0x02,0x00,0x00]

ds_write_b96 v255, v[2:4] offset:65535
// CHECK: [0xff,0xff,0x78,0xdb,0xff,0x02,0x00,0x00]

ds_write_b96 v1, v[253:255] offset:65535
// CHECK: [0xff,0xff,0x78,0xdb,0x01,0xfd,0x00,0x00]

ds_write_b96 v1, v[2:4]
// CHECK: [0x00,0x00,0x78,0xdb,0x01,0x02,0x00,0x00]

ds_write_b96 v1, v[2:4] offset:0
// CHECK: [0x00,0x00,0x78,0xdb,0x01,0x02,0x00,0x00]

ds_write_b96 v1, v[2:4] offset:4
// CHECK: [0x04,0x00,0x78,0xdb,0x01,0x02,0x00,0x00]

ds_write_b96 v1, v[2:4] offset:65535 gds
// CHECK: [0xff,0xff,0x7a,0xdb,0x01,0x02,0x00,0x00]

ds_write_b128 v1, v[2:5] offset:65535
// CHECK: [0xff,0xff,0x7c,0xdb,0x01,0x02,0x00,0x00]

ds_write_b128 v255, v[2:5] offset:65535
// CHECK: [0xff,0xff,0x7c,0xdb,0xff,0x02,0x00,0x00]

ds_write_b128 v1, v[252:255] offset:65535
// CHECK: [0xff,0xff,0x7c,0xdb,0x01,0xfc,0x00,0x00]

ds_write_b128 v1, v[2:5]
// CHECK: [0x00,0x00,0x7c,0xdb,0x01,0x02,0x00,0x00]

ds_write_b128 v1, v[2:5] offset:0
// CHECK: [0x00,0x00,0x7c,0xdb,0x01,0x02,0x00,0x00]

ds_write_b128 v1, v[2:5] offset:4
// CHECK: [0x04,0x00,0x7c,0xdb,0x01,0x02,0x00,0x00]

ds_write_b128 v1, v[2:5] offset:65535 gds
// CHECK: [0xff,0xff,0x7e,0xdb,0x01,0x02,0x00,0x00]

ds_read_b96 v[5:7], v1 offset:65535
// CHECK: [0xff,0xff,0xf8,0xdb,0x01,0x00,0x00,0x05]

ds_read_b96 v[253:255], v1 offset:65535
// CHECK: [0xff,0xff,0xf8,0xdb,0x01,0x00,0x00,0xfd]

ds_read_b96 v[5:7], v255 offset:65535
// CHECK: [0xff,0xff,0xf8,0xdb,0xff,0x00,0x00,0x05]

ds_read_b96 v[5:7], v1
// CHECK: [0x00,0x00,0xf8,0xdb,0x01,0x00,0x00,0x05]

ds_read_b96 v[5:7], v1 offset:0
// CHECK: [0x00,0x00,0xf8,0xdb,0x01,0x00,0x00,0x05]

ds_read_b96 v[5:7], v1 offset:4
// CHECK: [0x04,0x00,0xf8,0xdb,0x01,0x00,0x00,0x05]

ds_read_b96 v[5:7], v1 offset:65535 gds
// CHECK: [0xff,0xff,0xfa,0xdb,0x01,0x00,0x00,0x05]

ds_read_b128 v[5:8], v1 offset:65535
// CHECK: [0xff,0xff,0xfc,0xdb,0x01,0x00,0x00,0x05]

ds_read_b128 v[252:255], v1 offset:65535
// CHECK: [0xff,0xff,0xfc,0xdb,0x01,0x00,0x00,0xfc]

ds_read_b128 v[5:8], v255 offset:65535
// CHECK: [0xff,0xff,0xfc,0xdb,0xff,0x00,0x00,0x05]

ds_read_b128 v[5:8], v1
// CHECK: [0x00,0x00,0xfc,0xdb,0x01,0x00,0x00,0x05]

ds_read_b128 v[5:8], v1 offset:0
// CHECK: [0x00,0x00,0xfc,0xdb,0x01,0x00,0x00,0x05]

ds_read_b128 v[5:8], v1 offset:4
// CHECK: [0x04,0x00,0xfc,0xdb,0x01,0x00,0x00,0x05]

ds_read_b128 v[5:8], v1 offset:65535 gds
// CHECK: [0xff,0xff,0xfe,0xdb,0x01,0x00,0x00,0x05]
