/*
 * Copyright 2018 Google LLC
 * SPDX-License-Identifier: MIT
 */
#pragma once

#include <vulkan/vulkan.h>

#include "goldfish_vk_private_defs.h"
#include "vk_android_native_buffer_gfxstream.h"
#include "vulkan_gfxstream.h"

#if defined(LINUX_GUEST_BUILD)
#include "vulkan/wsi/wsi_common.h"
#endif

// anonymous
namespace {

template <class T>
struct vk_get_vk_struct_id;

#define REGISTER_VK_STRUCT_ID(T, ID)              \
    template <>                                   \
    struct vk_get_vk_struct_id<T> {               \
        static constexpr VkStructureType id = ID; \
    }

#ifdef VK_USE_PLATFORM_ANDROID_KHR
REGISTER_VK_STRUCT_ID(VkAndroidHardwareBufferPropertiesANDROID,
                      VK_STRUCTURE_TYPE_ANDROID_HARDWARE_BUFFER_PROPERTIES_ANDROID);
REGISTER_VK_STRUCT_ID(VkAndroidHardwareBufferFormatPropertiesANDROID,
                      VK_STRUCTURE_TYPE_ANDROID_HARDWARE_BUFFER_FORMAT_PROPERTIES_ANDROID);
REGISTER_VK_STRUCT_ID(VkAndroidHardwareBufferUsageANDROID,
                      VK_STRUCTURE_TYPE_ANDROID_HARDWARE_BUFFER_USAGE_ANDROID);
#endif
REGISTER_VK_STRUCT_ID(VkBufferCreateInfo, VK_STRUCTURE_TYPE_BUFFER_CREATE_INFO);
REGISTER_VK_STRUCT_ID(VkImageCreateInfo, VK_STRUCTURE_TYPE_SAMPLER_YCBCR_CONVERSION_CREATE_INFO);
REGISTER_VK_STRUCT_ID(VkImageFormatProperties2, VK_STRUCTURE_TYPE_IMAGE_FORMAT_PROPERTIES_2);
#ifdef VK_USE_PLATFORM_ANDROID_KHR
REGISTER_VK_STRUCT_ID(VkNativeBufferANDROID, VK_STRUCTURE_TYPE_NATIVE_BUFFER_ANDROID);
REGISTER_VK_STRUCT_ID(VkExternalFormatANDROID, VK_STRUCTURE_TYPE_EXTERNAL_FORMAT_ANDROID);
#endif
REGISTER_VK_STRUCT_ID(VkExternalMemoryBufferCreateInfo,
                      VK_STRUCTURE_TYPE_EXTERNAL_MEMORY_BUFFER_CREATE_INFO);
REGISTER_VK_STRUCT_ID(VkExternalMemoryImageCreateInfo,
                      VK_STRUCTURE_TYPE_EXTERNAL_MEMORY_IMAGE_CREATE_INFO);
REGISTER_VK_STRUCT_ID(VkMemoryAllocateInfo, VK_STRUCTURE_TYPE_MEMORY_ALLOCATE_INFO);
REGISTER_VK_STRUCT_ID(VkMemoryDedicatedAllocateInfo,
                      VK_STRUCTURE_TYPE_MEMORY_DEDICATED_ALLOCATE_INFO);
REGISTER_VK_STRUCT_ID(VkMemoryDedicatedRequirements,
                      VK_STRUCTURE_TYPE_MEMORY_DEDICATED_REQUIREMENTS);
#ifdef VK_USE_PLATFORM_ANDROID_KHR
REGISTER_VK_STRUCT_ID(VkImportAndroidHardwareBufferInfoANDROID,
                      VK_STRUCTURE_TYPE_IMPORT_ANDROID_HARDWARE_BUFFER_INFO_ANDROID);
#endif
REGISTER_VK_STRUCT_ID(VkImportMemoryFdInfoKHR, VK_STRUCTURE_TYPE_IMPORT_MEMORY_FD_INFO_KHR);
REGISTER_VK_STRUCT_ID(VkExportMemoryAllocateInfo, VK_STRUCTURE_TYPE_EXPORT_MEMORY_ALLOCATE_INFO);
REGISTER_VK_STRUCT_ID(VkMemoryRequirements2, VK_STRUCTURE_TYPE_MEMORY_REQUIREMENTS_2);
REGISTER_VK_STRUCT_ID(VkSemaphoreCreateInfo, VK_STRUCTURE_TYPE_SEMAPHORE_CREATE_INFO);
REGISTER_VK_STRUCT_ID(VkExportSemaphoreCreateInfoKHR,
                      VK_STRUCTURE_TYPE_EXPORT_SEMAPHORE_CREATE_INFO_KHR);
REGISTER_VK_STRUCT_ID(VkSamplerYcbcrConversionCreateInfo,
                      VK_STRUCTURE_TYPE_SAMPLER_YCBCR_CONVERSION_CREATE_INFO);
REGISTER_VK_STRUCT_ID(VkImportColorBufferGOOGLE, VK_STRUCTURE_TYPE_IMPORT_COLOR_BUFFER_GOOGLE);
REGISTER_VK_STRUCT_ID(VkImageViewCreateInfo, VK_STRUCTURE_TYPE_IMAGE_VIEW_CREATE_INFO);
#ifdef VK_USE_PLATFORM_FUCHSIA
REGISTER_VK_STRUCT_ID(VkImportMemoryBufferCollectionFUCHSIA,
                      VK_STRUCTURE_TYPE_IMPORT_MEMORY_BUFFER_COLLECTION_FUCHSIA);
REGISTER_VK_STRUCT_ID(VkImportMemoryZirconHandleInfoFUCHSIA,
                      VK_STRUCTURE_TYPE_IMPORT_MEMORY_ZIRCON_HANDLE_INFO_FUCHSIA);
REGISTER_VK_STRUCT_ID(VkBufferCollectionImageCreateInfoFUCHSIA,
                      VK_STRUCTURE_TYPE_BUFFER_COLLECTION_IMAGE_CREATE_INFO_FUCHSIA);
REGISTER_VK_STRUCT_ID(VkBufferCollectionBufferCreateInfoFUCHSIA,
                      VK_STRUCTURE_TYPE_BUFFER_COLLECTION_BUFFER_CREATE_INFO_FUCHSIA);
#endif  // VK_USE_PLATFORM_FUCHSIA
REGISTER_VK_STRUCT_ID(VkSamplerCreateInfo, VK_STRUCTURE_TYPE_SAMPLER_CREATE_INFO);
REGISTER_VK_STRUCT_ID(VkSamplerCustomBorderColorCreateInfoEXT,
                      VK_STRUCTURE_TYPE_SAMPLER_CUSTOM_BORDER_COLOR_CREATE_INFO_EXT);
REGISTER_VK_STRUCT_ID(VkSamplerYcbcrConversionInfo,
                      VK_STRUCTURE_TYPE_SAMPLER_YCBCR_CONVERSION_INFO);
REGISTER_VK_STRUCT_ID(VkFenceCreateInfo, VK_STRUCTURE_TYPE_FENCE_CREATE_INFO);
REGISTER_VK_STRUCT_ID(VkExportFenceCreateInfo, VK_STRUCTURE_TYPE_EXPORT_FENCE_CREATE_INFO);
REGISTER_VK_STRUCT_ID(VkImportBufferGOOGLE, VK_STRUCTURE_TYPE_IMPORT_BUFFER_GOOGLE);
REGISTER_VK_STRUCT_ID(VkCreateBlobGOOGLE, VK_STRUCTURE_TYPE_CREATE_BLOB_GOOGLE);
REGISTER_VK_STRUCT_ID(VkExternalImageFormatProperties,
                      VK_STRUCTURE_TYPE_EXTERNAL_IMAGE_FORMAT_PROPERTIES);
REGISTER_VK_STRUCT_ID(VkPhysicalDeviceImageFormatInfo2,
                      VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_IMAGE_FORMAT_INFO_2);
REGISTER_VK_STRUCT_ID(VkPhysicalDeviceExternalImageFormatInfo,
                      VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_EXTERNAL_IMAGE_FORMAT_INFO);
REGISTER_VK_STRUCT_ID(VkSemaphoreTypeCreateInfo, VK_STRUCTURE_TYPE_SEMAPHORE_TYPE_CREATE_INFO);
REGISTER_VK_STRUCT_ID(VkPhysicalDeviceFeatures2, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_FEATURES_2);
REGISTER_VK_STRUCT_ID(VkPhysicalDeviceProperties2, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PROPERTIES_2);
REGISTER_VK_STRUCT_ID(VkPhysicalDeviceDeviceMemoryReportFeaturesEXT,
                      VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DEVICE_MEMORY_REPORT_FEATURES_EXT);
REGISTER_VK_STRUCT_ID(VkMemoryAllocateFlagsInfo, VK_STRUCTURE_TYPE_MEMORY_ALLOCATE_FLAGS_INFO);
REGISTER_VK_STRUCT_ID(VkMemoryOpaqueCaptureAddressAllocateInfo,
                      VK_STRUCTURE_TYPE_MEMORY_OPAQUE_CAPTURE_ADDRESS_ALLOCATE_INFO);
REGISTER_VK_STRUCT_ID(VkBindImageMemoryInfo, VK_STRUCTURE_TYPE_BIND_IMAGE_MEMORY_INFO);
REGISTER_VK_STRUCT_ID(VkBindImageMemorySwapchainInfoKHR,
                      VK_STRUCTURE_TYPE_BIND_IMAGE_MEMORY_SWAPCHAIN_INFO_KHR);
REGISTER_VK_STRUCT_ID(VkBufferOpaqueCaptureAddressCreateInfo,
                      VK_STRUCTURE_TYPE_BUFFER_OPAQUE_CAPTURE_ADDRESS_CREATE_INFO);
REGISTER_VK_STRUCT_ID(VkBufferDeviceAddressCreateInfoEXT,
                      VK_STRUCTURE_TYPE_BUFFER_DEVICE_ADDRESS_CREATE_INFO_EXT);
REGISTER_VK_STRUCT_ID(VkGraphicsPipelineCreateInfo,
                      VK_STRUCTURE_TYPE_GRAPHICS_PIPELINE_CREATE_INFO);
REGISTER_VK_STRUCT_ID(VkPipelineRenderingCreateInfo,
                      VK_STRUCTURE_TYPE_PIPELINE_RENDERING_CREATE_INFO);
REGISTER_VK_STRUCT_ID(VkPhysicalDeviceExternalSemaphoreInfo,
                      VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_EXTERNAL_SEMAPHORE_INFO);
REGISTER_VK_STRUCT_ID(VkRenderPassBeginInfo, VK_STRUCTURE_TYPE_RENDER_PASS_BEGIN_INFO);
REGISTER_VK_STRUCT_ID(VkRenderPassAttachmentBeginInfo,
                      VK_STRUCTURE_TYPE_RENDER_PASS_ATTACHMENT_BEGIN_INFO);
REGISTER_VK_STRUCT_ID(VkImportMemoryHostPointerInfoEXT,
                      VK_STRUCTURE_TYPE_IMPORT_MEMORY_HOST_POINTER_INFO_EXT);
REGISTER_VK_STRUCT_ID(VkDeviceCreateInfo, VK_STRUCTURE_TYPE_DEVICE_CREATE_INFO);
REGISTER_VK_STRUCT_ID(VkPhysicalDeviceGroupProperties,
                      VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_GROUP_PROPERTIES);
REGISTER_VK_STRUCT_ID(VkPhysicalDeviceSwapchainMaintenance1FeaturesEXT, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SWAPCHAIN_MAINTENANCE_1_FEATURES_EXT);
REGISTER_VK_STRUCT_ID(VkSubmitInfo, VK_STRUCTURE_TYPE_SUBMIT_INFO);
REGISTER_VK_STRUCT_ID(VkTimelineSemaphoreSubmitInfo,
                      VK_STRUCTURE_TYPE_TIMELINE_SEMAPHORE_SUBMIT_INFO);
#if defined(LINUX_GUEST_BUILD)
REGISTER_VK_STRUCT_ID(wsi_image_create_info, VK_STRUCTURE_TYPE_WSI_IMAGE_CREATE_INFO_MESA);
#endif
REGISTER_VK_STRUCT_ID(VkImageDrmFormatModifierExplicitCreateInfoEXT,
                      VK_STRUCTURE_TYPE_IMAGE_DRM_FORMAT_MODIFIER_EXPLICIT_CREATE_INFO_EXT);
REGISTER_VK_STRUCT_ID(VkFormatProperties2, VK_STRUCTURE_TYPE_FORMAT_PROPERTIES_2);
REGISTER_VK_STRUCT_ID(VkPhysicalDeviceImageDrmFormatModifierInfoEXT,
                      VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_IMAGE_DRM_FORMAT_MODIFIER_INFO_EXT);
REGISTER_VK_STRUCT_ID(VkDrmFormatModifierPropertiesListEXT,
                      VK_STRUCTURE_TYPE_DRM_FORMAT_MODIFIER_PROPERTIES_LIST_EXT);
REGISTER_VK_STRUCT_ID(VkImageDrmFormatModifierListCreateInfoEXT,
                      VK_STRUCTURE_TYPE_IMAGE_DRM_FORMAT_MODIFIER_LIST_CREATE_INFO_EXT);

#undef REGISTER_VK_STRUCT_ID

}  // namespace
