import re, string, os

PATH = os.path.dirname(os.path.realpath(__file__))
MATHJAX_TEST_TEST_DIR = os.path.join(PATH, 'fixtures', 'MathJax')
MATHJAX_TEST_TEXT_DIR = os.path.join(MATHJAX_TEST_TEST_DIR, 'LaTeXToMathML-tex')
MATHJAX_TEST_OUT_DIR = os.path.join(MATHJAX_TEST_TEST_DIR, 'LaTeXToMathML-out')
MAGIC_LINE = "/* EVERYTHING BELOW IS AUTOGENERATED */\n"

template = string.Template("""void test_mathjax__$sanitized_name(void)
{
  fixture_tex = read_fixture_tex("MathJax/LaTeXToMathML-tex/$name.txt");
  fixture_mml = read_fixture_mml("MathJax/LaTeXToMathML-out/$name.html");
  mtex2MML_filter(fixture_tex, strlen(fixture_tex), MTEX2MML_DELIMITER_DEFAULT);
  result = mtex2MML_output();

  cl_assert_equal_s(fixture_mml, result);
}""")

fixtures = []
xtex_files = []
notex_files = []

txt_count = 0
xtex_count = 0
notex_count = 0

regex = False #'environments/alignat-1b'

for root, dirs, files in os.walk(MATHJAX_TEST_TEXT_DIR):
    for file in files:
        name = os.path.basename(root) + "/" + os.path.splitext(file)[0]
        if file.endswith(".txt"):
            if regex:
                if re.search(regex, name):
                    fixtures.append(name)
            else:
                fixtures.append(name)
            txt_count += 1
        elif file.endswith(".xtex"):
            xtex_files.append(name)
            xtex_count += 1
        elif file.endswith(".no_tex"):
            notex_files.append(name)
            notex_count += 1

test_file = open(os.path.join(PATH, "mathjax.c"),"r+")
test_file_lines = test_file.readlines()
test_file.seek(0)

autogenerated_index = test_file_lines.index(MAGIC_LINE)
test_file_lines = test_file_lines[:autogenerated_index + 1]

for fixture_name in fixtures:
    sanitized = fixture_name.replace('-', '').replace('/', '')
    test_file_lines.append("\n" + template.substitute(sanitized_name=sanitized, name=fixture_name) + "\n")

for line in test_file_lines:
    test_file.write(line)

test_file.truncate()
test_file.close()

total = float(txt_count + xtex_count)
coverage = "{0:.2f}".format((txt_count / total) * 100)
skipped_files = "\n * ".join(xtex_files)
incomplete_files = "\n * ".join(notex_files)

if xtex_count > 0:
    print("\nNot doing the following {0} MathJax tests (because they're non-standard):\n\n * {1}".format(notex_count, incomplete_files))
    print("\n\nSkipping the following MathJax tests:\n\n * {0}".format(skipped_files))
    print("\n\n*** You did {0} and skipped {1}: {2}% coverage ***".format(txt_count, xtex_count, coverage))
    print("\n\n*** Tests last fetched: 3e882fd386 ***\n\n")
