mypaint-brushes - MyPaint brushes
=================================

Brushes used by MyPaint and other software using libmypaint.

This data package is versionned. This are the brushes to be used by
libmypaint 2.x, current development version which has no releases to the
day of writing.
If you want brushes for the libmypaint 1.x releases, do not install
mypaint-brushes from master, but from "v1.3.x" branch (or last release
tagged with a "v1.x" version).

Building
---------

mypaint-brushes package can be installed as a typical autotools build:

> ./autogen.sh

> ./configure && make && make install


There are also historical scons scripts, but they work only with scons
2.x (and in particular not newer scons 3, based on Python 3):

> scons prefix=/your/application/install/prefix # Normal build

> scons -h                                      # Show build options

Using the brushes with pkg-config
---------------------------------

If your application needs libmypaint 2.x brushes, you can make the
module "mypaint-brushes-2.0" a dependency with pkg-config.

For a C/C++ program, the CFlags generated by pkg-config will define the
macro MYPAINT_BRUSHES_DIR, usable in your code in order to get the path
for all mypaint default brushes.

For programs in other languages, you can use the variable `brushesdir`
to get the same information with pkg-config and insert this value in
your program in the relevant way.

> pkg-config --variable=brushesdir mypaint-brushes-2.0

Licensing policy
----------------

Only public domain (or [Creative Commons 1.0
Universal](https://creativecommons.org/publicdomain/zero/1.0/) is an
acceptable license for the official `mypaint-brushes` package.

Optionally you may use CC BY (or CC BY-SA) 4.0 for the visible parts
(such as preview image) but keep the raw brush settings public domain.

By contributing new brushes, you therefore agree for them to be
relicensed Public Domain/CC0 1.0. If you want to propose someone else's
brushes, whose copyright you do not own, and if the brushes were not
already explicitly license CC0 1.0, you must first contact the original
authors.

The rest of this package (installation scripts, etc.) is license GPL-2+
(similarly to the MyPaint package). See `Licenses.dep5` for more
accurate licensing and authorship information.
