# Installation Notes for 64-bit Linux Systems

!!! note
    The description on this page is possibly not up-to-date.

The [glibc built-in stack-unwinder](#glibc-built-in-stack-unwinder) on 64-bit
systems has some problems with ng-log. In particular, if you are using
[`InstallFailureSignalHandler()`](failures.md), the signal may be raised in the
middle of `malloc`, holding some `malloc`-related locks when they invoke the
stack unwinder. The built-in stack unwinder may call `malloc` recursively, which
may require the thread to acquire a lock it already holds resulting in a
deadlock.

## Recommended Approach: `libunwind`

For above reason, if you use a 64-bit system and you need
`InstallFailureSignalHandler()`, we strongly recommend you install `libunwind`
before trying to configure or install ng-log. libunwind can be found
[here](http://download.savannah.nongnu.org/releases/libunwind/libunwind-snap-070410.tar.gz).

Even if you already have `libunwind` installed, you will probably still need to
install from the snapshot to get the latest version.

!!! warning
    If you install libunwind from the URL above, be aware that you may have
    trouble if you try to statically link your binary with ng-log: that is, if you
    link with `gcc -static -lgcc_eh ...`. This is because both `libunwind` and
    `libgcc` implement the same C++ exception handling APIs, but they implement
    them differently on some platforms. This is not likely to be a problem on
    ia64, but may be on x86-64.

Also, if you link binaries statically, make sure that you add
`-Wl,--eh-frame-hdr` to your linker options. This is required so that
`libunwind` can find the information generated by the compiler required for
stack unwinding.

Using `-static` is rare, though, so unless you know this will affect you it
probably won't.

## Alternative Stack-unwinder

If you cannot or do not wish to install `libunwind`, you can still try to use
two kinds of stack-unwinder:

### glibc Built-in Stack-unwinder

As we already mentioned, glibc's unwinder has a deadlock issue. However, if you
don't use `InstallFailureSignalHandler()` or you don't worry about the rare
possibilities of deadlocks, you can use this stack-unwinder. If you specify no
options and `libunwind` isn't detected on your system, the configure script
chooses this unwinder by default.

### Frame Pointer based Stack-unwinder

The frame pointer based stack unwinder requires that your application, the ng-log
library, and system libraries like libc, all be compiled with a frame pointer.
This is *not* the default for x86-64.
