/* automatically generated by ieee754-ops-auto.sh, do not edit! */
#include <tme/common.h>
_TME_RCSID("$Id: ieee754-ops-auto.sh,v 1.5 2009/08/28 01:34:01 fredette Exp $");

#include "softfloat-tme.h"
#include <math.h>

/* this does a strict compliance single-precision add: */
static void
_tme_ieee754_strict_single_add(struct tme_ieee754_ctl *ieee754_ctl, const struct tme_float *src0, const struct tme_float *src1, struct tme_float *dst)
{
  tme_uint32_t src0_buffer;
  tme_uint32_t src1_buffer;
  int exceptions;

  /* enter softfloat operation: */
  tme_mutex_lock(&tme_ieee754_global_mutex);
  tme_ieee754_global_ctl = ieee754_ctl;
  tme_ieee754_global_exceptions = 0;
  ieee754_ctl->tme_ieee754_ctl_lock_unlock = tme_ieee754_unlock_softfloat;

  /* assume that this operation raises no exceptions: */
  exceptions = 0;

  /* the operation: */
  _tme_ieee754_single_value_set(dst, float32,
    float32_add((*((const float32 *) tme_ieee754_single_value_get(src0, &src0_buffer))),
                (*((const float32 *) tme_ieee754_single_value_get(src1, &src1_buffer)))));

  /* leave softfloat operation: */
  tme_ieee754_global_ctl = NULL;
  exceptions |= tme_ieee754_global_exceptions;
  tme_mutex_unlock(&tme_ieee754_global_mutex);
  ieee754_ctl->tme_ieee754_ctl_lock_unlock = NULL;

  /* signal any exceptions: */
  if (exceptions != 0) {
    (*ieee754_ctl->tme_ieee754_ctl_exception)(ieee754_ctl, exceptions);
  }
}

/* this does a strict compliance single-precision sub: */
static void
_tme_ieee754_strict_single_sub(struct tme_ieee754_ctl *ieee754_ctl, const struct tme_float *src0, const struct tme_float *src1, struct tme_float *dst)
{
  tme_uint32_t src0_buffer;
  tme_uint32_t src1_buffer;
  int exceptions;

  /* enter softfloat operation: */
  tme_mutex_lock(&tme_ieee754_global_mutex);
  tme_ieee754_global_ctl = ieee754_ctl;
  tme_ieee754_global_exceptions = 0;
  ieee754_ctl->tme_ieee754_ctl_lock_unlock = tme_ieee754_unlock_softfloat;

  /* assume that this operation raises no exceptions: */
  exceptions = 0;

  /* the operation: */
  _tme_ieee754_single_value_set(dst, float32,
    float32_sub((*((const float32 *) tme_ieee754_single_value_get(src0, &src0_buffer))),
                (*((const float32 *) tme_ieee754_single_value_get(src1, &src1_buffer)))));

  /* leave softfloat operation: */
  tme_ieee754_global_ctl = NULL;
  exceptions |= tme_ieee754_global_exceptions;
  tme_mutex_unlock(&tme_ieee754_global_mutex);
  ieee754_ctl->tme_ieee754_ctl_lock_unlock = NULL;

  /* signal any exceptions: */
  if (exceptions != 0) {
    (*ieee754_ctl->tme_ieee754_ctl_exception)(ieee754_ctl, exceptions);
  }
}

/* this does a strict compliance single-precision mul: */
static void
_tme_ieee754_strict_single_mul(struct tme_ieee754_ctl *ieee754_ctl, const struct tme_float *src0, const struct tme_float *src1, struct tme_float *dst)
{
  tme_uint32_t src0_buffer;
  tme_uint32_t src1_buffer;
  int exceptions;

  /* enter softfloat operation: */
  tme_mutex_lock(&tme_ieee754_global_mutex);
  tme_ieee754_global_ctl = ieee754_ctl;
  tme_ieee754_global_exceptions = 0;
  ieee754_ctl->tme_ieee754_ctl_lock_unlock = tme_ieee754_unlock_softfloat;

  /* assume that this operation raises no exceptions: */
  exceptions = 0;

  /* the operation: */
  _tme_ieee754_single_value_set(dst, float32,
    float32_mul((*((const float32 *) tme_ieee754_single_value_get(src0, &src0_buffer))),
                (*((const float32 *) tme_ieee754_single_value_get(src1, &src1_buffer)))));

  /* leave softfloat operation: */
  tme_ieee754_global_ctl = NULL;
  exceptions |= tme_ieee754_global_exceptions;
  tme_mutex_unlock(&tme_ieee754_global_mutex);
  ieee754_ctl->tme_ieee754_ctl_lock_unlock = NULL;

  /* signal any exceptions: */
  if (exceptions != 0) {
    (*ieee754_ctl->tme_ieee754_ctl_exception)(ieee754_ctl, exceptions);
  }
}

/* this does a strict compliance single-precision div: */
static void
_tme_ieee754_strict_single_div(struct tme_ieee754_ctl *ieee754_ctl, const struct tme_float *src0, const struct tme_float *src1, struct tme_float *dst)
{
  tme_uint32_t src0_buffer;
  tme_uint32_t src1_buffer;
  int exceptions;

  /* enter softfloat operation: */
  tme_mutex_lock(&tme_ieee754_global_mutex);
  tme_ieee754_global_ctl = ieee754_ctl;
  tme_ieee754_global_exceptions = 0;
  ieee754_ctl->tme_ieee754_ctl_lock_unlock = tme_ieee754_unlock_softfloat;

  /* assume that this operation raises no exceptions: */
  exceptions = 0;

  /* the operation: */
  _tme_ieee754_single_value_set(dst, float32,
    float32_div((*((const float32 *) tme_ieee754_single_value_get(src0, &src0_buffer))),
                (*((const float32 *) tme_ieee754_single_value_get(src1, &src1_buffer)))));

  /* leave softfloat operation: */
  tme_ieee754_global_ctl = NULL;
  exceptions |= tme_ieee754_global_exceptions;
  tme_mutex_unlock(&tme_ieee754_global_mutex);
  ieee754_ctl->tme_ieee754_ctl_lock_unlock = NULL;

  /* signal any exceptions: */
  if (exceptions != 0) {
    (*ieee754_ctl->tme_ieee754_ctl_exception)(ieee754_ctl, exceptions);
  }
}

/* this does a strict compliance single-precision rem: */
static void
_tme_ieee754_strict_single_rem(struct tme_ieee754_ctl *ieee754_ctl, const struct tme_float *src0, const struct tme_float *src1, struct tme_float *dst)
{
  tme_uint32_t src0_buffer;
  tme_uint32_t src1_buffer;
  int exceptions;

  /* enter softfloat operation: */
  tme_mutex_lock(&tme_ieee754_global_mutex);
  tme_ieee754_global_ctl = ieee754_ctl;
  tme_ieee754_global_exceptions = 0;
  ieee754_ctl->tme_ieee754_ctl_lock_unlock = tme_ieee754_unlock_softfloat;

  /* assume that this operation raises no exceptions: */
  exceptions = 0;

  /* the operation: */
  _tme_ieee754_single_value_set(dst, float32,
    float32_rem((*((const float32 *) tme_ieee754_single_value_get(src0, &src0_buffer))),
                (*((const float32 *) tme_ieee754_single_value_get(src1, &src1_buffer)))));

  /* leave softfloat operation: */
  tme_ieee754_global_ctl = NULL;
  exceptions |= tme_ieee754_global_exceptions;
  tme_mutex_unlock(&tme_ieee754_global_mutex);
  ieee754_ctl->tme_ieee754_ctl_lock_unlock = NULL;

  /* signal any exceptions: */
  if (exceptions != 0) {
    (*ieee754_ctl->tme_ieee754_ctl_exception)(ieee754_ctl, exceptions);
  }
}

/* this does a strict compliance single-precision sqrt: */
static void
_tme_ieee754_strict_single_sqrt(struct tme_ieee754_ctl *ieee754_ctl, const struct tme_float *src0, struct tme_float *dst)
{
  tme_uint32_t src0_buffer;
  int exceptions;

  /* enter softfloat operation: */
  tme_mutex_lock(&tme_ieee754_global_mutex);
  tme_ieee754_global_ctl = ieee754_ctl;
  tme_ieee754_global_exceptions = 0;
  ieee754_ctl->tme_ieee754_ctl_lock_unlock = tme_ieee754_unlock_softfloat;

  /* assume that this operation raises no exceptions: */
  exceptions = 0;

  /* the operation: */
  _tme_ieee754_single_value_set(dst, float32,
    float32_sqrt((*((const float32 *) tme_ieee754_single_value_get(src0, &src0_buffer)))));

  /* leave softfloat operation: */
  tme_ieee754_global_ctl = NULL;
  exceptions |= tme_ieee754_global_exceptions;
  tme_mutex_unlock(&tme_ieee754_global_mutex);
  ieee754_ctl->tme_ieee754_ctl_lock_unlock = NULL;

  /* signal any exceptions: */
  if (exceptions != 0) {
    (*ieee754_ctl->tme_ieee754_ctl_exception)(ieee754_ctl, exceptions);
  }
}

/* this does a strict compliance single-precision neg: */
static void
_tme_ieee754_strict_single_neg(struct tme_ieee754_ctl *ieee754_ctl, const struct tme_float *src0, struct tme_float *dst)
{
  tme_uint32_t src0_buffer;
  int exceptions;

  /* enter softfloat operation: */
  tme_mutex_lock(&tme_ieee754_global_mutex);
  tme_ieee754_global_ctl = ieee754_ctl;
  tme_ieee754_global_exceptions = 0;
  ieee754_ctl->tme_ieee754_ctl_lock_unlock = tme_ieee754_unlock_softfloat;

  /* assume that this operation raises no exceptions: */
  exceptions = 0;

  /* the operation: */
  _tme_ieee754_single_value_set(dst, float32,
    float32_mul(int32_to_float32(-1),
                (*((const float32 *) tme_ieee754_single_value_get(src0, &src0_buffer)))));

  /* leave softfloat operation: */
  tme_ieee754_global_ctl = NULL;
  exceptions |= tme_ieee754_global_exceptions;
  tme_mutex_unlock(&tme_ieee754_global_mutex);
  ieee754_ctl->tme_ieee754_ctl_lock_unlock = NULL;

  /* signal any exceptions: */
  if (exceptions != 0) {
    (*ieee754_ctl->tme_ieee754_ctl_exception)(ieee754_ctl, exceptions);
  }
}

/* this does a strict compliance single-precision move: */
static void
_tme_ieee754_strict_single_move(struct tme_ieee754_ctl *ieee754_ctl, const struct tme_float *src0, struct tme_float *dst)
{
  tme_uint32_t src0_buffer;
  int exceptions;

  /* enter softfloat operation: */
  tme_mutex_lock(&tme_ieee754_global_mutex);
  tme_ieee754_global_ctl = ieee754_ctl;
  tme_ieee754_global_exceptions = 0;
  ieee754_ctl->tme_ieee754_ctl_lock_unlock = tme_ieee754_unlock_softfloat;

  /* assume that this operation raises no exceptions: */
  exceptions = 0;

  /* the operation: */
  _tme_ieee754_single_value_set(dst, float32,
    float32_add((*((const float32 *) tme_ieee754_single_value_get(src0, &src0_buffer))),
                int32_to_float32(0)));

  /* leave softfloat operation: */
  tme_ieee754_global_ctl = NULL;
  exceptions |= tme_ieee754_global_exceptions;
  tme_mutex_unlock(&tme_ieee754_global_mutex);
  ieee754_ctl->tme_ieee754_ctl_lock_unlock = NULL;

  /* signal any exceptions: */
  if (exceptions != 0) {
    (*ieee754_ctl->tme_ieee754_ctl_exception)(ieee754_ctl, exceptions);
  }
}

/* this does a strict compliance single-precision rint: */
static void
_tme_ieee754_strict_single_rint(struct tme_ieee754_ctl *ieee754_ctl, const struct tme_float *src0, struct tme_float *dst)
{
  tme_uint32_t src0_buffer;
  int exceptions;

  /* enter softfloat operation: */
  tme_mutex_lock(&tme_ieee754_global_mutex);
  tme_ieee754_global_ctl = ieee754_ctl;
  tme_ieee754_global_exceptions = 0;
  ieee754_ctl->tme_ieee754_ctl_lock_unlock = tme_ieee754_unlock_softfloat;

  /* assume that this operation raises no exceptions: */
  exceptions = 0;

  /* the operation: */
  _tme_ieee754_single_value_set(dst, float32,
    float32_round_to_int((*((const float32 *) tme_ieee754_single_value_get(src0, &src0_buffer)))));

  /* leave softfloat operation: */
  tme_ieee754_global_ctl = NULL;
  exceptions |= tme_ieee754_global_exceptions;
  tme_mutex_unlock(&tme_ieee754_global_mutex);
  ieee754_ctl->tme_ieee754_ctl_lock_unlock = NULL;

  /* signal any exceptions: */
  if (exceptions != 0) {
    (*ieee754_ctl->tme_ieee754_ctl_exception)(ieee754_ctl, exceptions);
  }
}

/* this does a strict compliance single-precision getexp: */
static void
_tme_ieee754_strict_single_getexp(struct tme_ieee754_ctl *ieee754_ctl, const struct tme_float *src0, struct tme_float *dst)
{
  tme_uint32_t src0_buffer;
  int exceptions;

  /* check for a NaN operand: */
  if (__tme_predict_false(tme_ieee754_single_check_nan_monadic(ieee754_ctl, src0, dst))) {
    return;
  }

  /* if the operand is an infinity: */
  if (tme_ieee754_single_is_inf(src0)) {

    /* return a NaN: */
    dst->tme_float_format = TME_FLOAT_FORMAT_IEEE754_SINGLE;
    dst->tme_float_value_ieee754_single = ieee754_ctl->tme_ieee754_ctl_default_nan_single;
    return;
  }

  /* assume that this operation raises no exceptions: */
  exceptions = 0;

  /* the operation: */

  /* if the operand is a zero, return a zero: */
  if (tme_ieee754_single_is_zero(src0)) {
    tme_ieee754_single_value_builtin_set(dst, TME_FLOAT_FORMAT_IEEE754_SINGLE_BUILTIN, 0);
  }

  /* otherwise, return the unbiased exponent: */
  else {
    tme_ieee754_single_value_builtin_set(dst, TME_FLOAT_FORMAT_IEEE754_SINGLE_BUILTIN, TME_FIELD_MASK_EXTRACTU((*tme_ieee754_single_value_get(src0, &src0_buffer)), ((tme_uint32_t) 0x7f800000)) - ((((tme_uint32_t) 0x7f800000) / _TME_FIELD_MASK_FACTOR(((tme_uint32_t) 0x7f800000))) >> 1));
  }
  ieee754_ctl->tme_ieee754_ctl_lock_unlock = NULL;

  /* signal any exceptions: */
  if (exceptions != 0) {
    (*ieee754_ctl->tme_ieee754_ctl_exception)(ieee754_ctl, exceptions);
  }
}

/* this does a strict compliance single-precision getman: */
static void
_tme_ieee754_strict_single_getman(struct tme_ieee754_ctl *ieee754_ctl, const struct tme_float *src0, struct tme_float *dst)
{
  tme_uint32_t src0_buffer;
  int exceptions;

  /* check for a NaN operand: */
  if (__tme_predict_false(tme_ieee754_single_check_nan_monadic(ieee754_ctl, src0, dst))) {
    return;
  }

  /* if the operand is an infinity: */
  if (tme_ieee754_single_is_inf(src0)) {

    /* return a NaN: */
    dst->tme_float_format = TME_FLOAT_FORMAT_IEEE754_SINGLE;
    dst->tme_float_value_ieee754_single = ieee754_ctl->tme_ieee754_ctl_default_nan_single;
    return;
  }

  /* assume that this operation raises no exceptions: */
  exceptions = 0;

  /* the operation: */

  /* if the operand is a zero, return it: */
  if (tme_ieee754_single_is_zero(src0)) {
    *dst = *src0;
  }

  /* otherwise, return the operand, with its exponent set to biased zero: */
  else {
    tme_ieee754_single_value_set(dst, (*tme_ieee754_single_value_get(src0, &src0_buffer)));
    TME_FIELD_MASK_DEPOSITU(dst->tme_float_value_ieee754_single, ((tme_uint32_t) 0x7f800000), ((((tme_uint32_t) 0x7f800000) / _TME_FIELD_MASK_FACTOR(((tme_uint32_t) 0x7f800000))) >> 1));
  }
  ieee754_ctl->tme_ieee754_ctl_lock_unlock = NULL;

  /* signal any exceptions: */
  if (exceptions != 0) {
    (*ieee754_ctl->tme_ieee754_ctl_exception)(ieee754_ctl, exceptions);
  }
}

/* this does a strict compliance single-precision from-double: */
static void
_tme_ieee754_strict_single_from_double(struct tme_ieee754_ctl *ieee754_ctl, const struct tme_float *src0, struct tme_float *dst)
{
  union tme_value64 src0_buffer;
  int exceptions;

  /* enter softfloat operation: */
  tme_mutex_lock(&tme_ieee754_global_mutex);
  tme_ieee754_global_ctl = ieee754_ctl;
  tme_ieee754_global_exceptions = 0;
  ieee754_ctl->tme_ieee754_ctl_lock_unlock = tme_ieee754_unlock_softfloat;

  /* assume that this operation raises no exceptions: */
  exceptions = 0;

  /* the operation: */
  _tme_ieee754_single_value_set(dst, float32,
    float64_to_float32((*((const float64 *) tme_ieee754_double_value_get(src0, &src0_buffer)))));

  /* leave softfloat operation: */
  tme_ieee754_global_ctl = NULL;
  exceptions |= tme_ieee754_global_exceptions;
  tme_mutex_unlock(&tme_ieee754_global_mutex);
  ieee754_ctl->tme_ieee754_ctl_lock_unlock = NULL;

  /* signal any exceptions: */
  if (exceptions != 0) {
    (*ieee754_ctl->tme_ieee754_ctl_exception)(ieee754_ctl, exceptions);
  }
}

/* this does a strict compliance single-precision from-extended80: */
static void
_tme_ieee754_strict_single_from_extended80(struct tme_ieee754_ctl *ieee754_ctl, const struct tme_float *src0, struct tme_float *dst)
{
  struct tme_float_ieee754_extended80 src0_buffer;
  int exceptions;

  /* enter softfloat operation: */
  tme_mutex_lock(&tme_ieee754_global_mutex);
  tme_ieee754_global_ctl = ieee754_ctl;
  tme_ieee754_global_exceptions = 0;
  ieee754_ctl->tme_ieee754_ctl_lock_unlock = tme_ieee754_unlock_softfloat;

  /* assume that this operation raises no exceptions: */
  exceptions = 0;

  /* the operation: */
  _tme_ieee754_single_value_set(dst, float32,
    floatx80_to_float32((*((const floatx80 *) tme_ieee754_extended80_value_get(src0, &src0_buffer)))));

  /* leave softfloat operation: */
  tme_ieee754_global_ctl = NULL;
  exceptions |= tme_ieee754_global_exceptions;
  tme_mutex_unlock(&tme_ieee754_global_mutex);
  ieee754_ctl->tme_ieee754_ctl_lock_unlock = NULL;

  /* signal any exceptions: */
  if (exceptions != 0) {
    (*ieee754_ctl->tme_ieee754_ctl_exception)(ieee754_ctl, exceptions);
  }
}

/* this does a strict compliance single-precision from-quad: */
static void
_tme_ieee754_strict_single_from_quad(struct tme_ieee754_ctl *ieee754_ctl, const struct tme_float *src0, struct tme_float *dst)
{
  struct tme_float_ieee754_quad src0_buffer;
  int exceptions;

  /* enter softfloat operation: */
  tme_mutex_lock(&tme_ieee754_global_mutex);
  tme_ieee754_global_ctl = ieee754_ctl;
  tme_ieee754_global_exceptions = 0;
  ieee754_ctl->tme_ieee754_ctl_lock_unlock = tme_ieee754_unlock_softfloat;

  /* assume that this operation raises no exceptions: */
  exceptions = 0;

  /* the operation: */
  _tme_ieee754_single_value_set(dst, float32,
    float128_to_float32((*((const float128 *) tme_ieee754_quad_value_get(src0, &src0_buffer)))));

  /* leave softfloat operation: */
  tme_ieee754_global_ctl = NULL;
  exceptions |= tme_ieee754_global_exceptions;
  tme_mutex_unlock(&tme_ieee754_global_mutex);
  ieee754_ctl->tme_ieee754_ctl_lock_unlock = NULL;

  /* signal any exceptions: */
  if (exceptions != 0) {
    (*ieee754_ctl->tme_ieee754_ctl_exception)(ieee754_ctl, exceptions);
  }
}

/* this does a strict compliance single-precision from-int32: */
static void
_tme_ieee754_strict_single_from_int32(struct tme_ieee754_ctl *ieee754_ctl, const tme_int32_t src0, struct tme_float *dst)
{
  int exceptions;

  /* enter softfloat operation: */
  tme_mutex_lock(&tme_ieee754_global_mutex);
  tme_ieee754_global_ctl = ieee754_ctl;
  tme_ieee754_global_exceptions = 0;
  ieee754_ctl->tme_ieee754_ctl_lock_unlock = tme_ieee754_unlock_softfloat;

  /* assume that this operation raises no exceptions: */
  exceptions = 0;

  /* the operation: */
  _tme_ieee754_single_value_set(dst, float32,
    int32_to_float32(src0));

  /* leave softfloat operation: */
  tme_ieee754_global_ctl = NULL;
  exceptions |= tme_ieee754_global_exceptions;
  tme_mutex_unlock(&tme_ieee754_global_mutex);
  ieee754_ctl->tme_ieee754_ctl_lock_unlock = NULL;

  /* signal any exceptions: */
  if (exceptions != 0) {
    (*ieee754_ctl->tme_ieee754_ctl_exception)(ieee754_ctl, exceptions);
  }
}

#if defined(TME_HAVE_INT64_T)

/* this does a strict compliance single-precision from-int64: */
static void
_tme_ieee754_strict_single_from_int64(struct tme_ieee754_ctl *ieee754_ctl, const tme_int64_t src0, struct tme_float *dst)
{
  int exceptions;

  /* enter softfloat operation: */
  tme_mutex_lock(&tme_ieee754_global_mutex);
  tme_ieee754_global_ctl = ieee754_ctl;
  tme_ieee754_global_exceptions = 0;
  ieee754_ctl->tme_ieee754_ctl_lock_unlock = tme_ieee754_unlock_softfloat;

  /* assume that this operation raises no exceptions: */
  exceptions = 0;

  /* the operation: */
  _tme_ieee754_single_value_set(dst, float32,
    int64_to_float32(src0));

  /* leave softfloat operation: */
  tme_ieee754_global_ctl = NULL;
  exceptions |= tme_ieee754_global_exceptions;
  tme_mutex_unlock(&tme_ieee754_global_mutex);
  ieee754_ctl->tme_ieee754_ctl_lock_unlock = NULL;

  /* signal any exceptions: */
  if (exceptions != 0) {
    (*ieee754_ctl->tme_ieee754_ctl_exception)(ieee754_ctl, exceptions);
  }
}

#endif /* defined(TME_HAVE_INT64_T) */

/* this does a strict compliance single-precision to-int32: */
static void
_tme_ieee754_strict_single_to_int32(struct tme_ieee754_ctl *ieee754_ctl, const struct tme_float *src0, tme_int32_t *dst)
{
  tme_uint32_t src0_buffer;
  int exceptions;

  /* enter softfloat operation: */
  tme_mutex_lock(&tme_ieee754_global_mutex);
  tme_ieee754_global_ctl = ieee754_ctl;
  tme_ieee754_global_exceptions = 0;
  ieee754_ctl->tme_ieee754_ctl_lock_unlock = tme_ieee754_unlock_softfloat;

  /* assume that this operation raises no exceptions: */
  exceptions = 0;

  /* the operation: */
  *dst = float32_to_int32((*((const float32 *) tme_ieee754_single_value_get(src0, &src0_buffer))));

  /* leave softfloat operation: */
  tme_ieee754_global_ctl = NULL;
  exceptions |= tme_ieee754_global_exceptions;
  tme_mutex_unlock(&tme_ieee754_global_mutex);
  ieee754_ctl->tme_ieee754_ctl_lock_unlock = NULL;

  /* signal any exceptions: */
  if (exceptions != 0) {
    (*ieee754_ctl->tme_ieee754_ctl_exception)(ieee754_ctl, exceptions);
  }
}

#if defined(TME_HAVE_INT64_T)

/* this does a strict compliance single-precision to-int64: */
static void
_tme_ieee754_strict_single_to_int64(struct tme_ieee754_ctl *ieee754_ctl, const struct tme_float *src0, tme_int64_t *dst)
{
  tme_uint32_t src0_buffer;
  int exceptions;

  /* enter softfloat operation: */
  tme_mutex_lock(&tme_ieee754_global_mutex);
  tme_ieee754_global_ctl = ieee754_ctl;
  tme_ieee754_global_exceptions = 0;
  ieee754_ctl->tme_ieee754_ctl_lock_unlock = tme_ieee754_unlock_softfloat;

  /* assume that this operation raises no exceptions: */
  exceptions = 0;

  /* the operation: */
  *dst = float32_to_int64((*((const float32 *) tme_ieee754_single_value_get(src0, &src0_buffer))));

  /* leave softfloat operation: */
  tme_ieee754_global_ctl = NULL;
  exceptions |= tme_ieee754_global_exceptions;
  tme_mutex_unlock(&tme_ieee754_global_mutex);
  ieee754_ctl->tme_ieee754_ctl_lock_unlock = NULL;

  /* signal any exceptions: */
  if (exceptions != 0) {
    (*ieee754_ctl->tme_ieee754_ctl_exception)(ieee754_ctl, exceptions);
  }
}

#endif /* defined(TME_HAVE_INT64_T) */

/* this does a strict compliance double-precision add: */
static void
_tme_ieee754_strict_double_add(struct tme_ieee754_ctl *ieee754_ctl, const struct tme_float *src0, const struct tme_float *src1, struct tme_float *dst)
{
  union tme_value64 src0_buffer;
  union tme_value64 src1_buffer;
  int exceptions;

  /* enter softfloat operation: */
  tme_mutex_lock(&tme_ieee754_global_mutex);
  tme_ieee754_global_ctl = ieee754_ctl;
  tme_ieee754_global_exceptions = 0;
  ieee754_ctl->tme_ieee754_ctl_lock_unlock = tme_ieee754_unlock_softfloat;

  /* assume that this operation raises no exceptions: */
  exceptions = 0;

  /* the operation: */
  _tme_ieee754_double_value_set(dst, float64,
    float64_add((*((const float64 *) tme_ieee754_double_value_get(src0, &src0_buffer))),
                (*((const float64 *) tme_ieee754_double_value_get(src1, &src1_buffer)))));

  /* leave softfloat operation: */
  tme_ieee754_global_ctl = NULL;
  exceptions |= tme_ieee754_global_exceptions;
  tme_mutex_unlock(&tme_ieee754_global_mutex);
  ieee754_ctl->tme_ieee754_ctl_lock_unlock = NULL;

  /* signal any exceptions: */
  if (exceptions != 0) {
    (*ieee754_ctl->tme_ieee754_ctl_exception)(ieee754_ctl, exceptions);
  }
}

/* this does a strict compliance double-precision sub: */
static void
_tme_ieee754_strict_double_sub(struct tme_ieee754_ctl *ieee754_ctl, const struct tme_float *src0, const struct tme_float *src1, struct tme_float *dst)
{
  union tme_value64 src0_buffer;
  union tme_value64 src1_buffer;
  int exceptions;

  /* enter softfloat operation: */
  tme_mutex_lock(&tme_ieee754_global_mutex);
  tme_ieee754_global_ctl = ieee754_ctl;
  tme_ieee754_global_exceptions = 0;
  ieee754_ctl->tme_ieee754_ctl_lock_unlock = tme_ieee754_unlock_softfloat;

  /* assume that this operation raises no exceptions: */
  exceptions = 0;

  /* the operation: */
  _tme_ieee754_double_value_set(dst, float64,
    float64_sub((*((const float64 *) tme_ieee754_double_value_get(src0, &src0_buffer))),
                (*((const float64 *) tme_ieee754_double_value_get(src1, &src1_buffer)))));

  /* leave softfloat operation: */
  tme_ieee754_global_ctl = NULL;
  exceptions |= tme_ieee754_global_exceptions;
  tme_mutex_unlock(&tme_ieee754_global_mutex);
  ieee754_ctl->tme_ieee754_ctl_lock_unlock = NULL;

  /* signal any exceptions: */
  if (exceptions != 0) {
    (*ieee754_ctl->tme_ieee754_ctl_exception)(ieee754_ctl, exceptions);
  }
}

/* this does a strict compliance double-precision mul: */
static void
_tme_ieee754_strict_double_mul(struct tme_ieee754_ctl *ieee754_ctl, const struct tme_float *src0, const struct tme_float *src1, struct tme_float *dst)
{
  union tme_value64 src0_buffer;
  union tme_value64 src1_buffer;
  int exceptions;

  /* enter softfloat operation: */
  tme_mutex_lock(&tme_ieee754_global_mutex);
  tme_ieee754_global_ctl = ieee754_ctl;
  tme_ieee754_global_exceptions = 0;
  ieee754_ctl->tme_ieee754_ctl_lock_unlock = tme_ieee754_unlock_softfloat;

  /* assume that this operation raises no exceptions: */
  exceptions = 0;

  /* the operation: */
  _tme_ieee754_double_value_set(dst, float64,
    float64_mul((*((const float64 *) tme_ieee754_double_value_get(src0, &src0_buffer))),
                (*((const float64 *) tme_ieee754_double_value_get(src1, &src1_buffer)))));

  /* leave softfloat operation: */
  tme_ieee754_global_ctl = NULL;
  exceptions |= tme_ieee754_global_exceptions;
  tme_mutex_unlock(&tme_ieee754_global_mutex);
  ieee754_ctl->tme_ieee754_ctl_lock_unlock = NULL;

  /* signal any exceptions: */
  if (exceptions != 0) {
    (*ieee754_ctl->tme_ieee754_ctl_exception)(ieee754_ctl, exceptions);
  }
}

/* this does a strict compliance double-precision div: */
static void
_tme_ieee754_strict_double_div(struct tme_ieee754_ctl *ieee754_ctl, const struct tme_float *src0, const struct tme_float *src1, struct tme_float *dst)
{
  union tme_value64 src0_buffer;
  union tme_value64 src1_buffer;
  int exceptions;

  /* enter softfloat operation: */
  tme_mutex_lock(&tme_ieee754_global_mutex);
  tme_ieee754_global_ctl = ieee754_ctl;
  tme_ieee754_global_exceptions = 0;
  ieee754_ctl->tme_ieee754_ctl_lock_unlock = tme_ieee754_unlock_softfloat;

  /* assume that this operation raises no exceptions: */
  exceptions = 0;

  /* the operation: */
  _tme_ieee754_double_value_set(dst, float64,
    float64_div((*((const float64 *) tme_ieee754_double_value_get(src0, &src0_buffer))),
                (*((const float64 *) tme_ieee754_double_value_get(src1, &src1_buffer)))));

  /* leave softfloat operation: */
  tme_ieee754_global_ctl = NULL;
  exceptions |= tme_ieee754_global_exceptions;
  tme_mutex_unlock(&tme_ieee754_global_mutex);
  ieee754_ctl->tme_ieee754_ctl_lock_unlock = NULL;

  /* signal any exceptions: */
  if (exceptions != 0) {
    (*ieee754_ctl->tme_ieee754_ctl_exception)(ieee754_ctl, exceptions);
  }
}

/* this does a strict compliance double-precision rem: */
static void
_tme_ieee754_strict_double_rem(struct tme_ieee754_ctl *ieee754_ctl, const struct tme_float *src0, const struct tme_float *src1, struct tme_float *dst)
{
  union tme_value64 src0_buffer;
  union tme_value64 src1_buffer;
  int exceptions;

  /* enter softfloat operation: */
  tme_mutex_lock(&tme_ieee754_global_mutex);
  tme_ieee754_global_ctl = ieee754_ctl;
  tme_ieee754_global_exceptions = 0;
  ieee754_ctl->tme_ieee754_ctl_lock_unlock = tme_ieee754_unlock_softfloat;

  /* assume that this operation raises no exceptions: */
  exceptions = 0;

  /* the operation: */
  _tme_ieee754_double_value_set(dst, float64,
    float64_rem((*((const float64 *) tme_ieee754_double_value_get(src0, &src0_buffer))),
                (*((const float64 *) tme_ieee754_double_value_get(src1, &src1_buffer)))));

  /* leave softfloat operation: */
  tme_ieee754_global_ctl = NULL;
  exceptions |= tme_ieee754_global_exceptions;
  tme_mutex_unlock(&tme_ieee754_global_mutex);
  ieee754_ctl->tme_ieee754_ctl_lock_unlock = NULL;

  /* signal any exceptions: */
  if (exceptions != 0) {
    (*ieee754_ctl->tme_ieee754_ctl_exception)(ieee754_ctl, exceptions);
  }
}

/* this does a strict compliance double-precision sqrt: */
static void
_tme_ieee754_strict_double_sqrt(struct tme_ieee754_ctl *ieee754_ctl, const struct tme_float *src0, struct tme_float *dst)
{
  union tme_value64 src0_buffer;
  int exceptions;

  /* enter softfloat operation: */
  tme_mutex_lock(&tme_ieee754_global_mutex);
  tme_ieee754_global_ctl = ieee754_ctl;
  tme_ieee754_global_exceptions = 0;
  ieee754_ctl->tme_ieee754_ctl_lock_unlock = tme_ieee754_unlock_softfloat;

  /* assume that this operation raises no exceptions: */
  exceptions = 0;

  /* the operation: */
  _tme_ieee754_double_value_set(dst, float64,
    float64_sqrt((*((const float64 *) tme_ieee754_double_value_get(src0, &src0_buffer)))));

  /* leave softfloat operation: */
  tme_ieee754_global_ctl = NULL;
  exceptions |= tme_ieee754_global_exceptions;
  tme_mutex_unlock(&tme_ieee754_global_mutex);
  ieee754_ctl->tme_ieee754_ctl_lock_unlock = NULL;

  /* signal any exceptions: */
  if (exceptions != 0) {
    (*ieee754_ctl->tme_ieee754_ctl_exception)(ieee754_ctl, exceptions);
  }
}

/* this does a strict compliance double-precision neg: */
static void
_tme_ieee754_strict_double_neg(struct tme_ieee754_ctl *ieee754_ctl, const struct tme_float *src0, struct tme_float *dst)
{
  union tme_value64 src0_buffer;
  int exceptions;

  /* enter softfloat operation: */
  tme_mutex_lock(&tme_ieee754_global_mutex);
  tme_ieee754_global_ctl = ieee754_ctl;
  tme_ieee754_global_exceptions = 0;
  ieee754_ctl->tme_ieee754_ctl_lock_unlock = tme_ieee754_unlock_softfloat;

  /* assume that this operation raises no exceptions: */
  exceptions = 0;

  /* the operation: */
  _tme_ieee754_double_value_set(dst, float64,
    float64_mul(int32_to_float64(-1),
                (*((const float64 *) tme_ieee754_double_value_get(src0, &src0_buffer)))));

  /* leave softfloat operation: */
  tme_ieee754_global_ctl = NULL;
  exceptions |= tme_ieee754_global_exceptions;
  tme_mutex_unlock(&tme_ieee754_global_mutex);
  ieee754_ctl->tme_ieee754_ctl_lock_unlock = NULL;

  /* signal any exceptions: */
  if (exceptions != 0) {
    (*ieee754_ctl->tme_ieee754_ctl_exception)(ieee754_ctl, exceptions);
  }
}

/* this does a strict compliance double-precision move: */
static void
_tme_ieee754_strict_double_move(struct tme_ieee754_ctl *ieee754_ctl, const struct tme_float *src0, struct tme_float *dst)
{
  union tme_value64 src0_buffer;
  int exceptions;

  /* enter softfloat operation: */
  tme_mutex_lock(&tme_ieee754_global_mutex);
  tme_ieee754_global_ctl = ieee754_ctl;
  tme_ieee754_global_exceptions = 0;
  ieee754_ctl->tme_ieee754_ctl_lock_unlock = tme_ieee754_unlock_softfloat;

  /* assume that this operation raises no exceptions: */
  exceptions = 0;

  /* the operation: */
  _tme_ieee754_double_value_set(dst, float64,
    float64_add((*((const float64 *) tme_ieee754_double_value_get(src0, &src0_buffer))),
                int32_to_float64(0)));

  /* leave softfloat operation: */
  tme_ieee754_global_ctl = NULL;
  exceptions |= tme_ieee754_global_exceptions;
  tme_mutex_unlock(&tme_ieee754_global_mutex);
  ieee754_ctl->tme_ieee754_ctl_lock_unlock = NULL;

  /* signal any exceptions: */
  if (exceptions != 0) {
    (*ieee754_ctl->tme_ieee754_ctl_exception)(ieee754_ctl, exceptions);
  }
}

/* this does a strict compliance double-precision rint: */
static void
_tme_ieee754_strict_double_rint(struct tme_ieee754_ctl *ieee754_ctl, const struct tme_float *src0, struct tme_float *dst)
{
  union tme_value64 src0_buffer;
  int exceptions;

  /* enter softfloat operation: */
  tme_mutex_lock(&tme_ieee754_global_mutex);
  tme_ieee754_global_ctl = ieee754_ctl;
  tme_ieee754_global_exceptions = 0;
  ieee754_ctl->tme_ieee754_ctl_lock_unlock = tme_ieee754_unlock_softfloat;

  /* assume that this operation raises no exceptions: */
  exceptions = 0;

  /* the operation: */
  _tme_ieee754_double_value_set(dst, float64,
    float64_round_to_int((*((const float64 *) tme_ieee754_double_value_get(src0, &src0_buffer)))));

  /* leave softfloat operation: */
  tme_ieee754_global_ctl = NULL;
  exceptions |= tme_ieee754_global_exceptions;
  tme_mutex_unlock(&tme_ieee754_global_mutex);
  ieee754_ctl->tme_ieee754_ctl_lock_unlock = NULL;

  /* signal any exceptions: */
  if (exceptions != 0) {
    (*ieee754_ctl->tme_ieee754_ctl_exception)(ieee754_ctl, exceptions);
  }
}

/* this does a strict compliance double-precision getexp: */
static void
_tme_ieee754_strict_double_getexp(struct tme_ieee754_ctl *ieee754_ctl, const struct tme_float *src0, struct tme_float *dst)
{
  union tme_value64 src0_buffer;
  int exceptions;

  /* check for a NaN operand: */
  if (__tme_predict_false(tme_ieee754_double_check_nan_monadic(ieee754_ctl, src0, dst))) {
    return;
  }

  /* if the operand is an infinity: */
  if (tme_ieee754_double_is_inf(src0)) {

    /* return a NaN: */
    dst->tme_float_format = TME_FLOAT_FORMAT_IEEE754_DOUBLE;
    dst->tme_float_value_ieee754_double = ieee754_ctl->tme_ieee754_ctl_default_nan_double;
    return;
  }

  /* assume that this operation raises no exceptions: */
  exceptions = 0;

  /* the operation: */

  /* if the operand is a zero, return a zero: */
  if (tme_ieee754_double_is_zero(src0)) {
    tme_ieee754_double_value_builtin_set(dst, TME_FLOAT_FORMAT_IEEE754_DOUBLE_BUILTIN, 0);
  }

  /* otherwise, return the unbiased exponent: */
  else {
    tme_ieee754_double_value_builtin_set(dst, TME_FLOAT_FORMAT_IEEE754_DOUBLE_BUILTIN, TME_FIELD_MASK_EXTRACTU((*tme_ieee754_double_value_get(src0, &src0_buffer)).tme_value64_uint32_hi, ((tme_uint32_t) 0x7ff00000)) - ((((tme_uint32_t) 0x7ff00000) / _TME_FIELD_MASK_FACTOR(((tme_uint32_t) 0x7ff00000))) >> 1));
  }
  ieee754_ctl->tme_ieee754_ctl_lock_unlock = NULL;

  /* signal any exceptions: */
  if (exceptions != 0) {
    (*ieee754_ctl->tme_ieee754_ctl_exception)(ieee754_ctl, exceptions);
  }
}

/* this does a strict compliance double-precision getman: */
static void
_tme_ieee754_strict_double_getman(struct tme_ieee754_ctl *ieee754_ctl, const struct tme_float *src0, struct tme_float *dst)
{
  union tme_value64 src0_buffer;
  int exceptions;

  /* check for a NaN operand: */
  if (__tme_predict_false(tme_ieee754_double_check_nan_monadic(ieee754_ctl, src0, dst))) {
    return;
  }

  /* if the operand is an infinity: */
  if (tme_ieee754_double_is_inf(src0)) {

    /* return a NaN: */
    dst->tme_float_format = TME_FLOAT_FORMAT_IEEE754_DOUBLE;
    dst->tme_float_value_ieee754_double = ieee754_ctl->tme_ieee754_ctl_default_nan_double;
    return;
  }

  /* assume that this operation raises no exceptions: */
  exceptions = 0;

  /* the operation: */

  /* if the operand is a zero, return it: */
  if (tme_ieee754_double_is_zero(src0)) {
    *dst = *src0;
  }

  /* otherwise, return the operand, with its exponent set to biased zero: */
  else {
    tme_ieee754_double_value_set(dst, (*tme_ieee754_double_value_get(src0, &src0_buffer)));
    TME_FIELD_MASK_DEPOSITU(dst->tme_float_value_ieee754_double.tme_value64_uint32_hi, ((tme_uint32_t) 0x7ff00000), ((((tme_uint32_t) 0x7ff00000) / _TME_FIELD_MASK_FACTOR(((tme_uint32_t) 0x7ff00000))) >> 1));
  }
  ieee754_ctl->tme_ieee754_ctl_lock_unlock = NULL;

  /* signal any exceptions: */
  if (exceptions != 0) {
    (*ieee754_ctl->tme_ieee754_ctl_exception)(ieee754_ctl, exceptions);
  }
}

/* this does a strict compliance double-precision from-single: */
static void
_tme_ieee754_strict_double_from_single(struct tme_ieee754_ctl *ieee754_ctl, const struct tme_float *src0, struct tme_float *dst)
{
  tme_uint32_t src0_buffer;
  int exceptions;

  /* enter softfloat operation: */
  tme_mutex_lock(&tme_ieee754_global_mutex);
  tme_ieee754_global_ctl = ieee754_ctl;
  tme_ieee754_global_exceptions = 0;
  ieee754_ctl->tme_ieee754_ctl_lock_unlock = tme_ieee754_unlock_softfloat;

  /* assume that this operation raises no exceptions: */
  exceptions = 0;

  /* the operation: */
  _tme_ieee754_double_value_set(dst, float64,
    float32_to_float64((*((const float32 *) tme_ieee754_single_value_get(src0, &src0_buffer)))));

  /* leave softfloat operation: */
  tme_ieee754_global_ctl = NULL;
  exceptions |= tme_ieee754_global_exceptions;
  tme_mutex_unlock(&tme_ieee754_global_mutex);
  ieee754_ctl->tme_ieee754_ctl_lock_unlock = NULL;

  /* signal any exceptions: */
  if (exceptions != 0) {
    (*ieee754_ctl->tme_ieee754_ctl_exception)(ieee754_ctl, exceptions);
  }
}

/* this does a strict compliance double-precision from-extended80: */
static void
_tme_ieee754_strict_double_from_extended80(struct tme_ieee754_ctl *ieee754_ctl, const struct tme_float *src0, struct tme_float *dst)
{
  struct tme_float_ieee754_extended80 src0_buffer;
  int exceptions;

  /* enter softfloat operation: */
  tme_mutex_lock(&tme_ieee754_global_mutex);
  tme_ieee754_global_ctl = ieee754_ctl;
  tme_ieee754_global_exceptions = 0;
  ieee754_ctl->tme_ieee754_ctl_lock_unlock = tme_ieee754_unlock_softfloat;

  /* assume that this operation raises no exceptions: */
  exceptions = 0;

  /* the operation: */
  _tme_ieee754_double_value_set(dst, float64,
    floatx80_to_float64((*((const floatx80 *) tme_ieee754_extended80_value_get(src0, &src0_buffer)))));

  /* leave softfloat operation: */
  tme_ieee754_global_ctl = NULL;
  exceptions |= tme_ieee754_global_exceptions;
  tme_mutex_unlock(&tme_ieee754_global_mutex);
  ieee754_ctl->tme_ieee754_ctl_lock_unlock = NULL;

  /* signal any exceptions: */
  if (exceptions != 0) {
    (*ieee754_ctl->tme_ieee754_ctl_exception)(ieee754_ctl, exceptions);
  }
}

/* this does a strict compliance double-precision from-quad: */
static void
_tme_ieee754_strict_double_from_quad(struct tme_ieee754_ctl *ieee754_ctl, const struct tme_float *src0, struct tme_float *dst)
{
  struct tme_float_ieee754_quad src0_buffer;
  int exceptions;

  /* enter softfloat operation: */
  tme_mutex_lock(&tme_ieee754_global_mutex);
  tme_ieee754_global_ctl = ieee754_ctl;
  tme_ieee754_global_exceptions = 0;
  ieee754_ctl->tme_ieee754_ctl_lock_unlock = tme_ieee754_unlock_softfloat;

  /* assume that this operation raises no exceptions: */
  exceptions = 0;

  /* the operation: */
  _tme_ieee754_double_value_set(dst, float64,
    float128_to_float64((*((const float128 *) tme_ieee754_quad_value_get(src0, &src0_buffer)))));

  /* leave softfloat operation: */
  tme_ieee754_global_ctl = NULL;
  exceptions |= tme_ieee754_global_exceptions;
  tme_mutex_unlock(&tme_ieee754_global_mutex);
  ieee754_ctl->tme_ieee754_ctl_lock_unlock = NULL;

  /* signal any exceptions: */
  if (exceptions != 0) {
    (*ieee754_ctl->tme_ieee754_ctl_exception)(ieee754_ctl, exceptions);
  }
}

/* this does a strict compliance double-precision from-int32: */
static void
_tme_ieee754_strict_double_from_int32(struct tme_ieee754_ctl *ieee754_ctl, const tme_int32_t src0, struct tme_float *dst)
{
  int exceptions;

  /* enter softfloat operation: */
  tme_mutex_lock(&tme_ieee754_global_mutex);
  tme_ieee754_global_ctl = ieee754_ctl;
  tme_ieee754_global_exceptions = 0;
  ieee754_ctl->tme_ieee754_ctl_lock_unlock = tme_ieee754_unlock_softfloat;

  /* assume that this operation raises no exceptions: */
  exceptions = 0;

  /* the operation: */
  _tme_ieee754_double_value_set(dst, float64,
    int32_to_float64(src0));

  /* leave softfloat operation: */
  tme_ieee754_global_ctl = NULL;
  exceptions |= tme_ieee754_global_exceptions;
  tme_mutex_unlock(&tme_ieee754_global_mutex);
  ieee754_ctl->tme_ieee754_ctl_lock_unlock = NULL;

  /* signal any exceptions: */
  if (exceptions != 0) {
    (*ieee754_ctl->tme_ieee754_ctl_exception)(ieee754_ctl, exceptions);
  }
}

#if defined(TME_HAVE_INT64_T)

/* this does a strict compliance double-precision from-int64: */
static void
_tme_ieee754_strict_double_from_int64(struct tme_ieee754_ctl *ieee754_ctl, const tme_int64_t src0, struct tme_float *dst)
{
  int exceptions;

  /* enter softfloat operation: */
  tme_mutex_lock(&tme_ieee754_global_mutex);
  tme_ieee754_global_ctl = ieee754_ctl;
  tme_ieee754_global_exceptions = 0;
  ieee754_ctl->tme_ieee754_ctl_lock_unlock = tme_ieee754_unlock_softfloat;

  /* assume that this operation raises no exceptions: */
  exceptions = 0;

  /* the operation: */
  _tme_ieee754_double_value_set(dst, float64,
    int64_to_float64(src0));

  /* leave softfloat operation: */
  tme_ieee754_global_ctl = NULL;
  exceptions |= tme_ieee754_global_exceptions;
  tme_mutex_unlock(&tme_ieee754_global_mutex);
  ieee754_ctl->tme_ieee754_ctl_lock_unlock = NULL;

  /* signal any exceptions: */
  if (exceptions != 0) {
    (*ieee754_ctl->tme_ieee754_ctl_exception)(ieee754_ctl, exceptions);
  }
}

#endif /* defined(TME_HAVE_INT64_T) */

/* this does a strict compliance double-precision to-int32: */
static void
_tme_ieee754_strict_double_to_int32(struct tme_ieee754_ctl *ieee754_ctl, const struct tme_float *src0, tme_int32_t *dst)
{
  union tme_value64 src0_buffer;
  int exceptions;

  /* enter softfloat operation: */
  tme_mutex_lock(&tme_ieee754_global_mutex);
  tme_ieee754_global_ctl = ieee754_ctl;
  tme_ieee754_global_exceptions = 0;
  ieee754_ctl->tme_ieee754_ctl_lock_unlock = tme_ieee754_unlock_softfloat;

  /* assume that this operation raises no exceptions: */
  exceptions = 0;

  /* the operation: */
  *dst = float64_to_int32((*((const float64 *) tme_ieee754_double_value_get(src0, &src0_buffer))));

  /* leave softfloat operation: */
  tme_ieee754_global_ctl = NULL;
  exceptions |= tme_ieee754_global_exceptions;
  tme_mutex_unlock(&tme_ieee754_global_mutex);
  ieee754_ctl->tme_ieee754_ctl_lock_unlock = NULL;

  /* signal any exceptions: */
  if (exceptions != 0) {
    (*ieee754_ctl->tme_ieee754_ctl_exception)(ieee754_ctl, exceptions);
  }
}

#if defined(TME_HAVE_INT64_T)

/* this does a strict compliance double-precision to-int64: */
static void
_tme_ieee754_strict_double_to_int64(struct tme_ieee754_ctl *ieee754_ctl, const struct tme_float *src0, tme_int64_t *dst)
{
  union tme_value64 src0_buffer;
  int exceptions;

  /* enter softfloat operation: */
  tme_mutex_lock(&tme_ieee754_global_mutex);
  tme_ieee754_global_ctl = ieee754_ctl;
  tme_ieee754_global_exceptions = 0;
  ieee754_ctl->tme_ieee754_ctl_lock_unlock = tme_ieee754_unlock_softfloat;

  /* assume that this operation raises no exceptions: */
  exceptions = 0;

  /* the operation: */
  *dst = float64_to_int64((*((const float64 *) tme_ieee754_double_value_get(src0, &src0_buffer))));

  /* leave softfloat operation: */
  tme_ieee754_global_ctl = NULL;
  exceptions |= tme_ieee754_global_exceptions;
  tme_mutex_unlock(&tme_ieee754_global_mutex);
  ieee754_ctl->tme_ieee754_ctl_lock_unlock = NULL;

  /* signal any exceptions: */
  if (exceptions != 0) {
    (*ieee754_ctl->tme_ieee754_ctl_exception)(ieee754_ctl, exceptions);
  }
}

#endif /* defined(TME_HAVE_INT64_T) */

#if defined(TME_HAVE_INT64_T)

/* this does a strict compliance extended80-precision add: */
static void
_tme_ieee754_strict_extended80_add(struct tme_ieee754_ctl *ieee754_ctl, const struct tme_float *src0, const struct tme_float *src1, struct tme_float *dst)
{
  struct tme_float_ieee754_extended80 src0_buffer;
  struct tme_float_ieee754_extended80 src1_buffer;
  int exceptions;

  /* enter softfloat operation: */
  tme_mutex_lock(&tme_ieee754_global_mutex);
  tme_ieee754_global_ctl = ieee754_ctl;
  tme_ieee754_global_exceptions = 0;
  ieee754_ctl->tme_ieee754_ctl_lock_unlock = tme_ieee754_unlock_softfloat;

  /* assume that this operation raises no exceptions: */
  exceptions = 0;

  /* the operation: */
  _tme_ieee754_extended80_value_set(dst, floatx80,
    floatx80_add((*((const floatx80 *) tme_ieee754_extended80_value_get(src0, &src0_buffer))),
                (*((const floatx80 *) tme_ieee754_extended80_value_get(src1, &src1_buffer)))));

  /* leave softfloat operation: */
  tme_ieee754_global_ctl = NULL;
  exceptions |= tme_ieee754_global_exceptions;
  tme_mutex_unlock(&tme_ieee754_global_mutex);
  ieee754_ctl->tme_ieee754_ctl_lock_unlock = NULL;

  /* signal any exceptions: */
  if (exceptions != 0) {
    (*ieee754_ctl->tme_ieee754_ctl_exception)(ieee754_ctl, exceptions);
  }
}

#endif /* defined(TME_HAVE_INT64_T) */

#if defined(TME_HAVE_INT64_T)

/* this does a strict compliance extended80-precision sub: */
static void
_tme_ieee754_strict_extended80_sub(struct tme_ieee754_ctl *ieee754_ctl, const struct tme_float *src0, const struct tme_float *src1, struct tme_float *dst)
{
  struct tme_float_ieee754_extended80 src0_buffer;
  struct tme_float_ieee754_extended80 src1_buffer;
  int exceptions;

  /* enter softfloat operation: */
  tme_mutex_lock(&tme_ieee754_global_mutex);
  tme_ieee754_global_ctl = ieee754_ctl;
  tme_ieee754_global_exceptions = 0;
  ieee754_ctl->tme_ieee754_ctl_lock_unlock = tme_ieee754_unlock_softfloat;

  /* assume that this operation raises no exceptions: */
  exceptions = 0;

  /* the operation: */
  _tme_ieee754_extended80_value_set(dst, floatx80,
    floatx80_sub((*((const floatx80 *) tme_ieee754_extended80_value_get(src0, &src0_buffer))),
                (*((const floatx80 *) tme_ieee754_extended80_value_get(src1, &src1_buffer)))));

  /* leave softfloat operation: */
  tme_ieee754_global_ctl = NULL;
  exceptions |= tme_ieee754_global_exceptions;
  tme_mutex_unlock(&tme_ieee754_global_mutex);
  ieee754_ctl->tme_ieee754_ctl_lock_unlock = NULL;

  /* signal any exceptions: */
  if (exceptions != 0) {
    (*ieee754_ctl->tme_ieee754_ctl_exception)(ieee754_ctl, exceptions);
  }
}

#endif /* defined(TME_HAVE_INT64_T) */

#if defined(TME_HAVE_INT64_T)

/* this does a strict compliance extended80-precision mul: */
static void
_tme_ieee754_strict_extended80_mul(struct tme_ieee754_ctl *ieee754_ctl, const struct tme_float *src0, const struct tme_float *src1, struct tme_float *dst)
{
  struct tme_float_ieee754_extended80 src0_buffer;
  struct tme_float_ieee754_extended80 src1_buffer;
  int exceptions;

  /* enter softfloat operation: */
  tme_mutex_lock(&tme_ieee754_global_mutex);
  tme_ieee754_global_ctl = ieee754_ctl;
  tme_ieee754_global_exceptions = 0;
  ieee754_ctl->tme_ieee754_ctl_lock_unlock = tme_ieee754_unlock_softfloat;

  /* assume that this operation raises no exceptions: */
  exceptions = 0;

  /* the operation: */
  _tme_ieee754_extended80_value_set(dst, floatx80,
    floatx80_mul((*((const floatx80 *) tme_ieee754_extended80_value_get(src0, &src0_buffer))),
                (*((const floatx80 *) tme_ieee754_extended80_value_get(src1, &src1_buffer)))));

  /* leave softfloat operation: */
  tme_ieee754_global_ctl = NULL;
  exceptions |= tme_ieee754_global_exceptions;
  tme_mutex_unlock(&tme_ieee754_global_mutex);
  ieee754_ctl->tme_ieee754_ctl_lock_unlock = NULL;

  /* signal any exceptions: */
  if (exceptions != 0) {
    (*ieee754_ctl->tme_ieee754_ctl_exception)(ieee754_ctl, exceptions);
  }
}

#endif /* defined(TME_HAVE_INT64_T) */

#if defined(TME_HAVE_INT64_T)

/* this does a strict compliance extended80-precision div: */
static void
_tme_ieee754_strict_extended80_div(struct tme_ieee754_ctl *ieee754_ctl, const struct tme_float *src0, const struct tme_float *src1, struct tme_float *dst)
{
  struct tme_float_ieee754_extended80 src0_buffer;
  struct tme_float_ieee754_extended80 src1_buffer;
  int exceptions;

  /* enter softfloat operation: */
  tme_mutex_lock(&tme_ieee754_global_mutex);
  tme_ieee754_global_ctl = ieee754_ctl;
  tme_ieee754_global_exceptions = 0;
  ieee754_ctl->tme_ieee754_ctl_lock_unlock = tme_ieee754_unlock_softfloat;

  /* assume that this operation raises no exceptions: */
  exceptions = 0;

  /* the operation: */
  _tme_ieee754_extended80_value_set(dst, floatx80,
    floatx80_div((*((const floatx80 *) tme_ieee754_extended80_value_get(src0, &src0_buffer))),
                (*((const floatx80 *) tme_ieee754_extended80_value_get(src1, &src1_buffer)))));

  /* leave softfloat operation: */
  tme_ieee754_global_ctl = NULL;
  exceptions |= tme_ieee754_global_exceptions;
  tme_mutex_unlock(&tme_ieee754_global_mutex);
  ieee754_ctl->tme_ieee754_ctl_lock_unlock = NULL;

  /* signal any exceptions: */
  if (exceptions != 0) {
    (*ieee754_ctl->tme_ieee754_ctl_exception)(ieee754_ctl, exceptions);
  }
}

#endif /* defined(TME_HAVE_INT64_T) */

#if defined(TME_HAVE_INT64_T)

/* this does a strict compliance extended80-precision rem: */
static void
_tme_ieee754_strict_extended80_rem(struct tme_ieee754_ctl *ieee754_ctl, const struct tme_float *src0, const struct tme_float *src1, struct tme_float *dst)
{
  struct tme_float_ieee754_extended80 src0_buffer;
  struct tme_float_ieee754_extended80 src1_buffer;
  int exceptions;

  /* enter softfloat operation: */
  tme_mutex_lock(&tme_ieee754_global_mutex);
  tme_ieee754_global_ctl = ieee754_ctl;
  tme_ieee754_global_exceptions = 0;
  ieee754_ctl->tme_ieee754_ctl_lock_unlock = tme_ieee754_unlock_softfloat;

  /* assume that this operation raises no exceptions: */
  exceptions = 0;

  /* the operation: */
  _tme_ieee754_extended80_value_set(dst, floatx80,
    floatx80_rem((*((const floatx80 *) tme_ieee754_extended80_value_get(src0, &src0_buffer))),
                (*((const floatx80 *) tme_ieee754_extended80_value_get(src1, &src1_buffer)))));

  /* leave softfloat operation: */
  tme_ieee754_global_ctl = NULL;
  exceptions |= tme_ieee754_global_exceptions;
  tme_mutex_unlock(&tme_ieee754_global_mutex);
  ieee754_ctl->tme_ieee754_ctl_lock_unlock = NULL;

  /* signal any exceptions: */
  if (exceptions != 0) {
    (*ieee754_ctl->tme_ieee754_ctl_exception)(ieee754_ctl, exceptions);
  }
}

#endif /* defined(TME_HAVE_INT64_T) */

#if defined(TME_HAVE_INT64_T)

/* this does a strict compliance extended80-precision sqrt: */
static void
_tme_ieee754_strict_extended80_sqrt(struct tme_ieee754_ctl *ieee754_ctl, const struct tme_float *src0, struct tme_float *dst)
{
  struct tme_float_ieee754_extended80 src0_buffer;
  int exceptions;

  /* enter softfloat operation: */
  tme_mutex_lock(&tme_ieee754_global_mutex);
  tme_ieee754_global_ctl = ieee754_ctl;
  tme_ieee754_global_exceptions = 0;
  ieee754_ctl->tme_ieee754_ctl_lock_unlock = tme_ieee754_unlock_softfloat;

  /* assume that this operation raises no exceptions: */
  exceptions = 0;

  /* the operation: */
  _tme_ieee754_extended80_value_set(dst, floatx80,
    floatx80_sqrt((*((const floatx80 *) tme_ieee754_extended80_value_get(src0, &src0_buffer)))));

  /* leave softfloat operation: */
  tme_ieee754_global_ctl = NULL;
  exceptions |= tme_ieee754_global_exceptions;
  tme_mutex_unlock(&tme_ieee754_global_mutex);
  ieee754_ctl->tme_ieee754_ctl_lock_unlock = NULL;

  /* signal any exceptions: */
  if (exceptions != 0) {
    (*ieee754_ctl->tme_ieee754_ctl_exception)(ieee754_ctl, exceptions);
  }
}

#endif /* defined(TME_HAVE_INT64_T) */

#if defined(TME_HAVE_INT64_T)

/* this does a strict compliance extended80-precision neg: */
static void
_tme_ieee754_strict_extended80_neg(struct tme_ieee754_ctl *ieee754_ctl, const struct tme_float *src0, struct tme_float *dst)
{
  struct tme_float_ieee754_extended80 src0_buffer;
  int exceptions;

  /* enter softfloat operation: */
  tme_mutex_lock(&tme_ieee754_global_mutex);
  tme_ieee754_global_ctl = ieee754_ctl;
  tme_ieee754_global_exceptions = 0;
  ieee754_ctl->tme_ieee754_ctl_lock_unlock = tme_ieee754_unlock_softfloat;

  /* assume that this operation raises no exceptions: */
  exceptions = 0;

  /* the operation: */
  _tme_ieee754_extended80_value_set(dst, floatx80,
    floatx80_mul(int32_to_floatx80(-1),
                (*((const floatx80 *) tme_ieee754_extended80_value_get(src0, &src0_buffer)))));

  /* leave softfloat operation: */
  tme_ieee754_global_ctl = NULL;
  exceptions |= tme_ieee754_global_exceptions;
  tme_mutex_unlock(&tme_ieee754_global_mutex);
  ieee754_ctl->tme_ieee754_ctl_lock_unlock = NULL;

  /* signal any exceptions: */
  if (exceptions != 0) {
    (*ieee754_ctl->tme_ieee754_ctl_exception)(ieee754_ctl, exceptions);
  }
}

#endif /* defined(TME_HAVE_INT64_T) */

#if defined(TME_HAVE_INT64_T)

/* this does a strict compliance extended80-precision move: */
static void
_tme_ieee754_strict_extended80_move(struct tme_ieee754_ctl *ieee754_ctl, const struct tme_float *src0, struct tme_float *dst)
{
  struct tme_float_ieee754_extended80 src0_buffer;
  int exceptions;

  /* enter softfloat operation: */
  tme_mutex_lock(&tme_ieee754_global_mutex);
  tme_ieee754_global_ctl = ieee754_ctl;
  tme_ieee754_global_exceptions = 0;
  ieee754_ctl->tme_ieee754_ctl_lock_unlock = tme_ieee754_unlock_softfloat;

  /* assume that this operation raises no exceptions: */
  exceptions = 0;

  /* the operation: */
  _tme_ieee754_extended80_value_set(dst, floatx80,
    floatx80_add((*((const floatx80 *) tme_ieee754_extended80_value_get(src0, &src0_buffer))),
                int32_to_floatx80(0)));

  /* leave softfloat operation: */
  tme_ieee754_global_ctl = NULL;
  exceptions |= tme_ieee754_global_exceptions;
  tme_mutex_unlock(&tme_ieee754_global_mutex);
  ieee754_ctl->tme_ieee754_ctl_lock_unlock = NULL;

  /* signal any exceptions: */
  if (exceptions != 0) {
    (*ieee754_ctl->tme_ieee754_ctl_exception)(ieee754_ctl, exceptions);
  }
}

#endif /* defined(TME_HAVE_INT64_T) */

#if defined(TME_HAVE_INT64_T)

/* this does a strict compliance extended80-precision rint: */
static void
_tme_ieee754_strict_extended80_rint(struct tme_ieee754_ctl *ieee754_ctl, const struct tme_float *src0, struct tme_float *dst)
{
  struct tme_float_ieee754_extended80 src0_buffer;
  int exceptions;

  /* enter softfloat operation: */
  tme_mutex_lock(&tme_ieee754_global_mutex);
  tme_ieee754_global_ctl = ieee754_ctl;
  tme_ieee754_global_exceptions = 0;
  ieee754_ctl->tme_ieee754_ctl_lock_unlock = tme_ieee754_unlock_softfloat;

  /* assume that this operation raises no exceptions: */
  exceptions = 0;

  /* the operation: */
  _tme_ieee754_extended80_value_set(dst, floatx80,
    floatx80_round_to_int((*((const floatx80 *) tme_ieee754_extended80_value_get(src0, &src0_buffer)))));

  /* leave softfloat operation: */
  tme_ieee754_global_ctl = NULL;
  exceptions |= tme_ieee754_global_exceptions;
  tme_mutex_unlock(&tme_ieee754_global_mutex);
  ieee754_ctl->tme_ieee754_ctl_lock_unlock = NULL;

  /* signal any exceptions: */
  if (exceptions != 0) {
    (*ieee754_ctl->tme_ieee754_ctl_exception)(ieee754_ctl, exceptions);
  }
}

#endif /* defined(TME_HAVE_INT64_T) */

/* this does a strict compliance extended80-precision getexp: */
static void
_tme_ieee754_strict_extended80_getexp(struct tme_ieee754_ctl *ieee754_ctl, const struct tme_float *src0, struct tme_float *dst)
{
  struct tme_float_ieee754_extended80 src0_buffer;
  int exceptions;

  /* check for a NaN operand: */
  if (__tme_predict_false(tme_ieee754_extended80_check_nan_monadic(ieee754_ctl, src0, dst))) {
    return;
  }

  /* if the operand is an infinity: */
  if (tme_ieee754_extended80_is_inf(src0)) {

    /* return a NaN: */
    dst->tme_float_format = TME_FLOAT_FORMAT_IEEE754_EXTENDED80;
    dst->tme_float_value_ieee754_extended80 = ieee754_ctl->tme_ieee754_ctl_default_nan_extended80;
    return;
  }

  /* assume that this operation raises no exceptions: */
  exceptions = 0;

  /* the operation: */

  /* if the operand is a zero, return a zero: */
  if (tme_ieee754_extended80_is_zero(src0)) {
    tme_ieee754_extended80_value_builtin_set(dst, TME_FLOAT_FORMAT_IEEE754_EXTENDED80_BUILTIN, 0);
  }

  /* otherwise, return the unbiased exponent: */
  else {
    tme_ieee754_extended80_value_builtin_set(dst, TME_FLOAT_FORMAT_IEEE754_EXTENDED80_BUILTIN, TME_FIELD_MASK_EXTRACTU((*tme_ieee754_extended80_value_get(src0, &src0_buffer)).tme_float_ieee754_extended80_sexp, ((tme_uint32_t) 0x7fff)) - ((((tme_uint32_t) 0x7fff) / _TME_FIELD_MASK_FACTOR(((tme_uint32_t) 0x7fff))) >> 1));
  }
  ieee754_ctl->tme_ieee754_ctl_lock_unlock = NULL;

  /* signal any exceptions: */
  if (exceptions != 0) {
    (*ieee754_ctl->tme_ieee754_ctl_exception)(ieee754_ctl, exceptions);
  }
}

/* this does a strict compliance extended80-precision getman: */
static void
_tme_ieee754_strict_extended80_getman(struct tme_ieee754_ctl *ieee754_ctl, const struct tme_float *src0, struct tme_float *dst)
{
  struct tme_float_ieee754_extended80 src0_buffer;
  int exceptions;

  /* check for a NaN operand: */
  if (__tme_predict_false(tme_ieee754_extended80_check_nan_monadic(ieee754_ctl, src0, dst))) {
    return;
  }

  /* if the operand is an infinity: */
  if (tme_ieee754_extended80_is_inf(src0)) {

    /* return a NaN: */
    dst->tme_float_format = TME_FLOAT_FORMAT_IEEE754_EXTENDED80;
    dst->tme_float_value_ieee754_extended80 = ieee754_ctl->tme_ieee754_ctl_default_nan_extended80;
    return;
  }

  /* assume that this operation raises no exceptions: */
  exceptions = 0;

  /* the operation: */

  /* if the operand is a zero, return it: */
  if (tme_ieee754_extended80_is_zero(src0)) {
    *dst = *src0;
  }

  /* otherwise, return the operand, with its exponent set to biased zero: */
  else {
    tme_ieee754_extended80_value_set(dst, (*tme_ieee754_extended80_value_get(src0, &src0_buffer)));
    TME_FIELD_MASK_DEPOSITU(dst->tme_float_value_ieee754_extended80.tme_float_ieee754_extended80_sexp, ((tme_uint32_t) 0x7fff), ((((tme_uint32_t) 0x7fff) / _TME_FIELD_MASK_FACTOR(((tme_uint32_t) 0x7fff))) >> 1));
  }
  ieee754_ctl->tme_ieee754_ctl_lock_unlock = NULL;

  /* signal any exceptions: */
  if (exceptions != 0) {
    (*ieee754_ctl->tme_ieee754_ctl_exception)(ieee754_ctl, exceptions);
  }
}

#if defined(TME_HAVE_INT64_T)

/* this does a strict compliance extended80-precision from-single: */
static void
_tme_ieee754_strict_extended80_from_single(struct tme_ieee754_ctl *ieee754_ctl, const struct tme_float *src0, struct tme_float *dst)
{
  tme_uint32_t src0_buffer;
  int exceptions;

  /* enter softfloat operation: */
  tme_mutex_lock(&tme_ieee754_global_mutex);
  tme_ieee754_global_ctl = ieee754_ctl;
  tme_ieee754_global_exceptions = 0;
  ieee754_ctl->tme_ieee754_ctl_lock_unlock = tme_ieee754_unlock_softfloat;

  /* assume that this operation raises no exceptions: */
  exceptions = 0;

  /* the operation: */
  _tme_ieee754_extended80_value_set(dst, floatx80,
    float32_to_floatx80((*((const float32 *) tme_ieee754_single_value_get(src0, &src0_buffer)))));

  /* leave softfloat operation: */
  tme_ieee754_global_ctl = NULL;
  exceptions |= tme_ieee754_global_exceptions;
  tme_mutex_unlock(&tme_ieee754_global_mutex);
  ieee754_ctl->tme_ieee754_ctl_lock_unlock = NULL;

  /* signal any exceptions: */
  if (exceptions != 0) {
    (*ieee754_ctl->tme_ieee754_ctl_exception)(ieee754_ctl, exceptions);
  }
}

#endif /* defined(TME_HAVE_INT64_T) */

#if defined(TME_HAVE_INT64_T)

/* this does a strict compliance extended80-precision from-double: */
static void
_tme_ieee754_strict_extended80_from_double(struct tme_ieee754_ctl *ieee754_ctl, const struct tme_float *src0, struct tme_float *dst)
{
  union tme_value64 src0_buffer;
  int exceptions;

  /* enter softfloat operation: */
  tme_mutex_lock(&tme_ieee754_global_mutex);
  tme_ieee754_global_ctl = ieee754_ctl;
  tme_ieee754_global_exceptions = 0;
  ieee754_ctl->tme_ieee754_ctl_lock_unlock = tme_ieee754_unlock_softfloat;

  /* assume that this operation raises no exceptions: */
  exceptions = 0;

  /* the operation: */
  _tme_ieee754_extended80_value_set(dst, floatx80,
    float64_to_floatx80((*((const float64 *) tme_ieee754_double_value_get(src0, &src0_buffer)))));

  /* leave softfloat operation: */
  tme_ieee754_global_ctl = NULL;
  exceptions |= tme_ieee754_global_exceptions;
  tme_mutex_unlock(&tme_ieee754_global_mutex);
  ieee754_ctl->tme_ieee754_ctl_lock_unlock = NULL;

  /* signal any exceptions: */
  if (exceptions != 0) {
    (*ieee754_ctl->tme_ieee754_ctl_exception)(ieee754_ctl, exceptions);
  }
}

#endif /* defined(TME_HAVE_INT64_T) */

#if defined(TME_HAVE_INT64_T)

/* this does a strict compliance extended80-precision from-quad: */
static void
_tme_ieee754_strict_extended80_from_quad(struct tme_ieee754_ctl *ieee754_ctl, const struct tme_float *src0, struct tme_float *dst)
{
  struct tme_float_ieee754_quad src0_buffer;
  int exceptions;

  /* enter softfloat operation: */
  tme_mutex_lock(&tme_ieee754_global_mutex);
  tme_ieee754_global_ctl = ieee754_ctl;
  tme_ieee754_global_exceptions = 0;
  ieee754_ctl->tme_ieee754_ctl_lock_unlock = tme_ieee754_unlock_softfloat;

  /* assume that this operation raises no exceptions: */
  exceptions = 0;

  /* the operation: */
  _tme_ieee754_extended80_value_set(dst, floatx80,
    float128_to_floatx80((*((const float128 *) tme_ieee754_quad_value_get(src0, &src0_buffer)))));

  /* leave softfloat operation: */
  tme_ieee754_global_ctl = NULL;
  exceptions |= tme_ieee754_global_exceptions;
  tme_mutex_unlock(&tme_ieee754_global_mutex);
  ieee754_ctl->tme_ieee754_ctl_lock_unlock = NULL;

  /* signal any exceptions: */
  if (exceptions != 0) {
    (*ieee754_ctl->tme_ieee754_ctl_exception)(ieee754_ctl, exceptions);
  }
}

#endif /* defined(TME_HAVE_INT64_T) */

#if defined(TME_HAVE_INT64_T)

/* this does a strict compliance extended80-precision from-int32: */
static void
_tme_ieee754_strict_extended80_from_int32(struct tme_ieee754_ctl *ieee754_ctl, const tme_int32_t src0, struct tme_float *dst)
{
  int exceptions;

  /* enter softfloat operation: */
  tme_mutex_lock(&tme_ieee754_global_mutex);
  tme_ieee754_global_ctl = ieee754_ctl;
  tme_ieee754_global_exceptions = 0;
  ieee754_ctl->tme_ieee754_ctl_lock_unlock = tme_ieee754_unlock_softfloat;

  /* assume that this operation raises no exceptions: */
  exceptions = 0;

  /* the operation: */
  _tme_ieee754_extended80_value_set(dst, floatx80,
    int32_to_floatx80(src0));

  /* leave softfloat operation: */
  tme_ieee754_global_ctl = NULL;
  exceptions |= tme_ieee754_global_exceptions;
  tme_mutex_unlock(&tme_ieee754_global_mutex);
  ieee754_ctl->tme_ieee754_ctl_lock_unlock = NULL;

  /* signal any exceptions: */
  if (exceptions != 0) {
    (*ieee754_ctl->tme_ieee754_ctl_exception)(ieee754_ctl, exceptions);
  }
}

#endif /* defined(TME_HAVE_INT64_T) */

#if defined(TME_HAVE_INT64_T)

/* this does a strict compliance extended80-precision from-int64: */
static void
_tme_ieee754_strict_extended80_from_int64(struct tme_ieee754_ctl *ieee754_ctl, const tme_int64_t src0, struct tme_float *dst)
{
  int exceptions;

  /* enter softfloat operation: */
  tme_mutex_lock(&tme_ieee754_global_mutex);
  tme_ieee754_global_ctl = ieee754_ctl;
  tme_ieee754_global_exceptions = 0;
  ieee754_ctl->tme_ieee754_ctl_lock_unlock = tme_ieee754_unlock_softfloat;

  /* assume that this operation raises no exceptions: */
  exceptions = 0;

  /* the operation: */
  _tme_ieee754_extended80_value_set(dst, floatx80,
    int64_to_floatx80(src0));

  /* leave softfloat operation: */
  tme_ieee754_global_ctl = NULL;
  exceptions |= tme_ieee754_global_exceptions;
  tme_mutex_unlock(&tme_ieee754_global_mutex);
  ieee754_ctl->tme_ieee754_ctl_lock_unlock = NULL;

  /* signal any exceptions: */
  if (exceptions != 0) {
    (*ieee754_ctl->tme_ieee754_ctl_exception)(ieee754_ctl, exceptions);
  }
}

#endif /* defined(TME_HAVE_INT64_T) */

/* this does a strict compliance extended80-precision to-int32: */
static void
_tme_ieee754_strict_extended80_to_int32(struct tme_ieee754_ctl *ieee754_ctl, const struct tme_float *src0, tme_int32_t *dst)
{
  struct tme_float_ieee754_extended80 src0_buffer;
  int exceptions;

  /* enter softfloat operation: */
  tme_mutex_lock(&tme_ieee754_global_mutex);
  tme_ieee754_global_ctl = ieee754_ctl;
  tme_ieee754_global_exceptions = 0;
  ieee754_ctl->tme_ieee754_ctl_lock_unlock = tme_ieee754_unlock_softfloat;

  /* assume that this operation raises no exceptions: */
  exceptions = 0;

  /* the operation: */
  *dst = floatx80_to_int32((*((const floatx80 *) tme_ieee754_extended80_value_get(src0, &src0_buffer))));

  /* leave softfloat operation: */
  tme_ieee754_global_ctl = NULL;
  exceptions |= tme_ieee754_global_exceptions;
  tme_mutex_unlock(&tme_ieee754_global_mutex);
  ieee754_ctl->tme_ieee754_ctl_lock_unlock = NULL;

  /* signal any exceptions: */
  if (exceptions != 0) {
    (*ieee754_ctl->tme_ieee754_ctl_exception)(ieee754_ctl, exceptions);
  }
}

#if defined(TME_HAVE_INT64_T)

/* this does a strict compliance extended80-precision to-int64: */
static void
_tme_ieee754_strict_extended80_to_int64(struct tme_ieee754_ctl *ieee754_ctl, const struct tme_float *src0, tme_int64_t *dst)
{
  struct tme_float_ieee754_extended80 src0_buffer;
  int exceptions;

  /* enter softfloat operation: */
  tme_mutex_lock(&tme_ieee754_global_mutex);
  tme_ieee754_global_ctl = ieee754_ctl;
  tme_ieee754_global_exceptions = 0;
  ieee754_ctl->tme_ieee754_ctl_lock_unlock = tme_ieee754_unlock_softfloat;

  /* assume that this operation raises no exceptions: */
  exceptions = 0;

  /* the operation: */
  *dst = floatx80_to_int64((*((const floatx80 *) tme_ieee754_extended80_value_get(src0, &src0_buffer))));

  /* leave softfloat operation: */
  tme_ieee754_global_ctl = NULL;
  exceptions |= tme_ieee754_global_exceptions;
  tme_mutex_unlock(&tme_ieee754_global_mutex);
  ieee754_ctl->tme_ieee754_ctl_lock_unlock = NULL;

  /* signal any exceptions: */
  if (exceptions != 0) {
    (*ieee754_ctl->tme_ieee754_ctl_exception)(ieee754_ctl, exceptions);
  }
}

#endif /* defined(TME_HAVE_INT64_T) */

#if defined(TME_HAVE_INT64_T)

/* this does a strict compliance quad-precision add: */
static void
_tme_ieee754_strict_quad_add(struct tme_ieee754_ctl *ieee754_ctl, const struct tme_float *src0, const struct tme_float *src1, struct tme_float *dst)
{
  struct tme_float_ieee754_quad src0_buffer;
  struct tme_float_ieee754_quad src1_buffer;
  int exceptions;

  /* enter softfloat operation: */
  tme_mutex_lock(&tme_ieee754_global_mutex);
  tme_ieee754_global_ctl = ieee754_ctl;
  tme_ieee754_global_exceptions = 0;
  ieee754_ctl->tme_ieee754_ctl_lock_unlock = tme_ieee754_unlock_softfloat;

  /* assume that this operation raises no exceptions: */
  exceptions = 0;

  /* the operation: */
  _tme_ieee754_quad_value_set(dst, float128,
    float128_add((*((const float128 *) tme_ieee754_quad_value_get(src0, &src0_buffer))),
                (*((const float128 *) tme_ieee754_quad_value_get(src1, &src1_buffer)))));

  /* leave softfloat operation: */
  tme_ieee754_global_ctl = NULL;
  exceptions |= tme_ieee754_global_exceptions;
  tme_mutex_unlock(&tme_ieee754_global_mutex);
  ieee754_ctl->tme_ieee754_ctl_lock_unlock = NULL;

  /* signal any exceptions: */
  if (exceptions != 0) {
    (*ieee754_ctl->tme_ieee754_ctl_exception)(ieee754_ctl, exceptions);
  }
}

#endif /* defined(TME_HAVE_INT64_T) */

#if defined(TME_HAVE_INT64_T)

/* this does a strict compliance quad-precision sub: */
static void
_tme_ieee754_strict_quad_sub(struct tme_ieee754_ctl *ieee754_ctl, const struct tme_float *src0, const struct tme_float *src1, struct tme_float *dst)
{
  struct tme_float_ieee754_quad src0_buffer;
  struct tme_float_ieee754_quad src1_buffer;
  int exceptions;

  /* enter softfloat operation: */
  tme_mutex_lock(&tme_ieee754_global_mutex);
  tme_ieee754_global_ctl = ieee754_ctl;
  tme_ieee754_global_exceptions = 0;
  ieee754_ctl->tme_ieee754_ctl_lock_unlock = tme_ieee754_unlock_softfloat;

  /* assume that this operation raises no exceptions: */
  exceptions = 0;

  /* the operation: */
  _tme_ieee754_quad_value_set(dst, float128,
    float128_sub((*((const float128 *) tme_ieee754_quad_value_get(src0, &src0_buffer))),
                (*((const float128 *) tme_ieee754_quad_value_get(src1, &src1_buffer)))));

  /* leave softfloat operation: */
  tme_ieee754_global_ctl = NULL;
  exceptions |= tme_ieee754_global_exceptions;
  tme_mutex_unlock(&tme_ieee754_global_mutex);
  ieee754_ctl->tme_ieee754_ctl_lock_unlock = NULL;

  /* signal any exceptions: */
  if (exceptions != 0) {
    (*ieee754_ctl->tme_ieee754_ctl_exception)(ieee754_ctl, exceptions);
  }
}

#endif /* defined(TME_HAVE_INT64_T) */

#if defined(TME_HAVE_INT64_T)

/* this does a strict compliance quad-precision mul: */
static void
_tme_ieee754_strict_quad_mul(struct tme_ieee754_ctl *ieee754_ctl, const struct tme_float *src0, const struct tme_float *src1, struct tme_float *dst)
{
  struct tme_float_ieee754_quad src0_buffer;
  struct tme_float_ieee754_quad src1_buffer;
  int exceptions;

  /* enter softfloat operation: */
  tme_mutex_lock(&tme_ieee754_global_mutex);
  tme_ieee754_global_ctl = ieee754_ctl;
  tme_ieee754_global_exceptions = 0;
  ieee754_ctl->tme_ieee754_ctl_lock_unlock = tme_ieee754_unlock_softfloat;

  /* assume that this operation raises no exceptions: */
  exceptions = 0;

  /* the operation: */
  _tme_ieee754_quad_value_set(dst, float128,
    float128_mul((*((const float128 *) tme_ieee754_quad_value_get(src0, &src0_buffer))),
                (*((const float128 *) tme_ieee754_quad_value_get(src1, &src1_buffer)))));

  /* leave softfloat operation: */
  tme_ieee754_global_ctl = NULL;
  exceptions |= tme_ieee754_global_exceptions;
  tme_mutex_unlock(&tme_ieee754_global_mutex);
  ieee754_ctl->tme_ieee754_ctl_lock_unlock = NULL;

  /* signal any exceptions: */
  if (exceptions != 0) {
    (*ieee754_ctl->tme_ieee754_ctl_exception)(ieee754_ctl, exceptions);
  }
}

#endif /* defined(TME_HAVE_INT64_T) */

#if defined(TME_HAVE_INT64_T)

/* this does a strict compliance quad-precision div: */
static void
_tme_ieee754_strict_quad_div(struct tme_ieee754_ctl *ieee754_ctl, const struct tme_float *src0, const struct tme_float *src1, struct tme_float *dst)
{
  struct tme_float_ieee754_quad src0_buffer;
  struct tme_float_ieee754_quad src1_buffer;
  int exceptions;

  /* enter softfloat operation: */
  tme_mutex_lock(&tme_ieee754_global_mutex);
  tme_ieee754_global_ctl = ieee754_ctl;
  tme_ieee754_global_exceptions = 0;
  ieee754_ctl->tme_ieee754_ctl_lock_unlock = tme_ieee754_unlock_softfloat;

  /* assume that this operation raises no exceptions: */
  exceptions = 0;

  /* the operation: */
  _tme_ieee754_quad_value_set(dst, float128,
    float128_div((*((const float128 *) tme_ieee754_quad_value_get(src0, &src0_buffer))),
                (*((const float128 *) tme_ieee754_quad_value_get(src1, &src1_buffer)))));

  /* leave softfloat operation: */
  tme_ieee754_global_ctl = NULL;
  exceptions |= tme_ieee754_global_exceptions;
  tme_mutex_unlock(&tme_ieee754_global_mutex);
  ieee754_ctl->tme_ieee754_ctl_lock_unlock = NULL;

  /* signal any exceptions: */
  if (exceptions != 0) {
    (*ieee754_ctl->tme_ieee754_ctl_exception)(ieee754_ctl, exceptions);
  }
}

#endif /* defined(TME_HAVE_INT64_T) */

#if defined(TME_HAVE_INT64_T)

/* this does a strict compliance quad-precision rem: */
static void
_tme_ieee754_strict_quad_rem(struct tme_ieee754_ctl *ieee754_ctl, const struct tme_float *src0, const struct tme_float *src1, struct tme_float *dst)
{
  struct tme_float_ieee754_quad src0_buffer;
  struct tme_float_ieee754_quad src1_buffer;
  int exceptions;

  /* enter softfloat operation: */
  tme_mutex_lock(&tme_ieee754_global_mutex);
  tme_ieee754_global_ctl = ieee754_ctl;
  tme_ieee754_global_exceptions = 0;
  ieee754_ctl->tme_ieee754_ctl_lock_unlock = tme_ieee754_unlock_softfloat;

  /* assume that this operation raises no exceptions: */
  exceptions = 0;

  /* the operation: */
  _tme_ieee754_quad_value_set(dst, float128,
    float128_rem((*((const float128 *) tme_ieee754_quad_value_get(src0, &src0_buffer))),
                (*((const float128 *) tme_ieee754_quad_value_get(src1, &src1_buffer)))));

  /* leave softfloat operation: */
  tme_ieee754_global_ctl = NULL;
  exceptions |= tme_ieee754_global_exceptions;
  tme_mutex_unlock(&tme_ieee754_global_mutex);
  ieee754_ctl->tme_ieee754_ctl_lock_unlock = NULL;

  /* signal any exceptions: */
  if (exceptions != 0) {
    (*ieee754_ctl->tme_ieee754_ctl_exception)(ieee754_ctl, exceptions);
  }
}

#endif /* defined(TME_HAVE_INT64_T) */

#if defined(TME_HAVE_INT64_T)

/* this does a strict compliance quad-precision sqrt: */
static void
_tme_ieee754_strict_quad_sqrt(struct tme_ieee754_ctl *ieee754_ctl, const struct tme_float *src0, struct tme_float *dst)
{
  struct tme_float_ieee754_quad src0_buffer;
  int exceptions;

  /* enter softfloat operation: */
  tme_mutex_lock(&tme_ieee754_global_mutex);
  tme_ieee754_global_ctl = ieee754_ctl;
  tme_ieee754_global_exceptions = 0;
  ieee754_ctl->tme_ieee754_ctl_lock_unlock = tme_ieee754_unlock_softfloat;

  /* assume that this operation raises no exceptions: */
  exceptions = 0;

  /* the operation: */
  _tme_ieee754_quad_value_set(dst, float128,
    float128_sqrt((*((const float128 *) tme_ieee754_quad_value_get(src0, &src0_buffer)))));

  /* leave softfloat operation: */
  tme_ieee754_global_ctl = NULL;
  exceptions |= tme_ieee754_global_exceptions;
  tme_mutex_unlock(&tme_ieee754_global_mutex);
  ieee754_ctl->tme_ieee754_ctl_lock_unlock = NULL;

  /* signal any exceptions: */
  if (exceptions != 0) {
    (*ieee754_ctl->tme_ieee754_ctl_exception)(ieee754_ctl, exceptions);
  }
}

#endif /* defined(TME_HAVE_INT64_T) */

#if defined(TME_HAVE_INT64_T)

/* this does a strict compliance quad-precision neg: */
static void
_tme_ieee754_strict_quad_neg(struct tme_ieee754_ctl *ieee754_ctl, const struct tme_float *src0, struct tme_float *dst)
{
  struct tme_float_ieee754_quad src0_buffer;
  int exceptions;

  /* enter softfloat operation: */
  tme_mutex_lock(&tme_ieee754_global_mutex);
  tme_ieee754_global_ctl = ieee754_ctl;
  tme_ieee754_global_exceptions = 0;
  ieee754_ctl->tme_ieee754_ctl_lock_unlock = tme_ieee754_unlock_softfloat;

  /* assume that this operation raises no exceptions: */
  exceptions = 0;

  /* the operation: */
  _tme_ieee754_quad_value_set(dst, float128,
    float128_mul(int32_to_float128(-1),
                (*((const float128 *) tme_ieee754_quad_value_get(src0, &src0_buffer)))));

  /* leave softfloat operation: */
  tme_ieee754_global_ctl = NULL;
  exceptions |= tme_ieee754_global_exceptions;
  tme_mutex_unlock(&tme_ieee754_global_mutex);
  ieee754_ctl->tme_ieee754_ctl_lock_unlock = NULL;

  /* signal any exceptions: */
  if (exceptions != 0) {
    (*ieee754_ctl->tme_ieee754_ctl_exception)(ieee754_ctl, exceptions);
  }
}

#endif /* defined(TME_HAVE_INT64_T) */

#if defined(TME_HAVE_INT64_T)

/* this does a strict compliance quad-precision move: */
static void
_tme_ieee754_strict_quad_move(struct tme_ieee754_ctl *ieee754_ctl, const struct tme_float *src0, struct tme_float *dst)
{
  struct tme_float_ieee754_quad src0_buffer;
  int exceptions;

  /* enter softfloat operation: */
  tme_mutex_lock(&tme_ieee754_global_mutex);
  tme_ieee754_global_ctl = ieee754_ctl;
  tme_ieee754_global_exceptions = 0;
  ieee754_ctl->tme_ieee754_ctl_lock_unlock = tme_ieee754_unlock_softfloat;

  /* assume that this operation raises no exceptions: */
  exceptions = 0;

  /* the operation: */
  _tme_ieee754_quad_value_set(dst, float128,
    float128_add((*((const float128 *) tme_ieee754_quad_value_get(src0, &src0_buffer))),
                int32_to_float128(0)));

  /* leave softfloat operation: */
  tme_ieee754_global_ctl = NULL;
  exceptions |= tme_ieee754_global_exceptions;
  tme_mutex_unlock(&tme_ieee754_global_mutex);
  ieee754_ctl->tme_ieee754_ctl_lock_unlock = NULL;

  /* signal any exceptions: */
  if (exceptions != 0) {
    (*ieee754_ctl->tme_ieee754_ctl_exception)(ieee754_ctl, exceptions);
  }
}

#endif /* defined(TME_HAVE_INT64_T) */

#if defined(TME_HAVE_INT64_T)

/* this does a strict compliance quad-precision rint: */
static void
_tme_ieee754_strict_quad_rint(struct tme_ieee754_ctl *ieee754_ctl, const struct tme_float *src0, struct tme_float *dst)
{
  struct tme_float_ieee754_quad src0_buffer;
  int exceptions;

  /* enter softfloat operation: */
  tme_mutex_lock(&tme_ieee754_global_mutex);
  tme_ieee754_global_ctl = ieee754_ctl;
  tme_ieee754_global_exceptions = 0;
  ieee754_ctl->tme_ieee754_ctl_lock_unlock = tme_ieee754_unlock_softfloat;

  /* assume that this operation raises no exceptions: */
  exceptions = 0;

  /* the operation: */
  _tme_ieee754_quad_value_set(dst, float128,
    float128_round_to_int((*((const float128 *) tme_ieee754_quad_value_get(src0, &src0_buffer)))));

  /* leave softfloat operation: */
  tme_ieee754_global_ctl = NULL;
  exceptions |= tme_ieee754_global_exceptions;
  tme_mutex_unlock(&tme_ieee754_global_mutex);
  ieee754_ctl->tme_ieee754_ctl_lock_unlock = NULL;

  /* signal any exceptions: */
  if (exceptions != 0) {
    (*ieee754_ctl->tme_ieee754_ctl_exception)(ieee754_ctl, exceptions);
  }
}

#endif /* defined(TME_HAVE_INT64_T) */

/* this does a strict compliance quad-precision getexp: */
static void
_tme_ieee754_strict_quad_getexp(struct tme_ieee754_ctl *ieee754_ctl, const struct tme_float *src0, struct tme_float *dst)
{
  struct tme_float_ieee754_quad src0_buffer;
  int exceptions;

  /* check for a NaN operand: */
  if (__tme_predict_false(tme_ieee754_quad_check_nan_monadic(ieee754_ctl, src0, dst))) {
    return;
  }

  /* if the operand is an infinity: */
  if (tme_ieee754_quad_is_inf(src0)) {

    /* return a NaN: */
    dst->tme_float_format = TME_FLOAT_FORMAT_IEEE754_QUAD;
    dst->tme_float_value_ieee754_quad = ieee754_ctl->tme_ieee754_ctl_default_nan_quad;
    return;
  }

  /* assume that this operation raises no exceptions: */
  exceptions = 0;

  /* the operation: */

  /* if the operand is a zero, return a zero: */
  if (tme_ieee754_quad_is_zero(src0)) {
    tme_ieee754_quad_value_builtin_set(dst, TME_FLOAT_FORMAT_IEEE754_QUAD_BUILTIN, 0);
  }

  /* otherwise, return the unbiased exponent: */
  else {
    tme_ieee754_quad_value_builtin_set(dst, TME_FLOAT_FORMAT_IEEE754_QUAD_BUILTIN, TME_FIELD_MASK_EXTRACTU((*tme_ieee754_quad_value_get(src0, &src0_buffer)).tme_float_ieee754_quad_hi.tme_value64_uint32_hi, ((tme_uint32_t) 0x7fff0000)) - ((((tme_uint32_t) 0x7fff0000) / _TME_FIELD_MASK_FACTOR(((tme_uint32_t) 0x7fff0000))) >> 1));
  }
  ieee754_ctl->tme_ieee754_ctl_lock_unlock = NULL;

  /* signal any exceptions: */
  if (exceptions != 0) {
    (*ieee754_ctl->tme_ieee754_ctl_exception)(ieee754_ctl, exceptions);
  }
}

/* this does a strict compliance quad-precision getman: */
static void
_tme_ieee754_strict_quad_getman(struct tme_ieee754_ctl *ieee754_ctl, const struct tme_float *src0, struct tme_float *dst)
{
  struct tme_float_ieee754_quad src0_buffer;
  int exceptions;

  /* check for a NaN operand: */
  if (__tme_predict_false(tme_ieee754_quad_check_nan_monadic(ieee754_ctl, src0, dst))) {
    return;
  }

  /* if the operand is an infinity: */
  if (tme_ieee754_quad_is_inf(src0)) {

    /* return a NaN: */
    dst->tme_float_format = TME_FLOAT_FORMAT_IEEE754_QUAD;
    dst->tme_float_value_ieee754_quad = ieee754_ctl->tme_ieee754_ctl_default_nan_quad;
    return;
  }

  /* assume that this operation raises no exceptions: */
  exceptions = 0;

  /* the operation: */

  /* if the operand is a zero, return it: */
  if (tme_ieee754_quad_is_zero(src0)) {
    *dst = *src0;
  }

  /* otherwise, return the operand, with its exponent set to biased zero: */
  else {
    tme_ieee754_quad_value_set(dst, (*tme_ieee754_quad_value_get(src0, &src0_buffer)));
    TME_FIELD_MASK_DEPOSITU(dst->tme_float_value_ieee754_quad.tme_float_ieee754_quad_hi.tme_value64_uint32_hi, ((tme_uint32_t) 0x7fff0000), ((((tme_uint32_t) 0x7fff0000) / _TME_FIELD_MASK_FACTOR(((tme_uint32_t) 0x7fff0000))) >> 1));
  }
  ieee754_ctl->tme_ieee754_ctl_lock_unlock = NULL;

  /* signal any exceptions: */
  if (exceptions != 0) {
    (*ieee754_ctl->tme_ieee754_ctl_exception)(ieee754_ctl, exceptions);
  }
}

#if defined(TME_HAVE_INT64_T)

/* this does a strict compliance quad-precision from-single: */
static void
_tme_ieee754_strict_quad_from_single(struct tme_ieee754_ctl *ieee754_ctl, const struct tme_float *src0, struct tme_float *dst)
{
  tme_uint32_t src0_buffer;
  int exceptions;

  /* enter softfloat operation: */
  tme_mutex_lock(&tme_ieee754_global_mutex);
  tme_ieee754_global_ctl = ieee754_ctl;
  tme_ieee754_global_exceptions = 0;
  ieee754_ctl->tme_ieee754_ctl_lock_unlock = tme_ieee754_unlock_softfloat;

  /* assume that this operation raises no exceptions: */
  exceptions = 0;

  /* the operation: */
  _tme_ieee754_quad_value_set(dst, float128,
    float32_to_float128((*((const float32 *) tme_ieee754_single_value_get(src0, &src0_buffer)))));

  /* leave softfloat operation: */
  tme_ieee754_global_ctl = NULL;
  exceptions |= tme_ieee754_global_exceptions;
  tme_mutex_unlock(&tme_ieee754_global_mutex);
  ieee754_ctl->tme_ieee754_ctl_lock_unlock = NULL;

  /* signal any exceptions: */
  if (exceptions != 0) {
    (*ieee754_ctl->tme_ieee754_ctl_exception)(ieee754_ctl, exceptions);
  }
}

#endif /* defined(TME_HAVE_INT64_T) */

#if defined(TME_HAVE_INT64_T)

/* this does a strict compliance quad-precision from-double: */
static void
_tme_ieee754_strict_quad_from_double(struct tme_ieee754_ctl *ieee754_ctl, const struct tme_float *src0, struct tme_float *dst)
{
  union tme_value64 src0_buffer;
  int exceptions;

  /* enter softfloat operation: */
  tme_mutex_lock(&tme_ieee754_global_mutex);
  tme_ieee754_global_ctl = ieee754_ctl;
  tme_ieee754_global_exceptions = 0;
  ieee754_ctl->tme_ieee754_ctl_lock_unlock = tme_ieee754_unlock_softfloat;

  /* assume that this operation raises no exceptions: */
  exceptions = 0;

  /* the operation: */
  _tme_ieee754_quad_value_set(dst, float128,
    float64_to_float128((*((const float64 *) tme_ieee754_double_value_get(src0, &src0_buffer)))));

  /* leave softfloat operation: */
  tme_ieee754_global_ctl = NULL;
  exceptions |= tme_ieee754_global_exceptions;
  tme_mutex_unlock(&tme_ieee754_global_mutex);
  ieee754_ctl->tme_ieee754_ctl_lock_unlock = NULL;

  /* signal any exceptions: */
  if (exceptions != 0) {
    (*ieee754_ctl->tme_ieee754_ctl_exception)(ieee754_ctl, exceptions);
  }
}

#endif /* defined(TME_HAVE_INT64_T) */

#if defined(TME_HAVE_INT64_T)

/* this does a strict compliance quad-precision from-extended80: */
static void
_tme_ieee754_strict_quad_from_extended80(struct tme_ieee754_ctl *ieee754_ctl, const struct tme_float *src0, struct tme_float *dst)
{
  struct tme_float_ieee754_extended80 src0_buffer;
  int exceptions;

  /* enter softfloat operation: */
  tme_mutex_lock(&tme_ieee754_global_mutex);
  tme_ieee754_global_ctl = ieee754_ctl;
  tme_ieee754_global_exceptions = 0;
  ieee754_ctl->tme_ieee754_ctl_lock_unlock = tme_ieee754_unlock_softfloat;

  /* assume that this operation raises no exceptions: */
  exceptions = 0;

  /* the operation: */
  _tme_ieee754_quad_value_set(dst, float128,
    floatx80_to_float128((*((const floatx80 *) tme_ieee754_extended80_value_get(src0, &src0_buffer)))));

  /* leave softfloat operation: */
  tme_ieee754_global_ctl = NULL;
  exceptions |= tme_ieee754_global_exceptions;
  tme_mutex_unlock(&tme_ieee754_global_mutex);
  ieee754_ctl->tme_ieee754_ctl_lock_unlock = NULL;

  /* signal any exceptions: */
  if (exceptions != 0) {
    (*ieee754_ctl->tme_ieee754_ctl_exception)(ieee754_ctl, exceptions);
  }
}

#endif /* defined(TME_HAVE_INT64_T) */

#if defined(TME_HAVE_INT64_T)

/* this does a strict compliance quad-precision from-int32: */
static void
_tme_ieee754_strict_quad_from_int32(struct tme_ieee754_ctl *ieee754_ctl, const tme_int32_t src0, struct tme_float *dst)
{
  int exceptions;

  /* enter softfloat operation: */
  tme_mutex_lock(&tme_ieee754_global_mutex);
  tme_ieee754_global_ctl = ieee754_ctl;
  tme_ieee754_global_exceptions = 0;
  ieee754_ctl->tme_ieee754_ctl_lock_unlock = tme_ieee754_unlock_softfloat;

  /* assume that this operation raises no exceptions: */
  exceptions = 0;

  /* the operation: */
  _tme_ieee754_quad_value_set(dst, float128,
    int32_to_float128(src0));

  /* leave softfloat operation: */
  tme_ieee754_global_ctl = NULL;
  exceptions |= tme_ieee754_global_exceptions;
  tme_mutex_unlock(&tme_ieee754_global_mutex);
  ieee754_ctl->tme_ieee754_ctl_lock_unlock = NULL;

  /* signal any exceptions: */
  if (exceptions != 0) {
    (*ieee754_ctl->tme_ieee754_ctl_exception)(ieee754_ctl, exceptions);
  }
}

#endif /* defined(TME_HAVE_INT64_T) */

#if defined(TME_HAVE_INT64_T)

/* this does a strict compliance quad-precision from-int64: */
static void
_tme_ieee754_strict_quad_from_int64(struct tme_ieee754_ctl *ieee754_ctl, const tme_int64_t src0, struct tme_float *dst)
{
  int exceptions;

  /* enter softfloat operation: */
  tme_mutex_lock(&tme_ieee754_global_mutex);
  tme_ieee754_global_ctl = ieee754_ctl;
  tme_ieee754_global_exceptions = 0;
  ieee754_ctl->tme_ieee754_ctl_lock_unlock = tme_ieee754_unlock_softfloat;

  /* assume that this operation raises no exceptions: */
  exceptions = 0;

  /* the operation: */
  _tme_ieee754_quad_value_set(dst, float128,
    int64_to_float128(src0));

  /* leave softfloat operation: */
  tme_ieee754_global_ctl = NULL;
  exceptions |= tme_ieee754_global_exceptions;
  tme_mutex_unlock(&tme_ieee754_global_mutex);
  ieee754_ctl->tme_ieee754_ctl_lock_unlock = NULL;

  /* signal any exceptions: */
  if (exceptions != 0) {
    (*ieee754_ctl->tme_ieee754_ctl_exception)(ieee754_ctl, exceptions);
  }
}

#endif /* defined(TME_HAVE_INT64_T) */

/* this does a strict compliance quad-precision to-int32: */
static void
_tme_ieee754_strict_quad_to_int32(struct tme_ieee754_ctl *ieee754_ctl, const struct tme_float *src0, tme_int32_t *dst)
{
  struct tme_float_ieee754_quad src0_buffer;
  int exceptions;

  /* enter softfloat operation: */
  tme_mutex_lock(&tme_ieee754_global_mutex);
  tme_ieee754_global_ctl = ieee754_ctl;
  tme_ieee754_global_exceptions = 0;
  ieee754_ctl->tme_ieee754_ctl_lock_unlock = tme_ieee754_unlock_softfloat;

  /* assume that this operation raises no exceptions: */
  exceptions = 0;

  /* the operation: */
  *dst = float128_to_int32((*((const float128 *) tme_ieee754_quad_value_get(src0, &src0_buffer))));

  /* leave softfloat operation: */
  tme_ieee754_global_ctl = NULL;
  exceptions |= tme_ieee754_global_exceptions;
  tme_mutex_unlock(&tme_ieee754_global_mutex);
  ieee754_ctl->tme_ieee754_ctl_lock_unlock = NULL;

  /* signal any exceptions: */
  if (exceptions != 0) {
    (*ieee754_ctl->tme_ieee754_ctl_exception)(ieee754_ctl, exceptions);
  }
}

#if defined(TME_HAVE_INT64_T)

/* this does a strict compliance quad-precision to-int64: */
static void
_tme_ieee754_strict_quad_to_int64(struct tme_ieee754_ctl *ieee754_ctl, const struct tme_float *src0, tme_int64_t *dst)
{
  struct tme_float_ieee754_quad src0_buffer;
  int exceptions;

  /* enter softfloat operation: */
  tme_mutex_lock(&tme_ieee754_global_mutex);
  tme_ieee754_global_ctl = ieee754_ctl;
  tme_ieee754_global_exceptions = 0;
  ieee754_ctl->tme_ieee754_ctl_lock_unlock = tme_ieee754_unlock_softfloat;

  /* assume that this operation raises no exceptions: */
  exceptions = 0;

  /* the operation: */
  *dst = float128_to_int64((*((const float128 *) tme_ieee754_quad_value_get(src0, &src0_buffer))));

  /* leave softfloat operation: */
  tme_ieee754_global_ctl = NULL;
  exceptions |= tme_ieee754_global_exceptions;
  tme_mutex_unlock(&tme_ieee754_global_mutex);
  ieee754_ctl->tme_ieee754_ctl_lock_unlock = NULL;

  /* signal any exceptions: */
  if (exceptions != 0) {
    (*ieee754_ctl->tme_ieee754_ctl_exception)(ieee754_ctl, exceptions);
  }
}

#endif /* defined(TME_HAVE_INT64_T) */

/* the strict compliance operations: */
_tme_const struct tme_ieee754_ops tme_ieee754_ops_strict = {

  /* the version of this structure: */
  TME_X_VERSION(0, 0),

  /* this does a strict compliance single-precision add: */
  _tme_ieee754_strict_single_add,

  /* this does a strict compliance single-precision sub: */
  _tme_ieee754_strict_single_sub,

  /* this does a strict compliance single-precision mul: */
  _tme_ieee754_strict_single_mul,

  /* this does a strict compliance single-precision div: */
  _tme_ieee754_strict_single_div,

  /* this does a strict compliance single-precision rem: */
  _tme_ieee754_strict_single_rem,

  /* this does a strict compliance single-precision sqrt: */
  _tme_ieee754_strict_single_sqrt,

  /* this does a strict compliance single-precision abs: */
  NULL,

  /* this does a strict compliance single-precision neg: */
  _tme_ieee754_strict_single_neg,

  /* this does a strict compliance single-precision move: */
  _tme_ieee754_strict_single_move,

  /* this does a strict compliance single-precision rint: */
  _tme_ieee754_strict_single_rint,

  /* this does a strict compliance single-precision cos: */
  NULL,

  /* this does a strict compliance single-precision acos: */
  NULL,

  /* this does a strict compliance single-precision cosh: */
  NULL,

  /* this does a strict compliance single-precision sin: */
  NULL,

  /* this does a strict compliance single-precision asin: */
  NULL,

  /* this does a strict compliance single-precision sinh: */
  NULL,

  /* this does a strict compliance single-precision tan: */
  NULL,

  /* this does a strict compliance single-precision atan: */
  NULL,

  /* this does a strict compliance single-precision tanh: */
  NULL,

  /* this does a strict compliance single-precision atanh: */
  NULL,

  /* this does a strict compliance single-precision exp: */
  NULL,

  /* this does a strict compliance single-precision expm1: */
  NULL,

  /* this does a strict compliance single-precision log10: */
  NULL,

  /* this does a strict compliance single-precision log: */
  NULL,

  /* this does a strict compliance single-precision log1p: */
  NULL,

  /* this does a strict compliance single-precision getexp: */
  _tme_ieee754_strict_single_getexp,

  /* this does a strict compliance single-precision getman: */
  _tme_ieee754_strict_single_getman,

  /* this does a strict compliance single-precision scale: */
  NULL,

  /* this does a strict compliance single-precision pow: */
  NULL,

  /* this does a strict compliance single-precision from_double: */
  _tme_ieee754_strict_single_from_double,

  /* this does a strict compliance single-precision from_extended80: */
  _tme_ieee754_strict_single_from_extended80,

  /* this does a strict compliance single-precision from_quad: */
  _tme_ieee754_strict_single_from_quad,

  /* this does a strict compliance single-precision from_int32: */
  _tme_ieee754_strict_single_from_int32,

  /* this does a strict compliance single-precision from_int64: */
#if (defined(TME_HAVE_INT64_T))
  _tme_ieee754_strict_single_from_int64,
#else  /* !(defined(TME_HAVE_INT64_T)) */
  NULL,
#endif /* !(defined(TME_HAVE_INT64_T)) */

  /* this does a strict compliance single-precision to_int32: */
  _tme_ieee754_strict_single_to_int32,

  /* this does a strict compliance single-precision to_int64: */
#if (defined(TME_HAVE_INT64_T))
  _tme_ieee754_strict_single_to_int64,
#else  /* !(defined(TME_HAVE_INT64_T)) */
  NULL,
#endif /* !(defined(TME_HAVE_INT64_T)) */

  /* this does a strict compliance double-precision add: */
  _tme_ieee754_strict_double_add,

  /* this does a strict compliance double-precision sub: */
  _tme_ieee754_strict_double_sub,

  /* this does a strict compliance double-precision mul: */
  _tme_ieee754_strict_double_mul,

  /* this does a strict compliance double-precision div: */
  _tme_ieee754_strict_double_div,

  /* this does a strict compliance double-precision rem: */
  _tme_ieee754_strict_double_rem,

  /* this does a strict compliance double-precision sqrt: */
  _tme_ieee754_strict_double_sqrt,

  /* this does a strict compliance double-precision abs: */
  NULL,

  /* this does a strict compliance double-precision neg: */
  _tme_ieee754_strict_double_neg,

  /* this does a strict compliance double-precision move: */
  _tme_ieee754_strict_double_move,

  /* this does a strict compliance double-precision rint: */
  _tme_ieee754_strict_double_rint,

  /* this does a strict compliance double-precision cos: */
  NULL,

  /* this does a strict compliance double-precision acos: */
  NULL,

  /* this does a strict compliance double-precision cosh: */
  NULL,

  /* this does a strict compliance double-precision sin: */
  NULL,

  /* this does a strict compliance double-precision asin: */
  NULL,

  /* this does a strict compliance double-precision sinh: */
  NULL,

  /* this does a strict compliance double-precision tan: */
  NULL,

  /* this does a strict compliance double-precision atan: */
  NULL,

  /* this does a strict compliance double-precision tanh: */
  NULL,

  /* this does a strict compliance double-precision atanh: */
  NULL,

  /* this does a strict compliance double-precision exp: */
  NULL,

  /* this does a strict compliance double-precision expm1: */
  NULL,

  /* this does a strict compliance double-precision log10: */
  NULL,

  /* this does a strict compliance double-precision log: */
  NULL,

  /* this does a strict compliance double-precision log1p: */
  NULL,

  /* this does a strict compliance double-precision getexp: */
  _tme_ieee754_strict_double_getexp,

  /* this does a strict compliance double-precision getman: */
  _tme_ieee754_strict_double_getman,

  /* this does a strict compliance double-precision scale: */
  NULL,

  /* this does a strict compliance double-precision pow: */
  NULL,

  /* this does a strict compliance double-precision from_single: */
  _tme_ieee754_strict_double_from_single,

  /* this does a strict compliance double-precision from_extended80: */
  _tme_ieee754_strict_double_from_extended80,

  /* this does a strict compliance double-precision from_quad: */
  _tme_ieee754_strict_double_from_quad,

  /* this does a strict compliance double-precision from_int32: */
  _tme_ieee754_strict_double_from_int32,

  /* this does a strict compliance double-precision from_int64: */
#if (defined(TME_HAVE_INT64_T))
  _tme_ieee754_strict_double_from_int64,
#else  /* !(defined(TME_HAVE_INT64_T)) */
  NULL,
#endif /* !(defined(TME_HAVE_INT64_T)) */

  /* this does a strict compliance double-precision to_int32: */
  _tme_ieee754_strict_double_to_int32,

  /* this does a strict compliance double-precision to_int64: */
#if (defined(TME_HAVE_INT64_T))
  _tme_ieee754_strict_double_to_int64,
#else  /* !(defined(TME_HAVE_INT64_T)) */
  NULL,
#endif /* !(defined(TME_HAVE_INT64_T)) */

  /* this does a strict compliance extended80-precision add: */
#if (defined(TME_HAVE_INT64_T))
  _tme_ieee754_strict_extended80_add,
#else  /* !(defined(TME_HAVE_INT64_T)) */
  NULL,
#endif /* !(defined(TME_HAVE_INT64_T)) */

  /* this does a strict compliance extended80-precision sub: */
#if (defined(TME_HAVE_INT64_T))
  _tme_ieee754_strict_extended80_sub,
#else  /* !(defined(TME_HAVE_INT64_T)) */
  NULL,
#endif /* !(defined(TME_HAVE_INT64_T)) */

  /* this does a strict compliance extended80-precision mul: */
#if (defined(TME_HAVE_INT64_T))
  _tme_ieee754_strict_extended80_mul,
#else  /* !(defined(TME_HAVE_INT64_T)) */
  NULL,
#endif /* !(defined(TME_HAVE_INT64_T)) */

  /* this does a strict compliance extended80-precision div: */
#if (defined(TME_HAVE_INT64_T))
  _tme_ieee754_strict_extended80_div,
#else  /* !(defined(TME_HAVE_INT64_T)) */
  NULL,
#endif /* !(defined(TME_HAVE_INT64_T)) */

  /* this does a strict compliance extended80-precision rem: */
#if (defined(TME_HAVE_INT64_T))
  _tme_ieee754_strict_extended80_rem,
#else  /* !(defined(TME_HAVE_INT64_T)) */
  NULL,
#endif /* !(defined(TME_HAVE_INT64_T)) */

  /* this does a strict compliance extended80-precision sqrt: */
#if (defined(TME_HAVE_INT64_T))
  _tme_ieee754_strict_extended80_sqrt,
#else  /* !(defined(TME_HAVE_INT64_T)) */
  NULL,
#endif /* !(defined(TME_HAVE_INT64_T)) */

  /* this does a strict compliance extended80-precision abs: */
  NULL,

  /* this does a strict compliance extended80-precision neg: */
#if (defined(TME_HAVE_INT64_T))
  _tme_ieee754_strict_extended80_neg,
#else  /* !(defined(TME_HAVE_INT64_T)) */
  NULL,
#endif /* !(defined(TME_HAVE_INT64_T)) */

  /* this does a strict compliance extended80-precision move: */
#if (defined(TME_HAVE_INT64_T))
  _tme_ieee754_strict_extended80_move,
#else  /* !(defined(TME_HAVE_INT64_T)) */
  NULL,
#endif /* !(defined(TME_HAVE_INT64_T)) */

  /* this does a strict compliance extended80-precision rint: */
#if (defined(TME_HAVE_INT64_T))
  _tme_ieee754_strict_extended80_rint,
#else  /* !(defined(TME_HAVE_INT64_T)) */
  NULL,
#endif /* !(defined(TME_HAVE_INT64_T)) */

  /* this does a strict compliance extended80-precision cos: */
  NULL,

  /* this does a strict compliance extended80-precision acos: */
  NULL,

  /* this does a strict compliance extended80-precision cosh: */
  NULL,

  /* this does a strict compliance extended80-precision sin: */
  NULL,

  /* this does a strict compliance extended80-precision asin: */
  NULL,

  /* this does a strict compliance extended80-precision sinh: */
  NULL,

  /* this does a strict compliance extended80-precision tan: */
  NULL,

  /* this does a strict compliance extended80-precision atan: */
  NULL,

  /* this does a strict compliance extended80-precision tanh: */
  NULL,

  /* this does a strict compliance extended80-precision atanh: */
  NULL,

  /* this does a strict compliance extended80-precision exp: */
  NULL,

  /* this does a strict compliance extended80-precision expm1: */
  NULL,

  /* this does a strict compliance extended80-precision log10: */
  NULL,

  /* this does a strict compliance extended80-precision log: */
  NULL,

  /* this does a strict compliance extended80-precision log1p: */
  NULL,

  /* this does a strict compliance extended80-precision getexp: */
  _tme_ieee754_strict_extended80_getexp,

  /* this does a strict compliance extended80-precision getman: */
  _tme_ieee754_strict_extended80_getman,

  /* this does a strict compliance extended80-precision scale: */
  NULL,

  /* this does a strict compliance extended80-precision pow: */
  NULL,

  /* this does a strict compliance extended80-precision from_single: */
#if (defined(TME_HAVE_INT64_T))
  _tme_ieee754_strict_extended80_from_single,
#else  /* !(defined(TME_HAVE_INT64_T)) */
  NULL,
#endif /* !(defined(TME_HAVE_INT64_T)) */

  /* this does a strict compliance extended80-precision from_double: */
#if (defined(TME_HAVE_INT64_T))
  _tme_ieee754_strict_extended80_from_double,
#else  /* !(defined(TME_HAVE_INT64_T)) */
  NULL,
#endif /* !(defined(TME_HAVE_INT64_T)) */

  /* this does a strict compliance extended80-precision from_quad: */
#if (defined(TME_HAVE_INT64_T))
  _tme_ieee754_strict_extended80_from_quad,
#else  /* !(defined(TME_HAVE_INT64_T)) */
  NULL,
#endif /* !(defined(TME_HAVE_INT64_T)) */

  /* this does a strict compliance extended80-precision from_int32: */
#if (defined(TME_HAVE_INT64_T))
  _tme_ieee754_strict_extended80_from_int32,
#else  /* !(defined(TME_HAVE_INT64_T)) */
  NULL,
#endif /* !(defined(TME_HAVE_INT64_T)) */

  /* this does a strict compliance extended80-precision from_int64: */
#if (defined(TME_HAVE_INT64_T))
  _tme_ieee754_strict_extended80_from_int64,
#else  /* !(defined(TME_HAVE_INT64_T)) */
  NULL,
#endif /* !(defined(TME_HAVE_INT64_T)) */

  /* this does a strict compliance extended80-precision to_int32: */
  _tme_ieee754_strict_extended80_to_int32,

  /* this does a strict compliance extended80-precision to_int64: */
#if (defined(TME_HAVE_INT64_T))
  _tme_ieee754_strict_extended80_to_int64,
#else  /* !(defined(TME_HAVE_INT64_T)) */
  NULL,
#endif /* !(defined(TME_HAVE_INT64_T)) */

  /* this does a strict compliance quad-precision add: */
#if (defined(TME_HAVE_INT64_T))
  _tme_ieee754_strict_quad_add,
#else  /* !(defined(TME_HAVE_INT64_T)) */
  NULL,
#endif /* !(defined(TME_HAVE_INT64_T)) */

  /* this does a strict compliance quad-precision sub: */
#if (defined(TME_HAVE_INT64_T))
  _tme_ieee754_strict_quad_sub,
#else  /* !(defined(TME_HAVE_INT64_T)) */
  NULL,
#endif /* !(defined(TME_HAVE_INT64_T)) */

  /* this does a strict compliance quad-precision mul: */
#if (defined(TME_HAVE_INT64_T))
  _tme_ieee754_strict_quad_mul,
#else  /* !(defined(TME_HAVE_INT64_T)) */
  NULL,
#endif /* !(defined(TME_HAVE_INT64_T)) */

  /* this does a strict compliance quad-precision div: */
#if (defined(TME_HAVE_INT64_T))
  _tme_ieee754_strict_quad_div,
#else  /* !(defined(TME_HAVE_INT64_T)) */
  NULL,
#endif /* !(defined(TME_HAVE_INT64_T)) */

  /* this does a strict compliance quad-precision rem: */
#if (defined(TME_HAVE_INT64_T))
  _tme_ieee754_strict_quad_rem,
#else  /* !(defined(TME_HAVE_INT64_T)) */
  NULL,
#endif /* !(defined(TME_HAVE_INT64_T)) */

  /* this does a strict compliance quad-precision sqrt: */
#if (defined(TME_HAVE_INT64_T))
  _tme_ieee754_strict_quad_sqrt,
#else  /* !(defined(TME_HAVE_INT64_T)) */
  NULL,
#endif /* !(defined(TME_HAVE_INT64_T)) */

  /* this does a strict compliance quad-precision abs: */
  NULL,

  /* this does a strict compliance quad-precision neg: */
#if (defined(TME_HAVE_INT64_T))
  _tme_ieee754_strict_quad_neg,
#else  /* !(defined(TME_HAVE_INT64_T)) */
  NULL,
#endif /* !(defined(TME_HAVE_INT64_T)) */

  /* this does a strict compliance quad-precision move: */
#if (defined(TME_HAVE_INT64_T))
  _tme_ieee754_strict_quad_move,
#else  /* !(defined(TME_HAVE_INT64_T)) */
  NULL,
#endif /* !(defined(TME_HAVE_INT64_T)) */

  /* this does a strict compliance quad-precision rint: */
#if (defined(TME_HAVE_INT64_T))
  _tme_ieee754_strict_quad_rint,
#else  /* !(defined(TME_HAVE_INT64_T)) */
  NULL,
#endif /* !(defined(TME_HAVE_INT64_T)) */

  /* this does a strict compliance quad-precision cos: */
  NULL,

  /* this does a strict compliance quad-precision acos: */
  NULL,

  /* this does a strict compliance quad-precision cosh: */
  NULL,

  /* this does a strict compliance quad-precision sin: */
  NULL,

  /* this does a strict compliance quad-precision asin: */
  NULL,

  /* this does a strict compliance quad-precision sinh: */
  NULL,

  /* this does a strict compliance quad-precision tan: */
  NULL,

  /* this does a strict compliance quad-precision atan: */
  NULL,

  /* this does a strict compliance quad-precision tanh: */
  NULL,

  /* this does a strict compliance quad-precision atanh: */
  NULL,

  /* this does a strict compliance quad-precision exp: */
  NULL,

  /* this does a strict compliance quad-precision expm1: */
  NULL,

  /* this does a strict compliance quad-precision log10: */
  NULL,

  /* this does a strict compliance quad-precision log: */
  NULL,

  /* this does a strict compliance quad-precision log1p: */
  NULL,

  /* this does a strict compliance quad-precision getexp: */
  _tme_ieee754_strict_quad_getexp,

  /* this does a strict compliance quad-precision getman: */
  _tme_ieee754_strict_quad_getman,

  /* this does a strict compliance quad-precision scale: */
  NULL,

  /* this does a strict compliance quad-precision pow: */
  NULL,

  /* this does a strict compliance quad-precision from_single: */
#if (defined(TME_HAVE_INT64_T))
  _tme_ieee754_strict_quad_from_single,
#else  /* !(defined(TME_HAVE_INT64_T)) */
  NULL,
#endif /* !(defined(TME_HAVE_INT64_T)) */

  /* this does a strict compliance quad-precision from_double: */
#if (defined(TME_HAVE_INT64_T))
  _tme_ieee754_strict_quad_from_double,
#else  /* !(defined(TME_HAVE_INT64_T)) */
  NULL,
#endif /* !(defined(TME_HAVE_INT64_T)) */

  /* this does a strict compliance quad-precision from_extended80: */
#if (defined(TME_HAVE_INT64_T))
  _tme_ieee754_strict_quad_from_extended80,
#else  /* !(defined(TME_HAVE_INT64_T)) */
  NULL,
#endif /* !(defined(TME_HAVE_INT64_T)) */

  /* this does a strict compliance quad-precision from_int32: */
#if (defined(TME_HAVE_INT64_T))
  _tme_ieee754_strict_quad_from_int32,
#else  /* !(defined(TME_HAVE_INT64_T)) */
  NULL,
#endif /* !(defined(TME_HAVE_INT64_T)) */

  /* this does a strict compliance quad-precision from_int64: */
#if (defined(TME_HAVE_INT64_T))
  _tme_ieee754_strict_quad_from_int64,
#else  /* !(defined(TME_HAVE_INT64_T)) */
  NULL,
#endif /* !(defined(TME_HAVE_INT64_T)) */

  /* this does a strict compliance quad-precision to_int32: */
  _tme_ieee754_strict_quad_to_int32,

  /* this does a strict compliance quad-precision to_int64: */
#if (defined(TME_HAVE_INT64_T))
  _tme_ieee754_strict_quad_to_int64,
#else  /* !(defined(TME_HAVE_INT64_T)) */
  NULL,
#endif /* !(defined(TME_HAVE_INT64_T)) */
};

#if (TME_FLOAT_FORMAT_IEEE754_SINGLE_BUILTIN == TME_FLOAT_FORMAT_IEEE754_SINGLE)

/* this does a partial compliance single-precision add: */
static void
_tme_ieee754_partial_single_add(struct tme_ieee754_ctl *ieee754_ctl, const struct tme_float *src0, const struct tme_float *src1, struct tme_float *dst)
{
  int exceptions;

  /* check for a NaN operand: */
  if (__tme_predict_false(tme_ieee754_single_check_nan_dyadic(ieee754_ctl, src0, src1, dst))) {
    return;
  }

  /* enter native floating-point operation: */
  tme_float_enter(ieee754_ctl->tme_ieee754_ctl_rounding_mode, tme_ieee754_exception_float, ieee754_ctl);
  ieee754_ctl->tme_ieee754_ctl_lock_unlock = tme_float_leave;

  /* assume that this operation raises no exceptions: */
  exceptions = 0;

  /* the operation: */
  tme_ieee754_single_value_builtin_set(dst, TME_FLOAT_FORMAT_IEEE754_SINGLE_BUILTIN, tme_ieee754_single_value_builtin_get(src0) + tme_ieee754_single_value_builtin_get(src1));

  /* leave native floating-point operation: */
  exceptions |= tme_float_leave();
  ieee754_ctl->tme_ieee754_ctl_lock_unlock = NULL;

  /* signal any exceptions: */
  if (exceptions != 0) {
    (*ieee754_ctl->tme_ieee754_ctl_exception)(ieee754_ctl, exceptions);
  }
}

#endif /* (TME_FLOAT_FORMAT_IEEE754_SINGLE_BUILTIN == TME_FLOAT_FORMAT_IEEE754_SINGLE) */

#if (TME_FLOAT_FORMAT_IEEE754_SINGLE_BUILTIN == TME_FLOAT_FORMAT_IEEE754_SINGLE)

/* this does a partial compliance single-precision sub: */
static void
_tme_ieee754_partial_single_sub(struct tme_ieee754_ctl *ieee754_ctl, const struct tme_float *src0, const struct tme_float *src1, struct tme_float *dst)
{
  int exceptions;

  /* check for a NaN operand: */
  if (__tme_predict_false(tme_ieee754_single_check_nan_dyadic(ieee754_ctl, src0, src1, dst))) {
    return;
  }

  /* enter native floating-point operation: */
  tme_float_enter(ieee754_ctl->tme_ieee754_ctl_rounding_mode, tme_ieee754_exception_float, ieee754_ctl);
  ieee754_ctl->tme_ieee754_ctl_lock_unlock = tme_float_leave;

  /* assume that this operation raises no exceptions: */
  exceptions = 0;

  /* the operation: */
  tme_ieee754_single_value_builtin_set(dst, TME_FLOAT_FORMAT_IEEE754_SINGLE_BUILTIN, tme_ieee754_single_value_builtin_get(src0) - tme_ieee754_single_value_builtin_get(src1));

  /* leave native floating-point operation: */
  exceptions |= tme_float_leave();
  ieee754_ctl->tme_ieee754_ctl_lock_unlock = NULL;

  /* signal any exceptions: */
  if (exceptions != 0) {
    (*ieee754_ctl->tme_ieee754_ctl_exception)(ieee754_ctl, exceptions);
  }
}

#endif /* (TME_FLOAT_FORMAT_IEEE754_SINGLE_BUILTIN == TME_FLOAT_FORMAT_IEEE754_SINGLE) */

#if (TME_FLOAT_FORMAT_IEEE754_SINGLE_BUILTIN == TME_FLOAT_FORMAT_IEEE754_SINGLE)

/* this does a partial compliance single-precision mul: */
static void
_tme_ieee754_partial_single_mul(struct tme_ieee754_ctl *ieee754_ctl, const struct tme_float *src0, const struct tme_float *src1, struct tme_float *dst)
{
  int exceptions;

  /* check for a NaN operand: */
  if (__tme_predict_false(tme_ieee754_single_check_nan_dyadic(ieee754_ctl, src0, src1, dst))) {
    return;
  }

  /* enter native floating-point operation: */
  tme_float_enter(ieee754_ctl->tme_ieee754_ctl_rounding_mode, tme_ieee754_exception_float, ieee754_ctl);
  ieee754_ctl->tme_ieee754_ctl_lock_unlock = tme_float_leave;

  /* assume that this operation raises no exceptions: */
  exceptions = 0;

  /* the operation: */
  tme_ieee754_single_value_builtin_set(dst, TME_FLOAT_FORMAT_IEEE754_SINGLE_BUILTIN, tme_ieee754_single_value_builtin_get(src0) * tme_ieee754_single_value_builtin_get(src1));

  /* leave native floating-point operation: */
  exceptions |= tme_float_leave();
  ieee754_ctl->tme_ieee754_ctl_lock_unlock = NULL;

  /* signal any exceptions: */
  if (exceptions != 0) {
    (*ieee754_ctl->tme_ieee754_ctl_exception)(ieee754_ctl, exceptions);
  }
}

#endif /* (TME_FLOAT_FORMAT_IEEE754_SINGLE_BUILTIN == TME_FLOAT_FORMAT_IEEE754_SINGLE) */

#if (TME_FLOAT_FORMAT_IEEE754_SINGLE_BUILTIN == TME_FLOAT_FORMAT_IEEE754_SINGLE)

/* this does a partial compliance single-precision div: */
static void
_tme_ieee754_partial_single_div(struct tme_ieee754_ctl *ieee754_ctl, const struct tme_float *src0, const struct tme_float *src1, struct tme_float *dst)
{
  int exceptions;

  /* check for a NaN operand: */
  if (__tme_predict_false(tme_ieee754_single_check_nan_dyadic(ieee754_ctl, src0, src1, dst))) {
    return;
  }

  /* enter native floating-point operation: */
  tme_float_enter(ieee754_ctl->tme_ieee754_ctl_rounding_mode, tme_ieee754_exception_float, ieee754_ctl);
  ieee754_ctl->tme_ieee754_ctl_lock_unlock = tme_float_leave;

  /* assume that this operation raises no exceptions: */
  exceptions = 0;

  /* the operation: */
  tme_ieee754_single_value_builtin_set(dst, TME_FLOAT_FORMAT_IEEE754_SINGLE_BUILTIN, tme_ieee754_single_value_builtin_get(src0) / tme_ieee754_single_value_builtin_get(src1));

  /* leave native floating-point operation: */
  exceptions |= tme_float_leave();
  ieee754_ctl->tme_ieee754_ctl_lock_unlock = NULL;

  /* signal any exceptions: */
  if (exceptions != 0) {
    (*ieee754_ctl->tme_ieee754_ctl_exception)(ieee754_ctl, exceptions);
  }
}

#endif /* (TME_FLOAT_FORMAT_IEEE754_SINGLE_BUILTIN == TME_FLOAT_FORMAT_IEEE754_SINGLE) */

#if (TME_FLOAT_FORMAT_IEEE754_SINGLE_BUILTIN == TME_FLOAT_FORMAT_IEEE754_SINGLE)

/* this does a partial compliance single-precision sqrt: */
static void
_tme_ieee754_partial_single_sqrt(struct tme_ieee754_ctl *ieee754_ctl, const struct tme_float *src0, struct tme_float *dst)
{
  int exceptions;

  /* check for a NaN operand: */
  if (__tme_predict_false(tme_ieee754_single_check_nan_monadic(ieee754_ctl, src0, dst))) {
    return;
  }

  /* enter native floating-point operation: */
  tme_float_enter(ieee754_ctl->tme_ieee754_ctl_rounding_mode, tme_ieee754_exception_float, ieee754_ctl);
  ieee754_ctl->tme_ieee754_ctl_lock_unlock = tme_float_leave;

  /* assume that this operation raises no exceptions: */
  exceptions = 0;

  /* the operation: */
#if (TME_FLOAT_FORMAT_IEEE754_SINGLE_BUILTIN == TME_FLOAT_FORMAT_FLOAT)
  tme_ieee754_single_value_builtin_set(dst, TME_FLOAT_FORMAT_FLOAT, sqrtf(tme_ieee754_single_value_builtin_get(src0)));
#else  /* (TME_FLOAT_FORMAT_IEEE754_SINGLE_BUILTIN != TME_FLOAT_FORMAT_FLOAT) */
  tme_ieee754_single_value_builtin_set(dst, TME_FLOAT_FORMAT_DOUBLE, sqrtl(tme_ieee754_single_value_builtin_get(src0)));
#endif /* (TME_FLOAT_FORMAT_IEEE754_SINGLE_BUILTIN != TME_FLOAT_FORMAT_FLOAT) */

  /* leave native floating-point operation: */
  exceptions |= tme_float_leave();
  ieee754_ctl->tme_ieee754_ctl_lock_unlock = NULL;

  /* signal any exceptions: */
  if (exceptions != 0) {
    (*ieee754_ctl->tme_ieee754_ctl_exception)(ieee754_ctl, exceptions);
  }
}

#endif /* (TME_FLOAT_FORMAT_IEEE754_SINGLE_BUILTIN == TME_FLOAT_FORMAT_IEEE754_SINGLE) */

#if (TME_FLOAT_FORMAT_IEEE754_SINGLE_BUILTIN == TME_FLOAT_FORMAT_IEEE754_SINGLE)

/* this does a partial compliance single-precision abs: */
static void
_tme_ieee754_partial_single_abs(struct tme_ieee754_ctl *ieee754_ctl, const struct tme_float *src0, struct tme_float *dst)
{
  int exceptions;

  /* check for a NaN operand: */
  if (__tme_predict_false(tme_ieee754_single_check_nan_monadic(ieee754_ctl, src0, dst))) {
    return;
  }

  /* enter native floating-point operation: */
  tme_float_enter(ieee754_ctl->tme_ieee754_ctl_rounding_mode, tme_ieee754_exception_float, ieee754_ctl);
  ieee754_ctl->tme_ieee754_ctl_lock_unlock = tme_float_leave;

  /* assume that this operation raises no exceptions: */
  exceptions = 0;

  /* the operation: */
#if (TME_FLOAT_FORMAT_IEEE754_SINGLE_BUILTIN == TME_FLOAT_FORMAT_FLOAT)
  tme_ieee754_single_value_builtin_set(dst, TME_FLOAT_FORMAT_FLOAT, fabsf(tme_ieee754_single_value_builtin_get(src0)));
#else  /* (TME_FLOAT_FORMAT_IEEE754_SINGLE_BUILTIN != TME_FLOAT_FORMAT_FLOAT) */
  tme_ieee754_single_value_builtin_set(dst, TME_FLOAT_FORMAT_DOUBLE, fabsl(tme_ieee754_single_value_builtin_get(src0)));
#endif /* (TME_FLOAT_FORMAT_IEEE754_SINGLE_BUILTIN != TME_FLOAT_FORMAT_FLOAT) */

  /* leave native floating-point operation: */
  exceptions |= tme_float_leave();
  ieee754_ctl->tme_ieee754_ctl_lock_unlock = NULL;

  /* signal any exceptions: */
  if (exceptions != 0) {
    (*ieee754_ctl->tme_ieee754_ctl_exception)(ieee754_ctl, exceptions);
  }
}

#endif /* (TME_FLOAT_FORMAT_IEEE754_SINGLE_BUILTIN == TME_FLOAT_FORMAT_IEEE754_SINGLE) */

#if (TME_FLOAT_FORMAT_IEEE754_SINGLE_BUILTIN == TME_FLOAT_FORMAT_IEEE754_SINGLE)

/* this does a partial compliance single-precision neg: */
static void
_tme_ieee754_partial_single_neg(struct tme_ieee754_ctl *ieee754_ctl, const struct tme_float *src0, struct tme_float *dst)
{
  int exceptions;

  /* check for a NaN operand: */
  if (__tme_predict_false(tme_ieee754_single_check_nan_monadic(ieee754_ctl, src0, dst))) {
    return;
  }

  /* enter native floating-point operation: */
  tme_float_enter(ieee754_ctl->tme_ieee754_ctl_rounding_mode, tme_ieee754_exception_float, ieee754_ctl);
  ieee754_ctl->tme_ieee754_ctl_lock_unlock = tme_float_leave;

  /* assume that this operation raises no exceptions: */
  exceptions = 0;

  /* the operation: */
  tme_ieee754_single_value_builtin_set(dst, TME_FLOAT_FORMAT_IEEE754_SINGLE_BUILTIN, -1 * tme_ieee754_single_value_builtin_get(src0));

  /* leave native floating-point operation: */
  exceptions |= tme_float_leave();
  ieee754_ctl->tme_ieee754_ctl_lock_unlock = NULL;

  /* signal any exceptions: */
  if (exceptions != 0) {
    (*ieee754_ctl->tme_ieee754_ctl_exception)(ieee754_ctl, exceptions);
  }
}

#endif /* (TME_FLOAT_FORMAT_IEEE754_SINGLE_BUILTIN == TME_FLOAT_FORMAT_IEEE754_SINGLE) */

#if (TME_FLOAT_FORMAT_IEEE754_SINGLE_BUILTIN == TME_FLOAT_FORMAT_IEEE754_SINGLE)

/* this does a partial compliance single-precision move: */
static void
_tme_ieee754_partial_single_move(struct tme_ieee754_ctl *ieee754_ctl, const struct tme_float *src0, struct tme_float *dst)
{
  int exceptions;

  /* check for a NaN operand: */
  if (__tme_predict_false(tme_ieee754_single_check_nan_monadic(ieee754_ctl, src0, dst))) {
    return;
  }

  /* enter native floating-point operation: */
  tme_float_enter(ieee754_ctl->tme_ieee754_ctl_rounding_mode, tme_ieee754_exception_float, ieee754_ctl);
  ieee754_ctl->tme_ieee754_ctl_lock_unlock = tme_float_leave;

  /* assume that this operation raises no exceptions: */
  exceptions = 0;

  /* the operation: */
  *dst = *src0;

  /* leave native floating-point operation: */
  exceptions |= tme_float_leave();
  ieee754_ctl->tme_ieee754_ctl_lock_unlock = NULL;

  /* signal any exceptions: */
  if (exceptions != 0) {
    (*ieee754_ctl->tme_ieee754_ctl_exception)(ieee754_ctl, exceptions);
  }
}

#endif /* (TME_FLOAT_FORMAT_IEEE754_SINGLE_BUILTIN == TME_FLOAT_FORMAT_IEEE754_SINGLE) */

#if (TME_FLOAT_FORMAT_IEEE754_SINGLE_BUILTIN == TME_FLOAT_FORMAT_IEEE754_SINGLE)

/* this does a partial compliance single-precision exp: */
static void
_tme_ieee754_partial_single_exp(struct tme_ieee754_ctl *ieee754_ctl, const struct tme_float *src0, struct tme_float *dst)
{
  int exceptions;

  /* check for a NaN operand: */
  if (__tme_predict_false(tme_ieee754_single_check_nan_monadic(ieee754_ctl, src0, dst))) {
    return;
  }

  /* enter native floating-point operation: */
  tme_float_enter(ieee754_ctl->tme_ieee754_ctl_rounding_mode, tme_ieee754_exception_float, ieee754_ctl);
  ieee754_ctl->tme_ieee754_ctl_lock_unlock = tme_float_leave;

  /* assume that this operation raises no exceptions: */
  exceptions = 0;

  /* the operation: */
#if (TME_FLOAT_FORMAT_IEEE754_SINGLE_BUILTIN == TME_FLOAT_FORMAT_FLOAT)
  tme_ieee754_single_value_builtin_set(dst, TME_FLOAT_FORMAT_FLOAT, expf(tme_ieee754_single_value_builtin_get(src0)));
#else  /* (TME_FLOAT_FORMAT_IEEE754_SINGLE_BUILTIN != TME_FLOAT_FORMAT_FLOAT) */
  tme_ieee754_single_value_builtin_set(dst, TME_FLOAT_FORMAT_DOUBLE, expl(tme_ieee754_single_value_builtin_get(src0)));
#endif /* (TME_FLOAT_FORMAT_IEEE754_SINGLE_BUILTIN != TME_FLOAT_FORMAT_FLOAT) */

  /* leave native floating-point operation: */
  exceptions |= tme_float_leave();
  ieee754_ctl->tme_ieee754_ctl_lock_unlock = NULL;

  /* signal any exceptions: */
  if (exceptions != 0) {
    (*ieee754_ctl->tme_ieee754_ctl_exception)(ieee754_ctl, exceptions);
  }
}

#endif /* (TME_FLOAT_FORMAT_IEEE754_SINGLE_BUILTIN == TME_FLOAT_FORMAT_IEEE754_SINGLE) */

#if (TME_FLOAT_FORMAT_IEEE754_SINGLE_BUILTIN == TME_FLOAT_FORMAT_IEEE754_SINGLE)

/* this does a partial compliance single-precision log10: */
static void
_tme_ieee754_partial_single_log10(struct tme_ieee754_ctl *ieee754_ctl, const struct tme_float *src0, struct tme_float *dst)
{
  int exceptions;

  /* check for a NaN operand: */
  if (__tme_predict_false(tme_ieee754_single_check_nan_monadic(ieee754_ctl, src0, dst))) {
    return;
  }

  /* enter native floating-point operation: */
  tme_float_enter(ieee754_ctl->tme_ieee754_ctl_rounding_mode, tme_ieee754_exception_float, ieee754_ctl);
  ieee754_ctl->tme_ieee754_ctl_lock_unlock = tme_float_leave;

  /* assume that this operation raises no exceptions: */
  exceptions = 0;

  /* the operation: */
#if (TME_FLOAT_FORMAT_IEEE754_SINGLE_BUILTIN == TME_FLOAT_FORMAT_FLOAT)
  tme_ieee754_single_value_builtin_set(dst, TME_FLOAT_FORMAT_FLOAT, log10f(tme_ieee754_single_value_builtin_get(src0)));
#else  /* (TME_FLOAT_FORMAT_IEEE754_SINGLE_BUILTIN != TME_FLOAT_FORMAT_FLOAT) */
  tme_ieee754_single_value_builtin_set(dst, TME_FLOAT_FORMAT_DOUBLE, log10l(tme_ieee754_single_value_builtin_get(src0)));
#endif /* (TME_FLOAT_FORMAT_IEEE754_SINGLE_BUILTIN != TME_FLOAT_FORMAT_FLOAT) */

  /* leave native floating-point operation: */
  exceptions |= tme_float_leave();
  ieee754_ctl->tme_ieee754_ctl_lock_unlock = NULL;

  /* signal any exceptions: */
  if (exceptions != 0) {
    (*ieee754_ctl->tme_ieee754_ctl_exception)(ieee754_ctl, exceptions);
  }
}

#endif /* (TME_FLOAT_FORMAT_IEEE754_SINGLE_BUILTIN == TME_FLOAT_FORMAT_IEEE754_SINGLE) */

#if (TME_FLOAT_FORMAT_IEEE754_SINGLE_BUILTIN == TME_FLOAT_FORMAT_IEEE754_SINGLE)

/* this does a partial compliance single-precision log: */
static void
_tme_ieee754_partial_single_log(struct tme_ieee754_ctl *ieee754_ctl, const struct tme_float *src0, struct tme_float *dst)
{
  int exceptions;

  /* check for a NaN operand: */
  if (__tme_predict_false(tme_ieee754_single_check_nan_monadic(ieee754_ctl, src0, dst))) {
    return;
  }

  /* enter native floating-point operation: */
  tme_float_enter(ieee754_ctl->tme_ieee754_ctl_rounding_mode, tme_ieee754_exception_float, ieee754_ctl);
  ieee754_ctl->tme_ieee754_ctl_lock_unlock = tme_float_leave;

  /* assume that this operation raises no exceptions: */
  exceptions = 0;

  /* the operation: */
#if (TME_FLOAT_FORMAT_IEEE754_SINGLE_BUILTIN == TME_FLOAT_FORMAT_FLOAT)
  tme_ieee754_single_value_builtin_set(dst, TME_FLOAT_FORMAT_FLOAT, logf(tme_ieee754_single_value_builtin_get(src0)));
#else  /* (TME_FLOAT_FORMAT_IEEE754_SINGLE_BUILTIN != TME_FLOAT_FORMAT_FLOAT) */
  tme_ieee754_single_value_builtin_set(dst, TME_FLOAT_FORMAT_DOUBLE, logl(tme_ieee754_single_value_builtin_get(src0)));
#endif /* (TME_FLOAT_FORMAT_IEEE754_SINGLE_BUILTIN != TME_FLOAT_FORMAT_FLOAT) */

  /* leave native floating-point operation: */
  exceptions |= tme_float_leave();
  ieee754_ctl->tme_ieee754_ctl_lock_unlock = NULL;

  /* signal any exceptions: */
  if (exceptions != 0) {
    (*ieee754_ctl->tme_ieee754_ctl_exception)(ieee754_ctl, exceptions);
  }
}

#endif /* (TME_FLOAT_FORMAT_IEEE754_SINGLE_BUILTIN == TME_FLOAT_FORMAT_IEEE754_SINGLE) */

#if (TME_FLOAT_FORMAT_IEEE754_SINGLE_BUILTIN == TME_FLOAT_FORMAT_IEEE754_SINGLE)

/* this does a partial compliance single-precision scale: */
static void
_tme_ieee754_partial_single_scale(struct tme_ieee754_ctl *ieee754_ctl, const struct tme_float *src0, const struct tme_float *src1, struct tme_float *dst)
{
  int exceptions;

  /* check for a NaN operand: */
  if (__tme_predict_false(tme_ieee754_single_check_nan_dyadic(ieee754_ctl, src0, src1, dst))) {
    return;
  }

  /* enter native floating-point operation: */
  tme_float_enter(ieee754_ctl->tme_ieee754_ctl_rounding_mode, tme_ieee754_exception_float, ieee754_ctl);
  ieee754_ctl->tme_ieee754_ctl_lock_unlock = tme_float_leave;

  /* assume that this operation raises no exceptions: */
  exceptions = 0;

  /* the operation: */
#if (TME_FLOAT_FORMAT_IEEE754_SINGLE_BUILTIN == TME_FLOAT_FORMAT_FLOAT)
  tme_ieee754_single_value_builtin_set(dst, TME_FLOAT_FORMAT_FLOAT, scalbnf(tme_ieee754_single_value_builtin_get(src0), tme_ieee754_single_value_builtin_get(src1)));
#else  /* (TME_FLOAT_FORMAT_IEEE754_SINGLE_BUILTIN != TME_FLOAT_FORMAT_FLOAT) */
  tme_ieee754_single_value_builtin_set(dst, TME_FLOAT_FORMAT_DOUBLE, scalbnl(tme_ieee754_single_value_builtin_get(src0), tme_ieee754_single_value_builtin_get(src1)));
#endif /* (TME_FLOAT_FORMAT_IEEE754_SINGLE_BUILTIN != TME_FLOAT_FORMAT_FLOAT) */

  /* leave native floating-point operation: */
  exceptions |= tme_float_leave();
  ieee754_ctl->tme_ieee754_ctl_lock_unlock = NULL;

  /* signal any exceptions: */
  if (exceptions != 0) {
    (*ieee754_ctl->tme_ieee754_ctl_exception)(ieee754_ctl, exceptions);
  }
}

#endif /* (TME_FLOAT_FORMAT_IEEE754_SINGLE_BUILTIN == TME_FLOAT_FORMAT_IEEE754_SINGLE) */

#if (TME_FLOAT_FORMAT_IEEE754_SINGLE_BUILTIN == TME_FLOAT_FORMAT_IEEE754_SINGLE)

/* this does a partial compliance single-precision pow: */
static void
_tme_ieee754_partial_single_pow(struct tme_ieee754_ctl *ieee754_ctl, const struct tme_float *src0, const struct tme_float *src1, struct tme_float *dst)
{
  int exceptions;

  /* check for a NaN operand: */
  if (__tme_predict_false(tme_ieee754_single_check_nan_dyadic(ieee754_ctl, src0, src1, dst))) {
    return;
  }

  /* enter native floating-point operation: */
  tme_float_enter(ieee754_ctl->tme_ieee754_ctl_rounding_mode, tme_ieee754_exception_float, ieee754_ctl);
  ieee754_ctl->tme_ieee754_ctl_lock_unlock = tme_float_leave;

  /* assume that this operation raises no exceptions: */
  exceptions = 0;

  /* the operation: */
#if (TME_FLOAT_FORMAT_IEEE754_SINGLE_BUILTIN == TME_FLOAT_FORMAT_FLOAT)
  tme_ieee754_single_value_builtin_set(dst, TME_FLOAT_FORMAT_FLOAT, powf(tme_ieee754_single_value_builtin_get(src0), tme_ieee754_single_value_builtin_get(src1)));
#else  /* (TME_FLOAT_FORMAT_IEEE754_SINGLE_BUILTIN != TME_FLOAT_FORMAT_FLOAT) */
  tme_ieee754_single_value_builtin_set(dst, TME_FLOAT_FORMAT_DOUBLE, powl(tme_ieee754_single_value_builtin_get(src0), tme_ieee754_single_value_builtin_get(src1)));
#endif /* (TME_FLOAT_FORMAT_IEEE754_SINGLE_BUILTIN != TME_FLOAT_FORMAT_FLOAT) */

  /* leave native floating-point operation: */
  exceptions |= tme_float_leave();
  ieee754_ctl->tme_ieee754_ctl_lock_unlock = NULL;

  /* signal any exceptions: */
  if (exceptions != 0) {
    (*ieee754_ctl->tme_ieee754_ctl_exception)(ieee754_ctl, exceptions);
  }
}

#endif /* (TME_FLOAT_FORMAT_IEEE754_SINGLE_BUILTIN == TME_FLOAT_FORMAT_IEEE754_SINGLE) */

#if (TME_FLOAT_FORMAT_IEEE754_DOUBLE_BUILTIN == TME_FLOAT_FORMAT_IEEE754_DOUBLE)

/* this does a partial compliance double-precision add: */
static void
_tme_ieee754_partial_double_add(struct tme_ieee754_ctl *ieee754_ctl, const struct tme_float *src0, const struct tme_float *src1, struct tme_float *dst)
{
  int exceptions;

  /* check for a NaN operand: */
  if (__tme_predict_false(tme_ieee754_double_check_nan_dyadic(ieee754_ctl, src0, src1, dst))) {
    return;
  }

  /* enter native floating-point operation: */
  tme_float_enter(ieee754_ctl->tme_ieee754_ctl_rounding_mode, tme_ieee754_exception_float, ieee754_ctl);
  ieee754_ctl->tme_ieee754_ctl_lock_unlock = tme_float_leave;

  /* assume that this operation raises no exceptions: */
  exceptions = 0;

  /* the operation: */
  tme_ieee754_double_value_builtin_set(dst, TME_FLOAT_FORMAT_IEEE754_DOUBLE_BUILTIN, tme_ieee754_double_value_builtin_get(src0) + tme_ieee754_double_value_builtin_get(src1));

  /* leave native floating-point operation: */
  exceptions |= tme_float_leave();
  ieee754_ctl->tme_ieee754_ctl_lock_unlock = NULL;

  /* signal any exceptions: */
  if (exceptions != 0) {
    (*ieee754_ctl->tme_ieee754_ctl_exception)(ieee754_ctl, exceptions);
  }
}

#endif /* (TME_FLOAT_FORMAT_IEEE754_DOUBLE_BUILTIN == TME_FLOAT_FORMAT_IEEE754_DOUBLE) */

#if (TME_FLOAT_FORMAT_IEEE754_DOUBLE_BUILTIN == TME_FLOAT_FORMAT_IEEE754_DOUBLE)

/* this does a partial compliance double-precision sub: */
static void
_tme_ieee754_partial_double_sub(struct tme_ieee754_ctl *ieee754_ctl, const struct tme_float *src0, const struct tme_float *src1, struct tme_float *dst)
{
  int exceptions;

  /* check for a NaN operand: */
  if (__tme_predict_false(tme_ieee754_double_check_nan_dyadic(ieee754_ctl, src0, src1, dst))) {
    return;
  }

  /* enter native floating-point operation: */
  tme_float_enter(ieee754_ctl->tme_ieee754_ctl_rounding_mode, tme_ieee754_exception_float, ieee754_ctl);
  ieee754_ctl->tme_ieee754_ctl_lock_unlock = tme_float_leave;

  /* assume that this operation raises no exceptions: */
  exceptions = 0;

  /* the operation: */
  tme_ieee754_double_value_builtin_set(dst, TME_FLOAT_FORMAT_IEEE754_DOUBLE_BUILTIN, tme_ieee754_double_value_builtin_get(src0) - tme_ieee754_double_value_builtin_get(src1));

  /* leave native floating-point operation: */
  exceptions |= tme_float_leave();
  ieee754_ctl->tme_ieee754_ctl_lock_unlock = NULL;

  /* signal any exceptions: */
  if (exceptions != 0) {
    (*ieee754_ctl->tme_ieee754_ctl_exception)(ieee754_ctl, exceptions);
  }
}

#endif /* (TME_FLOAT_FORMAT_IEEE754_DOUBLE_BUILTIN == TME_FLOAT_FORMAT_IEEE754_DOUBLE) */

#if (TME_FLOAT_FORMAT_IEEE754_DOUBLE_BUILTIN == TME_FLOAT_FORMAT_IEEE754_DOUBLE)

/* this does a partial compliance double-precision mul: */
static void
_tme_ieee754_partial_double_mul(struct tme_ieee754_ctl *ieee754_ctl, const struct tme_float *src0, const struct tme_float *src1, struct tme_float *dst)
{
  int exceptions;

  /* check for a NaN operand: */
  if (__tme_predict_false(tme_ieee754_double_check_nan_dyadic(ieee754_ctl, src0, src1, dst))) {
    return;
  }

  /* enter native floating-point operation: */
  tme_float_enter(ieee754_ctl->tme_ieee754_ctl_rounding_mode, tme_ieee754_exception_float, ieee754_ctl);
  ieee754_ctl->tme_ieee754_ctl_lock_unlock = tme_float_leave;

  /* assume that this operation raises no exceptions: */
  exceptions = 0;

  /* the operation: */
  tme_ieee754_double_value_builtin_set(dst, TME_FLOAT_FORMAT_IEEE754_DOUBLE_BUILTIN, tme_ieee754_double_value_builtin_get(src0) * tme_ieee754_double_value_builtin_get(src1));

  /* leave native floating-point operation: */
  exceptions |= tme_float_leave();
  ieee754_ctl->tme_ieee754_ctl_lock_unlock = NULL;

  /* signal any exceptions: */
  if (exceptions != 0) {
    (*ieee754_ctl->tme_ieee754_ctl_exception)(ieee754_ctl, exceptions);
  }
}

#endif /* (TME_FLOAT_FORMAT_IEEE754_DOUBLE_BUILTIN == TME_FLOAT_FORMAT_IEEE754_DOUBLE) */

#if (TME_FLOAT_FORMAT_IEEE754_DOUBLE_BUILTIN == TME_FLOAT_FORMAT_IEEE754_DOUBLE)

/* this does a partial compliance double-precision div: */
static void
_tme_ieee754_partial_double_div(struct tme_ieee754_ctl *ieee754_ctl, const struct tme_float *src0, const struct tme_float *src1, struct tme_float *dst)
{
  int exceptions;

  /* check for a NaN operand: */
  if (__tme_predict_false(tme_ieee754_double_check_nan_dyadic(ieee754_ctl, src0, src1, dst))) {
    return;
  }

  /* enter native floating-point operation: */
  tme_float_enter(ieee754_ctl->tme_ieee754_ctl_rounding_mode, tme_ieee754_exception_float, ieee754_ctl);
  ieee754_ctl->tme_ieee754_ctl_lock_unlock = tme_float_leave;

  /* assume that this operation raises no exceptions: */
  exceptions = 0;

  /* the operation: */
  tme_ieee754_double_value_builtin_set(dst, TME_FLOAT_FORMAT_IEEE754_DOUBLE_BUILTIN, tme_ieee754_double_value_builtin_get(src0) / tme_ieee754_double_value_builtin_get(src1));

  /* leave native floating-point operation: */
  exceptions |= tme_float_leave();
  ieee754_ctl->tme_ieee754_ctl_lock_unlock = NULL;

  /* signal any exceptions: */
  if (exceptions != 0) {
    (*ieee754_ctl->tme_ieee754_ctl_exception)(ieee754_ctl, exceptions);
  }
}

#endif /* (TME_FLOAT_FORMAT_IEEE754_DOUBLE_BUILTIN == TME_FLOAT_FORMAT_IEEE754_DOUBLE) */

#if (TME_FLOAT_FORMAT_IEEE754_DOUBLE_BUILTIN == TME_FLOAT_FORMAT_IEEE754_DOUBLE)

/* this does a partial compliance double-precision sqrt: */
static void
_tme_ieee754_partial_double_sqrt(struct tme_ieee754_ctl *ieee754_ctl, const struct tme_float *src0, struct tme_float *dst)
{
  int exceptions;

  /* check for a NaN operand: */
  if (__tme_predict_false(tme_ieee754_double_check_nan_monadic(ieee754_ctl, src0, dst))) {
    return;
  }

  /* enter native floating-point operation: */
  tme_float_enter(ieee754_ctl->tme_ieee754_ctl_rounding_mode, tme_ieee754_exception_float, ieee754_ctl);
  ieee754_ctl->tme_ieee754_ctl_lock_unlock = tme_float_leave;

  /* assume that this operation raises no exceptions: */
  exceptions = 0;

  /* the operation: */
#if (TME_FLOAT_FORMAT_IEEE754_DOUBLE_BUILTIN == TME_FLOAT_FORMAT_FLOAT)
  tme_ieee754_double_value_builtin_set(dst, TME_FLOAT_FORMAT_FLOAT, sqrtf(tme_ieee754_double_value_builtin_get(src0)));
#else  /* (TME_FLOAT_FORMAT_IEEE754_DOUBLE_BUILTIN != TME_FLOAT_FORMAT_FLOAT) */
  tme_ieee754_double_value_builtin_set(dst, TME_FLOAT_FORMAT_DOUBLE, sqrtl(tme_ieee754_double_value_builtin_get(src0)));
#endif /* (TME_FLOAT_FORMAT_IEEE754_DOUBLE_BUILTIN != TME_FLOAT_FORMAT_FLOAT) */

  /* leave native floating-point operation: */
  exceptions |= tme_float_leave();
  ieee754_ctl->tme_ieee754_ctl_lock_unlock = NULL;

  /* signal any exceptions: */
  if (exceptions != 0) {
    (*ieee754_ctl->tme_ieee754_ctl_exception)(ieee754_ctl, exceptions);
  }
}

#endif /* (TME_FLOAT_FORMAT_IEEE754_DOUBLE_BUILTIN == TME_FLOAT_FORMAT_IEEE754_DOUBLE) */

#if (TME_FLOAT_FORMAT_IEEE754_DOUBLE_BUILTIN == TME_FLOAT_FORMAT_IEEE754_DOUBLE)

/* this does a partial compliance double-precision abs: */
static void
_tme_ieee754_partial_double_abs(struct tme_ieee754_ctl *ieee754_ctl, const struct tme_float *src0, struct tme_float *dst)
{
  int exceptions;

  /* check for a NaN operand: */
  if (__tme_predict_false(tme_ieee754_double_check_nan_monadic(ieee754_ctl, src0, dst))) {
    return;
  }

  /* enter native floating-point operation: */
  tme_float_enter(ieee754_ctl->tme_ieee754_ctl_rounding_mode, tme_ieee754_exception_float, ieee754_ctl);
  ieee754_ctl->tme_ieee754_ctl_lock_unlock = tme_float_leave;

  /* assume that this operation raises no exceptions: */
  exceptions = 0;

  /* the operation: */
#if (TME_FLOAT_FORMAT_IEEE754_DOUBLE_BUILTIN == TME_FLOAT_FORMAT_FLOAT)
  tme_ieee754_double_value_builtin_set(dst, TME_FLOAT_FORMAT_FLOAT, fabsf(tme_ieee754_double_value_builtin_get(src0)));
#else  /* (TME_FLOAT_FORMAT_IEEE754_DOUBLE_BUILTIN != TME_FLOAT_FORMAT_FLOAT) */
  tme_ieee754_double_value_builtin_set(dst, TME_FLOAT_FORMAT_DOUBLE, fabsl(tme_ieee754_double_value_builtin_get(src0)));
#endif /* (TME_FLOAT_FORMAT_IEEE754_DOUBLE_BUILTIN != TME_FLOAT_FORMAT_FLOAT) */

  /* leave native floating-point operation: */
  exceptions |= tme_float_leave();
  ieee754_ctl->tme_ieee754_ctl_lock_unlock = NULL;

  /* signal any exceptions: */
  if (exceptions != 0) {
    (*ieee754_ctl->tme_ieee754_ctl_exception)(ieee754_ctl, exceptions);
  }
}

#endif /* (TME_FLOAT_FORMAT_IEEE754_DOUBLE_BUILTIN == TME_FLOAT_FORMAT_IEEE754_DOUBLE) */

#if (TME_FLOAT_FORMAT_IEEE754_DOUBLE_BUILTIN == TME_FLOAT_FORMAT_IEEE754_DOUBLE)

/* this does a partial compliance double-precision neg: */
static void
_tme_ieee754_partial_double_neg(struct tme_ieee754_ctl *ieee754_ctl, const struct tme_float *src0, struct tme_float *dst)
{
  int exceptions;

  /* check for a NaN operand: */
  if (__tme_predict_false(tme_ieee754_double_check_nan_monadic(ieee754_ctl, src0, dst))) {
    return;
  }

  /* enter native floating-point operation: */
  tme_float_enter(ieee754_ctl->tme_ieee754_ctl_rounding_mode, tme_ieee754_exception_float, ieee754_ctl);
  ieee754_ctl->tme_ieee754_ctl_lock_unlock = tme_float_leave;

  /* assume that this operation raises no exceptions: */
  exceptions = 0;

  /* the operation: */
  tme_ieee754_double_value_builtin_set(dst, TME_FLOAT_FORMAT_IEEE754_DOUBLE_BUILTIN, -1 * tme_ieee754_double_value_builtin_get(src0));

  /* leave native floating-point operation: */
  exceptions |= tme_float_leave();
  ieee754_ctl->tme_ieee754_ctl_lock_unlock = NULL;

  /* signal any exceptions: */
  if (exceptions != 0) {
    (*ieee754_ctl->tme_ieee754_ctl_exception)(ieee754_ctl, exceptions);
  }
}

#endif /* (TME_FLOAT_FORMAT_IEEE754_DOUBLE_BUILTIN == TME_FLOAT_FORMAT_IEEE754_DOUBLE) */

#if (TME_FLOAT_FORMAT_IEEE754_DOUBLE_BUILTIN == TME_FLOAT_FORMAT_IEEE754_DOUBLE)

/* this does a partial compliance double-precision move: */
static void
_tme_ieee754_partial_double_move(struct tme_ieee754_ctl *ieee754_ctl, const struct tme_float *src0, struct tme_float *dst)
{
  int exceptions;

  /* check for a NaN operand: */
  if (__tme_predict_false(tme_ieee754_double_check_nan_monadic(ieee754_ctl, src0, dst))) {
    return;
  }

  /* enter native floating-point operation: */
  tme_float_enter(ieee754_ctl->tme_ieee754_ctl_rounding_mode, tme_ieee754_exception_float, ieee754_ctl);
  ieee754_ctl->tme_ieee754_ctl_lock_unlock = tme_float_leave;

  /* assume that this operation raises no exceptions: */
  exceptions = 0;

  /* the operation: */
  *dst = *src0;

  /* leave native floating-point operation: */
  exceptions |= tme_float_leave();
  ieee754_ctl->tme_ieee754_ctl_lock_unlock = NULL;

  /* signal any exceptions: */
  if (exceptions != 0) {
    (*ieee754_ctl->tme_ieee754_ctl_exception)(ieee754_ctl, exceptions);
  }
}

#endif /* (TME_FLOAT_FORMAT_IEEE754_DOUBLE_BUILTIN == TME_FLOAT_FORMAT_IEEE754_DOUBLE) */

#if (TME_FLOAT_FORMAT_IEEE754_DOUBLE_BUILTIN == TME_FLOAT_FORMAT_IEEE754_DOUBLE)

/* this does a partial compliance double-precision exp: */
static void
_tme_ieee754_partial_double_exp(struct tme_ieee754_ctl *ieee754_ctl, const struct tme_float *src0, struct tme_float *dst)
{
  int exceptions;

  /* check for a NaN operand: */
  if (__tme_predict_false(tme_ieee754_double_check_nan_monadic(ieee754_ctl, src0, dst))) {
    return;
  }

  /* enter native floating-point operation: */
  tme_float_enter(ieee754_ctl->tme_ieee754_ctl_rounding_mode, tme_ieee754_exception_float, ieee754_ctl);
  ieee754_ctl->tme_ieee754_ctl_lock_unlock = tme_float_leave;

  /* assume that this operation raises no exceptions: */
  exceptions = 0;

  /* the operation: */
#if (TME_FLOAT_FORMAT_IEEE754_DOUBLE_BUILTIN == TME_FLOAT_FORMAT_FLOAT)
  tme_ieee754_double_value_builtin_set(dst, TME_FLOAT_FORMAT_FLOAT, expf(tme_ieee754_double_value_builtin_get(src0)));
#else  /* (TME_FLOAT_FORMAT_IEEE754_DOUBLE_BUILTIN != TME_FLOAT_FORMAT_FLOAT) */
  tme_ieee754_double_value_builtin_set(dst, TME_FLOAT_FORMAT_DOUBLE, expl(tme_ieee754_double_value_builtin_get(src0)));
#endif /* (TME_FLOAT_FORMAT_IEEE754_DOUBLE_BUILTIN != TME_FLOAT_FORMAT_FLOAT) */

  /* leave native floating-point operation: */
  exceptions |= tme_float_leave();
  ieee754_ctl->tme_ieee754_ctl_lock_unlock = NULL;

  /* signal any exceptions: */
  if (exceptions != 0) {
    (*ieee754_ctl->tme_ieee754_ctl_exception)(ieee754_ctl, exceptions);
  }
}

#endif /* (TME_FLOAT_FORMAT_IEEE754_DOUBLE_BUILTIN == TME_FLOAT_FORMAT_IEEE754_DOUBLE) */

#if (TME_FLOAT_FORMAT_IEEE754_DOUBLE_BUILTIN == TME_FLOAT_FORMAT_IEEE754_DOUBLE)

/* this does a partial compliance double-precision log10: */
static void
_tme_ieee754_partial_double_log10(struct tme_ieee754_ctl *ieee754_ctl, const struct tme_float *src0, struct tme_float *dst)
{
  int exceptions;

  /* check for a NaN operand: */
  if (__tme_predict_false(tme_ieee754_double_check_nan_monadic(ieee754_ctl, src0, dst))) {
    return;
  }

  /* enter native floating-point operation: */
  tme_float_enter(ieee754_ctl->tme_ieee754_ctl_rounding_mode, tme_ieee754_exception_float, ieee754_ctl);
  ieee754_ctl->tme_ieee754_ctl_lock_unlock = tme_float_leave;

  /* assume that this operation raises no exceptions: */
  exceptions = 0;

  /* the operation: */
#if (TME_FLOAT_FORMAT_IEEE754_DOUBLE_BUILTIN == TME_FLOAT_FORMAT_FLOAT)
  tme_ieee754_double_value_builtin_set(dst, TME_FLOAT_FORMAT_FLOAT, log10f(tme_ieee754_double_value_builtin_get(src0)));
#else  /* (TME_FLOAT_FORMAT_IEEE754_DOUBLE_BUILTIN != TME_FLOAT_FORMAT_FLOAT) */
  tme_ieee754_double_value_builtin_set(dst, TME_FLOAT_FORMAT_DOUBLE, log10l(tme_ieee754_double_value_builtin_get(src0)));
#endif /* (TME_FLOAT_FORMAT_IEEE754_DOUBLE_BUILTIN != TME_FLOAT_FORMAT_FLOAT) */

  /* leave native floating-point operation: */
  exceptions |= tme_float_leave();
  ieee754_ctl->tme_ieee754_ctl_lock_unlock = NULL;

  /* signal any exceptions: */
  if (exceptions != 0) {
    (*ieee754_ctl->tme_ieee754_ctl_exception)(ieee754_ctl, exceptions);
  }
}

#endif /* (TME_FLOAT_FORMAT_IEEE754_DOUBLE_BUILTIN == TME_FLOAT_FORMAT_IEEE754_DOUBLE) */

#if (TME_FLOAT_FORMAT_IEEE754_DOUBLE_BUILTIN == TME_FLOAT_FORMAT_IEEE754_DOUBLE)

/* this does a partial compliance double-precision log: */
static void
_tme_ieee754_partial_double_log(struct tme_ieee754_ctl *ieee754_ctl, const struct tme_float *src0, struct tme_float *dst)
{
  int exceptions;

  /* check for a NaN operand: */
  if (__tme_predict_false(tme_ieee754_double_check_nan_monadic(ieee754_ctl, src0, dst))) {
    return;
  }

  /* enter native floating-point operation: */
  tme_float_enter(ieee754_ctl->tme_ieee754_ctl_rounding_mode, tme_ieee754_exception_float, ieee754_ctl);
  ieee754_ctl->tme_ieee754_ctl_lock_unlock = tme_float_leave;

  /* assume that this operation raises no exceptions: */
  exceptions = 0;

  /* the operation: */
#if (TME_FLOAT_FORMAT_IEEE754_DOUBLE_BUILTIN == TME_FLOAT_FORMAT_FLOAT)
  tme_ieee754_double_value_builtin_set(dst, TME_FLOAT_FORMAT_FLOAT, logf(tme_ieee754_double_value_builtin_get(src0)));
#else  /* (TME_FLOAT_FORMAT_IEEE754_DOUBLE_BUILTIN != TME_FLOAT_FORMAT_FLOAT) */
  tme_ieee754_double_value_builtin_set(dst, TME_FLOAT_FORMAT_DOUBLE, logl(tme_ieee754_double_value_builtin_get(src0)));
#endif /* (TME_FLOAT_FORMAT_IEEE754_DOUBLE_BUILTIN != TME_FLOAT_FORMAT_FLOAT) */

  /* leave native floating-point operation: */
  exceptions |= tme_float_leave();
  ieee754_ctl->tme_ieee754_ctl_lock_unlock = NULL;

  /* signal any exceptions: */
  if (exceptions != 0) {
    (*ieee754_ctl->tme_ieee754_ctl_exception)(ieee754_ctl, exceptions);
  }
}

#endif /* (TME_FLOAT_FORMAT_IEEE754_DOUBLE_BUILTIN == TME_FLOAT_FORMAT_IEEE754_DOUBLE) */

#if (TME_FLOAT_FORMAT_IEEE754_DOUBLE_BUILTIN == TME_FLOAT_FORMAT_IEEE754_DOUBLE)

/* this does a partial compliance double-precision scale: */
static void
_tme_ieee754_partial_double_scale(struct tme_ieee754_ctl *ieee754_ctl, const struct tme_float *src0, const struct tme_float *src1, struct tme_float *dst)
{
  int exceptions;

  /* check for a NaN operand: */
  if (__tme_predict_false(tme_ieee754_double_check_nan_dyadic(ieee754_ctl, src0, src1, dst))) {
    return;
  }

  /* enter native floating-point operation: */
  tme_float_enter(ieee754_ctl->tme_ieee754_ctl_rounding_mode, tme_ieee754_exception_float, ieee754_ctl);
  ieee754_ctl->tme_ieee754_ctl_lock_unlock = tme_float_leave;

  /* assume that this operation raises no exceptions: */
  exceptions = 0;

  /* the operation: */
#if (TME_FLOAT_FORMAT_IEEE754_DOUBLE_BUILTIN == TME_FLOAT_FORMAT_FLOAT)
  tme_ieee754_double_value_builtin_set(dst, TME_FLOAT_FORMAT_FLOAT, scalbnf(tme_ieee754_double_value_builtin_get(src0), tme_ieee754_double_value_builtin_get(src1)));
#else  /* (TME_FLOAT_FORMAT_IEEE754_DOUBLE_BUILTIN != TME_FLOAT_FORMAT_FLOAT) */
  tme_ieee754_double_value_builtin_set(dst, TME_FLOAT_FORMAT_DOUBLE, scalbnl(tme_ieee754_double_value_builtin_get(src0), tme_ieee754_double_value_builtin_get(src1)));
#endif /* (TME_FLOAT_FORMAT_IEEE754_DOUBLE_BUILTIN != TME_FLOAT_FORMAT_FLOAT) */

  /* leave native floating-point operation: */
  exceptions |= tme_float_leave();
  ieee754_ctl->tme_ieee754_ctl_lock_unlock = NULL;

  /* signal any exceptions: */
  if (exceptions != 0) {
    (*ieee754_ctl->tme_ieee754_ctl_exception)(ieee754_ctl, exceptions);
  }
}

#endif /* (TME_FLOAT_FORMAT_IEEE754_DOUBLE_BUILTIN == TME_FLOAT_FORMAT_IEEE754_DOUBLE) */

#if (TME_FLOAT_FORMAT_IEEE754_DOUBLE_BUILTIN == TME_FLOAT_FORMAT_IEEE754_DOUBLE)

/* this does a partial compliance double-precision pow: */
static void
_tme_ieee754_partial_double_pow(struct tme_ieee754_ctl *ieee754_ctl, const struct tme_float *src0, const struct tme_float *src1, struct tme_float *dst)
{
  int exceptions;

  /* check for a NaN operand: */
  if (__tme_predict_false(tme_ieee754_double_check_nan_dyadic(ieee754_ctl, src0, src1, dst))) {
    return;
  }

  /* enter native floating-point operation: */
  tme_float_enter(ieee754_ctl->tme_ieee754_ctl_rounding_mode, tme_ieee754_exception_float, ieee754_ctl);
  ieee754_ctl->tme_ieee754_ctl_lock_unlock = tme_float_leave;

  /* assume that this operation raises no exceptions: */
  exceptions = 0;

  /* the operation: */
#if (TME_FLOAT_FORMAT_IEEE754_DOUBLE_BUILTIN == TME_FLOAT_FORMAT_FLOAT)
  tme_ieee754_double_value_builtin_set(dst, TME_FLOAT_FORMAT_FLOAT, powf(tme_ieee754_double_value_builtin_get(src0), tme_ieee754_double_value_builtin_get(src1)));
#else  /* (TME_FLOAT_FORMAT_IEEE754_DOUBLE_BUILTIN != TME_FLOAT_FORMAT_FLOAT) */
  tme_ieee754_double_value_builtin_set(dst, TME_FLOAT_FORMAT_DOUBLE, powl(tme_ieee754_double_value_builtin_get(src0), tme_ieee754_double_value_builtin_get(src1)));
#endif /* (TME_FLOAT_FORMAT_IEEE754_DOUBLE_BUILTIN != TME_FLOAT_FORMAT_FLOAT) */

  /* leave native floating-point operation: */
  exceptions |= tme_float_leave();
  ieee754_ctl->tme_ieee754_ctl_lock_unlock = NULL;

  /* signal any exceptions: */
  if (exceptions != 0) {
    (*ieee754_ctl->tme_ieee754_ctl_exception)(ieee754_ctl, exceptions);
  }
}

#endif /* (TME_FLOAT_FORMAT_IEEE754_DOUBLE_BUILTIN == TME_FLOAT_FORMAT_IEEE754_DOUBLE) */

#if (TME_FLOAT_FORMAT_IEEE754_EXTENDED80_BUILTIN == TME_FLOAT_FORMAT_IEEE754_EXTENDED80)

/* this does a partial compliance extended80-precision add: */
static void
_tme_ieee754_partial_extended80_add(struct tme_ieee754_ctl *ieee754_ctl, const struct tme_float *src0, const struct tme_float *src1, struct tme_float *dst)
{
  int exceptions;

  /* check for a NaN operand: */
  if (__tme_predict_false(tme_ieee754_extended80_check_nan_dyadic(ieee754_ctl, src0, src1, dst))) {
    return;
  }

  /* enter native floating-point operation: */
  tme_float_enter(ieee754_ctl->tme_ieee754_ctl_rounding_mode, tme_ieee754_exception_float, ieee754_ctl);
  ieee754_ctl->tme_ieee754_ctl_lock_unlock = tme_float_leave;

  /* assume that this operation raises no exceptions: */
  exceptions = 0;

  /* the operation: */
  tme_ieee754_extended80_value_builtin_set(dst, TME_FLOAT_FORMAT_IEEE754_EXTENDED80_BUILTIN, tme_ieee754_extended80_value_builtin_get(src0) + tme_ieee754_extended80_value_builtin_get(src1));

  /* leave native floating-point operation: */
  exceptions |= tme_float_leave();
  ieee754_ctl->tme_ieee754_ctl_lock_unlock = NULL;

  /* signal any exceptions: */
  if (exceptions != 0) {
    (*ieee754_ctl->tme_ieee754_ctl_exception)(ieee754_ctl, exceptions);
  }
}

#endif /* (TME_FLOAT_FORMAT_IEEE754_EXTENDED80_BUILTIN == TME_FLOAT_FORMAT_IEEE754_EXTENDED80) */

#if (TME_FLOAT_FORMAT_IEEE754_EXTENDED80_BUILTIN == TME_FLOAT_FORMAT_IEEE754_EXTENDED80)

/* this does a partial compliance extended80-precision sub: */
static void
_tme_ieee754_partial_extended80_sub(struct tme_ieee754_ctl *ieee754_ctl, const struct tme_float *src0, const struct tme_float *src1, struct tme_float *dst)
{
  int exceptions;

  /* check for a NaN operand: */
  if (__tme_predict_false(tme_ieee754_extended80_check_nan_dyadic(ieee754_ctl, src0, src1, dst))) {
    return;
  }

  /* enter native floating-point operation: */
  tme_float_enter(ieee754_ctl->tme_ieee754_ctl_rounding_mode, tme_ieee754_exception_float, ieee754_ctl);
  ieee754_ctl->tme_ieee754_ctl_lock_unlock = tme_float_leave;

  /* assume that this operation raises no exceptions: */
  exceptions = 0;

  /* the operation: */
  tme_ieee754_extended80_value_builtin_set(dst, TME_FLOAT_FORMAT_IEEE754_EXTENDED80_BUILTIN, tme_ieee754_extended80_value_builtin_get(src0) - tme_ieee754_extended80_value_builtin_get(src1));

  /* leave native floating-point operation: */
  exceptions |= tme_float_leave();
  ieee754_ctl->tme_ieee754_ctl_lock_unlock = NULL;

  /* signal any exceptions: */
  if (exceptions != 0) {
    (*ieee754_ctl->tme_ieee754_ctl_exception)(ieee754_ctl, exceptions);
  }
}

#endif /* (TME_FLOAT_FORMAT_IEEE754_EXTENDED80_BUILTIN == TME_FLOAT_FORMAT_IEEE754_EXTENDED80) */

#if (TME_FLOAT_FORMAT_IEEE754_EXTENDED80_BUILTIN == TME_FLOAT_FORMAT_IEEE754_EXTENDED80)

/* this does a partial compliance extended80-precision mul: */
static void
_tme_ieee754_partial_extended80_mul(struct tme_ieee754_ctl *ieee754_ctl, const struct tme_float *src0, const struct tme_float *src1, struct tme_float *dst)
{
  int exceptions;

  /* check for a NaN operand: */
  if (__tme_predict_false(tme_ieee754_extended80_check_nan_dyadic(ieee754_ctl, src0, src1, dst))) {
    return;
  }

  /* enter native floating-point operation: */
  tme_float_enter(ieee754_ctl->tme_ieee754_ctl_rounding_mode, tme_ieee754_exception_float, ieee754_ctl);
  ieee754_ctl->tme_ieee754_ctl_lock_unlock = tme_float_leave;

  /* assume that this operation raises no exceptions: */
  exceptions = 0;

  /* the operation: */
  tme_ieee754_extended80_value_builtin_set(dst, TME_FLOAT_FORMAT_IEEE754_EXTENDED80_BUILTIN, tme_ieee754_extended80_value_builtin_get(src0) * tme_ieee754_extended80_value_builtin_get(src1));

  /* leave native floating-point operation: */
  exceptions |= tme_float_leave();
  ieee754_ctl->tme_ieee754_ctl_lock_unlock = NULL;

  /* signal any exceptions: */
  if (exceptions != 0) {
    (*ieee754_ctl->tme_ieee754_ctl_exception)(ieee754_ctl, exceptions);
  }
}

#endif /* (TME_FLOAT_FORMAT_IEEE754_EXTENDED80_BUILTIN == TME_FLOAT_FORMAT_IEEE754_EXTENDED80) */

#if (TME_FLOAT_FORMAT_IEEE754_EXTENDED80_BUILTIN == TME_FLOAT_FORMAT_IEEE754_EXTENDED80)

/* this does a partial compliance extended80-precision div: */
static void
_tme_ieee754_partial_extended80_div(struct tme_ieee754_ctl *ieee754_ctl, const struct tme_float *src0, const struct tme_float *src1, struct tme_float *dst)
{
  int exceptions;

  /* check for a NaN operand: */
  if (__tme_predict_false(tme_ieee754_extended80_check_nan_dyadic(ieee754_ctl, src0, src1, dst))) {
    return;
  }

  /* enter native floating-point operation: */
  tme_float_enter(ieee754_ctl->tme_ieee754_ctl_rounding_mode, tme_ieee754_exception_float, ieee754_ctl);
  ieee754_ctl->tme_ieee754_ctl_lock_unlock = tme_float_leave;

  /* assume that this operation raises no exceptions: */
  exceptions = 0;

  /* the operation: */
  tme_ieee754_extended80_value_builtin_set(dst, TME_FLOAT_FORMAT_IEEE754_EXTENDED80_BUILTIN, tme_ieee754_extended80_value_builtin_get(src0) / tme_ieee754_extended80_value_builtin_get(src1));

  /* leave native floating-point operation: */
  exceptions |= tme_float_leave();
  ieee754_ctl->tme_ieee754_ctl_lock_unlock = NULL;

  /* signal any exceptions: */
  if (exceptions != 0) {
    (*ieee754_ctl->tme_ieee754_ctl_exception)(ieee754_ctl, exceptions);
  }
}

#endif /* (TME_FLOAT_FORMAT_IEEE754_EXTENDED80_BUILTIN == TME_FLOAT_FORMAT_IEEE754_EXTENDED80) */

#if (TME_FLOAT_FORMAT_IEEE754_EXTENDED80_BUILTIN == TME_FLOAT_FORMAT_IEEE754_EXTENDED80)

/* this does a partial compliance extended80-precision sqrt: */
static void
_tme_ieee754_partial_extended80_sqrt(struct tme_ieee754_ctl *ieee754_ctl, const struct tme_float *src0, struct tme_float *dst)
{
  int exceptions;

  /* check for a NaN operand: */
  if (__tme_predict_false(tme_ieee754_extended80_check_nan_monadic(ieee754_ctl, src0, dst))) {
    return;
  }

  /* enter native floating-point operation: */
  tme_float_enter(ieee754_ctl->tme_ieee754_ctl_rounding_mode, tme_ieee754_exception_float, ieee754_ctl);
  ieee754_ctl->tme_ieee754_ctl_lock_unlock = tme_float_leave;

  /* assume that this operation raises no exceptions: */
  exceptions = 0;

  /* the operation: */
#if (TME_FLOAT_FORMAT_IEEE754_EXTENDED80_BUILTIN == TME_FLOAT_FORMAT_FLOAT)
  tme_ieee754_extended80_value_builtin_set(dst, TME_FLOAT_FORMAT_FLOAT, sqrtf(tme_ieee754_extended80_value_builtin_get(src0)));
#else  /* (TME_FLOAT_FORMAT_IEEE754_EXTENDED80_BUILTIN != TME_FLOAT_FORMAT_FLOAT) */
  tme_ieee754_extended80_value_builtin_set(dst, TME_FLOAT_FORMAT_DOUBLE, sqrtl(tme_ieee754_extended80_value_builtin_get(src0)));
#endif /* (TME_FLOAT_FORMAT_IEEE754_EXTENDED80_BUILTIN != TME_FLOAT_FORMAT_FLOAT) */

  /* leave native floating-point operation: */
  exceptions |= tme_float_leave();
  ieee754_ctl->tme_ieee754_ctl_lock_unlock = NULL;

  /* signal any exceptions: */
  if (exceptions != 0) {
    (*ieee754_ctl->tme_ieee754_ctl_exception)(ieee754_ctl, exceptions);
  }
}

#endif /* (TME_FLOAT_FORMAT_IEEE754_EXTENDED80_BUILTIN == TME_FLOAT_FORMAT_IEEE754_EXTENDED80) */

#if (TME_FLOAT_FORMAT_IEEE754_EXTENDED80_BUILTIN == TME_FLOAT_FORMAT_IEEE754_EXTENDED80)

/* this does a partial compliance extended80-precision abs: */
static void
_tme_ieee754_partial_extended80_abs(struct tme_ieee754_ctl *ieee754_ctl, const struct tme_float *src0, struct tme_float *dst)
{
  int exceptions;

  /* check for a NaN operand: */
  if (__tme_predict_false(tme_ieee754_extended80_check_nan_monadic(ieee754_ctl, src0, dst))) {
    return;
  }

  /* enter native floating-point operation: */
  tme_float_enter(ieee754_ctl->tme_ieee754_ctl_rounding_mode, tme_ieee754_exception_float, ieee754_ctl);
  ieee754_ctl->tme_ieee754_ctl_lock_unlock = tme_float_leave;

  /* assume that this operation raises no exceptions: */
  exceptions = 0;

  /* the operation: */
#if (TME_FLOAT_FORMAT_IEEE754_EXTENDED80_BUILTIN == TME_FLOAT_FORMAT_FLOAT)
  tme_ieee754_extended80_value_builtin_set(dst, TME_FLOAT_FORMAT_FLOAT, fabsf(tme_ieee754_extended80_value_builtin_get(src0)));
#else  /* (TME_FLOAT_FORMAT_IEEE754_EXTENDED80_BUILTIN != TME_FLOAT_FORMAT_FLOAT) */
  tme_ieee754_extended80_value_builtin_set(dst, TME_FLOAT_FORMAT_DOUBLE, fabsl(tme_ieee754_extended80_value_builtin_get(src0)));
#endif /* (TME_FLOAT_FORMAT_IEEE754_EXTENDED80_BUILTIN != TME_FLOAT_FORMAT_FLOAT) */

  /* leave native floating-point operation: */
  exceptions |= tme_float_leave();
  ieee754_ctl->tme_ieee754_ctl_lock_unlock = NULL;

  /* signal any exceptions: */
  if (exceptions != 0) {
    (*ieee754_ctl->tme_ieee754_ctl_exception)(ieee754_ctl, exceptions);
  }
}

#endif /* (TME_FLOAT_FORMAT_IEEE754_EXTENDED80_BUILTIN == TME_FLOAT_FORMAT_IEEE754_EXTENDED80) */

#if (TME_FLOAT_FORMAT_IEEE754_EXTENDED80_BUILTIN == TME_FLOAT_FORMAT_IEEE754_EXTENDED80)

/* this does a partial compliance extended80-precision neg: */
static void
_tme_ieee754_partial_extended80_neg(struct tme_ieee754_ctl *ieee754_ctl, const struct tme_float *src0, struct tme_float *dst)
{
  int exceptions;

  /* check for a NaN operand: */
  if (__tme_predict_false(tme_ieee754_extended80_check_nan_monadic(ieee754_ctl, src0, dst))) {
    return;
  }

  /* enter native floating-point operation: */
  tme_float_enter(ieee754_ctl->tme_ieee754_ctl_rounding_mode, tme_ieee754_exception_float, ieee754_ctl);
  ieee754_ctl->tme_ieee754_ctl_lock_unlock = tme_float_leave;

  /* assume that this operation raises no exceptions: */
  exceptions = 0;

  /* the operation: */
  tme_ieee754_extended80_value_builtin_set(dst, TME_FLOAT_FORMAT_IEEE754_EXTENDED80_BUILTIN, -1 * tme_ieee754_extended80_value_builtin_get(src0));

  /* leave native floating-point operation: */
  exceptions |= tme_float_leave();
  ieee754_ctl->tme_ieee754_ctl_lock_unlock = NULL;

  /* signal any exceptions: */
  if (exceptions != 0) {
    (*ieee754_ctl->tme_ieee754_ctl_exception)(ieee754_ctl, exceptions);
  }
}

#endif /* (TME_FLOAT_FORMAT_IEEE754_EXTENDED80_BUILTIN == TME_FLOAT_FORMAT_IEEE754_EXTENDED80) */

#if (TME_FLOAT_FORMAT_IEEE754_EXTENDED80_BUILTIN == TME_FLOAT_FORMAT_IEEE754_EXTENDED80)

/* this does a partial compliance extended80-precision move: */
static void
_tme_ieee754_partial_extended80_move(struct tme_ieee754_ctl *ieee754_ctl, const struct tme_float *src0, struct tme_float *dst)
{
  int exceptions;

  /* check for a NaN operand: */
  if (__tme_predict_false(tme_ieee754_extended80_check_nan_monadic(ieee754_ctl, src0, dst))) {
    return;
  }

  /* enter native floating-point operation: */
  tme_float_enter(ieee754_ctl->tme_ieee754_ctl_rounding_mode, tme_ieee754_exception_float, ieee754_ctl);
  ieee754_ctl->tme_ieee754_ctl_lock_unlock = tme_float_leave;

  /* assume that this operation raises no exceptions: */
  exceptions = 0;

  /* the operation: */
  *dst = *src0;

  /* leave native floating-point operation: */
  exceptions |= tme_float_leave();
  ieee754_ctl->tme_ieee754_ctl_lock_unlock = NULL;

  /* signal any exceptions: */
  if (exceptions != 0) {
    (*ieee754_ctl->tme_ieee754_ctl_exception)(ieee754_ctl, exceptions);
  }
}

#endif /* (TME_FLOAT_FORMAT_IEEE754_EXTENDED80_BUILTIN == TME_FLOAT_FORMAT_IEEE754_EXTENDED80) */

#if (TME_FLOAT_FORMAT_IEEE754_EXTENDED80_BUILTIN == TME_FLOAT_FORMAT_IEEE754_EXTENDED80)

/* this does a partial compliance extended80-precision exp: */
static void
_tme_ieee754_partial_extended80_exp(struct tme_ieee754_ctl *ieee754_ctl, const struct tme_float *src0, struct tme_float *dst)
{
  int exceptions;

  /* check for a NaN operand: */
  if (__tme_predict_false(tme_ieee754_extended80_check_nan_monadic(ieee754_ctl, src0, dst))) {
    return;
  }

  /* enter native floating-point operation: */
  tme_float_enter(ieee754_ctl->tme_ieee754_ctl_rounding_mode, tme_ieee754_exception_float, ieee754_ctl);
  ieee754_ctl->tme_ieee754_ctl_lock_unlock = tme_float_leave;

  /* assume that this operation raises no exceptions: */
  exceptions = 0;

  /* the operation: */
#if (TME_FLOAT_FORMAT_IEEE754_EXTENDED80_BUILTIN == TME_FLOAT_FORMAT_FLOAT)
  tme_ieee754_extended80_value_builtin_set(dst, TME_FLOAT_FORMAT_FLOAT, expf(tme_ieee754_extended80_value_builtin_get(src0)));
#else  /* (TME_FLOAT_FORMAT_IEEE754_EXTENDED80_BUILTIN != TME_FLOAT_FORMAT_FLOAT) */
  tme_ieee754_extended80_value_builtin_set(dst, TME_FLOAT_FORMAT_DOUBLE, expl(tme_ieee754_extended80_value_builtin_get(src0)));
#endif /* (TME_FLOAT_FORMAT_IEEE754_EXTENDED80_BUILTIN != TME_FLOAT_FORMAT_FLOAT) */

  /* leave native floating-point operation: */
  exceptions |= tme_float_leave();
  ieee754_ctl->tme_ieee754_ctl_lock_unlock = NULL;

  /* signal any exceptions: */
  if (exceptions != 0) {
    (*ieee754_ctl->tme_ieee754_ctl_exception)(ieee754_ctl, exceptions);
  }
}

#endif /* (TME_FLOAT_FORMAT_IEEE754_EXTENDED80_BUILTIN == TME_FLOAT_FORMAT_IEEE754_EXTENDED80) */

#if (TME_FLOAT_FORMAT_IEEE754_EXTENDED80_BUILTIN == TME_FLOAT_FORMAT_IEEE754_EXTENDED80)

/* this does a partial compliance extended80-precision log10: */
static void
_tme_ieee754_partial_extended80_log10(struct tme_ieee754_ctl *ieee754_ctl, const struct tme_float *src0, struct tme_float *dst)
{
  int exceptions;

  /* check for a NaN operand: */
  if (__tme_predict_false(tme_ieee754_extended80_check_nan_monadic(ieee754_ctl, src0, dst))) {
    return;
  }

  /* enter native floating-point operation: */
  tme_float_enter(ieee754_ctl->tme_ieee754_ctl_rounding_mode, tme_ieee754_exception_float, ieee754_ctl);
  ieee754_ctl->tme_ieee754_ctl_lock_unlock = tme_float_leave;

  /* assume that this operation raises no exceptions: */
  exceptions = 0;

  /* the operation: */
#if (TME_FLOAT_FORMAT_IEEE754_EXTENDED80_BUILTIN == TME_FLOAT_FORMAT_FLOAT)
  tme_ieee754_extended80_value_builtin_set(dst, TME_FLOAT_FORMAT_FLOAT, log10f(tme_ieee754_extended80_value_builtin_get(src0)));
#else  /* (TME_FLOAT_FORMAT_IEEE754_EXTENDED80_BUILTIN != TME_FLOAT_FORMAT_FLOAT) */
  tme_ieee754_extended80_value_builtin_set(dst, TME_FLOAT_FORMAT_DOUBLE, log10l(tme_ieee754_extended80_value_builtin_get(src0)));
#endif /* (TME_FLOAT_FORMAT_IEEE754_EXTENDED80_BUILTIN != TME_FLOAT_FORMAT_FLOAT) */

  /* leave native floating-point operation: */
  exceptions |= tme_float_leave();
  ieee754_ctl->tme_ieee754_ctl_lock_unlock = NULL;

  /* signal any exceptions: */
  if (exceptions != 0) {
    (*ieee754_ctl->tme_ieee754_ctl_exception)(ieee754_ctl, exceptions);
  }
}

#endif /* (TME_FLOAT_FORMAT_IEEE754_EXTENDED80_BUILTIN == TME_FLOAT_FORMAT_IEEE754_EXTENDED80) */

#if (TME_FLOAT_FORMAT_IEEE754_EXTENDED80_BUILTIN == TME_FLOAT_FORMAT_IEEE754_EXTENDED80)

/* this does a partial compliance extended80-precision log: */
static void
_tme_ieee754_partial_extended80_log(struct tme_ieee754_ctl *ieee754_ctl, const struct tme_float *src0, struct tme_float *dst)
{
  int exceptions;

  /* check for a NaN operand: */
  if (__tme_predict_false(tme_ieee754_extended80_check_nan_monadic(ieee754_ctl, src0, dst))) {
    return;
  }

  /* enter native floating-point operation: */
  tme_float_enter(ieee754_ctl->tme_ieee754_ctl_rounding_mode, tme_ieee754_exception_float, ieee754_ctl);
  ieee754_ctl->tme_ieee754_ctl_lock_unlock = tme_float_leave;

  /* assume that this operation raises no exceptions: */
  exceptions = 0;

  /* the operation: */
#if (TME_FLOAT_FORMAT_IEEE754_EXTENDED80_BUILTIN == TME_FLOAT_FORMAT_FLOAT)
  tme_ieee754_extended80_value_builtin_set(dst, TME_FLOAT_FORMAT_FLOAT, logf(tme_ieee754_extended80_value_builtin_get(src0)));
#else  /* (TME_FLOAT_FORMAT_IEEE754_EXTENDED80_BUILTIN != TME_FLOAT_FORMAT_FLOAT) */
  tme_ieee754_extended80_value_builtin_set(dst, TME_FLOAT_FORMAT_DOUBLE, logl(tme_ieee754_extended80_value_builtin_get(src0)));
#endif /* (TME_FLOAT_FORMAT_IEEE754_EXTENDED80_BUILTIN != TME_FLOAT_FORMAT_FLOAT) */

  /* leave native floating-point operation: */
  exceptions |= tme_float_leave();
  ieee754_ctl->tme_ieee754_ctl_lock_unlock = NULL;

  /* signal any exceptions: */
  if (exceptions != 0) {
    (*ieee754_ctl->tme_ieee754_ctl_exception)(ieee754_ctl, exceptions);
  }
}

#endif /* (TME_FLOAT_FORMAT_IEEE754_EXTENDED80_BUILTIN == TME_FLOAT_FORMAT_IEEE754_EXTENDED80) */

#if (TME_FLOAT_FORMAT_IEEE754_EXTENDED80_BUILTIN == TME_FLOAT_FORMAT_IEEE754_EXTENDED80)

/* this does a partial compliance extended80-precision scale: */
static void
_tme_ieee754_partial_extended80_scale(struct tme_ieee754_ctl *ieee754_ctl, const struct tme_float *src0, const struct tme_float *src1, struct tme_float *dst)
{
  int exceptions;

  /* check for a NaN operand: */
  if (__tme_predict_false(tme_ieee754_extended80_check_nan_dyadic(ieee754_ctl, src0, src1, dst))) {
    return;
  }

  /* enter native floating-point operation: */
  tme_float_enter(ieee754_ctl->tme_ieee754_ctl_rounding_mode, tme_ieee754_exception_float, ieee754_ctl);
  ieee754_ctl->tme_ieee754_ctl_lock_unlock = tme_float_leave;

  /* assume that this operation raises no exceptions: */
  exceptions = 0;

  /* the operation: */
#if (TME_FLOAT_FORMAT_IEEE754_EXTENDED80_BUILTIN == TME_FLOAT_FORMAT_FLOAT)
  tme_ieee754_extended80_value_builtin_set(dst, TME_FLOAT_FORMAT_FLOAT, scalbnf(tme_ieee754_extended80_value_builtin_get(src0), tme_ieee754_extended80_value_builtin_get(src1)));
#else  /* (TME_FLOAT_FORMAT_IEEE754_EXTENDED80_BUILTIN != TME_FLOAT_FORMAT_FLOAT) */
  tme_ieee754_extended80_value_builtin_set(dst, TME_FLOAT_FORMAT_DOUBLE, scalbnl(tme_ieee754_extended80_value_builtin_get(src0), tme_ieee754_extended80_value_builtin_get(src1)));
#endif /* (TME_FLOAT_FORMAT_IEEE754_EXTENDED80_BUILTIN != TME_FLOAT_FORMAT_FLOAT) */

  /* leave native floating-point operation: */
  exceptions |= tme_float_leave();
  ieee754_ctl->tme_ieee754_ctl_lock_unlock = NULL;

  /* signal any exceptions: */
  if (exceptions != 0) {
    (*ieee754_ctl->tme_ieee754_ctl_exception)(ieee754_ctl, exceptions);
  }
}

#endif /* (TME_FLOAT_FORMAT_IEEE754_EXTENDED80_BUILTIN == TME_FLOAT_FORMAT_IEEE754_EXTENDED80) */

#if (TME_FLOAT_FORMAT_IEEE754_EXTENDED80_BUILTIN == TME_FLOAT_FORMAT_IEEE754_EXTENDED80)

/* this does a partial compliance extended80-precision pow: */
static void
_tme_ieee754_partial_extended80_pow(struct tme_ieee754_ctl *ieee754_ctl, const struct tme_float *src0, const struct tme_float *src1, struct tme_float *dst)
{
  int exceptions;

  /* check for a NaN operand: */
  if (__tme_predict_false(tme_ieee754_extended80_check_nan_dyadic(ieee754_ctl, src0, src1, dst))) {
    return;
  }

  /* enter native floating-point operation: */
  tme_float_enter(ieee754_ctl->tme_ieee754_ctl_rounding_mode, tme_ieee754_exception_float, ieee754_ctl);
  ieee754_ctl->tme_ieee754_ctl_lock_unlock = tme_float_leave;

  /* assume that this operation raises no exceptions: */
  exceptions = 0;

  /* the operation: */
#if (TME_FLOAT_FORMAT_IEEE754_EXTENDED80_BUILTIN == TME_FLOAT_FORMAT_FLOAT)
  tme_ieee754_extended80_value_builtin_set(dst, TME_FLOAT_FORMAT_FLOAT, powf(tme_ieee754_extended80_value_builtin_get(src0), tme_ieee754_extended80_value_builtin_get(src1)));
#else  /* (TME_FLOAT_FORMAT_IEEE754_EXTENDED80_BUILTIN != TME_FLOAT_FORMAT_FLOAT) */
  tme_ieee754_extended80_value_builtin_set(dst, TME_FLOAT_FORMAT_DOUBLE, powl(tme_ieee754_extended80_value_builtin_get(src0), tme_ieee754_extended80_value_builtin_get(src1)));
#endif /* (TME_FLOAT_FORMAT_IEEE754_EXTENDED80_BUILTIN != TME_FLOAT_FORMAT_FLOAT) */

  /* leave native floating-point operation: */
  exceptions |= tme_float_leave();
  ieee754_ctl->tme_ieee754_ctl_lock_unlock = NULL;

  /* signal any exceptions: */
  if (exceptions != 0) {
    (*ieee754_ctl->tme_ieee754_ctl_exception)(ieee754_ctl, exceptions);
  }
}

#endif /* (TME_FLOAT_FORMAT_IEEE754_EXTENDED80_BUILTIN == TME_FLOAT_FORMAT_IEEE754_EXTENDED80) */

#if (TME_FLOAT_FORMAT_IEEE754_QUAD_BUILTIN == TME_FLOAT_FORMAT_IEEE754_QUAD)

/* this does a partial compliance quad-precision add: */
static void
_tme_ieee754_partial_quad_add(struct tme_ieee754_ctl *ieee754_ctl, const struct tme_float *src0, const struct tme_float *src1, struct tme_float *dst)
{
  int exceptions;

  /* check for a NaN operand: */
  if (__tme_predict_false(tme_ieee754_quad_check_nan_dyadic(ieee754_ctl, src0, src1, dst))) {
    return;
  }

  /* enter native floating-point operation: */
  tme_float_enter(ieee754_ctl->tme_ieee754_ctl_rounding_mode, tme_ieee754_exception_float, ieee754_ctl);
  ieee754_ctl->tme_ieee754_ctl_lock_unlock = tme_float_leave;

  /* assume that this operation raises no exceptions: */
  exceptions = 0;

  /* the operation: */
  tme_ieee754_quad_value_builtin_set(dst, TME_FLOAT_FORMAT_IEEE754_QUAD_BUILTIN, tme_ieee754_quad_value_builtin_get(src0) + tme_ieee754_quad_value_builtin_get(src1));

  /* leave native floating-point operation: */
  exceptions |= tme_float_leave();
  ieee754_ctl->tme_ieee754_ctl_lock_unlock = NULL;

  /* signal any exceptions: */
  if (exceptions != 0) {
    (*ieee754_ctl->tme_ieee754_ctl_exception)(ieee754_ctl, exceptions);
  }
}

#endif /* (TME_FLOAT_FORMAT_IEEE754_QUAD_BUILTIN == TME_FLOAT_FORMAT_IEEE754_QUAD) */

#if (TME_FLOAT_FORMAT_IEEE754_QUAD_BUILTIN == TME_FLOAT_FORMAT_IEEE754_QUAD)

/* this does a partial compliance quad-precision sub: */
static void
_tme_ieee754_partial_quad_sub(struct tme_ieee754_ctl *ieee754_ctl, const struct tme_float *src0, const struct tme_float *src1, struct tme_float *dst)
{
  int exceptions;

  /* check for a NaN operand: */
  if (__tme_predict_false(tme_ieee754_quad_check_nan_dyadic(ieee754_ctl, src0, src1, dst))) {
    return;
  }

  /* enter native floating-point operation: */
  tme_float_enter(ieee754_ctl->tme_ieee754_ctl_rounding_mode, tme_ieee754_exception_float, ieee754_ctl);
  ieee754_ctl->tme_ieee754_ctl_lock_unlock = tme_float_leave;

  /* assume that this operation raises no exceptions: */
  exceptions = 0;

  /* the operation: */
  tme_ieee754_quad_value_builtin_set(dst, TME_FLOAT_FORMAT_IEEE754_QUAD_BUILTIN, tme_ieee754_quad_value_builtin_get(src0) - tme_ieee754_quad_value_builtin_get(src1));

  /* leave native floating-point operation: */
  exceptions |= tme_float_leave();
  ieee754_ctl->tme_ieee754_ctl_lock_unlock = NULL;

  /* signal any exceptions: */
  if (exceptions != 0) {
    (*ieee754_ctl->tme_ieee754_ctl_exception)(ieee754_ctl, exceptions);
  }
}

#endif /* (TME_FLOAT_FORMAT_IEEE754_QUAD_BUILTIN == TME_FLOAT_FORMAT_IEEE754_QUAD) */

#if (TME_FLOAT_FORMAT_IEEE754_QUAD_BUILTIN == TME_FLOAT_FORMAT_IEEE754_QUAD)

/* this does a partial compliance quad-precision mul: */
static void
_tme_ieee754_partial_quad_mul(struct tme_ieee754_ctl *ieee754_ctl, const struct tme_float *src0, const struct tme_float *src1, struct tme_float *dst)
{
  int exceptions;

  /* check for a NaN operand: */
  if (__tme_predict_false(tme_ieee754_quad_check_nan_dyadic(ieee754_ctl, src0, src1, dst))) {
    return;
  }

  /* enter native floating-point operation: */
  tme_float_enter(ieee754_ctl->tme_ieee754_ctl_rounding_mode, tme_ieee754_exception_float, ieee754_ctl);
  ieee754_ctl->tme_ieee754_ctl_lock_unlock = tme_float_leave;

  /* assume that this operation raises no exceptions: */
  exceptions = 0;

  /* the operation: */
  tme_ieee754_quad_value_builtin_set(dst, TME_FLOAT_FORMAT_IEEE754_QUAD_BUILTIN, tme_ieee754_quad_value_builtin_get(src0) * tme_ieee754_quad_value_builtin_get(src1));

  /* leave native floating-point operation: */
  exceptions |= tme_float_leave();
  ieee754_ctl->tme_ieee754_ctl_lock_unlock = NULL;

  /* signal any exceptions: */
  if (exceptions != 0) {
    (*ieee754_ctl->tme_ieee754_ctl_exception)(ieee754_ctl, exceptions);
  }
}

#endif /* (TME_FLOAT_FORMAT_IEEE754_QUAD_BUILTIN == TME_FLOAT_FORMAT_IEEE754_QUAD) */

#if (TME_FLOAT_FORMAT_IEEE754_QUAD_BUILTIN == TME_FLOAT_FORMAT_IEEE754_QUAD)

/* this does a partial compliance quad-precision div: */
static void
_tme_ieee754_partial_quad_div(struct tme_ieee754_ctl *ieee754_ctl, const struct tme_float *src0, const struct tme_float *src1, struct tme_float *dst)
{
  int exceptions;

  /* check for a NaN operand: */
  if (__tme_predict_false(tme_ieee754_quad_check_nan_dyadic(ieee754_ctl, src0, src1, dst))) {
    return;
  }

  /* enter native floating-point operation: */
  tme_float_enter(ieee754_ctl->tme_ieee754_ctl_rounding_mode, tme_ieee754_exception_float, ieee754_ctl);
  ieee754_ctl->tme_ieee754_ctl_lock_unlock = tme_float_leave;

  /* assume that this operation raises no exceptions: */
  exceptions = 0;

  /* the operation: */
  tme_ieee754_quad_value_builtin_set(dst, TME_FLOAT_FORMAT_IEEE754_QUAD_BUILTIN, tme_ieee754_quad_value_builtin_get(src0) / tme_ieee754_quad_value_builtin_get(src1));

  /* leave native floating-point operation: */
  exceptions |= tme_float_leave();
  ieee754_ctl->tme_ieee754_ctl_lock_unlock = NULL;

  /* signal any exceptions: */
  if (exceptions != 0) {
    (*ieee754_ctl->tme_ieee754_ctl_exception)(ieee754_ctl, exceptions);
  }
}

#endif /* (TME_FLOAT_FORMAT_IEEE754_QUAD_BUILTIN == TME_FLOAT_FORMAT_IEEE754_QUAD) */

#if (TME_FLOAT_FORMAT_IEEE754_QUAD_BUILTIN == TME_FLOAT_FORMAT_IEEE754_QUAD)

/* this does a partial compliance quad-precision sqrt: */
static void
_tme_ieee754_partial_quad_sqrt(struct tme_ieee754_ctl *ieee754_ctl, const struct tme_float *src0, struct tme_float *dst)
{
  int exceptions;

  /* check for a NaN operand: */
  if (__tme_predict_false(tme_ieee754_quad_check_nan_monadic(ieee754_ctl, src0, dst))) {
    return;
  }

  /* enter native floating-point operation: */
  tme_float_enter(ieee754_ctl->tme_ieee754_ctl_rounding_mode, tme_ieee754_exception_float, ieee754_ctl);
  ieee754_ctl->tme_ieee754_ctl_lock_unlock = tme_float_leave;

  /* assume that this operation raises no exceptions: */
  exceptions = 0;

  /* the operation: */
#if (TME_FLOAT_FORMAT_IEEE754_QUAD_BUILTIN == TME_FLOAT_FORMAT_FLOAT)
  tme_ieee754_quad_value_builtin_set(dst, TME_FLOAT_FORMAT_FLOAT, sqrtf(tme_ieee754_quad_value_builtin_get(src0)));
#else  /* (TME_FLOAT_FORMAT_IEEE754_QUAD_BUILTIN != TME_FLOAT_FORMAT_FLOAT) */
  tme_ieee754_quad_value_builtin_set(dst, TME_FLOAT_FORMAT_DOUBLE, sqrtl(tme_ieee754_quad_value_builtin_get(src0)));
#endif /* (TME_FLOAT_FORMAT_IEEE754_QUAD_BUILTIN != TME_FLOAT_FORMAT_FLOAT) */

  /* leave native floating-point operation: */
  exceptions |= tme_float_leave();
  ieee754_ctl->tme_ieee754_ctl_lock_unlock = NULL;

  /* signal any exceptions: */
  if (exceptions != 0) {
    (*ieee754_ctl->tme_ieee754_ctl_exception)(ieee754_ctl, exceptions);
  }
}

#endif /* (TME_FLOAT_FORMAT_IEEE754_QUAD_BUILTIN == TME_FLOAT_FORMAT_IEEE754_QUAD) */

#if (TME_FLOAT_FORMAT_IEEE754_QUAD_BUILTIN == TME_FLOAT_FORMAT_IEEE754_QUAD)

/* this does a partial compliance quad-precision abs: */
static void
_tme_ieee754_partial_quad_abs(struct tme_ieee754_ctl *ieee754_ctl, const struct tme_float *src0, struct tme_float *dst)
{
  int exceptions;

  /* check for a NaN operand: */
  if (__tme_predict_false(tme_ieee754_quad_check_nan_monadic(ieee754_ctl, src0, dst))) {
    return;
  }

  /* enter native floating-point operation: */
  tme_float_enter(ieee754_ctl->tme_ieee754_ctl_rounding_mode, tme_ieee754_exception_float, ieee754_ctl);
  ieee754_ctl->tme_ieee754_ctl_lock_unlock = tme_float_leave;

  /* assume that this operation raises no exceptions: */
  exceptions = 0;

  /* the operation: */
#if (TME_FLOAT_FORMAT_IEEE754_QUAD_BUILTIN == TME_FLOAT_FORMAT_FLOAT)
  tme_ieee754_quad_value_builtin_set(dst, TME_FLOAT_FORMAT_FLOAT, fabsf(tme_ieee754_quad_value_builtin_get(src0)));
#else  /* (TME_FLOAT_FORMAT_IEEE754_QUAD_BUILTIN != TME_FLOAT_FORMAT_FLOAT) */
  tme_ieee754_quad_value_builtin_set(dst, TME_FLOAT_FORMAT_DOUBLE, fabsl(tme_ieee754_quad_value_builtin_get(src0)));
#endif /* (TME_FLOAT_FORMAT_IEEE754_QUAD_BUILTIN != TME_FLOAT_FORMAT_FLOAT) */

  /* leave native floating-point operation: */
  exceptions |= tme_float_leave();
  ieee754_ctl->tme_ieee754_ctl_lock_unlock = NULL;

  /* signal any exceptions: */
  if (exceptions != 0) {
    (*ieee754_ctl->tme_ieee754_ctl_exception)(ieee754_ctl, exceptions);
  }
}

#endif /* (TME_FLOAT_FORMAT_IEEE754_QUAD_BUILTIN == TME_FLOAT_FORMAT_IEEE754_QUAD) */

#if (TME_FLOAT_FORMAT_IEEE754_QUAD_BUILTIN == TME_FLOAT_FORMAT_IEEE754_QUAD)

/* this does a partial compliance quad-precision neg: */
static void
_tme_ieee754_partial_quad_neg(struct tme_ieee754_ctl *ieee754_ctl, const struct tme_float *src0, struct tme_float *dst)
{
  int exceptions;

  /* check for a NaN operand: */
  if (__tme_predict_false(tme_ieee754_quad_check_nan_monadic(ieee754_ctl, src0, dst))) {
    return;
  }

  /* enter native floating-point operation: */
  tme_float_enter(ieee754_ctl->tme_ieee754_ctl_rounding_mode, tme_ieee754_exception_float, ieee754_ctl);
  ieee754_ctl->tme_ieee754_ctl_lock_unlock = tme_float_leave;

  /* assume that this operation raises no exceptions: */
  exceptions = 0;

  /* the operation: */
  tme_ieee754_quad_value_builtin_set(dst, TME_FLOAT_FORMAT_IEEE754_QUAD_BUILTIN, -1 * tme_ieee754_quad_value_builtin_get(src0));

  /* leave native floating-point operation: */
  exceptions |= tme_float_leave();
  ieee754_ctl->tme_ieee754_ctl_lock_unlock = NULL;

  /* signal any exceptions: */
  if (exceptions != 0) {
    (*ieee754_ctl->tme_ieee754_ctl_exception)(ieee754_ctl, exceptions);
  }
}

#endif /* (TME_FLOAT_FORMAT_IEEE754_QUAD_BUILTIN == TME_FLOAT_FORMAT_IEEE754_QUAD) */

#if (TME_FLOAT_FORMAT_IEEE754_QUAD_BUILTIN == TME_FLOAT_FORMAT_IEEE754_QUAD)

/* this does a partial compliance quad-precision move: */
static void
_tme_ieee754_partial_quad_move(struct tme_ieee754_ctl *ieee754_ctl, const struct tme_float *src0, struct tme_float *dst)
{
  int exceptions;

  /* check for a NaN operand: */
  if (__tme_predict_false(tme_ieee754_quad_check_nan_monadic(ieee754_ctl, src0, dst))) {
    return;
  }

  /* enter native floating-point operation: */
  tme_float_enter(ieee754_ctl->tme_ieee754_ctl_rounding_mode, tme_ieee754_exception_float, ieee754_ctl);
  ieee754_ctl->tme_ieee754_ctl_lock_unlock = tme_float_leave;

  /* assume that this operation raises no exceptions: */
  exceptions = 0;

  /* the operation: */
  *dst = *src0;

  /* leave native floating-point operation: */
  exceptions |= tme_float_leave();
  ieee754_ctl->tme_ieee754_ctl_lock_unlock = NULL;

  /* signal any exceptions: */
  if (exceptions != 0) {
    (*ieee754_ctl->tme_ieee754_ctl_exception)(ieee754_ctl, exceptions);
  }
}

#endif /* (TME_FLOAT_FORMAT_IEEE754_QUAD_BUILTIN == TME_FLOAT_FORMAT_IEEE754_QUAD) */

#if (TME_FLOAT_FORMAT_IEEE754_QUAD_BUILTIN == TME_FLOAT_FORMAT_IEEE754_QUAD)

/* this does a partial compliance quad-precision exp: */
static void
_tme_ieee754_partial_quad_exp(struct tme_ieee754_ctl *ieee754_ctl, const struct tme_float *src0, struct tme_float *dst)
{
  int exceptions;

  /* check for a NaN operand: */
  if (__tme_predict_false(tme_ieee754_quad_check_nan_monadic(ieee754_ctl, src0, dst))) {
    return;
  }

  /* enter native floating-point operation: */
  tme_float_enter(ieee754_ctl->tme_ieee754_ctl_rounding_mode, tme_ieee754_exception_float, ieee754_ctl);
  ieee754_ctl->tme_ieee754_ctl_lock_unlock = tme_float_leave;

  /* assume that this operation raises no exceptions: */
  exceptions = 0;

  /* the operation: */
#if (TME_FLOAT_FORMAT_IEEE754_QUAD_BUILTIN == TME_FLOAT_FORMAT_FLOAT)
  tme_ieee754_quad_value_builtin_set(dst, TME_FLOAT_FORMAT_FLOAT, expf(tme_ieee754_quad_value_builtin_get(src0)));
#else  /* (TME_FLOAT_FORMAT_IEEE754_QUAD_BUILTIN != TME_FLOAT_FORMAT_FLOAT) */
  tme_ieee754_quad_value_builtin_set(dst, TME_FLOAT_FORMAT_DOUBLE, expl(tme_ieee754_quad_value_builtin_get(src0)));
#endif /* (TME_FLOAT_FORMAT_IEEE754_QUAD_BUILTIN != TME_FLOAT_FORMAT_FLOAT) */

  /* leave native floating-point operation: */
  exceptions |= tme_float_leave();
  ieee754_ctl->tme_ieee754_ctl_lock_unlock = NULL;

  /* signal any exceptions: */
  if (exceptions != 0) {
    (*ieee754_ctl->tme_ieee754_ctl_exception)(ieee754_ctl, exceptions);
  }
}

#endif /* (TME_FLOAT_FORMAT_IEEE754_QUAD_BUILTIN == TME_FLOAT_FORMAT_IEEE754_QUAD) */

#if (TME_FLOAT_FORMAT_IEEE754_QUAD_BUILTIN == TME_FLOAT_FORMAT_IEEE754_QUAD)

/* this does a partial compliance quad-precision log10: */
static void
_tme_ieee754_partial_quad_log10(struct tme_ieee754_ctl *ieee754_ctl, const struct tme_float *src0, struct tme_float *dst)
{
  int exceptions;

  /* check for a NaN operand: */
  if (__tme_predict_false(tme_ieee754_quad_check_nan_monadic(ieee754_ctl, src0, dst))) {
    return;
  }

  /* enter native floating-point operation: */
  tme_float_enter(ieee754_ctl->tme_ieee754_ctl_rounding_mode, tme_ieee754_exception_float, ieee754_ctl);
  ieee754_ctl->tme_ieee754_ctl_lock_unlock = tme_float_leave;

  /* assume that this operation raises no exceptions: */
  exceptions = 0;

  /* the operation: */
#if (TME_FLOAT_FORMAT_IEEE754_QUAD_BUILTIN == TME_FLOAT_FORMAT_FLOAT)
  tme_ieee754_quad_value_builtin_set(dst, TME_FLOAT_FORMAT_FLOAT, log10f(tme_ieee754_quad_value_builtin_get(src0)));
#else  /* (TME_FLOAT_FORMAT_IEEE754_QUAD_BUILTIN != TME_FLOAT_FORMAT_FLOAT) */
  tme_ieee754_quad_value_builtin_set(dst, TME_FLOAT_FORMAT_DOUBLE, log10l(tme_ieee754_quad_value_builtin_get(src0)));
#endif /* (TME_FLOAT_FORMAT_IEEE754_QUAD_BUILTIN != TME_FLOAT_FORMAT_FLOAT) */

  /* leave native floating-point operation: */
  exceptions |= tme_float_leave();
  ieee754_ctl->tme_ieee754_ctl_lock_unlock = NULL;

  /* signal any exceptions: */
  if (exceptions != 0) {
    (*ieee754_ctl->tme_ieee754_ctl_exception)(ieee754_ctl, exceptions);
  }
}

#endif /* (TME_FLOAT_FORMAT_IEEE754_QUAD_BUILTIN == TME_FLOAT_FORMAT_IEEE754_QUAD) */

#if (TME_FLOAT_FORMAT_IEEE754_QUAD_BUILTIN == TME_FLOAT_FORMAT_IEEE754_QUAD)

/* this does a partial compliance quad-precision log: */
static void
_tme_ieee754_partial_quad_log(struct tme_ieee754_ctl *ieee754_ctl, const struct tme_float *src0, struct tme_float *dst)
{
  int exceptions;

  /* check for a NaN operand: */
  if (__tme_predict_false(tme_ieee754_quad_check_nan_monadic(ieee754_ctl, src0, dst))) {
    return;
  }

  /* enter native floating-point operation: */
  tme_float_enter(ieee754_ctl->tme_ieee754_ctl_rounding_mode, tme_ieee754_exception_float, ieee754_ctl);
  ieee754_ctl->tme_ieee754_ctl_lock_unlock = tme_float_leave;

  /* assume that this operation raises no exceptions: */
  exceptions = 0;

  /* the operation: */
#if (TME_FLOAT_FORMAT_IEEE754_QUAD_BUILTIN == TME_FLOAT_FORMAT_FLOAT)
  tme_ieee754_quad_value_builtin_set(dst, TME_FLOAT_FORMAT_FLOAT, logf(tme_ieee754_quad_value_builtin_get(src0)));
#else  /* (TME_FLOAT_FORMAT_IEEE754_QUAD_BUILTIN != TME_FLOAT_FORMAT_FLOAT) */
  tme_ieee754_quad_value_builtin_set(dst, TME_FLOAT_FORMAT_DOUBLE, logl(tme_ieee754_quad_value_builtin_get(src0)));
#endif /* (TME_FLOAT_FORMAT_IEEE754_QUAD_BUILTIN != TME_FLOAT_FORMAT_FLOAT) */

  /* leave native floating-point operation: */
  exceptions |= tme_float_leave();
  ieee754_ctl->tme_ieee754_ctl_lock_unlock = NULL;

  /* signal any exceptions: */
  if (exceptions != 0) {
    (*ieee754_ctl->tme_ieee754_ctl_exception)(ieee754_ctl, exceptions);
  }
}

#endif /* (TME_FLOAT_FORMAT_IEEE754_QUAD_BUILTIN == TME_FLOAT_FORMAT_IEEE754_QUAD) */

#if (TME_FLOAT_FORMAT_IEEE754_QUAD_BUILTIN == TME_FLOAT_FORMAT_IEEE754_QUAD)

/* this does a partial compliance quad-precision scale: */
static void
_tme_ieee754_partial_quad_scale(struct tme_ieee754_ctl *ieee754_ctl, const struct tme_float *src0, const struct tme_float *src1, struct tme_float *dst)
{
  int exceptions;

  /* check for a NaN operand: */
  if (__tme_predict_false(tme_ieee754_quad_check_nan_dyadic(ieee754_ctl, src0, src1, dst))) {
    return;
  }

  /* enter native floating-point operation: */
  tme_float_enter(ieee754_ctl->tme_ieee754_ctl_rounding_mode, tme_ieee754_exception_float, ieee754_ctl);
  ieee754_ctl->tme_ieee754_ctl_lock_unlock = tme_float_leave;

  /* assume that this operation raises no exceptions: */
  exceptions = 0;

  /* the operation: */
#if (TME_FLOAT_FORMAT_IEEE754_QUAD_BUILTIN == TME_FLOAT_FORMAT_FLOAT)
  tme_ieee754_quad_value_builtin_set(dst, TME_FLOAT_FORMAT_FLOAT, scalbnf(tme_ieee754_quad_value_builtin_get(src0), tme_ieee754_quad_value_builtin_get(src1)));
#else  /* (TME_FLOAT_FORMAT_IEEE754_QUAD_BUILTIN != TME_FLOAT_FORMAT_FLOAT) */
  tme_ieee754_quad_value_builtin_set(dst, TME_FLOAT_FORMAT_DOUBLE, scalbnl(tme_ieee754_quad_value_builtin_get(src0), tme_ieee754_quad_value_builtin_get(src1)));
#endif /* (TME_FLOAT_FORMAT_IEEE754_QUAD_BUILTIN != TME_FLOAT_FORMAT_FLOAT) */

  /* leave native floating-point operation: */
  exceptions |= tme_float_leave();
  ieee754_ctl->tme_ieee754_ctl_lock_unlock = NULL;

  /* signal any exceptions: */
  if (exceptions != 0) {
    (*ieee754_ctl->tme_ieee754_ctl_exception)(ieee754_ctl, exceptions);
  }
}

#endif /* (TME_FLOAT_FORMAT_IEEE754_QUAD_BUILTIN == TME_FLOAT_FORMAT_IEEE754_QUAD) */

#if (TME_FLOAT_FORMAT_IEEE754_QUAD_BUILTIN == TME_FLOAT_FORMAT_IEEE754_QUAD)

/* this does a partial compliance quad-precision pow: */
static void
_tme_ieee754_partial_quad_pow(struct tme_ieee754_ctl *ieee754_ctl, const struct tme_float *src0, const struct tme_float *src1, struct tme_float *dst)
{
  int exceptions;

  /* check for a NaN operand: */
  if (__tme_predict_false(tme_ieee754_quad_check_nan_dyadic(ieee754_ctl, src0, src1, dst))) {
    return;
  }

  /* enter native floating-point operation: */
  tme_float_enter(ieee754_ctl->tme_ieee754_ctl_rounding_mode, tme_ieee754_exception_float, ieee754_ctl);
  ieee754_ctl->tme_ieee754_ctl_lock_unlock = tme_float_leave;

  /* assume that this operation raises no exceptions: */
  exceptions = 0;

  /* the operation: */
#if (TME_FLOAT_FORMAT_IEEE754_QUAD_BUILTIN == TME_FLOAT_FORMAT_FLOAT)
  tme_ieee754_quad_value_builtin_set(dst, TME_FLOAT_FORMAT_FLOAT, powf(tme_ieee754_quad_value_builtin_get(src0), tme_ieee754_quad_value_builtin_get(src1)));
#else  /* (TME_FLOAT_FORMAT_IEEE754_QUAD_BUILTIN != TME_FLOAT_FORMAT_FLOAT) */
  tme_ieee754_quad_value_builtin_set(dst, TME_FLOAT_FORMAT_DOUBLE, powl(tme_ieee754_quad_value_builtin_get(src0), tme_ieee754_quad_value_builtin_get(src1)));
#endif /* (TME_FLOAT_FORMAT_IEEE754_QUAD_BUILTIN != TME_FLOAT_FORMAT_FLOAT) */

  /* leave native floating-point operation: */
  exceptions |= tme_float_leave();
  ieee754_ctl->tme_ieee754_ctl_lock_unlock = NULL;

  /* signal any exceptions: */
  if (exceptions != 0) {
    (*ieee754_ctl->tme_ieee754_ctl_exception)(ieee754_ctl, exceptions);
  }
}

#endif /* (TME_FLOAT_FORMAT_IEEE754_QUAD_BUILTIN == TME_FLOAT_FORMAT_IEEE754_QUAD) */

/* the partial compliance operations: */
_tme_const struct tme_ieee754_ops tme_ieee754_ops_partial = {

  /* the version of this structure: */
  TME_X_VERSION(0, 0),

  /* this does a partial compliance single-precision add: */
#if ((TME_FLOAT_FORMAT_IEEE754_SINGLE_BUILTIN == TME_FLOAT_FORMAT_IEEE754_SINGLE))
  _tme_ieee754_partial_single_add,
#else  /* !((TME_FLOAT_FORMAT_IEEE754_SINGLE_BUILTIN == TME_FLOAT_FORMAT_IEEE754_SINGLE)) */
  _tme_ieee754_strict_single_add,
#endif /* !((TME_FLOAT_FORMAT_IEEE754_SINGLE_BUILTIN == TME_FLOAT_FORMAT_IEEE754_SINGLE)) */

  /* this does a partial compliance single-precision sub: */
#if ((TME_FLOAT_FORMAT_IEEE754_SINGLE_BUILTIN == TME_FLOAT_FORMAT_IEEE754_SINGLE))
  _tme_ieee754_partial_single_sub,
#else  /* !((TME_FLOAT_FORMAT_IEEE754_SINGLE_BUILTIN == TME_FLOAT_FORMAT_IEEE754_SINGLE)) */
  _tme_ieee754_strict_single_sub,
#endif /* !((TME_FLOAT_FORMAT_IEEE754_SINGLE_BUILTIN == TME_FLOAT_FORMAT_IEEE754_SINGLE)) */

  /* this does a partial compliance single-precision mul: */
#if ((TME_FLOAT_FORMAT_IEEE754_SINGLE_BUILTIN == TME_FLOAT_FORMAT_IEEE754_SINGLE))
  _tme_ieee754_partial_single_mul,
#else  /* !((TME_FLOAT_FORMAT_IEEE754_SINGLE_BUILTIN == TME_FLOAT_FORMAT_IEEE754_SINGLE)) */
  _tme_ieee754_strict_single_mul,
#endif /* !((TME_FLOAT_FORMAT_IEEE754_SINGLE_BUILTIN == TME_FLOAT_FORMAT_IEEE754_SINGLE)) */

  /* this does a partial compliance single-precision div: */
#if ((TME_FLOAT_FORMAT_IEEE754_SINGLE_BUILTIN == TME_FLOAT_FORMAT_IEEE754_SINGLE))
  _tme_ieee754_partial_single_div,
#else  /* !((TME_FLOAT_FORMAT_IEEE754_SINGLE_BUILTIN == TME_FLOAT_FORMAT_IEEE754_SINGLE)) */
  _tme_ieee754_strict_single_div,
#endif /* !((TME_FLOAT_FORMAT_IEEE754_SINGLE_BUILTIN == TME_FLOAT_FORMAT_IEEE754_SINGLE)) */

  /* this does a partial compliance single-precision rem: */
  _tme_ieee754_strict_single_rem,

  /* this does a partial compliance single-precision sqrt: */
#if ((TME_FLOAT_FORMAT_IEEE754_SINGLE_BUILTIN == TME_FLOAT_FORMAT_IEEE754_SINGLE))
  _tme_ieee754_partial_single_sqrt,
#else  /* !((TME_FLOAT_FORMAT_IEEE754_SINGLE_BUILTIN == TME_FLOAT_FORMAT_IEEE754_SINGLE)) */
  _tme_ieee754_strict_single_sqrt,
#endif /* !((TME_FLOAT_FORMAT_IEEE754_SINGLE_BUILTIN == TME_FLOAT_FORMAT_IEEE754_SINGLE)) */

  /* this does a partial compliance single-precision abs: */
#if ((TME_FLOAT_FORMAT_IEEE754_SINGLE_BUILTIN == TME_FLOAT_FORMAT_IEEE754_SINGLE))
  _tme_ieee754_partial_single_abs,
#else  /* !((TME_FLOAT_FORMAT_IEEE754_SINGLE_BUILTIN == TME_FLOAT_FORMAT_IEEE754_SINGLE)) */
  NULL,
#endif /* !((TME_FLOAT_FORMAT_IEEE754_SINGLE_BUILTIN == TME_FLOAT_FORMAT_IEEE754_SINGLE)) */

  /* this does a partial compliance single-precision neg: */
#if ((TME_FLOAT_FORMAT_IEEE754_SINGLE_BUILTIN == TME_FLOAT_FORMAT_IEEE754_SINGLE))
  _tme_ieee754_partial_single_neg,
#else  /* !((TME_FLOAT_FORMAT_IEEE754_SINGLE_BUILTIN == TME_FLOAT_FORMAT_IEEE754_SINGLE)) */
  _tme_ieee754_strict_single_neg,
#endif /* !((TME_FLOAT_FORMAT_IEEE754_SINGLE_BUILTIN == TME_FLOAT_FORMAT_IEEE754_SINGLE)) */

  /* this does a partial compliance single-precision move: */
#if ((TME_FLOAT_FORMAT_IEEE754_SINGLE_BUILTIN == TME_FLOAT_FORMAT_IEEE754_SINGLE))
  _tme_ieee754_partial_single_move,
#else  /* !((TME_FLOAT_FORMAT_IEEE754_SINGLE_BUILTIN == TME_FLOAT_FORMAT_IEEE754_SINGLE)) */
  _tme_ieee754_strict_single_move,
#endif /* !((TME_FLOAT_FORMAT_IEEE754_SINGLE_BUILTIN == TME_FLOAT_FORMAT_IEEE754_SINGLE)) */

  /* this does a partial compliance single-precision rint: */
  _tme_ieee754_strict_single_rint,

  /* this does a partial compliance single-precision cos: */
  NULL,

  /* this does a partial compliance single-precision acos: */
  NULL,

  /* this does a partial compliance single-precision cosh: */
  NULL,

  /* this does a partial compliance single-precision sin: */
  NULL,

  /* this does a partial compliance single-precision asin: */
  NULL,

  /* this does a partial compliance single-precision sinh: */
  NULL,

  /* this does a partial compliance single-precision tan: */
  NULL,

  /* this does a partial compliance single-precision atan: */
  NULL,

  /* this does a partial compliance single-precision tanh: */
  NULL,

  /* this does a partial compliance single-precision atanh: */
  NULL,

  /* this does a partial compliance single-precision exp: */
#if ((TME_FLOAT_FORMAT_IEEE754_SINGLE_BUILTIN == TME_FLOAT_FORMAT_IEEE754_SINGLE))
  _tme_ieee754_partial_single_exp,
#else  /* !((TME_FLOAT_FORMAT_IEEE754_SINGLE_BUILTIN == TME_FLOAT_FORMAT_IEEE754_SINGLE)) */
  NULL,
#endif /* !((TME_FLOAT_FORMAT_IEEE754_SINGLE_BUILTIN == TME_FLOAT_FORMAT_IEEE754_SINGLE)) */

  /* this does a partial compliance single-precision expm1: */
  NULL,

  /* this does a partial compliance single-precision log10: */
#if ((TME_FLOAT_FORMAT_IEEE754_SINGLE_BUILTIN == TME_FLOAT_FORMAT_IEEE754_SINGLE))
  _tme_ieee754_partial_single_log10,
#else  /* !((TME_FLOAT_FORMAT_IEEE754_SINGLE_BUILTIN == TME_FLOAT_FORMAT_IEEE754_SINGLE)) */
  NULL,
#endif /* !((TME_FLOAT_FORMAT_IEEE754_SINGLE_BUILTIN == TME_FLOAT_FORMAT_IEEE754_SINGLE)) */

  /* this does a partial compliance single-precision log: */
#if ((TME_FLOAT_FORMAT_IEEE754_SINGLE_BUILTIN == TME_FLOAT_FORMAT_IEEE754_SINGLE))
  _tme_ieee754_partial_single_log,
#else  /* !((TME_FLOAT_FORMAT_IEEE754_SINGLE_BUILTIN == TME_FLOAT_FORMAT_IEEE754_SINGLE)) */
  NULL,
#endif /* !((TME_FLOAT_FORMAT_IEEE754_SINGLE_BUILTIN == TME_FLOAT_FORMAT_IEEE754_SINGLE)) */

  /* this does a partial compliance single-precision log1p: */
  NULL,

  /* this does a partial compliance single-precision getexp: */
  _tme_ieee754_strict_single_getexp,

  /* this does a partial compliance single-precision getman: */
  _tme_ieee754_strict_single_getman,

  /* this does a partial compliance single-precision scale: */
#if ((TME_FLOAT_FORMAT_IEEE754_SINGLE_BUILTIN == TME_FLOAT_FORMAT_IEEE754_SINGLE))
  _tme_ieee754_partial_single_scale,
#else  /* !((TME_FLOAT_FORMAT_IEEE754_SINGLE_BUILTIN == TME_FLOAT_FORMAT_IEEE754_SINGLE)) */
  NULL,
#endif /* !((TME_FLOAT_FORMAT_IEEE754_SINGLE_BUILTIN == TME_FLOAT_FORMAT_IEEE754_SINGLE)) */

  /* this does a partial compliance single-precision pow: */
#if ((TME_FLOAT_FORMAT_IEEE754_SINGLE_BUILTIN == TME_FLOAT_FORMAT_IEEE754_SINGLE))
  _tme_ieee754_partial_single_pow,
#else  /* !((TME_FLOAT_FORMAT_IEEE754_SINGLE_BUILTIN == TME_FLOAT_FORMAT_IEEE754_SINGLE)) */
  NULL,
#endif /* !((TME_FLOAT_FORMAT_IEEE754_SINGLE_BUILTIN == TME_FLOAT_FORMAT_IEEE754_SINGLE)) */

  /* this does a partial compliance single-precision from_double: */
  _tme_ieee754_strict_single_from_double,

  /* this does a partial compliance single-precision from_extended80: */
  _tme_ieee754_strict_single_from_extended80,

  /* this does a partial compliance single-precision from_quad: */
  _tme_ieee754_strict_single_from_quad,

  /* this does a partial compliance single-precision from_int32: */
  _tme_ieee754_strict_single_from_int32,

  /* this does a partial compliance single-precision from_int64: */
#if (defined(TME_HAVE_INT64_T))
  _tme_ieee754_strict_single_from_int64,
#else  /* !(defined(TME_HAVE_INT64_T)) */
  NULL,
#endif /* !(defined(TME_HAVE_INT64_T)) */

  /* this does a partial compliance single-precision to_int32: */
  _tme_ieee754_strict_single_to_int32,

  /* this does a partial compliance single-precision to_int64: */
#if (defined(TME_HAVE_INT64_T))
  _tme_ieee754_strict_single_to_int64,
#else  /* !(defined(TME_HAVE_INT64_T)) */
  NULL,
#endif /* !(defined(TME_HAVE_INT64_T)) */

  /* this does a partial compliance double-precision add: */
#if ((TME_FLOAT_FORMAT_IEEE754_DOUBLE_BUILTIN == TME_FLOAT_FORMAT_IEEE754_DOUBLE))
  _tme_ieee754_partial_double_add,
#else  /* !((TME_FLOAT_FORMAT_IEEE754_DOUBLE_BUILTIN == TME_FLOAT_FORMAT_IEEE754_DOUBLE)) */
  _tme_ieee754_strict_double_add,
#endif /* !((TME_FLOAT_FORMAT_IEEE754_DOUBLE_BUILTIN == TME_FLOAT_FORMAT_IEEE754_DOUBLE)) */

  /* this does a partial compliance double-precision sub: */
#if ((TME_FLOAT_FORMAT_IEEE754_DOUBLE_BUILTIN == TME_FLOAT_FORMAT_IEEE754_DOUBLE))
  _tme_ieee754_partial_double_sub,
#else  /* !((TME_FLOAT_FORMAT_IEEE754_DOUBLE_BUILTIN == TME_FLOAT_FORMAT_IEEE754_DOUBLE)) */
  _tme_ieee754_strict_double_sub,
#endif /* !((TME_FLOAT_FORMAT_IEEE754_DOUBLE_BUILTIN == TME_FLOAT_FORMAT_IEEE754_DOUBLE)) */

  /* this does a partial compliance double-precision mul: */
#if ((TME_FLOAT_FORMAT_IEEE754_DOUBLE_BUILTIN == TME_FLOAT_FORMAT_IEEE754_DOUBLE))
  _tme_ieee754_partial_double_mul,
#else  /* !((TME_FLOAT_FORMAT_IEEE754_DOUBLE_BUILTIN == TME_FLOAT_FORMAT_IEEE754_DOUBLE)) */
  _tme_ieee754_strict_double_mul,
#endif /* !((TME_FLOAT_FORMAT_IEEE754_DOUBLE_BUILTIN == TME_FLOAT_FORMAT_IEEE754_DOUBLE)) */

  /* this does a partial compliance double-precision div: */
#if ((TME_FLOAT_FORMAT_IEEE754_DOUBLE_BUILTIN == TME_FLOAT_FORMAT_IEEE754_DOUBLE))
  _tme_ieee754_partial_double_div,
#else  /* !((TME_FLOAT_FORMAT_IEEE754_DOUBLE_BUILTIN == TME_FLOAT_FORMAT_IEEE754_DOUBLE)) */
  _tme_ieee754_strict_double_div,
#endif /* !((TME_FLOAT_FORMAT_IEEE754_DOUBLE_BUILTIN == TME_FLOAT_FORMAT_IEEE754_DOUBLE)) */

  /* this does a partial compliance double-precision rem: */
  _tme_ieee754_strict_double_rem,

  /* this does a partial compliance double-precision sqrt: */
#if ((TME_FLOAT_FORMAT_IEEE754_DOUBLE_BUILTIN == TME_FLOAT_FORMAT_IEEE754_DOUBLE))
  _tme_ieee754_partial_double_sqrt,
#else  /* !((TME_FLOAT_FORMAT_IEEE754_DOUBLE_BUILTIN == TME_FLOAT_FORMAT_IEEE754_DOUBLE)) */
  _tme_ieee754_strict_double_sqrt,
#endif /* !((TME_FLOAT_FORMAT_IEEE754_DOUBLE_BUILTIN == TME_FLOAT_FORMAT_IEEE754_DOUBLE)) */

  /* this does a partial compliance double-precision abs: */
#if ((TME_FLOAT_FORMAT_IEEE754_DOUBLE_BUILTIN == TME_FLOAT_FORMAT_IEEE754_DOUBLE))
  _tme_ieee754_partial_double_abs,
#else  /* !((TME_FLOAT_FORMAT_IEEE754_DOUBLE_BUILTIN == TME_FLOAT_FORMAT_IEEE754_DOUBLE)) */
  NULL,
#endif /* !((TME_FLOAT_FORMAT_IEEE754_DOUBLE_BUILTIN == TME_FLOAT_FORMAT_IEEE754_DOUBLE)) */

  /* this does a partial compliance double-precision neg: */
#if ((TME_FLOAT_FORMAT_IEEE754_DOUBLE_BUILTIN == TME_FLOAT_FORMAT_IEEE754_DOUBLE))
  _tme_ieee754_partial_double_neg,
#else  /* !((TME_FLOAT_FORMAT_IEEE754_DOUBLE_BUILTIN == TME_FLOAT_FORMAT_IEEE754_DOUBLE)) */
  _tme_ieee754_strict_double_neg,
#endif /* !((TME_FLOAT_FORMAT_IEEE754_DOUBLE_BUILTIN == TME_FLOAT_FORMAT_IEEE754_DOUBLE)) */

  /* this does a partial compliance double-precision move: */
#if ((TME_FLOAT_FORMAT_IEEE754_DOUBLE_BUILTIN == TME_FLOAT_FORMAT_IEEE754_DOUBLE))
  _tme_ieee754_partial_double_move,
#else  /* !((TME_FLOAT_FORMAT_IEEE754_DOUBLE_BUILTIN == TME_FLOAT_FORMAT_IEEE754_DOUBLE)) */
  _tme_ieee754_strict_double_move,
#endif /* !((TME_FLOAT_FORMAT_IEEE754_DOUBLE_BUILTIN == TME_FLOAT_FORMAT_IEEE754_DOUBLE)) */

  /* this does a partial compliance double-precision rint: */
  _tme_ieee754_strict_double_rint,

  /* this does a partial compliance double-precision cos: */
  NULL,

  /* this does a partial compliance double-precision acos: */
  NULL,

  /* this does a partial compliance double-precision cosh: */
  NULL,

  /* this does a partial compliance double-precision sin: */
  NULL,

  /* this does a partial compliance double-precision asin: */
  NULL,

  /* this does a partial compliance double-precision sinh: */
  NULL,

  /* this does a partial compliance double-precision tan: */
  NULL,

  /* this does a partial compliance double-precision atan: */
  NULL,

  /* this does a partial compliance double-precision tanh: */
  NULL,

  /* this does a partial compliance double-precision atanh: */
  NULL,

  /* this does a partial compliance double-precision exp: */
#if ((TME_FLOAT_FORMAT_IEEE754_DOUBLE_BUILTIN == TME_FLOAT_FORMAT_IEEE754_DOUBLE))
  _tme_ieee754_partial_double_exp,
#else  /* !((TME_FLOAT_FORMAT_IEEE754_DOUBLE_BUILTIN == TME_FLOAT_FORMAT_IEEE754_DOUBLE)) */
  NULL,
#endif /* !((TME_FLOAT_FORMAT_IEEE754_DOUBLE_BUILTIN == TME_FLOAT_FORMAT_IEEE754_DOUBLE)) */

  /* this does a partial compliance double-precision expm1: */
  NULL,

  /* this does a partial compliance double-precision log10: */
#if ((TME_FLOAT_FORMAT_IEEE754_DOUBLE_BUILTIN == TME_FLOAT_FORMAT_IEEE754_DOUBLE))
  _tme_ieee754_partial_double_log10,
#else  /* !((TME_FLOAT_FORMAT_IEEE754_DOUBLE_BUILTIN == TME_FLOAT_FORMAT_IEEE754_DOUBLE)) */
  NULL,
#endif /* !((TME_FLOAT_FORMAT_IEEE754_DOUBLE_BUILTIN == TME_FLOAT_FORMAT_IEEE754_DOUBLE)) */

  /* this does a partial compliance double-precision log: */
#if ((TME_FLOAT_FORMAT_IEEE754_DOUBLE_BUILTIN == TME_FLOAT_FORMAT_IEEE754_DOUBLE))
  _tme_ieee754_partial_double_log,
#else  /* !((TME_FLOAT_FORMAT_IEEE754_DOUBLE_BUILTIN == TME_FLOAT_FORMAT_IEEE754_DOUBLE)) */
  NULL,
#endif /* !((TME_FLOAT_FORMAT_IEEE754_DOUBLE_BUILTIN == TME_FLOAT_FORMAT_IEEE754_DOUBLE)) */

  /* this does a partial compliance double-precision log1p: */
  NULL,

  /* this does a partial compliance double-precision getexp: */
  _tme_ieee754_strict_double_getexp,

  /* this does a partial compliance double-precision getman: */
  _tme_ieee754_strict_double_getman,

  /* this does a partial compliance double-precision scale: */
#if ((TME_FLOAT_FORMAT_IEEE754_DOUBLE_BUILTIN == TME_FLOAT_FORMAT_IEEE754_DOUBLE))
  _tme_ieee754_partial_double_scale,
#else  /* !((TME_FLOAT_FORMAT_IEEE754_DOUBLE_BUILTIN == TME_FLOAT_FORMAT_IEEE754_DOUBLE)) */
  NULL,
#endif /* !((TME_FLOAT_FORMAT_IEEE754_DOUBLE_BUILTIN == TME_FLOAT_FORMAT_IEEE754_DOUBLE)) */

  /* this does a partial compliance double-precision pow: */
#if ((TME_FLOAT_FORMAT_IEEE754_DOUBLE_BUILTIN == TME_FLOAT_FORMAT_IEEE754_DOUBLE))
  _tme_ieee754_partial_double_pow,
#else  /* !((TME_FLOAT_FORMAT_IEEE754_DOUBLE_BUILTIN == TME_FLOAT_FORMAT_IEEE754_DOUBLE)) */
  NULL,
#endif /* !((TME_FLOAT_FORMAT_IEEE754_DOUBLE_BUILTIN == TME_FLOAT_FORMAT_IEEE754_DOUBLE)) */

  /* this does a partial compliance double-precision from_single: */
  _tme_ieee754_strict_double_from_single,

  /* this does a partial compliance double-precision from_extended80: */
  _tme_ieee754_strict_double_from_extended80,

  /* this does a partial compliance double-precision from_quad: */
  _tme_ieee754_strict_double_from_quad,

  /* this does a partial compliance double-precision from_int32: */
  _tme_ieee754_strict_double_from_int32,

  /* this does a partial compliance double-precision from_int64: */
#if (defined(TME_HAVE_INT64_T))
  _tme_ieee754_strict_double_from_int64,
#else  /* !(defined(TME_HAVE_INT64_T)) */
  NULL,
#endif /* !(defined(TME_HAVE_INT64_T)) */

  /* this does a partial compliance double-precision to_int32: */
  _tme_ieee754_strict_double_to_int32,

  /* this does a partial compliance double-precision to_int64: */
#if (defined(TME_HAVE_INT64_T))
  _tme_ieee754_strict_double_to_int64,
#else  /* !(defined(TME_HAVE_INT64_T)) */
  NULL,
#endif /* !(defined(TME_HAVE_INT64_T)) */

  /* this does a partial compliance extended80-precision add: */
#if ((TME_FLOAT_FORMAT_IEEE754_EXTENDED80_BUILTIN == TME_FLOAT_FORMAT_IEEE754_EXTENDED80))
  _tme_ieee754_partial_extended80_add,
#else  /* !((TME_FLOAT_FORMAT_IEEE754_EXTENDED80_BUILTIN == TME_FLOAT_FORMAT_IEEE754_EXTENDED80)) */
#if (defined(TME_HAVE_INT64_T))
  _tme_ieee754_strict_extended80_add,
#else  /* !(defined(TME_HAVE_INT64_T)) */
  NULL,
#endif /* !(defined(TME_HAVE_INT64_T)) */
#endif /* !((TME_FLOAT_FORMAT_IEEE754_EXTENDED80_BUILTIN == TME_FLOAT_FORMAT_IEEE754_EXTENDED80)) */

  /* this does a partial compliance extended80-precision sub: */
#if ((TME_FLOAT_FORMAT_IEEE754_EXTENDED80_BUILTIN == TME_FLOAT_FORMAT_IEEE754_EXTENDED80))
  _tme_ieee754_partial_extended80_sub,
#else  /* !((TME_FLOAT_FORMAT_IEEE754_EXTENDED80_BUILTIN == TME_FLOAT_FORMAT_IEEE754_EXTENDED80)) */
#if (defined(TME_HAVE_INT64_T))
  _tme_ieee754_strict_extended80_sub,
#else  /* !(defined(TME_HAVE_INT64_T)) */
  NULL,
#endif /* !(defined(TME_HAVE_INT64_T)) */
#endif /* !((TME_FLOAT_FORMAT_IEEE754_EXTENDED80_BUILTIN == TME_FLOAT_FORMAT_IEEE754_EXTENDED80)) */

  /* this does a partial compliance extended80-precision mul: */
#if ((TME_FLOAT_FORMAT_IEEE754_EXTENDED80_BUILTIN == TME_FLOAT_FORMAT_IEEE754_EXTENDED80))
  _tme_ieee754_partial_extended80_mul,
#else  /* !((TME_FLOAT_FORMAT_IEEE754_EXTENDED80_BUILTIN == TME_FLOAT_FORMAT_IEEE754_EXTENDED80)) */
#if (defined(TME_HAVE_INT64_T))
  _tme_ieee754_strict_extended80_mul,
#else  /* !(defined(TME_HAVE_INT64_T)) */
  NULL,
#endif /* !(defined(TME_HAVE_INT64_T)) */
#endif /* !((TME_FLOAT_FORMAT_IEEE754_EXTENDED80_BUILTIN == TME_FLOAT_FORMAT_IEEE754_EXTENDED80)) */

  /* this does a partial compliance extended80-precision div: */
#if ((TME_FLOAT_FORMAT_IEEE754_EXTENDED80_BUILTIN == TME_FLOAT_FORMAT_IEEE754_EXTENDED80))
  _tme_ieee754_partial_extended80_div,
#else  /* !((TME_FLOAT_FORMAT_IEEE754_EXTENDED80_BUILTIN == TME_FLOAT_FORMAT_IEEE754_EXTENDED80)) */
#if (defined(TME_HAVE_INT64_T))
  _tme_ieee754_strict_extended80_div,
#else  /* !(defined(TME_HAVE_INT64_T)) */
  NULL,
#endif /* !(defined(TME_HAVE_INT64_T)) */
#endif /* !((TME_FLOAT_FORMAT_IEEE754_EXTENDED80_BUILTIN == TME_FLOAT_FORMAT_IEEE754_EXTENDED80)) */

  /* this does a partial compliance extended80-precision rem: */
#if (defined(TME_HAVE_INT64_T))
  _tme_ieee754_strict_extended80_rem,
#else  /* !(defined(TME_HAVE_INT64_T)) */
  NULL,
#endif /* !(defined(TME_HAVE_INT64_T)) */

  /* this does a partial compliance extended80-precision sqrt: */
#if ((TME_FLOAT_FORMAT_IEEE754_EXTENDED80_BUILTIN == TME_FLOAT_FORMAT_IEEE754_EXTENDED80))
  _tme_ieee754_partial_extended80_sqrt,
#else  /* !((TME_FLOAT_FORMAT_IEEE754_EXTENDED80_BUILTIN == TME_FLOAT_FORMAT_IEEE754_EXTENDED80)) */
#if (defined(TME_HAVE_INT64_T))
  _tme_ieee754_strict_extended80_sqrt,
#else  /* !(defined(TME_HAVE_INT64_T)) */
  NULL,
#endif /* !(defined(TME_HAVE_INT64_T)) */
#endif /* !((TME_FLOAT_FORMAT_IEEE754_EXTENDED80_BUILTIN == TME_FLOAT_FORMAT_IEEE754_EXTENDED80)) */

  /* this does a partial compliance extended80-precision abs: */
#if ((TME_FLOAT_FORMAT_IEEE754_EXTENDED80_BUILTIN == TME_FLOAT_FORMAT_IEEE754_EXTENDED80))
  _tme_ieee754_partial_extended80_abs,
#else  /* !((TME_FLOAT_FORMAT_IEEE754_EXTENDED80_BUILTIN == TME_FLOAT_FORMAT_IEEE754_EXTENDED80)) */
  NULL,
#endif /* !((TME_FLOAT_FORMAT_IEEE754_EXTENDED80_BUILTIN == TME_FLOAT_FORMAT_IEEE754_EXTENDED80)) */

  /* this does a partial compliance extended80-precision neg: */
#if ((TME_FLOAT_FORMAT_IEEE754_EXTENDED80_BUILTIN == TME_FLOAT_FORMAT_IEEE754_EXTENDED80))
  _tme_ieee754_partial_extended80_neg,
#else  /* !((TME_FLOAT_FORMAT_IEEE754_EXTENDED80_BUILTIN == TME_FLOAT_FORMAT_IEEE754_EXTENDED80)) */
#if (defined(TME_HAVE_INT64_T))
  _tme_ieee754_strict_extended80_neg,
#else  /* !(defined(TME_HAVE_INT64_T)) */
  NULL,
#endif /* !(defined(TME_HAVE_INT64_T)) */
#endif /* !((TME_FLOAT_FORMAT_IEEE754_EXTENDED80_BUILTIN == TME_FLOAT_FORMAT_IEEE754_EXTENDED80)) */

  /* this does a partial compliance extended80-precision move: */
#if ((TME_FLOAT_FORMAT_IEEE754_EXTENDED80_BUILTIN == TME_FLOAT_FORMAT_IEEE754_EXTENDED80))
  _tme_ieee754_partial_extended80_move,
#else  /* !((TME_FLOAT_FORMAT_IEEE754_EXTENDED80_BUILTIN == TME_FLOAT_FORMAT_IEEE754_EXTENDED80)) */
#if (defined(TME_HAVE_INT64_T))
  _tme_ieee754_strict_extended80_move,
#else  /* !(defined(TME_HAVE_INT64_T)) */
  NULL,
#endif /* !(defined(TME_HAVE_INT64_T)) */
#endif /* !((TME_FLOAT_FORMAT_IEEE754_EXTENDED80_BUILTIN == TME_FLOAT_FORMAT_IEEE754_EXTENDED80)) */

  /* this does a partial compliance extended80-precision rint: */
#if (defined(TME_HAVE_INT64_T))
  _tme_ieee754_strict_extended80_rint,
#else  /* !(defined(TME_HAVE_INT64_T)) */
  NULL,
#endif /* !(defined(TME_HAVE_INT64_T)) */

  /* this does a partial compliance extended80-precision cos: */
  NULL,

  /* this does a partial compliance extended80-precision acos: */
  NULL,

  /* this does a partial compliance extended80-precision cosh: */
  NULL,

  /* this does a partial compliance extended80-precision sin: */
  NULL,

  /* this does a partial compliance extended80-precision asin: */
  NULL,

  /* this does a partial compliance extended80-precision sinh: */
  NULL,

  /* this does a partial compliance extended80-precision tan: */
  NULL,

  /* this does a partial compliance extended80-precision atan: */
  NULL,

  /* this does a partial compliance extended80-precision tanh: */
  NULL,

  /* this does a partial compliance extended80-precision atanh: */
  NULL,

  /* this does a partial compliance extended80-precision exp: */
#if ((TME_FLOAT_FORMAT_IEEE754_EXTENDED80_BUILTIN == TME_FLOAT_FORMAT_IEEE754_EXTENDED80))
  _tme_ieee754_partial_extended80_exp,
#else  /* !((TME_FLOAT_FORMAT_IEEE754_EXTENDED80_BUILTIN == TME_FLOAT_FORMAT_IEEE754_EXTENDED80)) */
  NULL,
#endif /* !((TME_FLOAT_FORMAT_IEEE754_EXTENDED80_BUILTIN == TME_FLOAT_FORMAT_IEEE754_EXTENDED80)) */

  /* this does a partial compliance extended80-precision expm1: */
  NULL,

  /* this does a partial compliance extended80-precision log10: */
#if ((TME_FLOAT_FORMAT_IEEE754_EXTENDED80_BUILTIN == TME_FLOAT_FORMAT_IEEE754_EXTENDED80))
  _tme_ieee754_partial_extended80_log10,
#else  /* !((TME_FLOAT_FORMAT_IEEE754_EXTENDED80_BUILTIN == TME_FLOAT_FORMAT_IEEE754_EXTENDED80)) */
  NULL,
#endif /* !((TME_FLOAT_FORMAT_IEEE754_EXTENDED80_BUILTIN == TME_FLOAT_FORMAT_IEEE754_EXTENDED80)) */

  /* this does a partial compliance extended80-precision log: */
#if ((TME_FLOAT_FORMAT_IEEE754_EXTENDED80_BUILTIN == TME_FLOAT_FORMAT_IEEE754_EXTENDED80))
  _tme_ieee754_partial_extended80_log,
#else  /* !((TME_FLOAT_FORMAT_IEEE754_EXTENDED80_BUILTIN == TME_FLOAT_FORMAT_IEEE754_EXTENDED80)) */
  NULL,
#endif /* !((TME_FLOAT_FORMAT_IEEE754_EXTENDED80_BUILTIN == TME_FLOAT_FORMAT_IEEE754_EXTENDED80)) */

  /* this does a partial compliance extended80-precision log1p: */
  NULL,

  /* this does a partial compliance extended80-precision getexp: */
  _tme_ieee754_strict_extended80_getexp,

  /* this does a partial compliance extended80-precision getman: */
  _tme_ieee754_strict_extended80_getman,

  /* this does a partial compliance extended80-precision scale: */
#if ((TME_FLOAT_FORMAT_IEEE754_EXTENDED80_BUILTIN == TME_FLOAT_FORMAT_IEEE754_EXTENDED80))
  _tme_ieee754_partial_extended80_scale,
#else  /* !((TME_FLOAT_FORMAT_IEEE754_EXTENDED80_BUILTIN == TME_FLOAT_FORMAT_IEEE754_EXTENDED80)) */
  NULL,
#endif /* !((TME_FLOAT_FORMAT_IEEE754_EXTENDED80_BUILTIN == TME_FLOAT_FORMAT_IEEE754_EXTENDED80)) */

  /* this does a partial compliance extended80-precision pow: */
#if ((TME_FLOAT_FORMAT_IEEE754_EXTENDED80_BUILTIN == TME_FLOAT_FORMAT_IEEE754_EXTENDED80))
  _tme_ieee754_partial_extended80_pow,
#else  /* !((TME_FLOAT_FORMAT_IEEE754_EXTENDED80_BUILTIN == TME_FLOAT_FORMAT_IEEE754_EXTENDED80)) */
  NULL,
#endif /* !((TME_FLOAT_FORMAT_IEEE754_EXTENDED80_BUILTIN == TME_FLOAT_FORMAT_IEEE754_EXTENDED80)) */

  /* this does a partial compliance extended80-precision from_single: */
#if (defined(TME_HAVE_INT64_T))
  _tme_ieee754_strict_extended80_from_single,
#else  /* !(defined(TME_HAVE_INT64_T)) */
  NULL,
#endif /* !(defined(TME_HAVE_INT64_T)) */

  /* this does a partial compliance extended80-precision from_double: */
#if (defined(TME_HAVE_INT64_T))
  _tme_ieee754_strict_extended80_from_double,
#else  /* !(defined(TME_HAVE_INT64_T)) */
  NULL,
#endif /* !(defined(TME_HAVE_INT64_T)) */

  /* this does a partial compliance extended80-precision from_quad: */
#if (defined(TME_HAVE_INT64_T))
  _tme_ieee754_strict_extended80_from_quad,
#else  /* !(defined(TME_HAVE_INT64_T)) */
  NULL,
#endif /* !(defined(TME_HAVE_INT64_T)) */

  /* this does a partial compliance extended80-precision from_int32: */
#if (defined(TME_HAVE_INT64_T))
  _tme_ieee754_strict_extended80_from_int32,
#else  /* !(defined(TME_HAVE_INT64_T)) */
  NULL,
#endif /* !(defined(TME_HAVE_INT64_T)) */

  /* this does a partial compliance extended80-precision from_int64: */
#if (defined(TME_HAVE_INT64_T))
  _tme_ieee754_strict_extended80_from_int64,
#else  /* !(defined(TME_HAVE_INT64_T)) */
  NULL,
#endif /* !(defined(TME_HAVE_INT64_T)) */

  /* this does a partial compliance extended80-precision to_int32: */
  _tme_ieee754_strict_extended80_to_int32,

  /* this does a partial compliance extended80-precision to_int64: */
#if (defined(TME_HAVE_INT64_T))
  _tme_ieee754_strict_extended80_to_int64,
#else  /* !(defined(TME_HAVE_INT64_T)) */
  NULL,
#endif /* !(defined(TME_HAVE_INT64_T)) */

  /* this does a partial compliance quad-precision add: */
#if ((TME_FLOAT_FORMAT_IEEE754_QUAD_BUILTIN == TME_FLOAT_FORMAT_IEEE754_QUAD))
  _tme_ieee754_partial_quad_add,
#else  /* !((TME_FLOAT_FORMAT_IEEE754_QUAD_BUILTIN == TME_FLOAT_FORMAT_IEEE754_QUAD)) */
#if (defined(TME_HAVE_INT64_T))
  _tme_ieee754_strict_quad_add,
#else  /* !(defined(TME_HAVE_INT64_T)) */
  NULL,
#endif /* !(defined(TME_HAVE_INT64_T)) */
#endif /* !((TME_FLOAT_FORMAT_IEEE754_QUAD_BUILTIN == TME_FLOAT_FORMAT_IEEE754_QUAD)) */

  /* this does a partial compliance quad-precision sub: */
#if ((TME_FLOAT_FORMAT_IEEE754_QUAD_BUILTIN == TME_FLOAT_FORMAT_IEEE754_QUAD))
  _tme_ieee754_partial_quad_sub,
#else  /* !((TME_FLOAT_FORMAT_IEEE754_QUAD_BUILTIN == TME_FLOAT_FORMAT_IEEE754_QUAD)) */
#if (defined(TME_HAVE_INT64_T))
  _tme_ieee754_strict_quad_sub,
#else  /* !(defined(TME_HAVE_INT64_T)) */
  NULL,
#endif /* !(defined(TME_HAVE_INT64_T)) */
#endif /* !((TME_FLOAT_FORMAT_IEEE754_QUAD_BUILTIN == TME_FLOAT_FORMAT_IEEE754_QUAD)) */

  /* this does a partial compliance quad-precision mul: */
#if ((TME_FLOAT_FORMAT_IEEE754_QUAD_BUILTIN == TME_FLOAT_FORMAT_IEEE754_QUAD))
  _tme_ieee754_partial_quad_mul,
#else  /* !((TME_FLOAT_FORMAT_IEEE754_QUAD_BUILTIN == TME_FLOAT_FORMAT_IEEE754_QUAD)) */
#if (defined(TME_HAVE_INT64_T))
  _tme_ieee754_strict_quad_mul,
#else  /* !(defined(TME_HAVE_INT64_T)) */
  NULL,
#endif /* !(defined(TME_HAVE_INT64_T)) */
#endif /* !((TME_FLOAT_FORMAT_IEEE754_QUAD_BUILTIN == TME_FLOAT_FORMAT_IEEE754_QUAD)) */

  /* this does a partial compliance quad-precision div: */
#if ((TME_FLOAT_FORMAT_IEEE754_QUAD_BUILTIN == TME_FLOAT_FORMAT_IEEE754_QUAD))
  _tme_ieee754_partial_quad_div,
#else  /* !((TME_FLOAT_FORMAT_IEEE754_QUAD_BUILTIN == TME_FLOAT_FORMAT_IEEE754_QUAD)) */
#if (defined(TME_HAVE_INT64_T))
  _tme_ieee754_strict_quad_div,
#else  /* !(defined(TME_HAVE_INT64_T)) */
  NULL,
#endif /* !(defined(TME_HAVE_INT64_T)) */
#endif /* !((TME_FLOAT_FORMAT_IEEE754_QUAD_BUILTIN == TME_FLOAT_FORMAT_IEEE754_QUAD)) */

  /* this does a partial compliance quad-precision rem: */
#if (defined(TME_HAVE_INT64_T))
  _tme_ieee754_strict_quad_rem,
#else  /* !(defined(TME_HAVE_INT64_T)) */
  NULL,
#endif /* !(defined(TME_HAVE_INT64_T)) */

  /* this does a partial compliance quad-precision sqrt: */
#if ((TME_FLOAT_FORMAT_IEEE754_QUAD_BUILTIN == TME_FLOAT_FORMAT_IEEE754_QUAD))
  _tme_ieee754_partial_quad_sqrt,
#else  /* !((TME_FLOAT_FORMAT_IEEE754_QUAD_BUILTIN == TME_FLOAT_FORMAT_IEEE754_QUAD)) */
#if (defined(TME_HAVE_INT64_T))
  _tme_ieee754_strict_quad_sqrt,
#else  /* !(defined(TME_HAVE_INT64_T)) */
  NULL,
#endif /* !(defined(TME_HAVE_INT64_T)) */
#endif /* !((TME_FLOAT_FORMAT_IEEE754_QUAD_BUILTIN == TME_FLOAT_FORMAT_IEEE754_QUAD)) */

  /* this does a partial compliance quad-precision abs: */
#if ((TME_FLOAT_FORMAT_IEEE754_QUAD_BUILTIN == TME_FLOAT_FORMAT_IEEE754_QUAD))
  _tme_ieee754_partial_quad_abs,
#else  /* !((TME_FLOAT_FORMAT_IEEE754_QUAD_BUILTIN == TME_FLOAT_FORMAT_IEEE754_QUAD)) */
  NULL,
#endif /* !((TME_FLOAT_FORMAT_IEEE754_QUAD_BUILTIN == TME_FLOAT_FORMAT_IEEE754_QUAD)) */

  /* this does a partial compliance quad-precision neg: */
#if ((TME_FLOAT_FORMAT_IEEE754_QUAD_BUILTIN == TME_FLOAT_FORMAT_IEEE754_QUAD))
  _tme_ieee754_partial_quad_neg,
#else  /* !((TME_FLOAT_FORMAT_IEEE754_QUAD_BUILTIN == TME_FLOAT_FORMAT_IEEE754_QUAD)) */
#if (defined(TME_HAVE_INT64_T))
  _tme_ieee754_strict_quad_neg,
#else  /* !(defined(TME_HAVE_INT64_T)) */
  NULL,
#endif /* !(defined(TME_HAVE_INT64_T)) */
#endif /* !((TME_FLOAT_FORMAT_IEEE754_QUAD_BUILTIN == TME_FLOAT_FORMAT_IEEE754_QUAD)) */

  /* this does a partial compliance quad-precision move: */
#if ((TME_FLOAT_FORMAT_IEEE754_QUAD_BUILTIN == TME_FLOAT_FORMAT_IEEE754_QUAD))
  _tme_ieee754_partial_quad_move,
#else  /* !((TME_FLOAT_FORMAT_IEEE754_QUAD_BUILTIN == TME_FLOAT_FORMAT_IEEE754_QUAD)) */
#if (defined(TME_HAVE_INT64_T))
  _tme_ieee754_strict_quad_move,
#else  /* !(defined(TME_HAVE_INT64_T)) */
  NULL,
#endif /* !(defined(TME_HAVE_INT64_T)) */
#endif /* !((TME_FLOAT_FORMAT_IEEE754_QUAD_BUILTIN == TME_FLOAT_FORMAT_IEEE754_QUAD)) */

  /* this does a partial compliance quad-precision rint: */
#if (defined(TME_HAVE_INT64_T))
  _tme_ieee754_strict_quad_rint,
#else  /* !(defined(TME_HAVE_INT64_T)) */
  NULL,
#endif /* !(defined(TME_HAVE_INT64_T)) */

  /* this does a partial compliance quad-precision cos: */
  NULL,

  /* this does a partial compliance quad-precision acos: */
  NULL,

  /* this does a partial compliance quad-precision cosh: */
  NULL,

  /* this does a partial compliance quad-precision sin: */
  NULL,

  /* this does a partial compliance quad-precision asin: */
  NULL,

  /* this does a partial compliance quad-precision sinh: */
  NULL,

  /* this does a partial compliance quad-precision tan: */
  NULL,

  /* this does a partial compliance quad-precision atan: */
  NULL,

  /* this does a partial compliance quad-precision tanh: */
  NULL,

  /* this does a partial compliance quad-precision atanh: */
  NULL,

  /* this does a partial compliance quad-precision exp: */
#if ((TME_FLOAT_FORMAT_IEEE754_QUAD_BUILTIN == TME_FLOAT_FORMAT_IEEE754_QUAD))
  _tme_ieee754_partial_quad_exp,
#else  /* !((TME_FLOAT_FORMAT_IEEE754_QUAD_BUILTIN == TME_FLOAT_FORMAT_IEEE754_QUAD)) */
  NULL,
#endif /* !((TME_FLOAT_FORMAT_IEEE754_QUAD_BUILTIN == TME_FLOAT_FORMAT_IEEE754_QUAD)) */

  /* this does a partial compliance quad-precision expm1: */
  NULL,

  /* this does a partial compliance quad-precision log10: */
#if ((TME_FLOAT_FORMAT_IEEE754_QUAD_BUILTIN == TME_FLOAT_FORMAT_IEEE754_QUAD))
  _tme_ieee754_partial_quad_log10,
#else  /* !((TME_FLOAT_FORMAT_IEEE754_QUAD_BUILTIN == TME_FLOAT_FORMAT_IEEE754_QUAD)) */
  NULL,
#endif /* !((TME_FLOAT_FORMAT_IEEE754_QUAD_BUILTIN == TME_FLOAT_FORMAT_IEEE754_QUAD)) */

  /* this does a partial compliance quad-precision log: */
#if ((TME_FLOAT_FORMAT_IEEE754_QUAD_BUILTIN == TME_FLOAT_FORMAT_IEEE754_QUAD))
  _tme_ieee754_partial_quad_log,
#else  /* !((TME_FLOAT_FORMAT_IEEE754_QUAD_BUILTIN == TME_FLOAT_FORMAT_IEEE754_QUAD)) */
  NULL,
#endif /* !((TME_FLOAT_FORMAT_IEEE754_QUAD_BUILTIN == TME_FLOAT_FORMAT_IEEE754_QUAD)) */

  /* this does a partial compliance quad-precision log1p: */
  NULL,

  /* this does a partial compliance quad-precision getexp: */
  _tme_ieee754_strict_quad_getexp,

  /* this does a partial compliance quad-precision getman: */
  _tme_ieee754_strict_quad_getman,

  /* this does a partial compliance quad-precision scale: */
#if ((TME_FLOAT_FORMAT_IEEE754_QUAD_BUILTIN == TME_FLOAT_FORMAT_IEEE754_QUAD))
  _tme_ieee754_partial_quad_scale,
#else  /* !((TME_FLOAT_FORMAT_IEEE754_QUAD_BUILTIN == TME_FLOAT_FORMAT_IEEE754_QUAD)) */
  NULL,
#endif /* !((TME_FLOAT_FORMAT_IEEE754_QUAD_BUILTIN == TME_FLOAT_FORMAT_IEEE754_QUAD)) */

  /* this does a partial compliance quad-precision pow: */
#if ((TME_FLOAT_FORMAT_IEEE754_QUAD_BUILTIN == TME_FLOAT_FORMAT_IEEE754_QUAD))
  _tme_ieee754_partial_quad_pow,
#else  /* !((TME_FLOAT_FORMAT_IEEE754_QUAD_BUILTIN == TME_FLOAT_FORMAT_IEEE754_QUAD)) */
  NULL,
#endif /* !((TME_FLOAT_FORMAT_IEEE754_QUAD_BUILTIN == TME_FLOAT_FORMAT_IEEE754_QUAD)) */

  /* this does a partial compliance quad-precision from_single: */
#if (defined(TME_HAVE_INT64_T))
  _tme_ieee754_strict_quad_from_single,
#else  /* !(defined(TME_HAVE_INT64_T)) */
  NULL,
#endif /* !(defined(TME_HAVE_INT64_T)) */

  /* this does a partial compliance quad-precision from_double: */
#if (defined(TME_HAVE_INT64_T))
  _tme_ieee754_strict_quad_from_double,
#else  /* !(defined(TME_HAVE_INT64_T)) */
  NULL,
#endif /* !(defined(TME_HAVE_INT64_T)) */

  /* this does a partial compliance quad-precision from_extended80: */
#if (defined(TME_HAVE_INT64_T))
  _tme_ieee754_strict_quad_from_extended80,
#else  /* !(defined(TME_HAVE_INT64_T)) */
  NULL,
#endif /* !(defined(TME_HAVE_INT64_T)) */

  /* this does a partial compliance quad-precision from_int32: */
#if (defined(TME_HAVE_INT64_T))
  _tme_ieee754_strict_quad_from_int32,
#else  /* !(defined(TME_HAVE_INT64_T)) */
  NULL,
#endif /* !(defined(TME_HAVE_INT64_T)) */

  /* this does a partial compliance quad-precision from_int64: */
#if (defined(TME_HAVE_INT64_T))
  _tme_ieee754_strict_quad_from_int64,
#else  /* !(defined(TME_HAVE_INT64_T)) */
  NULL,
#endif /* !(defined(TME_HAVE_INT64_T)) */

  /* this does a partial compliance quad-precision to_int32: */
  _tme_ieee754_strict_quad_to_int32,

  /* this does a partial compliance quad-precision to_int64: */
#if (defined(TME_HAVE_INT64_T))
  _tme_ieee754_strict_quad_to_int64,
#else  /* !(defined(TME_HAVE_INT64_T)) */
  NULL,
#endif /* !(defined(TME_HAVE_INT64_T)) */
};

/* this does a unknown compliance single-precision add: */
static void
_tme_ieee754_unknown_single_add(struct tme_ieee754_ctl *ieee754_ctl, const struct tme_float *src0, const struct tme_float *src1, struct tme_float *dst)
{
  int exceptions;

  /* assume that this operation raises no exceptions: */
  exceptions = 0;

  /* the operation: */
  tme_ieee754_single_value_builtin_set(dst, TME_FLOAT_FORMAT_IEEE754_SINGLE_BUILTIN, tme_ieee754_single_value_builtin_get(src0) + tme_ieee754_single_value_builtin_get(src1));
  ieee754_ctl->tme_ieee754_ctl_lock_unlock = NULL;

  /* signal any exceptions: */
  if (exceptions != 0) {
    (*ieee754_ctl->tme_ieee754_ctl_exception)(ieee754_ctl, exceptions);
  }
}

/* this does a unknown compliance single-precision sub: */
static void
_tme_ieee754_unknown_single_sub(struct tme_ieee754_ctl *ieee754_ctl, const struct tme_float *src0, const struct tme_float *src1, struct tme_float *dst)
{
  int exceptions;

  /* assume that this operation raises no exceptions: */
  exceptions = 0;

  /* the operation: */
  tme_ieee754_single_value_builtin_set(dst, TME_FLOAT_FORMAT_IEEE754_SINGLE_BUILTIN, tme_ieee754_single_value_builtin_get(src0) - tme_ieee754_single_value_builtin_get(src1));
  ieee754_ctl->tme_ieee754_ctl_lock_unlock = NULL;

  /* signal any exceptions: */
  if (exceptions != 0) {
    (*ieee754_ctl->tme_ieee754_ctl_exception)(ieee754_ctl, exceptions);
  }
}

/* this does a unknown compliance single-precision mul: */
static void
_tme_ieee754_unknown_single_mul(struct tme_ieee754_ctl *ieee754_ctl, const struct tme_float *src0, const struct tme_float *src1, struct tme_float *dst)
{
  int exceptions;

  /* assume that this operation raises no exceptions: */
  exceptions = 0;

  /* the operation: */
  tme_ieee754_single_value_builtin_set(dst, TME_FLOAT_FORMAT_IEEE754_SINGLE_BUILTIN, tme_ieee754_single_value_builtin_get(src0) * tme_ieee754_single_value_builtin_get(src1));
  ieee754_ctl->tme_ieee754_ctl_lock_unlock = NULL;

  /* signal any exceptions: */
  if (exceptions != 0) {
    (*ieee754_ctl->tme_ieee754_ctl_exception)(ieee754_ctl, exceptions);
  }
}

/* this does a unknown compliance single-precision div: */
static void
_tme_ieee754_unknown_single_div(struct tme_ieee754_ctl *ieee754_ctl, const struct tme_float *src0, const struct tme_float *src1, struct tme_float *dst)
{
  int exceptions;

  /* assume that this operation raises no exceptions: */
  exceptions = 0;

  /* the operation: */
  tme_ieee754_single_value_builtin_set(dst, TME_FLOAT_FORMAT_IEEE754_SINGLE_BUILTIN, tme_ieee754_single_value_builtin_get(src0) / tme_ieee754_single_value_builtin_get(src1));
  ieee754_ctl->tme_ieee754_ctl_lock_unlock = NULL;

  /* signal any exceptions: */
  if (exceptions != 0) {
    (*ieee754_ctl->tme_ieee754_ctl_exception)(ieee754_ctl, exceptions);
  }
}

/* this does a unknown compliance single-precision sqrt: */
static void
_tme_ieee754_unknown_single_sqrt(struct tme_ieee754_ctl *ieee754_ctl, const struct tme_float *src0, struct tme_float *dst)
{
  int exceptions;

  /* assume that this operation raises no exceptions: */
  exceptions = 0;

  /* the operation: */
#if (TME_FLOAT_FORMAT_IEEE754_SINGLE_BUILTIN == TME_FLOAT_FORMAT_FLOAT)
  tme_ieee754_single_value_builtin_set(dst, TME_FLOAT_FORMAT_FLOAT, sqrtf(tme_ieee754_single_value_builtin_get(src0)));
#else  /* (TME_FLOAT_FORMAT_IEEE754_SINGLE_BUILTIN != TME_FLOAT_FORMAT_FLOAT) */
  tme_ieee754_single_value_builtin_set(dst, TME_FLOAT_FORMAT_DOUBLE, sqrtl(tme_ieee754_single_value_builtin_get(src0)));
#endif /* (TME_FLOAT_FORMAT_IEEE754_SINGLE_BUILTIN != TME_FLOAT_FORMAT_FLOAT) */
  ieee754_ctl->tme_ieee754_ctl_lock_unlock = NULL;

  /* signal any exceptions: */
  if (exceptions != 0) {
    (*ieee754_ctl->tme_ieee754_ctl_exception)(ieee754_ctl, exceptions);
  }
}

/* this does a unknown compliance single-precision abs: */
static void
_tme_ieee754_unknown_single_abs(struct tme_ieee754_ctl *ieee754_ctl, const struct tme_float *src0, struct tme_float *dst)
{
  int exceptions;

  /* assume that this operation raises no exceptions: */
  exceptions = 0;

  /* the operation: */
#if (TME_FLOAT_FORMAT_IEEE754_SINGLE_BUILTIN == TME_FLOAT_FORMAT_FLOAT)
  tme_ieee754_single_value_builtin_set(dst, TME_FLOAT_FORMAT_FLOAT, fabsf(tme_ieee754_single_value_builtin_get(src0)));
#else  /* (TME_FLOAT_FORMAT_IEEE754_SINGLE_BUILTIN != TME_FLOAT_FORMAT_FLOAT) */
  tme_ieee754_single_value_builtin_set(dst, TME_FLOAT_FORMAT_DOUBLE, fabsl(tme_ieee754_single_value_builtin_get(src0)));
#endif /* (TME_FLOAT_FORMAT_IEEE754_SINGLE_BUILTIN != TME_FLOAT_FORMAT_FLOAT) */
  ieee754_ctl->tme_ieee754_ctl_lock_unlock = NULL;

  /* signal any exceptions: */
  if (exceptions != 0) {
    (*ieee754_ctl->tme_ieee754_ctl_exception)(ieee754_ctl, exceptions);
  }
}

/* this does a unknown compliance single-precision neg: */
static void
_tme_ieee754_unknown_single_neg(struct tme_ieee754_ctl *ieee754_ctl, const struct tme_float *src0, struct tme_float *dst)
{
  int exceptions;

  /* assume that this operation raises no exceptions: */
  exceptions = 0;

  /* the operation: */
  tme_ieee754_single_value_builtin_set(dst, TME_FLOAT_FORMAT_IEEE754_SINGLE_BUILTIN, -1 * tme_ieee754_single_value_builtin_get(src0));
  ieee754_ctl->tme_ieee754_ctl_lock_unlock = NULL;

  /* signal any exceptions: */
  if (exceptions != 0) {
    (*ieee754_ctl->tme_ieee754_ctl_exception)(ieee754_ctl, exceptions);
  }
}

/* this does a unknown compliance single-precision move: */
static void
_tme_ieee754_unknown_single_move(struct tme_ieee754_ctl *ieee754_ctl, const struct tme_float *src0, struct tme_float *dst)
{
  int exceptions;

  /* assume that this operation raises no exceptions: */
  exceptions = 0;

  /* the operation: */
  *dst = *src0;
  ieee754_ctl->tme_ieee754_ctl_lock_unlock = NULL;

  /* signal any exceptions: */
  if (exceptions != 0) {
    (*ieee754_ctl->tme_ieee754_ctl_exception)(ieee754_ctl, exceptions);
  }
}

/* this does a unknown compliance single-precision exp: */
static void
_tme_ieee754_unknown_single_exp(struct tme_ieee754_ctl *ieee754_ctl, const struct tme_float *src0, struct tme_float *dst)
{
  int exceptions;

  /* assume that this operation raises no exceptions: */
  exceptions = 0;

  /* the operation: */
#if (TME_FLOAT_FORMAT_IEEE754_SINGLE_BUILTIN == TME_FLOAT_FORMAT_FLOAT)
  tme_ieee754_single_value_builtin_set(dst, TME_FLOAT_FORMAT_FLOAT, expf(tme_ieee754_single_value_builtin_get(src0)));
#else  /* (TME_FLOAT_FORMAT_IEEE754_SINGLE_BUILTIN != TME_FLOAT_FORMAT_FLOAT) */
  tme_ieee754_single_value_builtin_set(dst, TME_FLOAT_FORMAT_DOUBLE, expl(tme_ieee754_single_value_builtin_get(src0)));
#endif /* (TME_FLOAT_FORMAT_IEEE754_SINGLE_BUILTIN != TME_FLOAT_FORMAT_FLOAT) */
  ieee754_ctl->tme_ieee754_ctl_lock_unlock = NULL;

  /* signal any exceptions: */
  if (exceptions != 0) {
    (*ieee754_ctl->tme_ieee754_ctl_exception)(ieee754_ctl, exceptions);
  }
}

/* this does a unknown compliance single-precision log10: */
static void
_tme_ieee754_unknown_single_log10(struct tme_ieee754_ctl *ieee754_ctl, const struct tme_float *src0, struct tme_float *dst)
{
  int exceptions;

  /* assume that this operation raises no exceptions: */
  exceptions = 0;

  /* the operation: */
#if (TME_FLOAT_FORMAT_IEEE754_SINGLE_BUILTIN == TME_FLOAT_FORMAT_FLOAT)
  tme_ieee754_single_value_builtin_set(dst, TME_FLOAT_FORMAT_FLOAT, log10f(tme_ieee754_single_value_builtin_get(src0)));
#else  /* (TME_FLOAT_FORMAT_IEEE754_SINGLE_BUILTIN != TME_FLOAT_FORMAT_FLOAT) */
  tme_ieee754_single_value_builtin_set(dst, TME_FLOAT_FORMAT_DOUBLE, log10l(tme_ieee754_single_value_builtin_get(src0)));
#endif /* (TME_FLOAT_FORMAT_IEEE754_SINGLE_BUILTIN != TME_FLOAT_FORMAT_FLOAT) */
  ieee754_ctl->tme_ieee754_ctl_lock_unlock = NULL;

  /* signal any exceptions: */
  if (exceptions != 0) {
    (*ieee754_ctl->tme_ieee754_ctl_exception)(ieee754_ctl, exceptions);
  }
}

/* this does a unknown compliance single-precision log: */
static void
_tme_ieee754_unknown_single_log(struct tme_ieee754_ctl *ieee754_ctl, const struct tme_float *src0, struct tme_float *dst)
{
  int exceptions;

  /* assume that this operation raises no exceptions: */
  exceptions = 0;

  /* the operation: */
#if (TME_FLOAT_FORMAT_IEEE754_SINGLE_BUILTIN == TME_FLOAT_FORMAT_FLOAT)
  tme_ieee754_single_value_builtin_set(dst, TME_FLOAT_FORMAT_FLOAT, logf(tme_ieee754_single_value_builtin_get(src0)));
#else  /* (TME_FLOAT_FORMAT_IEEE754_SINGLE_BUILTIN != TME_FLOAT_FORMAT_FLOAT) */
  tme_ieee754_single_value_builtin_set(dst, TME_FLOAT_FORMAT_DOUBLE, logl(tme_ieee754_single_value_builtin_get(src0)));
#endif /* (TME_FLOAT_FORMAT_IEEE754_SINGLE_BUILTIN != TME_FLOAT_FORMAT_FLOAT) */
  ieee754_ctl->tme_ieee754_ctl_lock_unlock = NULL;

  /* signal any exceptions: */
  if (exceptions != 0) {
    (*ieee754_ctl->tme_ieee754_ctl_exception)(ieee754_ctl, exceptions);
  }
}

/* this does a unknown compliance single-precision scale: */
static void
_tme_ieee754_unknown_single_scale(struct tme_ieee754_ctl *ieee754_ctl, const struct tme_float *src0, const struct tme_float *src1, struct tme_float *dst)
{
  int exceptions;

  /* assume that this operation raises no exceptions: */
  exceptions = 0;

  /* the operation: */
#if (TME_FLOAT_FORMAT_IEEE754_SINGLE_BUILTIN == TME_FLOAT_FORMAT_FLOAT)
  tme_ieee754_single_value_builtin_set(dst, TME_FLOAT_FORMAT_FLOAT, scalbnf(tme_ieee754_single_value_builtin_get(src0), tme_ieee754_single_value_builtin_get(src1)));
#else  /* (TME_FLOAT_FORMAT_IEEE754_SINGLE_BUILTIN != TME_FLOAT_FORMAT_FLOAT) */
  tme_ieee754_single_value_builtin_set(dst, TME_FLOAT_FORMAT_DOUBLE, scalbnl(tme_ieee754_single_value_builtin_get(src0), tme_ieee754_single_value_builtin_get(src1)));
#endif /* (TME_FLOAT_FORMAT_IEEE754_SINGLE_BUILTIN != TME_FLOAT_FORMAT_FLOAT) */
  ieee754_ctl->tme_ieee754_ctl_lock_unlock = NULL;

  /* signal any exceptions: */
  if (exceptions != 0) {
    (*ieee754_ctl->tme_ieee754_ctl_exception)(ieee754_ctl, exceptions);
  }
}

/* this does a unknown compliance single-precision pow: */
static void
_tme_ieee754_unknown_single_pow(struct tme_ieee754_ctl *ieee754_ctl, const struct tme_float *src0, const struct tme_float *src1, struct tme_float *dst)
{
  int exceptions;

  /* assume that this operation raises no exceptions: */
  exceptions = 0;

  /* the operation: */
#if (TME_FLOAT_FORMAT_IEEE754_SINGLE_BUILTIN == TME_FLOAT_FORMAT_FLOAT)
  tme_ieee754_single_value_builtin_set(dst, TME_FLOAT_FORMAT_FLOAT, powf(tme_ieee754_single_value_builtin_get(src0), tme_ieee754_single_value_builtin_get(src1)));
#else  /* (TME_FLOAT_FORMAT_IEEE754_SINGLE_BUILTIN != TME_FLOAT_FORMAT_FLOAT) */
  tme_ieee754_single_value_builtin_set(dst, TME_FLOAT_FORMAT_DOUBLE, powl(tme_ieee754_single_value_builtin_get(src0), tme_ieee754_single_value_builtin_get(src1)));
#endif /* (TME_FLOAT_FORMAT_IEEE754_SINGLE_BUILTIN != TME_FLOAT_FORMAT_FLOAT) */
  ieee754_ctl->tme_ieee754_ctl_lock_unlock = NULL;

  /* signal any exceptions: */
  if (exceptions != 0) {
    (*ieee754_ctl->tme_ieee754_ctl_exception)(ieee754_ctl, exceptions);
  }
}

/* this does a unknown compliance double-precision add: */
static void
_tme_ieee754_unknown_double_add(struct tme_ieee754_ctl *ieee754_ctl, const struct tme_float *src0, const struct tme_float *src1, struct tme_float *dst)
{
  int exceptions;

  /* assume that this operation raises no exceptions: */
  exceptions = 0;

  /* the operation: */
  tme_ieee754_double_value_builtin_set(dst, TME_FLOAT_FORMAT_IEEE754_DOUBLE_BUILTIN, tme_ieee754_double_value_builtin_get(src0) + tme_ieee754_double_value_builtin_get(src1));
  ieee754_ctl->tme_ieee754_ctl_lock_unlock = NULL;

  /* signal any exceptions: */
  if (exceptions != 0) {
    (*ieee754_ctl->tme_ieee754_ctl_exception)(ieee754_ctl, exceptions);
  }
}

/* this does a unknown compliance double-precision sub: */
static void
_tme_ieee754_unknown_double_sub(struct tme_ieee754_ctl *ieee754_ctl, const struct tme_float *src0, const struct tme_float *src1, struct tme_float *dst)
{
  int exceptions;

  /* assume that this operation raises no exceptions: */
  exceptions = 0;

  /* the operation: */
  tme_ieee754_double_value_builtin_set(dst, TME_FLOAT_FORMAT_IEEE754_DOUBLE_BUILTIN, tme_ieee754_double_value_builtin_get(src0) - tme_ieee754_double_value_builtin_get(src1));
  ieee754_ctl->tme_ieee754_ctl_lock_unlock = NULL;

  /* signal any exceptions: */
  if (exceptions != 0) {
    (*ieee754_ctl->tme_ieee754_ctl_exception)(ieee754_ctl, exceptions);
  }
}

/* this does a unknown compliance double-precision mul: */
static void
_tme_ieee754_unknown_double_mul(struct tme_ieee754_ctl *ieee754_ctl, const struct tme_float *src0, const struct tme_float *src1, struct tme_float *dst)
{
  int exceptions;

  /* assume that this operation raises no exceptions: */
  exceptions = 0;

  /* the operation: */
  tme_ieee754_double_value_builtin_set(dst, TME_FLOAT_FORMAT_IEEE754_DOUBLE_BUILTIN, tme_ieee754_double_value_builtin_get(src0) * tme_ieee754_double_value_builtin_get(src1));
  ieee754_ctl->tme_ieee754_ctl_lock_unlock = NULL;

  /* signal any exceptions: */
  if (exceptions != 0) {
    (*ieee754_ctl->tme_ieee754_ctl_exception)(ieee754_ctl, exceptions);
  }
}

/* this does a unknown compliance double-precision div: */
static void
_tme_ieee754_unknown_double_div(struct tme_ieee754_ctl *ieee754_ctl, const struct tme_float *src0, const struct tme_float *src1, struct tme_float *dst)
{
  int exceptions;

  /* assume that this operation raises no exceptions: */
  exceptions = 0;

  /* the operation: */
  tme_ieee754_double_value_builtin_set(dst, TME_FLOAT_FORMAT_IEEE754_DOUBLE_BUILTIN, tme_ieee754_double_value_builtin_get(src0) / tme_ieee754_double_value_builtin_get(src1));
  ieee754_ctl->tme_ieee754_ctl_lock_unlock = NULL;

  /* signal any exceptions: */
  if (exceptions != 0) {
    (*ieee754_ctl->tme_ieee754_ctl_exception)(ieee754_ctl, exceptions);
  }
}

/* this does a unknown compliance double-precision sqrt: */
static void
_tme_ieee754_unknown_double_sqrt(struct tme_ieee754_ctl *ieee754_ctl, const struct tme_float *src0, struct tme_float *dst)
{
  int exceptions;

  /* assume that this operation raises no exceptions: */
  exceptions = 0;

  /* the operation: */
#if (TME_FLOAT_FORMAT_IEEE754_DOUBLE_BUILTIN == TME_FLOAT_FORMAT_FLOAT)
  tme_ieee754_double_value_builtin_set(dst, TME_FLOAT_FORMAT_FLOAT, sqrtf(tme_ieee754_double_value_builtin_get(src0)));
#else  /* (TME_FLOAT_FORMAT_IEEE754_DOUBLE_BUILTIN != TME_FLOAT_FORMAT_FLOAT) */
  tme_ieee754_double_value_builtin_set(dst, TME_FLOAT_FORMAT_DOUBLE, sqrtl(tme_ieee754_double_value_builtin_get(src0)));
#endif /* (TME_FLOAT_FORMAT_IEEE754_DOUBLE_BUILTIN != TME_FLOAT_FORMAT_FLOAT) */
  ieee754_ctl->tme_ieee754_ctl_lock_unlock = NULL;

  /* signal any exceptions: */
  if (exceptions != 0) {
    (*ieee754_ctl->tme_ieee754_ctl_exception)(ieee754_ctl, exceptions);
  }
}

/* this does a unknown compliance double-precision abs: */
static void
_tme_ieee754_unknown_double_abs(struct tme_ieee754_ctl *ieee754_ctl, const struct tme_float *src0, struct tme_float *dst)
{
  int exceptions;

  /* assume that this operation raises no exceptions: */
  exceptions = 0;

  /* the operation: */
#if (TME_FLOAT_FORMAT_IEEE754_DOUBLE_BUILTIN == TME_FLOAT_FORMAT_FLOAT)
  tme_ieee754_double_value_builtin_set(dst, TME_FLOAT_FORMAT_FLOAT, fabsf(tme_ieee754_double_value_builtin_get(src0)));
#else  /* (TME_FLOAT_FORMAT_IEEE754_DOUBLE_BUILTIN != TME_FLOAT_FORMAT_FLOAT) */
  tme_ieee754_double_value_builtin_set(dst, TME_FLOAT_FORMAT_DOUBLE, fabsl(tme_ieee754_double_value_builtin_get(src0)));
#endif /* (TME_FLOAT_FORMAT_IEEE754_DOUBLE_BUILTIN != TME_FLOAT_FORMAT_FLOAT) */
  ieee754_ctl->tme_ieee754_ctl_lock_unlock = NULL;

  /* signal any exceptions: */
  if (exceptions != 0) {
    (*ieee754_ctl->tme_ieee754_ctl_exception)(ieee754_ctl, exceptions);
  }
}

/* this does a unknown compliance double-precision neg: */
static void
_tme_ieee754_unknown_double_neg(struct tme_ieee754_ctl *ieee754_ctl, const struct tme_float *src0, struct tme_float *dst)
{
  int exceptions;

  /* assume that this operation raises no exceptions: */
  exceptions = 0;

  /* the operation: */
  tme_ieee754_double_value_builtin_set(dst, TME_FLOAT_FORMAT_IEEE754_DOUBLE_BUILTIN, -1 * tme_ieee754_double_value_builtin_get(src0));
  ieee754_ctl->tme_ieee754_ctl_lock_unlock = NULL;

  /* signal any exceptions: */
  if (exceptions != 0) {
    (*ieee754_ctl->tme_ieee754_ctl_exception)(ieee754_ctl, exceptions);
  }
}

/* this does a unknown compliance double-precision move: */
static void
_tme_ieee754_unknown_double_move(struct tme_ieee754_ctl *ieee754_ctl, const struct tme_float *src0, struct tme_float *dst)
{
  int exceptions;

  /* assume that this operation raises no exceptions: */
  exceptions = 0;

  /* the operation: */
  *dst = *src0;
  ieee754_ctl->tme_ieee754_ctl_lock_unlock = NULL;

  /* signal any exceptions: */
  if (exceptions != 0) {
    (*ieee754_ctl->tme_ieee754_ctl_exception)(ieee754_ctl, exceptions);
  }
}

/* this does a unknown compliance double-precision exp: */
static void
_tme_ieee754_unknown_double_exp(struct tme_ieee754_ctl *ieee754_ctl, const struct tme_float *src0, struct tme_float *dst)
{
  int exceptions;

  /* assume that this operation raises no exceptions: */
  exceptions = 0;

  /* the operation: */
#if (TME_FLOAT_FORMAT_IEEE754_DOUBLE_BUILTIN == TME_FLOAT_FORMAT_FLOAT)
  tme_ieee754_double_value_builtin_set(dst, TME_FLOAT_FORMAT_FLOAT, expf(tme_ieee754_double_value_builtin_get(src0)));
#else  /* (TME_FLOAT_FORMAT_IEEE754_DOUBLE_BUILTIN != TME_FLOAT_FORMAT_FLOAT) */
  tme_ieee754_double_value_builtin_set(dst, TME_FLOAT_FORMAT_DOUBLE, expl(tme_ieee754_double_value_builtin_get(src0)));
#endif /* (TME_FLOAT_FORMAT_IEEE754_DOUBLE_BUILTIN != TME_FLOAT_FORMAT_FLOAT) */
  ieee754_ctl->tme_ieee754_ctl_lock_unlock = NULL;

  /* signal any exceptions: */
  if (exceptions != 0) {
    (*ieee754_ctl->tme_ieee754_ctl_exception)(ieee754_ctl, exceptions);
  }
}

/* this does a unknown compliance double-precision log10: */
static void
_tme_ieee754_unknown_double_log10(struct tme_ieee754_ctl *ieee754_ctl, const struct tme_float *src0, struct tme_float *dst)
{
  int exceptions;

  /* assume that this operation raises no exceptions: */
  exceptions = 0;

  /* the operation: */
#if (TME_FLOAT_FORMAT_IEEE754_DOUBLE_BUILTIN == TME_FLOAT_FORMAT_FLOAT)
  tme_ieee754_double_value_builtin_set(dst, TME_FLOAT_FORMAT_FLOAT, log10f(tme_ieee754_double_value_builtin_get(src0)));
#else  /* (TME_FLOAT_FORMAT_IEEE754_DOUBLE_BUILTIN != TME_FLOAT_FORMAT_FLOAT) */
  tme_ieee754_double_value_builtin_set(dst, TME_FLOAT_FORMAT_DOUBLE, log10l(tme_ieee754_double_value_builtin_get(src0)));
#endif /* (TME_FLOAT_FORMAT_IEEE754_DOUBLE_BUILTIN != TME_FLOAT_FORMAT_FLOAT) */
  ieee754_ctl->tme_ieee754_ctl_lock_unlock = NULL;

  /* signal any exceptions: */
  if (exceptions != 0) {
    (*ieee754_ctl->tme_ieee754_ctl_exception)(ieee754_ctl, exceptions);
  }
}

/* this does a unknown compliance double-precision log: */
static void
_tme_ieee754_unknown_double_log(struct tme_ieee754_ctl *ieee754_ctl, const struct tme_float *src0, struct tme_float *dst)
{
  int exceptions;

  /* assume that this operation raises no exceptions: */
  exceptions = 0;

  /* the operation: */
#if (TME_FLOAT_FORMAT_IEEE754_DOUBLE_BUILTIN == TME_FLOAT_FORMAT_FLOAT)
  tme_ieee754_double_value_builtin_set(dst, TME_FLOAT_FORMAT_FLOAT, logf(tme_ieee754_double_value_builtin_get(src0)));
#else  /* (TME_FLOAT_FORMAT_IEEE754_DOUBLE_BUILTIN != TME_FLOAT_FORMAT_FLOAT) */
  tme_ieee754_double_value_builtin_set(dst, TME_FLOAT_FORMAT_DOUBLE, logl(tme_ieee754_double_value_builtin_get(src0)));
#endif /* (TME_FLOAT_FORMAT_IEEE754_DOUBLE_BUILTIN != TME_FLOAT_FORMAT_FLOAT) */
  ieee754_ctl->tme_ieee754_ctl_lock_unlock = NULL;

  /* signal any exceptions: */
  if (exceptions != 0) {
    (*ieee754_ctl->tme_ieee754_ctl_exception)(ieee754_ctl, exceptions);
  }
}

/* this does a unknown compliance double-precision scale: */
static void
_tme_ieee754_unknown_double_scale(struct tme_ieee754_ctl *ieee754_ctl, const struct tme_float *src0, const struct tme_float *src1, struct tme_float *dst)
{
  int exceptions;

  /* assume that this operation raises no exceptions: */
  exceptions = 0;

  /* the operation: */
#if (TME_FLOAT_FORMAT_IEEE754_DOUBLE_BUILTIN == TME_FLOAT_FORMAT_FLOAT)
  tme_ieee754_double_value_builtin_set(dst, TME_FLOAT_FORMAT_FLOAT, scalbnf(tme_ieee754_double_value_builtin_get(src0), tme_ieee754_double_value_builtin_get(src1)));
#else  /* (TME_FLOAT_FORMAT_IEEE754_DOUBLE_BUILTIN != TME_FLOAT_FORMAT_FLOAT) */
  tme_ieee754_double_value_builtin_set(dst, TME_FLOAT_FORMAT_DOUBLE, scalbnl(tme_ieee754_double_value_builtin_get(src0), tme_ieee754_double_value_builtin_get(src1)));
#endif /* (TME_FLOAT_FORMAT_IEEE754_DOUBLE_BUILTIN != TME_FLOAT_FORMAT_FLOAT) */
  ieee754_ctl->tme_ieee754_ctl_lock_unlock = NULL;

  /* signal any exceptions: */
  if (exceptions != 0) {
    (*ieee754_ctl->tme_ieee754_ctl_exception)(ieee754_ctl, exceptions);
  }
}

/* this does a unknown compliance double-precision pow: */
static void
_tme_ieee754_unknown_double_pow(struct tme_ieee754_ctl *ieee754_ctl, const struct tme_float *src0, const struct tme_float *src1, struct tme_float *dst)
{
  int exceptions;

  /* assume that this operation raises no exceptions: */
  exceptions = 0;

  /* the operation: */
#if (TME_FLOAT_FORMAT_IEEE754_DOUBLE_BUILTIN == TME_FLOAT_FORMAT_FLOAT)
  tme_ieee754_double_value_builtin_set(dst, TME_FLOAT_FORMAT_FLOAT, powf(tme_ieee754_double_value_builtin_get(src0), tme_ieee754_double_value_builtin_get(src1)));
#else  /* (TME_FLOAT_FORMAT_IEEE754_DOUBLE_BUILTIN != TME_FLOAT_FORMAT_FLOAT) */
  tme_ieee754_double_value_builtin_set(dst, TME_FLOAT_FORMAT_DOUBLE, powl(tme_ieee754_double_value_builtin_get(src0), tme_ieee754_double_value_builtin_get(src1)));
#endif /* (TME_FLOAT_FORMAT_IEEE754_DOUBLE_BUILTIN != TME_FLOAT_FORMAT_FLOAT) */
  ieee754_ctl->tme_ieee754_ctl_lock_unlock = NULL;

  /* signal any exceptions: */
  if (exceptions != 0) {
    (*ieee754_ctl->tme_ieee754_ctl_exception)(ieee754_ctl, exceptions);
  }
}

/* this does a unknown compliance extended80-precision add: */
static void
_tme_ieee754_unknown_extended80_add(struct tme_ieee754_ctl *ieee754_ctl, const struct tme_float *src0, const struct tme_float *src1, struct tme_float *dst)
{
  int exceptions;

  /* assume that this operation raises no exceptions: */
  exceptions = 0;

  /* the operation: */
  tme_ieee754_extended80_value_builtin_set(dst, TME_FLOAT_FORMAT_IEEE754_EXTENDED80_BUILTIN, tme_ieee754_extended80_value_builtin_get(src0) + tme_ieee754_extended80_value_builtin_get(src1));
  ieee754_ctl->tme_ieee754_ctl_lock_unlock = NULL;

  /* signal any exceptions: */
  if (exceptions != 0) {
    (*ieee754_ctl->tme_ieee754_ctl_exception)(ieee754_ctl, exceptions);
  }
}

/* this does a unknown compliance extended80-precision sub: */
static void
_tme_ieee754_unknown_extended80_sub(struct tme_ieee754_ctl *ieee754_ctl, const struct tme_float *src0, const struct tme_float *src1, struct tme_float *dst)
{
  int exceptions;

  /* assume that this operation raises no exceptions: */
  exceptions = 0;

  /* the operation: */
  tme_ieee754_extended80_value_builtin_set(dst, TME_FLOAT_FORMAT_IEEE754_EXTENDED80_BUILTIN, tme_ieee754_extended80_value_builtin_get(src0) - tme_ieee754_extended80_value_builtin_get(src1));
  ieee754_ctl->tme_ieee754_ctl_lock_unlock = NULL;

  /* signal any exceptions: */
  if (exceptions != 0) {
    (*ieee754_ctl->tme_ieee754_ctl_exception)(ieee754_ctl, exceptions);
  }
}

/* this does a unknown compliance extended80-precision mul: */
static void
_tme_ieee754_unknown_extended80_mul(struct tme_ieee754_ctl *ieee754_ctl, const struct tme_float *src0, const struct tme_float *src1, struct tme_float *dst)
{
  int exceptions;

  /* assume that this operation raises no exceptions: */
  exceptions = 0;

  /* the operation: */
  tme_ieee754_extended80_value_builtin_set(dst, TME_FLOAT_FORMAT_IEEE754_EXTENDED80_BUILTIN, tme_ieee754_extended80_value_builtin_get(src0) * tme_ieee754_extended80_value_builtin_get(src1));
  ieee754_ctl->tme_ieee754_ctl_lock_unlock = NULL;

  /* signal any exceptions: */
  if (exceptions != 0) {
    (*ieee754_ctl->tme_ieee754_ctl_exception)(ieee754_ctl, exceptions);
  }
}

/* this does a unknown compliance extended80-precision div: */
static void
_tme_ieee754_unknown_extended80_div(struct tme_ieee754_ctl *ieee754_ctl, const struct tme_float *src0, const struct tme_float *src1, struct tme_float *dst)
{
  int exceptions;

  /* assume that this operation raises no exceptions: */
  exceptions = 0;

  /* the operation: */
  tme_ieee754_extended80_value_builtin_set(dst, TME_FLOAT_FORMAT_IEEE754_EXTENDED80_BUILTIN, tme_ieee754_extended80_value_builtin_get(src0) / tme_ieee754_extended80_value_builtin_get(src1));
  ieee754_ctl->tme_ieee754_ctl_lock_unlock = NULL;

  /* signal any exceptions: */
  if (exceptions != 0) {
    (*ieee754_ctl->tme_ieee754_ctl_exception)(ieee754_ctl, exceptions);
  }
}

/* this does a unknown compliance extended80-precision sqrt: */
static void
_tme_ieee754_unknown_extended80_sqrt(struct tme_ieee754_ctl *ieee754_ctl, const struct tme_float *src0, struct tme_float *dst)
{
  int exceptions;

  /* assume that this operation raises no exceptions: */
  exceptions = 0;

  /* the operation: */
#if (TME_FLOAT_FORMAT_IEEE754_EXTENDED80_BUILTIN == TME_FLOAT_FORMAT_FLOAT)
  tme_ieee754_extended80_value_builtin_set(dst, TME_FLOAT_FORMAT_FLOAT, sqrtf(tme_ieee754_extended80_value_builtin_get(src0)));
#else  /* (TME_FLOAT_FORMAT_IEEE754_EXTENDED80_BUILTIN != TME_FLOAT_FORMAT_FLOAT) */
  tme_ieee754_extended80_value_builtin_set(dst, TME_FLOAT_FORMAT_DOUBLE, sqrtl(tme_ieee754_extended80_value_builtin_get(src0)));
#endif /* (TME_FLOAT_FORMAT_IEEE754_EXTENDED80_BUILTIN != TME_FLOAT_FORMAT_FLOAT) */
  ieee754_ctl->tme_ieee754_ctl_lock_unlock = NULL;

  /* signal any exceptions: */
  if (exceptions != 0) {
    (*ieee754_ctl->tme_ieee754_ctl_exception)(ieee754_ctl, exceptions);
  }
}

/* this does a unknown compliance extended80-precision abs: */
static void
_tme_ieee754_unknown_extended80_abs(struct tme_ieee754_ctl *ieee754_ctl, const struct tme_float *src0, struct tme_float *dst)
{
  int exceptions;

  /* assume that this operation raises no exceptions: */
  exceptions = 0;

  /* the operation: */
#if (TME_FLOAT_FORMAT_IEEE754_EXTENDED80_BUILTIN == TME_FLOAT_FORMAT_FLOAT)
  tme_ieee754_extended80_value_builtin_set(dst, TME_FLOAT_FORMAT_FLOAT, fabsf(tme_ieee754_extended80_value_builtin_get(src0)));
#else  /* (TME_FLOAT_FORMAT_IEEE754_EXTENDED80_BUILTIN != TME_FLOAT_FORMAT_FLOAT) */
  tme_ieee754_extended80_value_builtin_set(dst, TME_FLOAT_FORMAT_DOUBLE, fabsl(tme_ieee754_extended80_value_builtin_get(src0)));
#endif /* (TME_FLOAT_FORMAT_IEEE754_EXTENDED80_BUILTIN != TME_FLOAT_FORMAT_FLOAT) */
  ieee754_ctl->tme_ieee754_ctl_lock_unlock = NULL;

  /* signal any exceptions: */
  if (exceptions != 0) {
    (*ieee754_ctl->tme_ieee754_ctl_exception)(ieee754_ctl, exceptions);
  }
}

/* this does a unknown compliance extended80-precision neg: */
static void
_tme_ieee754_unknown_extended80_neg(struct tme_ieee754_ctl *ieee754_ctl, const struct tme_float *src0, struct tme_float *dst)
{
  int exceptions;

  /* assume that this operation raises no exceptions: */
  exceptions = 0;

  /* the operation: */
  tme_ieee754_extended80_value_builtin_set(dst, TME_FLOAT_FORMAT_IEEE754_EXTENDED80_BUILTIN, -1 * tme_ieee754_extended80_value_builtin_get(src0));
  ieee754_ctl->tme_ieee754_ctl_lock_unlock = NULL;

  /* signal any exceptions: */
  if (exceptions != 0) {
    (*ieee754_ctl->tme_ieee754_ctl_exception)(ieee754_ctl, exceptions);
  }
}

/* this does a unknown compliance extended80-precision move: */
static void
_tme_ieee754_unknown_extended80_move(struct tme_ieee754_ctl *ieee754_ctl, const struct tme_float *src0, struct tme_float *dst)
{
  int exceptions;

  /* assume that this operation raises no exceptions: */
  exceptions = 0;

  /* the operation: */
  *dst = *src0;
  ieee754_ctl->tme_ieee754_ctl_lock_unlock = NULL;

  /* signal any exceptions: */
  if (exceptions != 0) {
    (*ieee754_ctl->tme_ieee754_ctl_exception)(ieee754_ctl, exceptions);
  }
}

/* this does a unknown compliance extended80-precision exp: */
static void
_tme_ieee754_unknown_extended80_exp(struct tme_ieee754_ctl *ieee754_ctl, const struct tme_float *src0, struct tme_float *dst)
{
  int exceptions;

  /* assume that this operation raises no exceptions: */
  exceptions = 0;

  /* the operation: */
#if (TME_FLOAT_FORMAT_IEEE754_EXTENDED80_BUILTIN == TME_FLOAT_FORMAT_FLOAT)
  tme_ieee754_extended80_value_builtin_set(dst, TME_FLOAT_FORMAT_FLOAT, expf(tme_ieee754_extended80_value_builtin_get(src0)));
#else  /* (TME_FLOAT_FORMAT_IEEE754_EXTENDED80_BUILTIN != TME_FLOAT_FORMAT_FLOAT) */
  tme_ieee754_extended80_value_builtin_set(dst, TME_FLOAT_FORMAT_DOUBLE, expl(tme_ieee754_extended80_value_builtin_get(src0)));
#endif /* (TME_FLOAT_FORMAT_IEEE754_EXTENDED80_BUILTIN != TME_FLOAT_FORMAT_FLOAT) */
  ieee754_ctl->tme_ieee754_ctl_lock_unlock = NULL;

  /* signal any exceptions: */
  if (exceptions != 0) {
    (*ieee754_ctl->tme_ieee754_ctl_exception)(ieee754_ctl, exceptions);
  }
}

/* this does a unknown compliance extended80-precision log10: */
static void
_tme_ieee754_unknown_extended80_log10(struct tme_ieee754_ctl *ieee754_ctl, const struct tme_float *src0, struct tme_float *dst)
{
  int exceptions;

  /* assume that this operation raises no exceptions: */
  exceptions = 0;

  /* the operation: */
#if (TME_FLOAT_FORMAT_IEEE754_EXTENDED80_BUILTIN == TME_FLOAT_FORMAT_FLOAT)
  tme_ieee754_extended80_value_builtin_set(dst, TME_FLOAT_FORMAT_FLOAT, log10f(tme_ieee754_extended80_value_builtin_get(src0)));
#else  /* (TME_FLOAT_FORMAT_IEEE754_EXTENDED80_BUILTIN != TME_FLOAT_FORMAT_FLOAT) */
  tme_ieee754_extended80_value_builtin_set(dst, TME_FLOAT_FORMAT_DOUBLE, log10l(tme_ieee754_extended80_value_builtin_get(src0)));
#endif /* (TME_FLOAT_FORMAT_IEEE754_EXTENDED80_BUILTIN != TME_FLOAT_FORMAT_FLOAT) */
  ieee754_ctl->tme_ieee754_ctl_lock_unlock = NULL;

  /* signal any exceptions: */
  if (exceptions != 0) {
    (*ieee754_ctl->tme_ieee754_ctl_exception)(ieee754_ctl, exceptions);
  }
}

/* this does a unknown compliance extended80-precision log: */
static void
_tme_ieee754_unknown_extended80_log(struct tme_ieee754_ctl *ieee754_ctl, const struct tme_float *src0, struct tme_float *dst)
{
  int exceptions;

  /* assume that this operation raises no exceptions: */
  exceptions = 0;

  /* the operation: */
#if (TME_FLOAT_FORMAT_IEEE754_EXTENDED80_BUILTIN == TME_FLOAT_FORMAT_FLOAT)
  tme_ieee754_extended80_value_builtin_set(dst, TME_FLOAT_FORMAT_FLOAT, logf(tme_ieee754_extended80_value_builtin_get(src0)));
#else  /* (TME_FLOAT_FORMAT_IEEE754_EXTENDED80_BUILTIN != TME_FLOAT_FORMAT_FLOAT) */
  tme_ieee754_extended80_value_builtin_set(dst, TME_FLOAT_FORMAT_DOUBLE, logl(tme_ieee754_extended80_value_builtin_get(src0)));
#endif /* (TME_FLOAT_FORMAT_IEEE754_EXTENDED80_BUILTIN != TME_FLOAT_FORMAT_FLOAT) */
  ieee754_ctl->tme_ieee754_ctl_lock_unlock = NULL;

  /* signal any exceptions: */
  if (exceptions != 0) {
    (*ieee754_ctl->tme_ieee754_ctl_exception)(ieee754_ctl, exceptions);
  }
}

/* this does a unknown compliance extended80-precision scale: */
static void
_tme_ieee754_unknown_extended80_scale(struct tme_ieee754_ctl *ieee754_ctl, const struct tme_float *src0, const struct tme_float *src1, struct tme_float *dst)
{
  int exceptions;

  /* assume that this operation raises no exceptions: */
  exceptions = 0;

  /* the operation: */
#if (TME_FLOAT_FORMAT_IEEE754_EXTENDED80_BUILTIN == TME_FLOAT_FORMAT_FLOAT)
  tme_ieee754_extended80_value_builtin_set(dst, TME_FLOAT_FORMAT_FLOAT, scalbnf(tme_ieee754_extended80_value_builtin_get(src0), tme_ieee754_extended80_value_builtin_get(src1)));
#else  /* (TME_FLOAT_FORMAT_IEEE754_EXTENDED80_BUILTIN != TME_FLOAT_FORMAT_FLOAT) */
  tme_ieee754_extended80_value_builtin_set(dst, TME_FLOAT_FORMAT_DOUBLE, scalbnl(tme_ieee754_extended80_value_builtin_get(src0), tme_ieee754_extended80_value_builtin_get(src1)));
#endif /* (TME_FLOAT_FORMAT_IEEE754_EXTENDED80_BUILTIN != TME_FLOAT_FORMAT_FLOAT) */
  ieee754_ctl->tme_ieee754_ctl_lock_unlock = NULL;

  /* signal any exceptions: */
  if (exceptions != 0) {
    (*ieee754_ctl->tme_ieee754_ctl_exception)(ieee754_ctl, exceptions);
  }
}

/* this does a unknown compliance extended80-precision pow: */
static void
_tme_ieee754_unknown_extended80_pow(struct tme_ieee754_ctl *ieee754_ctl, const struct tme_float *src0, const struct tme_float *src1, struct tme_float *dst)
{
  int exceptions;

  /* assume that this operation raises no exceptions: */
  exceptions = 0;

  /* the operation: */
#if (TME_FLOAT_FORMAT_IEEE754_EXTENDED80_BUILTIN == TME_FLOAT_FORMAT_FLOAT)
  tme_ieee754_extended80_value_builtin_set(dst, TME_FLOAT_FORMAT_FLOAT, powf(tme_ieee754_extended80_value_builtin_get(src0), tme_ieee754_extended80_value_builtin_get(src1)));
#else  /* (TME_FLOAT_FORMAT_IEEE754_EXTENDED80_BUILTIN != TME_FLOAT_FORMAT_FLOAT) */
  tme_ieee754_extended80_value_builtin_set(dst, TME_FLOAT_FORMAT_DOUBLE, powl(tme_ieee754_extended80_value_builtin_get(src0), tme_ieee754_extended80_value_builtin_get(src1)));
#endif /* (TME_FLOAT_FORMAT_IEEE754_EXTENDED80_BUILTIN != TME_FLOAT_FORMAT_FLOAT) */
  ieee754_ctl->tme_ieee754_ctl_lock_unlock = NULL;

  /* signal any exceptions: */
  if (exceptions != 0) {
    (*ieee754_ctl->tme_ieee754_ctl_exception)(ieee754_ctl, exceptions);
  }
}

/* this does a unknown compliance quad-precision add: */
static void
_tme_ieee754_unknown_quad_add(struct tme_ieee754_ctl *ieee754_ctl, const struct tme_float *src0, const struct tme_float *src1, struct tme_float *dst)
{
  int exceptions;

  /* assume that this operation raises no exceptions: */
  exceptions = 0;

  /* the operation: */
  tme_ieee754_quad_value_builtin_set(dst, TME_FLOAT_FORMAT_IEEE754_QUAD_BUILTIN, tme_ieee754_quad_value_builtin_get(src0) + tme_ieee754_quad_value_builtin_get(src1));
  ieee754_ctl->tme_ieee754_ctl_lock_unlock = NULL;

  /* signal any exceptions: */
  if (exceptions != 0) {
    (*ieee754_ctl->tme_ieee754_ctl_exception)(ieee754_ctl, exceptions);
  }
}

/* this does a unknown compliance quad-precision sub: */
static void
_tme_ieee754_unknown_quad_sub(struct tme_ieee754_ctl *ieee754_ctl, const struct tme_float *src0, const struct tme_float *src1, struct tme_float *dst)
{
  int exceptions;

  /* assume that this operation raises no exceptions: */
  exceptions = 0;

  /* the operation: */
  tme_ieee754_quad_value_builtin_set(dst, TME_FLOAT_FORMAT_IEEE754_QUAD_BUILTIN, tme_ieee754_quad_value_builtin_get(src0) - tme_ieee754_quad_value_builtin_get(src1));
  ieee754_ctl->tme_ieee754_ctl_lock_unlock = NULL;

  /* signal any exceptions: */
  if (exceptions != 0) {
    (*ieee754_ctl->tme_ieee754_ctl_exception)(ieee754_ctl, exceptions);
  }
}

/* this does a unknown compliance quad-precision mul: */
static void
_tme_ieee754_unknown_quad_mul(struct tme_ieee754_ctl *ieee754_ctl, const struct tme_float *src0, const struct tme_float *src1, struct tme_float *dst)
{
  int exceptions;

  /* assume that this operation raises no exceptions: */
  exceptions = 0;

  /* the operation: */
  tme_ieee754_quad_value_builtin_set(dst, TME_FLOAT_FORMAT_IEEE754_QUAD_BUILTIN, tme_ieee754_quad_value_builtin_get(src0) * tme_ieee754_quad_value_builtin_get(src1));
  ieee754_ctl->tme_ieee754_ctl_lock_unlock = NULL;

  /* signal any exceptions: */
  if (exceptions != 0) {
    (*ieee754_ctl->tme_ieee754_ctl_exception)(ieee754_ctl, exceptions);
  }
}

/* this does a unknown compliance quad-precision div: */
static void
_tme_ieee754_unknown_quad_div(struct tme_ieee754_ctl *ieee754_ctl, const struct tme_float *src0, const struct tme_float *src1, struct tme_float *dst)
{
  int exceptions;

  /* assume that this operation raises no exceptions: */
  exceptions = 0;

  /* the operation: */
  tme_ieee754_quad_value_builtin_set(dst, TME_FLOAT_FORMAT_IEEE754_QUAD_BUILTIN, tme_ieee754_quad_value_builtin_get(src0) / tme_ieee754_quad_value_builtin_get(src1));
  ieee754_ctl->tme_ieee754_ctl_lock_unlock = NULL;

  /* signal any exceptions: */
  if (exceptions != 0) {
    (*ieee754_ctl->tme_ieee754_ctl_exception)(ieee754_ctl, exceptions);
  }
}

/* this does a unknown compliance quad-precision sqrt: */
static void
_tme_ieee754_unknown_quad_sqrt(struct tme_ieee754_ctl *ieee754_ctl, const struct tme_float *src0, struct tme_float *dst)
{
  int exceptions;

  /* assume that this operation raises no exceptions: */
  exceptions = 0;

  /* the operation: */
#if (TME_FLOAT_FORMAT_IEEE754_QUAD_BUILTIN == TME_FLOAT_FORMAT_FLOAT)
  tme_ieee754_quad_value_builtin_set(dst, TME_FLOAT_FORMAT_FLOAT, sqrtf(tme_ieee754_quad_value_builtin_get(src0)));
#else  /* (TME_FLOAT_FORMAT_IEEE754_QUAD_BUILTIN != TME_FLOAT_FORMAT_FLOAT) */
  tme_ieee754_quad_value_builtin_set(dst, TME_FLOAT_FORMAT_DOUBLE, sqrtl(tme_ieee754_quad_value_builtin_get(src0)));
#endif /* (TME_FLOAT_FORMAT_IEEE754_QUAD_BUILTIN != TME_FLOAT_FORMAT_FLOAT) */
  ieee754_ctl->tme_ieee754_ctl_lock_unlock = NULL;

  /* signal any exceptions: */
  if (exceptions != 0) {
    (*ieee754_ctl->tme_ieee754_ctl_exception)(ieee754_ctl, exceptions);
  }
}

/* this does a unknown compliance quad-precision abs: */
static void
_tme_ieee754_unknown_quad_abs(struct tme_ieee754_ctl *ieee754_ctl, const struct tme_float *src0, struct tme_float *dst)
{
  int exceptions;

  /* assume that this operation raises no exceptions: */
  exceptions = 0;

  /* the operation: */
#if (TME_FLOAT_FORMAT_IEEE754_QUAD_BUILTIN == TME_FLOAT_FORMAT_FLOAT)
  tme_ieee754_quad_value_builtin_set(dst, TME_FLOAT_FORMAT_FLOAT, fabsf(tme_ieee754_quad_value_builtin_get(src0)));
#else  /* (TME_FLOAT_FORMAT_IEEE754_QUAD_BUILTIN != TME_FLOAT_FORMAT_FLOAT) */
  tme_ieee754_quad_value_builtin_set(dst, TME_FLOAT_FORMAT_DOUBLE, fabsl(tme_ieee754_quad_value_builtin_get(src0)));
#endif /* (TME_FLOAT_FORMAT_IEEE754_QUAD_BUILTIN != TME_FLOAT_FORMAT_FLOAT) */
  ieee754_ctl->tme_ieee754_ctl_lock_unlock = NULL;

  /* signal any exceptions: */
  if (exceptions != 0) {
    (*ieee754_ctl->tme_ieee754_ctl_exception)(ieee754_ctl, exceptions);
  }
}

/* this does a unknown compliance quad-precision neg: */
static void
_tme_ieee754_unknown_quad_neg(struct tme_ieee754_ctl *ieee754_ctl, const struct tme_float *src0, struct tme_float *dst)
{
  int exceptions;

  /* assume that this operation raises no exceptions: */
  exceptions = 0;

  /* the operation: */
  tme_ieee754_quad_value_builtin_set(dst, TME_FLOAT_FORMAT_IEEE754_QUAD_BUILTIN, -1 * tme_ieee754_quad_value_builtin_get(src0));
  ieee754_ctl->tme_ieee754_ctl_lock_unlock = NULL;

  /* signal any exceptions: */
  if (exceptions != 0) {
    (*ieee754_ctl->tme_ieee754_ctl_exception)(ieee754_ctl, exceptions);
  }
}

/* this does a unknown compliance quad-precision move: */
static void
_tme_ieee754_unknown_quad_move(struct tme_ieee754_ctl *ieee754_ctl, const struct tme_float *src0, struct tme_float *dst)
{
  int exceptions;

  /* assume that this operation raises no exceptions: */
  exceptions = 0;

  /* the operation: */
  *dst = *src0;
  ieee754_ctl->tme_ieee754_ctl_lock_unlock = NULL;

  /* signal any exceptions: */
  if (exceptions != 0) {
    (*ieee754_ctl->tme_ieee754_ctl_exception)(ieee754_ctl, exceptions);
  }
}

/* this does a unknown compliance quad-precision exp: */
static void
_tme_ieee754_unknown_quad_exp(struct tme_ieee754_ctl *ieee754_ctl, const struct tme_float *src0, struct tme_float *dst)
{
  int exceptions;

  /* assume that this operation raises no exceptions: */
  exceptions = 0;

  /* the operation: */
#if (TME_FLOAT_FORMAT_IEEE754_QUAD_BUILTIN == TME_FLOAT_FORMAT_FLOAT)
  tme_ieee754_quad_value_builtin_set(dst, TME_FLOAT_FORMAT_FLOAT, expf(tme_ieee754_quad_value_builtin_get(src0)));
#else  /* (TME_FLOAT_FORMAT_IEEE754_QUAD_BUILTIN != TME_FLOAT_FORMAT_FLOAT) */
  tme_ieee754_quad_value_builtin_set(dst, TME_FLOAT_FORMAT_DOUBLE, expl(tme_ieee754_quad_value_builtin_get(src0)));
#endif /* (TME_FLOAT_FORMAT_IEEE754_QUAD_BUILTIN != TME_FLOAT_FORMAT_FLOAT) */
  ieee754_ctl->tme_ieee754_ctl_lock_unlock = NULL;

  /* signal any exceptions: */
  if (exceptions != 0) {
    (*ieee754_ctl->tme_ieee754_ctl_exception)(ieee754_ctl, exceptions);
  }
}

/* this does a unknown compliance quad-precision log10: */
static void
_tme_ieee754_unknown_quad_log10(struct tme_ieee754_ctl *ieee754_ctl, const struct tme_float *src0, struct tme_float *dst)
{
  int exceptions;

  /* assume that this operation raises no exceptions: */
  exceptions = 0;

  /* the operation: */
#if (TME_FLOAT_FORMAT_IEEE754_QUAD_BUILTIN == TME_FLOAT_FORMAT_FLOAT)
  tme_ieee754_quad_value_builtin_set(dst, TME_FLOAT_FORMAT_FLOAT, log10f(tme_ieee754_quad_value_builtin_get(src0)));
#else  /* (TME_FLOAT_FORMAT_IEEE754_QUAD_BUILTIN != TME_FLOAT_FORMAT_FLOAT) */
  tme_ieee754_quad_value_builtin_set(dst, TME_FLOAT_FORMAT_DOUBLE, log10l(tme_ieee754_quad_value_builtin_get(src0)));
#endif /* (TME_FLOAT_FORMAT_IEEE754_QUAD_BUILTIN != TME_FLOAT_FORMAT_FLOAT) */
  ieee754_ctl->tme_ieee754_ctl_lock_unlock = NULL;

  /* signal any exceptions: */
  if (exceptions != 0) {
    (*ieee754_ctl->tme_ieee754_ctl_exception)(ieee754_ctl, exceptions);
  }
}

/* this does a unknown compliance quad-precision log: */
static void
_tme_ieee754_unknown_quad_log(struct tme_ieee754_ctl *ieee754_ctl, const struct tme_float *src0, struct tme_float *dst)
{
  int exceptions;

  /* assume that this operation raises no exceptions: */
  exceptions = 0;

  /* the operation: */
#if (TME_FLOAT_FORMAT_IEEE754_QUAD_BUILTIN == TME_FLOAT_FORMAT_FLOAT)
  tme_ieee754_quad_value_builtin_set(dst, TME_FLOAT_FORMAT_FLOAT, logf(tme_ieee754_quad_value_builtin_get(src0)));
#else  /* (TME_FLOAT_FORMAT_IEEE754_QUAD_BUILTIN != TME_FLOAT_FORMAT_FLOAT) */
  tme_ieee754_quad_value_builtin_set(dst, TME_FLOAT_FORMAT_DOUBLE, logl(tme_ieee754_quad_value_builtin_get(src0)));
#endif /* (TME_FLOAT_FORMAT_IEEE754_QUAD_BUILTIN != TME_FLOAT_FORMAT_FLOAT) */
  ieee754_ctl->tme_ieee754_ctl_lock_unlock = NULL;

  /* signal any exceptions: */
  if (exceptions != 0) {
    (*ieee754_ctl->tme_ieee754_ctl_exception)(ieee754_ctl, exceptions);
  }
}

/* this does a unknown compliance quad-precision scale: */
static void
_tme_ieee754_unknown_quad_scale(struct tme_ieee754_ctl *ieee754_ctl, const struct tme_float *src0, const struct tme_float *src1, struct tme_float *dst)
{
  int exceptions;

  /* assume that this operation raises no exceptions: */
  exceptions = 0;

  /* the operation: */
#if (TME_FLOAT_FORMAT_IEEE754_QUAD_BUILTIN == TME_FLOAT_FORMAT_FLOAT)
  tme_ieee754_quad_value_builtin_set(dst, TME_FLOAT_FORMAT_FLOAT, scalbnf(tme_ieee754_quad_value_builtin_get(src0), tme_ieee754_quad_value_builtin_get(src1)));
#else  /* (TME_FLOAT_FORMAT_IEEE754_QUAD_BUILTIN != TME_FLOAT_FORMAT_FLOAT) */
  tme_ieee754_quad_value_builtin_set(dst, TME_FLOAT_FORMAT_DOUBLE, scalbnl(tme_ieee754_quad_value_builtin_get(src0), tme_ieee754_quad_value_builtin_get(src1)));
#endif /* (TME_FLOAT_FORMAT_IEEE754_QUAD_BUILTIN != TME_FLOAT_FORMAT_FLOAT) */
  ieee754_ctl->tme_ieee754_ctl_lock_unlock = NULL;

  /* signal any exceptions: */
  if (exceptions != 0) {
    (*ieee754_ctl->tme_ieee754_ctl_exception)(ieee754_ctl, exceptions);
  }
}

/* this does a unknown compliance quad-precision pow: */
static void
_tme_ieee754_unknown_quad_pow(struct tme_ieee754_ctl *ieee754_ctl, const struct tme_float *src0, const struct tme_float *src1, struct tme_float *dst)
{
  int exceptions;

  /* assume that this operation raises no exceptions: */
  exceptions = 0;

  /* the operation: */
#if (TME_FLOAT_FORMAT_IEEE754_QUAD_BUILTIN == TME_FLOAT_FORMAT_FLOAT)
  tme_ieee754_quad_value_builtin_set(dst, TME_FLOAT_FORMAT_FLOAT, powf(tme_ieee754_quad_value_builtin_get(src0), tme_ieee754_quad_value_builtin_get(src1)));
#else  /* (TME_FLOAT_FORMAT_IEEE754_QUAD_BUILTIN != TME_FLOAT_FORMAT_FLOAT) */
  tme_ieee754_quad_value_builtin_set(dst, TME_FLOAT_FORMAT_DOUBLE, powl(tme_ieee754_quad_value_builtin_get(src0), tme_ieee754_quad_value_builtin_get(src1)));
#endif /* (TME_FLOAT_FORMAT_IEEE754_QUAD_BUILTIN != TME_FLOAT_FORMAT_FLOAT) */
  ieee754_ctl->tme_ieee754_ctl_lock_unlock = NULL;

  /* signal any exceptions: */
  if (exceptions != 0) {
    (*ieee754_ctl->tme_ieee754_ctl_exception)(ieee754_ctl, exceptions);
  }
}

/* the unknown compliance operations: */
_tme_const struct tme_ieee754_ops tme_ieee754_ops_unknown = {

  /* the version of this structure: */
  TME_X_VERSION(0, 0),

  /* this does a unknown compliance single-precision add: */
  _tme_ieee754_unknown_single_add,

  /* this does a unknown compliance single-precision sub: */
  _tme_ieee754_unknown_single_sub,

  /* this does a unknown compliance single-precision mul: */
  _tme_ieee754_unknown_single_mul,

  /* this does a unknown compliance single-precision div: */
  _tme_ieee754_unknown_single_div,

  /* this does a unknown compliance single-precision rem: */
  _tme_ieee754_strict_single_rem,

  /* this does a unknown compliance single-precision sqrt: */
  _tme_ieee754_unknown_single_sqrt,

  /* this does a unknown compliance single-precision abs: */
  _tme_ieee754_unknown_single_abs,

  /* this does a unknown compliance single-precision neg: */
  _tme_ieee754_unknown_single_neg,

  /* this does a unknown compliance single-precision move: */
  _tme_ieee754_unknown_single_move,

  /* this does a unknown compliance single-precision rint: */
  _tme_ieee754_strict_single_rint,

  /* this does a unknown compliance single-precision cos: */
  NULL,

  /* this does a unknown compliance single-precision acos: */
  NULL,

  /* this does a unknown compliance single-precision cosh: */
  NULL,

  /* this does a unknown compliance single-precision sin: */
  NULL,

  /* this does a unknown compliance single-precision asin: */
  NULL,

  /* this does a unknown compliance single-precision sinh: */
  NULL,

  /* this does a unknown compliance single-precision tan: */
  NULL,

  /* this does a unknown compliance single-precision atan: */
  NULL,

  /* this does a unknown compliance single-precision tanh: */
  NULL,

  /* this does a unknown compliance single-precision atanh: */
  NULL,

  /* this does a unknown compliance single-precision exp: */
  _tme_ieee754_unknown_single_exp,

  /* this does a unknown compliance single-precision expm1: */
  NULL,

  /* this does a unknown compliance single-precision log10: */
  _tme_ieee754_unknown_single_log10,

  /* this does a unknown compliance single-precision log: */
  _tme_ieee754_unknown_single_log,

  /* this does a unknown compliance single-precision log1p: */
  NULL,

  /* this does a unknown compliance single-precision getexp: */
  _tme_ieee754_strict_single_getexp,

  /* this does a unknown compliance single-precision getman: */
  _tme_ieee754_strict_single_getman,

  /* this does a unknown compliance single-precision scale: */
  _tme_ieee754_unknown_single_scale,

  /* this does a unknown compliance single-precision pow: */
  _tme_ieee754_unknown_single_pow,

  /* this does a unknown compliance single-precision from_double: */
  _tme_ieee754_strict_single_from_double,

  /* this does a unknown compliance single-precision from_extended80: */
  _tme_ieee754_strict_single_from_extended80,

  /* this does a unknown compliance single-precision from_quad: */
  _tme_ieee754_strict_single_from_quad,

  /* this does a unknown compliance single-precision from_int32: */
  _tme_ieee754_strict_single_from_int32,

  /* this does a unknown compliance single-precision from_int64: */
#if (defined(TME_HAVE_INT64_T))
  _tme_ieee754_strict_single_from_int64,
#else  /* !(defined(TME_HAVE_INT64_T)) */
  NULL,
#endif /* !(defined(TME_HAVE_INT64_T)) */

  /* this does a unknown compliance single-precision to_int32: */
  _tme_ieee754_strict_single_to_int32,

  /* this does a unknown compliance single-precision to_int64: */
#if (defined(TME_HAVE_INT64_T))
  _tme_ieee754_strict_single_to_int64,
#else  /* !(defined(TME_HAVE_INT64_T)) */
  NULL,
#endif /* !(defined(TME_HAVE_INT64_T)) */

  /* this does a unknown compliance double-precision add: */
  _tme_ieee754_unknown_double_add,

  /* this does a unknown compliance double-precision sub: */
  _tme_ieee754_unknown_double_sub,

  /* this does a unknown compliance double-precision mul: */
  _tme_ieee754_unknown_double_mul,

  /* this does a unknown compliance double-precision div: */
  _tme_ieee754_unknown_double_div,

  /* this does a unknown compliance double-precision rem: */
  _tme_ieee754_strict_double_rem,

  /* this does a unknown compliance double-precision sqrt: */
  _tme_ieee754_unknown_double_sqrt,

  /* this does a unknown compliance double-precision abs: */
  _tme_ieee754_unknown_double_abs,

  /* this does a unknown compliance double-precision neg: */
  _tme_ieee754_unknown_double_neg,

  /* this does a unknown compliance double-precision move: */
  _tme_ieee754_unknown_double_move,

  /* this does a unknown compliance double-precision rint: */
  _tme_ieee754_strict_double_rint,

  /* this does a unknown compliance double-precision cos: */
  NULL,

  /* this does a unknown compliance double-precision acos: */
  NULL,

  /* this does a unknown compliance double-precision cosh: */
  NULL,

  /* this does a unknown compliance double-precision sin: */
  NULL,

  /* this does a unknown compliance double-precision asin: */
  NULL,

  /* this does a unknown compliance double-precision sinh: */
  NULL,

  /* this does a unknown compliance double-precision tan: */
  NULL,

  /* this does a unknown compliance double-precision atan: */
  NULL,

  /* this does a unknown compliance double-precision tanh: */
  NULL,

  /* this does a unknown compliance double-precision atanh: */
  NULL,

  /* this does a unknown compliance double-precision exp: */
  _tme_ieee754_unknown_double_exp,

  /* this does a unknown compliance double-precision expm1: */
  NULL,

  /* this does a unknown compliance double-precision log10: */
  _tme_ieee754_unknown_double_log10,

  /* this does a unknown compliance double-precision log: */
  _tme_ieee754_unknown_double_log,

  /* this does a unknown compliance double-precision log1p: */
  NULL,

  /* this does a unknown compliance double-precision getexp: */
  _tme_ieee754_strict_double_getexp,

  /* this does a unknown compliance double-precision getman: */
  _tme_ieee754_strict_double_getman,

  /* this does a unknown compliance double-precision scale: */
  _tme_ieee754_unknown_double_scale,

  /* this does a unknown compliance double-precision pow: */
  _tme_ieee754_unknown_double_pow,

  /* this does a unknown compliance double-precision from_single: */
  _tme_ieee754_strict_double_from_single,

  /* this does a unknown compliance double-precision from_extended80: */
  _tme_ieee754_strict_double_from_extended80,

  /* this does a unknown compliance double-precision from_quad: */
  _tme_ieee754_strict_double_from_quad,

  /* this does a unknown compliance double-precision from_int32: */
  _tme_ieee754_strict_double_from_int32,

  /* this does a unknown compliance double-precision from_int64: */
#if (defined(TME_HAVE_INT64_T))
  _tme_ieee754_strict_double_from_int64,
#else  /* !(defined(TME_HAVE_INT64_T)) */
  NULL,
#endif /* !(defined(TME_HAVE_INT64_T)) */

  /* this does a unknown compliance double-precision to_int32: */
  _tme_ieee754_strict_double_to_int32,

  /* this does a unknown compliance double-precision to_int64: */
#if (defined(TME_HAVE_INT64_T))
  _tme_ieee754_strict_double_to_int64,
#else  /* !(defined(TME_HAVE_INT64_T)) */
  NULL,
#endif /* !(defined(TME_HAVE_INT64_T)) */

  /* this does a unknown compliance extended80-precision add: */
  _tme_ieee754_unknown_extended80_add,

  /* this does a unknown compliance extended80-precision sub: */
  _tme_ieee754_unknown_extended80_sub,

  /* this does a unknown compliance extended80-precision mul: */
  _tme_ieee754_unknown_extended80_mul,

  /* this does a unknown compliance extended80-precision div: */
  _tme_ieee754_unknown_extended80_div,

  /* this does a unknown compliance extended80-precision rem: */
#if (defined(TME_HAVE_INT64_T))
  _tme_ieee754_strict_extended80_rem,
#else  /* !(defined(TME_HAVE_INT64_T)) */
  NULL,
#endif /* !(defined(TME_HAVE_INT64_T)) */

  /* this does a unknown compliance extended80-precision sqrt: */
  _tme_ieee754_unknown_extended80_sqrt,

  /* this does a unknown compliance extended80-precision abs: */
  _tme_ieee754_unknown_extended80_abs,

  /* this does a unknown compliance extended80-precision neg: */
  _tme_ieee754_unknown_extended80_neg,

  /* this does a unknown compliance extended80-precision move: */
  _tme_ieee754_unknown_extended80_move,

  /* this does a unknown compliance extended80-precision rint: */
#if (defined(TME_HAVE_INT64_T))
  _tme_ieee754_strict_extended80_rint,
#else  /* !(defined(TME_HAVE_INT64_T)) */
  NULL,
#endif /* !(defined(TME_HAVE_INT64_T)) */

  /* this does a unknown compliance extended80-precision cos: */
  NULL,

  /* this does a unknown compliance extended80-precision acos: */
  NULL,

  /* this does a unknown compliance extended80-precision cosh: */
  NULL,

  /* this does a unknown compliance extended80-precision sin: */
  NULL,

  /* this does a unknown compliance extended80-precision asin: */
  NULL,

  /* this does a unknown compliance extended80-precision sinh: */
  NULL,

  /* this does a unknown compliance extended80-precision tan: */
  NULL,

  /* this does a unknown compliance extended80-precision atan: */
  NULL,

  /* this does a unknown compliance extended80-precision tanh: */
  NULL,

  /* this does a unknown compliance extended80-precision atanh: */
  NULL,

  /* this does a unknown compliance extended80-precision exp: */
  _tme_ieee754_unknown_extended80_exp,

  /* this does a unknown compliance extended80-precision expm1: */
  NULL,

  /* this does a unknown compliance extended80-precision log10: */
  _tme_ieee754_unknown_extended80_log10,

  /* this does a unknown compliance extended80-precision log: */
  _tme_ieee754_unknown_extended80_log,

  /* this does a unknown compliance extended80-precision log1p: */
  NULL,

  /* this does a unknown compliance extended80-precision getexp: */
  _tme_ieee754_strict_extended80_getexp,

  /* this does a unknown compliance extended80-precision getman: */
  _tme_ieee754_strict_extended80_getman,

  /* this does a unknown compliance extended80-precision scale: */
  _tme_ieee754_unknown_extended80_scale,

  /* this does a unknown compliance extended80-precision pow: */
  _tme_ieee754_unknown_extended80_pow,

  /* this does a unknown compliance extended80-precision from_single: */
#if (defined(TME_HAVE_INT64_T))
  _tme_ieee754_strict_extended80_from_single,
#else  /* !(defined(TME_HAVE_INT64_T)) */
  NULL,
#endif /* !(defined(TME_HAVE_INT64_T)) */

  /* this does a unknown compliance extended80-precision from_double: */
#if (defined(TME_HAVE_INT64_T))
  _tme_ieee754_strict_extended80_from_double,
#else  /* !(defined(TME_HAVE_INT64_T)) */
  NULL,
#endif /* !(defined(TME_HAVE_INT64_T)) */

  /* this does a unknown compliance extended80-precision from_quad: */
#if (defined(TME_HAVE_INT64_T))
  _tme_ieee754_strict_extended80_from_quad,
#else  /* !(defined(TME_HAVE_INT64_T)) */
  NULL,
#endif /* !(defined(TME_HAVE_INT64_T)) */

  /* this does a unknown compliance extended80-precision from_int32: */
#if (defined(TME_HAVE_INT64_T))
  _tme_ieee754_strict_extended80_from_int32,
#else  /* !(defined(TME_HAVE_INT64_T)) */
  NULL,
#endif /* !(defined(TME_HAVE_INT64_T)) */

  /* this does a unknown compliance extended80-precision from_int64: */
#if (defined(TME_HAVE_INT64_T))
  _tme_ieee754_strict_extended80_from_int64,
#else  /* !(defined(TME_HAVE_INT64_T)) */
  NULL,
#endif /* !(defined(TME_HAVE_INT64_T)) */

  /* this does a unknown compliance extended80-precision to_int32: */
  _tme_ieee754_strict_extended80_to_int32,

  /* this does a unknown compliance extended80-precision to_int64: */
#if (defined(TME_HAVE_INT64_T))
  _tme_ieee754_strict_extended80_to_int64,
#else  /* !(defined(TME_HAVE_INT64_T)) */
  NULL,
#endif /* !(defined(TME_HAVE_INT64_T)) */

  /* this does a unknown compliance quad-precision add: */
  _tme_ieee754_unknown_quad_add,

  /* this does a unknown compliance quad-precision sub: */
  _tme_ieee754_unknown_quad_sub,

  /* this does a unknown compliance quad-precision mul: */
  _tme_ieee754_unknown_quad_mul,

  /* this does a unknown compliance quad-precision div: */
  _tme_ieee754_unknown_quad_div,

  /* this does a unknown compliance quad-precision rem: */
#if (defined(TME_HAVE_INT64_T))
  _tme_ieee754_strict_quad_rem,
#else  /* !(defined(TME_HAVE_INT64_T)) */
  NULL,
#endif /* !(defined(TME_HAVE_INT64_T)) */

  /* this does a unknown compliance quad-precision sqrt: */
  _tme_ieee754_unknown_quad_sqrt,

  /* this does a unknown compliance quad-precision abs: */
  _tme_ieee754_unknown_quad_abs,

  /* this does a unknown compliance quad-precision neg: */
  _tme_ieee754_unknown_quad_neg,

  /* this does a unknown compliance quad-precision move: */
  _tme_ieee754_unknown_quad_move,

  /* this does a unknown compliance quad-precision rint: */
#if (defined(TME_HAVE_INT64_T))
  _tme_ieee754_strict_quad_rint,
#else  /* !(defined(TME_HAVE_INT64_T)) */
  NULL,
#endif /* !(defined(TME_HAVE_INT64_T)) */

  /* this does a unknown compliance quad-precision cos: */
  NULL,

  /* this does a unknown compliance quad-precision acos: */
  NULL,

  /* this does a unknown compliance quad-precision cosh: */
  NULL,

  /* this does a unknown compliance quad-precision sin: */
  NULL,

  /* this does a unknown compliance quad-precision asin: */
  NULL,

  /* this does a unknown compliance quad-precision sinh: */
  NULL,

  /* this does a unknown compliance quad-precision tan: */
  NULL,

  /* this does a unknown compliance quad-precision atan: */
  NULL,

  /* this does a unknown compliance quad-precision tanh: */
  NULL,

  /* this does a unknown compliance quad-precision atanh: */
  NULL,

  /* this does a unknown compliance quad-precision exp: */
  _tme_ieee754_unknown_quad_exp,

  /* this does a unknown compliance quad-precision expm1: */
  NULL,

  /* this does a unknown compliance quad-precision log10: */
  _tme_ieee754_unknown_quad_log10,

  /* this does a unknown compliance quad-precision log: */
  _tme_ieee754_unknown_quad_log,

  /* this does a unknown compliance quad-precision log1p: */
  NULL,

  /* this does a unknown compliance quad-precision getexp: */
  _tme_ieee754_strict_quad_getexp,

  /* this does a unknown compliance quad-precision getman: */
  _tme_ieee754_strict_quad_getman,

  /* this does a unknown compliance quad-precision scale: */
  _tme_ieee754_unknown_quad_scale,

  /* this does a unknown compliance quad-precision pow: */
  _tme_ieee754_unknown_quad_pow,

  /* this does a unknown compliance quad-precision from_single: */
#if (defined(TME_HAVE_INT64_T))
  _tme_ieee754_strict_quad_from_single,
#else  /* !(defined(TME_HAVE_INT64_T)) */
  NULL,
#endif /* !(defined(TME_HAVE_INT64_T)) */

  /* this does a unknown compliance quad-precision from_double: */
#if (defined(TME_HAVE_INT64_T))
  _tme_ieee754_strict_quad_from_double,
#else  /* !(defined(TME_HAVE_INT64_T)) */
  NULL,
#endif /* !(defined(TME_HAVE_INT64_T)) */

  /* this does a unknown compliance quad-precision from_extended80: */
#if (defined(TME_HAVE_INT64_T))
  _tme_ieee754_strict_quad_from_extended80,
#else  /* !(defined(TME_HAVE_INT64_T)) */
  NULL,
#endif /* !(defined(TME_HAVE_INT64_T)) */

  /* this does a unknown compliance quad-precision from_int32: */
#if (defined(TME_HAVE_INT64_T))
  _tme_ieee754_strict_quad_from_int32,
#else  /* !(defined(TME_HAVE_INT64_T)) */
  NULL,
#endif /* !(defined(TME_HAVE_INT64_T)) */

  /* this does a unknown compliance quad-precision from_int64: */
#if (defined(TME_HAVE_INT64_T))
  _tme_ieee754_strict_quad_from_int64,
#else  /* !(defined(TME_HAVE_INT64_T)) */
  NULL,
#endif /* !(defined(TME_HAVE_INT64_T)) */

  /* this does a unknown compliance quad-precision to_int32: */
  _tme_ieee754_strict_quad_to_int32,

  /* this does a unknown compliance quad-precision to_int64: */
#if (defined(TME_HAVE_INT64_T))
  _tme_ieee754_strict_quad_to_int64,
#else  /* !(defined(TME_HAVE_INT64_T)) */
  NULL,
#endif /* !(defined(TME_HAVE_INT64_T)) */
};

/* this looks up an operations structure: */
const struct tme_ieee754_ops *
tme_ieee754_ops_lookup(const char *compliance)
{

  if (TME_ARG_IS(compliance, "strict")) { 
    return (&tme_ieee754_ops_strict);
  }
  if (TME_ARG_IS(compliance, "partial")) { 
    return (&tme_ieee754_ops_partial);
  }
  if (TME_ARG_IS(compliance, "unknown")) { 
    return (&tme_ieee754_ops_unknown);
  }
  return (NULL);
}

/* this is a compliance options string: */
const char * const tme_ieee754_compliance_options = "{ strict | partial | unknown }";
