/*
 * Copyright (c) 2008-2026 Jonathan Schleifer <js@nil.im>
 *
 * All rights reserved.
 *
 * This program is free software: you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License version 3.0 only,
 * as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License
 * version 3.0 for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * version 3.0 along with this program. If not, see
 * <https://www.gnu.org/licenses/>.
 */

#include "config.h"

#import "OHGameControllerElement.h"
#import "OHGameControllerElement+Private.h"

@implementation OHGameControllerElement
@synthesize name = _name, analog = _analog;

+ (instancetype)oh_elementWithName: (OFString *)name analog: (bool)analog
{
	return objc_autoreleaseReturnValue(
	    [[self alloc] oh_initWithName: name
				   analog: analog]);
}

- (instancetype)init
{
	OF_INVALID_INIT_METHOD
}

- (instancetype)oh_initWithName: (OFString *)name analog: (bool)analog
{
	self = [super init];

	@try {
		_name = [name copy];
		_analog = analog;
	} @catch (id e) {
		objc_release(self);
		@throw e;
	}

	return self;
}

- (void)dealloc
{
	objc_release(_name);

	[super dealloc];
}
@end
