#version 110

uniform mat4 worldViewProj;
uniform vec4 texelOffsets;
uniform vec4 inColor;

attribute vec4 position;
varying vec4 oColor;
varying vec2 oDepth;

void main()
{
  vec4 pos = worldViewProj * position;  
  pos.xy += texelOffsets.zw * pos.w;  
  gl_Position = pos;

  oColor = inColor;
  oDepth = pos.zw; 
}
