#version 120

varying vec2 uv;

uniform vec4 screenSize;
uniform sampler2D LeftTex;
uniform sampler2D RightTex;

void main()
{
	vec2 p = step(0.5, fract(uv * screenSize.xy * 0.5));
	vec4 left = texture2D(LeftTex, uv);
	vec4 right = texture2D(RightTex, uv);
	
	p.y = 1.0;
	
	float f = 0.0;
	if (p.x == p.y)
	  f = 1.0;
	
	// 1-abs(p.x-p.y)
	gl_FragColor = mix(left, right, vec4(f));
}