#version 120

uniform vec2 LensCentre;
uniform vec2 Scale;
uniform vec2 ScaleIn;
uniform vec4 HmdWarpParam;

// Scales input texture coordinates for distortion.
vec2 HmdWarp(vec2 in01)
{
	vec2 theta = (in01 - LensCentre) * ScaleIn; // Scales to [-1, 1]
	float rSq = theta.x * theta.x + theta.y * theta.y;
	vec2 rvector = theta * (HmdWarpParam.x + HmdWarpParam.y * rSq + HmdWarpParam.z * rSq * rSq + HmdWarpParam.w * rSq * rSq * rSq);
	return LensCentre + Scale * rvector;
}

varying vec2 uv;
uniform sampler2D RT;

void main()
{
	vec2 tc = HmdWarp(uv);
  
  float vignette = clamp((min(min(tc.x, 1-tc.x), min(tc.y, 1-tc.y)) / 0.03), 0.0, 1.0);
  gl_FragColor = mix(vec4(0.0, 0.0, 0.0 ,1.0), vec4(texture2D(RT, tc).xyz, 1.0), vec4(vignette, vignette, vignette, 1.0));
}
