<!-- SPDX-License-Identifier: CC-BY-4.0 -->
<!-- Copyright Contributors to the OpenColorIO Project. -->

April 8, 2019

Host: Michael Dolan

Rotating Secretary: Doug Walker (Carl will do next week)

Attendees:
  * [ ] Mark Boorer (_TSC_) - Industrial Light & Magic
  * [ ] Sean Cooper (_TSC_) - DNEG
  * [X] Michael Dolan (_TSC Chair_) - Sony Pictures Imageworks
  * [X] Larry Gritz (_TSC_) - Sony Pictures Imageworks
  * [X] Patrick Hodoul (_TSC_) - Autodesk
  * [ ] John Mertic - Academy Software Foundation / Linux Foundation
  * [X] Carl Rand (_TSC_) - Foundry
  * [X] Doug Walker (_TSC Chief Architect_) - Autodesk
  * [X] Kevin Wheatley (_TSC_) - Framestore
  * [X] Bernard Lefebvre - Autodesk

# **OCIO TSC Meeting Notes**

* ASWF Intake checklist open items -- License scan
    - No update on ext/ reorg project.
    - Michael: Wrote Alex to see if we can change the license for the ACES config.
    - Was agreement that we could avoid migrating the older configs to avoid the CTL issue.
        - Michael: CTL was not just a copy of AMPAS repo, was edited.

* ASWF Intake checklist open items -- CII badge -- Documentation
    - Items for badge:
        - SHOULD add/link coding standards to CONTRIBUTING.md
        - MUST publish process for reporting vulnerabilities on project site
        - MUST provide method for reporting private vulnerabilities
        - SUGGESTS documenting policy on adding tests
    - Larry: I've been super happy using clang format on OIIO.
        - It's set up to break the build for format violations.
        - Turned it off on a few files to handle special cases.
    - Discussion of adopting it for OCIO.
    - Patrick: Need to wait for a period where we don't have lots of PRs waiting to merge.
        - Larry: Could do it as we get close to the v2 release, during stabilization.
    - One issue is that it messes up Git blame/history.
        - Carl: Perhaps create a tag just before the reformat.
    - OCIO is not entirely consistent in following its own style guidelines.
    - Could experiment with using clang format on new code.

* ASWF Intake checklist open items -- CII badge -- Discussion items
    - Items for badge:
        - MUST include interim version for review between releases
        - Test suite SHOULD cover all code, branches, functionality
        - MUST enable warning flags, safe mode, or linter tool for quality checks
        - MUST address most warnings 
        - SUGGESTED to be maximally strict with warnings
    - We agreed that the interpretation of the first item is that development must happen in the public repo.
    - We agreed to require unit tests on new PRs going forward.
        - However won't insist on 100% coverage, just the main functionality.
    - Larry: badge requirements on testing are "should" rather than "must".
    - Autodesk has put a lot of focus on testing and all the v2 PRs have tests.
        - In some cases even more tests exist but depend on forthcoming PRs (TODOs in code).
    - However, there are parts of the v1 code base which have either no or minimal coverage.
    - Patrick has been working on enabling warnings, Linux almost working, Windows needs work.
    - Autodesk has been trying to address new warnings reported on Slack, etc.

* ASWF Intake checklist open items -- CII badge -- Security
    - For security, we don't have experts among the regular contributors, need a champion.
        - Would like to engage help from new contributers (was some discussion at LA ASWF meeting).
        - It's unclear how high the bar is for the CII badge.
        - Very interested to hear more from the TAC's working group.
    - Larry: On OIIO I try compiling with the latest compilers, sometimes flags security issues.

* ASWF Intake checklist open items -- CII badge -- Analysis
    - Michael started looking at some of the analysis tools, SonarCloud (ASWF account).

* 1.1.1 release
    - Agreed we don't need to do a press release for 1.1.1.
    - Michael: Got an LGTM from Sean on the site updates, will push that today.

* Misc items
    - Michael working on Python udpates.
    - Thanh has left the LF.
