**Features:**
* Snappier GUI while performing CGAL computations (computations running in separate thread)
* The size of the misc. caches can now be adjusted from Preferences
* The limit for when to disable OpenCSG can now be adjusted from Preferences
* Added Dot product operator: vec * vec
* Added Matrix multiplication operator: vec * mat, mat * mat
* Added search() function
* Dependencies are now tracked - any changes in uses/included files will be detected and cause a recompile
* The OPENSCADPATH environment variable is now implemented will have precedence when searching for libraries
* .csg files can now be opened from the GUI
* linear_extrude() will now assume that the first parameter means 'height' if it's a number

**Bugfixes:**
* use'ing an non-existing file sometimes crashed under Windows
* Better font handling: Ensure a monospace font is chosen as default
* Division by zero caused hang in some cases (e.g. sin(1/0))
* Larger minkowski operations sometimes caused a crash after a CGAL assert was thrown
* Fixed crashes in shared_ptr.hpp (or similar places) due bugs in cache management and CSG normalization
* scale() with a scale factor of zero could cause a crash
* Fixed a number of issues related to use/include
* Providing an unknown parameter on the cmd-line caused a crash
* cmd-line overrides using -D now also work for USEd modules
* Modifier characters can now be used in front of if statements
* rotate() with a vector argument with less that 3 elements used uninitialized variables, ending up being non-deterministic.
* .csg files will now have relative filenames whenever possible
* Don't just ignore geometric nodes having zero volume/area - when doing difference/intersection, they tend to turn negative objects into positive ones.
* Always use utf-8 file encoding, also under Windows
* A lot of build script fixes
* Some other crash bugs fixes

**Deprecations:**
* The old include syntax "<filename.scad>" without the include keyword is no
  longer supported and will cause a syntax error.

