Minutes from OpenVDB TSC meeting, January 16th, 2024

Attendees: *Jeff* L., *Dan* B., *Ken* M., *Richard* J., *Andre* P.,
           *Greg* H.

Additional Attendees: Marten Bojsen-Hansen (Autodesk),
                      Paul Mark di Francesco (SideFX), Phill Mayer (Autodesk),
                      Yannick Pomerleau, Jonah Friedman

Regrets: *Nick* A.,

Agenda:

1) Confirm quorum
2) Secretary
3) Autodesk VTT
4) Next meeting

------------

1) Confirm quorum

Quorum is present.

2) Secretary

Secretary is Andre Pradhana.

3) Autodesk VTT

The TSC likes the idea of incorporating VTT into the VDB project because VTT
is an orthogonal and complementary data structure to a VDB. VDB is sparse
(VDB has a notion of an activation) but non-adaptive. VTT is dense, but adaptive
in values. Fundamentally, it covers two cases of adaptive versus sparse.
It makes sense to have both in one system.

TSC asks if the name VTT can be changed because it sounds too similar to VDB,
which may cause confusion when discussing the data structure. It is good to
highlight the feature of VTT being dense and adaptive. The Autodesk team is
not married to the name VTT.

Tile means different things in VDB and VTT. In VDB this means a constant value
that covers an index space that is larger than one by one by one (used for
example for the interior of a level-set). In VTT, a tile is a node.

There is some concern about repeated implementations of algorithms that are
subtly different for different cases. Perhaps VDB can break things down into
more building blocks, which facilitates better integration with having an
adaptive grid. One suggestion is to have a superclass of the BaseGrid that
splits into a sparse grid versus an adaptive grid. Specific tools, such as
convert to polygons, should accept either type and know how to switch itself.

Autodesk is looking to open-source NanoVTT first. TSC reiterates that we are
interested in the C++ implementation of VTT also. We should make sure that there
is a way forward to incorporate VTT if NanoVTT is already incorporated into the
VDB project.

A lesson from the VDB project is that object-oriented nature of the data
structure is limiting. We are trying to move away, e.g. by moving signed
flood fill out of the leaf nodes or a tree into tools.

VTT has a lossy conversion to VDB because the adaptive information is not
supported in VDB. Needs more clarification on the conversion from a VDB to a
NanoVTT and if this conversion requires the whole OpenVTT library.

VTT is considering having two types of grids, one static and another dynamic.
If a user needs to do modification (e.g. create a new grid), they can switch to
switch to a dynamic grid.

Right now, VTT has a general serialization format in Bifrost. The hope is to
use .vdb format if it gets adopted. Autodesk has a conversion from VTT to a
single VDB right now, but they can look into converting a VTT into a stack of
VDBs. It is lossy. It uses Bifrost SDK.

VTT doesn’t have a transform. It is usually handled by higher-level tools,
such as Maya or Arnold. One possibility is to use a VDB-like transform in VTT,
but more conversation is needed for a technical decision. The caveat is VDB has
a frustum transform. There is a question about limiting the dense volume to a
meter cubed, which works well with frustum transform.

On frustum transform, Houdini can produce this. Dan Bailey added a feature for
the frustum rasterizer.

NanoVTT was first created to address the issue that software, other than Arnold,
should be able to render VTT volumes and to move to converge to VDB.

We need to focus on the Minimum Viable Product (MVP)  and be pragmatic:
 - The conversion from VTT to VDB
 - Serialization to .vdb format
 - Sampling
 - Regrading aspect of it. Top up and bottom down regrading.
   (like a refinement and coarsening oracle on an adaptive tree).

VTT team says that this is along the line of what they are thinking because
Bifrost is a visual programming language. They are thinking about what
traversals should be exposed to users to use the volumes in Bifrost.

There is a VTT Cookbook example.

Ideas to follow up on: create a super base class, more thoughts on transform.
The main concern is that we do not want to fragment the VDB project. We need to
follow up with a written feedback.

4) Next meeting

Next meeting is on January 23rd, 2024. 2pm-3pm EDT (GMT-4).
