#!/usr/bin/env python3

# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU Lesser General Public License
# as published by the Free Software Foundation; either version 2.1
# of the License, or (at your option) any later version.

# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU Lesser General Public License for more details.

# This test implement a Writer Follower communication, with all
# optional parameter not provided.

import sh4lt as s
import time

frame_duration_ms = 2
label = "check monitor writer"

# Create a Sh4lt description for the data to send (a ShType object)
shtype = s.ShType("text/x-raw", label)
assert shtype

# Create a Sh4lt Writer
writer = s.Writer(shtype)
# assert writer


# Create a Monitor
monitor = s.Monitor()
stat = monitor.get_stats()
writer_id = str(shtype.id())
assert writer_id in stat['created']
assert stat['ids'][writer_id]['label'] == shtype.label()
assert stat['ids'][writer_id]['group'] == shtype.group()
assert stat['ids'][writer_id]['path'] == str(shtype.path())
assert stat['infos'][writer_id]['connected'] is True
assert stat['infos'][writer_id]['shtype']['label'] == shtype.label()
assert stat['infos'][writer_id]['shtype']['group'] == shtype.group()
assert stat['infos'][writer_id]['shtype']['media'] == shtype.media()
assert stat['infos'][writer_id]['stats']['Mbps'] <= 0.0
assert stat['infos'][writer_id]['stats']['buffer_date'] <= 0
assert stat['infos'][writer_id]['stats']['buffer_number'] <= 0
assert stat['infos'][writer_id]['stats']['dur_ms'] <= 0
assert stat['infos'][writer_id]['stats']['fps'] <= 0
assert stat['infos'][writer_id]['stats']['reup'] == 0
assert stat['infos'][writer_id]['stats']['size_kB'] <= 0
assert stat['infos'][writer_id]['stats']['system_clock_date'] <= 0
assert stat['infos'][writer_id]['stats']['timecode'] == "00:00:00.000"
assert stat['infos'][writer_id]['stats']['total_size'] <= 0


# Write data to the Sh4lt
data = bytearray("are belong to us", encoding="utf-8")
assert writer.copy_to_shm(data, 123* 1000000, 345 * 1000000)

# check statistics have been updated
time.sleep(3)  # wait for Mbps and fps to be updated
monitor.update()
stat = monitor.get_stats()
assert stat['infos'][writer_id]['stats']['Mbps'] >= 0.0
assert stat['infos'][writer_id]['stats']['buffer_date'] == 123 * 1000000
assert stat['infos'][writer_id]['stats']['buffer_number'] == 0
assert stat['infos'][writer_id]['stats']['dur_ms'] == 345
assert stat['infos'][writer_id]['stats']['fps'] >= 0
assert stat['infos'][writer_id]['stats']['reup'] == 0
assert stat['infos'][writer_id]['stats']['size_kB'] >= 0
assert stat['infos'][writer_id]['stats']['system_clock_date'] >= 0
assert stat['infos'][writer_id]['stats']['timecode'] == "00:00:00.123"
assert stat['infos'][writer_id]['stats']['total_size'] <= 16
