/*
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * as published by the Free Software Foundation; either version 2.1
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 */

#undef NDEBUG  // get assert in release mode

#include <cassert>
#include <iostream>

#include "../sh4lt/ipcs/file-monitor.hpp"
#include "../sh4lt/ipcs/unix-socket-protocol.hpp"
#include "../sh4lt/ipcs/unix-socket-server.hpp"
#include "../sh4lt/logger/console.hpp"

static const std::string socket_path("/tmp/check-file-monitor");
static const size_t shm_size = 128;

auto main() -> int {
  using namespace sh4lt;
  logger::Console logger;
  UnixSocketProtocol::ServerSide sproto(
      [](int id) { std::cout << "(server) on_connect_cb, id " << id << '\n'; },
      [](int id) { std::cout << "(server) on_disconnect_cb, id " << id << '\n'; },
      []() { return UnixSocketProtocol::onConnectData(shm_size, "hello"); });  // user message

  // testing
  {
    assert(!fileMonitor::is_unix_socket(socket_path, &logger));
    UnixSocketServer srv(socket_path, &sproto, &logger);
    srv.start_serving();
    assert(fileMonitor::is_unix_socket(socket_path, &logger));
    assert(srv);
  }
  assert(!fileMonitor::is_unix_socket(socket_path, &logger));
  return 0;
}

