#pragma once
#include <stdint.h>

static constexpr const char* barrverb_prog_names[]
    = {".2 Sec Small Bright",     ".2 Sec Small Warm",
       ".2 Sec Medium Bright",    ".3 Sec Small Bright",
       ".3 Sec Small Warm",       ".4 Sec Medium Bright",
       ".4 Sec Medium Warm",      ".6 Sec Small Bright",
       ".6 Sec Medium Warm",      ".6 Sec Medium Dark",
       ".8 Sec Small Bright",     ".8 Sec Large Warm",
       "1.0 Sec Small Warm",      "1.0 Sec Medium Warm",
       "1.0 Sec Large Bright",    "1.2 Medium Warm",
       "1.2 Sec Small Warm",      "1.2 Sec Small Bright",
       "1.4 Sec Large Warm",      "1.4 Sec Large Dark",
       "1.4 Sec Medium Warm",     "1.6 Sec Small Dark",
       "1.6 Sec Large Bright",    "1.6 Sec Medium Bright",
       "1.8 Sec Large Dark",      "1.8 Sec Large Bright",
       "1.8 Sec Medium Warm",     "2.0 Sec Large Bright",
       "2.0 Sec Medium Warm",     "2.0 Sec Large Warm",
       "2.5 Sec Medium Warm",     "2.5 Sec Large Bright",
       "2.5 Sec Medium Bright",   "2.8 Sec Small Bright",
       "2.8 Sec Medium Bright",   "3.0 Sec Large Bright",
       "3.0 Sec Large Warm",      "3.0 Sec Medium Dark",
       "3.5 Sec Large Bright",    "3.5 Sec Medium Warm",
       "4.0 Sec Large Dark",      "4.0 Sec Medium Bright",
       "5 Sec Large Warm",        "8 Sec Large Bright",
       "8 Sec Large Warm",        "10 Sec Large Bright",
       "10 Sec Large Warm",       "16 Sec Large Dark",
       "18 Sec Ex. Large Bright", "20 Sec Ex Large Dark",
       "Gated - 100ms",           "Gated - 150ms",
       "Gated - 200ms",           "Gated - 250ms",
       "Gated - 300ms",           "Gated - 350ms",
       "Gated - 400ms",           "Gated - 500ms",
       "Gated - 600ms",           "Reverse - 300ms",
       "Reverse - 400ms",         "Reverse - 500ms",
       "Reverse - 600ms",         "Defeat"};

// clang-format off
static constexpr uint16_t barrverb_rom[] = {
    // Program  0, 0x0000
    0x3e38, 0x7cff, 0x3e44, 0x3f3a, 0x074c, 0x8000, 0x4004, 0xbd44, 0x7ed3, 0x3e1b,
    0x3d31, 0x0899, 0x8000, 0x4002, 0xbfc0, 0x403e, 0xc000, 0xffc2, 0x003c, 0x3ffe,
    0xff6b, 0x4095, 0x0004, 0xc000, 0xff67, 0x0095, 0x3fc6, 0x0000, 0x3ffe, 0xff34,
    0x40cc, 0x0040, 0xc000, 0xfef4, 0x00cc, 0x3fa7, 0x0000, 0x3ffe, 0xc000, 0x409b,
    0xc000, 0xff65, 0x3f8f, 0x0000, 0x010c, 0x0000, 0xc000, 0x0000, 0x0000, 0x8000,
    0x8000, 0x800a, 0xbd68, 0x7f52, 0x00ac, 0xff54, 0x0000, 0x3ffe, 0xbef9, 0x7f14,
    0x00ea, 0xff16, 0x0000, 0x0531, 0xb719, 0x48e7, 0x371a, 0xbfff, 0x4000, 0x08f1,
    0x0000, 0x3e6d, 0xbb7d, 0x7f75, 0x0089, 0xff77, 0x0000, 0x3ffe, 0xbed7, 0x7ee1,
    0x011d, 0xfee3, 0x0000, 0x08e1, 0xb716, 0x48ea, 0x3717, 0xbfff, 0x4000, 0x08f4,
    0x0000, 0x3ac3, 0x8533, 0x0000, 0x0000, 0x0004, 0x3ffc, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0002, 0x3ffe, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    // Program  1, 0x0100
    0x3e38, 0x7cff, 0x3e44, 0x3f3a, 0x074c, 0x8000, 0x4004, 0xbd44, 0x7ed3, 0x3e1b,
    0x3d31, 0x0899, 0x8000, 0x4002, 0xb71a, 0x48e2, 0x371f, 0x88a5, 0x403e, 0xc000,
    0xffc2, 0x375a, 0x08e0, 0xff6b, 0x4095, 0x0004, 0xc000, 0xff67, 0x0095, 0x3fc6,
    0x0000, 0x3ffe, 0xff34, 0x40cc, 0x0040, 0xc000, 0xfef4, 0x00cc, 0x3fa7, 0x0000,
    0x3ffe, 0xc000, 0x409b, 0xc000, 0xff65, 0x3f8f, 0x0000, 0x010c, 0x0000, 0xc000,
    0x0000, 0x0000, 0x8000, 0x8000, 0x800a, 0xbd68, 0x7f52, 0x00ac, 0xff54, 0x0000,
    0x3ffe, 0xbef9, 0x7f14, 0x00ea, 0xff16, 0x0000, 0x0531, 0xb719, 0x48e7, 0x371a,
    0xbfff, 0x4000, 0x08f1, 0x0000, 0x3e6d, 0xbb7d, 0x7f75, 0x0089, 0xff77, 0x0000,
    0x3ffe, 0xbed7, 0x7ee1, 0x011d, 0xfee3, 0x0000, 0x08e1, 0xb716, 0x48ea, 0x3717,
    0xbfff, 0x4000, 0x08f4, 0x0000, 0x3ac3, 0x8537, 0x3ffc, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0002, 0x3ffe, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    // Program  2, 0x0200
    0x3d84, 0x7b6f, 0x3c50, 0x3daa, 0x0d14, 0x8000, 0x4004, 0xbc90, 0x7d43, 0x3c27,
    0x3ba1, 0x0e61, 0x8000, 0x4002, 0xbfc0, 0x403e, 0xc000, 0xffc2, 0x003c, 0x3ffe,
    0xff6b, 0x4095, 0x0004, 0xc000, 0xff67, 0x0095, 0x3fc6, 0x0000, 0x3ffe, 0xfeee,
    0x4112, 0x0040, 0xc000, 0xfeae, 0x0112, 0x3fa7, 0x0000, 0x3ffe, 0xc000, 0x409b,
    0xc000, 0xff65, 0x3f49, 0x0000, 0x0152, 0x0000, 0xc000, 0x0000, 0x0000, 0x8000,
    0x8000, 0x800a, 0xbbec, 0x7e8a, 0x0174, 0xfe8c, 0x0000, 0x3ffe, 0xbdcd, 0x47b5,
    0xf697, 0x01b2, 0xfe4e, 0x0000, 0x0969, 0xaf5d, 0x50a3, 0x2f5e, 0xbfff, 0x4000,
    0x10ad, 0x0000, 0x3db9, 0xb731, 0x7ead, 0x0151, 0xfeaf, 0x0000, 0x3ffe, 0xbdab,
    0x4eb6, 0xef63, 0x01e5, 0xfe1b, 0x0000, 0x109d, 0xaf5a, 0x50a6, 0x2f5b, 0xbfff,
    0x4000, 0x10b0, 0x0000, 0x368b, 0x896b, 0x0004, 0x3ffc, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0002, 0x3ffe, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    // Program  3, 0x0300
    0x3e38, 0x7bd3, 0x3d7c, 0x3daa, 0x0ad0, 0x8000, 0x4004, 0xbd44, 0x7da7, 0x3d53,
    0x3ba1, 0x0c1d, 0x8000, 0x4002, 0xbfc0, 0x403e, 0xc000, 0xffc2, 0x003c, 0x3ffe,
    0xff6b, 0x4095, 0x0004, 0xc000, 0xff67, 0x0095, 0x3fc6, 0x0000, 0x3ffe, 0xff3e,
    0x40c2, 0x0040, 0xc000, 0xfefe, 0x00c2, 0x3fa7, 0x0000, 0x3ffe, 0xc000, 0x409b,
    0xc000, 0xff65, 0x3f99, 0x0000, 0x0102, 0x0000, 0xc000, 0x0000, 0x0000, 0x8000,
    0x8000, 0x800a, 0xbca0, 0x7eee, 0x0110, 0xfef0, 0x0000, 0x3ffe, 0xbe31, 0x7f14,
    0x00ea, 0xff16, 0x0000, 0x0725, 0xb2cd, 0x4d33, 0x32ce, 0xbfff, 0x4000, 0x0d3d,
    0x0000, 0x3e6d, 0xb8c1, 0x7ead, 0x0151, 0xfeaf, 0x0000, 0x3ffe, 0xbe73, 0x7e7d,
    0x0181, 0xfe7f, 0x0000, 0x0d2d, 0xb2ca, 0x4d36, 0x32cb, 0xbfff, 0x4000, 0x0d40,
    0x0000, 0x38cf, 0x8727, 0x0000, 0x0000, 0x0004, 0x3ffc, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0002, 0x3ffe, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    // Program  4, 0x0400
    0x3e2a, 0x7c37, 0x3c50, 0x3daa, 0x0ba6, 0x8000, 0x4004, 0xbd36, 0x7d43, 0x3cef,
    0x3ccd, 0x0bc7, 0x8000, 0x4002, 0xb194, 0x4e68, 0x3199, 0x8e2b, 0x403e, 0xc000,
    0xffc2, 0x31d4, 0x0e66, 0xff6b, 0x4095, 0x0004, 0xc000, 0xff67, 0x0095, 0x3fc6,
    0x0000, 0x3ffe, 0xff3e, 0x40c2, 0x0040, 0xc000, 0xfefe, 0x00c2, 0x3fa7, 0x0000,
    0x3ffe, 0xc000, 0x409b, 0xc000, 0xff65, 0x3f99, 0x0000, 0x0102, 0x0000, 0xc000,
    0x0000, 0x0000, 0x8000, 0x8000, 0x800a, 0xbc92, 0x7e8a, 0x0174, 0xfe8c, 0x0000,
    0x3ffe, 0xbe95, 0x7e4c, 0x01b2, 0xfe4e, 0x0000, 0x07fb, 0xb193, 0x4e6d, 0x3194,
    0xbfff, 0x4000, 0x0e77, 0x0000, 0x3e5f, 0xb7f9, 0x7ead, 0x0151, 0xfeaf, 0x0000,
    0x3ffe, 0xbe73, 0x7e19, 0x01e5, 0xfe1b, 0x0000, 0x0e67, 0xb190, 0x4e70, 0x3191,
    0xbfff, 0x4000, 0x0e7a, 0x0000, 0x37f9, 0x8801, 0x3ffc, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0002, 0x3ffe, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    // Program  5, 0x0500
    0x3d84, 0x7b6f, 0x3c50, 0x3daa, 0x0d14, 0x8000, 0x4004, 0xbc90, 0x7d43, 0x3c27,
    0x3ba1, 0x0e61, 0x8000, 0x4002, 0xbfc0, 0x403e, 0xc000, 0xffc2, 0x003c, 0x3ffe,
    0xff6b, 0x4095, 0x0004, 0xc000, 0xff67, 0x0095, 0x3fc6, 0x0000, 0x3ffe, 0xfeee,
    0x4112, 0x0040, 0xc000, 0xfeae, 0x0112, 0x3fa7, 0x0000, 0x3ffe, 0xc000, 0x409b,
    0xc000, 0xff65, 0x3f49, 0x0000, 0x0152, 0x0000, 0xc000, 0x0000, 0x0000, 0x8000,
    0x8000, 0x800a, 0xbbec, 0x7e8a, 0x0174, 0xfe8c, 0x0000, 0x3ffe, 0xbdcd, 0x7e4c,
    0x01b2, 0xfe4e, 0x0000, 0x0969, 0xaf5d, 0x50a3, 0x2f5e, 0xbfff, 0x4000, 0x10ad,
    0x0000, 0x3db9, 0xb731, 0x7ead, 0x0151, 0xfeaf, 0x0000, 0x3ffe, 0xbdab, 0x7e19,
    0x01e5, 0xfe1b, 0x0000, 0x109d, 0xaf5a, 0x50a6, 0x2f5b, 0xbfff, 0x4000, 0x10b0,
    0x0000, 0x368b, 0x896b, 0x0000, 0x0000, 0x0004, 0x3ffc, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0002, 0x3ffe, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    // Program  6, 0x0600
    0x3d84, 0x7b6f, 0x3c50, 0x3daa, 0x0d18, 0xc000, 0xfc90, 0x7d43, 0x3c27, 0x3ba1,
    0x0e63, 0xc000, 0xef5e, 0x509e, 0x2f63, 0x9061, 0x403e, 0xc000, 0xffc2, 0x2f9e,
    0x109c, 0xff6b, 0x4095, 0x0004, 0xc000, 0xff67, 0x0095, 0x3fc6, 0x0000, 0x3ffe,
    0xfeee, 0x4112, 0x0040, 0xc000, 0xfeae, 0x0112, 0x3fa7, 0x0000, 0x3ffe, 0xc000,
    0x409b, 0xc000, 0xff65, 0x3f49, 0x0000, 0x0152, 0x0000, 0xc000, 0x0000, 0x0000,
    0x8000, 0x8000, 0x800a, 0xbbec, 0x7e8a, 0x0174, 0xfe8c, 0x0000, 0x3ffe, 0xbdcd,
    0x7e4c, 0x01b2, 0xfe4e, 0x0000, 0x0969, 0xaf5d, 0x50a3, 0x2f5e, 0xbfff, 0x4000,
    0x10ad, 0x0000, 0x3db9, 0xb731, 0x7ead, 0x0151, 0xfeaf, 0x0000, 0x3ffe, 0xbdab,
    0x7e19, 0x01e5, 0xfe1b, 0x0000, 0x109d, 0xaf5a, 0x50a6, 0x2f5b, 0xbfff, 0x4000,
    0x10b0, 0x0000, 0x368b, 0x896b, 0x0000, 0x0004, 0x3ffc, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0002, 0x3ffe, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    // Program  7, 0x0700
    0x3cdd, 0x7a1b, 0x368a, 0x11cc, 0x00b3, 0x8000, 0x4004, 0xbb85, 0x7cb7, 0x35fd,
    0x0fc3, 0x0200, 0x8000, 0x4002, 0xbfc0, 0x403e, 0xc000, 0xffc2, 0x003c, 0x3ffe,
    0xff6b, 0x4095, 0x0004, 0xc000, 0xff67, 0x0095, 0x3fc6, 0x0000, 0x3ffe, 0xfeee,
    0x4112, 0x0040, 0xc000, 0xfeae, 0x0112, 0x3fa7, 0x0000, 0x3ffe, 0xc000, 0x409b,
    0xc000, 0xff65, 0x3f49, 0x0000, 0x0152, 0x0000, 0xc000, 0x0000, 0x0000, 0x8000,
    0x8000, 0x800a, 0xbab9, 0x7e26, 0x01d8, 0xfe28, 0x0000, 0x3ffe, 0xbd55, 0x7d84,
    0x027a, 0xfd86, 0x0000, 0x0c40, 0x8000, 0xa9e8, 0x561e, 0xe9e2, 0x1618, 0x29e9,
    0xbfff, 0x4000, 0x1622, 0x0000, 0x3d12, 0xb439, 0x7d81, 0x027d, 0xfd83, 0x0000,
    0x3ffe, 0xbdab, 0x7d6f, 0x028f, 0xfd71, 0x0000, 0x1612, 0x8000, 0xa9e5, 0x5621,
    0xe9df, 0x161b, 0x29e6, 0xbfff, 0x4000, 0x161f, 0x0006, 0x0000, 0x33b4, 0x8c42,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0002, 0x3ffe, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    // Program  8, 0x0800
    0x3777, 0x72a8, 0x2d11, 0x2778, 0x015d, 0xc000, 0xf4ca, 0x77d5, 0x2c05, 0x2359,
    0x0401, 0xc000, 0xce9a, 0x70ff, 0x0f02, 0xb09a, 0x40c9, 0xc000, 0xff37, 0x0f65,
    0x30fd, 0xfed6, 0x412a, 0x0067, 0xc000, 0xfe6f, 0x012a, 0x3f9e, 0x0000, 0x3ffe,
    0xfdc9, 0x4237, 0x00cb, 0xc000, 0xfcfe, 0x0237, 0x3f3a, 0x0000, 0x3ffe, 0xc000,
    0x4193, 0xc000, 0xfe6d, 0x3e91, 0x0000, 0x3af5, 0x0315, 0xfceb, 0x0000, 0x080d,
    0x8000, 0x8000, 0x800a, 0xb334, 0x4cc2, 0xedfb, 0x0541, 0xfabf, 0x0000, 0x3ffe,
    0xbaa7, 0x5760, 0xe395, 0x0509, 0xfaf7, 0x0000, 0x1c6b, 0x8000, 0x8e99, 0x716d,
    0xce93, 0x3167, 0x0e9a, 0xbfff, 0x4000, 0x3171, 0x0000, 0x37e7, 0xa798, 0x6077,
    0xd9d7, 0x05b0, 0xfa50, 0x0000, 0x3ffe, 0xba35, 0x6bf6, 0xce9f, 0x0569, 0xfa97,
    0x0000, 0x3161, 0x8000, 0x8e96, 0x7170, 0xfffe, 0x0e92, 0x316a, 0x0e97, 0xbfff,
    0x4000, 0x3174, 0x0000, 0x2389, 0x9c6d, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0002, 0x3ffe, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    // Program  9, 0x0900
    0x3777, 0x72a8, 0x2d11, 0x2778, 0x015d, 0xc000, 0xf5f6, 0x76a9, 0x2c05, 0x2359,
    0x0401, 0xc000, 0xce9a, 0x7164, 0xbf9b, 0x0f02, 0xb09a, 0x40c9, 0xc000, 0xff37,
    0x0f65, 0x30fd, 0xfed6, 0x412a, 0x0067, 0xc000, 0xfe6f, 0x012a, 0x3f9e, 0x0000,
    0x3ffe, 0xfdc9, 0x4237, 0x00cb, 0xc000, 0xfcfe, 0x0237, 0x3f3a, 0x0000, 0x3ffe,
    0xc000, 0x4193, 0xc000, 0xfe6d, 0x3e91, 0x0000, 0x3af5, 0x0315, 0xfceb, 0x0000,
    0x080d, 0x8000, 0x8000, 0x800a, 0xb334, 0x4cc2, 0xedfb, 0x0541, 0xfabf, 0x0000,
    0x3ffe, 0xbaa7, 0x5760, 0xe395, 0x0509, 0xfaf7, 0x0000, 0x1c6b, 0x8000, 0x8e99,
    0x716d, 0xce93, 0x3167, 0x0e9a, 0xbfff, 0x4000, 0x3171, 0x0000, 0x37e7, 0xa798,
    0x6077, 0xd9d7, 0x05b0, 0xfa50, 0x0000, 0x3ffe, 0xba35, 0x6bf6, 0xce9f, 0x0569,
    0xfa97, 0x0000, 0x3161, 0x8000, 0x8e96, 0x716e, 0x0002, 0xce90, 0x316a, 0x0e97,
    0xbfff, 0x4000, 0x3174, 0x0000, 0x2389, 0x9c6d, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0002, 0x3ffe, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    // Program 10, 0x0a00
    0x3cdd, 0x79b7, 0x3626, 0x1294, 0x00b7, 0xc000, 0xfb85, 0x7c53, 0x3599, 0x108b,
    0x0202, 0xc000, 0xffc0, 0x403e, 0xc000, 0xffc2, 0x003c, 0x3ffe, 0xff6b, 0x4095,
    0x0004, 0xc000, 0xff67, 0x0095, 0x3fc6, 0x0000, 0x3ffe, 0xfeee, 0x4112, 0x0040,
    0xc000, 0xfeae, 0x0112, 0x3fa7, 0x0000, 0x3ffe, 0xc000, 0x409b, 0xc000, 0xff65,
    0x3f49, 0x0000, 0x0152, 0x0000, 0xc000, 0x0000, 0x0000, 0x8000, 0x8000, 0x800a,
    0xba55, 0x45a1, 0xc000, 0xfa5f, 0x3e26, 0x01d8, 0xfe28, 0x0000, 0x3ffe, 0xbcf1,
    0x4a8c, 0xc000, 0xf574, 0x3d84, 0x027a, 0xfd86, 0x0000, 0x0d08, 0x8000, 0xa93e,
    0x56c8, 0xe938, 0x16c2, 0x293f, 0xbfff, 0x4000, 0x16cc, 0x0000, 0x3d12, 0xb371,
    0x4f73, 0xc000, 0xf08d, 0x3d81, 0x027d, 0xfd83, 0x0000, 0x3ffe, 0xbdc9, 0x542b,
    0xc000, 0xebd5, 0x3d6f, 0x028f, 0xfd71, 0x16c0, 0x2940, 0x16bc, 0x8000, 0xa93b,
    0x56cb, 0xe935, 0x16c5, 0x293c, 0xbfff, 0x4000, 0x16cf, 0x0000, 0x32ec, 0x8d0a,
    0x0000, 0x0002, 0x3ffe, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    // Program 11, 0x0b00
    0x33a4, 0x6c82, 0x3063, 0x2f78, 0x8000, 0x4002, 0xb095, 0x724b, 0x2fba, 0x2d64,
    0x8000, 0x4004, 0xbffa, 0x42fb, 0x0001, 0xbfff, 0x7d08, 0x8000, 0x8000, 0x8000,
    0xbeba, 0x0141, 0xfebf, 0x0000, 0x3e4f, 0x01af, 0xfe51, 0x0000, 0x3c9a, 0x0364,
    0xfc9c, 0x0000, 0x3b9e, 0x0460, 0xfba0, 0x0000, 0x3f14, 0x00ea, 0xff16, 0x0000,
    0x3f64, 0x009a, 0xff66, 0x0000, 0x0c47, 0xae27, 0x51d8, 0xe65e, 0x07c8, 0xf838,
    0x0000, 0x1c98, 0x0001, 0x8000, 0x4000, 0x2365, 0xb826, 0x617e, 0xd53d, 0x0943,
    0xf6bd, 0x0000, 0x3ffe, 0xb7f7, 0x72ce, 0xc2fc, 0x0a34, 0xf5cc, 0x0000, 0x3d05,
    0x0000, 0x33b7, 0x8c48, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0004, 0x3ffc, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0002, 0x3ffe, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    // Program 12, 0x0c00
    0x3d69, 0x7ae3, 0x3838, 0x0eca, 0x00b7, 0xc000, 0xfc11, 0x7d7f, 0x37ab, 0x0cc1,
    0x0202, 0xc000, 0xeceb, 0x5311, 0x2cf0, 0x92d4, 0x403e, 0xc000, 0xffc2, 0x2d2b,
    0x130f, 0xff6b, 0x4095, 0x0004, 0xc000, 0xff67, 0x0095, 0x3fc6, 0x0000, 0x3ffe,
    0xfeee, 0x4112, 0x0040, 0xc000, 0xfeae, 0x0112, 0x3fa7, 0x0000, 0x3ffe, 0xc000,
    0x409b, 0xc000, 0xff65, 0x3f49, 0x0000, 0x0152, 0x0000, 0xc000, 0x0000, 0x0000,
    0x8000, 0x8000, 0x800a, 0xbba9, 0x444d, 0xba3d, 0x0174, 0xfe8c, 0x0000, 0x3ffe,
    0xbd55, 0x4870, 0xb578, 0x0216, 0xfdea, 0x0000, 0x0a88, 0x8000, 0xacea, 0x531c,
    0xece4, 0x1316, 0x2ceb, 0xbfff, 0x4000, 0x1320, 0x0000, 0x3d9e, 0xb62d, 0x4c2b,
    0xb1d8, 0x01fb, 0xfe05, 0x0000, 0x3ffe, 0xbd47, 0x50e3, 0xacf0, 0x022b, 0xfdd5,
    0x0000, 0x1310, 0x8000, 0xace7, 0x531f, 0xfffe, 0x2ce3, 0x1319, 0x2ce8, 0xbfff,
    0x4000, 0x1323, 0x0000, 0x356c, 0x8a8a, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0002, 0x3ffe, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    // Program 13, 0x0d00
    0x3721, 0x7370, 0x2dc5, 0x2652, 0x0159, 0x8000, 0x4004, 0xb474, 0x789d, 0x2cb9,
    0x2233, 0x03ff, 0x8000, 0x4002, 0x8ef8, 0x70a1, 0x0f60, 0xb03c, 0x40c9, 0xc000,
    0xff37, 0x0fc3, 0x309f, 0xfed6, 0x412a, 0x0067, 0xc000, 0xfe6f, 0x012a, 0x3f9e,
    0x0000, 0x3ffe, 0xfdc9, 0x4237, 0x00cb, 0xc000, 0xfcfe, 0x0237, 0x3f3a, 0x0000,
    0x3ffe, 0xc000, 0x4193, 0xc000, 0xfe6d, 0x3e91, 0x0000, 0x3a9f, 0x036b, 0xfc95,
    0x0000, 0x0863, 0x8000, 0x8000, 0x800a, 0xb2de, 0x7b85, 0x0479, 0xfb87, 0x0000,
    0x3ffe, 0xb9df, 0x7ac3, 0x053b, 0xfac5, 0x0000, 0x1cf3, 0x8000, 0x8ef7, 0x710f,
    0xcef1, 0x3109, 0x0ef8, 0xbfff, 0x4000, 0x3113, 0x0000, 0x3791, 0xa784, 0x7bde,
    0x0420, 0xfbe0, 0x0000, 0x3ffe, 0xb96d, 0x7a95, 0x0569, 0xfa97, 0x0000, 0x3103,
    0x8000, 0x8ef4, 0x7112, 0xceee, 0x310c, 0x0004, 0x0ef1, 0xbfff, 0x4000, 0x3116,
    0x0000, 0x2301, 0x9cf5, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0002, 0x3ffe, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    // Program 14, 0x0e00
    0x35a4, 0x72a8, 0x2a55, 0x2c07, 0x015d, 0xc000, 0xf2f7, 0x77d5, 0x2949, 0x27e8,
    0x0401, 0xc000, 0xff35, 0x40c9, 0xc000, 0xff37, 0x0064, 0x3ffe, 0xfed6, 0x412a,
    0x0067, 0xc000, 0xfe6f, 0x012a, 0x3f9e, 0x0000, 0x3ffe, 0xfdc9, 0x4237, 0x00cb,
    0xc000, 0xfcfe, 0x0237, 0x3f3a, 0x0000, 0x3ffe, 0xc000, 0x4193, 0xc000, 0xfe6d,
    0x3e91, 0x0000, 0x3922, 0x04e8, 0xfb18, 0x0000, 0x09e0, 0x8000, 0x8000, 0x800a,
    0xb161, 0x4000, 0x3abd, 0x0541, 0xfabf, 0x0000, 0x3ffe, 0xb9df, 0x59fb, 0xdf06,
    0x06fd, 0xf903, 0x0000, 0x20fa, 0x8000, 0x8686, 0x7980, 0xc680, 0x397a, 0x0687,
    0xbfff, 0x4000, 0x3984, 0x0000, 0x3614, 0xa4dc, 0x4000, 0x3a4e, 0x05b0, 0xfa50,
    0x0000, 0x3ffe, 0xb841, 0x7279, 0xc68c, 0x06f9, 0xf907, 0x0000, 0x3974, 0x8000,
    0x8683, 0x7983, 0xc67d, 0x397d, 0x0684, 0xb980, 0x067f, 0x4000, 0x3987, 0x0000,
    0x1efa, 0xa0fc, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0002, 0x3ffe, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    // Program 15, 0x0f00
    0x36b1, 0x72a8, 0x2a55, 0x2afa, 0x015d, 0xc000, 0xf404, 0x77d5, 0x2949, 0x26db,
    0x0401, 0xc000, 0xc794, 0x7805, 0x07fc, 0xb7a0, 0x40c9, 0xc000, 0xff37, 0x0860,
    0x3802, 0xfed6, 0x412a, 0x0067, 0xc000, 0xfe6f, 0x012a, 0x3f9e, 0x0000, 0x3ffe,
    0xfdc9, 0x4237, 0x00cb, 0xc000, 0xfcfe, 0x0237, 0x3f3a, 0x0000, 0x3ffe, 0xc000,
    0x4193, 0xc000, 0xfe6d, 0x3e91, 0x0000, 0x3a2f, 0x03db, 0xfc25, 0x0000, 0x08d3,
    0x8000, 0x8000, 0x800a, 0xb26e, 0x4d88, 0xad35, 0x0541, 0xfabf, 0x0000, 0x3ffe,
    0xb9df, 0x7901, 0x06fd, 0xf903, 0x0000, 0x1fed, 0x8000, 0x8793, 0x7873, 0xc78d,
    0x386d, 0x0794, 0xbfff, 0x4000, 0x3877, 0x0000, 0x3721, 0xa4dc, 0x63f9, 0x9655,
    0x05b0, 0xfa50, 0x0000, 0x3ffe, 0xb841, 0x7905, 0x06f9, 0xf907, 0x0000, 0x3867,
    0x8000, 0x8790, 0x7876, 0xc78a, 0x3870, 0x0004, 0x078d, 0xbfff, 0x4000, 0x387a,
    0x0000, 0x2007, 0x9fef, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0002, 0x3ffe, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    // Program 16, 0x1000
    0x3ae0, 0x74fa, 0x3607, 0x37f3, 0x2231, 0xc000, 0xf8dc, 0x797e, 0x3748, 0x35e9,
    0x2073, 0xc000, 0xd83d, 0x675c, 0x18a5, 0xa70b, 0x40b5, 0xc000, 0xff4b, 0x18f4,
    0x275a, 0xff1d, 0x40e3, 0x0067, 0xc000, 0xfeb6, 0x00e3, 0x3fb2, 0x0000, 0x3ffe,
    0xfdfc, 0x4204, 0x00b7, 0xc000, 0xfd45, 0x0204, 0x3f6d, 0x0000, 0x3ffe, 0xc000,
    0x414c, 0xc000, 0xfeb4, 0x3e91, 0x0000, 0x02bb, 0x8000, 0x8000, 0x800a, 0xb7c3,
    0x4833, 0xb3b6, 0x0415, 0xfbeb, 0x0000, 0x3ffe, 0xbb0b, 0x5141, 0xa9b4, 0x0509,
    0xfaf7, 0x0000, 0x164c, 0x8000, 0x983c, 0x67ca, 0xd836, 0x27c4, 0x183d, 0xbfff,
    0x4000, 0x27ce, 0x0000, 0x3ae1, 0xaabd, 0x5a58, 0xa0be, 0x04e8, 0xfb18, 0x0000,
    0x3ffe, 0xbb61, 0x63e3, 0x9842, 0x03d9, 0xfc27, 0x0000, 0x27be, 0x8000, 0x9839,
    0x67cd, 0xd833, 0x27c7, 0x183a, 0xbfff, 0x67cb, 0x1835, 0x27d1, 0x0000, 0x29a8,
    0x964e, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0002, 0x3ffe, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    // Program 17, 0x1100
    0x3ae0, 0x74fa, 0x3607, 0x37f3, 0x2231, 0xc000, 0xf8dc, 0x797e, 0x3748, 0x35e9,
    0x2073, 0xc000, 0xff49, 0x40b5, 0xc000, 0xff4b, 0x0050, 0x3ffe, 0xff1d, 0x40e3,
    0x0067, 0xc000, 0xfeb6, 0x00e3, 0x3fb2, 0x0000, 0x3ffe, 0xfdfc, 0x4204, 0x00b7,
    0xc000, 0xfd45, 0x0204, 0x3f6d, 0x0000, 0x3ffe, 0xc000, 0x414c, 0xc000, 0xfeb4,
    0x3e91, 0x0000, 0x02bb, 0x8000, 0x8000, 0x800a, 0xb7c3, 0x4833, 0xb3b6, 0x0415,
    0xfbeb, 0x0000, 0x3ffe, 0xbb0b, 0x5141, 0xa9b4, 0x0509, 0xfaf7, 0x0000, 0x164c,
    0x8000, 0x983c, 0x67ca, 0xd836, 0x27c4, 0x183d, 0xbfff, 0x4000, 0x27ce, 0x0000,
    0x3ae1, 0xaabd, 0x5a58, 0xa0be, 0x04e8, 0xfb18, 0x0000, 0x3ffe, 0xbb61, 0x63e3,
    0x9842, 0x03d9, 0xfc27, 0x0000, 0x27be, 0x8000, 0x9839, 0x67cd, 0xd833, 0x27c7,
    0x183a, 0xbfff, 0x4000, 0x27d1, 0x0000, 0x3ffa, 0x29ae, 0x964e, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0002, 0x3ffe, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    // Program 18, 0x1200
    0x350e, 0x6e6c, 0x3063, 0x2c26, 0xc000, 0xf191, 0x74a3, 0x314a, 0x2884, 0xc000,
    0xfffa, 0x496f, 0x0001, 0xbfff, 0x7694, 0x8000, 0x8000, 0x8000, 0xbeba, 0x0141,
    0xfebf, 0x0000, 0x3e4f, 0x01af, 0xfe51, 0x0000, 0x3d62, 0x029c, 0xfd64, 0x0000,
    0x3cd6, 0x0328, 0xfcd8, 0x0000, 0x3f32, 0x00cc, 0xff34, 0x0000, 0x3f6e, 0x0090,
    0xff70, 0x0000, 0x0a1f, 0xaf23, 0x50dc, 0xa8ea, 0x0638, 0xf9c8, 0x0000, 0x3ffe,
    0xb88a, 0x5e8e, 0xc000, 0xe172, 0x37e7, 0x0817, 0xf7e9, 0x0000, 0x3ffe, 0xb8bf,
    0x6dea, 0xc000, 0xd216, 0x375a, 0x08a4, 0xf75c, 0x0000, 0x3690, 0x8000, 0x896a,
    0x7696, 0xc96a, 0x3696, 0x096b, 0x8000, 0x4000, 0x3696, 0x0000, 0x35df, 0x8a20,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0004, 0x3ffc, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0002, 0x3ffe, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    // Program 19, 0x1300
    0x31ba, 0x6c14, 0x2ed3, 0x3362, 0xc000, 0xee3d, 0x724b, 0x2ef2, 0x3088, 0xc000,
    0xfffa, 0x416b, 0x0001, 0xbfff, 0x7e98, 0x8000, 0x8000, 0x8000, 0xbeba, 0x0141,
    0xfebf, 0x0000, 0x3e4f, 0x01af, 0xfe51, 0x0000, 0x3c9a, 0x0364, 0xfc9c, 0x0000,
    0x3a72, 0x058c, 0xfa74, 0x0000, 0x3f14, 0x00ea, 0xff16, 0x0000, 0x3f64, 0x009a,
    0xff66, 0x0000, 0x0d73, 0xab07, 0x54f8, 0xa33e, 0x07c8, 0xf838, 0x0000, 0x3ffe,
    0xb826, 0x76bb, 0x0943, 0xf6bd, 0x0000, 0x3ffe, 0xb987, 0x75ca, 0x0a34, 0xf5cc,
    0x0000, 0x3e94, 0x8166, 0x7e9a, 0x0167, 0x8000, 0x4000, 0x3e9a, 0x0000, 0x328b,
    0x8d74, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0004, 0x3ffc, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0002, 0x3ffe, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    // Program 20, 0x1400
    0x33e5, 0x7132, 0x32bb, 0x282f, 0x8000, 0x4004, 0xb089, 0x767e, 0x3406, 0x24ef,
    0x8000, 0x4002, 0xbffc, 0x4e90, 0x0001, 0xbfff, 0x7173, 0x8000, 0x8000, 0x8000,
    0xbf00, 0x00fb, 0xff05, 0x0000, 0x3e4f, 0x01af, 0xfe51, 0x0000, 0x3cfe, 0x0300,
    0xfd00, 0x0000, 0x3ad6, 0x0528, 0xfad8, 0x0000, 0x3f41, 0x00bd, 0xff43, 0x0000,
    0x3f96, 0x0068, 0xff98, 0x0000, 0x0c06, 0xaf94, 0x506b, 0xaa87, 0x050c, 0xfaf4,
    0x0000, 0x3ffe, 0xba7e, 0x78af, 0x074f, 0xf8b1, 0x0000, 0x3ffe, 0xb987, 0x775a,
    0x08a4, 0xf75c, 0x0000, 0x316f, 0x8000, 0x8e8b, 0x717b, 0xce85, 0x3175, 0x0e8c,
    0x8000, 0x4000, 0x3175, 0x0000, 0x33f8, 0x8c07, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0004, 0x3ffc, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0002, 0x3ffe, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    // Program 21, 0x1500
    0x39cf, 0x7640, 0x369e, 0x1956, 0xc000, 0xf9cc, 0x779f, 0x37d8, 0x16bf, 0xc000,
    0xfffa, 0x6174, 0x0001, 0xbfff, 0x5e8f, 0x8000, 0x8000, 0x8000, 0xbf5b, 0x00a0,
    0xff60, 0x0000, 0x3f27, 0x00d7, 0xff29, 0x0000, 0x3e4c, 0x01b2, 0xfe4e, 0x0000,
    0x3dd1, 0x022d, 0xfdd3, 0x0000, 0x3f89, 0x0075, 0xff8b, 0x0000, 0x3fb2, 0x004c,
    0xffb4, 0x0000, 0x0626, 0xb710, 0x48ef, 0xc000, 0xf711, 0x3c1b, 0x03e3, 0xfc1d,
    0x0000, 0x3ffe, 0xbc13, 0x50c3, 0xaa97, 0x04a4, 0xfb5c, 0x0000, 0x3ffe, 0xbbfc,
    0x596f, 0xa175, 0x051a, 0xfae6, 0x0000, 0x1e8b, 0xa16f, 0x5e91, 0x2170, 0x8000,
    0x4000, 0x1e91, 0x0000, 0x39d8, 0x8627, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0004, 0x3ffc, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0002, 0x3ffe, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    // Program 22, 0x1600
    0x344c, 0x6e76, 0x312b, 0x2c16, 0xc000, 0xf0f2, 0x761a, 0x30e6, 0x2810, 0xc000,
    0xfffa, 0x4003, 0x8000, 0x8000, 0x8000, 0xbeba, 0x0141, 0xfebf, 0x0000, 0x3e4f,
    0x01af, 0xfe51, 0x0000, 0x3cfe, 0x0300, 0xfd00, 0x0000, 0x3bb0, 0x044e, 0xfbb2,
    0x0000, 0x3f14, 0x00ea, 0xff16, 0x0000, 0x3f96, 0x0068, 0xff98, 0x0000, 0x0b9f,
    0xaecf, 0x5130, 0xa896, 0x0638, 0xf9c8, 0x0000, 0x3ffe, 0xb8ee, 0x5e7e, 0xda95,
    0x06eb, 0xf915, 0x0000, 0x3ffe, 0xb72f, 0x6e3e, 0x88b8, 0x0908, 0xf6f8, 0x0000,
    0x3748, 0x8000, 0x88b2, 0x7754, 0xc8ac, 0x374e, 0x08b3, 0x8000, 0x4000, 0x374e,
    0x0000, 0x345f, 0x8ba0, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0004, 0x3ffc, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0002, 0x3ffe, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    // Program 23, 0x1700
    0x3214, 0x6e76, 0x312b, 0x2e4e, 0xc000, 0xeeba, 0x7426, 0x32da, 0x2a48, 0xc000,
    0xfffa, 0x4003, 0x8000, 0x8000, 0x8000, 0xbeba, 0x0141, 0xfebf, 0x0000, 0x3e4f,
    0x01af, 0xfe51, 0x0000, 0x3c36, 0x03c8, 0xfc38, 0x0000, 0x3a72, 0x058c, 0xfa74,
    0x0000, 0x3f14, 0x00ea, 0xff16, 0x0000, 0x3f64, 0x009a, 0xff66, 0x0000, 0x0dd7,
    0xac97, 0x5368, 0xa65e, 0x0638, 0xf9c8, 0x0000, 0x3ffe, 0xb8ee, 0x60b6, 0x985d,
    0x06eb, 0xf915, 0x0000, 0x3ffe, 0xb72f, 0x76f6, 0x0908, 0xf6f8, 0x0000, 0x3980,
    0x8000, 0x867a, 0x798c, 0xc674, 0x3986, 0x067b, 0x8000, 0x4000, 0x3986, 0x0000,
    0x3227, 0x8dd8, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0004, 0x3ffc, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0002, 0x3ffe, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    // Program 24, 0x1800
    0x31ba, 0x6c14, 0x2f9b, 0x329a, 0xc000, 0xee3d, 0x724b, 0x2fba, 0x2fc0, 0xc000,
    0xfffa, 0x416b, 0x0001, 0xbfff, 0x7e98, 0x8000, 0x8000, 0x8000, 0xbeba, 0x0141,
    0xfebf, 0x0000, 0x3e4f, 0x01af, 0xfe51, 0x0000, 0x3c9a, 0x0364, 0xfc9c, 0x0000,
    0x3a72, 0x058c, 0xfa74, 0x0000, 0x3f14, 0x00ea, 0xff16, 0x0000, 0x3f64, 0x009a,
    0xff66, 0x0000, 0x0d73, 0xab07, 0x54f8, 0xa406, 0x0700, 0xf900, 0x0000, 0x3ffe,
    0xb826, 0x76bb, 0x0943, 0xf6bd, 0x0000, 0x3ffe, 0xb8bf, 0x75ca, 0x0a34, 0xf5cc,
    0x0000, 0x3e94, 0x8166, 0x7e9a, 0x0167, 0x8000, 0x4000, 0x3e9a, 0x0000, 0x328b,
    0x8d74, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0004, 0x3ffc, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0002, 0x3ffe, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    // Program 25, 0x1900
    0x31ba, 0x6c14, 0x2f9b, 0x329a, 0xc000, 0xee3d, 0x724b, 0x2fba, 0x2fc0, 0xc000,
    0xfffa, 0x4003, 0x8000, 0x8000, 0x8000, 0xbeba, 0x0141, 0xfebf, 0x0000, 0x3e4f,
    0x01af, 0xfe51, 0x0000, 0x3c9a, 0x0364, 0xfc9c, 0x0000, 0x3a72, 0x058c, 0xfa74,
    0x0000, 0x3f14, 0x00ea, 0xff16, 0x0000, 0x3f64, 0x009a, 0xff66, 0x0000, 0x0d73,
    0xab07, 0x54f8, 0xa406, 0x0700, 0xf900, 0x0000, 0x3ffe, 0xb826, 0x76bb, 0x0943,
    0xf6bd, 0x0000, 0x3ffe, 0xb8bf, 0x75ca, 0x0a34, 0xf5cc, 0x0000, 0x3e94, 0x8000,
    0x8166, 0x7ea0, 0xc160, 0x3e9a, 0x0167, 0x8000, 0x4000, 0x3e9a, 0x0000, 0x328b,
    0x8d74, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0004, 0x3ffc, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0002, 0x3ffe, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    // Program 26, 0x1a00
    0x31b0, 0x6e12, 0x2f37, 0x310a, 0xc000, 0xee56, 0x73c2, 0x30e6, 0x2d04, 0xc000,
    0xfffa, 0x43c3, 0x0001, 0xbfff, 0x7c40, 0x8000, 0x8000, 0x8000, 0xbeba, 0x0141,
    0xfebf, 0x0000, 0x3e4f, 0x01af, 0xfe51, 0x0000, 0x3c36, 0x03c8, 0xfc38, 0x0000,
    0x3a0e, 0x05f0, 0xfa10, 0x0000, 0x3f14, 0x00ea, 0xff16, 0x0000, 0x3f64, 0x009a,
    0xff66, 0x0000, 0x0e3b, 0xab6b, 0x5494, 0xa596, 0x05d4, 0xfa2c, 0x0000, 0x3ffe,
    0xb7c2, 0x784b, 0x07b3, 0xf84d, 0x0000, 0x3ffe, 0xb72f, 0x76f6, 0x0908, 0xf6f8,
    0x0000, 0x3c3c, 0x8000, 0x83be, 0x7c48, 0xc3b8, 0x3c42, 0x03bf, 0x8000, 0x4000,
    0x3c42, 0x0000, 0x31c3, 0x8e3c, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0004, 0x3ffc, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0002, 0x3ffe, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    // Program 27, 0x1b00
    0x31ba, 0x6e08, 0x3383, 0x2cbe, 0xc000, 0xef69, 0x7313, 0x2d87, 0x2fff, 0xc000,
    0xfffa, 0x4003, 0x8000, 0x8000, 0x8000, 0xbeba, 0x0141, 0xfebf, 0x0000, 0x3e4f,
    0x01af, 0xfe51, 0x0000, 0x3c9a, 0x0364, 0xfc9c, 0x0000, 0x3a72, 0x058c, 0xfa74,
    0x0000, 0x3f14, 0x00ea, 0xff16, 0x0000, 0x3f64, 0x009a, 0xff66, 0x0000, 0x0d73,
    0xacfb, 0x5304, 0xa5fa, 0x0700, 0xf900, 0x0000, 0x3ffe, 0xb826, 0x76bb, 0x0943,
    0xf6bd, 0x0000, 0x3ffe, 0xb6cb, 0x75ca, 0x0a34, 0xf5cc, 0x0000, 0x3e94, 0x8000,
    0x8166, 0x7ea0, 0xc160, 0x3e9a, 0x0167, 0x8000, 0x4000, 0x3e9a, 0x0000, 0x328b,
    0x8d74, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0004, 0x3ffc, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0002, 0x3ffe, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    // Program 28, 0x1c00
    0x314c, 0x6c1e, 0x312b, 0x316e, 0xc000, 0xee49, 0x7307, 0x301e, 0x2e94, 0xc000,
    0xfffa, 0x4297, 0x0001, 0xbfff, 0x7d6c, 0x8000, 0x8000, 0x8000, 0xbeba, 0x0141,
    0xfebf, 0x0000, 0x3e4f, 0x01af, 0xfe51, 0x0000, 0x3c36, 0x03c8, 0xfc38, 0x0000,
    0x39aa, 0x0654, 0xf9ac, 0x0000, 0x3f14, 0x00ea, 0xff16, 0x0000, 0x3f64, 0x009a,
    0xff66, 0x0000, 0x0e9f, 0xab07, 0x54f8, 0xc000, 0xeb08, 0x14f8, 0xa4ce, 0x0638,
    0xf9c8, 0x0000, 0x3ffe, 0xb826, 0x630e, 0x9411, 0x08df, 0xf721, 0x0000, 0x3ffe,
    0xb793, 0x76f6, 0x0908, 0xf6f8, 0x0000, 0x3d68, 0x8000, 0x8292, 0x7d74, 0xc28c,
    0x3d6e, 0x0293, 0x8000, 0x4000, 0x3d6e, 0x0000, 0x315f, 0x8ea0, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0004, 0x3ffc, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0002, 0x3ffe, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    // Program 29, 0x1d00
    0x33a4, 0x6c82, 0x2d43, 0x329a, 0xc000, 0xf095, 0x724b, 0x2fba, 0x2d68, 0xc000,
    0xfffa, 0x42fb, 0x0001, 0xbfff, 0x7d08, 0x8000, 0x8000, 0x8000, 0xbeba, 0x0141,
    0xfebf, 0x0000, 0x3e4f, 0x01af, 0xfe51, 0x0000, 0x3c9a, 0x0364, 0xfc9c, 0x0000,
    0x3b9e, 0x0460, 0xfba0, 0x0000, 0x3f14, 0x00ea, 0xff16, 0x0000, 0x3f64, 0x009a,
    0xff66, 0x0000, 0x0c47, 0xae27, 0x51d8, 0xa65e, 0x07c8, 0xf838, 0x0000, 0x3ffe,
    0xb826, 0x617e, 0x953d, 0x0943, 0xf6bd, 0x0000, 0x3ffe, 0xb7f7, 0x72ce, 0xc000,
    0xcd32, 0x35ca, 0x0a34, 0xf5cc, 0x0000, 0x3d04, 0x8000, 0x82f6, 0x7d10, 0xc2f0,
    0x3d0a, 0x02f7, 0x8000, 0x4000, 0x3d0a, 0x0000, 0x33b7, 0x8c48, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0004, 0x3ffc, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0002, 0x3ffe, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    // Program 30, 0x1e00
    0x314c, 0x6a8e, 0x2e0b, 0x361e, 0xc000, 0xed6c, 0x7254, 0x2f56, 0x30ec, 0xc000,
    0xfffa, 0x403f, 0x0001, 0xbfff, 0x7fc4, 0x8000, 0x8000, 0x8000, 0xbeba, 0x0141,
    0xfebf, 0x0000, 0x3e4f, 0x01af, 0xfe51, 0x0000, 0x3c36, 0x03c8, 0xfc38, 0x0000,
    0x39aa, 0x0654, 0xf9ac, 0x0000, 0x3f14, 0x00ea, 0xff16, 0x0000, 0x3f64, 0x009a,
    0xff66, 0x0000, 0x0e9f, 0xab07, 0x54f8, 0xc000, 0xeb08, 0x14f8, 0xa33e, 0x07c8,
    0xf838, 0x0000, 0x3ffe, 0xb7c2, 0x6502, 0x91b9, 0x0943, 0xf6bd, 0x0000, 0x3ffe,
    0xb793, 0x76f6, 0x0908, 0xf6f8, 0x0000, 0x3fc0, 0x8000, 0x803a, 0x7fcc, 0xc034,
    0x3fc6, 0x003b, 0x8000, 0x4000, 0x3fc6, 0x0000, 0x315f, 0x8ea0, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0004, 0x3ffc, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0002, 0x3ffe, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    // Program 31, 0x1f00
    0x33a4, 0x6bba, 0x2c7b, 0x342a, 0xc000, 0xf095, 0x7183, 0x2ef2, 0x2ef8, 0xc000,
    0xfffa, 0x4003, 0x8000, 0x8000, 0x8000, 0xbeba, 0x0141, 0xfebf, 0x0000, 0x3e4f,
    0x01af, 0xfe51, 0x0000, 0x3c9a, 0x0364, 0xfc9c, 0x0000, 0x3b9e, 0x0460, 0xfba0,
    0x0000, 0x3f14, 0x00ea, 0xff16, 0x0000, 0x3f64, 0x009a, 0xff66, 0x0000, 0x0c47,
    0xad5f, 0x4000, 0x3836, 0x07c8, 0xf838, 0x0000, 0x3ffe, 0xb7c2, 0x62aa, 0x93ad,
    0x09a7, 0xf659, 0x0000, 0x3ffe, 0xb72f, 0x75ca, 0x0a34, 0xf5cc, 0x0000, 0x3f5c,
    0x8000, 0x809e, 0x7f68, 0xc098, 0x3f62, 0x009f, 0x8000, 0x4000, 0x3f62, 0x0000,
    0x33b7, 0x8c48, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0004, 0x3ffc, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0002, 0x3ffe, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    // Program 32, 0x2000
    0x33a4, 0x6c82, 0x2d43, 0x329a, 0xc000, 0xf095, 0x724b, 0x2fba, 0x2d68, 0xc000,
    0xfffa, 0x42fb, 0x0001, 0xbfff, 0x7d08, 0x8000, 0x8000, 0x8000, 0xbeba, 0x0141,
    0xfebf, 0x0000, 0x3e4f, 0x01af, 0xfe51, 0x0000, 0x3c9a, 0x0364, 0xfc9c, 0x0000,
    0x3b9e, 0x0460, 0xfba0, 0x0000, 0x3f14, 0x00ea, 0xff16, 0x0000, 0x3f64, 0x009a,
    0xff66, 0x0000, 0x0c47, 0xae27, 0x51d8, 0xc000, 0xee28, 0x3836, 0x07c8, 0xf838,
    0x0000, 0x3ffe, 0xb826, 0x617e, 0x953d, 0x0943, 0xf6bd, 0x0000, 0x3ffe, 0xb7f7,
    0x72ce, 0x82fc, 0x0a34, 0xf5cc, 0x0000, 0x3d04, 0x82f6, 0x7d0a, 0x02f7, 0x8000,
    0x4000, 0x3d0a, 0x0000, 0x33b7, 0x8c48, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0004, 0x3ffc, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0002, 0x3ffe, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    // Program 33, 0x2100
    0x3814, 0x7199, 0x33f8, 0x225e, 0xc000, 0xf631, 0x756e, 0x34b0, 0x1fb3, 0xc000,
    0xfffa, 0x4003, 0x8000, 0x8000, 0x8000, 0xbf1e, 0x00dd, 0xff23, 0x0000, 0x3ed1,
    0x012d, 0xfed3, 0x0000, 0x3e15, 0x01e9, 0xfe17, 0x0000, 0x3d2d, 0x02d1, 0xfd2f,
    0x0000, 0x3f53, 0x00ab, 0xff55, 0x0000, 0x3fa5, 0x0059, 0xffa7, 0x0000, 0x07d7,
    0xb5ba, 0x4a45, 0xaf1d, 0x069c, 0xf964, 0x0000, 0x3ffe, 0xbae2, 0x5603, 0xc000,
    0xe9fd, 0x1603, 0xa2f2, 0x0709, 0xf8f7, 0x0000, 0x3ffe, 0xba4f, 0x62c1, 0xc000,
    0x8000, 0x8000, 0x9715, 0x0628, 0xf9d8, 0x0000, 0x28eb, 0x8000, 0x970f, 0x68f7,
    0xd709, 0x28f1, 0x1710, 0x8000, 0x4000, 0x28f1, 0x0000, 0x3827, 0x87d8, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0004, 0x3ffc, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0002, 0x3ffe, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    // Program 34, 0x2200
    0x314c, 0x6dae, 0x3063, 0x30a6, 0xc000, 0xee3d, 0x73db, 0x3212, 0x2bd8, 0xc000,
    0xfffa, 0x4003, 0x8000, 0x8000, 0x8000, 0xbeba, 0x0141, 0xfebf, 0x0000, 0x3e4f,
    0x01af, 0xfe51, 0x0000, 0x3c36, 0x03c8, 0xfc38, 0x0000, 0x39aa, 0x0654, 0xf9ac,
    0x0000, 0x3f14, 0x00ea, 0xff16, 0x0000, 0x3f64, 0x009a, 0xff66, 0x0000, 0x0e9f,
    0xabcf, 0x5430, 0xa596, 0x0638, 0xf9c8, 0x0000, 0x3ffe, 0xb952, 0x611a, 0x96cd,
    0x0817, 0xf7e9, 0x0000, 0x3ffe, 0xb85b, 0x70da, 0xc000, 0x8000, 0x8000, 0x861c,
    0x0908, 0xf6f8, 0x0000, 0x39e4, 0x8000, 0x8616, 0x79f0, 0xc610, 0x39ea, 0x0617,
    0x8000, 0x4000, 0x39ea, 0x0000, 0x315f, 0x8ea0, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0004, 0x3ffc, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0002, 0x3ffe, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    // Program 35, 0x2300
    0x314c, 0x6a8e, 0x2e0b, 0x361e, 0xc000, 0xed6c, 0x7254, 0x2f56, 0x30ec, 0xc000,
    0xfffa, 0x4003, 0x8000, 0x8000, 0x8000, 0xbeba, 0x0141, 0xfebf, 0x0000, 0x3e4f,
    0x01af, 0xfe51, 0x0000, 0x3c36, 0x03c8, 0xfc38, 0x0000, 0x39aa, 0x0654, 0xf9ac,
    0x0000, 0x3f14, 0x00ea, 0xff16, 0x0000, 0x3f64, 0x009a, 0xff66, 0x0000, 0x0e9f,
    0xab07, 0x4000, 0x3836, 0x07c8, 0xf838, 0x0000, 0x3ffe, 0xb7c2, 0x6502, 0xc000,
    0xdafe, 0x2502, 0x91b9, 0x0943, 0xf6bd, 0x0000, 0x3ffe, 0xb793, 0x76f6, 0x0908,
    0xf6f8, 0x0000, 0x3fc0, 0x8000, 0x803a, 0x7fcc, 0xc034, 0x3fc6, 0x003b, 0x8000,
    0x4000, 0x3fc6, 0x0000, 0x315f, 0x8ea0, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0004, 0x3ffc, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0002, 0x3ffe, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    // Program 36, 0x2400
    0x314c, 0x6a8e, 0x2e0b, 0x361e, 0xc000, 0xed6c, 0x7254, 0x2f56, 0x30ec, 0xc000,
    0xfffa, 0x403f, 0x0001, 0xbfff, 0x7fc4, 0x8000, 0x8000, 0x8000, 0xbeba, 0x0141,
    0xfebf, 0x0000, 0x3e4f, 0x01af, 0xfe51, 0x0000, 0x3c36, 0x03c8, 0xfc38, 0x0000,
    0x39aa, 0x0654, 0xf9ac, 0x0000, 0x3f14, 0x00ea, 0xff16, 0x0000, 0x3f64, 0x009a,
    0xff66, 0x0000, 0x0e9f, 0xab07, 0x4000, 0x3836, 0x07c8, 0xf838, 0x0000, 0x3ffe,
    0xb7c2, 0x6502, 0xc000, 0xdafe, 0x2502, 0x91b9, 0x0943, 0xf6bd, 0x0000, 0x3ffe,
    0xb793, 0x76f6, 0x0908, 0xf6f8, 0x0000, 0x3fc0, 0x8000, 0x803a, 0x7fcc, 0xc034,
    0x3fc6, 0x003b, 0x8000, 0x4000, 0x3fc6, 0x0000, 0x315f, 0x8ea0, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0004, 0x3ffc, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0002, 0x3ffe, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    // Program 37, 0x2500
    0x346c, 0x6bba, 0x2e6f, 0x316e, 0xc000, 0xf15d, 0x7183, 0x30e6, 0x2c3c, 0xc000,
    0xfffa, 0x42fb, 0x0001, 0xbfff, 0x7d08, 0x8000, 0x8000, 0x8000, 0xbeba, 0x0141,
    0xfebf, 0x0000, 0x3e4f, 0x01af, 0xfe51, 0x0000, 0x3cfe, 0x0300, 0xfd00, 0x0000,
    0x3c02, 0x03fc, 0xfc04, 0x0000, 0x3f14, 0x00ea, 0xff16, 0x0000, 0x3f64, 0x009a,
    0xff66, 0x0000, 0x0b7f, 0xae27, 0x51d8, 0xa65e, 0x07c8, 0xf838, 0x0000, 0x3ffe,
    0xb952, 0x6052, 0x9669, 0x0943, 0xf6bd, 0x0000, 0x3ffe, 0xb6cb, 0x72ce, 0xc000,
    0x8000, 0x8000, 0x82fc, 0x0a34, 0xf5cc, 0x0000, 0x3d04, 0x82f6, 0x7d0a, 0x02f7,
    0x8000, 0x4000, 0x3d0a, 0x0000, 0x347f, 0x8b80, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0004, 0x3ffc, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0002, 0x3ffe, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    // Program 38, 0x2600
    0x314c, 0x6a8e, 0x2e0b, 0x361e, 0xc000, 0xee3d, 0x7183, 0x2f56, 0x30ec, 0xc000,
    0xfffa, 0x4003, 0x8000, 0x8000, 0x8000, 0xbeba, 0x0141, 0xfebf, 0x0000, 0x3e4f,
    0x01af, 0xfe51, 0x0000, 0x3c36, 0x03c8, 0xfc38, 0x0000, 0x39aa, 0x0654, 0xf9ac,
    0x0000, 0x3f14, 0x00ea, 0xff16, 0x0000, 0x3f64, 0x009a, 0xff66, 0x0000, 0x0e9f,
    0xab07, 0x54f8, 0xc000, 0x8000, 0x8000, 0xa33e, 0x07c8, 0xf838, 0x0000, 0x3ffe,
    0xb7c2, 0x6502, 0xc000, 0x8000, 0x8000, 0x91b9, 0x0943, 0xf6bd, 0x0000, 0x3ffe,
    0xb793, 0x76b6, 0x8040, 0x0908, 0xf6f8, 0x0000, 0x3fc0, 0x8000, 0x803a, 0x7fcc,
    0xc034, 0x3fc6, 0x003b, 0x8000, 0x4000, 0x3fc6, 0x0000, 0x315f, 0x8ea0, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0004, 0x3ffc, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0002, 0x3ffe, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    // Program 39, 0x2700
    0x314c, 0x6a8e, 0x2f37, 0x34f2, 0xc000, 0xedd9, 0x7183, 0x301e, 0x3088, 0xc000,
    0xfffa, 0x403f, 0x0001, 0xbfff, 0x7fc4, 0x8000, 0x8000, 0x8000, 0xbeba, 0x0141,
    0xfebf, 0x0000, 0x3e4f, 0x01af, 0xfe51, 0x0000, 0x3c36, 0x03c8, 0xfc38, 0x0000,
    0x39aa, 0x0654, 0xf9ac, 0x0000, 0x3f14, 0x00ea, 0xff16, 0x0000, 0x3f64, 0x009a,
    0xff66, 0x0000, 0x0e9f, 0xab07, 0x54f8, 0xa33e, 0x07c8, 0xf838, 0x0000, 0x3ffe,
    0xb7c2, 0x6502, 0x91b9, 0x0943, 0xf6bd, 0x0000, 0x3ffe, 0xb793, 0x76b6, 0xc000,
    0x8000, 0x8000, 0x8040, 0x0908, 0xf6f8, 0x0000, 0x3fc0, 0x8000, 0x803a, 0x7fcc,
    0xc034, 0x3fc6, 0x003b, 0x8000, 0x4000, 0x3fc6, 0x0000, 0x315f, 0x8ea0, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0004, 0x3ffc, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0002, 0x3ffe, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    // Program 40, 0x2800
    0x314c, 0x6a8e, 0x2e0b, 0x361e, 0xc000, 0xed6c, 0x7254, 0x2f56, 0x30ec, 0xc000,
    0xfffa, 0x403f, 0x0001, 0xbfff, 0x7fc4, 0x8000, 0x8000, 0x8000, 0xbeba, 0x0141,
    0xfebf, 0x0000, 0x3e4f, 0x01af, 0xfe51, 0x0000, 0x3c36, 0x03c8, 0xfc38, 0x0000,
    0x39aa, 0x0654, 0xf9ac, 0x0000, 0x3f14, 0x00ea, 0xff16, 0x0000, 0x3f64, 0x009a,
    0xff66, 0x0000, 0x0e9f, 0xab07, 0x54f8, 0xc000, 0x8000, 0x8000, 0xa33e, 0x07c8,
    0xf838, 0x0000, 0x3ffe, 0xb7c2, 0x6502, 0xc000, 0xdafe, 0x2502, 0x91b9, 0x0943,
    0xf6bd, 0x0000, 0x3ffe, 0xb793, 0x76b6, 0x8040, 0x0908, 0xf6f8, 0x0000, 0x3fc0,
    0x803a, 0x7fc6, 0x003b, 0x8000, 0x4000, 0x3fc6, 0x0000, 0x315f, 0x8ea0, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0004, 0x3ffc, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0002, 0x3ffe, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    // Program 41, 0x2900
    0x314c, 0x6a8e, 0x2e0b, 0x361e, 0xc000, 0xee3d, 0x7183, 0x2f56, 0x30ec, 0xc000,
    0xfffa, 0x4003, 0x8000, 0x8000, 0x8000, 0xbeba, 0x0141, 0xfebf, 0x0000, 0x3e4f,
    0x01af, 0xfe51, 0x0000, 0x3c36, 0x03c8, 0xfc38, 0x0000, 0x39aa, 0x0654, 0xf9ac,
    0x0000, 0x3f14, 0x00ea, 0xff16, 0x0000, 0x3f64, 0x009a, 0xff66, 0x0000, 0x0e9f,
    0xab07, 0x54f8, 0xa33e, 0x07c8, 0xf838, 0x0000, 0x3ffe, 0xb7c2, 0x6502, 0xc000,
    0xdafe, 0x2502, 0x91b9, 0x0943, 0xf6bd, 0x0000, 0x3ffe, 0xb793, 0x76b6, 0xc000,
    0x8000, 0x8000, 0x8040, 0x0908, 0xf6f8, 0x0000, 0x3fc0, 0x8000, 0x803a, 0x7fcc,
    0xc034, 0x3fc6, 0x003b, 0x8000, 0x4000, 0x3fc6, 0x0000, 0x315f, 0x8ea0, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0004, 0x3ffc, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0002, 0x3ffe, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    // Program 42, 0x2a00
    0x314c, 0x6bba, 0x2e0b, 0x34f2, 0xc000, 0xed6c, 0x7380, 0x2f56, 0x2fc0, 0xc000,
    0xfffa, 0x403f, 0x0001, 0xbfff, 0x7fc4, 0x8000, 0x8000, 0x8000, 0xbeba, 0x0141,
    0xfebf, 0x0000, 0x3e4f, 0x01af, 0xfe51, 0x0000, 0x3c36, 0x03c8, 0xfc38, 0x0000,
    0x39aa, 0x0654, 0xf9ac, 0x0000, 0x3f14, 0x00ea, 0xff16, 0x0000, 0x3f64, 0x009a,
    0xff66, 0x0000, 0x0e9f, 0xac33, 0x4000, 0x3836, 0x07c8, 0xf838, 0x0000, 0x3ffe,
    0xb7c2, 0x63d6, 0xc000, 0xdc2a, 0x23d6, 0x92e5, 0x0943, 0xf6bd, 0x0000, 0x3ffe,
    0xb72f, 0x75ee, 0x8040, 0x09d0, 0xf630, 0x0000, 0x3fc0, 0x8000, 0x803a, 0x7fcc,
    0xc034, 0x3fc6, 0x003b, 0x8000, 0x4000, 0x3fc6, 0x0000, 0x315f, 0x8ea0, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0004, 0x3ffc, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0002, 0x3ffe, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    // Program 43, 0x2b00
    0x314c, 0x6a8e, 0x2f37, 0x34f2, 0xc000, 0xedd9, 0x7183, 0x301e, 0x3088, 0xc000,
    0xfffa, 0x4003, 0x8000, 0x8000, 0x8000, 0xbeba, 0x0141, 0xfebf, 0x0000, 0x3e4f,
    0x01af, 0xfe51, 0x0000, 0x3c36, 0x03c8, 0xfc38, 0x0000, 0x39aa, 0x0654, 0xf9ac,
    0x0000, 0x3f14, 0x00ea, 0xff16, 0x0000, 0x3f64, 0x009a, 0xff66, 0x0000, 0x0e9f,
    0xab07, 0x54f8, 0xc000, 0xeb08, 0x14f8, 0xa33e, 0x07c8, 0xf838, 0x0000, 0x3ffe,
    0xb7c2, 0x6502, 0xc000, 0xdafe, 0x2502, 0x91b9, 0x0943, 0xf6bd, 0x0000, 0x3ffe,
    0xb793, 0x76b6, 0xc000, 0x8000, 0x8000, 0x8040, 0x0908, 0xf6f8, 0x0000, 0x3fc0,
    0x8000, 0x803a, 0x7fcc, 0xc034, 0x3fc6, 0x003b, 0x8000, 0x4000, 0x3fc6, 0x0000,
    0x315f, 0x8ea0, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0004, 0x3ffc, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0002, 0x3ffe, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    // Program 44, 0x2c00
    0x314c, 0x6a8e, 0x2e0b, 0x361e, 0xc000, 0xed6c, 0x7254, 0x2f56, 0x30ec, 0xc000,
    0xfffa, 0x403f, 0x0001, 0xbfff, 0x7fc4, 0x8000, 0x8000, 0x8000, 0xbeba, 0x0141,
    0xfebf, 0x0000, 0x3e4f, 0x01af, 0xfe51, 0x0000, 0x3c36, 0x03c8, 0xfc38, 0x0000,
    0x39aa, 0x0654, 0xf9ac, 0x0000, 0x3f14, 0x00ea, 0xff16, 0x0000, 0x3f64, 0x009a,
    0xff66, 0x0000, 0x0e9f, 0xab07, 0x54f8, 0xc000, 0xeb08, 0x14f8, 0xa33e, 0x07c8,
    0xf838, 0x0000, 0x3ffe, 0xb7c2, 0x6502, 0xc000, 0xdafe, 0x2502, 0x91b9, 0x0943,
    0xf6bd, 0x0000, 0x3ffe, 0xb793, 0x76b6, 0xc000, 0x8000, 0x8000, 0x8040, 0x0908,
    0xf6f8, 0x0000, 0x3fc0, 0x8000, 0x803a, 0x7fcc, 0xc034, 0x3fc6, 0x003b, 0x8000,
    0x4000, 0x3fc6, 0x0000, 0x315f, 0x8ea0, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0004, 0x3ffc, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0002, 0x3ffe, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    // Program 45, 0x2d00
    0x314c, 0x6a8e, 0x2e0b, 0x361e, 0xc000, 0xed6c, 0x7254, 0x2f56, 0x30ec, 0xc000,
    0xfffa, 0x4003, 0x8000, 0x8000, 0x8000, 0xbeba, 0x0141, 0xfebf, 0x0000, 0x3e4f,
    0x01af, 0xfe51, 0x0000, 0x3c36, 0x03c8, 0xfc38, 0x0000, 0x39aa, 0x0654, 0xf9ac,
    0x0000, 0x3f14, 0x00ea, 0xff16, 0x0000, 0x3f64, 0x009a, 0xff66, 0x0000, 0x0e9f,
    0xab07, 0x4000, 0x3836, 0x07c8, 0xf838, 0x0000, 0x3ffe, 0xb7c2, 0x6502, 0xc000,
    0xdafe, 0x2502, 0x91b9, 0x0943, 0xf6bd, 0x0000, 0x3ffe, 0xb793, 0x76b6, 0xc000,
    0x8000, 0x8000, 0x8040, 0x0908, 0xf6f8, 0x0000, 0x3fc0, 0x8000, 0x803d, 0x7fc9,
    0xc037, 0x3fc3, 0x003e, 0x8000, 0x4000, 0x3fc3, 0x0000, 0x315f, 0x8ea0, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0004, 0x3ffc, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0002, 0x3ffe, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    // Program 46, 0x2e00
    0x314c, 0x6bba, 0x2c7b, 0x3682, 0xc000, 0xee32, 0x718e, 0x2e2a, 0x3218, 0xc000,
    0xfffa, 0x405d, 0x0001, 0xbfff, 0x7fa6, 0x8000, 0x8000, 0x8000, 0xbeba, 0x0141,
    0xfebf, 0x0000, 0x3e4f, 0x01af, 0xfe51, 0x0000, 0x3c36, 0x03c8, 0xfc38, 0x0000,
    0x39aa, 0x0654, 0xf9ac, 0x0000, 0x3f14, 0x00ea, 0xff16, 0x0000, 0x3f64, 0x009a,
    0xff66, 0x0000, 0x0e9f, 0xab07, 0x4000, 0x3836, 0x07c8, 0xf838, 0x0000, 0x3ffe,
    0xb75e, 0x6566, 0xc000, 0xda9a, 0x2566, 0x9155, 0x0943, 0xf6bd, 0x0000, 0x3ffe,
    0xb7b1, 0x76fc, 0xc000, 0x8000, 0x8000, 0x805e, 0x08a4, 0xf75c, 0x0000, 0x3fa2,
    0x8000, 0x8058, 0x7fae, 0xc052, 0x3fa8, 0x0059, 0x8000, 0x4000, 0x3fa8, 0x0000,
    0x315f, 0x8ea0, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0004, 0x3ffc, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0002, 0x3ffe, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    // Program 47, 0x2f00
    0x3164, 0x6ce6, 0x312b, 0x308e, 0xc000, 0xed84, 0x7380, 0x314a, 0x2db4, 0xc000,
    0xfffa, 0x4313, 0x0001, 0xbfff, 0x7cf0, 0x8000, 0x8000, 0x8000, 0xbeba, 0x0141,
    0xfebf, 0x0000, 0x3e4f, 0x01af, 0xfe51, 0x0000, 0x3c36, 0x03c8, 0xfc38, 0x0000,
    0x39aa, 0x0654, 0xf9ac, 0x0000, 0x3f0b, 0x00f3, 0xff0d, 0x0000, 0x3f85, 0x0079,
    0xff87, 0x0000, 0x0e87, 0xac4b, 0x4000, 0x3836, 0x07c8, 0xf838, 0x0000, 0x3ffe,
    0xb9b6, 0x61ca, 0xc000, 0xde36, 0x21ca, 0x94f1, 0x0943, 0xf6bd, 0x0000, 0x3ffe,
    0xb8bf, 0x7252, 0xc000, 0xcdae, 0x3252, 0x8314, 0x0a98, 0xf568, 0x0000, 0x3cec,
    0xc30e, 0x0001, 0x8000, 0x4000, 0x3cf2, 0x0000, 0x3177, 0x8e88, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0004, 0x3ffc, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0002, 0x3ffe, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    // Program 48, 0x3000
    0x32d4, 0x6a8e, 0x2e0b, 0x3496, 0xc000, 0xeef4, 0x7254, 0x2f56, 0x2f64, 0xc000,
    0xfffa, 0x4003, 0x8000, 0x8000, 0x8000, 0xbeba, 0x0141, 0xfebf, 0x0000, 0x3e4f,
    0x01af, 0xfe51, 0x0000, 0x3c36, 0x03c8, 0xfc38, 0x0000, 0x39aa, 0x0654, 0xf9ac,
    0x0000, 0x0d17, 0xac8f, 0x4000, 0x3836, 0x07c8, 0xf838, 0x0000, 0x3ffe, 0xb7c2,
    0x637a, 0xc000, 0xdc86, 0x237a, 0x9341, 0x0943, 0xf6bd, 0x0000, 0x3ffe, 0xb793,
    0x752e, 0xc000, 0xcad2, 0x352e, 0x8038, 0x0a98, 0xf568, 0x0000, 0x3fc8, 0x8000,
    0x8035, 0x7fd1, 0xc02f, 0x3fcb, 0x0036, 0x8000, 0x4000, 0x3fcb, 0x0000, 0x32e7,
    0x8d18, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0004, 0x3ffc, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0002, 0x3ffe, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    // Program 49, 0x3100
    0x32d4, 0x6a8e, 0x2e0b, 0x3496, 0xc000, 0xeef4, 0x7254, 0x2f56, 0x2f64, 0xc000,
    0xfffa, 0x4037, 0x0001, 0xbfff, 0x7fcc, 0x8000, 0x8000, 0x8000, 0xbeba, 0x0141,
    0xfebf, 0x0000, 0x3e4f, 0x01af, 0xfe51, 0x0000, 0x3c36, 0x03c8, 0xfc38, 0x0000,
    0x39aa, 0x0654, 0xf9ac, 0x0000, 0x0d17, 0xac8f, 0x4000, 0x3836, 0x07c8, 0xf838,
    0x0000, 0x3ffe, 0xb7c2, 0x637a, 0xc000, 0xdc86, 0x237a, 0x9341, 0x0943, 0xf6bd,
    0x0000, 0x3ffe, 0xb793, 0x752e, 0xc000, 0xcad2, 0x352e, 0x8038, 0x0a98, 0xf568,
    0x0000, 0x3fc8, 0xc032, 0x0001, 0x8000, 0x4000, 0x3fce, 0x0000, 0x32e7, 0x8d18,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0004, 0x3ffc, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0002, 0x3ffe, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    // Program 50, 0x3200
    0x0009, 0x48dc, 0x0015, 0xffeb, 0x0000, 0x3fc9, 0x0035, 0xffcb, 0x0000, 0x3f51,
    0x00ad, 0xff53, 0x0000, 0x3804, 0x8006, 0x47d4, 0x0020, 0xffe0, 0x0000, 0x3fb3,
    0x004b, 0xffb5, 0x0000, 0x3f79, 0x0085, 0xff7b, 0x0000, 0x38fc, 0xbf58, 0x7fba,
    0x3f4d, 0x3f86, 0x3f1d, 0x3f8e, 0x3f42, 0x3fca, 0x3f8e, 0x3f37, 0x3f87, 0x3f45,
    0x3f88, 0x3f48, 0x3f99, 0x3f95, 0x3f45, 0x0996, 0xbff6, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0004, 0x3ffc, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0002, 0x3ffe, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    // Program 51, 0x3300
    0x0009, 0x48dc, 0x0015, 0xffeb, 0x0000, 0x3fc9, 0x0035, 0xffcb, 0x0000, 0x3f51,
    0x00ad, 0xff53, 0x0000, 0x3804, 0x8006, 0x47d4, 0x0020, 0xffe0, 0x0000, 0x3fb3,
    0x004b, 0xffb5, 0x0000, 0x3f79, 0x0085, 0xff7b, 0x0000, 0x38fc, 0xbf58, 0x7fba,
    0x3f4d, 0x3f86, 0x3f1d, 0x3f8e, 0x3f42, 0x3fca, 0x3f8e, 0x3f37, 0x3f87, 0x3f45,
    0x3f88, 0x3f48, 0x3f99, 0x3f95, 0x3f45, 0x3f78, 0x3f72, 0x3f68, 0x3f5d, 0x3fab,
    0x3f6e, 0x3f48, 0x3f8a, 0x0dfc, 0xbff6, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0004, 0x3ffc, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0002, 0x3ffe, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    // Program 52, 0x3400
    0x0009, 0x48dc, 0x0015, 0xffeb, 0x0000, 0x3fc9, 0x0035, 0xffcb, 0x0000, 0x3f51,
    0x00ad, 0xff53, 0x0000, 0x3804, 0x8006, 0x47d4, 0x0020, 0xffe0, 0x0000, 0x3fb3,
    0x004b, 0xffb5, 0x0000, 0x3f79, 0x0085, 0xff7b, 0x0000, 0x38fc, 0xbf58, 0x7fba,
    0x3f4d, 0x3f86, 0x3f1d, 0x3f8e, 0x3f42, 0x3fca, 0x3f8e, 0x3f37, 0x3f87, 0x3f45,
    0x3f88, 0x3f48, 0x3f99, 0x3f95, 0x3f45, 0x3f78, 0x3f72, 0x3f68, 0x3f5d, 0x3fab,
    0x3f6e, 0x3f48, 0x3f8a, 0x3f64, 0x3f5c, 0x3f6f, 0x3f8a, 0x3f97, 0x3f15, 0x3fc0,
    0x11d7, 0xbff6, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0004, 0x3ffc, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0002, 0x3ffe, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    // Program 53, 0x3500
    0x0009, 0x48dc, 0x0015, 0xffeb, 0x0000, 0x3fc9, 0x0035, 0xffcb, 0x0000, 0x3f51,
    0x00ad, 0xff53, 0x0000, 0x3804, 0x8006, 0x47d4, 0x0020, 0xffe0, 0x0000, 0x3fb3,
    0x004b, 0xffb5, 0x0000, 0x3f79, 0x0085, 0xff7b, 0x0000, 0x38fc, 0xbf58, 0x7fba,
    0x3f4d, 0x3f86, 0x3f1d, 0x3f8e, 0x3f42, 0x3fca, 0x3f8e, 0x3f37, 0x3f87, 0x3f45,
    0x3f88, 0x3f48, 0x3f99, 0x3f95, 0x3f45, 0x3f78, 0x3f72, 0x3f68, 0x3f5d, 0x3fab,
    0x3f6e, 0x3f48, 0x3f8a, 0x3f64, 0x3f5c, 0x3f6f, 0x3f8a, 0x3f97, 0x3f15, 0x3fc0,
    0x3f55, 0x3f86, 0x3f47, 0x3fa1, 0x3f96, 0x3f46, 0x3f8f, 0x3f1f, 0x3fb2, 0x16d8,
    0xbff6, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0004, 0x3ffc, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0002, 0x3ffe, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    // Program 54, 0x3600
    0x0009, 0x48dc, 0x0015, 0xffeb, 0x0000, 0x3fc9, 0x0035, 0xffcb, 0x0000, 0x3f51,
    0x00ad, 0xff53, 0x0000, 0x3804, 0x8006, 0x47d4, 0x0020, 0xffe0, 0x0000, 0x3fb3,
    0x004b, 0xffb5, 0x0000, 0x3f79, 0x0085, 0xff7b, 0x0000, 0x38fc, 0xbf58, 0x7fba,
    0x3f4d, 0x3f86, 0x3f1d, 0x3f8e, 0x3f42, 0x3fca, 0x3f8e, 0x3f37, 0x3f87, 0x3f45,
    0x3f88, 0x3f48, 0x3f99, 0x3f95, 0x3f45, 0x3f78, 0x3f72, 0x3f68, 0x3f5d, 0x3fab,
    0x3f6e, 0x3f48, 0x3f8a, 0x3f64, 0x3f5c, 0x3f6f, 0x3f8a, 0x3f97, 0x3f15, 0x3fc0,
    0x3f55, 0x3f86, 0x3f47, 0x3fa1, 0x3f96, 0x3f46, 0x3f8f, 0x3f1f, 0x3fb2, 0x3f3a,
    0x3f84, 0x3fc0, 0x3f21, 0x3fa8, 0x3f08, 0x3fb3, 0x3f4c, 0x1b8a, 0xbff6, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0004, 0x3ffc, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0002, 0x3ffe, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    // Program 55, 0x3700
    0x0009, 0x48dc, 0x0015, 0xffeb, 0x0000, 0x3fc9, 0x0035, 0xffcb, 0x0000, 0x3f51,
    0x00ad, 0xff53, 0x0000, 0x3804, 0x8006, 0x47d4, 0x0020, 0xffe0, 0x0000, 0x3fb3,
    0x004b, 0xffb5, 0x0000, 0x3f79, 0x0085, 0xff7b, 0x0000, 0x38fc, 0xbf58, 0x7fba,
    0x3f4d, 0x3f86, 0x3f1d, 0x3f8e, 0x3f42, 0x3fca, 0x3f8e, 0x3f37, 0x3f87, 0x3f45,
    0x3f88, 0x3f48, 0x3f99, 0x3f95, 0x3f45, 0x3f78, 0x3f72, 0x3f68, 0x3f5d, 0x3fab,
    0x3f6e, 0x3f48, 0x3f8a, 0x3f64, 0x3f5c, 0x3f6f, 0x3f8a, 0x3f97, 0x3f15, 0x3fc0,
    0x3f55, 0x3f86, 0x3f47, 0x3fa1, 0x3f96, 0x3f46, 0x3f8f, 0x3f1f, 0x3fb2, 0x3f3a,
    0x3f84, 0x3fc0, 0x3f21, 0x3fa8, 0x3f08, 0x3fb3, 0x3f4c, 0x3fa9, 0x3fa1, 0x3f26,
    0x3fa1, 0x3f36, 0x3f65, 0x3f71, 0x3f90, 0x3f7c, 0x2061, 0xbff6, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0004, 0x3ffc, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0002, 0x3ffe, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    // Program 56, 0x3800
    0x0009, 0x48dc, 0x0015, 0xffeb, 0x0000, 0x3fc9, 0x0035, 0xffcb, 0x0000, 0x3f51,
    0x00ad, 0xff53, 0x0000, 0x3804, 0x8006, 0x47d4, 0x0020, 0xffe0, 0x0000, 0x3fb3,
    0x004b, 0xffb5, 0x0000, 0x3f79, 0x0085, 0xff7b, 0x0000, 0x38fc, 0xbf58, 0x7fba,
    0x3f4d, 0x3f86, 0x3f1d, 0x3f8e, 0x3f42, 0x3fca, 0x3f8e, 0x3f37, 0x3f87, 0x3f45,
    0x3f88, 0x3f48, 0x3f99, 0x3f95, 0x3f45, 0x3f78, 0x3f72, 0x3f68, 0x3f5d, 0x3fab,
    0x3f6e, 0x3f48, 0x3f8a, 0x3f64, 0x3f5c, 0x3f6f, 0x3f8a, 0x3f97, 0x3f15, 0x3fc0,
    0x3f55, 0x3f86, 0x3f47, 0x3fa1, 0x3f96, 0x3f46, 0x3f8f, 0x3f1f, 0x3fb2, 0x3f3a,
    0x3f84, 0x3fc0, 0x3f21, 0x3fa8, 0x3f08, 0x3fb3, 0x3f4c, 0x3fa9, 0x3fa1, 0x3f26,
    0x3fa1, 0x3f36, 0x3f65, 0x3f71, 0x3f90, 0x3f7c, 0x3f57, 0x3f8a, 0x3f79, 0x3f47,
    0x3f81, 0x3f61, 0x3fd4, 0x240a, 0xbff6, 0x0004, 0x3ffc, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0002, 0x3ffe, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    // Program 57, 0x3900
    0x0009, 0x48dc, 0x0015, 0xffeb, 0x0000, 0x3fc9, 0x0035, 0xffcb, 0x0000, 0x3f51,
    0x00ad, 0xff53, 0x0000, 0x3804, 0x8006, 0x47d4, 0x0020, 0xffe0, 0x0000, 0x3fb3,
    0x004b, 0xffb5, 0x0000, 0x3f79, 0x0085, 0xff7b, 0x0000, 0x38fc, 0xbf58, 0x7fba,
    0x3f4d, 0x3f86, 0x3f1d, 0x3f8e, 0x3f42, 0x3fca, 0x3f8e, 0x3f37, 0x3f87, 0x3f45,
    0x3f88, 0x3f48, 0x3f99, 0x3f95, 0x3f45, 0x3f78, 0x3f72, 0x3f68, 0x3f5d, 0x3fab,
    0x3f6e, 0x3f48, 0x3f8a, 0x3f64, 0x3f5c, 0x3f6f, 0x3f8a, 0x3f97, 0x3f15, 0x3fc0,
    0x3f55, 0x3f86, 0x3f47, 0x3fa1, 0x3f96, 0x3f46, 0x3f8f, 0x3f1f, 0x3fb2, 0x3f3a,
    0x3f84, 0x3fc0, 0x3f21, 0x3fa8, 0x3f08, 0x3fb3, 0x3f4c, 0x3fa9, 0x3fa1, 0x3f26,
    0x3fa1, 0x3f36, 0x3f65, 0x3f71, 0x3f90, 0x3f7c, 0x3f57, 0x3f8a, 0x3f79, 0x3f47,
    0x3f81, 0x3f61, 0x3fd4, 0x3f16, 0x3fc0, 0x252e, 0x19d6, 0x3f9a, 0x3f4d, 0x3fc0,
    0x3f51, 0x3f71, 0x3f6a, 0x3f64, 0x3faf, 0x3f30, 0x3f5e, 0x3fbb, 0x3f1f, 0x2ce2,
    0xbff6, 0x0002, 0x3ffe, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    // Program 58, 0x3a00
    0x0009, 0x48dc, 0x0015, 0xffeb, 0x0000, 0x3fc9, 0x0035, 0xffcb, 0x0000, 0x3f51,
    0x00ad, 0xff53, 0x0000, 0x3804, 0x8006, 0x47d4, 0x0020, 0xffe0, 0x0000, 0x3fb3,
    0x004b, 0xffb5, 0x0000, 0x3f79, 0x0085, 0xff7b, 0x0000, 0x38fc, 0xbf58, 0x7fba,
    0x3f4d, 0x3f86, 0x3f1d, 0x3f8e, 0x3f42, 0x3fca, 0x3f8e, 0x3f37, 0x3f87, 0x3f45,
    0x3f88, 0x3f48, 0x3f99, 0x3f95, 0x3f45, 0x3f78, 0x3f72, 0x3f68, 0x3f5d, 0x3fab,
    0x3f6e, 0x3f48, 0x3f8a, 0x3f64, 0x3f5c, 0x3f6f, 0x3f8a, 0x3f97, 0x3f15, 0x3fc0,
    0x3f55, 0x3f86, 0x3f47, 0x3fa1, 0x3f96, 0x3f46, 0x3f8f, 0x3f1f, 0x3fb2, 0x3f3a,
    0x3f84, 0x3fc0, 0x3f21, 0x3fa8, 0x3f08, 0x3fb3, 0x3f4c, 0x3fa9, 0x3fa1, 0x3f26,
    0x3fa1, 0x3f36, 0x3f65, 0x3f71, 0x3f90, 0x3f7c, 0x3f57, 0x3f8a, 0x3f79, 0x3f47,
    0x3f81, 0x3f61, 0x3fd4, 0x3f16, 0x3fc0, 0x252e, 0x19d6, 0x3f9a, 0x3f4d, 0x3fc0,
    0x3f51, 0x3f71, 0x3f6a, 0x3f64, 0x3faf, 0x3f30, 0x3f5e, 0x3fbb, 0x3f1f, 0x3fbd,
    0x3f57, 0x2dc6, 0x11b6, 0x3f1d, 0x3fda, 0x3f59, 0x3f78, 0x3f9b, 0x3f1a, 0x3fbb,
    0x3f19, 0x3301, 0xbff6, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    // Program 59, 0x3b00
    0x0009, 0x48dc, 0x0015, 0xffeb, 0x0000, 0x3fc9, 0x0035, 0xffcb, 0x0000, 0x3f51,
    0x00ad, 0xff53, 0x0000, 0x1c8a, 0x0000, 0x1b7a, 0x8006, 0x47d4, 0x0020, 0xffe0,
    0x0000, 0x3fb3, 0x004b, 0xffb5, 0x0000, 0x3f79, 0x0085, 0xff7b, 0x0000, 0x1d80,
    0x0000, 0x1b7c, 0xbf58, 0x7fba, 0x3f4d, 0x3f86, 0x3f1d, 0x3f8e, 0x3dd1, 0x013b,
    0x3d19, 0x0747, 0xfbd6, 0x3e16, 0x3f45, 0x01fd, 0x3cd3, 0x3f99, 0x3d2c, 0x01ae,
    0x3d5a, 0x0190, 0x0aa2, 0xf72f, 0x3cf4, 0x01c9, 0x3d50, 0x3f48, 0x3f8a, 0x3c65,
    0x025b, 0x3f6f, 0x3f8a, 0x3d47, 0x12f2, 0xf172, 0x3cc1, 0x3f55, 0x01d6, 0x3cf7,
    0x3cdd, 0x025a, 0x3f46, 0x3d1e, 0x1810, 0xe980, 0x0276, 0x3c76, 0x01f5, 0x3d4f,
    0x3f21, 0x1939, 0xbff6, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0004, 0x3ffc, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0002, 0x3ffe, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    // Program 60, 0x3c00
    0x0009, 0x48dc, 0x0015, 0xffeb, 0x0000, 0x3fc9, 0x0035, 0xffcb, 0x0000, 0x3f51,
    0x00ad, 0xff53, 0x0000, 0x1362, 0x0000, 0x24a2, 0x8006, 0x47d4, 0x0020, 0xffe0,
    0x0000, 0x3fb3, 0x004b, 0xffb5, 0x0000, 0x3f79, 0x0085, 0xff7b, 0x0000, 0x1458,
    0x0000, 0x24a4, 0xbf58, 0x7fba, 0x3f4d, 0x3f86, 0x3f1d, 0x3f8e, 0x38ca, 0x0642,
    0x3f8e, 0x3f37, 0x3c0f, 0x02bd, 0x3f88, 0x0747, 0xf801, 0x3f99, 0x3f95, 0x02bd,
    0x3c00, 0x05ea, 0x38f0, 0x3f5d, 0x3ba4, 0x0375, 0x3f48, 0x3bef, 0x02ff, 0x0e8e,
    0xf0ce, 0x3f6f, 0x0391, 0x3b90, 0x02b0, 0x3c25, 0x3f55, 0x3f86, 0x3c24, 0x02c4,
    0x3f96, 0x3f46, 0x3d1e, 0x1810, 0xe980, 0x02d5, 0x3c17, 0x01f5, 0x3d4f, 0x3f21,
    0x3fa8, 0x3a24, 0x0497, 0x3f4c, 0x3d47, 0x0203, 0x3f26, 0x1d10, 0xe291, 0x0198,
    0x3d03, 0x0455, 0x3aac, 0x3f7c, 0x3f57, 0x2104, 0x1e86, 0x3f79, 0x2207, 0xbff6,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0002, 0x3ffe, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    // Program 61, 0x3d00
    0x0009, 0x48dc, 0x0015, 0xffeb, 0x0000, 0x3fc9, 0x0035, 0xffcb, 0x0000, 0x3f51,
    0x00ad, 0xff53, 0x0000, 0x0a3b, 0x0000, 0x2dc9, 0x8006, 0x47d4, 0x0020, 0xffe0,
    0x0000, 0x3fb3, 0x004b, 0xffb5, 0x0000, 0x3f79, 0x0085, 0xff7b, 0x0000, 0x0b31,
    0x0000, 0x2dcb, 0xbf58, 0x7fba, 0x3f4d, 0x3f86, 0x3f1d, 0x3f8e, 0x3f42, 0x3fca,
    0x3f8e, 0x3f37, 0x3b87, 0x0345, 0x3f88, 0x3b6a, 0x0377, 0x0866, 0xf72f, 0x3f45,
    0x0378, 0x3b72, 0x3f68, 0x033b, 0x3bcd, 0x3f6e, 0x3f48, 0x3f8a, 0x3a47, 0x0479,
    0x3f6f, 0x3d4b, 0x01d6, 0x10a2, 0xee73, 0x3fc0, 0x0194, 0x3d47, 0x0464, 0x3a84,
    0x3f96, 0x3f46, 0x3f8f, 0x3f1f, 0x3bb4, 0x0338, 0x3f84, 0x3fc0, 0x3c79, 0x0250,
    0x1987, 0xe581, 0x03b1, 0x3b4e, 0x0251, 0x3cf9, 0x3f26, 0x3fa1, 0x3f36, 0x3f65,
    0x3f71, 0x3b63, 0x03a9, 0x3f57, 0x3f8a, 0x217a, 0x1ad2, 0x0274, 0x22b6, 0xdccb,
    0x3f61, 0x0401, 0x3ae9, 0x02ed, 0x3bd7, 0x3f9a, 0x3f4d, 0x3fc0, 0x3f51, 0x3f71,
    0x3f6a, 0x2955, 0x160f, 0x3faf, 0x3f30, 0x3f5e, 0x3fbb, 0x2c01, 0xbff6, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    // Program 62, 0x3e00
    0x0009, 0x48dc, 0x0015, 0xffeb, 0x0000, 0x3fc9, 0x0035, 0xffcb, 0x0000, 0x3f51,
    0x00ad, 0xff53, 0x0000, 0x0151, 0x0000, 0x36b3, 0x8006, 0x47d4, 0x0020, 0xffe0,
    0x0000, 0x3fb3, 0x004b, 0xffb5, 0x0000, 0x3f79, 0x0085, 0xff7b, 0x0000, 0x0247,
    0x0000, 0x36b5, 0xbbd2, 0x3fca, 0x3f8e, 0x3f37, 0x3f87, 0x3f45, 0x3f88, 0x3f48,
    0x3a0d, 0x0521, 0x3f45, 0x3d5a, 0x0190, 0x0aa2, 0xf4c6, 0x3f5d, 0x01c9, 0x3d50,
    0x3f48, 0x0516, 0x39d8, 0x3f5c, 0x3f6f, 0x3f8a, 0x3f97, 0x3f15, 0x3fc0, 0x3f55,
    0x3f86, 0x3b5e, 0x038a, 0x3f96, 0x3c24, 0x02b1, 0x159f, 0xe980, 0x3fb2, 0x0323,
    0x3b9b, 0x02e2, 0x3bff, 0x3fa8, 0x3f08, 0x3fb3, 0x3f4c, 0x3fa9, 0x3fa1, 0x3ac0,
    0x0407, 0x3f36, 0x3f65, 0x3ad4, 0x042d, 0x3f7c, 0x2057, 0xdf00, 0x03f0, 0x3b13,
    0x3f47, 0x3f81, 0x3f61, 0x0471, 0x3a79, 0x24ee, 0x1ad2, 0x3f04, 0x3f9a, 0x3f4d,
    0x3fc0, 0x3f51, 0x3903, 0x05d8, 0x3f64, 0x3c2b, 0x02b4, 0x3f5e, 0x2bb2, 0xd409,
    0x3f1f, 0x2cda, 0x12e3, 0x02db, 0x3bf8, 0x058b, 0x396c, 0x3f59, 0x3f78, 0x3f9b,
    0x3f1a, 0x3fbb, 0x3f19, 0x3f55, 0x3f5f, 0x3f64, 0x34e9, 0xbff6,
    // Program 63, 0x3f00
    0x3f00, 0xff7d, 0xff7d, 0xff7d, 0xff7d, 0xff7d, 0xff7d, 0xff7d, 0xff7d, 0xff7d,
    0xff7d, 0xff7d, 0xff7d, 0xff7d, 0xff7d, 0xff7d, 0xff7d, 0xff7d, 0xff7d, 0xff7d,
    0xff7d, 0xff7d, 0xff7d, 0xff7d, 0xff7d, 0xff7d, 0xff7d, 0xff7d, 0xff7d, 0xff7d,
    0xff7d, 0xff7d, 0xff7d, 0xff7d, 0xff7d, 0xff7d, 0xff7d, 0xff7d, 0xff7d, 0xff7d,
    0xff7d, 0xff7d, 0xff7d, 0xff7d, 0xff7d, 0xff7d, 0xff7d, 0xff7d, 0xff7d, 0xff7d,
    0xff7d, 0xff7d, 0xff7d, 0xff7d, 0xff7d, 0xff7d, 0xff7d, 0xff7d, 0xff7d, 0xff7d,
    0xff7d, 0xff7d, 0xff7d, 0xff7d, 0xff7d, 0xff7d, 0xff7d, 0xff7d, 0xff7d, 0xff7d,
    0xff7d, 0xff7d, 0xff7d, 0xff7d, 0xff7d, 0xff7d, 0xff7d, 0xff7d, 0xff7d, 0xff7d,
    0xff7d, 0xff7d, 0xff7d, 0xff7d, 0xff7d, 0xff7d, 0xff7d, 0xff7d, 0xff7d, 0xff7d,
    0xff7d, 0xff7d, 0xff7d, 0xff7d, 0xff7d, 0xf01f, 0x0f5e, 0xff7d, 0xff7d, 0xff7d,
    0xff7d, 0xff7d, 0xff7d, 0xff7d, 0xff7d, 0xff7d, 0xff7d, 0xff7d, 0xff7d, 0xff7d,
    0xfcc1, 0xfa86, 0x07b3, 0xff7d, 0xff7d, 0xff7d, 0xff7d, 0xff7d, 0xff7d, 0xff7d,
    0xff7d, 0xff7d, 0xff7d, 0xff7d, 0xff7d, 0xff7d, 0xff7d, 0xff75};
// clang-format on
