#!/usr/bin/env python3

# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU Lesser General Public License
# as published by the Free Software Foundation; either version 2.1
# of the License, or (at your option) any later version.

# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU Lesser General Public License for more details.

from sh4lt import ShType
import json

# Create a Sh4lt description (a ShType object)
shtype = ShType("text/x-raw", "talk", ShType.default_group())
assert shtype

# Set several properties and check them
shtype.set_prop("format", "I420")
shtype.set_prop("height", 4096)
shtype.set_prop("interlace-mode", "progressive")
shtype.set_prop("label", "unexpected \\= comma\\,")
shtype.set_prop("multiview-mode", "mono")
shtype.set_prop("width", 4096)
shtype.set_prop("pi", 3.14)
shtype.set_prop("is_something", True)
shtype.set_custom_prop("framerate", "fraction", "30/1")
shtype.set_custom_prop("pixel-aspect-ratio", "fraction", "1/1")
assert shtype.get_prop("format").as_str() == "I420"
assert shtype.get_prop("framerate").as_str() =="30/1"
assert shtype.get_prop("height").as_int() == 4096
assert shtype.get_prop("interlace-mode").as_str(), "progressive"
assert shtype.get_prop("label").as_str() == "unexpected \\= comma\\,"
assert shtype.get_prop("multiview-mode").as_str() == "mono"
assert shtype.get_prop("pixel-aspect-ratio").as_str() == "1/1"
assert shtype.get_prop("width").as_int() == 4096
assert shtype.get_prop("width").as_int() == 4096
assert shtype.get_prop("pi").as_float() == 3.14
print(shtype.get_prop("is_something").as_bool())
assert shtype.get_prop("is_something").as_bool()
assert shtype.get_prop("do not exist").is_empty()

# Check serialization and deserialization
shtype_str = ShType.serialize(shtype)
assert len(shtype_str) > 0
print(shtype_str)
parsed = json.loads(shtype_str)
assert parsed['group'] == ShType.default_group()
assert parsed['label'] == "talk"
assert parsed['media'] == "text/x-raw"
assert parsed['property']['is_something']
shtype2 = ShType.deserialize(shtype_str)
shtype2_str = ShType.serialize(shtype2)
print(shtype2_str)
assert shtype2.get_prop("format").as_str() == "I420"
assert shtype2.get_prop("framerate").as_str() =="30/1"
assert shtype2.get_prop("height").as_int() == 4096
assert shtype2.get_prop("interlace-mode").as_str(), "progressive"
assert shtype2.get_prop("label").as_str() == "unexpected \\= comma\\,"
assert shtype2.get_prop("multiview-mode").as_str() == "mono"
assert shtype2.get_prop("pixel-aspect-ratio").as_str() == "1/1"
assert shtype2.get_prop("width").as_int() == 4096
assert shtype2.get_prop("width").as_int() == 4096
assert shtype2.get_prop("pi").as_float() == 3.14
assert shtype2.get_prop("is_something").as_bool()
assert shtype2.get_prop("do not exist").is_empty()
assert shtype_str == ShType.serialize(shtype2)

# check deserialization errors caused by malformed JSON
shtype3 = ShType.deserialize('{')
assert len(shtype3.deserialization_errors()) > 0

# check deserialization errors of well formed JSON, but with missing
# required JSON entries
shtype4 = ShType.deserialize('{}')
assert len(shtype4.deserialization_errors()) > 0

# check serialization of bogus shtype return empty string
assert len(ShType.serialize(shtype3)) == 0
assert len(ShType.serialize(shtype4)) == 0
