function(disable_qt_plugins theTarget)
  if(NOT TARGET Qt6::Core)
    return()
  endif()

  get_target_property(QtType Qt6::Core TYPE)

  if(NOT ("${QtType}" STREQUAL "STATIC_LIBRARY"))
    return()
  endif()

  set_target_properties(${theTarget}
    PROPERTIES
      QT_NO_PLUGINS
        "${Qt6Core_PLUGINS};${Qt6Gui_PLUGINS};${Qt6Widgets_PLUGINS};${Qt6Network_PLUGINS};${Qt6Qml_PLUGINS}"
      QT_PLUGINS_iconengines "-"
      QT_PLUGINS_networkinformation "-"
      QT_PLUGINS_platforms "-"
      QT_PLUGINS_imageformats "-"
      QT_PLUGINS_qmllint "-"
      QT_PLUGINS_scxmldatamodel "-"
      QT_PLUGINS_permissions "-"
  )
endfunction()

function(enable_minimal_qt_plugins theTarget gui)
  if(NOT TARGET Qt6::Core)
    return()
  endif()

  get_target_property(QtType Qt6::Core TYPE)
  if(NOT ("${QtType}" STREQUAL "STATIC_LIBRARY"))
    return()
  endif()

  function(link_if_exists _theLib)
    if(TARGET ${_theLib})
      target_link_libraries(${theTarget} PRIVATE ${_theLib})
    endif()
  endfunction()

  # rg -i 'Qt6::[a-zA-Z0-9_]+plugin' --only-matching --no-filename  --no-line-number |sort | uniq | awk '{ print "link_if_exists(" $1 ")"}'

  link_if_exists(Qt6::QOffscreenIntegrationPlugin)
  link_if_exists(Qt6::QMinimalIntegrationPlugin)
  link_if_exists(Qt6::QWindowsIntegrationPlugin)
  # link_if_exists(Qt6::QWindowsDirect2DIntegrationPlugin) # very slow and ugly!!
  link_if_exists(Qt6::QCocoaIntegrationPlugin)
  link_if_exists(Qt6::QTlsBackendOpenSSLPlugin)
  link_if_exists(Qt6::QSchannelBackendPlugin)
  # link_if_exists(Qt6::QTlsBackendCertOnlyPlugin)

  if(${gui})

  link_if_exists(Qt6::QXcbIntegrationPlugin)
  link_if_exists(Qt6::QXcbGlxIntegrationPlugin)
  link_if_exists(Qt6::QXcbEglIntegrationPlugin)
  link_if_exists(Qt6::QWaylandIntegrationPlugin)
  link_if_exists(Qt6::QWaylandEglPlatformIntegrationPlugin)
  link_if_exists(Qt6::QWaylandQtShellIntegrationPlugin)
  link_if_exists(Qt6::QWaylandWlShellIntegrationPlugin)
  link_if_exists(Qt6::QWaylandFullScreenShellV1IntegrationPlugin)
  link_if_exists(Qt6::QWaylandEglClientBufferPlugin)
  link_if_exists(Qt6::QWaylandXdgShellIntegrationPlugin)
  link_if_exists(Qt6::QWaylandXdgShellV5IntegrationPlugin)
  link_if_exists(Qt6::QWaylandXdgShellV6IntegrationPlugin)
  link_if_exists(Qt6::QWaylandBradientDecorationPlugin)
  link_if_exists(Qt6::QWaylandFullScreenShellV1IntegrationPlugin)
  link_if_exists(Qt6::QEglFSIntegrationPlugin)
  link_if_exists(Qt6::QEglFSX11IntegrationPlugin)
  link_if_exists(Qt6::QEglFSKmsEglDeviceIntegrationPlugin)
  link_if_exists(Qt6::QEglFSKmsGbmIntegrationPlugin)
  link_if_exists(Qt6::DmaBufServerBufferPlugin)
  link_if_exists(Qt6::DrmEglServerBufferPlugin)
  link_if_exists(Qt6::QMinimalEglIntegrationPlugin)
  link_if_exists(Qt6::QVkKhrDisplayIntegrationPlugin)
  link_if_exists(Qt6::QEvdevKeyboardPlugin)
  link_if_exists(Qt6::QEvdevMousePlugin)
  link_if_exists(Qt6::QEvdevTabletPlugin)
  link_if_exists(Qt6::QEvdevTouchScreenPlugin)
  link_if_exists(Qt6::QXdgDesktopPortalThemePlugin)
  link_if_exists(Qt6::ShmServerBufferPlugin)
  link_if_exists(Qt6::VulkanServerBufferPlugin)
  
  link_if_exists(Qt6::QVncIntegrationPlugin)

  link_if_exists(Qt6::QWasmIntegrationPlugin)

  link_if_exists(Qt6::QGifPlugin)
  link_if_exists(Qt6::QICNSPlugin)
  link_if_exists(Qt6::QICOPlugin)
  link_if_exists(Qt6::QJpegPlugin)
  link_if_exists(Qt6::QSvgIconPlugin)
  link_if_exists(Qt6::QSvgPlugin)
  link_if_exists(Qt6::QTgaPlugin)
  link_if_exists(Qt6::QTiffPlugin)
  link_if_exists(Qt6::QWbmpPlugin)
  link_if_exists(Qt6::QWebpPlugin)
  link_if_exists(Qt6::QMacHeifPlugin)
  link_if_exists(Qt6::QMacJp2Plugin)

  link_if_exists(Qt6::qmlmetaPlugin)


  # link_if_exists(Qt6::QNLMNIPlugin)
  # link_if_exists(Qt6::QScxmlEcmaScriptDataModelPlugin)
  # link_if_exists(Qt6::QmlLintQdsPlugin)
  # link_if_exists(Qt6::QmlLintQuickPlugin)
  link_if_exists(Qt6::LabsPlatformplugin)
  link_if_exists(Qt6::LabsSynchronizerplugin)
  link_if_exists(Qt6::PlatformPlugin)
  link_if_exists(Qt6::QAppleNetworkInformationPlugin)
#  link_if_exists(Qt6::QSCNetworkReachabilityNetworkInformationPlugin)
  link_if_exists(Qt6::QDarwinBluetoothPermissionPlugin)
  link_if_exists(Qt6::QDarwinCalendarPermissionPlugin)
  link_if_exists(Qt6::QDarwinCameraPermissionPlugin)
  link_if_exists(Qt6::QDarwinContactsPermissionPlugin)
  link_if_exists(Qt6::QDarwinLocationPermissionPlugin)
  link_if_exists(Qt6::QDarwinMicrophonePermissionPlugin)
  link_if_exists(Qt6::QSecureTransportBackendPlugin)
  link_if_exists(Qt6::QmlNetworkplugin)
  link_if_exists(Qt6::QmlAssetDownloaderplugin)
  link_if_exists(Qt6::QDebugMessageServiceFactoryPlugin)
  link_if_exists(Qt6::QLocalClientConnectionFactoryPlugin)
  link_if_exists(Qt6::QSQLiteDriverPlugin)
  link_if_exists(Qt6::QTcpServerConnectionFactoryPlugin)
  link_if_exists(Qt6::effectsplugin)
  link_if_exists(Qt6::labsanimationplugin)
  link_if_exists(Qt6::labsmodelsplugin)
  link_if_exists(Qt6::modelsplugin)
  link_if_exists(Qt6::particlesplugin)
  link_if_exists(Qt6::qmlfolderlistmodelplugin)
  link_if_exists(Qt6::qmlplugin)
  link_if_exists(Qt6::qmlsettingsplugin)
  link_if_exists(Qt6::qmlshapesplugin)
  link_if_exists(Qt6::qquicklayoutsplugin)
  link_if_exists(Qt6::qquickvectorimagehelpersplugin)
  link_if_exists(Qt6::qquickvectorimageplugin)
  link_if_exists(Qt6::qtqmlcoreplugin)
  link_if_exists(Qt6::qtquick2plugin)
  link_if_exists(Qt6::qtquickcontrols2basicstyleimplplugin)
  link_if_exists(Qt6::qtquickcontrols2basicstyleplugin)
  link_if_exists(Qt6::qtquickcontrols2fluentwinui3styleimplplugin)
  link_if_exists(Qt6::qtquickcontrols2fluentwinui3styleplugin)
  link_if_exists(Qt6::qtquickcontrols2fusionstyleimplplugin)
  link_if_exists(Qt6::qtquickcontrols2fusionstyleplugin)
  link_if_exists(Qt6::qtquickcontrols2imaginestyleimplplugin)
  link_if_exists(Qt6::qtquickcontrols2imaginestyleplugin)
  link_if_exists(Qt6::qtquickcontrols2implplugin)
  link_if_exists(Qt6::qtquickcontrols2iosstyleimplplugin)
  link_if_exists(Qt6::qtquickcontrols2iosstyleplugin)
  link_if_exists(Qt6::qtquickcontrols2macosstyleimplplugin)
  link_if_exists(Qt6::qtquickcontrols2macosstyleplugin)
  link_if_exists(Qt6::qtquickcontrols2materialstyleimplplugin)
  link_if_exists(Qt6::qtquickcontrols2materialstyleplugin)
  link_if_exists(Qt6::qtquickcontrols2nativestyleplugin)
  link_if_exists(Qt6::qtquickcontrols2plugin)
  link_if_exists(Qt6::qtquickcontrols2universalstyleimplplugin)
  link_if_exists(Qt6::qtquickcontrols2universalstyleplugin)
  link_if_exists(Qt6::qtquickcontrols2windowsstyleimplplugin)
  link_if_exists(Qt6::qtquickcontrols2windowsstyleplugin)
  link_if_exists(Qt6::qtquickdialogs2quickimplplugin)
  link_if_exists(Qt6::qtquickdialogsplugin)
  link_if_exists(Qt6::qtquickshapesdesignhelpersplugin)
  link_if_exists(Qt6::qtquicktemplates2plugin)
  link_if_exists(Qt6::sharedimageplugin)
  link_if_exists(Qt6::workerscriptplugin)
  endif()
endfunction()
