// =============================================================================
// PROJECT CHRONO - http://projectchrono.org
//
// Copyright (c) 2014 projectchrono.org
// All rights reserved.
//
// Use of this source code is governed by a BSD-style license that can be found
// in the LICENSE file at the top level of the distribution and at
// http://projectchrono.org/license-chrono.txt.
//
// =============================================================================
// Authors: Radu Serban
// =============================================================================
//
// Rack-pinion steering model constructed with data from file (JSON format).
//
// =============================================================================

#include "chrono_vehicle/wheeled_vehicle/steering/RackPinion.h"
#include "chrono_vehicle/utils/ChUtilsJSON.h"

using namespace rapidjson;

namespace chrono {
namespace vehicle {

// -----------------------------------------------------------------------------
// -----------------------------------------------------------------------------
RackPinion::RackPinion(const std::string& filename) : ChRackPinion("") {
    Document d;
    ReadFileJSON(filename, d);
    if (d.IsNull())
        return;

    Create(d);

    std::cout << "Loaded JSON " << filename << std::endl;
}

RackPinion::RackPinion(const rapidjson::Document& d) : ChRackPinion("") {
    Create(d);
}

void RackPinion::Create(const rapidjson::Document& d) {
    // Invoke base class method.
    ChPart::Create(d);

    // Read steering link data
    m_steeringLinkMass = d["Steering Link"]["Mass"].GetDouble();
    m_steeringLinkInertia = ReadVectorJSON(d["Steering Link"]["Inertia"]);
    m_steeringLinkCOM = d["Steering Link"]["COM"].GetDouble();
    m_steeringLinkRadius = d["Steering Link"]["Radius"].GetDouble();
    m_steeringLinkLength = d["Steering Link"]["Length"].GetDouble();

    // Pinion radius
    m_pinionRadius = d["Pinion"]["Radius"].GetDouble();
    m_maxAngle = d["Pinion"]["Maximum Angle (deg)"].GetDouble() * CH_DEG_TO_RAD;
}

}  // end namespace vehicle
}  // end namespace chrono
