/* ============================================================================
 * Freetype GL - A C OpenGL Freetype engine
 * Platform:    Any
 * WWW:         http://code.google.com/p/freetype-gl/
 * ----------------------------------------------------------------------------
 * Copyright 2011,2012 Nicolas P. Rougier. All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 *  1. Redistributions of source code must retain the above copyright notice,
 *     this list of conditions and the following disclaimer.
 *
 *  2. Redistributions in binary form must reproduce the above copyright
 *     notice, this list of conditions and the following disclaimer in the
 *     documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY NICOLAS P. ROUGIER ''AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO
 * EVENT SHALL NICOLAS P. ROUGIER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
 * INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * The views and conclusions contained in the software and documentation are
 * those of the authors and should not be interpreted as representing official
 * policies, either expressed or implied, of Nicolas P. Rougier.
 * ===============================================================================
 */
#include <stddef.h>
#ifdef __cplusplus
extern "C" {
#endif

typedef struct
{
    wchar_t charcode;
    float kerning;
} kerning_t;

typedef struct
{
    wchar_t charcode;
    int width, height;
    int offset_x, offset_y;
    float advance_x, advance_y;
    float s0, t0, s1, t1;
    size_t kerning_count;
    kerning_t kerning[1];
} texture_glyph_t;

typedef struct
{
    size_t tex_width;
    size_t tex_height;
    size_t tex_depth;
    unsigned char tex_data[65536];
    float size;
    float height;
    float linegap;
    float ascender;
    float descender;
    size_t glyphs_count;
    texture_glyph_t glyphs[96];
} texture_font_t;

texture_font_t font_data = {
 256, 256, 1, 
 {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,255,255,255,255,0,0,204,255,255,255,255,72,0,152,255,255,255,255,72,0,0,0,0,216,255,255,255,255,8,0,0,
  0,0,0,0,0,0,0,0,228,255,255,255,87,0,0,0,208,255,255,255,114,0,0,0,0,0,0,0,0,0,0,120,
  255,255,56,0,0,0,0,0,0,0,0,0,0,0,21,140,218,248,235,177,66,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,5,53,98,116,121,100,77,33,0,0,0,0,0,0,0,0,0,184,255,255,
  255,255,40,0,0,0,0,0,0,31,243,255,255,255,85,0,3,218,255,255,255,138,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,244,255,255,84,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,136,255,255,255,252,0,
  0,0,0,0,0,0,0,0,0,0,0,56,255,255,255,255,255,188,0,68,255,255,255,255,255,255,255,255,255,255,255,192,
  0,116,255,255,255,255,255,228,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,31,251,255,255,251,30,0,0,0,
  0,255,255,255,255,0,0,204,255,255,255,255,72,0,152,255,255,255,255,72,0,0,0,0,216,255,255,255,255,8,0,0,
  0,0,0,0,0,0,0,29,255,255,255,255,29,0,0,12,252,255,255,255,55,0,0,0,0,0,0,0,0,0,0,120,
  255,255,56,0,0,0,0,0,0,0,0,0,0,57,236,255,255,255,255,255,255,140,1,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,11,136,236,255,255,255,255,255,255,255,227,105,0,0,0,0,0,0,0,184,255,255,
  255,255,40,0,0,0,0,0,0,184,255,255,255,207,1,0,0,90,255,255,255,252,50,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,244,255,255,84,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,136,255,255,255,252,0,
  0,0,0,0,0,0,0,0,0,0,0,56,255,255,255,255,255,188,0,68,255,255,255,255,255,255,255,255,255,255,255,192,
  0,116,255,255,255,255,255,228,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,145,255,255,255,163,0,0,0,0,
  0,255,255,255,255,0,0,204,255,255,255,255,72,0,152,255,255,255,255,72,0,0,0,0,216,255,255,255,255,8,0,0,
  0,0,0,0,0,0,0,86,255,255,255,227,0,0,0,66,255,255,255,246,5,0,0,0,0,0,0,0,0,0,0,120,
  255,255,56,0,0,0,0,0,0,0,0,0,34,239,255,255,255,255,255,255,255,255,121,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,28,219,255,255,255,255,255,255,255,255,255,255,152,0,0,0,0,0,0,0,184,255,255,
  255,255,40,0,0,0,0,0,85,255,255,255,255,80,0,0,0,2,215,255,255,255,202,1,0,0,0,0,0,0,0,0,
  0,0,0,0,0,244,255,255,84,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,136,255,255,255,252,0,
  0,0,0,0,0,0,0,0,0,0,0,56,255,255,255,255,255,188,0,68,255,255,255,255,255,255,255,255,255,255,255,192,
  0,116,255,255,255,255,255,228,0,0,0,0,0,0,0,0,0,0,0,0,0,0,18,244,255,255,255,45,0,0,0,0,
  0,255,255,255,255,0,0,204,255,255,255,255,72,0,152,255,255,255,255,72,0,0,0,0,216,255,255,255,255,8,0,0,
  0,0,0,0,0,0,0,143,255,255,255,169,0,0,0,123,255,255,255,193,0,0,0,0,0,0,0,0,0,0,0,120,
  255,255,56,0,0,0,0,0,0,0,0,0,175,255,255,255,255,255,255,255,255,255,249,29,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,2,205,255,255,255,255,255,255,255,255,255,255,255,152,0,0,0,0,0,0,0,184,255,255,
  255,255,40,0,0,0,0,7,222,255,255,255,217,1,0,0,0,0,101,255,255,255,255,91,0,0,0,0,0,0,116,134,
  14,0,0,0,0,244,255,255,84,0,0,0,0,78,181,6,0,0,0,0,0,0,0,0,0,0,136,255,255,255,252,0,
  0,0,0,0,0,0,0,0,0,0,0,56,255,255,255,255,255,188,0,68,255,255,255,255,255,255,255,255,255,255,255,192,
  0,116,255,255,255,255,255,228,0,0,0,0,0,0,0,0,0,0,0,0,0,0,125,255,255,255,183,0,0,0,0,0,
  0,0,0,0,0,0,0,204,255,255,255,255,72,0,152,255,255,255,255,72,0,0,0,0,216,255,255,255,255,8,0,0,
  0,0,0,0,0,0,0,200,255,255,255,111,0,0,0,180,255,255,255,134,0,0,0,0,0,0,0,0,0,0,0,120,
  255,255,56,0,0,0,0,0,0,0,0,20,253,255,255,236,84,13,42,187,255,255,255,124,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,84,255,255,255,255,255,255,255,255,255,255,255,255,152,0,0,0,0,0,0,0,184,255,255,
  255,255,40,0,0,0,0,111,255,255,255,255,106,0,0,0,0,0,7,234,255,255,255,224,5,0,0,0,0,21,242,255,
  235,109,5,0,0,244,255,255,84,0,0,55,194,255,255,109,0,0,0,0,0,0,0,0,0,0,136,255,255,255,252,0,
  0,0,0,0,0,0,0,0,0,0,0,56,255,255,255,255,255,188,0,68,255,255,255,255,255,255,255,255,255,255,255,192,
  0,116,255,255,255,255,255,228,0,0,0,0,0,0,0,0,0,0,0,0,0,8,233,255,255,255,65,0,0,0,0,0,
  0,0,0,0,0,0,0,204,255,255,255,255,72,0,152,255,255,255,255,72,0,0,0,0,216,255,255,255,255,8,0,0,
  0,0,0,0,0,0,7,249,255,255,255,53,0,0,0,236,255,255,255,75,0,0,0,0,0,0,0,30,134,201,236,253,
  255,255,251,236,203,152,83,17,0,0,0,73,255,255,255,92,0,0,0,12,233,255,255,179,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,161,255,255,255,255,255,149,50,22,32,76,147,236,152,0,0,0,0,0,0,0,184,255,255,
  255,255,40,0,0,0,5,227,255,255,255,245,14,0,0,0,0,0,0,141,255,255,255,255,95,0,0,0,0,125,255,255,
  255,255,219,84,0,244,255,255,84,36,171,255,255,255,255,222,2,0,0,0,0,0,0,0,0,0,136,255,255,255,252,0,
  0,0,0,0,0,0,0,0,0,0,0,67,255,255,255,255,255,164,0,68,255,255,255,255,255,255,255,255,255,255,255,192,
  0,116,255,255,255,255,255,228,0,0,0,0,0,0,0,0,0,0,0,0,0,105,255,255,255,203,0,0,0,0,0,0,
  0,0,0,0,0,0,0,204,255,255,255,255,72,0,152,255,255,255,255,72,0,0,0,0,216,255,255,255,255,8,0,0,
  0,0,0,0,0,0,58,255,255,255,246,4,0,0,38,255,255,255,254,17,0,0,0,0,0,0,110,250,255,255,255,255,
  255,255,255,255,255,255,255,253,7,0,0,90,255,255,255,36,0,0,0,0,188,255,255,198,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,196,255,255,255,255,187,0,0,0,0,0,0,11,55,0,0,0,0,0,0,0,184,255,255,
  255,255,40,0,0,0,96,255,255,255,255,162,0,0,0,0,0,0,0,43,255,255,255,255,212,0,0,0,0,2,92,220,
  255,255,255,255,199,249,255,255,198,250,255,255,255,248,145,22,0,0,0,0,0,0,0,0,0,0,136,255,255,255,252,0,
  0,0,0,0,0,0,0,0,0,0,0,127,255,255,255,255,255,48,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,116,255,255,255,255,255,228,0,0,0,0,0,0,0,0,0,0,0,0,2,220,255,255,255,85,0,0,0,0,0,0,
  0,0,0,0,0,0,0,204,255,255,255,255,72,0,152,255,255,255,255,72,0,0,0,0,216,255,255,255,255,8,0,0,
  0,0,0,0,0,0,115,255,255,255,193,0,0,0,95,255,255,255,213,0,0,0,0,0,0,109,255,255,255,255,255,255,
  255,255,255,255,255,255,255,255,8,0,0,74,255,255,255,92,0,0,0,10,232,255,255,181,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,204,255,255,255,255,158,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,184,255,255,
  255,255,40,0,0,0,198,255,255,255,255,76,0,0,0,0,0,0,0,0,214,255,255,255,255,57,0,0,0,0,0,4,
  102,226,255,255,255,255,255,255,255,255,255,252,157,30,0,0,0,0,0,0,0,0,0,0,0,0,136,255,255,255,252,0,
  0,0,0,0,0,0,0,0,0,0,0,190,255,255,255,255,178,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,85,255,255,255,220,2,0,0,0,0,0,0,
  0,0,0,0,0,0,0,204,255,255,255,255,72,0,152,255,255,255,255,72,0,0,0,0,216,255,255,255,255,8,0,0,
  0,200,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,100,0,27,247,255,255,255,255,255,255,
  255,255,255,255,255,255,255,255,8,0,0,22,254,255,255,236,84,13,40,182,255,255,255,125,0,0,0,0,0,0,0,0,
  2,0,0,0,0,0,0,0,176,255,255,255,255,225,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,184,255,255,
  255,255,40,0,0,39,255,255,255,255,243,8,0,0,0,0,0,0,0,0,132,255,255,255,255,155,0,0,0,0,0,0,
  0,7,111,232,255,255,255,255,255,254,168,38,0,0,0,0,0,0,192,255,255,255,255,255,255,255,255,255,255,255,255,255,
  255,255,255,255,255,255,255,44,0,0,7,246,255,255,255,255,53,0,0,0,0,0,0,0,0,1,57,94,119,106,79,20,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,202,255,255,255,105,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,204,255,255,255,255,72,0,152,255,255,255,255,72,0,0,0,0,216,255,255,255,255,8,0,0,
  0,200,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,100,0,125,255,255,255,255,255,207,197,
  255,255,173,166,209,253,255,255,8,0,0,0,178,255,255,255,255,255,255,255,255,255,250,31,0,0,0,0,0,1,70,174,
  170,0,0,0,0,0,0,0,113,255,255,255,255,255,87,0,0,0,0,0,0,0,0,0,0,0,0,0,0,184,255,255,
  255,255,40,0,0,121,255,255,255,255,181,0,0,0,0,0,0,0,0,0,62,255,255,255,255,234,2,0,0,0,0,0,
  0,4,102,227,255,255,255,255,255,252,159,32,0,0,0,0,0,0,192,255,255,255,255,255,255,255,255,255,255,255,255,255,
  255,255,255,255,255,255,255,44,0,0,62,255,255,255,255,183,0,0,0,0,0,0,0,2,114,225,255,255,255,255,255,250,
  177,37,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,65,255,255,255,234,8,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,204,255,255,255,255,72,0,152,255,255,255,255,72,0,0,0,0,216,255,255,255,255,8,0,0,
  0,200,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,100,0,188,255,255,255,255,160,1,120,
  255,255,56,0,0,20,113,229,8,0,0,0,38,241,255,255,255,255,255,255,255,255,124,0,0,0,0,20,117,220,255,255,
  249,19,0,0,0,0,0,0,24,250,255,255,255,255,220,7,0,0,0,0,0,0,0,0,0,0,0,0,0,184,255,255,
  255,255,40,0,0,196,255,255,255,255,117,0,0,0,0,0,0,0,0,0,7,247,255,255,255,255,57,0,0,0,0,2,
  92,220,255,255,255,255,255,255,255,255,255,249,148,24,0,0,0,0,192,255,255,255,255,255,255,255,255,255,255,255,255,255,
  255,255,255,255,255,255,255,44,0,0,125,255,255,255,255,57,0,0,0,0,0,0,15,189,255,255,255,255,255,255,255,255,
  255,243,85,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,182,255,255,255,125,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,204,255,255,255,255,72,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,200,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,100,0,214,255,255,255,255,57,0,120,
  255,255,56,0,0,0,0,9,1,0,0,0,0,62,238,255,255,255,255,255,255,144,1,0,0,59,164,248,255,255,252,180,
  80,4,0,0,0,0,0,0,0,156,255,255,255,255,255,127,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,8,250,255,255,255,255,61,0,0,0,0,0,0,0,0,0,0,199,255,255,255,255,119,0,0,1,83,213,
  255,255,255,255,200,249,255,255,199,251,255,255,255,245,136,18,0,0,192,255,255,255,255,255,255,255,255,255,255,255,255,255,
  255,255,255,255,255,255,255,44,0,0,189,255,255,255,188,0,0,0,0,0,0,2,180,255,255,255,255,255,255,255,255,255,
  255,255,249,57,0,0,0,0,0,0,0,0,0,0,0,0,0,0,44,255,255,255,245,19,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,197,255,255,255,255,66,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,112,144,144,144,219,255,255,255,203,144,144,144,207,255,255,255,215,144,144,144,144,56,0,214,255,255,255,255,63,0,120,
  255,255,56,0,0,0,0,0,0,0,0,0,0,0,24,143,220,248,236,179,68,0,14,106,211,255,255,255,224,126,28,0,
  0,0,0,0,0,0,0,0,0,44,255,255,255,255,255,248,39,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,56,255,255,255,255,255,16,0,0,0,0,0,0,0,0,0,0,154,255,255,255,255,174,0,0,124,255,255,
  255,255,221,87,0,244,255,255,84,38,175,255,255,255,255,221,2,0,108,144,144,144,144,144,144,144,203,255,255,255,254,144,
  144,144,144,144,144,144,144,24,0,6,246,255,255,255,62,0,0,0,0,0,0,108,255,255,255,255,255,255,255,255,255,255,
  255,255,255,227,7,0,0,0,0,0,0,0,0,0,0,0,0,0,162,255,255,255,146,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,173,255,255,255,255,43,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,225,255,255,255,82,0,0,0,198,255,255,255,110,0,0,0,0,0,0,186,255,255,255,255,173,2,120,
  255,255,56,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,49,153,244,255,255,250,173,72,2,0,0,0,
  0,0,0,0,0,0,0,0,61,229,255,255,255,255,255,255,193,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,100,255,255,255,255,233,0,0,0,0,0,0,0,0,0,0,0,114,255,255,255,255,218,0,0,24,244,255,
  238,115,6,0,0,244,255,255,84,0,0,59,199,255,255,114,0,0,0,0,0,0,0,0,0,0,136,255,255,255,252,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,7,229,255,255,255,255,249,108,29,56,197,255,
  255,255,255,255,105,0,0,0,0,0,0,0,0,0,0,0,0,29,250,255,255,251,32,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,148,255,255,255,255,19,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,43,255,255,255,250,13,0,0,18,252,255,255,255,36,0,0,0,0,0,0,120,255,255,255,255,255,197,178,
  255,255,56,0,0,0,0,0,0,0,0,0,0,0,0,0,0,9,96,200,255,255,255,218,118,22,0,0,0,0,0,0,
  0,0,0,0,0,0,0,79,248,255,255,255,255,255,255,255,255,103,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,133,255,255,255,255,205,0,0,0,0,0,0,0,0,0,0,0,87,255,255,255,255,249,1,0,0,123,142,
  17,0,0,0,0,244,255,255,84,0,0,0,0,85,189,7,0,0,0,0,0,0,0,0,0,0,136,255,255,255,252,0,
  0,0,0,0,0,0,0,0,0,116,255,255,255,255,255,228,0,0,0,0,94,255,255,255,255,255,108,0,0,0,15,228,
  255,255,255,255,218,0,0,0,0,0,0,0,0,0,0,0,0,142,255,255,255,166,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,122,255,255,255,249,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,117,255,255,255,191,0,0,0,89,255,255,255,219,0,0,0,0,0,0,0,20,243,255,255,255,255,255,255,
  255,255,216,156,80,6,0,0,0,0,0,0,0,0,0,39,143,238,255,255,247,165,64,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,55,247,255,255,255,255,255,255,255,255,255,240,25,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,158,255,255,255,255,182,0,0,0,0,0,0,0,0,0,0,0,63,255,255,255,255,255,21,0,0,0,0,
  0,0,0,0,0,244,255,255,84,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,136,255,255,255,252,0,
  0,0,0,0,0,0,0,0,0,116,255,255,255,255,255,228,0,0,0,0,170,255,255,255,255,232,6,0,0,0,0,118,
  255,255,255,255,255,38,0,0,0,0,0,0,0,0,0,0,16,243,255,255,255,48,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,96,255,255,255,227,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,191,255,255,255,117,0,0,0,163,255,255,255,145,0,0,0,0,0,0,0,0,87,254,255,255,255,255,255,
  255,255,255,255,255,231,100,0,0,0,0,0,5,85,190,255,255,255,211,110,17,0,0,0,6,107,198,241,246,211,129,16,
  0,0,0,0,0,7,219,255,255,255,255,169,76,255,255,255,255,255,174,0,0,0,77,255,255,255,255,27,0,0,0,0,
  0,0,0,0,170,255,255,255,255,172,0,0,0,0,0,0,0,0,0,0,0,53,255,255,255,255,255,32,0,0,0,0,
  0,0,0,0,0,244,255,255,84,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,136,255,255,255,252,0,
  0,0,0,0,0,0,0,0,0,116,255,255,255,255,255,228,0,0,0,3,239,255,255,255,255,161,0,0,0,0,0,40,
  255,255,255,255,255,110,0,0,0,0,0,0,0,0,0,0,122,255,255,255,186,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,71,255,255,255,203,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,139,
  144,144,144,144,250,255,255,255,172,144,144,144,238,255,255,255,184,144,144,144,29,0,0,0,0,0,80,237,255,255,255,255,
  255,255,255,255,255,255,255,163,2,0,0,0,48,255,255,244,157,56,0,0,0,0,0,24,202,255,255,255,255,255,255,228,
  49,0,0,0,0,107,255,255,255,255,197,4,0,155,255,255,255,255,255,82,0,0,64,255,255,255,255,18,0,0,0,0,
  0,0,0,0,177,255,255,255,255,166,0,0,0,0,0,0,0,0,0,0,0,46,255,255,255,255,255,41,0,0,0,0,
  0,0,0,0,0,244,255,255,84,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,136,255,255,255,252,0,
  0,0,0,0,0,0,0,0,0,116,255,255,255,255,255,228,0,0,0,39,255,255,255,255,255,107,0,0,0,0,0,0,
  241,255,255,255,255,162,0,0,0,0,0,0,0,0,0,7,232,255,255,255,68,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,45,255,255,255,179,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,248,
  255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,52,0,0,0,0,0,0,17,129,226,255,255,
  255,255,255,255,255,255,255,255,133,0,0,0,0,167,103,13,0,0,0,0,0,0,5,202,255,255,255,255,255,255,255,255,
  233,29,0,0,0,206,255,255,255,255,63,0,0,15,229,255,255,255,255,229,15,0,75,255,255,255,254,2,0,0,0,0,
  0,0,0,0,170,255,255,255,255,172,0,0,0,0,0,0,0,0,0,0,0,54,255,255,255,255,255,32,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,136,255,255,255,252,0,
  0,0,0,0,0,0,0,0,0,116,255,255,255,255,255,228,0,0,0,76,255,255,255,255,255,68,0,0,0,0,0,0,
  202,255,255,255,255,199,0,0,0,0,0,0,0,0,0,102,255,255,255,205,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,248,
  255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,52,0,0,0,0,0,0,0,0,1,46,170,
  255,255,254,255,255,255,255,255,249,29,0,0,0,0,0,0,0,0,0,0,0,0,104,255,255,255,176,33,24,139,255,255,
  255,163,0,0,18,255,255,255,255,244,0,0,0,0,77,255,255,255,255,255,153,0,102,255,255,255,234,0,0,0,0,0,
  0,0,0,0,158,255,255,255,255,183,0,0,0,0,0,0,0,0,0,0,0,64,255,255,255,255,255,21,0,0,0,0,
  39,103,167,230,255,255,255,255,255,84,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,136,255,255,255,252,0,
  0,0,0,0,0,0,0,0,0,116,255,255,255,255,255,228,0,0,0,113,255,255,255,255,255,42,0,0,0,0,0,0,
  176,255,255,255,255,236,0,0,0,0,0,0,0,0,2,217,255,255,255,88,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,248,
  255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,52,0,0,0,0,0,0,0,0,0,0,120,
  255,255,70,115,251,255,255,255,255,117,0,0,0,0,0,0,0,0,0,0,0,0,193,255,255,223,8,0,0,0,176,255,
  255,246,8,0,58,255,255,255,255,221,0,0,0,0,0,166,255,255,255,255,254,62,159,255,255,255,180,0,0,0,0,0,
  0,0,0,0,132,255,255,255,255,207,0,0,0,0,0,0,0,0,0,0,0,88,255,255,255,255,248,1,0,0,164,230,
  255,255,255,255,255,255,255,255,255,84,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,136,255,255,255,252,0,
  0,0,0,0,0,0,0,0,0,116,255,255,255,255,255,228,0,0,0,137,255,255,255,255,255,22,0,0,0,0,0,0,
  156,255,255,255,255,255,3,0,0,0,0,0,0,0,82,255,255,255,222,3,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,248,
  255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,52,0,0,0,0,0,0,0,0,0,0,120,
  255,255,56,0,141,255,255,255,255,173,0,0,0,0,0,0,0,0,0,0,0,0,232,255,255,152,0,0,0,0,94,255,
  255,255,39,0,71,255,255,255,255,240,1,0,0,0,0,20,235,255,255,255,255,217,242,255,255,255,119,0,0,0,0,0,
  0,0,0,0,100,255,255,255,255,235,0,0,0,0,0,0,0,0,0,0,0,115,255,255,255,255,219,0,0,0,252,255,
  255,255,255,255,255,255,255,255,255,84,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,147,255,255,255,255,255,10,0,0,0,0,0,0,
  144,255,255,255,255,255,13,0,0,0,0,0,0,0,199,255,255,255,108,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,41,255,255,255,252,14,0,0,15,252,255,255,255,43,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,120,
  255,255,56,0,76,255,255,255,255,195,0,0,0,0,0,0,0,0,0,0,0,0,233,255,255,151,0,0,0,0,93,255,
  255,255,39,0,56,255,255,255,255,255,53,0,0,0,0,0,88,255,255,255,255,255,255,255,255,249,24,0,0,0,0,0,
  0,0,0,0,56,255,255,255,255,255,18,0,0,0,0,0,0,0,0,0,0,156,255,255,255,255,174,0,0,0,252,255,
  255,255,255,255,255,255,255,255,255,84,0,0,0,0,0,0,0,0,0,0,0,8,50,91,112,124,111,92,45,2,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,158,255,255,255,255,255,5,0,0,0,0,0,0,
  138,255,255,255,255,255,24,0,0,0,0,0,0,61,255,255,255,236,10,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,106,255,255,255,201,0,0,0,78,255,255,255,232,0,0,0,0,0,0,0,0,0,129,65,0,0,0,0,0,120,
  255,255,56,0,100,255,255,255,255,189,0,0,0,0,0,0,0,0,0,0,0,0,194,255,255,221,6,0,0,0,174,255,
  255,245,8,0,26,255,255,255,255,255,177,0,0,0,0,0,0,177,255,255,255,255,255,255,255,154,0,0,0,0,0,0,
  0,0,0,0,8,251,255,255,255,255,64,0,0,0,0,0,0,0,0,0,0,201,255,255,255,255,120,0,0,0,252,255,
  255,255,255,255,255,255,255,255,255,84,0,0,0,0,0,0,0,0,39,123,194,249,255,255,255,255,255,255,255,238,142,29,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,165,255,255,255,255,255,1,0,0,0,0,0,0,
  133,255,255,255,255,255,33,0,0,0,0,0,0,179,255,255,255,129,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,204,255,255,255,255,72,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,171,255,255,255,136,0,0,0,143,255,255,255,167,0,0,0,0,0,0,0,0,0,184,255,199,97,15,0,0,120,
  255,255,56,25,219,255,255,255,255,157,0,0,0,0,0,0,0,0,0,0,0,0,105,255,255,255,171,32,23,135,255,255,
  255,162,0,0,0,213,255,255,255,255,255,130,0,0,0,0,0,26,242,255,255,255,255,255,223,14,0,0,0,0,0,0,
  0,0,0,0,0,197,255,255,255,255,119,0,0,0,0,0,0,0,0,0,8,248,255,255,255,255,57,0,0,0,252,255,
  255,215,150,112,255,255,255,255,255,84,0,0,0,0,0,0,0,49,255,255,255,255,255,255,255,255,255,255,255,255,255,241,
  91,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,158,255,255,255,255,255,5,0,0,0,0,0,0,
  138,255,255,255,255,255,24,0,0,0,0,0,42,254,255,255,246,20,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,204,255,255,255,255,72,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,1,235,255,255,255,71,0,0,0,208,255,255,255,101,0,0,0,0,0,0,0,0,0,184,255,255,255,252,204,167,199,
  255,255,189,239,255,255,255,255,255,84,0,0,0,0,0,0,0,0,0,0,0,0,6,205,255,255,255,255,255,255,255,255,
  233,28,0,0,0,115,255,255,255,255,255,255,188,76,27,28,78,176,255,255,255,255,255,255,162,0,0,0,0,0,0,0,
  0,0,0,0,0,122,255,255,255,255,183,0,0,0,0,0,0,0,0,0,64,255,255,255,255,235,2,0,0,0,153,91,
  25,0,0,36,255,255,255,255,255,84,0,0,0,0,0,0,0,52,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  254,96,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,147,255,255,255,255,255,10,0,0,0,0,0,0,
  144,255,255,255,255,255,14,0,0,0,0,0,159,255,255,255,149,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,204,255,255,255,255,72,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,45,255,255,255,250,11,0,0,19,254,255,255,255,36,0,0,0,0,0,0,0,0,0,184,255,255,255,255,255,255,255,
  255,255,255,255,255,255,255,255,215,3,0,0,0,0,0,0,0,0,0,0,0,0,0,25,205,255,255,255,255,255,255,228,
  50,0,0,0,0,7,221,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,254,64,0,0,0,0,0,0,
  0,0,0,0,0,40,255,255,255,255,244,8,0,0,0,0,0,0,0,0,134,255,255,255,255,156,0,0,0,0,0,0,
  0,0,0,36,255,255,255,255,255,84,0,0,0,0,0,0,0,52,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  255,247,33,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,137,255,255,255,255,255,22,0,0,0,0,0,0,
  155,255,255,255,255,255,3,0,0,0,0,27,249,255,255,252,34,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,204,255,255,255,255,72,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,110,255,255,255,197,0,0,0,82,255,255,255,225,0,0,0,0,0,0,0,0,0,0,184,255,255,255,255,255,255,255,
  255,255,255,255,255,255,255,244,48,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,7,109,200,243,246,212,130,16,
  0,0,0,0,0,0,43,240,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,219,9,0,0,0,0,0,
  0,0,0,0,0,0,199,255,255,255,255,78,0,0,0,0,0,0,0,0,215,255,255,255,255,59,0,0,0,0,0,0,
  0,0,0,36,255,255,255,255,255,84,0,0,0,0,0,0,0,52,255,255,255,200,124,61,31,23,58,150,253,255,255,255,
  255,255,156,0,0,0,0,0,0,116,255,255,255,255,255,228,0,0,0,114,255,255,255,255,255,42,0,0,0,0,0,0,
  176,255,255,255,255,236,0,0,0,0,0,139,255,255,255,169,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,204,255,255,255,255,72,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,175,255,255,255,132,0,0,0,147,255,255,255,160,0,0,0,0,0,0,0,0,0,0,56,169,250,255,255,255,255,255,
  255,255,255,255,255,255,223,52,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,44,217,255,255,255,255,255,255,255,255,255,255,255,213,255,255,255,255,255,139,0,0,0,0,0,
  0,0,0,0,0,0,96,255,255,255,255,164,0,0,0,0,0,0,0,45,255,255,255,255,212,0,0,0,0,0,0,0,
  0,0,0,36,255,255,255,255,255,84,0,0,0,0,0,0,0,52,252,157,44,0,0,0,0,0,0,0,90,255,255,255,
  255,255,234,2,0,0,0,0,0,116,255,255,255,255,255,228,0,0,0,77,255,255,255,255,255,68,0,0,0,0,0,0,
  201,255,255,255,255,199,0,0,0,0,15,241,255,255,255,51,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,16,92,159,209,238,253,
  255,255,250,230,182,102,7,0,0,0,0,0,0,0,0,18,60,92,113,124,116,100,62,13,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,11,116,226,255,255,255,255,255,255,250,175,58,7,213,255,255,255,255,252,52,0,0,0,0,
  0,0,0,0,0,0,6,228,255,255,255,246,15,0,0,0,0,0,0,143,255,255,255,255,95,0,0,0,0,0,0,0,
  0,0,0,36,255,255,255,255,255,84,0,0,0,0,0,0,0,23,38,0,0,0,0,0,0,0,0,0,0,200,255,255,
  255,255,255,24,0,0,0,0,0,116,255,255,255,255,255,228,0,0,0,39,255,255,255,255,255,106,0,0,0,0,0,0,
  241,255,255,255,255,163,0,0,0,0,119,255,255,255,189,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,151,255,255,255,255,255,156,0,0,0,0,0,84,255,255,
  255,255,255,255,255,255,255,255,255,255,255,255,255,28,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,124,
  255,255,56,0,0,0,0,0,0,0,0,0,83,165,225,255,255,255,255,255,255,255,255,252,179,67,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,41,93,113,122,106,68,14,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,111,255,255,255,255,107,0,0,0,0,0,8,235,255,255,255,224,5,0,0,0,0,0,0,0,
  0,0,0,36,255,255,255,255,255,84,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,140,255,255,
  255,255,255,45,0,0,0,0,0,116,255,255,255,255,255,228,0,0,0,3,239,255,255,255,255,161,0,0,0,0,0,40,
  255,255,255,255,255,111,0,0,0,6,230,255,255,255,71,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,56,253,255,255,255,255,255,156,0,0,0,0,0,84,255,255,
  255,255,255,255,255,255,255,255,255,255,255,255,255,28,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,124,
  255,255,56,0,0,0,0,0,0,0,0,0,196,255,255,255,255,255,255,255,255,255,255,255,255,255,160,6,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,6,221,255,255,255,218,2,0,0,0,0,102,255,255,255,255,90,0,0,0,0,0,0,0,0,
  0,0,0,36,255,255,255,255,255,84,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,134,255,255,
  255,255,255,33,0,0,0,0,0,116,255,255,255,255,255,228,0,0,0,0,171,255,255,255,255,232,5,0,0,0,0,118,
  255,255,255,255,255,38,0,0,0,99,255,255,255,208,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,4,209,255,255,255,255,255,255,156,0,0,0,0,0,84,255,255,
  255,255,255,255,255,255,255,255,255,255,255,255,255,28,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,124,
  255,255,56,0,0,0,0,0,0,0,0,0,196,255,255,255,255,255,255,255,255,255,255,255,255,255,255,176,1,0,0,0,
  0,0,0,0,0,0,0,12,69,94,116,121,101,61,9,0,0,0,0,0,0,116,255,255,255,255,255,228,0,0,0,0,
  0,0,0,0,0,0,0,0,85,255,255,255,255,80,0,0,0,2,215,255,255,255,202,1,0,0,0,0,0,0,0,0,
  0,0,0,36,255,255,255,255,255,84,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,171,255,255,
  255,255,249,8,0,0,0,0,0,116,255,255,255,255,255,228,0,0,0,0,95,255,255,255,255,255,108,0,0,0,15,228,
  255,255,255,255,218,0,0,0,0,93,128,128,128,60,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,116,255,255,255,255,255,255,255,156,0,0,0,0,0,84,255,255,
  255,255,255,255,255,255,255,255,255,255,255,255,255,28,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,124,
  255,255,56,0,0,0,0,0,0,0,0,0,196,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,97,0,0,0,
  0,0,0,0,0,72,184,249,255,255,255,255,255,255,249,186,71,0,0,0,0,116,255,255,255,255,255,228,0,0,0,0,
  0,0,0,0,0,0,0,0,0,183,255,255,255,207,1,0,0,90,255,255,255,252,50,0,0,0,0,0,0,0,0,0,
  0,0,0,36,255,255,255,255,255,84,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,12,244,255,255,
  255,255,192,0,0,0,0,0,0,116,255,255,255,255,255,228,0,0,0,0,8,230,255,255,255,255,249,107,28,55,197,255,
  255,255,255,255,105,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,30,244,255,255,255,255,255,255,255,156,0,0,0,0,0,84,255,255,
  255,255,168,144,144,144,144,144,144,144,144,144,144,15,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,124,
  255,255,56,0,0,0,0,0,0,0,0,0,196,255,242,173,109,60,33,23,52,111,232,255,255,255,255,255,211,0,0,0,
  0,0,0,20,177,255,255,255,255,255,255,255,255,255,255,255,160,0,0,0,0,116,255,255,255,255,255,228,0,0,0,0,
  0,0,0,0,0,0,0,0,0,30,243,255,255,255,85,0,3,218,255,255,255,138,0,0,0,0,0,0,0,0,0,0,
  0,0,0,36,255,255,255,255,255,84,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,132,255,255,255,
  255,255,93,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,111,255,255,255,255,255,255,255,255,255,255,
  255,255,255,227,7,0,0,0,108,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,144,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,177,255,255,255,255,255,255,255,255,156,0,0,0,0,0,84,255,255,
  255,255,56,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,124,
  255,255,56,0,0,0,0,0,0,0,0,0,133,85,6,0,0,0,0,0,0,0,18,218,255,255,255,255,255,26,0,0,
  0,0,18,208,255,255,255,255,255,255,255,255,255,255,255,255,160,0,0,0,0,116,255,255,255,255,255,228,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,36,255,255,255,255,255,84,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,47,248,255,255,255,
  255,217,4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,182,255,255,255,255,255,255,255,255,255,
  255,255,249,58,0,0,0,0,108,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,144,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,80,255,255,255,252,234,255,255,255,255,156,0,0,0,0,0,84,255,255,
  255,255,56,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,95,255,255,255,255,255,56,0,0,
  0,1,193,255,255,255,255,255,255,255,255,255,255,255,255,255,160,0,0,0,0,116,255,255,255,255,255,228,0,0,0,0,
  0,0,0,15,72,105,122,113,92,40,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,36,255,255,255,255,255,84,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,15,220,255,255,255,255,
  254,60,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,16,192,255,255,255,255,255,255,255,255,
  255,244,86,0,0,0,0,0,108,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,144,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,12,226,255,255,255,142,200,255,255,255,255,156,0,0,0,0,0,84,255,255,
  255,255,56,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,44,94,115,117,94,63,5,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,44,255,255,255,255,255,64,0,0,
  0,95,255,255,255,255,255,249,147,65,30,25,56,119,211,255,160,0,0,0,0,116,255,255,255,255,255,228,0,0,0,0,
  0,46,172,252,255,255,255,255,255,255,221,107,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,36,255,255,255,255,255,84,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,5,187,255,255,255,255,255,
  135,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,116,226,255,255,255,255,255,251,
  178,38,0,0,0,0,0,0,108,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,138,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,142,255,255,255,227,12,200,255,255,255,255,156,0,0,0,0,0,84,255,255,
  255,255,56,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,5,107,227,255,255,255,255,255,255,239,154,21,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,54,255,255,255,255,255,37,0,0,
  4,230,255,255,255,255,234,46,0,0,0,0,0,0,0,70,113,0,0,0,0,116,255,255,255,255,255,228,0,0,0,0,
  103,249,255,255,255,255,255,255,255,255,255,255,193,18,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,36,255,255,255,255,255,84,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,161,255,255,255,255,255,176,
  2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,59,95,120,108,81,21,
  0,0,0,0,0,0,0,0,60,144,144,144,144,144,144,144,144,144,144,144,214,255,255,255,255,255,63,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,48,252,255,255,255,81,0,200,255,255,255,255,156,0,0,0,0,0,84,255,255,
  255,255,56,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,17,195,255,255,255,255,255,255,255,255,255,255,235,69,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,134,255,255,255,255,228,0,0,0,
  72,255,255,255,255,255,62,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,86,
  254,255,255,255,255,255,255,255,255,255,255,255,255,197,5,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,36,255,255,255,255,255,84,0,0,0,0,0,0,0,0,0,0,0,0,0,0,134,255,255,255,255,255,197,9,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,228,255,255,255,255,220,1,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,2,201,255,255,255,178,0,0,200,255,255,255,255,156,0,0,0,0,0,84,255,255,
  255,255,175,209,239,249,230,198,130,41,0,0,0,0,0,0,0,4,199,255,255,255,255,255,255,255,255,255,255,255,255,243,
  49,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,5,107,251,255,255,255,255,113,0,0,0,
  161,255,255,255,255,176,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,13,234,
  255,255,255,255,255,255,255,255,255,255,255,255,255,255,110,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,36,255,255,255,255,255,84,0,0,0,0,0,0,0,0,0,0,0,0,0,108,255,255,255,255,255,209,16,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,17,79,0,0,0,0,0,0,0,0,0,0,0,0,0,72,255,255,255,255,255,124,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,106,255,255,255,244,30,0,0,200,255,255,255,255,156,0,0,0,0,0,84,255,255,
  255,255,255,255,255,255,255,255,255,252,158,13,0,0,0,0,0,123,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  219,6,0,0,0,0,0,0,0,0,0,0,0,0,0,0,78,144,144,148,177,227,255,255,255,255,255,180,2,0,0,0,
  225,255,255,255,255,84,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,100,255,
  255,255,255,255,202,73,29,49,128,249,255,255,255,255,220,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,36,255,255,255,255,255,84,0,0,0,0,0,0,0,0,0,0,0,0,85,253,255,255,255,255,218,23,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,61,163,247,204,0,0,0,0,0,0,0,0,0,0,0,0,0,169,255,255,255,255,253,29,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,24,240,255,255,255,116,0,0,0,200,255,255,255,255,156,0,0,0,0,0,84,255,255,
  255,255,255,255,255,255,255,255,255,255,255,212,28,0,0,0,8,236,255,255,255,255,250,127,38,24,74,212,255,255,255,255,
  255,101,0,0,0,0,0,0,0,0,0,0,0,0,0,0,140,255,255,255,255,255,255,255,255,246,133,5,0,0,0,15,
  255,255,255,255,255,23,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,169,255,
  255,255,255,209,4,0,0,0,0,92,255,255,255,255,255,32,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,36,255,255,255,255,255,84,0,0,0,0,0,0,0,0,0,0,0,65,248,255,255,255,255,224,29,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,20,
  115,216,255,255,255,204,0,0,0,0,0,0,0,0,0,0,0,0,17,248,255,255,255,255,185,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,167,255,255,255,209,4,0,0,0,200,255,255,255,255,156,0,0,0,0,0,84,255,255,
  255,255,255,255,255,255,255,255,255,255,255,255,204,8,0,0,85,255,255,255,255,255,100,0,0,0,0,19,230,255,255,255,
  255,202,0,0,0,0,0,0,0,0,0,0,0,0,0,0,140,255,255,255,255,255,255,250,152,22,0,0,0,0,0,59,
  255,255,255,255,238,0,20,127,202,235,249,230,190,115,14,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,199,255,
  255,255,255,89,0,0,0,0,0,0,224,255,255,255,255,62,0,0,0,0,0,0,0,0,0,0,0,0,0,60,144,144,
  144,144,144,159,255,255,255,255,255,180,144,144,144,144,144,87,0,0,0,0,48,241,255,255,255,255,229,35,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,66,168,249,
  255,255,255,255,255,204,0,0,0,0,0,0,0,0,0,0,0,0,107,255,255,255,255,255,87,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,70,255,255,255,254,57,0,0,0,0,200,255,255,255,255,156,0,0,0,0,0,84,255,255,
  249,206,165,149,158,201,253,255,255,255,255,255,255,133,0,0,145,255,255,255,255,220,1,0,0,0,0,0,117,255,255,255,
  255,255,26,0,0,0,0,0,0,0,0,0,0,0,0,0,140,255,255,255,255,255,255,255,255,226,112,3,0,0,0,89,
  255,255,255,255,220,70,237,255,255,255,255,255,255,255,233,73,0,0,0,0,0,0,0,0,0,0,0,0,0,0,211,255,
  255,255,255,47,0,0,0,0,0,0,184,255,255,255,255,74,0,0,0,0,0,0,0,0,0,0,0,0,0,108,255,255,
  255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,156,0,0,0,33,231,255,255,255,255,234,41,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,23,120,220,255,255,255,
  255,255,255,255,255,204,0,0,0,0,0,0,0,0,0,0,0,0,204,255,255,255,255,238,7,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,8,220,255,255,255,152,0,0,0,0,0,200,255,255,255,255,156,0,0,0,0,0,83,194,89,
  13,0,0,0,0,0,36,187,255,255,255,255,255,242,17,0,192,255,255,255,255,153,0,0,0,0,0,0,49,255,255,255,
  255,255,88,0,0,0,0,0,0,0,0,0,0,0,0,0,140,255,255,255,255,255,255,255,255,255,255,190,11,0,0,102,
  255,255,255,255,238,245,255,255,255,255,255,255,255,255,255,250,74,0,0,0,0,116,255,255,255,255,255,228,0,0,190,255,
  255,255,255,67,0,0,0,0,0,0,204,255,255,255,255,53,0,0,0,0,0,0,0,0,0,0,0,0,0,108,255,255,
  255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,156,0,0,21,218,255,255,255,255,238,47,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,72,173,251,255,255,255,255,255,
  255,255,255,251,180,77,0,0,0,0,0,0,0,0,0,0,0,45,255,255,255,255,255,148,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,132,255,255,255,232,16,0,0,0,0,0,200,255,255,255,255,156,0,0,0,0,0,4,0,0,
  0,0,0,0,0,0,0,3,183,255,255,255,255,255,91,0,211,255,255,255,255,121,0,0,0,0,0,0,18,255,255,255,
  255,255,136,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,21,77,190,255,255,255,255,255,170,0,0,115,
  255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,232,19,0,0,0,116,255,255,255,255,255,228,0,0,135,255,
  255,255,255,138,0,0,0,0,0,29,247,255,255,255,244,8,0,0,0,0,0,0,0,0,0,0,0,0,0,108,255,255,
  255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,156,0,12,203,255,255,255,255,242,54,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,27,125,224,255,255,255,255,255,255,255,255,
  255,201,109,21,0,0,0,0,0,0,0,0,0,0,0,0,0,142,255,255,255,255,255,51,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,8,249,255,255,255,91,0,0,0,0,0,0,200,255,255,255,255,156,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,31,252,255,255,255,255,156,0,224,255,255,255,255,115,0,0,0,0,0,0,12,255,255,255,
  255,255,175,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,148,255,255,255,255,255,61,0,125,
  255,255,255,255,255,255,255,238,167,152,200,255,255,255,255,255,255,122,0,0,0,116,255,255,255,255,255,228,0,0,38,251,
  255,255,255,249,76,0,0,0,20,189,255,255,255,255,152,0,0,0,0,0,0,0,0,0,0,0,0,0,0,108,255,255,
  255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,156,0,169,255,255,255,255,255,196,144,144,144,144,144,144,144,144,
  144,144,144,33,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,77,178,252,255,255,255,255,255,255,255,255,221,130,
  38,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,5,234,255,255,255,255,209,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,12,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,188,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,201,255,255,255,255,187,0,214,255,255,255,255,133,0,0,0,0,0,0,29,255,255,255,
  255,255,204,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,7,228,255,255,255,255,155,0,124,
  255,255,255,255,255,255,198,18,0,0,0,92,253,255,255,255,255,218,0,0,0,116,255,255,255,255,255,228,0,0,0,129,
  255,255,255,255,255,199,156,176,237,255,255,255,255,226,21,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,208,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  255,255,255,60,0,0,0,0,0,0,0,0,0,0,0,0,0,53,228,255,255,255,255,255,255,255,255,237,152,59,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,81,255,255,255,255,255,112,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,12,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,188,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,171,255,255,255,255,205,0,196,255,255,255,255,181,0,0,0,0,0,0,76,255,255,255,
  255,255,224,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,151,255,255,255,255,211,0,117,
  255,255,255,255,255,252,34,0,0,0,0,0,156,255,255,255,255,255,20,0,0,116,255,255,255,255,255,228,0,0,0,1,
  126,251,255,255,255,255,255,255,255,255,255,255,208,34,0,0,0,0,47,144,144,144,144,144,144,144,144,144,144,144,144,144,
  144,144,144,144,144,144,114,0,0,0,0,0,0,0,0,0,0,208,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  255,255,255,60,0,0,0,0,0,0,0,0,0,0,0,0,0,84,255,255,255,255,255,255,248,173,81,6,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,178,255,255,255,255,250,21,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,12,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,188,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,180,255,255,255,255,194,0,153,255,255,255,255,248,27,0,0,0,0,0,170,255,255,255,
  255,255,239,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,119,255,255,255,255,235,0,102,
  255,255,255,255,255,195,0,0,0,0,0,0,59,255,255,255,255,255,64,0,0,125,255,255,255,255,255,204,0,0,0,0,
  0,50,223,255,255,255,255,255,255,255,255,145,4,0,0,0,0,0,84,255,255,255,255,255,255,255,255,255,255,255,255,255,
  255,255,255,255,255,255,204,0,0,0,0,0,0,0,0,0,0,208,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  255,255,255,60,0,0,0,0,0,0,0,0,0,0,0,0,0,84,255,255,255,255,245,113,16,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,23,251,255,255,255,255,173,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,12,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,188,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,228,255,255,255,255,172,0,94,255,255,255,255,255,193,16,0,0,0,100,255,255,255,255,
  255,255,246,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,130,255,255,255,255,233,0,82,
  255,255,255,255,255,148,0,0,0,0,0,0,10,255,255,255,255,255,81,0,0,172,255,255,255,255,255,88,0,0,0,0,
  102,237,255,255,255,255,255,255,255,255,255,255,183,29,0,0,0,0,84,255,255,255,255,255,255,255,255,255,255,255,255,255,
  255,255,255,255,255,255,204,0,0,0,0,0,0,0,0,0,0,208,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  255,255,255,60,0,0,0,0,0,0,0,0,0,0,0,0,0,84,255,255,255,255,255,243,162,70,3,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,116,255,255,255,255,255,76,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,6,144,144,144,144,144,144,144,144,144,144,144,231,255,255,255,255,212,144,144,105,0,0,0,0,0,
  0,0,0,0,0,0,0,0,80,255,255,255,255,255,119,0,13,243,255,255,255,255,255,237,165,151,201,255,255,255,255,255,
  255,255,249,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,203,255,255,255,255,210,0,53,
  255,255,255,255,255,131,0,0,0,0,0,0,0,248,255,255,255,255,91,0,0,222,255,255,255,255,216,2,0,0,0,143,
  255,255,255,255,255,255,255,255,255,255,255,255,255,230,34,0,0,0,84,255,255,255,255,255,255,255,255,255,255,255,255,255,
  255,255,255,255,255,255,204,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,83,255,255,255,255,255,255,255,255,231,142,50,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,213,255,255,255,255,230,3,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,200,255,255,255,255,156,0,0,0,0,45,89,4,0,
  0,0,0,0,0,0,0,52,236,255,255,255,255,255,46,0,0,131,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  255,255,238,0,0,0,0,0,0,0,0,132,125,23,0,0,0,0,0,0,0,0,0,122,255,255,255,255,255,160,0,15,
  255,255,255,255,255,136,0,0,0,0,0,0,0,253,255,255,255,255,76,0,16,255,255,255,255,255,93,0,0,0,90,255,
  255,255,255,255,152,44,7,21,92,227,255,255,255,255,206,3,0,0,84,255,255,255,255,255,255,255,255,255,255,255,255,255,
  255,255,255,255,255,255,204,0,40,55,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,8,58,99,117,120,103,62,11,0,0,0,0,0,0,0,2,72,173,250,255,255,255,255,255,255,255,255,214,122,31,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,54,255,255,255,255,255,137,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,200,255,255,255,255,156,0,0,0,0,72,255,233,156,
  94,50,28,20,35,78,160,250,255,255,255,255,255,185,0,0,0,6,199,255,255,255,255,255,255,255,255,255,255,236,255,255,
  255,255,225,0,0,0,0,0,0,0,0,156,255,253,198,130,85,47,31,19,31,81,184,255,255,255,255,255,255,81,0,0,
  222,255,255,255,255,167,0,0,0,0,0,0,29,255,255,255,255,255,57,0,66,255,255,255,255,219,3,0,0,2,225,255,
  255,255,255,119,0,0,0,0,0,27,231,255,255,255,255,91,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,84,255,209,108,16,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,4,
  89,180,250,255,255,255,255,255,255,246,157,27,0,0,0,0,0,0,0,0,23,120,219,255,255,255,255,255,255,255,255,254,
  194,102,17,0,0,0,0,0,0,0,0,0,0,0,151,255,255,255,255,255,40,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,200,255,255,255,255,156,0,0,0,0,72,255,255,255,
  255,255,255,255,255,255,255,255,255,255,255,255,245,45,0,0,0,0,12,176,255,255,255,255,255,255,255,255,179,109,255,255,
  255,255,212,0,0,0,0,0,0,0,0,156,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,205,2,0,0,
  161,255,255,255,255,231,2,0,0,0,0,0,98,255,255,255,255,253,12,0,116,255,255,255,255,97,0,0,0,61,255,255,
  255,255,223,3,0,0,0,0,0,0,107,255,255,255,255,181,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,84,255,255,255,246,162,60,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,71,222,
  255,255,255,255,255,255,255,255,255,255,255,239,65,0,0,0,0,0,0,0,0,0,1,66,167,248,255,255,255,255,255,255,
  255,255,249,174,82,7,0,0,0,0,0,0,0,8,239,255,255,255,255,198,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,200,255,255,255,255,156,0,0,0,0,72,255,255,255,
  255,255,255,255,255,255,255,255,255,255,255,252,81,0,0,0,0,0,0,0,66,158,219,243,247,225,170,79,0,116,255,255,
  255,255,183,0,0,0,0,0,0,0,0,156,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,235,43,0,0,0,
  82,255,255,255,255,255,106,0,0,0,0,12,218,255,255,255,255,206,0,0,166,255,255,255,223,4,0,0,0,114,255,255,
  255,255,155,0,0,0,0,0,0,0,36,255,255,255,255,232,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,84,255,255,255,255,255,255,214,113,19,0,0,0,0,0,0,0,0,0,0,0,0,144,255,
  255,255,255,255,255,255,255,255,255,255,255,255,243,36,0,0,0,0,0,0,0,0,0,0,0,19,113,214,255,255,255,255,
  255,255,255,255,255,196,0,0,0,0,0,0,0,89,255,255,255,255,255,101,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,200,255,255,255,255,156,0,0,0,0,72,255,255,255,
  255,255,255,255,255,255,255,255,255,255,228,62,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,157,255,255,
  255,255,137,0,0,0,0,0,0,0,0,156,255,255,255,255,255,255,255,255,255,255,255,255,255,255,210,45,0,0,0,0,
  6,232,255,255,255,255,251,128,38,23,70,204,255,255,255,255,255,109,0,0,215,255,255,255,102,0,0,0,0,134,255,255,
  255,255,136,0,0,0,0,0,0,0,17,255,255,255,255,253,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,84,255,255,255,255,255,255,255,255,248,167,65,1,0,0,0,0,0,0,0,0,0,144,255,
  255,255,255,255,255,255,255,255,255,255,255,255,255,170,0,0,0,0,0,0,0,0,0,0,0,0,0,0,60,161,246,255,
  255,255,255,255,255,204,0,0,0,0,0,0,0,186,255,255,255,255,245,14,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,200,255,255,255,255,156,0,0,0,0,26,137,203,250,
  255,255,255,255,255,255,255,255,219,114,13,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,215,255,255,
  255,255,92,0,0,0,0,0,0,0,0,38,125,195,246,255,255,255,255,255,255,255,255,255,201,102,5,0,0,0,0,0,
  0,109,255,255,255,255,255,255,255,255,255,255,255,255,255,255,230,13,0,0,0,0,0,0,0,0,0,0,0,127,255,255,
  255,255,159,0,0,0,0,0,0,0,41,255,255,255,255,245,0,0,47,144,144,144,144,144,144,144,144,144,144,144,144,144,
  144,144,144,144,144,144,114,0,24,137,227,255,255,255,255,255,255,255,255,255,219,119,23,0,0,0,0,0,0,0,144,255,
  255,243,160,81,40,23,49,133,250,255,255,255,255,247,10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,15,107,
  208,255,255,255,255,204,0,0,0,0,0,0,29,253,255,255,255,255,162,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,7,
  49,82,109,121,122,105,82,28,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,50,255,255,255,
  255,254,29,0,0,0,0,0,0,0,0,0,0,0,4,43,76,104,117,125,116,101,68,17,0,0,0,0,0,0,0,0,
  0,2,174,255,255,255,255,255,255,255,255,255,255,255,255,253,70,0,0,0,0,0,0,0,0,0,0,0,0,105,255,255,
  255,255,228,5,0,0,0,0,0,0,119,255,255,255,255,224,0,0,84,255,255,255,255,255,255,255,255,255,255,255,255,255,
  255,255,255,255,255,255,204,0,0,0,2,66,158,241,255,255,255,255,255,255,255,255,250,172,71,2,0,0,0,0,144,249,
  136,20,0,0,0,0,0,0,122,255,255,255,255,255,49,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,54,155,243,255,204,0,0,0,0,0,0,124,255,255,255,255,255,64,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,41,127,190,229,248,247,226,184,112,16,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,188,255,255,255,
  255,194,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,9,178,255,255,255,255,255,255,255,255,255,255,248,84,0,0,0,0,0,0,0,0,0,0,0,0,0,52,255,255,
  255,255,255,133,0,0,0,0,0,40,240,255,255,255,255,170,0,0,84,255,255,255,255,255,255,255,255,255,255,255,255,255,
  255,255,255,255,255,255,204,0,0,0,0,0,0,9,87,180,251,255,255,255,255,255,255,255,255,223,124,26,0,0,98,46,
  0,0,0,0,0,0,0,0,51,255,255,255,255,255,65,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,12,101,153,0,0,0,0,0,0,220,255,255,255,255,221,1,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,40,181,255,255,255,255,255,255,255,255,255,238,103,0,0,0,0,0,160,255,255,255,255,255,255,
  255,255,254,242,228,191,143,62,1,0,0,0,0,0,0,0,0,30,133,14,0,0,0,0,0,0,3,148,255,255,255,255,
  255,101,0,0,0,0,0,0,0,0,0,0,214,255,255,255,255,255,255,77,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,89,207,255,255,255,255,255,255,250,171,39,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,230,255,
  255,255,255,255,167,59,22,37,111,237,255,255,255,255,255,95,0,0,84,255,255,255,255,255,255,255,255,255,255,255,255,255,
  255,255,255,255,255,255,204,0,0,0,0,0,0,0,0,0,21,109,201,255,255,255,255,255,255,255,255,252,149,0,0,0,
  0,0,0,0,0,0,0,0,66,255,255,255,255,255,42,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,62,255,255,255,255,255,125,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,98,246,255,255,255,255,255,255,255,255,255,255,255,255,138,0,0,0,0,160,255,255,255,255,255,255,
  255,255,255,255,255,255,255,255,212,61,0,0,0,0,0,0,0,36,255,242,154,81,35,21,41,100,208,255,255,255,255,255,
  213,4,0,0,0,0,0,0,0,0,0,26,255,255,255,255,255,255,255,145,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,33,84,107,122,105,75,13,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,111,255,
  255,255,255,255,255,255,255,255,255,255,255,255,255,255,223,5,0,0,84,255,255,255,255,255,255,255,255,255,255,255,255,255,
  255,255,255,255,255,255,204,0,0,0,0,0,0,0,0,0,0,0,0,38,130,221,255,255,255,255,255,255,204,0,0,0,
  0,0,0,0,0,0,0,0,168,255,255,255,255,230,3,0,0,0,0,0,0,0,0,0,0,29,77,100,121,117,97,58,
  8,0,0,0,0,0,0,0,0,0,0,159,255,255,255,255,253,30,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,116,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,91,0,0,0,160,255,255,255,255,255,255,
  255,255,255,255,255,255,255,255,255,251,84,0,0,0,0,0,0,36,255,255,255,255,255,255,255,255,255,255,255,255,255,253,
  65,0,0,0,0,0,0,0,0,0,0,94,255,255,255,255,255,255,255,213,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,4,189,
  255,255,255,255,255,255,255,255,255,255,255,255,255,249,60,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,59,195,255,255,255,255,204,0,0,0,
  0,0,0,0,0,0,0,92,255,255,255,255,255,127,0,0,0,0,0,0,0,0,6,113,205,255,255,255,255,255,255,255,
  247,178,56,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,83,254,255,255,255,255,200,101,40,11,12,46,126,239,255,255,255,234,9,0,0,160,255,255,255,255,255,255,
  255,255,255,255,255,255,255,255,255,255,244,28,0,0,0,0,0,36,255,255,255,255,255,255,255,255,255,255,255,255,254,96,
  0,0,0,0,0,0,0,0,0,0,0,161,255,255,255,255,255,255,255,255,25,0,0,0,0,0,0,0,204,255,255,255,
  255,255,255,255,255,255,255,255,255,255,255,255,255,236,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,16,
  181,255,255,255,255,255,255,255,255,255,255,255,237,75,0,0,0,0,136,255,255,255,255,255,255,255,255,255,255,255,255,255,
  255,255,255,255,48,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,29,119,211,255,255,255,255,255,204,0,0,0,
  0,0,0,0,0,0,74,250,255,255,255,255,209,8,0,0,0,0,0,0,0,60,216,255,255,255,255,255,255,255,255,255,
  255,255,148,0,0,0,0,100,255,255,255,255,255,254,240,223,206,163,104,41,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,19,234,255,255,255,245,103,0,0,0,0,0,0,0,34,229,255,255,255,102,0,0,160,255,255,255,255,235,144,
  144,144,145,161,215,255,255,255,255,255,255,143,0,0,0,0,0,36,255,255,255,255,255,255,255,255,255,255,255,234,86,0,
  0,0,0,0,0,0,0,0,0,0,0,228,255,255,255,255,255,255,255,255,93,0,0,0,0,0,0,0,204,255,255,255,
  255,255,255,255,255,255,255,255,255,255,255,255,255,236,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  1,91,205,255,255,255,255,255,255,255,241,145,27,0,0,0,0,0,136,255,255,255,255,255,255,255,255,255,255,255,255,255,
  255,255,255,255,48,0,0,0,0,0,0,0,0,0,0,0,0,15,99,191,254,255,255,255,255,255,255,255,203,0,0,0,
  0,0,0,0,0,66,247,255,255,255,255,231,32,0,0,0,0,0,0,0,69,247,255,255,255,255,255,255,255,255,255,255,
  255,255,148,0,0,0,0,100,255,255,255,255,255,255,255,255,255,255,255,255,188,67,0,0,0,0,0,0,0,0,0,0,
  0,0,0,162,255,255,255,249,67,0,0,0,0,0,0,0,0,0,75,255,255,255,174,0,0,160,255,255,255,255,208,0,
  0,0,0,0,0,101,255,255,255,255,255,217,0,0,0,0,0,14,152,232,255,255,255,255,255,255,255,222,136,16,0,0,
  0,0,0,0,0,0,0,0,0,0,41,255,255,255,255,251,255,255,255,255,161,0,0,0,0,0,0,0,204,255,255,255,
  255,255,255,255,255,255,255,255,255,255,255,255,255,236,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,26,82,107,123,115,97,52,4,0,0,0,0,0,0,0,136,255,255,255,255,255,255,255,255,255,255,255,255,255,
  255,255,255,255,48,0,0,0,0,0,0,0,0,0,6,80,171,247,255,255,255,255,255,255,255,255,219,119,23,0,0,0,
  0,0,0,0,51,244,255,255,255,255,235,44,0,0,0,0,0,0,0,48,247,255,255,255,255,255,255,255,255,255,255,255,
  255,255,148,0,0,0,0,100,255,255,255,255,255,255,255,255,255,255,255,255,255,255,145,3,0,0,0,0,0,0,0,0,
  0,0,35,254,255,255,255,101,0,0,0,0,0,0,0,0,0,0,0,232,255,255,229,0,0,160,255,255,255,255,208,0,
  0,0,0,0,0,0,195,255,255,255,255,250,0,0,0,0,0,0,0,0,41,86,115,123,106,83,42,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,109,255,255,255,255,165,255,255,255,255,228,0,0,0,0,0,0,0,204,255,255,255,
  255,255,255,255,255,255,255,255,255,255,255,255,255,236,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,136,255,255,255,255,255,255,255,255,255,255,255,255,255,
  255,255,255,255,48,0,0,0,0,0,0,1,60,152,237,255,255,255,255,255,255,255,255,248,167,65,1,0,0,0,0,0,
  0,0,0,26,230,255,255,255,255,236,46,0,0,0,0,0,0,0,2,201,255,255,255,255,255,254,163,69,30,32,74,165,
  253,255,148,0,0,0,0,100,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,178,2,0,0,0,0,0,0,0,
  0,0,136,255,255,255,197,1,0,0,0,4,103,193,236,247,215,127,9,187,255,255,251,0,0,160,255,255,255,255,208,0,
  0,0,0,0,0,0,142,255,255,255,255,255,10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,176,255,255,255,255,84,221,255,255,255,255,40,0,0,0,0,0,0,204,255,255,255,
  255,236,144,144,144,144,144,144,144,144,144,144,144,132,0,0,0,0,0,0,0,0,0,9,66,92,115,120,102,61,12,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,136,255,255,255,255,255,154,144,144,144,144,144,144,144,
  144,144,144,144,27,0,0,0,0,40,132,222,255,255,255,255,255,255,255,255,255,213,113,19,0,0,0,0,0,0,0,0,
  0,0,0,166,255,255,255,255,242,51,0,0,0,0,0,0,0,0,97,255,255,255,255,255,251,80,0,0,0,0,0,0,
  51,213,148,0,0,0,0,100,255,255,255,255,255,170,144,161,199,254,255,255,255,255,255,255,122,0,0,0,0,0,0,0,
  0,2,232,255,255,255,62,0,0,0,24,206,255,255,255,255,255,255,205,184,255,255,255,12,0,160,255,255,255,255,208,0,
  0,0,0,0,0,0,140,255,255,255,255,250,0,0,0,100,255,255,255,255,255,60,0,0,0,0,0,0,192,255,255,255,
  255,224,0,0,0,0,0,0,0,3,240,255,255,255,255,26,163,255,255,255,255,108,0,0,0,0,0,0,204,255,255,255,
  255,212,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,64,177,246,255,255,255,255,255,255,248,178,
  73,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,136,255,255,255,255,255,24,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,77,255,255,255,255,255,255,255,255,255,245,160,59,0,0,0,0,0,0,0,0,0,0,0,
  0,0,32,255,255,255,255,255,80,0,0,0,0,0,0,0,0,0,200,255,255,255,255,255,118,0,0,0,0,0,0,0,
  0,15,85,0,0,0,0,100,255,255,255,255,255,60,0,0,0,32,186,255,255,255,255,255,246,23,0,0,0,0,0,0,
  0,45,255,255,255,219,0,0,0,8,211,255,255,255,255,255,255,255,255,255,255,255,255,16,0,160,255,255,255,255,208,0,
  0,0,0,0,0,0,189,255,255,255,255,205,0,0,0,100,255,255,255,255,255,60,0,0,0,0,0,0,192,255,255,255,
  255,224,0,0,0,0,0,0,0,56,255,255,255,255,224,0,105,255,255,255,255,176,0,0,0,0,0,0,204,255,255,255,
  255,212,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,17,167,255,255,255,255,255,255,255,255,255,255,255,
  255,121,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,136,255,255,255,255,255,24,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,84,255,255,255,255,255,255,255,208,107,15,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,103,255,255,255,255,198,0,0,0,0,0,0,0,0,0,37,255,255,255,255,255,229,6,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,100,255,255,255,255,255,60,0,0,0,0,6,195,255,255,255,255,255,127,0,0,0,0,0,0,
  0,99,255,255,255,133,0,0,0,134,255,255,255,255,255,255,255,255,255,255,255,255,255,16,0,160,255,255,255,255,208,0,
  0,0,0,0,0,87,254,255,255,255,255,117,0,0,0,100,255,255,255,255,255,60,0,0,0,0,0,0,192,255,255,255,
  255,224,0,0,0,0,0,0,0,123,255,255,255,255,166,0,47,255,255,255,255,240,3,0,0,0,0,0,204,255,255,255,
  255,212,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,18,206,255,255,255,255,255,255,255,255,255,255,255,255,
  255,132,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,136,255,255,255,255,255,24,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,84,255,255,255,255,243,154,53,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,138,255,255,255,255,140,0,0,0,0,0,0,0,0,0,111,255,255,255,255,255,134,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,100,255,255,255,255,255,60,0,0,0,0,0,51,255,255,255,255,255,216,0,0,0,0,0,0,
  0,152,255,255,255,79,0,0,10,240,255,255,255,215,70,9,17,98,240,255,255,255,255,16,0,160,255,255,255,255,235,144,
  144,144,145,159,208,255,255,255,255,255,213,9,0,0,0,100,255,255,255,255,255,60,0,0,0,0,0,0,192,255,255,255,
  255,224,0,0,0,0,0,0,0,191,255,255,255,255,108,0,2,242,255,255,255,255,56,0,0,0,0,0,204,255,255,255,
  255,212,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,200,255,255,255,255,255,255,255,255,255,255,255,255,255,
  255,132,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,136,255,255,255,255,255,24,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,84,255,255,202,101,12,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,156,255,255,255,255,124,0,0,0,0,0,0,0,0,0,160,255,255,255,255,255,64,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,100,255,255,255,255,255,60,0,0,0,0,0,0,207,255,255,255,255,255,27,0,0,0,0,0,
  0,182,255,255,255,30,0,0,76,255,255,255,246,27,0,0,0,0,77,255,255,255,255,16,0,160,255,255,255,255,255,255,
  255,255,255,255,255,255,255,255,255,187,23,0,0,0,0,100,255,255,255,255,255,60,0,0,0,0,0,0,192,255,255,255,
  255,224,0,0,0,0,0,0,10,248,255,255,255,255,50,0,0,187,255,255,255,255,124,0,0,0,0,0,204,255,255,255,
  255,212,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,113,255,255,255,255,255,255,208,100,43,23,49,102,203,255,
  255,132,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,136,255,255,255,255,255,24,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,70,148,47,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,160,255,255,255,255,124,0,0,0,0,0,0,0,0,0,208,255,255,255,255,255,12,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,100,255,255,255,255,255,60,0,0,0,0,0,0,141,255,255,255,255,255,81,0,0,0,0,0,
  0,198,255,255,255,4,0,0,130,255,255,255,150,0,0,0,0,0,0,207,255,255,255,16,0,160,255,255,255,255,255,255,
  255,255,255,255,255,255,245,170,57,0,0,0,0,0,0,100,255,255,255,255,255,60,0,0,0,0,0,0,192,255,255,255,
  255,224,0,0,0,0,0,0,71,255,255,255,255,244,3,0,0,129,255,255,255,255,192,0,0,0,0,0,204,255,255,255,
  255,212,0,0,0,0,0,0,0,0,0,0,0,0,0,0,20,243,255,255,255,255,255,158,6,0,0,0,0,0,0,107,
  247,132,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,136,255,255,255,255,255,24,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,160,255,255,255,255,124,0,0,0,0,0,0,0,0,0,241,255,255,255,255,233,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,100,255,255,255,255,255,60,0,0,0,0,0,0,98,255,255,255,255,255,122,0,0,0,0,0,
  0,214,255,255,245,0,0,0,156,255,255,255,100,0,0,0,0,0,0,157,255,255,255,16,0,160,255,255,255,255,255,255,
  255,255,255,255,255,255,255,255,232,135,13,0,0,0,0,100,255,255,255,255,255,60,0,0,0,0,0,0,192,255,255,255,
  255,224,0,0,0,0,0,0,138,255,255,255,255,190,0,0,0,71,255,255,255,255,249,10,0,0,0,0,204,255,255,255,
  255,212,0,0,0,0,0,0,0,0,0,0,0,0,0,0,110,255,255,255,255,255,199,4,0,0,0,0,0,0,0,0,
  75,128,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,136,255,255,255,255,255,24,0,0,0,0,0,0,0,
  0,0,0,0,0,0,184,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,52,0,0,0,0,0,0,0,0,
  0,0,102,164,164,164,164,79,0,0,0,0,0,0,0,0,1,254,255,255,255,255,208,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,100,255,255,255,255,255,60,0,0,0,0,0,0,65,255,255,255,255,255,150,0,0,0,0,0,
  0,223,255,255,236,0,0,0,168,255,255,255,76,0,0,0,0,0,0,132,255,255,255,16,0,160,255,255,255,255,255,255,
  255,255,255,255,255,255,255,255,255,255,220,33,0,0,0,100,255,255,255,255,255,60,0,0,0,0,0,0,192,255,255,255,
  255,224,0,0,0,0,0,0,206,255,255,255,255,132,0,0,0,15,253,255,255,255,255,71,0,0,0,0,204,255,255,255,
  255,255,255,255,255,255,255,255,255,255,255,255,200,0,0,0,204,255,255,255,255,255,65,0,0,0,0,0,0,0,0,0,
  0,18,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,136,255,255,255,255,255,255,255,255,255,255,255,255,255,
  255,255,255,24,0,0,184,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,52,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,14,255,255,255,255,255,198,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,100,255,255,255,255,255,60,0,0,0,0,0,0,46,255,255,255,255,255,171,0,0,0,0,0,
  0,209,255,255,250,0,0,0,155,255,255,255,100,0,0,0,0,0,0,157,255,255,255,16,0,160,255,255,255,255,208,0,
  0,0,1,14,54,144,251,255,255,255,255,208,6,0,0,100,255,255,255,255,255,60,0,0,0,0,0,0,192,255,255,255,
  255,224,0,0,0,0,0,19,254,255,255,255,255,74,0,0,0,0,211,255,255,255,255,139,0,0,0,0,204,255,255,255,
  255,255,255,255,255,255,255,255,255,255,255,255,200,0,0,22,255,255,255,255,255,219,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,136,255,255,255,255,255,255,255,255,255,255,255,255,255,
  255,255,255,24,0,0,184,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,52,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,24,255,255,255,255,255,190,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,100,255,255,255,255,255,60,0,0,0,0,0,0,37,255,255,255,255,255,180,0,0,0,0,0,
  0,192,255,255,255,11,0,0,129,255,255,255,150,0,0,0,0,0,0,207,255,255,255,16,0,160,255,255,255,255,208,0,
  0,0,0,0,0,0,95,255,255,255,255,255,97,0,0,100,255,255,255,255,255,60,0,0,0,0,0,0,192,255,255,255,
  255,224,0,0,0,0,0,86,255,255,255,255,255,158,144,144,144,144,217,255,255,255,255,207,0,0,0,0,204,255,255,255,
  255,255,255,255,255,255,255,255,255,255,255,255,200,0,0,71,255,255,255,255,255,149,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,136,255,255,255,255,255,255,255,255,255,255,255,255,255,
  255,255,255,24,0,0,184,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,52,0,0,0,0,0,0,0,0,
  0,0,160,255,255,255,255,116,0,0,0,0,0,0,0,0,15,255,255,255,255,255,198,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,100,255,255,255,255,255,60,0,0,0,0,0,0,30,255,255,255,255,255,186,0,0,0,0,0,
  0,174,255,255,255,43,0,0,74,255,255,255,246,27,0,0,0,0,77,255,255,255,255,16,0,160,255,255,255,255,208,0,
  0,0,0,0,0,0,1,225,255,255,255,255,186,0,0,100,255,255,255,255,255,60,0,0,0,0,0,0,192,255,255,255,
  255,224,0,0,0,0,0,153,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,254,20,0,0,0,204,255,255,255,
  255,255,255,255,255,255,255,255,255,255,255,255,200,0,0,120,255,255,255,255,255,99,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,136,255,255,255,255,255,255,255,255,255,255,255,255,255,
  255,255,255,24,0,0,103,144,144,144,144,151,255,255,255,255,255,207,144,144,144,144,144,29,0,0,0,0,0,0,0,0,
  0,0,160,255,255,255,255,116,0,0,0,0,0,0,0,0,2,254,255,255,255,255,208,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,100,255,255,255,255,255,60,0,0,0,0,0,0,37,255,255,255,255,255,180,0,0,0,0,0,
  0,136,255,255,255,99,0,0,9,238,255,255,255,215,69,9,17,97,240,255,255,255,255,16,0,160,255,255,255,255,208,0,
  0,0,0,0,0,0,0,175,255,255,255,255,238,0,0,100,255,255,255,255,255,170,144,144,144,144,144,144,228,255,255,255,
  255,224,0,0,0,0,0,221,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,87,0,0,0,204,255,255,255,
  255,236,144,144,144,144,144,144,144,144,144,144,112,0,0,153,255,255,255,255,255,64,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,136,255,255,255,255,255,154,144,144,144,144,144,144,144,
  144,144,144,13,0,0,0,0,0,0,0,16,255,255,255,255,255,144,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,160,255,255,255,255,116,0,0,0,0,0,0,0,0,0,242,255,255,255,255,232,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,100,255,255,255,255,255,60,0,0,0,0,0,0,46,255,255,255,255,255,170,0,0,0,0,0,
  0,78,255,255,255,161,0,0,0,130,255,255,255,255,255,255,255,255,255,255,255,255,255,16,0,160,255,255,255,255,208,0,
  0,0,0,0,0,0,0,165,255,255,255,255,255,4,0,100,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  255,224,0,0,0,0,32,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,155,0,0,0,204,255,255,255,
  255,212,0,0,0,0,0,0,0,0,0,0,0,0,0,168,255,255,255,255,255,40,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,136,255,255,255,255,255,24,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,16,255,255,255,255,255,144,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,160,255,255,255,255,116,0,0,0,0,0,0,0,0,0,209,255,255,255,255,255,12,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,100,255,255,255,255,255,60,0,0,0,0,0,0,67,255,255,255,255,255,149,0,0,0,0,0,
  0,20,255,255,255,244,15,0,0,7,209,255,255,255,255,255,255,255,255,252,255,255,255,16,0,160,255,255,255,255,208,0,
  0,0,0,0,0,0,0,188,255,255,255,255,255,7,0,100,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  255,224,0,0,0,0,100,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,222,0,0,0,204,255,255,255,
  255,212,0,0,0,0,0,0,0,0,0,0,0,0,0,182,255,255,255,255,255,30,0,0,0,33,144,144,144,144,144,144,
  144,144,74,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,136,255,255,255,255,255,24,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,16,255,255,255,255,255,144,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,160,255,255,255,255,116,0,0,0,0,0,0,0,0,0,161,255,255,255,255,255,63,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,100,255,255,255,255,255,60,0,0,0,0,0,0,99,255,255,255,255,255,120,0,0,0,0,0,
  0,0,200,255,255,255,114,0,0,0,22,204,255,255,255,255,255,255,193,177,255,255,255,16,0,160,255,255,255,255,208,0,
  0,0,0,0,0,0,16,244,255,255,255,255,243,0,0,100,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  255,224,0,0,0,0,168,255,255,255,255,212,0,0,0,0,0,0,0,100,255,255,255,255,255,34,0,0,204,255,255,255,
  255,212,0,0,0,0,0,0,0,0,0,0,0,0,0,192,255,255,255,255,255,22,0,0,0,60,255,255,255,255,255,255,
  255,255,132,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,136,255,255,255,255,255,24,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,16,255,255,255,255,255,144,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,112,255,255,255,255,255,133,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,100,255,255,255,255,255,60,0,0,0,0,0,0,143,255,255,255,255,255,80,0,0,0,0,0,
  0,0,91,255,255,255,241,30,0,0,0,3,102,193,237,248,217,128,7,96,144,144,144,9,0,160,255,255,255,255,208,0,
  0,0,0,0,0,18,180,255,255,255,255,255,200,0,0,100,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  255,224,0,0,0,1,234,255,255,255,255,150,0,0,0,0,0,0,0,36,255,255,255,255,255,102,0,0,204,255,255,255,
  255,212,0,0,0,0,0,0,0,0,0,0,0,0,0,182,255,255,255,255,255,29,0,0,0,60,255,255,255,255,255,255,
  255,255,132,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,136,255,255,255,255,255,24,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,16,255,255,255,255,255,144,0,0,0,0,0,0,0,0,0,0,0,76,255,255,
  255,255,255,255,255,255,255,255,255,255,52,0,0,0,0,0,0,38,255,255,255,255,255,228,6,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,100,255,255,255,255,255,60,0,0,0,0,0,0,208,255,255,255,255,255,26,0,0,0,0,0,
  0,0,5,230,255,255,255,191,6,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,160,255,255,255,255,235,144,
  144,144,145,155,189,247,255,255,255,255,255,255,124,0,0,100,255,255,255,255,255,60,0,0,0,0,0,0,192,255,255,255,
  255,224,0,0,0,48,255,255,255,255,255,88,0,0,0,0,0,0,0,0,227,255,255,255,255,170,0,0,204,255,255,255,
  255,212,0,0,0,0,0,0,0,0,0,0,0,0,0,168,255,255,255,255,255,39,0,0,0,60,255,255,255,255,255,255,
  255,255,132,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,136,255,255,255,255,255,24,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,16,255,255,255,255,255,144,0,0,0,0,0,0,0,0,0,0,0,76,255,255,
  255,255,255,255,255,255,255,255,255,255,52,0,0,0,0,0,0,0,200,255,255,255,255,255,116,0,0,0,0,0,0,0,
  0,15,85,0,0,0,0,100,255,255,255,255,255,60,0,0,0,0,0,51,255,255,255,255,255,213,0,0,0,0,0,0,
  0,0,0,94,255,255,255,255,184,9,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,160,255,255,255,255,255,255,
  255,255,255,255,255,255,255,255,255,255,255,236,16,0,0,100,255,255,255,255,255,60,0,0,0,0,0,0,192,255,255,255,
  255,224,0,0,0,115,255,255,255,255,255,25,0,0,0,0,0,0,0,0,164,255,255,255,255,236,1,0,204,255,255,255,
  255,212,0,0,0,0,0,0,0,0,0,0,0,0,0,153,255,255,255,255,255,64,0,0,0,60,255,255,255,255,255,255,
  255,255,132,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,136,255,255,255,255,255,24,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,16,255,255,255,255,255,144,0,0,0,0,0,0,0,0,0,0,0,76,255,255,
  255,255,255,255,255,255,255,255,255,255,52,0,0,0,0,0,0,0,98,255,255,255,255,255,250,78,0,0,0,0,0,0,
  49,212,148,0,0,0,0,100,255,255,255,255,255,60,0,0,0,0,5,194,255,255,255,255,255,124,0,0,0,0,0,0,
  0,0,0,0,169,255,255,255,255,211,64,0,0,0,0,0,0,0,0,0,52,44,0,0,0,160,255,255,255,255,255,255,
  255,255,255,255,255,255,255,255,255,255,246,68,0,0,0,100,255,255,255,255,255,60,0,0,0,0,0,0,192,255,255,255,
  255,224,0,0,0,183,255,255,255,255,219,0,0,0,0,0,0,0,0,0,100,255,255,255,255,255,50,0,204,255,255,255,
  255,212,0,0,0,0,0,0,0,0,0,0,0,0,0,119,255,255,255,255,255,98,0,0,0,0,0,0,0,100,255,255,
  255,255,132,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,136,255,255,255,255,255,24,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,16,255,255,255,255,255,144,0,0,0,0,0,0,0,0,0,0,0,76,255,255,
  255,255,255,255,255,255,255,255,255,255,52,0,0,0,0,0,0,0,2,202,255,255,255,255,255,254,162,67,29,31,72,161,
  252,255,148,0,0,0,0,100,255,255,255,255,255,60,0,0,0,32,186,255,255,255,255,255,245,21,0,0,0,0,0,0,
  0,0,0,0,16,218,255,255,255,255,255,192,111,48,23,4,16,50,107,193,255,193,0,0,0,160,255,255,255,255,255,255,
  255,255,255,255,255,255,255,255,255,193,47,0,0,0,0,100,255,255,255,255,255,60,0,0,0,0,0,0,192,255,255,255,
  255,224,0,0,6,244,255,255,255,255,157,0,0,0,0,0,0,0,0,0,36,255,255,255,255,255,118,0,204,255,255,255,
  255,236,144,144,144,144,144,144,144,144,144,144,144,132,0,71,255,255,255,255,255,150,0,0,0,0,0,0,0,100,255,255,
  255,255,132,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,136,255,255,255,255,255,24,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,16,255,255,255,255,255,144,0,0,0,0,0,0,0,0,0,0,0,42,144,144,
  144,144,144,144,191,255,255,255,255,255,52,0,0,0,0,0,0,0,0,49,247,255,255,255,255,255,255,255,255,255,255,255,
  255,255,148,0,0,0,0,100,255,255,255,255,255,170,144,160,199,254,255,255,255,255,255,255,119,0,0,0,0,0,0,0,
  0,0,0,0,0,28,215,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,76,0,0,160,255,255,255,255,255,255,
  255,255,254,245,234,211,171,121,42,0,0,0,0,0,0,100,255,255,255,255,255,60,0,0,0,0,0,0,192,255,255,255,
  255,224,0,0,62,255,255,255,255,255,95,0,0,0,0,0,0,0,0,0,0,227,255,255,255,255,186,0,204,255,255,255,
  255,255,255,255,255,255,255,255,255,255,255,255,255,236,0,22,255,255,255,255,255,218,0,0,0,0,0,0,0,100,255,255,
  255,255,132,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,136,255,255,255,255,255,24,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,16,255,255,255,255,255,144,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,108,255,255,255,255,255,52,0,0,0,0,0,0,0,0,0,70,247,255,255,255,255,255,255,255,255,255,255,
  255,255,148,0,0,0,0,100,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,175,2,0,0,0,0,0,0,0,
  0,0,0,0,0,0,14,169,255,255,255,255,255,255,255,255,255,255,255,255,255,255,191,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,100,255,255,255,255,255,60,0,0,0,0,0,0,192,255,255,255,
  255,224,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,204,255,255,255,
  255,255,255,255,255,255,255,255,255,255,255,255,255,236,0,0,201,255,255,255,255,255,62,0,0,0,0,0,0,100,255,255,
  255,255,132,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,136,255,255,255,255,255,24,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,16,255,255,255,255,255,144,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,108,255,255,255,255,255,52,0,0,0,0,0,0,0,0,0,0,61,217,255,255,255,255,255,255,255,255,255,
  255,255,148,0,0,0,0,100,255,255,255,255,255,255,255,255,255,255,255,255,255,255,144,3,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,72,198,255,255,255,255,255,255,255,255,255,255,248,151,17,0,0,184,255,255,255,255,232,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,100,255,255,255,255,255,60,0,0,0,0,0,0,192,255,255,255,
  255,224,0,196,255,255,255,255,220,0,0,0,0,0,0,0,2,184,255,255,255,255,255,159,0,0,0,0,204,255,255,255,
  255,255,255,255,255,255,255,255,255,255,255,255,255,236,0,0,108,255,255,255,255,255,193,2,0,0,0,0,0,100,255,255,
  255,255,132,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,136,255,255,255,255,255,24,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,16,255,255,255,255,255,144,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,108,255,255,255,255,255,52,0,0,0,0,0,0,0,0,0,0,0,6,114,207,255,255,255,255,255,255,255,
  246,175,56,0,0,0,0,100,255,255,255,255,255,255,255,255,255,255,255,255,188,67,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,42,121,180,219,243,252,241,220,172,108,19,0,0,0,0,184,255,255,255,255,232,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,100,255,255,255,255,255,60,0,0,0,0,0,0,192,255,255,255,
  255,224,0,196,255,255,255,255,220,0,0,0,0,0,0,0,127,255,255,255,255,255,205,8,0,0,0,0,204,255,255,255,
  255,255,255,255,255,255,255,255,255,255,255,255,255,236,0,0,19,241,255,255,255,255,255,141,1,0,0,0,0,100,255,255,
  255,255,132,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,136,255,255,255,255,255,24,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,16,255,255,255,255,255,144,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,108,255,255,255,255,255,52,0,0,0,0,0,0,0,0,0,0,0,0,0,0,29,79,101,122,118,98,58,
  7,0,0,0,0,0,0,100,255,255,255,255,255,254,242,225,207,164,105,40,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,184,255,255,255,255,232,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,100,255,255,255,255,255,60,0,0,0,0,0,0,192,255,255,255,
  255,224,0,196,255,255,255,255,220,0,0,0,0,0,0,70,253,255,255,255,255,236,31,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,111,255,255,255,255,255,255,191,79,31,23,68,199,255,255,
  255,255,132,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,16,255,255,255,255,255,144,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,108,255,255,255,255,255,52,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,5,63,95,120,106,80,26,0,0,0,0,0,0,0,0,0,0,184,255,255,255,255,232,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,100,255,255,255,255,255,60,0,0,0,0,0,0,192,255,255,255,
  255,224,0,196,255,255,255,255,220,0,0,0,0,0,29,235,255,255,255,255,253,70,0,0,0,0,188,255,255,255,255,255,
  124,0,0,0,0,0,0,0,200,255,255,255,255,44,0,0,0,3,199,255,255,255,255,255,255,255,255,255,255,255,255,255,
  255,255,132,0,236,255,255,255,255,255,255,255,246,234,218,178,134,61,1,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,16,255,255,255,255,255,144,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,108,255,255,255,255,255,52,0,0,0,0,0,0,0,0,5,63,95,120,107,81,27,0,0,0,0,0,0,
  0,0,0,0,92,255,255,255,255,255,255,122,0,0,0,0,0,14,251,255,255,255,255,255,216,0,0,0,0,0,0,0,
  0,0,0,0,0,0,14,143,235,255,255,255,255,255,253,189,62,0,0,0,0,0,0,0,0,184,255,255,255,255,232,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,100,255,255,255,255,255,60,0,0,0,0,0,0,192,255,255,255,
  255,224,0,196,255,255,255,255,220,0,0,0,0,5,199,255,255,255,255,255,122,0,0,0,0,0,188,255,255,255,255,255,
  219,0,0,0,0,0,0,0,200,255,255,255,255,44,0,0,0,0,18,208,255,255,255,255,255,255,255,255,255,255,255,255,
  255,255,131,0,236,255,255,255,255,255,255,255,255,255,255,255,255,255,224,86,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,16,255,255,255,255,255,144,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,108,255,255,255,255,255,52,0,0,0,0,0,0,14,143,235,255,255,255,255,255,253,191,64,0,0,0,0,
  0,0,0,0,92,255,255,255,255,255,255,190,0,0,0,0,0,78,255,255,255,255,255,255,216,0,0,0,0,0,0,0,
  0,0,0,0,0,53,224,255,255,255,255,255,255,255,255,255,253,134,0,0,0,0,0,0,0,184,255,255,255,255,232,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,100,255,255,255,255,255,60,0,0,0,0,0,0,192,255,255,255,
  255,224,0,196,255,255,255,255,220,0,0,0,0,146,255,255,255,255,255,176,1,0,0,0,0,0,188,255,255,255,255,255,
  255,60,0,0,0,0,0,0,200,255,255,255,255,44,0,0,0,0,0,20,174,255,255,255,255,255,255,255,255,255,255,255,
  255,157,16,0,236,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,150,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,16,255,255,255,255,255,144,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,108,255,255,255,255,255,52,0,0,0,0,0,53,224,255,255,255,255,255,255,255,255,255,254,138,1,0,0,
  0,0,0,0,92,255,255,255,255,255,255,248,9,0,0,0,0,145,255,255,255,255,255,255,216,0,0,0,0,0,0,0,
  0,0,0,0,35,235,255,255,255,255,255,255,255,255,255,255,255,255,125,0,0,0,0,0,0,184,255,255,255,255,232,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,100,255,255,255,255,255,60,0,0,0,0,0,0,192,255,255,255,
  255,224,0,196,255,255,255,255,220,0,0,0,86,255,255,255,255,255,217,14,0,0,0,0,0,0,188,255,255,255,255,255,
  255,156,0,0,0,0,0,0,200,255,255,255,255,44,0,0,0,0,0,0,0,74,186,250,255,255,255,255,255,255,242,159,
  49,0,0,0,236,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,109,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,16,255,255,255,255,255,144,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,108,255,255,255,255,255,52,0,0,0,0,35,235,255,255,255,255,255,255,255,255,255,255,255,255,130,0,0,
  0,0,0,0,92,255,255,255,255,255,255,255,70,0,0,0,0,213,255,255,255,255,255,255,216,0,0,0,0,0,0,0,
  0,0,0,2,208,255,255,255,255,255,255,255,255,255,255,255,255,255,254,67,0,0,0,0,0,184,255,255,255,255,232,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,196,255,255,255,255,220,0,0,40,243,255,255,255,255,244,43,0,0,0,0,0,0,0,188,255,255,255,255,255,
  255,241,10,0,0,0,0,0,200,255,255,255,255,44,0,0,0,0,0,0,0,0,0,16,73,98,120,114,95,52,3,0,
  0,0,0,0,236,255,255,255,255,222,144,144,150,171,224,255,255,255,255,255,255,235,13,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,16,255,255,255,255,255,144,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,108,255,255,255,255,255,52,0,0,0,2,208,255,255,255,255,255,255,255,255,255,255,255,255,255,255,71,0,
  0,0,0,0,92,255,255,255,255,255,255,255,138,0,0,0,25,255,255,255,255,255,255,255,216,0,0,0,0,0,0,0,
  0,0,0,92,255,255,255,255,255,231,90,28,50,171,255,255,255,255,255,201,0,0,0,0,0,184,255,255,255,255,232,0,
  0,0,0,0,0,0,0,0,0,0,0,0,120,255,255,255,255,255,255,255,255,244,232,209,166,112,27,0,0,0,0,0,
  0,0,0,196,255,255,255,255,220,0,11,212,255,255,255,255,255,87,0,0,0,0,0,0,0,0,188,255,255,255,255,255,
  255,255,93,0,0,0,0,0,200,255,255,255,255,44,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,236,255,255,255,255,180,0,0,0,0,0,83,247,255,255,255,255,255,85,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,103,144,144,144,144,151,255,255,255,255,255,207,144,144,144,144,144,29,0,0,0,0,0,0,0,0,
  0,0,0,0,108,255,255,255,255,255,52,0,0,0,92,255,255,255,255,255,231,90,28,50,171,255,255,255,255,255,206,1,
  0,0,0,0,92,255,255,255,255,254,255,255,207,0,0,0,92,255,255,254,255,255,255,255,216,0,0,0,0,0,0,0,
  0,0,0,215,255,255,255,255,251,46,0,0,0,1,179,255,255,255,255,255,71,0,0,0,0,184,255,255,255,255,232,0,
  0,0,0,0,0,0,0,0,0,0,0,0,120,255,255,255,255,255,255,255,255,255,255,255,255,255,253,165,23,0,0,0,
  0,0,0,196,255,255,255,255,220,0,164,255,255,255,255,255,141,0,0,0,0,0,0,0,0,0,188,255,255,255,255,255,
  255,255,189,0,0,0,0,0,200,255,255,255,255,44,0,0,0,0,0,0,0,21,77,105,122,116,100,64,20,0,0,0,
  0,0,0,0,236,255,255,255,255,180,0,0,0,0,0,0,124,255,255,255,255,255,149,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,184,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,52,0,0,0,0,0,0,0,0,
  0,0,0,0,108,255,255,255,255,255,52,0,0,0,215,255,255,255,255,251,46,0,0,0,1,179,255,255,255,255,255,75,
  0,0,0,0,92,255,255,255,255,211,255,255,254,20,0,0,160,255,255,211,255,255,255,255,216,0,0,0,0,0,0,0,
  0,0,43,255,255,255,255,255,158,0,0,0,0,0,42,255,255,255,255,255,155,0,0,0,0,184,255,255,255,255,232,0,
  0,0,0,0,0,0,0,0,0,0,0,0,120,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,224,26,0,0,
  0,0,0,196,255,255,255,255,220,105,255,255,255,255,255,192,4,0,0,0,0,0,0,0,0,0,188,255,255,255,255,255,
  255,255,254,30,0,0,0,0,200,255,255,255,255,44,0,0,0,0,0,79,196,255,255,255,255,255,255,255,255,210,137,42,
  0,0,0,0,236,255,255,255,255,180,0,0,0,0,0,0,43,255,255,255,255,255,182,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,184,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,52,0,0,0,0,0,0,0,0,
  0,0,0,0,108,255,255,255,255,255,52,0,0,43,255,255,255,255,255,158,0,0,0,0,0,42,255,255,255,255,255,159,
  0,0,0,0,92,255,255,255,255,150,255,255,255,87,0,0,227,255,255,150,255,255,255,255,216,0,0,0,0,0,0,0,
  0,0,120,255,255,255,255,255,72,0,0,0,0,0,0,212,255,255,255,255,232,1,0,0,0,184,255,255,255,255,232,0,
  0,0,0,0,0,0,0,0,0,0,0,0,120,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,190,0,0,
  0,0,0,196,255,255,255,255,242,248,255,255,255,255,255,52,0,0,0,0,0,0,0,0,0,0,188,255,255,255,255,200,
  255,255,255,125,0,0,0,0,200,255,255,255,255,44,0,0,0,11,167,255,255,255,255,255,255,255,255,255,255,255,255,255,
  117,0,0,0,236,255,255,255,255,180,0,0,0,0,0,0,13,255,255,255,255,255,201,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,184,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,52,0,0,0,0,0,0,0,0,
  0,0,0,0,108,255,255,255,255,255,52,0,0,120,255,255,255,255,255,72,0,0,0,0,0,0,212,255,255,255,255,235,
  3,0,0,0,92,255,255,255,255,124,220,255,255,155,0,39,255,255,255,90,255,255,255,255,216,0,0,0,0,0,0,0,
  0,0,179,255,255,255,255,255,13,0,0,0,0,0,0,152,255,255,255,255,255,39,0,0,0,184,255,255,255,255,232,0,
  0,0,0,0,0,0,0,0,0,0,0,0,120,255,255,255,255,255,161,144,144,155,193,252,255,255,255,255,255,255,61,0,
  0,0,0,196,255,255,255,255,255,255,255,255,255,255,255,157,0,0,0,0,0,0,0,0,0,0,188,255,255,255,255,104,
  255,255,255,220,0,0,0,0,200,255,255,255,255,44,0,0,3,180,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  136,0,0,0,236,255,255,255,255,180,0,0,0,0,0,0,11,255,255,255,255,255,202,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,184,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,52,0,0,0,0,0,0,0,0,
  0,0,0,0,108,255,255,255,255,255,51,0,0,179,255,255,255,255,255,13,0,0,0,0,0,0,152,255,255,255,255,255,
  41,0,0,0,92,255,255,255,255,124,159,255,255,223,0,107,255,255,255,29,255,255,255,255,216,0,0,0,0,0,0,0,
  0,0,219,255,255,255,255,226,0,0,0,0,0,0,0,108,255,255,255,255,255,79,0,0,0,184,255,255,255,255,232,0,
  0,0,0,0,0,0,0,0,0,0,0,0,120,255,255,255,255,255,40,0,0,0,0,39,222,255,255,255,255,255,137,0,
  0,0,0,196,255,255,255,255,255,255,255,255,255,255,255,252,40,0,0,0,0,0,0,0,0,0,188,255,255,255,255,56,
  207,255,255,255,62,0,0,0,200,255,255,255,255,44,0,0,108,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  136,0,0,0,236,255,255,255,255,180,0,0,0,0,0,0,42,255,255,255,255,255,183,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,116,255,255,255,255,255,39,0,0,219,255,255,255,255,226,0,0,0,0,0,0,0,108,255,255,255,255,255,
  81,0,0,0,92,255,255,255,255,124,97,255,255,255,36,174,255,255,225,0,255,255,255,255,216,0,0,0,0,0,0,0,
  0,6,252,255,255,255,255,198,0,0,0,0,0,0,0,80,255,255,255,255,255,118,0,0,0,184,255,255,255,255,232,0,
  0,0,0,0,0,0,0,0,0,0,0,0,120,255,255,255,255,255,40,0,0,0,0,0,77,255,255,255,255,255,192,0,
  0,0,0,196,255,255,255,255,255,255,255,255,255,255,255,255,172,0,0,0,0,0,0,0,0,0,188,255,255,255,255,56,
  111,255,255,255,158,0,0,0,200,255,255,255,255,44,0,3,231,255,255,255,255,255,174,71,36,25,49,98,171,248,255,255,
  136,0,0,0,236,255,255,255,255,180,0,0,0,0,0,0,123,255,255,255,255,255,150,0,72,255,255,255,255,255,255,255,
  255,255,255,255,255,255,255,255,255,255,255,255,196,0,0,0,0,0,0,0,0,0,0,0,0,73,0,0,0,0,0,0,
  0,0,0,0,140,255,255,255,255,255,25,0,6,252,255,255,255,255,198,0,0,0,0,0,0,0,80,255,255,255,255,255,
  121,0,0,0,92,255,255,255,255,124,36,255,255,255,106,239,255,255,164,0,255,255,255,255,216,0,0,0,0,0,0,0,
  0,29,255,255,255,255,255,176,0,0,0,0,0,0,0,57,255,255,255,255,255,147,0,0,0,184,255,255,255,255,232,0,
  0,0,0,0,0,0,0,0,0,0,0,0,120,255,255,255,255,255,40,0,0,0,0,0,8,252,255,255,255,255,214,0,
  0,0,0,196,255,255,255,255,255,255,255,255,255,255,255,255,255,52,0,0,0,0,0,0,0,0,188,255,255,255,255,56,
  20,250,255,255,242,10,0,0,200,255,255,255,255,44,0,57,255,255,255,255,255,129,0,0,0,0,0,0,0,24,134,247,
  136,0,0,0,236,255,255,255,255,180,0,0,0,0,0,79,246,255,255,255,255,255,86,0,72,255,255,255,255,255,255,255,
  255,255,255,255,255,255,255,255,255,255,255,255,196,0,0,0,0,0,0,0,0,0,0,0,0,233,104,0,0,0,0,0,
  0,0,0,0,202,255,255,255,255,248,4,0,29,255,255,255,255,255,176,0,0,0,0,0,0,0,57,255,255,255,255,255,
  148,0,0,0,92,255,255,255,255,124,0,230,255,255,220,255,255,255,104,0,255,255,255,255,216,0,0,0,0,0,0,0,
  0,41,255,255,255,255,255,163,0,0,0,0,0,0,0,45,255,255,255,255,255,159,0,0,0,184,255,255,255,255,232,0,
  0,0,0,0,0,0,0,0,0,0,0,0,120,255,255,255,255,255,40,0,0,0,0,0,0,237,255,255,255,255,227,0,
  0,0,0,196,255,255,255,255,255,255,221,108,255,255,255,255,255,187,0,0,0,0,0,0,0,0,188,255,255,255,255,56,
  0,173,255,255,255,94,0,0,200,255,255,255,255,44,0,108,255,255,255,255,255,15,0,0,0,0,0,0,0,0,0,37,
  81,0,0,0,236,255,255,255,255,222,144,144,149,170,222,255,255,255,255,255,255,236,13,0,72,255,255,255,255,255,255,255,
  255,255,255,255,255,255,255,255,255,255,255,255,196,0,0,0,0,0,0,0,0,0,0,0,0,236,255,174,25,0,0,0,
  0,0,0,75,255,255,255,255,255,202,0,0,41,255,255,255,255,255,163,0,0,0,0,0,0,0,45,255,255,255,255,255,
  160,0,0,0,92,255,255,255,255,124,0,169,255,255,255,255,255,255,43,0,255,255,255,255,216,0,0,0,0,0,0,0,
  0,53,255,255,255,255,255,157,0,0,0,0,0,0,0,39,255,255,255,255,255,170,0,0,0,184,255,255,255,255,232,0,
  0,0,0,0,0,0,0,0,0,0,0,0,120,255,255,255,255,255,40,0,0,0,0,0,0,243,255,255,255,255,213,0,
  0,0,0,196,255,255,255,255,255,247,48,2,213,255,255,255,255,255,66,0,0,0,0,0,0,0,188,255,255,255,255,56,
  0,77,255,255,255,190,0,0,200,255,255,255,255,44,0,130,255,255,255,255,251,4,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,236,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,111,0,0,72,255,255,255,255,255,255,255,
  255,255,255,255,255,255,255,255,255,255,255,255,196,0,0,0,0,0,0,0,0,0,0,0,0,236,255,255,246,165,79,41,
  21,46,127,247,255,255,255,255,255,134,0,0,53,255,255,255,255,255,157,0,0,0,0,0,0,0,39,255,255,255,255,255,
  171,0,0,0,92,255,255,255,255,124,0,107,255,255,255,255,255,237,1,0,255,255,255,255,216,0,0,0,0,0,0,0,
  0,61,255,255,255,255,255,153,0,0,0,0,0,0,0,34,255,255,255,255,255,180,0,0,0,184,255,255,255,255,232,0,
  0,0,0,0,0,0,0,0,0,0,0,0,120,255,255,255,255,255,40,0,0,0,0,0,31,255,255,255,255,255,173,0,
  0,0,0,196,255,255,255,255,255,97,0,0,84,255,255,255,255,255,201,0,0,0,0,0,0,0,188,255,255,255,255,56,
  0,4,232,255,255,254,32,0,200,255,255,255,255,44,0,132,255,255,255,255,255,63,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,236,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,154,0,0,0,40,144,144,144,144,144,144,151,
  255,255,255,255,255,207,144,144,144,144,144,144,110,0,0,0,0,0,0,0,0,0,0,0,0,236,255,255,255,255,255,255,
  255,255,255,255,255,255,255,255,253,34,0,0,61,255,255,255,255,255,153,0,0,0,0,0,0,0,34,255,255,255,255,255,
  180,0,0,0,92,255,255,255,255,124,0,46,255,255,255,255,255,178,0,0,255,255,255,255,216,0,0,0,0,0,0,0,
  0,53,255,255,255,255,255,157,0,0,0,0,0,0,0,39,255,255,255,255,255,176,0,0,0,184,255,255,255,255,232,0,
  0,0,0,0,0,0,0,0,0,0,0,0,120,255,255,255,255,255,40,0,0,0,0,0,139,255,255,255,255,255,100,0,
  0,0,0,196,255,255,255,255,222,0,0,0,1,206,255,255,255,255,255,81,0,0,0,0,0,0,188,255,255,255,255,56,
  0,0,140,255,255,255,127,0,200,255,255,255,255,44,0,109,255,255,255,255,255,221,43,0,0,0,0,0,0,0,0,0,
  0,0,0,0,236,255,255,255,255,255,255,255,255,255,255,255,255,255,227,91,0,0,0,0,0,0,0,0,0,0,0,16,
  255,255,255,255,255,144,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,236,255,255,255,255,255,255,
  255,255,255,255,255,255,255,255,136,0,0,0,53,255,255,255,255,255,157,0,0,0,0,0,0,0,39,255,255,255,255,255,
  172,0,0,0,92,255,255,255,255,124,0,1,238,255,255,255,255,117,0,0,255,255,255,255,216,0,0,0,0,0,0,0,
  0,41,255,255,255,255,255,163,0,0,0,0,0,0,0,45,255,255,255,255,255,168,0,0,0,184,255,255,255,255,232,0,
  0,0,0,0,0,0,0,0,0,0,0,0,120,255,255,255,255,255,40,0,0,9,49,149,254,255,255,255,255,224,10,0,
  0,0,0,196,255,255,255,255,220,0,0,0,0,76,255,255,255,255,255,213,2,0,0,0,0,0,188,255,255,255,255,56,
  0,0,43,255,255,255,221,1,200,255,255,255,255,44,0,56,255,255,255,255,255,255,251,159,48,0,0,0,0,0,0,0,
  0,0,0,0,236,255,255,255,255,255,255,255,248,236,220,181,136,64,2,0,0,0,0,0,0,0,0,0,0,0,0,16,
  255,255,255,255,255,144,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,212,255,255,255,255,255,255,
  255,255,255,255,255,255,255,160,5,0,0,0,41,255,255,255,255,255,163,0,0,0,0,0,0,0,45,255,255,255,255,255,
  160,0,0,0,92,255,255,255,255,124,0,0,179,255,255,255,255,57,0,0,255,255,255,255,216,0,0,0,0,0,0,0,
  0,29,255,255,255,255,255,176,0,0,0,0,0,0,0,57,255,255,255,255,255,152,0,0,0,184,255,255,255,255,232,0,
  0,0,0,0,0,0,0,0,0,0,0,0,120,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,242,56,0,0,
  0,0,0,196,255,255,255,255,220,0,0,0,0,0,199,255,255,255,255,255,96,0,0,0,0,0,188,255,255,255,255,56,
  0,0,0,202,255,255,255,63,200,255,255,255,255,44,0,1,219,255,255,255,255,255,255,255,255,202,103,14,0,0,0,0,
  0,0,0,0,236,255,255,255,255,180,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,16,
  255,255,255,255,255,144,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,73,160,231,255,255,255,
  255,255,255,255,255,196,81,0,0,0,0,0,29,255,255,255,255,255,176,0,0,0,0,0,0,0,57,255,255,255,255,255,
  148,0,0,0,92,255,255,255,255,124,0,0,60,116,116,116,116,6,0,0,255,255,255,255,216,0,0,0,0,0,0,0,
  0,7,252,255,255,255,255,198,0,0,0,0,0,0,0,80,255,255,255,255,255,127,0,0,0,184,255,255,255,255,232,0,
  0,0,0,0,0,0,0,0,0,0,0,0,120,255,255,255,255,255,255,255,255,255,255,255,255,255,253,178,38,0,0,0,
  0,0,0,196,255,255,255,255,220,0,0,0,0,0,67,255,255,255,255,255,224,6,0,0,0,0,188,255,255,255,255,56,
  0,0,0,106,255,255,255,160,200,255,255,255,255,44,0,0,78,255,255,255,255,255,255,255,255,255,255,244,148,30,0,0,
  0,0,0,0,236,255,255,255,255,180,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,16,
  255,255,255,255,255,144,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,35,79,108,
  122,118,102,72,18,0,0,0,0,0,0,0,7,252,255,255,255,255,198,0,0,0,0,0,0,0,80,255,255,255,255,255,
  122,0,0,0,92,255,255,255,255,124,0,0,0,0,0,0,0,0,0,0,255,255,255,255,216,0,0,0,0,0,0,0,
  0,0,220,255,255,255,255,226,0,0,0,0,0,0,0,107,255,255,255,255,255,96,0,0,0,184,255,255,255,255,232,0,
  0,0,0,0,0,0,0,0,0,0,0,0,120,255,255,255,255,255,255,255,255,255,255,255,255,226,62,0,0,0,0,0,
  0,0,0,196,255,255,255,255,220,0,0,0,0,0,0,191,255,255,255,255,255,111,0,0,0,0,188,255,255,255,255,56,
  0,0,0,17,248,255,255,244,212,255,255,255,255,44,0,0,0,108,253,255,255,255,255,255,255,255,255,255,255,246,118,1,
  0,0,0,0,236,255,255,255,255,180,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,16,
  255,255,255,255,255,144,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,220,255,255,255,255,226,0,0,0,0,0,0,0,107,255,255,255,255,255,
  82,0,0,0,92,255,255,255,255,124,0,0,0,0,0,0,0,0,0,0,255,255,255,255,216,0,0,0,0,0,0,0,
  0,0,179,255,255,255,255,255,13,0,0,0,0,0,0,151,255,255,255,255,255,50,0,0,0,184,255,255,255,255,245,144,
  144,144,144,144,144,144,144,144,144,144,132,0,120,255,255,255,255,255,255,255,255,255,255,255,255,255,243,42,0,0,0,0,
  0,0,0,196,255,255,255,255,220,0,0,0,0,0,0,59,255,255,255,255,255,233,12,0,0,0,188,255,255,255,255,56,
  0,0,0,0,169,255,255,255,255,255,255,255,255,44,0,0,0,0,60,215,255,255,255,255,255,255,255,255,255,255,255,168,
  2,0,0,0,236,255,255,255,255,180,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,16,
  255,255,255,255,255,144,0,0,0,0,0,0,0,0,252,255,255,255,255,164,0,0,0,0,0,0,0,48,255,255,255,255,
  255,112,0,0,0,0,0,0,0,0,0,0,0,179,255,255,255,255,255,13,0,0,0,0,0,0,151,255,255,255,255,255,
  42,0,0,0,92,255,255,255,255,124,0,0,0,0,0,0,0,0,0,0,255,255,255,255,216,0,0,0,0,0,0,0,
  0,0,120,255,255,255,255,255,71,0,0,0,0,0,0,210,255,255,255,255,246,7,0,0,0,184,255,255,255,255,255,255,
  255,255,255,255,255,255,255,255,255,255,236,0,120,255,255,255,255,255,161,144,174,249,255,255,255,255,255,195,0,0,0,0,
  0,0,0,196,255,255,255,255,220,0,0,0,0,0,0,0,183,255,255,255,255,255,125,0,0,0,188,255,255,255,255,56,
  0,0,0,0,72,255,255,255,255,255,255,255,255,44,0,0,0,0,0,3,99,215,255,255,255,255,255,255,255,255,255,255,
  139,0,0,0,236,255,255,255,255,180,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,16,
  255,255,255,255,255,144,0,0,0,0,0,0,0,0,252,255,255,255,255,164,0,0,0,0,0,0,0,48,255,255,255,255,
  255,112,0,0,0,0,0,0,0,0,0,0,0,120,255,255,255,255,255,71,0,0,0,0,0,0,210,255,255,255,255,235,
  3,0,0,0,92,255,255,255,255,124,0,0,0,0,0,0,0,0,0,0,255,255,255,255,216,0,0,0,0,0,0,0,
  0,0,42,255,255,255,255,255,156,0,0,0,0,0,41,255,255,255,255,255,181,0,0,0,0,184,255,255,255,255,255,255,
  255,255,255,255,255,255,255,255,255,255,236,0,120,255,255,255,255,255,40,0,0,46,235,255,255,255,255,255,73,0,0,0,
  0,0,0,196,255,255,255,255,220,0,0,0,0,0,0,0,51,255,255,255,255,255,241,19,0,0,188,255,255,255,255,56,
  0,0,0,0,3,228,255,255,255,255,255,255,255,44,0,0,0,0,0,0,0,1,69,172,250,255,255,255,255,255,255,255,
  253,46,0,0,236,255,255,255,255,180,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,16,
  255,255,255,255,255,144,0,0,0,0,0,0,0,0,252,255,255,255,255,164,0,0,0,0,0,0,0,48,255,255,255,255,
  255,112,0,0,0,0,0,0,0,0,0,0,0,42,255,255,255,255,255,156,0,0,0,0,0,41,255,255,255,255,255,159,
  0,0,0,0,92,255,255,255,255,124,0,0,0,0,0,0,0,0,0,0,255,255,255,255,216,0,0,0,0,0,0,0,
  0,0,0,214,255,255,255,255,250,45,0,0,0,1,177,255,255,255,255,255,98,0,0,0,0,184,255,255,255,255,255,255,
  255,255,255,255,255,255,255,255,255,255,236,0,120,255,255,255,255,255,40,0,0,0,69,255,255,255,255,255,200,0,0,0,
  0,0,0,196,255,255,255,255,220,0,0,0,0,0,0,0,0,175,255,255,255,255,255,140,0,0,188,255,255,255,255,56,
  0,0,0,0,0,135,255,255,255,255,255,255,255,44,0,0,0,0,0,0,0,0,0,0,21,120,236,255,255,255,255,255,
  255,152,0,0,236,255,255,255,255,180,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,16,
  255,255,255,255,255,144,0,0,0,0,0,0,0,0,252,255,255,255,255,164,0,0,0,0,0,0,0,48,255,255,255,255,
  255,112,0,0,0,0,0,0,0,0,0,0,0,0,214,255,255,255,255,250,45,0,0,0,1,177,255,255,255,255,255,75,
  0,0,0,0,92,255,255,255,255,124,0,0,0,0,0,0,0,0,0,0,255,255,255,255,216,0,0,0,0,0,0,0,
  0,0,0,92,255,255,255,255,255,230,89,27,49,169,255,255,255,255,255,238,10,0,0,0,0,184,255,255,255,255,255,255,
  255,255,255,255,255,255,255,255,255,255,236,0,120,255,255,255,255,255,40,0,0,0,0,178,255,255,255,255,255,71,0,0,
  0,0,0,196,255,255,255,255,220,0,0,0,0,0,0,0,0,44,253,255,255,255,255,247,28,0,188,255,255,255,255,56,
  0,0,0,0,0,39,255,255,255,255,255,255,255,44,0,0,0,0,0,0,0,0,0,0,0,0,17,198,255,255,255,255,
  255,223,0,0,236,255,255,255,255,180,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,16,
  255,255,255,255,255,144,0,0,0,0,0,0,0,0,252,255,255,255,255,164,0,0,0,0,0,0,0,48,255,255,255,255,
  255,112,0,0,0,0,0,0,0,0,0,0,0,0,92,255,255,255,255,255,230,89,27,49,169,255,255,255,255,255,206,1,
  0,0,0,0,92,255,255,255,255,124,0,0,0,0,0,0,0,0,0,0,255,255,255,255,216,0,0,0,0,0,0,0,
  0,0,0,2,209,255,255,255,255,255,255,255,255,255,255,255,255,255,255,111,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,120,255,255,255,255,255,40,0,0,0,0,54,255,255,255,255,255,197,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,188,255,255,255,255,56,
  0,0,0,0,0,0,198,255,255,255,255,255,255,44,0,0,0,0,0,0,0,0,0,0,0,0,0,24,244,255,255,255,
  255,255,10,0,236,255,255,255,255,180,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,16,
  255,255,255,255,255,144,0,0,0,0,0,0,0,0,252,255,255,255,255,164,0,0,0,0,0,0,0,48,255,255,255,255,
  255,112,0,0,0,0,0,0,0,0,0,0,0,0,2,209,255,255,255,255,255,255,255,255,255,255,255,255,255,255,71,0,
  0,0,0,0,92,255,255,255,255,124,0,0,0,0,0,0,0,0,0,0,255,255,255,255,216,0,0,0,0,0,0,0,
  0,0,0,0,35,236,255,255,255,255,255,255,255,255,255,255,255,255,189,4,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,120,255,255,255,255,255,40,0,0,0,0,0,191,255,255,255,255,255,68,0,
  0,0,0,206,255,255,255,255,214,0,0,0,0,0,0,0,0,0,95,255,255,255,255,255,70,0,188,255,255,255,255,56,
  0,0,0,0,0,0,101,255,255,255,255,255,255,44,0,0,0,0,0,0,0,0,0,0,0,0,0,0,175,255,255,255,
  255,255,26,0,236,255,255,255,255,180,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,16,
  255,255,255,255,255,144,0,0,0,0,0,0,0,0,252,255,255,255,255,164,0,0,0,0,0,0,0,48,255,255,255,255,
  255,112,0,0,0,0,0,0,0,0,0,0,0,0,0,35,235,255,255,255,255,255,255,255,255,255,255,255,255,130,0,0,
  0,0,0,0,92,255,255,255,255,124,0,0,0,0,0,0,0,0,0,0,255,255,255,255,216,0,0,0,0,0,0,0,
  0,0,0,0,0,54,225,255,255,255,255,255,255,255,255,255,255,188,16,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,120,255,255,255,255,255,40,0,0,0,0,0,71,255,255,255,255,255,194,0,
  0,0,0,147,255,255,255,255,253,14,0,0,0,0,0,0,0,0,149,255,255,255,255,252,13,0,188,255,255,255,255,56,
  0,0,0,0,0,0,14,246,255,255,255,255,255,44,0,20,0,0,0,0,0,0,0,0,0,0,0,0,151,255,255,255,
  255,255,16,0,236,255,255,255,255,180,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,16,
  255,255,255,255,255,144,0,0,0,0,0,0,0,0,252,255,255,255,255,164,0,0,0,0,0,0,0,48,255,255,255,255,
  255,112,0,0,0,0,0,0,0,0,0,0,0,0,0,0,53,224,255,255,255,255,255,255,255,255,255,254,140,1,0,0,
  0,0,0,0,92,255,255,255,255,124,0,0,0,0,0,0,0,0,0,0,255,255,255,255,216,0,0,0,0,0,0,0,
  0,0,0,0,0,0,14,145,237,255,255,255,255,255,255,255,255,114,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,120,255,255,255,255,255,40,0,0,0,0,0,0,207,255,255,255,255,255,65,
  0,0,0,87,255,255,255,255,255,65,0,0,0,0,0,0,0,0,202,255,255,255,255,206,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,112,182,29,0,0,0,0,0,0,0,0,0,0,194,255,255,255,
  255,250,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,16,
  255,255,255,255,255,144,0,0,0,0,0,0,0,0,252,255,255,255,255,164,0,0,0,0,0,0,0,48,255,255,255,255,
  255,112,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,14,144,236,255,255,255,255,255,254,192,65,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,5,66,97,121,142,255,255,255,255,255,126,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,120,255,255,255,255,255,40,0,0,0,0,0,0,88,255,255,255,255,255,192,
  0,0,0,27,255,255,255,255,255,119,0,0,0,0,0,0,0,6,249,255,255,255,255,147,0,0,169,255,255,255,150,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,112,255,243,136,22,0,0,0,0,0,0,0,74,255,255,255,255,
  255,199,0,0,248,255,255,255,255,255,255,255,255,180,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,16,
  255,255,255,255,255,144,0,0,0,0,0,0,0,0,252,255,255,255,255,164,0,0,0,0,0,0,0,48,255,255,255,255,
  255,112,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,5,65,97,120,108,82,28,0,0,0,0,0,0,
  0,0,241,255,255,255,244,0,0,0,0,0,0,0,0,0,0,0,0,0,130,255,255,255,255,109,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,141,255,255,255,255,255,142,1,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,120,255,255,255,255,255,40,0,0,0,0,0,0,3,220,255,255,255,255,255,
  63,0,0,0,224,255,255,255,255,172,0,0,0,0,0,0,0,53,255,255,255,255,255,87,0,0,52,255,255,255,246,21,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,112,255,255,255,246,176,103,54,29,29,63,153,251,255,255,255,255,
  255,125,0,0,248,255,255,255,255,255,255,255,255,180,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,16,
  255,255,255,255,255,144,0,0,0,0,0,0,0,0,252,255,255,255,255,164,0,0,0,0,0,0,0,48,255,255,255,255,
  255,112,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,210,255,255,255,255,12,0,0,0,0,0,0,0,0,0,0,0,0,149,255,255,255,255,80,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,2,175,255,255,255,255,253,71,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,120,255,255,255,255,255,40,0,0,0,0,0,0,0,104,255,255,255,255,255,
  189,0,0,0,164,255,255,255,255,226,0,0,0,0,0,0,0,107,255,255,255,255,255,28,0,0,0,190,255,255,255,130,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,112,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  240,18,0,0,248,255,255,255,255,255,255,255,255,180,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,16,
  255,255,255,255,255,144,0,0,0,0,0,0,0,0,252,255,255,255,255,164,0,0,0,0,0,0,0,48,255,255,255,255,
  255,112,0,14,233,255,255,255,255,209,2,0,0,0,0,0,0,0,0,92,255,255,255,255,255,115,0,0,0,0,0,0,
  0,0,179,255,255,255,255,36,0,0,0,0,0,0,0,0,0,0,0,0,168,255,255,255,255,51,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,10,203,255,255,232,68,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,120,255,255,255,255,255,40,0,0,0,0,0,0,0,8,231,255,255,255,255,
  255,60,0,0,104,255,255,255,255,255,23,0,0,0,0,0,0,160,255,255,255,255,224,0,0,0,0,72,255,255,255,236,
  10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,112,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,253,
  86,0,0,0,248,255,255,255,255,255,255,255,255,180,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,16,
  255,255,255,255,255,144,0,0,0,0,0,0,0,0,252,255,255,255,255,164,0,0,0,0,0,0,0,48,255,255,255,255,
  255,112,0,0,102,255,255,255,255,255,100,0,0,0,0,0,0,0,9,227,255,255,255,255,220,6,0,0,0,0,0,0,
  0,0,148,255,255,255,255,61,0,0,0,0,0,0,0,0,0,0,0,0,187,255,255,255,255,22,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,24,225,190,24,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,44,255,255,255,255,255,77,0,0,0,0,0,0,214,255,255,255,255,164,0,0,0,0,0,209,255,255,255,
  110,0,0,0,0,0,0,0,0,0,0,0,0,0,0,70,232,255,255,255,255,255,255,255,255,255,255,255,255,255,240,89,
  0,0,0,0,248,255,255,255,255,24,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,16,
  255,255,255,255,255,144,0,0,0,0,0,0,0,0,252,255,255,255,255,164,0,0,0,0,0,0,0,48,255,255,255,255,
  255,112,0,0,3,210,255,255,255,255,231,12,0,0,0,0,0,0,125,255,255,255,255,255,81,0,0,0,0,0,0,0,
  0,0,117,255,255,255,255,85,0,0,0,0,0,0,0,0,0,0,0,0,206,255,255,255,248,1,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,27,2,0,0,0,0,0,152,255,255,255,255,255,116,0,0,
  0,0,0,0,0,0,0,10,234,255,255,255,255,249,30,0,60,255,255,255,255,255,255,255,255,255,112,0,0,0,0,0,
  0,0,0,0,1,239,255,255,255,255,130,0,0,0,0,0,13,253,255,255,255,255,105,0,0,0,0,0,92,255,255,255,
  223,4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,6,89,171,241,255,255,255,255,255,255,255,255,230,136,26,0,
  0,0,0,0,248,255,255,255,255,24,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,16,
  255,255,255,255,255,144,0,0,0,0,0,0,0,0,252,255,255,255,255,164,0,0,0,0,0,0,0,48,255,255,255,255,
  255,112,0,0,0,67,255,255,255,255,255,132,0,0,0,0,0,25,243,255,255,255,255,192,0,0,0,0,0,0,0,0,
  0,0,86,255,255,255,255,110,0,0,0,0,0,0,0,0,0,0,0,0,226,255,255,255,220,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,30,250,255,255,255,255,230,7,0,
  0,0,0,0,0,0,0,111,255,255,255,255,255,152,0,0,60,255,255,255,255,255,255,255,255,255,112,0,0,0,0,0,
  0,0,0,0,0,181,255,255,255,255,184,0,0,0,0,0,65,255,255,255,255,255,45,0,0,0,0,0,4,225,255,255,
  255,90,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,41,83,108,122,120,106,83,34,0,0,0,0,
  0,0,0,0,248,255,255,255,255,24,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,16,
  255,255,255,255,255,144,0,0,0,0,0,0,0,0,252,255,255,255,255,164,0,0,0,0,0,0,0,48,255,255,255,255,
  255,112,0,0,0,0,178,255,255,255,255,246,29,0,0,0,0,157,255,255,255,255,253,49,0,0,0,0,0,0,0,0,
  0,0,55,255,255,255,255,134,0,0,0,0,0,0,0,0,0,0,0,0,245,255,255,255,191,0,0,0,0,0,0,0,
  0,100,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,216,0,0,0,153,255,255,255,255,255,102,0,
  0,0,0,0,0,0,5,226,255,255,255,255,249,30,0,0,60,255,255,255,255,255,255,255,255,255,112,0,0,0,0,0,
  0,0,0,0,0,121,255,255,255,255,236,0,0,0,0,0,118,255,255,255,255,239,2,0,0,0,0,0,0,112,255,255,
  255,207,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,248,255,255,255,255,24,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,16,
  255,255,255,255,255,144,0,0,0,0,0,0,0,0,252,255,255,255,255,164,0,0,0,0,0,0,0,48,255,255,255,255,
  255,112,0,0,0,0,38,250,255,255,255,255,164,0,0,0,47,253,255,255,255,255,159,0,0,0,0,0,0,0,0,0,
  0,0,24,255,255,255,255,158,0,0,0,0,0,0,0,0,0,0,0,8,255,255,255,255,162,0,0,0,0,0,0,0,
  0,100,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,216,0,0,0,30,250,255,255,255,255,220,3,
  0,0,0,0,0,0,99,255,255,255,255,255,152,0,0,0,60,255,255,255,255,255,255,255,255,255,112,0,0,0,0,0,
  0,0,0,0,0,62,255,255,255,255,255,35,0,0,0,0,172,255,255,255,255,182,0,0,0,0,0,0,0,11,238,255,
  255,255,70,0,0,0,0,0,0,0,0,0,0,0,0,5,174,255,255,255,255,138,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,248,255,255,255,255,24,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,16,
  255,255,255,255,255,144,0,0,0,0,0,0,0,0,252,255,255,255,255,164,0,0,0,0,0,0,0,48,255,255,255,255,
  255,112,0,0,0,0,0,143,255,255,255,255,254,53,0,0,188,255,255,255,255,244,26,0,0,0,0,0,0,0,0,0,
  0,0,1,248,255,255,255,183,0,0,0,175,255,255,255,255,47,0,0,27,255,255,255,255,133,0,0,0,0,0,0,0,
  0,100,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,216,0,0,0,0,153,255,255,255,255,255,88,
  0,0,0,0,0,2,218,255,255,255,255,249,30,0,0,0,0,0,0,0,0,160,255,255,255,255,112,0,0,0,0,0,
  0,0,0,0,0,8,249,255,255,255,255,88,0,0,0,0,225,255,255,255,255,122,0,0,0,0,0,0,0,0,132,255,
  255,255,188,0,0,0,0,0,0,0,0,0,0,0,0,0,5,174,255,255,255,255,80,0,0,0,0,0,0,0,0,0,
  0,0,0,0,248,255,255,255,255,24,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,16,
  255,255,255,255,255,144,0,0,0,0,0,0,0,0,248,255,255,255,255,164,0,0,0,0,0,0,0,48,255,255,255,255,
  255,108,0,0,0,0,0,17,237,255,255,255,255,195,0,77,255,255,255,255,255,125,0,0,0,0,0,0,0,0,0,0,
  0,0,0,219,255,255,255,207,0,0,0,222,255,255,255,255,101,0,0,46,255,255,255,255,104,0,0,0,0,0,0,0,
  0,100,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,216,0,0,0,0,30,250,255,255,255,255,208,
  0,0,0,0,0,86,255,255,255,255,255,152,0,0,0,0,0,0,0,0,0,160,255,255,255,255,112,0,0,0,0,0,
  0,0,0,0,0,0,198,255,255,255,255,142,0,0,0,23,255,255,255,255,255,63,0,0,0,0,0,0,0,0,22,247,
  255,255,255,49,0,0,0,0,0,0,0,0,0,0,0,0,0,5,174,255,255,255,240,35,0,0,0,0,0,0,0,0,
  0,0,0,0,248,255,255,255,255,24,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,236,255,255,255,255,164,0,0,0,0,0,0,0,48,255,255,255,255,
  255,95,0,0,0,0,0,0,109,255,255,255,255,255,88,216,255,255,255,255,226,9,0,0,0,0,0,0,0,0,0,0,
  0,0,0,188,255,255,255,232,0,0,14,254,255,255,255,255,155,0,0,66,255,255,255,255,75,0,0,0,0,0,0,0,
  0,56,144,144,144,144,144,144,144,144,144,144,144,163,255,255,255,255,255,255,172,0,0,0,0,0,153,255,255,255,255,255,
  74,0,0,0,0,207,255,255,255,255,249,30,0,0,0,0,0,0,0,0,0,160,255,255,255,255,112,0,0,0,0,0,
  0,0,0,0,0,0,138,255,255,255,255,195,0,0,0,76,255,255,255,255,250,9,0,0,0,0,0,0,0,0,0,153,
  255,255,255,167,0,0,0,0,0,0,0,0,0,0,0,0,0,0,5,174,255,255,255,208,9,0,0,0,0,0,0,0,
  0,0,0,0,248,255,255,255,255,24,0,0,0,0,0,0,0,0,0,0,0,0,24,229,255,255,255,255,121,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,222,255,255,255,255,168,0,0,0,0,0,0,0,53,255,255,255,255,
  255,81,0,0,0,0,0,0,4,215,255,255,255,255,249,255,255,255,255,255,91,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,157,255,255,255,253,3,0,59,255,255,255,255,255,209,0,0,85,255,255,255,255,46,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,161,255,255,255,255,255,240,27,0,0,0,0,0,30,250,255,255,255,255,
  195,0,0,0,74,255,255,255,255,255,152,0,0,0,0,0,0,0,0,0,0,160,255,255,255,255,112,0,0,0,0,0,
  0,0,0,0,0,0,79,255,255,255,255,245,3,0,0,130,255,255,255,255,200,0,0,0,0,0,0,0,0,0,0,37,
  253,255,255,252,32,0,0,0,0,0,0,0,0,0,0,0,0,0,0,5,174,255,255,255,158,0,0,0,0,0,0,0,
  0,0,0,0,248,255,255,255,255,24,0,0,0,0,0,0,0,0,0,0,0,5,195,255,255,255,255,255,253,70,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,192,255,255,255,255,196,0,0,0,0,0,0,0,81,255,255,255,255,
  255,51,0,0,0,0,0,0,0,74,255,255,255,255,255,255,255,255,255,201,1,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,126,255,255,255,255,24,0,106,255,255,255,255,255,252,10,0,104,255,255,255,255,17,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,67,255,255,255,255,255,255,100,0,0,0,0,0,0,0,153,255,255,255,255,
  255,61,0,0,195,255,255,255,255,250,30,0,0,0,0,0,0,0,0,0,0,160,255,255,255,255,112,0,0,0,0,0,
  0,0,0,0,0,0,20,255,255,255,255,255,46,0,0,183,255,255,255,255,140,0,0,0,0,0,0,0,0,0,0,0,
  173,255,255,255,147,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,5,174,255,255,255,99,0,0,0,0,0,0,
  0,0,0,0,248,255,255,255,255,24,0,0,0,0,0,0,0,0,0,0,0,148,255,255,255,255,255,255,255,237,33,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,145,255,255,255,255,248,19,0,0,0,0,0,0,154,255,255,255,255,
  251,8,0,0,0,0,0,0,0,0,184,255,255,255,255,255,255,255,255,59,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,95,255,255,255,255,49,0,153,255,255,255,255,255,255,61,0,123,255,255,255,244,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,9,220,255,255,255,255,255,188,0,0,0,0,0,0,0,0,31,250,255,255,255,
  255,182,0,62,255,255,255,255,255,153,0,0,0,0,0,0,0,0,0,0,0,160,255,255,255,255,112,0,0,0,0,0,
  0,0,0,0,0,0,0,215,255,255,255,255,100,0,0,236,255,255,255,255,81,0,0,0,0,0,0,0,0,0,0,0,
  55,255,255,255,245,19,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,5,174,255,255,247,49,0,0,0,0,0,
  0,0,0,0,248,255,255,255,255,24,0,0,0,0,0,0,0,0,0,0,95,255,255,255,255,255,255,255,255,255,207,9,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,87,255,255,255,255,255,158,0,0,0,0,0,53,249,255,255,255,255,
  202,0,0,0,0,0,0,0,0,0,43,252,255,255,255,255,255,255,169,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,64,255,255,255,255,73,0,199,255,255,213,255,255,255,115,0,142,255,255,255,215,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,136,255,255,255,255,255,244,33,0,0,0,0,0,0,0,0,0,154,255,255,255,
  255,255,48,184,255,255,255,255,250,30,0,0,0,0,0,0,0,0,0,0,0,160,255,255,255,255,112,0,0,0,0,0,
  0,0,0,0,0,0,0,155,255,255,255,255,153,0,34,255,255,255,255,255,21,0,0,0,0,0,0,0,0,0,0,0,
  0,193,255,255,255,127,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,248,255,255,255,255,24,0,0,0,0,0,0,0,0,0,50,247,255,255,255,255,248,255,255,255,255,255,163,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,9,241,255,255,255,255,255,175,61,22,36,112,240,255,255,255,255,255,
  110,0,0,0,0,0,0,0,0,0,0,150,255,255,255,255,255,248,32,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,33,255,255,255,255,98,2,244,255,255,118,243,255,255,169,0,162,255,255,255,186,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,46,251,255,255,255,255,255,110,0,0,0,0,0,0,0,0,0,0,31,250,255,255,
  255,255,204,255,255,255,255,255,153,0,0,0,0,0,0,0,0,0,0,0,0,160,255,255,255,255,112,0,0,0,0,0,
  0,0,0,0,0,0,0,96,255,255,255,255,207,0,88,255,255,255,255,217,0,0,0,0,0,0,0,0,0,0,0,0,
  0,75,255,255,255,235,9,0,0,0,0,0,0,0,0,36,255,255,255,255,255,108,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,248,255,255,255,255,24,0,0,0,0,0,0,0,0,20,224,255,255,255,255,224,37,140,255,255,255,255,255,
  110,0,0,0,0,0,0,0,0,0,0,0,0,0,0,137,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,234,
  17,0,0,0,0,0,0,0,0,0,0,79,255,255,255,255,255,209,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,5,253,255,255,255,122,37,255,255,255,63,191,255,255,223,0,181,255,255,255,157,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,2,201,255,255,255,255,255,197,2,0,0,0,0,0,0,0,0,0,0,0,154,255,255,
  255,255,255,255,255,255,255,250,30,0,0,0,0,0,0,0,0,0,0,0,0,160,255,255,255,255,112,0,0,0,0,0,
  0,0,0,0,0,0,0,36,255,255,255,255,251,9,141,255,255,255,255,158,0,0,0,0,0,0,0,0,0,0,0,0,
  0,1,211,255,255,255,107,0,0,0,0,0,0,0,0,36,255,255,255,255,255,108,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,248,255,255,255,255,24,0,0,0,0,0,0,0,3,188,255,255,255,255,215,28,0,0,125,255,255,255,255,
  251,61,0,0,0,0,0,0,0,0,0,0,0,0,0,9,216,255,255,255,255,255,255,255,255,255,255,255,255,255,255,85,
  0,0,0,0,0,0,0,0,0,0,3,210,255,255,255,255,255,255,87,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,227,255,255,255,146,83,255,255,253,13,136,255,255,255,21,200,255,255,255,128,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,111,255,255,255,255,255,247,40,0,0,0,0,0,0,0,0,0,0,0,0,31,250,255,
  255,255,255,255,255,255,255,153,0,0,0,0,0,0,0,0,0,0,0,0,0,160,255,255,255,255,112,0,0,0,0,0,
  0,0,0,0,0,0,0,0,232,255,255,255,255,58,195,255,255,255,255,98,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,95,255,255,255,221,3,0,0,0,0,0,0,0,36,255,255,255,255,255,108,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,248,255,255,255,255,24,0,0,0,0,0,0,0,139,255,255,255,255,205,21,0,0,0,0,109,254,255,255,
  255,232,27,0,0,0,0,0,0,0,0,0,0,0,0,0,26,207,255,255,255,255,255,255,255,255,255,255,255,251,98,0,
  0,0,0,0,0,0,0,0,0,0,102,255,255,255,255,255,255,255,224,8,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,196,255,255,255,171,130,255,255,215,0,80,255,255,255,75,219,255,255,255,99,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,29,243,255,255,255,255,255,120,0,0,0,0,0,0,0,0,0,0,0,0,0,0,154,255,
  255,255,255,255,255,255,250,30,0,0,0,0,0,0,0,0,0,0,0,0,0,160,255,255,255,255,112,0,0,0,0,0,
  0,0,0,0,0,0,0,0,173,255,255,255,255,114,245,255,255,255,255,39,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,5,227,255,255,255,87,0,0,0,0,0,0,0,36,255,255,255,255,255,108,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,248,255,255,255,255,24,0,0,0,0,0,0,87,255,255,255,255,194,14,0,0,0,0,0,0,94,252,255,
  255,255,199,6,0,0,0,0,0,0,0,0,0,0,0,0,0,7,107,220,255,255,255,255,255,255,255,246,165,41,0,0,
  0,0,0,0,0,0,0,0,0,14,233,255,255,255,255,255,255,255,255,121,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,166,255,255,255,195,176,255,255,163,0,25,255,255,255,129,238,255,255,255,70,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,179,255,255,255,255,255,205,4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,31,250,
  255,255,255,255,255,255,153,0,0,0,0,0,0,0,0,0,0,0,0,0,0,160,255,255,255,255,112,0,0,0,0,0,
  0,0,0,0,0,0,0,0,113,255,255,255,255,210,255,255,255,255,234,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,115,255,255,255,204,0,0,0,0,0,0,0,36,255,255,255,255,255,108,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,248,255,255,255,255,24,0,0,0,0,0,44,244,255,255,255,182,9,0,0,0,0,0,0,0,0,80,248,
  255,255,255,153,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,31,85,107,123,115,97,60,6,0,0,0,0,
  0,0,0,0,0,0,0,0,0,136,255,255,255,255,255,255,255,255,255,242,23,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,135,255,255,255,220,223,255,255,110,0,0,225,255,255,186,254,255,255,255,41,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,86,255,255,255,255,255,250,47,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,154,
  255,255,255,255,255,250,30,0,0,0,0,0,0,0,0,0,0,0,0,0,0,160,255,255,255,255,112,0,0,0,0,0,
  0,0,0,0,0,0,0,0,53,255,255,255,255,255,255,255,255,255,175,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,13,240,255,255,255,66,0,0,0,0,0,0,36,255,255,255,255,255,108,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,248,255,255,255,255,24,0,0,0,0,0,92,128,128,128,116,5,0,0,0,0,0,0,0,0,0,0,62,
  128,128,128,127,24,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,33,248,255,255,255,255,206,255,255,255,255,255,154,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,104,255,255,255,249,255,255,255,58,0,0,169,255,255,248,255,255,255,255,12,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,16,231,255,255,255,255,255,130,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,37,
  255,255,255,255,255,165,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,160,255,255,255,255,112,0,0,0,0,0,
  0,0,0,0,0,0,0,0,4,245,255,255,255,255,255,255,255,255,116,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,136,255,255,255,184,0,0,0,0,0,0,36,255,255,255,255,255,108,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,248,255,255,255,255,24,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,124,0,0,
  0,0,0,0,0,0,0,0,171,255,255,255,255,249,36,166,255,255,255,255,252,45,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,73,255,255,255,255,255,255,252,9,0,0,114,255,255,255,255,255,255,239,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,154,255,255,255,255,255,213,6,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,16,
  255,255,255,255,255,144,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,160,255,255,255,255,112,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,190,255,255,255,255,255,255,255,255,56,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,25,248,255,255,255,46,0,0,0,0,0,36,255,255,255,255,255,108,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,248,255,255,255,255,24,0,0,0,0,0,0,0,0,0,0,0,14,57,94,112,124,116,102,74,24,0,0,
  0,0,0,0,0,0,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,124,0,0,
  0,0,0,0,0,0,0,60,255,255,255,255,255,141,0,30,247,255,255,255,255,186,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,42,255,255,255,255,255,255,210,0,0,0,58,255,255,255,255,255,255,210,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,62,254,255,255,255,255,253,55,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,16,
  255,255,255,255,255,144,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,160,255,255,255,255,112,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,130,255,255,255,255,255,255,255,246,6,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,156,255,255,255,164,0,0,0,0,0,36,255,255,255,255,255,108,0,0,7,77,114,112,82,16,0,0,
  0,0,0,0,248,255,255,255,255,24,0,0,0,0,0,0,0,0,27,123,201,252,255,255,255,255,255,255,255,255,211,105,
  3,0,0,0,0,0,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,124,0,0,
  0,0,0,0,0,0,1,203,255,255,255,255,236,16,0,0,133,255,255,255,255,255,75,0,0,0,0,0,0,0,0,0,
  0,0,0,0,11,255,255,255,255,255,255,158,0,0,0,8,250,255,255,255,255,255,181,0,0,0,0,0,0,0,0,0,
  0,0,0,0,7,215,255,255,255,255,255,140,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,16,
  255,255,255,255,255,144,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,160,255,255,255,255,112,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,70,255,255,255,255,255,255,255,193,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,39,254,255,255,251,30,0,0,0,0,36,255,255,255,255,255,108,0,91,231,255,255,255,255,249,154,15,
  0,0,0,0,248,255,255,255,255,24,0,0,0,0,0,0,0,21,252,255,255,255,255,255,255,255,255,255,255,255,255,255,
  194,15,0,0,0,0,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,124,0,0,
  0,0,0,0,0,0,94,255,255,255,255,255,109,0,0,0,12,231,255,255,255,255,215,4,0,0,0,0,0,0,0,0,
  0,0,0,0,0,236,255,255,255,255,255,106,0,0,0,0,203,255,255,255,255,255,152,0,0,0,0,0,0,0,0,0,
  0,0,0,0,129,255,255,255,255,255,219,9,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,16,
  255,255,255,255,255,144,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,160,255,255,255,255,112,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,176,255,255,255,144,0,0,0,0,36,255,255,255,255,255,108,115,255,255,255,255,255,255,255,255,218,
  22,0,0,0,248,255,255,255,255,24,0,0,0,0,0,0,0,24,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  255,170,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,10,228,255,255,255,255,216,4,0,0,0,0,99,255,255,255,255,255,109,0,0,0,0,0,0,0,0,
  0,0,0,0,0,205,255,255,255,255,255,54,0,0,0,0,147,255,255,255,255,255,123,0,0,0,0,0,0,0,0,0,
  0,0,0,41,249,255,255,255,255,254,63,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,16,
  255,255,255,255,255,144,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,160,255,255,255,255,112,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,240,255,255,255,255,160,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,58,255,255,255,244,17,0,0,0,36,255,255,255,255,255,168,252,255,255,255,255,255,255,255,255,255,
  199,1,0,0,248,255,255,255,255,24,0,0,0,0,0,0,0,24,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  255,255,46,0,0,0,0,0,0,0,0,0,21,79,103,121,115,94,49,4,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,128,255,255,255,255,255,76,0,0,0,0,0,2,208,255,255,255,255,236,16,0,0,0,0,0,0,0,
  0,0,0,0,0,174,255,255,255,255,250,7,0,0,0,0,92,255,255,255,255,255,94,0,0,0,0,0,0,0,0,0,
  0,0,1,196,255,255,255,255,255,151,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,16,
  255,255,255,255,255,144,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,160,255,255,255,255,112,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,240,255,255,255,255,160,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,196,255,255,255,124,0,0,0,36,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  255,95,0,0,248,255,255,255,255,24,0,0,0,0,0,0,0,24,255,236,175,119,78,45,29,19,30,58,137,251,255,255,
  255,255,142,0,0,0,0,0,0,2,88,204,254,255,255,255,255,255,255,237,158,48,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,27,245,255,255,255,255,188,0,0,0,0,0,0,0,66,255,255,255,255,255,142,0,0,0,0,0,0,0,
  0,0,0,0,0,143,255,255,255,255,206,0,0,0,0,0,36,255,255,255,255,255,66,0,0,0,0,0,0,0,0,0,
  0,0,104,255,255,255,255,255,226,13,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,16,
  255,255,255,255,255,144,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,160,255,255,255,255,112,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,240,255,255,255,255,160,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,78,255,255,255,233,8,0,0,36,255,255,255,255,255,255,255,171,51,25,80,223,255,255,255,255,
  255,206,0,0,248,255,255,255,255,24,0,0,0,0,0,0,0,9,62,3,0,0,0,0,0,0,0,0,0,141,255,255,
  255,255,197,0,0,0,0,0,26,200,255,255,255,255,255,255,255,255,255,255,255,255,50,0,0,0,0,0,0,0,0,0,
  0,0,0,0,162,255,255,255,255,253,46,0,0,0,0,0,0,0,0,177,255,255,255,255,249,36,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,25,240,255,255,255,255,255,73,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,16,
  255,255,255,255,255,144,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,160,255,255,255,255,112,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,240,255,255,255,255,160,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,1,214,255,255,255,104,0,0,36,255,255,255,255,255,255,173,0,0,0,0,30,239,255,255,255,
  255,255,37,0,248,255,255,255,255,24,0,0,0,0,0,0,0,0,0,0,0,32,77,114,128,140,144,144,144,193,255,255,
  255,255,243,0,0,0,0,32,228,255,255,255,255,255,255,255,255,255,255,255,255,255,56,0,0,0,0,0,0,0,0,0,
  0,0,0,52,254,255,255,255,255,156,0,0,0,0,0,0,0,0,0,38,250,255,255,255,255,175,0,0,0,0,0,0,
  0,0,7,65,97,118,115,96,59,5,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,166,255,255,255,255,255,235,144,144,144,144,144,144,144,144,144,144,144,144,144,15,0,0,0,0,0,0,0,0,0,16,
  255,255,255,255,255,144,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,160,255,255,255,255,112,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,240,255,255,255,255,160,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,98,255,255,255,219,2,0,36,255,255,255,255,255,253,32,0,0,0,0,0,128,255,255,255,
  255,255,95,0,248,255,255,255,255,24,0,0,0,0,0,0,0,0,6,114,212,255,255,255,255,255,255,255,255,255,255,255,
  255,255,255,6,0,0,7,204,255,255,255,255,255,255,255,255,255,255,255,255,255,255,56,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  35,164,244,255,255,255,255,255,255,244,159,36,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,208,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,28,0,0,0,0,0,0,0,0,0,16,
  255,255,255,255,255,144,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,160,255,255,255,255,112,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,240,255,255,255,255,160,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,6,126,128,128,128,27,0,36,255,255,255,255,255,198,0,0,0,0,0,0,41,255,255,255,
  255,255,140,0,248,255,255,255,255,255,255,255,255,180,0,0,0,32,216,255,255,255,255,255,255,255,255,255,255,255,255,255,
  255,255,255,20,0,0,114,255,255,255,255,255,255,207,96,38,21,39,83,159,248,255,56,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,64,153,204,235,248,255,255,255,255,160,0,0,0,0,0,0,0,0,0,0,0,0,0,0,110,
  250,255,255,255,255,255,255,255,255,255,255,250,104,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,208,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,28,0,0,0,0,0,0,0,0,0,16,
  255,255,255,255,255,144,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,160,255,255,255,255,112,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,240,255,255,255,255,160,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,36,255,255,255,255,255,146,0,0,0,0,0,0,1,245,255,255,
  255,255,169,0,248,255,255,255,255,255,255,255,255,180,0,0,12,223,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  255,255,255,27,0,5,227,255,255,255,255,255,154,2,0,0,0,0,0,0,25,172,56,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,5,171,255,255,255,255,255,255,255,255,255,160,0,0,0,0,0,0,0,0,0,0,0,0,0,130,255,
  255,255,255,255,255,255,255,255,255,255,255,255,255,120,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,208,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,28,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,160,255,255,255,255,112,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,240,255,255,255,255,160,0,0,0,0,0,0,0,30,92,118,105,64,2,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,36,255,255,255,255,255,118,0,0,0,0,0,0,0,219,255,255,
  255,255,182,0,248,255,255,255,255,255,255,255,255,180,0,0,129,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  255,255,255,28,0,62,255,255,255,255,255,205,4,0,0,0,0,0,0,0,0,0,5,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,131,255,255,255,255,255,255,255,255,255,255,160,0,0,0,0,0,0,0,0,0,0,0,0,75,254,255,
  255,255,255,255,255,255,255,255,255,255,255,255,255,252,62,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,208,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,28,0,184,255,255,255,255,212,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,160,255,255,255,255,112,0,0,0,0,0,
  0,0,53,99,120,96,39,0,0,0,240,255,255,255,255,160,0,0,0,0,0,30,181,254,255,255,255,255,222,74,0,184,
  255,255,255,255,220,0,0,0,0,0,0,0,0,0,0,36,255,255,255,255,255,110,0,0,0,0,0,0,0,211,255,255,
  255,255,192,0,248,255,255,255,255,255,255,255,255,180,0,0,219,255,255,255,255,255,246,139,63,25,7,0,0,115,255,255,
  255,255,255,28,0,125,255,255,255,255,255,88,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,7,237,255,255,255,255,255,255,255,255,255,255,160,0,0,0,0,0,0,0,0,0,0,0,4,226,255,255,
  255,255,251,159,63,29,24,59,144,250,255,255,255,255,197,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,184,255,255,255,255,212,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,160,255,255,255,255,112,0,0,0,0,0,
  76,220,255,255,255,255,254,174,17,0,240,255,255,255,255,160,0,0,0,0,48,239,255,255,255,255,255,255,255,253,96,184,
  255,255,255,255,220,0,0,0,0,0,0,0,0,0,0,36,255,255,255,255,255,118,0,0,0,0,0,0,0,219,255,255,
  255,255,182,0,0,0,0,0,0,0,0,0,0,0,0,20,255,255,255,255,255,255,70,0,0,0,0,0,0,129,255,255,
  255,255,255,28,0,167,255,255,255,255,255,18,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,57,255,255,255,255,255,247,169,145,144,144,144,90,0,0,0,0,0,0,0,0,0,0,0,91,255,255,255,
  255,255,92,0,0,0,0,0,0,90,255,255,255,255,255,52,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,84,255,255,255,255,255,64,0,0,0,0,0,0,0,0,184,255,255,255,255,212,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,60,255,255,255,255,255,255,255,255,255,112,0,0,0,0,119,
  255,255,255,255,255,255,255,255,216,20,240,255,255,255,255,160,0,0,0,22,232,255,255,255,255,255,255,255,255,255,244,216,
  255,255,255,255,220,0,0,0,0,0,0,0,0,0,0,36,255,255,255,255,255,146,0,0,0,0,0,0,1,245,255,255,
  255,255,168,0,0,0,0,0,0,0,0,0,0,0,0,42,255,255,255,255,255,218,0,0,0,0,0,0,0,168,255,255,
  255,255,255,28,0,186,255,255,255,255,236,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,99,255,255,255,255,255,89,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,178,255,255,255,
  255,197,0,0,0,0,0,0,0,0,228,255,255,255,255,120,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,84,255,255,255,255,255,64,0,0,0,0,0,0,0,0,184,255,255,255,255,212,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,60,255,255,255,255,255,255,255,255,255,112,0,0,0,78,255,
  255,255,255,255,255,255,255,255,255,179,240,255,255,255,255,160,0,0,0,156,255,255,255,255,255,255,255,255,255,255,255,255,
  255,255,255,255,220,0,0,0,0,0,0,0,0,0,0,36,255,255,255,255,255,198,0,0,0,0,0,0,41,255,255,255,
  255,255,139,0,0,0,0,0,0,0,0,0,0,0,0,42,255,255,255,255,255,196,0,0,0,0,0,0,5,235,255,255,
  255,255,255,28,0,199,255,255,255,255,223,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,116,255,255,255,255,255,34,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,237,255,255,255,
  255,205,144,144,144,144,144,144,144,144,232,255,255,255,255,176,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,84,255,255,255,255,255,64,0,0,0,0,0,0,0,0,184,255,255,255,255,212,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,60,255,255,255,255,255,255,255,255,255,112,0,0,6,221,255,
  255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,160,0,0,27,253,255,255,255,255,255,178,53,25,78,220,255,255,
  255,255,255,255,220,0,0,0,0,0,0,0,0,0,0,36,255,255,255,255,255,253,32,0,0,0,0,0,128,255,255,255,
  255,255,95,0,0,0,0,0,0,0,0,0,0,0,0,20,255,255,255,255,255,235,4,0,0,0,0,0,108,255,255,255,
  255,255,255,28,0,187,255,255,255,255,235,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,127,255,255,255,255,255,24,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,27,255,255,255,255,
  255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,200,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,84,255,255,255,255,255,64,0,0,0,0,0,0,0,0,184,255,255,255,255,212,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,60,255,255,255,255,255,255,255,255,255,112,0,0,84,255,255,
  255,255,255,255,145,41,28,98,238,255,255,255,255,255,255,160,0,0,116,255,255,255,255,255,182,1,0,0,0,26,234,255,
  255,255,255,255,220,0,0,0,0,0,0,0,0,0,0,36,255,255,255,255,255,255,173,0,0,0,0,30,239,255,255,255,
  255,255,36,0,0,0,0,0,0,0,0,0,0,0,0,0,220,255,255,255,255,255,134,1,0,0,0,81,248,255,255,255,
  255,255,255,28,0,168,255,255,255,255,254,16,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,128,255,255,255,255,255,24,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,45,255,255,255,255,
  255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,217,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,84,255,255,255,255,255,64,0,0,0,0,0,0,0,0,184,255,255,255,255,212,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,170,255,255,
  255,255,255,137,0,0,0,0,55,251,255,255,255,255,255,160,0,0,183,255,255,255,255,254,36,0,0,0,0,0,110,255,
  255,255,255,255,220,0,0,0,0,0,0,0,0,0,0,36,255,255,255,255,255,255,255,170,50,24,79,222,255,255,255,255,
  255,206,0,0,0,0,0,0,0,0,0,0,0,0,0,0,131,255,255,255,255,255,255,205,145,141,199,255,255,255,255,255,
  255,255,255,28,0,127,255,255,255,255,255,84,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,176,
  255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,160,0,0,0,0,0,0,0,0,0,0,59,255,255,255,255,
  255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,224,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,84,255,255,255,255,255,64,0,0,0,0,0,0,0,0,184,255,255,255,255,212,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,100,255,255,255,255,255,48,0,0,0,0,228,255,255,
  255,255,238,12,0,0,0,0,0,162,255,255,255,255,255,160,0,0,231,255,255,255,255,199,0,0,0,0,0,0,20,253,
  255,255,255,255,220,0,0,0,0,0,0,0,0,0,0,36,255,255,255,255,255,252,255,255,255,255,255,255,255,255,255,255,
  255,94,0,0,0,0,0,0,0,0,0,0,0,0,0,0,18,230,255,255,255,255,255,255,255,255,255,255,255,225,255,255,
  255,255,255,28,0,65,255,255,255,255,255,201,3,0,0,0,0,0,0,0,0,0,6,0,0,0,0,0,0,0,0,176,
  255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,160,0,0,0,0,0,0,0,0,0,0,48,255,255,255,255,
  255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,224,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,84,255,255,255,255,255,64,0,0,0,0,0,0,0,0,184,255,255,255,255,212,0,0,1,
  60,101,120,98,35,0,0,0,0,0,0,0,0,0,0,0,0,0,100,255,255,255,255,255,48,0,0,0,17,255,255,255,
  255,255,164,0,0,0,0,0,0,75,255,255,255,255,255,160,0,8,255,255,255,255,255,146,0,0,0,0,0,0,0,220,
  255,255,255,255,220,0,0,0,0,0,0,0,0,0,0,36,255,255,255,255,255,150,249,255,255,255,255,255,255,255,255,255,
  201,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,53,236,255,255,255,255,255,255,255,255,255,158,113,255,255,
  255,255,255,28,0,6,230,255,255,255,255,255,148,1,0,0,0,0,0,0,23,172,56,0,0,0,0,0,0,0,0,176,
  255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,160,0,0,0,0,0,0,0,0,0,0,30,255,255,255,255,
  255,117,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,184,255,255,255,255,212,0,60,211,
  255,255,255,255,255,173,18,0,0,0,0,0,0,0,0,0,0,0,100,255,255,255,255,255,48,0,0,0,46,255,255,255,
  255,255,114,0,0,0,0,0,0,24,255,255,255,255,255,160,0,23,255,255,255,255,255,121,0,0,0,0,0,0,0,194,
  255,255,255,255,220,0,0,0,0,0,0,0,0,0,0,36,255,255,255,255,255,108,111,255,255,255,255,255,255,255,255,223,
  25,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,30,167,252,255,255,255,255,255,224,93,0,112,255,255,
  255,255,255,28,0,0,118,255,255,255,255,255,255,203,94,37,21,37,78,154,246,255,56,0,0,0,0,0,0,0,0,176,
  255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,160,0,0,0,0,0,0,0,0,0,0,4,243,255,255,255,
  255,154,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,184,255,255,255,255,212,60,245,255,
  255,255,255,255,255,255,204,6,0,0,0,0,0,0,0,0,0,0,100,255,255,255,255,255,48,0,0,0,59,255,255,255,
  255,255,86,0,0,0,0,0,0,0,251,255,255,255,255,160,0,32,255,255,255,255,255,115,0,0,0,0,0,0,0,188,
  255,255,255,255,220,0,0,0,0,0,0,0,0,0,0,36,255,255,255,255,255,108,0,93,230,255,255,255,255,252,164,19,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,18,79,111,122,100,57,1,0,0,0,0,0,
  0,0,0,0,0,0,9,208,255,255,255,255,255,255,255,255,255,255,255,255,255,255,56,0,0,0,0,0,0,0,0,99,
  144,144,144,144,200,255,255,255,255,255,152,144,144,144,144,144,90,0,0,0,0,0,0,0,0,0,0,0,186,255,255,255,
  255,234,12,0,0,0,0,0,0,0,0,0,0,0,29,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,184,255,255,255,255,213,207,255,255,
  255,255,255,255,255,255,255,116,0,0,0,0,0,0,0,0,0,0,100,255,255,255,255,255,48,0,0,0,69,255,255,255,
  255,255,78,0,0,0,0,0,0,0,243,255,255,255,255,160,0,21,255,255,255,255,255,130,0,0,0,0,0,0,0,203,
  255,255,255,255,220,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,6,73,109,116,89,22,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,36,232,255,255,255,255,255,255,255,255,255,255,255,255,255,56,0,0,0,0,0,0,0,0,0,
  0,0,0,0,128,255,255,255,255,255,20,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,107,255,255,255,
  255,255,173,8,0,0,0,0,0,0,0,0,36,148,245,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,184,255,255,255,255,253,255,255,255,
  255,255,255,255,255,255,255,219,0,0,0,0,0,0,0,0,0,0,100,255,255,255,255,255,48,0,0,0,59,255,255,255,
  255,255,86,0,0,0,0,0,0,0,251,255,255,255,255,160,0,6,254,255,255,255,255,168,0,0,0,0,0,0,1,241,
  255,255,255,255,220,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,176,255,255,255,255,228,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,30,206,255,255,255,255,255,255,255,255,255,255,255,255,51,0,0,0,0,0,0,0,0,0,
  0,0,0,0,128,255,255,255,255,255,20,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,9,234,255,255,
  255,255,255,220,116,55,26,21,38,68,124,197,255,255,252,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,204,255,255,255,255,255,255,255,255,255,255,64,0,0,0,0,0,0,0,0,184,255,255,255,255,255,255,145,36,
  37,122,253,255,255,255,255,255,30,0,0,0,0,0,0,0,0,0,100,255,255,255,255,255,48,0,0,0,46,255,255,255,
  255,255,114,0,0,0,0,0,0,24,255,255,255,255,255,160,0,0,221,255,255,255,255,234,3,0,0,0,0,0,58,255,
  255,255,255,255,220,0,72,255,255,255,255,255,255,255,255,255,255,244,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,176,255,255,255,255,228,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,3,94,208,255,255,255,255,255,255,255,243,168,54,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,128,255,255,255,255,255,20,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,92,255,255,
  255,255,255,255,255,255,255,255,255,255,255,255,255,255,252,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,204,255,255,255,255,255,255,255,255,255,255,64,0,0,0,0,0,0,0,0,184,255,255,255,255,255,164,0,0,
  0,0,148,255,255,255,255,255,73,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,17,255,255,255,
  255,255,165,0,0,0,0,0,0,75,255,255,255,255,255,160,0,0,169,255,255,255,255,255,98,0,0,0,0,0,176,255,
  255,255,255,255,220,0,72,255,255,255,255,255,255,255,255,255,255,244,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,176,255,255,255,255,228,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,24,81,105,122,117,98,56,8,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,128,255,255,255,255,255,20,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,140,255,
  255,255,255,255,255,255,255,255,255,255,255,255,255,255,252,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,204,255,255,255,255,255,255,255,255,255,255,64,0,0,0,0,0,0,0,0,184,255,255,255,255,255,47,0,0,
  0,0,74,255,255,255,255,255,91,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,228,255,255,
  255,255,238,12,0,0,0,0,0,162,255,255,255,255,255,160,0,0,89,255,255,255,255,255,241,54,0,0,0,119,255,255,
  255,255,255,255,220,0,72,255,255,255,255,255,255,255,255,255,255,244,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,176,255,255,255,255,228,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,128,255,255,255,255,255,20,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,105,
  248,255,255,255,255,255,255,255,255,255,255,255,255,255,243,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,204,255,255,255,255,255,255,255,255,255,255,64,0,0,0,0,0,0,0,0,184,255,255,255,255,242,0,0,0,
  0,0,44,255,255,255,255,255,102,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,168,255,255,
  255,255,255,137,0,0,0,0,54,251,255,255,255,255,255,160,0,0,9,236,255,255,255,255,255,251,180,152,206,255,255,255,
  255,255,255,255,220,0,72,255,255,255,255,255,255,255,255,255,255,244,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,176,255,255,255,255,228,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,5,
  83,117,83,6,0,0,0,46,107,118,84,12,0,0,0,112,255,255,255,228,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,128,255,255,255,255,255,20,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  27,140,232,255,255,255,255,255,255,255,255,242,181,100,14,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,114,144,144,144,144,180,255,255,255,255,255,64,0,0,0,0,0,0,0,0,184,255,255,255,255,218,0,0,0,
  0,0,36,255,255,255,255,255,104,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,84,255,255,
  255,255,255,255,145,40,27,97,238,255,255,255,255,255,255,160,0,0,0,102,255,255,255,255,255,255,255,255,255,255,255,254,
  255,255,255,255,220,0,40,144,144,144,144,144,214,255,255,255,255,244,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,176,255,255,255,255,228,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,112,255,255,255,160,36,220,
  255,255,255,222,40,2,151,255,255,255,255,234,62,0,0,112,255,255,255,228,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,128,255,255,255,255,255,20,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,38,86,106,122,120,107,81,44,4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,84,255,255,255,255,255,64,0,0,0,0,0,0,0,0,184,255,255,255,255,212,0,0,0,
  0,0,36,255,255,255,255,255,104,0,0,0,12,255,255,255,255,255,255,255,255,255,255,255,48,0,0,0,0,6,221,255,
  255,255,255,255,255,255,255,255,255,255,253,255,255,255,255,160,0,0,0,1,170,255,255,255,255,255,255,255,255,255,212,191,
  255,255,255,255,220,0,0,0,0,0,0,0,160,255,255,255,255,244,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,176,255,255,255,255,228,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,112,255,255,255,165,218,255,
  255,255,255,255,216,116,255,255,255,255,255,255,234,10,0,112,255,255,255,228,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,128,255,255,255,255,255,20,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,84,255,255,255,255,255,64,0,0,0,0,0,0,0,0,184,255,255,255,255,212,0,0,0,
  0,0,36,255,255,255,255,255,104,0,0,0,12,255,255,255,255,255,255,255,255,255,255,255,48,0,0,0,0,0,80,255,
  255,255,255,255,255,255,255,255,255,158,240,255,255,255,255,160,0,0,0,0,5,156,255,255,255,255,255,255,255,220,39,184,
  255,255,255,255,217,0,0,0,0,0,0,0,160,255,255,255,255,244,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,176,255,255,255,255,228,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,112,255,255,255,242,255,255,
  255,255,255,255,255,252,255,255,255,255,255,255,255,91,0,112,255,255,255,228,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,128,255,255,255,255,255,20,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,59,101,120,98,35,
  0,0,0,0,0,0,0,0,0,0,0,0,8,69,100,120,110,87,33,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,84,255,255,255,255,255,64,0,0,0,0,0,0,0,0,184,255,255,255,255,212,0,0,0,
  0,0,36,255,255,255,255,255,104,0,0,0,12,255,255,255,255,255,255,255,255,255,255,255,48,0,0,0,0,0,0,125,
  255,255,255,255,255,255,255,255,212,18,240,255,255,255,255,160,0,0,0,0,0,0,61,160,221,247,237,205,120,15,0,191,
  255,255,255,255,203,0,0,0,0,0,0,0,160,255,255,255,255,244,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,176,255,255,255,255,228,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,112,255,255,255,255,255,255,
  255,255,255,255,255,255,255,255,255,255,255,255,255,149,0,112,255,255,255,228,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,128,255,255,255,255,255,20,0,0,0,0,0,0,0,184,255,255,255,255,212,0,57,209,255,255,255,255,255,
  173,18,0,0,0,0,0,0,0,0,34,166,246,255,255,255,255,255,255,213,92,1,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,84,255,255,255,255,255,64,0,0,0,0,0,0,0,0,184,255,255,255,255,212,0,0,0,
  0,0,36,255,255,255,255,255,104,0,0,0,12,255,255,255,255,255,255,255,255,255,255,255,48,0,0,0,0,0,0,0,
  85,227,255,255,255,255,253,173,17,0,240,255,255,255,255,160,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,224,
  255,255,255,255,187,0,0,0,0,0,0,0,160,255,255,255,255,244,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,176,255,255,255,255,228,0,0,0,0,0,16,207,255,255,255,255,255,200,16,0,112,255,255,255,255,196,37,
  76,247,255,255,255,255,181,35,84,251,255,255,255,192,0,112,255,255,255,228,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,128,255,255,255,255,255,20,0,0,0,0,0,0,0,184,255,255,255,255,212,57,244,255,255,255,255,255,255,
  255,204,6,0,0,0,0,0,0,101,249,255,255,255,255,255,255,255,255,255,255,193,17,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,84,255,255,255,255,255,64,0,0,0,0,0,0,0,0,184,255,255,255,255,212,0,0,0,
  0,0,36,255,255,255,255,255,104,0,0,0,6,144,144,144,144,144,187,255,255,255,255,255,48,0,0,0,0,0,0,0,
  0,2,62,104,120,92,35,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,58,255,
  255,255,255,255,145,0,0,0,0,0,0,0,160,255,255,255,255,244,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,176,255,255,255,255,228,0,0,0,0,10,197,255,255,255,255,255,194,13,0,0,112,255,255,255,255,80,0,
  0,175,255,255,255,255,56,0,0,193,255,255,255,216,0,112,255,255,255,228,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,128,255,255,255,255,255,20,0,0,0,0,0,0,0,184,255,255,255,255,212,204,255,255,255,255,255,255,255,
  255,255,116,0,0,0,0,0,115,255,255,255,255,255,255,255,255,255,255,255,255,255,213,16,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,84,255,255,255,255,255,64,0,0,0,0,0,0,0,0,184,255,255,255,255,212,0,0,0,
  0,0,36,255,255,255,255,255,104,0,0,0,0,0,0,0,0,0,100,255,255,255,255,255,48,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,203,126,43,0,0,0,0,0,0,46,222,255,
  255,255,255,255,88,0,0,0,0,0,0,0,160,255,255,255,255,244,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,176,255,255,255,255,228,0,0,0,6,185,255,255,255,255,255,189,10,0,0,0,112,255,255,255,255,47,0,
  0,138,255,255,255,255,21,0,0,161,255,255,255,237,0,112,255,255,255,228,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,128,255,255,255,255,255,20,0,0,0,0,0,0,0,184,255,255,255,255,252,255,255,255,255,255,255,255,255,
  255,255,219,0,0,0,0,60,252,255,255,255,255,255,255,255,255,255,255,255,255,255,255,171,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,84,255,255,255,255,255,64,0,0,0,0,0,0,0,0,184,255,255,255,255,212,0,0,0,
  0,0,36,255,255,255,255,255,104,0,0,0,0,0,0,0,0,0,100,255,255,255,255,255,48,0,0,0,0,0,0,0,
  0,0,0,5,72,108,115,87,21,0,0,0,0,0,0,0,0,0,0,0,232,255,255,232,187,160,147,156,200,254,255,255,
  255,255,255,239,11,0,0,0,0,0,0,0,160,255,255,255,255,244,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,176,255,255,255,255,228,0,0,3,173,255,255,255,255,255,184,9,0,0,0,0,112,255,255,255,255,37,0,
  0,126,255,255,255,255,10,0,0,150,255,255,255,245,0,112,255,255,255,228,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,128,255,255,255,255,255,20,0,0,0,0,0,0,0,184,255,255,255,255,255,255,148,37,38,124,253,255,255,
  255,255,255,30,0,0,0,211,255,255,255,255,255,201,72,25,42,132,251,255,255,255,255,255,72,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,84,255,255,255,255,255,64,0,0,0,0,0,0,0,0,184,255,255,255,255,212,0,0,0,
  0,0,36,255,255,255,255,255,104,0,0,0,0,0,0,0,0,0,100,255,255,255,255,255,48,0,36,255,255,255,255,255,
  108,0,90,228,255,255,255,255,251,163,17,0,0,0,0,0,0,0,0,0,232,255,255,255,255,255,255,255,255,255,255,255,
  255,255,255,126,0,0,0,0,0,0,0,0,160,255,255,255,255,244,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,176,255,255,255,255,228,0,1,160,255,255,255,255,255,178,7,0,0,0,0,0,112,255,255,255,255,36,0,
  0,124,255,255,255,255,8,0,0,148,255,255,255,251,0,112,255,255,255,228,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,128,255,255,255,255,255,20,0,0,0,0,0,0,0,184,255,255,255,255,255,167,0,0,0,0,150,255,255,
  255,255,255,73,0,0,69,255,255,255,255,255,199,7,0,0,0,0,88,255,255,255,255,255,187,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,84,255,255,255,255,255,64,0,0,0,0,0,0,0,0,184,255,255,255,255,212,0,0,0,
  0,0,36,255,255,255,255,255,104,0,0,0,0,0,0,0,0,0,100,255,255,255,255,255,48,0,36,255,255,255,255,255,
  108,109,255,255,255,255,255,255,255,255,221,23,0,0,0,0,0,0,0,0,232,255,255,255,255,255,255,255,255,255,255,255,
  255,255,185,3,0,0,0,0,0,0,0,0,160,255,255,255,255,244,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,176,255,255,255,255,228,0,145,255,255,255,255,255,172,5,0,0,0,0,0,0,112,255,255,255,255,36,0,
  0,124,255,255,255,255,8,0,0,148,255,255,255,255,0,112,255,255,255,228,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,128,255,255,255,255,255,20,0,0,0,0,0,0,0,184,255,255,255,255,255,49,0,0,0,0,75,255,255,
  255,255,255,91,0,0,154,255,255,255,255,255,50,0,0,0,0,0,0,187,255,255,255,255,254,18,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,84,255,255,255,255,255,64,0,0,0,0,0,0,0,0,184,255,255,255,255,212,0,0,0,
  0,0,36,255,255,255,255,255,104,0,0,0,0,0,0,0,0,0,100,255,255,255,255,255,48,0,36,255,255,255,255,255,
  149,249,255,255,255,255,255,255,255,255,255,198,1,0,0,0,0,0,0,0,229,255,255,255,255,255,255,255,255,255,255,255,
  247,134,4,0,0,0,0,0,0,0,0,0,160,255,255,255,255,244,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,176,255,255,255,255,228,130,255,255,255,255,255,166,4,0,0,0,0,0,0,0,112,255,255,255,255,36,0,
  0,124,255,255,255,255,8,0,0,148,255,255,255,255,0,112,255,255,255,228,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,184,255,255,255,255,243,0,0,0,0,0,45,255,255,
  255,255,255,102,0,0,215,255,255,255,255,210,0,0,0,0,0,0,0,91,255,255,255,255,255,77,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,84,255,255,255,255,255,64,0,0,0,0,0,0,0,0,184,255,255,255,255,212,0,0,0,
  0,0,36,255,255,255,255,255,104,0,0,0,0,0,0,0,0,0,100,255,255,255,255,255,48,0,36,255,255,255,255,255,
  252,255,255,255,255,255,255,255,255,255,255,255,93,0,0,0,0,0,0,0,13,78,135,182,216,240,251,249,235,214,166,107,
  18,0,0,0,0,0,0,0,0,0,0,0,160,255,255,255,255,244,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,176,255,255,255,255,253,255,255,255,255,255,164,2,0,0,0,0,0,0,0,0,112,255,255,255,255,36,0,
  0,124,255,255,255,255,8,0,0,148,255,255,255,255,0,112,255,255,255,228,0,0,0,0,0,0,0,0,0,2,61,102,
  119,91,34,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,184,255,255,255,255,218,0,0,0,0,0,36,255,255,
  255,255,255,104,0,2,254,255,255,255,255,154,0,0,0,0,0,0,0,35,255,255,255,255,255,119,0,0,0,0,0,0,
  0,40,144,144,144,144,144,144,180,255,255,255,255,255,172,144,144,144,144,144,144,27,0,184,255,255,255,255,212,0,0,0,
  0,0,36,255,255,255,255,255,104,0,0,0,0,0,0,0,0,0,100,255,255,255,255,255,48,0,36,255,255,255,255,255,
  255,255,172,51,25,80,224,255,255,255,255,255,206,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,160,255,255,255,255,244,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,176,255,255,255,255,255,255,255,255,255,255,179,0,0,0,0,0,0,0,0,0,112,255,255,255,255,36,0,
  0,124,255,255,255,255,8,0,0,148,255,255,255,255,0,112,255,255,255,228,0,0,0,0,0,0,0,0,82,226,255,255,
  255,255,253,169,16,0,240,255,255,255,255,160,0,0,0,0,0,0,184,255,255,255,255,212,0,0,0,0,0,36,255,255,
  255,255,255,104,0,19,255,255,255,255,255,124,0,0,0,0,0,0,0,5,255,255,255,255,255,138,0,0,0,0,0,0,
  0,72,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,48,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,100,255,255,255,255,255,48,0,36,255,255,255,255,255,
  255,175,0,0,0,0,32,240,255,255,255,255,255,36,0,0,0,0,0,0,0,0,0,0,1,58,95,121,112,75,14,0,
  0,0,0,0,0,0,0,0,0,0,0,0,160,255,255,255,255,244,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,176,255,255,255,255,255,255,255,255,255,255,255,90,0,0,0,0,0,0,0,0,112,255,255,255,255,36,0,
  0,124,255,255,255,255,8,0,0,148,255,255,255,255,0,112,255,255,255,228,0,0,0,0,0,0,0,122,255,255,255,255,
  255,255,255,255,211,17,240,255,255,255,255,160,0,0,0,0,0,0,184,255,255,255,255,212,0,0,0,0,0,36,255,255,
  255,255,255,104,0,32,255,255,255,255,255,115,0,0,0,0,0,0,0,0,251,255,255,255,255,151,0,0,0,0,0,0,
  0,72,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,48,0,0,0,0,0,0,36,83,109,122,
  119,104,72,31,0,0,0,0,0,0,0,0,0,0,0,0,0,0,100,255,255,255,255,255,48,0,36,255,255,255,255,255,
  253,33,0,0,0,0,0,129,255,255,255,255,255,95,0,116,255,255,255,255,255,32,0,103,222,255,255,255,255,255,249,155,
  0,0,0,0,0,0,0,0,0,0,0,0,160,255,255,255,255,244,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,176,255,255,255,255,255,255,255,255,255,255,255,235,20,0,0,0,0,0,0,0,112,255,255,255,255,36,0,
  0,124,255,255,255,255,8,0,0,148,255,255,255,255,0,112,255,255,255,228,0,0,0,0,0,0,78,255,255,255,255,255,
  255,255,255,255,255,157,240,255,255,255,255,160,0,0,0,0,0,0,184,255,255,255,255,212,0,0,0,0,0,36,255,255,
  255,255,255,104,0,19,255,255,255,255,255,124,0,0,0,0,0,0,0,5,255,255,255,255,255,138,0,0,0,0,0,0,
  0,72,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,48,0,0,0,4,110,216,255,255,255,255,
  255,255,255,255,229,161,71,0,0,0,0,0,0,0,0,0,0,0,100,255,255,255,255,255,48,0,36,255,255,255,255,255,
  199,0,0,0,0,0,0,42,255,255,255,255,255,139,0,116,255,255,255,255,255,33,160,255,255,255,255,255,255,255,255,236,
  0,0,0,0,0,0,0,0,0,0,0,0,160,255,255,255,255,244,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,176,255,255,255,255,255,255,129,238,255,255,255,255,166,0,0,0,0,0,0,0,112,255,255,255,255,36,0,
  0,124,255,255,255,255,8,0,0,148,255,255,255,255,0,112,255,255,255,228,0,0,0,0,0,5,220,255,255,255,255,255,
  255,255,255,255,255,255,253,255,255,255,255,160,0,0,0,0,0,0,184,255,255,255,255,212,0,0,0,0,0,36,255,255,
  255,255,255,104,0,2,254,255,255,255,255,154,0,0,0,0,0,0,0,35,255,255,255,255,255,119,0,0,0,0,0,0,
  0,72,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,48,0,0,22,204,255,255,255,255,255,255,
  255,255,255,255,255,255,224,0,0,0,0,0,0,0,0,0,0,0,100,255,255,255,255,255,48,0,36,255,255,255,255,255,
  147,0,0,0,0,0,0,1,245,255,255,255,255,168,0,116,255,255,255,255,255,138,255,255,255,255,255,255,255,255,255,236,
  0,0,0,0,0,0,0,0,0,0,0,0,160,255,255,255,255,244,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,176,255,255,255,255,253,101,0,106,255,255,255,255,255,76,0,0,0,0,0,0,112,255,255,255,255,36,0,
  0,124,255,255,255,255,8,0,0,148,255,255,255,255,0,112,255,255,255,228,0,0,0,0,0,83,255,255,255,255,255,255,
  146,41,28,98,239,255,255,255,255,255,255,160,0,0,0,0,0,0,184,255,255,255,255,212,0,0,0,0,0,36,255,255,
  255,255,255,104,0,0,214,255,255,255,255,210,0,0,0,0,0,0,0,91,255,255,255,255,255,76,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,196,255,255,255,255,255,255,255,
  255,255,255,255,255,255,224,0,0,0,0,0,0,0,0,0,0,0,100,255,255,255,255,255,48,0,36,255,255,255,255,255,
  119,0,0,0,0,0,0,0,220,255,255,255,255,182,0,116,255,255,255,255,255,252,255,255,255,255,255,255,255,255,255,236,
  0,0,0,0,0,0,0,0,0,0,0,0,154,255,255,255,255,250,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,176,255,255,255,255,228,0,0,2,207,255,255,255,255,227,14,0,0,0,0,0,112,255,255,255,255,36,0,
  0,124,255,255,255,255,8,0,0,148,255,255,255,255,0,112,255,255,255,228,0,0,0,0,0,168,255,255,255,255,255,139,
  0,0,0,0,56,252,255,255,255,255,255,160,0,0,0,0,0,0,184,255,255,255,255,212,0,0,0,0,0,36,255,255,
  255,255,255,104,0,0,154,255,255,255,255,255,49,0,0,0,0,0,0,186,255,255,255,255,254,17,0,0,0,0,0,0,
  0,0,0,0,0,0,56,128,128,128,128,128,18,0,0,0,0,0,0,0,0,0,0,77,255,255,255,255,255,255,255,255,
  255,255,255,255,255,255,224,0,0,0,0,0,0,0,0,0,0,0,100,255,255,255,255,255,48,0,36,255,255,255,255,255,
  110,0,0,0,0,0,0,0,211,255,255,255,255,192,0,116,255,255,255,255,255,255,255,233,130,58,30,24,48,107,205,236,
  0,0,0,0,0,0,0,0,0,0,0,0,143,255,255,255,255,255,19,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,176,255,255,255,255,228,0,0,0,59,254,255,255,255,255,152,0,0,0,0,0,112,255,255,255,255,36,0,
  0,124,255,255,255,255,8,0,0,148,255,255,255,255,0,112,255,255,255,228,0,0,0,0,0,228,255,255,255,255,239,12,
  0,0,0,0,0,164,255,255,255,255,255,160,0,0,0,0,0,0,184,255,255,255,255,212,0,0,0,0,0,36,255,255,
  255,255,255,104,0,0,69,255,255,255,255,255,199,7,0,0,0,0,87,255,255,255,255,255,187,0,0,0,0,0,0,0,
  0,0,0,0,0,0,112,255,255,255,255,255,36,0,0,0,0,0,0,0,0,0,0,150,255,255,255,255,255,168,68,33,
  21,36,70,125,205,255,224,0,0,0,0,0,0,0,0,0,0,0,100,255,255,255,255,255,48,0,36,255,255,255,255,255,
  118,0,0,0,0,0,0,0,219,255,255,255,255,182,0,116,255,255,255,255,255,255,188,18,0,0,0,0,0,0,0,90,
  0,0,0,0,0,0,0,0,0,0,0,0,123,255,255,255,255,255,80,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,176,255,255,255,255,228,0,0,0,0,162,255,255,255,255,254,63,0,0,0,0,112,255,255,255,255,36,0,
  0,124,255,255,255,255,8,0,0,148,255,255,255,255,0,112,255,255,255,228,0,0,0,0,17,255,255,255,255,255,165,0,
  0,0,0,0,0,75,255,255,255,255,255,160,0,0,0,0,0,0,184,255,255,255,255,212,0,0,0,0,0,36,255,255,
  255,255,255,104,0,0,0,211,255,255,255,255,255,200,71,24,41,132,250,255,255,255,255,255,72,0,0,0,0,0,0,0,
  0,0,0,0,0,0,112,255,255,255,255,255,36,0,0,0,0,0,0,0,0,0,0,177,255,255,255,255,189,0,0,0,
  0,0,0,0,0,46,143,0,0,0,0,0,0,0,0,0,0,0,100,255,255,255,255,255,48,0,36,255,255,255,255,255,
  146,0,0,0,0,0,0,1,245,255,255,255,255,169,0,116,255,255,255,255,255,226,14,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,80,255,255,255,255,255,209,17,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,176,255,255,255,255,228,0,0,0,0,24,241,255,255,255,255,218,9,0,0,0,112,255,255,255,255,36,0,
  0,124,255,255,255,255,8,0,0,148,255,255,255,255,0,112,255,255,255,228,0,0,0,0,46,255,255,255,255,255,114,0,
  0,0,0,0,0,24,255,255,255,255,255,160,0,0,0,0,0,0,184,255,255,255,255,212,0,0,0,0,0,36,255,255,
  255,255,255,104,0,0,0,59,252,255,255,255,255,255,255,255,255,255,255,255,255,255,255,171,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,112,255,255,255,255,255,36,0,0,0,0,0,0,0,0,0,0,168,255,255,255,255,179,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,105,255,255,255,255,255,44,0,36,255,255,255,255,255,
  198,0,0,0,0,0,0,41,255,255,255,255,255,140,0,116,255,255,255,255,255,124,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,23,253,255,255,255,255,255,237,166,145,144,144,144,121,0,0,0,0,0,0,
  0,0,0,0,176,255,255,255,255,228,0,0,0,0,0,113,255,255,255,255,255,138,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,112,255,255,255,228,0,0,0,0,59,255,255,255,255,255,86,0,
  0,0,0,0,0,0,251,255,255,255,255,160,0,0,0,0,0,0,184,255,255,255,255,212,0,0,0,0,0,36,255,255,
  255,255,255,104,0,0,0,0,115,255,255,255,255,255,255,255,255,255,255,255,255,255,213,16,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,112,255,255,255,255,255,36,0,0,0,0,0,0,0,0,0,0,118,255,255,255,255,255,169,43,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,127,255,255,255,255,255,31,0,36,255,255,255,255,255,
  253,32,0,0,0,0,0,128,255,255,255,255,255,95,0,116,255,255,255,255,255,66,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,185,255,255,255,255,255,255,255,255,255,255,255,216,0,0,0,0,0,0,
  0,0,0,0,176,255,255,255,255,228,0,0,0,0,0,4,212,255,255,255,255,252,51,0,0,244,255,255,255,255,160,0,
  0,0,0,0,96,255,255,255,255,255,52,0,0,0,0,112,255,255,255,228,0,0,0,0,69,255,255,255,255,255,78,0,
  0,0,0,0,0,0,243,255,255,255,255,160,0,0,0,0,0,0,184,255,255,255,255,212,0,0,0,0,0,36,255,255,
  255,255,255,104,0,0,0,0,0,101,249,255,255,255,255,255,255,255,255,255,255,194,17,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,112,255,255,255,255,255,36,0,0,0,0,0,0,0,0,0,0,24,245,255,255,255,255,255,255,214,
  147,86,27,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,184,255,255,255,255,255,14,0,36,255,255,255,255,255,
  255,173,0,0,0,0,30,239,255,255,255,255,255,37,0,116,255,255,255,255,255,43,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,48,251,255,255,255,255,255,255,255,255,255,255,216,0,0,0,0,0,0,
  0,0,0,0,176,255,255,255,255,228,0,0,0,0,0,0,65,255,255,255,255,255,208,5,0,244,255,255,255,255,160,0,
  0,0,0,0,96,255,255,255,255,255,52,0,0,0,0,112,255,255,255,228,0,0,0,0,59,255,255,255,255,255,86,0,
  0,0,0,0,0,0,251,255,255,255,255,160,0,0,0,0,0,0,184,255,255,255,255,212,0,0,0,0,0,36,255,255,
  255,255,255,104,0,0,0,0,0,0,35,166,246,255,255,255,255,255,255,213,93,1,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,112,255,255,255,255,255,36,0,0,0,0,0,0,0,0,0,0,0,87,251,255,255,255,255,255,255,
  255,255,255,211,119,15,0,0,0,0,0,0,0,0,0,0,0,75,254,255,255,255,255,228,0,0,36,255,255,255,255,255,
  255,255,170,50,24,79,222,255,255,255,255,255,206,0,0,116,255,255,255,255,255,33,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,78,243,255,255,255,255,255,255,255,255,255,216,0,0,0,0,0,0,
  0,0,0,0,176,255,255,255,255,228,0,0,0,0,0,0,0,168,255,255,255,255,255,124,0,244,255,255,255,255,160,0,
  0,0,0,0,96,255,255,255,255,255,52,0,0,0,0,112,255,255,255,228,0,0,0,0,46,255,255,255,255,255,114,0,
  0,0,0,0,0,24,255,255,255,255,255,160,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,9,70,102,121,111,88,34,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,228,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,112,0,0,0,0,0,60,205,255,255,255,255,255,
  255,255,255,255,255,233,71,0,0,0,38,144,144,144,144,150,191,254,255,255,255,255,255,172,0,0,36,255,255,255,255,255,
  255,255,255,255,255,255,255,255,255,255,255,255,94,0,0,116,255,255,255,255,255,32,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,20,125,193,233,250,255,255,255,255,255,216,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,244,255,255,255,255,160,0,
  0,0,0,0,96,255,255,255,255,255,52,0,0,0,0,112,255,255,255,228,0,0,0,0,17,255,255,255,255,255,165,0,
  0,0,0,0,0,75,255,255,255,255,255,160,0,79,255,255,255,255,255,79,0,0,0,0,0,0,0,0,216,255,255,255,
  255,202,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,228,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,112,0,0,0,0,0,0,0,58,138,202,249,255,
  255,255,255,255,255,255,250,57,0,0,68,255,255,255,255,255,255,255,255,255,255,255,255,82,0,0,36,255,255,255,255,255,
  166,252,255,255,255,255,255,255,255,255,255,199,1,0,0,116,255,255,255,255,255,32,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,19,228,255,255,255,
  255,255,120,0,0,0,0,0,16,236,255,255,255,255,255,112,0,0,0,0,0,0,0,0,0,244,255,255,255,255,160,0,
  0,0,0,0,96,255,255,255,255,255,52,0,0,0,0,112,255,255,255,228,0,0,0,0,0,228,255,255,255,255,238,12,
  0,0,0,0,0,162,255,255,255,255,255,160,0,8,244,255,255,255,255,150,0,0,0,0,0,0,0,31,255,255,255,255,
  255,119,0,232,255,255,255,184,0,0,0,0,0,0,0,0,0,0,0,0,0,64,255,255,255,255,100,0,0,0,0,0,
  0,228,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,112,0,0,0,0,0,0,0,0,0,0,6,59,
  127,213,255,255,255,255,255,201,0,0,68,255,255,255,255,255,255,255,255,255,255,255,196,1,0,0,36,255,255,255,255,255,
  108,113,255,255,255,255,255,255,255,255,219,23,0,0,0,116,255,255,255,255,255,32,0,0,0,0,0,0,0,0,0,0,
  0,172,255,255,255,255,255,46,0,0,0,0,0,0,0,0,164,255,255,255,255,255,51,0,0,0,0,0,65,253,255,255,
  255,255,241,22,0,0,0,0,143,255,255,255,255,255,184,1,0,0,0,0,0,0,0,0,0,244,255,255,255,255,160,0,
  0,0,0,0,96,255,255,255,255,255,52,0,0,0,0,112,255,255,255,228,0,0,0,0,0,169,255,255,255,255,255,137,
  0,0,0,0,54,251,255,255,255,255,255,160,0,0,170,255,255,255,255,221,0,0,0,0,0,0,0,102,255,255,255,255,
  255,37,0,185,255,255,255,224,0,0,0,0,0,0,0,0,0,0,0,0,0,105,255,255,255,255,52,0,0,0,0,0,
  0,228,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,112,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,123,255,255,255,255,255,29,0,68,255,255,255,255,255,255,255,255,255,255,201,22,0,0,0,36,255,255,255,255,255,
  108,0,90,232,255,255,255,255,249,155,16,0,0,0,0,116,255,255,255,255,255,32,0,0,0,0,0,0,0,0,0,0,
  0,69,255,255,255,255,255,138,0,0,0,0,0,0,0,9,243,255,255,255,255,209,0,0,0,0,0,0,0,133,255,255,
  255,255,255,153,0,0,0,37,250,255,255,255,255,234,24,0,0,0,0,0,0,0,0,0,0,244,255,255,255,255,160,0,
  0,0,0,0,96,255,255,255,255,255,52,0,0,0,0,112,255,255,255,228,0,0,0,0,0,84,255,255,255,255,255,255,
  145,40,27,97,238,255,255,255,255,255,255,160,0,0,88,255,255,255,255,255,37,0,0,0,0,0,0,174,255,255,255,255,
  210,0,0,138,255,255,255,254,9,0,0,0,0,0,0,0,0,0,0,0,0,146,255,255,255,252,8,0,0,0,0,0,
  0,128,144,144,144,144,193,255,255,255,255,255,159,144,144,144,144,144,144,63,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,5,249,255,255,255,255,70,0,68,255,255,255,255,255,255,243,222,169,86,2,0,0,0,0,36,255,255,255,255,255,
  108,0,0,7,77,114,113,84,16,0,0,0,0,0,0,116,255,255,255,255,255,32,0,0,0,0,0,0,0,0,0,0,
  0,1,220,255,255,255,255,228,2,0,0,0,0,0,0,86,255,255,255,255,255,112,0,0,0,0,0,0,0,4,200,255,
  255,255,255,252,45,0,0,178,255,255,255,255,255,76,0,0,0,0,0,0,0,0,0,0,0,244,255,255,255,255,160,0,
  0,0,0,0,96,255,255,255,255,255,52,0,0,0,0,112,255,255,255,228,0,0,0,0,0,6,221,255,255,255,255,255,
  255,255,255,255,255,255,255,255,255,255,255,160,0,0,13,248,255,255,255,255,108,0,0,0,0,0,4,241,255,255,255,255,
  127,0,0,91,255,255,255,255,48,0,0,0,0,0,0,0,0,0,0,0,0,187,255,255,255,214,0,0,0,0,0,0,
  0,0,0,0,0,0,112,255,255,255,255,255,36,0,0,0,0,0,0,0,0,0,0,87,154,43,0,0,0,0,0,0,
  0,0,29,253,255,255,255,255,76,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,36,255,255,255,255,255,
  108,0,0,0,0,0,0,0,0,0,0,0,0,0,0,116,255,255,255,255,255,32,0,0,0,0,0,0,0,0,0,0,
  0,0,119,255,255,255,255,255,68,0,0,0,0,0,0,174,255,255,255,255,250,21,0,0,0,0,0,0,0,0,33,241,
  255,255,255,255,187,0,67,255,255,255,255,255,149,0,0,0,0,0,0,0,0,0,0,0,0,244,255,255,255,255,160,0,
  0,0,0,0,96,255,255,255,255,255,52,0,0,0,0,112,255,255,255,228,0,0,0,0,0,0,78,255,255,255,255,255,
  255,255,255,255,255,177,240,255,255,255,255,160,0,0,0,179,255,255,255,255,179,0,0,0,0,0,60,255,255,255,255,255,
  45,0,0,44,255,255,255,255,89,0,0,0,0,0,0,0,0,0,0,0,0,228,255,255,255,167,0,0,0,0,0,0,
  0,0,0,0,0,0,112,255,255,255,255,255,36,0,0,0,0,0,0,0,0,0,0,96,255,255,212,136,84,43,25,24,
  45,108,221,255,255,255,255,255,50,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,36,255,255,255,255,255,
  108,0,0,0,0,0,0,0,0,0,0,0,0,0,0,116,255,255,255,255,255,32,0,0,0,0,0,0,0,0,0,0,
  0,0,22,250,255,255,255,255,161,0,0,0,0,0,15,248,255,255,255,255,174,0,0,0,0,0,0,0,0,0,0,90,
  255,255,255,255,255,79,209,255,255,255,255,213,9,0,0,0,0,0,0,0,0,0,0,0,0,244,255,255,255,255,160,0,
  0,0,0,0,96,255,255,255,255,255,52,0,0,0,0,112,255,255,255,228,0,0,0,0,0,0,0,120,255,255,255,255,
  255,255,255,255,216,19,240,255,255,255,255,160,0,0,0,96,255,255,255,255,244,6,0,0,0,0,131,255,255,255,255,218,
  0,0,0,4,248,255,255,255,129,0,0,0,73,128,128,128,128,6,0,0,13,255,255,255,255,119,0,0,0,0,0,0,
  0,0,0,0,0,0,112,255,255,255,255,255,36,0,0,0,0,0,0,0,0,0,0,96,255,255,255,255,255,255,255,255,
  255,255,255,255,255,255,255,235,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,36,255,255,255,255,255,
  108,0,0,0,0,0,0,0,0,0,0,0,0,0,0,116,255,255,255,255,255,32,0,0,0,0,0,0,0,0,0,0,
  0,0,0,169,255,255,255,255,243,10,0,0,0,0,96,255,255,255,255,255,77,0,0,0,0,0,0,0,0,0,0,0,
  161,255,255,255,255,245,255,255,255,255,248,47,0,0,0,0,0,0,0,0,0,0,0,0,0,244,255,255,255,255,160,0,
  0,0,0,0,96,255,255,255,255,255,52,0,0,0,0,112,255,255,255,228,0,0,0,0,0,0,0,0,77,221,255,255,
  255,255,254,174,17,0,240,255,255,255,255,160,0,0,0,18,251,255,255,255,255,66,0,0,0,0,203,255,255,255,255,135,
  0,0,0,0,206,255,255,255,169,0,0,0,188,255,255,255,255,54,0,0,53,255,255,255,255,72,0,0,0,0,0,0,
  0,0,0,0,0,0,112,255,255,255,255,255,36,0,0,0,0,0,0,0,0,0,0,96,255,255,255,255,255,255,255,255,
  255,255,255,255,255,255,255,115,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,36,255,255,255,255,255,
  108,0,0,0,0,0,0,0,0,0,0,0,0,0,0,116,255,255,255,255,255,32,0,0,0,0,0,0,0,0,0,0,
  0,0,0,66,255,255,255,255,255,90,0,0,0,0,184,255,255,255,255,232,4,0,0,0,0,0,0,0,0,0,0,0,
  12,219,255,255,255,255,255,255,255,255,113,0,0,0,0,0,0,0,0,0,0,0,0,0,0,244,255,255,255,255,160,0,
  0,0,0,0,96,255,255,255,255,255,52,0,0,0,0,112,255,255,255,228,0,0,0,0,0,0,0,0,0,0,55,101,
  121,97,39,0,0,0,240,255,255,255,255,160,0,0,0,0,187,255,255,255,255,137,0,0,0,20,253,255,255,255,255,53,
  0,0,0,0,159,255,255,255,209,0,0,2,241,255,255,255,255,109,0,0,94,255,255,255,255,25,0,0,0,0,0,0,
  0,0,0,0,0,0,112,255,255,255,255,255,36,0,0,0,0,0,0,0,0,0,0,96,255,255,255,255,255,255,255,255,
  255,255,255,255,255,255,157,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,36,255,255,255,255,255,
  108,0,0,0,0,0,0,0,0,0,0,0,0,0,0,116,255,255,255,255,255,32,0,0,0,0,0,0,0,0,0,0,
  0,0,0,1,218,255,255,255,255,183,0,0,0,21,251,255,255,255,255,139,0,0,0,0,0,0,0,0,0,0,0,0,
  0,52,250,255,255,255,255,255,255,185,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,244,255,255,255,255,160,0,
  0,0,0,0,103,255,255,255,255,255,52,0,0,0,0,112,255,255,255,228,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,240,255,255,255,255,160,0,0,0,0,105,255,255,255,255,208,0,0,0,89,255,255,255,255,225,0,
  0,0,0,0,112,255,255,255,247,2,0,44,255,255,255,255,255,163,0,0,135,255,255,255,233,0,0,0,0,0,0,0,
  0,0,0,0,0,0,112,255,255,255,255,255,36,0,0,0,0,0,0,0,0,0,0,5,71,151,216,255,255,255,255,255,
  255,255,255,254,195,79,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,36,255,255,255,255,255,
  108,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,116,255,255,255,255,252,23,0,0,105,255,255,255,255,255,42,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,117,255,255,255,255,255,234,24,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,243,255,255,255,255,167,0,
  0,0,0,0,127,255,255,255,255,255,52,0,0,0,0,112,255,255,255,228,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,240,255,255,255,255,160,0,0,0,0,24,253,255,255,255,254,24,0,0,160,255,255,255,255,143,0,
  0,0,0,0,65,255,255,255,255,34,0,100,255,255,255,255,255,218,0,0,175,255,255,255,186,0,0,0,0,0,0,0,
  0,0,0,0,0,0,112,255,255,255,255,255,36,0,0,0,0,0,0,0,0,0,0,0,0,0,0,19,61,95,114,124,
  118,104,69,21,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,36,255,255,255,255,255,
  108,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,20,249,255,255,255,255,112,0,0,194,255,255,255,255,201,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,100,255,255,255,255,255,226,16,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,233,255,255,255,255,196,0,
  0,0,0,0,184,255,255,255,255,255,52,0,0,0,0,112,255,255,255,228,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,240,255,255,255,255,160,0,0,0,0,0,196,255,255,255,255,95,0,0,230,255,255,255,255,61,0,
  0,0,0,0,18,255,255,255,255,74,0,156,255,255,206,255,255,255,18,0,216,255,255,255,139,0,0,0,0,0,0,0,
  0,0,0,0,0,0,112,255,255,255,255,255,36,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,166,255,255,255,255,205,0,28,254,255,255,255,255,104,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,39,244,255,255,255,255,255,255,168,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,214,255,255,255,255,248,20,
  0,0,0,45,253,255,255,255,255,255,52,0,0,0,0,112,255,255,255,228,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,240,255,255,255,255,160,0,0,0,0,0,113,255,255,255,255,166,0,47,255,255,255,255,232,2,0,
  0,0,0,0,0,227,255,255,255,114,0,212,255,255,103,237,255,255,72,5,251,255,255,255,92,0,0,0,0,0,0,0,
  0,0,0,0,0,0,112,255,255,255,255,255,36,0,0,0,0,0,0,0,0,120,255,255,255,255,255,255,255,255,255,255,
  255,255,255,255,255,255,148,0,0,0,0,0,0,0,0,0,19,107,175,213,237,248,255,255,255,16,0,148,255,255,253,242,
  228,193,142,57,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,63,255,255,255,255,255,42,115,255,255,255,255,247,16,0,0,0,0,0,0,0,0,0,0,0,0,0,
  6,206,255,255,255,255,255,255,255,255,95,0,0,0,0,0,0,0,0,0,0,0,0,0,0,171,255,255,255,255,255,203,
  61,24,75,224,255,255,255,255,255,255,52,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,240,255,255,255,255,160,0,0,0,0,0,31,255,255,255,255,235,2,118,255,255,255,255,151,0,0,
  0,0,0,0,0,180,255,255,255,155,14,253,255,255,42,178,255,255,126,42,255,255,255,255,45,0,0,0,0,0,0,0,
  0,0,0,0,0,0,105,255,255,255,255,255,56,0,0,0,0,0,0,0,0,120,255,255,255,255,255,255,255,255,255,255,
  255,255,255,255,255,255,148,0,0,0,0,0,0,0,0,64,237,255,255,255,255,255,255,255,255,16,0,148,255,255,255,255,
  255,255,255,255,156,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,215,255,255,255,255,135,204,255,255,255,255,166,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  141,255,255,255,255,255,255,255,255,255,242,34,0,0,0,0,0,0,0,0,0,0,0,0,0,104,255,255,255,255,255,255,
  255,255,255,255,253,255,255,255,255,255,52,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,240,255,255,255,255,160,0,0,0,0,0,0,204,255,255,255,255,52,189,255,255,255,255,69,0,0,
  0,0,0,0,0,133,255,255,255,195,67,255,255,236,1,117,255,255,181,82,255,255,255,248,4,0,0,0,0,0,0,0,
  0,0,0,0,0,0,90,255,255,255,255,255,153,0,0,0,0,0,0,0,0,120,255,255,255,255,255,255,255,255,255,255,
  255,255,255,255,255,255,148,0,0,0,0,0,0,0,9,234,255,255,255,255,255,255,255,255,255,16,0,148,255,255,255,255,
  255,255,255,255,255,95,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,113,255,255,255,255,237,255,255,255,255,255,69,0,0,0,0,0,0,0,0,0,0,0,0,0,71,
  254,255,255,255,255,114,227,255,255,255,255,199,4,0,0,0,0,0,0,0,0,0,0,0,0,17,239,255,255,255,255,255,
  255,255,255,255,163,255,255,255,255,255,52,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,240,255,255,255,255,160,0,0,0,0,0,0,122,255,255,255,255,135,249,255,255,255,237,4,0,0,
  0,0,0,0,0,86,255,255,255,235,123,255,255,177,0,56,255,255,235,124,255,255,255,206,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,52,255,255,255,255,255,255,213,161,144,144,144,144,63,0,120,255,255,255,255,255,255,255,255,255,255,
  255,255,255,255,255,255,148,0,0,0,0,0,0,0,88,255,255,255,255,255,255,255,255,255,255,16,0,148,255,255,255,255,
  255,255,255,255,255,196,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,18,247,255,255,255,255,255,255,255,255,226,2,0,0,0,0,0,0,0,0,0,0,0,0,21,231,
  255,255,255,255,205,2,87,255,255,255,255,255,131,0,0,0,0,0,0,0,0,0,0,0,0,0,95,255,255,255,255,255,
  255,255,255,165,96,255,255,255,255,255,52,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,39,255,255,255,255,245,255,255,255,255,159,0,0,0,
  0,0,0,0,0,39,255,255,255,255,198,255,255,116,0,5,246,255,255,199,255,255,255,159,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,6,238,255,255,255,255,255,255,255,255,255,255,255,112,0,67,144,144,144,144,144,144,144,144,144,145,
  243,255,255,255,255,255,139,0,0,0,0,0,0,0,145,255,255,255,255,254,120,28,3,0,0,0,0,0,0,0,13,68,
  216,255,255,255,255,247,4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,162,255,255,255,255,255,255,255,255,131,0,0,0,0,0,0,0,0,0,0,0,0,0,181,255,
  255,255,255,254,57,0,0,191,255,255,255,255,252,60,0,0,0,0,0,0,0,0,0,0,0,0,0,93,235,255,255,255,
  255,246,139,3,96,255,255,255,255,255,52,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,213,255,255,255,255,255,255,255,255,77,0,0,0,
  0,0,0,0,0,2,245,255,255,255,255,255,255,56,0,0,190,255,255,255,255,255,255,112,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,130,255,255,255,255,255,255,255,255,255,255,255,112,0,0,0,0,0,0,0,0,0,0,0,150,
  255,255,255,255,255,201,13,0,0,0,0,0,0,0,177,255,255,255,255,182,0,0,0,0,0,0,0,0,0,0,0,0,
  68,255,255,255,255,255,28,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,59,255,255,255,255,255,255,255,255,35,0,0,0,0,0,0,0,0,0,0,0,0,111,255,255,
  255,255,255,160,0,0,0,44,251,255,255,255,255,224,15,0,0,0,0,0,0,0,0,0,0,0,0,0,9,74,113,117,
  85,21,0,0,0,0,0,0,0,0,0,0,0,0,9,108,187,233,249,227,192,119,26,0,0,0,0,0,0,0,0,24,
  144,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,130,255,255,255,255,255,255,255,242,7,0,0,0,
  0,0,0,0,0,0,201,255,255,255,255,255,246,5,0,0,129,255,255,255,255,255,255,64,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,4,167,255,255,255,255,255,255,255,255,255,255,112,0,0,0,0,0,0,0,0,0,0,140,255,
  255,255,255,255,209,17,0,0,0,0,0,0,0,0,190,255,255,255,255,126,0,0,0,0,0,0,0,0,0,0,0,0,
  9,255,255,255,255,255,41,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,212,255,255,255,255,255,255,193,0,0,0,0,0,0,0,0,0,0,0,0,46,248,255,255,
  255,255,241,24,0,0,0,0,144,255,255,255,255,255,166,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,80,232,255,255,255,255,255,255,255,251,165,52,0,0,0,0,5,100,233,
  204,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,48,255,255,255,255,255,255,255,167,0,0,0,0,
  0,0,0,0,0,0,154,255,255,255,255,255,191,0,0,0,68,255,255,255,255,255,255,17,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,57,141,192,228,243,253,255,255,255,255,112,0,0,0,0,0,0,0,0,0,130,255,255,
  255,255,255,215,22,0,0,0,0,0,0,0,0,0,196,255,255,255,255,105,0,0,0,0,0,0,0,0,0,0,0,0,
  0,243,255,255,255,255,48,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,109,255,255,255,255,255,255,96,0,0,0,0,0,0,0,0,0,0,0,9,214,255,255,255,
  255,255,114,0,0,0,0,0,15,232,255,255,255,255,255,93,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,70,255,255,255,255,255,255,255,255,255,255,255,255,222,166,149,175,238,255,255,
  204,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,221,255,255,255,255,255,255,85,0,0,0,0,
  0,0,0,0,0,0,107,255,255,255,255,255,130,0,0,0,11,251,255,255,255,255,226,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,119,255,255,255,
  255,255,221,26,0,0,0,0,0,0,0,0,0,0,196,255,255,255,255,100,0,0,0,0,0,0,0,0,0,0,0,0,
  0,236,255,255,255,255,48,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,16,246,255,255,255,255,243,11,0,0,0,0,0,0,0,0,0,0,0,152,255,255,255,255,
  255,214,5,0,0,0,0,0,0,96,255,255,255,255,255,242,34,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,84,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  204,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,60,255,255,255,255,255,70,0,0,0,0,202,255,255,255,255,179,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,110,255,255,255,255,
  255,226,31,0,0,0,0,0,0,0,0,0,0,0,196,255,255,255,255,100,0,0,0,0,0,0,0,0,0,0,0,0,
  0,236,255,255,255,255,48,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,2,229,255,255,255,255,157,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,84,255,255,255,206,163,153,183,227,255,255,255,255,255,255,255,255,255,255,255,
  190,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,100,254,255,255,255,255,
  231,37,0,0,0,0,0,0,0,0,0,0,0,0,196,255,255,255,255,100,0,0,0,0,0,0,0,0,0,0,0,0,
  0,236,255,255,255,255,48,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,73,255,255,255,255,255,60,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,84,255,163,35,0,0,0,0,0,57,163,250,255,255,255,255,255,255,255,165,
  15,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,91,253,255,255,255,255,235,
  43,0,0,0,0,0,0,0,0,0,0,0,0,0,202,255,255,255,255,100,0,0,0,0,0,0,0,0,0,0,0,0,
  0,236,255,255,255,255,54,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,193,255,255,255,255,218,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,69,80,0,0,0,0,0,0,0,0,0,25,123,199,243,247,219,154,51,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,82,252,255,255,255,255,240,49,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,223,255,255,255,255,95,0,0,0,0,0,0,0,0,0,0,0,0,
  0,231,255,255,255,255,74,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,115,255,255,255,255,255,119,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,74,249,255,255,255,255,243,57,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,20,254,255,255,255,255,81,0,0,0,0,0,0,0,0,0,0,0,0,
  0,218,255,255,255,255,127,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,83,144,145,163,214,255,255,255,255,255,245,19,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,66,247,255,255,255,255,246,64,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,130,255,255,255,255,255,44,0,0,0,0,0,0,0,0,0,0,0,0,
  0,182,255,255,255,255,226,14,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,148,255,255,255,255,255,255,255,255,255,132,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,59,244,255,255,255,255,249,72,0,0,0,
  0,0,0,0,0,0,0,0,0,1,14,55,150,254,255,255,255,255,227,1,0,0,0,0,0,0,0,0,0,0,0,0,
  0,111,255,255,255,255,255,212,89,28,5,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,148,255,255,255,255,255,255,255,255,211,8,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,227,255,255,255,255,255,207,144,144,144,144,
  144,144,144,144,144,144,83,0,164,255,255,255,255,255,255,255,255,252,82,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,10,209,255,255,255,255,255,255,255,255,255,32,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,148,255,255,255,255,255,255,255,215,28,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,236,255,255,255,255,255,255,255,255,255,255,
  255,255,255,255,255,255,148,0,164,255,255,255,255,255,255,232,165,52,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,11,121,206,252,255,255,255,255,255,255,32,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,148,255,255,255,255,247,209,122,11,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,236,255,255,255,255,255,255,255,255,255,255,
  255,255,255,255,255,255,148,0,164,255,255,255,255,255,255,235,161,40,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,3,108,206,253,255,255,255,255,255,255,32,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,236,255,255,255,255,255,255,255,255,255,255,
  255,255,255,255,255,255,148,0,164,255,255,255,255,255,255,255,255,246,60,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,2,183,255,255,255,255,255,255,255,255,255,32,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,236,255,255,255,255,255,255,255,255,255,255,
  255,255,255,255,255,255,148,0,0,1,16,60,162,255,255,255,255,255,207,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,87,255,255,255,255,255,221,96,31,7,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,146,255,255,255,255,255,30,0,0,0,0,0,0,0,0,0,0,0,0,
  0,166,255,255,255,255,235,21,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,30,255,255,255,255,255,71,0,0,0,0,0,0,0,0,0,0,0,0,
  0,208,255,255,255,255,139,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,230,255,255,255,255,91,0,0,0,0,0,0,0,0,0,0,0,0,
  0,228,255,255,255,255,82,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,206,255,255,255,255,99,0,0,0,0,0,0,0,0,0,0,0,0,
  0,235,255,255,255,255,57,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,196,255,255,255,255,100,0,0,0,0,0,0,0,0,0,0,0,0,
  0,236,255,255,255,255,48,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,196,255,255,255,255,100,0,0,0,0,0,0,0,0,0,0,0,0,
  0,236,255,255,255,255,48,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,196,255,255,255,255,100,0,0,0,0,0,0,0,0,0,0,0,0,
  0,236,255,255,255,255,48,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,196,255,255,255,255,101,0,0,0,0,0,0,0,0,0,0,0,0,
  0,237,255,255,255,255,48,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,195,255,255,255,255,108,0,0,0,0,0,0,0,0,0,0,0,0,
  0,245,255,255,255,255,46,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,185,255,255,255,255,133,0,0,0,0,0,0,0,0,0,0,0,0,
  16,255,255,255,255,255,36,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,170,255,255,255,255,192,0,0,0,0,0,0,0,0,0,0,0,0,
  79,255,255,255,255,255,21,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,130,255,255,255,255,255,129,30,3,0,0,0,0,0,0,0,13,73,
  223,255,255,255,255,237,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,70,255,255,255,255,255,255,255,255,255,255,16,0,148,255,255,255,255,
  255,255,255,255,255,179,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,219,255,255,255,255,255,255,255,255,255,16,0,148,255,255,255,255,
  255,255,255,255,255,75,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,48,227,255,255,255,255,255,255,255,255,16,0,148,255,255,255,255,
  255,255,255,254,133,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,13,99,170,212,238,249,255,255,255,16,0,148,255,255,253,243,
  228,190,136,46,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0}, 
 39.000000f, 45.400002f, 0.000001f, 36.200001f, -9.200000f, 96, 
 {
  {L'\0', 0, 0, 0, 0, 0.000000f, 0.000000f, 0.011719f, 0.011719f, 0.015625f, 0.015625f, 0, { } },
  {L' ', 0, 0, 0, 0, 23.484375f, 0.000000f, 0.023438f, 0.003906f, 0.023438f, 0.003906f, 0, { } },
  {L'!', 6, 29, 9, 29, 23.484375f, 0.000000f, 0.027344f, 0.003906f, 0.050781f, 0.117188f, 0, { } },
  {L'"', 16, 11, 4, 29, 23.484375f, 0.000000f, 0.054688f, 0.003906f, 0.117188f, 0.046875f, 0, { } },
  {L'#', 24, 29, 0, 29, 23.484375f, 0.000000f, 0.121094f, 0.003906f, 0.214844f, 0.117188f, 0, { } },
  {L'$', 18, 36, 3, 30, 23.484375f, 0.000000f, 0.218750f, 0.003906f, 0.289062f, 0.144531f, 0, { } },
  {L'%', 24, 28, 0, 28, 23.484375f, 0.000000f, 0.292969f, 0.003906f, 0.386719f, 0.113281f, 0, { } },
  {L'&', 24, 31, 0, 30, 23.484375f, 0.000000f, 0.390625f, 0.003906f, 0.484375f, 0.125000f, 0, { } },
  {L'\'', 6, 11, 9, 29, 23.484375f, 0.000000f, 0.488281f, 0.003906f, 0.511719f, 0.046875f, 0, { } },
  {L'(', 11, 35, 7, 30, 23.484375f, 0.000000f, 0.515625f, 0.003906f, 0.558594f, 0.140625f, 0, { } },
  {L')', 12, 35, 5, 30, 23.484375f, 0.000000f, 0.562500f, 0.003906f, 0.609375f, 0.140625f, 0, { } },
  {L'*', 20, 18, 2, 29, 23.484375f, 0.000000f, 0.613281f, 0.003906f, 0.691406f, 0.074219f, 0, { } },
  {L'+', 22, 21, 1, 23, 23.484375f, 0.000000f, 0.695312f, 0.003906f, 0.781250f, 0.085938f, 0, { } },
  {L',', 9, 13, 6, 8, 23.484375f, 0.000000f, 0.785156f, 0.003906f, 0.820312f, 0.054688f, 0, { } },
  {L'-', 13, 6, 5, 15, 23.484375f, 0.000000f, 0.824219f, 0.003906f, 0.875000f, 0.027344f, 0, { } },
  {L'.', 7, 7, 8, 7, 23.484375f, 0.000000f, 0.878906f, 0.003906f, 0.906250f, 0.031250f, 0, { } },
  {L'/', 20, 33, 2, 29, 23.484375f, 0.000000f, 0.910156f, 0.003906f, 0.988281f, 0.132812f, 0, { } },
  {L'0', 20, 31, 2, 30, 23.484375f, 0.000000f, 0.824219f, 0.035156f, 0.902344f, 0.156250f, 0, { } },
  {L'1', 19, 29, 3, 29, 23.484375f, 0.000000f, 0.613281f, 0.078125f, 0.687500f, 0.191406f, 0, { } },
  {L'2', 19, 30, 2, 30, 23.484375f, 0.000000f, 0.691406f, 0.089844f, 0.765625f, 0.207031f, 0, { } },
  {L'3', 19, 31, 2, 30, 23.484375f, 0.000000f, 0.292969f, 0.117188f, 0.367188f, 0.238281f, 0, { } },
  {L'4', 21, 29, 1, 29, 23.484375f, 0.000000f, 0.023438f, 0.121094f, 0.105469f, 0.234375f, 0, { } },
  {L'5', 19, 30, 2, 29, 23.484375f, 0.000000f, 0.109375f, 0.121094f, 0.183594f, 0.238281f, 0, { } },
  {L'6', 20, 31, 2, 30, 23.484375f, 0.000000f, 0.371094f, 0.128906f, 0.449219f, 0.250000f, 0, { } },
  {L'7', 19, 29, 2, 29, 23.484375f, 0.000000f, 0.906250f, 0.136719f, 0.980469f, 0.250000f, 0, { } },
  {L'8', 20, 31, 2, 30, 23.484375f, 0.000000f, 0.488281f, 0.144531f, 0.566406f, 0.265625f, 0, { } },
  {L'9', 19, 31, 2, 30, 23.484375f, 0.000000f, 0.187500f, 0.148438f, 0.261719f, 0.269531f, 0, { } },
  {L':', 7, 20, 8, 20, 23.484375f, 0.000000f, 0.785156f, 0.058594f, 0.812500f, 0.136719f, 0, { } },
  {L';', 8, 26, 7, 21, 23.484375f, 0.000000f, 0.453125f, 0.128906f, 0.484375f, 0.230469f, 0, { } },
  {L'<', 21, 21, 1, 23, 23.484375f, 0.000000f, 0.816406f, 0.160156f, 0.898438f, 0.242188f, 0, { } },
  {L'=', 21, 14, 1, 20, 23.484375f, 0.000000f, 0.570312f, 0.195312f, 0.652344f, 0.250000f, 0, { } },
  {L'>', 21, 21, 1, 23, 23.484375f, 0.000000f, 0.656250f, 0.210938f, 0.738281f, 0.292969f, 0, { } },
  {L'?', 17, 30, 4, 30, 23.484375f, 0.000000f, 0.742188f, 0.210938f, 0.808594f, 0.328125f, 0, { } },
  {L'@', 23, 33, 0, 27, 23.484375f, 0.000000f, 0.003906f, 0.238281f, 0.093750f, 0.367188f, 0, { } },
  {L'A', 23, 29, 0, 29, 23.484375f, 0.000000f, 0.265625f, 0.242188f, 0.355469f, 0.355469f, 0, { } },
  {L'B', 21, 29, 2, 29, 23.484375f, 0.000000f, 0.097656f, 0.242188f, 0.179688f, 0.355469f, 0, { } },
  {L'C', 19, 31, 2, 30, 23.484375f, 0.000000f, 0.812500f, 0.246094f, 0.886719f, 0.367188f, 0, { } },
  {L'D', 20, 29, 2, 29, 23.484375f, 0.000000f, 0.902344f, 0.253906f, 0.980469f, 0.367188f, 0, { } },
  {L'E', 18, 29, 3, 29, 23.484375f, 0.000000f, 0.359375f, 0.253906f, 0.429688f, 0.367188f, 0, { } },
  {L'F', 19, 29, 3, 29, 23.484375f, 0.000000f, 0.570312f, 0.253906f, 0.644531f, 0.367188f, 0, { } },
  {L'G', 20, 31, 2, 30, 23.484375f, 0.000000f, 0.433594f, 0.269531f, 0.511719f, 0.390625f, 0, { } },
  {L'H', 19, 29, 2, 29, 23.484375f, 0.000000f, 0.183594f, 0.273438f, 0.257812f, 0.386719f, 0, { } },
  {L'I', 18, 29, 3, 29, 23.484375f, 0.000000f, 0.648438f, 0.296875f, 0.718750f, 0.410156f, 0, { } },
  {L'J', 18, 30, 2, 29, 23.484375f, 0.000000f, 0.722656f, 0.332031f, 0.792969f, 0.449219f, 0, { } },
  {L'K', 22, 29, 2, 29, 23.484375f, 0.000000f, 0.261719f, 0.359375f, 0.347656f, 0.472656f, 0, { } },
  {L'L', 18, 29, 4, 29, 23.484375f, 0.000000f, 0.097656f, 0.359375f, 0.167969f, 0.472656f, 0, { } },
  {L'M', 21, 29, 1, 29, 23.484375f, 0.000000f, 0.890625f, 0.371094f, 0.972656f, 0.484375f, 0, { } },
  {L'N', 20, 29, 2, 29, 23.484375f, 0.000000f, 0.351562f, 0.371094f, 0.429688f, 0.484375f, 0, { } },
  {L'O', 21, 31, 1, 30, 23.484375f, 0.000000f, 0.796875f, 0.371094f, 0.878906f, 0.492188f, 0, { } },
  {L'P', 19, 29, 3, 29, 23.484375f, 0.000000f, 0.515625f, 0.371094f, 0.589844f, 0.484375f, 0, { } },
  {L'Q', 21, 36, 1, 30, 23.484375f, 0.000000f, 0.003906f, 0.371094f, 0.085938f, 0.511719f, 0, { } },
  {L'R', 22, 29, 2, 29, 23.484375f, 0.000000f, 0.171875f, 0.390625f, 0.257812f, 0.503906f, 0, { } },
  {L'S', 20, 31, 2, 30, 23.484375f, 0.000000f, 0.433594f, 0.394531f, 0.511719f, 0.515625f, 0, { } },
  {L'T', 21, 29, 1, 29, 23.484375f, 0.000000f, 0.593750f, 0.414062f, 0.675781f, 0.527344f, 0, { } },
  {L'U', 20, 30, 2, 29, 23.484375f, 0.000000f, 0.679688f, 0.453125f, 0.757812f, 0.570312f, 0, { } },
  {L'V', 22, 29, 1, 29, 23.484375f, 0.000000f, 0.261719f, 0.476562f, 0.347656f, 0.589844f, 0, { } },
  {L'W', 24, 29, 0, 29, 23.484375f, 0.000000f, 0.882812f, 0.488281f, 0.976562f, 0.601562f, 0, { } },
  {L'X', 23, 29, 0, 29, 23.484375f, 0.000000f, 0.761719f, 0.496094f, 0.851562f, 0.609375f, 0, { } },
  {L'Y', 24, 29, 0, 29, 23.484375f, 0.000000f, 0.089844f, 0.507812f, 0.183594f, 0.621094f, 0, { } },
  {L'Z', 21, 29, 2, 29, 23.484375f, 0.000000f, 0.003906f, 0.515625f, 0.085938f, 0.628906f, 0, { } },
  {L'[', 10, 36, 8, 30, 23.484375f, 0.000000f, 0.515625f, 0.488281f, 0.554688f, 0.628906f, 0, { } },
  {L'\\', 20, 33, 2, 29, 23.484375f, 0.000000f, 0.351562f, 0.488281f, 0.429688f, 0.617188f, 0, { } },
  {L']', 11, 36, 5, 30, 23.484375f, 0.000000f, 0.187500f, 0.507812f, 0.230469f, 0.648438f, 0, { } },
  {L'^', 22, 11, 1, 29, 23.484375f, 0.000000f, 0.558594f, 0.531250f, 0.644531f, 0.574219f, 0, { } },
  {L'_', 24, 4, 0, -5, 23.484375f, 0.000000f, 0.648438f, 0.574219f, 0.742188f, 0.589844f, 0, { } },
  {L'`', 12, 7, 3, 31, 23.484375f, 0.000000f, 0.433594f, 0.519531f, 0.480469f, 0.546875f, 0, { } },
  {L'a', 21, 23, 1, 22, 23.484375f, 0.000000f, 0.558594f, 0.578125f, 0.640625f, 0.667969f, 0, { } },
  {L'b', 20, 31, 2, 30, 23.484375f, 0.000000f, 0.433594f, 0.550781f, 0.511719f, 0.671875f, 0, { } },
  {L'c', 18, 23, 3, 22, 23.484375f, 0.000000f, 0.644531f, 0.593750f, 0.714844f, 0.683594f, 0, { } },
  {L'd', 20, 31, 1, 30, 23.484375f, 0.000000f, 0.234375f, 0.593750f, 0.312500f, 0.714844f, 0, { } },
  {L'e', 21, 23, 1, 22, 23.484375f, 0.000000f, 0.855469f, 0.605469f, 0.937500f, 0.695312f, 0, { } },
  {L'f', 18, 30, 3, 30, 23.484375f, 0.000000f, 0.746094f, 0.613281f, 0.816406f, 0.730469f, 0, { } },
  {L'g', 20, 30, 1, 22, 23.484375f, 0.000000f, 0.316406f, 0.621094f, 0.394531f, 0.738281f, 0, { } },
  {L'h', 18, 30, 3, 30, 23.484375f, 0.000000f, 0.089844f, 0.625000f, 0.160156f, 0.742188f, 0, { } },
  {L'i', 21, 32, 2, 32, 23.484375f, 0.000000f, 0.003906f, 0.632812f, 0.085938f, 0.757812f, 0, { } },
  {L'j', 15, 40, 2, 32, 23.484375f, 0.000000f, 0.164062f, 0.652344f, 0.222656f, 0.808594f, 0, { } },
  {L'k', 20, 30, 3, 30, 23.484375f, 0.000000f, 0.515625f, 0.671875f, 0.593750f, 0.789062f, 0, { } },
  {L'l', 20, 30, 1, 30, 23.484375f, 0.000000f, 0.398438f, 0.675781f, 0.476562f, 0.792969f, 0, { } },
  {L'm', 21, 22, 1, 22, 23.484375f, 0.000000f, 0.597656f, 0.687500f, 0.679688f, 0.773438f, 0, { } },
  {L'n', 18, 22, 3, 22, 23.484375f, 0.000000f, 0.820312f, 0.699219f, 0.890625f, 0.785156f, 0, { } },
  {L'o', 21, 23, 1, 22, 23.484375f, 0.000000f, 0.894531f, 0.699219f, 0.976562f, 0.789062f, 0, { } },
  {L'p', 20, 30, 2, 22, 23.484375f, 0.000000f, 0.226562f, 0.718750f, 0.304688f, 0.835938f, 0, { } },
  {L'q', 20, 30, 1, 22, 23.484375f, 0.000000f, 0.718750f, 0.734375f, 0.796875f, 0.851562f, 0, { } },
  {L'r', 17, 22, 5, 22, 23.484375f, 0.000000f, 0.308594f, 0.742188f, 0.375000f, 0.828125f, 0, { } },
  {L's', 18, 23, 3, 22, 23.484375f, 0.000000f, 0.089844f, 0.746094f, 0.160156f, 0.835938f, 0, { } },
  {L't', 19, 28, 2, 28, 23.484375f, 0.000000f, 0.003906f, 0.761719f, 0.078125f, 0.871094f, 0, { } },
  {L'u', 18, 22, 3, 21, 23.484375f, 0.000000f, 0.597656f, 0.777344f, 0.667969f, 0.863281f, 0, { } },
  {L'v', 21, 21, 1, 21, 23.484375f, 0.000000f, 0.800781f, 0.789062f, 0.882812f, 0.871094f, 0, { } },
  {L'w', 24, 21, 0, 21, 23.484375f, 0.000000f, 0.886719f, 0.792969f, 0.980469f, 0.875000f, 0, { } },
  {L'x', 22, 21, 1, 21, 23.484375f, 0.000000f, 0.480469f, 0.792969f, 0.566406f, 0.875000f, 0, { } },
  {L'y', 22, 29, 1, 21, 23.484375f, 0.000000f, 0.378906f, 0.796875f, 0.464844f, 0.910156f, 0, { } },
  {L'z', 18, 21, 3, 21, 23.484375f, 0.000000f, 0.082031f, 0.839844f, 0.152344f, 0.921875f, 0, { } },
  {L'{', 18, 37, 3, 30, 23.484375f, 0.000000f, 0.156250f, 0.839844f, 0.226562f, 0.984375f, 0, { } },
  {L'|', 5, 39, 9, 30, 23.484375f, 0.000000f, 0.683594f, 0.687500f, 0.703125f, 0.839844f, 0, { } },
  {L'}', 18, 37, 3, 30, 23.484375f, 0.000000f, 0.230469f, 0.839844f, 0.300781f, 0.984375f, 0, { } },
  {L'~', 21, 8, 1, 17, 23.484375f, 0.000000f, 0.671875f, 0.855469f, 0.753906f, 0.886719f, 0, { } },
 }
};
#ifdef __cplusplus
}
#endif
