# Header-параметры

Вы можете определить параметры заголовка таким же образом, как вы определяете параметры `Query`, `Path` и `Cookie`.

## Импорт `Header`

Сперва импортируйте `Header`:

//// tab | Python 3.10+

```Python hl_lines="3"
{!> ../../../docs_src/header_params/tutorial001_an_py310.py!}
```

////

//// tab | Python 3.9+

```Python hl_lines="3"
{!> ../../../docs_src/header_params/tutorial001_an_py39.py!}
```

////

//// tab | Python 3.8+

```Python hl_lines="3"
{!> ../../../docs_src/header_params/tutorial001_an.py!}
```

////

//// tab | Python 3.10+ без Annotated

/// tip | "Подсказка"

Предпочтительнее использовать версию с аннотацией, если это возможно.

///

```Python hl_lines="1"
{!> ../../../docs_src/header_params/tutorial001_py310.py!}
```

////

//// tab | Python 3.8+ без Annotated

/// tip | "Подсказка"

Предпочтительнее использовать версию с аннотацией, если это возможно.

///

```Python hl_lines="3"
{!> ../../../docs_src/header_params/tutorial001.py!}
```

////

## Объявление параметров `Header`

Затем объявите параметры заголовка, используя ту же структуру, что и с `Path`, `Query` и `Cookie`.

Первое значение является значением по умолчанию, вы можете передать все дополнительные параметры валидации или аннотации:

//// tab | Python 3.10+

```Python hl_lines="9"
{!> ../../../docs_src/header_params/tutorial001_an_py310.py!}
```

////

//// tab | Python 3.9+

```Python hl_lines="9"
{!> ../../../docs_src/header_params/tutorial001_an_py39.py!}
```

////

//// tab | Python 3.8+

```Python hl_lines="10"
{!> ../../../docs_src/header_params/tutorial001_an.py!}
```

////

//// tab | Python 3.10+ без Annotated

/// tip | "Подсказка"

Предпочтительнее использовать версию с аннотацией, если это возможно.

///

```Python hl_lines="7"
{!> ../../../docs_src/header_params/tutorial001_py310.py!}
```

////

//// tab | Python 3.8+ без Annotated

/// tip | "Подсказка"

Предпочтительнее использовать версию с аннотацией, если это возможно.

///

```Python hl_lines="9"
{!> ../../../docs_src/header_params/tutorial001.py!}
```

////

/// note | "Технические детали"

`Header` - это "родственный" класс `Path`, `Query` и `Cookie`. Он также наследуется от того же общего класса `Param`.

Но помните, что когда вы импортируете `Query`, `Path`, `Header` и другие из `fastapi`, на самом деле это функции, которые возвращают специальные классы.

///

/// info | "Дополнительная информация"

Чтобы объявить заголовки, важно использовать `Header`, иначе параметры интерпретируются как query-параметры.

///

## Автоматическое преобразование

`Header` обладает небольшой дополнительной функциональностью в дополнение к тому, что предоставляют `Path`, `Query` и `Cookie`.

Большинство стандартных заголовков разделены символом "дефис", также известным как "минус" (`-`).

Но переменная вроде `user-agent` недопустима в Python.

По умолчанию `Header` преобразует символы имен параметров из символа подчеркивания (`_`) в дефис (`-`) для извлечения и документирования заголовков.

Кроме того, HTTP-заголовки не чувствительны к регистру, поэтому вы можете объявить их в стандартном стиле Python (также известном как "snake_case").

Таким образом вы можете использовать `user_agent`, как обычно, в коде Python, вместо того, чтобы вводить заглавные буквы как `User_Agent` или что-то подобное.

Если по какой-либо причине вам необходимо отключить автоматическое преобразование подчеркиваний в дефисы, установите для параметра `convert_underscores` в `Header` значение `False`:

//// tab | Python 3.10+

```Python hl_lines="10"
{!> ../../../docs_src/header_params/tutorial002_an_py310.py!}
```

////

//// tab | Python 3.9+

```Python hl_lines="11"
{!> ../../../docs_src/header_params/tutorial002_an_py39.py!}
```

////

//// tab | Python 3.8+

```Python hl_lines="12"
{!> ../../../docs_src/header_params/tutorial002_an.py!}
```

////

//// tab | Python 3.10+ без Annotated

/// tip | "Подсказка"

Предпочтительнее использовать версию с аннотацией, если это возможно.

///

```Python hl_lines="8"
{!> ../../../docs_src/header_params/tutorial002_py310.py!}
```

////

//// tab | Python 3.8+ без Annotated

/// tip | "Подсказка"

Предпочтительнее использовать версию с аннотацией, если это возможно.

///

```Python hl_lines="10"
{!> ../../../docs_src/header_params/tutorial002.py!}
```

////

/// warning | "Внимание"

Прежде чем установить для `convert_underscores` значение `False`, имейте в виду, что некоторые HTTP-прокси и серверы запрещают использование заголовков с подчеркиванием.

///

## Повторяющиеся заголовки

Есть возможность получать несколько заголовков с одним и тем же именем, но разными значениями.

Вы можете определить эти случаи, используя список в объявлении типа.

Вы получите все значения из повторяющегося заголовка в виде `list` Python.

Например, чтобы объявить заголовок `X-Token`, который может появляться более одного раза, вы можете написать:

//// tab | Python 3.10+

```Python hl_lines="9"
{!> ../../../docs_src/header_params/tutorial003_an_py310.py!}
```

////

//// tab | Python 3.9+

```Python hl_lines="9"
{!> ../../../docs_src/header_params/tutorial003_an_py39.py!}
```

////

//// tab | Python 3.8+

```Python hl_lines="10"
{!> ../../../docs_src/header_params/tutorial003_an.py!}
```

////

//// tab | Python 3.10+ без Annotated

/// tip | "Подсказка"

Предпочтительнее использовать версию с аннотацией, если это возможно.

///

```Python hl_lines="7"
{!> ../../../docs_src/header_params/tutorial003_py310.py!}
```

////

//// tab | Python 3.9+ без Annotated

/// tip | "Подсказка"

Предпочтительнее использовать версию с аннотацией, если это возможно.

///

```Python hl_lines="9"
{!> ../../../docs_src/header_params/tutorial003_py39.py!}
```

////

//// tab | Python 3.8+ без Annotated

/// tip | "Подсказка"

Предпочтительнее использовать версию с аннотацией, если это возможно.

///

```Python hl_lines="9"
{!> ../../../docs_src/header_params/tutorial003.py!}
```

////

Если вы взаимодействуете с этой *операцией пути*, отправляя два HTTP-заголовка, таких как:

```
X-Token: foo
X-Token: bar
```

Ответ был бы таким:

```JSON
{
    "X-Token values": [
        "bar",
        "foo"
    ]
}
```

## Резюме

Объявляйте заголовки с помощью `Header`, используя тот же общий шаблон, как при `Query`, `Path` и `Cookie`.

И не беспокойтесь о символах подчеркивания в ваших переменных, **FastAPI** позаботится об их преобразовании.
