Translate to Russian (русский язык).

Language code: ru.

---

Use a neutral tone (not overly formal or informal).

Use correct Russian grammar — appropriate cases, suffixes, and endings depending on context.

For the following technical terms, use these specific translations to ensure consistency and clarity across the documentation:

* production (meaning production software or environment): продакшн (do not change the ending, for example, translate `in production` as `в продакшн` (not `в продакшене`))
* completion (meaning code auto-completion): автозавершение
* editor (meaning component of IDE): редактор кода
* adopt (meaning start to use): использовать (or `начать использовать`)
* headers (meaning HTTP-headers): HTTP-заголовки
* cookie sessions: сессии с использованием cookie
* tested (adjective): протестированный
* middleware: middleware (don't translate, but add `промежуточный слой` if clarification is needed)
* path operation: операция пути (optionally clarify as `обработчик пути`)
* path operation function: функция-обработчик пути (or `функция обработки пути`)
* proprietary: проприетарный
* benchmark: бенчмарк (add (`тест производительности`) if clarification is needed or use just `тест производительности`)
* ASGI server: ASGI-сервер
* In a hurry? : Нет времени?
* response status code: статус-код ответа
* HTTP status code: HTTP статус-код
* issue (meaning GitHub issue): Issue (add `тикет\обращение` if clarification is needed)
* PR (meaning GitHub pull request): пулл-реквест (add `запрос на изменение` if clarification is needed)
* run (meaning run the code): запустить (or `прогнать` if it's about testing the program)
* to reach users: донести до пользователей (or `привлечь внимание пользователей` in the promotion context)
* body (meaning HTTP request body): тело запроса
* body (meaning HTTP response body): тело ответа
* body parameter : body-параметр (or `параметр тела запроса`)
* validate: валидировать (or `выполнить валидацию`)
* requirements (meaning dependencies): зависимости
* auto-reload: авто-перезагрузка (or `перезагрузить автоматически` if used as a verb)
* show (meaning show on the screen): отобразить
* parsing (noun): парсинг
* origin (in web development): origin (add `источник` if clarification is needed)
* include: включать (add `в себя` if it's appropriate, or use `содержать` as an alternative)
* virtual environment: виртуальное окружение
* framework: фреймворк
* path paremeter: path-параметр
* path (as in URL path): путь
* form (as in HTML form): форма
* media type: тип содержимого (or `медиа-тип`)
* request: HTTP-запрос
* response: HTTP-ответ
* type hints: аннотации типов
* type annotations: аннотации типов
* context manager: менеджер контекста
* code base: кодовая база
* instantiate: создать экземпляр (avoid "инстанцировать")
* load balancer: балансировщик нагрузки
* load balance: балансировка нагрузки
* worker process: воркер-процесс (or `процесс воркера`)
* worker: воркер
* lifespan: lifespan (do not translate when it's about lifespan events, but translate as `жизненный цикл` or `срок жизни` in other cases)
* mount (verb): монтировать
* mount (noun): точка монтирования / mount (keep in English if it's a FastAPI keyword)
* plugin: плагин
* plug-in: плагин
* full stack: full stack (do not translate)
* full-stack: full-stack (do not translate)
* loop (as in async loop): цикл событий
* Machine Learning: Машинное обучение
* Deep Learning: Глубокое обучение
* callback hell: callback hell (clarify as `ад обратных вызовов`)
* on the fly: на лету
* scratch the surface: поверхностно ознакомиться
* tip: совет (or `подсказка` depending on context)
* Pydantic model: Pydantic-модель (`модель Pydantic` and `Pydantic модель` are also fine)
* declare: объявить
* have the next best performance, after: быть на следующем месте по производительности после
* timing attack: тайминговая атака (clarify `атака по времени` if needed)
* OAuth2 scope: OAuth2 scope (clarify `область` if needed)
* TLS Termination Proxy: прокси-сервер TSL-терминации
* utilize (resources): использовать
* сontent: содержимое (or `контент`)
* raise exception: вызвать исключение (also possible to use `сгенерировать исключение` or `выбросить исключение`)
* password flow: password flow (clarify as `аутентификация по паролю` if needed)
* tutorial: руководство (or `учебник`)
* too long; didn't read: слишком длинно; не читал
* proxy with a stripped path prefix: прокси с функцией удаления префикса пути
* nerd: умник
* sub application: подприложение
* webhook request: вебхук-запрос
* serve (meaning providing access to something): «отдавать» (or `предоставлять доступ к`)
* recap (noun): резюме
* utility function: вспомогательная функция

Do not add whitespace in `т.д.`, `т.п.`.
