from typing import Any, ClassVar, Iterable, Iterator, List, Set, Tuple

from typing import overload
import lief # type: ignore
import lief.PE # type: ignore

class ACCELERATOR_FLAGS:
    __members__: ClassVar[dict] = ...  # read-only
    END: ClassVar[ACCELERATOR_FLAGS] = ...
    FALT: ClassVar[ACCELERATOR_FLAGS] = ...
    FCONTROL: ClassVar[ACCELERATOR_FLAGS] = ...
    FNOINVERT: ClassVar[ACCELERATOR_FLAGS] = ...
    FSHIFT: ClassVar[ACCELERATOR_FLAGS] = ...
    FVIRTKEY: ClassVar[ACCELERATOR_FLAGS] = ...
    __entries: ClassVar[dict] = ...
    def __init__(self, value: int) -> None: ...
    @property
    def name(self) -> str: ...
    @property
    def value(self) -> int: ...

class ACCELERATOR_VK_CODES:
    __members__: ClassVar[dict] = ...  # read-only
    VK_0: ClassVar[ACCELERATOR_VK_CODES] = ...
    VK_1: ClassVar[ACCELERATOR_VK_CODES] = ...
    VK_2: ClassVar[ACCELERATOR_VK_CODES] = ...
    VK_3: ClassVar[ACCELERATOR_VK_CODES] = ...
    VK_4: ClassVar[ACCELERATOR_VK_CODES] = ...
    VK_5: ClassVar[ACCELERATOR_VK_CODES] = ...
    VK_6: ClassVar[ACCELERATOR_VK_CODES] = ...
    VK_7: ClassVar[ACCELERATOR_VK_CODES] = ...
    VK_8: ClassVar[ACCELERATOR_VK_CODES] = ...
    VK_9: ClassVar[ACCELERATOR_VK_CODES] = ...
    VK_A: ClassVar[ACCELERATOR_VK_CODES] = ...
    VK_ACCEPT: ClassVar[ACCELERATOR_VK_CODES] = ...
    VK_ADD: ClassVar[ACCELERATOR_VK_CODES] = ...
    VK_APPS: ClassVar[ACCELERATOR_VK_CODES] = ...
    VK_ATTN: ClassVar[ACCELERATOR_VK_CODES] = ...
    VK_B: ClassVar[ACCELERATOR_VK_CODES] = ...
    VK_BACK: ClassVar[ACCELERATOR_VK_CODES] = ...
    VK_BROWSER_BACK: ClassVar[ACCELERATOR_VK_CODES] = ...
    VK_BROWSER_FAVORITES: ClassVar[ACCELERATOR_VK_CODES] = ...
    VK_BROWSER_FORWARD: ClassVar[ACCELERATOR_VK_CODES] = ...
    VK_BROWSER_HOME: ClassVar[ACCELERATOR_VK_CODES] = ...
    VK_BROWSER_REFRESH: ClassVar[ACCELERATOR_VK_CODES] = ...
    VK_BROWSER_SEARCH: ClassVar[ACCELERATOR_VK_CODES] = ...
    VK_BROWSER_STOP: ClassVar[ACCELERATOR_VK_CODES] = ...
    VK_C: ClassVar[ACCELERATOR_VK_CODES] = ...
    VK_CANCEL: ClassVar[ACCELERATOR_VK_CODES] = ...
    VK_CAPITAL: ClassVar[ACCELERATOR_VK_CODES] = ...
    VK_CLEAR: ClassVar[ACCELERATOR_VK_CODES] = ...
    VK_CONTROL: ClassVar[ACCELERATOR_VK_CODES] = ...
    VK_CONVERT: ClassVar[ACCELERATOR_VK_CODES] = ...
    VK_CRSEL: ClassVar[ACCELERATOR_VK_CODES] = ...
    VK_D: ClassVar[ACCELERATOR_VK_CODES] = ...
    VK_DECIMAL: ClassVar[ACCELERATOR_VK_CODES] = ...
    VK_DELETE: ClassVar[ACCELERATOR_VK_CODES] = ...
    VK_DIVIDE: ClassVar[ACCELERATOR_VK_CODES] = ...
    VK_DOWN: ClassVar[ACCELERATOR_VK_CODES] = ...
    VK_E: ClassVar[ACCELERATOR_VK_CODES] = ...
    VK_END: ClassVar[ACCELERATOR_VK_CODES] = ...
    VK_EREOF: ClassVar[ACCELERATOR_VK_CODES] = ...
    VK_ESCAPE: ClassVar[ACCELERATOR_VK_CODES] = ...
    VK_EXECUTE: ClassVar[ACCELERATOR_VK_CODES] = ...
    VK_EXSEL: ClassVar[ACCELERATOR_VK_CODES] = ...
    VK_F: ClassVar[ACCELERATOR_VK_CODES] = ...
    VK_F1: ClassVar[ACCELERATOR_VK_CODES] = ...
    VK_F10: ClassVar[ACCELERATOR_VK_CODES] = ...
    VK_F11: ClassVar[ACCELERATOR_VK_CODES] = ...
    VK_F12: ClassVar[ACCELERATOR_VK_CODES] = ...
    VK_F13: ClassVar[ACCELERATOR_VK_CODES] = ...
    VK_F14: ClassVar[ACCELERATOR_VK_CODES] = ...
    VK_F15: ClassVar[ACCELERATOR_VK_CODES] = ...
    VK_F16: ClassVar[ACCELERATOR_VK_CODES] = ...
    VK_F17: ClassVar[ACCELERATOR_VK_CODES] = ...
    VK_F18: ClassVar[ACCELERATOR_VK_CODES] = ...
    VK_F19: ClassVar[ACCELERATOR_VK_CODES] = ...
    VK_F2: ClassVar[ACCELERATOR_VK_CODES] = ...
    VK_F20: ClassVar[ACCELERATOR_VK_CODES] = ...
    VK_F21: ClassVar[ACCELERATOR_VK_CODES] = ...
    VK_F22: ClassVar[ACCELERATOR_VK_CODES] = ...
    VK_F23: ClassVar[ACCELERATOR_VK_CODES] = ...
    VK_F24: ClassVar[ACCELERATOR_VK_CODES] = ...
    VK_F3: ClassVar[ACCELERATOR_VK_CODES] = ...
    VK_F4: ClassVar[ACCELERATOR_VK_CODES] = ...
    VK_F5: ClassVar[ACCELERATOR_VK_CODES] = ...
    VK_F6: ClassVar[ACCELERATOR_VK_CODES] = ...
    VK_F7: ClassVar[ACCELERATOR_VK_CODES] = ...
    VK_F8: ClassVar[ACCELERATOR_VK_CODES] = ...
    VK_F9: ClassVar[ACCELERATOR_VK_CODES] = ...
    VK_FINAL: ClassVar[ACCELERATOR_VK_CODES] = ...
    VK_G: ClassVar[ACCELERATOR_VK_CODES] = ...
    VK_H: ClassVar[ACCELERATOR_VK_CODES] = ...
    VK_HANGUEL: ClassVar[ACCELERATOR_VK_CODES] = ...
    VK_HANGUL: ClassVar[ACCELERATOR_VK_CODES] = ...
    VK_HANJA: ClassVar[ACCELERATOR_VK_CODES] = ...
    VK_HELP: ClassVar[ACCELERATOR_VK_CODES] = ...
    VK_HOME: ClassVar[ACCELERATOR_VK_CODES] = ...
    VK_I: ClassVar[ACCELERATOR_VK_CODES] = ...
    VK_IME_OFF: ClassVar[ACCELERATOR_VK_CODES] = ...
    VK_IME_ON: ClassVar[ACCELERATOR_VK_CODES] = ...
    VK_INSERT: ClassVar[ACCELERATOR_VK_CODES] = ...
    VK_J: ClassVar[ACCELERATOR_VK_CODES] = ...
    VK_JUNJA: ClassVar[ACCELERATOR_VK_CODES] = ...
    VK_K: ClassVar[ACCELERATOR_VK_CODES] = ...
    VK_KANA: ClassVar[ACCELERATOR_VK_CODES] = ...
    VK_KANJI: ClassVar[ACCELERATOR_VK_CODES] = ...
    VK_L: ClassVar[ACCELERATOR_VK_CODES] = ...
    VK_LAUNCH_APP1: ClassVar[ACCELERATOR_VK_CODES] = ...
    VK_LAUNCH_APP2: ClassVar[ACCELERATOR_VK_CODES] = ...
    VK_LAUNCH_MAIL: ClassVar[ACCELERATOR_VK_CODES] = ...
    VK_LAUNCH_MEDIA_SELECT: ClassVar[ACCELERATOR_VK_CODES] = ...
    VK_LBUTTON: ClassVar[ACCELERATOR_VK_CODES] = ...
    VK_LCONTROL: ClassVar[ACCELERATOR_VK_CODES] = ...
    VK_LEFT: ClassVar[ACCELERATOR_VK_CODES] = ...
    VK_LMENU: ClassVar[ACCELERATOR_VK_CODES] = ...
    VK_LSHIFT: ClassVar[ACCELERATOR_VK_CODES] = ...
    VK_LWIN: ClassVar[ACCELERATOR_VK_CODES] = ...
    VK_M: ClassVar[ACCELERATOR_VK_CODES] = ...
    VK_MBUTTON: ClassVar[ACCELERATOR_VK_CODES] = ...
    VK_MEDIA_NEXT_TRACK: ClassVar[ACCELERATOR_VK_CODES] = ...
    VK_MEDIA_PLAY_PAUSE: ClassVar[ACCELERATOR_VK_CODES] = ...
    VK_MEDIA_PREV_TRACK: ClassVar[ACCELERATOR_VK_CODES] = ...
    VK_MEDIA_STOP: ClassVar[ACCELERATOR_VK_CODES] = ...
    VK_MENU: ClassVar[ACCELERATOR_VK_CODES] = ...
    VK_MODECHANGE: ClassVar[ACCELERATOR_VK_CODES] = ...
    VK_MULTIPLY: ClassVar[ACCELERATOR_VK_CODES] = ...
    VK_N: ClassVar[ACCELERATOR_VK_CODES] = ...
    VK_NEXT: ClassVar[ACCELERATOR_VK_CODES] = ...
    VK_NONAME: ClassVar[ACCELERATOR_VK_CODES] = ...
    VK_NONCONVERT: ClassVar[ACCELERATOR_VK_CODES] = ...
    VK_NUMLOCK: ClassVar[ACCELERATOR_VK_CODES] = ...
    VK_NUMPAD0: ClassVar[ACCELERATOR_VK_CODES] = ...
    VK_NUMPAD1: ClassVar[ACCELERATOR_VK_CODES] = ...
    VK_NUMPAD2: ClassVar[ACCELERATOR_VK_CODES] = ...
    VK_NUMPAD3: ClassVar[ACCELERATOR_VK_CODES] = ...
    VK_NUMPAD4: ClassVar[ACCELERATOR_VK_CODES] = ...
    VK_NUMPAD5: ClassVar[ACCELERATOR_VK_CODES] = ...
    VK_NUMPAD6: ClassVar[ACCELERATOR_VK_CODES] = ...
    VK_NUMPAD7: ClassVar[ACCELERATOR_VK_CODES] = ...
    VK_NUMPAD8: ClassVar[ACCELERATOR_VK_CODES] = ...
    VK_NUMPAD9: ClassVar[ACCELERATOR_VK_CODES] = ...
    VK_O: ClassVar[ACCELERATOR_VK_CODES] = ...
    VK_OEM_1: ClassVar[ACCELERATOR_VK_CODES] = ...
    VK_OEM_102: ClassVar[ACCELERATOR_VK_CODES] = ...
    VK_OEM_2: ClassVar[ACCELERATOR_VK_CODES] = ...
    VK_OEM_4: ClassVar[ACCELERATOR_VK_CODES] = ...
    VK_OEM_5: ClassVar[ACCELERATOR_VK_CODES] = ...
    VK_OEM_6: ClassVar[ACCELERATOR_VK_CODES] = ...
    VK_OEM_7: ClassVar[ACCELERATOR_VK_CODES] = ...
    VK_OEM_8: ClassVar[ACCELERATOR_VK_CODES] = ...
    VK_OEM_CLEAR: ClassVar[ACCELERATOR_VK_CODES] = ...
    VK_OEM_COMMA: ClassVar[ACCELERATOR_VK_CODES] = ...
    VK_OEM_MINUS: ClassVar[ACCELERATOR_VK_CODES] = ...
    VK_OEM_PERIOD: ClassVar[ACCELERATOR_VK_CODES] = ...
    VK_OEM_PLUS: ClassVar[ACCELERATOR_VK_CODES] = ...
    VK_P: ClassVar[ACCELERATOR_VK_CODES] = ...
    VK_PA1: ClassVar[ACCELERATOR_VK_CODES] = ...
    VK_PACKET: ClassVar[ACCELERATOR_VK_CODES] = ...
    VK_PAUSE: ClassVar[ACCELERATOR_VK_CODES] = ...
    VK_PLAY: ClassVar[ACCELERATOR_VK_CODES] = ...
    VK_PRINT: ClassVar[ACCELERATOR_VK_CODES] = ...
    VK_PRIOR: ClassVar[ACCELERATOR_VK_CODES] = ...
    VK_PROCESSKEY: ClassVar[ACCELERATOR_VK_CODES] = ...
    VK_Q: ClassVar[ACCELERATOR_VK_CODES] = ...
    VK_R: ClassVar[ACCELERATOR_VK_CODES] = ...
    VK_RBUTTON: ClassVar[ACCELERATOR_VK_CODES] = ...
    VK_RCONTROL: ClassVar[ACCELERATOR_VK_CODES] = ...
    VK_RETURN: ClassVar[ACCELERATOR_VK_CODES] = ...
    VK_RIGHT: ClassVar[ACCELERATOR_VK_CODES] = ...
    VK_RMENU: ClassVar[ACCELERATOR_VK_CODES] = ...
    VK_RSHIFT: ClassVar[ACCELERATOR_VK_CODES] = ...
    VK_RWIN: ClassVar[ACCELERATOR_VK_CODES] = ...
    VK_S: ClassVar[ACCELERATOR_VK_CODES] = ...
    VK_SCROLL: ClassVar[ACCELERATOR_VK_CODES] = ...
    VK_SELECT: ClassVar[ACCELERATOR_VK_CODES] = ...
    VK_SEPARATOR: ClassVar[ACCELERATOR_VK_CODES] = ...
    VK_SHIFT: ClassVar[ACCELERATOR_VK_CODES] = ...
    VK_SLEEP: ClassVar[ACCELERATOR_VK_CODES] = ...
    VK_SNAPSHOT: ClassVar[ACCELERATOR_VK_CODES] = ...
    VK_SPACE: ClassVar[ACCELERATOR_VK_CODES] = ...
    VK_SUBTRACT: ClassVar[ACCELERATOR_VK_CODES] = ...
    VK_T: ClassVar[ACCELERATOR_VK_CODES] = ...
    VK_TAB: ClassVar[ACCELERATOR_VK_CODES] = ...
    VK_U: ClassVar[ACCELERATOR_VK_CODES] = ...
    VK_UP: ClassVar[ACCELERATOR_VK_CODES] = ...
    VK_V: ClassVar[ACCELERATOR_VK_CODES] = ...
    VK_VOLUME_DOWN: ClassVar[ACCELERATOR_VK_CODES] = ...
    VK_VOLUME_MUTE: ClassVar[ACCELERATOR_VK_CODES] = ...
    VK_VOLUME_UP: ClassVar[ACCELERATOR_VK_CODES] = ...
    VK_W: ClassVar[ACCELERATOR_VK_CODES] = ...
    VK_X: ClassVar[ACCELERATOR_VK_CODES] = ...
    VK_XBUTTON1: ClassVar[ACCELERATOR_VK_CODES] = ...
    VK_XBUTTON2: ClassVar[ACCELERATOR_VK_CODES] = ...
    VK_Y: ClassVar[ACCELERATOR_VK_CODES] = ...
    VK_Z: ClassVar[ACCELERATOR_VK_CODES] = ...
    VK_ZOOM: ClassVar[ACCELERATOR_VK_CODES] = ...
    __entries: ClassVar[dict] = ...
    def __init__(self, value: int) -> None: ...
    @property
    def name(self) -> str: ...
    @property
    def value(self) -> int: ...

class ALGORITHMS:
    __members__: ClassVar[dict] = ...  # read-only
    EC: ClassVar[ALGORITHMS] = ...
    MD2: ClassVar[ALGORITHMS] = ...
    MD4: ClassVar[ALGORITHMS] = ...
    MD5: ClassVar[ALGORITHMS] = ...
    MD5_RSA: ClassVar[ALGORITHMS] = ...
    RSA: ClassVar[ALGORITHMS] = ...
    SHA1_DSA: ClassVar[ALGORITHMS] = ...
    SHA1_ECDSA: ClassVar[ALGORITHMS] = ...
    SHA1_RSA: ClassVar[ALGORITHMS] = ...
    SHA_1: ClassVar[ALGORITHMS] = ...
    SHA_256: ClassVar[ALGORITHMS] = ...
    SHA_256_ECDSA: ClassVar[ALGORITHMS] = ...
    SHA_256_RSA: ClassVar[ALGORITHMS] = ...
    SHA_384: ClassVar[ALGORITHMS] = ...
    SHA_384_ECDSA: ClassVar[ALGORITHMS] = ...
    SHA_384_RSA: ClassVar[ALGORITHMS] = ...
    SHA_512: ClassVar[ALGORITHMS] = ...
    SHA_512_ECDSA: ClassVar[ALGORITHMS] = ...
    SHA_512_RSA: ClassVar[ALGORITHMS] = ...
    UNKNOWN: ClassVar[ALGORITHMS] = ...
    __entries: ClassVar[dict] = ...
    def __init__(self, value: int) -> None: ...
    @property
    def name(self) -> str: ...
    @property
    def value(self) -> int: ...

class Attribute(lief.Object):
    def __init__(self, *args, **kwargs) -> None: ...
    @property
    def type(self) -> lief.PE.SIG_ATTRIBUTE_TYPES: ...

class Binary(lief.Binary):
    class it_const_signatures:
        def __init__(self, *args, **kwargs) -> None: ...
        def __getitem__(self, arg0: int) -> lief.PE.Signature: ...
        def __iter__(self) -> Iterator: ...
        def __len__(self) -> int: ...
        def __next__(self) -> lief.PE.Signature: ...

    class it_data_directories:
        def __init__(self, *args, **kwargs) -> None: ...
        def __getitem__(self, arg0: int) -> lief.PE.DataDirectory: ...
        def __iter__(self) -> Iterator: ...
        def __len__(self) -> int: ...
        def __next__(self) -> lief.PE.DataDirectory: ...

    class it_delay_imports:
        def __init__(self, *args, **kwargs) -> None: ...
        def __getitem__(self, arg0: int) -> lief.PE.DelayImport: ...
        def __iter__(self) -> Iterator: ...
        def __len__(self) -> int: ...
        def __next__(self) -> lief.PE.DelayImport: ...

    class it_imports:
        def __init__(self, *args, **kwargs) -> None: ...
        def __getitem__(self, arg0: int) -> lief.PE.Import: ...
        def __iter__(self) -> Iterator: ...
        def __len__(self) -> int: ...
        def __next__(self) -> lief.PE.Import: ...

    class it_relocations:
        def __init__(self, *args, **kwargs) -> None: ...
        def __getitem__(self, arg0: int) -> lief.PE.Relocation: ...
        def __iter__(self) -> Iterator: ...
        def __len__(self) -> int: ...
        def __next__(self) -> lief.PE.Relocation: ...

    class it_section:
        def __init__(self, *args, **kwargs) -> None: ...
        def __getitem__(self, arg0: int) -> lief.PE.Section: ...
        def __iter__(self) -> Iterator: ...
        def __len__(self) -> int: ...
        def __next__(self) -> lief.PE.Section: ...

    class it_symbols:
        def __init__(self, *args, **kwargs) -> None: ...
        def __getitem__(self, arg0: int) -> lief.PE.Symbol: ...
        def __iter__(self) -> Iterator: ...
        def __len__(self) -> int: ...
        def __next__(self) -> lief.PE.Symbol: ...
    dos_stub: memoryview
    rich_header: lief.PE.RichHeader
    tls: lief.PE.TLS
    def __init__(self, name: str, type: lief.PE.PE_TYPE) -> None: ...
    def add_import_function(self, import_name: str, function_name: str) -> lief.PE.ImportEntry: ...
    def add_library(self, import_name: str) -> lief.PE.Import: ...
    def add_relocation(self, relocation: lief.PE.Relocation) -> lief.PE.Relocation: ...
    def add_section(self, section: lief.PE.Section, type: lief.PE.SECTION_TYPES = ...) -> lief.PE.Section: ...
    def authentihash(self, algorithm: lief.PE.ALGORITHMS) -> bytes: ...
    def data_directory(self, type: lief.PE.DATA_DIRECTORY) -> lief.PE.DataDirectory: ...
    def get_delay_import(self, import_name: str) -> lief.PE.DelayImport: ...
    def get_export(self) -> lief.PE.Export: ...
    def get_import(self, import_name: str) -> lief.PE.Import: ...
    def get_section(self, section_name: str) -> lief.PE.Section: ...
    def has_delay_import(self, import_name: str) -> bool: ...
    def has_import(self, import_name: str) -> bool: ...
    def predict_function_rva(self, library: str, function: str) -> int: ...
    def remove(self, section: lief.PE.Section, clear: bool = ...) -> None: ...
    def remove_all_libraries(self) -> None: ...
    def remove_all_relocations(self) -> None: ...
    def remove_library(self, import_name: str) -> None: ...
    def rva_to_offset(self, rva_address: int) -> int: ...
    def section_from_offset(self, offset: int) -> lief.PE.Section: ...
    def section_from_rva(self, rva: int) -> lief.PE.Section: ...
    def va_to_offset(self, va_address: int) -> int: ...
    @overload
    def verify_signature(self, checks: lief.PE.Signature.VERIFICATION_CHECKS = ...) -> lief.PE.Signature.VERIFICATION_FLAGS: ...
    @overload
    def verify_signature(self, signature: lief.PE.Signature, checks: lief.PE.Signature.VERIFICATION_CHECKS = ...) -> lief.PE.Signature.VERIFICATION_FLAGS: ...
    @overload
    def verify_signature(self, detached) -> lief.PE.Signature.VERIFICATION_FLAGS: ...
    def write(self, output_path: str) -> None: ...
    @property
    def authentihash_md5(self) -> bytes: ...
    @property
    def authentihash_sha1(self) -> bytes: ...
    @property
    def authentihash_sha256(self) -> bytes: ...
    @property
    def authentihash_sha512(self) -> bytes: ...
    @property
    def data_directories(self) -> lief.PE.Binary.it_data_directories: ...
    @property
    def debug(self) -> List[lief.PE.Debug]: ...
    @property
    def delay_imports(self) -> lief.PE.Binary.it_delay_imports: ...
    @property
    def dos_header(self) -> lief.PE.DosHeader: ...
    @property
    def exception_functions(self) -> List[lief.Function]: ...
    @property
    def functions(self) -> List[lief.Function]: ...
    @property
    def has_configuration(self) -> bool: ...
    @property
    def has_debug(self) -> bool: ...
    @property
    def has_delay_imports(self) -> bool: ...
    @property
    def has_exceptions(self) -> bool: ...
    @property
    def has_exports(self) -> bool: ...
    @property
    def has_imports(self) -> bool: ...
    @property
    def has_relocations(self) -> bool: ...
    @property
    def has_resources(self) -> bool: ...
    @property
    def has_rich_header(self) -> bool: ...
    @property
    def has_signatures(self) -> bool: ...
    @property
    def has_tls(self) -> bool: ...
    @property
    def header(self) -> lief.PE.Header: ...
    @property
    def imports(self) -> lief.PE.Binary.it_imports: ...
    @property
    def is_reproducible_build(self) -> bool: ...
    @property
    def load_configuration(self) -> lief.PE.LoadConfiguration: ...
    @property
    def optional_header(self) -> lief.PE.OptionalHeader: ...
    @property
    def overlay(self) -> memoryview: ...
    @property
    def relocations(self) -> lief.PE.Binary.it_relocations: ...
    @property
    def resources(self) -> lief.PE.ResourceNode: ...
    @property
    def resources_manager(self) -> object: ...
    @property
    def sections(self) -> lief.PE.Binary.it_section: ...
    @property
    def signatures(self) -> lief.PE.Binary.it_const_signatures: ...
    @property
    def sizeof_headers(self) -> int: ...
    @property
    def symbols(self) -> List[lief.PE.Symbol]: ...
    @property
    def virtual_size(self) -> int: ...

class Builder:
    def __init__(self, pe_binary: lief.PE.Binary) -> None: ...
    def build(self) -> object: ...
    def build_dos_stub(self, enable: bool = ...) -> lief.PE.Builder: ...
    def build_imports(self, enable: bool = ...) -> lief.PE.Builder: ...
    def build_overlay(self, enable: bool = ...) -> lief.PE.Builder: ...
    def build_relocations(self, enable: bool = ...) -> lief.PE.Builder: ...
    def build_resources(self, enable: bool = ...) -> lief.PE.Builder: ...
    def build_tls(self, enable: bool = ...) -> lief.PE.Builder: ...
    def get_build(self) -> List[int]: ...
    def patch_imports(self, enable: bool = ...) -> lief.PE.Builder: ...
    def write(self, output: str) -> None: ...

class CODE_PAGES:
    __members__: ClassVar[dict] = ...  # read-only
    ASMO_708: ClassVar[CODE_PAGES] = ...
    BIG5: ClassVar[CODE_PAGES] = ...
    CP1025: ClassVar[CODE_PAGES] = ...
    CP866: ClassVar[CODE_PAGES] = ...
    CP875: ClassVar[CODE_PAGES] = ...
    CSISO2022JP: ClassVar[CODE_PAGES] = ...
    DOS_720: ClassVar[CODE_PAGES] = ...
    DOS_862: ClassVar[CODE_PAGES] = ...
    EUC_CN: ClassVar[CODE_PAGES] = ...
    EUC_JP: ClassVar[CODE_PAGES] = ...
    EUC_JP_JIS: ClassVar[CODE_PAGES] = ...
    EUC_KR: ClassVar[CODE_PAGES] = ...
    GB18030: ClassVar[CODE_PAGES] = ...
    GB2312: ClassVar[CODE_PAGES] = ...
    HZ_GB_2312: ClassVar[CODE_PAGES] = ...
    IBM00858: ClassVar[CODE_PAGES] = ...
    IBM00924: ClassVar[CODE_PAGES] = ...
    IBM01047: ClassVar[CODE_PAGES] = ...
    IBM01140: ClassVar[CODE_PAGES] = ...
    IBM01141: ClassVar[CODE_PAGES] = ...
    IBM01142: ClassVar[CODE_PAGES] = ...
    IBM01143: ClassVar[CODE_PAGES] = ...
    IBM01144: ClassVar[CODE_PAGES] = ...
    IBM01145: ClassVar[CODE_PAGES] = ...
    IBM01146: ClassVar[CODE_PAGES] = ...
    IBM01147: ClassVar[CODE_PAGES] = ...
    IBM01148: ClassVar[CODE_PAGES] = ...
    IBM01149: ClassVar[CODE_PAGES] = ...
    IBM037: ClassVar[CODE_PAGES] = ...
    IBM1026: ClassVar[CODE_PAGES] = ...
    IBM273: ClassVar[CODE_PAGES] = ...
    IBM277: ClassVar[CODE_PAGES] = ...
    IBM278: ClassVar[CODE_PAGES] = ...
    IBM280: ClassVar[CODE_PAGES] = ...
    IBM284: ClassVar[CODE_PAGES] = ...
    IBM285: ClassVar[CODE_PAGES] = ...
    IBM290: ClassVar[CODE_PAGES] = ...
    IBM297: ClassVar[CODE_PAGES] = ...
    IBM420: ClassVar[CODE_PAGES] = ...
    IBM423: ClassVar[CODE_PAGES] = ...
    IBM424: ClassVar[CODE_PAGES] = ...
    IBM437: ClassVar[CODE_PAGES] = ...
    IBM500: ClassVar[CODE_PAGES] = ...
    IBM737: ClassVar[CODE_PAGES] = ...
    IBM775: ClassVar[CODE_PAGES] = ...
    IBM850: ClassVar[CODE_PAGES] = ...
    IBM852: ClassVar[CODE_PAGES] = ...
    IBM855: ClassVar[CODE_PAGES] = ...
    IBM857: ClassVar[CODE_PAGES] = ...
    IBM860: ClassVar[CODE_PAGES] = ...
    IBM861: ClassVar[CODE_PAGES] = ...
    IBM863: ClassVar[CODE_PAGES] = ...
    IBM864: ClassVar[CODE_PAGES] = ...
    IBM865: ClassVar[CODE_PAGES] = ...
    IBM869: ClassVar[CODE_PAGES] = ...
    IBM870: ClassVar[CODE_PAGES] = ...
    IBM871: ClassVar[CODE_PAGES] = ...
    IBM880: ClassVar[CODE_PAGES] = ...
    IBM905: ClassVar[CODE_PAGES] = ...
    IBM_THAI: ClassVar[CODE_PAGES] = ...
    ISO_2022_JP: ClassVar[CODE_PAGES] = ...
    ISO_2022_JP_JIS: ClassVar[CODE_PAGES] = ...
    ISO_2022_KR: ClassVar[CODE_PAGES] = ...
    ISO_8859_1: ClassVar[CODE_PAGES] = ...
    ISO_8859_13: ClassVar[CODE_PAGES] = ...
    ISO_8859_15: ClassVar[CODE_PAGES] = ...
    ISO_8859_2: ClassVar[CODE_PAGES] = ...
    ISO_8859_3: ClassVar[CODE_PAGES] = ...
    ISO_8859_4: ClassVar[CODE_PAGES] = ...
    ISO_8859_5: ClassVar[CODE_PAGES] = ...
    ISO_8859_6: ClassVar[CODE_PAGES] = ...
    ISO_8859_7: ClassVar[CODE_PAGES] = ...
    ISO_8859_8: ClassVar[CODE_PAGES] = ...
    ISO_8859_8_I: ClassVar[CODE_PAGES] = ...
    ISO_8859_9: ClassVar[CODE_PAGES] = ...
    JOHAB: ClassVar[CODE_PAGES] = ...
    KOI8_R: ClassVar[CODE_PAGES] = ...
    KOI8_U: ClassVar[CODE_PAGES] = ...
    KS_C_5601_1987: ClassVar[CODE_PAGES] = ...
    MACINTOSH: ClassVar[CODE_PAGES] = ...
    SHIFT_JIS: ClassVar[CODE_PAGES] = ...
    UNICODEFFFE: ClassVar[CODE_PAGES] = ...
    US_ASCII: ClassVar[CODE_PAGES] = ...
    UTF_16: ClassVar[CODE_PAGES] = ...
    UTF_32: ClassVar[CODE_PAGES] = ...
    UTF_32BE: ClassVar[CODE_PAGES] = ...
    UTF_7: ClassVar[CODE_PAGES] = ...
    UTF_8: ClassVar[CODE_PAGES] = ...
    WINDOWS_1250: ClassVar[CODE_PAGES] = ...
    WINDOWS_1251: ClassVar[CODE_PAGES] = ...
    WINDOWS_1252: ClassVar[CODE_PAGES] = ...
    WINDOWS_1253: ClassVar[CODE_PAGES] = ...
    WINDOWS_1254: ClassVar[CODE_PAGES] = ...
    WINDOWS_1255: ClassVar[CODE_PAGES] = ...
    WINDOWS_1256: ClassVar[CODE_PAGES] = ...
    WINDOWS_1257: ClassVar[CODE_PAGES] = ...
    WINDOWS_1258: ClassVar[CODE_PAGES] = ...
    WINDOWS_874: ClassVar[CODE_PAGES] = ...
    X_CHINESE_CNS: ClassVar[CODE_PAGES] = ...
    X_CHINESE_ETEN: ClassVar[CODE_PAGES] = ...
    X_CP20001: ClassVar[CODE_PAGES] = ...
    X_CP20003: ClassVar[CODE_PAGES] = ...
    X_CP20004: ClassVar[CODE_PAGES] = ...
    X_CP20005: ClassVar[CODE_PAGES] = ...
    X_CP20261: ClassVar[CODE_PAGES] = ...
    X_CP20269: ClassVar[CODE_PAGES] = ...
    X_CP20936: ClassVar[CODE_PAGES] = ...
    X_CP20949: ClassVar[CODE_PAGES] = ...
    X_CP50227: ClassVar[CODE_PAGES] = ...
    X_EBCDIC_KOREANEXTENDED: ClassVar[CODE_PAGES] = ...
    X_EUROPA: ClassVar[CODE_PAGES] = ...
    X_IA5: ClassVar[CODE_PAGES] = ...
    X_IA5_GERMAN: ClassVar[CODE_PAGES] = ...
    X_IA5_NORWEGIAN: ClassVar[CODE_PAGES] = ...
    X_IA5_SWEDISH: ClassVar[CODE_PAGES] = ...
    X_ISCII_AS: ClassVar[CODE_PAGES] = ...
    X_ISCII_BE: ClassVar[CODE_PAGES] = ...
    X_ISCII_DE: ClassVar[CODE_PAGES] = ...
    X_ISCII_GU: ClassVar[CODE_PAGES] = ...
    X_ISCII_KA: ClassVar[CODE_PAGES] = ...
    X_ISCII_MA: ClassVar[CODE_PAGES] = ...
    X_ISCII_OR: ClassVar[CODE_PAGES] = ...
    X_ISCII_PA: ClassVar[CODE_PAGES] = ...
    X_ISCII_TA: ClassVar[CODE_PAGES] = ...
    X_ISCII_TE: ClassVar[CODE_PAGES] = ...
    X_MAC_ARABIC: ClassVar[CODE_PAGES] = ...
    X_MAC_CE: ClassVar[CODE_PAGES] = ...
    X_MAC_CHINESESIMP: ClassVar[CODE_PAGES] = ...
    X_MAC_CHINESETRAD: ClassVar[CODE_PAGES] = ...
    X_MAC_CROATIAN: ClassVar[CODE_PAGES] = ...
    X_MAC_CYRILLIC: ClassVar[CODE_PAGES] = ...
    X_MAC_GREEK: ClassVar[CODE_PAGES] = ...
    X_MAC_HEBREW: ClassVar[CODE_PAGES] = ...
    X_MAC_ICELANDIC: ClassVar[CODE_PAGES] = ...
    X_MAC_JAPANESE: ClassVar[CODE_PAGES] = ...
    X_MAC_KOREAN: ClassVar[CODE_PAGES] = ...
    X_MAC_ROMANIAN: ClassVar[CODE_PAGES] = ...
    X_MAC_THAI: ClassVar[CODE_PAGES] = ...
    X_MAC_TURKISH: ClassVar[CODE_PAGES] = ...
    X_MAC_UKRAINIAN: ClassVar[CODE_PAGES] = ...
    __entries: ClassVar[dict] = ...
    def __init__(self, value: int) -> None: ...
    @property
    def name(self) -> str: ...
    @property
    def value(self) -> int: ...

class CODE_VIEW_SIGNATURES:
    __members__: ClassVar[dict] = ...  # read-only
    CV_41: ClassVar[CODE_VIEW_SIGNATURES] = ...
    CV_50: ClassVar[CODE_VIEW_SIGNATURES] = ...
    PDB_20: ClassVar[CODE_VIEW_SIGNATURES] = ...
    PDB_70: ClassVar[CODE_VIEW_SIGNATURES] = ...
    UNKNOWN: ClassVar[CODE_VIEW_SIGNATURES] = ...
    __entries: ClassVar[dict] = ...
    def __init__(self, value: int) -> None: ...
    @property
    def name(self) -> str: ...
    @property
    def value(self) -> int: ...

class CodeIntegrity(lief.Object):
    catalog: int
    catalog_offset: int
    flags: int
    reserved: int
    def __init__(self) -> None: ...

class CodeView(lief.Object):
    def __init__(self, *args, **kwargs) -> None: ...
    @property
    def cv_signature(self) -> lief.PE.CODE_VIEW_SIGNATURES: ...

class CodeViewPDB(CodeView):
    age: int
    filename: str
    signature: List[int]
    def __init__(self) -> None: ...

class ContentInfo(lief.Object):
    def __init__(self, *args, **kwargs) -> None: ...
    @property
    def content_type(self) -> str: ...
    @property
    def digest(self) -> bytes: ...
    @property
    def digest_algorithm(self) -> lief.PE.ALGORITHMS: ...

class ContentType(Attribute):
    def __init__(self, *args, **kwargs) -> None: ...
    @property
    def oid(self) -> str: ...

class DATA_DIRECTORY:
    __members__: ClassVar[dict] = ...  # read-only
    ARCHITECTURE: ClassVar[DATA_DIRECTORY] = ...
    BASE_RELOCATION_TABLE: ClassVar[DATA_DIRECTORY] = ...
    BOUND_IMPORT: ClassVar[DATA_DIRECTORY] = ...
    CERTIFICATE_TABLE: ClassVar[DATA_DIRECTORY] = ...
    CLR_RUNTIME_HEADER: ClassVar[DATA_DIRECTORY] = ...
    DEBUG: ClassVar[DATA_DIRECTORY] = ...
    DELAY_IMPORT_DESCRIPTOR: ClassVar[DATA_DIRECTORY] = ...
    EXCEPTION_TABLE: ClassVar[DATA_DIRECTORY] = ...
    EXPORT_TABLE: ClassVar[DATA_DIRECTORY] = ...
    GLOBAL_PTR: ClassVar[DATA_DIRECTORY] = ...
    IAT: ClassVar[DATA_DIRECTORY] = ...
    IMPORT_TABLE: ClassVar[DATA_DIRECTORY] = ...
    LOAD_CONFIG_TABLE: ClassVar[DATA_DIRECTORY] = ...
    RESERVED: ClassVar[DATA_DIRECTORY] = ...
    RESOURCE_TABLE: ClassVar[DATA_DIRECTORY] = ...
    TLS_TABLE: ClassVar[DATA_DIRECTORY] = ...
    __entries: ClassVar[dict] = ...
    def __init__(self, value: int) -> None: ...
    @property
    def name(self) -> str: ...
    @property
    def value(self) -> int: ...

class DEBUG_TYPES:
    __members__: ClassVar[dict] = ...  # read-only
    BORLAND: ClassVar[DEBUG_TYPES] = ...
    CLSID: ClassVar[DEBUG_TYPES] = ...
    CODEVIEW: ClassVar[DEBUG_TYPES] = ...
    COFF: ClassVar[DEBUG_TYPES] = ...
    EXCEPTION: ClassVar[DEBUG_TYPES] = ...
    EX_DLLCHARACTERISTICS: ClassVar[DEBUG_TYPES] = ...
    FIXUP: ClassVar[DEBUG_TYPES] = ...
    FPO: ClassVar[DEBUG_TYPES] = ...
    ILTCG: ClassVar[DEBUG_TYPES] = ...
    MISC: ClassVar[DEBUG_TYPES] = ...
    MPX: ClassVar[DEBUG_TYPES] = ...
    OMAP_FROM_SRC: ClassVar[DEBUG_TYPES] = ...
    OMAP_TO_SRC: ClassVar[DEBUG_TYPES] = ...
    POGO: ClassVar[DEBUG_TYPES] = ...
    REPRO: ClassVar[DEBUG_TYPES] = ...
    UNKNOWN: ClassVar[DEBUG_TYPES] = ...
    VC_FEATURE: ClassVar[DEBUG_TYPES] = ...
    __entries: ClassVar[dict] = ...
    def __init__(self, value: int) -> None: ...
    @property
    def name(self) -> str: ...
    @property
    def value(self) -> int: ...

class DIALOG_BOX_STYLES:
    __members__: ClassVar[dict] = ...  # read-only
    ABSALIGN: ClassVar[DIALOG_BOX_STYLES] = ...
    CENTER: ClassVar[DIALOG_BOX_STYLES] = ...
    CENTERMOUSE: ClassVar[DIALOG_BOX_STYLES] = ...
    CONTEXTHELP: ClassVar[DIALOG_BOX_STYLES] = ...
    CONTROL: ClassVar[DIALOG_BOX_STYLES] = ...
    D3DLOOK: ClassVar[DIALOG_BOX_STYLES] = ...
    FIXEDSYS: ClassVar[DIALOG_BOX_STYLES] = ...
    LOCALEDIT: ClassVar[DIALOG_BOX_STYLES] = ...
    MODALFRAME: ClassVar[DIALOG_BOX_STYLES] = ...
    NOFAILCREATE: ClassVar[DIALOG_BOX_STYLES] = ...
    NOIDLEMSG: ClassVar[DIALOG_BOX_STYLES] = ...
    SETFONT: ClassVar[DIALOG_BOX_STYLES] = ...
    SETFOREGROUND: ClassVar[DIALOG_BOX_STYLES] = ...
    SHELLFONT: ClassVar[DIALOG_BOX_STYLES] = ...
    SYSMODAL: ClassVar[DIALOG_BOX_STYLES] = ...
    __entries: ClassVar[dict] = ...
    def __init__(self, value: int) -> None: ...
    @property
    def name(self) -> str: ...
    @property
    def value(self) -> int: ...

class DLL_CHARACTERISTICS:
    __members__: ClassVar[dict] = ...  # read-only
    APPCONTAINER: ClassVar[DLL_CHARACTERISTICS] = ...
    DYNAMIC_BASE: ClassVar[DLL_CHARACTERISTICS] = ...
    FORCE_INTEGRITY: ClassVar[DLL_CHARACTERISTICS] = ...
    GUARD_CF: ClassVar[DLL_CHARACTERISTICS] = ...
    HIGH_ENTROPY_VA: ClassVar[DLL_CHARACTERISTICS] = ...
    NO_BIND: ClassVar[DLL_CHARACTERISTICS] = ...
    NO_ISOLATION: ClassVar[DLL_CHARACTERISTICS] = ...
    NO_SEH: ClassVar[DLL_CHARACTERISTICS] = ...
    NX_COMPAT: ClassVar[DLL_CHARACTERISTICS] = ...
    TERMINAL_SERVER_AWARE: ClassVar[DLL_CHARACTERISTICS] = ...
    WDM_DRIVER: ClassVar[DLL_CHARACTERISTICS] = ...
    __entries: ClassVar[dict] = ...
    def __init__(self, value: int) -> None: ...
    @property
    def name(self) -> str: ...
    @property
    def value(self) -> int: ...

class DataDirectory(lief.Object):
    rva: int
    size: int
    def __init__(self) -> None: ...
    @property
    def has_section(self) -> bool: ...
    @property
    def section(self) -> lief.PE.Section: ...
    @property
    def type(self) -> lief.PE.DATA_DIRECTORY: ...

class Debug(lief.Object):
    addressof_rawdata: int
    characteristics: int
    major_version: int
    minor_version: int
    pointerto_rawdata: int
    sizeof_data: int
    timestamp: int
    type: lief.PE.DEBUG_TYPES
    def __init__(self) -> None: ...
    @property
    def code_view(self) -> lief.PE.CodeView: ...
    @property
    def has_code_view(self) -> bool: ...
    @property
    def has_pogo(self) -> bool: ...
    @property
    def pogo(self) -> lief.PE.Pogo: ...

class DelayImport(lief.Object):
    class it_entries:
        def __init__(self, *args, **kwargs) -> None: ...
        def __getitem__(self, arg0: int) -> lief.PE.DelayImportEntry: ...
        def __iter__(self) -> Iterator: ...
        def __len__(self) -> int: ...
        def __next__(self) -> lief.PE.DelayImportEntry: ...
    attribute: int
    biat: int
    handle: int
    iat: int
    name: object
    names_table: int
    timestamp: int
    uiat: int
    def __init__(self, library_name: str) -> None: ...
    @property
    def entries(self) -> lief.PE.DelayImport.it_entries: ...

class DelayImportEntry(lief.Symbol):
    data: int
    name: object
    def __init__(self) -> None: ...
    @property
    def hint(self) -> int: ...
    @property
    def iat_value(self) -> int: ...
    @property
    def is_ordinal(self) -> bool: ...
    @property
    def ordinal(self) -> int: ...

class DictStringVersion:
    def __init__(self) -> None: ...
    def items(self) -> Any: ...
    def keys(self) -> Any: ...
    def values(self) -> Any: ...
    def __bool__(self) -> bool: ...
    @overload
    def __contains__(self, arg0: str) -> bool: ...
    @overload
    def __contains__(self, arg0: object) -> bool: ...
    def __delitem__(self, arg0: str) -> None: ...
    def __getitem__(self, arg0: str) -> str: ...
    def __iter__(self) -> Iterator: ...
    def __len__(self) -> int: ...
    def __setitem__(self, arg0: str, arg1: str) -> None: ...

class DosHeader(lief.Object):
    addressof_new_exeheader: int
    addressof_relocation_table: int
    checksum: int
    file_size_in_pages: int
    header_size_in_paragraphs: int
    initial_ip: int
    initial_relative_cs: int
    initial_relative_ss: int
    initial_sp: int
    magic: int
    maximum_extra_paragraphs: int
    minimum_extra_paragraphs: int
    numberof_relocation: int
    oem_id: int
    oem_info: int
    overlay_number: int
    used_bytes_in_the_last_page: int
    def __init__(self) -> None: ...

class EXTENDED_WINDOW_STYLES:
    __members__: ClassVar[dict] = ...  # read-only
    ACCEPTFILES: ClassVar[EXTENDED_WINDOW_STYLES] = ...
    APPWINDOW: ClassVar[EXTENDED_WINDOW_STYLES] = ...
    CLIENTEDGE: ClassVar[EXTENDED_WINDOW_STYLES] = ...
    CONTEXTHELP: ClassVar[EXTENDED_WINDOW_STYLES] = ...
    CONTROLPARENT: ClassVar[EXTENDED_WINDOW_STYLES] = ...
    DLGMODALFRAME: ClassVar[EXTENDED_WINDOW_STYLES] = ...
    LEFT: ClassVar[EXTENDED_WINDOW_STYLES] = ...
    LEFTSCROLLBAR: ClassVar[EXTENDED_WINDOW_STYLES] = ...
    LTRREADING: ClassVar[EXTENDED_WINDOW_STYLES] = ...
    MDICHILD: ClassVar[EXTENDED_WINDOW_STYLES] = ...
    NOPARENTNOTIFY: ClassVar[EXTENDED_WINDOW_STYLES] = ...
    RIGHT: ClassVar[EXTENDED_WINDOW_STYLES] = ...
    RIGHTSCROLLBAR: ClassVar[EXTENDED_WINDOW_STYLES] = ...
    RTLREADING: ClassVar[EXTENDED_WINDOW_STYLES] = ...
    STATICEDGE: ClassVar[EXTENDED_WINDOW_STYLES] = ...
    TOOLWINDOW: ClassVar[EXTENDED_WINDOW_STYLES] = ...
    TOPMOST: ClassVar[EXTENDED_WINDOW_STYLES] = ...
    TRANSPARENT: ClassVar[EXTENDED_WINDOW_STYLES] = ...
    WINDOWEDGE: ClassVar[EXTENDED_WINDOW_STYLES] = ...
    __entries: ClassVar[dict] = ...
    def __init__(self, value: int) -> None: ...
    @property
    def name(self) -> str: ...
    @property
    def value(self) -> int: ...

class Export(lief.Object):
    class it_entries:
        def __init__(self, *args, **kwargs) -> None: ...
        def __getitem__(self, arg0: int) -> lief.PE.ExportEntry: ...
        def __iter__(self) -> Iterator: ...
        def __len__(self) -> int: ...
        def __next__(self) -> lief.PE.ExportEntry: ...
    export_flags: int
    major_version: int
    minor_version: int
    name: object
    ordinal_base: int
    timestamp: int
    def __init__(self) -> None: ...
    @property
    def entries(self) -> lief.PE.Export.it_entries: ...

class ExportEntry(lief.Symbol):
    class forward_information_t:
        function: str
        library: str
        def __init__(self, *args, **kwargs) -> None: ...
    address: int
    is_extern: bool
    name: object
    ordinal: int
    def __init__(self) -> None: ...
    @property
    def forward_information(self) -> lief.PE.ExportEntry.forward_information_t: ...
    @property
    def function_rva(self) -> int: ...
    @property
    def is_forwarded(self) -> bool: ...

class FIXED_VERSION_FILE_FLAGS:
    __members__: ClassVar[dict] = ...  # read-only
    DEBUG: ClassVar[FIXED_VERSION_FILE_FLAGS] = ...
    INFOINFERRED: ClassVar[FIXED_VERSION_FILE_FLAGS] = ...
    PATCHED: ClassVar[FIXED_VERSION_FILE_FLAGS] = ...
    PRERELEASE: ClassVar[FIXED_VERSION_FILE_FLAGS] = ...
    PRIVATEBUILD: ClassVar[FIXED_VERSION_FILE_FLAGS] = ...
    SPECIALBUILD: ClassVar[FIXED_VERSION_FILE_FLAGS] = ...
    __entries: ClassVar[dict] = ...
    def __init__(self, value: int) -> None: ...
    @property
    def name(self) -> str: ...
    @property
    def value(self) -> int: ...

class FIXED_VERSION_FILE_SUB_TYPES:
    __members__: ClassVar[dict] = ...  # read-only
    DRV_COMM: ClassVar[FIXED_VERSION_FILE_SUB_TYPES] = ...
    DRV_DISPLAY: ClassVar[FIXED_VERSION_FILE_SUB_TYPES] = ...
    DRV_INSTALLABLE: ClassVar[FIXED_VERSION_FILE_SUB_TYPES] = ...
    DRV_KEYBOARD: ClassVar[FIXED_VERSION_FILE_SUB_TYPES] = ...
    DRV_LANGUAGE: ClassVar[FIXED_VERSION_FILE_SUB_TYPES] = ...
    DRV_MOUSE: ClassVar[FIXED_VERSION_FILE_SUB_TYPES] = ...
    DRV_NETWORK: ClassVar[FIXED_VERSION_FILE_SUB_TYPES] = ...
    DRV_PRINTER: ClassVar[FIXED_VERSION_FILE_SUB_TYPES] = ...
    DRV_SOUND: ClassVar[FIXED_VERSION_FILE_SUB_TYPES] = ...
    DRV_SYSTEM: ClassVar[FIXED_VERSION_FILE_SUB_TYPES] = ...
    DRV_VERSIONED_PRINTER: ClassVar[FIXED_VERSION_FILE_SUB_TYPES] = ...
    FONT_RASTER: ClassVar[FIXED_VERSION_FILE_SUB_TYPES] = ...
    FONT_TRUETYPE: ClassVar[FIXED_VERSION_FILE_SUB_TYPES] = ...
    FONT_VECTOR: ClassVar[FIXED_VERSION_FILE_SUB_TYPES] = ...
    UNKNOWN: ClassVar[FIXED_VERSION_FILE_SUB_TYPES] = ...
    __entries: ClassVar[dict] = ...
    def __init__(self, value: int) -> None: ...
    @property
    def name(self) -> str: ...
    @property
    def value(self) -> int: ...

class FIXED_VERSION_FILE_TYPES:
    __members__: ClassVar[dict] = ...  # read-only
    APP: ClassVar[FIXED_VERSION_FILE_TYPES] = ...
    DLL: ClassVar[FIXED_VERSION_FILE_TYPES] = ...
    DRV: ClassVar[FIXED_VERSION_FILE_TYPES] = ...
    FONT: ClassVar[FIXED_VERSION_FILE_TYPES] = ...
    STATIC_LIB: ClassVar[FIXED_VERSION_FILE_TYPES] = ...
    UNKNOWN: ClassVar[FIXED_VERSION_FILE_TYPES] = ...
    VXD: ClassVar[FIXED_VERSION_FILE_TYPES] = ...
    __entries: ClassVar[dict] = ...
    def __init__(self, value: int) -> None: ...
    @property
    def name(self) -> str: ...
    @property
    def value(self) -> int: ...

class FIXED_VERSION_OS:
    __members__: ClassVar[dict] = ...  # read-only
    DOS: ClassVar[FIXED_VERSION_OS] = ...
    DOS_WINDOWS16: ClassVar[FIXED_VERSION_OS] = ...
    DOS_WINDOWS32: ClassVar[FIXED_VERSION_OS] = ...
    NT: ClassVar[FIXED_VERSION_OS] = ...
    NT_WINDOWS32: ClassVar[FIXED_VERSION_OS] = ...
    OS216: ClassVar[FIXED_VERSION_OS] = ...
    OS216_PM16: ClassVar[FIXED_VERSION_OS] = ...
    OS232: ClassVar[FIXED_VERSION_OS] = ...
    OS232_PM32: ClassVar[FIXED_VERSION_OS] = ...
    PM16: ClassVar[FIXED_VERSION_OS] = ...
    PM32: ClassVar[FIXED_VERSION_OS] = ...
    UNKNOWN: ClassVar[FIXED_VERSION_OS] = ...
    WINDOWS16: ClassVar[FIXED_VERSION_OS] = ...
    WINDOWS32: ClassVar[FIXED_VERSION_OS] = ...
    __entries: ClassVar[dict] = ...
    def __init__(self, value: int) -> None: ...
    @property
    def name(self) -> str: ...
    @property
    def value(self) -> int: ...

class GUARD_CF_FLAGS:
    __members__: ClassVar[dict] = ...  # read-only
    GCF_ENABLE_EXPORT_SUPPRESSION: ClassVar[GUARD_CF_FLAGS] = ...
    GCF_EXPORT_SUPPRESSION_INFO_PRESENT: ClassVar[GUARD_CF_FLAGS] = ...
    GCF_FUNCTION_TABLE_PRESENT: ClassVar[GUARD_CF_FLAGS] = ...
    GCF_INSTRUMENTED: ClassVar[GUARD_CF_FLAGS] = ...
    GCF_LONGJUMP_TABLE_PRESENT: ClassVar[GUARD_CF_FLAGS] = ...
    GCF_NONE: ClassVar[GUARD_CF_FLAGS] = ...
    GCF_W_INSTRUMENTED: ClassVar[GUARD_CF_FLAGS] = ...
    GRF_ENABLE: ClassVar[GUARD_CF_FLAGS] = ...
    GRF_INSTRUMENTED: ClassVar[GUARD_CF_FLAGS] = ...
    GRF_STRICT: ClassVar[GUARD_CF_FLAGS] = ...
    __entries: ClassVar[dict] = ...
    def __init__(self, value: int) -> None: ...
    @property
    def name(self) -> str: ...
    @property
    def value(self) -> int: ...

class GenericType(Attribute):
    def __init__(self, *args, **kwargs) -> None: ...
    @property
    def oid(self) -> str: ...
    @property
    def raw_content(self) -> bytes: ...

class HEADER_CHARACTERISTICS:
    __members__: ClassVar[dict] = ...  # read-only
    AGGRESSIVE_WS_TRIM: ClassVar[HEADER_CHARACTERISTICS] = ...
    BYTES_REVERSED_HI: ClassVar[HEADER_CHARACTERISTICS] = ...
    BYTES_REVERSED_LO: ClassVar[HEADER_CHARACTERISTICS] = ...
    CHARA_32BIT_MACHINE: ClassVar[HEADER_CHARACTERISTICS] = ...
    DEBUG_STRIPPED: ClassVar[HEADER_CHARACTERISTICS] = ...
    DLL: ClassVar[HEADER_CHARACTERISTICS] = ...
    EXECUTABLE_IMAGE: ClassVar[HEADER_CHARACTERISTICS] = ...
    LARGE_ADDRESS_AWARE: ClassVar[HEADER_CHARACTERISTICS] = ...
    LINE_NUMS_STRIPPED: ClassVar[HEADER_CHARACTERISTICS] = ...
    LOCAL_SYMS_STRIPPED: ClassVar[HEADER_CHARACTERISTICS] = ...
    NET_RUN_FROM_SWAP: ClassVar[HEADER_CHARACTERISTICS] = ...
    RELOCS_STRIPPED: ClassVar[HEADER_CHARACTERISTICS] = ...
    REMOVABLE_RUN_FROM_SWAP: ClassVar[HEADER_CHARACTERISTICS] = ...
    SYSTEM: ClassVar[HEADER_CHARACTERISTICS] = ...
    UP_SYSTEM_ONLY: ClassVar[HEADER_CHARACTERISTICS] = ...
    __entries: ClassVar[dict] = ...
    def __init__(self, value: int) -> None: ...
    @property
    def name(self) -> str: ...
    @property
    def value(self) -> int: ...

class Header(lief.Object):
    characteristics: lief.PE.HEADER_CHARACTERISTICS
    machine: lief.PE.MACHINE_TYPES
    numberof_sections: int
    numberof_symbols: int
    pointerto_symbol_table: int
    signature: List[int]
    sizeof_optional_header: int
    time_date_stamps: int
    def __init__(self) -> None: ...
    def add_characteristic(self, characteristic: lief.PE.HEADER_CHARACTERISTICS) -> None: ...
    def has_characteristic(self, characteristic: lief.PE.HEADER_CHARACTERISTICS) -> bool: ...
    def remove_characteristic(self, characteristic: lief.PE.HEADER_CHARACTERISTICS) -> None: ...
    @property
    def characteristics_list(self) -> Set[lief.PE.HEADER_CHARACTERISTICS]: ...

class IMPHASH_MODE:
    __members__: ClassVar[dict] = ...  # read-only
    DEFAULT: ClassVar[IMPHASH_MODE] = ...
    LIEF: ClassVar[IMPHASH_MODE] = ...
    PEFILE: ClassVar[IMPHASH_MODE] = ...
    VT: ClassVar[IMPHASH_MODE] = ...
    __entries: ClassVar[dict] = ...
    def __init__(self, value: int) -> None: ...
    @property
    def name(self) -> str: ...
    @property
    def value(self) -> int: ...

class Import(lief.Object):
    class it_entries:
        def __init__(self, *args, **kwargs) -> None: ...
        def __getitem__(self, arg0: int) -> lief.PE.ImportEntry: ...
        def __iter__(self) -> Iterator: ...
        def __len__(self) -> int: ...
        def __next__(self) -> lief.PE.ImportEntry: ...
    import_address_table_rva: int
    import_lookup_table_rva: int
    name: object
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, library_name: str) -> None: ...
    @overload
    def add_entry(self, entry: lief.PE.ImportEntry) -> lief.PE.ImportEntry: ...
    @overload
    def add_entry(self, function_name: str) -> lief.PE.ImportEntry: ...
    def get_entry(self, function_name: str) -> lief.PE.ImportEntry: ...
    def get_function_rva_from_iat(self, function_name: str) -> object: ...
    @property
    def directory(self) -> lief.PE.DataDirectory: ...
    @property
    def entries(self) -> lief.PE.Import.it_entries: ...
    @property
    def forwarder_chain(self) -> int: ...
    @property
    def iat_directory(self) -> lief.PE.DataDirectory: ...
    @property
    def timedatestamp(self) -> int: ...

class ImportEntry(lief.Symbol):
    data: int
    name: object
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, import_name: str) -> None: ...
    @overload
    def __init__(self, data: int, name: str = ...) -> None: ...
    @overload
    def __init__(self, data: int, type: lief.PE.PE_TYPE, name: str = ...) -> None: ...
    @overload
    def __init__(self, name: str, type: lief.PE.PE_TYPE) -> None: ...
    @property
    def hint(self) -> int: ...
    @property
    def iat_address(self) -> int: ...
    @property
    def iat_value(self) -> int: ...
    @property
    def is_ordinal(self) -> bool: ...
    @property
    def ordinal(self) -> int: ...

class LangCodeItem(lief.Object):
    code_page: lief.PE.CODE_PAGES
    items: dict
    key: str
    lang: lief.PE.RESOURCE_LANGS
    sublang: lief.PE.RESOURCE_SUBLANGS
    type: int
    def __init__(self, *args, **kwargs) -> None: ...

class ListLangCodeItem:
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, arg0: lief.PE.ListLangCodeItem) -> None: ...
    @overload
    def __init__(self, arg0: Iterable) -> None: ...
    def append(self, x: lief.PE.LangCodeItem) -> None: ...
    def clear(self) -> None: ...
    def count(self, x: lief.PE.LangCodeItem) -> int: ...
    @overload
    def extend(self, L: lief.PE.ListLangCodeItem) -> None: ...
    @overload
    def extend(self, L: Iterable) -> None: ...
    def insert(self, i: int, x: lief.PE.LangCodeItem) -> None: ...
    @overload
    def pop(self) -> lief.PE.LangCodeItem: ...
    @overload
    def pop(self, i: int) -> lief.PE.LangCodeItem: ...
    def remove(self, x: lief.PE.LangCodeItem) -> None: ...
    def __bool__(self) -> bool: ...
    def __contains__(self, x: lief.PE.LangCodeItem) -> bool: ...
    @overload
    def __delitem__(self, arg0: int) -> None: ...
    @overload
    def __delitem__(self, arg0: slice) -> None: ...
    @overload
    def __getitem__(self, s: slice) -> lief.PE.ListLangCodeItem: ...
    @overload
    def __getitem__(self, arg0: int) -> lief.PE.LangCodeItem: ...
    def __iter__(self) -> Iterator: ...
    def __len__(self) -> int: ...
    @overload
    def __setitem__(self, arg0: int, arg1: lief.PE.LangCodeItem) -> None: ...
    @overload
    def __setitem__(self, arg0: slice, arg1: lief.PE.ListLangCodeItem) -> None: ...

class LoadConfiguration(lief.Object):
    characteristics: int
    critical_section_default_timeout: int
    csd_version: int
    decommit_free_block_threshold: int
    decommit_total_free_threshold: int
    dependent_load_flags: int
    editlist: int
    global_flags_clear: int
    global_flags_set: int
    lock_prefix_table: int
    major_version: int
    maximum_allocation_size: int
    minor_version: int
    process_affinity_mask: int
    process_heap_flags: int
    reserved1: int
    security_cookie: int
    timedatestamp: int
    virtual_memory_threshold: int
    def __init__(self) -> None: ...
    @property
    def size(self) -> int: ...
    @property
    def version(self) -> Any: ...

class LoadConfigurationV0(LoadConfiguration):
    se_handler_count: int
    se_handler_table: int
    def __init__(self) -> None: ...

class LoadConfigurationV1(LoadConfigurationV0):
    guard_cf_check_function_pointer: int
    guard_cf_dispatch_function_pointer: int
    guard_cf_function_count: int
    guard_cf_function_table: int
    guard_flags: lief.PE.GUARD_CF_FLAGS
    def __init__(self) -> None: ...
    def has(self, flag: lief.PE.GUARD_CF_FLAGS) -> bool: ...
    def __contains__(self, arg0: lief.PE.GUARD_CF_FLAGS) -> bool: ...
    @property
    def guard_cf_flags_list(self) -> Set[lief.PE.GUARD_CF_FLAGS]: ...

class LoadConfigurationV10(LoadConfigurationV9):
    guard_xfg_check_function_pointer: int
    guard_xfg_dispatch_function_pointer: int
    guard_xfg_table_dispatch_function_pointer: int
    def __init__(self) -> None: ...

class LoadConfigurationV11(LoadConfigurationV10):
    cast_guard_os_determined_failure_mode: int
    def __init__(self) -> None: ...

class LoadConfigurationV2(LoadConfigurationV1):
    def __init__(self) -> None: ...
    @property
    def code_integrity(self) -> lief.PE.CodeIntegrity: ...

class LoadConfigurationV3(LoadConfigurationV2):
    guard_address_taken_iat_entry_count: int
    guard_address_taken_iat_entry_table: int
    guard_long_jump_target_count: int
    guard_long_jump_target_table: int
    def __init__(self) -> None: ...

class LoadConfigurationV4(LoadConfigurationV3):
    dynamic_value_reloc_table: int
    hybrid_metadata_pointer: int
    def __init__(self) -> None: ...

class LoadConfigurationV5(LoadConfigurationV4):
    dynamic_value_reloctable_offset: int
    dynamic_value_reloctable_section: int
    guard_rf_failure_routine: int
    guard_rf_failure_routine_function_pointer: int
    reserved2: int
    def __init__(self) -> None: ...

class LoadConfigurationV6(LoadConfigurationV5):
    guard_rf_verify_stackpointer_function_pointer: int
    hotpatch_table_offset: int
    def __init__(self) -> None: ...

class LoadConfigurationV7(LoadConfigurationV6):
    addressof_unicode_string: int
    reserved3: int
    def __init__(self) -> None: ...

class LoadConfigurationV8(LoadConfigurationV7):
    volatile_metadata_pointer: int
    def __init__(self) -> None: ...

class LoadConfigurationV9(LoadConfigurationV8):
    guard_eh_continuation_count: int
    guard_eh_continuation_table: int
    def __init__(self) -> None: ...

class MACHINE_TYPES:
    __members__: ClassVar[dict] = ...  # read-only
    AM33: ClassVar[MACHINE_TYPES] = ...
    AMD64: ClassVar[MACHINE_TYPES] = ...
    ARM: ClassVar[MACHINE_TYPES] = ...
    ARM64: ClassVar[MACHINE_TYPES] = ...
    ARMNT: ClassVar[MACHINE_TYPES] = ...
    EBC: ClassVar[MACHINE_TYPES] = ...
    I386: ClassVar[MACHINE_TYPES] = ...
    IA64: ClassVar[MACHINE_TYPES] = ...
    INVALID: ClassVar[MACHINE_TYPES] = ...
    M32R: ClassVar[MACHINE_TYPES] = ...
    MIPS16: ClassVar[MACHINE_TYPES] = ...
    MIPSFPU: ClassVar[MACHINE_TYPES] = ...
    MIPSFPU16: ClassVar[MACHINE_TYPES] = ...
    POWERPC: ClassVar[MACHINE_TYPES] = ...
    POWERPCFP: ClassVar[MACHINE_TYPES] = ...
    R4000: ClassVar[MACHINE_TYPES] = ...
    SH3: ClassVar[MACHINE_TYPES] = ...
    SH3DSP: ClassVar[MACHINE_TYPES] = ...
    SH4: ClassVar[MACHINE_TYPES] = ...
    SH5: ClassVar[MACHINE_TYPES] = ...
    THUMB: ClassVar[MACHINE_TYPES] = ...
    UNKNOWN: ClassVar[MACHINE_TYPES] = ...
    WCEMIPSV2: ClassVar[MACHINE_TYPES] = ...
    __entries: ClassVar[dict] = ...
    def __init__(self, value: int) -> None: ...
    @property
    def name(self) -> str: ...
    @property
    def value(self) -> int: ...

class MsSpcNestedSignature(Attribute):
    def __init__(self, *args, **kwargs) -> None: ...
    @property
    def signature(self) -> lief.PE.Signature: ...

class MsSpcStatementType(Attribute):
    def __init__(self, *args, **kwargs) -> None: ...
    @property
    def oid(self) -> str: ...

class OptionalHeader(lief.Object):
    addressof_entrypoint: int
    baseof_code: int
    baseof_data: int
    checksum: int
    dll_characteristics: int
    file_alignment: int
    imagebase: int
    loader_flags: int
    magic: lief.PE.PE_TYPE
    major_image_version: int
    major_linker_version: int
    major_operating_system_version: int
    major_subsystem_version: int
    minor_image_version: int
    minor_linker_version: int
    minor_operating_system_version: int
    minor_subsystem_version: int
    numberof_rva_and_size: int
    section_alignment: int
    sizeof_code: int
    sizeof_headers: int
    sizeof_heap_commit: int
    sizeof_heap_reserve: int
    sizeof_image: int
    sizeof_initialized_data: int
    sizeof_stack_commit: int
    sizeof_stack_reserve: int
    sizeof_uninitialized_data: int
    subsystem: Any
    win32_version_value: int
    def __init__(self) -> None: ...
    def add(self, characteristic: lief.PE.DLL_CHARACTERISTICS) -> None: ...
    def has(self, characteristics: lief.PE.DLL_CHARACTERISTICS) -> bool: ...
    def remove(self, characteristic: lief.PE.DLL_CHARACTERISTICS) -> None: ...
    def __contains__(self, arg0: lief.PE.DLL_CHARACTERISTICS) -> bool: ...
    def __iadd__(self, arg0: lief.PE.DLL_CHARACTERISTICS) -> lief.PE.OptionalHeader: ...
    def __isub__(self, arg0: lief.PE.DLL_CHARACTERISTICS) -> lief.PE.OptionalHeader: ...
    @property
    def computed_checksum(self) -> int: ...
    @property
    def dll_characteristics_lists(self) -> Set[lief.PE.DLL_CHARACTERISTICS]: ...

class PE_TYPE:
    __members__: ClassVar[dict] = ...  # read-only
    PE32: ClassVar[PE_TYPE] = ...
    PE32_PLUS: ClassVar[PE_TYPE] = ...
    __entries: ClassVar[dict] = ...
    def __init__(self, value: int) -> None: ...
    @property
    def name(self) -> str: ...
    @property
    def value(self) -> int: ...

class PKCS9AtSequenceNumber(Attribute):
    def __init__(self, *args, **kwargs) -> None: ...
    @property
    def number(self) -> int: ...

class PKCS9CounterSignature(Attribute):
    def __init__(self, *args, **kwargs) -> None: ...
    @property
    def signer(self) -> lief.PE.SignerInfo: ...

class PKCS9MessageDigest(Attribute):
    def __init__(self, *args, **kwargs) -> None: ...
    @property
    def digest(self) -> object: ...

class PKCS9SigningTime(Attribute):
    def __init__(self, *args, **kwargs) -> None: ...
    @property
    def time(self) -> List[int]: ...

class POGO_SIGNATURES:
    __members__: ClassVar[dict] = ...  # read-only
    LCTG: ClassVar[POGO_SIGNATURES] = ...
    PGI: ClassVar[POGO_SIGNATURES] = ...
    UNKNOWN: ClassVar[POGO_SIGNATURES] = ...
    __entries: ClassVar[dict] = ...
    def __init__(self, value: int) -> None: ...
    @property
    def name(self) -> str: ...
    @property
    def value(self) -> int: ...

class Pogo(lief.Object):
    class it_entries:
        def __init__(self, *args, **kwargs) -> None: ...
        def __getitem__(self, arg0: int) -> lief.PE.PogoEntry: ...
        def __iter__(self) -> Iterator: ...
        def __len__(self) -> int: ...
        def __next__(self) -> lief.PE.PogoEntry: ...
    def __init__(self) -> None: ...
    @property
    def entries(self) -> lief.PE.Pogo.it_entries: ...
    @property
    def signature(self) -> lief.PE.POGO_SIGNATURES: ...

class PogoEntry(lief.Object):
    name: object
    size: int
    start_rva: int
    def __init__(self) -> None: ...

class RELOCATIONS_BASE_TYPES:
    __members__: ClassVar[dict] = ...  # read-only
    ABSOLUTE: ClassVar[RELOCATIONS_BASE_TYPES] = ...
    ARM_MOV32: ClassVar[RELOCATIONS_BASE_TYPES] = ...
    ARM_MOV32A: ClassVar[RELOCATIONS_BASE_TYPES] = ...
    ARM_MOV32T: ClassVar[RELOCATIONS_BASE_TYPES] = ...
    DIR64: ClassVar[RELOCATIONS_BASE_TYPES] = ...
    HIGH: ClassVar[RELOCATIONS_BASE_TYPES] = ...
    HIGH3ADJ: ClassVar[RELOCATIONS_BASE_TYPES] = ...
    HIGHADJ: ClassVar[RELOCATIONS_BASE_TYPES] = ...
    HIGHLOW: ClassVar[RELOCATIONS_BASE_TYPES] = ...
    IA64_IMM64: ClassVar[RELOCATIONS_BASE_TYPES] = ...
    LOW: ClassVar[RELOCATIONS_BASE_TYPES] = ...
    MIPS_JMPADDR: ClassVar[RELOCATIONS_BASE_TYPES] = ...
    MIPS_JMPADDR16: ClassVar[RELOCATIONS_BASE_TYPES] = ...
    REL: ClassVar[RELOCATIONS_BASE_TYPES] = ...
    RISCV_HI20: ClassVar[RELOCATIONS_BASE_TYPES] = ...
    RISCV_LOW12I: ClassVar[RELOCATIONS_BASE_TYPES] = ...
    RISCV_LOW12S: ClassVar[RELOCATIONS_BASE_TYPES] = ...
    SECTION: ClassVar[RELOCATIONS_BASE_TYPES] = ...
    THUMB_MOV32: ClassVar[RELOCATIONS_BASE_TYPES] = ...
    __entries: ClassVar[dict] = ...
    def __init__(self, value: int) -> None: ...
    @property
    def name(self) -> str: ...
    @property
    def value(self) -> int: ...

class RESOURCE_LANGS:
    __members__: ClassVar[dict] = ...  # read-only
    AFRIKAANS: ClassVar[RESOURCE_LANGS] = ...
    ALBANIAN: ClassVar[RESOURCE_LANGS] = ...
    ARABIC: ClassVar[RESOURCE_LANGS] = ...
    ARMENIAN: ClassVar[RESOURCE_LANGS] = ...
    ASSAMESE: ClassVar[RESOURCE_LANGS] = ...
    AZERI: ClassVar[RESOURCE_LANGS] = ...
    BANGLA: ClassVar[RESOURCE_LANGS] = ...
    BASQUE: ClassVar[RESOURCE_LANGS] = ...
    BELARUSIAN: ClassVar[RESOURCE_LANGS] = ...
    BOSNIAN: ClassVar[RESOURCE_LANGS] = ...
    BRETON: ClassVar[RESOURCE_LANGS] = ...
    BULGARIAN: ClassVar[RESOURCE_LANGS] = ...
    CATALAN: ClassVar[RESOURCE_LANGS] = ...
    CHINESE: ClassVar[RESOURCE_LANGS] = ...
    CORNISH: ClassVar[RESOURCE_LANGS] = ...
    CROATIAN: ClassVar[RESOURCE_LANGS] = ...
    CZECH: ClassVar[RESOURCE_LANGS] = ...
    DANISH: ClassVar[RESOURCE_LANGS] = ...
    DIVEHI: ClassVar[RESOURCE_LANGS] = ...
    DUTCH: ClassVar[RESOURCE_LANGS] = ...
    ENGLISH: ClassVar[RESOURCE_LANGS] = ...
    ESPERANTO: ClassVar[RESOURCE_LANGS] = ...
    ESTONIAN: ClassVar[RESOURCE_LANGS] = ...
    FAEROESE: ClassVar[RESOURCE_LANGS] = ...
    FARSI: ClassVar[RESOURCE_LANGS] = ...
    FINNISH: ClassVar[RESOURCE_LANGS] = ...
    FRENCH: ClassVar[RESOURCE_LANGS] = ...
    GAELIC: ClassVar[RESOURCE_LANGS] = ...
    GALICIAN: ClassVar[RESOURCE_LANGS] = ...
    GEORGIAN: ClassVar[RESOURCE_LANGS] = ...
    GERMAN: ClassVar[RESOURCE_LANGS] = ...
    GREEK: ClassVar[RESOURCE_LANGS] = ...
    GUJARATI: ClassVar[RESOURCE_LANGS] = ...
    HEBREW: ClassVar[RESOURCE_LANGS] = ...
    HINDI: ClassVar[RESOURCE_LANGS] = ...
    HUNGARIAN: ClassVar[RESOURCE_LANGS] = ...
    ICELANDIC: ClassVar[RESOURCE_LANGS] = ...
    INDONESIAN: ClassVar[RESOURCE_LANGS] = ...
    INUKTITUT: ClassVar[RESOURCE_LANGS] = ...
    INVARIANT: ClassVar[RESOURCE_LANGS] = ...
    IRISH: ClassVar[RESOURCE_LANGS] = ...
    ITALIAN: ClassVar[RESOURCE_LANGS] = ...
    JAPANESE: ClassVar[RESOURCE_LANGS] = ...
    KANNADA: ClassVar[RESOURCE_LANGS] = ...
    KASHMIRI: ClassVar[RESOURCE_LANGS] = ...
    KAZAK: ClassVar[RESOURCE_LANGS] = ...
    KONKANI: ClassVar[RESOURCE_LANGS] = ...
    KOREAN: ClassVar[RESOURCE_LANGS] = ...
    KYRGYZ: ClassVar[RESOURCE_LANGS] = ...
    LATVIAN: ClassVar[RESOURCE_LANGS] = ...
    LITHUANIAN: ClassVar[RESOURCE_LANGS] = ...
    LOWER_SORBIAN: ClassVar[RESOURCE_LANGS] = ...
    MACEDONIAN: ClassVar[RESOURCE_LANGS] = ...
    MALAY: ClassVar[RESOURCE_LANGS] = ...
    MALAYALAM: ClassVar[RESOURCE_LANGS] = ...
    MALTESE: ClassVar[RESOURCE_LANGS] = ...
    MANIPURI: ClassVar[RESOURCE_LANGS] = ...
    MAORI: ClassVar[RESOURCE_LANGS] = ...
    MARATHI: ClassVar[RESOURCE_LANGS] = ...
    MONGOLIAN: ClassVar[RESOURCE_LANGS] = ...
    NEPALI: ClassVar[RESOURCE_LANGS] = ...
    NEUTRAL: ClassVar[RESOURCE_LANGS] = ...
    NORWEGIAN: ClassVar[RESOURCE_LANGS] = ...
    ORIYA: ClassVar[RESOURCE_LANGS] = ...
    POLISH: ClassVar[RESOURCE_LANGS] = ...
    PORTUGUESE: ClassVar[RESOURCE_LANGS] = ...
    PULAR: ClassVar[RESOURCE_LANGS] = ...
    PUNJABI: ClassVar[RESOURCE_LANGS] = ...
    QUECHUA: ClassVar[RESOURCE_LANGS] = ...
    RHAETO_ROMANCE: ClassVar[RESOURCE_LANGS] = ...
    ROMANIAN: ClassVar[RESOURCE_LANGS] = ...
    RUSSIAN: ClassVar[RESOURCE_LANGS] = ...
    SAMI: ClassVar[RESOURCE_LANGS] = ...
    SANSKRIT: ClassVar[RESOURCE_LANGS] = ...
    SERBIAN: ClassVar[RESOURCE_LANGS] = ...
    SINDHI: ClassVar[RESOURCE_LANGS] = ...
    SLOVAK: ClassVar[RESOURCE_LANGS] = ...
    SLOVENIAN: ClassVar[RESOURCE_LANGS] = ...
    SORBIAN: ClassVar[RESOURCE_LANGS] = ...
    SPANISH: ClassVar[RESOURCE_LANGS] = ...
    SUTU: ClassVar[RESOURCE_LANGS] = ...
    SWAHILI: ClassVar[RESOURCE_LANGS] = ...
    SWEDISH: ClassVar[RESOURCE_LANGS] = ...
    SYRIAC: ClassVar[RESOURCE_LANGS] = ...
    TAMAZIGHT: ClassVar[RESOURCE_LANGS] = ...
    TAMIL: ClassVar[RESOURCE_LANGS] = ...
    TATAR: ClassVar[RESOURCE_LANGS] = ...
    TELUGU: ClassVar[RESOURCE_LANGS] = ...
    THAI: ClassVar[RESOURCE_LANGS] = ...
    TIGRINYA: ClassVar[RESOURCE_LANGS] = ...
    TSONGA: ClassVar[RESOURCE_LANGS] = ...
    TSWANA: ClassVar[RESOURCE_LANGS] = ...
    TURKISH: ClassVar[RESOURCE_LANGS] = ...
    UKRAINIAN: ClassVar[RESOURCE_LANGS] = ...
    URDU: ClassVar[RESOURCE_LANGS] = ...
    UZBEK: ClassVar[RESOURCE_LANGS] = ...
    VALENCIAN: ClassVar[RESOURCE_LANGS] = ...
    VENDA: ClassVar[RESOURCE_LANGS] = ...
    VIETNAMESE: ClassVar[RESOURCE_LANGS] = ...
    WALON: ClassVar[RESOURCE_LANGS] = ...
    WELSH: ClassVar[RESOURCE_LANGS] = ...
    XHOSA: ClassVar[RESOURCE_LANGS] = ...
    ZULU: ClassVar[RESOURCE_LANGS] = ...
    __entries: ClassVar[dict] = ...
    def __init__(self, value: int) -> None: ...
    @property
    def name(self) -> str: ...
    @property
    def value(self) -> int: ...

class RESOURCE_SUBLANGS:
    __members__: ClassVar[dict] = ...  # read-only
    AFRIKAANS_SOUTH_AFRICA: ClassVar[RESOURCE_SUBLANGS] = ...
    ALBANIAN_ALBANIA: ClassVar[RESOURCE_SUBLANGS] = ...
    ALSATIAN_FRANCE: ClassVar[RESOURCE_SUBLANGS] = ...
    AMHARIC_ETHIOPIA: ClassVar[RESOURCE_SUBLANGS] = ...
    ARABIC_ALGERIA: ClassVar[RESOURCE_SUBLANGS] = ...
    ARABIC_BAHRAIN: ClassVar[RESOURCE_SUBLANGS] = ...
    ARABIC_EGYPT: ClassVar[RESOURCE_SUBLANGS] = ...
    ARABIC_IRAQ: ClassVar[RESOURCE_SUBLANGS] = ...
    ARABIC_JORDAN: ClassVar[RESOURCE_SUBLANGS] = ...
    ARABIC_KUWAIT: ClassVar[RESOURCE_SUBLANGS] = ...
    ARABIC_LEBANON: ClassVar[RESOURCE_SUBLANGS] = ...
    ARABIC_LIBYA: ClassVar[RESOURCE_SUBLANGS] = ...
    ARABIC_MOROCCO: ClassVar[RESOURCE_SUBLANGS] = ...
    ARABIC_OMAN: ClassVar[RESOURCE_SUBLANGS] = ...
    ARABIC_QATAR: ClassVar[RESOURCE_SUBLANGS] = ...
    ARABIC_SAUDI_ARABIA: ClassVar[RESOURCE_SUBLANGS] = ...
    ARABIC_SYRIA: ClassVar[RESOURCE_SUBLANGS] = ...
    ARABIC_TUNISIA: ClassVar[RESOURCE_SUBLANGS] = ...
    ARABIC_UAE: ClassVar[RESOURCE_SUBLANGS] = ...
    ARABIC_YEMEN: ClassVar[RESOURCE_SUBLANGS] = ...
    ARMENIAN_ARMENIA: ClassVar[RESOURCE_SUBLANGS] = ...
    ASSAMESE_INDIA: ClassVar[RESOURCE_SUBLANGS] = ...
    AZERI_CYRILLIC: ClassVar[RESOURCE_SUBLANGS] = ...
    AZERI_LATIN: ClassVar[RESOURCE_SUBLANGS] = ...
    BANGLA_BANGLADESH: ClassVar[RESOURCE_SUBLANGS] = ...
    BANGLA_INDIA: ClassVar[RESOURCE_SUBLANGS] = ...
    BASHKIR_RUSSIA: ClassVar[RESOURCE_SUBLANGS] = ...
    BASQUE_BASQUE: ClassVar[RESOURCE_SUBLANGS] = ...
    BELARUSIAN_BELARUS: ClassVar[RESOURCE_SUBLANGS] = ...
    BOSNIAN_BOSNIA_HERZEGOVINA_CYRILLIC: ClassVar[RESOURCE_SUBLANGS] = ...
    BOSNIAN_BOSNIA_HERZEGOVINA_LATIN: ClassVar[RESOURCE_SUBLANGS] = ...
    BRETON_FRANCE: ClassVar[RESOURCE_SUBLANGS] = ...
    BULGARIAN_BULGARIA: ClassVar[RESOURCE_SUBLANGS] = ...
    CATALAN_CATALAN: ClassVar[RESOURCE_SUBLANGS] = ...
    CHINESE_HONGKONG: ClassVar[RESOURCE_SUBLANGS] = ...
    CHINESE_MACAU: ClassVar[RESOURCE_SUBLANGS] = ...
    CHINESE_SIMPLIFIED: ClassVar[RESOURCE_SUBLANGS] = ...
    CHINESE_SINGAPORE: ClassVar[RESOURCE_SUBLANGS] = ...
    CHINESE_TRADITIONAL: ClassVar[RESOURCE_SUBLANGS] = ...
    CORSICAN_FRANCE: ClassVar[RESOURCE_SUBLANGS] = ...
    CROATIAN_BOSNIA_HERZEGOVINA_LATIN: ClassVar[RESOURCE_SUBLANGS] = ...
    CROATIAN_CROATIA: ClassVar[RESOURCE_SUBLANGS] = ...
    CUSTOM_DEFAULT: ClassVar[RESOURCE_SUBLANGS] = ...
    CUSTOM_UNSPECIFIED: ClassVar[RESOURCE_SUBLANGS] = ...
    CZECH_CZECH_REPUBLIC: ClassVar[RESOURCE_SUBLANGS] = ...
    DANISH_DENMARK: ClassVar[RESOURCE_SUBLANGS] = ...
    DARI_AFGHANISTAN: ClassVar[RESOURCE_SUBLANGS] = ...
    DEFAULT: ClassVar[RESOURCE_SUBLANGS] = ...
    DIVEHI_MALDIVES: ClassVar[RESOURCE_SUBLANGS] = ...
    DUTCH: ClassVar[RESOURCE_SUBLANGS] = ...
    DUTCH_BELGIAN: ClassVar[RESOURCE_SUBLANGS] = ...
    ENGLISH_AUS: ClassVar[RESOURCE_SUBLANGS] = ...
    ENGLISH_BELIZE: ClassVar[RESOURCE_SUBLANGS] = ...
    ENGLISH_CAN: ClassVar[RESOURCE_SUBLANGS] = ...
    ENGLISH_CARIBBEAN: ClassVar[RESOURCE_SUBLANGS] = ...
    ENGLISH_EIRE: ClassVar[RESOURCE_SUBLANGS] = ...
    ENGLISH_INDIA: ClassVar[RESOURCE_SUBLANGS] = ...
    ENGLISH_IRELAND: ClassVar[RESOURCE_SUBLANGS] = ...
    ENGLISH_JAMAICA: ClassVar[RESOURCE_SUBLANGS] = ...
    ENGLISH_MALAYSIA: ClassVar[RESOURCE_SUBLANGS] = ...
    ENGLISH_NZ: ClassVar[RESOURCE_SUBLANGS] = ...
    ENGLISH_PHILIPPINES: ClassVar[RESOURCE_SUBLANGS] = ...
    ENGLISH_SINGAPORE: ClassVar[RESOURCE_SUBLANGS] = ...
    ENGLISH_SOUTH_AFRICA: ClassVar[RESOURCE_SUBLANGS] = ...
    ENGLISH_TRINIDAD: ClassVar[RESOURCE_SUBLANGS] = ...
    ENGLISH_UK: ClassVar[RESOURCE_SUBLANGS] = ...
    ENGLISH_US: ClassVar[RESOURCE_SUBLANGS] = ...
    ENGLISH_ZIMBABWE: ClassVar[RESOURCE_SUBLANGS] = ...
    ESTONIAN_ESTONIA: ClassVar[RESOURCE_SUBLANGS] = ...
    FAEROESE_FAROE_ISLANDS: ClassVar[RESOURCE_SUBLANGS] = ...
    FILIPINO_PHILIPPINES: ClassVar[RESOURCE_SUBLANGS] = ...
    FINNISH_FINLAND: ClassVar[RESOURCE_SUBLANGS] = ...
    FRENCH: ClassVar[RESOURCE_SUBLANGS] = ...
    FRENCH_BELGIAN: ClassVar[RESOURCE_SUBLANGS] = ...
    FRENCH_CANADIAN: ClassVar[RESOURCE_SUBLANGS] = ...
    FRENCH_LUXEMBOURG: ClassVar[RESOURCE_SUBLANGS] = ...
    FRENCH_MONACO: ClassVar[RESOURCE_SUBLANGS] = ...
    FRENCH_SWISS: ClassVar[RESOURCE_SUBLANGS] = ...
    FRISIAN_NETHERLANDS: ClassVar[RESOURCE_SUBLANGS] = ...
    GALICIAN_GALICIAN: ClassVar[RESOURCE_SUBLANGS] = ...
    GEORGIAN_GEORGIA: ClassVar[RESOURCE_SUBLANGS] = ...
    GERMAN: ClassVar[RESOURCE_SUBLANGS] = ...
    GERMAN_AUSTRIAN: ClassVar[RESOURCE_SUBLANGS] = ...
    GERMAN_LIECHTENSTEIN: ClassVar[RESOURCE_SUBLANGS] = ...
    GERMAN_LUXEMBOURG: ClassVar[RESOURCE_SUBLANGS] = ...
    GERMAN_SWISS: ClassVar[RESOURCE_SUBLANGS] = ...
    GREEK_GREECE: ClassVar[RESOURCE_SUBLANGS] = ...
    GREENLANDIC_GREENLAND: ClassVar[RESOURCE_SUBLANGS] = ...
    GUJARATI_INDIA: ClassVar[RESOURCE_SUBLANGS] = ...
    HAUSA_NIGERIA_LATIN: ClassVar[RESOURCE_SUBLANGS] = ...
    HEBREW_ISRAEL: ClassVar[RESOURCE_SUBLANGS] = ...
    HINDI_INDIA: ClassVar[RESOURCE_SUBLANGS] = ...
    HUNGARIAN_HUNGARY: ClassVar[RESOURCE_SUBLANGS] = ...
    ICELANDIC_ICELAND: ClassVar[RESOURCE_SUBLANGS] = ...
    IGBO_NIGERIA: ClassVar[RESOURCE_SUBLANGS] = ...
    INDONESIAN_INDONESIA: ClassVar[RESOURCE_SUBLANGS] = ...
    INUKTITUT_CANADA: ClassVar[RESOURCE_SUBLANGS] = ...
    INUKTITUT_CANADA_LATIN: ClassVar[RESOURCE_SUBLANGS] = ...
    IRISH_IRELAND: ClassVar[RESOURCE_SUBLANGS] = ...
    ITALIAN: ClassVar[RESOURCE_SUBLANGS] = ...
    ITALIAN_SWISS: ClassVar[RESOURCE_SUBLANGS] = ...
    JAPANESE_JAPAN: ClassVar[RESOURCE_SUBLANGS] = ...
    KANNADA_INDIA: ClassVar[RESOURCE_SUBLANGS] = ...
    KASHMIRI_INDIA: ClassVar[RESOURCE_SUBLANGS] = ...
    KASHMIRI_SASIA: ClassVar[RESOURCE_SUBLANGS] = ...
    KAZAK_KAZAKHSTAN: ClassVar[RESOURCE_SUBLANGS] = ...
    KHMER_CAMBODIA: ClassVar[RESOURCE_SUBLANGS] = ...
    KICHE_GUATEMALA: ClassVar[RESOURCE_SUBLANGS] = ...
    KINYARWANDA_RWANDA: ClassVar[RESOURCE_SUBLANGS] = ...
    KONKANI_INDIA: ClassVar[RESOURCE_SUBLANGS] = ...
    KOREAN: ClassVar[RESOURCE_SUBLANGS] = ...
    KYRGYZ_KYRGYZSTAN: ClassVar[RESOURCE_SUBLANGS] = ...
    LAO_LAO: ClassVar[RESOURCE_SUBLANGS] = ...
    LATVIAN_LATVIA: ClassVar[RESOURCE_SUBLANGS] = ...
    LITHUANIAN: ClassVar[RESOURCE_SUBLANGS] = ...
    LITHUANIAN_CLASSIC: ClassVar[RESOURCE_SUBLANGS] = ...
    LOWER_SORBIAN_GERMANY: ClassVar[RESOURCE_SUBLANGS] = ...
    LUXEMBOURGISH_LUXEMBOURG: ClassVar[RESOURCE_SUBLANGS] = ...
    MACEDONIAN_MACEDONIA: ClassVar[RESOURCE_SUBLANGS] = ...
    MALAYALAM_INDIA: ClassVar[RESOURCE_SUBLANGS] = ...
    MALAY_BRUNEI_DARUSSALAM: ClassVar[RESOURCE_SUBLANGS] = ...
    MALAY_MALAYSIA: ClassVar[RESOURCE_SUBLANGS] = ...
    MALTESE_MALTA: ClassVar[RESOURCE_SUBLANGS] = ...
    MAORI_NEW_ZEALAND: ClassVar[RESOURCE_SUBLANGS] = ...
    MAPUDUNGUN_CHILE: ClassVar[RESOURCE_SUBLANGS] = ...
    MARATHI_INDIA: ClassVar[RESOURCE_SUBLANGS] = ...
    MOHAWK_MOHAWK: ClassVar[RESOURCE_SUBLANGS] = ...
    MONGOLIAN_CYRILLIC_MONGOLIA: ClassVar[RESOURCE_SUBLANGS] = ...
    MONGOLIAN_PRC: ClassVar[RESOURCE_SUBLANGS] = ...
    NEPALI_INDIA: ClassVar[RESOURCE_SUBLANGS] = ...
    NEPALI_NEPAL: ClassVar[RESOURCE_SUBLANGS] = ...
    NEUTRAL: ClassVar[RESOURCE_SUBLANGS] = ...
    NORWEGIAN_BOKMAL: ClassVar[RESOURCE_SUBLANGS] = ...
    NORWEGIAN_NYNORSK: ClassVar[RESOURCE_SUBLANGS] = ...
    OCCITAN_FRANCE: ClassVar[RESOURCE_SUBLANGS] = ...
    ORIYA_INDIA: ClassVar[RESOURCE_SUBLANGS] = ...
    PASHTO_AFGHANISTAN: ClassVar[RESOURCE_SUBLANGS] = ...
    PERSIAN_IRAN: ClassVar[RESOURCE_SUBLANGS] = ...
    POLISH_POLAND: ClassVar[RESOURCE_SUBLANGS] = ...
    PORTUGUESE: ClassVar[RESOURCE_SUBLANGS] = ...
    PORTUGUESE_BRAZILIAN: ClassVar[RESOURCE_SUBLANGS] = ...
    PULAR_SENEGAL: ClassVar[RESOURCE_SUBLANGS] = ...
    PUNJABI_INDIA: ClassVar[RESOURCE_SUBLANGS] = ...
    PUNJABI_PAKISTAN: ClassVar[RESOURCE_SUBLANGS] = ...
    QUECHUA_BOLIVIA: ClassVar[RESOURCE_SUBLANGS] = ...
    QUECHUA_ECUADOR: ClassVar[RESOURCE_SUBLANGS] = ...
    QUECHUA_PERU: ClassVar[RESOURCE_SUBLANGS] = ...
    ROMANIAN_ROMANIA: ClassVar[RESOURCE_SUBLANGS] = ...
    ROMANSH_SWITZERLAND: ClassVar[RESOURCE_SUBLANGS] = ...
    RUSSIAN_RUSSIA: ClassVar[RESOURCE_SUBLANGS] = ...
    SAMI_INARI_FINLAND: ClassVar[RESOURCE_SUBLANGS] = ...
    SAMI_LULE_NORWAY: ClassVar[RESOURCE_SUBLANGS] = ...
    SAMI_LULE_SWEDEN: ClassVar[RESOURCE_SUBLANGS] = ...
    SAMI_NORTHERN_FINLAND: ClassVar[RESOURCE_SUBLANGS] = ...
    SAMI_NORTHERN_NORWAY: ClassVar[RESOURCE_SUBLANGS] = ...
    SAMI_NORTHERN_SWEDEN: ClassVar[RESOURCE_SUBLANGS] = ...
    SAMI_SKOLT_FINLAND: ClassVar[RESOURCE_SUBLANGS] = ...
    SAMI_SOUTHERN_NORWAY: ClassVar[RESOURCE_SUBLANGS] = ...
    SAMI_SOUTHERN_SWEDEN: ClassVar[RESOURCE_SUBLANGS] = ...
    SANSKRIT_INDIA: ClassVar[RESOURCE_SUBLANGS] = ...
    SERBIAN_BOSNIA_HERZEGOVINA_CYRILLIC: ClassVar[RESOURCE_SUBLANGS] = ...
    SERBIAN_BOSNIA_HERZEGOVINA_LATIN: ClassVar[RESOURCE_SUBLANGS] = ...
    SERBIAN_CROATIA: ClassVar[RESOURCE_SUBLANGS] = ...
    SERBIAN_CYRILLIC: ClassVar[RESOURCE_SUBLANGS] = ...
    SERBIAN_LATIN: ClassVar[RESOURCE_SUBLANGS] = ...
    SINDHI_AFGHANISTAN: ClassVar[RESOURCE_SUBLANGS] = ...
    SINDHI_INDIA: ClassVar[RESOURCE_SUBLANGS] = ...
    SINDHI_PAKISTAN: ClassVar[RESOURCE_SUBLANGS] = ...
    SINHALESE_SRI_LANKA: ClassVar[RESOURCE_SUBLANGS] = ...
    SLOVAK_SLOVAKIA: ClassVar[RESOURCE_SUBLANGS] = ...
    SLOVENIAN_SLOVENIA: ClassVar[RESOURCE_SUBLANGS] = ...
    SOTHO_NORTHERN_SOUTH_AFRICA: ClassVar[RESOURCE_SUBLANGS] = ...
    SPANISH: ClassVar[RESOURCE_SUBLANGS] = ...
    SPANISH_ARGENTINA: ClassVar[RESOURCE_SUBLANGS] = ...
    SPANISH_BOLIVIA: ClassVar[RESOURCE_SUBLANGS] = ...
    SPANISH_CHILE: ClassVar[RESOURCE_SUBLANGS] = ...
    SPANISH_COLOMBIA: ClassVar[RESOURCE_SUBLANGS] = ...
    SPANISH_COSTA_RICA: ClassVar[RESOURCE_SUBLANGS] = ...
    SPANISH_DOMINICAN_REPUBLIC: ClassVar[RESOURCE_SUBLANGS] = ...
    SPANISH_ECUADOR: ClassVar[RESOURCE_SUBLANGS] = ...
    SPANISH_EL_SALVADOR: ClassVar[RESOURCE_SUBLANGS] = ...
    SPANISH_GUATEMALA: ClassVar[RESOURCE_SUBLANGS] = ...
    SPANISH_HONDURAS: ClassVar[RESOURCE_SUBLANGS] = ...
    SPANISH_MEXICAN: ClassVar[RESOURCE_SUBLANGS] = ...
    SPANISH_MODERN: ClassVar[RESOURCE_SUBLANGS] = ...
    SPANISH_NICARAGUA: ClassVar[RESOURCE_SUBLANGS] = ...
    SPANISH_PANAMA: ClassVar[RESOURCE_SUBLANGS] = ...
    SPANISH_PARAGUAY: ClassVar[RESOURCE_SUBLANGS] = ...
    SPANISH_PERU: ClassVar[RESOURCE_SUBLANGS] = ...
    SPANISH_PUERTO_RICO: ClassVar[RESOURCE_SUBLANGS] = ...
    SPANISH_URUGUAY: ClassVar[RESOURCE_SUBLANGS] = ...
    SPANISH_US: ClassVar[RESOURCE_SUBLANGS] = ...
    SPANISH_VENEZUELA: ClassVar[RESOURCE_SUBLANGS] = ...
    SWAHILI_KENYA: ClassVar[RESOURCE_SUBLANGS] = ...
    SWEDISH: ClassVar[RESOURCE_SUBLANGS] = ...
    SWEDISH_FINLAND: ClassVar[RESOURCE_SUBLANGS] = ...
    SYRIAC_SYRIA: ClassVar[RESOURCE_SUBLANGS] = ...
    SYS_DEFAULT: ClassVar[RESOURCE_SUBLANGS] = ...
    TAJIK_TAJIKISTAN: ClassVar[RESOURCE_SUBLANGS] = ...
    TAMAZIGHT_ALGERIA_LATIN: ClassVar[RESOURCE_SUBLANGS] = ...
    TAMIL_INDIA: ClassVar[RESOURCE_SUBLANGS] = ...
    TAMIL_SRI_LANKA: ClassVar[RESOURCE_SUBLANGS] = ...
    TATAR_RUSSIA: ClassVar[RESOURCE_SUBLANGS] = ...
    TELUGU_INDIA: ClassVar[RESOURCE_SUBLANGS] = ...
    THAI_THAILAND: ClassVar[RESOURCE_SUBLANGS] = ...
    TIBETAN_PRC: ClassVar[RESOURCE_SUBLANGS] = ...
    TIGRIGNA_ERITREA: ClassVar[RESOURCE_SUBLANGS] = ...
    TIGRINYA_ERITREA: ClassVar[RESOURCE_SUBLANGS] = ...
    TIGRINYA_ETHIOPIA: ClassVar[RESOURCE_SUBLANGS] = ...
    TSWANA_BOTSWANA: ClassVar[RESOURCE_SUBLANGS] = ...
    TSWANA_SOUTH_AFRICA: ClassVar[RESOURCE_SUBLANGS] = ...
    TURKISH_TURKEY: ClassVar[RESOURCE_SUBLANGS] = ...
    TURKMEN_TURKMENISTAN: ClassVar[RESOURCE_SUBLANGS] = ...
    UIGHUR_PRC: ClassVar[RESOURCE_SUBLANGS] = ...
    UI_CUSTOM_DEFAULT: ClassVar[RESOURCE_SUBLANGS] = ...
    UKRAINIAN_UKRAINE: ClassVar[RESOURCE_SUBLANGS] = ...
    UPPER_SORBIAN_GERMANY: ClassVar[RESOURCE_SUBLANGS] = ...
    URDU_INDIA: ClassVar[RESOURCE_SUBLANGS] = ...
    URDU_PAKISTAN: ClassVar[RESOURCE_SUBLANGS] = ...
    UZBEK_CYRILLIC: ClassVar[RESOURCE_SUBLANGS] = ...
    UZBEK_LATIN: ClassVar[RESOURCE_SUBLANGS] = ...
    VALENCIAN_VALENCIA: ClassVar[RESOURCE_SUBLANGS] = ...
    VIETNAMESE_VIETNAM: ClassVar[RESOURCE_SUBLANGS] = ...
    WELSH_UNITED_KINGDOM: ClassVar[RESOURCE_SUBLANGS] = ...
    WOLOF_SENEGAL: ClassVar[RESOURCE_SUBLANGS] = ...
    XHOSA_SOUTH_AFRICA: ClassVar[RESOURCE_SUBLANGS] = ...
    YAKUT_RUSSIA: ClassVar[RESOURCE_SUBLANGS] = ...
    YI_PRC: ClassVar[RESOURCE_SUBLANGS] = ...
    YORUBA_NIGERIA: ClassVar[RESOURCE_SUBLANGS] = ...
    ZULU_SOUTH_AFRICA: ClassVar[RESOURCE_SUBLANGS] = ...
    __entries: ClassVar[dict] = ...
    def __init__(self, value: int) -> None: ...
    @property
    def name(self) -> str: ...
    @property
    def value(self) -> int: ...

class RESOURCE_TYPES:
    __members__: ClassVar[dict] = ...  # read-only
    ACCELERATOR: ClassVar[RESOURCE_TYPES] = ...
    ANICURSOR: ClassVar[RESOURCE_TYPES] = ...
    ANIICON: ClassVar[RESOURCE_TYPES] = ...
    BITMAP: ClassVar[RESOURCE_TYPES] = ...
    CURSOR: ClassVar[RESOURCE_TYPES] = ...
    DIALOG: ClassVar[RESOURCE_TYPES] = ...
    DLGINCLUDE: ClassVar[RESOURCE_TYPES] = ...
    FONT: ClassVar[RESOURCE_TYPES] = ...
    FONTDIR: ClassVar[RESOURCE_TYPES] = ...
    GROUP_CURSOR: ClassVar[RESOURCE_TYPES] = ...
    GROUP_ICON: ClassVar[RESOURCE_TYPES] = ...
    HTML: ClassVar[RESOURCE_TYPES] = ...
    ICON: ClassVar[RESOURCE_TYPES] = ...
    MANIFEST: ClassVar[RESOURCE_TYPES] = ...
    MENU: ClassVar[RESOURCE_TYPES] = ...
    MESSAGETABLE: ClassVar[RESOURCE_TYPES] = ...
    PLUGPLAY: ClassVar[RESOURCE_TYPES] = ...
    RCDATA: ClassVar[RESOURCE_TYPES] = ...
    STRING: ClassVar[RESOURCE_TYPES] = ...
    VERSION: ClassVar[RESOURCE_TYPES] = ...
    VXD: ClassVar[RESOURCE_TYPES] = ...
    __entries: ClassVar[dict] = ...
    def __init__(self, value: int) -> None: ...
    @property
    def name(self) -> str: ...
    @property
    def value(self) -> int: ...

class Relocation(lief.Object):
    class it_entries:
        def __init__(self, *args, **kwargs) -> None: ...
        def __getitem__(self, arg0: int) -> lief.PE.RelocationEntry: ...
        def __iter__(self) -> Iterator: ...
        def __len__(self) -> int: ...
        def __next__(self) -> lief.PE.RelocationEntry: ...
    block_size: int
    virtual_address: int
    def __init__(self) -> None: ...
    def add_entry(self, new_entry: lief.PE.RelocationEntry) -> lief.PE.RelocationEntry: ...
    @property
    def entries(self) -> lief.PE.Relocation.it_entries: ...

class RelocationEntry(lief.Relocation):
    data: int
    position: int
    type: lief.PE.RELOCATIONS_BASE_TYPES
    def __init__(self) -> None: ...

class ResourceAccelerator(lief.Object):
    def __init__(self, *args, **kwargs) -> None: ...
    @property
    def ansi(self) -> int: ...
    @property
    def flags(self) -> int: ...
    @property
    def id(self) -> int: ...
    @property
    def padding(self) -> int: ...

class ResourceData(ResourceNode):
    code_page: int
    content: memoryview
    reserved: int
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, content: List[int], code_page: int) -> None: ...
    @property
    def offset(self) -> int: ...

class ResourceDialog(lief.Object):
    class it_const_items:
        def __init__(self, *args, **kwargs) -> None: ...
        def __getitem__(self, arg0: int) -> lief.PE.ResourceDialogItem: ...
        def __iter__(self) -> Iterator: ...
        def __len__(self) -> int: ...
        def __next__(self) -> lief.PE.ResourceDialogItem: ...
    lang: lief.PE.RESOURCE_LANGS
    sub_lang: lief.PE.RESOURCE_SUBLANGS
    def __init__(self, *args, **kwargs) -> None: ...
    def has_dialogbox_style(self, style: lief.PE.DIALOG_BOX_STYLES) -> bool: ...
    def has_extended_style(self, style: lief.PE.EXTENDED_WINDOW_STYLES) -> bool: ...
    def has_style(self, style: lief.PE.WINDOW_STYLES) -> bool: ...
    @property
    def charset(self) -> int: ...
    @property
    def cx(self) -> int: ...
    @property
    def cy(self) -> int: ...
    @property
    def dialogbox_style_list(self) -> Set[lief.PE.DIALOG_BOX_STYLES]: ...
    @property
    def extended_style(self) -> int: ...
    @property
    def extended_style_list(self) -> Set[lief.PE.DIALOG_BOX_STYLES]: ...
    @property
    def help_id(self) -> int: ...
    @property
    def is_extended(self) -> bool: ...
    @property
    def items(self) -> lief.PE.ResourceDialog.it_const_items: ...
    @property
    def point_size(self) -> int: ...
    @property
    def signature(self) -> int: ...
    @property
    def style(self) -> int: ...
    @property
    def style_list(self) -> Set[lief.PE.WINDOW_STYLES]: ...
    @property
    def title(self) -> str: ...
    @property
    def typeface(self) -> str: ...
    @property
    def version(self) -> int: ...
    @property
    def weight(self) -> int: ...
    @property
    def x(self) -> int: ...
    @property
    def y(self) -> int: ...

class ResourceDialogItem(lief.Object):
    def __init__(self, *args, **kwargs) -> None: ...
    @property
    def cx(self) -> int: ...
    @property
    def cy(self) -> int: ...
    @property
    def extended_style(self) -> int: ...
    @property
    def help_id(self) -> int: ...
    @property
    def id(self) -> int: ...
    @property
    def is_extended(self) -> bool: ...
    @property
    def style(self) -> int: ...
    @property
    def title(self) -> str: ...
    @property
    def x(self) -> int: ...
    @property
    def y(self) -> int: ...

class ResourceDirectory(ResourceNode):
    characteristics: int
    major_version: int
    minor_version: int
    numberof_id_entries: int
    numberof_name_entries: int
    time_date_stamp: int
    def __init__(self) -> None: ...

class ResourceFixedFileInfo(lief.Object):
    file_date_LS: int
    file_date_MS: int
    file_flags: int
    file_flags_mask: int
    file_os: lief.PE.FIXED_VERSION_OS
    file_subtype: lief.PE.FIXED_VERSION_FILE_SUB_TYPES
    file_type: lief.PE.FIXED_VERSION_FILE_TYPES
    file_version_LS: int
    file_version_MS: int
    product_version_LS: int
    product_version_MS: int
    signature: int
    struct_version: int
    def __init__(self, *args, **kwargs) -> None: ...

class ResourceIcon(lief.Object):
    bit_count: int
    color_count: int
    height: int
    id: int
    lang: lief.PE.RESOURCE_LANGS
    pixels: memoryview
    planes: int
    reserved: int
    sublang: lief.PE.RESOURCE_SUBLANGS
    width: int
    def __init__(self, *args, **kwargs) -> None: ...
    def save(self, filepath: str) -> None: ...

class ResourceNode(lief.Object):
    class it_childs:
        def __init__(self, *args, **kwargs) -> None: ...
        def __getitem__(self, arg0: int) -> lief.PE.ResourceNode: ...
        def __iter__(self) -> Iterator: ...
        def __len__(self) -> int: ...
        def __next__(self) -> lief.PE.ResourceNode: ...
    id: int
    name: object
    def __init__(self, *args, **kwargs) -> None: ...
    def add_data_node(self, resource_data: lief.PE.ResourceData) -> lief.PE.ResourceNode: ...
    def add_directory_node(self, resource_directory: lief.PE.ResourceDirectory) -> lief.PE.ResourceNode: ...
    @overload
    def delete_child(self, node: lief.PE.ResourceNode) -> None: ...
    @overload
    def delete_child(self, id: int) -> None: ...
    @property
    def childs(self) -> lief.PE.ResourceNode.it_childs: ...
    @property
    def depth(self) -> int: ...
    @property
    def has_name(self) -> bool: ...
    @property
    def is_data(self) -> bool: ...
    @property
    def is_directory(self) -> bool: ...

class ResourceStringFileInfo(lief.Object):
    key: str
    langcode_items: Any
    type: int
    def __init__(self, *args, **kwargs) -> None: ...

class ResourceStringTable(lief.Object):
    def __init__(self, *args, **kwargs) -> None: ...
    @property
    def length(self) -> int: ...
    @property
    def name(self) -> str: ...

class ResourceVarFileInfo(lief.Object):
    key: str
    translations: List[int]
    type: int
    def __init__(self, *args, **kwargs) -> None: ...

class ResourceVersion(lief.Object):
    fixed_file_info: lief.PE.ResourceFixedFileInfo
    key: str
    string_file_info: lief.PE.ResourceStringFileInfo
    type: int
    var_file_info: lief.PE.ResourceVarFileInfo
    def __init__(self, *args, **kwargs) -> None: ...
    def remove_fixed_file_info(self) -> None: ...
    def remove_string_file_info(self) -> None: ...
    def remove_var_file_info(self) -> None: ...
    @property
    def has_fixed_file_info(self) -> bool: ...
    @property
    def has_string_file_info(self) -> bool: ...
    @property
    def has_var_file_info(self) -> bool: ...

class ResourcesManager(lief.Object):
    class it_const_accelerators:
        def __init__(self, *args, **kwargs) -> None: ...
        def __getitem__(self, arg0: int) -> lief.PE.ResourceAccelerator: ...
        def __iter__(self) -> Iterator: ...
        def __len__(self) -> int: ...
        def __next__(self) -> lief.PE.ResourceAccelerator: ...

    class it_const_dialogs:
        def __init__(self, *args, **kwargs) -> None: ...
        def __getitem__(self, arg0: int) -> lief.PE.ResourceDialog: ...
        def __iter__(self) -> Iterator: ...
        def __len__(self) -> int: ...
        def __next__(self) -> lief.PE.ResourceDialog: ...

    class it_const_icons:
        def __init__(self, *args, **kwargs) -> None: ...
        def __getitem__(self, arg0: int) -> lief.PE.ResourceIcon: ...
        def __iter__(self) -> Iterator: ...
        def __len__(self) -> int: ...
        def __next__(self) -> lief.PE.ResourceIcon: ...

    class it_const_strings_table:
        def __init__(self, *args, **kwargs) -> None: ...
        def __getitem__(self, arg0: int) -> lief.PE.ResourceStringTable: ...
        def __iter__(self) -> Iterator: ...
        def __len__(self) -> int: ...
        def __next__(self) -> lief.PE.ResourceStringTable: ...
    manifest: object
    def __init__(self, *args, **kwargs) -> None: ...
    def add_icon(self, icon: lief.PE.ResourceIcon) -> None: ...
    def change_icon(self, old_one: lief.PE.ResourceIcon, new_one: lief.PE.ResourceIcon) -> None: ...
    def get_node_type(self, type: lief.PE.RESOURCE_TYPES) -> lief.PE.ResourceNode: ...
    def has_type(self, type: lief.PE.RESOURCE_TYPES) -> bool: ...
    @property
    def accelerator(self) -> lief.PE.ResourcesManager.it_const_accelerators: ...
    @property
    def dialogs(self) -> lief.PE.ResourcesManager.it_const_dialogs: ...
    @property
    def has_accelerator(self) -> bool: ...
    @property
    def has_dialogs(self) -> bool: ...
    @property
    def has_html(self) -> bool: ...
    @property
    def has_icons(self) -> bool: ...
    @property
    def has_manifest(self) -> bool: ...
    @property
    def has_string_table(self) -> bool: ...
    @property
    def has_version(self) -> bool: ...
    @property
    def html(self) -> List[str]: ...
    @property
    def icons(self) -> lief.PE.ResourcesManager.it_const_icons: ...
    @property
    def langs_available(self) -> Set[lief.PE.RESOURCE_LANGS]: ...
    @property
    def string_table(self) -> lief.PE.ResourcesManager.it_const_strings_table: ...
    @property
    def sublangs_available(self) -> Set[lief.PE.RESOURCE_SUBLANGS]: ...
    @property
    def types_available(self) -> Set[lief.PE.RESOURCE_TYPES]: ...
    @property
    def version(self) -> object: ...

class RichEntry(lief.Object):
    build_id: int
    count: int
    id: int
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, id: int, build_id: int, count: int) -> None: ...

class RichHeader:
    class it_entries:
        def __init__(self, *args, **kwargs) -> None: ...
        def __getitem__(self, arg0: int) -> lief.PE.RichEntry: ...
        def __iter__(self) -> Iterator: ...
        def __len__(self) -> int: ...
        def __next__(self) -> lief.PE.RichEntry: ...
    key: int
    def __init__(self) -> None: ...
    @overload
    def add_entry(self, entry: lief.PE.RichEntry) -> None: ...
    @overload
    def add_entry(self, id: int, build_id: int, count: int) -> None: ...
    @overload
    def hash(self, algo: lief.PE.ALGORITHMS) -> List[int]: ...
    @overload
    def hash(self, algo: lief.PE.ALGORITHMS, xor_key: int) -> List[int]: ...
    @overload
    def raw(self) -> List[int]: ...
    @overload
    def raw(self, xor_key: int) -> List[int]: ...
    @property
    def entries(self) -> lief.PE.RichHeader.it_entries: ...

class RsaInfo:
    def __init__(self, *args, **kwargs) -> None: ...
    @property
    def D(self) -> bytes: ...
    @property
    def E(self) -> bytes: ...
    @property
    def N(self) -> bytes: ...
    @property
    def P(self) -> bytes: ...
    @property
    def Q(self) -> bytes: ...
    @property
    def has_private_key(self) -> bool: ...
    @property
    def has_public_key(self) -> bool: ...
    @property
    def key_size(self) -> int: ...
    @property
    def __len__(self) -> int: ...

class SECTION_CHARACTERISTICS:
    __members__: ClassVar[dict] = ...  # read-only
    ALIGN_1024BYTES: ClassVar[SECTION_CHARACTERISTICS] = ...
    ALIGN_128BYTES: ClassVar[SECTION_CHARACTERISTICS] = ...
    ALIGN_16BYTES: ClassVar[SECTION_CHARACTERISTICS] = ...
    ALIGN_1BYTES: ClassVar[SECTION_CHARACTERISTICS] = ...
    ALIGN_2048BYTES: ClassVar[SECTION_CHARACTERISTICS] = ...
    ALIGN_256BYTES: ClassVar[SECTION_CHARACTERISTICS] = ...
    ALIGN_2BYTES: ClassVar[SECTION_CHARACTERISTICS] = ...
    ALIGN_32BYTES: ClassVar[SECTION_CHARACTERISTICS] = ...
    ALIGN_4096BYTES: ClassVar[SECTION_CHARACTERISTICS] = ...
    ALIGN_4BYTES: ClassVar[SECTION_CHARACTERISTICS] = ...
    ALIGN_512BYTES: ClassVar[SECTION_CHARACTERISTICS] = ...
    ALIGN_64BYTES: ClassVar[SECTION_CHARACTERISTICS] = ...
    ALIGN_8192BYTES: ClassVar[SECTION_CHARACTERISTICS] = ...
    ALIGN_8BYTES: ClassVar[SECTION_CHARACTERISTICS] = ...
    CNT_CODE: ClassVar[SECTION_CHARACTERISTICS] = ...
    CNT_INITIALIZED_DATA: ClassVar[SECTION_CHARACTERISTICS] = ...
    CNT_UNINITIALIZED_DATA: ClassVar[SECTION_CHARACTERISTICS] = ...
    GPREL: ClassVar[SECTION_CHARACTERISTICS] = ...
    LNK_COMDAT: ClassVar[SECTION_CHARACTERISTICS] = ...
    LNK_INFO: ClassVar[SECTION_CHARACTERISTICS] = ...
    LNK_NRELOC_OVFL: ClassVar[SECTION_CHARACTERISTICS] = ...
    LNK_OTHER: ClassVar[SECTION_CHARACTERISTICS] = ...
    LNK_REMOVE: ClassVar[SECTION_CHARACTERISTICS] = ...
    MEM_16BIT: ClassVar[SECTION_CHARACTERISTICS] = ...
    MEM_DISCARDABLE: ClassVar[SECTION_CHARACTERISTICS] = ...
    MEM_EXECUTE: ClassVar[SECTION_CHARACTERISTICS] = ...
    MEM_LOCKED: ClassVar[SECTION_CHARACTERISTICS] = ...
    MEM_NOT_CACHED: ClassVar[SECTION_CHARACTERISTICS] = ...
    MEM_NOT_PAGED: ClassVar[SECTION_CHARACTERISTICS] = ...
    MEM_PRELOAD: ClassVar[SECTION_CHARACTERISTICS] = ...
    MEM_PURGEABLE: ClassVar[SECTION_CHARACTERISTICS] = ...
    MEM_READ: ClassVar[SECTION_CHARACTERISTICS] = ...
    MEM_SHARED: ClassVar[SECTION_CHARACTERISTICS] = ...
    MEM_WRITE: ClassVar[SECTION_CHARACTERISTICS] = ...
    TYPE_NO_PAD: ClassVar[SECTION_CHARACTERISTICS] = ...
    __entries: ClassVar[dict] = ...
    def __init__(self, value: int) -> None: ...
    @property
    def name(self) -> str: ...
    @property
    def value(self) -> int: ...

class SECTION_TYPES:
    __members__: ClassVar[dict] = ...  # read-only
    BSS: ClassVar[SECTION_TYPES] = ...
    DATA: ClassVar[SECTION_TYPES] = ...
    EXPORT: ClassVar[SECTION_TYPES] = ...
    IDATA: ClassVar[SECTION_TYPES] = ...
    RELOCATION: ClassVar[SECTION_TYPES] = ...
    RESOURCE: ClassVar[SECTION_TYPES] = ...
    TEXT: ClassVar[SECTION_TYPES] = ...
    TLS_: ClassVar[SECTION_TYPES] = ...
    UNKNOWN: ClassVar[SECTION_TYPES] = ...
    __entries: ClassVar[dict] = ...
    def __init__(self, value: int) -> None: ...
    @property
    def name(self) -> str: ...
    @property
    def value(self) -> int: ...

class SIG_ATTRIBUTE_TYPES:
    __members__: ClassVar[dict] = ...  # read-only
    CONTENT_TYPE: ClassVar[SIG_ATTRIBUTE_TYPES] = ...
    GENERIC_TYPE: ClassVar[SIG_ATTRIBUTE_TYPES] = ...
    MS_COUNTER_SIGN: ClassVar[SIG_ATTRIBUTE_TYPES] = ...
    MS_SPC_NESTED_SIGN: ClassVar[SIG_ATTRIBUTE_TYPES] = ...
    MS_SPC_STATEMENT_TYPE: ClassVar[SIG_ATTRIBUTE_TYPES] = ...
    PKCS9_AT_SEQUENCE_NUMBER: ClassVar[SIG_ATTRIBUTE_TYPES] = ...
    PKCS9_COUNTER_SIGNATURE: ClassVar[SIG_ATTRIBUTE_TYPES] = ...
    PKCS9_MESSAGE_DIGEST: ClassVar[SIG_ATTRIBUTE_TYPES] = ...
    PKCS9_SIGNING_TIME: ClassVar[SIG_ATTRIBUTE_TYPES] = ...
    SPC_SP_OPUS_INFO: ClassVar[SIG_ATTRIBUTE_TYPES] = ...
    UNKNOWN: ClassVar[SIG_ATTRIBUTE_TYPES] = ...
    __entries: ClassVar[dict] = ...
    def __init__(self, value: int) -> None: ...
    @property
    def name(self) -> str: ...
    @property
    def value(self) -> int: ...

class SUBSYSTEM:
    __members__: ClassVar[dict] = ...  # read-only
    EFI_APPLICATION: ClassVar[SUBSYSTEM] = ...
    EFI_BOOT_SERVICE_DRIVER: ClassVar[SUBSYSTEM] = ...
    EFI_ROM: ClassVar[SUBSYSTEM] = ...
    EFI_RUNTIME_DRIVER: ClassVar[SUBSYSTEM] = ...
    NATIVE: ClassVar[SUBSYSTEM] = ...
    NATIVE_WINDOWS: ClassVar[SUBSYSTEM] = ...
    OS2_CUI: ClassVar[SUBSYSTEM] = ...
    POSIX_CUI: ClassVar[SUBSYSTEM] = ...
    UNKNOWN: ClassVar[SUBSYSTEM] = ...
    WINDOWS_BOOT_APPLICATION: ClassVar[SUBSYSTEM] = ...
    WINDOWS_CE_GUI: ClassVar[SUBSYSTEM] = ...
    WINDOWS_CUI: ClassVar[SUBSYSTEM] = ...
    WINDOWS_GUI: ClassVar[SUBSYSTEM] = ...
    XBOX: ClassVar[SUBSYSTEM] = ...
    __entries: ClassVar[dict] = ...
    def __init__(self, value: int) -> None: ...
    @property
    def name(self) -> str: ...
    @property
    def value(self) -> int: ...

class SYMBOL_BASE_TYPES:
    __members__: ClassVar[dict] = ...  # read-only
    BYTE: ClassVar[SYMBOL_BASE_TYPES] = ...
    CHAR: ClassVar[SYMBOL_BASE_TYPES] = ...
    DOUBLE: ClassVar[SYMBOL_BASE_TYPES] = ...
    DWORD: ClassVar[SYMBOL_BASE_TYPES] = ...
    ENUM: ClassVar[SYMBOL_BASE_TYPES] = ...
    FLOAT: ClassVar[SYMBOL_BASE_TYPES] = ...
    INT: ClassVar[SYMBOL_BASE_TYPES] = ...
    LONG: ClassVar[SYMBOL_BASE_TYPES] = ...
    MOE: ClassVar[SYMBOL_BASE_TYPES] = ...
    NULL: ClassVar[SYMBOL_BASE_TYPES] = ...
    SHORT: ClassVar[SYMBOL_BASE_TYPES] = ...
    STRUCT: ClassVar[SYMBOL_BASE_TYPES] = ...
    UINT: ClassVar[SYMBOL_BASE_TYPES] = ...
    UNION: ClassVar[SYMBOL_BASE_TYPES] = ...
    VOID: ClassVar[SYMBOL_BASE_TYPES] = ...
    WORD: ClassVar[SYMBOL_BASE_TYPES] = ...
    __entries: ClassVar[dict] = ...
    def __init__(self, value: int) -> None: ...
    @property
    def name(self) -> str: ...
    @property
    def value(self) -> int: ...

class SYMBOL_COMPLEX_TYPES:
    __members__: ClassVar[dict] = ...  # read-only
    ARRAY: ClassVar[SYMBOL_COMPLEX_TYPES] = ...
    COMPLEX_TYPE_SHIFT: ClassVar[SYMBOL_COMPLEX_TYPES] = ...
    FUNCTION: ClassVar[SYMBOL_COMPLEX_TYPES] = ...
    NULL: ClassVar[SYMBOL_COMPLEX_TYPES] = ...
    POINTER: ClassVar[SYMBOL_COMPLEX_TYPES] = ...
    __entries: ClassVar[dict] = ...
    def __init__(self, value: int) -> None: ...
    @property
    def name(self) -> str: ...
    @property
    def value(self) -> int: ...

class SYMBOL_SECTION_NUMBER:
    __members__: ClassVar[dict] = ...  # read-only
    ABSOLUTE: ClassVar[SYMBOL_SECTION_NUMBER] = ...
    DEBUG: ClassVar[SYMBOL_SECTION_NUMBER] = ...
    UNDEFINED: ClassVar[SYMBOL_SECTION_NUMBER] = ...
    __entries: ClassVar[dict] = ...
    def __init__(self, value: int) -> None: ...
    @property
    def name(self) -> str: ...
    @property
    def value(self) -> int: ...

class SYMBOL_STORAGE_CLASS:
    __members__: ClassVar[dict] = ...  # read-only
    AUTOMATIC: ClassVar[SYMBOL_STORAGE_CLASS] = ...
    BIT_FIELD: ClassVar[SYMBOL_STORAGE_CLASS] = ...
    BLOCK: ClassVar[SYMBOL_STORAGE_CLASS] = ...
    CLR_TOKEN: ClassVar[SYMBOL_STORAGE_CLASS] = ...
    END_OF_FUNCTION: ClassVar[SYMBOL_STORAGE_CLASS] = ...
    END_OF_STRUCT: ClassVar[SYMBOL_STORAGE_CLASS] = ...
    ENUM_TAG: ClassVar[SYMBOL_STORAGE_CLASS] = ...
    EXTERNAL: ClassVar[SYMBOL_STORAGE_CLASS] = ...
    EXTERNAL_DEF: ClassVar[SYMBOL_STORAGE_CLASS] = ...
    FILE: ClassVar[SYMBOL_STORAGE_CLASS] = ...
    FUNCTION: ClassVar[SYMBOL_STORAGE_CLASS] = ...
    LABEL: ClassVar[SYMBOL_STORAGE_CLASS] = ...
    MEMBER_OF_ENUM: ClassVar[SYMBOL_STORAGE_CLASS] = ...
    MEMBER_OF_STRUCT: ClassVar[SYMBOL_STORAGE_CLASS] = ...
    NULL: ClassVar[SYMBOL_STORAGE_CLASS] = ...
    REGISTER: ClassVar[SYMBOL_STORAGE_CLASS] = ...
    REGISTER_PARAM: ClassVar[SYMBOL_STORAGE_CLASS] = ...
    SECTION: ClassVar[SYMBOL_STORAGE_CLASS] = ...
    STATIC: ClassVar[SYMBOL_STORAGE_CLASS] = ...
    TYPE_DEFINITION: ClassVar[SYMBOL_STORAGE_CLASS] = ...
    UDEFINED_STATIC: ClassVar[SYMBOL_STORAGE_CLASS] = ...
    UNDEFINED_LABEL: ClassVar[SYMBOL_STORAGE_CLASS] = ...
    UNION_TAG: ClassVar[SYMBOL_STORAGE_CLASS] = ...
    WEAK_EXTERNAL: ClassVar[SYMBOL_STORAGE_CLASS] = ...
    __entries: ClassVar[dict] = ...
    def __init__(self, value: int) -> None: ...
    @property
    def name(self) -> str: ...
    @property
    def value(self) -> int: ...

class Section(lief.Section):
    characteristics: int
    numberof_line_numbers: int
    numberof_relocations: int
    pointerto_line_numbers: int
    pointerto_raw_data: int
    pointerto_relocation: int
    sizeof_raw_data: int
    virtual_size: int
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, content: List[int], name: str = ..., characteristics: int = ...) -> None: ...
    @overload
    def __init__(self, name: str) -> None: ...
    def has_characteristic(self, characteristic: lief.PE.SECTION_CHARACTERISTICS) -> bool: ...
    @property
    def characteristics_lists(self) -> Set[lief.PE.SECTION_CHARACTERISTICS]: ...
    @property
    def padding(self) -> bytes: ...

class Signature(lief.Object):
    class VERIFICATION_CHECKS:
        __members__: ClassVar[dict] = ...  # read-only
        DEFAULT: ClassVar[Signature.VERIFICATION_CHECKS] = ...
        HASH_ONLY: ClassVar[Signature.VERIFICATION_CHECKS] = ...
        LIFETIME_SIGNING: ClassVar[Signature.VERIFICATION_CHECKS] = ...
        SKIP_CERT_TIME: ClassVar[Signature.VERIFICATION_CHECKS] = ...
        __entries: ClassVar[dict] = ...
        def __init__(self, value: int) -> None: ...
        @property
        def name(self) -> str: ...
        @property
        def value(self) -> int: ...

    class VERIFICATION_FLAGS:
        __members__: ClassVar[dict] = ...  # read-only
        BAD_DIGEST: ClassVar[Signature.VERIFICATION_FLAGS] = ...
        BAD_SIGNATURE: ClassVar[Signature.VERIFICATION_FLAGS] = ...
        CERT_EXPIRED: ClassVar[Signature.VERIFICATION_FLAGS] = ...
        CERT_FUTURE: ClassVar[Signature.VERIFICATION_FLAGS] = ...
        CERT_NOT_FOUND: ClassVar[Signature.VERIFICATION_FLAGS] = ...
        CORRUPTED_AUTH_DATA: ClassVar[Signature.VERIFICATION_FLAGS] = ...
        CORRUPTED_CONTENT_INFO: ClassVar[Signature.VERIFICATION_FLAGS] = ...
        INCONSISTENT_DIGEST_ALGORITHM: ClassVar[Signature.VERIFICATION_FLAGS] = ...
        INVALID_SIGNER: ClassVar[Signature.VERIFICATION_FLAGS] = ...
        MISSING_PKCS9_MESSAGE_DIGEST: ClassVar[Signature.VERIFICATION_FLAGS] = ...
        NO_SIGNATURE: ClassVar[Signature.VERIFICATION_FLAGS] = ...
        OK: ClassVar[Signature.VERIFICATION_FLAGS] = ...
        UNSUPPORTED_ALGORITHM: ClassVar[Signature.VERIFICATION_FLAGS] = ...
        __entries: ClassVar[dict] = ...
        def __init__(self, value: int) -> None: ...
        def name(self, *args, **kwargs) -> Any: ...
        @property
        def value(self) -> int: ...

    class it_const_crt:
        def __init__(self, *args, **kwargs) -> None: ...
        def __getitem__(self, arg0: int) -> lief.PE.x509: ...
        def __iter__(self) -> Iterator: ...
        def __len__(self) -> int: ...
        def __next__(self) -> lief.PE.x509: ...

    class it_const_signers_t:
        def __init__(self, *args, **kwargs) -> None: ...
        def __getitem__(self, arg0: int) -> lief.PE.SignerInfo: ...
        def __iter__(self) -> Iterator: ...
        def __len__(self) -> int: ...
        def __next__(self) -> lief.PE.SignerInfo: ...
    def __init__(self, *args, **kwargs) -> None: ...
    def check(self, checks: lief.PE.Signature.VERIFICATION_CHECKS = ...) -> lief.PE.Signature.VERIFICATION_FLAGS: ...
    def find_crt(self, serialno: List[int]) -> lief.PE.x509: ...
    @overload
    def find_crt_issuer(self, issuer: str) -> lief.PE.x509: ...
    @overload
    def find_crt_issuer(self, issuer: str, serialno: List[int]) -> lief.PE.x509: ...
    @overload
    def find_crt_subject(self, subject: str) -> lief.PE.x509: ...
    @overload
    def find_crt_subject(self, subject: str, serialno: List[int]) -> lief.PE.x509: ...
    def parse(self, *args, **kwargs) -> lief.PE.Binary | None: ...
    @property
    def certificates(self) -> lief.PE.Signature.it_const_crt: ...
    @property
    def content_info(self) -> lief.PE.ContentInfo: ...
    @property
    def digest_algorithm(self) -> lief.PE.ALGORITHMS: ...
    @property
    def raw_der(self) -> bytes: ...
    @property
    def signers(self) -> List[lief.PE.SignerInfo]: ...
    @property
    def version(self) -> int: ...

class SignerInfo(lief.Object):
    class it_const_attributes_t:
        def __init__(self, *args, **kwargs) -> None: ...
        def __getitem__(self, arg0: int) -> lief.PE.Attribute: ...
        def __iter__(self) -> Iterator: ...
        def __len__(self) -> int: ...
        def __next__(self) -> lief.PE.Attribute: ...
    def __init__(self, *args, **kwargs) -> None: ...
    def get_attribute(self, type: lief.PE.SIG_ATTRIBUTE_TYPES) -> lief.PE.Attribute: ...
    def get_auth_attribute(self, type: lief.PE.SIG_ATTRIBUTE_TYPES) -> lief.PE.Attribute: ...
    def get_unauth_attribute(self, type: lief.PE.SIG_ATTRIBUTE_TYPES) -> lief.PE.Attribute: ...
    @property
    def authenticated_attributes(self) -> lief.PE.SignerInfo.it_const_attributes_t: ...
    @property
    def cert(self) -> lief.PE.x509: ...
    @property
    def digest_algorithm(self) -> lief.PE.ALGORITHMS: ...
    @property
    def encrypted_digest(self) -> bytes: ...
    @property
    def encryption_algorithm(self) -> lief.PE.ALGORITHMS: ...
    @property
    def issuer(self) -> object: ...
    @property
    def serial_number(self) -> bytes: ...
    @property
    def unauthenticated_attributes(self) -> lief.PE.SignerInfo.it_const_attributes_t: ...
    @property
    def version(self) -> int: ...

class SpcSpOpusInfo(Attribute):
    def __init__(self, *args, **kwargs) -> None: ...
    @property
    def more_info(self) -> object: ...
    @property
    def program_name(self) -> object: ...

class Symbol(lief.Symbol):
    name: str
    def __init__(self) -> None: ...
    @property
    def base_type(self) -> lief.PE.SYMBOL_BASE_TYPES: ...
    @property
    def complex_type(self) -> lief.PE.SYMBOL_COMPLEX_TYPES: ...
    @property
    def has_section(self) -> bool: ...
    @property
    def numberof_aux_symbols(self) -> int: ...
    @property
    def section(self) -> lief.PE.Section: ...
    @property
    def section_number(self) -> int: ...
    @property
    def storage_class(self) -> lief.PE.SYMBOL_STORAGE_CLASS: ...
    @property
    def type(self) -> int: ...

class TLS(lief.Object):
    addressof_callbacks: int
    addressof_index: int
    addressof_raw_data: Tuple[int,int]
    callbacks: List[int]
    characteristics: int
    data_template: memoryview
    sizeof_zero_fill: int
    def __init__(self) -> None: ...
    @property
    def directory(self) -> lief.PE.DataDirectory: ...
    @property
    def has_data_directory(self) -> bool: ...
    @property
    def has_section(self) -> bool: ...
    @property
    def section(self) -> lief.PE.Section: ...

class WINDOW_STYLES:
    __members__: ClassVar[dict] = ...  # read-only
    BORDER: ClassVar[WINDOW_STYLES] = ...
    CAPTION: ClassVar[WINDOW_STYLES] = ...
    CHILD: ClassVar[WINDOW_STYLES] = ...
    CLIPCHILDREN: ClassVar[WINDOW_STYLES] = ...
    CLIPSIBLINGS: ClassVar[WINDOW_STYLES] = ...
    DISABLED: ClassVar[WINDOW_STYLES] = ...
    DLGFRAME: ClassVar[WINDOW_STYLES] = ...
    GROUP: ClassVar[WINDOW_STYLES] = ...
    HSCROLL: ClassVar[WINDOW_STYLES] = ...
    MAXIMIZE: ClassVar[WINDOW_STYLES] = ...
    MAXIMIZEBOX: ClassVar[WINDOW_STYLES] = ...
    MINIMIZE: ClassVar[WINDOW_STYLES] = ...
    MINIMIZEBOX: ClassVar[WINDOW_STYLES] = ...
    OVERLAPPED: ClassVar[WINDOW_STYLES] = ...
    POPUP: ClassVar[WINDOW_STYLES] = ...
    SYSMENU: ClassVar[WINDOW_STYLES] = ...
    TABSTOP: ClassVar[WINDOW_STYLES] = ...
    THICKFRAME: ClassVar[WINDOW_STYLES] = ...
    VISIBLE: ClassVar[WINDOW_STYLES] = ...
    VSCROLL: ClassVar[WINDOW_STYLES] = ...
    __entries: ClassVar[dict] = ...
    def __init__(self, value: int) -> None: ...
    @property
    def name(self) -> str: ...
    @property
    def value(self) -> int: ...

class WIN_VERSION:
    __members__: ClassVar[dict] = ...  # read-only
    SEH: ClassVar[WIN_VERSION] = ...
    UNKNOWN: ClassVar[WIN_VERSION] = ...
    WIN10_0_14286: ClassVar[WIN_VERSION] = ...
    WIN10_0_14383: ClassVar[WIN_VERSION] = ...
    WIN10_0_14901: ClassVar[WIN_VERSION] = ...
    WIN10_0_15002: ClassVar[WIN_VERSION] = ...
    WIN10_0_16237: ClassVar[WIN_VERSION] = ...
    WIN10_0_18362: ClassVar[WIN_VERSION] = ...
    WIN10_0_19534: ClassVar[WIN_VERSION] = ...
    WIN10_0_9879: ClassVar[WIN_VERSION] = ...
    WIN10_0_MSVC_2019: ClassVar[WIN_VERSION] = ...
    WIN10_0_MSVC_2019_16: ClassVar[WIN_VERSION] = ...
    WIN_8_1: ClassVar[WIN_VERSION] = ...
    __entries: ClassVar[dict] = ...
    def __init__(self, value: int) -> None: ...
    @property
    def name(self) -> str: ...
    @property
    def value(self) -> int: ...

class x509(lief.Object):
    class KEY_TYPES:
        __members__: ClassVar[dict] = ...  # read-only
        ECDSA: ClassVar[x509.KEY_TYPES] = ...
        ECKEY: ClassVar[x509.KEY_TYPES] = ...
        ECKEY_DH: ClassVar[x509.KEY_TYPES] = ...
        NONE: ClassVar[x509.KEY_TYPES] = ...
        RSA: ClassVar[x509.KEY_TYPES] = ...
        RSASSA_PSS: ClassVar[x509.KEY_TYPES] = ...
        RSA_ALT: ClassVar[x509.KEY_TYPES] = ...
        __entries: ClassVar[dict] = ...
        def __init__(self, value: int) -> None: ...
        @property
        def name(self) -> str: ...
        @property
        def value(self) -> int: ...

    class KEY_USAGE:
        __members__: ClassVar[dict] = ...  # read-only
        CRL_SIGN: ClassVar[x509.KEY_USAGE] = ...
        DATA_ENCIPHERMENT: ClassVar[x509.KEY_USAGE] = ...
        DECIPHER_ONLY: ClassVar[x509.KEY_USAGE] = ...
        DIGITAL_SIGNATURE: ClassVar[x509.KEY_USAGE] = ...
        ENCIPHER_ONLY: ClassVar[x509.KEY_USAGE] = ...
        KEY_AGREEMENT: ClassVar[x509.KEY_USAGE] = ...
        KEY_CERT_SIGN: ClassVar[x509.KEY_USAGE] = ...
        KEY_ENCIPHERMENT: ClassVar[x509.KEY_USAGE] = ...
        NON_REPUDIATION: ClassVar[x509.KEY_USAGE] = ...
        __entries: ClassVar[dict] = ...
        def __init__(self, value: int) -> None: ...
        @property
        def name(self) -> str: ...
        @property
        def value(self) -> int: ...

    class VERIFICATION_FLAGS:
        __members__: ClassVar[dict] = ...  # read-only
        BADCERT_BAD_KEY: ClassVar[x509.VERIFICATION_FLAGS] = ...
        BADCERT_BAD_MD: ClassVar[x509.VERIFICATION_FLAGS] = ...
        BADCERT_BAD_PK: ClassVar[x509.VERIFICATION_FLAGS] = ...
        BADCERT_CN_MISMATCH: ClassVar[x509.VERIFICATION_FLAGS] = ...
        BADCERT_EXPIRED: ClassVar[x509.VERIFICATION_FLAGS] = ...
        BADCERT_EXT_KEY_USAGE: ClassVar[x509.VERIFICATION_FLAGS] = ...
        BADCERT_FUTURE: ClassVar[x509.VERIFICATION_FLAGS] = ...
        BADCERT_KEY_USAGE: ClassVar[x509.VERIFICATION_FLAGS] = ...
        BADCERT_MISSING: ClassVar[x509.VERIFICATION_FLAGS] = ...
        BADCERT_NOT_TRUSTED: ClassVar[x509.VERIFICATION_FLAGS] = ...
        BADCERT_NS_CERT_TYPE: ClassVar[x509.VERIFICATION_FLAGS] = ...
        BADCERT_OTHERNATURE: ClassVar[x509.VERIFICATION_FLAGS] = ...
        BADCERT_REVOKED: ClassVar[x509.VERIFICATION_FLAGS] = ...
        BADCERT_SKIP_VERIFY: ClassVar[x509.VERIFICATION_FLAGS] = ...
        BADCRL_BAD_KEY: ClassVar[x509.VERIFICATION_FLAGS] = ...
        BADCRL_BAD_MD: ClassVar[x509.VERIFICATION_FLAGS] = ...
        BADCRL_BAD_PK: ClassVar[x509.VERIFICATION_FLAGS] = ...
        BADCRL_EXPIRED: ClassVar[x509.VERIFICATION_FLAGS] = ...
        BADCRL_FUTURE: ClassVar[x509.VERIFICATION_FLAGS] = ...
        BADCRL_NOT_TRUSTED: ClassVar[x509.VERIFICATION_FLAGS] = ...
        OK: ClassVar[x509.VERIFICATION_FLAGS] = ...
        __entries: ClassVar[dict] = ...
        def __init__(self, value: int) -> None: ...
        @property
        def name(self) -> str: ...
        @property
        def value(self) -> int: ...
    def __init__(self, *args, **kwargs) -> None: ...
    @overload
    def is_trusted_by(self, ca_list: List[lief.PE.x509]) -> lief.PE.x509.VERIFICATION_FLAGS: ...
    @overload
    def is_trusted_by(self, microsoft_ca_bundle) -> lief.PE.x509.VERIFICATION_FLAGS: ...
    def parse(self, *args, **kwargs) -> lief.PE.Binary | None: ...
    @overload
    def verify(self, ca: lief.PE.x509) -> lief.PE.x509.VERIFICATION_FLAGS: ...
    @overload
    def verify(self, signer) -> lief.PE.x509.VERIFICATION_FLAGS: ...
    @property
    def certificate_policies(self) -> List[str]: ...
    @property
    def ext_key_usage(self) -> List[str]: ...
    @property
    def is_ca(self) -> bool: ...
    @property
    def issuer(self) -> object: ...
    @property
    def key_type(self) -> lief.PE.x509.KEY_TYPES: ...
    @property
    def key_usage(self) -> List[lief.PE.x509.KEY_USAGE]: ...
    @property
    def raw(self) -> bytes: ...
    @property
    def rsa_info(self) -> lief.PE.RsaInfo: ...
    @property
    def serial_number(self) -> bytes: ...
    @property
    def signature(self) -> bytes: ...
    @property
    def signature_algorithm(self) -> str: ...
    @property
    def subject(self) -> object: ...
    @property
    def valid_from(self) -> List[int]: ...
    @property
    def valid_to(self) -> List[int]: ...
    @property
    def version(self) -> int: ...

def get_imphash(binary: lief.PE.Binary, mode: lief.PE.IMPHASH_MODE = ...) -> str: ...
@overload
def get_type(file: str) -> object: ...
@overload
def get_type(raw: List[int]) -> object: ...
@overload
def is_pe(file: str) -> bool: ...
@overload
def is_pe(raw: List[int]) -> bool: ...
def oid_to_string(arg0: str) -> str: ...
@overload
def parse(filename: str) -> lief.PE.Binary | None: ...
@overload
def parse(raw: List[int], name: str = ...) -> lief.PE.Binary | None: ...
@overload
def parse(io: object, name: str = ...) -> lief.PE.Binary | None: ...
def resolve_ordinals(imp: lief.PE.Import, strict: bool = ..., use_std: bool = ...) -> object: ...
