/* Copyright 2022 - 2024 R. Thomas
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
#ifndef LIEF_ASM_MIPS_REGISTER_H
#define LIEF_ASM_MIPS_REGISTER_H
namespace LIEF {
namespace assembly {
namespace mips {
enum class REG;
const char* get_register_name(REG r);

enum class REG {
  NoRegister = 0,
  AT = 1,
  DSPCCond = 2,
  DSPCarry = 3,
  DSPEFI = 4,
  DSPOutFlag = 5,
  DSPPos = 6,
  DSPSCount = 7,
  FP = 8,
  GP = 9,
  MSAAccess = 10,
  MSACSR = 11,
  MSAIR = 12,
  MSAMap = 13,
  MSAModify = 14,
  MSARequest = 15,
  MSASave = 16,
  MSAUnmap = 17,
  PC = 18,
  RA = 19,
  SP = 20,
  ZERO = 21,
  A0 = 22,
  A1 = 23,
  A2 = 24,
  A3 = 25,
  AC0 = 26,
  AC1 = 27,
  AC2 = 28,
  AC3 = 29,
  AT_64 = 30,
  COP00 = 31,
  COP01 = 32,
  COP02 = 33,
  COP03 = 34,
  COP04 = 35,
  COP05 = 36,
  COP06 = 37,
  COP07 = 38,
  COP08 = 39,
  COP09 = 40,
  COP20 = 41,
  COP21 = 42,
  COP22 = 43,
  COP23 = 44,
  COP24 = 45,
  COP25 = 46,
  COP26 = 47,
  COP27 = 48,
  COP28 = 49,
  COP29 = 50,
  COP30 = 51,
  COP31 = 52,
  COP32 = 53,
  COP33 = 54,
  COP34 = 55,
  COP35 = 56,
  COP36 = 57,
  COP37 = 58,
  COP38 = 59,
  COP39 = 60,
  COP010 = 61,
  COP011 = 62,
  COP012 = 63,
  COP013 = 64,
  COP014 = 65,
  COP015 = 66,
  COP016 = 67,
  COP017 = 68,
  COP018 = 69,
  COP019 = 70,
  COP020 = 71,
  COP021 = 72,
  COP022 = 73,
  COP023 = 74,
  COP024 = 75,
  COP025 = 76,
  COP026 = 77,
  COP027 = 78,
  COP028 = 79,
  COP029 = 80,
  COP030 = 81,
  COP031 = 82,
  COP210 = 83,
  COP211 = 84,
  COP212 = 85,
  COP213 = 86,
  COP214 = 87,
  COP215 = 88,
  COP216 = 89,
  COP217 = 90,
  COP218 = 91,
  COP219 = 92,
  COP220 = 93,
  COP221 = 94,
  COP222 = 95,
  COP223 = 96,
  COP224 = 97,
  COP225 = 98,
  COP226 = 99,
  COP227 = 100,
  COP228 = 101,
  COP229 = 102,
  COP230 = 103,
  COP231 = 104,
  COP310 = 105,
  COP311 = 106,
  COP312 = 107,
  COP313 = 108,
  COP314 = 109,
  COP315 = 110,
  COP316 = 111,
  COP317 = 112,
  COP318 = 113,
  COP319 = 114,
  COP320 = 115,
  COP321 = 116,
  COP322 = 117,
  COP323 = 118,
  COP324 = 119,
  COP325 = 120,
  COP326 = 121,
  COP327 = 122,
  COP328 = 123,
  COP329 = 124,
  COP330 = 125,
  COP331 = 126,
  D0 = 127,
  D1 = 128,
  D2 = 129,
  D3 = 130,
  D4 = 131,
  D5 = 132,
  D6 = 133,
  D7 = 134,
  D8 = 135,
  D9 = 136,
  D10 = 137,
  D11 = 138,
  D12 = 139,
  D13 = 140,
  D14 = 141,
  D15 = 142,
  DSPOutFlag20 = 143,
  DSPOutFlag21 = 144,
  DSPOutFlag22 = 145,
  DSPOutFlag23 = 146,
  F0 = 147,
  F1 = 148,
  F2 = 149,
  F3 = 150,
  F4 = 151,
  F5 = 152,
  F6 = 153,
  F7 = 154,
  F8 = 155,
  F9 = 156,
  F10 = 157,
  F11 = 158,
  F12 = 159,
  F13 = 160,
  F14 = 161,
  F15 = 162,
  F16 = 163,
  F17 = 164,
  F18 = 165,
  F19 = 166,
  F20 = 167,
  F21 = 168,
  F22 = 169,
  F23 = 170,
  F24 = 171,
  F25 = 172,
  F26 = 173,
  F27 = 174,
  F28 = 175,
  F29 = 176,
  F30 = 177,
  F31 = 178,
  FCC0 = 179,
  FCC1 = 180,
  FCC2 = 181,
  FCC3 = 182,
  FCC4 = 183,
  FCC5 = 184,
  FCC6 = 185,
  FCC7 = 186,
  FCR0 = 187,
  FCR1 = 188,
  FCR2 = 189,
  FCR3 = 190,
  FCR4 = 191,
  FCR5 = 192,
  FCR6 = 193,
  FCR7 = 194,
  FCR8 = 195,
  FCR9 = 196,
  FCR10 = 197,
  FCR11 = 198,
  FCR12 = 199,
  FCR13 = 200,
  FCR14 = 201,
  FCR15 = 202,
  FCR16 = 203,
  FCR17 = 204,
  FCR18 = 205,
  FCR19 = 206,
  FCR20 = 207,
  FCR21 = 208,
  FCR22 = 209,
  FCR23 = 210,
  FCR24 = 211,
  FCR25 = 212,
  FCR26 = 213,
  FCR27 = 214,
  FCR28 = 215,
  FCR29 = 216,
  FCR30 = 217,
  FCR31 = 218,
  FP_64 = 219,
  F_HI0 = 220,
  F_HI1 = 221,
  F_HI2 = 222,
  F_HI3 = 223,
  F_HI4 = 224,
  F_HI5 = 225,
  F_HI6 = 226,
  F_HI7 = 227,
  F_HI8 = 228,
  F_HI9 = 229,
  F_HI10 = 230,
  F_HI11 = 231,
  F_HI12 = 232,
  F_HI13 = 233,
  F_HI14 = 234,
  F_HI15 = 235,
  F_HI16 = 236,
  F_HI17 = 237,
  F_HI18 = 238,
  F_HI19 = 239,
  F_HI20 = 240,
  F_HI21 = 241,
  F_HI22 = 242,
  F_HI23 = 243,
  F_HI24 = 244,
  F_HI25 = 245,
  F_HI26 = 246,
  F_HI27 = 247,
  F_HI28 = 248,
  F_HI29 = 249,
  F_HI30 = 250,
  F_HI31 = 251,
  GP_64 = 252,
  HI0 = 253,
  HI1 = 254,
  HI2 = 255,
  HI3 = 256,
  HWR0 = 257,
  HWR1 = 258,
  HWR2 = 259,
  HWR3 = 260,
  HWR4 = 261,
  HWR5 = 262,
  HWR6 = 263,
  HWR7 = 264,
  HWR8 = 265,
  HWR9 = 266,
  HWR10 = 267,
  HWR11 = 268,
  HWR12 = 269,
  HWR13 = 270,
  HWR14 = 271,
  HWR15 = 272,
  HWR16 = 273,
  HWR17 = 274,
  HWR18 = 275,
  HWR19 = 276,
  HWR20 = 277,
  HWR21 = 278,
  HWR22 = 279,
  HWR23 = 280,
  HWR24 = 281,
  HWR25 = 282,
  HWR26 = 283,
  HWR27 = 284,
  HWR28 = 285,
  HWR29 = 286,
  HWR30 = 287,
  HWR31 = 288,
  K0 = 289,
  K1 = 290,
  LO0 = 291,
  LO1 = 292,
  LO2 = 293,
  LO3 = 294,
  MPL0 = 295,
  MPL1 = 296,
  MPL2 = 297,
  MSA8 = 298,
  MSA9 = 299,
  MSA10 = 300,
  MSA11 = 301,
  MSA12 = 302,
  MSA13 = 303,
  MSA14 = 304,
  MSA15 = 305,
  MSA16 = 306,
  MSA17 = 307,
  MSA18 = 308,
  MSA19 = 309,
  MSA20 = 310,
  MSA21 = 311,
  MSA22 = 312,
  MSA23 = 313,
  MSA24 = 314,
  MSA25 = 315,
  MSA26 = 316,
  MSA27 = 317,
  MSA28 = 318,
  MSA29 = 319,
  MSA30 = 320,
  MSA31 = 321,
  P0 = 322,
  P1 = 323,
  P2 = 324,
  RA_64 = 325,
  S0 = 326,
  S1 = 327,
  S2 = 328,
  S3 = 329,
  S4 = 330,
  S5 = 331,
  S6 = 332,
  S7 = 333,
  SP_64 = 334,
  T0 = 335,
  T1 = 336,
  T2 = 337,
  T3 = 338,
  T4 = 339,
  T5 = 340,
  T6 = 341,
  T7 = 342,
  T8 = 343,
  T9 = 344,
  V0 = 345,
  V1 = 346,
  W0 = 347,
  W1 = 348,
  W2 = 349,
  W3 = 350,
  W4 = 351,
  W5 = 352,
  W6 = 353,
  W7 = 354,
  W8 = 355,
  W9 = 356,
  W10 = 357,
  W11 = 358,
  W12 = 359,
  W13 = 360,
  W14 = 361,
  W15 = 362,
  W16 = 363,
  W17 = 364,
  W18 = 365,
  W19 = 366,
  W20 = 367,
  W21 = 368,
  W22 = 369,
  W23 = 370,
  W24 = 371,
  W25 = 372,
  W26 = 373,
  W27 = 374,
  W28 = 375,
  W29 = 376,
  W30 = 377,
  W31 = 378,
  ZERO_64 = 379,
  A0_64 = 380,
  A1_64 = 381,
  A2_64 = 382,
  A3_64 = 383,
  AC0_64 = 384,
  D0_64 = 385,
  D1_64 = 386,
  D2_64 = 387,
  D3_64 = 388,
  D4_64 = 389,
  D5_64 = 390,
  D6_64 = 391,
  D7_64 = 392,
  D8_64 = 393,
  D9_64 = 394,
  D10_64 = 395,
  D11_64 = 396,
  D12_64 = 397,
  D13_64 = 398,
  D14_64 = 399,
  D15_64 = 400,
  D16_64 = 401,
  D17_64 = 402,
  D18_64 = 403,
  D19_64 = 404,
  D20_64 = 405,
  D21_64 = 406,
  D22_64 = 407,
  D23_64 = 408,
  D24_64 = 409,
  D25_64 = 410,
  D26_64 = 411,
  D27_64 = 412,
  D28_64 = 413,
  D29_64 = 414,
  D30_64 = 415,
  D31_64 = 416,
  DSPOutFlag16_19 = 417,
  HI0_64 = 418,
  K0_64 = 419,
  K1_64 = 420,
  LO0_64 = 421,
  S0_64 = 422,
  S1_64 = 423,
  S2_64 = 424,
  S3_64 = 425,
  S4_64 = 426,
  S5_64 = 427,
  S6_64 = 428,
  S7_64 = 429,
  T0_64 = 430,
  T1_64 = 431,
  T2_64 = 432,
  T3_64 = 433,
  T4_64 = 434,
  T5_64 = 435,
  T6_64 = 436,
  T7_64 = 437,
  T8_64 = 438,
  T9_64 = 439,
  V0_64 = 440,
  V1_64 = 441,
  NUM_TARGET_REGS = 442,
};

}
}
}
#endif
