/* Copyright 2017 - 2024 R. Thomas
 * Copyright 2017 - 2024 Quarkslab
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
#ifndef LIEF_PE_KERNEL32_DLL_LOOKUP_H
#define LIEF_PE_KERNEL32_DLL_LOOKUP_H
#include <cstdint>

namespace LIEF {
namespace PE {

inline const char* kernel32_dll_lookup(uint32_t i) {
  switch(i) {
  case 0x0001: return "ActivateActCtx";
  case 0x0002: return "AddAtomA";
  case 0x0003: return "AddAtomW";
  case 0x0004: return "AddConsoleAliasA";
  case 0x0005: return "AddConsoleAliasW";
  case 0x0006: return "AddLocalAlternateComputerNameA";
  case 0x0007: return "AddLocalAlternateComputerNameW";
  case 0x0008: return "AddRefActCtx";
  case 0x0009: return "AddVectoredExceptionHandler";
  case 0x000a: return "AllocConsole";
  case 0x000b: return "AllocateUserPhysicalPages";
  case 0x000c: return "AreFileApisANSI";
  case 0x000d: return "AssignProcessToJobObject";
  case 0x000e: return "AttachConsole";
  case 0x000f: return "BackupRead";
  case 0x0010: return "BackupSeek";
  case 0x0011: return "BackupWrite";
  case 0x0012: return "BaseCheckAppcompatCache";
  case 0x0013: return "BaseCleanupAppcompatCache";
  case 0x0014: return "BaseCleanupAppcompatCacheSupport";
  case 0x0015: return "BaseDumpAppcompatCache";
  case 0x0016: return "BaseFlushAppcompatCache";
  case 0x0017: return "BaseInitAppcompatCache";
  case 0x0018: return "BaseInitAppcompatCacheSupport";
  case 0x0019: return "BaseProcessInitPostImport";
  case 0x001a: return "BaseQueryModuleData";
  case 0x001b: return "BaseUpdateAppcompatCache";
  case 0x001c: return "BasepCheckWinSaferRestrictions";
  case 0x001d: return "Beep";
  case 0x001e: return "BeginUpdateResourceA";
  case 0x001f: return "BeginUpdateResourceW";
  case 0x0020: return "BindIoCompletionCallback";
  case 0x0021: return "BuildCommDCBA";
  case 0x0022: return "BuildCommDCBAndTimeoutsA";
  case 0x0023: return "BuildCommDCBAndTimeoutsW";
  case 0x0024: return "BuildCommDCBW";
  case 0x0025: return "CallNamedPipeA";
  case 0x0026: return "CallNamedPipeW";
  case 0x0027: return "CancelDeviceWakeupRequest";
  case 0x0028: return "CancelIo";
  case 0x0029: return "CancelTimerQueueTimer";
  case 0x002a: return "CancelWaitableTimer";
  case 0x002b: return "ChangeTimerQueueTimer";
  case 0x002c: return "CheckNameLegalDOS8Dot3A";
  case 0x002d: return "CheckNameLegalDOS8Dot3W";
  case 0x002e: return "CheckRemoteDebuggerPresent";
  case 0x002f: return "ClearCommBreak";
  case 0x0030: return "ClearCommError";
  case 0x0031: return "CloseConsoleHandle";
  case 0x0032: return "CloseHandle";
  case 0x0033: return "CloseProfileUserMapping";
  case 0x0034: return "CmdBatNotification";
  case 0x0035: return "CommConfigDialogA";
  case 0x0036: return "CommConfigDialogW";
  case 0x0037: return "CompareFileTime";
  case 0x0038: return "CompareStringA";
  case 0x0039: return "CompareStringW";
  case 0x003a: return "ConnectNamedPipe";
  case 0x003b: return "ConsoleMenuControl";
  case 0x003c: return "ContinueDebugEvent";
  case 0x003d: return "ConvertDefaultLocale";
  case 0x003e: return "ConvertFiberToThread";
  case 0x003f: return "ConvertThreadToFiber";
  case 0x0040: return "CopyFileA";
  case 0x0041: return "CopyFileExA";
  case 0x0042: return "CopyFileExW";
  case 0x0043: return "CopyFileW";
  case 0x0044: return "CopyLZFile";
  case 0x0045: return "CreateActCtxA";
  case 0x0046: return "CreateActCtxW";
  case 0x0047: return "CreateConsoleScreenBuffer";
  case 0x0048: return "CreateDirectoryA";
  case 0x0049: return "CreateDirectoryExA";
  case 0x004a: return "CreateDirectoryExW";
  case 0x004b: return "CreateDirectoryW";
  case 0x004c: return "CreateEventA";
  case 0x004d: return "CreateEventW";
  case 0x004e: return "CreateFiber";
  case 0x004f: return "CreateFiberEx";
  case 0x0050: return "CreateFileA";
  case 0x0051: return "CreateFileMappingA";
  case 0x0052: return "CreateFileMappingW";
  case 0x0053: return "CreateFileW";
  case 0x0054: return "CreateHardLinkA";
  case 0x0055: return "CreateHardLinkW";
  case 0x0056: return "CreateIoCompletionPort";
  case 0x0057: return "CreateJobObjectA";
  case 0x0058: return "CreateJobObjectW";
  case 0x0059: return "CreateJobSet";
  case 0x005a: return "CreateMailslotA";
  case 0x005b: return "CreateMailslotW";
  case 0x005c: return "CreateMemoryResourceNotification";
  case 0x005d: return "CreateMutexA";
  case 0x005e: return "CreateMutexW";
  case 0x005f: return "CreateNamedPipeA";
  case 0x0060: return "CreateNamedPipeW";
  case 0x0061: return "CreateNlsSecurityDescriptor";
  case 0x0062: return "CreatePipe";
  case 0x0063: return "CreateProcessA";
  case 0x0064: return "CreateProcessInternalA";
  case 0x0065: return "CreateProcessInternalW";
  case 0x0066: return "CreateProcessInternalWSecure";
  case 0x0067: return "CreateProcessW";
  case 0x0068: return "CreateRemoteThread";
  case 0x0069: return "CreateSemaphoreA";
  case 0x006a: return "CreateSemaphoreW";
  case 0x006b: return "CreateSocketHandle";
  case 0x006c: return "CreateTapePartition";
  case 0x006d: return "CreateThread";
  case 0x006e: return "CreateTimerQueue";
  case 0x006f: return "CreateTimerQueueTimer";
  case 0x0070: return "CreateToolhelp32Snapshot";
  case 0x0071: return "CreateVirtualBuffer";
  case 0x0072: return "CreateWaitableTimerA";
  case 0x0073: return "CreateWaitableTimerW";
  case 0x0074: return "DeactivateActCtx";
  case 0x0075: return "DebugActiveProcess";
  case 0x0076: return "DebugActiveProcessStop";
  case 0x0077: return "DebugBreak";
  case 0x0078: return "DebugBreakProcess";
  case 0x0079: return "DebugSetProcessKillOnExit";
  case 0x007a: return "DecodePointer";
  case 0x007b: return "DecodeSystemPointer";
  case 0x007c: return "DefineDosDeviceA";
  case 0x007d: return "DefineDosDeviceW";
  case 0x007e: return "DelayLoadFailureHook";
  case 0x007f: return "DeleteAtom";
  case 0x0080: return "DeleteCriticalSection";
  case 0x0081: return "DeleteFiber";
  case 0x0082: return "DeleteFileA";
  case 0x0083: return "DeleteFileW";
  case 0x0084: return "DeleteTimerQueue";
  case 0x0085: return "DeleteTimerQueueEx";
  case 0x0086: return "DeleteTimerQueueTimer";
  case 0x0087: return "DeleteVolumeMountPointA";
  case 0x0088: return "DeleteVolumeMountPointW";
  case 0x0089: return "DeviceIoControl";
  case 0x008a: return "DisableThreadLibraryCalls";
  case 0x008b: return "DisconnectNamedPipe";
  case 0x008c: return "DnsHostnameToComputerNameA";
  case 0x008d: return "DnsHostnameToComputerNameW";
  case 0x008e: return "DosDateTimeToFileTime";
  case 0x008f: return "DosPathToSessionPathA";
  case 0x0090: return "DosPathToSessionPathW";
  case 0x0091: return "DuplicateConsoleHandle";
  case 0x0092: return "DuplicateHandle";
  case 0x0093: return "EncodePointer";
  case 0x0094: return "EncodeSystemPointer";
  case 0x0095: return "EndUpdateResourceA";
  case 0x0096: return "EndUpdateResourceW";
  case 0x0097: return "EnterCriticalSection";
  case 0x0098: return "EnumCalendarInfoA";
  case 0x0099: return "EnumCalendarInfoExA";
  case 0x009a: return "EnumCalendarInfoExW";
  case 0x009b: return "EnumCalendarInfoW";
  case 0x009c: return "EnumDateFormatsA";
  case 0x009d: return "EnumDateFormatsExA";
  case 0x009e: return "EnumDateFormatsExW";
  case 0x009f: return "EnumDateFormatsW";
  case 0x00a0: return "EnumLanguageGroupLocalesA";
  case 0x00a1: return "EnumLanguageGroupLocalesW";
  case 0x00a2: return "EnumResourceLanguagesA";
  case 0x00a3: return "EnumResourceLanguagesW";
  case 0x00a4: return "EnumResourceNamesA";
  case 0x00a5: return "EnumResourceNamesW";
  case 0x00a6: return "EnumResourceTypesA";
  case 0x00a7: return "EnumResourceTypesW";
  case 0x00a8: return "EnumSystemCodePagesA";
  case 0x00a9: return "EnumSystemCodePagesW";
  case 0x00aa: return "EnumSystemGeoID";
  case 0x00ab: return "EnumSystemLanguageGroupsA";
  case 0x00ac: return "EnumSystemLanguageGroupsW";
  case 0x00ad: return "EnumSystemLocalesA";
  case 0x00ae: return "EnumSystemLocalesW";
  case 0x00af: return "EnumTimeFormatsA";
  case 0x00b0: return "EnumTimeFormatsW";
  case 0x00b1: return "EnumUILanguagesA";
  case 0x00b2: return "EnumUILanguagesW";
  case 0x00b3: return "EnumerateLocalComputerNamesA";
  case 0x00b4: return "EnumerateLocalComputerNamesW";
  case 0x00b5: return "EraseTape";
  case 0x00b6: return "EscapeCommFunction";
  case 0x00b7: return "ExitProcess";
  case 0x00b8: return "ExitThread";
  case 0x00b9: return "ExitVDM";
  case 0x00ba: return "ExpandEnvironmentStringsA";
  case 0x00bb: return "ExpandEnvironmentStringsW";
  case 0x00bc: return "ExpungeConsoleCommandHistoryA";
  case 0x00bd: return "ExpungeConsoleCommandHistoryW";
  case 0x00be: return "ExtendVirtualBuffer";
  case 0x00bf: return "FatalAppExitA";
  case 0x00c0: return "FatalAppExitW";
  case 0x00c1: return "FatalExit";
  case 0x00c2: return "FileTimeToDosDateTime";
  case 0x00c3: return "FileTimeToLocalFileTime";
  case 0x00c4: return "FileTimeToSystemTime";
  case 0x00c5: return "FillConsoleOutputAttribute";
  case 0x00c6: return "FillConsoleOutputCharacterA";
  case 0x00c7: return "FillConsoleOutputCharacterW";
  case 0x00c8: return "FindActCtxSectionGuid";
  case 0x00c9: return "FindActCtxSectionStringA";
  case 0x00ca: return "FindActCtxSectionStringW";
  case 0x00cb: return "FindAtomA";
  case 0x00cc: return "FindAtomW";
  case 0x00cd: return "FindClose";
  case 0x00ce: return "FindCloseChangeNotification";
  case 0x00cf: return "FindFirstChangeNotificationA";
  case 0x00d0: return "FindFirstChangeNotificationW";
  case 0x00d1: return "FindFirstFileA";
  case 0x00d2: return "FindFirstFileExA";
  case 0x00d3: return "FindFirstFileExW";
  case 0x00d4: return "FindFirstFileW";
  case 0x00d5: return "FindFirstVolumeA";
  case 0x00d6: return "FindFirstVolumeMountPointA";
  case 0x00d7: return "FindFirstVolumeMountPointW";
  case 0x00d8: return "FindFirstVolumeW";
  case 0x00d9: return "FindNextChangeNotification";
  case 0x00da: return "FindNextFileA";
  case 0x00db: return "FindNextFileW";
  case 0x00dc: return "FindNextVolumeA";
  case 0x00dd: return "FindNextVolumeMountPointA";
  case 0x00de: return "FindNextVolumeMountPointW";
  case 0x00df: return "FindNextVolumeW";
  case 0x00e0: return "FindResourceA";
  case 0x00e1: return "FindResourceExA";
  case 0x00e2: return "FindResourceExW";
  case 0x00e3: return "FindResourceW";
  case 0x00e4: return "FindVolumeClose";
  case 0x00e5: return "FindVolumeMountPointClose";
  case 0x00e6: return "FlushConsoleInputBuffer";
  case 0x00e7: return "FlushFileBuffers";
  case 0x00e8: return "FlushInstructionCache";
  case 0x00e9: return "FlushViewOfFile";
  case 0x00ea: return "FoldStringA";
  case 0x00eb: return "FoldStringW";
  case 0x00ec: return "FormatMessageA";
  case 0x00ed: return "FormatMessageW";
  case 0x00ee: return "FreeConsole";
  case 0x00ef: return "FreeEnvironmentStringsA";
  case 0x00f0: return "FreeEnvironmentStringsW";
  case 0x00f1: return "FreeLibrary";
  case 0x00f2: return "FreeLibraryAndExitThread";
  case 0x00f3: return "FreeResource";
  case 0x00f4: return "FreeUserPhysicalPages";
  case 0x00f5: return "FreeVirtualBuffer";
  case 0x00f6: return "GenerateConsoleCtrlEvent";
  case 0x00f7: return "GetACP";
  case 0x00f8: return "GetAtomNameA";
  case 0x00f9: return "GetAtomNameW";
  case 0x00fa: return "GetBinaryType";
  case 0x00fb: return "GetBinaryTypeA";
  case 0x00fc: return "GetBinaryTypeW";
  case 0x00fd: return "GetCPFileNameFromRegistry";
  case 0x00fe: return "GetCPInfo";
  case 0x00ff: return "GetCPInfoExA";
  case 0x0100: return "GetCPInfoExW";
  case 0x0101: return "GetCalendarInfoA";
  case 0x0102: return "GetCalendarInfoW";
  case 0x0103: return "GetComPlusPackageInstallStatus";
  case 0x0104: return "GetCommConfig";
  case 0x0105: return "GetCommMask";
  case 0x0106: return "GetCommModemStatus";
  case 0x0107: return "GetCommProperties";
  case 0x0108: return "GetCommState";
  case 0x0109: return "GetCommTimeouts";
  case 0x010a: return "GetCommandLineA";
  case 0x010b: return "GetCommandLineW";
  case 0x010c: return "GetCompressedFileSizeA";
  case 0x010d: return "GetCompressedFileSizeW";
  case 0x010e: return "GetComputerNameA";
  case 0x010f: return "GetComputerNameExA";
  case 0x0110: return "GetComputerNameExW";
  case 0x0111: return "GetComputerNameW";
  case 0x0112: return "GetConsoleAliasA";
  case 0x0113: return "GetConsoleAliasExesA";
  case 0x0114: return "GetConsoleAliasExesLengthA";
  case 0x0115: return "GetConsoleAliasExesLengthW";
  case 0x0116: return "GetConsoleAliasExesW";
  case 0x0117: return "GetConsoleAliasW";
  case 0x0118: return "GetConsoleAliasesA";
  case 0x0119: return "GetConsoleAliasesLengthA";
  case 0x011a: return "GetConsoleAliasesLengthW";
  case 0x011b: return "GetConsoleAliasesW";
  case 0x011c: return "GetConsoleCP";
  case 0x011d: return "GetConsoleCharType";
  case 0x011e: return "GetConsoleCommandHistoryA";
  case 0x011f: return "GetConsoleCommandHistoryLengthA";
  case 0x0120: return "GetConsoleCommandHistoryLengthW";
  case 0x0121: return "GetConsoleCommandHistoryW";
  case 0x0122: return "GetConsoleCursorInfo";
  case 0x0123: return "GetConsoleCursorMode";
  case 0x0124: return "GetConsoleDisplayMode";
  case 0x0125: return "GetConsoleFontInfo";
  case 0x0126: return "GetConsoleFontSize";
  case 0x0127: return "GetConsoleHardwareState";
  case 0x0128: return "GetConsoleInputExeNameA";
  case 0x0129: return "GetConsoleInputExeNameW";
  case 0x012a: return "GetConsoleInputWaitHandle";
  case 0x012b: return "GetConsoleKeyboardLayoutNameA";
  case 0x012c: return "GetConsoleKeyboardLayoutNameW";
  case 0x012d: return "GetConsoleMode";
  case 0x012e: return "GetConsoleNlsMode";
  case 0x012f: return "GetConsoleOutputCP";
  case 0x0130: return "GetConsoleProcessList";
  case 0x0131: return "GetConsoleScreenBufferInfo";
  case 0x0132: return "GetConsoleSelectionInfo";
  case 0x0133: return "GetConsoleTitleA";
  case 0x0134: return "GetConsoleTitleW";
  case 0x0135: return "GetConsoleWindow";
  case 0x0136: return "GetCurrencyFormatA";
  case 0x0137: return "GetCurrencyFormatW";
  case 0x0138: return "GetCurrentActCtx";
  case 0x0139: return "GetCurrentConsoleFont";
  case 0x013a: return "GetCurrentDirectoryA";
  case 0x013b: return "GetCurrentDirectoryW";
  case 0x013c: return "GetCurrentProcess";
  case 0x013d: return "GetCurrentProcessId";
  case 0x013e: return "GetCurrentThread";
  case 0x013f: return "GetCurrentThreadId";
  case 0x0140: return "GetDateFormatA";
  case 0x0141: return "GetDateFormatW";
  case 0x0142: return "GetDefaultCommConfigA";
  case 0x0143: return "GetDefaultCommConfigW";
  case 0x0144: return "GetDefaultSortkeySize";
  case 0x0145: return "GetDevicePowerState";
  case 0x0146: return "GetDiskFreeSpaceA";
  case 0x0147: return "GetDiskFreeSpaceExA";
  case 0x0148: return "GetDiskFreeSpaceExW";
  case 0x0149: return "GetDiskFreeSpaceW";
  case 0x014a: return "GetDllDirectoryA";
  case 0x014b: return "GetDllDirectoryW";
  case 0x014c: return "GetDriveTypeA";
  case 0x014d: return "GetDriveTypeW";
  case 0x014e: return "GetEnvironmentStrings";
  case 0x014f: return "GetEnvironmentStringsA";
  case 0x0150: return "GetEnvironmentStringsW";
  case 0x0151: return "GetEnvironmentVariableA";
  case 0x0152: return "GetEnvironmentVariableW";
  case 0x0153: return "GetExitCodeProcess";
  case 0x0154: return "GetExitCodeThread";
  case 0x0155: return "GetExpandedNameA";
  case 0x0156: return "GetExpandedNameW";
  case 0x0157: return "GetFileAttributesA";
  case 0x0158: return "GetFileAttributesExA";
  case 0x0159: return "GetFileAttributesExW";
  case 0x015a: return "GetFileAttributesW";
  case 0x015b: return "GetFileInformationByHandle";
  case 0x015c: return "GetFileSize";
  case 0x015d: return "GetFileSizeEx";
  case 0x015e: return "GetFileTime";
  case 0x015f: return "GetFileType";
  case 0x0160: return "GetFirmwareEnvironmentVariableA";
  case 0x0161: return "GetFirmwareEnvironmentVariableW";
  case 0x0162: return "GetFullPathNameA";
  case 0x0163: return "GetFullPathNameW";
  case 0x0164: return "GetGeoInfoA";
  case 0x0165: return "GetGeoInfoW";
  case 0x0166: return "GetHandleContext";
  case 0x0167: return "GetHandleInformation";
  case 0x0168: return "GetLargestConsoleWindowSize";
  case 0x0169: return "GetLastError";
  case 0x016a: return "GetLinguistLangSize";
  case 0x016b: return "GetLocalTime";
  case 0x016c: return "GetLocaleInfoA";
  case 0x016d: return "GetLocaleInfoW";
  case 0x016e: return "GetLogicalDriveStringsA";
  case 0x016f: return "GetLogicalDriveStringsW";
  case 0x0170: return "GetLogicalDrives";
  case 0x0171: return "GetLongPathNameA";
  case 0x0172: return "GetLongPathNameW";
  case 0x0173: return "GetMailslotInfo";
  case 0x0174: return "GetModuleFileNameA";
  case 0x0175: return "GetModuleFileNameW";
  case 0x0176: return "GetModuleHandleA";
  case 0x0177: return "GetModuleHandleExA";
  case 0x0178: return "GetModuleHandleExW";
  case 0x0179: return "GetModuleHandleW";
  case 0x017a: return "GetNamedPipeHandleStateA";
  case 0x017b: return "GetNamedPipeHandleStateW";
  case 0x017c: return "GetNamedPipeInfo";
  case 0x017d: return "GetNativeSystemInfo";
  case 0x017e: return "GetNextVDMCommand";
  case 0x017f: return "GetNlsSectionName";
  case 0x0180: return "GetNumaAvailableMemory";
  case 0x0181: return "GetNumaAvailableMemoryNode";
  case 0x0182: return "GetNumaHighestNodeNumber";
  case 0x0183: return "GetNumaNodeProcessorMask";
  case 0x0184: return "GetNumaProcessorMap";
  case 0x0185: return "GetNumaProcessorNode";
  case 0x0186: return "GetNumberFormatA";
  case 0x0187: return "GetNumberFormatW";
  case 0x0188: return "GetNumberOfConsoleFonts";
  case 0x0189: return "GetNumberOfConsoleInputEvents";
  case 0x018a: return "GetNumberOfConsoleMouseButtons";
  case 0x018b: return "GetOEMCP";
  case 0x018c: return "GetOverlappedResult";
  case 0x018d: return "GetPriorityClass";
  case 0x018e: return "GetPrivateProfileIntA";
  case 0x018f: return "GetPrivateProfileIntW";
  case 0x0190: return "GetPrivateProfileSectionA";
  case 0x0191: return "GetPrivateProfileSectionNamesA";
  case 0x0192: return "GetPrivateProfileSectionNamesW";
  case 0x0193: return "GetPrivateProfileSectionW";
  case 0x0194: return "GetPrivateProfileStringA";
  case 0x0195: return "GetPrivateProfileStringW";
  case 0x0196: return "GetPrivateProfileStructA";
  case 0x0197: return "GetPrivateProfileStructW";
  case 0x0198: return "GetProcAddress";
  case 0x0199: return "GetProcessAffinityMask";
  case 0x019a: return "GetProcessHandleCount";
  case 0x019b: return "GetProcessHeap";
  case 0x019c: return "GetProcessHeaps";
  case 0x019d: return "GetProcessId";
  case 0x019e: return "GetProcessIoCounters";
  case 0x019f: return "GetProcessPriorityBoost";
  case 0x01a0: return "GetProcessShutdownParameters";
  case 0x01a1: return "GetProcessTimes";
  case 0x01a2: return "GetProcessVersion";
  case 0x01a3: return "GetProcessWorkingSetSize";
  case 0x01a4: return "GetProfileIntA";
  case 0x01a5: return "GetProfileIntW";
  case 0x01a6: return "GetProfileSectionA";
  case 0x01a7: return "GetProfileSectionW";
  case 0x01a8: return "GetProfileStringA";
  case 0x01a9: return "GetProfileStringW";
  case 0x01aa: return "GetQueuedCompletionStatus";
  case 0x01ab: return "GetShortPathNameA";
  case 0x01ac: return "GetShortPathNameW";
  case 0x01ad: return "GetStartupInfoA";
  case 0x01ae: return "GetStartupInfoW";
  case 0x01af: return "GetStdHandle";
  case 0x01b0: return "GetStringTypeA";
  case 0x01b1: return "GetStringTypeExA";
  case 0x01b2: return "GetStringTypeExW";
  case 0x01b3: return "GetStringTypeW";
  case 0x01b4: return "GetSystemDefaultLCID";
  case 0x01b5: return "GetSystemDefaultLangID";
  case 0x01b6: return "GetSystemDefaultUILanguage";
  case 0x01b7: return "GetSystemDirectoryA";
  case 0x01b8: return "GetSystemDirectoryW";
  case 0x01b9: return "GetSystemInfo";
  case 0x01ba: return "GetSystemPowerStatus";
  case 0x01bb: return "GetSystemRegistryQuota";
  case 0x01bc: return "GetSystemTime";
  case 0x01bd: return "GetSystemTimeAdjustment";
  case 0x01be: return "GetSystemTimeAsFileTime";
  case 0x01bf: return "GetSystemTimes";
  case 0x01c0: return "GetSystemWindowsDirectoryA";
  case 0x01c1: return "GetSystemWindowsDirectoryW";
  case 0x01c2: return "GetSystemWow64DirectoryA";
  case 0x01c3: return "GetSystemWow64DirectoryW";
  case 0x01c4: return "GetTapeParameters";
  case 0x01c5: return "GetTapePosition";
  case 0x01c6: return "GetTapeStatus";
  case 0x01c7: return "GetTempFileNameA";
  case 0x01c8: return "GetTempFileNameW";
  case 0x01c9: return "GetTempPathA";
  case 0x01ca: return "GetTempPathW";
  case 0x01cb: return "GetThreadContext";
  case 0x01cc: return "GetThreadIOPendingFlag";
  case 0x01cd: return "GetThreadLocale";
  case 0x01ce: return "GetThreadPriority";
  case 0x01cf: return "GetThreadPriorityBoost";
  case 0x01d0: return "GetThreadSelectorEntry";
  case 0x01d1: return "GetThreadTimes";
  case 0x01d2: return "GetTickCount";
  case 0x01d3: return "GetTimeFormatA";
  case 0x01d4: return "GetTimeFormatW";
  case 0x01d5: return "GetTimeZoneInformation";
  case 0x01d6: return "GetUserDefaultLCID";
  case 0x01d7: return "GetUserDefaultLangID";
  case 0x01d8: return "GetUserDefaultUILanguage";
  case 0x01d9: return "GetUserGeoID";
  case 0x01da: return "GetVDMCurrentDirectories";
  case 0x01db: return "GetVersion";
  case 0x01dc: return "GetVersionExA";
  case 0x01dd: return "GetVersionExW";
  case 0x01de: return "GetVolumeInformationA";
  case 0x01df: return "GetVolumeInformationW";
  case 0x01e0: return "GetVolumeNameForVolumeMountPointA";
  case 0x01e1: return "GetVolumeNameForVolumeMountPointW";
  case 0x01e2: return "GetVolumePathNameA";
  case 0x01e3: return "GetVolumePathNameW";
  case 0x01e4: return "GetVolumePathNamesForVolumeNameA";
  case 0x01e5: return "GetVolumePathNamesForVolumeNameW";
  case 0x01e6: return "GetWindowsDirectoryA";
  case 0x01e7: return "GetWindowsDirectoryW";
  case 0x01e8: return "GetWriteWatch";
  case 0x01e9: return "GlobalAddAtomA";
  case 0x01ea: return "GlobalAddAtomW";
  case 0x01eb: return "GlobalAlloc";
  case 0x01ec: return "GlobalCompact";
  case 0x01ed: return "GlobalDeleteAtom";
  case 0x01ee: return "GlobalFindAtomA";
  case 0x01ef: return "GlobalFindAtomW";
  case 0x01f0: return "GlobalFix";
  case 0x01f1: return "GlobalFlags";
  case 0x01f2: return "GlobalFree";
  case 0x01f3: return "GlobalGetAtomNameA";
  case 0x01f4: return "GlobalGetAtomNameW";
  case 0x01f5: return "GlobalHandle";
  case 0x01f6: return "GlobalLock";
  case 0x01f7: return "GlobalMemoryStatus";
  case 0x01f8: return "GlobalMemoryStatusEx";
  case 0x01f9: return "GlobalReAlloc";
  case 0x01fa: return "GlobalSize";
  case 0x01fb: return "GlobalUnWire";
  case 0x01fc: return "GlobalUnfix";
  case 0x01fd: return "GlobalUnlock";
  case 0x01fe: return "GlobalWire";
  case 0x01ff: return "Heap32First";
  case 0x0200: return "Heap32ListFirst";
  case 0x0201: return "Heap32ListNext";
  case 0x0202: return "Heap32Next";
  case 0x0203: return "HeapAlloc";
  case 0x0204: return "HeapCompact";
  case 0x0205: return "HeapCreate";
  case 0x0206: return "HeapCreateTagsW";
  case 0x0207: return "HeapDestroy";
  case 0x0208: return "HeapExtend";
  case 0x0209: return "HeapFree";
  case 0x020a: return "HeapLock";
  case 0x020b: return "HeapQueryInformation";
  case 0x020c: return "HeapQueryTagW";
  case 0x020d: return "HeapReAlloc";
  case 0x020e: return "HeapSetInformation";
  case 0x020f: return "HeapSize";
  case 0x0210: return "HeapSummary";
  case 0x0211: return "HeapUnlock";
  case 0x0212: return "HeapUsage";
  case 0x0213: return "HeapValidate";
  case 0x0214: return "HeapWalk";
  case 0x0215: return "InitAtomTable";
  case 0x0216: return "InitializeCriticalSection";
  case 0x0217: return "InitializeCriticalSectionAndSpinCount";
  case 0x0218: return "InitializeSListHead";
  case 0x0219: return "InterlockedCompareExchange";
  case 0x021a: return "InterlockedDecrement";
  case 0x021b: return "InterlockedExchange";
  case 0x021c: return "InterlockedExchangeAdd";
  case 0x021d: return "InterlockedFlushSList";
  case 0x021e: return "InterlockedIncrement";
  case 0x021f: return "InterlockedPopEntrySList";
  case 0x0220: return "InterlockedPushEntrySList";
  case 0x0221: return "InvalidateConsoleDIBits";
  case 0x0222: return "IsBadCodePtr";
  case 0x0223: return "IsBadHugeReadPtr";
  case 0x0224: return "IsBadHugeWritePtr";
  case 0x0225: return "IsBadReadPtr";
  case 0x0226: return "IsBadStringPtrA";
  case 0x0227: return "IsBadStringPtrW";
  case 0x0228: return "IsBadWritePtr";
  case 0x0229: return "IsDBCSLeadByte";
  case 0x022a: return "IsDBCSLeadByteEx";
  case 0x022b: return "IsDebuggerPresent";
  case 0x022c: return "IsProcessInJob";
  case 0x022d: return "IsProcessorFeaturePresent";
  case 0x022e: return "IsSystemResumeAutomatic";
  case 0x022f: return "IsValidCodePage";
  case 0x0230: return "IsValidLanguageGroup";
  case 0x0231: return "IsValidLocale";
  case 0x0232: return "IsValidUILanguage";
  case 0x0233: return "IsWow64Process";
  case 0x0234: return "LCMapStringA";
  case 0x0235: return "LCMapStringW";
  case 0x0236: return "LZClose";
  case 0x0237: return "LZCloseFile";
  case 0x0238: return "LZCopy";
  case 0x0239: return "LZCreateFileW";
  case 0x023a: return "LZDone";
  case 0x023b: return "LZInit";
  case 0x023c: return "LZOpenFileA";
  case 0x023d: return "LZOpenFileW";
  case 0x023e: return "LZRead";
  case 0x023f: return "LZSeek";
  case 0x0240: return "LZStart";
  case 0x0241: return "LeaveCriticalSection";
  case 0x0242: return "LoadLibraryA";
  case 0x0243: return "LoadLibraryExA";
  case 0x0244: return "LoadLibraryExW";
  case 0x0245: return "LoadLibraryW";
  case 0x0246: return "LoadModule";
  case 0x0247: return "LoadResource";
  case 0x0248: return "LocalAlloc";
  case 0x0249: return "LocalCompact";
  case 0x024a: return "LocalFileTimeToFileTime";
  case 0x024b: return "LocalFlags";
  case 0x024c: return "LocalFree";
  case 0x024d: return "LocalHandle";
  case 0x024e: return "LocalLock";
  case 0x024f: return "LocalReAlloc";
  case 0x0250: return "LocalShrink";
  case 0x0251: return "LocalSize";
  case 0x0252: return "LocalUnlock";
  case 0x0253: return "LockFile";
  case 0x0254: return "LockFileEx";
  case 0x0255: return "LockResource";
  case 0x0256: return "MapUserPhysicalPages";
  case 0x0257: return "MapUserPhysicalPagesScatter";
  case 0x0258: return "MapViewOfFile";
  case 0x0259: return "MapViewOfFileEx";
  case 0x025a: return "Module32First";
  case 0x025b: return "Module32FirstW";
  case 0x025c: return "Module32Next";
  case 0x025d: return "Module32NextW";
  case 0x025e: return "MoveFileA";
  case 0x025f: return "MoveFileExA";
  case 0x0260: return "MoveFileExW";
  case 0x0261: return "MoveFileW";
  case 0x0262: return "MoveFileWithProgressA";
  case 0x0263: return "MoveFileWithProgressW";
  case 0x0264: return "MulDiv";
  case 0x0265: return "MultiByteToWideChar";
  case 0x0266: return "NlsConvertIntegerToString";
  case 0x0267: return "NlsGetCacheUpdateCount";
  case 0x0268: return "NlsResetProcessLocale";
  case 0x0269: return "NumaVirtualQueryNode";
  case 0x026a: return "OpenConsoleW";
  case 0x026b: return "OpenDataFile";
  case 0x026c: return "OpenEventA";
  case 0x026d: return "OpenEventW";
  case 0x026e: return "OpenFile";
  case 0x026f: return "OpenFileMappingA";
  case 0x0270: return "OpenFileMappingW";
  case 0x0271: return "OpenJobObjectA";
  case 0x0272: return "OpenJobObjectW";
  case 0x0273: return "OpenMutexA";
  case 0x0274: return "OpenMutexW";
  case 0x0275: return "OpenProcess";
  case 0x0276: return "OpenProfileUserMapping";
  case 0x0277: return "OpenSemaphoreA";
  case 0x0278: return "OpenSemaphoreW";
  case 0x0279: return "OpenThread";
  case 0x027a: return "OpenWaitableTimerA";
  case 0x027b: return "OpenWaitableTimerW";
  case 0x027c: return "OutputDebugStringA";
  case 0x027d: return "OutputDebugStringW";
  case 0x027e: return "PeekConsoleInputA";
  case 0x027f: return "PeekConsoleInputW";
  case 0x0280: return "PeekNamedPipe";
  case 0x0281: return "PostQueuedCompletionStatus";
  case 0x0282: return "PrepareTape";
  case 0x0283: return "PrivCopyFileExW";
  case 0x0284: return "PrivMoveFileIdentityW";
  case 0x0285: return "Process32First";
  case 0x0286: return "Process32FirstW";
  case 0x0287: return "Process32Next";
  case 0x0288: return "Process32NextW";
  case 0x0289: return "ProcessIdToSessionId";
  case 0x028a: return "PulseEvent";
  case 0x028b: return "PurgeComm";
  case 0x028c: return "QueryActCtxW";
  case 0x028d: return "QueryDepthSList";
  case 0x028e: return "QueryDosDeviceA";
  case 0x028f: return "QueryDosDeviceW";
  case 0x0290: return "QueryInformationJobObject";
  case 0x0291: return "QueryMemoryResourceNotification";
  case 0x0292: return "QueryPerformanceCounter";
  case 0x0293: return "QueryPerformanceFrequency";
  case 0x0294: return "QueryWin31IniFilesMappedToRegistry";
  case 0x0295: return "QueueUserAPC";
  case 0x0296: return "QueueUserWorkItem";
  case 0x0297: return "RaiseException";
  case 0x0298: return "ReadConsoleA";
  case 0x0299: return "ReadConsoleInputA";
  case 0x029a: return "ReadConsoleInputExA";
  case 0x029b: return "ReadConsoleInputExW";
  case 0x029c: return "ReadConsoleInputW";
  case 0x029d: return "ReadConsoleOutputA";
  case 0x029e: return "ReadConsoleOutputAttribute";
  case 0x029f: return "ReadConsoleOutputCharacterA";
  case 0x02a0: return "ReadConsoleOutputCharacterW";
  case 0x02a1: return "ReadConsoleOutputW";
  case 0x02a2: return "ReadConsoleW";
  case 0x02a3: return "ReadDirectoryChangesW";
  case 0x02a4: return "ReadFile";
  case 0x02a5: return "ReadFileEx";
  case 0x02a6: return "ReadFileScatter";
  case 0x02a7: return "ReadProcessMemory";
  case 0x02a8: return "RegisterConsoleIME";
  case 0x02a9: return "RegisterConsoleOS2";
  case 0x02aa: return "RegisterConsoleVDM";
  case 0x02ab: return "RegisterWaitForInputIdle";
  case 0x02ac: return "RegisterWaitForSingleObject";
  case 0x02ad: return "RegisterWaitForSingleObjectEx";
  case 0x02ae: return "RegisterWowBaseHandlers";
  case 0x02af: return "RegisterWowExec";
  case 0x02b0: return "ReleaseActCtx";
  case 0x02b1: return "ReleaseMutex";
  case 0x02b2: return "ReleaseSemaphore";
  case 0x02b3: return "RemoveDirectoryA";
  case 0x02b4: return "RemoveDirectoryW";
  case 0x02b5: return "RemoveLocalAlternateComputerNameA";
  case 0x02b6: return "RemoveLocalAlternateComputerNameW";
  case 0x02b7: return "RemoveVectoredExceptionHandler";
  case 0x02b8: return "ReplaceFile";
  case 0x02b9: return "ReplaceFileA";
  case 0x02ba: return "ReplaceFileW";
  case 0x02bb: return "RequestDeviceWakeup";
  case 0x02bc: return "RequestWakeupLatency";
  case 0x02bd: return "ResetEvent";
  case 0x02be: return "ResetWriteWatch";
  case 0x02bf: return "RestoreLastError";
  case 0x02c0: return "ResumeThread";
  case 0x02c1: return "RtlCaptureContext";
  case 0x02c2: return "RtlCaptureStackBackTrace";
  case 0x02c3: return "RtlFillMemory";
  case 0x02c4: return "RtlMoveMemory";
  case 0x02c5: return "RtlUnwind";
  case 0x02c6: return "RtlZeroMemory";
  case 0x02c7: return "ScrollConsoleScreenBufferA";
  case 0x02c8: return "ScrollConsoleScreenBufferW";
  case 0x02c9: return "SearchPathA";
  case 0x02ca: return "SearchPathW";
  case 0x02cb: return "SetCPGlobal";
  case 0x02cc: return "SetCalendarInfoA";
  case 0x02cd: return "SetCalendarInfoW";
  case 0x02ce: return "SetClientTimeZoneInformation";
  case 0x02cf: return "SetComPlusPackageInstallStatus";
  case 0x02d0: return "SetCommBreak";
  case 0x02d1: return "SetCommConfig";
  case 0x02d2: return "SetCommMask";
  case 0x02d3: return "SetCommState";
  case 0x02d4: return "SetCommTimeouts";
  case 0x02d5: return "SetComputerNameA";
  case 0x02d6: return "SetComputerNameExA";
  case 0x02d7: return "SetComputerNameExW";
  case 0x02d8: return "SetComputerNameW";
  case 0x02d9: return "SetConsoleActiveScreenBuffer";
  case 0x02da: return "SetConsoleCP";
  case 0x02db: return "SetConsoleCommandHistoryMode";
  case 0x02dc: return "SetConsoleCtrlHandler";
  case 0x02dd: return "SetConsoleCursor";
  case 0x02de: return "SetConsoleCursorInfo";
  case 0x02df: return "SetConsoleCursorMode";
  case 0x02e0: return "SetConsoleCursorPosition";
  case 0x02e1: return "SetConsoleDisplayMode";
  case 0x02e2: return "SetConsoleFont";
  case 0x02e3: return "SetConsoleHardwareState";
  case 0x02e4: return "SetConsoleIcon";
  case 0x02e5: return "SetConsoleInputExeNameA";
  case 0x02e6: return "SetConsoleInputExeNameW";
  case 0x02e7: return "SetConsoleKeyShortcuts";
  case 0x02e8: return "SetConsoleLocalEUDC";
  case 0x02e9: return "SetConsoleMaximumWindowSize";
  case 0x02ea: return "SetConsoleMenuClose";
  case 0x02eb: return "SetConsoleMode";
  case 0x02ec: return "SetConsoleNlsMode";
  case 0x02ed: return "SetConsoleNumberOfCommandsA";
  case 0x02ee: return "SetConsoleNumberOfCommandsW";
  case 0x02ef: return "SetConsoleOS2OemFormat";
  case 0x02f0: return "SetConsoleOutputCP";
  case 0x02f1: return "SetConsolePalette";
  case 0x02f2: return "SetConsoleScreenBufferSize";
  case 0x02f3: return "SetConsoleTextAttribute";
  case 0x02f4: return "SetConsoleTitleA";
  case 0x02f5: return "SetConsoleTitleW";
  case 0x02f6: return "SetConsoleWindowInfo";
  case 0x02f7: return "SetCriticalSectionSpinCount";
  case 0x02f8: return "SetCurrentDirectoryA";
  case 0x02f9: return "SetCurrentDirectoryW";
  case 0x02fa: return "SetDefaultCommConfigA";
  case 0x02fb: return "SetDefaultCommConfigW";
  case 0x02fc: return "SetDllDirectoryA";
  case 0x02fd: return "SetDllDirectoryW";
  case 0x02fe: return "SetEndOfFile";
  case 0x02ff: return "SetEnvironmentVariableA";
  case 0x0300: return "SetEnvironmentVariableW";
  case 0x0301: return "SetErrorMode";
  case 0x0302: return "SetEvent";
  case 0x0303: return "SetFileApisToANSI";
  case 0x0304: return "SetFileApisToOEM";
  case 0x0305: return "SetFileAttributesA";
  case 0x0306: return "SetFileAttributesW";
  case 0x0307: return "SetFilePointer";
  case 0x0308: return "SetFilePointerEx";
  case 0x0309: return "SetFileShortNameA";
  case 0x030a: return "SetFileShortNameW";
  case 0x030b: return "SetFileTime";
  case 0x030c: return "SetFileValidData";
  case 0x030d: return "SetFirmwareEnvironmentVariableA";
  case 0x030e: return "SetFirmwareEnvironmentVariableW";
  case 0x030f: return "SetHandleContext";
  case 0x0310: return "SetHandleCount";
  case 0x0311: return "SetHandleInformation";
  case 0x0312: return "SetInformationJobObject";
  case 0x0313: return "SetLastConsoleEventActive";
  case 0x0314: return "SetLastError";
  case 0x0315: return "SetLocalPrimaryComputerNameA";
  case 0x0316: return "SetLocalPrimaryComputerNameW";
  case 0x0317: return "SetLocalTime";
  case 0x0318: return "SetLocaleInfoA";
  case 0x0319: return "SetLocaleInfoW";
  case 0x031a: return "SetMailslotInfo";
  case 0x031b: return "SetMessageWaitingIndicator";
  case 0x031c: return "SetNamedPipeHandleState";
  case 0x031d: return "SetPriorityClass";
  case 0x031e: return "SetProcessAffinityMask";
  case 0x031f: return "SetProcessPriorityBoost";
  case 0x0320: return "SetProcessShutdownParameters";
  case 0x0321: return "SetProcessWorkingSetSize";
  case 0x0322: return "SetStdHandle";
  case 0x0323: return "SetSystemPowerState";
  case 0x0324: return "SetSystemTime";
  case 0x0325: return "SetSystemTimeAdjustment";
  case 0x0326: return "SetTapeParameters";
  case 0x0327: return "SetTapePosition";
  case 0x0328: return "SetTermsrvAppInstallMode";
  case 0x0329: return "SetThreadAffinityMask";
  case 0x032a: return "SetThreadContext";
  case 0x032b: return "SetThreadExecutionState";
  case 0x032c: return "SetThreadIdealProcessor";
  case 0x032d: return "SetThreadLocale";
  case 0x032e: return "SetThreadPriority";
  case 0x032f: return "SetThreadPriorityBoost";
  case 0x0330: return "SetThreadUILanguage";
  case 0x0331: return "SetTimeZoneInformation";
  case 0x0332: return "SetTimerQueueTimer";
  case 0x0333: return "SetUnhandledExceptionFilter";
  case 0x0334: return "SetUserGeoID";
  case 0x0335: return "SetVDMCurrentDirectories";
  case 0x0336: return "SetVolumeLabelA";
  case 0x0337: return "SetVolumeLabelW";
  case 0x0338: return "SetVolumeMountPointA";
  case 0x0339: return "SetVolumeMountPointW";
  case 0x033a: return "SetWaitableTimer";
  case 0x033b: return "SetupComm";
  case 0x033c: return "ShowConsoleCursor";
  case 0x033d: return "SignalObjectAndWait";
  case 0x033e: return "SizeofResource";
  case 0x033f: return "Sleep";
  case 0x0340: return "SleepEx";
  case 0x0341: return "SuspendThread";
  case 0x0342: return "SwitchToFiber";
  case 0x0343: return "SwitchToThread";
  case 0x0344: return "SystemTimeToFileTime";
  case 0x0345: return "SystemTimeToTzSpecificLocalTime";
  case 0x0346: return "TerminateJobObject";
  case 0x0347: return "TerminateProcess";
  case 0x0348: return "TerminateThread";
  case 0x0349: return "TermsrvAppInstallMode";
  case 0x034a: return "Thread32First";
  case 0x034b: return "Thread32Next";
  case 0x034c: return "TlsAlloc";
  case 0x034d: return "TlsFree";
  case 0x034e: return "TlsGetValue";
  case 0x034f: return "TlsSetValue";
  case 0x0350: return "Toolhelp32ReadProcessMemory";
  case 0x0351: return "TransactNamedPipe";
  case 0x0352: return "TransmitCommChar";
  case 0x0353: return "TrimVirtualBuffer";
  case 0x0354: return "TryEnterCriticalSection";
  case 0x0355: return "TzSpecificLocalTimeToSystemTime";
  case 0x0356: return "UTRegister";
  case 0x0357: return "UTUnRegister";
  case 0x0358: return "UnhandledExceptionFilter";
  case 0x0359: return "UnlockFile";
  case 0x035a: return "UnlockFileEx";
  case 0x035b: return "UnmapViewOfFile";
  case 0x035c: return "UnregisterConsoleIME";
  case 0x035d: return "UnregisterWait";
  case 0x035e: return "UnregisterWaitEx";
  case 0x035f: return "UpdateResourceA";
  case 0x0360: return "UpdateResourceW";
  case 0x0361: return "VDMConsoleOperation";
  case 0x0362: return "VDMOperationStarted";
  case 0x0363: return "ValidateLCType";
  case 0x0364: return "ValidateLocale";
  case 0x0365: return "VerLanguageNameA";
  case 0x0366: return "VerLanguageNameW";
  case 0x0367: return "VerSetConditionMask";
  case 0x0368: return "VerifyConsoleIoHandle";
  case 0x0369: return "VerifyVersionInfoA";
  case 0x036a: return "VerifyVersionInfoW";
  case 0x036b: return "VirtualAlloc";
  case 0x036c: return "VirtualAllocEx";
  case 0x036d: return "VirtualBufferExceptionHandler";
  case 0x036e: return "VirtualFree";
  case 0x036f: return "VirtualFreeEx";
  case 0x0370: return "VirtualLock";
  case 0x0371: return "VirtualProtect";
  case 0x0372: return "VirtualProtectEx";
  case 0x0373: return "VirtualQuery";
  case 0x0374: return "VirtualQueryEx";
  case 0x0375: return "VirtualUnlock";
  case 0x0376: return "WTSGetActiveConsoleSessionId";
  case 0x0377: return "WaitCommEvent";
  case 0x0378: return "WaitForDebugEvent";
  case 0x0379: return "WaitForMultipleObjects";
  case 0x037a: return "WaitForMultipleObjectsEx";
  case 0x037b: return "WaitForSingleObject";
  case 0x037c: return "WaitForSingleObjectEx";
  case 0x037d: return "WaitNamedPipeA";
  case 0x037e: return "WaitNamedPipeW";
  case 0x037f: return "WideCharToMultiByte";
  case 0x0380: return "WinExec";
  case 0x0381: return "WriteConsoleA";
  case 0x0382: return "WriteConsoleInputA";
  case 0x0383: return "WriteConsoleInputVDMA";
  case 0x0384: return "WriteConsoleInputVDMW";
  case 0x0385: return "WriteConsoleInputW";
  case 0x0386: return "WriteConsoleOutputA";
  case 0x0387: return "WriteConsoleOutputAttribute";
  case 0x0388: return "WriteConsoleOutputCharacterA";
  case 0x0389: return "WriteConsoleOutputCharacterW";
  case 0x038a: return "WriteConsoleOutputW";
  case 0x038b: return "WriteConsoleW";
  case 0x038c: return "WriteFile";
  case 0x038d: return "WriteFileEx";
  case 0x038e: return "WriteFileGather";
  case 0x038f: return "WritePrivateProfileSectionA";
  case 0x0390: return "WritePrivateProfileSectionW";
  case 0x0391: return "WritePrivateProfileStringA";
  case 0x0392: return "WritePrivateProfileStringW";
  case 0x0393: return "WritePrivateProfileStructA";
  case 0x0394: return "WritePrivateProfileStructW";
  case 0x0395: return "WriteProcessMemory";
  case 0x0396: return "WriteProfileSectionA";
  case 0x0397: return "WriteProfileSectionW";
  case 0x0398: return "WriteProfileStringA";
  case 0x0399: return "WriteProfileStringW";
  case 0x039a: return "WriteTapemark";
  case 0x039b: return "ZombifyActCtx";
  case 0x039c: return "_hread";
  case 0x039d: return "_hwrite";
  case 0x039e: return "_lclose";
  case 0x039f: return "_lcreat";
  case 0x03a0: return "_llseek";
  case 0x03a1: return "_lopen";
  case 0x03a2: return "_lread";
  case 0x03a3: return "_lwrite";
  case 0x03a4: return "lstrcat";
  case 0x03a5: return "lstrcatA";
  case 0x03a6: return "lstrcatW";
  case 0x03a7: return "lstrcmp";
  case 0x03a8: return "lstrcmpA";
  case 0x03a9: return "lstrcmpW";
  case 0x03aa: return "lstrcmpi";
  case 0x03ab: return "lstrcmpiA";
  case 0x03ac: return "lstrcmpiW";
  case 0x03ad: return "lstrcpy";
  case 0x03ae: return "lstrcpyA";
  case 0x03af: return "lstrcpyW";
  case 0x03b0: return "lstrcpyn";
  case 0x03b1: return "lstrcpynA";
  case 0x03b2: return "lstrcpynW";
  case 0x03b3: return "lstrlen";
  case 0x03b4: return "lstrlenA";
  case 0x03b5: return "lstrlenW";
  }
  return nullptr;
}


}
}

#endif

