#[allow(non_camel_case_types)]
#[derive(Debug, Clone, Copy, PartialEq, Eq, PartialOrd, Ord, Hash)]
pub enum Opcode {
  PHI,
  INLINEASM,
  INLINEASM_BR,
  CFI_INSTRUCTION,
  EH_LABEL,
  GC_LABEL,
  ANNOTATION_LABEL,
  KILL,
  EXTRACT_SUBREG,
  INSERT_SUBREG,
  IMPLICIT_DEF,
  SUBREG_TO_REG,
  COPY_TO_REGCLASS,
  DBG_VALUE,
  DBG_VALUE_LIST,
  DBG_INSTR_REF,
  DBG_PHI,
  DBG_LABEL,
  REG_SEQUENCE,
  COPY,
  BUNDLE,
  LIFETIME_START,
  LIFETIME_END,
  PSEUDO_PROBE,
  ARITH_FENCE,
  STACKMAP,
  FENTRY_CALL,
  PATCHPOINT,
  LOAD_STACK_GUARD,
  PREALLOCATED_SETUP,
  PREALLOCATED_ARG,
  STATEPOINT,
  LOCAL_ESCAPE,
  FAULTING_OP,
  PATCHABLE_OP,
  PATCHABLE_FUNCTION_ENTER,
  PATCHABLE_RET,
  PATCHABLE_FUNCTION_EXIT,
  PATCHABLE_TAIL_CALL,
  PATCHABLE_EVENT_CALL,
  PATCHABLE_TYPED_EVENT_CALL,
  ICALL_BRANCH_FUNNEL,
  MEMBARRIER,
  JUMP_TABLE_DEBUG_INFO,
  CONVERGENCECTRL_ENTRY,
  CONVERGENCECTRL_ANCHOR,
  CONVERGENCECTRL_LOOP,
  CONVERGENCECTRL_GLUE,
  G_ASSERT_SEXT,
  G_ASSERT_ZEXT,
  G_ASSERT_ALIGN,
  G_ADD,
  G_SUB,
  G_MUL,
  G_SDIV,
  G_UDIV,
  G_SREM,
  G_UREM,
  G_SDIVREM,
  G_UDIVREM,
  G_AND,
  G_OR,
  G_XOR,
  G_IMPLICIT_DEF,
  G_PHI,
  G_FRAME_INDEX,
  G_GLOBAL_VALUE,
  G_PTRAUTH_GLOBAL_VALUE,
  G_CONSTANT_POOL,
  G_EXTRACT,
  G_UNMERGE_VALUES,
  G_INSERT,
  G_MERGE_VALUES,
  G_BUILD_VECTOR,
  G_BUILD_VECTOR_TRUNC,
  G_CONCAT_VECTORS,
  G_PTRTOINT,
  G_INTTOPTR,
  G_BITCAST,
  G_FREEZE,
  G_CONSTANT_FOLD_BARRIER,
  G_INTRINSIC_FPTRUNC_ROUND,
  G_INTRINSIC_TRUNC,
  G_INTRINSIC_ROUND,
  G_INTRINSIC_LRINT,
  G_INTRINSIC_LLRINT,
  G_INTRINSIC_ROUNDEVEN,
  G_READCYCLECOUNTER,
  G_READSTEADYCOUNTER,
  G_LOAD,
  G_SEXTLOAD,
  G_ZEXTLOAD,
  G_INDEXED_LOAD,
  G_INDEXED_SEXTLOAD,
  G_INDEXED_ZEXTLOAD,
  G_STORE,
  G_INDEXED_STORE,
  G_ATOMIC_CMPXCHG_WITH_SUCCESS,
  G_ATOMIC_CMPXCHG,
  G_ATOMICRMW_XCHG,
  G_ATOMICRMW_ADD,
  G_ATOMICRMW_SUB,
  G_ATOMICRMW_AND,
  G_ATOMICRMW_NAND,
  G_ATOMICRMW_OR,
  G_ATOMICRMW_XOR,
  G_ATOMICRMW_MAX,
  G_ATOMICRMW_MIN,
  G_ATOMICRMW_UMAX,
  G_ATOMICRMW_UMIN,
  G_ATOMICRMW_FADD,
  G_ATOMICRMW_FSUB,
  G_ATOMICRMW_FMAX,
  G_ATOMICRMW_FMIN,
  G_ATOMICRMW_UINC_WRAP,
  G_ATOMICRMW_UDEC_WRAP,
  G_FENCE,
  G_PREFETCH,
  G_BRCOND,
  G_BRINDIRECT,
  G_INVOKE_REGION_START,
  G_INTRINSIC,
  G_INTRINSIC_W_SIDE_EFFECTS,
  G_INTRINSIC_CONVERGENT,
  G_INTRINSIC_CONVERGENT_W_SIDE_EFFECTS,
  G_ANYEXT,
  G_TRUNC,
  G_CONSTANT,
  G_FCONSTANT,
  G_VASTART,
  G_VAARG,
  G_SEXT,
  G_SEXT_INREG,
  G_ZEXT,
  G_SHL,
  G_LSHR,
  G_ASHR,
  G_FSHL,
  G_FSHR,
  G_ROTR,
  G_ROTL,
  G_ICMP,
  G_FCMP,
  G_SCMP,
  G_UCMP,
  G_SELECT,
  G_UADDO,
  G_UADDE,
  G_USUBO,
  G_USUBE,
  G_SADDO,
  G_SADDE,
  G_SSUBO,
  G_SSUBE,
  G_UMULO,
  G_SMULO,
  G_UMULH,
  G_SMULH,
  G_UADDSAT,
  G_SADDSAT,
  G_USUBSAT,
  G_SSUBSAT,
  G_USHLSAT,
  G_SSHLSAT,
  G_SMULFIX,
  G_UMULFIX,
  G_SMULFIXSAT,
  G_UMULFIXSAT,
  G_SDIVFIX,
  G_UDIVFIX,
  G_SDIVFIXSAT,
  G_UDIVFIXSAT,
  G_FADD,
  G_FSUB,
  G_FMUL,
  G_FMA,
  G_FMAD,
  G_FDIV,
  G_FREM,
  G_FPOW,
  G_FPOWI,
  G_FEXP,
  G_FEXP2,
  G_FEXP10,
  G_FLOG,
  G_FLOG2,
  G_FLOG10,
  G_FLDEXP,
  G_FFREXP,
  G_FNEG,
  G_FPEXT,
  G_FPTRUNC,
  G_FPTOSI,
  G_FPTOUI,
  G_SITOFP,
  G_UITOFP,
  G_FABS,
  G_FCOPYSIGN,
  G_IS_FPCLASS,
  G_FCANONICALIZE,
  G_FMINNUM,
  G_FMAXNUM,
  G_FMINNUM_IEEE,
  G_FMAXNUM_IEEE,
  G_FMINIMUM,
  G_FMAXIMUM,
  G_GET_FPENV,
  G_SET_FPENV,
  G_RESET_FPENV,
  G_GET_FPMODE,
  G_SET_FPMODE,
  G_RESET_FPMODE,
  G_PTR_ADD,
  G_PTRMASK,
  G_SMIN,
  G_SMAX,
  G_UMIN,
  G_UMAX,
  G_ABS,
  G_LROUND,
  G_LLROUND,
  G_BR,
  G_BRJT,
  G_VSCALE,
  G_INSERT_SUBVECTOR,
  G_EXTRACT_SUBVECTOR,
  G_INSERT_VECTOR_ELT,
  G_EXTRACT_VECTOR_ELT,
  G_SHUFFLE_VECTOR,
  G_SPLAT_VECTOR,
  G_VECTOR_COMPRESS,
  G_CTTZ,
  G_CTTZ_ZERO_UNDEF,
  G_CTLZ,
  G_CTLZ_ZERO_UNDEF,
  G_CTPOP,
  G_BSWAP,
  G_BITREVERSE,
  G_FCEIL,
  G_FCOS,
  G_FSIN,
  G_FTAN,
  G_FACOS,
  G_FASIN,
  G_FATAN,
  G_FCOSH,
  G_FSINH,
  G_FTANH,
  G_FSQRT,
  G_FFLOOR,
  G_FRINT,
  G_FNEARBYINT,
  G_ADDRSPACE_CAST,
  G_BLOCK_ADDR,
  G_JUMP_TABLE,
  G_DYN_STACKALLOC,
  G_STACKSAVE,
  G_STACKRESTORE,
  G_STRICT_FADD,
  G_STRICT_FSUB,
  G_STRICT_FMUL,
  G_STRICT_FDIV,
  G_STRICT_FREM,
  G_STRICT_FMA,
  G_STRICT_FSQRT,
  G_STRICT_FLDEXP,
  G_READ_REGISTER,
  G_WRITE_REGISTER,
  G_MEMCPY,
  G_MEMCPY_INLINE,
  G_MEMMOVE,
  G_MEMSET,
  G_BZERO,
  G_TRAP,
  G_DEBUGTRAP,
  G_UBSANTRAP,
  G_VECREDUCE_SEQ_FADD,
  G_VECREDUCE_SEQ_FMUL,
  G_VECREDUCE_FADD,
  G_VECREDUCE_FMUL,
  G_VECREDUCE_FMAX,
  G_VECREDUCE_FMIN,
  G_VECREDUCE_FMAXIMUM,
  G_VECREDUCE_FMINIMUM,
  G_VECREDUCE_ADD,
  G_VECREDUCE_MUL,
  G_VECREDUCE_AND,
  G_VECREDUCE_OR,
  G_VECREDUCE_XOR,
  G_VECREDUCE_SMAX,
  G_VECREDUCE_SMIN,
  G_VECREDUCE_UMAX,
  G_VECREDUCE_UMIN,
  G_SBFX,
  G_UBFX,
  ATOMIC_CMP_SWAP_I128,
  ATOMIC_LOAD_ADD_I128,
  ATOMIC_LOAD_AND_I128,
  ATOMIC_LOAD_NAND_I128,
  ATOMIC_LOAD_OR_I128,
  ATOMIC_LOAD_SUB_I128,
  ATOMIC_LOAD_XOR_I128,
  ATOMIC_SWAP_I128,
  BUILD_QUADWORD,
  BUILD_UACC,
  CFENCE,
  CFENCE8,
  CLRLSLDI,
  CLRLSLDI_rec,
  CLRLSLWI,
  CLRLSLWI_rec,
  CLRRDI,
  CLRRDI_rec,
  CLRRWI,
  CLRRWI_rec,
  DCBFL,
  DCBFLP,
  DCBFPS,
  DCBFx,
  DCBSTPS,
  DCBTCT,
  DCBTDS,
  DCBTSTCT,
  DCBTSTDS,
  DCBTSTT,
  DCBTSTx,
  DCBTT,
  DCBTx,
  DFLOADf32,
  DFLOADf64,
  DFSTOREf32,
  DFSTOREf64,
  EXTLDI,
  EXTLDI_rec,
  EXTLWI,
  EXTLWI_rec,
  EXTRDI,
  EXTRDI_rec,
  EXTRWI,
  EXTRWI_rec,
  INSLWI,
  INSLWI_rec,
  INSRDI,
  INSRDI_rec,
  INSRWI,
  INSRWI_rec,
  KILL_PAIR,
  LAx,
  LIWAX,
  LIWZX,
  PPCLdFixedAddr,
  PSUBI,
  RLWIMIbm,
  RLWIMIbm_rec,
  RLWINMbm,
  RLWINMbm_rec,
  RLWNMbm,
  RLWNMbm_rec,
  ROTRDI,
  ROTRDI_rec,
  ROTRWI,
  ROTRWI_rec,
  SLDI,
  SLDI_rec,
  SLWI,
  SLWI_rec,
  SPILLTOVSR_LD,
  SPILLTOVSR_LDX,
  SPILLTOVSR_ST,
  SPILLTOVSR_STX,
  SRDI,
  SRDI_rec,
  SRWI,
  SRWI_rec,
  STIWX,
  SUBI,
  SUBIC,
  SUBIC_rec,
  SUBIS,
  SUBPCIS,
  XFLOADf32,
  XFLOADf64,
  XFSTOREf32,
  XFSTOREf64,
  ADD4,
  ADD4O,
  ADD4O_rec,
  ADD4TLS,
  ADD4_rec,
  ADD8,
  ADD8O,
  ADD8O_rec,
  ADD8TLS,
  ADD8TLS_,
  ADD8_rec,
  ADDC,
  ADDC8,
  ADDC8O,
  ADDC8O_rec,
  ADDC8_rec,
  ADDCO,
  ADDCO_rec,
  ADDC_rec,
  ADDE,
  ADDE8,
  ADDE8O,
  ADDE8O_rec,
  ADDE8_rec,
  ADDEO,
  ADDEO_rec,
  ADDEX,
  ADDEX8,
  ADDE_rec,
  ADDG6S,
  ADDG6S8,
  ADDI,
  ADDI8,
  ADDIC,
  ADDIC8,
  ADDIC_rec,
  ADDIS,
  ADDIS8,
  ADDISdtprelHA,
  ADDISdtprelHA32,
  ADDISgotTprelHA,
  ADDIStlsgdHA,
  ADDIStlsldHA,
  ADDIStocHA,
  ADDIStocHA8,
  ADDIdtprelL,
  ADDIdtprelL32,
  ADDItlsgdL,
  ADDItlsgdL32,
  ADDItlsgdLADDR,
  ADDItlsgdLADDR32,
  ADDItlsldL,
  ADDItlsldL32,
  ADDItlsldLADDR,
  ADDItlsldLADDR32,
  ADDItoc,
  ADDItoc8,
  ADDItocL,
  ADDItocL8,
  ADDME,
  ADDME8,
  ADDME8O,
  ADDME8O_rec,
  ADDME8_rec,
  ADDMEO,
  ADDMEO_rec,
  ADDME_rec,
  ADDPCIS,
  ADDZE,
  ADDZE8,
  ADDZE8O,
  ADDZE8O_rec,
  ADDZE8_rec,
  ADDZEO,
  ADDZEO_rec,
  ADDZE_rec,
  ADJCALLSTACKDOWN,
  ADJCALLSTACKUP,
  AND,
  AND8,
  AND8_rec,
  ANDC,
  ANDC8,
  ANDC8_rec,
  ANDC_rec,
  ANDI8_rec,
  ANDIS8_rec,
  ANDIS_rec,
  ANDI_rec,
  ANDI_rec_1_EQ_BIT,
  ANDI_rec_1_EQ_BIT8,
  ANDI_rec_1_GT_BIT,
  ANDI_rec_1_GT_BIT8,
  AND_rec,
  ATOMIC_CMP_SWAP_I16,
  ATOMIC_CMP_SWAP_I32,
  ATOMIC_CMP_SWAP_I64,
  ATOMIC_CMP_SWAP_I8,
  ATOMIC_LOAD_ADD_I16,
  ATOMIC_LOAD_ADD_I32,
  ATOMIC_LOAD_ADD_I64,
  ATOMIC_LOAD_ADD_I8,
  ATOMIC_LOAD_AND_I16,
  ATOMIC_LOAD_AND_I32,
  ATOMIC_LOAD_AND_I64,
  ATOMIC_LOAD_AND_I8,
  ATOMIC_LOAD_MAX_I16,
  ATOMIC_LOAD_MAX_I32,
  ATOMIC_LOAD_MAX_I64,
  ATOMIC_LOAD_MAX_I8,
  ATOMIC_LOAD_MIN_I16,
  ATOMIC_LOAD_MIN_I32,
  ATOMIC_LOAD_MIN_I64,
  ATOMIC_LOAD_MIN_I8,
  ATOMIC_LOAD_NAND_I16,
  ATOMIC_LOAD_NAND_I32,
  ATOMIC_LOAD_NAND_I64,
  ATOMIC_LOAD_NAND_I8,
  ATOMIC_LOAD_OR_I16,
  ATOMIC_LOAD_OR_I32,
  ATOMIC_LOAD_OR_I64,
  ATOMIC_LOAD_OR_I8,
  ATOMIC_LOAD_SUB_I16,
  ATOMIC_LOAD_SUB_I32,
  ATOMIC_LOAD_SUB_I64,
  ATOMIC_LOAD_SUB_I8,
  ATOMIC_LOAD_UMAX_I16,
  ATOMIC_LOAD_UMAX_I32,
  ATOMIC_LOAD_UMAX_I64,
  ATOMIC_LOAD_UMAX_I8,
  ATOMIC_LOAD_UMIN_I16,
  ATOMIC_LOAD_UMIN_I32,
  ATOMIC_LOAD_UMIN_I64,
  ATOMIC_LOAD_UMIN_I8,
  ATOMIC_LOAD_XOR_I16,
  ATOMIC_LOAD_XOR_I32,
  ATOMIC_LOAD_XOR_I64,
  ATOMIC_LOAD_XOR_I8,
  ATOMIC_SWAP_I16,
  ATOMIC_SWAP_I32,
  ATOMIC_SWAP_I64,
  ATOMIC_SWAP_I8,
  ATTN,
  B,
  BA,
  BC,
  BCC,
  BCCA,
  BCCCTR,
  BCCCTR8,
  BCCCTRL,
  BCCCTRL8,
  BCCL,
  BCCLA,
  BCCLR,
  BCCLRL,
  BCCTR,
  BCCTR8,
  BCCTR8n,
  BCCTRL,
  BCCTRL8,
  BCCTRL8n,
  BCCTRLn,
  BCCTRn,
  BCDADD_rec,
  BCDCFN_rec,
  BCDCFSQ_rec,
  BCDCFZ_rec,
  BCDCPSGN_rec,
  BCDCTN_rec,
  BCDCTSQ_rec,
  BCDCTZ_rec,
  BCDSETSGN_rec,
  BCDSR_rec,
  BCDSUB_rec,
  BCDS_rec,
  BCDTRUNC_rec,
  BCDUS_rec,
  BCDUTRUNC_rec,
  BCL,
  BCLR,
  BCLRL,
  BCLRLn,
  BCLRn,
  BCLalways,
  BCLn,
  BCTR,
  BCTR8,
  BCTRL,
  BCTRL8,
  BCTRL8_LDinto_toc,
  BCTRL8_LDinto_toc_RM,
  BCTRL8_RM,
  BCTRL_LWZinto_toc,
  BCTRL_LWZinto_toc_RM,
  BCTRL_RM,
  BCn,
  BDNZ,
  BDNZ8,
  BDNZA,
  BDNZAm,
  BDNZAp,
  BDNZL,
  BDNZLA,
  BDNZLAm,
  BDNZLAp,
  BDNZLR,
  BDNZLR8,
  BDNZLRL,
  BDNZLRLm,
  BDNZLRLp,
  BDNZLRm,
  BDNZLRp,
  BDNZLm,
  BDNZLp,
  BDNZm,
  BDNZp,
  BDZ,
  BDZ8,
  BDZA,
  BDZAm,
  BDZAp,
  BDZL,
  BDZLA,
  BDZLAm,
  BDZLAp,
  BDZLR,
  BDZLR8,
  BDZLRL,
  BDZLRLm,
  BDZLRLp,
  BDZLRm,
  BDZLRp,
  BDZLm,
  BDZLp,
  BDZm,
  BDZp,
  BL,
  BL8,
  BL8_NOP,
  BL8_NOP_RM,
  BL8_NOP_TLS,
  BL8_NOTOC,
  BL8_NOTOC_RM,
  BL8_NOTOC_TLS,
  BL8_RM,
  BL8_TLS,
  BL8_TLS_,
  BLA,
  BLA8,
  BLA8_NOP,
  BLA8_NOP_RM,
  BLA8_RM,
  BLA_RM,
  BLR,
  BLR8,
  BLRL,
  BL_NOP,
  BL_NOP_RM,
  BL_RM,
  BL_TLS,
  BPERMD,
  BRD,
  BRH,
  BRH8,
  BRINC,
  BRW,
  BRW8,
  CBCDTD,
  CBCDTD8,
  CDTBCD,
  CDTBCD8,
  CFUGED,
  CLRBHRB,
  CMPB,
  CMPB8,
  CMPD,
  CMPDI,
  CMPEQB,
  CMPLD,
  CMPLDI,
  CMPLW,
  CMPLWI,
  CMPRB,
  CMPRB8,
  CMPW,
  CMPWI,
  CNTLZD,
  CNTLZDM,
  CNTLZD_rec,
  CNTLZW,
  CNTLZW8,
  CNTLZW8_rec,
  CNTLZW_rec,
  CNTTZD,
  CNTTZDM,
  CNTTZD_rec,
  CNTTZW,
  CNTTZW8,
  CNTTZW8_rec,
  CNTTZW_rec,
  CP_ABORT,
  CP_COPY,
  CP_COPY8,
  CP_PASTE8_rec,
  CP_PASTE_rec,
  CR6SET,
  CR6UNSET,
  CRAND,
  CRANDC,
  CREQV,
  CRNAND,
  CRNOR,
  CRNOT,
  CROR,
  CRORC,
  CRSET,
  CRUNSET,
  CRXOR,
  CTRL_DEP,
  DADD,
  DADDQ,
  DADDQ_rec,
  DADD_rec,
  DARN,
  DCBA,
  DCBF,
  DCBFEP,
  DCBI,
  DCBST,
  DCBSTEP,
  DCBT,
  DCBTEP,
  DCBTST,
  DCBTSTEP,
  DCBZ,
  DCBZEP,
  DCBZL,
  DCBZLEP,
  DCCCI,
  DCFFIX,
  DCFFIXQ,
  DCFFIXQQ,
  DCFFIXQ_rec,
  DCFFIX_rec,
  DCMPO,
  DCMPOQ,
  DCMPU,
  DCMPUQ,
  DCTDP,
  DCTDP_rec,
  DCTFIX,
  DCTFIXQ,
  DCTFIXQQ,
  DCTFIXQ_rec,
  DCTFIX_rec,
  DCTQPQ,
  DCTQPQ_rec,
  DDEDPD,
  DDEDPDQ,
  DDEDPDQ_rec,
  DDEDPD_rec,
  DDIV,
  DDIVQ,
  DDIVQ_rec,
  DDIV_rec,
  DENBCD,
  DENBCDQ,
  DENBCDQ_rec,
  DENBCD_rec,
  DIEX,
  DIEXQ,
  DIEXQ_rec,
  DIEX_rec,
  DIVD,
  DIVDE,
  DIVDEO,
  DIVDEO_rec,
  DIVDEU,
  DIVDEUO,
  DIVDEUO_rec,
  DIVDEU_rec,
  DIVDE_rec,
  DIVDO,
  DIVDO_rec,
  DIVDU,
  DIVDUO,
  DIVDUO_rec,
  DIVDU_rec,
  DIVD_rec,
  DIVW,
  DIVWE,
  DIVWEO,
  DIVWEO_rec,
  DIVWEU,
  DIVWEUO,
  DIVWEUO_rec,
  DIVWEU_rec,
  DIVWE_rec,
  DIVWO,
  DIVWO_rec,
  DIVWU,
  DIVWUO,
  DIVWUO_rec,
  DIVWU_rec,
  DIVW_rec,
  DMMR,
  DMSETDMRZ,
  DMUL,
  DMULQ,
  DMULQ_rec,
  DMUL_rec,
  DMXOR,
  DMXXEXTFDMR256,
  DMXXEXTFDMR512,
  DMXXEXTFDMR512_HI,
  DMXXINSTFDMR256,
  DMXXINSTFDMR512,
  DMXXINSTFDMR512_HI,
  DQUA,
  DQUAI,
  DQUAIQ,
  DQUAIQ_rec,
  DQUAI_rec,
  DQUAQ,
  DQUAQ_rec,
  DQUA_rec,
  DRDPQ,
  DRDPQ_rec,
  DRINTN,
  DRINTNQ,
  DRINTNQ_rec,
  DRINTN_rec,
  DRINTX,
  DRINTXQ,
  DRINTXQ_rec,
  DRINTX_rec,
  DRRND,
  DRRNDQ,
  DRRNDQ_rec,
  DRRND_rec,
  DRSP,
  DRSP_rec,
  DSCLI,
  DSCLIQ,
  DSCLIQ_rec,
  DSCLI_rec,
  DSCRI,
  DSCRIQ,
  DSCRIQ_rec,
  DSCRI_rec,
  DSS,
  DSSALL,
  DST,
  DST64,
  DSTST,
  DSTST64,
  DSTSTT,
  DSTSTT64,
  DSTT,
  DSTT64,
  DSUB,
  DSUBQ,
  DSUBQ_rec,
  DSUB_rec,
  DTSTDC,
  DTSTDCQ,
  DTSTDG,
  DTSTDGQ,
  DTSTEX,
  DTSTEXQ,
  DTSTSF,
  DTSTSFI,
  DTSTSFIQ,
  DTSTSFQ,
  DXEX,
  DXEXQ,
  DXEXQ_rec,
  DXEX_rec,
  DYNALLOC,
  DYNALLOC8,
  DYNAREAOFFSET,
  DYNAREAOFFSET8,
  DecreaseCTR8loop,
  DecreaseCTRloop,
  EFDABS,
  EFDADD,
  EFDCFS,
  EFDCFSF,
  EFDCFSI,
  EFDCFSID,
  EFDCFUF,
  EFDCFUI,
  EFDCFUID,
  EFDCMPEQ,
  EFDCMPGT,
  EFDCMPLT,
  EFDCTSF,
  EFDCTSI,
  EFDCTSIDZ,
  EFDCTSIZ,
  EFDCTUF,
  EFDCTUI,
  EFDCTUIDZ,
  EFDCTUIZ,
  EFDDIV,
  EFDMUL,
  EFDNABS,
  EFDNEG,
  EFDSUB,
  EFDTSTEQ,
  EFDTSTGT,
  EFDTSTLT,
  EFSABS,
  EFSADD,
  EFSCFD,
  EFSCFSF,
  EFSCFSI,
  EFSCFUF,
  EFSCFUI,
  EFSCMPEQ,
  EFSCMPGT,
  EFSCMPLT,
  EFSCTSF,
  EFSCTSI,
  EFSCTSIZ,
  EFSCTUF,
  EFSCTUI,
  EFSCTUIZ,
  EFSDIV,
  EFSMUL,
  EFSNABS,
  EFSNEG,
  EFSSUB,
  EFSTSTEQ,
  EFSTSTGT,
  EFSTSTLT,
  EH_SjLj_LongJmp32,
  EH_SjLj_LongJmp64,
  EH_SjLj_SetJmp32,
  EH_SjLj_SetJmp64,
  EH_SjLj_Setup,
  EQV,
  EQV8,
  EQV8_rec,
  EQV_rec,
  EVABS,
  EVADDIW,
  EVADDSMIAAW,
  EVADDSSIAAW,
  EVADDUMIAAW,
  EVADDUSIAAW,
  EVADDW,
  EVAND,
  EVANDC,
  EVCMPEQ,
  EVCMPGTS,
  EVCMPGTU,
  EVCMPLTS,
  EVCMPLTU,
  EVCNTLSW,
  EVCNTLZW,
  EVDIVWS,
  EVDIVWU,
  EVEQV,
  EVEXTSB,
  EVEXTSH,
  EVFSABS,
  EVFSADD,
  EVFSCFSF,
  EVFSCFSI,
  EVFSCFUF,
  EVFSCFUI,
  EVFSCMPEQ,
  EVFSCMPGT,
  EVFSCMPLT,
  EVFSCTSF,
  EVFSCTSI,
  EVFSCTSIZ,
  EVFSCTUF,
  EVFSCTUI,
  EVFSCTUIZ,
  EVFSDIV,
  EVFSMUL,
  EVFSNABS,
  EVFSNEG,
  EVFSSUB,
  EVFSTSTEQ,
  EVFSTSTGT,
  EVFSTSTLT,
  EVLDD,
  EVLDDX,
  EVLDH,
  EVLDHX,
  EVLDW,
  EVLDWX,
  EVLHHESPLAT,
  EVLHHESPLATX,
  EVLHHOSSPLAT,
  EVLHHOSSPLATX,
  EVLHHOUSPLAT,
  EVLHHOUSPLATX,
  EVLWHE,
  EVLWHEX,
  EVLWHOS,
  EVLWHOSX,
  EVLWHOU,
  EVLWHOUX,
  EVLWHSPLAT,
  EVLWHSPLATX,
  EVLWWSPLAT,
  EVLWWSPLATX,
  EVMERGEHI,
  EVMERGEHILO,
  EVMERGELO,
  EVMERGELOHI,
  EVMHEGSMFAA,
  EVMHEGSMFAN,
  EVMHEGSMIAA,
  EVMHEGSMIAN,
  EVMHEGUMIAA,
  EVMHEGUMIAN,
  EVMHESMF,
  EVMHESMFA,
  EVMHESMFAAW,
  EVMHESMFANW,
  EVMHESMI,
  EVMHESMIA,
  EVMHESMIAAW,
  EVMHESMIANW,
  EVMHESSF,
  EVMHESSFA,
  EVMHESSFAAW,
  EVMHESSFANW,
  EVMHESSIAAW,
  EVMHESSIANW,
  EVMHEUMI,
  EVMHEUMIA,
  EVMHEUMIAAW,
  EVMHEUMIANW,
  EVMHEUSIAAW,
  EVMHEUSIANW,
  EVMHOGSMFAA,
  EVMHOGSMFAN,
  EVMHOGSMIAA,
  EVMHOGSMIAN,
  EVMHOGUMIAA,
  EVMHOGUMIAN,
  EVMHOSMF,
  EVMHOSMFA,
  EVMHOSMFAAW,
  EVMHOSMFANW,
  EVMHOSMI,
  EVMHOSMIA,
  EVMHOSMIAAW,
  EVMHOSMIANW,
  EVMHOSSF,
  EVMHOSSFA,
  EVMHOSSFAAW,
  EVMHOSSFANW,
  EVMHOSSIAAW,
  EVMHOSSIANW,
  EVMHOUMI,
  EVMHOUMIA,
  EVMHOUMIAAW,
  EVMHOUMIANW,
  EVMHOUSIAAW,
  EVMHOUSIANW,
  EVMRA,
  EVMWHSMF,
  EVMWHSMFA,
  EVMWHSMI,
  EVMWHSMIA,
  EVMWHSSF,
  EVMWHSSFA,
  EVMWHUMI,
  EVMWHUMIA,
  EVMWLSMIAAW,
  EVMWLSMIANW,
  EVMWLSSIAAW,
  EVMWLSSIANW,
  EVMWLUMI,
  EVMWLUMIA,
  EVMWLUMIAAW,
  EVMWLUMIANW,
  EVMWLUSIAAW,
  EVMWLUSIANW,
  EVMWSMF,
  EVMWSMFA,
  EVMWSMFAA,
  EVMWSMFAN,
  EVMWSMI,
  EVMWSMIA,
  EVMWSMIAA,
  EVMWSMIAN,
  EVMWSSF,
  EVMWSSFA,
  EVMWSSFAA,
  EVMWSSFAN,
  EVMWUMI,
  EVMWUMIA,
  EVMWUMIAA,
  EVMWUMIAN,
  EVNAND,
  EVNEG,
  EVNOR,
  EVOR,
  EVORC,
  EVRLW,
  EVRLWI,
  EVRNDW,
  EVSEL,
  EVSLW,
  EVSLWI,
  EVSPLATFI,
  EVSPLATI,
  EVSRWIS,
  EVSRWIU,
  EVSRWS,
  EVSRWU,
  EVSTDD,
  EVSTDDX,
  EVSTDH,
  EVSTDHX,
  EVSTDW,
  EVSTDWX,
  EVSTWHE,
  EVSTWHEX,
  EVSTWHO,
  EVSTWHOX,
  EVSTWWE,
  EVSTWWEX,
  EVSTWWO,
  EVSTWWOX,
  EVSUBFSMIAAW,
  EVSUBFSSIAAW,
  EVSUBFUMIAAW,
  EVSUBFUSIAAW,
  EVSUBFW,
  EVSUBIFW,
  EVXOR,
  EXTSB,
  EXTSB8,
  EXTSB8_32_64,
  EXTSB8_rec,
  EXTSB_rec,
  EXTSH,
  EXTSH8,
  EXTSH8_32_64,
  EXTSH8_rec,
  EXTSH_rec,
  EXTSW,
  EXTSWSLI,
  EXTSWSLI_32_64,
  EXTSWSLI_32_64_rec,
  EXTSWSLI_rec,
  EXTSW_32,
  EXTSW_32_64,
  EXTSW_32_64_rec,
  EXTSW_rec,
  EnforceIEIO,
  FABSD,
  FABSD_rec,
  FABSS,
  FABSS_rec,
  FADD,
  FADDS,
  FADDS_rec,
  FADD_rec,
  FADDrtz,
  FCFID,
  FCFIDS,
  FCFIDS_rec,
  FCFIDU,
  FCFIDUS,
  FCFIDUS_rec,
  FCFIDU_rec,
  FCFID_rec,
  FCMPOD,
  FCMPOS,
  FCMPUD,
  FCMPUS,
  FCPSGND,
  FCPSGND_rec,
  FCPSGNS,
  FCPSGNS_rec,
  FCTID,
  FCTIDU,
  FCTIDUZ,
  FCTIDUZ_rec,
  FCTIDU_rec,
  FCTIDZ,
  FCTIDZ_rec,
  FCTID_rec,
  FCTIW,
  FCTIWU,
  FCTIWUZ,
  FCTIWUZ_rec,
  FCTIWU_rec,
  FCTIWZ,
  FCTIWZ_rec,
  FCTIW_rec,
  FDIV,
  FDIVS,
  FDIVS_rec,
  FDIV_rec,
  FENCE,
  FMADD,
  FMADDS,
  FMADDS_rec,
  FMADD_rec,
  FMR,
  FMR_rec,
  FMSUB,
  FMSUBS,
  FMSUBS_rec,
  FMSUB_rec,
  FMUL,
  FMULS,
  FMULS_rec,
  FMUL_rec,
  FNABSD,
  FNABSD_rec,
  FNABSS,
  FNABSS_rec,
  FNEGD,
  FNEGD_rec,
  FNEGS,
  FNEGS_rec,
  FNMADD,
  FNMADDS,
  FNMADDS_rec,
  FNMADD_rec,
  FNMSUB,
  FNMSUBS,
  FNMSUBS_rec,
  FNMSUB_rec,
  FRE,
  FRES,
  FRES_rec,
  FRE_rec,
  FRIMD,
  FRIMD_rec,
  FRIMS,
  FRIMS_rec,
  FRIND,
  FRIND_rec,
  FRINS,
  FRINS_rec,
  FRIPD,
  FRIPD_rec,
  FRIPS,
  FRIPS_rec,
  FRIZD,
  FRIZD_rec,
  FRIZS,
  FRIZS_rec,
  FRSP,
  FRSP_rec,
  FRSQRTE,
  FRSQRTES,
  FRSQRTES_rec,
  FRSQRTE_rec,
  FSELD,
  FSELD_rec,
  FSELS,
  FSELS_rec,
  FSQRT,
  FSQRTS,
  FSQRTS_rec,
  FSQRT_rec,
  FSUB,
  FSUBS,
  FSUBS_rec,
  FSUB_rec,
  FTDIV,
  FTSQRT,
  GETtlsADDR,
  GETtlsADDR32,
  GETtlsADDR32AIX,
  GETtlsADDR64AIX,
  GETtlsADDRPCREL,
  GETtlsMOD32AIX,
  GETtlsMOD64AIX,
  GETtlsTpointer32AIX,
  GETtlsldADDR,
  GETtlsldADDR32,
  GETtlsldADDRPCREL,
  HASHCHK,
  HASHCHK8,
  HASHCHKP,
  HASHCHKP8,
  HASHST,
  HASHST8,
  HASHSTP,
  HASHSTP8,
  HRFID,
  ICBI,
  ICBIEP,
  ICBLC,
  ICBLQ,
  ICBT,
  ICBTLS,
  ICCCI,
  ISEL,
  ISEL8,
  ISYNC,
  LA,
  LA8,
  LBARX,
  LBARXL,
  LBEPX,
  LBZ,
  LBZ8,
  LBZCIX,
  LBZU,
  LBZU8,
  LBZUX,
  LBZUX8,
  LBZX,
  LBZX8,
  LBZXTLS,
  LBZXTLS_,
  LBZXTLS_32,
  LD,
  LDARX,
  LDARXL,
  LDAT,
  LDBRX,
  LDCIX,
  LDU,
  LDUX,
  LDX,
  LDXTLS,
  LDXTLS_,
  LDgotTprelL,
  LDgotTprelL32,
  LDtoc,
  LDtocBA,
  LDtocCPT,
  LDtocJTI,
  LDtocL,
  LFD,
  LFDEPX,
  LFDU,
  LFDUX,
  LFDX,
  LFDXTLS,
  LFDXTLS_,
  LFIWAX,
  LFIWZX,
  LFS,
  LFSU,
  LFSUX,
  LFSX,
  LFSXTLS,
  LFSXTLS_,
  LHA,
  LHA8,
  LHARX,
  LHARXL,
  LHAU,
  LHAU8,
  LHAUX,
  LHAUX8,
  LHAX,
  LHAX8,
  LHAXTLS,
  LHAXTLS_,
  LHAXTLS_32,
  LHBRX,
  LHBRX8,
  LHEPX,
  LHZ,
  LHZ8,
  LHZCIX,
  LHZU,
  LHZU8,
  LHZUX,
  LHZUX8,
  LHZX,
  LHZX8,
  LHZXTLS,
  LHZXTLS_,
  LHZXTLS_32,
  LI,
  LI8,
  LIS,
  LIS8,
  LMW,
  LQ,
  LQARX,
  LQARXL,
  LQX_PSEUDO,
  LSWI,
  LVEBX,
  LVEHX,
  LVEWX,
  LVSL,
  LVSR,
  LVX,
  LVXL,
  LWA,
  LWARX,
  LWARXL,
  LWAT,
  LWAUX,
  LWAX,
  LWAXTLS,
  LWAXTLS_,
  LWAXTLS_32,
  LWAX_32,
  LWA_32,
  LWBRX,
  LWBRX8,
  LWEPX,
  LWZ,
  LWZ8,
  LWZCIX,
  LWZU,
  LWZU8,
  LWZUX,
  LWZUX8,
  LWZX,
  LWZX8,
  LWZXTLS,
  LWZXTLS_,
  LWZXTLS_32,
  LWZtoc,
  LWZtocL,
  LXSD,
  LXSDX,
  LXSIBZX,
  LXSIHZX,
  LXSIWAX,
  LXSIWZX,
  LXSSP,
  LXSSPX,
  LXV,
  LXVB16X,
  LXVD2X,
  LXVDSX,
  LXVH8X,
  LXVKQ,
  LXVL,
  LXVLL,
  LXVP,
  LXVPRL,
  LXVPRLL,
  LXVPX,
  LXVRBX,
  LXVRDX,
  LXVRHX,
  LXVRL,
  LXVRLL,
  LXVRWX,
  LXVW4X,
  LXVWSX,
  LXVX,
  MADDHD,
  MADDHDU,
  MADDLD,
  MADDLD8,
  MBAR,
  MCRF,
  MCRFS,
  MCRXRX,
  MFBHRBE,
  MFCR,
  MFCR8,
  MFCTR,
  MFCTR8,
  MFDCR,
  MFFS,
  MFFSCDRN,
  MFFSCDRNI,
  MFFSCE,
  MFFSCRN,
  MFFSCRNI,
  MFFSL,
  MFFS_rec,
  MFLR,
  MFLR8,
  MFMSR,
  MFOCRF,
  MFOCRF8,
  MFPMR,
  MFSPR,
  MFSPR8,
  MFSR,
  MFSRIN,
  MFTB,
  MFTB8,
  MFUDSCR,
  MFVRD,
  MFVRSAVE,
  MFVRSAVEv,
  MFVRWZ,
  MFVSCR,
  MFVSRD,
  MFVSRLD,
  MFVSRWZ,
  MODSD,
  MODSW,
  MODUD,
  MODUW,
  MSGSYNC,
  MSYNC,
  MTCRF,
  MTCRF8,
  MTCTR,
  MTCTR8,
  MTCTR8loop,
  MTCTRloop,
  MTDCR,
  MTFSB0,
  MTFSB1,
  MTFSF,
  MTFSFI,
  MTFSFI_rec,
  MTFSFIb,
  MTFSF_rec,
  MTFSFb,
  MTLR,
  MTLR8,
  MTMSR,
  MTMSRD,
  MTOCRF,
  MTOCRF8,
  MTPMR,
  MTSPR,
  MTSPR8,
  MTSR,
  MTSRIN,
  MTUDSCR,
  MTVRD,
  MTVRSAVE,
  MTVRSAVEv,
  MTVRWA,
  MTVRWZ,
  MTVSCR,
  MTVSRBM,
  MTVSRBMI,
  MTVSRD,
  MTVSRDD,
  MTVSRDM,
  MTVSRHM,
  MTVSRQM,
  MTVSRWA,
  MTVSRWM,
  MTVSRWS,
  MTVSRWZ,
  MULHD,
  MULHDU,
  MULHDU_rec,
  MULHD_rec,
  MULHW,
  MULHWU,
  MULHWU_rec,
  MULHW_rec,
  MULLD,
  MULLDO,
  MULLDO_rec,
  MULLD_rec,
  MULLI,
  MULLI8,
  MULLW,
  MULLWO,
  MULLWO_rec,
  MULLW_rec,
  MoveGOTtoLR,
  MovePCtoLR,
  MovePCtoLR8,
  NAND,
  NAND8,
  NAND8_rec,
  NAND_rec,
  NAP,
  NEG,
  NEG8,
  NEG8O,
  NEG8O_rec,
  NEG8_rec,
  NEGO,
  NEGO_rec,
  NEG_rec,
  NOP,
  NOP_GT_PWR6,
  NOP_GT_PWR7,
  NOR,
  NOR8,
  NOR8_rec,
  NOR_rec,
  OR,
  OR8,
  OR8_rec,
  ORC,
  ORC8,
  ORC8_rec,
  ORC_rec,
  ORI,
  ORI8,
  ORIS,
  ORIS8,
  OR_rec,
  PADDI,
  PADDI8,
  PADDI8pc,
  PADDIdtprel,
  PADDIpc,
  PDEPD,
  PEXTD,
  PLA,
  PLA8,
  PLA8pc,
  PLApc,
  PLBZ,
  PLBZ8,
  PLBZ8nopc,
  PLBZ8onlypc,
  PLBZ8pc,
  PLBZnopc,
  PLBZonlypc,
  PLBZpc,
  PLD,
  PLDnopc,
  PLDonlypc,
  PLDpc,
  PLFD,
  PLFDnopc,
  PLFDonlypc,
  PLFDpc,
  PLFS,
  PLFSnopc,
  PLFSonlypc,
  PLFSpc,
  PLHA,
  PLHA8,
  PLHA8nopc,
  PLHA8onlypc,
  PLHA8pc,
  PLHAnopc,
  PLHAonlypc,
  PLHApc,
  PLHZ,
  PLHZ8,
  PLHZ8nopc,
  PLHZ8onlypc,
  PLHZ8pc,
  PLHZnopc,
  PLHZonlypc,
  PLHZpc,
  PLI,
  PLI8,
  PLWA,
  PLWA8,
  PLWA8nopc,
  PLWA8onlypc,
  PLWA8pc,
  PLWAnopc,
  PLWAonlypc,
  PLWApc,
  PLWZ,
  PLWZ8,
  PLWZ8nopc,
  PLWZ8onlypc,
  PLWZ8pc,
  PLWZnopc,
  PLWZonlypc,
  PLWZpc,
  PLXSD,
  PLXSDnopc,
  PLXSDonlypc,
  PLXSDpc,
  PLXSSP,
  PLXSSPnopc,
  PLXSSPonlypc,
  PLXSSPpc,
  PLXV,
  PLXVP,
  PLXVPnopc,
  PLXVPonlypc,
  PLXVPpc,
  PLXVnopc,
  PLXVonlypc,
  PLXVpc,
  PMXVBF16GER2,
  PMXVBF16GER2NN,
  PMXVBF16GER2NP,
  PMXVBF16GER2PN,
  PMXVBF16GER2PP,
  PMXVBF16GER2W,
  PMXVBF16GER2WNN,
  PMXVBF16GER2WNP,
  PMXVBF16GER2WPN,
  PMXVBF16GER2WPP,
  PMXVF16GER2,
  PMXVF16GER2NN,
  PMXVF16GER2NP,
  PMXVF16GER2PN,
  PMXVF16GER2PP,
  PMXVF16GER2W,
  PMXVF16GER2WNN,
  PMXVF16GER2WNP,
  PMXVF16GER2WPN,
  PMXVF16GER2WPP,
  PMXVF32GER,
  PMXVF32GERNN,
  PMXVF32GERNP,
  PMXVF32GERPN,
  PMXVF32GERPP,
  PMXVF32GERW,
  PMXVF32GERWNN,
  PMXVF32GERWNP,
  PMXVF32GERWPN,
  PMXVF32GERWPP,
  PMXVF64GER,
  PMXVF64GERNN,
  PMXVF64GERNP,
  PMXVF64GERPN,
  PMXVF64GERPP,
  PMXVF64GERW,
  PMXVF64GERWNN,
  PMXVF64GERWNP,
  PMXVF64GERWPN,
  PMXVF64GERWPP,
  PMXVI16GER2,
  PMXVI16GER2PP,
  PMXVI16GER2S,
  PMXVI16GER2SPP,
  PMXVI16GER2SW,
  PMXVI16GER2SWPP,
  PMXVI16GER2W,
  PMXVI16GER2WPP,
  PMXVI4GER8,
  PMXVI4GER8PP,
  PMXVI4GER8W,
  PMXVI4GER8WPP,
  PMXVI8GER4,
  PMXVI8GER4PP,
  PMXVI8GER4SPP,
  PMXVI8GER4W,
  PMXVI8GER4WPP,
  PMXVI8GER4WSPP,
  POPCNTB,
  POPCNTB8,
  POPCNTD,
  POPCNTW,
  PPC32GOT,
  PPC32PICGOT,
  PREPARE_PROBED_ALLOCA_32,
  PREPARE_PROBED_ALLOCA_64,
  PREPARE_PROBED_ALLOCA_NEGSIZE_SAME_REG_32,
  PREPARE_PROBED_ALLOCA_NEGSIZE_SAME_REG_64,
  PROBED_ALLOCA_32,
  PROBED_ALLOCA_64,
  PROBED_STACKALLOC_32,
  PROBED_STACKALLOC_64,
  PSTB,
  PSTB8,
  PSTB8nopc,
  PSTB8onlypc,
  PSTB8pc,
  PSTBnopc,
  PSTBonlypc,
  PSTBpc,
  PSTD,
  PSTDnopc,
  PSTDonlypc,
  PSTDpc,
  PSTFD,
  PSTFDnopc,
  PSTFDonlypc,
  PSTFDpc,
  PSTFS,
  PSTFSnopc,
  PSTFSonlypc,
  PSTFSpc,
  PSTH,
  PSTH8,
  PSTH8nopc,
  PSTH8onlypc,
  PSTH8pc,
  PSTHnopc,
  PSTHonlypc,
  PSTHpc,
  PSTW,
  PSTW8,
  PSTW8nopc,
  PSTW8onlypc,
  PSTW8pc,
  PSTWnopc,
  PSTWonlypc,
  PSTWpc,
  PSTXSD,
  PSTXSDnopc,
  PSTXSDonlypc,
  PSTXSDpc,
  PSTXSSP,
  PSTXSSPnopc,
  PSTXSSPonlypc,
  PSTXSSPpc,
  PSTXV,
  PSTXVP,
  PSTXVPnopc,
  PSTXVPonlypc,
  PSTXVPpc,
  PSTXVnopc,
  PSTXVonlypc,
  PSTXVpc,
  PseudoEIEIO,
  RESTORE_ACC,
  RESTORE_CR,
  RESTORE_CRBIT,
  RESTORE_QUADWORD,
  RESTORE_UACC,
  RESTORE_WACC,
  RFCI,
  RFDI,
  RFEBB,
  RFI,
  RFID,
  RFMCI,
  RLDCL,
  RLDCL_rec,
  RLDCR,
  RLDCR_rec,
  RLDIC,
  RLDICL,
  RLDICL_32,
  RLDICL_32_64,
  RLDICL_32_rec,
  RLDICL_rec,
  RLDICR,
  RLDICR_32,
  RLDICR_rec,
  RLDIC_rec,
  RLDIMI,
  RLDIMI_rec,
  RLWIMI,
  RLWIMI8,
  RLWIMI8_rec,
  RLWIMI_rec,
  RLWINM,
  RLWINM8,
  RLWINM8_rec,
  RLWINM_rec,
  RLWNM,
  RLWNM8,
  RLWNM8_rec,
  RLWNM_rec,
  ReadTB,
  SC,
  SCV,
  SELECT_CC_F16,
  SELECT_CC_F4,
  SELECT_CC_F8,
  SELECT_CC_I4,
  SELECT_CC_I8,
  SELECT_CC_SPE,
  SELECT_CC_SPE4,
  SELECT_CC_VRRC,
  SELECT_CC_VSFRC,
  SELECT_CC_VSRC,
  SELECT_CC_VSSRC,
  SELECT_F16,
  SELECT_F4,
  SELECT_F8,
  SELECT_I4,
  SELECT_I8,
  SELECT_SPE,
  SELECT_SPE4,
  SELECT_VRRC,
  SELECT_VSFRC,
  SELECT_VSRC,
  SELECT_VSSRC,
  SETB,
  SETB8,
  SETBC,
  SETBC8,
  SETBCR,
  SETBCR8,
  SETFLM,
  SETNBC,
  SETNBC8,
  SETNBCR,
  SETNBCR8,
  SETRND,
  SETRNDi,
  SLBFEE_rec,
  SLBIA,
  SLBIE,
  SLBIEG,
  SLBMFEE,
  SLBMFEV,
  SLBMTE,
  SLBSYNC,
  SLD,
  SLD_rec,
  SLW,
  SLW8,
  SLW8_rec,
  SLW_rec,
  SPELWZ,
  SPELWZX,
  SPESTW,
  SPESTWX,
  SPILL_ACC,
  SPILL_CR,
  SPILL_CRBIT,
  SPILL_QUADWORD,
  SPILL_UACC,
  SPILL_WACC,
  SPLIT_QUADWORD,
  SRAD,
  SRADI,
  SRADI_32,
  SRADI_rec,
  SRAD_rec,
  SRAW,
  SRAWI,
  SRAWI_rec,
  SRAW_rec,
  SRD,
  SRD_rec,
  SRW,
  SRW8,
  SRW8_rec,
  SRW_rec,
  STB,
  STB8,
  STBCIX,
  STBCX,
  STBEPX,
  STBU,
  STBU8,
  STBUX,
  STBUX8,
  STBX,
  STBX8,
  STBXTLS,
  STBXTLS_,
  STBXTLS_32,
  STD,
  STDAT,
  STDBRX,
  STDCIX,
  STDCX,
  STDU,
  STDUX,
  STDX,
  STDXTLS,
  STDXTLS_,
  STFD,
  STFDEPX,
  STFDU,
  STFDUX,
  STFDX,
  STFDXTLS,
  STFDXTLS_,
  STFIWX,
  STFS,
  STFSU,
  STFSUX,
  STFSX,
  STFSXTLS,
  STFSXTLS_,
  STH,
  STH8,
  STHBRX,
  STHCIX,
  STHCX,
  STHEPX,
  STHU,
  STHU8,
  STHUX,
  STHUX8,
  STHX,
  STHX8,
  STHXTLS,
  STHXTLS_,
  STHXTLS_32,
  STMW,
  STOP,
  STQ,
  STQCX,
  STQX_PSEUDO,
  STSWI,
  STVEBX,
  STVEHX,
  STVEWX,
  STVX,
  STVXL,
  STW,
  STW8,
  STWAT,
  STWBRX,
  STWCIX,
  STWCX,
  STWEPX,
  STWU,
  STWU8,
  STWUX,
  STWUX8,
  STWX,
  STWX8,
  STWXTLS,
  STWXTLS_,
  STWXTLS_32,
  STXSD,
  STXSDX,
  STXSIBX,
  STXSIBXv,
  STXSIHX,
  STXSIHXv,
  STXSIWX,
  STXSSP,
  STXSSPX,
  STXV,
  STXVB16X,
  STXVD2X,
  STXVH8X,
  STXVL,
  STXVLL,
  STXVP,
  STXVPRL,
  STXVPRLL,
  STXVPX,
  STXVRBX,
  STXVRDX,
  STXVRHX,
  STXVRL,
  STXVRLL,
  STXVRWX,
  STXVW4X,
  STXVX,
  SUBF,
  SUBF8,
  SUBF8O,
  SUBF8O_rec,
  SUBF8_rec,
  SUBFC,
  SUBFC8,
  SUBFC8O,
  SUBFC8O_rec,
  SUBFC8_rec,
  SUBFCO,
  SUBFCO_rec,
  SUBFC_rec,
  SUBFE,
  SUBFE8,
  SUBFE8O,
  SUBFE8O_rec,
  SUBFE8_rec,
  SUBFEO,
  SUBFEO_rec,
  SUBFE_rec,
  SUBFIC,
  SUBFIC8,
  SUBFME,
  SUBFME8,
  SUBFME8O,
  SUBFME8O_rec,
  SUBFME8_rec,
  SUBFMEO,
  SUBFMEO_rec,
  SUBFME_rec,
  SUBFO,
  SUBFO_rec,
  SUBFUS,
  SUBFUS_rec,
  SUBFZE,
  SUBFZE8,
  SUBFZE8O,
  SUBFZE8O_rec,
  SUBFZE8_rec,
  SUBFZEO,
  SUBFZEO_rec,
  SUBFZE_rec,
  SUBF_rec,
  SYNC,
  SYNCP10,
  TABORT,
  TABORTDC,
  TABORTDCI,
  TABORTWC,
  TABORTWCI,
  TAILB,
  TAILB8,
  TAILBA,
  TAILBA8,
  TAILBCTR,
  TAILBCTR8,
  TBEGIN,
  TBEGIN_RET,
  TCHECK,
  TCHECK_RET,
  TCRETURNai,
  TCRETURNai8,
  TCRETURNdi,
  TCRETURNdi8,
  TCRETURNri,
  TCRETURNri8,
  TD,
  TDI,
  TEND,
  TLBIA,
  TLBIE,
  TLBIEL,
  TLBILX,
  TLBIVAX,
  TLBLD,
  TLBLI,
  TLBRE,
  TLBRE2,
  TLBSX,
  TLBSX2,
  TLBSX2D,
  TLBSYNC,
  TLBWE,
  TLBWE2,
  TLSGDAIX,
  TLSGDAIX8,
  TLSLDAIX,
  TLSLDAIX8,
  TRAP,
  TRECHKPT,
  TRECLAIM,
  TSR,
  TW,
  TWI,
  UNENCODED_NOP,
  UpdateGBR,
  VABSDUB,
  VABSDUH,
  VABSDUW,
  VADDCUQ,
  VADDCUW,
  VADDECUQ,
  VADDEUQM,
  VADDFP,
  VADDSBS,
  VADDSHS,
  VADDSWS,
  VADDUBM,
  VADDUBS,
  VADDUDM,
  VADDUHM,
  VADDUHS,
  VADDUQM,
  VADDUWM,
  VADDUWS,
  VAND,
  VANDC,
  VAVGSB,
  VAVGSH,
  VAVGSW,
  VAVGUB,
  VAVGUH,
  VAVGUW,
  VBPERMD,
  VBPERMQ,
  VCFSX,
  VCFSX_0,
  VCFUGED,
  VCFUX,
  VCFUX_0,
  VCIPHER,
  VCIPHERLAST,
  VCLRLB,
  VCLRRB,
  VCLZB,
  VCLZD,
  VCLZDM,
  VCLZH,
  VCLZLSBB,
  VCLZW,
  VCMPBFP,
  VCMPBFP_rec,
  VCMPEQFP,
  VCMPEQFP_rec,
  VCMPEQUB,
  VCMPEQUB_rec,
  VCMPEQUD,
  VCMPEQUD_rec,
  VCMPEQUH,
  VCMPEQUH_rec,
  VCMPEQUQ,
  VCMPEQUQ_rec,
  VCMPEQUW,
  VCMPEQUW_rec,
  VCMPGEFP,
  VCMPGEFP_rec,
  VCMPGTFP,
  VCMPGTFP_rec,
  VCMPGTSB,
  VCMPGTSB_rec,
  VCMPGTSD,
  VCMPGTSD_rec,
  VCMPGTSH,
  VCMPGTSH_rec,
  VCMPGTSQ,
  VCMPGTSQ_rec,
  VCMPGTSW,
  VCMPGTSW_rec,
  VCMPGTUB,
  VCMPGTUB_rec,
  VCMPGTUD,
  VCMPGTUD_rec,
  VCMPGTUH,
  VCMPGTUH_rec,
  VCMPGTUQ,
  VCMPGTUQ_rec,
  VCMPGTUW,
  VCMPGTUW_rec,
  VCMPNEB,
  VCMPNEB_rec,
  VCMPNEH,
  VCMPNEH_rec,
  VCMPNEW,
  VCMPNEW_rec,
  VCMPNEZB,
  VCMPNEZB_rec,
  VCMPNEZH,
  VCMPNEZH_rec,
  VCMPNEZW,
  VCMPNEZW_rec,
  VCMPSQ,
  VCMPUQ,
  VCNTMBB,
  VCNTMBD,
  VCNTMBH,
  VCNTMBW,
  VCTSXS,
  VCTSXS_0,
  VCTUXS,
  VCTUXS_0,
  VCTZB,
  VCTZD,
  VCTZDM,
  VCTZH,
  VCTZLSBB,
  VCTZW,
  VDIVESD,
  VDIVESQ,
  VDIVESW,
  VDIVEUD,
  VDIVEUQ,
  VDIVEUW,
  VDIVSD,
  VDIVSQ,
  VDIVSW,
  VDIVUD,
  VDIVUQ,
  VDIVUW,
  VEQV,
  VEXPANDBM,
  VEXPANDDM,
  VEXPANDHM,
  VEXPANDQM,
  VEXPANDWM,
  VEXPTEFP,
  VEXTDDVLX,
  VEXTDDVRX,
  VEXTDUBVLX,
  VEXTDUBVRX,
  VEXTDUHVLX,
  VEXTDUHVRX,
  VEXTDUWVLX,
  VEXTDUWVRX,
  VEXTRACTBM,
  VEXTRACTD,
  VEXTRACTDM,
  VEXTRACTHM,
  VEXTRACTQM,
  VEXTRACTUB,
  VEXTRACTUH,
  VEXTRACTUW,
  VEXTRACTWM,
  VEXTSB2D,
  VEXTSB2Ds,
  VEXTSB2W,
  VEXTSB2Ws,
  VEXTSD2Q,
  VEXTSH2D,
  VEXTSH2Ds,
  VEXTSH2W,
  VEXTSH2Ws,
  VEXTSW2D,
  VEXTSW2Ds,
  VEXTUBLX,
  VEXTUBRX,
  VEXTUHLX,
  VEXTUHRX,
  VEXTUWLX,
  VEXTUWRX,
  VGBBD,
  VGNB,
  VINSBLX,
  VINSBRX,
  VINSBVLX,
  VINSBVRX,
  VINSD,
  VINSDLX,
  VINSDRX,
  VINSERTB,
  VINSERTD,
  VINSERTH,
  VINSERTW,
  VINSHLX,
  VINSHRX,
  VINSHVLX,
  VINSHVRX,
  VINSW,
  VINSWLX,
  VINSWRX,
  VINSWVLX,
  VINSWVRX,
  VLOGEFP,
  VMADDFP,
  VMAXFP,
  VMAXSB,
  VMAXSD,
  VMAXSH,
  VMAXSW,
  VMAXUB,
  VMAXUD,
  VMAXUH,
  VMAXUW,
  VMHADDSHS,
  VMHRADDSHS,
  VMINFP,
  VMINSB,
  VMINSD,
  VMINSH,
  VMINSW,
  VMINUB,
  VMINUD,
  VMINUH,
  VMINUW,
  VMLADDUHM,
  VMODSD,
  VMODSQ,
  VMODSW,
  VMODUD,
  VMODUQ,
  VMODUW,
  VMRGEW,
  VMRGHB,
  VMRGHH,
  VMRGHW,
  VMRGLB,
  VMRGLH,
  VMRGLW,
  VMRGOW,
  VMSUMCUD,
  VMSUMMBM,
  VMSUMSHM,
  VMSUMSHS,
  VMSUMUBM,
  VMSUMUDM,
  VMSUMUHM,
  VMSUMUHS,
  VMUL10CUQ,
  VMUL10ECUQ,
  VMUL10EUQ,
  VMUL10UQ,
  VMULESB,
  VMULESD,
  VMULESH,
  VMULESW,
  VMULEUB,
  VMULEUD,
  VMULEUH,
  VMULEUW,
  VMULHSD,
  VMULHSW,
  VMULHUD,
  VMULHUW,
  VMULLD,
  VMULOSB,
  VMULOSD,
  VMULOSH,
  VMULOSW,
  VMULOUB,
  VMULOUD,
  VMULOUH,
  VMULOUW,
  VMULUWM,
  VNAND,
  VNCIPHER,
  VNCIPHERLAST,
  VNEGD,
  VNEGW,
  VNMSUBFP,
  VNOR,
  VOR,
  VORC,
  VPDEPD,
  VPERM,
  VPERMR,
  VPERMXOR,
  VPEXTD,
  VPKPX,
  VPKSDSS,
  VPKSDUS,
  VPKSHSS,
  VPKSHUS,
  VPKSWSS,
  VPKSWUS,
  VPKUDUM,
  VPKUDUS,
  VPKUHUM,
  VPKUHUS,
  VPKUWUM,
  VPKUWUS,
  VPMSUMB,
  VPMSUMD,
  VPMSUMH,
  VPMSUMW,
  VPOPCNTB,
  VPOPCNTD,
  VPOPCNTH,
  VPOPCNTW,
  VPRTYBD,
  VPRTYBQ,
  VPRTYBW,
  VREFP,
  VRFIM,
  VRFIN,
  VRFIP,
  VRFIZ,
  VRLB,
  VRLD,
  VRLDMI,
  VRLDNM,
  VRLH,
  VRLQ,
  VRLQMI,
  VRLQNM,
  VRLW,
  VRLWMI,
  VRLWNM,
  VRSQRTEFP,
  VSBOX,
  VSEL,
  VSHASIGMAD,
  VSHASIGMAW,
  VSL,
  VSLB,
  VSLD,
  VSLDBI,
  VSLDOI,
  VSLH,
  VSLO,
  VSLQ,
  VSLV,
  VSLW,
  VSPLTB,
  VSPLTBs,
  VSPLTH,
  VSPLTHs,
  VSPLTISB,
  VSPLTISH,
  VSPLTISW,
  VSPLTW,
  VSR,
  VSRAB,
  VSRAD,
  VSRAH,
  VSRAQ,
  VSRAW,
  VSRB,
  VSRD,
  VSRDBI,
  VSRH,
  VSRO,
  VSRQ,
  VSRV,
  VSRW,
  VSTRIBL,
  VSTRIBL_rec,
  VSTRIBR,
  VSTRIBR_rec,
  VSTRIHL,
  VSTRIHL_rec,
  VSTRIHR,
  VSTRIHR_rec,
  VSUBCUQ,
  VSUBCUW,
  VSUBECUQ,
  VSUBEUQM,
  VSUBFP,
  VSUBSBS,
  VSUBSHS,
  VSUBSWS,
  VSUBUBM,
  VSUBUBS,
  VSUBUDM,
  VSUBUHM,
  VSUBUHS,
  VSUBUQM,
  VSUBUWM,
  VSUBUWS,
  VSUM2SWS,
  VSUM4SBS,
  VSUM4SHS,
  VSUM4UBS,
  VSUMSWS,
  VUPKHPX,
  VUPKHSB,
  VUPKHSH,
  VUPKHSW,
  VUPKLPX,
  VUPKLSB,
  VUPKLSH,
  VUPKLSW,
  VXOR,
  V_SET0,
  V_SET0B,
  V_SET0H,
  V_SETALLONES,
  V_SETALLONESB,
  V_SETALLONESH,
  WAIT,
  WAITP10,
  WRTEE,
  WRTEEI,
  XOR,
  XOR8,
  XOR8_rec,
  XORI,
  XORI8,
  XORIS,
  XORIS8,
  XOR_rec,
  XSABSDP,
  XSABSQP,
  XSADDDP,
  XSADDQP,
  XSADDQPO,
  XSADDSP,
  XSCMPEQDP,
  XSCMPEQQP,
  XSCMPEXPDP,
  XSCMPEXPQP,
  XSCMPGEDP,
  XSCMPGEQP,
  XSCMPGTDP,
  XSCMPGTQP,
  XSCMPODP,
  XSCMPOQP,
  XSCMPUDP,
  XSCMPUQP,
  XSCPSGNDP,
  XSCPSGNQP,
  XSCVDPHP,
  XSCVDPQP,
  XSCVDPSP,
  XSCVDPSPN,
  XSCVDPSXDS,
  XSCVDPSXDSs,
  XSCVDPSXWS,
  XSCVDPSXWSs,
  XSCVDPUXDS,
  XSCVDPUXDSs,
  XSCVDPUXWS,
  XSCVDPUXWSs,
  XSCVHPDP,
  XSCVQPDP,
  XSCVQPDPO,
  XSCVQPSDZ,
  XSCVQPSQZ,
  XSCVQPSWZ,
  XSCVQPUDZ,
  XSCVQPUQZ,
  XSCVQPUWZ,
  XSCVSDQP,
  XSCVSPDP,
  XSCVSPDPN,
  XSCVSQQP,
  XSCVSXDDP,
  XSCVSXDSP,
  XSCVUDQP,
  XSCVUQQP,
  XSCVUXDDP,
  XSCVUXDSP,
  XSDIVDP,
  XSDIVQP,
  XSDIVQPO,
  XSDIVSP,
  XSIEXPDP,
  XSIEXPQP,
  XSMADDADP,
  XSMADDASP,
  XSMADDMDP,
  XSMADDMSP,
  XSMADDQP,
  XSMADDQPO,
  XSMAXCDP,
  XSMAXCQP,
  XSMAXDP,
  XSMAXJDP,
  XSMINCDP,
  XSMINCQP,
  XSMINDP,
  XSMINJDP,
  XSMSUBADP,
  XSMSUBASP,
  XSMSUBMDP,
  XSMSUBMSP,
  XSMSUBQP,
  XSMSUBQPO,
  XSMULDP,
  XSMULQP,
  XSMULQPO,
  XSMULSP,
  XSNABSDP,
  XSNABSDPs,
  XSNABSQP,
  XSNEGDP,
  XSNEGQP,
  XSNMADDADP,
  XSNMADDASP,
  XSNMADDMDP,
  XSNMADDMSP,
  XSNMADDQP,
  XSNMADDQPO,
  XSNMSUBADP,
  XSNMSUBASP,
  XSNMSUBMDP,
  XSNMSUBMSP,
  XSNMSUBQP,
  XSNMSUBQPO,
  XSRDPI,
  XSRDPIC,
  XSRDPIM,
  XSRDPIP,
  XSRDPIZ,
  XSREDP,
  XSRESP,
  XSRQPI,
  XSRQPIX,
  XSRQPXP,
  XSRSP,
  XSRSQRTEDP,
  XSRSQRTESP,
  XSSQRTDP,
  XSSQRTQP,
  XSSQRTQPO,
  XSSQRTSP,
  XSSUBDP,
  XSSUBQP,
  XSSUBQPO,
  XSSUBSP,
  XSTDIVDP,
  XSTSQRTDP,
  XSTSTDCDP,
  XSTSTDCQP,
  XSTSTDCSP,
  XSXEXPDP,
  XSXEXPQP,
  XSXSIGDP,
  XSXSIGQP,
  XVABSDP,
  XVABSSP,
  XVADDDP,
  XVADDSP,
  XVBF16GER2,
  XVBF16GER2NN,
  XVBF16GER2NP,
  XVBF16GER2PN,
  XVBF16GER2PP,
  XVBF16GER2W,
  XVBF16GER2WNN,
  XVBF16GER2WNP,
  XVBF16GER2WPN,
  XVBF16GER2WPP,
  XVCMPEQDP,
  XVCMPEQDP_rec,
  XVCMPEQSP,
  XVCMPEQSP_rec,
  XVCMPGEDP,
  XVCMPGEDP_rec,
  XVCMPGESP,
  XVCMPGESP_rec,
  XVCMPGTDP,
  XVCMPGTDP_rec,
  XVCMPGTSP,
  XVCMPGTSP_rec,
  XVCPSGNDP,
  XVCPSGNSP,
  XVCVBF16SPN,
  XVCVDPSP,
  XVCVDPSXDS,
  XVCVDPSXWS,
  XVCVDPUXDS,
  XVCVDPUXWS,
  XVCVHPSP,
  XVCVSPBF16,
  XVCVSPDP,
  XVCVSPHP,
  XVCVSPSXDS,
  XVCVSPSXWS,
  XVCVSPUXDS,
  XVCVSPUXWS,
  XVCVSXDDP,
  XVCVSXDSP,
  XVCVSXWDP,
  XVCVSXWSP,
  XVCVUXDDP,
  XVCVUXDSP,
  XVCVUXWDP,
  XVCVUXWSP,
  XVDIVDP,
  XVDIVSP,
  XVF16GER2,
  XVF16GER2NN,
  XVF16GER2NP,
  XVF16GER2PN,
  XVF16GER2PP,
  XVF16GER2W,
  XVF16GER2WNN,
  XVF16GER2WNP,
  XVF16GER2WPN,
  XVF16GER2WPP,
  XVF32GER,
  XVF32GERNN,
  XVF32GERNP,
  XVF32GERPN,
  XVF32GERPP,
  XVF32GERW,
  XVF32GERWNN,
  XVF32GERWNP,
  XVF32GERWPN,
  XVF32GERWPP,
  XVF64GER,
  XVF64GERNN,
  XVF64GERNP,
  XVF64GERPN,
  XVF64GERPP,
  XVF64GERW,
  XVF64GERWNN,
  XVF64GERWNP,
  XVF64GERWPN,
  XVF64GERWPP,
  XVI16GER2,
  XVI16GER2PP,
  XVI16GER2S,
  XVI16GER2SPP,
  XVI16GER2SW,
  XVI16GER2SWPP,
  XVI16GER2W,
  XVI16GER2WPP,
  XVI4GER8,
  XVI4GER8PP,
  XVI4GER8W,
  XVI4GER8WPP,
  XVI8GER4,
  XVI8GER4PP,
  XVI8GER4SPP,
  XVI8GER4W,
  XVI8GER4WPP,
  XVI8GER4WSPP,
  XVIEXPDP,
  XVIEXPSP,
  XVMADDADP,
  XVMADDASP,
  XVMADDMDP,
  XVMADDMSP,
  XVMAXDP,
  XVMAXSP,
  XVMINDP,
  XVMINSP,
  XVMSUBADP,
  XVMSUBASP,
  XVMSUBMDP,
  XVMSUBMSP,
  XVMULDP,
  XVMULSP,
  XVNABSDP,
  XVNABSSP,
  XVNEGDP,
  XVNEGSP,
  XVNMADDADP,
  XVNMADDASP,
  XVNMADDMDP,
  XVNMADDMSP,
  XVNMSUBADP,
  XVNMSUBASP,
  XVNMSUBMDP,
  XVNMSUBMSP,
  XVRDPI,
  XVRDPIC,
  XVRDPIM,
  XVRDPIP,
  XVRDPIZ,
  XVREDP,
  XVRESP,
  XVRSPI,
  XVRSPIC,
  XVRSPIM,
  XVRSPIP,
  XVRSPIZ,
  XVRSQRTEDP,
  XVRSQRTESP,
  XVSQRTDP,
  XVSQRTSP,
  XVSUBDP,
  XVSUBSP,
  XVTDIVDP,
  XVTDIVSP,
  XVTLSBB,
  XVTSQRTDP,
  XVTSQRTSP,
  XVTSTDCDP,
  XVTSTDCSP,
  XVXEXPDP,
  XVXEXPSP,
  XVXSIGDP,
  XVXSIGSP,
  XXBLENDVB,
  XXBLENDVD,
  XXBLENDVH,
  XXBLENDVW,
  XXBRD,
  XXBRH,
  XXBRQ,
  XXBRW,
  XXEVAL,
  XXEXTRACTUW,
  XXGENPCVBM,
  XXGENPCVDM,
  XXGENPCVHM,
  XXGENPCVWM,
  XXINSERTW,
  XXLAND,
  XXLANDC,
  XXLEQV,
  XXLEQVOnes,
  XXLNAND,
  XXLNOR,
  XXLOR,
  XXLORC,
  XXLORf,
  XXLXOR,
  XXLXORdpz,
  XXLXORspz,
  XXLXORz,
  XXMFACC,
  XXMFACCW,
  XXMRGHW,
  XXMRGLW,
  XXMTACC,
  XXMTACCW,
  XXPERM,
  XXPERMDI,
  XXPERMDIs,
  XXPERMR,
  XXPERMX,
  XXSEL,
  XXSETACCZ,
  XXSETACCZW,
  XXSLDWI,
  XXSLDWIs,
  XXSPLTI32DX,
  XXSPLTIB,
  XXSPLTIDP,
  XXSPLTIW,
  XXSPLTW,
  XXSPLTWs,
  gBC,
  gBCA,
  gBCAat,
  gBCCTR,
  gBCCTRL,
  gBCL,
  gBCLA,
  gBCLAat,
  gBCLR,
  gBCLRL,
  gBCLat,
  gBCat,
  INSTRUCTION_LIST_END,
  UNKNOWN(u64),
}

impl From<u64> for Opcode {
    fn from(value: u64) -> Self {
        match value {
          0 => Opcode::PHI,
          1 => Opcode::INLINEASM,
          2 => Opcode::INLINEASM_BR,
          3 => Opcode::CFI_INSTRUCTION,
          4 => Opcode::EH_LABEL,
          5 => Opcode::GC_LABEL,
          6 => Opcode::ANNOTATION_LABEL,
          7 => Opcode::KILL,
          8 => Opcode::EXTRACT_SUBREG,
          9 => Opcode::INSERT_SUBREG,
          10 => Opcode::IMPLICIT_DEF,
          11 => Opcode::SUBREG_TO_REG,
          12 => Opcode::COPY_TO_REGCLASS,
          13 => Opcode::DBG_VALUE,
          14 => Opcode::DBG_VALUE_LIST,
          15 => Opcode::DBG_INSTR_REF,
          16 => Opcode::DBG_PHI,
          17 => Opcode::DBG_LABEL,
          18 => Opcode::REG_SEQUENCE,
          19 => Opcode::COPY,
          20 => Opcode::BUNDLE,
          21 => Opcode::LIFETIME_START,
          22 => Opcode::LIFETIME_END,
          23 => Opcode::PSEUDO_PROBE,
          24 => Opcode::ARITH_FENCE,
          25 => Opcode::STACKMAP,
          26 => Opcode::FENTRY_CALL,
          27 => Opcode::PATCHPOINT,
          28 => Opcode::LOAD_STACK_GUARD,
          29 => Opcode::PREALLOCATED_SETUP,
          30 => Opcode::PREALLOCATED_ARG,
          31 => Opcode::STATEPOINT,
          32 => Opcode::LOCAL_ESCAPE,
          33 => Opcode::FAULTING_OP,
          34 => Opcode::PATCHABLE_OP,
          35 => Opcode::PATCHABLE_FUNCTION_ENTER,
          36 => Opcode::PATCHABLE_RET,
          37 => Opcode::PATCHABLE_FUNCTION_EXIT,
          38 => Opcode::PATCHABLE_TAIL_CALL,
          39 => Opcode::PATCHABLE_EVENT_CALL,
          40 => Opcode::PATCHABLE_TYPED_EVENT_CALL,
          41 => Opcode::ICALL_BRANCH_FUNNEL,
          42 => Opcode::MEMBARRIER,
          43 => Opcode::JUMP_TABLE_DEBUG_INFO,
          44 => Opcode::CONVERGENCECTRL_ENTRY,
          45 => Opcode::CONVERGENCECTRL_ANCHOR,
          46 => Opcode::CONVERGENCECTRL_LOOP,
          47 => Opcode::CONVERGENCECTRL_GLUE,
          48 => Opcode::G_ASSERT_SEXT,
          49 => Opcode::G_ASSERT_ZEXT,
          50 => Opcode::G_ASSERT_ALIGN,
          51 => Opcode::G_ADD,
          52 => Opcode::G_SUB,
          53 => Opcode::G_MUL,
          54 => Opcode::G_SDIV,
          55 => Opcode::G_UDIV,
          56 => Opcode::G_SREM,
          57 => Opcode::G_UREM,
          58 => Opcode::G_SDIVREM,
          59 => Opcode::G_UDIVREM,
          60 => Opcode::G_AND,
          61 => Opcode::G_OR,
          62 => Opcode::G_XOR,
          63 => Opcode::G_IMPLICIT_DEF,
          64 => Opcode::G_PHI,
          65 => Opcode::G_FRAME_INDEX,
          66 => Opcode::G_GLOBAL_VALUE,
          67 => Opcode::G_PTRAUTH_GLOBAL_VALUE,
          68 => Opcode::G_CONSTANT_POOL,
          69 => Opcode::G_EXTRACT,
          70 => Opcode::G_UNMERGE_VALUES,
          71 => Opcode::G_INSERT,
          72 => Opcode::G_MERGE_VALUES,
          73 => Opcode::G_BUILD_VECTOR,
          74 => Opcode::G_BUILD_VECTOR_TRUNC,
          75 => Opcode::G_CONCAT_VECTORS,
          76 => Opcode::G_PTRTOINT,
          77 => Opcode::G_INTTOPTR,
          78 => Opcode::G_BITCAST,
          79 => Opcode::G_FREEZE,
          80 => Opcode::G_CONSTANT_FOLD_BARRIER,
          81 => Opcode::G_INTRINSIC_FPTRUNC_ROUND,
          82 => Opcode::G_INTRINSIC_TRUNC,
          83 => Opcode::G_INTRINSIC_ROUND,
          84 => Opcode::G_INTRINSIC_LRINT,
          85 => Opcode::G_INTRINSIC_LLRINT,
          86 => Opcode::G_INTRINSIC_ROUNDEVEN,
          87 => Opcode::G_READCYCLECOUNTER,
          88 => Opcode::G_READSTEADYCOUNTER,
          89 => Opcode::G_LOAD,
          90 => Opcode::G_SEXTLOAD,
          91 => Opcode::G_ZEXTLOAD,
          92 => Opcode::G_INDEXED_LOAD,
          93 => Opcode::G_INDEXED_SEXTLOAD,
          94 => Opcode::G_INDEXED_ZEXTLOAD,
          95 => Opcode::G_STORE,
          96 => Opcode::G_INDEXED_STORE,
          97 => Opcode::G_ATOMIC_CMPXCHG_WITH_SUCCESS,
          98 => Opcode::G_ATOMIC_CMPXCHG,
          99 => Opcode::G_ATOMICRMW_XCHG,
          100 => Opcode::G_ATOMICRMW_ADD,
          101 => Opcode::G_ATOMICRMW_SUB,
          102 => Opcode::G_ATOMICRMW_AND,
          103 => Opcode::G_ATOMICRMW_NAND,
          104 => Opcode::G_ATOMICRMW_OR,
          105 => Opcode::G_ATOMICRMW_XOR,
          106 => Opcode::G_ATOMICRMW_MAX,
          107 => Opcode::G_ATOMICRMW_MIN,
          108 => Opcode::G_ATOMICRMW_UMAX,
          109 => Opcode::G_ATOMICRMW_UMIN,
          110 => Opcode::G_ATOMICRMW_FADD,
          111 => Opcode::G_ATOMICRMW_FSUB,
          112 => Opcode::G_ATOMICRMW_FMAX,
          113 => Opcode::G_ATOMICRMW_FMIN,
          114 => Opcode::G_ATOMICRMW_UINC_WRAP,
          115 => Opcode::G_ATOMICRMW_UDEC_WRAP,
          116 => Opcode::G_FENCE,
          117 => Opcode::G_PREFETCH,
          118 => Opcode::G_BRCOND,
          119 => Opcode::G_BRINDIRECT,
          120 => Opcode::G_INVOKE_REGION_START,
          121 => Opcode::G_INTRINSIC,
          122 => Opcode::G_INTRINSIC_W_SIDE_EFFECTS,
          123 => Opcode::G_INTRINSIC_CONVERGENT,
          124 => Opcode::G_INTRINSIC_CONVERGENT_W_SIDE_EFFECTS,
          125 => Opcode::G_ANYEXT,
          126 => Opcode::G_TRUNC,
          127 => Opcode::G_CONSTANT,
          128 => Opcode::G_FCONSTANT,
          129 => Opcode::G_VASTART,
          130 => Opcode::G_VAARG,
          131 => Opcode::G_SEXT,
          132 => Opcode::G_SEXT_INREG,
          133 => Opcode::G_ZEXT,
          134 => Opcode::G_SHL,
          135 => Opcode::G_LSHR,
          136 => Opcode::G_ASHR,
          137 => Opcode::G_FSHL,
          138 => Opcode::G_FSHR,
          139 => Opcode::G_ROTR,
          140 => Opcode::G_ROTL,
          141 => Opcode::G_ICMP,
          142 => Opcode::G_FCMP,
          143 => Opcode::G_SCMP,
          144 => Opcode::G_UCMP,
          145 => Opcode::G_SELECT,
          146 => Opcode::G_UADDO,
          147 => Opcode::G_UADDE,
          148 => Opcode::G_USUBO,
          149 => Opcode::G_USUBE,
          150 => Opcode::G_SADDO,
          151 => Opcode::G_SADDE,
          152 => Opcode::G_SSUBO,
          153 => Opcode::G_SSUBE,
          154 => Opcode::G_UMULO,
          155 => Opcode::G_SMULO,
          156 => Opcode::G_UMULH,
          157 => Opcode::G_SMULH,
          158 => Opcode::G_UADDSAT,
          159 => Opcode::G_SADDSAT,
          160 => Opcode::G_USUBSAT,
          161 => Opcode::G_SSUBSAT,
          162 => Opcode::G_USHLSAT,
          163 => Opcode::G_SSHLSAT,
          164 => Opcode::G_SMULFIX,
          165 => Opcode::G_UMULFIX,
          166 => Opcode::G_SMULFIXSAT,
          167 => Opcode::G_UMULFIXSAT,
          168 => Opcode::G_SDIVFIX,
          169 => Opcode::G_UDIVFIX,
          170 => Opcode::G_SDIVFIXSAT,
          171 => Opcode::G_UDIVFIXSAT,
          172 => Opcode::G_FADD,
          173 => Opcode::G_FSUB,
          174 => Opcode::G_FMUL,
          175 => Opcode::G_FMA,
          176 => Opcode::G_FMAD,
          177 => Opcode::G_FDIV,
          178 => Opcode::G_FREM,
          179 => Opcode::G_FPOW,
          180 => Opcode::G_FPOWI,
          181 => Opcode::G_FEXP,
          182 => Opcode::G_FEXP2,
          183 => Opcode::G_FEXP10,
          184 => Opcode::G_FLOG,
          185 => Opcode::G_FLOG2,
          186 => Opcode::G_FLOG10,
          187 => Opcode::G_FLDEXP,
          188 => Opcode::G_FFREXP,
          189 => Opcode::G_FNEG,
          190 => Opcode::G_FPEXT,
          191 => Opcode::G_FPTRUNC,
          192 => Opcode::G_FPTOSI,
          193 => Opcode::G_FPTOUI,
          194 => Opcode::G_SITOFP,
          195 => Opcode::G_UITOFP,
          196 => Opcode::G_FABS,
          197 => Opcode::G_FCOPYSIGN,
          198 => Opcode::G_IS_FPCLASS,
          199 => Opcode::G_FCANONICALIZE,
          200 => Opcode::G_FMINNUM,
          201 => Opcode::G_FMAXNUM,
          202 => Opcode::G_FMINNUM_IEEE,
          203 => Opcode::G_FMAXNUM_IEEE,
          204 => Opcode::G_FMINIMUM,
          205 => Opcode::G_FMAXIMUM,
          206 => Opcode::G_GET_FPENV,
          207 => Opcode::G_SET_FPENV,
          208 => Opcode::G_RESET_FPENV,
          209 => Opcode::G_GET_FPMODE,
          210 => Opcode::G_SET_FPMODE,
          211 => Opcode::G_RESET_FPMODE,
          212 => Opcode::G_PTR_ADD,
          213 => Opcode::G_PTRMASK,
          214 => Opcode::G_SMIN,
          215 => Opcode::G_SMAX,
          216 => Opcode::G_UMIN,
          217 => Opcode::G_UMAX,
          218 => Opcode::G_ABS,
          219 => Opcode::G_LROUND,
          220 => Opcode::G_LLROUND,
          221 => Opcode::G_BR,
          222 => Opcode::G_BRJT,
          223 => Opcode::G_VSCALE,
          224 => Opcode::G_INSERT_SUBVECTOR,
          225 => Opcode::G_EXTRACT_SUBVECTOR,
          226 => Opcode::G_INSERT_VECTOR_ELT,
          227 => Opcode::G_EXTRACT_VECTOR_ELT,
          228 => Opcode::G_SHUFFLE_VECTOR,
          229 => Opcode::G_SPLAT_VECTOR,
          230 => Opcode::G_VECTOR_COMPRESS,
          231 => Opcode::G_CTTZ,
          232 => Opcode::G_CTTZ_ZERO_UNDEF,
          233 => Opcode::G_CTLZ,
          234 => Opcode::G_CTLZ_ZERO_UNDEF,
          235 => Opcode::G_CTPOP,
          236 => Opcode::G_BSWAP,
          237 => Opcode::G_BITREVERSE,
          238 => Opcode::G_FCEIL,
          239 => Opcode::G_FCOS,
          240 => Opcode::G_FSIN,
          241 => Opcode::G_FTAN,
          242 => Opcode::G_FACOS,
          243 => Opcode::G_FASIN,
          244 => Opcode::G_FATAN,
          245 => Opcode::G_FCOSH,
          246 => Opcode::G_FSINH,
          247 => Opcode::G_FTANH,
          248 => Opcode::G_FSQRT,
          249 => Opcode::G_FFLOOR,
          250 => Opcode::G_FRINT,
          251 => Opcode::G_FNEARBYINT,
          252 => Opcode::G_ADDRSPACE_CAST,
          253 => Opcode::G_BLOCK_ADDR,
          254 => Opcode::G_JUMP_TABLE,
          255 => Opcode::G_DYN_STACKALLOC,
          256 => Opcode::G_STACKSAVE,
          257 => Opcode::G_STACKRESTORE,
          258 => Opcode::G_STRICT_FADD,
          259 => Opcode::G_STRICT_FSUB,
          260 => Opcode::G_STRICT_FMUL,
          261 => Opcode::G_STRICT_FDIV,
          262 => Opcode::G_STRICT_FREM,
          263 => Opcode::G_STRICT_FMA,
          264 => Opcode::G_STRICT_FSQRT,
          265 => Opcode::G_STRICT_FLDEXP,
          266 => Opcode::G_READ_REGISTER,
          267 => Opcode::G_WRITE_REGISTER,
          268 => Opcode::G_MEMCPY,
          269 => Opcode::G_MEMCPY_INLINE,
          270 => Opcode::G_MEMMOVE,
          271 => Opcode::G_MEMSET,
          272 => Opcode::G_BZERO,
          273 => Opcode::G_TRAP,
          274 => Opcode::G_DEBUGTRAP,
          275 => Opcode::G_UBSANTRAP,
          276 => Opcode::G_VECREDUCE_SEQ_FADD,
          277 => Opcode::G_VECREDUCE_SEQ_FMUL,
          278 => Opcode::G_VECREDUCE_FADD,
          279 => Opcode::G_VECREDUCE_FMUL,
          280 => Opcode::G_VECREDUCE_FMAX,
          281 => Opcode::G_VECREDUCE_FMIN,
          282 => Opcode::G_VECREDUCE_FMAXIMUM,
          283 => Opcode::G_VECREDUCE_FMINIMUM,
          284 => Opcode::G_VECREDUCE_ADD,
          285 => Opcode::G_VECREDUCE_MUL,
          286 => Opcode::G_VECREDUCE_AND,
          287 => Opcode::G_VECREDUCE_OR,
          288 => Opcode::G_VECREDUCE_XOR,
          289 => Opcode::G_VECREDUCE_SMAX,
          290 => Opcode::G_VECREDUCE_SMIN,
          291 => Opcode::G_VECREDUCE_UMAX,
          292 => Opcode::G_VECREDUCE_UMIN,
          293 => Opcode::G_SBFX,
          294 => Opcode::G_UBFX,
          295 => Opcode::ATOMIC_CMP_SWAP_I128,
          296 => Opcode::ATOMIC_LOAD_ADD_I128,
          297 => Opcode::ATOMIC_LOAD_AND_I128,
          298 => Opcode::ATOMIC_LOAD_NAND_I128,
          299 => Opcode::ATOMIC_LOAD_OR_I128,
          300 => Opcode::ATOMIC_LOAD_SUB_I128,
          301 => Opcode::ATOMIC_LOAD_XOR_I128,
          302 => Opcode::ATOMIC_SWAP_I128,
          303 => Opcode::BUILD_QUADWORD,
          304 => Opcode::BUILD_UACC,
          305 => Opcode::CFENCE,
          306 => Opcode::CFENCE8,
          307 => Opcode::CLRLSLDI,
          308 => Opcode::CLRLSLDI_rec,
          309 => Opcode::CLRLSLWI,
          310 => Opcode::CLRLSLWI_rec,
          311 => Opcode::CLRRDI,
          312 => Opcode::CLRRDI_rec,
          313 => Opcode::CLRRWI,
          314 => Opcode::CLRRWI_rec,
          315 => Opcode::DCBFL,
          316 => Opcode::DCBFLP,
          317 => Opcode::DCBFPS,
          318 => Opcode::DCBFx,
          319 => Opcode::DCBSTPS,
          320 => Opcode::DCBTCT,
          321 => Opcode::DCBTDS,
          322 => Opcode::DCBTSTCT,
          323 => Opcode::DCBTSTDS,
          324 => Opcode::DCBTSTT,
          325 => Opcode::DCBTSTx,
          326 => Opcode::DCBTT,
          327 => Opcode::DCBTx,
          328 => Opcode::DFLOADf32,
          329 => Opcode::DFLOADf64,
          330 => Opcode::DFSTOREf32,
          331 => Opcode::DFSTOREf64,
          332 => Opcode::EXTLDI,
          333 => Opcode::EXTLDI_rec,
          334 => Opcode::EXTLWI,
          335 => Opcode::EXTLWI_rec,
          336 => Opcode::EXTRDI,
          337 => Opcode::EXTRDI_rec,
          338 => Opcode::EXTRWI,
          339 => Opcode::EXTRWI_rec,
          340 => Opcode::INSLWI,
          341 => Opcode::INSLWI_rec,
          342 => Opcode::INSRDI,
          343 => Opcode::INSRDI_rec,
          344 => Opcode::INSRWI,
          345 => Opcode::INSRWI_rec,
          346 => Opcode::KILL_PAIR,
          347 => Opcode::LAx,
          348 => Opcode::LIWAX,
          349 => Opcode::LIWZX,
          350 => Opcode::PPCLdFixedAddr,
          351 => Opcode::PSUBI,
          352 => Opcode::RLWIMIbm,
          353 => Opcode::RLWIMIbm_rec,
          354 => Opcode::RLWINMbm,
          355 => Opcode::RLWINMbm_rec,
          356 => Opcode::RLWNMbm,
          357 => Opcode::RLWNMbm_rec,
          358 => Opcode::ROTRDI,
          359 => Opcode::ROTRDI_rec,
          360 => Opcode::ROTRWI,
          361 => Opcode::ROTRWI_rec,
          362 => Opcode::SLDI,
          363 => Opcode::SLDI_rec,
          364 => Opcode::SLWI,
          365 => Opcode::SLWI_rec,
          366 => Opcode::SPILLTOVSR_LD,
          367 => Opcode::SPILLTOVSR_LDX,
          368 => Opcode::SPILLTOVSR_ST,
          369 => Opcode::SPILLTOVSR_STX,
          370 => Opcode::SRDI,
          371 => Opcode::SRDI_rec,
          372 => Opcode::SRWI,
          373 => Opcode::SRWI_rec,
          374 => Opcode::STIWX,
          375 => Opcode::SUBI,
          376 => Opcode::SUBIC,
          377 => Opcode::SUBIC_rec,
          378 => Opcode::SUBIS,
          379 => Opcode::SUBPCIS,
          380 => Opcode::XFLOADf32,
          381 => Opcode::XFLOADf64,
          382 => Opcode::XFSTOREf32,
          383 => Opcode::XFSTOREf64,
          384 => Opcode::ADD4,
          385 => Opcode::ADD4O,
          386 => Opcode::ADD4O_rec,
          387 => Opcode::ADD4TLS,
          388 => Opcode::ADD4_rec,
          389 => Opcode::ADD8,
          390 => Opcode::ADD8O,
          391 => Opcode::ADD8O_rec,
          392 => Opcode::ADD8TLS,
          393 => Opcode::ADD8TLS_,
          394 => Opcode::ADD8_rec,
          395 => Opcode::ADDC,
          396 => Opcode::ADDC8,
          397 => Opcode::ADDC8O,
          398 => Opcode::ADDC8O_rec,
          399 => Opcode::ADDC8_rec,
          400 => Opcode::ADDCO,
          401 => Opcode::ADDCO_rec,
          402 => Opcode::ADDC_rec,
          403 => Opcode::ADDE,
          404 => Opcode::ADDE8,
          405 => Opcode::ADDE8O,
          406 => Opcode::ADDE8O_rec,
          407 => Opcode::ADDE8_rec,
          408 => Opcode::ADDEO,
          409 => Opcode::ADDEO_rec,
          410 => Opcode::ADDEX,
          411 => Opcode::ADDEX8,
          412 => Opcode::ADDE_rec,
          413 => Opcode::ADDG6S,
          414 => Opcode::ADDG6S8,
          415 => Opcode::ADDI,
          416 => Opcode::ADDI8,
          417 => Opcode::ADDIC,
          418 => Opcode::ADDIC8,
          419 => Opcode::ADDIC_rec,
          420 => Opcode::ADDIS,
          421 => Opcode::ADDIS8,
          422 => Opcode::ADDISdtprelHA,
          423 => Opcode::ADDISdtprelHA32,
          424 => Opcode::ADDISgotTprelHA,
          425 => Opcode::ADDIStlsgdHA,
          426 => Opcode::ADDIStlsldHA,
          427 => Opcode::ADDIStocHA,
          428 => Opcode::ADDIStocHA8,
          429 => Opcode::ADDIdtprelL,
          430 => Opcode::ADDIdtprelL32,
          431 => Opcode::ADDItlsgdL,
          432 => Opcode::ADDItlsgdL32,
          433 => Opcode::ADDItlsgdLADDR,
          434 => Opcode::ADDItlsgdLADDR32,
          435 => Opcode::ADDItlsldL,
          436 => Opcode::ADDItlsldL32,
          437 => Opcode::ADDItlsldLADDR,
          438 => Opcode::ADDItlsldLADDR32,
          439 => Opcode::ADDItoc,
          440 => Opcode::ADDItoc8,
          441 => Opcode::ADDItocL,
          442 => Opcode::ADDItocL8,
          443 => Opcode::ADDME,
          444 => Opcode::ADDME8,
          445 => Opcode::ADDME8O,
          446 => Opcode::ADDME8O_rec,
          447 => Opcode::ADDME8_rec,
          448 => Opcode::ADDMEO,
          449 => Opcode::ADDMEO_rec,
          450 => Opcode::ADDME_rec,
          451 => Opcode::ADDPCIS,
          452 => Opcode::ADDZE,
          453 => Opcode::ADDZE8,
          454 => Opcode::ADDZE8O,
          455 => Opcode::ADDZE8O_rec,
          456 => Opcode::ADDZE8_rec,
          457 => Opcode::ADDZEO,
          458 => Opcode::ADDZEO_rec,
          459 => Opcode::ADDZE_rec,
          460 => Opcode::ADJCALLSTACKDOWN,
          461 => Opcode::ADJCALLSTACKUP,
          462 => Opcode::AND,
          463 => Opcode::AND8,
          464 => Opcode::AND8_rec,
          465 => Opcode::ANDC,
          466 => Opcode::ANDC8,
          467 => Opcode::ANDC8_rec,
          468 => Opcode::ANDC_rec,
          469 => Opcode::ANDI8_rec,
          470 => Opcode::ANDIS8_rec,
          471 => Opcode::ANDIS_rec,
          472 => Opcode::ANDI_rec,
          473 => Opcode::ANDI_rec_1_EQ_BIT,
          474 => Opcode::ANDI_rec_1_EQ_BIT8,
          475 => Opcode::ANDI_rec_1_GT_BIT,
          476 => Opcode::ANDI_rec_1_GT_BIT8,
          477 => Opcode::AND_rec,
          478 => Opcode::ATOMIC_CMP_SWAP_I16,
          479 => Opcode::ATOMIC_CMP_SWAP_I32,
          480 => Opcode::ATOMIC_CMP_SWAP_I64,
          481 => Opcode::ATOMIC_CMP_SWAP_I8,
          482 => Opcode::ATOMIC_LOAD_ADD_I16,
          483 => Opcode::ATOMIC_LOAD_ADD_I32,
          484 => Opcode::ATOMIC_LOAD_ADD_I64,
          485 => Opcode::ATOMIC_LOAD_ADD_I8,
          486 => Opcode::ATOMIC_LOAD_AND_I16,
          487 => Opcode::ATOMIC_LOAD_AND_I32,
          488 => Opcode::ATOMIC_LOAD_AND_I64,
          489 => Opcode::ATOMIC_LOAD_AND_I8,
          490 => Opcode::ATOMIC_LOAD_MAX_I16,
          491 => Opcode::ATOMIC_LOAD_MAX_I32,
          492 => Opcode::ATOMIC_LOAD_MAX_I64,
          493 => Opcode::ATOMIC_LOAD_MAX_I8,
          494 => Opcode::ATOMIC_LOAD_MIN_I16,
          495 => Opcode::ATOMIC_LOAD_MIN_I32,
          496 => Opcode::ATOMIC_LOAD_MIN_I64,
          497 => Opcode::ATOMIC_LOAD_MIN_I8,
          498 => Opcode::ATOMIC_LOAD_NAND_I16,
          499 => Opcode::ATOMIC_LOAD_NAND_I32,
          500 => Opcode::ATOMIC_LOAD_NAND_I64,
          501 => Opcode::ATOMIC_LOAD_NAND_I8,
          502 => Opcode::ATOMIC_LOAD_OR_I16,
          503 => Opcode::ATOMIC_LOAD_OR_I32,
          504 => Opcode::ATOMIC_LOAD_OR_I64,
          505 => Opcode::ATOMIC_LOAD_OR_I8,
          506 => Opcode::ATOMIC_LOAD_SUB_I16,
          507 => Opcode::ATOMIC_LOAD_SUB_I32,
          508 => Opcode::ATOMIC_LOAD_SUB_I64,
          509 => Opcode::ATOMIC_LOAD_SUB_I8,
          510 => Opcode::ATOMIC_LOAD_UMAX_I16,
          511 => Opcode::ATOMIC_LOAD_UMAX_I32,
          512 => Opcode::ATOMIC_LOAD_UMAX_I64,
          513 => Opcode::ATOMIC_LOAD_UMAX_I8,
          514 => Opcode::ATOMIC_LOAD_UMIN_I16,
          515 => Opcode::ATOMIC_LOAD_UMIN_I32,
          516 => Opcode::ATOMIC_LOAD_UMIN_I64,
          517 => Opcode::ATOMIC_LOAD_UMIN_I8,
          518 => Opcode::ATOMIC_LOAD_XOR_I16,
          519 => Opcode::ATOMIC_LOAD_XOR_I32,
          520 => Opcode::ATOMIC_LOAD_XOR_I64,
          521 => Opcode::ATOMIC_LOAD_XOR_I8,
          522 => Opcode::ATOMIC_SWAP_I16,
          523 => Opcode::ATOMIC_SWAP_I32,
          524 => Opcode::ATOMIC_SWAP_I64,
          525 => Opcode::ATOMIC_SWAP_I8,
          526 => Opcode::ATTN,
          527 => Opcode::B,
          528 => Opcode::BA,
          529 => Opcode::BC,
          530 => Opcode::BCC,
          531 => Opcode::BCCA,
          532 => Opcode::BCCCTR,
          533 => Opcode::BCCCTR8,
          534 => Opcode::BCCCTRL,
          535 => Opcode::BCCCTRL8,
          536 => Opcode::BCCL,
          537 => Opcode::BCCLA,
          538 => Opcode::BCCLR,
          539 => Opcode::BCCLRL,
          540 => Opcode::BCCTR,
          541 => Opcode::BCCTR8,
          542 => Opcode::BCCTR8n,
          543 => Opcode::BCCTRL,
          544 => Opcode::BCCTRL8,
          545 => Opcode::BCCTRL8n,
          546 => Opcode::BCCTRLn,
          547 => Opcode::BCCTRn,
          548 => Opcode::BCDADD_rec,
          549 => Opcode::BCDCFN_rec,
          550 => Opcode::BCDCFSQ_rec,
          551 => Opcode::BCDCFZ_rec,
          552 => Opcode::BCDCPSGN_rec,
          553 => Opcode::BCDCTN_rec,
          554 => Opcode::BCDCTSQ_rec,
          555 => Opcode::BCDCTZ_rec,
          556 => Opcode::BCDSETSGN_rec,
          557 => Opcode::BCDSR_rec,
          558 => Opcode::BCDSUB_rec,
          559 => Opcode::BCDS_rec,
          560 => Opcode::BCDTRUNC_rec,
          561 => Opcode::BCDUS_rec,
          562 => Opcode::BCDUTRUNC_rec,
          563 => Opcode::BCL,
          564 => Opcode::BCLR,
          565 => Opcode::BCLRL,
          566 => Opcode::BCLRLn,
          567 => Opcode::BCLRn,
          568 => Opcode::BCLalways,
          569 => Opcode::BCLn,
          570 => Opcode::BCTR,
          571 => Opcode::BCTR8,
          572 => Opcode::BCTRL,
          573 => Opcode::BCTRL8,
          574 => Opcode::BCTRL8_LDinto_toc,
          575 => Opcode::BCTRL8_LDinto_toc_RM,
          576 => Opcode::BCTRL8_RM,
          577 => Opcode::BCTRL_LWZinto_toc,
          578 => Opcode::BCTRL_LWZinto_toc_RM,
          579 => Opcode::BCTRL_RM,
          580 => Opcode::BCn,
          581 => Opcode::BDNZ,
          582 => Opcode::BDNZ8,
          583 => Opcode::BDNZA,
          584 => Opcode::BDNZAm,
          585 => Opcode::BDNZAp,
          586 => Opcode::BDNZL,
          587 => Opcode::BDNZLA,
          588 => Opcode::BDNZLAm,
          589 => Opcode::BDNZLAp,
          590 => Opcode::BDNZLR,
          591 => Opcode::BDNZLR8,
          592 => Opcode::BDNZLRL,
          593 => Opcode::BDNZLRLm,
          594 => Opcode::BDNZLRLp,
          595 => Opcode::BDNZLRm,
          596 => Opcode::BDNZLRp,
          597 => Opcode::BDNZLm,
          598 => Opcode::BDNZLp,
          599 => Opcode::BDNZm,
          600 => Opcode::BDNZp,
          601 => Opcode::BDZ,
          602 => Opcode::BDZ8,
          603 => Opcode::BDZA,
          604 => Opcode::BDZAm,
          605 => Opcode::BDZAp,
          606 => Opcode::BDZL,
          607 => Opcode::BDZLA,
          608 => Opcode::BDZLAm,
          609 => Opcode::BDZLAp,
          610 => Opcode::BDZLR,
          611 => Opcode::BDZLR8,
          612 => Opcode::BDZLRL,
          613 => Opcode::BDZLRLm,
          614 => Opcode::BDZLRLp,
          615 => Opcode::BDZLRm,
          616 => Opcode::BDZLRp,
          617 => Opcode::BDZLm,
          618 => Opcode::BDZLp,
          619 => Opcode::BDZm,
          620 => Opcode::BDZp,
          621 => Opcode::BL,
          622 => Opcode::BL8,
          623 => Opcode::BL8_NOP,
          624 => Opcode::BL8_NOP_RM,
          625 => Opcode::BL8_NOP_TLS,
          626 => Opcode::BL8_NOTOC,
          627 => Opcode::BL8_NOTOC_RM,
          628 => Opcode::BL8_NOTOC_TLS,
          629 => Opcode::BL8_RM,
          630 => Opcode::BL8_TLS,
          631 => Opcode::BL8_TLS_,
          632 => Opcode::BLA,
          633 => Opcode::BLA8,
          634 => Opcode::BLA8_NOP,
          635 => Opcode::BLA8_NOP_RM,
          636 => Opcode::BLA8_RM,
          637 => Opcode::BLA_RM,
          638 => Opcode::BLR,
          639 => Opcode::BLR8,
          640 => Opcode::BLRL,
          641 => Opcode::BL_NOP,
          642 => Opcode::BL_NOP_RM,
          643 => Opcode::BL_RM,
          644 => Opcode::BL_TLS,
          645 => Opcode::BPERMD,
          646 => Opcode::BRD,
          647 => Opcode::BRH,
          648 => Opcode::BRH8,
          649 => Opcode::BRINC,
          650 => Opcode::BRW,
          651 => Opcode::BRW8,
          652 => Opcode::CBCDTD,
          653 => Opcode::CBCDTD8,
          654 => Opcode::CDTBCD,
          655 => Opcode::CDTBCD8,
          656 => Opcode::CFUGED,
          657 => Opcode::CLRBHRB,
          658 => Opcode::CMPB,
          659 => Opcode::CMPB8,
          660 => Opcode::CMPD,
          661 => Opcode::CMPDI,
          662 => Opcode::CMPEQB,
          663 => Opcode::CMPLD,
          664 => Opcode::CMPLDI,
          665 => Opcode::CMPLW,
          666 => Opcode::CMPLWI,
          667 => Opcode::CMPRB,
          668 => Opcode::CMPRB8,
          669 => Opcode::CMPW,
          670 => Opcode::CMPWI,
          671 => Opcode::CNTLZD,
          672 => Opcode::CNTLZDM,
          673 => Opcode::CNTLZD_rec,
          674 => Opcode::CNTLZW,
          675 => Opcode::CNTLZW8,
          676 => Opcode::CNTLZW8_rec,
          677 => Opcode::CNTLZW_rec,
          678 => Opcode::CNTTZD,
          679 => Opcode::CNTTZDM,
          680 => Opcode::CNTTZD_rec,
          681 => Opcode::CNTTZW,
          682 => Opcode::CNTTZW8,
          683 => Opcode::CNTTZW8_rec,
          684 => Opcode::CNTTZW_rec,
          685 => Opcode::CP_ABORT,
          686 => Opcode::CP_COPY,
          687 => Opcode::CP_COPY8,
          688 => Opcode::CP_PASTE8_rec,
          689 => Opcode::CP_PASTE_rec,
          690 => Opcode::CR6SET,
          691 => Opcode::CR6UNSET,
          692 => Opcode::CRAND,
          693 => Opcode::CRANDC,
          694 => Opcode::CREQV,
          695 => Opcode::CRNAND,
          696 => Opcode::CRNOR,
          697 => Opcode::CRNOT,
          698 => Opcode::CROR,
          699 => Opcode::CRORC,
          700 => Opcode::CRSET,
          701 => Opcode::CRUNSET,
          702 => Opcode::CRXOR,
          703 => Opcode::CTRL_DEP,
          704 => Opcode::DADD,
          705 => Opcode::DADDQ,
          706 => Opcode::DADDQ_rec,
          707 => Opcode::DADD_rec,
          708 => Opcode::DARN,
          709 => Opcode::DCBA,
          710 => Opcode::DCBF,
          711 => Opcode::DCBFEP,
          712 => Opcode::DCBI,
          713 => Opcode::DCBST,
          714 => Opcode::DCBSTEP,
          715 => Opcode::DCBT,
          716 => Opcode::DCBTEP,
          717 => Opcode::DCBTST,
          718 => Opcode::DCBTSTEP,
          719 => Opcode::DCBZ,
          720 => Opcode::DCBZEP,
          721 => Opcode::DCBZL,
          722 => Opcode::DCBZLEP,
          723 => Opcode::DCCCI,
          724 => Opcode::DCFFIX,
          725 => Opcode::DCFFIXQ,
          726 => Opcode::DCFFIXQQ,
          727 => Opcode::DCFFIXQ_rec,
          728 => Opcode::DCFFIX_rec,
          729 => Opcode::DCMPO,
          730 => Opcode::DCMPOQ,
          731 => Opcode::DCMPU,
          732 => Opcode::DCMPUQ,
          733 => Opcode::DCTDP,
          734 => Opcode::DCTDP_rec,
          735 => Opcode::DCTFIX,
          736 => Opcode::DCTFIXQ,
          737 => Opcode::DCTFIXQQ,
          738 => Opcode::DCTFIXQ_rec,
          739 => Opcode::DCTFIX_rec,
          740 => Opcode::DCTQPQ,
          741 => Opcode::DCTQPQ_rec,
          742 => Opcode::DDEDPD,
          743 => Opcode::DDEDPDQ,
          744 => Opcode::DDEDPDQ_rec,
          745 => Opcode::DDEDPD_rec,
          746 => Opcode::DDIV,
          747 => Opcode::DDIVQ,
          748 => Opcode::DDIVQ_rec,
          749 => Opcode::DDIV_rec,
          750 => Opcode::DENBCD,
          751 => Opcode::DENBCDQ,
          752 => Opcode::DENBCDQ_rec,
          753 => Opcode::DENBCD_rec,
          754 => Opcode::DIEX,
          755 => Opcode::DIEXQ,
          756 => Opcode::DIEXQ_rec,
          757 => Opcode::DIEX_rec,
          758 => Opcode::DIVD,
          759 => Opcode::DIVDE,
          760 => Opcode::DIVDEO,
          761 => Opcode::DIVDEO_rec,
          762 => Opcode::DIVDEU,
          763 => Opcode::DIVDEUO,
          764 => Opcode::DIVDEUO_rec,
          765 => Opcode::DIVDEU_rec,
          766 => Opcode::DIVDE_rec,
          767 => Opcode::DIVDO,
          768 => Opcode::DIVDO_rec,
          769 => Opcode::DIVDU,
          770 => Opcode::DIVDUO,
          771 => Opcode::DIVDUO_rec,
          772 => Opcode::DIVDU_rec,
          773 => Opcode::DIVD_rec,
          774 => Opcode::DIVW,
          775 => Opcode::DIVWE,
          776 => Opcode::DIVWEO,
          777 => Opcode::DIVWEO_rec,
          778 => Opcode::DIVWEU,
          779 => Opcode::DIVWEUO,
          780 => Opcode::DIVWEUO_rec,
          781 => Opcode::DIVWEU_rec,
          782 => Opcode::DIVWE_rec,
          783 => Opcode::DIVWO,
          784 => Opcode::DIVWO_rec,
          785 => Opcode::DIVWU,
          786 => Opcode::DIVWUO,
          787 => Opcode::DIVWUO_rec,
          788 => Opcode::DIVWU_rec,
          789 => Opcode::DIVW_rec,
          790 => Opcode::DMMR,
          791 => Opcode::DMSETDMRZ,
          792 => Opcode::DMUL,
          793 => Opcode::DMULQ,
          794 => Opcode::DMULQ_rec,
          795 => Opcode::DMUL_rec,
          796 => Opcode::DMXOR,
          797 => Opcode::DMXXEXTFDMR256,
          798 => Opcode::DMXXEXTFDMR512,
          799 => Opcode::DMXXEXTFDMR512_HI,
          800 => Opcode::DMXXINSTFDMR256,
          801 => Opcode::DMXXINSTFDMR512,
          802 => Opcode::DMXXINSTFDMR512_HI,
          803 => Opcode::DQUA,
          804 => Opcode::DQUAI,
          805 => Opcode::DQUAIQ,
          806 => Opcode::DQUAIQ_rec,
          807 => Opcode::DQUAI_rec,
          808 => Opcode::DQUAQ,
          809 => Opcode::DQUAQ_rec,
          810 => Opcode::DQUA_rec,
          811 => Opcode::DRDPQ,
          812 => Opcode::DRDPQ_rec,
          813 => Opcode::DRINTN,
          814 => Opcode::DRINTNQ,
          815 => Opcode::DRINTNQ_rec,
          816 => Opcode::DRINTN_rec,
          817 => Opcode::DRINTX,
          818 => Opcode::DRINTXQ,
          819 => Opcode::DRINTXQ_rec,
          820 => Opcode::DRINTX_rec,
          821 => Opcode::DRRND,
          822 => Opcode::DRRNDQ,
          823 => Opcode::DRRNDQ_rec,
          824 => Opcode::DRRND_rec,
          825 => Opcode::DRSP,
          826 => Opcode::DRSP_rec,
          827 => Opcode::DSCLI,
          828 => Opcode::DSCLIQ,
          829 => Opcode::DSCLIQ_rec,
          830 => Opcode::DSCLI_rec,
          831 => Opcode::DSCRI,
          832 => Opcode::DSCRIQ,
          833 => Opcode::DSCRIQ_rec,
          834 => Opcode::DSCRI_rec,
          835 => Opcode::DSS,
          836 => Opcode::DSSALL,
          837 => Opcode::DST,
          838 => Opcode::DST64,
          839 => Opcode::DSTST,
          840 => Opcode::DSTST64,
          841 => Opcode::DSTSTT,
          842 => Opcode::DSTSTT64,
          843 => Opcode::DSTT,
          844 => Opcode::DSTT64,
          845 => Opcode::DSUB,
          846 => Opcode::DSUBQ,
          847 => Opcode::DSUBQ_rec,
          848 => Opcode::DSUB_rec,
          849 => Opcode::DTSTDC,
          850 => Opcode::DTSTDCQ,
          851 => Opcode::DTSTDG,
          852 => Opcode::DTSTDGQ,
          853 => Opcode::DTSTEX,
          854 => Opcode::DTSTEXQ,
          855 => Opcode::DTSTSF,
          856 => Opcode::DTSTSFI,
          857 => Opcode::DTSTSFIQ,
          858 => Opcode::DTSTSFQ,
          859 => Opcode::DXEX,
          860 => Opcode::DXEXQ,
          861 => Opcode::DXEXQ_rec,
          862 => Opcode::DXEX_rec,
          863 => Opcode::DYNALLOC,
          864 => Opcode::DYNALLOC8,
          865 => Opcode::DYNAREAOFFSET,
          866 => Opcode::DYNAREAOFFSET8,
          867 => Opcode::DecreaseCTR8loop,
          868 => Opcode::DecreaseCTRloop,
          869 => Opcode::EFDABS,
          870 => Opcode::EFDADD,
          871 => Opcode::EFDCFS,
          872 => Opcode::EFDCFSF,
          873 => Opcode::EFDCFSI,
          874 => Opcode::EFDCFSID,
          875 => Opcode::EFDCFUF,
          876 => Opcode::EFDCFUI,
          877 => Opcode::EFDCFUID,
          878 => Opcode::EFDCMPEQ,
          879 => Opcode::EFDCMPGT,
          880 => Opcode::EFDCMPLT,
          881 => Opcode::EFDCTSF,
          882 => Opcode::EFDCTSI,
          883 => Opcode::EFDCTSIDZ,
          884 => Opcode::EFDCTSIZ,
          885 => Opcode::EFDCTUF,
          886 => Opcode::EFDCTUI,
          887 => Opcode::EFDCTUIDZ,
          888 => Opcode::EFDCTUIZ,
          889 => Opcode::EFDDIV,
          890 => Opcode::EFDMUL,
          891 => Opcode::EFDNABS,
          892 => Opcode::EFDNEG,
          893 => Opcode::EFDSUB,
          894 => Opcode::EFDTSTEQ,
          895 => Opcode::EFDTSTGT,
          896 => Opcode::EFDTSTLT,
          897 => Opcode::EFSABS,
          898 => Opcode::EFSADD,
          899 => Opcode::EFSCFD,
          900 => Opcode::EFSCFSF,
          901 => Opcode::EFSCFSI,
          902 => Opcode::EFSCFUF,
          903 => Opcode::EFSCFUI,
          904 => Opcode::EFSCMPEQ,
          905 => Opcode::EFSCMPGT,
          906 => Opcode::EFSCMPLT,
          907 => Opcode::EFSCTSF,
          908 => Opcode::EFSCTSI,
          909 => Opcode::EFSCTSIZ,
          910 => Opcode::EFSCTUF,
          911 => Opcode::EFSCTUI,
          912 => Opcode::EFSCTUIZ,
          913 => Opcode::EFSDIV,
          914 => Opcode::EFSMUL,
          915 => Opcode::EFSNABS,
          916 => Opcode::EFSNEG,
          917 => Opcode::EFSSUB,
          918 => Opcode::EFSTSTEQ,
          919 => Opcode::EFSTSTGT,
          920 => Opcode::EFSTSTLT,
          921 => Opcode::EH_SjLj_LongJmp32,
          922 => Opcode::EH_SjLj_LongJmp64,
          923 => Opcode::EH_SjLj_SetJmp32,
          924 => Opcode::EH_SjLj_SetJmp64,
          925 => Opcode::EH_SjLj_Setup,
          926 => Opcode::EQV,
          927 => Opcode::EQV8,
          928 => Opcode::EQV8_rec,
          929 => Opcode::EQV_rec,
          930 => Opcode::EVABS,
          931 => Opcode::EVADDIW,
          932 => Opcode::EVADDSMIAAW,
          933 => Opcode::EVADDSSIAAW,
          934 => Opcode::EVADDUMIAAW,
          935 => Opcode::EVADDUSIAAW,
          936 => Opcode::EVADDW,
          937 => Opcode::EVAND,
          938 => Opcode::EVANDC,
          939 => Opcode::EVCMPEQ,
          940 => Opcode::EVCMPGTS,
          941 => Opcode::EVCMPGTU,
          942 => Opcode::EVCMPLTS,
          943 => Opcode::EVCMPLTU,
          944 => Opcode::EVCNTLSW,
          945 => Opcode::EVCNTLZW,
          946 => Opcode::EVDIVWS,
          947 => Opcode::EVDIVWU,
          948 => Opcode::EVEQV,
          949 => Opcode::EVEXTSB,
          950 => Opcode::EVEXTSH,
          951 => Opcode::EVFSABS,
          952 => Opcode::EVFSADD,
          953 => Opcode::EVFSCFSF,
          954 => Opcode::EVFSCFSI,
          955 => Opcode::EVFSCFUF,
          956 => Opcode::EVFSCFUI,
          957 => Opcode::EVFSCMPEQ,
          958 => Opcode::EVFSCMPGT,
          959 => Opcode::EVFSCMPLT,
          960 => Opcode::EVFSCTSF,
          961 => Opcode::EVFSCTSI,
          962 => Opcode::EVFSCTSIZ,
          963 => Opcode::EVFSCTUF,
          964 => Opcode::EVFSCTUI,
          965 => Opcode::EVFSCTUIZ,
          966 => Opcode::EVFSDIV,
          967 => Opcode::EVFSMUL,
          968 => Opcode::EVFSNABS,
          969 => Opcode::EVFSNEG,
          970 => Opcode::EVFSSUB,
          971 => Opcode::EVFSTSTEQ,
          972 => Opcode::EVFSTSTGT,
          973 => Opcode::EVFSTSTLT,
          974 => Opcode::EVLDD,
          975 => Opcode::EVLDDX,
          976 => Opcode::EVLDH,
          977 => Opcode::EVLDHX,
          978 => Opcode::EVLDW,
          979 => Opcode::EVLDWX,
          980 => Opcode::EVLHHESPLAT,
          981 => Opcode::EVLHHESPLATX,
          982 => Opcode::EVLHHOSSPLAT,
          983 => Opcode::EVLHHOSSPLATX,
          984 => Opcode::EVLHHOUSPLAT,
          985 => Opcode::EVLHHOUSPLATX,
          986 => Opcode::EVLWHE,
          987 => Opcode::EVLWHEX,
          988 => Opcode::EVLWHOS,
          989 => Opcode::EVLWHOSX,
          990 => Opcode::EVLWHOU,
          991 => Opcode::EVLWHOUX,
          992 => Opcode::EVLWHSPLAT,
          993 => Opcode::EVLWHSPLATX,
          994 => Opcode::EVLWWSPLAT,
          995 => Opcode::EVLWWSPLATX,
          996 => Opcode::EVMERGEHI,
          997 => Opcode::EVMERGEHILO,
          998 => Opcode::EVMERGELO,
          999 => Opcode::EVMERGELOHI,
          1000 => Opcode::EVMHEGSMFAA,
          1001 => Opcode::EVMHEGSMFAN,
          1002 => Opcode::EVMHEGSMIAA,
          1003 => Opcode::EVMHEGSMIAN,
          1004 => Opcode::EVMHEGUMIAA,
          1005 => Opcode::EVMHEGUMIAN,
          1006 => Opcode::EVMHESMF,
          1007 => Opcode::EVMHESMFA,
          1008 => Opcode::EVMHESMFAAW,
          1009 => Opcode::EVMHESMFANW,
          1010 => Opcode::EVMHESMI,
          1011 => Opcode::EVMHESMIA,
          1012 => Opcode::EVMHESMIAAW,
          1013 => Opcode::EVMHESMIANW,
          1014 => Opcode::EVMHESSF,
          1015 => Opcode::EVMHESSFA,
          1016 => Opcode::EVMHESSFAAW,
          1017 => Opcode::EVMHESSFANW,
          1018 => Opcode::EVMHESSIAAW,
          1019 => Opcode::EVMHESSIANW,
          1020 => Opcode::EVMHEUMI,
          1021 => Opcode::EVMHEUMIA,
          1022 => Opcode::EVMHEUMIAAW,
          1023 => Opcode::EVMHEUMIANW,
          1024 => Opcode::EVMHEUSIAAW,
          1025 => Opcode::EVMHEUSIANW,
          1026 => Opcode::EVMHOGSMFAA,
          1027 => Opcode::EVMHOGSMFAN,
          1028 => Opcode::EVMHOGSMIAA,
          1029 => Opcode::EVMHOGSMIAN,
          1030 => Opcode::EVMHOGUMIAA,
          1031 => Opcode::EVMHOGUMIAN,
          1032 => Opcode::EVMHOSMF,
          1033 => Opcode::EVMHOSMFA,
          1034 => Opcode::EVMHOSMFAAW,
          1035 => Opcode::EVMHOSMFANW,
          1036 => Opcode::EVMHOSMI,
          1037 => Opcode::EVMHOSMIA,
          1038 => Opcode::EVMHOSMIAAW,
          1039 => Opcode::EVMHOSMIANW,
          1040 => Opcode::EVMHOSSF,
          1041 => Opcode::EVMHOSSFA,
          1042 => Opcode::EVMHOSSFAAW,
          1043 => Opcode::EVMHOSSFANW,
          1044 => Opcode::EVMHOSSIAAW,
          1045 => Opcode::EVMHOSSIANW,
          1046 => Opcode::EVMHOUMI,
          1047 => Opcode::EVMHOUMIA,
          1048 => Opcode::EVMHOUMIAAW,
          1049 => Opcode::EVMHOUMIANW,
          1050 => Opcode::EVMHOUSIAAW,
          1051 => Opcode::EVMHOUSIANW,
          1052 => Opcode::EVMRA,
          1053 => Opcode::EVMWHSMF,
          1054 => Opcode::EVMWHSMFA,
          1055 => Opcode::EVMWHSMI,
          1056 => Opcode::EVMWHSMIA,
          1057 => Opcode::EVMWHSSF,
          1058 => Opcode::EVMWHSSFA,
          1059 => Opcode::EVMWHUMI,
          1060 => Opcode::EVMWHUMIA,
          1061 => Opcode::EVMWLSMIAAW,
          1062 => Opcode::EVMWLSMIANW,
          1063 => Opcode::EVMWLSSIAAW,
          1064 => Opcode::EVMWLSSIANW,
          1065 => Opcode::EVMWLUMI,
          1066 => Opcode::EVMWLUMIA,
          1067 => Opcode::EVMWLUMIAAW,
          1068 => Opcode::EVMWLUMIANW,
          1069 => Opcode::EVMWLUSIAAW,
          1070 => Opcode::EVMWLUSIANW,
          1071 => Opcode::EVMWSMF,
          1072 => Opcode::EVMWSMFA,
          1073 => Opcode::EVMWSMFAA,
          1074 => Opcode::EVMWSMFAN,
          1075 => Opcode::EVMWSMI,
          1076 => Opcode::EVMWSMIA,
          1077 => Opcode::EVMWSMIAA,
          1078 => Opcode::EVMWSMIAN,
          1079 => Opcode::EVMWSSF,
          1080 => Opcode::EVMWSSFA,
          1081 => Opcode::EVMWSSFAA,
          1082 => Opcode::EVMWSSFAN,
          1083 => Opcode::EVMWUMI,
          1084 => Opcode::EVMWUMIA,
          1085 => Opcode::EVMWUMIAA,
          1086 => Opcode::EVMWUMIAN,
          1087 => Opcode::EVNAND,
          1088 => Opcode::EVNEG,
          1089 => Opcode::EVNOR,
          1090 => Opcode::EVOR,
          1091 => Opcode::EVORC,
          1092 => Opcode::EVRLW,
          1093 => Opcode::EVRLWI,
          1094 => Opcode::EVRNDW,
          1095 => Opcode::EVSEL,
          1096 => Opcode::EVSLW,
          1097 => Opcode::EVSLWI,
          1098 => Opcode::EVSPLATFI,
          1099 => Opcode::EVSPLATI,
          1100 => Opcode::EVSRWIS,
          1101 => Opcode::EVSRWIU,
          1102 => Opcode::EVSRWS,
          1103 => Opcode::EVSRWU,
          1104 => Opcode::EVSTDD,
          1105 => Opcode::EVSTDDX,
          1106 => Opcode::EVSTDH,
          1107 => Opcode::EVSTDHX,
          1108 => Opcode::EVSTDW,
          1109 => Opcode::EVSTDWX,
          1110 => Opcode::EVSTWHE,
          1111 => Opcode::EVSTWHEX,
          1112 => Opcode::EVSTWHO,
          1113 => Opcode::EVSTWHOX,
          1114 => Opcode::EVSTWWE,
          1115 => Opcode::EVSTWWEX,
          1116 => Opcode::EVSTWWO,
          1117 => Opcode::EVSTWWOX,
          1118 => Opcode::EVSUBFSMIAAW,
          1119 => Opcode::EVSUBFSSIAAW,
          1120 => Opcode::EVSUBFUMIAAW,
          1121 => Opcode::EVSUBFUSIAAW,
          1122 => Opcode::EVSUBFW,
          1123 => Opcode::EVSUBIFW,
          1124 => Opcode::EVXOR,
          1125 => Opcode::EXTSB,
          1126 => Opcode::EXTSB8,
          1127 => Opcode::EXTSB8_32_64,
          1128 => Opcode::EXTSB8_rec,
          1129 => Opcode::EXTSB_rec,
          1130 => Opcode::EXTSH,
          1131 => Opcode::EXTSH8,
          1132 => Opcode::EXTSH8_32_64,
          1133 => Opcode::EXTSH8_rec,
          1134 => Opcode::EXTSH_rec,
          1135 => Opcode::EXTSW,
          1136 => Opcode::EXTSWSLI,
          1137 => Opcode::EXTSWSLI_32_64,
          1138 => Opcode::EXTSWSLI_32_64_rec,
          1139 => Opcode::EXTSWSLI_rec,
          1140 => Opcode::EXTSW_32,
          1141 => Opcode::EXTSW_32_64,
          1142 => Opcode::EXTSW_32_64_rec,
          1143 => Opcode::EXTSW_rec,
          1144 => Opcode::EnforceIEIO,
          1145 => Opcode::FABSD,
          1146 => Opcode::FABSD_rec,
          1147 => Opcode::FABSS,
          1148 => Opcode::FABSS_rec,
          1149 => Opcode::FADD,
          1150 => Opcode::FADDS,
          1151 => Opcode::FADDS_rec,
          1152 => Opcode::FADD_rec,
          1153 => Opcode::FADDrtz,
          1154 => Opcode::FCFID,
          1155 => Opcode::FCFIDS,
          1156 => Opcode::FCFIDS_rec,
          1157 => Opcode::FCFIDU,
          1158 => Opcode::FCFIDUS,
          1159 => Opcode::FCFIDUS_rec,
          1160 => Opcode::FCFIDU_rec,
          1161 => Opcode::FCFID_rec,
          1162 => Opcode::FCMPOD,
          1163 => Opcode::FCMPOS,
          1164 => Opcode::FCMPUD,
          1165 => Opcode::FCMPUS,
          1166 => Opcode::FCPSGND,
          1167 => Opcode::FCPSGND_rec,
          1168 => Opcode::FCPSGNS,
          1169 => Opcode::FCPSGNS_rec,
          1170 => Opcode::FCTID,
          1171 => Opcode::FCTIDU,
          1172 => Opcode::FCTIDUZ,
          1173 => Opcode::FCTIDUZ_rec,
          1174 => Opcode::FCTIDU_rec,
          1175 => Opcode::FCTIDZ,
          1176 => Opcode::FCTIDZ_rec,
          1177 => Opcode::FCTID_rec,
          1178 => Opcode::FCTIW,
          1179 => Opcode::FCTIWU,
          1180 => Opcode::FCTIWUZ,
          1181 => Opcode::FCTIWUZ_rec,
          1182 => Opcode::FCTIWU_rec,
          1183 => Opcode::FCTIWZ,
          1184 => Opcode::FCTIWZ_rec,
          1185 => Opcode::FCTIW_rec,
          1186 => Opcode::FDIV,
          1187 => Opcode::FDIVS,
          1188 => Opcode::FDIVS_rec,
          1189 => Opcode::FDIV_rec,
          1190 => Opcode::FENCE,
          1191 => Opcode::FMADD,
          1192 => Opcode::FMADDS,
          1193 => Opcode::FMADDS_rec,
          1194 => Opcode::FMADD_rec,
          1195 => Opcode::FMR,
          1196 => Opcode::FMR_rec,
          1197 => Opcode::FMSUB,
          1198 => Opcode::FMSUBS,
          1199 => Opcode::FMSUBS_rec,
          1200 => Opcode::FMSUB_rec,
          1201 => Opcode::FMUL,
          1202 => Opcode::FMULS,
          1203 => Opcode::FMULS_rec,
          1204 => Opcode::FMUL_rec,
          1205 => Opcode::FNABSD,
          1206 => Opcode::FNABSD_rec,
          1207 => Opcode::FNABSS,
          1208 => Opcode::FNABSS_rec,
          1209 => Opcode::FNEGD,
          1210 => Opcode::FNEGD_rec,
          1211 => Opcode::FNEGS,
          1212 => Opcode::FNEGS_rec,
          1213 => Opcode::FNMADD,
          1214 => Opcode::FNMADDS,
          1215 => Opcode::FNMADDS_rec,
          1216 => Opcode::FNMADD_rec,
          1217 => Opcode::FNMSUB,
          1218 => Opcode::FNMSUBS,
          1219 => Opcode::FNMSUBS_rec,
          1220 => Opcode::FNMSUB_rec,
          1221 => Opcode::FRE,
          1222 => Opcode::FRES,
          1223 => Opcode::FRES_rec,
          1224 => Opcode::FRE_rec,
          1225 => Opcode::FRIMD,
          1226 => Opcode::FRIMD_rec,
          1227 => Opcode::FRIMS,
          1228 => Opcode::FRIMS_rec,
          1229 => Opcode::FRIND,
          1230 => Opcode::FRIND_rec,
          1231 => Opcode::FRINS,
          1232 => Opcode::FRINS_rec,
          1233 => Opcode::FRIPD,
          1234 => Opcode::FRIPD_rec,
          1235 => Opcode::FRIPS,
          1236 => Opcode::FRIPS_rec,
          1237 => Opcode::FRIZD,
          1238 => Opcode::FRIZD_rec,
          1239 => Opcode::FRIZS,
          1240 => Opcode::FRIZS_rec,
          1241 => Opcode::FRSP,
          1242 => Opcode::FRSP_rec,
          1243 => Opcode::FRSQRTE,
          1244 => Opcode::FRSQRTES,
          1245 => Opcode::FRSQRTES_rec,
          1246 => Opcode::FRSQRTE_rec,
          1247 => Opcode::FSELD,
          1248 => Opcode::FSELD_rec,
          1249 => Opcode::FSELS,
          1250 => Opcode::FSELS_rec,
          1251 => Opcode::FSQRT,
          1252 => Opcode::FSQRTS,
          1253 => Opcode::FSQRTS_rec,
          1254 => Opcode::FSQRT_rec,
          1255 => Opcode::FSUB,
          1256 => Opcode::FSUBS,
          1257 => Opcode::FSUBS_rec,
          1258 => Opcode::FSUB_rec,
          1259 => Opcode::FTDIV,
          1260 => Opcode::FTSQRT,
          1261 => Opcode::GETtlsADDR,
          1262 => Opcode::GETtlsADDR32,
          1263 => Opcode::GETtlsADDR32AIX,
          1264 => Opcode::GETtlsADDR64AIX,
          1265 => Opcode::GETtlsADDRPCREL,
          1266 => Opcode::GETtlsMOD32AIX,
          1267 => Opcode::GETtlsMOD64AIX,
          1268 => Opcode::GETtlsTpointer32AIX,
          1269 => Opcode::GETtlsldADDR,
          1270 => Opcode::GETtlsldADDR32,
          1271 => Opcode::GETtlsldADDRPCREL,
          1272 => Opcode::HASHCHK,
          1273 => Opcode::HASHCHK8,
          1274 => Opcode::HASHCHKP,
          1275 => Opcode::HASHCHKP8,
          1276 => Opcode::HASHST,
          1277 => Opcode::HASHST8,
          1278 => Opcode::HASHSTP,
          1279 => Opcode::HASHSTP8,
          1280 => Opcode::HRFID,
          1281 => Opcode::ICBI,
          1282 => Opcode::ICBIEP,
          1283 => Opcode::ICBLC,
          1284 => Opcode::ICBLQ,
          1285 => Opcode::ICBT,
          1286 => Opcode::ICBTLS,
          1287 => Opcode::ICCCI,
          1288 => Opcode::ISEL,
          1289 => Opcode::ISEL8,
          1290 => Opcode::ISYNC,
          1291 => Opcode::LA,
          1292 => Opcode::LA8,
          1293 => Opcode::LBARX,
          1294 => Opcode::LBARXL,
          1295 => Opcode::LBEPX,
          1296 => Opcode::LBZ,
          1297 => Opcode::LBZ8,
          1298 => Opcode::LBZCIX,
          1299 => Opcode::LBZU,
          1300 => Opcode::LBZU8,
          1301 => Opcode::LBZUX,
          1302 => Opcode::LBZUX8,
          1303 => Opcode::LBZX,
          1304 => Opcode::LBZX8,
          1305 => Opcode::LBZXTLS,
          1306 => Opcode::LBZXTLS_,
          1307 => Opcode::LBZXTLS_32,
          1308 => Opcode::LD,
          1309 => Opcode::LDARX,
          1310 => Opcode::LDARXL,
          1311 => Opcode::LDAT,
          1312 => Opcode::LDBRX,
          1313 => Opcode::LDCIX,
          1314 => Opcode::LDU,
          1315 => Opcode::LDUX,
          1316 => Opcode::LDX,
          1317 => Opcode::LDXTLS,
          1318 => Opcode::LDXTLS_,
          1319 => Opcode::LDgotTprelL,
          1320 => Opcode::LDgotTprelL32,
          1321 => Opcode::LDtoc,
          1322 => Opcode::LDtocBA,
          1323 => Opcode::LDtocCPT,
          1324 => Opcode::LDtocJTI,
          1325 => Opcode::LDtocL,
          1326 => Opcode::LFD,
          1327 => Opcode::LFDEPX,
          1328 => Opcode::LFDU,
          1329 => Opcode::LFDUX,
          1330 => Opcode::LFDX,
          1331 => Opcode::LFDXTLS,
          1332 => Opcode::LFDXTLS_,
          1333 => Opcode::LFIWAX,
          1334 => Opcode::LFIWZX,
          1335 => Opcode::LFS,
          1336 => Opcode::LFSU,
          1337 => Opcode::LFSUX,
          1338 => Opcode::LFSX,
          1339 => Opcode::LFSXTLS,
          1340 => Opcode::LFSXTLS_,
          1341 => Opcode::LHA,
          1342 => Opcode::LHA8,
          1343 => Opcode::LHARX,
          1344 => Opcode::LHARXL,
          1345 => Opcode::LHAU,
          1346 => Opcode::LHAU8,
          1347 => Opcode::LHAUX,
          1348 => Opcode::LHAUX8,
          1349 => Opcode::LHAX,
          1350 => Opcode::LHAX8,
          1351 => Opcode::LHAXTLS,
          1352 => Opcode::LHAXTLS_,
          1353 => Opcode::LHAXTLS_32,
          1354 => Opcode::LHBRX,
          1355 => Opcode::LHBRX8,
          1356 => Opcode::LHEPX,
          1357 => Opcode::LHZ,
          1358 => Opcode::LHZ8,
          1359 => Opcode::LHZCIX,
          1360 => Opcode::LHZU,
          1361 => Opcode::LHZU8,
          1362 => Opcode::LHZUX,
          1363 => Opcode::LHZUX8,
          1364 => Opcode::LHZX,
          1365 => Opcode::LHZX8,
          1366 => Opcode::LHZXTLS,
          1367 => Opcode::LHZXTLS_,
          1368 => Opcode::LHZXTLS_32,
          1369 => Opcode::LI,
          1370 => Opcode::LI8,
          1371 => Opcode::LIS,
          1372 => Opcode::LIS8,
          1373 => Opcode::LMW,
          1374 => Opcode::LQ,
          1375 => Opcode::LQARX,
          1376 => Opcode::LQARXL,
          1377 => Opcode::LQX_PSEUDO,
          1378 => Opcode::LSWI,
          1379 => Opcode::LVEBX,
          1380 => Opcode::LVEHX,
          1381 => Opcode::LVEWX,
          1382 => Opcode::LVSL,
          1383 => Opcode::LVSR,
          1384 => Opcode::LVX,
          1385 => Opcode::LVXL,
          1386 => Opcode::LWA,
          1387 => Opcode::LWARX,
          1388 => Opcode::LWARXL,
          1389 => Opcode::LWAT,
          1390 => Opcode::LWAUX,
          1391 => Opcode::LWAX,
          1392 => Opcode::LWAXTLS,
          1393 => Opcode::LWAXTLS_,
          1394 => Opcode::LWAXTLS_32,
          1395 => Opcode::LWAX_32,
          1396 => Opcode::LWA_32,
          1397 => Opcode::LWBRX,
          1398 => Opcode::LWBRX8,
          1399 => Opcode::LWEPX,
          1400 => Opcode::LWZ,
          1401 => Opcode::LWZ8,
          1402 => Opcode::LWZCIX,
          1403 => Opcode::LWZU,
          1404 => Opcode::LWZU8,
          1405 => Opcode::LWZUX,
          1406 => Opcode::LWZUX8,
          1407 => Opcode::LWZX,
          1408 => Opcode::LWZX8,
          1409 => Opcode::LWZXTLS,
          1410 => Opcode::LWZXTLS_,
          1411 => Opcode::LWZXTLS_32,
          1412 => Opcode::LWZtoc,
          1413 => Opcode::LWZtocL,
          1414 => Opcode::LXSD,
          1415 => Opcode::LXSDX,
          1416 => Opcode::LXSIBZX,
          1417 => Opcode::LXSIHZX,
          1418 => Opcode::LXSIWAX,
          1419 => Opcode::LXSIWZX,
          1420 => Opcode::LXSSP,
          1421 => Opcode::LXSSPX,
          1422 => Opcode::LXV,
          1423 => Opcode::LXVB16X,
          1424 => Opcode::LXVD2X,
          1425 => Opcode::LXVDSX,
          1426 => Opcode::LXVH8X,
          1427 => Opcode::LXVKQ,
          1428 => Opcode::LXVL,
          1429 => Opcode::LXVLL,
          1430 => Opcode::LXVP,
          1431 => Opcode::LXVPRL,
          1432 => Opcode::LXVPRLL,
          1433 => Opcode::LXVPX,
          1434 => Opcode::LXVRBX,
          1435 => Opcode::LXVRDX,
          1436 => Opcode::LXVRHX,
          1437 => Opcode::LXVRL,
          1438 => Opcode::LXVRLL,
          1439 => Opcode::LXVRWX,
          1440 => Opcode::LXVW4X,
          1441 => Opcode::LXVWSX,
          1442 => Opcode::LXVX,
          1443 => Opcode::MADDHD,
          1444 => Opcode::MADDHDU,
          1445 => Opcode::MADDLD,
          1446 => Opcode::MADDLD8,
          1447 => Opcode::MBAR,
          1448 => Opcode::MCRF,
          1449 => Opcode::MCRFS,
          1450 => Opcode::MCRXRX,
          1451 => Opcode::MFBHRBE,
          1452 => Opcode::MFCR,
          1453 => Opcode::MFCR8,
          1454 => Opcode::MFCTR,
          1455 => Opcode::MFCTR8,
          1456 => Opcode::MFDCR,
          1457 => Opcode::MFFS,
          1458 => Opcode::MFFSCDRN,
          1459 => Opcode::MFFSCDRNI,
          1460 => Opcode::MFFSCE,
          1461 => Opcode::MFFSCRN,
          1462 => Opcode::MFFSCRNI,
          1463 => Opcode::MFFSL,
          1464 => Opcode::MFFS_rec,
          1465 => Opcode::MFLR,
          1466 => Opcode::MFLR8,
          1467 => Opcode::MFMSR,
          1468 => Opcode::MFOCRF,
          1469 => Opcode::MFOCRF8,
          1470 => Opcode::MFPMR,
          1471 => Opcode::MFSPR,
          1472 => Opcode::MFSPR8,
          1473 => Opcode::MFSR,
          1474 => Opcode::MFSRIN,
          1475 => Opcode::MFTB,
          1476 => Opcode::MFTB8,
          1477 => Opcode::MFUDSCR,
          1478 => Opcode::MFVRD,
          1479 => Opcode::MFVRSAVE,
          1480 => Opcode::MFVRSAVEv,
          1481 => Opcode::MFVRWZ,
          1482 => Opcode::MFVSCR,
          1483 => Opcode::MFVSRD,
          1484 => Opcode::MFVSRLD,
          1485 => Opcode::MFVSRWZ,
          1486 => Opcode::MODSD,
          1487 => Opcode::MODSW,
          1488 => Opcode::MODUD,
          1489 => Opcode::MODUW,
          1490 => Opcode::MSGSYNC,
          1491 => Opcode::MSYNC,
          1492 => Opcode::MTCRF,
          1493 => Opcode::MTCRF8,
          1494 => Opcode::MTCTR,
          1495 => Opcode::MTCTR8,
          1496 => Opcode::MTCTR8loop,
          1497 => Opcode::MTCTRloop,
          1498 => Opcode::MTDCR,
          1499 => Opcode::MTFSB0,
          1500 => Opcode::MTFSB1,
          1501 => Opcode::MTFSF,
          1502 => Opcode::MTFSFI,
          1503 => Opcode::MTFSFI_rec,
          1504 => Opcode::MTFSFIb,
          1505 => Opcode::MTFSF_rec,
          1506 => Opcode::MTFSFb,
          1507 => Opcode::MTLR,
          1508 => Opcode::MTLR8,
          1509 => Opcode::MTMSR,
          1510 => Opcode::MTMSRD,
          1511 => Opcode::MTOCRF,
          1512 => Opcode::MTOCRF8,
          1513 => Opcode::MTPMR,
          1514 => Opcode::MTSPR,
          1515 => Opcode::MTSPR8,
          1516 => Opcode::MTSR,
          1517 => Opcode::MTSRIN,
          1518 => Opcode::MTUDSCR,
          1519 => Opcode::MTVRD,
          1520 => Opcode::MTVRSAVE,
          1521 => Opcode::MTVRSAVEv,
          1522 => Opcode::MTVRWA,
          1523 => Opcode::MTVRWZ,
          1524 => Opcode::MTVSCR,
          1525 => Opcode::MTVSRBM,
          1526 => Opcode::MTVSRBMI,
          1527 => Opcode::MTVSRD,
          1528 => Opcode::MTVSRDD,
          1529 => Opcode::MTVSRDM,
          1530 => Opcode::MTVSRHM,
          1531 => Opcode::MTVSRQM,
          1532 => Opcode::MTVSRWA,
          1533 => Opcode::MTVSRWM,
          1534 => Opcode::MTVSRWS,
          1535 => Opcode::MTVSRWZ,
          1536 => Opcode::MULHD,
          1537 => Opcode::MULHDU,
          1538 => Opcode::MULHDU_rec,
          1539 => Opcode::MULHD_rec,
          1540 => Opcode::MULHW,
          1541 => Opcode::MULHWU,
          1542 => Opcode::MULHWU_rec,
          1543 => Opcode::MULHW_rec,
          1544 => Opcode::MULLD,
          1545 => Opcode::MULLDO,
          1546 => Opcode::MULLDO_rec,
          1547 => Opcode::MULLD_rec,
          1548 => Opcode::MULLI,
          1549 => Opcode::MULLI8,
          1550 => Opcode::MULLW,
          1551 => Opcode::MULLWO,
          1552 => Opcode::MULLWO_rec,
          1553 => Opcode::MULLW_rec,
          1554 => Opcode::MoveGOTtoLR,
          1555 => Opcode::MovePCtoLR,
          1556 => Opcode::MovePCtoLR8,
          1557 => Opcode::NAND,
          1558 => Opcode::NAND8,
          1559 => Opcode::NAND8_rec,
          1560 => Opcode::NAND_rec,
          1561 => Opcode::NAP,
          1562 => Opcode::NEG,
          1563 => Opcode::NEG8,
          1564 => Opcode::NEG8O,
          1565 => Opcode::NEG8O_rec,
          1566 => Opcode::NEG8_rec,
          1567 => Opcode::NEGO,
          1568 => Opcode::NEGO_rec,
          1569 => Opcode::NEG_rec,
          1570 => Opcode::NOP,
          1571 => Opcode::NOP_GT_PWR6,
          1572 => Opcode::NOP_GT_PWR7,
          1573 => Opcode::NOR,
          1574 => Opcode::NOR8,
          1575 => Opcode::NOR8_rec,
          1576 => Opcode::NOR_rec,
          1577 => Opcode::OR,
          1578 => Opcode::OR8,
          1579 => Opcode::OR8_rec,
          1580 => Opcode::ORC,
          1581 => Opcode::ORC8,
          1582 => Opcode::ORC8_rec,
          1583 => Opcode::ORC_rec,
          1584 => Opcode::ORI,
          1585 => Opcode::ORI8,
          1586 => Opcode::ORIS,
          1587 => Opcode::ORIS8,
          1588 => Opcode::OR_rec,
          1589 => Opcode::PADDI,
          1590 => Opcode::PADDI8,
          1591 => Opcode::PADDI8pc,
          1592 => Opcode::PADDIdtprel,
          1593 => Opcode::PADDIpc,
          1594 => Opcode::PDEPD,
          1595 => Opcode::PEXTD,
          1596 => Opcode::PLA,
          1597 => Opcode::PLA8,
          1598 => Opcode::PLA8pc,
          1599 => Opcode::PLApc,
          1600 => Opcode::PLBZ,
          1601 => Opcode::PLBZ8,
          1602 => Opcode::PLBZ8nopc,
          1603 => Opcode::PLBZ8onlypc,
          1604 => Opcode::PLBZ8pc,
          1605 => Opcode::PLBZnopc,
          1606 => Opcode::PLBZonlypc,
          1607 => Opcode::PLBZpc,
          1608 => Opcode::PLD,
          1609 => Opcode::PLDnopc,
          1610 => Opcode::PLDonlypc,
          1611 => Opcode::PLDpc,
          1612 => Opcode::PLFD,
          1613 => Opcode::PLFDnopc,
          1614 => Opcode::PLFDonlypc,
          1615 => Opcode::PLFDpc,
          1616 => Opcode::PLFS,
          1617 => Opcode::PLFSnopc,
          1618 => Opcode::PLFSonlypc,
          1619 => Opcode::PLFSpc,
          1620 => Opcode::PLHA,
          1621 => Opcode::PLHA8,
          1622 => Opcode::PLHA8nopc,
          1623 => Opcode::PLHA8onlypc,
          1624 => Opcode::PLHA8pc,
          1625 => Opcode::PLHAnopc,
          1626 => Opcode::PLHAonlypc,
          1627 => Opcode::PLHApc,
          1628 => Opcode::PLHZ,
          1629 => Opcode::PLHZ8,
          1630 => Opcode::PLHZ8nopc,
          1631 => Opcode::PLHZ8onlypc,
          1632 => Opcode::PLHZ8pc,
          1633 => Opcode::PLHZnopc,
          1634 => Opcode::PLHZonlypc,
          1635 => Opcode::PLHZpc,
          1636 => Opcode::PLI,
          1637 => Opcode::PLI8,
          1638 => Opcode::PLWA,
          1639 => Opcode::PLWA8,
          1640 => Opcode::PLWA8nopc,
          1641 => Opcode::PLWA8onlypc,
          1642 => Opcode::PLWA8pc,
          1643 => Opcode::PLWAnopc,
          1644 => Opcode::PLWAonlypc,
          1645 => Opcode::PLWApc,
          1646 => Opcode::PLWZ,
          1647 => Opcode::PLWZ8,
          1648 => Opcode::PLWZ8nopc,
          1649 => Opcode::PLWZ8onlypc,
          1650 => Opcode::PLWZ8pc,
          1651 => Opcode::PLWZnopc,
          1652 => Opcode::PLWZonlypc,
          1653 => Opcode::PLWZpc,
          1654 => Opcode::PLXSD,
          1655 => Opcode::PLXSDnopc,
          1656 => Opcode::PLXSDonlypc,
          1657 => Opcode::PLXSDpc,
          1658 => Opcode::PLXSSP,
          1659 => Opcode::PLXSSPnopc,
          1660 => Opcode::PLXSSPonlypc,
          1661 => Opcode::PLXSSPpc,
          1662 => Opcode::PLXV,
          1663 => Opcode::PLXVP,
          1664 => Opcode::PLXVPnopc,
          1665 => Opcode::PLXVPonlypc,
          1666 => Opcode::PLXVPpc,
          1667 => Opcode::PLXVnopc,
          1668 => Opcode::PLXVonlypc,
          1669 => Opcode::PLXVpc,
          1670 => Opcode::PMXVBF16GER2,
          1671 => Opcode::PMXVBF16GER2NN,
          1672 => Opcode::PMXVBF16GER2NP,
          1673 => Opcode::PMXVBF16GER2PN,
          1674 => Opcode::PMXVBF16GER2PP,
          1675 => Opcode::PMXVBF16GER2W,
          1676 => Opcode::PMXVBF16GER2WNN,
          1677 => Opcode::PMXVBF16GER2WNP,
          1678 => Opcode::PMXVBF16GER2WPN,
          1679 => Opcode::PMXVBF16GER2WPP,
          1680 => Opcode::PMXVF16GER2,
          1681 => Opcode::PMXVF16GER2NN,
          1682 => Opcode::PMXVF16GER2NP,
          1683 => Opcode::PMXVF16GER2PN,
          1684 => Opcode::PMXVF16GER2PP,
          1685 => Opcode::PMXVF16GER2W,
          1686 => Opcode::PMXVF16GER2WNN,
          1687 => Opcode::PMXVF16GER2WNP,
          1688 => Opcode::PMXVF16GER2WPN,
          1689 => Opcode::PMXVF16GER2WPP,
          1690 => Opcode::PMXVF32GER,
          1691 => Opcode::PMXVF32GERNN,
          1692 => Opcode::PMXVF32GERNP,
          1693 => Opcode::PMXVF32GERPN,
          1694 => Opcode::PMXVF32GERPP,
          1695 => Opcode::PMXVF32GERW,
          1696 => Opcode::PMXVF32GERWNN,
          1697 => Opcode::PMXVF32GERWNP,
          1698 => Opcode::PMXVF32GERWPN,
          1699 => Opcode::PMXVF32GERWPP,
          1700 => Opcode::PMXVF64GER,
          1701 => Opcode::PMXVF64GERNN,
          1702 => Opcode::PMXVF64GERNP,
          1703 => Opcode::PMXVF64GERPN,
          1704 => Opcode::PMXVF64GERPP,
          1705 => Opcode::PMXVF64GERW,
          1706 => Opcode::PMXVF64GERWNN,
          1707 => Opcode::PMXVF64GERWNP,
          1708 => Opcode::PMXVF64GERWPN,
          1709 => Opcode::PMXVF64GERWPP,
          1710 => Opcode::PMXVI16GER2,
          1711 => Opcode::PMXVI16GER2PP,
          1712 => Opcode::PMXVI16GER2S,
          1713 => Opcode::PMXVI16GER2SPP,
          1714 => Opcode::PMXVI16GER2SW,
          1715 => Opcode::PMXVI16GER2SWPP,
          1716 => Opcode::PMXVI16GER2W,
          1717 => Opcode::PMXVI16GER2WPP,
          1718 => Opcode::PMXVI4GER8,
          1719 => Opcode::PMXVI4GER8PP,
          1720 => Opcode::PMXVI4GER8W,
          1721 => Opcode::PMXVI4GER8WPP,
          1722 => Opcode::PMXVI8GER4,
          1723 => Opcode::PMXVI8GER4PP,
          1724 => Opcode::PMXVI8GER4SPP,
          1725 => Opcode::PMXVI8GER4W,
          1726 => Opcode::PMXVI8GER4WPP,
          1727 => Opcode::PMXVI8GER4WSPP,
          1728 => Opcode::POPCNTB,
          1729 => Opcode::POPCNTB8,
          1730 => Opcode::POPCNTD,
          1731 => Opcode::POPCNTW,
          1732 => Opcode::PPC32GOT,
          1733 => Opcode::PPC32PICGOT,
          1734 => Opcode::PREPARE_PROBED_ALLOCA_32,
          1735 => Opcode::PREPARE_PROBED_ALLOCA_64,
          1736 => Opcode::PREPARE_PROBED_ALLOCA_NEGSIZE_SAME_REG_32,
          1737 => Opcode::PREPARE_PROBED_ALLOCA_NEGSIZE_SAME_REG_64,
          1738 => Opcode::PROBED_ALLOCA_32,
          1739 => Opcode::PROBED_ALLOCA_64,
          1740 => Opcode::PROBED_STACKALLOC_32,
          1741 => Opcode::PROBED_STACKALLOC_64,
          1742 => Opcode::PSTB,
          1743 => Opcode::PSTB8,
          1744 => Opcode::PSTB8nopc,
          1745 => Opcode::PSTB8onlypc,
          1746 => Opcode::PSTB8pc,
          1747 => Opcode::PSTBnopc,
          1748 => Opcode::PSTBonlypc,
          1749 => Opcode::PSTBpc,
          1750 => Opcode::PSTD,
          1751 => Opcode::PSTDnopc,
          1752 => Opcode::PSTDonlypc,
          1753 => Opcode::PSTDpc,
          1754 => Opcode::PSTFD,
          1755 => Opcode::PSTFDnopc,
          1756 => Opcode::PSTFDonlypc,
          1757 => Opcode::PSTFDpc,
          1758 => Opcode::PSTFS,
          1759 => Opcode::PSTFSnopc,
          1760 => Opcode::PSTFSonlypc,
          1761 => Opcode::PSTFSpc,
          1762 => Opcode::PSTH,
          1763 => Opcode::PSTH8,
          1764 => Opcode::PSTH8nopc,
          1765 => Opcode::PSTH8onlypc,
          1766 => Opcode::PSTH8pc,
          1767 => Opcode::PSTHnopc,
          1768 => Opcode::PSTHonlypc,
          1769 => Opcode::PSTHpc,
          1770 => Opcode::PSTW,
          1771 => Opcode::PSTW8,
          1772 => Opcode::PSTW8nopc,
          1773 => Opcode::PSTW8onlypc,
          1774 => Opcode::PSTW8pc,
          1775 => Opcode::PSTWnopc,
          1776 => Opcode::PSTWonlypc,
          1777 => Opcode::PSTWpc,
          1778 => Opcode::PSTXSD,
          1779 => Opcode::PSTXSDnopc,
          1780 => Opcode::PSTXSDonlypc,
          1781 => Opcode::PSTXSDpc,
          1782 => Opcode::PSTXSSP,
          1783 => Opcode::PSTXSSPnopc,
          1784 => Opcode::PSTXSSPonlypc,
          1785 => Opcode::PSTXSSPpc,
          1786 => Opcode::PSTXV,
          1787 => Opcode::PSTXVP,
          1788 => Opcode::PSTXVPnopc,
          1789 => Opcode::PSTXVPonlypc,
          1790 => Opcode::PSTXVPpc,
          1791 => Opcode::PSTXVnopc,
          1792 => Opcode::PSTXVonlypc,
          1793 => Opcode::PSTXVpc,
          1794 => Opcode::PseudoEIEIO,
          1795 => Opcode::RESTORE_ACC,
          1796 => Opcode::RESTORE_CR,
          1797 => Opcode::RESTORE_CRBIT,
          1798 => Opcode::RESTORE_QUADWORD,
          1799 => Opcode::RESTORE_UACC,
          1800 => Opcode::RESTORE_WACC,
          1801 => Opcode::RFCI,
          1802 => Opcode::RFDI,
          1803 => Opcode::RFEBB,
          1804 => Opcode::RFI,
          1805 => Opcode::RFID,
          1806 => Opcode::RFMCI,
          1807 => Opcode::RLDCL,
          1808 => Opcode::RLDCL_rec,
          1809 => Opcode::RLDCR,
          1810 => Opcode::RLDCR_rec,
          1811 => Opcode::RLDIC,
          1812 => Opcode::RLDICL,
          1813 => Opcode::RLDICL_32,
          1814 => Opcode::RLDICL_32_64,
          1815 => Opcode::RLDICL_32_rec,
          1816 => Opcode::RLDICL_rec,
          1817 => Opcode::RLDICR,
          1818 => Opcode::RLDICR_32,
          1819 => Opcode::RLDICR_rec,
          1820 => Opcode::RLDIC_rec,
          1821 => Opcode::RLDIMI,
          1822 => Opcode::RLDIMI_rec,
          1823 => Opcode::RLWIMI,
          1824 => Opcode::RLWIMI8,
          1825 => Opcode::RLWIMI8_rec,
          1826 => Opcode::RLWIMI_rec,
          1827 => Opcode::RLWINM,
          1828 => Opcode::RLWINM8,
          1829 => Opcode::RLWINM8_rec,
          1830 => Opcode::RLWINM_rec,
          1831 => Opcode::RLWNM,
          1832 => Opcode::RLWNM8,
          1833 => Opcode::RLWNM8_rec,
          1834 => Opcode::RLWNM_rec,
          1835 => Opcode::ReadTB,
          1836 => Opcode::SC,
          1837 => Opcode::SCV,
          1838 => Opcode::SELECT_CC_F16,
          1839 => Opcode::SELECT_CC_F4,
          1840 => Opcode::SELECT_CC_F8,
          1841 => Opcode::SELECT_CC_I4,
          1842 => Opcode::SELECT_CC_I8,
          1843 => Opcode::SELECT_CC_SPE,
          1844 => Opcode::SELECT_CC_SPE4,
          1845 => Opcode::SELECT_CC_VRRC,
          1846 => Opcode::SELECT_CC_VSFRC,
          1847 => Opcode::SELECT_CC_VSRC,
          1848 => Opcode::SELECT_CC_VSSRC,
          1849 => Opcode::SELECT_F16,
          1850 => Opcode::SELECT_F4,
          1851 => Opcode::SELECT_F8,
          1852 => Opcode::SELECT_I4,
          1853 => Opcode::SELECT_I8,
          1854 => Opcode::SELECT_SPE,
          1855 => Opcode::SELECT_SPE4,
          1856 => Opcode::SELECT_VRRC,
          1857 => Opcode::SELECT_VSFRC,
          1858 => Opcode::SELECT_VSRC,
          1859 => Opcode::SELECT_VSSRC,
          1860 => Opcode::SETB,
          1861 => Opcode::SETB8,
          1862 => Opcode::SETBC,
          1863 => Opcode::SETBC8,
          1864 => Opcode::SETBCR,
          1865 => Opcode::SETBCR8,
          1866 => Opcode::SETFLM,
          1867 => Opcode::SETNBC,
          1868 => Opcode::SETNBC8,
          1869 => Opcode::SETNBCR,
          1870 => Opcode::SETNBCR8,
          1871 => Opcode::SETRND,
          1872 => Opcode::SETRNDi,
          1873 => Opcode::SLBFEE_rec,
          1874 => Opcode::SLBIA,
          1875 => Opcode::SLBIE,
          1876 => Opcode::SLBIEG,
          1877 => Opcode::SLBMFEE,
          1878 => Opcode::SLBMFEV,
          1879 => Opcode::SLBMTE,
          1880 => Opcode::SLBSYNC,
          1881 => Opcode::SLD,
          1882 => Opcode::SLD_rec,
          1883 => Opcode::SLW,
          1884 => Opcode::SLW8,
          1885 => Opcode::SLW8_rec,
          1886 => Opcode::SLW_rec,
          1887 => Opcode::SPELWZ,
          1888 => Opcode::SPELWZX,
          1889 => Opcode::SPESTW,
          1890 => Opcode::SPESTWX,
          1891 => Opcode::SPILL_ACC,
          1892 => Opcode::SPILL_CR,
          1893 => Opcode::SPILL_CRBIT,
          1894 => Opcode::SPILL_QUADWORD,
          1895 => Opcode::SPILL_UACC,
          1896 => Opcode::SPILL_WACC,
          1897 => Opcode::SPLIT_QUADWORD,
          1898 => Opcode::SRAD,
          1899 => Opcode::SRADI,
          1900 => Opcode::SRADI_32,
          1901 => Opcode::SRADI_rec,
          1902 => Opcode::SRAD_rec,
          1903 => Opcode::SRAW,
          1904 => Opcode::SRAWI,
          1905 => Opcode::SRAWI_rec,
          1906 => Opcode::SRAW_rec,
          1907 => Opcode::SRD,
          1908 => Opcode::SRD_rec,
          1909 => Opcode::SRW,
          1910 => Opcode::SRW8,
          1911 => Opcode::SRW8_rec,
          1912 => Opcode::SRW_rec,
          1913 => Opcode::STB,
          1914 => Opcode::STB8,
          1915 => Opcode::STBCIX,
          1916 => Opcode::STBCX,
          1917 => Opcode::STBEPX,
          1918 => Opcode::STBU,
          1919 => Opcode::STBU8,
          1920 => Opcode::STBUX,
          1921 => Opcode::STBUX8,
          1922 => Opcode::STBX,
          1923 => Opcode::STBX8,
          1924 => Opcode::STBXTLS,
          1925 => Opcode::STBXTLS_,
          1926 => Opcode::STBXTLS_32,
          1927 => Opcode::STD,
          1928 => Opcode::STDAT,
          1929 => Opcode::STDBRX,
          1930 => Opcode::STDCIX,
          1931 => Opcode::STDCX,
          1932 => Opcode::STDU,
          1933 => Opcode::STDUX,
          1934 => Opcode::STDX,
          1935 => Opcode::STDXTLS,
          1936 => Opcode::STDXTLS_,
          1937 => Opcode::STFD,
          1938 => Opcode::STFDEPX,
          1939 => Opcode::STFDU,
          1940 => Opcode::STFDUX,
          1941 => Opcode::STFDX,
          1942 => Opcode::STFDXTLS,
          1943 => Opcode::STFDXTLS_,
          1944 => Opcode::STFIWX,
          1945 => Opcode::STFS,
          1946 => Opcode::STFSU,
          1947 => Opcode::STFSUX,
          1948 => Opcode::STFSX,
          1949 => Opcode::STFSXTLS,
          1950 => Opcode::STFSXTLS_,
          1951 => Opcode::STH,
          1952 => Opcode::STH8,
          1953 => Opcode::STHBRX,
          1954 => Opcode::STHCIX,
          1955 => Opcode::STHCX,
          1956 => Opcode::STHEPX,
          1957 => Opcode::STHU,
          1958 => Opcode::STHU8,
          1959 => Opcode::STHUX,
          1960 => Opcode::STHUX8,
          1961 => Opcode::STHX,
          1962 => Opcode::STHX8,
          1963 => Opcode::STHXTLS,
          1964 => Opcode::STHXTLS_,
          1965 => Opcode::STHXTLS_32,
          1966 => Opcode::STMW,
          1967 => Opcode::STOP,
          1968 => Opcode::STQ,
          1969 => Opcode::STQCX,
          1970 => Opcode::STQX_PSEUDO,
          1971 => Opcode::STSWI,
          1972 => Opcode::STVEBX,
          1973 => Opcode::STVEHX,
          1974 => Opcode::STVEWX,
          1975 => Opcode::STVX,
          1976 => Opcode::STVXL,
          1977 => Opcode::STW,
          1978 => Opcode::STW8,
          1979 => Opcode::STWAT,
          1980 => Opcode::STWBRX,
          1981 => Opcode::STWCIX,
          1982 => Opcode::STWCX,
          1983 => Opcode::STWEPX,
          1984 => Opcode::STWU,
          1985 => Opcode::STWU8,
          1986 => Opcode::STWUX,
          1987 => Opcode::STWUX8,
          1988 => Opcode::STWX,
          1989 => Opcode::STWX8,
          1990 => Opcode::STWXTLS,
          1991 => Opcode::STWXTLS_,
          1992 => Opcode::STWXTLS_32,
          1993 => Opcode::STXSD,
          1994 => Opcode::STXSDX,
          1995 => Opcode::STXSIBX,
          1996 => Opcode::STXSIBXv,
          1997 => Opcode::STXSIHX,
          1998 => Opcode::STXSIHXv,
          1999 => Opcode::STXSIWX,
          2000 => Opcode::STXSSP,
          2001 => Opcode::STXSSPX,
          2002 => Opcode::STXV,
          2003 => Opcode::STXVB16X,
          2004 => Opcode::STXVD2X,
          2005 => Opcode::STXVH8X,
          2006 => Opcode::STXVL,
          2007 => Opcode::STXVLL,
          2008 => Opcode::STXVP,
          2009 => Opcode::STXVPRL,
          2010 => Opcode::STXVPRLL,
          2011 => Opcode::STXVPX,
          2012 => Opcode::STXVRBX,
          2013 => Opcode::STXVRDX,
          2014 => Opcode::STXVRHX,
          2015 => Opcode::STXVRL,
          2016 => Opcode::STXVRLL,
          2017 => Opcode::STXVRWX,
          2018 => Opcode::STXVW4X,
          2019 => Opcode::STXVX,
          2020 => Opcode::SUBF,
          2021 => Opcode::SUBF8,
          2022 => Opcode::SUBF8O,
          2023 => Opcode::SUBF8O_rec,
          2024 => Opcode::SUBF8_rec,
          2025 => Opcode::SUBFC,
          2026 => Opcode::SUBFC8,
          2027 => Opcode::SUBFC8O,
          2028 => Opcode::SUBFC8O_rec,
          2029 => Opcode::SUBFC8_rec,
          2030 => Opcode::SUBFCO,
          2031 => Opcode::SUBFCO_rec,
          2032 => Opcode::SUBFC_rec,
          2033 => Opcode::SUBFE,
          2034 => Opcode::SUBFE8,
          2035 => Opcode::SUBFE8O,
          2036 => Opcode::SUBFE8O_rec,
          2037 => Opcode::SUBFE8_rec,
          2038 => Opcode::SUBFEO,
          2039 => Opcode::SUBFEO_rec,
          2040 => Opcode::SUBFE_rec,
          2041 => Opcode::SUBFIC,
          2042 => Opcode::SUBFIC8,
          2043 => Opcode::SUBFME,
          2044 => Opcode::SUBFME8,
          2045 => Opcode::SUBFME8O,
          2046 => Opcode::SUBFME8O_rec,
          2047 => Opcode::SUBFME8_rec,
          2048 => Opcode::SUBFMEO,
          2049 => Opcode::SUBFMEO_rec,
          2050 => Opcode::SUBFME_rec,
          2051 => Opcode::SUBFO,
          2052 => Opcode::SUBFO_rec,
          2053 => Opcode::SUBFUS,
          2054 => Opcode::SUBFUS_rec,
          2055 => Opcode::SUBFZE,
          2056 => Opcode::SUBFZE8,
          2057 => Opcode::SUBFZE8O,
          2058 => Opcode::SUBFZE8O_rec,
          2059 => Opcode::SUBFZE8_rec,
          2060 => Opcode::SUBFZEO,
          2061 => Opcode::SUBFZEO_rec,
          2062 => Opcode::SUBFZE_rec,
          2063 => Opcode::SUBF_rec,
          2064 => Opcode::SYNC,
          2065 => Opcode::SYNCP10,
          2066 => Opcode::TABORT,
          2067 => Opcode::TABORTDC,
          2068 => Opcode::TABORTDCI,
          2069 => Opcode::TABORTWC,
          2070 => Opcode::TABORTWCI,
          2071 => Opcode::TAILB,
          2072 => Opcode::TAILB8,
          2073 => Opcode::TAILBA,
          2074 => Opcode::TAILBA8,
          2075 => Opcode::TAILBCTR,
          2076 => Opcode::TAILBCTR8,
          2077 => Opcode::TBEGIN,
          2078 => Opcode::TBEGIN_RET,
          2079 => Opcode::TCHECK,
          2080 => Opcode::TCHECK_RET,
          2081 => Opcode::TCRETURNai,
          2082 => Opcode::TCRETURNai8,
          2083 => Opcode::TCRETURNdi,
          2084 => Opcode::TCRETURNdi8,
          2085 => Opcode::TCRETURNri,
          2086 => Opcode::TCRETURNri8,
          2087 => Opcode::TD,
          2088 => Opcode::TDI,
          2089 => Opcode::TEND,
          2090 => Opcode::TLBIA,
          2091 => Opcode::TLBIE,
          2092 => Opcode::TLBIEL,
          2093 => Opcode::TLBILX,
          2094 => Opcode::TLBIVAX,
          2095 => Opcode::TLBLD,
          2096 => Opcode::TLBLI,
          2097 => Opcode::TLBRE,
          2098 => Opcode::TLBRE2,
          2099 => Opcode::TLBSX,
          2100 => Opcode::TLBSX2,
          2101 => Opcode::TLBSX2D,
          2102 => Opcode::TLBSYNC,
          2103 => Opcode::TLBWE,
          2104 => Opcode::TLBWE2,
          2105 => Opcode::TLSGDAIX,
          2106 => Opcode::TLSGDAIX8,
          2107 => Opcode::TLSLDAIX,
          2108 => Opcode::TLSLDAIX8,
          2109 => Opcode::TRAP,
          2110 => Opcode::TRECHKPT,
          2111 => Opcode::TRECLAIM,
          2112 => Opcode::TSR,
          2113 => Opcode::TW,
          2114 => Opcode::TWI,
          2115 => Opcode::UNENCODED_NOP,
          2116 => Opcode::UpdateGBR,
          2117 => Opcode::VABSDUB,
          2118 => Opcode::VABSDUH,
          2119 => Opcode::VABSDUW,
          2120 => Opcode::VADDCUQ,
          2121 => Opcode::VADDCUW,
          2122 => Opcode::VADDECUQ,
          2123 => Opcode::VADDEUQM,
          2124 => Opcode::VADDFP,
          2125 => Opcode::VADDSBS,
          2126 => Opcode::VADDSHS,
          2127 => Opcode::VADDSWS,
          2128 => Opcode::VADDUBM,
          2129 => Opcode::VADDUBS,
          2130 => Opcode::VADDUDM,
          2131 => Opcode::VADDUHM,
          2132 => Opcode::VADDUHS,
          2133 => Opcode::VADDUQM,
          2134 => Opcode::VADDUWM,
          2135 => Opcode::VADDUWS,
          2136 => Opcode::VAND,
          2137 => Opcode::VANDC,
          2138 => Opcode::VAVGSB,
          2139 => Opcode::VAVGSH,
          2140 => Opcode::VAVGSW,
          2141 => Opcode::VAVGUB,
          2142 => Opcode::VAVGUH,
          2143 => Opcode::VAVGUW,
          2144 => Opcode::VBPERMD,
          2145 => Opcode::VBPERMQ,
          2146 => Opcode::VCFSX,
          2147 => Opcode::VCFSX_0,
          2148 => Opcode::VCFUGED,
          2149 => Opcode::VCFUX,
          2150 => Opcode::VCFUX_0,
          2151 => Opcode::VCIPHER,
          2152 => Opcode::VCIPHERLAST,
          2153 => Opcode::VCLRLB,
          2154 => Opcode::VCLRRB,
          2155 => Opcode::VCLZB,
          2156 => Opcode::VCLZD,
          2157 => Opcode::VCLZDM,
          2158 => Opcode::VCLZH,
          2159 => Opcode::VCLZLSBB,
          2160 => Opcode::VCLZW,
          2161 => Opcode::VCMPBFP,
          2162 => Opcode::VCMPBFP_rec,
          2163 => Opcode::VCMPEQFP,
          2164 => Opcode::VCMPEQFP_rec,
          2165 => Opcode::VCMPEQUB,
          2166 => Opcode::VCMPEQUB_rec,
          2167 => Opcode::VCMPEQUD,
          2168 => Opcode::VCMPEQUD_rec,
          2169 => Opcode::VCMPEQUH,
          2170 => Opcode::VCMPEQUH_rec,
          2171 => Opcode::VCMPEQUQ,
          2172 => Opcode::VCMPEQUQ_rec,
          2173 => Opcode::VCMPEQUW,
          2174 => Opcode::VCMPEQUW_rec,
          2175 => Opcode::VCMPGEFP,
          2176 => Opcode::VCMPGEFP_rec,
          2177 => Opcode::VCMPGTFP,
          2178 => Opcode::VCMPGTFP_rec,
          2179 => Opcode::VCMPGTSB,
          2180 => Opcode::VCMPGTSB_rec,
          2181 => Opcode::VCMPGTSD,
          2182 => Opcode::VCMPGTSD_rec,
          2183 => Opcode::VCMPGTSH,
          2184 => Opcode::VCMPGTSH_rec,
          2185 => Opcode::VCMPGTSQ,
          2186 => Opcode::VCMPGTSQ_rec,
          2187 => Opcode::VCMPGTSW,
          2188 => Opcode::VCMPGTSW_rec,
          2189 => Opcode::VCMPGTUB,
          2190 => Opcode::VCMPGTUB_rec,
          2191 => Opcode::VCMPGTUD,
          2192 => Opcode::VCMPGTUD_rec,
          2193 => Opcode::VCMPGTUH,
          2194 => Opcode::VCMPGTUH_rec,
          2195 => Opcode::VCMPGTUQ,
          2196 => Opcode::VCMPGTUQ_rec,
          2197 => Opcode::VCMPGTUW,
          2198 => Opcode::VCMPGTUW_rec,
          2199 => Opcode::VCMPNEB,
          2200 => Opcode::VCMPNEB_rec,
          2201 => Opcode::VCMPNEH,
          2202 => Opcode::VCMPNEH_rec,
          2203 => Opcode::VCMPNEW,
          2204 => Opcode::VCMPNEW_rec,
          2205 => Opcode::VCMPNEZB,
          2206 => Opcode::VCMPNEZB_rec,
          2207 => Opcode::VCMPNEZH,
          2208 => Opcode::VCMPNEZH_rec,
          2209 => Opcode::VCMPNEZW,
          2210 => Opcode::VCMPNEZW_rec,
          2211 => Opcode::VCMPSQ,
          2212 => Opcode::VCMPUQ,
          2213 => Opcode::VCNTMBB,
          2214 => Opcode::VCNTMBD,
          2215 => Opcode::VCNTMBH,
          2216 => Opcode::VCNTMBW,
          2217 => Opcode::VCTSXS,
          2218 => Opcode::VCTSXS_0,
          2219 => Opcode::VCTUXS,
          2220 => Opcode::VCTUXS_0,
          2221 => Opcode::VCTZB,
          2222 => Opcode::VCTZD,
          2223 => Opcode::VCTZDM,
          2224 => Opcode::VCTZH,
          2225 => Opcode::VCTZLSBB,
          2226 => Opcode::VCTZW,
          2227 => Opcode::VDIVESD,
          2228 => Opcode::VDIVESQ,
          2229 => Opcode::VDIVESW,
          2230 => Opcode::VDIVEUD,
          2231 => Opcode::VDIVEUQ,
          2232 => Opcode::VDIVEUW,
          2233 => Opcode::VDIVSD,
          2234 => Opcode::VDIVSQ,
          2235 => Opcode::VDIVSW,
          2236 => Opcode::VDIVUD,
          2237 => Opcode::VDIVUQ,
          2238 => Opcode::VDIVUW,
          2239 => Opcode::VEQV,
          2240 => Opcode::VEXPANDBM,
          2241 => Opcode::VEXPANDDM,
          2242 => Opcode::VEXPANDHM,
          2243 => Opcode::VEXPANDQM,
          2244 => Opcode::VEXPANDWM,
          2245 => Opcode::VEXPTEFP,
          2246 => Opcode::VEXTDDVLX,
          2247 => Opcode::VEXTDDVRX,
          2248 => Opcode::VEXTDUBVLX,
          2249 => Opcode::VEXTDUBVRX,
          2250 => Opcode::VEXTDUHVLX,
          2251 => Opcode::VEXTDUHVRX,
          2252 => Opcode::VEXTDUWVLX,
          2253 => Opcode::VEXTDUWVRX,
          2254 => Opcode::VEXTRACTBM,
          2255 => Opcode::VEXTRACTD,
          2256 => Opcode::VEXTRACTDM,
          2257 => Opcode::VEXTRACTHM,
          2258 => Opcode::VEXTRACTQM,
          2259 => Opcode::VEXTRACTUB,
          2260 => Opcode::VEXTRACTUH,
          2261 => Opcode::VEXTRACTUW,
          2262 => Opcode::VEXTRACTWM,
          2263 => Opcode::VEXTSB2D,
          2264 => Opcode::VEXTSB2Ds,
          2265 => Opcode::VEXTSB2W,
          2266 => Opcode::VEXTSB2Ws,
          2267 => Opcode::VEXTSD2Q,
          2268 => Opcode::VEXTSH2D,
          2269 => Opcode::VEXTSH2Ds,
          2270 => Opcode::VEXTSH2W,
          2271 => Opcode::VEXTSH2Ws,
          2272 => Opcode::VEXTSW2D,
          2273 => Opcode::VEXTSW2Ds,
          2274 => Opcode::VEXTUBLX,
          2275 => Opcode::VEXTUBRX,
          2276 => Opcode::VEXTUHLX,
          2277 => Opcode::VEXTUHRX,
          2278 => Opcode::VEXTUWLX,
          2279 => Opcode::VEXTUWRX,
          2280 => Opcode::VGBBD,
          2281 => Opcode::VGNB,
          2282 => Opcode::VINSBLX,
          2283 => Opcode::VINSBRX,
          2284 => Opcode::VINSBVLX,
          2285 => Opcode::VINSBVRX,
          2286 => Opcode::VINSD,
          2287 => Opcode::VINSDLX,
          2288 => Opcode::VINSDRX,
          2289 => Opcode::VINSERTB,
          2290 => Opcode::VINSERTD,
          2291 => Opcode::VINSERTH,
          2292 => Opcode::VINSERTW,
          2293 => Opcode::VINSHLX,
          2294 => Opcode::VINSHRX,
          2295 => Opcode::VINSHVLX,
          2296 => Opcode::VINSHVRX,
          2297 => Opcode::VINSW,
          2298 => Opcode::VINSWLX,
          2299 => Opcode::VINSWRX,
          2300 => Opcode::VINSWVLX,
          2301 => Opcode::VINSWVRX,
          2302 => Opcode::VLOGEFP,
          2303 => Opcode::VMADDFP,
          2304 => Opcode::VMAXFP,
          2305 => Opcode::VMAXSB,
          2306 => Opcode::VMAXSD,
          2307 => Opcode::VMAXSH,
          2308 => Opcode::VMAXSW,
          2309 => Opcode::VMAXUB,
          2310 => Opcode::VMAXUD,
          2311 => Opcode::VMAXUH,
          2312 => Opcode::VMAXUW,
          2313 => Opcode::VMHADDSHS,
          2314 => Opcode::VMHRADDSHS,
          2315 => Opcode::VMINFP,
          2316 => Opcode::VMINSB,
          2317 => Opcode::VMINSD,
          2318 => Opcode::VMINSH,
          2319 => Opcode::VMINSW,
          2320 => Opcode::VMINUB,
          2321 => Opcode::VMINUD,
          2322 => Opcode::VMINUH,
          2323 => Opcode::VMINUW,
          2324 => Opcode::VMLADDUHM,
          2325 => Opcode::VMODSD,
          2326 => Opcode::VMODSQ,
          2327 => Opcode::VMODSW,
          2328 => Opcode::VMODUD,
          2329 => Opcode::VMODUQ,
          2330 => Opcode::VMODUW,
          2331 => Opcode::VMRGEW,
          2332 => Opcode::VMRGHB,
          2333 => Opcode::VMRGHH,
          2334 => Opcode::VMRGHW,
          2335 => Opcode::VMRGLB,
          2336 => Opcode::VMRGLH,
          2337 => Opcode::VMRGLW,
          2338 => Opcode::VMRGOW,
          2339 => Opcode::VMSUMCUD,
          2340 => Opcode::VMSUMMBM,
          2341 => Opcode::VMSUMSHM,
          2342 => Opcode::VMSUMSHS,
          2343 => Opcode::VMSUMUBM,
          2344 => Opcode::VMSUMUDM,
          2345 => Opcode::VMSUMUHM,
          2346 => Opcode::VMSUMUHS,
          2347 => Opcode::VMUL10CUQ,
          2348 => Opcode::VMUL10ECUQ,
          2349 => Opcode::VMUL10EUQ,
          2350 => Opcode::VMUL10UQ,
          2351 => Opcode::VMULESB,
          2352 => Opcode::VMULESD,
          2353 => Opcode::VMULESH,
          2354 => Opcode::VMULESW,
          2355 => Opcode::VMULEUB,
          2356 => Opcode::VMULEUD,
          2357 => Opcode::VMULEUH,
          2358 => Opcode::VMULEUW,
          2359 => Opcode::VMULHSD,
          2360 => Opcode::VMULHSW,
          2361 => Opcode::VMULHUD,
          2362 => Opcode::VMULHUW,
          2363 => Opcode::VMULLD,
          2364 => Opcode::VMULOSB,
          2365 => Opcode::VMULOSD,
          2366 => Opcode::VMULOSH,
          2367 => Opcode::VMULOSW,
          2368 => Opcode::VMULOUB,
          2369 => Opcode::VMULOUD,
          2370 => Opcode::VMULOUH,
          2371 => Opcode::VMULOUW,
          2372 => Opcode::VMULUWM,
          2373 => Opcode::VNAND,
          2374 => Opcode::VNCIPHER,
          2375 => Opcode::VNCIPHERLAST,
          2376 => Opcode::VNEGD,
          2377 => Opcode::VNEGW,
          2378 => Opcode::VNMSUBFP,
          2379 => Opcode::VNOR,
          2380 => Opcode::VOR,
          2381 => Opcode::VORC,
          2382 => Opcode::VPDEPD,
          2383 => Opcode::VPERM,
          2384 => Opcode::VPERMR,
          2385 => Opcode::VPERMXOR,
          2386 => Opcode::VPEXTD,
          2387 => Opcode::VPKPX,
          2388 => Opcode::VPKSDSS,
          2389 => Opcode::VPKSDUS,
          2390 => Opcode::VPKSHSS,
          2391 => Opcode::VPKSHUS,
          2392 => Opcode::VPKSWSS,
          2393 => Opcode::VPKSWUS,
          2394 => Opcode::VPKUDUM,
          2395 => Opcode::VPKUDUS,
          2396 => Opcode::VPKUHUM,
          2397 => Opcode::VPKUHUS,
          2398 => Opcode::VPKUWUM,
          2399 => Opcode::VPKUWUS,
          2400 => Opcode::VPMSUMB,
          2401 => Opcode::VPMSUMD,
          2402 => Opcode::VPMSUMH,
          2403 => Opcode::VPMSUMW,
          2404 => Opcode::VPOPCNTB,
          2405 => Opcode::VPOPCNTD,
          2406 => Opcode::VPOPCNTH,
          2407 => Opcode::VPOPCNTW,
          2408 => Opcode::VPRTYBD,
          2409 => Opcode::VPRTYBQ,
          2410 => Opcode::VPRTYBW,
          2411 => Opcode::VREFP,
          2412 => Opcode::VRFIM,
          2413 => Opcode::VRFIN,
          2414 => Opcode::VRFIP,
          2415 => Opcode::VRFIZ,
          2416 => Opcode::VRLB,
          2417 => Opcode::VRLD,
          2418 => Opcode::VRLDMI,
          2419 => Opcode::VRLDNM,
          2420 => Opcode::VRLH,
          2421 => Opcode::VRLQ,
          2422 => Opcode::VRLQMI,
          2423 => Opcode::VRLQNM,
          2424 => Opcode::VRLW,
          2425 => Opcode::VRLWMI,
          2426 => Opcode::VRLWNM,
          2427 => Opcode::VRSQRTEFP,
          2428 => Opcode::VSBOX,
          2429 => Opcode::VSEL,
          2430 => Opcode::VSHASIGMAD,
          2431 => Opcode::VSHASIGMAW,
          2432 => Opcode::VSL,
          2433 => Opcode::VSLB,
          2434 => Opcode::VSLD,
          2435 => Opcode::VSLDBI,
          2436 => Opcode::VSLDOI,
          2437 => Opcode::VSLH,
          2438 => Opcode::VSLO,
          2439 => Opcode::VSLQ,
          2440 => Opcode::VSLV,
          2441 => Opcode::VSLW,
          2442 => Opcode::VSPLTB,
          2443 => Opcode::VSPLTBs,
          2444 => Opcode::VSPLTH,
          2445 => Opcode::VSPLTHs,
          2446 => Opcode::VSPLTISB,
          2447 => Opcode::VSPLTISH,
          2448 => Opcode::VSPLTISW,
          2449 => Opcode::VSPLTW,
          2450 => Opcode::VSR,
          2451 => Opcode::VSRAB,
          2452 => Opcode::VSRAD,
          2453 => Opcode::VSRAH,
          2454 => Opcode::VSRAQ,
          2455 => Opcode::VSRAW,
          2456 => Opcode::VSRB,
          2457 => Opcode::VSRD,
          2458 => Opcode::VSRDBI,
          2459 => Opcode::VSRH,
          2460 => Opcode::VSRO,
          2461 => Opcode::VSRQ,
          2462 => Opcode::VSRV,
          2463 => Opcode::VSRW,
          2464 => Opcode::VSTRIBL,
          2465 => Opcode::VSTRIBL_rec,
          2466 => Opcode::VSTRIBR,
          2467 => Opcode::VSTRIBR_rec,
          2468 => Opcode::VSTRIHL,
          2469 => Opcode::VSTRIHL_rec,
          2470 => Opcode::VSTRIHR,
          2471 => Opcode::VSTRIHR_rec,
          2472 => Opcode::VSUBCUQ,
          2473 => Opcode::VSUBCUW,
          2474 => Opcode::VSUBECUQ,
          2475 => Opcode::VSUBEUQM,
          2476 => Opcode::VSUBFP,
          2477 => Opcode::VSUBSBS,
          2478 => Opcode::VSUBSHS,
          2479 => Opcode::VSUBSWS,
          2480 => Opcode::VSUBUBM,
          2481 => Opcode::VSUBUBS,
          2482 => Opcode::VSUBUDM,
          2483 => Opcode::VSUBUHM,
          2484 => Opcode::VSUBUHS,
          2485 => Opcode::VSUBUQM,
          2486 => Opcode::VSUBUWM,
          2487 => Opcode::VSUBUWS,
          2488 => Opcode::VSUM2SWS,
          2489 => Opcode::VSUM4SBS,
          2490 => Opcode::VSUM4SHS,
          2491 => Opcode::VSUM4UBS,
          2492 => Opcode::VSUMSWS,
          2493 => Opcode::VUPKHPX,
          2494 => Opcode::VUPKHSB,
          2495 => Opcode::VUPKHSH,
          2496 => Opcode::VUPKHSW,
          2497 => Opcode::VUPKLPX,
          2498 => Opcode::VUPKLSB,
          2499 => Opcode::VUPKLSH,
          2500 => Opcode::VUPKLSW,
          2501 => Opcode::VXOR,
          2502 => Opcode::V_SET0,
          2503 => Opcode::V_SET0B,
          2504 => Opcode::V_SET0H,
          2505 => Opcode::V_SETALLONES,
          2506 => Opcode::V_SETALLONESB,
          2507 => Opcode::V_SETALLONESH,
          2508 => Opcode::WAIT,
          2509 => Opcode::WAITP10,
          2510 => Opcode::WRTEE,
          2511 => Opcode::WRTEEI,
          2512 => Opcode::XOR,
          2513 => Opcode::XOR8,
          2514 => Opcode::XOR8_rec,
          2515 => Opcode::XORI,
          2516 => Opcode::XORI8,
          2517 => Opcode::XORIS,
          2518 => Opcode::XORIS8,
          2519 => Opcode::XOR_rec,
          2520 => Opcode::XSABSDP,
          2521 => Opcode::XSABSQP,
          2522 => Opcode::XSADDDP,
          2523 => Opcode::XSADDQP,
          2524 => Opcode::XSADDQPO,
          2525 => Opcode::XSADDSP,
          2526 => Opcode::XSCMPEQDP,
          2527 => Opcode::XSCMPEQQP,
          2528 => Opcode::XSCMPEXPDP,
          2529 => Opcode::XSCMPEXPQP,
          2530 => Opcode::XSCMPGEDP,
          2531 => Opcode::XSCMPGEQP,
          2532 => Opcode::XSCMPGTDP,
          2533 => Opcode::XSCMPGTQP,
          2534 => Opcode::XSCMPODP,
          2535 => Opcode::XSCMPOQP,
          2536 => Opcode::XSCMPUDP,
          2537 => Opcode::XSCMPUQP,
          2538 => Opcode::XSCPSGNDP,
          2539 => Opcode::XSCPSGNQP,
          2540 => Opcode::XSCVDPHP,
          2541 => Opcode::XSCVDPQP,
          2542 => Opcode::XSCVDPSP,
          2543 => Opcode::XSCVDPSPN,
          2544 => Opcode::XSCVDPSXDS,
          2545 => Opcode::XSCVDPSXDSs,
          2546 => Opcode::XSCVDPSXWS,
          2547 => Opcode::XSCVDPSXWSs,
          2548 => Opcode::XSCVDPUXDS,
          2549 => Opcode::XSCVDPUXDSs,
          2550 => Opcode::XSCVDPUXWS,
          2551 => Opcode::XSCVDPUXWSs,
          2552 => Opcode::XSCVHPDP,
          2553 => Opcode::XSCVQPDP,
          2554 => Opcode::XSCVQPDPO,
          2555 => Opcode::XSCVQPSDZ,
          2556 => Opcode::XSCVQPSQZ,
          2557 => Opcode::XSCVQPSWZ,
          2558 => Opcode::XSCVQPUDZ,
          2559 => Opcode::XSCVQPUQZ,
          2560 => Opcode::XSCVQPUWZ,
          2561 => Opcode::XSCVSDQP,
          2562 => Opcode::XSCVSPDP,
          2563 => Opcode::XSCVSPDPN,
          2564 => Opcode::XSCVSQQP,
          2565 => Opcode::XSCVSXDDP,
          2566 => Opcode::XSCVSXDSP,
          2567 => Opcode::XSCVUDQP,
          2568 => Opcode::XSCVUQQP,
          2569 => Opcode::XSCVUXDDP,
          2570 => Opcode::XSCVUXDSP,
          2571 => Opcode::XSDIVDP,
          2572 => Opcode::XSDIVQP,
          2573 => Opcode::XSDIVQPO,
          2574 => Opcode::XSDIVSP,
          2575 => Opcode::XSIEXPDP,
          2576 => Opcode::XSIEXPQP,
          2577 => Opcode::XSMADDADP,
          2578 => Opcode::XSMADDASP,
          2579 => Opcode::XSMADDMDP,
          2580 => Opcode::XSMADDMSP,
          2581 => Opcode::XSMADDQP,
          2582 => Opcode::XSMADDQPO,
          2583 => Opcode::XSMAXCDP,
          2584 => Opcode::XSMAXCQP,
          2585 => Opcode::XSMAXDP,
          2586 => Opcode::XSMAXJDP,
          2587 => Opcode::XSMINCDP,
          2588 => Opcode::XSMINCQP,
          2589 => Opcode::XSMINDP,
          2590 => Opcode::XSMINJDP,
          2591 => Opcode::XSMSUBADP,
          2592 => Opcode::XSMSUBASP,
          2593 => Opcode::XSMSUBMDP,
          2594 => Opcode::XSMSUBMSP,
          2595 => Opcode::XSMSUBQP,
          2596 => Opcode::XSMSUBQPO,
          2597 => Opcode::XSMULDP,
          2598 => Opcode::XSMULQP,
          2599 => Opcode::XSMULQPO,
          2600 => Opcode::XSMULSP,
          2601 => Opcode::XSNABSDP,
          2602 => Opcode::XSNABSDPs,
          2603 => Opcode::XSNABSQP,
          2604 => Opcode::XSNEGDP,
          2605 => Opcode::XSNEGQP,
          2606 => Opcode::XSNMADDADP,
          2607 => Opcode::XSNMADDASP,
          2608 => Opcode::XSNMADDMDP,
          2609 => Opcode::XSNMADDMSP,
          2610 => Opcode::XSNMADDQP,
          2611 => Opcode::XSNMADDQPO,
          2612 => Opcode::XSNMSUBADP,
          2613 => Opcode::XSNMSUBASP,
          2614 => Opcode::XSNMSUBMDP,
          2615 => Opcode::XSNMSUBMSP,
          2616 => Opcode::XSNMSUBQP,
          2617 => Opcode::XSNMSUBQPO,
          2618 => Opcode::XSRDPI,
          2619 => Opcode::XSRDPIC,
          2620 => Opcode::XSRDPIM,
          2621 => Opcode::XSRDPIP,
          2622 => Opcode::XSRDPIZ,
          2623 => Opcode::XSREDP,
          2624 => Opcode::XSRESP,
          2625 => Opcode::XSRQPI,
          2626 => Opcode::XSRQPIX,
          2627 => Opcode::XSRQPXP,
          2628 => Opcode::XSRSP,
          2629 => Opcode::XSRSQRTEDP,
          2630 => Opcode::XSRSQRTESP,
          2631 => Opcode::XSSQRTDP,
          2632 => Opcode::XSSQRTQP,
          2633 => Opcode::XSSQRTQPO,
          2634 => Opcode::XSSQRTSP,
          2635 => Opcode::XSSUBDP,
          2636 => Opcode::XSSUBQP,
          2637 => Opcode::XSSUBQPO,
          2638 => Opcode::XSSUBSP,
          2639 => Opcode::XSTDIVDP,
          2640 => Opcode::XSTSQRTDP,
          2641 => Opcode::XSTSTDCDP,
          2642 => Opcode::XSTSTDCQP,
          2643 => Opcode::XSTSTDCSP,
          2644 => Opcode::XSXEXPDP,
          2645 => Opcode::XSXEXPQP,
          2646 => Opcode::XSXSIGDP,
          2647 => Opcode::XSXSIGQP,
          2648 => Opcode::XVABSDP,
          2649 => Opcode::XVABSSP,
          2650 => Opcode::XVADDDP,
          2651 => Opcode::XVADDSP,
          2652 => Opcode::XVBF16GER2,
          2653 => Opcode::XVBF16GER2NN,
          2654 => Opcode::XVBF16GER2NP,
          2655 => Opcode::XVBF16GER2PN,
          2656 => Opcode::XVBF16GER2PP,
          2657 => Opcode::XVBF16GER2W,
          2658 => Opcode::XVBF16GER2WNN,
          2659 => Opcode::XVBF16GER2WNP,
          2660 => Opcode::XVBF16GER2WPN,
          2661 => Opcode::XVBF16GER2WPP,
          2662 => Opcode::XVCMPEQDP,
          2663 => Opcode::XVCMPEQDP_rec,
          2664 => Opcode::XVCMPEQSP,
          2665 => Opcode::XVCMPEQSP_rec,
          2666 => Opcode::XVCMPGEDP,
          2667 => Opcode::XVCMPGEDP_rec,
          2668 => Opcode::XVCMPGESP,
          2669 => Opcode::XVCMPGESP_rec,
          2670 => Opcode::XVCMPGTDP,
          2671 => Opcode::XVCMPGTDP_rec,
          2672 => Opcode::XVCMPGTSP,
          2673 => Opcode::XVCMPGTSP_rec,
          2674 => Opcode::XVCPSGNDP,
          2675 => Opcode::XVCPSGNSP,
          2676 => Opcode::XVCVBF16SPN,
          2677 => Opcode::XVCVDPSP,
          2678 => Opcode::XVCVDPSXDS,
          2679 => Opcode::XVCVDPSXWS,
          2680 => Opcode::XVCVDPUXDS,
          2681 => Opcode::XVCVDPUXWS,
          2682 => Opcode::XVCVHPSP,
          2683 => Opcode::XVCVSPBF16,
          2684 => Opcode::XVCVSPDP,
          2685 => Opcode::XVCVSPHP,
          2686 => Opcode::XVCVSPSXDS,
          2687 => Opcode::XVCVSPSXWS,
          2688 => Opcode::XVCVSPUXDS,
          2689 => Opcode::XVCVSPUXWS,
          2690 => Opcode::XVCVSXDDP,
          2691 => Opcode::XVCVSXDSP,
          2692 => Opcode::XVCVSXWDP,
          2693 => Opcode::XVCVSXWSP,
          2694 => Opcode::XVCVUXDDP,
          2695 => Opcode::XVCVUXDSP,
          2696 => Opcode::XVCVUXWDP,
          2697 => Opcode::XVCVUXWSP,
          2698 => Opcode::XVDIVDP,
          2699 => Opcode::XVDIVSP,
          2700 => Opcode::XVF16GER2,
          2701 => Opcode::XVF16GER2NN,
          2702 => Opcode::XVF16GER2NP,
          2703 => Opcode::XVF16GER2PN,
          2704 => Opcode::XVF16GER2PP,
          2705 => Opcode::XVF16GER2W,
          2706 => Opcode::XVF16GER2WNN,
          2707 => Opcode::XVF16GER2WNP,
          2708 => Opcode::XVF16GER2WPN,
          2709 => Opcode::XVF16GER2WPP,
          2710 => Opcode::XVF32GER,
          2711 => Opcode::XVF32GERNN,
          2712 => Opcode::XVF32GERNP,
          2713 => Opcode::XVF32GERPN,
          2714 => Opcode::XVF32GERPP,
          2715 => Opcode::XVF32GERW,
          2716 => Opcode::XVF32GERWNN,
          2717 => Opcode::XVF32GERWNP,
          2718 => Opcode::XVF32GERWPN,
          2719 => Opcode::XVF32GERWPP,
          2720 => Opcode::XVF64GER,
          2721 => Opcode::XVF64GERNN,
          2722 => Opcode::XVF64GERNP,
          2723 => Opcode::XVF64GERPN,
          2724 => Opcode::XVF64GERPP,
          2725 => Opcode::XVF64GERW,
          2726 => Opcode::XVF64GERWNN,
          2727 => Opcode::XVF64GERWNP,
          2728 => Opcode::XVF64GERWPN,
          2729 => Opcode::XVF64GERWPP,
          2730 => Opcode::XVI16GER2,
          2731 => Opcode::XVI16GER2PP,
          2732 => Opcode::XVI16GER2S,
          2733 => Opcode::XVI16GER2SPP,
          2734 => Opcode::XVI16GER2SW,
          2735 => Opcode::XVI16GER2SWPP,
          2736 => Opcode::XVI16GER2W,
          2737 => Opcode::XVI16GER2WPP,
          2738 => Opcode::XVI4GER8,
          2739 => Opcode::XVI4GER8PP,
          2740 => Opcode::XVI4GER8W,
          2741 => Opcode::XVI4GER8WPP,
          2742 => Opcode::XVI8GER4,
          2743 => Opcode::XVI8GER4PP,
          2744 => Opcode::XVI8GER4SPP,
          2745 => Opcode::XVI8GER4W,
          2746 => Opcode::XVI8GER4WPP,
          2747 => Opcode::XVI8GER4WSPP,
          2748 => Opcode::XVIEXPDP,
          2749 => Opcode::XVIEXPSP,
          2750 => Opcode::XVMADDADP,
          2751 => Opcode::XVMADDASP,
          2752 => Opcode::XVMADDMDP,
          2753 => Opcode::XVMADDMSP,
          2754 => Opcode::XVMAXDP,
          2755 => Opcode::XVMAXSP,
          2756 => Opcode::XVMINDP,
          2757 => Opcode::XVMINSP,
          2758 => Opcode::XVMSUBADP,
          2759 => Opcode::XVMSUBASP,
          2760 => Opcode::XVMSUBMDP,
          2761 => Opcode::XVMSUBMSP,
          2762 => Opcode::XVMULDP,
          2763 => Opcode::XVMULSP,
          2764 => Opcode::XVNABSDP,
          2765 => Opcode::XVNABSSP,
          2766 => Opcode::XVNEGDP,
          2767 => Opcode::XVNEGSP,
          2768 => Opcode::XVNMADDADP,
          2769 => Opcode::XVNMADDASP,
          2770 => Opcode::XVNMADDMDP,
          2771 => Opcode::XVNMADDMSP,
          2772 => Opcode::XVNMSUBADP,
          2773 => Opcode::XVNMSUBASP,
          2774 => Opcode::XVNMSUBMDP,
          2775 => Opcode::XVNMSUBMSP,
          2776 => Opcode::XVRDPI,
          2777 => Opcode::XVRDPIC,
          2778 => Opcode::XVRDPIM,
          2779 => Opcode::XVRDPIP,
          2780 => Opcode::XVRDPIZ,
          2781 => Opcode::XVREDP,
          2782 => Opcode::XVRESP,
          2783 => Opcode::XVRSPI,
          2784 => Opcode::XVRSPIC,
          2785 => Opcode::XVRSPIM,
          2786 => Opcode::XVRSPIP,
          2787 => Opcode::XVRSPIZ,
          2788 => Opcode::XVRSQRTEDP,
          2789 => Opcode::XVRSQRTESP,
          2790 => Opcode::XVSQRTDP,
          2791 => Opcode::XVSQRTSP,
          2792 => Opcode::XVSUBDP,
          2793 => Opcode::XVSUBSP,
          2794 => Opcode::XVTDIVDP,
          2795 => Opcode::XVTDIVSP,
          2796 => Opcode::XVTLSBB,
          2797 => Opcode::XVTSQRTDP,
          2798 => Opcode::XVTSQRTSP,
          2799 => Opcode::XVTSTDCDP,
          2800 => Opcode::XVTSTDCSP,
          2801 => Opcode::XVXEXPDP,
          2802 => Opcode::XVXEXPSP,
          2803 => Opcode::XVXSIGDP,
          2804 => Opcode::XVXSIGSP,
          2805 => Opcode::XXBLENDVB,
          2806 => Opcode::XXBLENDVD,
          2807 => Opcode::XXBLENDVH,
          2808 => Opcode::XXBLENDVW,
          2809 => Opcode::XXBRD,
          2810 => Opcode::XXBRH,
          2811 => Opcode::XXBRQ,
          2812 => Opcode::XXBRW,
          2813 => Opcode::XXEVAL,
          2814 => Opcode::XXEXTRACTUW,
          2815 => Opcode::XXGENPCVBM,
          2816 => Opcode::XXGENPCVDM,
          2817 => Opcode::XXGENPCVHM,
          2818 => Opcode::XXGENPCVWM,
          2819 => Opcode::XXINSERTW,
          2820 => Opcode::XXLAND,
          2821 => Opcode::XXLANDC,
          2822 => Opcode::XXLEQV,
          2823 => Opcode::XXLEQVOnes,
          2824 => Opcode::XXLNAND,
          2825 => Opcode::XXLNOR,
          2826 => Opcode::XXLOR,
          2827 => Opcode::XXLORC,
          2828 => Opcode::XXLORf,
          2829 => Opcode::XXLXOR,
          2830 => Opcode::XXLXORdpz,
          2831 => Opcode::XXLXORspz,
          2832 => Opcode::XXLXORz,
          2833 => Opcode::XXMFACC,
          2834 => Opcode::XXMFACCW,
          2835 => Opcode::XXMRGHW,
          2836 => Opcode::XXMRGLW,
          2837 => Opcode::XXMTACC,
          2838 => Opcode::XXMTACCW,
          2839 => Opcode::XXPERM,
          2840 => Opcode::XXPERMDI,
          2841 => Opcode::XXPERMDIs,
          2842 => Opcode::XXPERMR,
          2843 => Opcode::XXPERMX,
          2844 => Opcode::XXSEL,
          2845 => Opcode::XXSETACCZ,
          2846 => Opcode::XXSETACCZW,
          2847 => Opcode::XXSLDWI,
          2848 => Opcode::XXSLDWIs,
          2849 => Opcode::XXSPLTI32DX,
          2850 => Opcode::XXSPLTIB,
          2851 => Opcode::XXSPLTIDP,
          2852 => Opcode::XXSPLTIW,
          2853 => Opcode::XXSPLTW,
          2854 => Opcode::XXSPLTWs,
          2855 => Opcode::gBC,
          2856 => Opcode::gBCA,
          2857 => Opcode::gBCAat,
          2858 => Opcode::gBCCTR,
          2859 => Opcode::gBCCTRL,
          2860 => Opcode::gBCL,
          2861 => Opcode::gBCLA,
          2862 => Opcode::gBCLAat,
          2863 => Opcode::gBCLR,
          2864 => Opcode::gBCLRL,
          2865 => Opcode::gBCLat,
          2866 => Opcode::gBCat,
          2867 => Opcode::INSTRUCTION_LIST_END,
          _ => Opcode::UNKNOWN(value),
        }
    }
}
