/* Copyright 2022 - 2025 R. Thomas
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
#ifndef LIEF_ASM_MIPS_OPCODE_H
#define LIEF_ASM_MIPS_OPCODE_H

/* Generated from LLVM: 21.1.0 */

namespace LIEF {
namespace assembly {
namespace mips {
enum class OPCODE {
  PHI = 0,
  INLINEASM = 1,
  INLINEASM_BR = 2,
  CFI_INSTRUCTION = 3,
  EH_LABEL = 4,
  GC_LABEL = 5,
  ANNOTATION_LABEL = 6,
  KILL = 7,
  EXTRACT_SUBREG = 8,
  INSERT_SUBREG = 9,
  IMPLICIT_DEF = 10,
  INIT_UNDEF = 11,
  SUBREG_TO_REG = 12,
  COPY_TO_REGCLASS = 13,
  DBG_VALUE = 14,
  DBG_VALUE_LIST = 15,
  DBG_INSTR_REF = 16,
  DBG_PHI = 17,
  DBG_LABEL = 18,
  REG_SEQUENCE = 19,
  COPY = 20,
  BUNDLE = 21,
  LIFETIME_START = 22,
  LIFETIME_END = 23,
  PSEUDO_PROBE = 24,
  ARITH_FENCE = 25,
  STACKMAP = 26,
  FENTRY_CALL = 27,
  PATCHPOINT = 28,
  LOAD_STACK_GUARD = 29,
  PREALLOCATED_SETUP = 30,
  PREALLOCATED_ARG = 31,
  STATEPOINT = 32,
  LOCAL_ESCAPE = 33,
  FAULTING_OP = 34,
  PATCHABLE_OP = 35,
  PATCHABLE_FUNCTION_ENTER = 36,
  PATCHABLE_RET = 37,
  PATCHABLE_FUNCTION_EXIT = 38,
  PATCHABLE_TAIL_CALL = 39,
  PATCHABLE_EVENT_CALL = 40,
  PATCHABLE_TYPED_EVENT_CALL = 41,
  ICALL_BRANCH_FUNNEL = 42,
  FAKE_USE = 43,
  MEMBARRIER = 44,
  JUMP_TABLE_DEBUG_INFO = 45,
  CONVERGENCECTRL_ENTRY = 46,
  CONVERGENCECTRL_ANCHOR = 47,
  CONVERGENCECTRL_LOOP = 48,
  CONVERGENCECTRL_GLUE = 49,
  G_ASSERT_SEXT = 50,
  G_ASSERT_ZEXT = 51,
  G_ASSERT_ALIGN = 52,
  G_ADD = 53,
  G_SUB = 54,
  G_MUL = 55,
  G_SDIV = 56,
  G_UDIV = 57,
  G_SREM = 58,
  G_UREM = 59,
  G_SDIVREM = 60,
  G_UDIVREM = 61,
  G_AND = 62,
  G_OR = 63,
  G_XOR = 64,
  G_ABDS = 65,
  G_ABDU = 66,
  G_IMPLICIT_DEF = 67,
  G_PHI = 68,
  G_FRAME_INDEX = 69,
  G_GLOBAL_VALUE = 70,
  G_PTRAUTH_GLOBAL_VALUE = 71,
  G_CONSTANT_POOL = 72,
  G_EXTRACT = 73,
  G_UNMERGE_VALUES = 74,
  G_INSERT = 75,
  G_MERGE_VALUES = 76,
  G_BUILD_VECTOR = 77,
  G_BUILD_VECTOR_TRUNC = 78,
  G_CONCAT_VECTORS = 79,
  G_PTRTOINT = 80,
  G_INTTOPTR = 81,
  G_BITCAST = 82,
  G_FREEZE = 83,
  G_CONSTANT_FOLD_BARRIER = 84,
  G_INTRINSIC_FPTRUNC_ROUND = 85,
  G_INTRINSIC_TRUNC = 86,
  G_INTRINSIC_ROUND = 87,
  G_INTRINSIC_LRINT = 88,
  G_INTRINSIC_LLRINT = 89,
  G_INTRINSIC_ROUNDEVEN = 90,
  G_READCYCLECOUNTER = 91,
  G_READSTEADYCOUNTER = 92,
  G_LOAD = 93,
  G_SEXTLOAD = 94,
  G_ZEXTLOAD = 95,
  G_INDEXED_LOAD = 96,
  G_INDEXED_SEXTLOAD = 97,
  G_INDEXED_ZEXTLOAD = 98,
  G_STORE = 99,
  G_INDEXED_STORE = 100,
  G_ATOMIC_CMPXCHG_WITH_SUCCESS = 101,
  G_ATOMIC_CMPXCHG = 102,
  G_ATOMICRMW_XCHG = 103,
  G_ATOMICRMW_ADD = 104,
  G_ATOMICRMW_SUB = 105,
  G_ATOMICRMW_AND = 106,
  G_ATOMICRMW_NAND = 107,
  G_ATOMICRMW_OR = 108,
  G_ATOMICRMW_XOR = 109,
  G_ATOMICRMW_MAX = 110,
  G_ATOMICRMW_MIN = 111,
  G_ATOMICRMW_UMAX = 112,
  G_ATOMICRMW_UMIN = 113,
  G_ATOMICRMW_FADD = 114,
  G_ATOMICRMW_FSUB = 115,
  G_ATOMICRMW_FMAX = 116,
  G_ATOMICRMW_FMIN = 117,
  G_ATOMICRMW_FMAXIMUM = 118,
  G_ATOMICRMW_FMINIMUM = 119,
  G_ATOMICRMW_UINC_WRAP = 120,
  G_ATOMICRMW_UDEC_WRAP = 121,
  G_ATOMICRMW_USUB_COND = 122,
  G_ATOMICRMW_USUB_SAT = 123,
  G_FENCE = 124,
  G_PREFETCH = 125,
  G_BRCOND = 126,
  G_BRINDIRECT = 127,
  G_INVOKE_REGION_START = 128,
  G_INTRINSIC = 129,
  G_INTRINSIC_W_SIDE_EFFECTS = 130,
  G_INTRINSIC_CONVERGENT = 131,
  G_INTRINSIC_CONVERGENT_W_SIDE_EFFECTS = 132,
  G_ANYEXT = 133,
  G_TRUNC = 134,
  G_TRUNC_SSAT_S = 135,
  G_TRUNC_SSAT_U = 136,
  G_TRUNC_USAT_U = 137,
  G_CONSTANT = 138,
  G_FCONSTANT = 139,
  G_VASTART = 140,
  G_VAARG = 141,
  G_SEXT = 142,
  G_SEXT_INREG = 143,
  G_ZEXT = 144,
  G_SHL = 145,
  G_LSHR = 146,
  G_ASHR = 147,
  G_FSHL = 148,
  G_FSHR = 149,
  G_ROTR = 150,
  G_ROTL = 151,
  G_ICMP = 152,
  G_FCMP = 153,
  G_SCMP = 154,
  G_UCMP = 155,
  G_SELECT = 156,
  G_UADDO = 157,
  G_UADDE = 158,
  G_USUBO = 159,
  G_USUBE = 160,
  G_SADDO = 161,
  G_SADDE = 162,
  G_SSUBO = 163,
  G_SSUBE = 164,
  G_UMULO = 165,
  G_SMULO = 166,
  G_UMULH = 167,
  G_SMULH = 168,
  G_UADDSAT = 169,
  G_SADDSAT = 170,
  G_USUBSAT = 171,
  G_SSUBSAT = 172,
  G_USHLSAT = 173,
  G_SSHLSAT = 174,
  G_SMULFIX = 175,
  G_UMULFIX = 176,
  G_SMULFIXSAT = 177,
  G_UMULFIXSAT = 178,
  G_SDIVFIX = 179,
  G_UDIVFIX = 180,
  G_SDIVFIXSAT = 181,
  G_UDIVFIXSAT = 182,
  G_FADD = 183,
  G_FSUB = 184,
  G_FMUL = 185,
  G_FMA = 186,
  G_FMAD = 187,
  G_FDIV = 188,
  G_FREM = 189,
  G_FPOW = 190,
  G_FPOWI = 191,
  G_FEXP = 192,
  G_FEXP2 = 193,
  G_FEXP10 = 194,
  G_FLOG = 195,
  G_FLOG2 = 196,
  G_FLOG10 = 197,
  G_FLDEXP = 198,
  G_FFREXP = 199,
  G_FNEG = 200,
  G_FPEXT = 201,
  G_FPTRUNC = 202,
  G_FPTOSI = 203,
  G_FPTOUI = 204,
  G_SITOFP = 205,
  G_UITOFP = 206,
  G_FPTOSI_SAT = 207,
  G_FPTOUI_SAT = 208,
  G_FABS = 209,
  G_FCOPYSIGN = 210,
  G_IS_FPCLASS = 211,
  G_FCANONICALIZE = 212,
  G_FMINNUM = 213,
  G_FMAXNUM = 214,
  G_FMINNUM_IEEE = 215,
  G_FMAXNUM_IEEE = 216,
  G_FMINIMUM = 217,
  G_FMAXIMUM = 218,
  G_FMINIMUMNUM = 219,
  G_FMAXIMUMNUM = 220,
  G_GET_FPENV = 221,
  G_SET_FPENV = 222,
  G_RESET_FPENV = 223,
  G_GET_FPMODE = 224,
  G_SET_FPMODE = 225,
  G_RESET_FPMODE = 226,
  G_GET_ROUNDING = 227,
  G_PTR_ADD = 228,
  G_PTRMASK = 229,
  G_SMIN = 230,
  G_SMAX = 231,
  G_UMIN = 232,
  G_UMAX = 233,
  G_ABS = 234,
  G_LROUND = 235,
  G_LLROUND = 236,
  G_BR = 237,
  G_BRJT = 238,
  G_VSCALE = 239,
  G_INSERT_SUBVECTOR = 240,
  G_EXTRACT_SUBVECTOR = 241,
  G_INSERT_VECTOR_ELT = 242,
  G_EXTRACT_VECTOR_ELT = 243,
  G_SHUFFLE_VECTOR = 244,
  G_SPLAT_VECTOR = 245,
  G_STEP_VECTOR = 246,
  G_VECTOR_COMPRESS = 247,
  G_CTTZ = 248,
  G_CTTZ_ZERO_UNDEF = 249,
  G_CTLZ = 250,
  G_CTLZ_ZERO_UNDEF = 251,
  G_CTPOP = 252,
  G_BSWAP = 253,
  G_BITREVERSE = 254,
  G_FCEIL = 255,
  G_FCOS = 256,
  G_FSIN = 257,
  G_FSINCOS = 258,
  G_FTAN = 259,
  G_FACOS = 260,
  G_FASIN = 261,
  G_FATAN = 262,
  G_FATAN2 = 263,
  G_FCOSH = 264,
  G_FSINH = 265,
  G_FTANH = 266,
  G_FSQRT = 267,
  G_FFLOOR = 268,
  G_FRINT = 269,
  G_FNEARBYINT = 270,
  G_ADDRSPACE_CAST = 271,
  G_BLOCK_ADDR = 272,
  G_JUMP_TABLE = 273,
  G_DYN_STACKALLOC = 274,
  G_STACKSAVE = 275,
  G_STACKRESTORE = 276,
  G_STRICT_FADD = 277,
  G_STRICT_FSUB = 278,
  G_STRICT_FMUL = 279,
  G_STRICT_FDIV = 280,
  G_STRICT_FREM = 281,
  G_STRICT_FMA = 282,
  G_STRICT_FSQRT = 283,
  G_STRICT_FLDEXP = 284,
  G_READ_REGISTER = 285,
  G_WRITE_REGISTER = 286,
  G_MEMCPY = 287,
  G_MEMCPY_INLINE = 288,
  G_MEMMOVE = 289,
  G_MEMSET = 290,
  G_BZERO = 291,
  G_TRAP = 292,
  G_DEBUGTRAP = 293,
  G_UBSANTRAP = 294,
  G_VECREDUCE_SEQ_FADD = 295,
  G_VECREDUCE_SEQ_FMUL = 296,
  G_VECREDUCE_FADD = 297,
  G_VECREDUCE_FMUL = 298,
  G_VECREDUCE_FMAX = 299,
  G_VECREDUCE_FMIN = 300,
  G_VECREDUCE_FMAXIMUM = 301,
  G_VECREDUCE_FMINIMUM = 302,
  G_VECREDUCE_ADD = 303,
  G_VECREDUCE_MUL = 304,
  G_VECREDUCE_AND = 305,
  G_VECREDUCE_OR = 306,
  G_VECREDUCE_XOR = 307,
  G_VECREDUCE_SMAX = 308,
  G_VECREDUCE_SMIN = 309,
  G_VECREDUCE_UMAX = 310,
  G_VECREDUCE_UMIN = 311,
  G_SBFX = 312,
  G_UBFX = 313,
  ABSMacro = 314,
  ADJCALLSTACKDOWN = 315,
  ADJCALLSTACKUP = 316,
  AND_V_D_PSEUDO = 317,
  AND_V_H_PSEUDO = 318,
  AND_V_W_PSEUDO = 319,
  ATOMIC_CMP_SWAP_I16 = 320,
  ATOMIC_CMP_SWAP_I16_POSTRA = 321,
  ATOMIC_CMP_SWAP_I32 = 322,
  ATOMIC_CMP_SWAP_I32_POSTRA = 323,
  ATOMIC_CMP_SWAP_I64 = 324,
  ATOMIC_CMP_SWAP_I64_POSTRA = 325,
  ATOMIC_CMP_SWAP_I8 = 326,
  ATOMIC_CMP_SWAP_I8_POSTRA = 327,
  ATOMIC_LOAD_ADD_I16 = 328,
  ATOMIC_LOAD_ADD_I16_POSTRA = 329,
  ATOMIC_LOAD_ADD_I32 = 330,
  ATOMIC_LOAD_ADD_I32_POSTRA = 331,
  ATOMIC_LOAD_ADD_I64 = 332,
  ATOMIC_LOAD_ADD_I64_POSTRA = 333,
  ATOMIC_LOAD_ADD_I8 = 334,
  ATOMIC_LOAD_ADD_I8_POSTRA = 335,
  ATOMIC_LOAD_AND_I16 = 336,
  ATOMIC_LOAD_AND_I16_POSTRA = 337,
  ATOMIC_LOAD_AND_I32 = 338,
  ATOMIC_LOAD_AND_I32_POSTRA = 339,
  ATOMIC_LOAD_AND_I64 = 340,
  ATOMIC_LOAD_AND_I64_POSTRA = 341,
  ATOMIC_LOAD_AND_I8 = 342,
  ATOMIC_LOAD_AND_I8_POSTRA = 343,
  ATOMIC_LOAD_MAX_I16 = 344,
  ATOMIC_LOAD_MAX_I16_POSTRA = 345,
  ATOMIC_LOAD_MAX_I32 = 346,
  ATOMIC_LOAD_MAX_I32_POSTRA = 347,
  ATOMIC_LOAD_MAX_I64 = 348,
  ATOMIC_LOAD_MAX_I64_POSTRA = 349,
  ATOMIC_LOAD_MAX_I8 = 350,
  ATOMIC_LOAD_MAX_I8_POSTRA = 351,
  ATOMIC_LOAD_MIN_I16 = 352,
  ATOMIC_LOAD_MIN_I16_POSTRA = 353,
  ATOMIC_LOAD_MIN_I32 = 354,
  ATOMIC_LOAD_MIN_I32_POSTRA = 355,
  ATOMIC_LOAD_MIN_I64 = 356,
  ATOMIC_LOAD_MIN_I64_POSTRA = 357,
  ATOMIC_LOAD_MIN_I8 = 358,
  ATOMIC_LOAD_MIN_I8_POSTRA = 359,
  ATOMIC_LOAD_NAND_I16 = 360,
  ATOMIC_LOAD_NAND_I16_POSTRA = 361,
  ATOMIC_LOAD_NAND_I32 = 362,
  ATOMIC_LOAD_NAND_I32_POSTRA = 363,
  ATOMIC_LOAD_NAND_I64 = 364,
  ATOMIC_LOAD_NAND_I64_POSTRA = 365,
  ATOMIC_LOAD_NAND_I8 = 366,
  ATOMIC_LOAD_NAND_I8_POSTRA = 367,
  ATOMIC_LOAD_OR_I16 = 368,
  ATOMIC_LOAD_OR_I16_POSTRA = 369,
  ATOMIC_LOAD_OR_I32 = 370,
  ATOMIC_LOAD_OR_I32_POSTRA = 371,
  ATOMIC_LOAD_OR_I64 = 372,
  ATOMIC_LOAD_OR_I64_POSTRA = 373,
  ATOMIC_LOAD_OR_I8 = 374,
  ATOMIC_LOAD_OR_I8_POSTRA = 375,
  ATOMIC_LOAD_SUB_I16 = 376,
  ATOMIC_LOAD_SUB_I16_POSTRA = 377,
  ATOMIC_LOAD_SUB_I32 = 378,
  ATOMIC_LOAD_SUB_I32_POSTRA = 379,
  ATOMIC_LOAD_SUB_I64 = 380,
  ATOMIC_LOAD_SUB_I64_POSTRA = 381,
  ATOMIC_LOAD_SUB_I8 = 382,
  ATOMIC_LOAD_SUB_I8_POSTRA = 383,
  ATOMIC_LOAD_UMAX_I16 = 384,
  ATOMIC_LOAD_UMAX_I16_POSTRA = 385,
  ATOMIC_LOAD_UMAX_I32 = 386,
  ATOMIC_LOAD_UMAX_I32_POSTRA = 387,
  ATOMIC_LOAD_UMAX_I64 = 388,
  ATOMIC_LOAD_UMAX_I64_POSTRA = 389,
  ATOMIC_LOAD_UMAX_I8 = 390,
  ATOMIC_LOAD_UMAX_I8_POSTRA = 391,
  ATOMIC_LOAD_UMIN_I16 = 392,
  ATOMIC_LOAD_UMIN_I16_POSTRA = 393,
  ATOMIC_LOAD_UMIN_I32 = 394,
  ATOMIC_LOAD_UMIN_I32_POSTRA = 395,
  ATOMIC_LOAD_UMIN_I64 = 396,
  ATOMIC_LOAD_UMIN_I64_POSTRA = 397,
  ATOMIC_LOAD_UMIN_I8 = 398,
  ATOMIC_LOAD_UMIN_I8_POSTRA = 399,
  ATOMIC_LOAD_XOR_I16 = 400,
  ATOMIC_LOAD_XOR_I16_POSTRA = 401,
  ATOMIC_LOAD_XOR_I32 = 402,
  ATOMIC_LOAD_XOR_I32_POSTRA = 403,
  ATOMIC_LOAD_XOR_I64 = 404,
  ATOMIC_LOAD_XOR_I64_POSTRA = 405,
  ATOMIC_LOAD_XOR_I8 = 406,
  ATOMIC_LOAD_XOR_I8_POSTRA = 407,
  ATOMIC_SWAP_I16 = 408,
  ATOMIC_SWAP_I16_POSTRA = 409,
  ATOMIC_SWAP_I32 = 410,
  ATOMIC_SWAP_I32_POSTRA = 411,
  ATOMIC_SWAP_I64 = 412,
  ATOMIC_SWAP_I64_POSTRA = 413,
  ATOMIC_SWAP_I8 = 414,
  ATOMIC_SWAP_I8_POSTRA = 415,
  B = 416,
  BAL_BR = 417,
  BAL_BR_MM = 418,
  BEQLImmMacro = 419,
  BGE = 420,
  BGEImmMacro = 421,
  BGEL = 422,
  BGELImmMacro = 423,
  BGEU = 424,
  BGEUImmMacro = 425,
  BGEUL = 426,
  BGEULImmMacro = 427,
  BGT = 428,
  BGTImmMacro = 429,
  BGTL = 430,
  BGTLImmMacro = 431,
  BGTU = 432,
  BGTUImmMacro = 433,
  BGTUL = 434,
  BGTULImmMacro = 435,
  BLE = 436,
  BLEImmMacro = 437,
  BLEL = 438,
  BLELImmMacro = 439,
  BLEU = 440,
  BLEUImmMacro = 441,
  BLEUL = 442,
  BLEULImmMacro = 443,
  BLT = 444,
  BLTImmMacro = 445,
  BLTL = 446,
  BLTLImmMacro = 447,
  BLTU = 448,
  BLTUImmMacro = 449,
  BLTUL = 450,
  BLTULImmMacro = 451,
  BNELImmMacro = 452,
  BPOSGE32_PSEUDO = 453,
  BSEL_D_PSEUDO = 454,
  BSEL_FD_PSEUDO = 455,
  BSEL_FW_PSEUDO = 456,
  BSEL_H_PSEUDO = 457,
  BSEL_W_PSEUDO = 458,
  B_MM = 459,
  B_MMR6_Pseudo = 460,
  B_MM_Pseudo = 461,
  BeqImm = 462,
  BneImm = 463,
  BteqzT8CmpX16 = 464,
  BteqzT8CmpiX16 = 465,
  BteqzT8SltX16 = 466,
  BteqzT8SltiX16 = 467,
  BteqzT8SltiuX16 = 468,
  BteqzT8SltuX16 = 469,
  BtnezT8CmpX16 = 470,
  BtnezT8CmpiX16 = 471,
  BtnezT8SltX16 = 472,
  BtnezT8SltiX16 = 473,
  BtnezT8SltiuX16 = 474,
  BtnezT8SltuX16 = 475,
  BuildPairF64 = 476,
  BuildPairF64_64 = 477,
  CFTC1 = 478,
  CONSTPOOL_ENTRY = 479,
  COPY_FD_PSEUDO = 480,
  COPY_FW_PSEUDO = 481,
  CTTC1 = 482,
  Constant32 = 483,
  DMULImmMacro = 484,
  DMULMacro = 485,
  DMULOMacro = 486,
  DMULOUMacro = 487,
  DROL = 488,
  DROLImm = 489,
  DROR = 490,
  DRORImm = 491,
  DSDivIMacro = 492,
  DSDivMacro = 493,
  DSRemIMacro = 494,
  DSRemMacro = 495,
  DUDivIMacro = 496,
  DUDivMacro = 497,
  DURemIMacro = 498,
  DURemMacro = 499,
  ERet = 500,
  ExtractElementF64 = 501,
  ExtractElementF64_64 = 502,
  FABS_D = 503,
  FABS_W = 504,
  FEXP2_D_1_PSEUDO = 505,
  FEXP2_W_1_PSEUDO = 506,
  FILL_FD_PSEUDO = 507,
  FILL_FW_PSEUDO = 508,
  GotPrologue16 = 509,
  INSERT_B_VIDX64_PSEUDO = 510,
  INSERT_B_VIDX_PSEUDO = 511,
  INSERT_D_VIDX64_PSEUDO = 512,
  INSERT_D_VIDX_PSEUDO = 513,
  INSERT_FD_PSEUDO = 514,
  INSERT_FD_VIDX64_PSEUDO = 515,
  INSERT_FD_VIDX_PSEUDO = 516,
  INSERT_FW_PSEUDO = 517,
  INSERT_FW_VIDX64_PSEUDO = 518,
  INSERT_FW_VIDX_PSEUDO = 519,
  INSERT_H_VIDX64_PSEUDO = 520,
  INSERT_H_VIDX_PSEUDO = 521,
  INSERT_W_VIDX64_PSEUDO = 522,
  INSERT_W_VIDX_PSEUDO = 523,
  JALR64Pseudo = 524,
  JALRHB64Pseudo = 525,
  JALRHBPseudo = 526,
  JALRPseudo = 527,
  JAL_MMR6 = 528,
  JalOneReg = 529,
  JalTwoReg = 530,
  LDMacro = 531,
  LDR_D = 532,
  LDR_W = 533,
  LD_F16 = 534,
  LOAD_ACC128 = 535,
  LOAD_ACC64 = 536,
  LOAD_ACC64DSP = 537,
  LOAD_CCOND_DSP = 538,
  LONG_BRANCH_ADDiu = 539,
  LONG_BRANCH_ADDiu2Op = 540,
  LONG_BRANCH_DADDiu = 541,
  LONG_BRANCH_DADDiu2Op = 542,
  LONG_BRANCH_LUi = 543,
  LONG_BRANCH_LUi2Op = 544,
  LONG_BRANCH_LUi2Op_64 = 545,
  LWM_MM = 546,
  LoadAddrImm32 = 547,
  LoadAddrImm64 = 548,
  LoadAddrReg32 = 549,
  LoadAddrReg64 = 550,
  LoadImm32 = 551,
  LoadImm64 = 552,
  LoadImmDoubleFGR = 553,
  LoadImmDoubleFGR_32 = 554,
  LoadImmDoubleGPR = 555,
  LoadImmSingleFGR = 556,
  LoadImmSingleGPR = 557,
  LwConstant32 = 558,
  MFTACX = 559,
  MFTC0 = 560,
  MFTC1 = 561,
  MFTDSP = 562,
  MFTGPR = 563,
  MFTHC1 = 564,
  MFTHI = 565,
  MFTLO = 566,
  MIPSeh_return32 = 567,
  MIPSeh_return64 = 568,
  MSA_FP_EXTEND_D_PSEUDO = 569,
  MSA_FP_EXTEND_W_PSEUDO = 570,
  MSA_FP_ROUND_D_PSEUDO = 571,
  MSA_FP_ROUND_W_PSEUDO = 572,
  MTTACX = 573,
  MTTC0 = 574,
  MTTC1 = 575,
  MTTDSP = 576,
  MTTGPR = 577,
  MTTHC1 = 578,
  MTTHI = 579,
  MTTLO = 580,
  MULImmMacro = 581,
  MULOMacro = 582,
  MULOUMacro = 583,
  MultRxRy16 = 584,
  MultRxRyRz16 = 585,
  MultuRxRy16 = 586,
  MultuRxRyRz16 = 587,
  NOP = 588,
  NORImm = 589,
  NORImm64 = 590,
  NOR_V_D_PSEUDO = 591,
  NOR_V_H_PSEUDO = 592,
  NOR_V_W_PSEUDO = 593,
  OR_V_D_PSEUDO = 594,
  OR_V_H_PSEUDO = 595,
  OR_V_W_PSEUDO = 596,
  PseudoCMPU_EQ_QB = 597,
  PseudoCMPU_LE_QB = 598,
  PseudoCMPU_LT_QB = 599,
  PseudoCMP_EQ_PH = 600,
  PseudoCMP_LE_PH = 601,
  PseudoCMP_LT_PH = 602,
  PseudoCVT_D32_W = 603,
  PseudoCVT_D64_L = 604,
  PseudoCVT_D64_W = 605,
  PseudoCVT_S_L = 606,
  PseudoCVT_S_W = 607,
  PseudoDMULT = 608,
  PseudoDMULTu = 609,
  PseudoDSDIV = 610,
  PseudoDUDIV = 611,
  PseudoD_SELECT_I = 612,
  PseudoD_SELECT_I64 = 613,
  PseudoIndirectBranch = 614,
  PseudoIndirectBranch64 = 615,
  PseudoIndirectBranch64R6 = 616,
  PseudoIndirectBranchR6 = 617,
  PseudoIndirectBranch_MM = 618,
  PseudoIndirectBranch_MMR6 = 619,
  PseudoIndirectHazardBranch = 620,
  PseudoIndirectHazardBranch64 = 621,
  PseudoIndrectHazardBranch64R6 = 622,
  PseudoIndrectHazardBranchR6 = 623,
  PseudoMADD = 624,
  PseudoMADDU = 625,
  PseudoMADDU_MM = 626,
  PseudoMADD_MM = 627,
  PseudoMFHI = 628,
  PseudoMFHI64 = 629,
  PseudoMFHI_MM = 630,
  PseudoMFLO = 631,
  PseudoMFLO64 = 632,
  PseudoMFLO_MM = 633,
  PseudoMSUB = 634,
  PseudoMSUBU = 635,
  PseudoMSUBU_MM = 636,
  PseudoMSUB_MM = 637,
  PseudoMTLOHI = 638,
  PseudoMTLOHI64 = 639,
  PseudoMTLOHI_DSP = 640,
  PseudoMTLOHI_MM = 641,
  PseudoMULT = 642,
  PseudoMULT_MM = 643,
  PseudoMULTu = 644,
  PseudoMULTu_MM = 645,
  PseudoPICK_PH = 646,
  PseudoPICK_QB = 647,
  PseudoReturn = 648,
  PseudoReturn64 = 649,
  PseudoSDIV = 650,
  PseudoSELECTFP_F_D32 = 651,
  PseudoSELECTFP_F_D64 = 652,
  PseudoSELECTFP_F_I = 653,
  PseudoSELECTFP_F_I64 = 654,
  PseudoSELECTFP_F_S = 655,
  PseudoSELECTFP_T_D32 = 656,
  PseudoSELECTFP_T_D64 = 657,
  PseudoSELECTFP_T_I = 658,
  PseudoSELECTFP_T_I64 = 659,
  PseudoSELECTFP_T_S = 660,
  PseudoSELECT_D32 = 661,
  PseudoSELECT_D64 = 662,
  PseudoSELECT_I = 663,
  PseudoSELECT_I64 = 664,
  PseudoSELECT_S = 665,
  PseudoTRUNC_W_D = 666,
  PseudoTRUNC_W_D32 = 667,
  PseudoTRUNC_W_S = 668,
  PseudoUDIV = 669,
  ROL = 670,
  ROLImm = 671,
  ROR = 672,
  RORImm = 673,
  RetRA = 674,
  RetRA16 = 675,
  SDC1_M1 = 676,
  SDIV_MM_Pseudo = 677,
  SDMacro = 678,
  SDivIMacro = 679,
  SDivMacro = 680,
  SEQIMacro = 681,
  SEQMacro = 682,
  SGE = 683,
  SGEImm = 684,
  SGEImm64 = 685,
  SGEU = 686,
  SGEUImm = 687,
  SGEUImm64 = 688,
  SGTImm = 689,
  SGTImm64 = 690,
  SGTUImm = 691,
  SGTUImm64 = 692,
  SLE = 693,
  SLEImm = 694,
  SLEImm64 = 695,
  SLEU = 696,
  SLEUImm = 697,
  SLEUImm64 = 698,
  SLTImm64 = 699,
  SLTUImm64 = 700,
  SNEIMacro = 701,
  SNEMacro = 702,
  SNZ_B_PSEUDO = 703,
  SNZ_D_PSEUDO = 704,
  SNZ_H_PSEUDO = 705,
  SNZ_V_PSEUDO = 706,
  SNZ_W_PSEUDO = 707,
  SRemIMacro = 708,
  SRemMacro = 709,
  STORE_ACC128 = 710,
  STORE_ACC64 = 711,
  STORE_ACC64DSP = 712,
  STORE_CCOND_DSP = 713,
  STR_D = 714,
  STR_W = 715,
  ST_F16 = 716,
  SWM_MM = 717,
  SZ_B_PSEUDO = 718,
  SZ_D_PSEUDO = 719,
  SZ_H_PSEUDO = 720,
  SZ_V_PSEUDO = 721,
  SZ_W_PSEUDO = 722,
  SaaAddr = 723,
  SaadAddr = 724,
  SelBeqZ = 725,
  SelBneZ = 726,
  SelTBteqZCmp = 727,
  SelTBteqZCmpi = 728,
  SelTBteqZSlt = 729,
  SelTBteqZSlti = 730,
  SelTBteqZSltiu = 731,
  SelTBteqZSltu = 732,
  SelTBtneZCmp = 733,
  SelTBtneZCmpi = 734,
  SelTBtneZSlt = 735,
  SelTBtneZSlti = 736,
  SelTBtneZSltiu = 737,
  SelTBtneZSltu = 738,
  SltCCRxRy16 = 739,
  SltiCCRxImmX16 = 740,
  SltiuCCRxImmX16 = 741,
  SltuCCRxRy16 = 742,
  SltuRxRyRz16 = 743,
  TAILCALL = 744,
  TAILCALL64R6REG = 745,
  TAILCALLHB64R6REG = 746,
  TAILCALLHBR6REG = 747,
  TAILCALLR6REG = 748,
  TAILCALLREG = 749,
  TAILCALLREG64 = 750,
  TAILCALLREGHB = 751,
  TAILCALLREGHB64 = 752,
  TAILCALLREG_MM = 753,
  TAILCALLREG_MMR6 = 754,
  TAILCALL_MM = 755,
  TAILCALL_MMR6 = 756,
  TRAP = 757,
  TRAP_MM = 758,
  UDIV_MM_Pseudo = 759,
  UDivIMacro = 760,
  UDivMacro = 761,
  URemIMacro = 762,
  URemMacro = 763,
  Ulh = 764,
  Ulhu = 765,
  Ulw = 766,
  Ush = 767,
  Usw = 768,
  XOR_V_D_PSEUDO = 769,
  XOR_V_H_PSEUDO = 770,
  XOR_V_W_PSEUDO = 771,
  ABSQ_S_PH = 772,
  ABSQ_S_PH_MM = 773,
  ABSQ_S_QB = 774,
  ABSQ_S_QB_MMR2 = 775,
  ABSQ_S_W = 776,
  ABSQ_S_W_MM = 777,
  ADD = 778,
  ADDIUPC = 779,
  ADDIUPC_MM = 780,
  ADDIUPC_MMR6 = 781,
  ADDIUR1SP_MM = 782,
  ADDIUR2_MM = 783,
  ADDIUS5_MM = 784,
  ADDIUSP_MM = 785,
  ADDIU_MMR6 = 786,
  ADDQH_PH = 787,
  ADDQH_PH_MMR2 = 788,
  ADDQH_R_PH = 789,
  ADDQH_R_PH_MMR2 = 790,
  ADDQH_R_W = 791,
  ADDQH_R_W_MMR2 = 792,
  ADDQH_W = 793,
  ADDQH_W_MMR2 = 794,
  ADDQ_PH = 795,
  ADDQ_PH_MM = 796,
  ADDQ_S_PH = 797,
  ADDQ_S_PH_MM = 798,
  ADDQ_S_W = 799,
  ADDQ_S_W_MM = 800,
  ADDR_PS64 = 801,
  ADDSC = 802,
  ADDSC_MM = 803,
  ADDS_A_B = 804,
  ADDS_A_D = 805,
  ADDS_A_H = 806,
  ADDS_A_W = 807,
  ADDS_S_B = 808,
  ADDS_S_D = 809,
  ADDS_S_H = 810,
  ADDS_S_W = 811,
  ADDS_U_B = 812,
  ADDS_U_D = 813,
  ADDS_U_H = 814,
  ADDS_U_W = 815,
  ADDU16_MM = 816,
  ADDU16_MMR6 = 817,
  ADDUH_QB = 818,
  ADDUH_QB_MMR2 = 819,
  ADDUH_R_QB = 820,
  ADDUH_R_QB_MMR2 = 821,
  ADDU_MMR6 = 822,
  ADDU_PH = 823,
  ADDU_PH_MMR2 = 824,
  ADDU_QB = 825,
  ADDU_QB_MM = 826,
  ADDU_S_PH = 827,
  ADDU_S_PH_MMR2 = 828,
  ADDU_S_QB = 829,
  ADDU_S_QB_MM = 830,
  ADDVI_B = 831,
  ADDVI_D = 832,
  ADDVI_H = 833,
  ADDVI_W = 834,
  ADDV_B = 835,
  ADDV_D = 836,
  ADDV_H = 837,
  ADDV_W = 838,
  ADDWC = 839,
  ADDWC_MM = 840,
  ADD_A_B = 841,
  ADD_A_D = 842,
  ADD_A_H = 843,
  ADD_A_W = 844,
  ADD_MM = 845,
  ADD_MMR6 = 846,
  ADDi = 847,
  ADDi_MM = 848,
  ADDiu = 849,
  ADDiu_MM = 850,
  ADDu = 851,
  ADDu_MM = 852,
  ALIGN = 853,
  ALIGN_MMR6 = 854,
  ALUIPC = 855,
  ALUIPC_MMR6 = 856,
  AND = 857,
  AND16_MM = 858,
  AND16_MMR6 = 859,
  AND64 = 860,
  ANDI16_MM = 861,
  ANDI16_MMR6 = 862,
  ANDI_B = 863,
  ANDI_MMR6 = 864,
  AND_MM = 865,
  AND_MMR6 = 866,
  AND_V = 867,
  ANDi = 868,
  ANDi64 = 869,
  ANDi_MM = 870,
  APPEND = 871,
  APPEND_MMR2 = 872,
  ASUB_S_B = 873,
  ASUB_S_D = 874,
  ASUB_S_H = 875,
  ASUB_S_W = 876,
  ASUB_U_B = 877,
  ASUB_U_D = 878,
  ASUB_U_H = 879,
  ASUB_U_W = 880,
  AUI = 881,
  AUIPC = 882,
  AUIPC_MMR6 = 883,
  AUI_MMR6 = 884,
  AVER_S_B = 885,
  AVER_S_D = 886,
  AVER_S_H = 887,
  AVER_S_W = 888,
  AVER_U_B = 889,
  AVER_U_D = 890,
  AVER_U_H = 891,
  AVER_U_W = 892,
  AVE_S_B = 893,
  AVE_S_D = 894,
  AVE_S_H = 895,
  AVE_S_W = 896,
  AVE_U_B = 897,
  AVE_U_D = 898,
  AVE_U_H = 899,
  AVE_U_W = 900,
  AddiuRxImmX16 = 901,
  AddiuRxPcImmX16 = 902,
  AddiuRxRxImm16 = 903,
  AddiuRxRxImmX16 = 904,
  AddiuRxRyOffMemX16 = 905,
  AddiuSpImm16 = 906,
  AddiuSpImmX16 = 907,
  AdduRxRyRz16 = 908,
  AndRxRxRy16 = 909,
  B16_MM = 910,
  BADDu = 911,
  BAL = 912,
  BALC = 913,
  BALC_MMR6 = 914,
  BALIGN = 915,
  BALIGN_MMR2 = 916,
  BBIT0 = 917,
  BBIT032 = 918,
  BBIT1 = 919,
  BBIT132 = 920,
  BC = 921,
  BC16_MMR6 = 922,
  BC1EQZ = 923,
  BC1EQZC_MMR6 = 924,
  BC1F = 925,
  BC1FL = 926,
  BC1F_MM = 927,
  BC1NEZ = 928,
  BC1NEZC_MMR6 = 929,
  BC1T = 930,
  BC1TL = 931,
  BC1T_MM = 932,
  BC2EQZ = 933,
  BC2EQZC_MMR6 = 934,
  BC2NEZ = 935,
  BC2NEZC_MMR6 = 936,
  BCLRI_B = 937,
  BCLRI_D = 938,
  BCLRI_H = 939,
  BCLRI_W = 940,
  BCLR_B = 941,
  BCLR_D = 942,
  BCLR_H = 943,
  BCLR_W = 944,
  BC_MMR6 = 945,
  BEQ = 946,
  BEQ64 = 947,
  BEQC = 948,
  BEQC64 = 949,
  BEQC_MMR6 = 950,
  BEQL = 951,
  BEQZ16_MM = 952,
  BEQZALC = 953,
  BEQZALC_MMR6 = 954,
  BEQZC = 955,
  BEQZC16_MMR6 = 956,
  BEQZC64 = 957,
  BEQZC_MM = 958,
  BEQZC_MMR6 = 959,
  BEQ_MM = 960,
  BGEC = 961,
  BGEC64 = 962,
  BGEC_MMR6 = 963,
  BGEUC = 964,
  BGEUC64 = 965,
  BGEUC_MMR6 = 966,
  BGEZ = 967,
  BGEZ64 = 968,
  BGEZAL = 969,
  BGEZALC = 970,
  BGEZALC_MMR6 = 971,
  BGEZALL = 972,
  BGEZALS_MM = 973,
  BGEZAL_MM = 974,
  BGEZC = 975,
  BGEZC64 = 976,
  BGEZC_MMR6 = 977,
  BGEZL = 978,
  BGEZ_MM = 979,
  BGTZ = 980,
  BGTZ64 = 981,
  BGTZALC = 982,
  BGTZALC_MMR6 = 983,
  BGTZC = 984,
  BGTZC64 = 985,
  BGTZC_MMR6 = 986,
  BGTZL = 987,
  BGTZ_MM = 988,
  BINSLI_B = 989,
  BINSLI_D = 990,
  BINSLI_H = 991,
  BINSLI_W = 992,
  BINSL_B = 993,
  BINSL_D = 994,
  BINSL_H = 995,
  BINSL_W = 996,
  BINSRI_B = 997,
  BINSRI_D = 998,
  BINSRI_H = 999,
  BINSRI_W = 1000,
  BINSR_B = 1001,
  BINSR_D = 1002,
  BINSR_H = 1003,
  BINSR_W = 1004,
  BITREV = 1005,
  BITREV_MM = 1006,
  BITSWAP = 1007,
  BITSWAP_MMR6 = 1008,
  BLEZ = 1009,
  BLEZ64 = 1010,
  BLEZALC = 1011,
  BLEZALC_MMR6 = 1012,
  BLEZC = 1013,
  BLEZC64 = 1014,
  BLEZC_MMR6 = 1015,
  BLEZL = 1016,
  BLEZ_MM = 1017,
  BLTC = 1018,
  BLTC64 = 1019,
  BLTC_MMR6 = 1020,
  BLTUC = 1021,
  BLTUC64 = 1022,
  BLTUC_MMR6 = 1023,
  BLTZ = 1024,
  BLTZ64 = 1025,
  BLTZAL = 1026,
  BLTZALC = 1027,
  BLTZALC_MMR6 = 1028,
  BLTZALL = 1029,
  BLTZALS_MM = 1030,
  BLTZAL_MM = 1031,
  BLTZC = 1032,
  BLTZC64 = 1033,
  BLTZC_MMR6 = 1034,
  BLTZL = 1035,
  BLTZ_MM = 1036,
  BMNZI_B = 1037,
  BMNZ_V = 1038,
  BMZI_B = 1039,
  BMZ_V = 1040,
  BNE = 1041,
  BNE64 = 1042,
  BNEC = 1043,
  BNEC64 = 1044,
  BNEC_MMR6 = 1045,
  BNEGI_B = 1046,
  BNEGI_D = 1047,
  BNEGI_H = 1048,
  BNEGI_W = 1049,
  BNEG_B = 1050,
  BNEG_D = 1051,
  BNEG_H = 1052,
  BNEG_W = 1053,
  BNEL = 1054,
  BNEZ16_MM = 1055,
  BNEZALC = 1056,
  BNEZALC_MMR6 = 1057,
  BNEZC = 1058,
  BNEZC16_MMR6 = 1059,
  BNEZC64 = 1060,
  BNEZC_MM = 1061,
  BNEZC_MMR6 = 1062,
  BNE_MM = 1063,
  BNVC = 1064,
  BNVC_MMR6 = 1065,
  BNZ_B = 1066,
  BNZ_D = 1067,
  BNZ_H = 1068,
  BNZ_V = 1069,
  BNZ_W = 1070,
  BOVC = 1071,
  BOVC_MMR6 = 1072,
  BPOSGE32 = 1073,
  BPOSGE32C_MMR3 = 1074,
  BPOSGE32_MM = 1075,
  BREAK = 1076,
  BREAK16_MM = 1077,
  BREAK16_MMR6 = 1078,
  BREAK_MM = 1079,
  BREAK_MMR6 = 1080,
  BSELI_B = 1081,
  BSEL_V = 1082,
  BSETI_B = 1083,
  BSETI_D = 1084,
  BSETI_H = 1085,
  BSETI_W = 1086,
  BSET_B = 1087,
  BSET_D = 1088,
  BSET_H = 1089,
  BSET_W = 1090,
  BZ_B = 1091,
  BZ_D = 1092,
  BZ_H = 1093,
  BZ_V = 1094,
  BZ_W = 1095,
  BeqzRxImm16 = 1096,
  BeqzRxImmX16 = 1097,
  Bimm16 = 1098,
  BimmX16 = 1099,
  BnezRxImm16 = 1100,
  BnezRxImmX16 = 1101,
  Break16 = 1102,
  Bteqz16 = 1103,
  BteqzX16 = 1104,
  Btnez16 = 1105,
  BtnezX16 = 1106,
  CACHE = 1107,
  CACHEE = 1108,
  CACHEE_MM = 1109,
  CACHE_MM = 1110,
  CACHE_MMR6 = 1111,
  CACHE_R6 = 1112,
  CEIL_L_D64 = 1113,
  CEIL_L_D_MMR6 = 1114,
  CEIL_L_S = 1115,
  CEIL_L_S_MMR6 = 1116,
  CEIL_W_D32 = 1117,
  CEIL_W_D64 = 1118,
  CEIL_W_D_MMR6 = 1119,
  CEIL_W_MM = 1120,
  CEIL_W_S = 1121,
  CEIL_W_S_MM = 1122,
  CEIL_W_S_MMR6 = 1123,
  CEQI_B = 1124,
  CEQI_D = 1125,
  CEQI_H = 1126,
  CEQI_W = 1127,
  CEQ_B = 1128,
  CEQ_D = 1129,
  CEQ_H = 1130,
  CEQ_W = 1131,
  CFC1 = 1132,
  CFC1_MM = 1133,
  CFC2_MM = 1134,
  CFCMSA = 1135,
  CINS = 1136,
  CINS32 = 1137,
  CINS64_32 = 1138,
  CINS_i32 = 1139,
  CLASS_D = 1140,
  CLASS_D_MMR6 = 1141,
  CLASS_S = 1142,
  CLASS_S_MMR6 = 1143,
  CLEI_S_B = 1144,
  CLEI_S_D = 1145,
  CLEI_S_H = 1146,
  CLEI_S_W = 1147,
  CLEI_U_B = 1148,
  CLEI_U_D = 1149,
  CLEI_U_H = 1150,
  CLEI_U_W = 1151,
  CLE_S_B = 1152,
  CLE_S_D = 1153,
  CLE_S_H = 1154,
  CLE_S_W = 1155,
  CLE_U_B = 1156,
  CLE_U_D = 1157,
  CLE_U_H = 1158,
  CLE_U_W = 1159,
  CLO = 1160,
  CLO_MM = 1161,
  CLO_MMR6 = 1162,
  CLO_R6 = 1163,
  CLTI_S_B = 1164,
  CLTI_S_D = 1165,
  CLTI_S_H = 1166,
  CLTI_S_W = 1167,
  CLTI_U_B = 1168,
  CLTI_U_D = 1169,
  CLTI_U_H = 1170,
  CLTI_U_W = 1171,
  CLT_S_B = 1172,
  CLT_S_D = 1173,
  CLT_S_H = 1174,
  CLT_S_W = 1175,
  CLT_U_B = 1176,
  CLT_U_D = 1177,
  CLT_U_H = 1178,
  CLT_U_W = 1179,
  CLZ = 1180,
  CLZ_MM = 1181,
  CLZ_MMR6 = 1182,
  CLZ_R6 = 1183,
  CMPGDU_EQ_QB = 1184,
  CMPGDU_EQ_QB_MMR2 = 1185,
  CMPGDU_LE_QB = 1186,
  CMPGDU_LE_QB_MMR2 = 1187,
  CMPGDU_LT_QB = 1188,
  CMPGDU_LT_QB_MMR2 = 1189,
  CMPGU_EQ_QB = 1190,
  CMPGU_EQ_QB_MM = 1191,
  CMPGU_LE_QB = 1192,
  CMPGU_LE_QB_MM = 1193,
  CMPGU_LT_QB = 1194,
  CMPGU_LT_QB_MM = 1195,
  CMPU_EQ_QB = 1196,
  CMPU_EQ_QB_MM = 1197,
  CMPU_LE_QB = 1198,
  CMPU_LE_QB_MM = 1199,
  CMPU_LT_QB = 1200,
  CMPU_LT_QB_MM = 1201,
  CMP_AF_D_MMR6 = 1202,
  CMP_AF_S_MMR6 = 1203,
  CMP_EQ_D = 1204,
  CMP_EQ_D_MMR6 = 1205,
  CMP_EQ_PH = 1206,
  CMP_EQ_PH_MM = 1207,
  CMP_EQ_S = 1208,
  CMP_EQ_S_MMR6 = 1209,
  CMP_F_D = 1210,
  CMP_F_S = 1211,
  CMP_LE_D = 1212,
  CMP_LE_D_MMR6 = 1213,
  CMP_LE_PH = 1214,
  CMP_LE_PH_MM = 1215,
  CMP_LE_S = 1216,
  CMP_LE_S_MMR6 = 1217,
  CMP_LT_D = 1218,
  CMP_LT_D_MMR6 = 1219,
  CMP_LT_PH = 1220,
  CMP_LT_PH_MM = 1221,
  CMP_LT_S = 1222,
  CMP_LT_S_MMR6 = 1223,
  CMP_SAF_D = 1224,
  CMP_SAF_D_MMR6 = 1225,
  CMP_SAF_S = 1226,
  CMP_SAF_S_MMR6 = 1227,
  CMP_SEQ_D = 1228,
  CMP_SEQ_D_MMR6 = 1229,
  CMP_SEQ_S = 1230,
  CMP_SEQ_S_MMR6 = 1231,
  CMP_SLE_D = 1232,
  CMP_SLE_D_MMR6 = 1233,
  CMP_SLE_S = 1234,
  CMP_SLE_S_MMR6 = 1235,
  CMP_SLT_D = 1236,
  CMP_SLT_D_MMR6 = 1237,
  CMP_SLT_S = 1238,
  CMP_SLT_S_MMR6 = 1239,
  CMP_SUEQ_D = 1240,
  CMP_SUEQ_D_MMR6 = 1241,
  CMP_SUEQ_S = 1242,
  CMP_SUEQ_S_MMR6 = 1243,
  CMP_SULE_D = 1244,
  CMP_SULE_D_MMR6 = 1245,
  CMP_SULE_S = 1246,
  CMP_SULE_S_MMR6 = 1247,
  CMP_SULT_D = 1248,
  CMP_SULT_D_MMR6 = 1249,
  CMP_SULT_S = 1250,
  CMP_SULT_S_MMR6 = 1251,
  CMP_SUN_D = 1252,
  CMP_SUN_D_MMR6 = 1253,
  CMP_SUN_S = 1254,
  CMP_SUN_S_MMR6 = 1255,
  CMP_UEQ_D = 1256,
  CMP_UEQ_D_MMR6 = 1257,
  CMP_UEQ_S = 1258,
  CMP_UEQ_S_MMR6 = 1259,
  CMP_ULE_D = 1260,
  CMP_ULE_D_MMR6 = 1261,
  CMP_ULE_S = 1262,
  CMP_ULE_S_MMR6 = 1263,
  CMP_ULT_D = 1264,
  CMP_ULT_D_MMR6 = 1265,
  CMP_ULT_S = 1266,
  CMP_ULT_S_MMR6 = 1267,
  CMP_UN_D = 1268,
  CMP_UN_D_MMR6 = 1269,
  CMP_UN_S = 1270,
  CMP_UN_S_MMR6 = 1271,
  COPY_S_B = 1272,
  COPY_S_D = 1273,
  COPY_S_H = 1274,
  COPY_S_W = 1275,
  COPY_U_B = 1276,
  COPY_U_H = 1277,
  COPY_U_W = 1278,
  CRC32B = 1279,
  CRC32CB = 1280,
  CRC32CD = 1281,
  CRC32CH = 1282,
  CRC32CW = 1283,
  CRC32D = 1284,
  CRC32H = 1285,
  CRC32W = 1286,
  CTC1 = 1287,
  CTC1_MM = 1288,
  CTC2_MM = 1289,
  CTCMSA = 1290,
  CVT_D32_S = 1291,
  CVT_D32_S_MM = 1292,
  CVT_D32_W = 1293,
  CVT_D32_W_MM = 1294,
  CVT_D64_L = 1295,
  CVT_D64_S = 1296,
  CVT_D64_S_MM = 1297,
  CVT_D64_W = 1298,
  CVT_D64_W_MM = 1299,
  CVT_D_L_MMR6 = 1300,
  CVT_L_D64 = 1301,
  CVT_L_D64_MM = 1302,
  CVT_L_D_MMR6 = 1303,
  CVT_L_S = 1304,
  CVT_L_S_MM = 1305,
  CVT_L_S_MMR6 = 1306,
  CVT_PS_PW64 = 1307,
  CVT_PS_S64 = 1308,
  CVT_PW_PS64 = 1309,
  CVT_S_D32 = 1310,
  CVT_S_D32_MM = 1311,
  CVT_S_D64 = 1312,
  CVT_S_D64_MM = 1313,
  CVT_S_L = 1314,
  CVT_S_L_MMR6 = 1315,
  CVT_S_PL64 = 1316,
  CVT_S_PU64 = 1317,
  CVT_S_W = 1318,
  CVT_S_W_MM = 1319,
  CVT_S_W_MMR6 = 1320,
  CVT_W_D32 = 1321,
  CVT_W_D32_MM = 1322,
  CVT_W_D64 = 1323,
  CVT_W_D64_MM = 1324,
  CVT_W_S = 1325,
  CVT_W_S_MM = 1326,
  CVT_W_S_MMR6 = 1327,
  C_EQ_D32 = 1328,
  C_EQ_D32_MM = 1329,
  C_EQ_D64 = 1330,
  C_EQ_D64_MM = 1331,
  C_EQ_S = 1332,
  C_EQ_S_MM = 1333,
  C_F_D32 = 1334,
  C_F_D32_MM = 1335,
  C_F_D64 = 1336,
  C_F_D64_MM = 1337,
  C_F_S = 1338,
  C_F_S_MM = 1339,
  C_LE_D32 = 1340,
  C_LE_D32_MM = 1341,
  C_LE_D64 = 1342,
  C_LE_D64_MM = 1343,
  C_LE_S = 1344,
  C_LE_S_MM = 1345,
  C_LT_D32 = 1346,
  C_LT_D32_MM = 1347,
  C_LT_D64 = 1348,
  C_LT_D64_MM = 1349,
  C_LT_S = 1350,
  C_LT_S_MM = 1351,
  C_NGE_D32 = 1352,
  C_NGE_D32_MM = 1353,
  C_NGE_D64 = 1354,
  C_NGE_D64_MM = 1355,
  C_NGE_S = 1356,
  C_NGE_S_MM = 1357,
  C_NGLE_D32 = 1358,
  C_NGLE_D32_MM = 1359,
  C_NGLE_D64 = 1360,
  C_NGLE_D64_MM = 1361,
  C_NGLE_S = 1362,
  C_NGLE_S_MM = 1363,
  C_NGL_D32 = 1364,
  C_NGL_D32_MM = 1365,
  C_NGL_D64 = 1366,
  C_NGL_D64_MM = 1367,
  C_NGL_S = 1368,
  C_NGL_S_MM = 1369,
  C_NGT_D32 = 1370,
  C_NGT_D32_MM = 1371,
  C_NGT_D64 = 1372,
  C_NGT_D64_MM = 1373,
  C_NGT_S = 1374,
  C_NGT_S_MM = 1375,
  C_OLE_D32 = 1376,
  C_OLE_D32_MM = 1377,
  C_OLE_D64 = 1378,
  C_OLE_D64_MM = 1379,
  C_OLE_S = 1380,
  C_OLE_S_MM = 1381,
  C_OLT_D32 = 1382,
  C_OLT_D32_MM = 1383,
  C_OLT_D64 = 1384,
  C_OLT_D64_MM = 1385,
  C_OLT_S = 1386,
  C_OLT_S_MM = 1387,
  C_SEQ_D32 = 1388,
  C_SEQ_D32_MM = 1389,
  C_SEQ_D64 = 1390,
  C_SEQ_D64_MM = 1391,
  C_SEQ_S = 1392,
  C_SEQ_S_MM = 1393,
  C_SF_D32 = 1394,
  C_SF_D32_MM = 1395,
  C_SF_D64 = 1396,
  C_SF_D64_MM = 1397,
  C_SF_S = 1398,
  C_SF_S_MM = 1399,
  C_UEQ_D32 = 1400,
  C_UEQ_D32_MM = 1401,
  C_UEQ_D64 = 1402,
  C_UEQ_D64_MM = 1403,
  C_UEQ_S = 1404,
  C_UEQ_S_MM = 1405,
  C_ULE_D32 = 1406,
  C_ULE_D32_MM = 1407,
  C_ULE_D64 = 1408,
  C_ULE_D64_MM = 1409,
  C_ULE_S = 1410,
  C_ULE_S_MM = 1411,
  C_ULT_D32 = 1412,
  C_ULT_D32_MM = 1413,
  C_ULT_D64 = 1414,
  C_ULT_D64_MM = 1415,
  C_ULT_S = 1416,
  C_ULT_S_MM = 1417,
  C_UN_D32 = 1418,
  C_UN_D32_MM = 1419,
  C_UN_D64 = 1420,
  C_UN_D64_MM = 1421,
  C_UN_S = 1422,
  C_UN_S_MM = 1423,
  CmpRxRy16 = 1424,
  CmpiRxImm16 = 1425,
  CmpiRxImmX16 = 1426,
  DADD = 1427,
  DADDi = 1428,
  DADDiu = 1429,
  DADDu = 1430,
  DAHI = 1431,
  DALIGN = 1432,
  DATI = 1433,
  DAUI = 1434,
  DBITSWAP = 1435,
  DCLO = 1436,
  DCLO_R6 = 1437,
  DCLZ = 1438,
  DCLZ_R6 = 1439,
  DDIV = 1440,
  DDIVU = 1441,
  DERET = 1442,
  DERET_MM = 1443,
  DERET_MMR6 = 1444,
  DEXT = 1445,
  DEXT64_32 = 1446,
  DEXTM = 1447,
  DEXTU = 1448,
  DI = 1449,
  DINS = 1450,
  DINSM = 1451,
  DINSU = 1452,
  DIV = 1453,
  DIVU = 1454,
  DIVU_MMR6 = 1455,
  DIV_MMR6 = 1456,
  DIV_S_B = 1457,
  DIV_S_D = 1458,
  DIV_S_H = 1459,
  DIV_S_W = 1460,
  DIV_U_B = 1461,
  DIV_U_D = 1462,
  DIV_U_H = 1463,
  DIV_U_W = 1464,
  DI_MM = 1465,
  DI_MMR6 = 1466,
  DLSA = 1467,
  DLSA_R6 = 1468,
  DMFC0 = 1469,
  DMFC1 = 1470,
  DMFC2 = 1471,
  DMFC2_OCTEON = 1472,
  DMFGC0 = 1473,
  DMOD = 1474,
  DMODU = 1475,
  DMT = 1476,
  DMTC0 = 1477,
  DMTC1 = 1478,
  DMTC2 = 1479,
  DMTC2_OCTEON = 1480,
  DMTGC0 = 1481,
  DMUH = 1482,
  DMUHU = 1483,
  DMUL = 1484,
  DMULT = 1485,
  DMULTu = 1486,
  DMULU = 1487,
  DMUL_R6 = 1488,
  DOTP_S_D = 1489,
  DOTP_S_H = 1490,
  DOTP_S_W = 1491,
  DOTP_U_D = 1492,
  DOTP_U_H = 1493,
  DOTP_U_W = 1494,
  DPADD_S_D = 1495,
  DPADD_S_H = 1496,
  DPADD_S_W = 1497,
  DPADD_U_D = 1498,
  DPADD_U_H = 1499,
  DPADD_U_W = 1500,
  DPAQX_SA_W_PH = 1501,
  DPAQX_SA_W_PH_MMR2 = 1502,
  DPAQX_S_W_PH = 1503,
  DPAQX_S_W_PH_MMR2 = 1504,
  DPAQ_SA_L_W = 1505,
  DPAQ_SA_L_W_MM = 1506,
  DPAQ_S_W_PH = 1507,
  DPAQ_S_W_PH_MM = 1508,
  DPAU_H_QBL = 1509,
  DPAU_H_QBL_MM = 1510,
  DPAU_H_QBR = 1511,
  DPAU_H_QBR_MM = 1512,
  DPAX_W_PH = 1513,
  DPAX_W_PH_MMR2 = 1514,
  DPA_W_PH = 1515,
  DPA_W_PH_MMR2 = 1516,
  DPOP = 1517,
  DPSQX_SA_W_PH = 1518,
  DPSQX_SA_W_PH_MMR2 = 1519,
  DPSQX_S_W_PH = 1520,
  DPSQX_S_W_PH_MMR2 = 1521,
  DPSQ_SA_L_W = 1522,
  DPSQ_SA_L_W_MM = 1523,
  DPSQ_S_W_PH = 1524,
  DPSQ_S_W_PH_MM = 1525,
  DPSUB_S_D = 1526,
  DPSUB_S_H = 1527,
  DPSUB_S_W = 1528,
  DPSUB_U_D = 1529,
  DPSUB_U_H = 1530,
  DPSUB_U_W = 1531,
  DPSU_H_QBL = 1532,
  DPSU_H_QBL_MM = 1533,
  DPSU_H_QBR = 1534,
  DPSU_H_QBR_MM = 1535,
  DPSX_W_PH = 1536,
  DPSX_W_PH_MMR2 = 1537,
  DPS_W_PH = 1538,
  DPS_W_PH_MMR2 = 1539,
  DROTR = 1540,
  DROTR32 = 1541,
  DROTRV = 1542,
  DSBH = 1543,
  DSDIV = 1544,
  DSHD = 1545,
  DSLL = 1546,
  DSLL32 = 1547,
  DSLL64_32 = 1548,
  DSLLV = 1549,
  DSRA = 1550,
  DSRA32 = 1551,
  DSRAV = 1552,
  DSRL = 1553,
  DSRL32 = 1554,
  DSRLV = 1555,
  DSUB = 1556,
  DSUBu = 1557,
  DUDIV = 1558,
  DVP = 1559,
  DVPE = 1560,
  DVP_MMR6 = 1561,
  DivRxRy16 = 1562,
  DivuRxRy16 = 1563,
  EHB = 1564,
  EHB_MM = 1565,
  EHB_MMR6 = 1566,
  EI = 1567,
  EI_MM = 1568,
  EI_MMR6 = 1569,
  EMT = 1570,
  ERET = 1571,
  ERETNC = 1572,
  ERETNC_MMR6 = 1573,
  ERET_MM = 1574,
  ERET_MMR6 = 1575,
  EVP = 1576,
  EVPE = 1577,
  EVP_MMR6 = 1578,
  EXT = 1579,
  EXTP = 1580,
  EXTPDP = 1581,
  EXTPDPV = 1582,
  EXTPDPV_MM = 1583,
  EXTPDP_MM = 1584,
  EXTPV = 1585,
  EXTPV_MM = 1586,
  EXTP_MM = 1587,
  EXTRV_RS_W = 1588,
  EXTRV_RS_W_MM = 1589,
  EXTRV_R_W = 1590,
  EXTRV_R_W_MM = 1591,
  EXTRV_S_H = 1592,
  EXTRV_S_H_MM = 1593,
  EXTRV_W = 1594,
  EXTRV_W_MM = 1595,
  EXTR_RS_W = 1596,
  EXTR_RS_W_MM = 1597,
  EXTR_R_W = 1598,
  EXTR_R_W_MM = 1599,
  EXTR_S_H = 1600,
  EXTR_S_H_MM = 1601,
  EXTR_W = 1602,
  EXTR_W_MM = 1603,
  EXTS = 1604,
  EXTS32 = 1605,
  EXT_MM = 1606,
  EXT_MMR6 = 1607,
  FABS_D32 = 1608,
  FABS_D32_MM = 1609,
  FABS_D64 = 1610,
  FABS_D64_MM = 1611,
  FABS_S = 1612,
  FABS_S_MM = 1613,
  FADD_D = 1614,
  FADD_D32 = 1615,
  FADD_D32_MM = 1616,
  FADD_D64 = 1617,
  FADD_D64_MM = 1618,
  FADD_PS64 = 1619,
  FADD_S = 1620,
  FADD_S_MM = 1621,
  FADD_S_MMR6 = 1622,
  FADD_W = 1623,
  FCAF_D = 1624,
  FCAF_W = 1625,
  FCEQ_D = 1626,
  FCEQ_W = 1627,
  FCLASS_D = 1628,
  FCLASS_W = 1629,
  FCLE_D = 1630,
  FCLE_W = 1631,
  FCLT_D = 1632,
  FCLT_W = 1633,
  FCMP_D32 = 1634,
  FCMP_D32_MM = 1635,
  FCMP_D64 = 1636,
  FCMP_S32 = 1637,
  FCMP_S32_MM = 1638,
  FCNE_D = 1639,
  FCNE_W = 1640,
  FCOR_D = 1641,
  FCOR_W = 1642,
  FCUEQ_D = 1643,
  FCUEQ_W = 1644,
  FCULE_D = 1645,
  FCULE_W = 1646,
  FCULT_D = 1647,
  FCULT_W = 1648,
  FCUNE_D = 1649,
  FCUNE_W = 1650,
  FCUN_D = 1651,
  FCUN_W = 1652,
  FDIV_D = 1653,
  FDIV_D32 = 1654,
  FDIV_D32_MM = 1655,
  FDIV_D64 = 1656,
  FDIV_D64_MM = 1657,
  FDIV_S = 1658,
  FDIV_S_MM = 1659,
  FDIV_S_MMR6 = 1660,
  FDIV_W = 1661,
  FEXDO_H = 1662,
  FEXDO_W = 1663,
  FEXP2_D = 1664,
  FEXP2_W = 1665,
  FEXUPL_D = 1666,
  FEXUPL_W = 1667,
  FEXUPR_D = 1668,
  FEXUPR_W = 1669,
  FFINT_S_D = 1670,
  FFINT_S_W = 1671,
  FFINT_U_D = 1672,
  FFINT_U_W = 1673,
  FFQL_D = 1674,
  FFQL_W = 1675,
  FFQR_D = 1676,
  FFQR_W = 1677,
  FILL_B = 1678,
  FILL_D = 1679,
  FILL_H = 1680,
  FILL_W = 1681,
  FLOG2_D = 1682,
  FLOG2_W = 1683,
  FLOOR_L_D64 = 1684,
  FLOOR_L_D_MMR6 = 1685,
  FLOOR_L_S = 1686,
  FLOOR_L_S_MMR6 = 1687,
  FLOOR_W_D32 = 1688,
  FLOOR_W_D64 = 1689,
  FLOOR_W_D_MMR6 = 1690,
  FLOOR_W_MM = 1691,
  FLOOR_W_S = 1692,
  FLOOR_W_S_MM = 1693,
  FLOOR_W_S_MMR6 = 1694,
  FMADD_D = 1695,
  FMADD_W = 1696,
  FMAX_A_D = 1697,
  FMAX_A_W = 1698,
  FMAX_D = 1699,
  FMAX_W = 1700,
  FMIN_A_D = 1701,
  FMIN_A_W = 1702,
  FMIN_D = 1703,
  FMIN_W = 1704,
  FMOV_D32 = 1705,
  FMOV_D32_MM = 1706,
  FMOV_D64 = 1707,
  FMOV_D64_MM = 1708,
  FMOV_D_MMR6 = 1709,
  FMOV_S = 1710,
  FMOV_S_MM = 1711,
  FMOV_S_MMR6 = 1712,
  FMSUB_D = 1713,
  FMSUB_W = 1714,
  FMUL_D = 1715,
  FMUL_D32 = 1716,
  FMUL_D32_MM = 1717,
  FMUL_D64 = 1718,
  FMUL_D64_MM = 1719,
  FMUL_PS64 = 1720,
  FMUL_S = 1721,
  FMUL_S_MM = 1722,
  FMUL_S_MMR6 = 1723,
  FMUL_W = 1724,
  FNEG_D32 = 1725,
  FNEG_D32_MM = 1726,
  FNEG_D64 = 1727,
  FNEG_D64_MM = 1728,
  FNEG_S = 1729,
  FNEG_S_MM = 1730,
  FNEG_S_MMR6 = 1731,
  FORK = 1732,
  FRCP_D = 1733,
  FRCP_W = 1734,
  FRINT_D = 1735,
  FRINT_W = 1736,
  FRSQRT_D = 1737,
  FRSQRT_W = 1738,
  FSAF_D = 1739,
  FSAF_W = 1740,
  FSEQ_D = 1741,
  FSEQ_W = 1742,
  FSLE_D = 1743,
  FSLE_W = 1744,
  FSLT_D = 1745,
  FSLT_W = 1746,
  FSNE_D = 1747,
  FSNE_W = 1748,
  FSOR_D = 1749,
  FSOR_W = 1750,
  FSQRT_D = 1751,
  FSQRT_D32 = 1752,
  FSQRT_D32_MM = 1753,
  FSQRT_D64 = 1754,
  FSQRT_D64_MM = 1755,
  FSQRT_S = 1756,
  FSQRT_S_MM = 1757,
  FSQRT_W = 1758,
  FSUB_D = 1759,
  FSUB_D32 = 1760,
  FSUB_D32_MM = 1761,
  FSUB_D64 = 1762,
  FSUB_D64_MM = 1763,
  FSUB_PS64 = 1764,
  FSUB_S = 1765,
  FSUB_S_MM = 1766,
  FSUB_S_MMR6 = 1767,
  FSUB_W = 1768,
  FSUEQ_D = 1769,
  FSUEQ_W = 1770,
  FSULE_D = 1771,
  FSULE_W = 1772,
  FSULT_D = 1773,
  FSULT_W = 1774,
  FSUNE_D = 1775,
  FSUNE_W = 1776,
  FSUN_D = 1777,
  FSUN_W = 1778,
  FTINT_S_D = 1779,
  FTINT_S_W = 1780,
  FTINT_U_D = 1781,
  FTINT_U_W = 1782,
  FTQ_H = 1783,
  FTQ_W = 1784,
  FTRUNC_S_D = 1785,
  FTRUNC_S_W = 1786,
  FTRUNC_U_D = 1787,
  FTRUNC_U_W = 1788,
  GINVI = 1789,
  GINVI_MMR6 = 1790,
  GINVT = 1791,
  GINVT_MMR6 = 1792,
  HADD_S_D = 1793,
  HADD_S_H = 1794,
  HADD_S_W = 1795,
  HADD_U_D = 1796,
  HADD_U_H = 1797,
  HADD_U_W = 1798,
  HSUB_S_D = 1799,
  HSUB_S_H = 1800,
  HSUB_S_W = 1801,
  HSUB_U_D = 1802,
  HSUB_U_H = 1803,
  HSUB_U_W = 1804,
  HYPCALL = 1805,
  HYPCALL_MM = 1806,
  ILVEV_B = 1807,
  ILVEV_D = 1808,
  ILVEV_H = 1809,
  ILVEV_W = 1810,
  ILVL_B = 1811,
  ILVL_D = 1812,
  ILVL_H = 1813,
  ILVL_W = 1814,
  ILVOD_B = 1815,
  ILVOD_D = 1816,
  ILVOD_H = 1817,
  ILVOD_W = 1818,
  ILVR_B = 1819,
  ILVR_D = 1820,
  ILVR_H = 1821,
  ILVR_W = 1822,
  INS = 1823,
  INSERT_B = 1824,
  INSERT_D = 1825,
  INSERT_H = 1826,
  INSERT_W = 1827,
  INSV = 1828,
  INSVE_B = 1829,
  INSVE_D = 1830,
  INSVE_H = 1831,
  INSVE_W = 1832,
  INSV_MM = 1833,
  INS_MM = 1834,
  INS_MMR6 = 1835,
  J = 1836,
  JAL = 1837,
  JALR = 1838,
  JALR16_MM = 1839,
  JALR64 = 1840,
  JALRC16_MMR6 = 1841,
  JALRC_HB_MMR6 = 1842,
  JALRC_MMR6 = 1843,
  JALRS16_MM = 1844,
  JALRS_MM = 1845,
  JALR_HB = 1846,
  JALR_HB64 = 1847,
  JALR_MM = 1848,
  JALS_MM = 1849,
  JALX = 1850,
  JALX_MM = 1851,
  JAL_MM = 1852,
  JIALC = 1853,
  JIALC64 = 1854,
  JIALC_MMR6 = 1855,
  JIC = 1856,
  JIC64 = 1857,
  JIC_MMR6 = 1858,
  JR = 1859,
  JR16_MM = 1860,
  JR64 = 1861,
  JRADDIUSP = 1862,
  JRC16_MM = 1863,
  JRC16_MMR6 = 1864,
  JRCADDIUSP_MMR6 = 1865,
  JR_HB = 1866,
  JR_HB64 = 1867,
  JR_HB64_R6 = 1868,
  JR_HB_R6 = 1869,
  JR_MM = 1870,
  J_MM = 1871,
  Jal16 = 1872,
  JalB16 = 1873,
  JrRa16 = 1874,
  JrcRa16 = 1875,
  JrcRx16 = 1876,
  JumpLinkReg16 = 1877,
  LB = 1878,
  LB64 = 1879,
  LBE = 1880,
  LBE_MM = 1881,
  LBU16_MM = 1882,
  LBUX = 1883,
  LBUX_MM = 1884,
  LBU_MMR6 = 1885,
  LB_MM = 1886,
  LB_MMR6 = 1887,
  LBu = 1888,
  LBu64 = 1889,
  LBuE = 1890,
  LBuE_MM = 1891,
  LBu_MM = 1892,
  LD = 1893,
  LDC1 = 1894,
  LDC164 = 1895,
  LDC1_D64_MMR6 = 1896,
  LDC1_MM_D32 = 1897,
  LDC1_MM_D64 = 1898,
  LDC2 = 1899,
  LDC2_MMR6 = 1900,
  LDC2_R6 = 1901,
  LDC3 = 1902,
  LDI_B = 1903,
  LDI_D = 1904,
  LDI_H = 1905,
  LDI_W = 1906,
  LDL = 1907,
  LDPC = 1908,
  LDR = 1909,
  LDXC1 = 1910,
  LDXC164 = 1911,
  LD_B = 1912,
  LD_D = 1913,
  LD_H = 1914,
  LD_W = 1915,
  LEA_ADDiu = 1916,
  LEA_ADDiu64 = 1917,
  LEA_ADDiu_MM = 1918,
  LH = 1919,
  LH64 = 1920,
  LHE = 1921,
  LHE_MM = 1922,
  LHU16_MM = 1923,
  LHX = 1924,
  LHX_MM = 1925,
  LH_MM = 1926,
  LHu = 1927,
  LHu64 = 1928,
  LHuE = 1929,
  LHuE_MM = 1930,
  LHu_MM = 1931,
  LI16_MM = 1932,
  LI16_MMR6 = 1933,
  LL = 1934,
  LL64 = 1935,
  LL64_R6 = 1936,
  LLD = 1937,
  LLD_R6 = 1938,
  LLE = 1939,
  LLE_MM = 1940,
  LL_MM = 1941,
  LL_MMR6 = 1942,
  LL_R6 = 1943,
  LSA = 1944,
  LSA_MMR6 = 1945,
  LSA_R6 = 1946,
  LUI_MMR6 = 1947,
  LUXC1 = 1948,
  LUXC164 = 1949,
  LUXC1_MM = 1950,
  LUi = 1951,
  LUi64 = 1952,
  LUi_MM = 1953,
  LW = 1954,
  LW16_MM = 1955,
  LW64 = 1956,
  LWC1 = 1957,
  LWC1_MM = 1958,
  LWC2 = 1959,
  LWC2_MMR6 = 1960,
  LWC2_R6 = 1961,
  LWC3 = 1962,
  LWDSP = 1963,
  LWDSP_MM = 1964,
  LWE = 1965,
  LWE_MM = 1966,
  LWGP_MM = 1967,
  LWL = 1968,
  LWL64 = 1969,
  LWLE = 1970,
  LWLE_MM = 1971,
  LWL_MM = 1972,
  LWM16_MM = 1973,
  LWM16_MMR6 = 1974,
  LWM32_MM = 1975,
  LWPC = 1976,
  LWPC_MMR6 = 1977,
  LWP_MM = 1978,
  LWR = 1979,
  LWR64 = 1980,
  LWRE = 1981,
  LWRE_MM = 1982,
  LWR_MM = 1983,
  LWSP_MM = 1984,
  LWUPC = 1985,
  LWU_MM = 1986,
  LWX = 1987,
  LWXC1 = 1988,
  LWXC1_MM = 1989,
  LWXS_MM = 1990,
  LWX_MM = 1991,
  LW_MM = 1992,
  LW_MMR6 = 1993,
  LWu = 1994,
  LbRxRyOffMemX16 = 1995,
  LbuRxRyOffMemX16 = 1996,
  LhRxRyOffMemX16 = 1997,
  LhuRxRyOffMemX16 = 1998,
  LiRxImm16 = 1999,
  LiRxImmAlignX16 = 2000,
  LiRxImmX16 = 2001,
  LwRxPcTcp16 = 2002,
  LwRxPcTcpX16 = 2003,
  LwRxRyOffMemX16 = 2004,
  LwRxSpImmX16 = 2005,
  MADD = 2006,
  MADDF_D = 2007,
  MADDF_D_MMR6 = 2008,
  MADDF_S = 2009,
  MADDF_S_MMR6 = 2010,
  MADDR_Q_H = 2011,
  MADDR_Q_W = 2012,
  MADDU = 2013,
  MADDU_DSP = 2014,
  MADDU_DSP_MM = 2015,
  MADDU_MM = 2016,
  MADDV_B = 2017,
  MADDV_D = 2018,
  MADDV_H = 2019,
  MADDV_W = 2020,
  MADD_D32 = 2021,
  MADD_D32_MM = 2022,
  MADD_D64 = 2023,
  MADD_DSP = 2024,
  MADD_DSP_MM = 2025,
  MADD_MM = 2026,
  MADD_Q_H = 2027,
  MADD_Q_W = 2028,
  MADD_S = 2029,
  MADD_S_MM = 2030,
  MAQ_SA_W_PHL = 2031,
  MAQ_SA_W_PHL_MM = 2032,
  MAQ_SA_W_PHR = 2033,
  MAQ_SA_W_PHR_MM = 2034,
  MAQ_S_W_PHL = 2035,
  MAQ_S_W_PHL_MM = 2036,
  MAQ_S_W_PHR = 2037,
  MAQ_S_W_PHR_MM = 2038,
  MAXA_D = 2039,
  MAXA_D_MMR6 = 2040,
  MAXA_S = 2041,
  MAXA_S_MMR6 = 2042,
  MAXI_S_B = 2043,
  MAXI_S_D = 2044,
  MAXI_S_H = 2045,
  MAXI_S_W = 2046,
  MAXI_U_B = 2047,
  MAXI_U_D = 2048,
  MAXI_U_H = 2049,
  MAXI_U_W = 2050,
  MAX_A_B = 2051,
  MAX_A_D = 2052,
  MAX_A_H = 2053,
  MAX_A_W = 2054,
  MAX_D = 2055,
  MAX_D_MMR6 = 2056,
  MAX_S = 2057,
  MAX_S_B = 2058,
  MAX_S_D = 2059,
  MAX_S_H = 2060,
  MAX_S_MMR6 = 2061,
  MAX_S_W = 2062,
  MAX_U_B = 2063,
  MAX_U_D = 2064,
  MAX_U_H = 2065,
  MAX_U_W = 2066,
  MFC0 = 2067,
  MFC0_MMR6 = 2068,
  MFC1 = 2069,
  MFC1_D64 = 2070,
  MFC1_MM = 2071,
  MFC1_MMR6 = 2072,
  MFC2 = 2073,
  MFC2_MMR6 = 2074,
  MFGC0 = 2075,
  MFGC0_MM = 2076,
  MFHC0_MMR6 = 2077,
  MFHC1_D32 = 2078,
  MFHC1_D32_MM = 2079,
  MFHC1_D64 = 2080,
  MFHC1_D64_MM = 2081,
  MFHC2_MMR6 = 2082,
  MFHGC0 = 2083,
  MFHGC0_MM = 2084,
  MFHI = 2085,
  MFHI16_MM = 2086,
  MFHI64 = 2087,
  MFHI_DSP = 2088,
  MFHI_DSP_MM = 2089,
  MFHI_MM = 2090,
  MFLO = 2091,
  MFLO16_MM = 2092,
  MFLO64 = 2093,
  MFLO_DSP = 2094,
  MFLO_DSP_MM = 2095,
  MFLO_MM = 2096,
  MFTR = 2097,
  MINA_D = 2098,
  MINA_D_MMR6 = 2099,
  MINA_S = 2100,
  MINA_S_MMR6 = 2101,
  MINI_S_B = 2102,
  MINI_S_D = 2103,
  MINI_S_H = 2104,
  MINI_S_W = 2105,
  MINI_U_B = 2106,
  MINI_U_D = 2107,
  MINI_U_H = 2108,
  MINI_U_W = 2109,
  MIN_A_B = 2110,
  MIN_A_D = 2111,
  MIN_A_H = 2112,
  MIN_A_W = 2113,
  MIN_D = 2114,
  MIN_D_MMR6 = 2115,
  MIN_S = 2116,
  MIN_S_B = 2117,
  MIN_S_D = 2118,
  MIN_S_H = 2119,
  MIN_S_MMR6 = 2120,
  MIN_S_W = 2121,
  MIN_U_B = 2122,
  MIN_U_D = 2123,
  MIN_U_H = 2124,
  MIN_U_W = 2125,
  MOD = 2126,
  MODSUB = 2127,
  MODSUB_MM = 2128,
  MODU = 2129,
  MODU_MMR6 = 2130,
  MOD_MMR6 = 2131,
  MOD_S_B = 2132,
  MOD_S_D = 2133,
  MOD_S_H = 2134,
  MOD_S_W = 2135,
  MOD_U_B = 2136,
  MOD_U_D = 2137,
  MOD_U_H = 2138,
  MOD_U_W = 2139,
  MOVE16_MM = 2140,
  MOVE16_MMR6 = 2141,
  MOVEP_MM = 2142,
  MOVEP_MMR6 = 2143,
  MOVE_V = 2144,
  MOVF_D32 = 2145,
  MOVF_D32_MM = 2146,
  MOVF_D64 = 2147,
  MOVF_I = 2148,
  MOVF_I64 = 2149,
  MOVF_I_MM = 2150,
  MOVF_S = 2151,
  MOVF_S_MM = 2152,
  MOVN_I64_D64 = 2153,
  MOVN_I64_I = 2154,
  MOVN_I64_I64 = 2155,
  MOVN_I64_S = 2156,
  MOVN_I_D32 = 2157,
  MOVN_I_D32_MM = 2158,
  MOVN_I_D64 = 2159,
  MOVN_I_I = 2160,
  MOVN_I_I64 = 2161,
  MOVN_I_MM = 2162,
  MOVN_I_S = 2163,
  MOVN_I_S_MM = 2164,
  MOVT_D32 = 2165,
  MOVT_D32_MM = 2166,
  MOVT_D64 = 2167,
  MOVT_I = 2168,
  MOVT_I64 = 2169,
  MOVT_I_MM = 2170,
  MOVT_S = 2171,
  MOVT_S_MM = 2172,
  MOVZ_I64_D64 = 2173,
  MOVZ_I64_I = 2174,
  MOVZ_I64_I64 = 2175,
  MOVZ_I64_S = 2176,
  MOVZ_I_D32 = 2177,
  MOVZ_I_D32_MM = 2178,
  MOVZ_I_D64 = 2179,
  MOVZ_I_I = 2180,
  MOVZ_I_I64 = 2181,
  MOVZ_I_MM = 2182,
  MOVZ_I_S = 2183,
  MOVZ_I_S_MM = 2184,
  MSUB = 2185,
  MSUBF_D = 2186,
  MSUBF_D_MMR6 = 2187,
  MSUBF_S = 2188,
  MSUBF_S_MMR6 = 2189,
  MSUBR_Q_H = 2190,
  MSUBR_Q_W = 2191,
  MSUBU = 2192,
  MSUBU_DSP = 2193,
  MSUBU_DSP_MM = 2194,
  MSUBU_MM = 2195,
  MSUBV_B = 2196,
  MSUBV_D = 2197,
  MSUBV_H = 2198,
  MSUBV_W = 2199,
  MSUB_D32 = 2200,
  MSUB_D32_MM = 2201,
  MSUB_D64 = 2202,
  MSUB_DSP = 2203,
  MSUB_DSP_MM = 2204,
  MSUB_MM = 2205,
  MSUB_Q_H = 2206,
  MSUB_Q_W = 2207,
  MSUB_S = 2208,
  MSUB_S_MM = 2209,
  MTC0 = 2210,
  MTC0_MMR6 = 2211,
  MTC1 = 2212,
  MTC1_D64 = 2213,
  MTC1_D64_MM = 2214,
  MTC1_MM = 2215,
  MTC1_MMR6 = 2216,
  MTC2 = 2217,
  MTC2_MMR6 = 2218,
  MTGC0 = 2219,
  MTGC0_MM = 2220,
  MTHC0_MMR6 = 2221,
  MTHC1_D32 = 2222,
  MTHC1_D32_MM = 2223,
  MTHC1_D64 = 2224,
  MTHC1_D64_MM = 2225,
  MTHC2_MMR6 = 2226,
  MTHGC0 = 2227,
  MTHGC0_MM = 2228,
  MTHI = 2229,
  MTHI64 = 2230,
  MTHI_DSP = 2231,
  MTHI_DSP_MM = 2232,
  MTHI_MM = 2233,
  MTHLIP = 2234,
  MTHLIP_MM = 2235,
  MTLO = 2236,
  MTLO64 = 2237,
  MTLO_DSP = 2238,
  MTLO_DSP_MM = 2239,
  MTLO_MM = 2240,
  MTM0 = 2241,
  MTM1 = 2242,
  MTM2 = 2243,
  MTP0 = 2244,
  MTP1 = 2245,
  MTP2 = 2246,
  MTTR = 2247,
  MUH = 2248,
  MUHU = 2249,
  MUHU_MMR6 = 2250,
  MUH_MMR6 = 2251,
  MUL = 2252,
  MULEQ_S_W_PHL = 2253,
  MULEQ_S_W_PHL_MM = 2254,
  MULEQ_S_W_PHR = 2255,
  MULEQ_S_W_PHR_MM = 2256,
  MULEU_S_PH_QBL = 2257,
  MULEU_S_PH_QBL_MM = 2258,
  MULEU_S_PH_QBR = 2259,
  MULEU_S_PH_QBR_MM = 2260,
  MULQ_RS_PH = 2261,
  MULQ_RS_PH_MM = 2262,
  MULQ_RS_W = 2263,
  MULQ_RS_W_MMR2 = 2264,
  MULQ_S_PH = 2265,
  MULQ_S_PH_MMR2 = 2266,
  MULQ_S_W = 2267,
  MULQ_S_W_MMR2 = 2268,
  MULR_PS64 = 2269,
  MULR_Q_H = 2270,
  MULR_Q_W = 2271,
  MULSAQ_S_W_PH = 2272,
  MULSAQ_S_W_PH_MM = 2273,
  MULSA_W_PH = 2274,
  MULSA_W_PH_MMR2 = 2275,
  MULT = 2276,
  MULTU_DSP = 2277,
  MULTU_DSP_MM = 2278,
  MULT_DSP = 2279,
  MULT_DSP_MM = 2280,
  MULT_MM = 2281,
  MULTu = 2282,
  MULTu_MM = 2283,
  MULU = 2284,
  MULU_MMR6 = 2285,
  MULV_B = 2286,
  MULV_D = 2287,
  MULV_H = 2288,
  MULV_W = 2289,
  MUL_MM = 2290,
  MUL_MMR6 = 2291,
  MUL_PH = 2292,
  MUL_PH_MMR2 = 2293,
  MUL_Q_H = 2294,
  MUL_Q_W = 2295,
  MUL_R6 = 2296,
  MUL_S_PH = 2297,
  MUL_S_PH_MMR2 = 2298,
  Mfhi16 = 2299,
  Mflo16 = 2300,
  Move32R16 = 2301,
  MoveR3216 = 2302,
  NAL = 2303,
  NLOC_B = 2304,
  NLOC_D = 2305,
  NLOC_H = 2306,
  NLOC_W = 2307,
  NLZC_B = 2308,
  NLZC_D = 2309,
  NLZC_H = 2310,
  NLZC_W = 2311,
  NMADD_D32 = 2312,
  NMADD_D32_MM = 2313,
  NMADD_D64 = 2314,
  NMADD_S = 2315,
  NMADD_S_MM = 2316,
  NMSUB_D32 = 2317,
  NMSUB_D32_MM = 2318,
  NMSUB_D64 = 2319,
  NMSUB_S = 2320,
  NMSUB_S_MM = 2321,
  NOR = 2322,
  NOR64 = 2323,
  NORI_B = 2324,
  NOR_MM = 2325,
  NOR_MMR6 = 2326,
  NOR_V = 2327,
  NOT16_MM = 2328,
  NOT16_MMR6 = 2329,
  NegRxRy16 = 2330,
  NotRxRy16 = 2331,
  OR = 2332,
  OR16_MM = 2333,
  OR16_MMR6 = 2334,
  OR64 = 2335,
  ORI_B = 2336,
  ORI_MMR6 = 2337,
  OR_MM = 2338,
  OR_MMR6 = 2339,
  OR_V = 2340,
  ORi = 2341,
  ORi64 = 2342,
  ORi_MM = 2343,
  OrRxRxRy16 = 2344,
  PACKRL_PH = 2345,
  PACKRL_PH_MM = 2346,
  PAUSE = 2347,
  PAUSE_MM = 2348,
  PAUSE_MMR6 = 2349,
  PCKEV_B = 2350,
  PCKEV_D = 2351,
  PCKEV_H = 2352,
  PCKEV_W = 2353,
  PCKOD_B = 2354,
  PCKOD_D = 2355,
  PCKOD_H = 2356,
  PCKOD_W = 2357,
  PCNT_B = 2358,
  PCNT_D = 2359,
  PCNT_H = 2360,
  PCNT_W = 2361,
  PICK_PH = 2362,
  PICK_PH_MM = 2363,
  PICK_QB = 2364,
  PICK_QB_MM = 2365,
  PLL_PS64 = 2366,
  PLU_PS64 = 2367,
  POP = 2368,
  PRECEQU_PH_QBL = 2369,
  PRECEQU_PH_QBLA = 2370,
  PRECEQU_PH_QBLA_MM = 2371,
  PRECEQU_PH_QBL_MM = 2372,
  PRECEQU_PH_QBR = 2373,
  PRECEQU_PH_QBRA = 2374,
  PRECEQU_PH_QBRA_MM = 2375,
  PRECEQU_PH_QBR_MM = 2376,
  PRECEQ_W_PHL = 2377,
  PRECEQ_W_PHL_MM = 2378,
  PRECEQ_W_PHR = 2379,
  PRECEQ_W_PHR_MM = 2380,
  PRECEU_PH_QBL = 2381,
  PRECEU_PH_QBLA = 2382,
  PRECEU_PH_QBLA_MM = 2383,
  PRECEU_PH_QBL_MM = 2384,
  PRECEU_PH_QBR = 2385,
  PRECEU_PH_QBRA = 2386,
  PRECEU_PH_QBRA_MM = 2387,
  PRECEU_PH_QBR_MM = 2388,
  PRECRQU_S_QB_PH = 2389,
  PRECRQU_S_QB_PH_MM = 2390,
  PRECRQ_PH_W = 2391,
  PRECRQ_PH_W_MM = 2392,
  PRECRQ_QB_PH = 2393,
  PRECRQ_QB_PH_MM = 2394,
  PRECRQ_RS_PH_W = 2395,
  PRECRQ_RS_PH_W_MM = 2396,
  PRECR_QB_PH = 2397,
  PRECR_QB_PH_MMR2 = 2398,
  PRECR_SRA_PH_W = 2399,
  PRECR_SRA_PH_W_MMR2 = 2400,
  PRECR_SRA_R_PH_W = 2401,
  PRECR_SRA_R_PH_W_MMR2 = 2402,
  PREF = 2403,
  PREFE = 2404,
  PREFE_MM = 2405,
  PREFX_MM = 2406,
  PREF_MM = 2407,
  PREF_MMR6 = 2408,
  PREF_R6 = 2409,
  PREPEND = 2410,
  PREPEND_MMR2 = 2411,
  PUL_PS64 = 2412,
  PUU_PS64 = 2413,
  RADDU_W_QB = 2414,
  RADDU_W_QB_MM = 2415,
  RDDSP = 2416,
  RDDSP_MM = 2417,
  RDHWR = 2418,
  RDHWR64 = 2419,
  RDHWR_MM = 2420,
  RDHWR_MMR6 = 2421,
  RDPGPR_MMR6 = 2422,
  RECIP_D32 = 2423,
  RECIP_D32_MM = 2424,
  RECIP_D64 = 2425,
  RECIP_D64_MM = 2426,
  RECIP_S = 2427,
  RECIP_S_MM = 2428,
  REPLV_PH = 2429,
  REPLV_PH_MM = 2430,
  REPLV_QB = 2431,
  REPLV_QB_MM = 2432,
  REPL_PH = 2433,
  REPL_PH_MM = 2434,
  REPL_QB = 2435,
  REPL_QB_MM = 2436,
  RINT_D = 2437,
  RINT_D_MMR6 = 2438,
  RINT_S = 2439,
  RINT_S_MMR6 = 2440,
  ROTR = 2441,
  ROTRV = 2442,
  ROTRV_MM = 2443,
  ROTR_MM = 2444,
  ROUND_L_D64 = 2445,
  ROUND_L_D_MMR6 = 2446,
  ROUND_L_S = 2447,
  ROUND_L_S_MMR6 = 2448,
  ROUND_W_D32 = 2449,
  ROUND_W_D64 = 2450,
  ROUND_W_D_MMR6 = 2451,
  ROUND_W_MM = 2452,
  ROUND_W_S = 2453,
  ROUND_W_S_MM = 2454,
  ROUND_W_S_MMR6 = 2455,
  RSQRT_D32 = 2456,
  RSQRT_D32_MM = 2457,
  RSQRT_D64 = 2458,
  RSQRT_D64_MM = 2459,
  RSQRT_S = 2460,
  RSQRT_S_MM = 2461,
  Restore16 = 2462,
  RestoreX16 = 2463,
  SAA = 2464,
  SAAD = 2465,
  SAT_S_B = 2466,
  SAT_S_D = 2467,
  SAT_S_H = 2468,
  SAT_S_W = 2469,
  SAT_U_B = 2470,
  SAT_U_D = 2471,
  SAT_U_H = 2472,
  SAT_U_W = 2473,
  SB = 2474,
  SB16_MM = 2475,
  SB16_MMR6 = 2476,
  SB64 = 2477,
  SBE = 2478,
  SBE_MM = 2479,
  SB_MM = 2480,
  SB_MMR6 = 2481,
  SC = 2482,
  SC64 = 2483,
  SC64_R6 = 2484,
  SCD = 2485,
  SCD_R6 = 2486,
  SCE = 2487,
  SCE_MM = 2488,
  SC_MM = 2489,
  SC_MMR6 = 2490,
  SC_R6 = 2491,
  SD = 2492,
  SDBBP = 2493,
  SDBBP16_MM = 2494,
  SDBBP16_MMR6 = 2495,
  SDBBP_MM = 2496,
  SDBBP_MMR6 = 2497,
  SDBBP_R6 = 2498,
  SDC1 = 2499,
  SDC164 = 2500,
  SDC1_D64_MMR6 = 2501,
  SDC1_MM_D32 = 2502,
  SDC1_MM_D64 = 2503,
  SDC2 = 2504,
  SDC2_MMR6 = 2505,
  SDC2_R6 = 2506,
  SDC3 = 2507,
  SDIV = 2508,
  SDIV_MM = 2509,
  SDL = 2510,
  SDR = 2511,
  SDXC1 = 2512,
  SDXC164 = 2513,
  SEB = 2514,
  SEB64 = 2515,
  SEB_MM = 2516,
  SEH = 2517,
  SEH64 = 2518,
  SEH_MM = 2519,
  SELEQZ = 2520,
  SELEQZ64 = 2521,
  SELEQZ_D = 2522,
  SELEQZ_D_MMR6 = 2523,
  SELEQZ_MMR6 = 2524,
  SELEQZ_S = 2525,
  SELEQZ_S_MMR6 = 2526,
  SELNEZ = 2527,
  SELNEZ64 = 2528,
  SELNEZ_D = 2529,
  SELNEZ_D_MMR6 = 2530,
  SELNEZ_MMR6 = 2531,
  SELNEZ_S = 2532,
  SELNEZ_S_MMR6 = 2533,
  SEL_D = 2534,
  SEL_D_MMR6 = 2535,
  SEL_S = 2536,
  SEL_S_MMR6 = 2537,
  SEQ = 2538,
  SEQi = 2539,
  SH = 2540,
  SH16_MM = 2541,
  SH16_MMR6 = 2542,
  SH64 = 2543,
  SHE = 2544,
  SHE_MM = 2545,
  SHF_B = 2546,
  SHF_H = 2547,
  SHF_W = 2548,
  SHILO = 2549,
  SHILOV = 2550,
  SHILOV_MM = 2551,
  SHILO_MM = 2552,
  SHLLV_PH = 2553,
  SHLLV_PH_MM = 2554,
  SHLLV_QB = 2555,
  SHLLV_QB_MM = 2556,
  SHLLV_S_PH = 2557,
  SHLLV_S_PH_MM = 2558,
  SHLLV_S_W = 2559,
  SHLLV_S_W_MM = 2560,
  SHLL_PH = 2561,
  SHLL_PH_MM = 2562,
  SHLL_QB = 2563,
  SHLL_QB_MM = 2564,
  SHLL_S_PH = 2565,
  SHLL_S_PH_MM = 2566,
  SHLL_S_W = 2567,
  SHLL_S_W_MM = 2568,
  SHRAV_PH = 2569,
  SHRAV_PH_MM = 2570,
  SHRAV_QB = 2571,
  SHRAV_QB_MMR2 = 2572,
  SHRAV_R_PH = 2573,
  SHRAV_R_PH_MM = 2574,
  SHRAV_R_QB = 2575,
  SHRAV_R_QB_MMR2 = 2576,
  SHRAV_R_W = 2577,
  SHRAV_R_W_MM = 2578,
  SHRA_PH = 2579,
  SHRA_PH_MM = 2580,
  SHRA_QB = 2581,
  SHRA_QB_MMR2 = 2582,
  SHRA_R_PH = 2583,
  SHRA_R_PH_MM = 2584,
  SHRA_R_QB = 2585,
  SHRA_R_QB_MMR2 = 2586,
  SHRA_R_W = 2587,
  SHRA_R_W_MM = 2588,
  SHRLV_PH = 2589,
  SHRLV_PH_MMR2 = 2590,
  SHRLV_QB = 2591,
  SHRLV_QB_MM = 2592,
  SHRL_PH = 2593,
  SHRL_PH_MMR2 = 2594,
  SHRL_QB = 2595,
  SHRL_QB_MM = 2596,
  SH_MM = 2597,
  SH_MMR6 = 2598,
  SIGRIE = 2599,
  SIGRIE_MMR6 = 2600,
  SLDI_B = 2601,
  SLDI_D = 2602,
  SLDI_H = 2603,
  SLDI_W = 2604,
  SLD_B = 2605,
  SLD_D = 2606,
  SLD_H = 2607,
  SLD_W = 2608,
  SLL = 2609,
  SLL16_MM = 2610,
  SLL16_MMR6 = 2611,
  SLL64_32 = 2612,
  SLL64_64 = 2613,
  SLLI_B = 2614,
  SLLI_D = 2615,
  SLLI_H = 2616,
  SLLI_W = 2617,
  SLLV = 2618,
  SLLV_MM = 2619,
  SLL_B = 2620,
  SLL_D = 2621,
  SLL_H = 2622,
  SLL_MM = 2623,
  SLL_MMR6 = 2624,
  SLL_W = 2625,
  SLT = 2626,
  SLT64 = 2627,
  SLT_MM = 2628,
  SLTi = 2629,
  SLTi64 = 2630,
  SLTi_MM = 2631,
  SLTiu = 2632,
  SLTiu64 = 2633,
  SLTiu_MM = 2634,
  SLTu = 2635,
  SLTu64 = 2636,
  SLTu_MM = 2637,
  SNE = 2638,
  SNEi = 2639,
  SPLATI_B = 2640,
  SPLATI_D = 2641,
  SPLATI_H = 2642,
  SPLATI_W = 2643,
  SPLAT_B = 2644,
  SPLAT_D = 2645,
  SPLAT_H = 2646,
  SPLAT_W = 2647,
  SRA = 2648,
  SRAI_B = 2649,
  SRAI_D = 2650,
  SRAI_H = 2651,
  SRAI_W = 2652,
  SRARI_B = 2653,
  SRARI_D = 2654,
  SRARI_H = 2655,
  SRARI_W = 2656,
  SRAR_B = 2657,
  SRAR_D = 2658,
  SRAR_H = 2659,
  SRAR_W = 2660,
  SRAV = 2661,
  SRAV_MM = 2662,
  SRA_B = 2663,
  SRA_D = 2664,
  SRA_H = 2665,
  SRA_MM = 2666,
  SRA_W = 2667,
  SRL = 2668,
  SRL16_MM = 2669,
  SRL16_MMR6 = 2670,
  SRLI_B = 2671,
  SRLI_D = 2672,
  SRLI_H = 2673,
  SRLI_W = 2674,
  SRLRI_B = 2675,
  SRLRI_D = 2676,
  SRLRI_H = 2677,
  SRLRI_W = 2678,
  SRLR_B = 2679,
  SRLR_D = 2680,
  SRLR_H = 2681,
  SRLR_W = 2682,
  SRLV = 2683,
  SRLV_MM = 2684,
  SRL_B = 2685,
  SRL_D = 2686,
  SRL_H = 2687,
  SRL_MM = 2688,
  SRL_W = 2689,
  SSNOP = 2690,
  SSNOP_MM = 2691,
  SSNOP_MMR6 = 2692,
  ST_B = 2693,
  ST_D = 2694,
  ST_H = 2695,
  ST_W = 2696,
  SUB = 2697,
  SUBQH_PH = 2698,
  SUBQH_PH_MMR2 = 2699,
  SUBQH_R_PH = 2700,
  SUBQH_R_PH_MMR2 = 2701,
  SUBQH_R_W = 2702,
  SUBQH_R_W_MMR2 = 2703,
  SUBQH_W = 2704,
  SUBQH_W_MMR2 = 2705,
  SUBQ_PH = 2706,
  SUBQ_PH_MM = 2707,
  SUBQ_S_PH = 2708,
  SUBQ_S_PH_MM = 2709,
  SUBQ_S_W = 2710,
  SUBQ_S_W_MM = 2711,
  SUBSUS_U_B = 2712,
  SUBSUS_U_D = 2713,
  SUBSUS_U_H = 2714,
  SUBSUS_U_W = 2715,
  SUBSUU_S_B = 2716,
  SUBSUU_S_D = 2717,
  SUBSUU_S_H = 2718,
  SUBSUU_S_W = 2719,
  SUBS_S_B = 2720,
  SUBS_S_D = 2721,
  SUBS_S_H = 2722,
  SUBS_S_W = 2723,
  SUBS_U_B = 2724,
  SUBS_U_D = 2725,
  SUBS_U_H = 2726,
  SUBS_U_W = 2727,
  SUBU16_MM = 2728,
  SUBU16_MMR6 = 2729,
  SUBUH_QB = 2730,
  SUBUH_QB_MMR2 = 2731,
  SUBUH_R_QB = 2732,
  SUBUH_R_QB_MMR2 = 2733,
  SUBU_MMR6 = 2734,
  SUBU_PH = 2735,
  SUBU_PH_MMR2 = 2736,
  SUBU_QB = 2737,
  SUBU_QB_MM = 2738,
  SUBU_S_PH = 2739,
  SUBU_S_PH_MMR2 = 2740,
  SUBU_S_QB = 2741,
  SUBU_S_QB_MM = 2742,
  SUBVI_B = 2743,
  SUBVI_D = 2744,
  SUBVI_H = 2745,
  SUBVI_W = 2746,
  SUBV_B = 2747,
  SUBV_D = 2748,
  SUBV_H = 2749,
  SUBV_W = 2750,
  SUB_MM = 2751,
  SUB_MMR6 = 2752,
  SUBu = 2753,
  SUBu_MM = 2754,
  SUXC1 = 2755,
  SUXC164 = 2756,
  SUXC1_MM = 2757,
  SW = 2758,
  SW16_MM = 2759,
  SW16_MMR6 = 2760,
  SW64 = 2761,
  SWC1 = 2762,
  SWC1_MM = 2763,
  SWC2 = 2764,
  SWC2_MMR6 = 2765,
  SWC2_R6 = 2766,
  SWC3 = 2767,
  SWDSP = 2768,
  SWDSP_MM = 2769,
  SWE = 2770,
  SWE_MM = 2771,
  SWL = 2772,
  SWL64 = 2773,
  SWLE = 2774,
  SWLE_MM = 2775,
  SWL_MM = 2776,
  SWM16_MM = 2777,
  SWM16_MMR6 = 2778,
  SWM32_MM = 2779,
  SWP_MM = 2780,
  SWR = 2781,
  SWR64 = 2782,
  SWRE = 2783,
  SWRE_MM = 2784,
  SWR_MM = 2785,
  SWSP_MM = 2786,
  SWSP_MMR6 = 2787,
  SWXC1 = 2788,
  SWXC1_MM = 2789,
  SW_MM = 2790,
  SW_MMR6 = 2791,
  SYNC = 2792,
  SYNCI = 2793,
  SYNCI_MM = 2794,
  SYNCI_MMR6 = 2795,
  SYNC_MM = 2796,
  SYNC_MMR6 = 2797,
  SYSCALL = 2798,
  SYSCALL_MM = 2799,
  Save16 = 2800,
  SaveX16 = 2801,
  SbRxRyOffMemX16 = 2802,
  SebRx16 = 2803,
  SehRx16 = 2804,
  ShRxRyOffMemX16 = 2805,
  SllX16 = 2806,
  SllvRxRy16 = 2807,
  SltRxRy16 = 2808,
  SltiRxImm16 = 2809,
  SltiRxImmX16 = 2810,
  SltiuRxImm16 = 2811,
  SltiuRxImmX16 = 2812,
  SltuRxRy16 = 2813,
  SraX16 = 2814,
  SravRxRy16 = 2815,
  SrlX16 = 2816,
  SrlvRxRy16 = 2817,
  SubuRxRyRz16 = 2818,
  SwRxRyOffMemX16 = 2819,
  SwRxSpImmX16 = 2820,
  TEQ = 2821,
  TEQI = 2822,
  TEQI_MM = 2823,
  TEQ_MM = 2824,
  TGE = 2825,
  TGEI = 2826,
  TGEIU = 2827,
  TGEIU_MM = 2828,
  TGEI_MM = 2829,
  TGEU = 2830,
  TGEU_MM = 2831,
  TGE_MM = 2832,
  TLBGINV = 2833,
  TLBGINVF = 2834,
  TLBGINVF_MM = 2835,
  TLBGINV_MM = 2836,
  TLBGP = 2837,
  TLBGP_MM = 2838,
  TLBGR = 2839,
  TLBGR_MM = 2840,
  TLBGWI = 2841,
  TLBGWI_MM = 2842,
  TLBGWR = 2843,
  TLBGWR_MM = 2844,
  TLBINV = 2845,
  TLBINVF = 2846,
  TLBINVF_MMR6 = 2847,
  TLBINV_MMR6 = 2848,
  TLBP = 2849,
  TLBP_MM = 2850,
  TLBR = 2851,
  TLBR_MM = 2852,
  TLBWI = 2853,
  TLBWI_MM = 2854,
  TLBWR = 2855,
  TLBWR_MM = 2856,
  TLT = 2857,
  TLTI = 2858,
  TLTIU_MM = 2859,
  TLTI_MM = 2860,
  TLTU = 2861,
  TLTU_MM = 2862,
  TLT_MM = 2863,
  TNE = 2864,
  TNEI = 2865,
  TNEI_MM = 2866,
  TNE_MM = 2867,
  TRUNC_L_D64 = 2868,
  TRUNC_L_D_MMR6 = 2869,
  TRUNC_L_S = 2870,
  TRUNC_L_S_MMR6 = 2871,
  TRUNC_W_D32 = 2872,
  TRUNC_W_D64 = 2873,
  TRUNC_W_D_MMR6 = 2874,
  TRUNC_W_MM = 2875,
  TRUNC_W_S = 2876,
  TRUNC_W_S_MM = 2877,
  TRUNC_W_S_MMR6 = 2878,
  TTLTIU = 2879,
  UDIV = 2880,
  UDIV_MM = 2881,
  V3MULU = 2882,
  VMM0 = 2883,
  VMULU = 2884,
  VSHF_B = 2885,
  VSHF_D = 2886,
  VSHF_H = 2887,
  VSHF_W = 2888,
  WAIT = 2889,
  WAIT_MM = 2890,
  WAIT_MMR6 = 2891,
  WRDSP = 2892,
  WRDSP_MM = 2893,
  WRPGPR_MMR6 = 2894,
  WSBH = 2895,
  WSBH_MM = 2896,
  WSBH_MMR6 = 2897,
  XOR = 2898,
  XOR16_MM = 2899,
  XOR16_MMR6 = 2900,
  XOR64 = 2901,
  XORI_B = 2902,
  XORI_MMR6 = 2903,
  XOR_MM = 2904,
  XOR_MMR6 = 2905,
  XOR_V = 2906,
  XORi = 2907,
  XORi64 = 2908,
  XORi_MM = 2909,
  XorRxRxRy16 = 2910,
  YIELD = 2911,
  INSTRUCTION_LIST_END = 2912,
};
}
}
}
#endif
