// This file implements the IActiveScriptError Interface and Gateway for Python.
// Generated by makegw.py

#include "stdafx.h"
#include "PyIActiveScriptError.h"

// @doc - This file contains autoduck documentation
// ---------------------------------------------------
//
// Interface Implementation

PyIActiveScriptError::PyIActiveScriptError(IUnknown *pdisp) : PyIUnknown(pdisp) { ob_type = &type; }

PyIActiveScriptError::~PyIActiveScriptError() {}

/* static */ IActiveScriptError *PyIActiveScriptError::GetI(PyObject *self)
{
    return (IActiveScriptError *)PyIUnknown::GetI(self);
}

// @pymethod |PyIActiveScriptError|GetExceptionInfo|Description of GetExceptionInfo.
PyObject *PyIActiveScriptError::GetExceptionInfo(PyObject *self, PyObject *args)
{
    PY_INTERFACE_METHOD;
    IActiveScriptError *pIASE = GetI(self);
    if (pIASE == NULL)
        return NULL;
    if (!PyArg_ParseTuple(args, ":GetExceptionInfo"))
        return NULL;
    EXCEPINFO ei;
    memset(&ei, 0, sizeof(ei));
    PY_INTERFACE_PRECALL;
    HRESULT hr = pIASE->GetExceptionInfo(&ei);
    PY_INTERFACE_POSTCALL;
    if (FAILED(hr))
        return SetPythonCOMError(self, hr);
    return PyCom_PyObjectFromExcepInfo(&ei);
}

// @pymethod |PyIActiveScriptError|GetSourcePosition|Description of GetSourcePosition.
PyObject *PyIActiveScriptError::GetSourcePosition(PyObject *self, PyObject *args)
{
    PY_INTERFACE_METHOD;
    IActiveScriptError *pIASE = GetI(self);
    if (pIASE == NULL)
        return NULL;
    DWORD pdwSourceContext;
    ULONG pulLineNumber;
    LONG plCharacterPosition;
    if (!PyArg_ParseTuple(args, ":GetSourcePosition"))
        return NULL;
    PY_INTERFACE_PRECALL;
    HRESULT hr = pIASE->GetSourcePosition(&pdwSourceContext, &pulLineNumber, &plCharacterPosition);
    PY_INTERFACE_POSTCALL;
    if (FAILED(hr))
        return SetPythonCOMError(self, hr);

    PyObject *pyretval = Py_BuildValue("iii", pdwSourceContext, pulLineNumber, plCharacterPosition);
    return pyretval;
}

// @pymethod |PyIActiveScriptError|GetSourceLineText|Description of GetSourceLineText.
PyObject *PyIActiveScriptError::GetSourceLineText(PyObject *self, PyObject *args)
{
    PY_INTERFACE_METHOD;
    IActiveScriptError *pIASE = GetI(self);
    if (pIASE == NULL)
        return NULL;
    BSTR pbstrSourceLine;
    if (!PyArg_ParseTuple(args, ":GetSourceLineText"))
        return NULL;
    PY_INTERFACE_PRECALL;
    HRESULT hr = pIASE->GetSourceLineText(&pbstrSourceLine);
    PY_INTERFACE_POSTCALL;
    if (FAILED(hr))
        return SetPythonCOMError(self, hr);
    PyObject *pyretval = MakeBstrToObj(pbstrSourceLine);
    SysFreeString(pbstrSourceLine);
    return pyretval;
}

// @object PyIActiveScriptError|Description of the interface
static struct PyMethodDef PyIActiveScriptError_methods[] = {
    {"GetExceptionInfo", PyIActiveScriptError::GetExceptionInfo,
     1},  // @pymeth GetExceptionInfo|Description of GetExceptionInfo
    {"GetSourcePosition", PyIActiveScriptError::GetSourcePosition,
     1},  // @pymeth GetSourcePosition|Description of GetSourcePosition
    {"GetSourceLineText", PyIActiveScriptError::GetSourceLineText,
     1},  // @pymeth GetSourceLineText|Description of GetSourceLineText
    {NULL}};

PyComTypeObject PyIActiveScriptError::type("PyIActiveScriptError", &PyIUnknown::type, sizeof(PyIActiveScriptError),
                                           PyIActiveScriptError_methods, GET_PYCOM_CTOR(PyIActiveScriptError));
