---
title: "Quatrix"
description: "Rclone docs for Quatrix"
versionIntroduced: "v1.63.2"
---

# {{< icon "fas fa-shield-alt" >}} Quatrix

Quatrix by Maytech is [Quatrix Secure Compliant File Sharing | Maytech](https://www.maytech.net/products/quatrix-business).

Paths are specified as `remote:path`

Paths may be as deep as required, e.g., `remote:directory/subdirectory`.

The initial setup for Quatrix involves getting an API Key from Quatrix. You can get the API key in the user's profile at `https://<account>/profile/api-keys`
or with the help of the API - https://docs.maytech.net/quatrix/quatrix-api/api-explorer#/API-Key/post_api_key_create.

See complete Swagger documentation for Quatrix - https://docs.maytech.net/quatrix/quatrix-api/api-explorer

## Configuration

Here is an example of how to make a remote called `remote`.  First run:

     rclone config

This will guide you through an interactive setup process:

```
No remotes found, make a new one?
n) New remote
s) Set configuration password
q) Quit config
n/s/q> n
name> remote
Type of storage to configure.
Choose a number from below, or type in your own value
[snip]
XX / Quatrix by Maytech
   \ "quatrix"
[snip]
Storage> quatrix
API key for accessing Quatrix account.
api_key> your_api_key
Host name of Quatrix account.
host> example.quatrix.it

--------------------
[remote]
api_key = your_api_key
host = example.quatrix.it
--------------------
y) Yes this is OK
e) Edit this remote
d) Delete this remote
y/e/d> y
```

Once configured you can then use `rclone` like this,

List directories in top level of your Quatrix

    rclone lsd remote:

List all the files in your Quatrix

    rclone ls remote:

To copy a local directory to an Quatrix directory called backup

    rclone copy /home/source remote:backup

### API key validity

API Key is created with no expiration date. It will be valid until you delete or deactivate it in your account.
After disabling, the API Key can be enabled back. If the API Key was deleted and a new key was created, you can
update it in rclone config. The same happens if the hostname was changed.

```
$ rclone config
Current remotes:

Name                 Type
====                 ====
remote               quatrix

e) Edit existing remote
n) New remote
d) Delete remote
r) Rename remote
c) Copy remote
s) Set configuration password
q) Quit config
e/n/d/r/c/s/q> e
Choose a number from below, or type in an existing value
 1 > remote
remote> remote
--------------------
[remote]
type = quatrix
host = some_host.quatrix.it
api_key = your_api_key
--------------------
Edit remote
Option api_key.
API key for accessing Quatrix account
Enter a string value. Press Enter for the default (your_api_key)
api_key>
Option host.
Host name of Quatrix account
Enter a string value. Press Enter for the default (some_host.quatrix.it).

--------------------
[remote]
type = quatrix
host = some_host.quatrix.it
api_key = your_api_key
--------------------
y) Yes this is OK
e) Edit this remote
d) Delete this remote
y/e/d> y
```

### Modification times and hashes

Quatrix allows modification times to be set on objects accurate to 1 microsecond.
These will be used to detect whether objects need syncing or not.

Quatrix does not support hashes, so you cannot use the `--checksum` flag.

### Restricted filename characters

File names in Quatrix are case sensitive and have limitations like the maximum length of a filename is 255, and the minimum length is 1. A file name cannot be equal to `.` or `..` nor contain `/` , `\` or non-printable ascii.

### Transfers

For files above 50 MiB rclone will use a chunked transfer. Rclone will upload up to `--transfers` chunks at the same time (shared among all multipart uploads).
Chunks are buffered in memory, and the minimal chunk size is 10_000_000 bytes by default, and it can be changed in the advanced configuration, so increasing `--transfers` will increase the memory use.
The chunk size has a maximum size limit, which is set to 100_000_000 bytes by default and can be changed in the advanced configuration.
The size of the uploaded chunk will dynamically change depending on the upload speed.
The total memory use equals the number of transfers multiplied by the minimal chunk size.
In case there's free memory allocated for the upload (which equals the difference of `maximal_summary_chunk_size` and `minimal_chunk_size` * `transfers`),
the chunk size may increase in case of high upload speed. As well as it can decrease in case of upload speed problems.
If no free memory is available, all chunks will equal `minimal_chunk_size`.

### Deleting files

Files you delete with rclone will end up in Trash and be stored there for 30 days.
Quatrix also provides an API to permanently delete files and an API to empty the Trash so that you can remove files permanently from your account.

{{< rem autogenerated options start" - DO NOT EDIT - instead edit fs.RegInfo in backend/quatrix/quatrix.go then run make backenddocs" >}}
### Standard options

Here are the Standard options specific to quatrix (Quatrix by Maytech).

#### --quatrix-api-key

API key for accessing Quatrix account

Properties:

- Config:      api_key
- Env Var:     RCLONE_QUATRIX_API_KEY
- Type:        string
- Required:    true

#### --quatrix-host

Host name of Quatrix account

Properties:

- Config:      host
- Env Var:     RCLONE_QUATRIX_HOST
- Type:        string
- Required:    true

### Advanced options

Here are the Advanced options specific to quatrix (Quatrix by Maytech).

#### --quatrix-encoding

The encoding for the backend.

See the [encoding section in the overview](/overview/#encoding) for more info.

Properties:

- Config:      encoding
- Env Var:     RCLONE_QUATRIX_ENCODING
- Type:        Encoding
- Default:     Slash,BackSlash,Del,Ctl,InvalidUtf8,Dot

#### --quatrix-effective-upload-time

Wanted upload time for one chunk

Properties:

- Config:      effective_upload_time
- Env Var:     RCLONE_QUATRIX_EFFECTIVE_UPLOAD_TIME
- Type:        string
- Default:     "4s"

#### --quatrix-minimal-chunk-size

The minimal size for one chunk

Properties:

- Config:      minimal_chunk_size
- Env Var:     RCLONE_QUATRIX_MINIMAL_CHUNK_SIZE
- Type:        SizeSuffix
- Default:     9.537Mi

#### --quatrix-maximal-summary-chunk-size

The maximal summary for all chunks. It should not be less than 'transfers'*'minimal_chunk_size'

Properties:

- Config:      maximal_summary_chunk_size
- Env Var:     RCLONE_QUATRIX_MAXIMAL_SUMMARY_CHUNK_SIZE
- Type:        SizeSuffix
- Default:     95.367Mi

#### --quatrix-hard-delete

Delete files permanently rather than putting them into the trash.

Properties:

- Config:      hard_delete
- Env Var:     RCLONE_QUATRIX_HARD_DELETE
- Type:        bool
- Default:     false

{{< rem autogenerated options stop >}}

## Storage usage

The storage usage in Quatrix is restricted to the account during the purchase. You can restrict any user with a smaller storage limit.
The account limit is applied if the user has no custom storage limit. Once you've reached the limit, the upload of files will fail.
This can be fixed by freeing up the space or increasing the quota.

## Server-side operations

Quatrix supports server-side operations (copy and move). In case of conflict, files are overwritten during server-side operation.