---
title: "Proton Drive"
description: "Rclone docs for Proton Drive"
versionIntroduced: "v1.64.0"
status: Beta
---

# {{< icon "fa fa-folder" >}} Proton Drive

[Proton Drive](https://proton.me/drive) is an end-to-end encrypted Swiss vault
 for your files that protects your data.

This is an rclone backend for Proton Drive which supports the file transfer
features of Proton Drive using the same client-side encryption.

Due to the fact that Proton Drive doesn't publish its API documentation, this 
backend is implemented with best efforts by reading the open-sourced client 
source code and observing the Proton Drive traffic in the browser.

**NB** This backend is currently in Beta. It is believed to be correct
and all the integration tests pass. However the Proton Drive protocol
has evolved over time there may be accounts it is not compatible
with. Please [post on the rclone forum](https://forum.rclone.org/) if
you find an incompatibility.

Paths are specified as `remote:path`

Paths may be as deep as required, e.g. `remote:directory/subdirectory`.

## Configurations

Here is an example of how to make a remote called `remote`.  First run:

     rclone config

This will guide you through an interactive setup process:

```
No remotes found, make a new one?
n) New remote
s) Set configuration password
q) Quit config
n/s/q> n
name> remote
Type of storage to configure.
Choose a number from below, or type in your own value
[snip]
XX / Proton Drive
   \ "protondrive"
[snip]
Storage> protondrive
User name
user> you@protonmail.com
Password.
y) Yes type in my own password
g) Generate random password
n) No leave this optional password blank
y/g/n> y
Enter the password:
password:
Confirm the password:
password:
Option 2fa.
2FA code (if the account requires one)
Enter a value. Press Enter to leave empty.
2fa> 123456
Remote config
--------------------
[remote]
type = protondrive
user = you@protonmail.com
pass = *** ENCRYPTED ***
--------------------
y) Yes this is OK
e) Edit this remote
d) Delete this remote
y/e/d> y
```

**NOTE:** The Proton Drive encryption keys need to have been already generated 
after a regular login via the browser, otherwise attempting to use the 
credentials in `rclone` will fail.

Once configured you can then use `rclone` like this,

List directories in top level of your Proton Drive

    rclone lsd remote:

List all the files in your Proton Drive

    rclone ls remote:

To copy a local directory to an Proton Drive directory called backup

    rclone copy /home/source remote:backup

### Modification times and hashes

Proton Drive Bridge does not support updating modification times yet.

The SHA1 hash algorithm is supported.

### Restricted filename characters

Invalid UTF-8 bytes will be [replaced](/overview/#invalid-utf8), also left and 
right spaces will be removed ([code reference](https://github.com/ProtonMail/WebClients/blob/b4eba99d241af4fdae06ff7138bd651a40ef5d3c/applications/drive/src/app/store/_links/validation.ts#L51))

### Duplicated files

Proton Drive can not have two files with exactly the same name and path. If the 
conflict occurs, depending on the advanced config, the file might or might not 
be overwritten.

### [Mailbox password](https://proton.me/support/the-difference-between-the-mailbox-password-and-login-password)

Please set your mailbox password in the advanced config section.

### Caching

The cache is currently built for the case when the rclone is the only instance 
performing operations to the mount point. The event system, which is the proton
API system that provides visibility of what has changed on the drive, is yet 
to be implemented, so updates from other clients won’t be reflected in the 
cache. Thus, if there are concurrent clients accessing the same mount point, 
then we might have a problem with caching the stale data.

{{< rem autogenerated options start" - DO NOT EDIT - instead edit fs.RegInfo in backend/protondrive/protondrive.go then run make backenddocs" >}}
### Standard options

Here are the Standard options specific to protondrive (Proton Drive).

#### --protondrive-username

The username of your proton account

Properties:

- Config:      username
- Env Var:     RCLONE_PROTONDRIVE_USERNAME
- Type:        string
- Required:    true

#### --protondrive-password

The password of your proton account.

**NB** Input to this must be obscured - see [rclone obscure](/commands/rclone_obscure/).

Properties:

- Config:      password
- Env Var:     RCLONE_PROTONDRIVE_PASSWORD
- Type:        string
- Required:    true

#### --protondrive-2fa

The 2FA code

The value can also be provided with --protondrive-2fa=000000

The 2FA code of your proton drive account if the account is set up with 
two-factor authentication

Properties:

- Config:      2fa
- Env Var:     RCLONE_PROTONDRIVE_2FA
- Type:        string
- Required:    false

### Advanced options

Here are the Advanced options specific to protondrive (Proton Drive).

#### --protondrive-mailbox-password

The mailbox password of your two-password proton account.

For more information regarding the mailbox password, please check the 
following official knowledge base article: 
https://proton.me/support/the-difference-between-the-mailbox-password-and-login-password


**NB** Input to this must be obscured - see [rclone obscure](/commands/rclone_obscure/).

Properties:

- Config:      mailbox_password
- Env Var:     RCLONE_PROTONDRIVE_MAILBOX_PASSWORD
- Type:        string
- Required:    false

#### --protondrive-client-uid

Client uid key (internal use only)

Properties:

- Config:      client_uid
- Env Var:     RCLONE_PROTONDRIVE_CLIENT_UID
- Type:        string
- Required:    false

#### --protondrive-client-access-token

Client access token key (internal use only)

Properties:

- Config:      client_access_token
- Env Var:     RCLONE_PROTONDRIVE_CLIENT_ACCESS_TOKEN
- Type:        string
- Required:    false

#### --protondrive-client-refresh-token

Client refresh token key (internal use only)

Properties:

- Config:      client_refresh_token
- Env Var:     RCLONE_PROTONDRIVE_CLIENT_REFRESH_TOKEN
- Type:        string
- Required:    false

#### --protondrive-client-salted-key-pass

Client salted key pass key (internal use only)

Properties:

- Config:      client_salted_key_pass
- Env Var:     RCLONE_PROTONDRIVE_CLIENT_SALTED_KEY_PASS
- Type:        string
- Required:    false

#### --protondrive-encoding

The encoding for the backend.

See the [encoding section in the overview](/overview/#encoding) for more info.

Properties:

- Config:      encoding
- Env Var:     RCLONE_PROTONDRIVE_ENCODING
- Type:        Encoding
- Default:     Slash,LeftSpace,RightSpace,InvalidUtf8,Dot

#### --protondrive-original-file-size

Return the file size before encryption
			
The size of the encrypted file will be different from (bigger than) the 
original file size. Unless there is a reason to return the file size 
after encryption is performed, otherwise, set this option to true, as 
features like Open() which will need to be supplied with original content 
size, will fail to operate properly

Properties:

- Config:      original_file_size
- Env Var:     RCLONE_PROTONDRIVE_ORIGINAL_FILE_SIZE
- Type:        bool
- Default:     true

#### --protondrive-app-version

The app version string 

The app version string indicates the client that is currently performing 
the API request. This information is required and will be sent with every 
API request.

Properties:

- Config:      app_version
- Env Var:     RCLONE_PROTONDRIVE_APP_VERSION
- Type:        string
- Default:     "macos-drive@1.0.0-alpha.1+rclone"

#### --protondrive-replace-existing-draft

Create a new revision when filename conflict is detected

When a file upload is cancelled or failed before completion, a draft will be 
created and the subsequent upload of the same file to the same location will be 
reported as a conflict.

The value can also be set by --protondrive-replace-existing-draft=true

If the option is set to true, the draft will be replaced and then the upload 
operation will restart. If there are other clients also uploading at the same 
file location at the same time, the behavior is currently unknown. Need to set 
to true for integration tests.
If the option is set to false, an error "a draft exist - usually this means a 
file is being uploaded at another client, or, there was a failed upload attempt" 
will be returned, and no upload will happen.

Properties:

- Config:      replace_existing_draft
- Env Var:     RCLONE_PROTONDRIVE_REPLACE_EXISTING_DRAFT
- Type:        bool
- Default:     false

#### --protondrive-enable-caching

Caches the files and folders metadata to reduce API calls

Notice: If you are mounting ProtonDrive as a VFS, please disable this feature, 
as the current implementation doesn't update or clear the cache when there are 
external changes. 

The files and folders on ProtonDrive are represented as links with keyrings, 
which can be cached to improve performance and be friendly to the API server.

The cache is currently built for the case when the rclone is the only instance 
performing operations to the mount point. The event system, which is the proton
API system that provides visibility of what has changed on the drive, is yet 
to be implemented, so updates from other clients won’t be reflected in the 
cache. Thus, if there are concurrent clients accessing the same mount point, 
then we might have a problem with caching the stale data.

Properties:

- Config:      enable_caching
- Env Var:     RCLONE_PROTONDRIVE_ENABLE_CACHING
- Type:        bool
- Default:     true

#### --protondrive-description

Description of the remote.

Properties:

- Config:      description
- Env Var:     RCLONE_PROTONDRIVE_DESCRIPTION
- Type:        string
- Required:    false

{{< rem autogenerated options stop >}}

## Limitations

This backend uses the 
[Proton-API-Bridge](https://github.com/henrybear327/Proton-API-Bridge), which 
is based on [go-proton-api](https://github.com/henrybear327/go-proton-api), a 
fork of the [official repo](https://github.com/ProtonMail/go-proton-api).

There is no official API documentation available from Proton Drive. But, thanks 
to Proton open sourcing [proton-go-api](https://github.com/ProtonMail/go-proton-api) 
and the web, iOS, and Android client codebases, we don't need to completely 
reverse engineer the APIs by observing the web client traffic! 

[proton-go-api](https://github.com/ProtonMail/go-proton-api) provides the basic 
building blocks of API calls and error handling, such as 429 exponential 
back-off, but it is pretty much just a barebone interface to the Proton API. 
For example, the encryption and decryption of the Proton Drive file are not 
provided in this library. 

The Proton-API-Bridge, attempts to bridge the gap, so rclone can be built on 
top of this quickly. This codebase handles the intricate tasks before and after 
calling Proton APIs, particularly the complex encryption scheme, allowing 
developers to implement features for other software on top of this codebase. 
There are likely quite a few errors in this library, as there isn't official 
documentation available. 
