---
title: "Pixeldrain"
description: "Rclone docs for Pixeldrain"
versionIntroduced: "v1.68"
---

# {{< icon "fa fa-circle" >}} Pixeldrain

This is the backend for Pixeldrain's premium filesystem feature. This is not the
same as pixeldrain's free file sharing product. The filesystem requires either a
Pro subscription or the Prepaid plan. [More information on
subscriptions](https://pixeldrain.com/#pro).

An overview of the filesystem's features and limitations is available in the
[filesystem guide](https://pixeldrain.com/filesystem) on pixeldrain.

### Usage with account

To use the personal filesystem you will need a [pixeldrain
account](https://pixeldrain.com/register) and either the Prepaid plan or one of
the Patreon-based subscriptions. After registering and subscribing, your
personal filesystem will be available at this link: https://pixeldrain.com/d/me.

Go to the [API keys page](https://pixeldrain.com/user/api_keys) on your account
and generate a new API key for rclone. Then run `rclone config` and use the API
key to create a new backend.

Example:

```
No remotes found, make a new one?
n) New remote
d) Delete remote
c) Copy remote
s) Set configuration password
q) Quit config
n/d/c/s/q> n

Enter name for new remote.
name> pixeldrainfs

Option Storage.
Type of storage to configure.
Choose a number from below, or type in your own value.
...
XX / Pixeldrain Filesystem
   \ (pixeldrain)
...
Storage> pixeldrain

Option api_key.
API key for your pixeldrain account.
Found on https://pixeldrain.com/user/api_keys.
Enter a value. Press Enter to leave empty.
api_key> b1bb1e81-9b7b-406b-986a-c9b20be76e15

Option directory_id.
Root of the filesystem to use. Set to 'me' to use your personal filesystem.
Set to a shared directory ID to use a shared directory.
Enter a string value. Press Enter for the default (me).
directory_id>

Edit advanced config?
y) Yes
n) No (default)
y/n>

Configuration complete.
Options:
- type: pixeldrain
- api_key: b1bb1e81-9b7b-406b-986a-c9b20be76e15
Keep this "pixeldrainfs" remote?
y) Yes this is OK (default)
e) Edit this remote
d) Delete this remote
y/e/d>

Current remotes:

Name                 Type
====                 ====
pixeldrainfs         pixeldrain

e) Edit existing remote
n) New remote
d) Delete remote
r) Rename remote
c) Copy remote
s) Set configuration password
q) Quit config
e/n/d/r/c/s/q> q
```

### Usage without account

It is possible to gain read-only access to publicly shared directories through
rclone. For this you only need a directory ID. The directory ID can be found in
the URL of a shared directory, the URL will look like this
`https://pixeldrain.com/d/abcd1234` where `abcd1234` is the directory ID.
Directory IDs in your own filesystem can also be listed with the `lsf` command:

`rclone lsf Pixeldrain: --dirs-only -Fpi`

This will print directories in your `Pixeldrain` home directory and their public
IDs.

Enter this directory ID in the rclone config and you will be able to access the
directory.

{{< rem autogenerated options start" - DO NOT EDIT - instead edit fs.RegInfo in backend/pixeldrain/pixeldrain.go then run make backenddocs" >}}
### Standard options

Here are the Standard options specific to pixeldrain (Pixeldrain Filesystem).

#### --pixeldrain-api-key

API key for your pixeldrain account.
Found on https://pixeldrain.com/user/api_keys.

Properties:

- Config:      api_key
- Env Var:     RCLONE_PIXELDRAIN_API_KEY
- Type:        string
- Required:    false

#### --pixeldrain-root-folder-id

Root of the filesystem to use.

Set to 'me' to use your personal filesystem. Set to a shared directory ID to use a shared directory.

Properties:

- Config:      root_folder_id
- Env Var:     RCLONE_PIXELDRAIN_ROOT_FOLDER_ID
- Type:        string
- Default:     "me"

### Advanced options

Here are the Advanced options specific to pixeldrain (Pixeldrain Filesystem).

#### --pixeldrain-api-url

The API endpoint to connect to. In the vast majority of cases it's fine to leave
this at default. It is only intended to be changed for testing purposes.

Properties:

- Config:      api_url
- Env Var:     RCLONE_PIXELDRAIN_API_URL
- Type:        string
- Default:     "https://pixeldrain.com/api"

#### --pixeldrain-description

Description of the remote.

Properties:

- Config:      description
- Env Var:     RCLONE_PIXELDRAIN_DESCRIPTION
- Type:        string
- Required:    false

### Metadata

Pixeldrain supports file modes and creation times.

Here are the possible system metadata items for the pixeldrain backend.

| Name | Help | Type | Example | Read Only |
|------|------|------|---------|-----------|
| btime | Time of file birth (creation) | RFC 3339 | 2006-01-02T15:04:05.999999999Z07:00 | N |
| mode | File mode | octal, unix style | 755 | N |
| mtime | Time of last modification | RFC 3339 | 2006-01-02T15:04:05.999999999Z07:00 | N |

See the [metadata](/docs/#metadata) docs for more info.

{{< rem autogenerated options stop >}}
