/* ScummVM - Graphic Adventure Engine
 *
 * ScummVM is the legal property of its developers, whose names
 * are too numerous to list here. Please refer to the COPYRIGHT
 * file distributed with this source distribution.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 */

#ifndef DIRECTOR_DETECTION_PATHS_H
#define DIRECTOR_DETECTION_PATHS_H

namespace Director {

const char *const directoryGlobs[] = {
	"install",
	"win_data",						// L-ZONE
	"data",
	"program",						// Arc Media products
	"media",						// Gundam
	"mvm",							// Master of the Elements
	"module_1",
	"module_2",						// Takeru
	"datas",						// O!KAY! subscription from Domino Verlag
	"data_k",
	"data_1",
	"data_2",						// JumpStart World
	"numbers",						// JumpStart Learning Games
	"blender",						// Blender CD-ROM magazines
	"cd_data",						// Polis
	"ojo2000",						// Abrapalabra
	"p2data",
	"p2media",
	"p3media",
	"annat",						// Pettson & Findus
	"bb",							// Blinky Bill
	"fctdata",
	"fct",					   		// Felix the Cat
	"95instal",						// Fisher-Price Little People
	"popup",						// Pop Up Computer
	"win_demo",
	"file",
	"mfile",
	"lingo expo",					// D4 sample movies
	"main",							// Meet MediaBand
	"bellinin bikinit",				// Bellini 3 (Finnish)
//	"abc",							// Alphabet Train
//	"123",							// Ktar Alarkam
	"vlaams",
	"ned",							// I Spy School Days (Dutch)
	"fl1",							// Flipper & Lopaka
	"cipdemo",
	"cipher",						// Jewels of the Oracle
	"gems",							// Gems of Darkness / Jewels II
	"xn--t8jo8k",					// Perfect Blue screen savers
	"maccurio",
	"wincurio",						// Curio City
	"a.d.a.m. the inside story 1.1", // ADAM
	"nine month miracle 1.0",		// Nine Month Miracle
	"_A.D.A.M. Data",				// ADAM Software Products
	"_A.D.A.M.  Data",				// ADAM Software Products with more space
	"_setup",
	"bin",
	"adam resources",				// ADAM Software Products
	"NAV",
	"Daedalus Max",					// The Daedalus Encounter
	0
};

} // End of namespace Director

#endif
