# SIESTA 5.4.0 Release Notes (2025-05-28)

## Highlights

- Added support for partial point charges in SIESTA (intended for QMMM) and
  incorporated the original QMMM driver as a utility. Now the SIESTA interface can
  now be extended to support other MM software.

  ([93](https://gitlab.com/siesta-project/siesta/-/merge_requests/93))



## New features

- Added support for partial point charges in SIESTA (intended for QMMM) and
  incorporated the original QMMM driver as a utility. The SIESTA interface can
  now be extended to support other MM software.

  What SIESTA receives from an external MM program are the following pieces of
  information: cell dimensions, QM atom coordinates, MM atom coordinates, and MM
  atom partial charges. From there, SIESTA calculates the electrostatic potential
  generated by the point charges and adds it to the corresponding SCF potential.
  After convergence, SIESTA also calculates forces components over said point
  charges (i.e. the MM atoms).

  Both operations mentioned above are solved using an implementation of the
  Particle Mesh Ewald method done by C. Sanz and already available in the QMMM
  driver. The inclusion of these operations in SIESTA provides some advantages:

  * Using SIESTA's own parallelization, calculations of electrostatic potential
    and forces over MM atoms are now much faster, and no longer become the
    limiting factor in very large systems.
  * We no longer need to exchange grid-related information between SIESTA and the
    MM driver.
  * This new approach is the expected one from other MM engines, thus increasing
    the eligibility of SIESTA as a QM engine, for QM/MM, when using other drivers
    (ASE, for example). In these approaches, the QM engine calculates the
    electrostatic term of QM/MM, while the MM driver takes care of the
    Lennard-Jones term.

  Information exchange between SIESTA and the MM driver can be done either via
  pipes or sockets. For the sake of simplicity, communication with our own QM/MM
  driver is still handled via pipes, but a test for the socket interface is also
  included.

  ([93](https://gitlab.com/siesta-project/siesta/-/merge_requests/93))


- Add FFTW support for the Poisson solver and optimize distribution handling

  ([115](https://gitlab.com/siesta-project/siesta/-/merge_requests/115))


- Re-design of the matel tables, including a new approach to their initialization

  Table initialization is done at the outset in parallel, instead of on-the-fly.
  Also: exploit other opportunities for parallelization over atoms in a few routines.

  ([140](https://gitlab.com/siesta-project/siesta/-/merge_requests/140))


- Enable calculation of the derivatives of Hamiltonian and overlap matrix during 
  an FC run. Results are written to a new output file `SystemLabel.dHSdR.nc`.

  Calculating the derivatives directly in SIESTA, instead of writing all HSX files
  to the disk and then calculating the derivatives with a post-processing utility
  saves a disk space.

  ([327](https://gitlab.com/siesta-project/siesta/-/merge_requests/327))


- Enabled writing 1 or 2 Hamiltonians's to a single HSX file

  Internal development allowing more flexibility
  when constructing the HSX files.

  ([400](https://gitlab.com/siesta-project/siesta/-/merge_requests/400))


- Enabled writing 1 or 2 DM's to a single DM file

  Internal development allowing more flexibility
  when constructing the DM files.

  ([407](https://gitlab.com/siesta-project/siesta/-/merge_requests/407))


- The testing framework can now use fixtures

  This enables a more flexible testing framework
  where tests can depend on other tests, and in particular
  the outputs of other tests.

  ([411](https://gitlab.com/siesta-project/siesta/-/merge_requests/411))


- Enabled usage of Basis Pressure in terms of a per-species option.

  Deprecated BASIS_ENTHALPY and BASIS_HARRIS_ENTHALPY files in favor of systemlabel.BASIS_ENTHALPY.

  ([458](https://gitlab.com/siesta-project/siesta/-/merge_requests/458))



## Changes and improvements

- Adds deallocations in several parts of the code that never deallocated module arrays.

  Also standardized most of the "deinit"-type routine names.

  ([231](https://gitlab.com/siesta-project/siesta/-/merge_requests/231))


- Changed default Hamiltonian file format for TranSiesta

  Historically TranSiesta has required the TSHS file format
  because it contained additional information required for
  TranSiesta runs.

  Now, the TSHS file format is deprecated, in favor of the
  HSX file format.

  Several utilities now has a greater flexibility because
  they can read TSHS, HSX, nc files.

  ([411](https://gitlab.com/siesta-project/siesta/-/merge_requests/411))


- It is now possible to re-run tests under the ctest framework.

  For most tests, this means just setting UseSaveDM to false, but additional precautions were needed for TS and MD restarts.
  Additionaly, the ctest suite now supports the REMOVE_FILES option, which removes files after run and verification steps.

  ([448](https://gitlab.com/siesta-project/siesta/-/merge_requests/448))


- Clarified usage of BandlinesScale fdf variable.

  Now, band calculation is not performed if the cell is non-orthorhombic, but pi/a was chosen as an option for BandLinesScale.

  ([457](https://gitlab.com/siesta-project/siesta/-/merge_requests/457))


- Allowed HSX file writing for MD+FC calculations

  This fully superseedes the TSHS implementations.

  ([460](https://gitlab.com/siesta-project/siesta/-/merge_requests/460))


- Updated compiler flags for GNU and Intel compilers, in particular those involving
  checks and debug.

  ([468](https://gitlab.com/siesta-project/siesta/-/merge_requests/468))


- A few QOL features for COOP utilities:

  fat now will default to .bands.WFSX instead of .WFSX, and mprop will default to .fullBZ.WFSX, which are the intended targets. This removes the need of making unnecessary symbolic links.

  Also, removed the parameters ncbmx and nlwmx, allowing for more flexibility in input files.

  ([473](https://gitlab.com/siesta-project/siesta/-/merge_requests/473))



## Bugfixes

- Fixed communicator and command-line argument issues in MPI-based API

  ([447](https://gitlab.com/siesta-project/siesta/-/merge_requests/447))


- Fixed ANNEAL\_RESTART file being read even when no XV file was present or when the XV file was not being read.

  ([456](https://gitlab.com/siesta-project/siesta/-/merge_requests/456))


- Fixed quadruple precision requirement in moremeshsubs with a workaround for
  large integer divisions.

  ([459](https://gitlab.com/siesta-project/siesta/-/merge_requests/459))


- Fixed DFT-D3 not working when ghost atoms were present, due to the negative atomic numbers then used as indexes for the D3 library.

  ([465](https://gitlab.com/siesta-project/siesta/-/merge_requests/465))


- Fixed a reintroduced bug with IOEIG being called from all nodes.

  ([466](https://gitlab.com/siesta-project/siesta/-/merge_requests/466))


- Fixed some tests requiring more than 1 CPU when MPI is enabled.

  The new option MPI_MINPROCS disables a tests if the maximum number of MPI processors is less than the minimum required.

  ([467](https://gitlab.com/siesta-project/siesta/-/merge_requests/467))


- Fixed some validation tests requiring a GPU because four reference output files were missing. 

  These files are: 
        si-qdot-elpa-native-gpu.out
        si-qdot-elpa-native-1stage-gpu.out
        si-qdot-elsi-elpa-gpu.out
        si-qdot-elsi-elpa-1stage-gpu.out

  With these files, it will be possible to perform the ctests when a GPU is available.

  ([471](https://gitlab.com/siesta-project/siesta/-/merge_requests/471))


- Fixed units conversion when printing delta-Ef option in transiesta.

  ([476](https://gitlab.com/siesta-project/siesta/-/merge_requests/476))


- Fixed vib2xsf not printing the unit cell for the AXSF format.

  ([477](https://gitlab.com/siesta-project/siesta/-/merge_requests/477))



## Build related

- Enable the use of mpi_f08 interfaces if available

  Both the mpi_f08 and the legacy interfaces are supported through macros.

  ([284](https://gitlab.com/siesta-project/siesta/-/merge_requests/284))


- Adds several fixes to APostnikov utilities and expands the CMake framework
  to include automated tests for those.

  ([350](https://gitlab.com/siesta-project/siesta/-/merge_requests/350))


- Moved `Config/cmake` to `cmake`

  This makes it much simpler to
  traverse the directory structure.

  ([414](https://gitlab.com/siesta-project/siesta/-/merge_requests/414))


- Fix typos in the manual setting of GPU-related variables for ELPA

  These variables are needed when ELPA features cannot be found automatically.

  ([443](https://gitlab.com/siesta-project/siesta/-/merge_requests/443))


- Fix the use of the `SIESTA_PROFILE_NVTX_LIBRARY` CMake variable

  This fixes a building problem when compiling with NVTX support
  (`-DSIESTA_WITH_PROFILE_NVTX=ON`).

  ([444](https://gitlab.com/siesta-project/siesta/-/merge_requests/444))


- Internal cleanup of test runs

  To disable *verification* tests one should do
  `ctest -LE verify`

  The environment variable `SIESTA_TESTS_VERIFY`
  has no more effect.

  ([451](https://gitlab.com/siesta-project/siesta/-/merge_requests/451))


- Restructured configuration of tests for easier future changes

  ([455](https://gitlab.com/siesta-project/siesta/-/merge_requests/455))


- Add support for rpath handling

  The variable `SIESTA_SET_RPATH` (`ON` by default) controls
  whether executables and libraries use rpath (or runpath in Linux).

  ([464](https://gitlab.com/siesta-project/siesta/-/merge_requests/464))


- Added .git extension to all URLs used for GIT_REPOSITORY within CMake.

  ([474](https://gitlab.com/siesta-project/siesta/-/merge_requests/474))



## Documentation

- New system for tracking changes and generating Release Notes based on towncrier.

  ([445](https://gitlab.com/siesta-project/siesta/-/merge_requests/445))


## Utilities


### New features

- Added a new tool to calculate the (2D) Lindhard function from the KP and EIG files outputed by SIESTA.

  ([450](https://gitlab.com/siesta-project/siesta/-/merge_requests/450))
