#!/bin/sh
#
# srecord - Manipulate EPROM load files
# Copyright (C) 2022 Scott Finneran
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 3 of the License, or (at
# your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
# General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program. If not, see <http://www.gnu.org/licenses/>.
#

TEST_SUBJECT="srec_cat -o -coe 32 to test xiretza's patch"
. test_prelude

cat > test.in << 'fubar'
S00600004844521B
S12300007A855C178405C14B8D7FD703E20D2CE168B84570C1E3C731585CDB2A0778C73F44
S123002012E9F486314236DF5970FF26621CA5258187CBF48A046FB8209B20F9E125668F3E
S1230040F085A32C0A8F99828E20E2F3DC37EC233E84D1F3566D912C759FFC9450BFDB2942
S1230060AC4CAFBA1BFED2EA0D227CEA52B50791F4944C07216A9880512B315D97E71506F1
S123008055BE88AB42A5216190F75676992F189F8E3331A257E01835C1E814D8070EF5C95B
S12300A054BA0A6B2F63BE739540574845B791F7FB39D2D86412B238B5EE92DEECC01F0BD7
S12300C06836D6825D8D81E372E573FA04A8248E2AF9E7613F64B3F2C4AF6D71A15A18326D
S12300E068B0514E7F730F815465DA4FC1113D58C4878DACFDF0755EA7613D7AA213E7C11A
S12301007CA4D8C2E40FCE0F68316B925EBEF9B4467C1B8D7291031739C18EBCEAAFDF7738
S1230120EE09D2ECE6696357E621359CE1503B076684C930AF0AE5A26F59738668577AA4F1
S1230140B7FC922263D256E91263BEB59D20DBB8C0E24E6827E5829976094F72836EFAA33B
S12301605BD9F49F4D00617FC4B33048AFA398526B18C420B0A822B80F905F2665034EC128
S1230180D07FA72ED264DBFD73095E41509F2D420BD20094B000C5EAFA075BD23B00BD3D7D
S12301A0008A21062B53C8C500F4EC001356D8F81DE7C2009B0C002676683FD0F7B7C16C0B
S12301C0D1D87583F73334072E6B8896BE12B90CE488601891E38339CA6481A232F0CAEE8A
S12301E02F5AECA53801A936D8DA5DF184E38F731BA4043AE48E3D5EE7A003606BF2ACA0C3
S12302006D973A5A73567E0E5196FE738BD254F40059F811F11BC47DBBAC137ADBB2A739E0
S1230220FC7AA42AE79C75E03BC28C7ECE6B7D31E51F5259F9A76E7C296C72FC66CE63C11C
S12302400031EA7E59779DBBD7B8E6942657F71235581AD897070099C9975CF79F17DBBE92
S123026073C6C857B828B7327BD152D2A0A1129AD272E1BF05CAC03B4F68E6A77D7323E017
S123028038720012FA456A7BA37F5535A097D06B37465A6ACCE86173EB430EDBB7F858D89D
S12302A01A91F4F4B5F802A7C33C605C6E13E1D7B2814F944574DD505D1931E3B70F89FD8B
S12302C05F7A1F8E97C4E7EB1E6298A10C6A6D854D5A0B64B0484CA9BD73948D5443AC2788
S12302E0FEC1CAEF05EB5C748873826D936613112A8559D3C5A83C4A84175FECEB08A1F67D
S1230300DF1CCB448C9234D79E343B1690F75666B75E5B94617AC948E25387D9DB7FD23C53
S1230320E23050F5CA24A4A7955096F4115722109624F176E308927B9BC3A7F2D61E0519FE
S12303408E5A000A67DBB21283CF650503E974B00F1034C826E811801F5998D8AACF19247D
S1230360DD5FFE9C08D9C4115AD67BCF922B889E83976896276D9276C8BC4CFA739097D6A2
S12303800C68B255D06C735278577DC24D35200369D21D9C1210F374CAECCD0FC0CFA36881
S12303A0F5F1A58B3E07FA729B1EFA631C139CAFA28261FB01B342C5AD59F8EF4F1863D51B
S12303C0B0C90EF4BC507A89651736C1C8C3429E52ACA4FDCE8D5E247795EC42058A00E884
S12303E0B500387C92595B40FB00AA9A004B1D02F353A0CA001277007832CE461D3F4300CB
S5030020DC
S9030000FC
fubar

if test $? -ne 0; then no_result; fi

cat > test.ok << 'fubar'
; HDR
;
; Generated automatically by srec_cat -o --coe 32
;
; depth = 256; 0x0100
; width = 32; 0x20
memory_initialization_radix = 16;
memory_initialization_vector =
7A855C17,
8405C14B,
8D7FD703,
E20D2CE1,
68B84570,
C1E3C731,
585CDB2A,
0778C73F,
12E9F486,
314236DF,
5970FF26,
621CA525,
8187CBF4,
8A046FB8,
209B20F9,
E125668F,
F085A32C,
0A8F9982,
8E20E2F3,
DC37EC23,
3E84D1F3,
566D912C,
759FFC94,
50BFDB29,
AC4CAFBA,
1BFED2EA,
0D227CEA,
52B50791,
F4944C07,
216A9880,
512B315D,
97E71506,
55BE88AB,
42A52161,
90F75676,
992F189F,
8E3331A2,
57E01835,
C1E814D8,
070EF5C9,
54BA0A6B,
2F63BE73,
95405748,
45B791F7,
FB39D2D8,
6412B238,
B5EE92DE,
ECC01F0B,
6836D682,
5D8D81E3,
72E573FA,
04A8248E,
2AF9E761,
3F64B3F2,
C4AF6D71,
A15A1832,
68B0514E,
7F730F81,
5465DA4F,
C1113D58,
C4878DAC,
FDF0755E,
A7613D7A,
A213E7C1,
7CA4D8C2,
E40FCE0F,
68316B92,
5EBEF9B4,
467C1B8D,
72910317,
39C18EBC,
EAAFDF77,
EE09D2EC,
E6696357,
E621359C,
E1503B07,
6684C930,
AF0AE5A2,
6F597386,
68577AA4,
B7FC9222,
63D256E9,
1263BEB5,
9D20DBB8,
C0E24E68,
27E58299,
76094F72,
836EFAA3,
5BD9F49F,
4D00617F,
C4B33048,
AFA39852,
6B18C420,
B0A822B8,
0F905F26,
65034EC1,
D07FA72E,
D264DBFD,
73095E41,
509F2D42,
0BD20094,
B000C5EA,
FA075BD2,
3B00BD3D,
008A2106,
2B53C8C5,
00F4EC00,
1356D8F8,
1DE7C200,
9B0C0026,
76683FD0,
F7B7C16C,
D1D87583,
F7333407,
2E6B8896,
BE12B90C,
E4886018,
91E38339,
CA6481A2,
32F0CAEE,
2F5AECA5,
3801A936,
D8DA5DF1,
84E38F73,
1BA4043A,
E48E3D5E,
E7A00360,
6BF2ACA0,
6D973A5A,
73567E0E,
5196FE73,
8BD254F4,
0059F811,
F11BC47D,
BBAC137A,
DBB2A739,
FC7AA42A,
E79C75E0,
3BC28C7E,
CE6B7D31,
E51F5259,
F9A76E7C,
296C72FC,
66CE63C1,
0031EA7E,
59779DBB,
D7B8E694,
2657F712,
35581AD8,
97070099,
C9975CF7,
9F17DBBE,
73C6C857,
B828B732,
7BD152D2,
A0A1129A,
D272E1BF,
05CAC03B,
4F68E6A7,
7D7323E0,
38720012,
FA456A7B,
A37F5535,
A097D06B,
37465A6A,
CCE86173,
EB430EDB,
B7F858D8,
1A91F4F4,
B5F802A7,
C33C605C,
6E13E1D7,
B2814F94,
4574DD50,
5D1931E3,
B70F89FD,
5F7A1F8E,
97C4E7EB,
1E6298A1,
0C6A6D85,
4D5A0B64,
B0484CA9,
BD73948D,
5443AC27,
FEC1CAEF,
05EB5C74,
8873826D,
93661311,
2A8559D3,
C5A83C4A,
84175FEC,
EB08A1F6,
DF1CCB44,
8C9234D7,
9E343B16,
90F75666,
B75E5B94,
617AC948,
E25387D9,
DB7FD23C,
E23050F5,
CA24A4A7,
955096F4,
11572210,
9624F176,
E308927B,
9BC3A7F2,
D61E0519,
8E5A000A,
67DBB212,
83CF6505,
03E974B0,
0F1034C8,
26E81180,
1F5998D8,
AACF1924,
DD5FFE9C,
08D9C411,
5AD67BCF,
922B889E,
83976896,
276D9276,
C8BC4CFA,
739097D6,
0C68B255,
D06C7352,
78577DC2,
4D352003,
69D21D9C,
1210F374,
CAECCD0F,
C0CFA368,
F5F1A58B,
3E07FA72,
9B1EFA63,
1C139CAF,
A28261FB,
01B342C5,
AD59F8EF,
4F1863D5,
B0C90EF4,
BC507A89,
651736C1,
C8C3429E,
52ACA4FD,
CE8D5E24,
7795EC42,
058A00E8,
B500387C,
92595B40,
FB00AA9A,
004B1D02,
F353A0CA,
00127700,
7832CE46,
1D3F4300;
; start address = 0000
fubar
if test $? -ne 0; then no_result; fi

srec_cat test.in -o test.out -coe 32
if test $? -ne 0; then fail; fi

diff test.ok test.out
if test $? -ne 0; then fail; fi

#
# The things tested here, worked.
# No other guarantees are made.
#
pass

# vim: set ts=8 sw=4 et :
