# glossaries-extra package
# Matthew Bertucci 2023/04/25 for v1.51

#include:glossaries

### 2 Package Options ###
# load-time only options
#keyvals:\usepackage/glossaries-extra#c
nowarn
nolangwarn
noredefwarn
translate=#true,false,babel
notranslate
languages=%<language(s)%>
locales=%<language(s)%>
nolong
nosuper
nolist
notree
nostyles
makeindex
xindy
xindy={%<options%>}
xindygloss
xindynoglsnumbers
acronym#true,false
acronyms
#endkeyvals

\glossariesextrasetup{options%keyvals}

#keyvals:\usepackage/glossaries-extra#c,\glossariesextrasetup
## options passed to glossaries.sty
debug=#false,true,showtargets,showaccsupp,showwrgloss,all
savewrites#true,false
hyperfirst#true,false
writeglslabels
writeglslabelnames
toc#true,false
numberline#true,false
section=%<section unit%>
ucmark#true,false
numberedsection=#false,nolabel,autolabel
savenumberlist#true,false
entrycounter#true,false
counterwithin=%<counter%>
subentrycounter#true,false
style=%<style-name%>
nonumberlist
seeautonumberlist
counter=%<counter%>
nopostdot#true,false
nogroupskip#true,false
seenoindex=#error,warn,ignore
esclocations#true,false
indexonlyfirst#true,false
sanitizesort#true,false
sort=#none,clear,def,use,standard
order=#word,letter
automake=#false,delayed,immediate,makegloss,lite
automakegloss
automakeglosslite
disablemakegloss
restoremakegloss
nohypertypes={%<list%>}
nomain
symbols
numbers
index
noglossaryindex
acronymlists={%<label-list%>}
shortcuts=#acronyms,acro,ac,abbreviations,abbr,acother,abother,other,all,true,none,false
mfirstuc=#expanded,unexpanded
kernelglossredefs={%<value%>}
## options unique to glossaries-extra
nomissingglstext#true,false
abbreviations
postdot
postpunc=#comma,dot,none
stylemods
stylemods=#default,all,inline,list,tree,mcols,long,longragged,longbooktabs,super,superragged,bookindex,longextra,topic,table
prefix
accsupp
undefaction=#warn,error
docdef=#false,true,restricted,atom
indexcrossrefs#true,false
autoseeindex#true,false
record=#off,only,nameref,hybrid
bibglsaux=%<basename%>
equations#true,false
floats#true,false
indexcounter
showtargets=#left,right,innerleft,innerright,annoteleft,annoteright
#endkeyvals

#ifOption:abbreviations
\printabbreviations
\printabbreviations[options%keyvals]
\printunsrtabbreviations#*
\printunsrtabbreviations[options%keyvals]#*
\abbreviationsname#*
#endif

#ifOption:symbols
\printsymbols
\printsymbols[options%keyvals]
\glsxtrnewsymbol{label}{symbol}#l
\glsxtrnewsymbol[options%keyvals]{label}{symbol}#l
\printunsrtsymbols#*
\printunsrtsymbols[options%keyvals]#*
\glsxtrpostdescsymbol#*
#endif

#ifOption:numbers
\printnumbers
\printnumbers[options%keyvals]
\glsxtrnewnumber{label}{number}#l
\glsxtrnewnumber[options%keyvals]{label}{number}#l
\printunsrtnumbers#*
\printunsrtnumbers[options%keyvals]#*
\glsxtrpostdescnumber#*
#endif

#ifOption:index
\newterm{term}
\newterm[options%keyvals]{term}
\printindex
\printindex[options%keyvals]
\printunsrtindex
\printunsrtindex[options%keyvals]
\glsxtrpostdescindex#*
#endif

#ifOption:acronym
\printacronyms
\printacronyms[options%keyvals]
\printunsrtacronyms
\printunsrtacronyms[options%keyvals]
#endif
#ifOption:acronym=true
\printacronyms
\printacronyms[options%keyvals]
\printunsrtacronyms
\printunsrtacronyms[options%keyvals]
#endif
#ifOption:acronyms
\printacronyms
\printacronyms[options%keyvals]
\printunsrtacronyms
\printunsrtacronyms[options%keyvals]
#endif

#ifOption:stylemods
#include:glossaries-extra-stylemods
#endif
#ifOption:stylemods=default
#include:glossaries-extra-stylemods
#endif
#ifOption:stylemods=all
#include:glossaries-extra-stylemods
#include:glossary-inline
#include:glossary-mcols
#include:glossary-longragged
#include:glossary-longbooktabs
#include:glossary-superragged
#include:glossary-bookindex
#include:glossary-longextra
#include:glossary-topic
#include:glossary-table
#endif
#ifOption:stylemods=inline
#include:glossaries-extra-stylemods
#include:glossary-inline
#endif
#ifOption:stylemods=list
#include:glossaries-extra-stylemods
# glossary-list already loaded by glossaries.cwl
#endif
#ifOption:stylemods=tree
#include:glossaries-extra-stylemods
# glossary-tree already loaded by glossaries.cwl
#endif
#ifOption:stylemods=mcols
#include:glossaries-extra-stylemods
#include:glossary-mcols
#endif
#ifOption:stylemods=long
#include:glossaries-extra-stylemods
# glossary-long already loaded by glossaries.cwl
#endif
#ifOption:stylemods=longragged
#include:glossaries-extra-stylemods
#include:glossary-longragged
#endif
#ifOption:stylemods=longbooktabs
#include:glossaries-extra-stylemods
#include:glossary-longbooktabs
#endif
#ifOption:stylemods=super
#include:glossaries-extra-stylemods
# glossary-super already loaded by glossaries.cwl
#endif
#ifOption:stylemods=superragged
#include:glossaries-extra-stylemods
#include:glossary-superragged
#endif
#ifOption:stylemods=bookindex
#include:glossaries-extra-stylemods
#include:glossary-bookindex
#endif
#ifOption:stylemods=longextra
#include:glossaries-extra-stylemods
#include:glossary-longextra
#endif
#ifOption:stylemods=topic
#include:glossaries-extra-stylemods
#include:glossary-topic
#endif
#ifOption:stylemods=table
#include:glossaries-extra-stylemods
#include:glossary-table
#endif

#ifOption:prefix
#include:glossaries-prefix
\pglsxtrshort{label}#r
\pglsxtrshort[options%keyvals]{label}#r
\pglsxtrshort{label}[insert]#*r
\pglsxtrshort[options%keyvals]{label}[insert]#*r
\Pglsxtrshort{label}#r
\Pglsxtrshort[options%keyvals]{label}#r
\Pglsxtrshort{label}[insert]#*r
\Pglsxtrshort[options%keyvals]{label}[insert]#*r
\PGLSxtrshort{label}#r
\PGLSxtrshort[options%keyvals]{label}#r
\PGLSxtrshort{label}[insert]#*r
\PGLSxtrshort[options%keyvals]{label}[insert]#*r
\pglsxtrshortpl{label}#r
\pglsxtrshortpl[options%keyvals]{label}#r
\pglsxtrshortpl{label}[insert]#*r
\pglsxtrshortpl[options%keyvals]{label}[insert]#*r
\Pglsxtrshortpl{label}#r
\Pglsxtrshortpl[options%keyvals]{label}#r
\Pglsxtrshortpl{label}[insert]#*r
\Pglsxtrshortpl[options%keyvals]{label}[insert]#*r
\PGLSxtrshortpl{label}#r
\PGLSxtrshortpl[options%keyvals]{label}#r
\PGLSxtrshortpl{label}[insert]#*r
\PGLSxtrshortpl[options%keyvals]{label}[insert]#*r
\pglsxtrlong{label}#r
\pglsxtrlong[options%keyvals]{label}#r
\pglsxtrlong{label}[insert]#*r
\pglsxtrlong[options%keyvals]{label}[insert]#*r
\Pglsxtrlong{label}#r
\Pglsxtrlong[options%keyvals]{label}#r
\Pglsxtrlong{label}[insert]#*r
\Pglsxtrlong[options%keyvals]{label}[insert]#*r
\PGLSxtrlong{label}#r
\PGLSxtrlong[options%keyvals]{label}#r
\PGLSxtrlong{label}[insert]#*r
\PGLSxtrlong[options%keyvals]{label}[insert]#*r
\pglsxtrlongpl{label}#r
\pglsxtrlongpl[options%keyvals]{label}#r
\pglsxtrlongpl{label}[insert]#*r
\pglsxtrlongpl[options%keyvals]{label}[insert]#*r
\Pglsxtrlongpl{label}#r
\Pglsxtrlongpl[options%keyvals]{label}#r
\Pglsxtrlongpl{label}[insert]#*r
\Pglsxtrlongpl[options%keyvals]{label}[insert]#*r
\PGLSxtrlongpl{label}#r
\PGLSxtrlongpl[options%keyvals]{label}#r
\PGLSxtrlongpl{label}[insert]#*r
\PGLSxtrlongpl[options%keyvals]{label}[insert]#*r
\pglsfmtshort{label}#*r
\Pglsfmtshort{label}#*r
\PGLSfmtshort{label}#*r
\pglsfmtshortpl{label}#*r
\Pglsfmtshortpl{label}#*r
\PGLSfmtshortpl{label}#*r
\pglsfmtlong{label}#*r
\Pglsfmtlong{label}#*r
\PGLSfmtlong{label}#*r
\pglsfmtlongpl{label}#*r
\Pglsfmtlongpl{label}#*r
\PGLSfmtlongpl{label}#*r
\Pglsxtrtitleshort{label}#*r
\Pglsxtrtitleshortpl{label}#*r
\Pglsxtrtitlelong{label}#*r
\Pglsxtrtitlelongpl{label}#*r
\mpgls{multi-label}
\mpgls[options%keyvals]{multi-label}
\mpgls{multi-label}[insert]#*
\mpgls[options%keyvals]{multi-label}[insert]#*
\mpglspl{multi-label}
\mpglspl[options%keyvals]{multi-label}
\mpglspl{multi-label}[insert]#*
\mpglspl[options%keyvals]{multi-label}[insert]#*
\mpglsmainpl{multi-label}
\mpglsmainpl[options%keyvals]{multi-label}
\mpglsmainpl{multi-label}[insert]#*
\mpglsmainpl[options%keyvals]{multi-label}[insert]#*
\Mpgls{multi-label}
\Mpgls[options%keyvals]{multi-label}
\Mpgls{multi-label}[insert]#*
\Mpgls[options%keyvals]{multi-label}[insert]#*
\Mpglspl{multi-label}
\Mpglspl[options%keyvals]{multi-label}
\Mpglspl{multi-label}[insert]#*
\Mpglspl[options%keyvals]{multi-label}[insert]#*
\Mpglsmainpl{multi-label}
\Mpglsmainpl[options%keyvals]{multi-label}
\Mpglsmainpl{multi-label}[insert]#*
\Mpglsmainpl[options%keyvals]{multi-label}[insert]#*
\MPGls{multi-label}
\MPGls[options%keyvals]{multi-label}
\MPGls{multi-label}[insert]#*
\MPGls[options%keyvals]{multi-label}[insert]#*
\MPGlspl{multi-label}
\MPGlspl[options%keyvals]{multi-label}
\MPGlspl{multi-label}[insert]#*
\MPGlspl[options%keyvals]{multi-label}[insert]#*
\MPGlsmainpl{multi-label}
\MPGlsmainpl[options%keyvals]{multi-label}
\MPGlsmainpl{multi-label}[insert]#*
\MPGlsmainpl[options%keyvals]{multi-label}[insert]#*
\MPGLS{multi-label}
\MPGLS[options%keyvals]{multi-label}
\MPGLS{multi-label}[insert]#*
\MPGLS[options%keyvals]{multi-label}[insert]#*
\MPGLSpl{multi-label}
\MPGLSpl[options%keyvals]{multi-label}
\MPGLSpl{multi-label}[insert]#*
\MPGLSpl[options%keyvals]{multi-label}[insert]#*
\MPGLSmainpl{multi-label}
\MPGLSmainpl[options%keyvals]{multi-label}
\MPGLSmainpl{multi-label}[insert]#*
\MPGLSmainpl[options%keyvals]{multi-label}[insert]#*
\pglsprefix{arg1}{arg2}#S
\Pglsprefix{arg1}{arg2}#S
\PGLSprefix{arg1}{arg2}#S
#endif

#ifOption:accsupp
#include:glossaries-accsupp
#endif

## options shortcuts=ac,acother,all,acronyms,acro,true provide these
\acs{label}#*r
\acs[options%keyvals]{label}#*r
\acs{label}[insert]#*r
\acs[options%keyvals]{label}[insert]#*r
\acs*{label}#Sr
\acs*[options%keyvals]{label}#Sr
\acs*{label}[insert]#Sr
\acs*[options%keyvals]{label}[insert]#Sr
\acs+{label}#Sr
\acs+[options%keyvals]{label}#Sr
\acs+{label}[insert]#Sr
\acs+[options%keyvals]{label}[insert]#Sr
\Acs{label}#*r
\Acs[options%keyvals]{label}#*r
\Acs{label}[insert]#*r
\Acs[options%keyvals]{label}[insert]#*r
\Acs*{label}#Sr
\Acs*[options%keyvals]{label}#Sr
\Acs*{label}[insert]#Sr
\Acs*[options%keyvals]{label}[insert]#Sr
\Acs+{label}#Sr
\Acs+[options%keyvals]{label}#Sr
\Acs+{label}[insert]#Sr
\Acs+[options%keyvals]{label}[insert]#Sr
\ACS{label}#*r
\ACS[options%keyvals]{label}#*r
\ACS{label}[insert]#*r
\ACS[options%keyvals]{label}[insert]#*r
\ACS*{label}#Sr
\ACS*[options%keyvals]{label}#Sr
\ACS*{label}[insert]#Sr
\ACS*[options%keyvals]{label}[insert]#Sr
\ACS+{label}#Sr
\ACS+[options%keyvals]{label}#Sr
\ACS+{label}[insert]#Sr
\ACS+[options%keyvals]{label}[insert]#Sr
\acsp{label}#*r
\acsp[options%keyvals]{label}#*r
\acsp{label}[insert]#*r
\acsp[options%keyvals]{label}[insert]#*r
\acsp*{label}#Sr
\acsp*[options%keyvals]{label}#Sr
\acsp*{label}[insert]#Sr
\acsp*[options%keyvals]{label}[insert]#Sr
\acsp+{label}#Sr
\acsp+[options%keyvals]{label}#Sr
\acsp+{label}[insert]#Sr
\acsp+[options%keyvals]{label}[insert]#Sr
\Acsp{label}#*r
\Acsp[options%keyvals]{label}#*r
\Acsp{label}[insert]#*r
\Acsp[options%keyvals]{label}[insert]#*r
\Acsp*{label}#Sr
\Acsp*[options%keyvals]{label}#Sr
\Acsp*{label}[insert]#Sr
\Acsp*[options%keyvals]{label}[insert]#Sr
\Acsp+{label}#Sr
\Acsp+[options%keyvals]{label}#Sr
\Acsp+{label}[insert]#Sr
\Acsp+[options%keyvals]{label}[insert]#Sr
\ACSP{label}#*r
\ACSP[options%keyvals]{label}#*r
\ACSP{label}[insert]#*r
\ACSP[options%keyvals]{label}[insert]#*r
\ACSP*{label}#Sr
\ACSP*[options%keyvals]{label}#Sr
\ACSP*{label}[insert]#Sr
\ACSP*[options%keyvals]{label}[insert]#Sr
\ACSP+{label}#Sr
\ACSP+[options%keyvals]{label}#Sr
\ACSP+{label}[insert]#Sr
\ACSP+[options%keyvals]{label}[insert]#Sr
\acl{label}#*r
\acl[options%keyvals]{label}#*r
\acl{label}[insert]#*r
\acl[options%keyvals]{label}[insert]#*r
\acl*{label}#Sr
\acl*[options%keyvals]{label}#Sr
\acl*{label}[insert]#Sr
\acl*[options%keyvals]{label}[insert]#Sr
\acl+{label}#Sr
\acl+[options%keyvals]{label}#Sr
\acl+{label}[insert]#Sr
\acl+[options%keyvals]{label}[insert]#Sr
\Acl{label}#*r
\Acl[options%keyvals]{label}#*r
\Acl{label}[insert]#*r
\Acl[options%keyvals]{label}[insert]#*r
\Acl*{label}#Sr
\Acl*[options%keyvals]{label}#Sr
\Acl*{label}[insert]#Sr
\Acl*[options%keyvals]{label}[insert]#Sr
\Acl+{label}#Sr
\Acl+[options%keyvals]{label}#Sr
\Acl+{label}[insert]#Sr
\Acl+[options%keyvals]{label}[insert]#Sr
\ACL{label}#*r
\ACL[options%keyvals]{label}#*r
\ACL{label}[insert]#*r
\ACL[options%keyvals]{label}[insert]#*r
\ACL*{label}#Sr
\ACL*[options%keyvals]{label}#Sr
\ACL*{label}[insert]#Sr
\ACL*[options%keyvals]{label}[insert]#Sr
\ACL+{label}#Sr
\ACL+[options%keyvals]{label}#Sr
\ACL+{label}[insert]#Sr
\ACL+[options%keyvals]{label}[insert]#Sr
\aclp{label}#*r
\aclp[options%keyvals]{label}#*r
\aclp{label}[insert]#*r
\aclp[options%keyvals]{label}[insert]#*r
\aclp*{label}#Sr
\aclp*[options%keyvals]{label}#Sr
\aclp*{label}[insert]#Sr
\aclp*[options%keyvals]{label}[insert]#Sr
\aclp+{label}#Sr
\aclp+[options%keyvals]{label}#Sr
\aclp+{label}[insert]#Sr
\aclp+[options%keyvals]{label}[insert]#Sr
\Aclp{label}#*r
\Aclp[options%keyvals]{label}#*r
\Aclp{label}[insert]#*r
\Aclp[options%keyvals]{label}[insert]#*r
\Aclp*{label}#Sr
\Aclp*[options%keyvals]{label}#Sr
\Aclp*{label}[insert]#Sr
\Aclp*[options%keyvals]{label}[insert]#Sr
\Aclp+{label}#Sr
\Aclp+[options%keyvals]{label}#Sr
\Aclp+{label}[insert]#Sr
\Aclp+[options%keyvals]{label}[insert]#Sr
\ACLP{label}#*r
\ACLP[options%keyvals]{label}#*r
\ACLP{label}[insert]#*r
\ACLP[options%keyvals]{label}[insert]#*r
\ACLP*{label}#Sr
\ACLP*[options%keyvals]{label}#Sr
\ACLP*{label}[insert]#Sr
\ACLP*[options%keyvals]{label}[insert]#Sr
\ACLP+{label}#Sr
\ACLP+[options%keyvals]{label}#Sr
\ACLP+{label}[insert]#Sr
\ACLP+[options%keyvals]{label}[insert]#Sr
\acf{label}#*r
\acf[options%keyvals]{label}#*r
\acf{label}[insert]#*r
\acf[options%keyvals]{label}[insert]#*r
\acf*{label}#Sr
\acf*[options%keyvals]{label}#Sr
\acf*{label}[insert]#Sr
\acf*[options%keyvals]{label}[insert]#Sr
\acf+{label}#Sr
\acf+[options%keyvals]{label}#Sr
\acf+{label}[insert]#Sr
\acf+[options%keyvals]{label}[insert]#Sr
\Acf{label}#*r
\Acf[options%keyvals]{label}#*r
\Acf{label}[insert]#*r
\Acf[options%keyvals]{label}[insert]#*r
\Acf*{label}#Sr
\Acf*[options%keyvals]{label}#Sr
\Acf*{label}[insert]#Sr
\Acf*[options%keyvals]{label}[insert]#Sr
\Acf+{label}#Sr
\Acf+[options%keyvals]{label}#Sr
\Acf+{label}[insert]#Sr
\Acf+[options%keyvals]{label}[insert]#Sr
\ACF{label}#*r
\ACF[options%keyvals]{label}#*r
\ACF{label}[insert]#*r
\ACF[options%keyvals]{label}[insert]#*r
\ACF*{label}#Sr
\ACF*[options%keyvals]{label}#Sr
\ACF*{label}[insert]#Sr
\ACF*[options%keyvals]{label}[insert]#Sr
\ACF+{label}#Sr
\ACF+[options%keyvals]{label}#Sr
\ACF+{label}[insert]#Sr
\ACF+[options%keyvals]{label}[insert]#Sr
\acfp{label}#*r
\acfp[options%keyvals]{label}#*r
\acfp{label}[insert]#*r
\acfp[options%keyvals]{label}[insert]#*r
\acfp*{label}#Sr
\acfp*[options%keyvals]{label}#Sr
\acfp*{label}[insert]#Sr
\acfp*[options%keyvals]{label}[insert]#Sr
\acfp+{label}#Sr
\acfp+[options%keyvals]{label}#Sr
\acfp+{label}[insert]#Sr
\acfp+[options%keyvals]{label}[insert]#Sr
\Acfp{label}#*r
\Acfp[options%keyvals]{label}#*r
\Acfp{label}[insert]#*r
\Acfp[options%keyvals]{label}[insert]#*r
\Acfp*{label}#Sr
\Acfp*[options%keyvals]{label}#Sr
\Acfp*{label}[insert]#Sr
\Acfp*[options%keyvals]{label}[insert]#Sr
\Acfp+{label}#Sr
\Acfp+[options%keyvals]{label}#Sr
\Acfp+{label}[insert]#Sr
\Acfp+[options%keyvals]{label}[insert]#Sr
\ACFP{label}#*r
\ACFP[options%keyvals]{label}#*r
\ACFP{label}[insert]#*r
\ACFP[options%keyvals]{label}[insert]#*r
\ACFP*{label}#Sr
\ACFP*[options%keyvals]{label}#Sr
\ACFP*{label}[insert]#Sr
\ACFP*[options%keyvals]{label}[insert]#Sr
\ACFP+{label}#Sr
\ACFP+[options%keyvals]{label}#Sr
\ACFP+{label}[insert]#Sr
\ACFP+[options%keyvals]{label}[insert]#Sr
\ac{label}#*r
\ac[options%keyvals]{label}#*r
\ac{label}[insert]#*r
\ac[options%keyvals]{label}[insert]#*r
\Ac{label}#*r
\Ac[options%keyvals]{label}#*r
\Ac{label}[insert]#*r
\Ac[options%keyvals]{label}[insert]#*r
\ac*{label}#Sr
\ac*[options%keyvals]{label}#Sr
\ac*{label}[insert]#Sr
\ac*[options%keyvals]{label}[insert]#Sr
\Ac*{label}#Sr
\Ac*[options%keyvals]{label}#Sr
\Ac*{label}[insert]#Sr
\Ac*[options%keyvals]{label}[insert]#Sr
\ac+{label}#Sr
\ac+[options%keyvals]{label}#Sr
\ac+{label}[insert]#Sr
\ac+[options%keyvals]{label}[insert]#Sr
\Ac+{label}#Sr
\Ac+[options%keyvals]{label}#Sr
\Ac+{label}[insert]#Sr
\Ac+[options%keyvals]{label}[insert]#Sr
\AC{label}#*r
\AC[options%keyvals]{label}#*r
\AC{label}[insert]#*r
\AC[options%keyvals]{label}[insert]#*r
\AC*{label}#Sr
\AC*[options%keyvals]{label}#Sr
\AC*{label}[insert]#Sr
\AC*[options%keyvals]{label}[insert]#Sr
\AC+{label}#Sr
\AC+[options%keyvals]{label}#Sr
\AC+{label}[insert]#Sr
\AC+[options%keyvals]{label}[insert]#Sr
\acp{label}#*r
\acp[options%keyvals]{label}#*r
\acp{label}[insert]#*r
\acp[options%keyvals]{label}[insert]#*r
\Acp{label}#*r
\Acp[options%keyvals]{label}#*r
\Acp{label}[insert]#*r
\Acp[options%keyvals]{label}[insert]#*r
\acp*{label}#Sr
\acp*[options%keyvals]{label}#Sr
\acp*{label}[insert]#Sr
\acp*[options%keyvals]{label}[insert]#Sr
\Acp*{label}#Sr
\Acp*[options%keyvals]{label}#Sr
\Acp*{label}[insert]#Sr
\Acp*[options%keyvals]{label}[insert]#Sr
\acp+{label}#Sr
\acp+[options%keyvals]{label}#Sr
\acp+{label}[insert]#Sr
\acp+[options%keyvals]{label}[insert]#Sr
\Acp+{label}#Sr
\Acp+[options%keyvals]{label}#Sr
\Acp+{label}[insert]#Sr
\Acp+[options%keyvals]{label}[insert]#Sr
\ACP{label}#*r
\ACP[options%keyvals]{label}#*r
\ACP{label}[insert]#*r
\ACP[options%keyvals]{label}[insert]#*r
\ACP*{label}#Sr
\ACP*[options%keyvals]{label}#Sr
\ACP*{label}[insert]#Sr
\ACP*[options%keyvals]{label}[insert]#Sr
\ACP+{label}#Sr
\ACP+[options%keyvals]{label}#Sr
\ACP+{label}[insert]#Sr
\ACP+[options%keyvals]{label}[insert]#Sr

## options shortcuts=abbreviations,abbr,abother,all,true provide these
\ab{label}#*r
\ab[options%keyvals]{label}#*r
\ab{label}[insert]#*r
\ab[options%keyvals]{label}[insert]#*r
\ab*{label}#Sr
\ab*[options%keyvals]{label}#Sr
\ab*{label}[insert]#Sr
\ab*[options%keyvals]{label}[insert]#Sr
\ab+{label}#Sr
\ab+[options%keyvals]{label}#Sr
\ab+{label}[insert]#Sr
\ab+[options%keyvals]{label}[insert]#Sr
\abp{label}#*r
\abp[options%keyvals]{label}#*r
\abp{label}[insert]#*r
\abp[options%keyvals]{label}[insert]#*r
\abp*{label}#Sr
\abp*[options%keyvals]{label}#Sr
\abp*{label}[insert]#Sr
\abp*[options%keyvals]{label}[insert]#Sr
\abp+{label}#Sr
\abp+[options%keyvals]{label}#Sr
\abp+{label}[insert]#Sr
\abp+[options%keyvals]{label}[insert]#Sr
\as{label}#*r
\as[options%keyvals]{label}#*r
\as{label}[insert]#*r
\as[options%keyvals]{label}[insert]#*r
\as*{label}#Sr
\as*[options%keyvals]{label}#Sr
\as*{label}[insert]#Sr
\as*[options%keyvals]{label}[insert]#Sr
\as+{label}#Sr
\as+[options%keyvals]{label}#Sr
\as+{label}[insert]#Sr
\as+[options%keyvals]{label}[insert]#Sr
\asp{label}#*r
\asp[options%keyvals]{label}#*r
\asp{label}[insert]#*r
\asp[options%keyvals]{label}[insert]#*r
\asp*{label}#Sr
\asp*[options%keyvals]{label}#Sr
\asp*{label}[insert]#Sr
\asp*[options%keyvals]{label}[insert]#Sr
\asp+{label}#Sr
\asp+[options%keyvals]{label}#Sr
\asp+{label}[insert]#Sr
\asp+[options%keyvals]{label}[insert]#Sr
\al{label}#*r
\al[options%keyvals]{label}#*r
\al{label}[insert]#*r
\al[options%keyvals]{label}[insert]#*r
\al*{label}#Sr
\al*[options%keyvals]{label}#Sr
\al*{label}[insert]#Sr
\al*[options%keyvals]{label}[insert]#Sr
\al+{label}#Sr
\al+[options%keyvals]{label}#Sr
\al+{label}[insert]#Sr
\al+[options%keyvals]{label}[insert]#Sr
\alp{label}#*r
\alp[options%keyvals]{label}#*r
\alp{label}[insert]#*r
\alp[options%keyvals]{label}[insert]#*r
\alp*{label}#Sr
\alp*[options%keyvals]{label}#Sr
\alp*{label}[insert]#Sr
\alp*[options%keyvals]{label}[insert]#Sr
\alp+{label}#Sr
\alp+[options%keyvals]{label}#Sr
\alp+{label}[insert]#Sr
\alp+[options%keyvals]{label}[insert]#Sr
\af{label}#*r
\af[options%keyvals]{label}#*r
\af{label}[insert]#*r
\af[options%keyvals]{label}[insert]#*r
\af*{label}#Sr
\af*[options%keyvals]{label}#Sr
\af*{label}[insert]#Sr
\af*[options%keyvals]{label}[insert]#Sr
\af+{label}#Sr
\af+[options%keyvals]{label}#Sr
\af+{label}[insert]#Sr
\af+[options%keyvals]{label}[insert]#Sr
\afp{label}#*r
\afp[options%keyvals]{label}#*r
\afp{label}[insert]#*r
\afp[options%keyvals]{label}[insert]#*r
\afp*{label}#Sr
\afp*[options%keyvals]{label}#Sr
\afp*{label}[insert]#Sr
\afp*[options%keyvals]{label}[insert]#Sr
\afp+{label}#Sr
\afp+[options%keyvals]{label}#Sr
\afp+{label}[insert]#Sr
\afp+[options%keyvals]{label}[insert]#Sr
\Ab{label}#*r
\Ab[options%keyvals]{label}#*r
\Ab{label}[insert]#*r
\Ab[options%keyvals]{label}[insert]#*r
\Ab*{label}#Sr
\Ab*[options%keyvals]{label}#Sr
\Ab*{label}[insert]#Sr
\Ab*[options%keyvals]{label}[insert]#Sr
\Ab+{label}#Sr
\Ab+[options%keyvals]{label}#Sr
\Ab+{label}[insert]#Sr
\Ab+[options%keyvals]{label}[insert]#Sr
\Abp{label}#*r
\Abp[options%keyvals]{label}#*r
\Abp{label}[insert]#*r
\Abp[options%keyvals]{label}[insert]#*r
\Abp*{label}#Sr
\Abp*[options%keyvals]{label}#Sr
\Abp*{label}[insert]#Sr
\Abp*[options%keyvals]{label}[insert]#Sr
\Abp+{label}#Sr
\Abp+[options%keyvals]{label}#Sr
\Abp+{label}[insert]#Sr
\Abp+[options%keyvals]{label}[insert]#Sr
\As{label}#*r
\As[options%keyvals]{label}#*r
\As{label}[insert]#*r
\As[options%keyvals]{label}[insert]#*r
\As*{label}#Sr
\As*[options%keyvals]{label}#Sr
\As*{label}[insert]#Sr
\As*[options%keyvals]{label}[insert]#Sr
\As+{label}#Sr
\As+[options%keyvals]{label}#Sr
\As+{label}[insert]#Sr
\As+[options%keyvals]{label}[insert]#Sr
\Asp{label}#*r
\Asp[options%keyvals]{label}#*r
\Asp{label}[insert]#*r
\Asp[options%keyvals]{label}[insert]#*r
\Asp*{label}#Sr
\Asp*[options%keyvals]{label}#Sr
\Asp*{label}[insert]#Sr
\Asp*[options%keyvals]{label}[insert]#Sr
\Asp+{label}#Sr
\Asp+[options%keyvals]{label}#Sr
\Asp+{label}[insert]#Sr
\Asp+[options%keyvals]{label}[insert]#Sr
\Al{label}#*r
\Al[options%keyvals]{label}#*r
\Al{label}[insert]#*r
\Al[options%keyvals]{label}[insert]#*r
\Al*{label}#Sr
\Al*[options%keyvals]{label}#Sr
\Al*{label}[insert]#Sr
\Al*[options%keyvals]{label}[insert]#Sr
\Al+{label}#Sr
\Al+[options%keyvals]{label}#Sr
\Al+{label}[insert]#Sr
\Al+[options%keyvals]{label}[insert]#Sr
\Alp{label}#*r
\Alp[options%keyvals]{label}#*r
\Alp{label}[insert]#*r
\Alp[options%keyvals]{label}[insert]#*r
\Alp*{label}#Sr
\Alp*[options%keyvals]{label}#Sr
\Alp*{label}[insert]#Sr
\Alp*[options%keyvals]{label}[insert]#Sr
\Alp+{label}#Sr
\Alp+[options%keyvals]{label}#Sr
\Alp+{label}[insert]#Sr
\Alp+[options%keyvals]{label}[insert]#Sr
\Af{label}#*r
\Af[options%keyvals]{label}#*r
\Af{label}[insert]#*r
\Af[options%keyvals]{label}[insert]#*r
\Af*{label}#Sr
\Af*[options%keyvals]{label}#Sr
\Af*{label}[insert]#Sr
\Af*[options%keyvals]{label}[insert]#Sr
\Af+{label}#Sr
\Af+[options%keyvals]{label}#Sr
\Af+{label}[insert]#Sr
\Af+[options%keyvals]{label}[insert]#Sr
\Afp{label}#*r
\Afp[options%keyvals]{label}#*r
\Afp{label}[insert]#*r
\Afp[options%keyvals]{label}[insert]#*r
\Afp*{label}#Sr
\Afp*[options%keyvals]{label}#Sr
\Afp*{label}[insert]#Sr
\Afp*[options%keyvals]{label}[insert]#Sr
\Afp+{label}#Sr
\Afp+[options%keyvals]{label}#Sr
\Afp+{label}[insert]#Sr
\Afp+[options%keyvals]{label}[insert]#Sr
\AB{label}#*r
\AB[options%keyvals]{label}#*r
\AB{label}[insert]#*r
\AB[options%keyvals]{label}[insert]#*r
\AB*{label}#Sr
\AB*[options%keyvals]{label}#Sr
\AB*{label}[insert]#Sr
\AB*[options%keyvals]{label}[insert]#Sr
\AB+{label}#Sr
\AB+[options%keyvals]{label}#Sr
\AB+{label}[insert]#Sr
\AB+[options%keyvals]{label}[insert]#Sr
\ABP{label}#*r
\ABP[options%keyvals]{label}#*r
\ABP{label}[insert]#*r
\ABP[options%keyvals]{label}[insert]#*r
\ABP*{label}#Sr
\ABP*[options%keyvals]{label}#Sr
\ABP*{label}[insert]#Sr
\ABP*[options%keyvals]{label}[insert]#Sr
\ABP+{label}#Sr
\ABP+[options%keyvals]{label}#Sr
\ABP+{label}[insert]#Sr
\ABP+[options%keyvals]{label}[insert]#Sr
\AS{label}#*r
\AS[options%keyvals]{label}#*r
\AS{label}[insert]#*r
\AS[options%keyvals]{label}[insert]#*r
\AS*{label}#Sr
\AS*[options%keyvals]{label}#Sr
\AS*{label}[insert]#Sr
\AS*[options%keyvals]{label}[insert]#Sr
\AS+{label}#Sr
\AS+[options%keyvals]{label}#Sr
\AS+{label}[insert]#Sr
\AS+[options%keyvals]{label}[insert]#Sr
\ASP{label}#*r
\ASP[options%keyvals]{label}#*r
\ASP{label}[insert]#*r
\ASP[options%keyvals]{label}[insert]#*r
\ASP*{label}#Sr
\ASP*[options%keyvals]{label}#Sr
\ASP*{label}[insert]#Sr
\ASP*[options%keyvals]{label}[insert]#Sr
\ASP+{label}#Sr
\ASP+[options%keyvals]{label}#Sr
\ASP+{label}[insert]#Sr
\ASP+[options%keyvals]{label}[insert]#Sr
\AL{label}#*r
\AL[options%keyvals]{label}#*r
\AL{label}[insert]#*r
\AL[options%keyvals]{label}[insert]#*r
\AL*{label}#Sr
\AL*[options%keyvals]{label}#Sr
\AL*{label}[insert]#Sr
\AL*[options%keyvals]{label}[insert]#Sr
\AL+{label}#Sr
\AL+[options%keyvals]{label}#Sr
\AL+{label}[insert]#Sr
\AL+[options%keyvals]{label}[insert]#Sr
\ALP{label}#*r
\ALP[options%keyvals]{label}#*r
\ALP{label}[insert]#*r
\ALP[options%keyvals]{label}[insert]#*r
\ALP*{label}#Sr
\ALP*[options%keyvals]{label}#Sr
\ALP*{label}[insert]#Sr
\ALP*[options%keyvals]{label}[insert]#Sr
\ALP+{label}#Sr
\ALP+[options%keyvals]{label}#Sr
\ALP+{label}[insert]#Sr
\ALP+[options%keyvals]{label}[insert]#Sr
\AF{label}#*r
\AF[options%keyvals]{label}#*r
\AF{label}[insert]#*r
\AF[options%keyvals]{label}[insert]#*r
\AF*{label}#Sr
\AF*[options%keyvals]{label}#Sr
\AF*{label}[insert]#Sr
\AF*[options%keyvals]{label}[insert]#Sr
\AF+{label}#Sr
\AF+[options%keyvals]{label}#Sr
\AF+{label}[insert]#Sr
\AF+[options%keyvals]{label}[insert]#Sr
\AFP{label}#*r
\AFP[options%keyvals]{label}#*r
\AFP{label}[insert]#*r
\AFP[options%keyvals]{label}[insert]#*r
\AFP*{label}#Sr
\AFP*[options%keyvals]{label}#Sr
\AFP*{label}[insert]#Sr
\AFP*[options%keyvals]{label}[insert]#Sr
\AFP+{label}#Sr
\AFP+[options%keyvals]{label}#Sr
\AFP+{label}[insert]#Sr
\AFP+[options%keyvals]{label}[insert]#Sr

#ifOption:shortcuts=abbreviations
\newabbr{label}{short}{long}#l
\newabbr[options%keyvals]{label}{short}{long}#l
#endif
#ifOption:shortcuts=abbr
\newabbr{label}{short}{long}#l
\newabbr[options%keyvals]{label}{short}{long}#l
#endif
#ifOption:shortcuts=other
\newentry{label}{keyvals}#l
\newsym{label}{symbol}#l
\newsym[options%keyvals]{label}{symbol}#l
\newnum{label}{number}#l
\newnum[options%keyvals]{label}{number}#l
#endif
#ifOption:shortcuts=acother
\newentry{label}{keyvals}#l
\newsym{label}{symbol}#l
\newsym[options%keyvals]{label}{symbol}#l
\newnum{label}{number}#l
\newnum[options%keyvals]{label}{number}#l
#endif
#ifOption:shortcuts=abother
\newabbr{label}{short}{long}#l
\newabbr[options%keyvals]{label}{short}{long}#l
\newentry{label}{keyvals}#l
\newsym{label}{symbol}#l
\newsym[options%keyvals]{label}{symbol}#l
\newnum{label}{number}#l
\newnum[options%keyvals]{label}{number}#l
#endif
#ifOption:shortcuts=all
\newabbr{label}{short}{long}#l
\newabbr[options%keyvals]{label}{short}{long}#l
\newentry{label}{keyvals}#l
\newsym{label}{symbol}#l
\newsym[options%keyvals]{label}{symbol}#l
\newnum{label}{number}#l
\newnum[options%keyvals]{label}{number}#l
#endif
#ifOption:shortcuts=true
\newabbr{label}{short}{long}#l
\newabbr[options%keyvals]{label}{short}{long}#l
\newentry{label}{keyvals}#l
\newsym{label}{symbol}#l
\newsym[options%keyvals]{label}{symbol}#l
\newnum{label}{number}#l
\newnum[options%keyvals]{label}{number}#l
#endif

#ifOption:record
#include:glossaries-extra-bib2gls
#endif
#ifOption:record=only
#include:glossaries-extra-bib2gls
#endif
#ifOption:record=nameref
#include:glossaries-extra-bib2gls
#endif

# from options inherited from glossaries.sty
#ifOption:translate
#include:translator
#include:tracklang
#endif
#ifOption:translate=true
#include:translator
#include:tracklang
#endif
#ifOption:translate=babel
#include:glossaries-babel
#endif

#ifOption:xindy
## Required Styles ##
\GlsAddXdyStyle{style-name}
\GlsSetXdyStyles{style name list}
## Language and Encodings ##
\GlsSetXdyLanguage{language}
\GlsSetXdyLanguage[glossary-type]{language}
\GlsSetXdyCodePage{codepage}
## Locations and Number lists ##
\GlsAddXdyCounters{counter list}
\GlsAddXdyAttribute{name}
\GlsAddXdyLocation{name}{definition}
\GlsAddXdyLocation[H-prefix]{name}{definition}
\GlsSetXdyLocationClassOrder{location names}
\GlsSetXdyMinRangeLength{integer}
## Glossary Groups ##
\GlsSetXdyFirstLetterAfterDigits{letter}
\GlsSetXdyNumberGroupOrder{relative location}
## other
\GlsAddLetterGroup{name}{xindy code}#*
\GlsAddSortRule{arg1}{arg2}#*
\GlsAddXdyAlphabet{name}{definition}#*
#endif

\glsxtrundeftag#*
\glsxtrundefaction{message}{additional help}#*
\glsxtrsetbibglsaux{basename}#*
\thewrglossary#*
\glsxtrwrglossmark#*
\glsxtrwrglosscountermark{number}#*
\glsxtrshowtargetouter{target-name}#*
\glsxtrshowtargetinner{target-name}#*
\glsshowtargetinnersymleft{name}#*
\glsxtrshowtargetsymbolleft#*
\glsshowtargetinnersymright{name}#*
\glsxtrshowtargetsymbolright#*

### 3 Defining Entries ###
\longnewglossaryentry*{label}{keyvals}{long description}#l

# keys provided by glossaries.sty
#keyvals:\longnewglossaryentry*#c,\newentry#c,\newabbr#c,\newsym#c,\newnum#c,\glsxtrnewsymbol#c,\glsxtrnewnumber#c,\newabbreviation#c
name=%<text%>
description=%<text%>
parent=%<parent-label%>
descriptionplural=%<text%>
text=%<text%>
first=%<text%>
plural=%<text%>
firstplural=%<text%>
symbol=%<symbol%>
symbolplural=%<symbol%>
sort=%<entry%>
type=%<glossary-label%>
user1=%<text%>
user2=%<text%>
user3=%<text%>
user4=%<text%>
user5=%<text%>
user6=%<text%>
nonumberlist#true,false
see={%<xr-list%>}
see={[%<tag%>]%<xr-list%>}
#endkeyvals

# keys provided by glossaries-extra.sty
#keyvals:\newglossaryentry#c,\longnewglossaryentry#c,\provideglossaryentry#c,\longprovideglossaryentry#c,\newacronym#c,\newterm#c,\longnewglossaryentry*#c,\newentry#c,\newabbr#c,\newsym#c,\newnum#c,\glsxtrnewsymbol#c,\glsxtrnewnumber#c,\newabbreviation#c
category=%<category-label%>
seealso={%<xr-list%>}
alias={%<xr-label%>}
#endkeyvals

\glsxtrpostlongdescription#*
\glsxtrprovidestoragekey{key%plain}{default value}{no link cs%cmd}#*d
\glsxtrifkeydefined{key%plain}{true}{false}#*
\glsxtraliashook{label}#*
\glsxtrdeffield{label}{field}{value}#*r
\glsxtredeffield{label}{field}{value}#*r
\glsxtrapptocsvfield{label}{field}{value}#*r
\glsxtrfieldlistadd{label}{field}{value}#*r
\glsxtrfieldlistgadd{label}{field}{value}#*r
\glsxtrfieldlisteadd{label}{field}{value}#*r
\glsxtrfieldlistxadd{label}{field}{value}#*r
\glsxtrsetfieldifexists{label}{field}{code}#*r
\GlsXtrSetField{label}{field}{value}#*r
\gGlsXtrSetField{label}{field}{value}#*r
\eGlsXtrSetField{label}{field}{value}#*r
\xGlsXtrSetField{label}{field}{value}#*r
\GlsXtrLetField{label}{field}{value}#*r
\csGlsXtrLetField{label}{field}{csname}#*r
\GlsXtrLetFieldToField{label1%ref}{field1}{label2%ref}{field2}#*r

### 4 Abbreviations ###
## Defining Abbreviations ##
\newabbreviation{label}{short}{long}#l
\newabbreviation[options%keyvals]{label}{short}{long}#l
\glsxtrabbrvpluralsuffix#*
\glsxtrabbrvtype#*
\glsxtrnewabbrevpresetkeyhook{options}{label}{short}#*
\newabbreviationhook#*

## Referencing (Using) Abbreviations ##
\glsxtrshort{label}#r
\glsxtrshort[options%keyvals]{label}#r
\glsxtrshort{label}[insert]#*r
\glsxtrshort[options%keyvals]{label}[insert]#*r
\Glsxtrshort{label}#r
\Glsxtrshort[options%keyvals]{label}#r
\Glsxtrshort{label}[insert]#*r
\Glsxtrshort[options%keyvals]{label}[insert]#*r
\GLSxtrshort{label}#r
\GLSxtrshort[options%keyvals]{label}#r
\GLSxtrshort{label}[insert]#*r
\GLSxtrshort[options%keyvals]{label}[insert]#*r

\glsxtrshortpl{label}#*r
\glsxtrshortpl[options%keyvals]{label}#*r
\glsxtrshortpl{label}[insert]#*r
\glsxtrshortpl[options%keyvals]{label}[insert]#*r
\Glsxtrshortpl{label}#*r
\Glsxtrshortpl[options%keyvals]{label}#*r
\Glsxtrshortpl{label}[insert]#*r
\Glsxtrshortpl[options%keyvals]{label}[insert]#*r
\GLSxtrshortpl{label}#*r
\GLSxtrshortpl[options%keyvals]{label}#*r
\GLSxtrshortpl{label}[insert]#*r
\GLSxtrshortpl[options%keyvals]{label}[insert]#*r

\glsxtrlong{label}#r
\glsxtrlong[options%keyvals]{label}#r
\glsxtrlong{label}[insert]#*r
\glsxtrlong[options%keyvals]{label}[insert]#*r
\Glsxtrlong{label}#r
\Glsxtrlong[options%keyvals]{label}#r
\Glsxtrlong{label}[insert]#*r
\Glsxtrlong[options%keyvals]{label}[insert]#*r
\GLSxtrlong{label}#r
\GLSxtrlong[options%keyvals]{label}#r
\GLSxtrlong{label}[insert]#*r
\GLSxtrlong[options%keyvals]{label}[insert]#*r

\glsxtrlongpl{label}#*r
\glsxtrlongpl[options%keyvals]{label}#*r
\glsxtrlongpl{label}[insert]#*r
\glsxtrlongpl[options%keyvals]{label}[insert]#*r
\Glsxtrlongpl{label}#*r
\Glsxtrlongpl[options%keyvals]{label}#*r
\Glsxtrlongpl{label}[insert]#*r
\Glsxtrlongpl[options%keyvals]{label}[insert]#*r
\GLSxtrlongpl{label}#*r
\GLSxtrlongpl[options%keyvals]{label}#*r
\GLSxtrlongpl{label}[insert]#*r
\GLSxtrlongpl[options%keyvals]{label}[insert]#*r

\glsxtrfull{label}#r
\glsxtrfull[options%keyvals]{label}#r
\glsxtrfull{label}[insert]#*r
\glsxtrfull[options%keyvals]{label}[insert]#*r
\Glsxtrfull{label}#r
\Glsxtrfull[options%keyvals]{label}#r
\Glsxtrfull{label}[insert]#*r
\Glsxtrfull[options%keyvals]{label}[insert]#*r
\GLSxtrfull{label}#r
\GLSxtrfull[options%keyvals]{label}#r
\GLSxtrfull{label}[insert]#*r
\GLSxtrfull[options%keyvals]{label}[insert]#*r

\glsxtrfullpl{label}#*r
\glsxtrfullpl[options%keyvals]{label}#*r
\glsxtrfullpl{label}[insert]#*r
\glsxtrfullpl[options%keyvals]{label}[insert]#*r
\Glsxtrfullpl{label}#*r
\Glsxtrfullpl[options%keyvals]{label}#*r
\Glsxtrfullpl{label}[insert]#*r
\Glsxtrfullpl[options%keyvals]{label}[insert]#*r
\GLSxtrfullpl{label}#*r
\GLSxtrfullpl[options%keyvals]{label}#*r
\GLSxtrfullpl{label}[insert]#*r
\GLSxtrfullpl[options%keyvals]{label}[insert]#*r

\glsxtrsetlongfirstuse{label}#*
\glsxtrsetupfulldefs#*
\glsxtrfullsaveinsert{label}{insert}#*

## Tagging Initials ##
\GlsXtrEnableInitialTagging{categories}{cmd}#d
\GlsXtrEnableInitialTagging*{categories}{cmd}#d
\glsxtrtagfont{text}#*

## Abbreviation Styles ##
\setabbreviationstyle{style-name%keyvals}
\setabbreviationstyle[category]{style-name%keyvals}

#keyvals:\setabbreviationstyle#c
short-nolong
short
short-nolong-desc
short-desc
nolong-short
short-sc-nolong
short-sc
short-sc-nolong-desc
short-sc-desc
short-sm-nolong
short-sm
short-sm-nolong-desc
short-sm-desc
nolong-short-sm
short-em-nolong
short-em
short-em-nolong-desc
short-em-desc
nolong-short-em
long-noshort-desc
long-desc
long-noshort
long
long-noshort-sc
long-noshort-sc-desc
long-noshort-sm
long-noshort-sm-desc
long-noshort-em
long-noshort-em-desc
long-em-noshort-em
long-em-noshort-em-desc
long-short
long-short-desc
long-short-sc
long-short-sc-desc
long-short-sm
long-short-sm-desc
long-short-em
long-short-em-desc
long-em-short-em
long-em-short-em-desc
long-short-user
long-short-user-desc
long-postshort-user
long-postshort-user-desc
long-postshort-sc-user
long-postshort-sc-user-desc
short-long
short-long-desc
short-sc-long
short-sc-long-desc
short-sm-long
short-sm-long-desc
short-em-long
short-em-long-desc
short-em-long-em
short-em-long-em-desc
short-long-user
short-long-user-desc
short-postlong-user
short-postlong-user-desc
long-hyphen-short-hyphen
long-hyphen-postshort-hyphen
long-hyphen-short-hyphen-desc
long-hyphen-postshort-hyphen-desc
long-hyphen-noshort-desc-noreg
long-hyphen-noshort-noreg
short-hyphen-long-hyphen
short-hyphen-postlong-hyphen
short-hyphen-long-hyphen-desc
short-hyphen-postlong-hyphen-desc
long-only-short-only
long-only-short-only-desc
long-only-short-sc-only
long-only-short-sc-only-desc
short-footnote
footnote
short-footnote-desc
footnote-desc
short-postfootnote
postfootnote
short-postfootnote-desc
postfootnote-desc
short-sc-footnote
short-sc-footnote-desc
short-sc-postfootnote
short-sc-postfootnote-desc
short-sm-footnote
short-sm-footnote-desc
short-sm-postfootnote
short-sm-postfootnote-desc
short-em-footnote
short-em-footnote-desc
short-em-postfootnote
short-em-postfootnote-desc
short-nolong-noreg
short-nolong-desc-noreg
nolong-short-noreg
long-noshort-desc-noreg
long-noshort-noreg
long-em-noshort-em-noreg
long-em-noshort-em-desc-noreg
%abbreviationstyle
#endkeyvals

\ifglsxtrinsertinside#*
\glsxtrinsertinsidetrue#*
\glsxtrinsertinsidefalse#*
\glsxtrparen{text}#*
\glsxtrfullsep{label}#*
\glsabbrvdefaultfont{text}#*
\glsfirstabbrvdefaultfont{text}#*
\glsxtrdefaultrevert{text}#*
\glslongdefaultfont{text}#*
\glsfirstlongdefaultfont{text}#*
\glsxtrlongshortname#*
\glsxtrlongshortdescsort#*
\glsxtrlongshortdescname#*
\glsxtrshortlongname#*
\glsxtrshortlongdescsort#*
\glsxtrshortlongdescname#*
\glsxtruserfield#*
\glsxtruserparensep#*
\glsxtruserfieldfmt{text}#*
\glsabbrvuserfont{text}#*
\glsfirstabbrvuserfont{text}#*
\glsxtrusersuffix#*
\glslonguserfont{text}#*
\glsfirstlonguserfont{text}#*
\glsabbrvscuserfont{text}#*
\glsfirstabbrvscuserfont{text}#*
\glsxtrscuserrevert{text}#*
\glsxtrscusersuffix#*
\glsuserdescription{long}{label}#*
\glsxtruserparen{text}{label}#*
\GLSxtruserparen{text}{label}#*
\glsxtrlongshortuserdescname#*
\glsxtrlongshortscusername#*
\glsxtrlongshortscuserdescname#*
\glsxtrshortlonguserdescname#*
\glsxtruserlongshortformat{label}{insert}{long-cs}{short-cs}#*
\Glsxtruserlongshortformat{label}{insert}{long-cs}{short-cs}#*
\GLSxtruserlongshortformat{label}{insert}{long-cs}{short-cs}#*
\glsxtruserlongshortplformat{label}{insert}{long-cs}{short-cs}#*
\Glsxtruserlongshortplformat{label}{insert}{long-cs}{short-cs}#*
\GLSxtruserlongshortplformat{label}{insert}{long-cs}{short-cs}#*
\glsxtrusershortlongformat{label}{insert}{long-cs}{short-cs}#*
\Glsxtrusershortlongformat{label}{insert}{long-cs}{short-cs}#*
\GLSxtrusershortlongformat{label}{insert}{long-cs}{short-cs}#*
\glsxtrusershortlongplformat{label}{insert}{long-cs}{short-cs}#*
\Glsxtrusershortlongplformat{label}{insert}{long-cs}{short-cs}#*
\GLSxtrusershortlongplformat{label}{insert}{long-cs}{short-cs}#*
\glsxtrusershortformat{label}{fmt-cs}#*
\glsxtrusershortplformat{label}{fmt-cs}#*
\GLSxtrusershortformat{label}{fmt-cs}#*
\GLSxtrusershortplformat{label}{fmt-cs}#*
\glsxtrpostusershortformat{label}{fmt-cs}#*
\glsxtruserlongformat{label}{fmt-cs}#*
\GLSxtruserlongformat{label}{fmt-cs}#*
\glsxtruserlongplformat{label}{fmt-cs}#*
\GLSxtruserlongplformat{label}{fmt-cs}#*
\glsxtrpostuserlongformat{label}{fmt-cs}#*
\glsxtrfootnotename#*
\glsxtrfootnotedescname#*
\glsxtrfootnotedescsort#*
\glslongfootnotefont{text}#*
\glsfirstlongfootnotefont{text}#*
\glsxtrabbrvfootnote{label}{text}#*
\glsxtrfootnotelongformat{label}{fmt-cs}#*
\glsxtrfootnotelongplformat{label}{fmt-cs}#*
\glsxtrpostfootnotelongformat{label}{fmt-cs}#*
\glsxtrshortnolongname#*
\glsxtrshortdescname#*
\glsxtrlongnoshortdescname#*
\glsxtrlongnoshortname#*
\glsabbrvhyphenfont{text}#*
\glsfirstabbrvhyphenfont{text}#*
\glslonghyphenfont{text}#*
\glsfirstlonghyphenfont{text}#*
\glsxtrhyphensuffix#*
\glsxtrlonghyphenshortsort#*
\glsxtrshorthyphenlongsort#*
\glsxtrlonghyphennoshortsort#*
\glsxtrlonghyphennoshortdescsort#*
\glsxtrlonghyphenshort{label}{long}{short}{insert}#*r
\GLSxtrlonghyphenshort{label}{long}{short}{insert}#*r
\glsxtrlonghyphennoshort{label}{long}{insert}#*r
\GLSxtrlonghyphennoshort{label}{long}{insert}#*r
\glsxtrlonghyphen{label}{long}{insert}#*r
\xpglsxtrposthyphenshort#*
\glsxtrposthyphenshort{label}{insert}#*r
\GLSxtrposthyphenshort{label}{insert}#*r
\glsxtrposthyphenshortpl{label}{insert}#*r
\GLSxtrposthyphenshortpl{label}{insert}#*r
\xpglsxtrposthyphensubsequent#*
\glsxtrposthyphensubsequent{label}{insert}#*r
\GLSxtrposthyphensubsequent{label}{insert}#*r
\glsxtrshorthyphenlong{label}{long}{short}{insert}#*r
\GLSxtrshorthyphenlong{label}{long}{short}{insert}#*r
\glsxtrshorthyphen{label}{short}{insert}#*r
\xpglsxtrposthyphenlong#*
\glsxtrposthyphenlong{label}{insert}#*r
\GLSxtrposthyphenlong{label}{insert}#*r
\glsxtrposthyphenlongpl{label}{insert}#*r
\GLSxtrposthyphenlongpl{label}{insert}#*r
\glsabbrvonlyfont{text}#*
\glsfirstabbrvonlyfont{text}#*
\glslongonlyfont{text}#*
\glsfirstlongonlyfont{text}#*
\glsxtronlysuffix#*
\glsabbrvsconlyfont{text}#*
\glsfirstabbrvsconlyfont{text}#*
\glsxtrsconlyrevert{text}#*
\glsxtrsconlysuffix#*
\glsxtronlyname#*
\glsxtronlydescname#*
\glsxtronlydescsort#*
\glsxtrsconlyname#*
\glsxtrsconlydescname#*
\glsxtrsconlydescsort#*
\glsabbrvscfont{text}#*
\glsfirstabbrvscfont{text}#*
\glsxtrscrevert{text}#*
\glsxtrscsuffix#*
\glsabbrvsmfont{text}#*
\glsfirstabbrvsmfont{text}#*
\glsxtrsmrevert{text}#*
\glsxtrsmsuffix#*
\glsabbrvemfont{text}#*
\glsfirstabbrvemfont{text}#*
\glsxtremrevert{text}#*
\glsxtremsuffix#*
\glslongemfont{text}#*
\glsfirstlongemfont{text}#*
\glssetabbrvfmt{category}#*
\glsuseabbrvfont{style-name}{text}#*
\glsuselongfont{style-name}{text}#*
\GlsXtrUseAbbrStyleSetup{style-name}#*
\GlsXtrUseAbbrStyleFmts{style-name}#*
\xpglsxtrpostabbrvfootnote#*
\glsxtrpostabbrvfootnote{label}{fmt-code}#*
\glsxtrifhyphenstart{string}{true}{false}#*
\GlsXtrWarnDeprecatedAbbrStyle{old name}{new name}#*
\newabbreviationstyle{name%specialDef}{setup}{definitions}#*s#%abbreviationstyle
\renewabbreviationstyle{name}{setup}{definitions}#*
\letabbreviationstyle{new-style%specialDef}{existing-style}#*s#%abbreviationstyle
\glscategorylabel#*
\glsxtrorgkeylist#*
\glsxtrorgshort#*
\glsshortpltok#*
\glsxtrorglong#*
\glslongpltok#*
\ExtraCustomAbbreviationFields#*
\CustomAbbreviationFields#*
\GlsXtrPostNewAbbreviation#*
\glsxtrsetcomplexstyle{label}{n}#*
\glsfirstinnerfmtabbrvfont{text}#*
\glsfirstxpabbrvfont{text}{category}#*
\glsinnerfmtabbrvfont{text}#*
\glsxpabbrvfont{text}{category}#*
\glsfirstinnerfmtlongfont{text}#*
\glsfirstxplongfont{text}{category}#*
\glsinnerfmtlongfont{text}#*
\glsxplongfont{text}{category}#*
\glsxtrAccSuppAbbrSetNoLongAttrs{category}#*
\glsxtrAccSuppAbbrSetNameLongAttrs{category}#*
\glsxtrAccSuppAbbrSetFirstLongAttrs{category}#*
\glsxtrAccSuppAbbrSetTextShortAttrs{category}#*
\glsxtrAccSuppAbbrSetNameShortAttrs{category}#*
\abbrvpluralsuffix#*
\glsfirstabbrvfont{text}#*
\glsabbrvfont{text}#*
\glsxtrrevert{text}#*
\glsfirstlongfont{text}#*
\glslongfont{text}#*
\glsxtrfullformat{label}{insert}#*r
\glsxtrfullplformat{label}{insert}#*r
\Glsxtrfullformat{label}{insert}#*r
\Glsxtrfullplformat{label}{insert}#*r
\GLSxtrfullformat{label}{insert}#*r
\GLSxtrfullplformat{label}{insert}#*r
\glsxtrsubsequentfmt{label}{insert}#*r
\glsxtrsubsequentplfmt{label}{insert}#*r
\Glsxtrsubsequentfmt{label}{insert}#*r
\Glsxtrsubsequentplfmt{label}{insert}#*r
\GLSxtrsubsequentfmt{label}{insert}#*r
\GLSxtrsubsequentplfmt{label}{insert}#*r
\glsxtrdefaultsubsequentfmt{label}{insert}#*r
\glsxtrdefaultsubsequentplfmt{label}{insert}#*r
\Glsxtrdefaultsubsequentfmt{label}{insert}#*r
\Glsxtrdefaultsubsequentplfmt{label}{insert}#*r
\GLSxtrdefaultsubsequentfmt{label}{insert}#*r
\GLSxtrdefaultsubsequentplfmt{label}{insert}#*r
\glsxtrinlinefullformat{label}{insert}#*r
\glsxtrinlinefullplformat{label}{insert}#*r
\Glsxtrinlinefullformat{label}{insert}#*r
\Glsxtrinlinefullplformat{label}{insert}#*r
\GLSxtrinlinefullformat{label}{insert}#*r
\GLSxtrinlinefullplformat{label}{insert}#*r
\glsxtrlongformat{label}{insert}{format-cs}#*r
\Glsxtrlongformat{label}{insert}{format-cs}#*r
\GLSxtrlongformat{label}{insert}{format-cs}#*r
\glsxtrlongplformat{label}{insert}{format-cs}#*r
\Glsxtrlongplformat{label}{insert}{format-cs}#*r
\GLSxtrlongplformat{label}{insert}{format-cs}#*r
\glsxtrlongformatgrp{label}{insert}{format-cs}#*r
\Glsxtrlongformatgrp{label}{insert}{format-cs}#*r
\GLSxtrlongformatgrp{label}{insert}{format-cs}#*r
\glsxtrlongplformatgrp{label}{insert}{format-cs}#*r
\Glsxtrlongplformatgrp{label}{insert}{format-cs}#*r
\GLSxtrlongplformatgrp{label}{insert}{format-cs}#*r
\glsxtrshortformat{label}{insert}{format-cs}#*r
\Glsxtrshortformat{label}{insert}{format-cs}#*r
\GLSxtrshortformat{label}{insert}{format-cs}#*r
\glsxtrshortplformat{label}{insert}{format-cs}#*r
\Glsxtrshortplformat{label}{insert}{format-cs}#*r
\GLSxtrshortplformat{label}{insert}{format-cs}#*r
\glsxtrshortformatgrp{label}{insert}{format-cs}#*r
\Glsxtrshortformatgrp{label}{insert}{format-cs}#*r
\GLSxtrshortformatgrp{label}{insert}{format-cs}#*r
\glsxtrshortplformatgrp{label}{insert}{format-cs}#*r
\Glsxtrshortplformatgrp{label}{insert}{format-cs}#*r
\GLSxtrshortplformatgrp{label}{insert}{format-cs}#*r
\glsxtrlongshortformat{label}{insert}{format-cs}#*r
\Glsxtrlongshortformat{label}{insert}{format-cs}#*r
\GLSxtrlongshortformat{label}{insert}{format-cs}#*r
\glsxtrlongshortplformat{label}{insert}{long-cs}{short-cs}#*r
\Glsxtrlongshortplformat{label}{insert}{long-cs}{short-cs}#*r
\GLSxtrlongshortplformat{label}{insert}{long-cs}{short-cs}#*r
\glsxtrshortlongformat{label}{insert}{long-cs}{short-cs}#*r
\Glsxtrshortlongformat{label}{insert}{long-cs}{short-cs}#*r
\GLSxtrshortlongformat{label}{insert}{long-cs}{short-cs}#*r
\glsxtrshortlongplformat{label}{insert}{long-cs}{short-cs}#*r
\Glsxtrshortlongplformat{label}{insert}{long-cs}{short-cs}#*r
\GLSxtrshortlongplformat{label}{insert}{long-cs}{short-cs}#*r

## Restoring Base Acronym Mechanism ##
\RestoreAcronyms#*
\MakeAcronymsAbbreviations#*

### 5 Referencing (Using) Entries ###
\GlsXtrSetAltModifier{token}{options%keyvals}
\GlsXtrSetStarModifier{options%keyvals}
\GlsXtrSetPlusModifier{options%keyvals}
\glslinkwrcontent{code}#*

## Options ##
\GlsXtrSetDefaultGlsOpts{options%keyvals}
\GlsXtrAppToDefaultGlsOpts{options%keyvals}
\GlsXtrPreToDefaultGlsOpts{options%keyvals}
\GlsXtrSetDefaultNumberFormat{encap}
\GlsXtrFmtDefaultOptions#*
\glslinkpresetkeys#*
\glsaddpresetkeys#*
\glsaddpostsetkeys#*
\glsinitreunsets#*
\glsxtrchecknohyperfirst{label}#*r
\glsxtrinitwrgloss#*
\glsxtrinithyperoutside#*
\setupglslink{options%keyvals}
\setupglsadd{options%keyvals}

#keyvals:\gls#c,\Gls#c,\GLS#c,\glspl#c,\Glspl#c,\GLSpl#c,\glsdisp#c,\Glsdisp#c,\glslink#c,\Glslink#c,\glstext#c,\Glstext#c,\GLStext#c,\glsfirst#c,\Glsfirst#c,\GLSfirst#c,\glsplural#c,\Glsplural#c,\GLSplural#c,\glsfirstplural#c,\Glsfirstplural#c,\GLSfirstplural#c,\glsname#c,\Glsname#c,\GLSname#c,\glssymbol#c,\Glssymbol#c,\GLSsymbol#c,\glssymbolplural#c,\Glssymbolplural#c,\GLSsymbolplural#c,\glsdesc#c,\Glsdesc#c,\GLSdesc#c,\glsdescplural#c,\Glsdescplural#c,\GLSdescplural#c,\glsuseri#c,\Glsuseri#c,\GLSuseri#c,\glsuserii#c,\Glsuserii#c,\GLSuserii#c,\glsuseriii#c,\Glsuseriii#c,\GLSuseriii#c,\glsuseriv#c,\Glsuseriv#c,\GLSuseriv#c,\glsuserv#c,\Glsuserv#c,\GLSuserv#c,\glsuservi#c,\Glsuservi#c,\GLSuservi#c,\cgls#c,\cGls#c,\cglspl#c,\cGlspl#c,\acrshort#c,\Acrshort#c,\acrshortpl#c,\Acrshortpl#c,\acrlong#c,\Acrlong#c,\acrlongpl#c,\Acrlongpl#c,\acrfull#c,\Acrfull#c,\acrfullpl#c,\Acrfullpl#c,\acs#c,\Acs#c,\acsp#c,\Acsp#c,\acl#c,\Acl#c,\aclp#c,\Aclp#c,\acf#c,\Acf#c,\acfp#c,\Acfp#c,\ac#c,\Ac#c,\acp#c,\Acp#c,\acrfullfmt#c,\ACRfullfmt#c,\Acrfullfmt#c,\ACRfullplfmt#c,\Acrfullplfmt#c,\acrfullplfmt#c,\GlsXtrSetAltModifier#c,\GlsXtrSetStarModifier#c,\GlsXtrSetPlusModifier#c,\GlsXtrSetDefaultGlsOpts#c,\GlsXtrAppToDefaultGlsOpts#c,\GlsXtrPreToDefaultGlsOpts#c,\setupglslink#c,\glsxtrsetpopts#c,\glsxtrnewgls#c,\glsxtrnewglslike#c,\glsxtrnewGLSlike#c,\glsxtrnewglslink#c,\glsxtrnewglsdisp#c,\glsxtrnewrgls#c,\glsxtrnewrglslike#c,\glsxtrnewrGLSlike#c,\glsxtrfmt#c,\glsxtrfmt*#c,\Glsxtrfmt#c,\Glsxtrfmt*#c,\cGLS#c,\cGLS*#c,\cGLS+#c,\cGLSpl#c,\cGLSpl*#c,\cGLSpl+#c,\rgls#c,\rgls*#c,\rgls+#c,\rGls#c,\rGls*#c,\rGls+#c,\rGLS#c,\rGLS*#c,\rGLS+#c,\rglspl#c,\rglspl*#c,\rglspl+#c,\rGlspl#c,\rGlspl*#c,\rGlspl+#c,\rGLSpl#c,\rGLSpl*#c,\rGLSpl+#c,\glsxtr#c,\glsxtrpl#c,\Glsxtr#c,\Glsxtrpl#c
hyperoutside#true,false
textformat=%<csname%>
innertextformat=%<csname%>
postunset=#global,local,none
prereset
prereset=#global,local,none
preunset=#global,local,none
noindex#true,false
wrgloss=#before,after
thevalue=%<location%>
theHvalue=%<the-H-value%>
prefix=%<link-prefix%>
#endkeyvals

#keyvals:\GlsXtrSetAltModifier#c,\GlsXtrSetStarModifier#c,\GlsXtrSetPlusModifier#c,\GlsXtrSetDefaultGlsOpts#c,\GlsXtrAppToDefaultGlsOpts#c,\GlsXtrPreToDefaultGlsOpts#c,\setupglslink#c,\glsxtrsetpopts#c,\glsxtrnewgls#c,\glsxtrnewglslike#c,\glsxtrnewGLSlike#c,\glsxtrnewglslink#c,\glsxtrnewglsdisp#c,\glsxtrfmt#c,\glsxtrfmt*#c,\Glsxtrfmt#c,\Glsxtrfmt*#c,\cGLS#c,\cGLS*#c,\cGLS+#c,\cGLSpl#c,\cGLSpl*#c,\cGLSpl+#c,\rgls#c,\rgls*#c,\rgls+#c,\rGls#c,\rGls*#c,\rGls+#c,\rGLS#c,\rGLS*#c,\rGLS+#c,\rglspl#c,\rglspl*#c,\rglspl+#c,\rGlspl#c,\rGlspl*#c,\rGlspl+#c,\rGLSpl#c,\rGLSpl*#c,\rGLSpl+#c,\glsxtr#c,\glsxtrpl#c,\Glsxtr#c,\Glsxtrpl#c
hyper#true,false
format=%<csname%>
counter=%<counter%>
local#true,false
#endkeyvals

#keyvals:\setupglsadd#c,\glsaddeach#c,\glsstartrange#c,\glsendrange#c,\GlsXtrAutoAddOnFormat#c
format=%<csname%>
counter=%<counter%>
local#true,false
#endkeyvals

#keyvals:\glsadd#c,\glsaddall#c,\setupglsadd#c,\glsaddeach#c,\glsstartrange#c,\glsendrange#c,\GlsXtrAutoAddOnFormat#c
thevalue=%<location%>
theHvalue=%<<prefix><location>%>
#endkeyvals

\ifglsxtrinitwrgloss#*
\glsxtrinitwrglosstrue#*
\glsxtrinitwrglossfalse#*
\glsxtrsupphypernumber{location}#*

## Entries in Sectioning Titles, Headers, Captions and Contents ##
\glsxtrRevertMarks
\glsxtrRevertTocMarks
\glsxtrtitleopts#*
\glsfmtshort{label}#*r
\Glsfmtshort{label}#*r
\GLSfmtshort{label}#*r
\glsfmtshortpl{label}#*r
\Glsfmtshortpl{label}#*r
\GLSfmtshortpl{label}#*r
\glsfmtlong{label}#*r
\Glsfmtlong{label}#*r
\GLSfmtlong{label}#*r
\glsfmtlongpl{label}#*r
\Glsfmtlongpl{label}#*r
\GLSfmtlongpl{label}#*r
\glspdffmtfull{label}#*r
\glspdffmtfullpl{label}#*r
\glsfmtfull{label}#*r
\Glsfmtfull{label}#*r
\GLSfmtfull{label}#*r
\glsfmtfullpl{label}#*r
\Glsfmtfullpl{label}#*r
\GLSfmtfullpl{label}#*r
\glsfmtname{label}#*r
\Glsfmtname{label}#*r
\GLSfmtname{label}#*r
\glsfmttext{label}#*r
\Glsfmttext{label}#*r
\GLSfmttext{label}#*r
\glsfmtplural{label}#*r
\Glsfmtplural{label}#*r
\GLSfmtplural{label}#*r
\glsfmtfirst{label}#*r
\Glsfmtfirst{label}#*r
\GLSfmtfirst{label}#*r
\glsfmtfirstpl{label}#*r
\Glsfmtfirstpl{label}#*r
\GLSfmtfirstpl{label}#*r
\glsxtrifinmark{true}{false}#*
\glsxtrifintoc{true}{false}#*
\glsxtrtitleorpdforheading{title%text}{PDF bookmarks%text}{heading%text}
\glsxtrifheaduc{label}{true}{false}#*r
\glsxtrtitleshort{label}#*r
\glsxtrheadshort{label}#*r
\Glsxtrtitleshort{label}#*r
\Glsxtrheadshort{label}#*r
\GLSxtrtitleshort{label}#*r
\GLSxtrheadshort{label}#*r
\glsxtrtitleshortpl{label}#*r
\glsxtrheadshortpl{label}#*r
\Glsxtrtitleshortpl{label}#*r
\Glsxtrheadshortpl{label}#*r
\GLSxtrtitleshortpl{label}#*r
\GLSxtrheadshortpl{label}#*r
\glsxtrtitlelong{label}#*r
\glsxtrheadlong{label}#*r
\Glsxtrtitlelong{label}#*r
\Glsxtrheadlong{label}#*r
\GLSxtrtitlelong{label}#*r
\GLSxtrheadlong{label}#*r
\glsxtrtitlelongpl{label}#*r
\glsxtrheadlongpl{label}#*r
\Glsxtrtitlelongpl{label}#*r
\Glsxtrheadlongpl{label}#*r
\GLSxtrtitlelongpl{label}#*r
\GLSxtrheadlongpl{label}#*r
\glsxtrtitlefull{label}#*r
\glsxtrheadfull{label}#*r
\Glsxtrtitlefull{label}#*r
\Glsxtrheadfull{label}#*r
\GLSxtrtitlefull{label}#*r
\GLSxtrheadfull{label}#*r
\glsxtrtitlefullpl{label}#*r
\glsxtrheadfullpl{label}#*r
\Glsxtrtitlefullpl{label}#*r
\Glsxtrheadfullpl{label}#*r
\GLSxtrtitlefullpl{label}#*r
\GLSxtrheadfullpl{label}#*r
\glsxtrtitlename{label}#*r
\glsxtrheadname{label}#*r
\Glsxtrtitlename{label}#*r
\Glsxtrheadname{label}#*r
\GLSxtrtitlename{label}#*r
\GLSxtrheadname{label}#*r
\glsxtrtitletext{label}#*r
\glsxtrheadtext{label}#*r
\Glsxtrtitletext{label}#*r
\Glsxtrheadtext{label}#*r
\GLSxtrtitletext{label}#*r
\GLSxtrheadtext{label}#*r
\glsxtrtitleplural{label}#*r
\glsxtrheadplural{label}#*r
\Glsxtrtitleplural{label}#*r
\Glsxtrheadplural{label}#*r
\GLSxtrtitleplural{label}#*r
\GLSxtrheadplural{label}#*r
\glsxtrtitlefirst{label}#*r
\glsxtrheadfirst{label}#*r
\Glsxtrtitlefirst{label}#*r
\Glsxtrheadfirst{label}#*r
\GLSxtrtitlefirst{label}#*r
\GLSxtrheadfirst{label}#*r
\glsxtrtitlefirstplural{label}#*r
\glsxtrheadfirstplural{label}#*r
\Glsxtrtitlefirstplural{label}#*r
\Glsxtrheadfirstplural{label}#*r
\GLSxtrtitlefirstplural{label}#*r
\GLSxtrheadfirstplural{label}#*r
\glsxtrmarkhook#*
\glsxtrrestoremarkhook#*

## Nested Links ##
\glsxtrp{field}{label}#*r
\glsxtrpInit{csname}{label}#*r
\glsxtrsetpopts{options%keyvals}#*
\glossxtrsetpopts#*
\glsps{label}#*r
\glspt{label}#*r
\Glsps{label}#*r
\Glspt{label}#*r
\GLSps{label}#*r
\GLSpt{label}#*r
\Glsxtrp{field}{label}#*r
\GLSxtrp{field}{label}#*r

## Adjusting the Text Style ##
\GlsXtrExpandedFmt{cs}{text}#*
\glsxtrregularfont{text}#*
\glsxtrabbreviationfont{text}#*
\glsxtrassignfieldfont{text}#*
\glsxtrgenentrytextfmt#*
\glsxtrdefaultentrytextfmt{text}#*
\glsxtrattrentrytextfmt{text}#*
\glsifapplyinnerfmtfield{label}{internal-field}{true}{false}#*
\glsexclapplyinnerfmtfield{label}{internal-field}#*
\glsfmtfield{insert}{cs}{label}{internal-field}#*
\Glsfmtfield{insert}{cs}{label}{internal-field}#*
\GLSfmtfield{insert}{cs}{label}{internal-field}#*
\glsxtrpostlinkhook#*
\glsxtrdiscardperiod{label}{discarded}{no discard}#*
\glsxtrdiscardperiodretainfirstuse{label}{discarded}{no discard}#*
\glsxtrifcustomdiscardperiod{true}{false}#*
\glsxtrpostlinkendsentence#*
\glsxtrifperiod{true}{false}#*
\glsxtrifnextpunc{true}{false}#*
\glsxtrdopostpunc{code}#*
\glsxtraddpunctuationmark{tokens}#*
\glsxtrsetpunctuationmarks{tokens}#*
\glsxtrpostlink#*
\glsdefpostlink{category}{definition}#*
\glspretopostlink{category}{code}#*
\glsapptopostlink{category}{code}#*
\glsxtrpostlinkAddDescOnFirstUse#*
\glsxtrpostlinkAddSymbolOnFirstUse#*
\glsxtrpostlinkAddSymbolDescOnFirstUse#*
\glsxtrpostlinkSymbolDescSep#*
\glsxtrcurrentfield#*
\glsxtrifwasglslike{true}{false}#*
\glsxtrifwasglslikeandfirstuse{true}{false}#*
\glsxtrifwassubsequentuse{true}{false}#*
\glsxtrifwassubsequentorshort{true}{false}#*
\glsxtrifallcaps{true}{false}#*
\glsxtrsaveinsert{label}{insert}#*
\glsxtrassignlinktextfmt#*
\glsxtrgenabbrvfmt#*

## Hyperlinks ##
\glsxtrtarget{label}{text}#*
\glsxtrtargetfield#*

## Label Prefixes ##
\glsxtrnewgls{prefix}{cmd}#*d
\glsxtrnewgls[default-options%keyvals]{prefix}{cmd}#*d
\glsxtrnewglslike{prefix}{gls-cmd%cmd}{glspl-cmd%cmd}{Gls-cmd%cmd}{Glspl-cmd%cmd}#*d
\glsxtrnewglslike[default-options%keyvals]{prefix}{gls-cmd%cmd}{glspl-cmd%cmd}{Gls-cmd%cmd}{Glspl-cmd%cmd}#*d
\glsxtrnewGLSlike{prefix}{GLS-cmd%cmd}{GLSpl-cmd%cmd}#*d
\glsxtrnewGLSlike[default options%keyvals]{prefix}{GLS-cmd%cmd}{GLSpl-cmd%cmd}#*d
\glsxtrnewglslink{prefix}{cmd}#*d
\glsxtrnewglslink[default-options%keyvals]{prefix}{cmd}#*d
\glsxtrnewglsdisp{prefix}{cmd}#*d
\glsxtrnewglsdisp[default-options%keyvals]{prefix}{cmd}#*d
\glsxtridentifyglslike{prefix}{cmd}#*
\glsxtrnewrgls{prefix}{cmd}#*d
\glsxtrnewrgls[default-options%keyvals]{prefix}{cmd}#*d
\glsxtrnewrglslike{prefix}{rgls-cmd%cmd}{rglspl-cmd%cmd}{rGls-cmd%cmd}{rGlspl-cmd%cmd}#*d
\glsxtrnewrglslike[default-options%keyvals]{prefix}{rgls-cmd%cmd}{rglspl-cmd%cmd}{rGls-cmd%cmd}{rGlspl-cmd%cmd}#*d
\glsxtrnewrGLSlike{prefix}{rGLS-cmd%cmd}{rGLSpl-cmd%cmd}#*d
\glsxtrnewrGLSlike[default-options%keyvals]{prefix}{rGLS-cmd%cmd}{rGLSpl-cmd%cmd}#*d

## Indexing ##
\glsaddallunindexed
\glsaddallunindexed[glossary-types]
\glsaddeach{labellist}#r
\glsaddeach[options%keyvals]{labellist}#r
\glsstartrange{labellist}#r
\glsstartrange[options%keyvals]{labellist}#r
\glsendrange{labellist}#r
\glsendrange[options%keyvals]{labellist}#r
\GlsXtrSetDefaultRangeFormat{encap}
\GlsXtrAutoAddOnFormat{format list}{glsadd options%keyvals}
\GlsXtrAutoAddOnFormat[label]{format list}{glsadd options%keyvals}
\glsxtrdowrglossaryhook{label}#*
\glsentryindexcount{label}#*r
\glsifindexed{label}{true}{false}#*r
\glsxtrifindexing{true}{false}#*

## Cross-Referencing ##
\glsxtrseelists{label}#*r
\glsxtrseelistsencap{content}#*
\glsxtrseelistsdelim#*
\glsxtrusesee{label}#*r
\glsxtrusealias{label}#*r
\glsxtruseseealso{label}#*r
\glsxtralias{label}#*r
\glsxtrseealsolabels{label}#*r
\glsxtruseseealsoformat{xr-list}#*
\glsxtrindexseealso{label}{xr-list}#*r
\glsxtrsetaliasnoindex#*
\glsxtrindexaliased#*
\glsxtraddallcrossrefs#*
\glsxtraddunusedxrefs#*
\glsxtrunusedformat{location}#*

## First Use Flag ##
\glsxtrpostunset{label}#*r
\glsxtrpostlocalunset{label}#*r
\glsxtrpostreset{label}#*r
\glsxtrpostlocalreset{label}#*r
\glslocalunseteach{labellist}#*r
\glslocalreseteach{labellist}#*r
\glsxtrifwasfirstuse{true}{false}#*
\GlsXtrIfUnusedOrUndefined{label}{true}{false}#*
\GlsXtrStartUnsetBuffering#*
\GlsXtrClearUnsetBuffer#*
\GlsXtrStopUnsetBuffering#*
\GlsXtrForUnsetBufferedList{handler-cs}#*
\GlsXtrDiscardUnsetBuffering#*
\GlsXtrUnsetBufferEnableRepeatLocal#*
\GlsXtrResetLocalBuffer#*
\GlsXtrUnsetBufferDisableRepeatLocal#*

## Accessing Fields ##
\glsxtrusefield{label}{field}#*r
\Glsxtrusefield{label}{field}#*r
\GLSxtrusefield{label}{field}#*r
\glsxtrfieldtitlecase{label}{field}#*r
\glsxtrfieldtitlecasecs{content}#*
\glsxtrentryparentname{entry-name}#*
\glsxtrhiername{label}#*r
\glsxtrhiernamesep#*
\Glsxtrhiername{label}#*r
\GlsXtrhiername{label}#*r
\GLSxtrhiername{label}#*r
\GLSXTRhiername{label}#*r
\GlsXtrForeignTextField#*
\GlsXtrForeignText{label}{text}#*r
\GlsXtrUnknownDialectWarning{locale}{language}#*
\GlsXtrFmtField#*
\glsxtrfmt{label}{text}#*r
\glsxtrfmt[options%keyvals]{label}{text}#*r
\glsxtrfmt*{label}{text}#*r
\glsxtrfmt*{label}{text}[insert]#*r
\glsxtrfmt*[options%keyvals]{label}{text}#*r
\glsxtrfmt*[options%keyvals]{label}{text}[insert]#*r
\glsxtrfmtdisplay{csname}{text}{insert}#*
\glsxtrentryfmt{label}{text}#*r
\glsxtrpdfentryfmt{label}{text}#*r
\Glsxtrfmt{label}{text}#*r
\Glsxtrfmt[options%keyvals]{label}{text}#*r
\Glsxtrfmt*{label}{text}#*r
\Glsxtrfmt*{label}{text}[insert]#*r
\Glsxtrfmt*[options%keyvals]{label}{text}#*r
\Glsxtrfmt*[options%keyvals]{label}{text}[insert]#*r
\Glsxtrentryfmt{label}{text}#*r
\Glsxtrpdfentryfmt{label}{text}#*r

## Comma-Separated Lists ##
\glsxtrseelist{xr-list}#*
\glsxtrtaggedlist{sing-tag}{plural-tag}{prefix}{xr-list}#*
\glsxtrtaggedlistsep#*
\glsseefirstitem{label}#*r
\glsseelastoxfordsep#*
\glsxtrforcsvfield{label}{field}{handler}#*r
\glsxtrendfor#*
\glsxtrfieldformatcsvlist{label}{field}#*r
\GlsXtrIfValueInFieldCsvList{label}{field}{value}{true}{false}#*r
\GlsXtrIfFieldValueInCsvList{label}{field}{list}{true}{false}#*r
\xGlsXtrIfValueInFieldCsvList{label}{field}{value}{true}{false}#*r

## List Fields ##
\glsxtrfieldformatlist{label}{field}#*r
\glsxtrfielddolistloop{label}{field}#*r
\glsxtrfieldforlistloop{label}{field}{handler}#*r
\glsxtrfieldifinlist{label}{field}{item}{true}{false}#*r
\glsxtrfieldxifinlist{label}{field}{item}{true}{false}#*r

## Field Conditionals ##
\GlsXtrIfFieldUndef{field}{label}{true}{false}#*r
\glsxtrifhasfield{field}{label}{true}{false}#*r
\glsxtrifhasfield*{field}{label}{true}{false}#*r
\GlsXtrIfFieldCmpNum{field}{label}{comparison}{integer}{true}{false}#*r
\GlsXtrIfFieldCmpNum*{field}{label}{comparison}{integer}{true}{false}#*r
\GlsXtrIfFieldEqNum{field}{label}{integer}{true}{false}#*r
\GlsXtrIfFieldEqNum*{field}{label}{integer}{true}{false}#*r
\GlsXtrIfFieldNonZero{field}{label}{true}{false}#*r
\GlsXtrIfFieldNonZero*{field}{label}{true}{false}#*r
\GlsXtrIfFieldEqStr{field}{label}{text}{true}{false}#*r
\GlsXtrIfFieldEqStr*{field}{label}{text}{true}{false}#*r
\GlsXtrIfFieldEqXpStr{field}{label}{text}{true}{false}#*r
\GlsXtrIfFieldEqXpStr*{field}{label}{text}{true}{false}#*r
\GlsXtrIfXpFieldEqXpStr{field}{label}{text}{true}{false}#*r
\GlsXtrIfXpFieldEqXpStr*{field}{label}{text}{true}{false}#*r

### 6 Counting References ###
\GlsXtrEnableEntryCounting{category-list}{value}#*
\cGLS{label}#*r
\cGLS[options%keyvals]{label}#*r
\cGLS{label}[insert]#*r
\cGLS[options%keyvals]{label}[insert]#*r
\cGLS*{label}#Sr
\cGLS*[options%keyvals]{label}#Sr
\cGLS*{label}[insert]#Sr
\cGLS*[options%keyvals]{label}[insert]#Sr
\cGLS+{label}#Sr
\cGLS+[options%keyvals]{label}#Sr
\cGLS+{label}[insert]#Sr
\cGLS+[options%keyvals]{label}[insert]#Sr
\cGLSpl{label}#*r
\cGLSpl[options%keyvals]{label}#*r
\cGLSpl{label}[insert]#*r
\cGLSpl[options%keyvals]{label}[insert]#*r
\cGLSpl*{label}#Sr
\cGLSpl*[options%keyvals]{label}#Sr
\cGLSpl*{label}[insert]#Sr
\cGLSpl*[options%keyvals]{label}[insert]#Sr
\cGLSpl+{label}#Sr
\cGLSpl+[options%keyvals]{label}#Sr
\cGLSpl+{label}[insert]#Sr
\cGLSpl+[options%keyvals]{label}[insert]#Sr
\cGLSformat{label}{insert}#*r
\cGLSplformat{label}{insert}#*r
\glsxtrifcounttrigger{label}{true}{false}#*r
\glsenableentryunitcount#*
\GlsXtrEnableEntryUnitCounting{category-list}{value}{counter}#*
\glsentryprevtotalcount{label}#*r
\glsentryprevmaxcount{label}#*r

## Link Counting ##
\GlsXtrEnableLinkCounting{categories}#*
\GlsXtrEnableLinkCounting[parent-counter]{categories}#*
\glsxtrinclinkcounter{counter}#*
\GlsXtrLinkCounterValue{label}#*r
\GlsXtrTheLinkCounter{counter}#*
\GlsXtrIfLinkCounterDef{label}{true}{false}#*r
\GlsXtrLinkCounterName{label}#*r

### 7 Multi (or Compound) Entries ###
\multiglossaryentry{multi-label}{labellist}
\multiglossaryentry{multi-label}[main-label]{labellist}
\multiglossaryentry[options%keyvals]{multi-label}{labellist}
\multiglossaryentry[options%keyvals]{multi-label}[main-label]{labellist}
\mgls{multi-label}
\mgls[options%keyvals]{multi-label}
\mgls{multi-label}[insert]#*
\mgls[options%keyvals]{multi-label}[insert]#*
\mgls*{multi-label}#S
\mgls*[options%keyvals]{multi-label}#S
\mgls*{multi-label}[insert]#S
\mgls*[options%keyvals]{multi-label}[insert]#S
\mgls+{multi-label}#S
\mgls+[options%keyvals]{multi-label}#S
\mgls+{multi-label}[insert]#S
\mgls+[options%keyvals]{multi-label}[insert]#S
\providemultiglossaryentry{multi-label}{labellist}
\providemultiglossaryentry{multi-label}[main label]{labellist}
\providemultiglossaryentry[options%keyvals]{multi-label}{labellist}
\providemultiglossaryentry[options%keyvals]{multi-label}[main label]{labellist}
\multiglossaryentryglobaltrue
\multiglossaryentryglobalfalse
\ifmultiglossaryentryglobal#*
\mglsSetOptions{multi-label}{options%keyvals}
\mglsAddOptions{multi-label}{options%keyvals}
\GlsXtrMglsOrGls{mgls-cmd}{gls-cmd}{label}#*
\GlsXtrMglsOrGls{mgls-cmd}{gls-cmd}[options%keyvals]{label}#*
\GlsXtrMglsOrGls{mgls-cmd}{gls-cmd}[options%keyvals]{label}[insert]#*

## Prefixes and Suffixes ##
\mglsprefix#*
\mglssuffix#*
\mglsdefcategoryprefix{category}{definition}#*
\mglsdefcategorysuffix{category}{definition}#*
\mglshascategoryprefix{category}{true}{false}#*
\mglsusecategoryprefix{category}#*
\mglshascategorysuffix{category}{true}{false}#*
\mglsusecategorysuffix{category}#*

## Separators ##
\glscombinedsep{prev label%ref}{next label%ref}#*r
\glscombinedfirstsep{prev label%ref}{next label%ref}#*r
\glscombinedsepfirst{prev label%ref}{next label%ref}#*r
\glscombinedfirstsepfirst{prev label%ref}{next label%ref}#*r
\glssetcombinedsepabbrvnbsp#*
\glssetcombinedsepabbrvnone#*
\glssetcombinedsepnarrow{width}{narrow sep%l}#*

## \mgls Element Hooks ##
\mglselementprehook#*
\mglselementposthook#*
\mglscurrentmultilabel#*
\mglscurrentmainlabel#*
\mglscurrentlist#*
\mglscurrentoptions#*
\mglscurrentcategory#*
\glsxtrcurrentmglscsname#*
\mglsisfirstuse{true}{false}#*
\mglscurrentlabel#*
\mglselementindex#*
\mglscurrentprefix#*
\mglscurrentsuffix#*
\mglsiflast{true}{false}#*

## Post-Link Hook ##
\mglscustompostlinkhook#*
\mglslastelementpostlinkhook#*
\mglslastmainpostlinkhook#*
\mglslastmultilabel#*
\mglslastcategory#*
\mglswasfirstuse{true}{false}#*
\mglslastelementlabel#*
\mglsiflastelementskipped{true}{false}#*
\mglsiflastelementwasfirstuse{true}{false}#*
\mglsiflastelementwasplural{true}{false}#*
\mglsiflastelementcapscase{no-change}{firstuc}{all caps}#*
\mglslastmainlabel#*
\mglsiflastmainskipped{true}{false}#*
\mglsiflastmainwasfirstuse{true}{false}#*
\mglsiflastmainwasplural{true}{false}#*
\mglsiflastmaincapscase{no-change}{firstuc}{all caps}#*

## Multi-Entry First Use ##
\ifmglsused{multi-label}{true}{false}#*
\mglsunset{multi-label}#*
\mglsreset{multi-label}#*
\mglslocalunset{multi-label}#*
\mglslocalreset{multi-label}#*
\mglsunsetall#*
\mglsresetall#*

## Multi-Entry Settings ##
\multiglossaryentrysetup{options%keyvals}

#keyvals:\multiglossaryentry#c,\providemultiglossaryentry#c,\multiglossaryentrysetup#c
indexmain=#false,true,first
indexothers=#false,true,first
encapmain=%<csname%>
encapothers=%<csname%>
postlinks=#none,all,notlast,mainnotlast,mainonly,othernotlast,otheronly
mpostlink=#false,true,firstonly,usedonly
mpostlinkelement=#last,main,custom
firstprefix=%<prefix%>
usedprefix=%<prefix%>
firstsuffix=%<suffix%>
usedsuffix=%<suffix%>
firstskipmain#true,false
firstskipothers#true,false
usedskipmain#true,false
usedskipothers#true,false
hyper=#none,allmain,mainonly,individual,otheronly,notmainfirst,nototherfirst,notfirst
textformat=%<csname%>
category=%<category%>
mglsopts={%<mgls options%>}
#endkeyvals

\glsxtrmglsWarnAllSkipped{message%text}{insert}{fmt-cs}#*

## \mgls Options ##
#keyvals:\mgls#c,\mgls*#c,\mgls+#c,\Mgls#c,\Mgls*#c,\Mgls+#c,\MGls#c,\MGls*#c,\MGls+#c,\MGLS#c,\MGLS*#c,\MGLS+#c,\mglspl#c,\mglspl*#c,\mglspl+#c,\Mglspl#c,\Mglspl*#c,\Mglspl+#c,\MGlspl#c,\MGlspl*#c,\MGlspl+#c,\MGLSpl#c,\MGLSpl*#c,\MGLSpl+#c,\mglsname#c,\mglsname*#c,\mglsname+#c,\Mglsname#c,\Mglsname*#c,\Mglsname+#c,\MGlsname#c,\MGlsname*#c,\MGlsname+#c,\MGLSname#c,\MGLSname*#c,\MGLSname+#c,\mglsmainpl#c,\mglsmainpl*#c,\mglsmainpl+#c,\Mglsmainpl#c,\Mglsmainpl*#c,\Mglsmainpl+#c,\MGlsmainpl#c,\MGlsmainpl*#c,\MGlsmainpl+#c,\MGLSmainpl#c,\MGLSmainpl*#c,\MGLSmainpl+#c,\mglsshort#c,\mglsshort*#c,\mglsshort+#c,\Mglsshort#c,\Mglsshort*#c,\Mglsshort+#c,\MGlsshort#c,\MGlsshort*#c,\MGlsshort+#c,\MGLSshort#c,\MGLSshort*#c,\MGLSshort+#c,\mglslong#c,\mglslong*#c,\mglslong+#c,\Mglslong#c,\Mglslong*#c,\Mglslong+#c,\MGlslong#c,\MGlslong*#c,\MGlslong+#c,\MGLSlong#c,\MGLSlong*#c,\MGLSlong+#c,\mglsfull#c,\mglsfull*#c,\mglsfull+#c,\Mglsfull#c,\Mglsfull*#c,\Mglsfull+#c,\MGlsfull#c,\MGlsfull*#c,\MGlsfull+#c,\MGLSfull#c,\MGLSfull*#c,\MGLSfull+#c,\mglssymbol#c,\mglssymbol*#c,\mglssymbol+#c,\Mglssymbol#c,\Mglssymbol*#c,\Mglssymbol+#c,\MGlssymbol#c,\MGlssymbol*#c,\MGlssymbol+#c,\MGLSsymbol#c,\MGLSsymbol*#c,\MGLSsymbol+#c,\mglsusefield#c,\mglsusefield*#c,\mglsusefield+#c,\Mglsusefield#c,\Mglsusefield*#c,\Mglsusefield+#c,\MGlsusefield#c,\MGlsusefield*#c,\MGlsusefield+#c,\MGLSusefield#c,\MGLSusefield*#c,\MGLSusefield+#c,\mpgls#c,\mpglspl#c,\mpglsmainpl#c,\Mpgls#c,\Mpglspl#c,\Mpglsmainpl#c,\MPGls#c,\MPGlspl#c,\MPGlsmainpl#c,\MPGLS#c,\MPGLSpl#c,\MPGLSmainpl#c,\mglsSetOptions#c,\mglsAddOptions#c,\GlsXtrMglsOrGls#c
setup={%<options%>}
all={%<gls options%>}
main={%<gls options%>}
others={%<gls options%>}
hyper#true,false
multiunset=#global,local,none
presetlocal#true,false
resetall#true,false
resetmain#true,false
resetothers#true,false
unsetall#true,false
unsetmain#true,false
unsetothers#true,false
#endkeyvals

\mglselementreset{label}#*r
\mglselementunset{label}#*r
\mglsunsetothers{multi-label}
\mglslocalunsetothers{multi-label}

## Variants of \mgls ##
\mglspl{multi-label}
\mglspl[options%keyvals]{multi-label}
\mglspl{multi-label}[insert]#*
\mglspl[options%keyvals]{multi-label}[insert]#*
\mglsmainpl{multi-label}
\mglsmainpl[options%keyvals]{multi-label}
\mglsmainpl{multi-label}[insert]#*
\mglsmainpl[options%keyvals]{multi-label}[insert]#*
\Mgls{multi-label}
\Mgls[options%keyvals]{multi-label}
\Mgls{multi-label}[insert]#*
\Mgls[options%keyvals]{label}[insert]#*
\MGls{multi-label}
\MGls[options%keyvals]{multi-label}
\MGls{multi-label}[insert]#*
\MGls[options%keyvals]{multi-label}[insert]#*
\Mglspl{multi-label}
\Mglspl[options%keyvals]{multi-label}
\Mglspl{multi-label}[insert]#*
\Mglspl[options%keyvals]{multi-label}[insert]#*
\Mglsmainpl{multi-label}
\Mglsmainpl[options%keyvals]{multi-label}
\Mglsmainpl{multi-label}[insert]#*
\Mglsmainpl[options%keyvals]{multi-label}[insert]#*
\MGlspl{multi-label}
\MGlspl[options%keyvals]{multi-label}
\MGlspl{multi-label}[insert]#*
\MGlspl[options%keyvals]{multi-label}[insert]#*
\MGlsmainpl{multi-label}
\MGlsmainpl[options%keyvals]{multi-label}
\MGlsmainpl{multi-label}[insert]#*
\MGlsmainpl[options%keyvals]{multi-label}[insert]#*
\MGLS{multi-label}
\MGLS[options%keyvals]{multi-label}
\MGLS{multi-label}[insert]#*
\MGLS[options%keyvals]{multi-label}[insert]#*
\MGLSpl{multi-label}
\MGLSpl[options%keyvals]{multi-label}
\MGLSpl{multi-label}[insert]#*
\MGLSpl[options%keyvals]{multi-label}[insert]#*
\MGLSmainpl{multi-label}
\MGLSmainpl[options%keyvals]{multi-label}
\MGLSmainpl{multi-label}[insert]#*
\MGLSmainpl[options%keyvals]{multi-label}[insert]#*
\mglsshort{multi-label}
\mglsshort[options%keyvals]{multi-label}
\mglsshort{multi-label}[insert]#*
\mglsshort[options%keyvals]{multi-label}[insert]#*
\mglslong{multi-label}
\mglslong[options%keyvals]{multi-label}
\mglslong{multi-label}[insert]#*
\mglslong[options%keyvals]{multi-label}[insert]#*
\mglsfull{multi-label}
\mglsfull[options%keyvals]{multi-label}
\mglsfull{multi-label}[insert]#*
\mglsfull[options%keyvals]{multi-label}[insert]#*
\Mglsshort{multi-label}
\Mglsshort[options%keyvals]{multi-label}
\Mglsshort{multi-label}[insert]#*
\Mglsshort[options%keyvals]{multi-label}[insert]#*
\Mglslong{multi-label}
\Mglslong[options%keyvals]{multi-label}
\Mglslong{multi-label}[insert]#*
\Mglslong[options%keyvals]{multi-label}[insert]#*
\Mglsfull{multi-label}
\Mglsfull[options%keyvals]{multi-label}
\Mglsfull{multi-label}[insert]#*
\Mglsfull[options%keyvals]{multi-label}[insert]#*
\mglsname{multi-label}#*
\mglsname[options%keyvals]{multi-label}#*
\mglsname{multi-label}[insert]#*
\mglsname[options%keyvals]{multi-label}[insert]#*
\mglssymbol{multi-label}#*
\mglssymbol[options%keyvals]{multi-label}#*
\mglssymbol{multi-label}[insert]#*
\mglssymbol[options%keyvals]{multi-label}[insert]#*
\mglsusefield{multi-label}#*
\mglsusefield[options%keyvals]{multi-label}#*
\mglsusefield{multi-label}[insert]#*
\mglsusefield[options%keyvals]{multi-label}[insert]#*
\Mglsname{multi-label}#*
\Mglsname[options%keyvals]{multi-label}#*
\Mglsname{multi-label}[insert]#*
\Mglsname[options%keyvals]{multi-label}[insert]#*
\Mglssymbol{multi-label}#*
\Mglssymbol[options%keyvals]{multi-label}#*
\Mglssymbol{multi-label}[insert]#*
\Mglssymbol[options%keyvals]{multi-label}[insert]#*
\Mglsusefield{multi-label}#*
\Mglsusefield[options%keyvals]{multi-label}#*
\Mglsusefield{multi-label}[insert]#*
\Mglsusefield[options%keyvals]{multi-label}[insert]#*
\MGlsname{multi-label}#*
\MGlsname[options%keyvals]{multi-label}#*
\MGlsname{multi-label}[insert]#*
\MGlsname[options%keyvals]{multi-label}[insert]#*
\MGlssymbol{multi-label}#*
\MGlssymbol[options%keyvals]{multi-label}#*
\MGlssymbol{multi-label}[insert]#*
\MGlssymbol[options%keyvals]{multi-label}[insert]#*
\MGlsusefield{multi-label}#*
\MGlsusefield[options%keyvals]{multi-label}#*
\MGlsusefield{multi-label}[insert]#*
\MGlsusefield[options%keyvals]{multi-label}[insert]#*
\mglsfield#*
\mpglsWarning#*

## Cross-References ##
\mglsseefirstitem{multi-label}#*
\mglsseeitem{multi-label}#*

## Additional Commands ##
\glsxtrifmulti{multi-label}{true}{false}#*
\glsxtrmultimain{multi-label}#*
\glsxtrmultilist{multi-label}#*
\mglsforelements{multi-label}{cmd}{body}#*
\mglsforotherelements{multi-label}{cmd}{body}#*
\glsxtrmultitotalelements{multi-label}#*
\glsxtrmultimainindex{multi-label}#*
\glsxtrmultilastotherindex{multi-label}#*
\writemultiglossentry{options}{multi-label}{main-label}{list}#*

## bib2gls ##
# see glossaries-extra-bib2gls.cwl

### 8 Defining and Displaying Glossaries ###
\makeglossaries[types]
\newignoredglossary*{name}#*
\provideignoredglossary{name}#*
\glsxtrcopytoglossary{label}{glossary-type}#r
\glsxtrcopytoglossary*{label}{glossary-type}#*r
\forallabbreviationlists{cmd}{body}#*

## Entry Page Reference ##
\glsxtrpageref{label}#r

## Glossary Preamble ##
\apptoglossarypreamble{text}#*
\apptoglossarypreamble[type]{text}#*
\pretoglossarypreamble{text}#*
\pretoglossarypreamble[type]{text}#*

## Options ##
# options provided by glossaries.sty
#keyvals:\printabbreviations#c,\printunsrtabbreviations#c,\printunsrtsymbols#c,\printunsrtnumbers#c,\printunsrtindex#c,\printunsrtacronyms#c,\printunsrtglossary#c,\printunsrtglossary*#c,\begin{printunsrtglossarywrap}#c,\printunsrtglossaryunit#c
type=%<glossary-label%>
title=%<text%>
toctitle=%<text%>
style=%<style-name%>
numberedsection=#false,nolabel,autolabel
nonumberlist#true,false
nogroupskip#true,false
nopostdot#true,false
entrycounter#true,false
subentrycounter#true,false
sort=#use,def,nocase,case,word,letter,standard
#endkeyvals

# options provided by glossaries-extra.sty
#keyvals:\printnoidxglossary#c,\printglossary#c,\printsymbols#c,\printnumbers#c,\printindex#c,\printacronyms#c,\printabbreviations#c,\printunsrtabbreviations#c,\printunsrtsymbols#c,\printunsrtnumbers#c,\printunsrtindex#c,\printunsrtacronyms#c,\printunsrtglossary#c,\printunsrtglossary*#c,\begin{printunsrtglossarywrap}#c,\printunsrtglossaryunit#c
label=##l
prefix=%<prefix%>
targetnameprefix=%<prefix%>
target#true,false
preamble=%<text%>
postamble=%<text%>
#endkeyvals

# "unsrt"-only options
#keyvals:\printunsrtabbreviations#c,\printunsrtsymbols#c,\printunsrtnumbers#c,\printunsrtindex#c,\printunsrtacronyms#c,\printunsrtglossary#c,\printunsrtglossary*#c,\begin{printunsrtglossarywrap}#c,\printunsrtglossaryunit#c
leveloffset=%<<n> or ++<n>%>
flatten#true,false
groups#true,false
#endkeyvals

\glsxtrsetglossarylabel{label}#*l

## Displaying a Glossary Without Sorting or Indexing ##
\printunsrtglossary
\printunsrtglossary[options%keyvals]
\printunsrtglossary*{init-code}
\printunsrtglossary*[options%keyvals]{init-code}
\printunsrtglossaries
\glsxtrnoidxgroups#*
\glsxtrgroupfield#*
\glsxtraddgroup{label}{code}#*
\printunsrtglossarygrouphook{internal cs}#*
\glssubgroupheading{prev-level}{level}{parent-label}{group-label}#*
\GlsXtrLocationField#*
\printunsrtglossarypostbegin{internal cs}#*
\printunsrtglossarypreend{internal cs}#*
\glscurrententrylevel#*
\glscurrenttoplevelentry#*
\glscurrentrootentry#*
\printunsrtglossaryentryprocesshook{label}#*
\printunsrtglossaryskipentry#*
\printunsrtglossarypreentryprocesshook{internal cs}#*
\printunsrtglossarypostentryprocesshook{internal cs}#*
\printunsrtglossarypredoglossary#*
\printunsrtglossaryhandler{label}#*r
\glsxtrunsrtdo{label}#*r
\glsxtriflabelinlist{label}{labellist}{true}{false}#*r
\ifglsxtrprintglossflatten#*
\glsxtrprintglossflattentrue#*
\glsxtrprintglossflattenfalse#*

\printunsrtinnerglossary{pre-code}{post-code}
\printunsrtinnerglossary[options%keyvals]{pre-code}{post-code}

# can only use specific keys, hence separate listing here
#keyvals:\printunsrtinnerglossary#c
type=%<glossary-label%>
nonumberlist#true,false
nogroupskip#true,false
nopostdot#true,false
entrycounter#true,false
subentrycounter#true,false
target#true,false
targetnameprefix=%<prefix%>
prefix=%<prefix%>
groups#true,false
leveloffset=%<<n> or ++<n>%>
#endkeyvals

\begin{printunsrtglossarywrap}
\begin{printunsrtglossarywrap}[options%keyvals]
\end{printunsrtglossarywrap}
\GlsXtrRecordCounter{counter}#*
\glsxtrAddCounterRecordHook{label}{counter}{value}#*
\printunsrtglossaryunit{counter}#*
\printunsrtglossaryunit[options%keyvals]{counter}#*
\printunsrtglossaryunitsetup{counter}#*
\printunsrtglossaryunitpostskip#*

## Standalone Entry Items ##
\glsxtrglossentry{label}#*r
\GlsXtrStandaloneGlossaryType#*
\GlsXtrStandaloneSubEntryItem{label}#*r
\GlsXtrStandaloneEntryName{label}#*r
\glsxtractivatenopost#*
\glsxtrglossentryother{header}{label}{field}#*r
\GlsXtrStandaloneEntryOther{label}{field}#*r
\GlsXtrStandaloneEntryPdfName{label}#*r
\GlsXtrStandaloneEntryHeadName{label}#*r
\GlsXtrStandaloneEntryPdfOther{label}{field}#*r
\GlsXtrStandaloneEntryHeadOther{label}{field}#*r

## Glossary Style Modifications ##
\glsxtrpreglossarystyle#*
\glsentrypdfsymbol{label}#*r
\glossentrynameother{label}{field}#*r
\glsxtrpostnamehook{label}#*r
\glsdefpostname{category}{definition}#*
\glsextrapostnamehook{label}#*r
\glsxtrpostdescription#*
\glsxtrpostdescgeneral#*
\glsxtrpostdescterm#*
\glsxtrpostdescacronym#*
\glsxtrpostdescabbreviation#*
\glsdefpostdesc{category}{definition}#*
\glsxtrnopostpunc#*
\glsxtrrestorepostpunc#*
\GlsXtrFormatLocationList{location list}#*
\GlsXtrEnablePreLocationTag{page tag}{pages tag}#*
\glsxtrdisplaysingleloc{format}{location}#*
\glsxtrdisplaystartloc{format}{location}#*
\glsxtrdisplayendloc{format}{location}#*
\glsxtrlocrangefmt#*
\glsxtrdisplayendlochook{format}{location}#*
\glsxtrsetgrouptitle{group-label}{group-title%text}#*
\glsxtrlocalsetgrouptitle{group-label}{group-title%text}#*
\glsxtrgetgrouptitle{group-label}{cmd}#*d

## New Glossary Styles ##
#keyvals:\setglossarystyle#c
abbr-long-short
abbr-short-long
bookindex
long-custom1-name
long-custom2-name
long-custom3-name
long-desc-custom1-name
long-desc-custom2-name
long-desc-custom3-name
long-desc-name
long-desc-sym-name
long-desc-sym
long-loc-desc-name
long-loc-desc-sym-name
long-loc-sym-desc-name
long-name-custom1
long-name-custom1-desc
long-name-custom2
long-name-custom2-desc
long-name-custom3
long-name-custom3-desc
long-name-desc-loc
long-name-desc-sym-loc
long-name-desc-sym
long-name-desc
long-name-sym-desc-loc
long-name-sym-desc
long-sym-desc-name
long-sym-desc
table
topic
topicmcols
#endkeyvals

### 9 Accessibility Support ###
## Abbreviations ##
\glsxtrassignactualsetup#*
\glsdefaultshortaccess{long}{short}#*

## Accessibility Wrappers ##
\glsaccessname{label}#*r
\Glsaccessname{label}#*r
\GLSaccessname{label}#*r
\glsaccesstext{label}#*r
\Glsaccesstext{label}#*r
\GLSaccesstext{label}#*r
\GLSaccessplural{label}#*r
\glsaccessplural{label}#*r
\Glsaccessplural{label}#*r
\glsaccessfirst{label}#*r
\Glsaccessfirst{label}#*r
\GLSaccessfirst{label}#*r
\glsaccessfirstplural{label}#*r
\Glsaccessfirstplural{label}#*r
\GLSaccessfirstplural{label}#*r
\glsaccesssymbol{label}#*r
\Glsaccesssymbol{label}#*r
\GLSaccesssymbol{label}#*r
\glsaccesssymbolplural{label}#*r
\Glsaccesssymbolplural{label}#*r
\GLSaccesssymbolplural{label}#*r
\glsaccessdesc{label}#*r
\Glsaccessdesc{label}#*r
\GLSaccessdesc{label}#*r
\glsaccessdescplural{label}#*r
\Glsaccessdescplural{label}#*r
\GLSaccessdescplural{label#*r
\glsaccessshort{label}#*r
\Glsaccessshort{label}#*r
\GLSaccessshort{label}#*r
\glsaccessshortpl{label}#*r
\Glsaccessshortpl{label}#*r
\GLSaccessshortpl{label}#*r
\glsaccesslong{label}#*r
\Glsaccesslong{label}#*r
\GLSaccesslong{label}#*r
\glsaccesslongpl{label}#*r
\Glsaccesslongpl{label}#*r
\GLSaccesslongpl{label}#*r
\glsaccessuseri{label}#*r
\Glsaccessuseri{label}#*r
\GLSaccessuseri{label}#*r
\glsaccessuserii{label}#*r
\Glsaccessuserii{label}#*r
\GLSaccessuserii{label}#*r
\glsaccessuseriii{label}#*r
\Glsaccessuseriii{label}#*r
\GLSaccessuseriii{label}#*r
\glsaccessuseriv{label}#*r
\Glsaccessuseriv{label}#*r
\GLSaccessuseriv{label}#*r
\glsaccessuserv{label}#*r
\Glsaccessuserv{label}#*r
\GLSaccessuserv{label}#*r
\glsaccessuservi{label}#*r
\Glsaccessuservi{label}#*r
\GLSaccessuservi{label}#*r

## Inner Formatting Wrappers ##
\glsaccessfmtname{insert}{cmd}{label}#*
\Glsaccessfmtname{insert}{cmd}{label}#*
\GLSaccessfmtname{insert}{cmd}{label}#*
\glsaccessfmttext{insert}{cmd}{label}#*
\Glsaccessfmttext{insert}{cmd}{label}#*
\GLSaccessfmttext{insert}{cmd}{label}#*
\glsaccessfmtplural{insert}{cmd}{label}#*
\Glsaccessfmtplural{insert}{cmd}{label}#*
\GLSaccessfmtplural{insert}{cmd}{label}#*
\glsaccessfmtfirst{insert}{cmd}{label}#*
\Glsaccessfmtfirst{insert}{cmd}{label}#*
\GLSaccessfmtfirst{insert}{cmd}{label}#*
\glsaccessfmtfirstplural{insert}{cmd}{label}#*
\Glsaccessfmtfirstplural{insert}{cmd}{label}#*
\GLSaccessfmtfirstplural{insert}{cmd}{label}#*
\glsaccessfmtsymbol{insert}{cmd}{label}#*
\Glsaccessfmtsymbol{insert}{cmd}{label}#*
\GLSaccessfmtsymbol{insert}{cmd}{label}#*
\glsaccessfmtsymbolplural{insert}{cmd}{label}#*
\Glsaccessfmtsymbolplural{insert}{cmd}{label}#*
\GLSaccessfmtsymbolplural{insert}{cmd}{label}#*
\glsaccessfmtdesc{insert}{cmd}{label}#*
\Glsaccessfmtdesc{insert}{cmd}{label}#*
\GLSaccessfmtdesc{insert}{cmd}{label}#*
\glsaccessfmtdescplural{insert}{cmd}{label}#*
\Glsaccessfmtdescplural{insert}{cmd}{label}#*
\GLSaccessfmtdescplural{insert}{cmd}{label}#*
\glsaccessfmtshort{insert}{cmd}{label}#*
\Glsaccessfmtshort{insert}{cmd}{label}#*
\GLSaccessfmtshort{insert}{cmd}{label}#*
\glsaccessfmtshortpl{insert}{cmd}{label}#*
\Glsaccessfmtshortpl{insert}{cmd}{label}#*
\GLSaccessfmtshortpl{insert}{cmd}{label}#*
\glsaccessfmtlong{insert}{cmd}{label}#*
\Glsaccessfmtlong{insert}{cmd}{label}#*
\GLSaccessfmtlong{insert}{cmd}{label}#*
\glsaccessfmtlongpl{insert}{cmd}{label}#*
\Glsaccessfmtlongpl{insert}{cmd}{label}#*
\GLSaccessfmtlongpl{insert}{cmd}{label}#*
\glsaccessfmtuseri{insert}{cmd}{label}#*
\Glsaccessfmtuseri{insert}{cmd}{label}#*
\GLSaccessfmtuseri{insert}{cmd}{label}#*
\glsaccessfmtuserii{insert}{cmd}{label}#*
\Glsaccessfmtuserii{insert}{cmd}{label}#*
\GLSaccessfmtuserii{insert}{cmd}{label}#*
\glsaccessfmtuseriii{insert}{cmd}{label}#*
\Glsaccessfmtuseriii{insert}{cmd}{label}#*
\GLSaccessfmtuseriii{insert}{cmd}{label}#*
\glsaccessfmtuseriv{insert}{cmd}{label}#*
\Glsaccessfmtuseriv{insert}{cmd}{label}#*
\GLSaccessfmtuseriv{insert}{cmd}{label}#*
\glsaccessfmtuserv{insert}{cmd}{label}#*
\Glsaccessfmtuserv{insert}{cmd}{label}#*
\GLSaccessfmtuserv{insert}{cmd}{label}#*
\glsaccessfmtuservi{insert}{cmd}{label}#*
\Glsaccessfmtuservi{insert}{cmd}{label}#*
\GLSaccessfmtuservi{insert}{cmd}{label}#*

### 10 Categories ###
\glscategory{label}#r
\glsifcategory{label}{category}{true}{false}#*r
\glsxtrsetcategory{labellist}{category}#*
\glsxtrsetcategoryforall{glossary-labels}{category}#*
\glsforeachincategory{category}{glossarycmd}{labelcmd}{body}#*
\glsforeachincategory[glossary-types]{category}{glossarycmd}{labelcmd}{body}#*
\glsforeachwithattribute{attribute}{value}{glossary-cmd}{label-cmd}{body}#*
\glsforeachwithattribute[glossary-types]{attribute}{value}{glossary-cmd}{label-cmd}{body}#*

## Attributes ##
\glsxtrwordsep#*
\glsxtrword{word}#*
\glssetcategoryattribute{category}{attribute}{value}#*
\glssetcategoriesattribute{category list}{attribute}{value}#*
\glssetcategoryattributes{category}{attribute list}{value}#*
\glssetcategoriesattributes{category list}{attribute list}{value}#*
\glssetattribute{label}{attribute}{value}#*r
\glssetregularcategory{category}#*
\glsunsetcategoryattribute{category}{attribute}#*
\glsgetcategoryattribute{category}{attribute}#*
\glsgetattribute{label}{attribute}#*r
\glshascategoryattribute{category}{attribute}{true}{false}#*
\glshasattribute{label}{attribute}{value}{true}{false}#*r
\glsifcategoryattribute{category}{attribute}{value}{true}{false}#*
\glsifattribute{label}{attribute}{value}{true}{false}#*r
\glsifregularcategory{category}{true}{false}#*
\glsifnotregularcategory{category}{true}{false}#*
\glsifregular{label}{true}{false}#*r
\glsifnotregular{label}{true}{false}#*r
\glsifcategoryattributetrue{category}{attribute}{true}{false}#*
\glsifattributetrue{label}{attribute}{true}{false}#*r
\glsifcategoryattributehasitem{category}{attribute}{item}{true}{false}#*

### 11 bib2gls: Managing Reference Databases ###
\glsxtrresourcefile{filename%file}
\glsxtrresourcefile[options%keyvals]{filename%file}
\GlsXtrLoadResources
\GlsXtrLoadResources[options%keyvals]

#keyvals:\glsxtrresourcefile#c,\GlsXtrLoadResources#c
charset=%<encoding name%>
locale=%<lang tag%>
interpret-preamble#true,false
write-preamble#true,false
set-widest#true,false
entry-type-aliases={%<keyvals%>}
unknown-entry-alias=%<value%>
action=#define,copy,define or copy
copy-to-glossary={%<list%>}
copy-to-glossary-missing-field-action=#skip,fallback,empty
src={%<list%>}
selection=#recorded and deps,recorded and deps and see,recorded and deps and see not also,recorded no deps,recorded and ancestors,deps but not recorded,ancestors but not recorded,selected before,all
match={%<keyvals%>}
match-op=#and,or
not-match={%<keyvals%>}
match-action=#filter,add
limit=%<number%>
save-child-count#true,false
save-sibling-count#true,false
save-root-ancestor#true,false
flatten#true,false
flatten-lonely=#false,presort,postsort
flatten-lonely-rule=#only unrecorded parents,discard unrecorded,no discard
flatten-lonely-condition=%<value%>
flatten-lonely-missing-field-action=#skip,fallback,empty
strip-missing-parents#true,false
missing-parents=#strip,warn,create
missing-parent-category=#same as child,same as base,no value,false,%<label%>
group-level=#{%<n%>},{>%<n%>},{>=%<n%>},{<%<n%>},{<=%<n%>},all
merge-small-groups
merge-small-groups=%<n%>
master=%<name%>
master-resources={%<list%>}
interpret-label-fields#true,false
labelify={%<list%>}
labelify-replace={%<list%>}
label-prefix=%<prefix%>
duplicate-label-suffix=%<suffix%>
record-label-prefix=%<tag%>
cs-label-prefix=%<tag%>
ext-prefixes={%<list%>}
prefix-only-existing#true,false
save-original-id=#false,true,%<field%>
save-original-id-action=#always,no override,changed override,changes,diff
save-definition-index#true,false
save-use-index#true,false
dependency-fields={%<list%>}
group=%<label%>
category=#false,same as entry,same as original entry,same as base,same as type,%<label%>
type=#false,same as entry,same as original entry,same as base,same as category,same as parent,%<label%>
trigger-type=%<type%>
progenitor-type=%<type%>
progeny-type=%<type%>
adopted-parent-field=%<field%>
abbreviation-name-fallback=%<field%>
abbreviation-text-fallback=%<field%>
ignore-fields={%<list%>}
field-aliases={%<keyvals%>}
replicate-fields={%<keyvals%>}
replicate-override#true,false
replicate-missing-field-action=#skip,fallback,empty
assign-fields={%<keyvals%>}
assign-override#true,false
assign-missing-field-action=#skip,fallback,empty
counter=%<value%>
copy-action-group-field=%<value%>
copy-alias-to-see#true,false
save-from-see=%<value%>
save-from-seealso=%<value%>
save-from-alias=%<value%>
save-crossref-tail=%<value%>
save-original-entrytype=%<value%>
save-original-entrytype-action=#always,no override,changed override,changed,diff,changed no override
post-description-dot=#none,all,check
strip-trailing-nopost=#true,false
check-end-punctuation={%<list%>}
sort-label-list={%<list%>}
prune-xr#true,false
prune-see-match={%<keyvals%>}
prune-see-op=#and,or
prune-seealso-match={%<keyvals%>}
prune-seealso-op=#and,or
prune-iterations=%<number%>
bibtex-contributor-fields={%<list%>}
contributor-order=#surname,von,forenames
encapsulate-fields={%<keyvals%>}
encapsulate-fields*={%<keyvals%>}
format-integer-fields={%<keyvals%>}
format-decimal-fields={%<keyvals%>}
interpret-fields={%<list%>}
interpret-fields-action=#replace,replace non empty
hex-unicode-fields={%<list%>}
date-time-fields={%<list%>}
date-fields={%<list%>}
time-fields={%<list%>}
date-time-field-format=%<value%>
date-field-format=%<value%>
time-field-format=%<value%>
date-time-field-locale=%<value%>
date-field-locale=%<value%>
time-field-locale=%<value%>
prefix-fields={%<list%>}
append-prefix-field=#none,space,space or nbsp
append-prefix-field-cs=%<cs%>
append-prefix-field-exceptions=%<sequence%>
append-prefix-field-cs-exceptions=%<sequence%>
append-prefix-field-nbsp-match=%<pattern%>
no-case-change-cs={%<list%>}
word-boundaries={%<list%>}
short-case-change=#white space,cs space,dash,nbsp
long-case-change=#white space,cs space,dash,nbsp
name-case-change=#white space,cs space,dash,nbsp
description-case-change=#white space,cs space,dash,nbsp
field-case-change={%<keyvals%>}
short-plural-suffix=%<suffix%>
dual-short-plural-suffix=%<suffix%>
save-locations=#false,true,see,see not also,alias only
save-loclist#true,false
save-primary-locations=#false,retain,default format,start,remove
save-principal-locations=#false,retain,default format,start,remove
primary-location-formats={%<list%>}
principal-location-formats={%<list%>}
primary-loc-counters=#combine,match,split
principal-loc-counters=#combine,match,split
merge-ranges#true,false
min-loc-range=%<value%>
max-loc-diff=%<integer%>
suffixF=%<value%>
suffixFF=%<value%>
compact-ranges=%<value%>
see=#omit,before,after
seealso=#omit,before,after
alias=#omit,before,after
alias-loc=#keep,transfer,omit
loc-prefix=%<value%>
loc-prefix-def=#global,local,individual
loc-suffix=%<value%>
loc-suffix-def=#global,local,individual
loc-counters={%<list%>}
save-index-counter=%<value%>
supplemental-locations=%<basename%>
supplemental-selection=%<value%>
supplemental-category=%<value%>
sort=%<value%>
shuffle=%<seed%>
sort-field=%<field%>
missing-sort-fallback=%<field%>
custom-sort-fallbacks={%<keyvals%>}
entry-sort-fallback=%<field%>
abbreviation-sort-fallback=%<field%>
symbol-sort-fallback=%<field%>
bibtexentry-sort-fallback=%<field%>
field-concat-sep=%<separator%>
trim-sort#true,false
sort-replace={%<list%>}
sort-rule=%<value%>
break-at=#word,character,sentence,upper-notlower,upper-upper,upper-notlower-word,upper-upper-word,none
break-marker=%<marker%>
break-at-match={%<keyvals%>}
break-at-match-op=#and,or
break-at-not-match={%<keyvals%>}
sort-number-pad=%<number%>
sort-pad-plus=%<marker%>
sort-pad-minus=%<marker%>
identical-sort-action=#none,def,use,id,original id,%<field%>
sort-suffix=#none,non-unique,%<field%>
sort-suffix-marker=%<marker%>
encapsulate-sort=%<csname%>
strength=#primary,secondary,tertiary,identical
decomposition=#canonical,full,none
letter-number-rule=#before letter,after letter,between,first,last
letter-number-punc-rule=#punc-space-first,punc-space-last,space-punc-first,space-punc-last,space-first-punc-last,punc-first-space-last,punc-first-space-zero,punc-last-space-zero,punc-first-space-zero-match-next,punc-last-space-zero-match-next
numeric-sort-pattern=%<value%>
numeric-locale=#locale,doc,%<lang-tag%>
date-sort-locale=#locale,doc,%<lang-tag%>
date-sort-format=#default,short,medium,long,full,%<pattern%>
group-formation=#default,codepoint,unicode category,unicode script,unicode category and script
secondary=%<value%>
secondary-match={%<keyvals%>}
secondary-not-match={%<keyvals%>}
secondary-match-op=#and,or
secondary-match-action=#filter,add
secondary-missing-sort-fallback=%<field%>
secondary-trim-sort#true,false
secondary-sort-replace={%<list%>}
secondary-sort-rule=%<value%>
secondary-break-at=#word,character,sentence,upper-notlower,upper-upper,upper-notlower-word,upper-upper-word,none
secondary-break-marker=%<marker%>
secondary-break-at-match={%<keyvals%>}
secondary-break-at-match-op=#and,or
secondary-break-at-not-match={%<keyvals%>}
secondary-sort-number-pad=%<number%>
secondary-sort-pad-plus=%<marker%>
secondary-sort-pad-minus=%<marker%>
secondary-identical-sort-action=#none,def,use,id,original id,%<field%>
secondary-sort-suffix=#none,non-unique,%<field%>
secondary-sort-suffix-marker=%<marker%>
secondary-strength=#primary,secondary,tertiary,identical
secondary-decomposition=#canonical,full,none
secondary-letter-number-rule=#before letter,after letter,between,first,last
secondary-letter-number-punc-rule=#punc-space-first,punc-space-last,space-punc-first,space-punc-last,space-first-punc-last,punc-first-space-last,punc-first-space-zero,punc-last-space-zero,punc-first-space-zero-match-next,punc-last-space-zero-match-next
secondary-numeric-sort-pattern=%<value%>
secondary-numeric-locale=#locale,doc,%<lang-tag%>
secondary-date-sort-locale=#locale,doc,%<lang-tag%>
secondary-date-sort-format=#default,short,medium,long,full,%<pattern%>
secondary-group-formation=#default,codepoint,unicode category,unicode script,unicode category and script
dual-prefix=%<prefix%>
primary-dual-dependency#true,false
combine-dual-locations=#false,both,dual,primary,dual retain principal,primary retain principal
dual-type=#false,same as entry,same as original entry,same as base,same as primary,same as parent,same as category,%<label%>
dual-category=#false,same as entry,same as original entry,same as base,same as primary,same as type,%<label%>
dual-counter=%<value%>
dual-short-case-change=#white space,cs space,dash,nbsp
dual-long-case-change=#white space,cs space,dash,nbsp
dual-field=%<value%>
dual-date-time-field-format=%<value%>
dual-date-field-format=%<value%>
dual-time-field-format=%<value%>
dual-date-time-field-locale=%<value%>
dual-date-field-locale=%<value%>
date-time-field-locale=%<value%>
dual-sort=%<value%>
dual-sort-field=%<value%>
dual-missing-sort-fallback=%<field%>
dual-trim-sort#true,false
dual-sort-replace={%<list%>}
dual-sort-rule=%<value%>
dual-break-at=#word,character,sentence,upper-notlower,upper-upper,upper-notlower-word,upper-upper-word,none
dual-break-marker=%<marker%>
dual-break-at-match={%<keyvals%>}
dual-break-at-match-op=#and,or
dual-break-at-not-match={%<keyvals%>}
dual-sort-number-pad=%<number%>
dual-sort-pad-plus=%<marker%>
dual-sort-pad-minus=%<marker%>
dual-identical-sort-action=#none,def,use,id,original id,%<field%>
dual-sort-suffix=#none,non-unique,%<field%>
dual-sort-suffix-marker=%<marker%>
dual-strength=#primary,secondary,tertiary,identical
dual-decomposition=#canonical,full,none
dual-letter-number-rule=#before letter,after letter,between,first,last
dual-letter-number-punc-rule=#punc-space-first,punc-space-last,space-punc-first,space-punc-last,space-first-punc-last,punc-first-space-last,punc-first-space-zero,punc-last-space-zero,punc-first-space-zero-match-next,punc-last-space-zero-match-next
dual-numeric-sort-pattern=%<value%>
dual-numeric-locale=#locale,doc,%<lang-tag%>
dual-date-sort-locale=#locale,doc,%<lang-tag%>
dual-date-sort-format=#default,short,medium,long,full,%<pattern%>
dual-group-formation=#default,codepoint,unicode category,unicode script,unicode category and script
dual-entry-map={{%<list1%>},{%<list2%>}}
dual-abbrv-map={{%<list1%>},{%<list2%>}}
dual-abbrventry-map={{%<list1%>},{%<list2%>}}
dual-symbol-map={{%<list1%>},{%<list2%>}}
dual-indexentry-map={{%<list1%>},{%<list2%>}}
dual-indexsymbol-map={{%<list1%>},{%<list2%>}}
dual-indexabbrv-map={{%<list1%>},{%<list2%>}}
dual-entry-backlink#true,false
dual-abbrv-backlink#true,false
dual-symbol-backlink#true,false
dual-abbrventry-backlink#true,false
dual-entryabbrv-backlink#true,false
dual-indexentry-backlink#true,false
dual-indexsymbol-backlink#true,false
dual-indexabbrv-backlink#true,false
dual-backlink#true,false
tertiary-prefix=%<prefix%>
tertiary-type=%<value%>
tertiary-category=%<value%>
compound-options-global#true,false
compound-dependent#true,false
compound-add-hierarchy#true,false
compound-has-records#true,false
compound-adjust-name=#false,unique,once
compound-main-type=#same as entry,same as original entry,same as base,same as category,same as parent,%<label%>
compound-other-type=#same as main,same as entry,same as original entry,same as base,same as category,same as parent,%<label%>
compound-type-override#true,false
compound-write-def=#none,all,ref
#endkeyvals

\glsxtrresourcecount#*
\glsxtrresourceinit#*
\glsxtrMFUsave#*
\GlsXtrDefaultResourceOptions#*

## Record Counting ##
\glsxtrdetoklocation{location}#*
\GlsXtrTotalRecordCount{label}#*r
\GlsXtrRecordCount{label}{counter}#*r
\GlsXtrLocationRecordCount{label}{counter}{location}#*r
\glsxtrifrecordtrigger{label}{true}{false}#*r
\glsxtrrecordtriggervalue{label}#*r
\GlsXtrSetRecordCountAttribute{category list}{value}#*
\glstriggerrecordformat{location}#*

\rgls{label}#*r
\rgls[options%keyvals]{label}#*r
\rgls{label}[insert]#*r
\rgls[options%keyvals]{label}[insert]#*r
\rgls*{label}#Sr
\rgls*[options%keyvals]{label}#Sr
\rgls*{label}[insert]#Sr
\rgls*[options%keyvals]{label}[insert]#Sr
\rgls+{label}#Sr
\rgls+[options%keyvals]{label}#Sr
\rgls+{label}[insert]#Sr
\rgls+[options%keyvals]{label}[insert]#Sr
\rGls{label}#*r
\rGls[options%keyvals]{label}#*r
\rGls{label}[insert]#*r
\rGls[options%keyvals]{label}[insert]#*r
\rGls*{label}#Sr
\rGls*[options%keyvals]{label}#Sr
\rGls*{label}[insert]#Sr
\rGls*[options%keyvals]{label}[insert]#Sr
\rGls+{label}#Sr
\rGls+[options%keyvals]{label}#Sr
\rGls+{label}[insert]#Sr
\rGls+[options%keyvals]{label}[insert]#Sr
\rGLS{label}#*r
\rGLS[options%keyvals]{label}#*r
\rGLS{label}[insert]#*r
\rGLS[options%keyvals]{label}[insert]#*r
\rGLS*{label}#Sr
\rGLS*[options%keyvals]{label}#Sr
\rGLS*{label}[insert]#Sr
\rGLS*[options%keyvals]{label}[insert]#Sr
\rGLS+{label}#Sr
\rGLS+[options%keyvals]{label}#Sr
\rGLS+{label}[insert]#Sr
\rGLS+[options%keyvals]{label}[insert]#Sr
\rglspl{label}#*r
\rglspl[options%keyvals]{label}#*r
\rglspl{label}[insert]#*r
\rglspl[options%keyvals]{label}[insert]#*r
\rglspl*{label}#Sr
\rglspl*[options%keyvals]{label}#Sr
\rglspl*{label}[insert]#Sr
\rglspl*[options%keyvals]{label}[insert]#Sr
\rglspl+{label}#Sr
\rglspl+[options%keyvals]{label}#Sr
\rglspl+{label}[insert]#Sr
\rglspl+[options%keyvals]{label}[insert]#Sr
\rGlspl{label}#*r
\rGlspl[options%keyvals]{label}#*r
\rGlspl{label}[insert]#*r
\rGlspl[options%keyvals]{label}[insert]#*r
\rGlspl*{label}#Sr
\rGlspl*[options%keyvals]{label}#Sr
\rGlspl*{label}[insert]#Sr
\rGlspl*[options%keyvals]{label}[insert]#Sr
\rGlspl+{label}#Sr
\rGlspl+[options%keyvals]{label}#Sr
\rGlspl+{label}[insert]#Sr
\rGlspl+[options%keyvals]{label}[insert]#Sr
\rGLSpl{label}#*r
\rGLSpl[options%keyvals]{label}#*r
\rGLSpl{label}[insert]#*r
\rGLSpl[options%keyvals]{label}[insert]#*r
\rGLSpl*{label}#Sr
\rGLSpl*[options%keyvals]{label}#Sr
\rGLSpl*{label}[insert]#Sr
\rGLSpl*[options%keyvals]{label}[insert]#Sr
\rGLSpl+{label}#Sr
\rGLSpl+[options%keyvals]{label}#Sr
\rGLSpl+{label}[insert]#Sr
\rGLSpl+[options%keyvals]{label}[insert]#Sr
\rglsformat{label}{insert}#*r
\rglsplformat{label}{insert}#*r
\rGlsformat{label}{insert}#*r
\rGlsplformat{label}{insert}#*r
\rGLSformat{label}{insert}#*r
\rGLSplformat{label}{insert}#*r
\glsxtrenablerecordcount#*

### 12 Auto-Indexing ###
\glsxtrdoautoindexname{label}{attribute}#*r
\glsxtrautoindexentry{label}#*r
\glsxtrautoindexassignsort{cmd}{label}#*r
\glsxtrautoindexesc#*
\glsxtrautoindex{text}#*
\GlsXtrEnableIndexFormatOverride#*
\GlsXtrSetActualChar{character}#*
\GlsXtrSetLevelChar{character}#*
\GlsXtrSetEscChar{character}#*
\GlsXtrSetEncapChar{character}#*

### 13 On-the-Fly Document Definitions ###
\GlsXtrEnableOnTheFly
\glsxtr{label}#l
\glsxtr[gls-options%keyvals]{label}#l
\glsxtr[gls-options%keyvals][dfn-options]{label}#l
\GlsXtrWarning{defn options}{label}#*
\glsxtrpl{label}#l
\glsxtrpl[gls-options%keyvals]{label}#l
\glsxtrpl[gls-options%keyvals][dfn-options]{label}#l
\Glsxtr{label}#l
\Glsxtr[gls-options%keyvals]{label}#l
\Glsxtr[gls-options%keyvals][dfn-options]{label}#l
\Glsxtrpl{label}#l
\Glsxtrpl[gls-options%keyvals]{label}#l
\Glsxtrpl[gls-options%keyvals][dfn-options]{label}#l
\glsxtrcat#*

### 15 Multi-Lingual Support ###
\ProvidesGlossariesExtraLang{tag}#*
\GlsXtrNoGlsWarningHead{glossary-label}{file}#*
\GlsXtrNoGlsWarningEmptyStart#*
\GlsXtrNoGlsWarningEmptyMain#*
\GlsXtrNoGlsWarningEmptyNotMain{glossary-label}#*
\GlsXtrNoGlsWarningCheckFile{file}#*
\GlsXtrNoGlsWarningMisMatch#*
\GlsXtrNoGlsWarningNoOut{file}#*
\GlsXtrNoGlsWarningTail#*
\GlsXtrNoGlsWarningBuildInfo#*
\GlsXtrNoGlsWarningAutoMake{glossary-label}#*

### other commands ###
\GlossariesAbbrStyleTooComplexWarning{arg1}{arg2}#*
\GlossariesExtraInfo{message%text}#*
\GlossariesExtraWarning{message%text}#*
\GlossariesExtraWarningNoLine{message%text}#*
\glsabspace{label}#*r
\glsacspacemax#*
\glsfmtinsert#*
\GLSfmtinsert#*
\GlsXtrDefineAbbreviationShortcuts#*
\GlsXtrDefineAcShortcuts#*
\GlsXtrDefineOtherShortcuts#*
\glsxtrfirstscfont{text}#*
\glsxtrfirstsmfont{text}#*
\glsxtrifemptyglossary{type}{true}{false}#*
\GlsXtrIfInGlossary{label}{glossary-type}{true}{false}#*r
\glsxtrinitwrglossbeforefalse#*
\glsxtrinitwrglossbeforetrue#*
\GlsXtrInternalLocationHyperlink{counter}{prefix}{location}#*
\glsxtrlocationhyperlink{counter}{prefix}{location}#*
\glsxtrNoGlossaryWarning{type}#*
\glsxtrprovideaccsuppcmd{category}{field}#*
\GlsXtrRecordWarning{type}#*
\glsxtrscfont{text}#*
\glsxtrsmfont{text}#*
\glsxtrstarflywarn#*
\glsxtrsupplocationurl#*
\glsxtruseseeformat{tag}{xr-list}#*
\glsxtrwordsephyphen#*
\ifglsxtrinitwrglossbefore#*
\mglsSetMain{multi-label}{new-main-label}#*
\RequireGlossariesExtraLang{tag}#*
\seealsoname#*

### not in main documentation ###
\glsxtrcontinuedname#S
\glsxtrcounterprefix#S
\glsxtrdohyperlink#S
\glsxtrdoidentify{arg}#S
\glsxtrhyperlink{arg1}{arg2}#S
\glsxtridentifyglsfamily{arg1}{arg2}{arg3}{arg4}{arg5}{arg6}{arg7}{arg8}#S
\glsxtridentifyglslink{arg1}{arg2}#S
\glsxtrmglswrite{arg}#S
\glsxtrprotectlinks#S
\glsxtrshorthyphennoinsert{arg1}{arg2}{arg3}#S
\glsxtrshorthyphennolong{arg1}{arg2}{arg3}#S
\GLSxtrshorthyphennolong{arg1}{arg2}{arg3}#S
\glsxtrundefdebug{arg}#S
\mglsWriteSeparateRefsFalse#S
\mglsWriteSeparateRefsTrue#S

# deprecated
\preglossarypreamble{text}#S
\preglossarypreamble[type]{text}#S
