---
title: Associated projects
author: Helfer Thomas
date: 11/03/2021
lang: en-EN
link-citations: true
colorlinks: true
figPrefixTemplate: "$$i$$"
tblPrefixTemplate: "$$i$$"
secPrefixTemplate: "$$i$$"
eqnPrefixTemplate: "($$i$$)"
---

# Finite element and Fast-Fourier Transform solvers

## The `Cast3M` finite element solver

![](img/VoidsGrowth.png "Simulation of Void growth")

`Cast3M` is a finite element tool box for structural and fluid mechanics
developped by `CEA`: <http://www-cast3m.cea.fr/>. `MFront` is packaged
with `Cast3M` since 2019.

The interface to this solver is described on [this page](castem.html).

## `AMITEX_FFTP`

![](img/AMITEX_FFTP_sig1.png "Polycrystals computation based on FFT")

`AMITEX_FFTP` is a massively parallel mechanical solver based on the
Fast-Fourier Transform developped by `CEA`:
<http://www.maisondelasimulation.fr/projects/amitex/general/_build/html/index.html>

The interface to this solver is described on [this page](amitex.html).

## `code_aster` and `Salome-meca`

![](img/VeRCoRs.png "Simulation of the VeRCoRs mock-up of a nuclear building")

`code_aster` is a massively parallel finite element mechanical solver
developped by `EDF`: <https://www.code-aster.org>. The `Salome-Meca`
platform packages the `code_aster` in a suite of state-of-the-art pre-
and post-processing tools. `MFront` is packaged with `code_aster` since
2015.

The interface to this solver is described on [this page](aster.html).

## `OpenGeoSys`

<center>
<iframe width="560" height="315" src="https://www.youtube.com/embed/juWMIkJ64iE" frameborder="0" allow="accelerometer; autoplay; encrypted-media; gyroscope; picture-in-picture" allowfullscreen>
</iframe>
</center>

`OpenGeoSys` (OGS) is a scientific open source project for the
development of numerical methods for the simulation of
thermo-hydro-mechanical-chemical (THMC) processes in porous and
fractured media: <https://www.opengeosys.org/>

The project handles behaviours generated by `MFront` using the
[`MFrontGenericInterfaceSupportProject`
project](https://github.com/thelfer/MFrontGenericInterfaceSupport) which
is described in Section @sec:mgis.

## `MoFEM`

<http://mofem.eng.gla.ac.uk/mofem/html/>

## `mgis.fenics`

`FEniCS` is is a popular open-source computing platform for solving
partial differential equations (PDEs): https://fenicsproject.org/

The `mgis.fenics` `python` module aims at leveraging the power of the
`FEniCS` platform, used for the discretization of the balance equations,
the assembly of residuals and stiffness matrices and the parallel
distribution of the resolution, combined with `MFront`, used for the
local integration of the constitutive equations, to build complex
mechanical simulations: <https://thelfer.github.io/mgis/web/mgis_fenics.html>

## `mfem-mgis`

`MFEM` is a free, lightweight, scalable `C++` library for finite element
methods.

<https://github.com/thelfer/mfem-mgis>

# Miscellaneous

## The `MFrontGenericInterfaceProject`

<https://github.com/thelfer/MFrontGenericInterfaceSupport>

## `MFrontGallery`

<https://github.com/thelfer/MFrontGenericInterfaceSupport>

## `Madnex`

<https://github.com/thelfer/madnex>

## `tfel-plot`

<https://github.com/thelfer/tfel-plot>

## `tfel-editor`

<https://github.com/thelfer/tfel-editor>

## Syntax highlighting in `SublimeText`

Thanks to Eduardo Borges, syntax highlighting for `MFront` and `MTest`
is available for the `SublimeText3` text-editor.

You can download it here:

<https://github.com/etpborges/mfront_syntax_highlighting>
