/*!
 * \file   EllipticCreep.hxx
 * \brief  this file implements the EllipticCreep Behaviour.
 *         File generated by tfel version 2.0
 * \author Maxime Salvo / Thomas Helfer
 * \date   9 Octobre 2013
 */

#ifndef LIB_TFELMATERIAL_ELLIPTICCREEP_HXX_
#define LIB_TFELMATERIAL_ELLIPTICCREEP_HXX_

#include <iostream>
#include <algorithm>
#include <string>

#include "TFEL/Config/TFELConfig.hxx"
#include "TFEL/Config/TFELTypes.hxx"
#include "TFEL/TypeTraits/IsFundamentalNumericType.hxx"
#include "TFEL/TypeTraits/IsReal.hxx"
#include "TFEL/Material/MechanicalBehaviour.hxx"
#include "TFEL/Material/MechanicalBehaviourTraits.hxx"
#include "TFEL/Material/OutOfBoundsPolicy.hxx"
#include "TFEL/Material/BoundsCheck.hxx"
#include "TFEL/Material/EllipticCreepBehaviourData.hxx"
#include "TFEL/Material/EllipticCreepIntegrationData.hxx"

#include <limits>
#include <algorithm>

#include "TFEL/Math/st2tost2.hxx"
#include "TFEL/Math/tmatrix.hxx"
#include "TFEL/Math/tvector.hxx"
#include "TFEL/Math/TinyMatrixSolve.hxx"

#include "TFEL/Math/Stensor/StensorFromTinyVectorView.hxx"
#include "TFEL/Math/ST2toST2/ST2toST2FromTinyMatrixView.hxx"

#include "TFEL/Math/ST2toST2/ST2toST2FromTinyMatrixView2.hxx"

#include "TFEL/Math/Stensor/StensorFromTinyMatrixColumnView.hxx"
#include "TFEL/Math/Stensor/StensorFromTinyMatrixRowView.hxx"
#include "TFEL/Math/Stensor/StensorFromTinyMatrixColumnView2.hxx"
#include "TFEL/Math/Stensor/StensorFromTinyMatrixRowView2.hxx"
#include "TFEL/Math/Vector/TinyVectorOfStensorFromTinyVectorView.hxx"
#line 7 "EllipticCreep-1.mfront"
#include "TFEL/Material/Lame.hxx"
#include "UO2_YoungModulus_Fink1981-mfront.hxx"

#include "UO2_PoissonRatio_Fink1981-mfront.hxx"

#include "UO2_ThermalExpansion-mfront.hxx"

namespace tfel {

  namespace material {

    struct EllipticCreepParametersInitializer {
      static EllipticCreepParametersInitializer& get();

      double A;
      double E;
      double CAf;
      double referenceTemperatureForThermalExpansion;
      double epsilon;
      double theta;
      double numerical_jacobian_epsilon;
      unsigned short iterMax;

      void set(const char* const, const double);

      void set(const char* const, const unsigned short);

     private:
      EllipticCreepParametersInitializer();

      EllipticCreepParametersInitializer(
          const EllipticCreepParametersInitializer&);

      EllipticCreepParametersInitializer& operator=(
          const EllipticCreepParametersInitializer&);
    };

    // Forward Declaration
    template <ModellingHypothesis::Hypothesis, typename Type, bool use_qt>
    class EllipticCreep;

    // Forward Declaration
    template <ModellingHypothesis::Hypothesis hypothesis, typename Type>
    std::ostream& operator<<(std::ostream&,
                             const EllipticCreep<hypothesis, Type, false>&);

    /*!
     * \class EllipticCreep
     * \brief This class implements the EllipticCreep behaviour.
     * \param hypothesis, modelling hypothesis.
     * \param Type, numerical type.
     * \author Maxime Salvo / Thomas Helfer
     * \date   9 Octobre 2013
     */
    template <ModellingHypothesis::Hypothesis hypothesis, typename Type>
    class EllipticCreep<hypothesis, Type, false>
        : public MechanicalBehaviour<hypothesis, Type, false>,
          public EllipticCreepBehaviourData<hypothesis, Type, false>,
          public EllipticCreepIntegrationData<hypothesis, Type, false> {
      static constexpr unsigned short N =
          ModellingHypothesisToSpaceDimension<hypothesis>::value;

      static_assert(N == 1 || N == 2 || N == 3);
      static_assert(tfel::typetraits::IsFundamentalNumericType<Type>::cond);
      static_assert(tfel::typetraits::IsReal<Type>::cond);

      friend std::ostream& operator<<<>(std::ostream&, const EllipticCreep&);

      static constexpr unsigned short TVectorSize = N;
      typedef tfel::math::StensorDimeToSize<N> StensorDimeToSize;
      static constexpr unsigned short StensorSize = StensorDimeToSize::value;
      typedef tfel::math::TensorDimeToSize<N> TensorDimeToSize;
      static constexpr unsigned short TensorSize = TensorDimeToSize::value;

      typedef unsigned short ushort;
      typedef tfel::config::Types<N, Type, false> Types;
      typedef typename Types::real real;
      typedef typename Types::time time;
      typedef typename Types::length length;
      typedef typename Types::frequency frequency;
      typedef typename Types::stress stress;
      typedef typename Types::strain strain;
      typedef typename Types::strainrate strainrate;
      typedef typename Types::stressrate stressrate;
      typedef typename Types::temperature temperature;
      typedef typename Types::thermalexpansion thermalexpansion;
      typedef typename Types::massdensity massdensity;
      typedef typename Types::TVector TVector;
      typedef typename Types::Stensor Stensor;
      typedef typename Types::Stensor4 Stensor4;
      typedef typename Types::FrequencyStensor FrequencyStensor;
      typedef typename Types::ForceTVector ForceTVector;
      typedef typename Types::StressStensor StressStensor;
      typedef typename Types::StrainRateStensor StressRateStensor;
      typedef typename Types::DisplacementTVector DisplacementTVector;
      typedef typename Types::StrainStensor StrainStensor;
      typedef typename Types::StrainRateStensor StrainRateStensor;
      typedef typename Types::StiffnessTensor StiffnessTensor;
      typedef typename Types::Tensor Tensor;
      typedef typename Types::ThermalExpansionCoefficientTensor
          ThermalExpansionCoefficientTensor;
      typedef
          typename Types::DeformationGradientTensor DeformationGradientTensor;
      typedef typename Types::FiniteStrainStiffnessTensor
          FiniteStrainStiffnessTensor;
      typedef StiffnessTensor StiffnessOperator;

     public:
      typedef EllipticCreepBehaviourData<hypothesis, Type, false> BehaviourData;
      typedef EllipticCreepIntegrationData<hypothesis, Type, false>
          IntegrationData;
      typedef
          typename MechanicalBehaviour<hypothesis, Type, false>::SMType SMType;

      using MechanicalBehaviour<hypothesis, Type, false>::ELASTIC;
      using MechanicalBehaviour<hypothesis, Type, false>::SECANTOPERATOR;
      using MechanicalBehaviour<hypothesis, Type, false>::TANGENTOPERATOR;
      using MechanicalBehaviour<hypothesis, Type, false>::
          CONSISTENTTANGENTOPERATOR;
      using MechanicalBehaviour<hypothesis, Type, false>::NOSTIFFNESSREQUESTED;
      typedef typename MechanicalBehaviour<hypothesis, Type, false>::
          IntegrationResult IntegrationResult;
      using MechanicalBehaviour<hypothesis, Type, false>::SUCCESS;
      using MechanicalBehaviour<hypothesis, Type, false>::FAILURE;
      using MechanicalBehaviour<hypothesis, Type, false>::UNRELIABLE_RESULTS;

      typedef StrainStensor StressFreeExpansionType;

     private:
      typename tfel::math::
          StensorFromTinyVectorView<N, 2 + StensorSize, 0, real>::type deel;
#line 13 "EllipticCreep-1.mfront"
      real& dpv;
#line 16 "EllipticCreep-1.mfront"
      real& dpd;

#line 30 "EllipticCreep-1.mfront"
      real nu;
#line 32 "EllipticCreep-1.mfront"
      stress lambda;
#line 34 "EllipticCreep-1.mfront"
      stress mu;
#line 36 "EllipticCreep-1.mfront"
      real f_t;

#line 22 "EllipticCreep-1.mfront"
      real A;
#line 24 "EllipticCreep-1.mfront"
      real E;
#line 26 "EllipticCreep-1.mfront"
      real CAf;
      real referenceTemperatureForThermalExpansion;
      real epsilon;
      real theta;
      real numerical_jacobian_epsilon;
      ushort iterMax;

      // Jacobian
      tfel::math::tmatrix<2 + StensorSize, 2 + StensorSize, Type> jacobian;
      // zeros
      tfel::math::tvector<2 + StensorSize, Type> zeros;

      // previous zeros
      tfel::math::tvector<2 + StensorSize, Type> zeros_1;

      // function
      tfel::math::tvector<2 + StensorSize, Type> fzeros;

      // number of iterations
      unsigned int iter;

      void computeNumericalJacobian(
          tfel::math::tmatrix<2 + StensorSize, 2 + StensorSize, real>&
              njacobian) {
        using namespace std;
        using namespace tfel::math;
        tvector<2 + StensorSize, real> tzeros(this->zeros);
        tvector<2 + StensorSize, real> tfzeros(this->fzeros);
        tmatrix<2 + StensorSize, 2 + StensorSize, real> tjacobian(
            this->jacobian);
        for (unsigned short idx = 0; idx != 2 + StensorSize; ++idx) {
          this->zeros(idx) -= this->numerical_jacobian_epsilon;
          this->computeStress();
          this->computeFdF();
          this->zeros = tzeros;
          tvector<2 + StensorSize, real> tfzeros2(this->fzeros);
          this->zeros(idx) += this->numerical_jacobian_epsilon;
          this->computeStress();
          this->computeFdF();
          this->fzeros = (this->fzeros - tfzeros2) /
                         (real(2) * (this->numerical_jacobian_epsilon));
          for (unsigned short idx2 = 0; idx2 != 2 + StensorSize; ++idx2) {
            njacobian(idx2, idx) = this->fzeros(idx2);
          }
          this->zeros = tzeros;
          this->fzeros = tfzeros;
        }
        if (&njacobian != &(this->jacobian)) {
          this->jacobian = tjacobian;
        }
      }

      void getPartialJacobianInvert(Stensor4& partial_jacobian_eel) {
        using namespace tfel::math;
        TinyPermutation<2 + StensorSize> permuation;
        this->computeNumericalJacobian(this->jacobian);
        TinyMatrixSolve<2 + StensorSize, real>::decomp(this->jacobian,
                                                       permuation);
        for (unsigned short idx = 0; idx != StensorSize; ++idx) {
          tvector<2 + StensorSize, real> vect_e(real(0));
          vect_e(idx) = real(1);
          TinyMatrixSolve<2 + StensorSize, real>::back_substitute(
              this->jacobian, permuation, vect_e);
          for (unsigned short idx2 = 0; idx2 != StensorSize; ++idx2) {
            partial_jacobian_eel(idx2, idx) = vect_e(idx2);
          }
        }
      }

      void getPartialJacobianInvert(Stensor4& partial_jacobian_eel,
                                    Stensor& partial_jacobian_pv) {
        using namespace tfel::math;
        TinyPermutation<2 + StensorSize> permuation;
        this->computeNumericalJacobian(this->jacobian);
        TinyMatrixSolve<2 + StensorSize, real>::decomp(this->jacobian,
                                                       permuation);
        for (unsigned short idx = 0; idx != StensorSize; ++idx) {
          tvector<2 + StensorSize, real> vect_e(real(0));
          vect_e(idx) = real(1);
          TinyMatrixSolve<2 + StensorSize, real>::back_substitute(
              this->jacobian, permuation, vect_e);
          for (unsigned short idx2 = 0; idx2 != StensorSize; ++idx2) {
            partial_jacobian_eel(idx2, idx) = vect_e(idx2);
          }
          partial_jacobian_pv(idx) = vect_e(StensorSize);
        }
      }

      void getPartialJacobianInvert(Stensor4& partial_jacobian_eel,
                                    Stensor& partial_jacobian_pv,
                                    Stensor& partial_jacobian_pd) {
        using namespace tfel::math;
        TinyPermutation<2 + StensorSize> permuation;
        this->computeNumericalJacobian(this->jacobian);
        TinyMatrixSolve<2 + StensorSize, real>::decomp(this->jacobian,
                                                       permuation);
        for (unsigned short idx = 0; idx != StensorSize; ++idx) {
          tvector<2 + StensorSize, real> vect_e(real(0));
          vect_e(idx) = real(1);
          TinyMatrixSolve<2 + StensorSize, real>::back_substitute(
              this->jacobian, permuation, vect_e);
          for (unsigned short idx2 = 0; idx2 != StensorSize; ++idx2) {
            partial_jacobian_eel(idx2, idx) = vect_e(idx2);
          }
          partial_jacobian_pv(idx) = vect_e(StensorSize);
          partial_jacobian_pd(idx) = vect_e(1 + StensorSize);
        }
      }

      void computeStress(void) {
        using namespace std;
        using namespace tfel::math;
        using mfront::UO2_PoissonRatio_Fink1981;
        using mfront::UO2_PoissonRatio_Fink1981_checkBounds;
        using mfront::UO2_ThermalExpansion;
        using mfront::UO2_ThermalExpansion_checkBounds;
        using mfront::UO2_YoungModulus_Fink1981;
        using mfront::UO2_YoungModulus_Fink1981_checkBounds;
        using std::vector;
#line 51 "EllipticCreep-1.mfront"
        using namespace tfel ::material ::lame;
#line 53 "EllipticCreep-1.mfront"
        this->f = this->f_t + this->theta * (1 - this->f_t) /
                                  (1 + this->theta * this->dpv) * this->dpv;
#line 55 "EllipticCreep-1.mfront"
        const stress young =
            UO2_YoungModulus_Fink1981((this->T + (this->theta) * (this->dT)),
                                      min(max(this->f, real(0)), real(1)));
#line 56 "EllipticCreep-1.mfront"
        this->lambda = computeLambda(young, this->nu);
#line 57 "EllipticCreep-1.mfront"
        this->mu = computeMu(young, this->nu);
#line 59 "EllipticCreep-1.mfront"
        this->sig = this->lambda *
                        trace((this->eel + (this->theta) * (this->deel))) *
                        Stensor ::Id() +
                    2 * this->mu * (this->eel + (this->theta) * (this->deel));
      }  // end of EllipticCreep::computeStress

      void computeFinalStress(void) {
        using namespace std;
        using namespace tfel::math;
        using mfront::UO2_PoissonRatio_Fink1981;
        using mfront::UO2_PoissonRatio_Fink1981_checkBounds;
        using mfront::UO2_ThermalExpansion;
        using mfront::UO2_ThermalExpansion_checkBounds;
        using mfront::UO2_YoungModulus_Fink1981;
        using mfront::UO2_YoungModulus_Fink1981_checkBounds;
        using std::vector;
#line 63 "EllipticCreep-1.mfront"
        using namespace tfel ::material ::lame;
#line 65 "EllipticCreep-1.mfront"
        this->f = this->f_t +
                  (1 - this->f_t) / (1 + this->theta * this->dpv) * this->dpv;
#line 67 "EllipticCreep-1.mfront"
        const stress young = UO2_YoungModulus_Fink1981(
            (this->T + this->dT), min(max(this->f, real(0)), real(1)));
#line 68 "EllipticCreep-1.mfront"
        this->lambda = computeLambda(young, this->nu);
#line 69 "EllipticCreep-1.mfront"
        this->mu = computeMu(young, this->nu);
#line 71 "EllipticCreep-1.mfront"
        this->sig = this->lambda * trace(this->eel) * Stensor ::Id() +
                    2 * this->mu * this->eel;
      }  // end of EllipticCreep::computeStress

      /*!
       * \brief Update internal variables at end of integration
       */
      void updateStateVariables(void) {
        this->eel += this->deel;
        this->pv += this->dpv;
        this->pd += this->dpd;
      }

      /*!
       * \brief Update auxiliary state variables at end of integration
       */
      void updateAuxiliaryStateVariables(void) {}

      /*!
       * \brief Default constructor (disabled)
       */
      EllipticCreep();

      /*!
       * \brief Copy constructor (disabled)
       */
      EllipticCreep(const EllipticCreep&);

      /*!
       * \brief Assignement operator (disabled)
       */
      EllipticCreep& operator=(const EllipticCreep&);

     public:
      /*!
       * \brief Constructor
       */
      EllipticCreep(
          const EllipticCreepBehaviourData<hypothesis, Type, false>& src1,
          const EllipticCreepIntegrationData<hypothesis, Type, false>& src2)
          : EllipticCreepBehaviourData<hypothesis, Type, false>(src1),
            EllipticCreepIntegrationData<hypothesis, Type, false>(src2),
            deel(this->zeros),
            dpv(this->zeros(StensorSize)),
            dpd(this->zeros(1 + StensorSize)),
            zeros(real(0)),
            fzeros(real(0)) {
        using namespace std;
        using namespace tfel::math;
        using mfront::UO2_PoissonRatio_Fink1981;
        using mfront::UO2_PoissonRatio_Fink1981_checkBounds;
        using mfront::UO2_ThermalExpansion;
        using mfront::UO2_ThermalExpansion_checkBounds;
        using mfront::UO2_YoungModulus_Fink1981;
        using mfront::UO2_YoungModulus_Fink1981_checkBounds;
        using std::vector;
        this->A = EllipticCreepParametersInitializer::get().A;
        this->E = EllipticCreepParametersInitializer::get().E;
        this->CAf = EllipticCreepParametersInitializer::get().CAf;
        this->referenceTemperatureForThermalExpansion =
            EllipticCreepParametersInitializer::get()
                .referenceTemperatureForThermalExpansion;
        this->epsilon = EllipticCreepParametersInitializer::get().epsilon;
        this->theta = EllipticCreepParametersInitializer::get().theta;
        this->numerical_jacobian_epsilon =
            EllipticCreepParametersInitializer::get()
                .numerical_jacobian_epsilon;
        this->iterMax = EllipticCreepParametersInitializer::get().iterMax;
      }

      /*
       * \brief constructor for the umat interface
       *
       * \param const Type *const UMATdt_, time increment
       * \param const Type *const UMATT_, temperature
       * \param const Type *const UMATdT_, temperature increment
       * \param const Type *const UMATmat, material properties
       * \param const Type *const UMATint_vars, state variables
       * \param const Type *const UMAText_vars, external state variables
       * \param const Type *const UMATdext_vars, external state variables
       * increments
       */
      EllipticCreep(const Type* const UMATdt_,
                    const Type* const UMATT_,
                    const Type* const UMATdT_,
                    const Type* const UMATmat,
                    const Type* const UMATint_vars,
                    const Type* const UMAText_vars,
                    const Type* const UMATdext_vars)
          : EllipticCreepBehaviourData<hypothesis, Type, false>(
                UMATT_, UMATmat, UMATint_vars, UMAText_vars),
            EllipticCreepIntegrationData<hypothesis, Type, false>(
                UMATdt_, UMATdT_, UMATdext_vars),
            deel(this->zeros),
            dpv(this->zeros(StensorSize)),
            dpd(this->zeros(1 + StensorSize)),
            zeros(real(0)),
            fzeros(real(0)) {
        using namespace std;
        using namespace tfel::math;
        using mfront::UO2_PoissonRatio_Fink1981;
        using mfront::UO2_PoissonRatio_Fink1981_checkBounds;
        using mfront::UO2_ThermalExpansion;
        using mfront::UO2_ThermalExpansion_checkBounds;
        using mfront::UO2_YoungModulus_Fink1981;
        using mfront::UO2_YoungModulus_Fink1981_checkBounds;
        using std::vector;
        this->A = EllipticCreepParametersInitializer::get().A;
        this->E = EllipticCreepParametersInitializer::get().E;
        this->CAf = EllipticCreepParametersInitializer::get().CAf;
        this->referenceTemperatureForThermalExpansion =
            EllipticCreepParametersInitializer::get()
                .referenceTemperatureForThermalExpansion;
        this->epsilon = EllipticCreepParametersInitializer::get().epsilon;
        this->theta = EllipticCreepParametersInitializer::get().theta;
        this->numerical_jacobian_epsilon =
            EllipticCreepParametersInitializer::get()
                .numerical_jacobian_epsilon;
        this->iterMax = EllipticCreepParametersInitializer::get().iterMax;
      }

      void computeStressFreeExpansion(
          std::pair<StressFreeExpansionType, StressFreeExpansionType>& dl_l01) {
        using namespace std;
        using namespace tfel::math;
        using mfront::UO2_PoissonRatio_Fink1981;
        using mfront::UO2_PoissonRatio_Fink1981_checkBounds;
        using mfront::UO2_ThermalExpansion;
        using mfront::UO2_ThermalExpansion_checkBounds;
        using mfront::UO2_YoungModulus_Fink1981;
        using mfront::UO2_YoungModulus_Fink1981_checkBounds;
        using std::vector;
        auto& dl_l0 = dl_l01.first;
        auto& dl_l1 = dl_l01.second;
        dl_l0 = StressFreeExpansionType(
            typename StressFreeExpansionType::value_type(0));
        dl_l1 = StressFreeExpansionType(
            typename StressFreeExpansionType::value_type(0));
        const thermalexpansion alpha_Ti = UO2_ThermalExpansion();
        const thermalexpansion alpha_T_t = UO2_ThermalExpansion();
        const thermalexpansion alpha_T_t_dt = UO2_ThermalExpansion();
        dl_l0[0] =
            1 /
            (1 +
             alpha_Ti * (this->referenceTemperatureForThermalExpansion - 300)) *
            (alpha_T_t * (this->T - 300) -
             alpha_Ti * (this->referenceTemperatureForThermalExpansion - 300));
        dl_l0[1] = dl_l0[0];
        dl_l0[2] = dl_l0[0];
        dl_l1[0] =
            1 /
            (1 +
             alpha_Ti * (this->referenceTemperatureForThermalExpansion - 300)) *
            (alpha_T_t_dt * (this->T + this->dT - 300) -
             alpha_Ti * (this->referenceTemperatureForThermalExpansion - 300));
        dl_l1[1] = dl_l1[0];
        dl_l1[2] = dl_l1[0];
      }

      /*!
       * \ brief initialize the behaviour with user code
       */
      void initialize(void) {
        using namespace std;
        using namespace tfel::math;
        using mfront::UO2_PoissonRatio_Fink1981;
        using mfront::UO2_PoissonRatio_Fink1981_checkBounds;
        using mfront::UO2_ThermalExpansion;
        using mfront::UO2_ThermalExpansion_checkBounds;
        using mfront::UO2_YoungModulus_Fink1981;
        using mfront::UO2_YoungModulus_Fink1981_checkBounds;
        using std::vector;
#line 45 "EllipticCreep-1.mfront"
        this->nu = UO2_PoissonRatio_Fink1981();
#line 47 "EllipticCreep-1.mfront"
        this->f_t = this->f;
      }

      /*!
       * \brief set the policy for "out of bounds" conditions
       */
      void setOutOfBoundsPolicy(const OutOfBoundsPolicy policy_value) {
        this->policy = policy_value;
      }  // end of setOutOfBoundsPolicy

      /*!
       * \brief set the policy for "out of bounds" conditions
       */
      ModellingHypothesis::Hypothesis getModellingHypothesis(void) const {
        return hypothesis;
      }  // end of getModellingHypothesis

      /*!
       * \brief check bounds
       */
      void checkBounds(void) const {}  // end of checkBounds

      IntegrationResult computePredictionOperator(const SMType) {
        using namespace std;
        string msg("EllipticCreep::computePredictionOperator : ");
        msg += "unimplemented feature";
        throw(runtime_error(msg));
        return FAILURE;
      }

      /*!
       * \brief Integrate behaviour law over the time step
       */
      IntegrationResult integrate(const SMType smt) {
        using namespace std;
        using namespace tfel::math;
        real error;
        bool converge = false;
        this->iter = 0;
        while ((converge == false) && (this->iter < EllipticCreep::iterMax)) {
          ++(this->iter);
          this->computeStress();
          const bool computeFdF_ok = this->computeFdF();
          if (!computeFdF_ok) {
            if (this->iter == 1) {
              return MechanicalBehaviour<hypothesis, Type, false>::FAILURE;
            } else {
              const real integrate_one_half = real(1) / real(2);
              this->zeros -= (this->zeros - this->zeros_1) * integrate_one_half;
            }
          } else {
            this->zeros_1 = this->zeros;
            error = norm(this->fzeros);
            converge = ((error) / (real(2 + StensorSize)) < (this->epsilon));
            if (!converge) {
              try {
                this->computeNumericalJacobian(this->jacobian);
                TinyMatrixSolve<2 + StensorSize, real>::exe(this->jacobian,
                                                            this->fzeros);
              } catch (LUException&) {
                return MechanicalBehaviour<hypothesis, Type, false>::FAILURE;
              }
              this->zeros -= this->fzeros;
            }
          }
        }
        if (this->iter == this->iterMax) {
          return MechanicalBehaviour<hypothesis, Type, false>::FAILURE;
        }
        if (smt != NOSTIFFNESSREQUESTED) {
          string msg("EllipticCreep::integrate : ");
          msg += "unimplemented feature";
          throw(runtime_error(msg));
        }
        this->updateStateVariables();
        this->computeFinalStress();
        this->updateAuxiliaryStateVariables();
        return MechanicalBehaviour<hypothesis, Type, false>::SUCCESS;
      }  // end of EllipticCreep::integrate

      /*!
       * \brief compute fzeros and jacobian
       */
      bool computeFdF(void) {
        using namespace std;
        using namespace tfel::math;
        using mfront::UO2_PoissonRatio_Fink1981;
        using mfront::UO2_PoissonRatio_Fink1981_checkBounds;
        using mfront::UO2_ThermalExpansion;
        using mfront::UO2_ThermalExpansion_checkBounds;
        using mfront::UO2_YoungModulus_Fink1981;
        using mfront::UO2_YoungModulus_Fink1981_checkBounds;
        using std::vector;
        typename tfel::math::StensorFromTinyVectorView<
            N, 2 + StensorSize, 0, real>::type feel(this->fzeros);
        real& fpv(this->fzeros(StensorSize));
        real& fpd(this->fzeros(1 + StensorSize));
        // setting f values to zeros
        this->fzeros = this->zeros;
#line 76 "EllipticCreep-1.mfront"
        const stress pr = trace((this->sig)) / real(3);
#line 78 "EllipticCreep-1.mfront"
        const stress seq = sigmaeq((this->sig));
#line 80 "EllipticCreep-1.mfront"
        const real Af = 2.25 * (this->CAf) *
                        pow((this->E) * (pow((this->f), -(this->E)) - 1),
                            -2 * (this->E) / ((this->E) + 1));
#line 81 "EllipticCreep-1.mfront"
        const real Bf = (1 + 2 * (this->f) / real(3)) *
                        pow(1 - (this->f), -2 * (this->E) / ((this->E) + 1));
#line 82 "EllipticCreep-1.mfront"
        const stress s = sqrt(Af * pr * pr + Bf * seq * seq);
#line 83 "EllipticCreep-1.mfront"
        if (s > 1.e-8 * (this->mu)) {
#line 85 "EllipticCreep-1.mfront"
          real inv_seq(0);
#line 86 "EllipticCreep-1.mfront"
          Stensor n(real(0.));
#line 87 "EllipticCreep-1.mfront"
          if (seq > 1.e-8 * (this->mu)) {
#line 88 "EllipticCreep-1.mfront"
            inv_seq = 1 / seq;
#line 89 "EllipticCreep-1.mfront"
            n = 1.5 * deviator((this->sig)) * inv_seq;
#line 90 "EllipticCreep-1.mfront"
          }
#line 91 "EllipticCreep-1.mfront"
          const real ds_dpr = Af * pr / s;
#line 92 "EllipticCreep-1.mfront"
          const real ds_dseq = Bf * seq / s;
#line 93 "EllipticCreep-1.mfront"
          const real dphi_ds = (this->A) * pow(s, (this->E));
#line 94 "EllipticCreep-1.mfront"
          const real dphi_dp = dphi_ds * ds_dpr;
#line 95 "EllipticCreep-1.mfront"
          const real dphi_dseq = dphi_ds * ds_dseq;
#line 97 "EllipticCreep-1.mfront"
          const real K = (this->lambda) + (2 * (this->mu)) / 3;
#line 98 "EllipticCreep-1.mfront"
          fpv -= dphi_dp * (this->dt);
#line 100 "EllipticCreep-1.mfront"
          fpd -= dphi_dseq * (this->dt);
#line 102 "EllipticCreep-1.mfront"
          feel += ((this->dpv) / 3) * Stensor ::Id() + (this->dpd) * n;
#line 103 "EllipticCreep-1.mfront"
        }
#line 104 "EllipticCreep-1.mfront"
        feel -= (this->deto);
        return true;
      }

      const StiffnessOperator& getTangentOperator(void) const {
        return this->Dt;
      }

      real getTimeStepScalingFactor(void) const { return real(1); }

      void updateExternalStateVariables(void) {
        this->eto += this->deto;

        this->T += this->dT;
      }

      /*!
       * \brief Destructor
       */
      ~EllipticCreep() {}

     private:
      //! Tangent operator;
      StiffnessOperator Dt;
      //! policy for treating out of bounds conditions
      OutOfBoundsPolicy policy;
    };  // end of EllipticCreep class

    template <ModellingHypothesis::Hypothesis hypothesis, typename Type>
    std::ostream& operator<<(std::ostream& os,
                             const EllipticCreep<hypothesis, Type, false>& b) {
      using namespace std;
      using namespace tfel::utilities;
      os << Name<EllipticCreep<hypothesis, Type, false>>::getName() << endl;
      os << "eto : " << b.eto << endl;
      os << "deto : " << b.deto << endl;
      os << "sig : " << b.sig << endl;
      os << "dt : " << b.dt << endl;
      os << "T : " << b.T << endl;
      os << "dT : " << b.dT << endl;
      os << "eel : " << b.eel << endl;
      os << "deel : " << b.deel << endl;
      os << "pv : " << b.pv << endl;
      os << "dpv : " << b.dpv << endl;
      os << "pd : " << b.pd << endl;
      os << "dpd : " << b.dpd << endl;
      os << "f : " << b.f << endl;
      os << "nu : " << b.nu << endl;
      os << "lambda : " << b.lambda << endl;
      os << "mu : " << b.mu << endl;
      os << "f_t : " << b.f_t << endl;
      os << "A : " << b.A << endl;
      os << "E : " << b.E << endl;
      os << "CAf : " << b.CAf << endl;
      os << "referenceTemperatureForThermalExpansion : "
         << b.referenceTemperatureForThermalExpansion << endl;
      os << "epsilon : " << b.epsilon << endl;
      os << "theta : " << b.theta << endl;
      os << "numerical_jacobian_epsilon : " << b.numerical_jacobian_epsilon
         << endl;
      os << "iterMax : " << b.iterMax << endl;
      return os;
    }

    /*!
     * Partial specialisation for EllipticCreep.
     */
    template <ModellingHypothesis::Hypothesis hypothesis, typename Type>
    class MechanicalBehaviourTraits<EllipticCreep<hypothesis, Type, false>> {
      static constexpr unsigned short N =
          ModellingHypothesisToSpaceDimension<hypothesis>::value;
      static constexpr unsigned short TVectorSize = N;
      typedef tfel::math::StensorDimeToSize<N> StensorDimeToSize;
      static constexpr unsigned short StensorSize = StensorDimeToSize::value;
      typedef tfel::math::TensorDimeToSize<N> TensorDimeToSize;
      static constexpr unsigned short TensorSize = TensorDimeToSize::value;

     public:
      static constexpr bool is_defined = true;
      static constexpr bool use_quantities = false;
      static constexpr bool hasStressFreeExpansion = true;
      static constexpr bool handlesThermalExpansion = true;
      static constexpr unsigned short dimension = N;
      typedef Type NumType;
      static constexpr unsigned short material_properties_nb = 0;
      static constexpr unsigned short internal_variables_nb = 3 + StensorSize;
      static constexpr unsigned short external_variables_nb = 0;
      static constexpr bool hasConsistantTangentOperator = false;
      static constexpr bool isConsistantTangentOperatorSymmetric = false;
      static constexpr bool hasPredictionOperator = false;
      static constexpr bool hasTimeStepScalingFactor = false;
    };

    /*!
     * Partial specialisation for EllipticCreep.
     */
    template <typename Type>
    class MechanicalBehaviourTraits<
        EllipticCreep<ModellingHypothesis::AXISYMMETRICALGENERALISEDPLANESTRESS,
                      Type,
                      false>> {
     public:
      static constexpr bool is_defined = false;
      static constexpr bool use_quantities = false;
      static constexpr bool hasStressFreeExpansion = true;
      static constexpr bool handlesThermalExpansion = true;
      static constexpr unsigned short dimension = 0u;
      typedef Type NumType;
      static constexpr unsigned short material_properties_nb = 0;
      static constexpr unsigned short internal_variables_nb = 0;
      static constexpr unsigned short external_variables_nb = 0;
      static constexpr bool hasConsistantTangentOperator = false;
      static constexpr bool isConsistantTangentOperatorSymmetric = false;
      static constexpr bool hasPredictionOperator = false;
      static constexpr bool hasTimeStepScalingFactor = false;
    };

    /*!
     * Partial specialisation for EllipticCreep.
     */
    template <typename Type>
    class MechanicalBehaviourTraits<
        EllipticCreep<ModellingHypothesis::PLANESTRESS, Type, false>> {
     public:
      static constexpr bool is_defined = false;
      static constexpr bool use_quantities = false;
      static constexpr bool hasStressFreeExpansion = true;
      static constexpr bool handlesThermalExpansion = true;
      static constexpr unsigned short dimension = 0u;
      typedef Type NumType;
      static constexpr unsigned short material_properties_nb = 0;
      static constexpr unsigned short internal_variables_nb = 0;
      static constexpr unsigned short external_variables_nb = 0;
      static constexpr bool hasConsistantTangentOperator = false;
      static constexpr bool isConsistantTangentOperatorSymmetric = false;
      static constexpr bool hasPredictionOperator = false;
      static constexpr bool hasTimeStepScalingFactor = false;
    };

  }  // end of namespace material

}  // end of namespace tfel

namespace tfel {
  namespace utilities {
    //! Partial specialisation of the Name class
    template <tfel::material::ModellingHypothesis::Hypothesis hypothesis,
              typename Type>
    struct Name<tfel::material::EllipticCreep<hypothesis, Type, false>> {
      /*!
       * \brief  Return the name of the class.
       * \return the name of the class.
       * \see    Name.
       */
      static std::string getName(void) { return std::string("EllipticCreep"); }
    };  // end of struct Name
  }     // end of namespace utilities
}  // end of namespace tfel

#endif /* LIB_TFELMATERIAL_ELLIPTICCREEP_HXX_ */
