/*!
 * \file   BurletCailletaudKinematicHardeningRule.hxx
 * \brief
 * \author Thomas Helfer
 * \date   04/04/2018
 * \copyright Copyright (C) 2006-2025 CEA/DEN, EDF R&D. All rights
 * reserved.
 * This project is publicly released under either the GNU GPL Licence with
 * linking exception or the CECILL-A licence. A copy of thoses licences are
 * delivered with the sources of TFEL. CEA or EDF may also distribute this
 * project under specific licensing conditions.
 */

#ifndef LIB_MFRONT_BEHAVIOURBRICK_BURLETCAILLETAUDKINEMATICHARDENINGRULE_HXX
#define LIB_MFRONT_BEHAVIOURBRICK_BURLETCAILLETAUDKINEMATICHARDENINGRULE_HXX

#include "MFront/BehaviourBrick/KinematicHardeningRuleBase.hxx"

namespace mfront::bbrick {

  /*!
   * \brief This class describes the Burlet-Cailletaud kinematic hardening
   * rule defined by the following evolution of the back-strain variable
   * \f$\underline{a}\f$:
   * \f[
   * \underline{\dot{a}}=\underline{\dot{\varepsilon}}^{p}-\eta\,\,D\underline{a}-(1-\eta)\,D\,\left(\underline{a}\,\colon\,\underline{n}\right)\,\underline{n}
   * \f]
   */
  struct BurletCailletaudKinematicHardeningRule : KinematicHardeningRuleBase {
    std::vector<OptionDescription> getOptions() const override;
    void initialize(BehaviourDescription&,
                    AbstractBehaviourDSL&,
                    const std::string&,
                    const std::string&,
                    const DataMap&) override;
    void endTreatment(BehaviourDescription&,
                      const AbstractBehaviourDSL&,
                      const std::string&,
                      const std::string&) const override;
    std::string buildBackStrainImplicitEquations(
        const BehaviourDescription&,
        const StressPotential&,
        const StressCriterion&,
        const std::vector<std::shared_ptr<KinematicHardeningRule>>&,
        const std::string&,
        const std::string&,
        const bool) const override;
    //! destructor
    ~BurletCailletaudKinematicHardeningRule() override;

   protected:
    //! \brief call-back
    BehaviourDescription::MaterialProperty D;
    //! \brief parameter call-back
    BehaviourDescription::MaterialProperty eta;

  };  // end of struct KinematicHardeningRule

}  // end of namespace mfront::bbrick

#endif /* LIB_MFRONT_BEHAVIOURBRICK_BURLETCAILLETAUDKINEMATICHARDENINGRULE_HXX \
        */
