---
title: Release notes of the 3.0.15 version of `TFEL`, `MFront` and `MTest`
author: Thomas Helfer
date: 6/12/2023
lang: en-EN
numbersections: true
documentclass: article
from: markdown+tex_math_single_backslash
geometry:
  - margin=2cm
papersize: a4
link-citations: true
colorlinks: true
figPrefixTemplate: "$$i$$"
tblPrefixTemplate: "$$i$$"
secPrefixTemplate: "$$i$$"
eqnPrefixTemplate: "($$i$$)"
---

The page describes the new functionalities of Version 3.0.15 of the
`TFEL` project.

This version was released on Mai 12, 2025.

# Issues fixed

## Issue 782: [tfel-system] `recursiveFind`: directory depths are not handled correctly. The flag selecting the treatment of errors is not passed correctly

For more details, see <https://github.com/thelfer/tfel/issues/782>.

## Issue 769: Fix potential conflict between `@ComputeStressFressExpansion` and `@ComputeThermalExpansion`

For more details, see <https://github.com/thelfer/tfel/issues/769>.

## Issue 757: cmake policy CMP0167 is only supported after 3..30.0

For more details, see <https://github.com/thelfer/tfel/issues/757>.

## Issue 755: Add support for the `nvc++` compiler

For more details, see <https://github.com/thelfer/tfel/issues/755>.

## Issue 740: Support building with CMake 4.0.0

For more details, see <https://github.com/thelfer/tfel/issues/740>.

## Issue 746: [mfront] [mtest] Add support for substitutions in strings

For more details, see <https://github.com/thelfer/tfel/issues/746>.

## Issue 742: Abaqus interface issue with Abaqus 2024
￼

For more details, see <https://github.com/thelfer/tfel/issues/742>.

## Issue 728: [tfel-utilities] find replace_all when passing an empty `string_view`

For more details, see <https://github.com/thelfer/tfel/issues/728>.

## Issue 699: [mfront] Auxiliary state variables computed by external point wise models are not taken into account correctly in `@FlowRule` in isotropic DSLs

For more details, see <https://github.com/thelfer/tfel/issues/699>.

## Issue 691: `[python-bindings]` Fix the definition of `TFEL_PYTHON_LIBS` in Versions 3.0.x and 3.1.x

For more details, see <https://github.com/thelfer/tfel/issues/691>.

## Issue 688: [implicit-dsl] Explicit use of auxiliary state variables computed by externally point-wise models in `@ComputeStress` and `@ComputeFinalStress` is wrong

For more details, see <https://github.com/thelfer/tfel/issues/688>.

## Issue 687: [mfront] Treatment of the point wise models in the DSL `RungeKutta` is broken

For more details, see <https://github.com/thelfer/tfel/issues/687>.

## Issue 203: Add support to `pandoc-xnos`
￼

￼
For more details, see <https://github.com/thelfer/tfel/issues/203>.